/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.autoupdate.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FeeTypeEnum;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionSubsidiaryLedger;
import com.kingdee.eas.fi.gl.ReportConditionSubsidiaryLedgerAssist;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadItemInfo;
import com.kingdee.eas.fi.gl.app.AbstractGLReportSubsidiaryLedgerControllerBean;
import com.kingdee.eas.fi.gl.app.GLRptHelper;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLReportSubsidiaryLedgerControllerBean
extends AbstractGLReportSubsidiaryLedgerControllerBean {
    private static final long serialVersionUID = -374532530308766616L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLReportSubsidiaryLedgerControllerBean");
    private static final String HAS_KSQL_SEQ = "USE_KSQL_SEQ";
    private static final String COUNT = "COUNT";
    private boolean isShowQuantity = false;
    private boolean isTransAccountDefaultMu = true;
    private boolean isAccountQty = false;
    private BigDecimal accountingCoefficient = null;
    private MeasureUnitInfo accountingMeasureUnitInfo = null;
    private boolean isShowUnit = true;
    int k = -1;
    boolean isSameCreditUnitGroup = true;
    boolean isSameDebitUnitGroup = true;
    StringBuffer strSelfOrder = new StringBuffer();
    Map initParam = new HashMap();
    private Map<String, Integer> actTypeMap;

    protected boolean getPar(ReportPartner partner) throws EASBizException, BOSException {
        return partner.isParamAsstIsUnit();
    }

    private boolean getIsShowQuantity(ReportPartner partner) throws EASBizException, BOSException {
        if (this.initParam.get("PARAM_ISSHOWQUANTITY") != null) {
            return (Boolean)this.initParam.get("PARAM_ISSHOWQUANTITY");
        }
        boolean isQtyAsst = partner.getParmQtyAsst();
        if (partner.getAccountViewInfo().isIsQty() && !isQtyAsst) {
            this.isShowQuantity = true;
        } else if (partner.getAccountViewInfo().isIsQty() && isQtyAsst) {
            if (partner.getAccountViewInfo().getCAA() != null) {
                IAsstAccount iasstAccount = AsstAccountFactory.getLocalInstance((Context)partner.getContext());
                AsstAccountInfo actaccount = iasstAccount.getAsstAccountInfo((IObjectPK)new ObjectUuidPK(partner.getAccountViewInfo().getCAA().getId().toString()));
                if (actaccount.isIsQty()) {
                    this.isShowQuantity = true;
                }
            } else {
                this.isShowQuantity = true;
            }
        }
        this.initParam.put("PARAM_ISSHOWQUANTITY", new Boolean(this.isShowQuantity));
        return this.isShowQuantity;
    }

    @Override
    protected String getSqlForDataFromAndWhere(ReportPartner partner) throws BOSException, EASBizException {
        return this.getSqlForDataFrom(partner);
    }

    protected boolean isShowLocalCurrencyColumns(ReportPartner partner) throws BOSException, EASBizException {
        return !partner.isParmForeignCurrencySu() && partner.getCurrencyType() == 0 && !partner.isBaseCurrency();
    }

    protected boolean isShowReportingCurrencyColumns(ReportPartner partner) throws BOSException, EASBizException {
        return !partner.isParmForeignCurrencySu() && partner.isParmUseReportCurrency() && partner.getCurrencyType() == 0 && !partner.isReportingCurrency();
    }

    @Override
    protected String getSqlForDataSelect(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        boolean showLocalCurrencyColumns = this.isShowLocalCurrencyColumns(partner);
        boolean showReportingCurrencyColumns = this.isShowReportingCurrencyColumns(partner);
        boolean optionShowBusinessDate = condition.getOptionShowBusinessDate();
        boolean optionOtherAccount = condition.getOptionOtherAccount();
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("FNumber, FName, ");
        sqlSelect.append("FDate,");
        if (optionShowBusinessDate) {
            sqlSelect.append("FBizDate,");
        }
        sqlSelect.append("FVoucherNumber,FVoucherTypeNumber ,FVoucherTypeName ,FCREATETIME ,FSeq,FDescription,\r\n");
        if (optionOtherAccount) {
            sqlSelect.append("accountName,\r\n");
            sqlSelect.append("accountLongNumber,\r\n");
            sqlSelect.append("currencyID,\r\n");
            sqlSelect.append("FAccounttableid,\r\n");
            sqlSelect.append("FSOURCETYPE,\r\n");
        }
        if (optionOtherAccount || showLocalCurrencyColumns) {
            sqlSelect.append("FLocalRate,\r\n");
        }
        if (showReportingCurrencyColumns) {
            sqlSelect.append("FRptRate,\r\n");
        }
        if (this.isShowQuantity) {
            sqlSelect.append(" FDebitUnitId,FDebitQty,FDebitQtyDefault,FDebitPrice,\r\n");
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.getPar(partner)) {
                sqlSelect.append(" FDebitAssistUnit,\r\n");
                if (ReportConditionSubsidiaryLedger.class.equals(partner.getFixCondition().getClass())) {
                    sqlSelect.append(" (case when FLineType=3 or FLineType=4 then null else FDebitAssistPrice end) FDebitAssistPrice,\r\n");
                } else {
                    sqlSelect.append("FDebitAssistPrice,\r\n");
                }
                sqlSelect.append(" FDebitAssistQty,\r\n");
            }
        }
        sqlSelect.append("\tFDebitFor,");
        if (optionOtherAccount || showLocalCurrencyColumns) {
            sqlSelect.append("FDebitLocal,");
        }
        if (showReportingCurrencyColumns) {
            sqlSelect.append("FDebitRpt,");
        }
        if (this.isShowQuantity) {
            sqlSelect.append("\tFCreditUnitId,FCreditQty,FCreditQtyDefault,FCreditPrice,\r\n");
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.getPar(partner)) {
                sqlSelect.append(" FCreditAssistUnit,\r\n");
                if (ReportConditionSubsidiaryLedger.class.equals(partner.getFixCondition().getClass())) {
                    sqlSelect.append(" (case when FLineType=3 or FLineType=4 then null else FCreditAssistPrice end) FCreditAssistPrice,\r\n");
                } else {
                    sqlSelect.append("FCreditAssistPrice,\r\n");
                }
                sqlSelect.append(" FCreditAssistQty,\r\n");
            }
        }
        sqlSelect.append("\tFCreditFor,");
        if (optionOtherAccount || showLocalCurrencyColumns) {
            sqlSelect.append("FCreditLocal,");
        }
        if (showReportingCurrencyColumns) {
            sqlSelect.append("FCreditRpt,");
        }
        sqlSelect.append("FBalanceUnitId,");
        sqlSelect.append("\tFLineType,FVoucherID, \r\n");
        if (condition.getOptionShowAccountCusAttribute()) {
            sqlSelect.append(" \tFSettlementType,FSettlementCode, \r\n");
            sqlSelect.append("\tFBizNumber,\r\n");
            sqlSelect.append("\tFTicketNumber,FInvoiceNumber,\r\n");
            sqlSelect.append("\tFFeeType,FHandler,\r\n");
        }
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
            sqlSelect.append(" FCurrencyName ,\r\n");
            sqlSelect.append(" fcurrencynumber ,\r\n");
            sqlSelect.append(" fcurrencyid ,\r\n");
        }
        sqlSelect.append("\tFPeriodYear,FPeriodNumber ");
        if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
            sqlSelect.append("    ,FAccountOrAssist,");
            sqlSelect.append("     FAsstAccountPerId,");
            sqlSelect.append("     FNumberGroupAsst,");
            sqlSelect.append("     FdisplaynameGroup,");
            sqlSelect.append("     FNumberGroup,");
            sqlSelect.append("    FAsstAccountName,");
            sqlSelect.append("    FdivisionBalance");
        }
        return sqlSelect.toString();
    }

    @Override
    protected String getSqlForDataFrom(ReportPartner partner) throws BOSException {
        StringBuffer sqlFrom = new StringBuffer();
        sqlFrom.append("FROM ");
        sqlFrom.append(partner.getTempTableName());
        sqlFrom.append(" T \r\n");
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
            sqlFrom.append(" inner join t_bd_currency cc on cc.fid = T.fcurrencyid ");
        }
        try {
            sqlFrom.append(this.getSqlForDataWhere(partner));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return sqlFrom.toString();
    }

    @Override
    protected String getSqlForDataWhere(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sqlWhere = new StringBuffer();
        ReportConditionSubsidiaryLedger reportcondition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        if (reportcondition.getOptionOnlyAsst() || reportcondition.getAssisthgId() != null) {
            sqlWhere.append("where  FdivisionBalance  is null or FdivisionBalance <> 2 ");
        } else {
            sqlWhere.append("");
        }
        return sqlWhere.toString();
    }

    @Override
    protected String getSqlForDataOrder(ReportPartner partner) throws BOSException, EASBizException {
        boolean isTimeOrder;
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        StringBuffer order = new StringBuffer("ORDER BY ");
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency() && !((ReportConditionSubsidiaryLedger)partner.getFixCondition()).getOptionOtherAccount()) {
            order.append(" cc.fnumber,");
        }
        order = order.append("FPeriodYear,FPeriodNumber, ");
        HashMap<String, String> hmParamIn = new HashMap<String, String>();
        hmParamIn.put("GL_113", partner.getCompanyId());
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)partner.getContext());
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        boolean bl = isTimeOrder = Integer.valueOf(hmAllParam.get("GL_113") == null ? "1" : hmAllParam.get("GL_113").toString()) == 0;
        if (this.strSelfOrder.length() > 0) {
            String selfOrder = this.strSelfOrder.toString().toLowerCase();
            while (selfOrder.indexOf("  ") != -1) {
                selfOrder = selfOrder.replaceAll("  ", " ");
            }
            if ((selfOrder = selfOrder + ",").indexOf("fdate") == -1) {
                if (condition.getOptionDailyTotal()) {
                    order.append("FDate,");
                }
                order.append("FLineType,").append(selfOrder);
                order.append(selfOrder.indexOf("fvouchertypenumber") == -1 ? "FVoucherTypeNumber," : "");
                order.append(selfOrder.indexOf("fvouchernumber") == -1 ? "FVoucherNumber," : "");
                order.append("t.fcreatetime,");
            } else {
                if (condition.getOptionDailyTotal()) {
                    order.append("FDate,");
                    selfOrder = selfOrder.replaceAll("fdate asc,", "");
                    selfOrder = selfOrder.replaceAll("fdate desc,", "");
                }
                order.append("FLineType,").append(selfOrder);
                order.append(selfOrder.indexOf("fvouchertypenumber") == -1 ? "FVoucherTypeNumber," : "");
                order.append(selfOrder.indexOf("fvouchernumber") == -1 ? "FVoucherNumber," : "");
                order.append("t.fcreatetime,");
            }
        } else if (isTimeOrder) {
            order.append("case when fdate is null then {ts'1970-01-01 00:00:00'} else FDate end,FLineType,t.fcreatetime,FVoucherTypeNumber,FVoucherNumber,");
        } else {
            order.append("case when fdate is null then {ts'1970-01-01 00:00:00'} else FDate end,FLineType,FVoucherNumber,FVoucherTypeNumber,t.fcreatetime,");
        }
        if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
            order.append(" FAccountOrAssist, ");
        }
        order.append(" FSeq ");
        if (condition.getOptionOtherAccount()) {
            order.append(", FVoucherID ");
        }
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency() && ((ReportConditionSubsidiaryLedger)partner.getFixCondition()).getOptionOtherAccount()) {
            order.append(", cc.fnumber");
        }
        return order.toString();
    }

    @Override
    protected void doSomethingBeforeQuery(ReportPartner partner) throws BOSException, EASBizException {
        super.doSomethingBeforeQuery(partner);
        boolean isShowAccountCusAttribute = ((ReportConditionSubsidiaryLedger)partner.getFixCondition()).getOptionShowAccountCusAttribute();
        HashMap<String, String> table = new HashMap<String, String>();
        table.put("VOUCHER", "TV");
        table.put("ENTRIES", "TVE");
        table.put("VOUCHERTYPE", "TVT");
        table.put("PERIOD", "TP");
        table.put("ACCOUNTVIEW", "AV");
        HashMap tableValue = RptServerUtil.getRptSelfCongdition(partner.getContext(), partner.getCondition(), table, true, isShowAccountCusAttribute);
        if (tableValue != null && tableValue.get("orderCondition") != null) {
            this.strSelfOrder = new StringBuffer(tableValue.get("orderCondition").toString());
        }
    }

    @Override
    protected void doSomethingAfterInsertData(ReportPartner partner) throws BOSException, EASBizException {
        if (partner.isNewQuery()) {
            this.addTableHeadInfo(partner);
        }
    }

    @Override
    protected ReportTableHeadInfo getDefalutTableHeadInfo(ReportPartner partner) throws EASBizException {
        ReportTableHeadInfo head = new ReportTableHeadInfo();
        String[] columnNames = new String[]{"FDate", "FVoucherNumber", "FDescription", "FDebit", "FCredit", "FDC", "FBalance", "FBizNumber", "FFeeType", "FHandler", "FInvoiceNumber", "FSettlementCode", "FSettlementType", "FTicketNumber"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"Date_jz", "VoucherNumber", "Description", "Debit", "Credit", "Balance", "Balance", "AccountCusAttribute", "AccountCusAttribute", "AccountCusAttribute", "AccountCusAttribute", "AccountCusAttribute", "AccountCusAttribute", "AccountCusAttribute"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{80, 80, 140, 70, 70, 40, 110, 110, 100, 100, 100, 100, 100, 100};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        return head;
    }

    protected void addTableHeadInfo(ReportPartner partner) throws EASBizException, BOSException {
        int j;
        String[] titles;
        ReportTableHeadItemInfo item;
        String[] titles2;
        boolean isQtyAsst = partner.getParmQtyAsst();
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        this.isShowQuantity = this.getIsShowQuantity(partner);
        ArrayList<ReportTableHeadItemInfo> itemList = new ArrayList<ReportTableHeadItemInfo>();
        ReportTableHeadItemInfo item2 = new ReportTableHeadItemInfo();
        item2.setColumnName("FDate");
        item2.setWidth(80);
        item2.setAlignment(0);
        item2.setFreeze(false);
        item2.setMerge(false);
        item2.setVisible(true);
        item2.setTitles(new String[]{"Date_jz"});
        itemList.add(item2);
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).getOptionShowBusinessDate()) {
            item2 = new ReportTableHeadItemInfo();
            item2.setColumnName("FBizDate");
            item2.setWidth(80);
            item2.setAlignment(0);
            item2.setFreeze(false);
            item2.setMerge(false);
            item2.setVisible(true);
            item2.setTitles(new String[]{"BizDate"});
            itemList.add(item2);
        }
        item2 = new ReportTableHeadItemInfo();
        item2.setColumnName("FVoucherNumber");
        item2.setWidth(80);
        item2.setAlignment(0);
        item2.setFreeze(false);
        item2.setMerge(false);
        item2.setVisible(true);
        item2.setTitles(new String[]{"VoucherNumber"});
        itemList.add(item2);
        item2 = new ReportTableHeadItemInfo();
        item2.setColumnName("FDescription");
        item2.setWidth(140);
        item2.setAlignment(0);
        item2.setFreeze(false);
        item2.setMerge(false);
        item2.setVisible(true);
        item2.setTitles(new String[]{"Description"});
        itemList.add(item2);
        if (condition.getOptionOtherAccount()) {
            item2 = new ReportTableHeadItemInfo();
            item2.setColumnName("accountName");
            item2.setWidth(200);
            item2.setAlignment(0);
            item2.setFreeze(false);
            item2.setMerge(false);
            item2.setVisible(true);
            item2.setTitles(new String[]{"otherAccount"});
            itemList.add(item2);
        }
        if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
            RptRowSet rs;
            this.isShowUnit = true;
            StringBuffer sqlForAsstCount = new StringBuffer();
            sqlForAsstCount.append("SELECT MAX(FCount) FROM  ").append(partner.getTempTableName());
            try {
                rs = DBUtilx.executeQuery((String)sqlForAsstCount.toString(), null, (Context)partner.getContext());
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            int k = 1;
            if (rs.next()) {
                k = !rs.isNull(0) ? rs.getInt(0) : 0;
            }
            for (int h = 0; h < k; ++h) {
                ReportTableHeadItemInfo item3 = new ReportTableHeadItemInfo();
                item3.setColumnName("FAsstAccountName" + h);
                item3.setWidth(180);
                item3.setAlignment(0);
                item3.setFreeze(false);
                item3.setMerge(false);
                item3.setVisible(true);
                item3.setTitles(new String[]{"AssistActName"});
                itemList.add(item3);
            }
        }
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
            item2 = new ReportTableHeadItemInfo();
            item2.setColumnName("FCurrencyName");
            item2.setWidth(80);
            item2.setAlignment(0);
            item2.setFreeze(false);
            item2.setMerge(false);
            item2.setVisible(true);
            item2.setTitles(new String[]{"CurrencyType"});
            itemList.add(item2);
        }
        if (this.isShowLocalCurrencyColumns(partner)) {
            item2 = new ReportTableHeadItemInfo();
            item2.setColumnName("FBaseRate");
            item2.setWidth(70);
            item2.setAlignment(2);
            item2.setFreeze(false);
            item2.setMerge(false);
            item2.setVisible(true);
            titles2 = new String[]{this.isShowReportingCurrencyColumns(partner) ? "BaseRate" : "Rate"};
            item2.setTitles(titles2);
            item2.setNumberStyleType(1);
            item2.setNumberScale(2);
            if (!condition.isAllCurrency()) {
                item2.setNumberScale(partner.getScaleRateLocal());
            }
            item2.setNeedKilobit(true);
            itemList.add(item2);
        }
        if (this.isShowReportingCurrencyColumns(partner)) {
            item2 = new ReportTableHeadItemInfo();
            item2.setColumnName("FRptRate");
            item2.setWidth(70);
            item2.setAlignment(2);
            item2.setFreeze(false);
            item2.setMerge(false);
            item2.setVisible(true);
            titles2 = new String[]{this.isShowLocalCurrencyColumns(partner) ? "RptRate" : "Rate"};
            item2.setTitles(titles2);
            item2.setNumberStyleType(1);
            item2.setNumberScale(2);
            if (!condition.isAllCurrency()) {
                item2.setNumberScale(partner.getScaleRateRpt());
            }
            item2.setNeedKilobit(true);
            itemList.add(item2);
        }
        ArrayList<ReportTableHeadItemInfo> debitList = new ArrayList<ReportTableHeadItemInfo>(5);
        if (this.isShowQuantity) {
            item = new ReportTableHeadItemInfo();
            item.setColumnName("FDebitUnit");
            item.setWidth(40);
            item.setAlignment(1);
            item.setFreeze(false);
            item.setMerge(false);
            item.setVisible(true);
            item.setTitles(new String[]{"Debit", "Unit"});
            debitList.add(item);
            item = new ReportTableHeadItemInfo();
            item.setColumnName("FDebitQuantity");
            item.setWidth(80);
            item.setAlignment(2);
            item.setFreeze(false);
            item.setMerge(false);
            item.setVisible(true);
            item.setTitles(new String[]{"Debit", "Quantity"});
            item.setNumberStyleType(1);
            item.setNumberScale(partner.getParmQtyScale());
            item.setNeedKilobit(true);
            debitList.add(item);
            item = new ReportTableHeadItemInfo();
            item.setColumnName("FDebitPrice");
            item.setWidth(80);
            item.setAlignment(2);
            item.setFreeze(false);
            item.setMerge(false);
            item.setVisible(true);
            item.setTitles(new String[]{"Debit", "Price"});
            item.setNumberStyleType(1);
            item.setNumberScale(partner.getParmPriceScale());
            item.setNeedKilobit(true);
            debitList.add(item);
        }
        item = new ReportTableHeadItemInfo();
        item.setColumnName("FDebitFor");
        item.setWidth(110);
        item.setAlignment(2);
        item.setFreeze(false);
        item.setMerge(false);
        item.setVisible(true);
        item.setTitles(new String[]{"Debit"});
        item.setNumberStyleType(1);
        item.setNumberScale(this.getScaleFor(partner, null));
        item.setNeedKilobit(true);
        debitList.add(item);
        if (this.isShowLocalCurrencyColumns(partner)) {
            item = new ReportTableHeadItemInfo();
            item.setColumnName("FDebitLocal");
            item.setWidth(110);
            item.setAlignment(2);
            item.setFreeze(false);
            item.setMerge(false);
            item.setVisible(true);
            item.setTitles(new String[]{"Debit", "LocalCurrency"});
            item.setNumberStyleType(1);
            item.setNumberScale(partner.getScaleLocal());
            item.setNeedKilobit(true);
            debitList.add(item);
        }
        if (this.isShowReportingCurrencyColumns(partner)) {
            item = new ReportTableHeadItemInfo();
            item.setColumnName("FDebitRpt");
            item.setWidth(110);
            item.setAlignment(2);
            item.setFreeze(false);
            item.setMerge(false);
            item.setVisible(true);
            item.setTitles(new String[]{"Debit", "ReportingCurrency"});
            item.setNumberStyleType(1);
            item.setNumberScale(partner.getScaleRpt());
            item.setNeedKilobit(true);
            debitList.add(item);
        }
        if (debitList.size() != 1) {
            int forIndex = this.isShowQuantity ? 3 : 0;
            ReportTableHeadItemInfo item4 = (ReportTableHeadItemInfo)debitList.get(forIndex);
            if (forIndex == debitList.size() - 1) {
                item4.setTitles(new String[]{"Debit", "Amount"});
            } else {
                item4.setTitles(new String[]{"Debit", "SourceCurrency"});
            }
        }
        itemList.addAll(debitList);
        if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
            ArrayList<ReportTableHeadItemInfo> debitListx = new ArrayList<ReportTableHeadItemInfo>(5);
            ReportTableHeadItemInfo item5 = new ReportTableHeadItemInfo();
            item5.setColumnName("FDebitAssistUnit");
            item5.setWidth(80);
            item5.setTitleNeedResource(new boolean[]{true, false});
            item5.setAlignment(1);
            item5.setFreeze(false);
            item5.setMerge(false);
            item5.setVisible(true);
            item5.setTitles(new String[]{"Debit", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"537_GLReportSubsidiaryLedgerControllerBean", (Locale)partner.getContext().getLocale())});
            debitListx.add(item5);
            item5 = new ReportTableHeadItemInfo();
            item5.setColumnName("FDebitAssistPrice");
            item5.setTitleNeedResource(new boolean[]{true, false});
            item5.setWidth(80);
            item5.setAlignment(2);
            item5.setFreeze(false);
            item5.setMerge(false);
            item5.setVisible(true);
            item5.setTitles(new String[]{"Debit", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"236_VoucherEditBaseUI", (Locale)partner.getContext().getLocale())});
            item5.setNumberStyleType(1);
            item5.setNumberScale(partner.getParmQtyScale());
            item5.setNeedKilobit(true);
            debitListx.add(item5);
            item5 = new ReportTableHeadItemInfo();
            item5.setColumnName("FDebitAssistQty");
            item5.setTitleNeedResource(new boolean[]{true, false});
            item5.setWidth(80);
            item5.setAlignment(2);
            item5.setFreeze(false);
            item5.setMerge(false);
            item5.setVisible(true);
            item5.setTitles(new String[]{"Debit", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"237_VoucherEditBaseUI", (Locale)partner.getContext().getLocale())});
            item5.setNumberStyleType(1);
            item5.setNumberScale(partner.getParmPriceScale());
            item5.setNeedKilobit(true);
            debitListx.add(item5);
            itemList.addAll(debitListx);
        }
        for (int i = 0; i < debitList.size(); ++i) {
            ReportTableHeadItemInfo debitItem = (ReportTableHeadItemInfo)debitList.get(i);
            ReportTableHeadItemInfo item6 = new ReportTableHeadItemInfo();
            item6.setColumnName("FCredit" + debitItem.getColumnName().substring(6));
            item6.setWidth(debitItem.getWidth());
            item6.setAlignment(debitItem.getAlignment());
            item6.setFreeze(debitItem.isFreeze());
            item6.setMerge(debitItem.isMerge());
            item6.setVisible(debitItem.isVisible());
            item6.setNeedKilobit(debitItem.isNeedKilobit());
            item6.setNumberScale(debitItem.getNumberScale());
            item6.setNumberStyleType(debitItem.getNumberStyleType());
            titles = new String[debitItem.getTitles().length];
            titles[0] = "Credit";
            for (j = 1; j < debitItem.getTitles().length; ++j) {
                titles[j] = debitItem.getTitles()[j];
            }
            item6.setTitles(titles);
            itemList.add(item6);
        }
        if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
            ArrayList<ReportTableHeadItemInfo> debitListx = new ArrayList<ReportTableHeadItemInfo>(5);
            ReportTableHeadItemInfo item7 = new ReportTableHeadItemInfo();
            item7.setColumnName("FCreditAssistUnit");
            item7.setWidth(80);
            item7.setTitleNeedResource(new boolean[]{true, false});
            item7.setAlignment(1);
            item7.setFreeze(false);
            item7.setMerge(false);
            item7.setVisible(true);
            item7.setTitles(new String[]{"Credit", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"537_GLReportSubsidiaryLedgerControllerBean", (Locale)partner.getContext().getLocale())});
            debitListx.add(item7);
            item7 = new ReportTableHeadItemInfo();
            item7.setColumnName("FCreditAssistPrice");
            item7.setTitleNeedResource(new boolean[]{true, false});
            item7.setWidth(80);
            item7.setAlignment(2);
            item7.setFreeze(false);
            item7.setMerge(false);
            item7.setVisible(true);
            item7.setTitles(new String[]{"Credit", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"236_VoucherEditBaseUI", (Locale)partner.getContext().getLocale())});
            item7.setNumberStyleType(1);
            item7.setNumberScale(partner.getParmQtyScale());
            item7.setNeedKilobit(true);
            debitListx.add(item7);
            item7 = new ReportTableHeadItemInfo();
            item7.setColumnName("FCreditAssistQty");
            item7.setTitleNeedResource(new boolean[]{true, false});
            item7.setWidth(80);
            item7.setAlignment(2);
            item7.setFreeze(false);
            item7.setMerge(false);
            item7.setVisible(true);
            item7.setTitles(new String[]{"Credit", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"237_VoucherEditBaseUI", (Locale)partner.getContext().getLocale())});
            item7.setNumberStyleType(1);
            item7.setNumberScale(partner.getParmPriceScale());
            item7.setNeedKilobit(true);
            debitListx.add(item7);
            itemList.addAll(debitListx);
        }
        for (int i = 0; i < debitList.size(); ++i) {
            if (!this.isShowQuantity && i == 0 || this.isShowQuantity && i == 3) {
                ReportTableHeadItemInfo item8 = new ReportTableHeadItemInfo();
                item8.setColumnName("FDC");
                item8.setWidth(40);
                item8.setAlignment(1);
                item8.setFreeze(false);
                item8.setMerge(false);
                item8.setVisible(true);
                item8.setTitles(new String[]{"Balance", "DC"});
                itemList.add(item8);
            }
            ReportTableHeadItemInfo debitItem = (ReportTableHeadItemInfo)debitList.get(i);
            ReportTableHeadItemInfo item9 = new ReportTableHeadItemInfo();
            item9.setColumnName("FBalance" + debitItem.getColumnName().substring(6));
            item9.setWidth(debitItem.getWidth());
            item9.setAlignment(debitItem.getAlignment());
            item9.setFreeze(debitItem.isFreeze());
            item9.setMerge(debitItem.isMerge());
            item9.setVisible(debitItem.isVisible());
            item9.setNeedKilobit(debitItem.isNeedKilobit());
            item9.setNumberScale(debitItem.getNumberScale());
            item9.setNumberStyleType(debitItem.getNumberStyleType());
            titles = new String[2];
            titles[0] = "Balance";
            if (debitList.size() == 1) {
                titles[1] = "Amount";
            } else {
                for (j = 1; j < debitItem.getTitles().length; ++j) {
                    titles[j] = debitItem.getTitles()[j];
                }
            }
            item9.setTitles(titles);
            itemList.add(item9);
        }
        if (condition.getOptionShowAccountCusAttribute()) {
            ArrayList<ReportTableHeadItemInfo> acclist = new ArrayList<ReportTableHeadItemInfo>();
            String companyid = partner.getCompanyId();
            String id = partner.getAccountViewInfo().getId().toString();
            StringBuffer sqln = new StringBuffer();
            sqln.append(" select fnumber from t_bd_accountview where fid ='");
            sqln.append(id).append("'");
            RptRowSet rs = null;
            try {
                rs = DBUtilx.executeQuery((String)sqln.toString(), null, (Context)partner.getContext());
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            String fnumber = null;
            while (rs.next()) {
                fnumber = rs.getString("fnumber");
            }
            String sqlids = new StringBuffer().append(" select fid  from t_bd_accountview where fnumber like '").append(fnumber).append("%'").append(" and FCompanyID='").append(companyid).append("'").append(" and FAccountTableID='").append(partner.getAccountTableId()).append("'").toString();
            try {
                rs = DBUtilx.executeQuery((String)sqlids, null, (Context)partner.getContext());
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            StringBuffer ids = new StringBuffer();
            while (rs.next()) {
                ids.append("'").append(rs.getString("fid")).append("',");
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" select FmappingFieldName from t_gl_assistcustomizedtype ");
            sql.append(" where Fid in (");
            sql.append(" select TGA.FCUSTOMIZEDTYPEID from t_gl_assistCustomizedProperty TGA ");
            sql.append(" inner join t_bd_accountview TA on TGA.FACCOUNTID = TA.FID ");
            sql.append(" where TA.FID in(");
            sql.append(ids.substring(0, ids.length() - 1).toString()).append("))");
            try {
                rs = DBUtilx.executeQuery((String)sql.toString(), null, (Context)partner.getContext());
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            ArrayList<String> mFieldNamelist = new ArrayList<String>();
            while (rs.next()) {
                mFieldNamelist.add(rs.getString("FmappingFieldName"));
            }
            ReportTableHeadItemInfo item10 = new ReportTableHeadItemInfo();
            item10.setColumnName("FBizNumber");
            item10.setWidth(100);
            item10.setAlignment(0);
            item10.setFreeze(false);
            item10.setMerge(false);
            item10.setVisible(false);
            if (mFieldNamelist.contains("FBizNumberID")) {
                item10.setVisible(true);
            }
            item10.setTitles(new String[]{"AccountCusAttribute", "BizNumber"});
            acclist.add(item10);
            item10 = new ReportTableHeadItemInfo();
            item10.setColumnName("FFeeType");
            item10.setWidth(100);
            item10.setAlignment(0);
            item10.setFreeze(false);
            item10.setMerge(false);
            item10.setVisible(false);
            if (mFieldNamelist.contains("FFeeType")) {
                item10.setVisible(true);
            }
            item10.setTitles(new String[]{"AccountCusAttribute", "FeeType"});
            acclist.add(item10);
            item10 = new ReportTableHeadItemInfo();
            item10.setColumnName("FHandler");
            item10.setWidth(100);
            item10.setAlignment(0);
            item10.setFreeze(false);
            item10.setMerge(false);
            item10.setVisible(false);
            if (mFieldNamelist.contains("FHandlerID")) {
                item10.setVisible(true);
            }
            item10.setTitles(new String[]{"AccountCusAttribute", "Handler"});
            acclist.add(item10);
            item10 = new ReportTableHeadItemInfo();
            item10.setColumnName("FInvoiceNumber");
            item10.setWidth(100);
            item10.setAlignment(0);
            item10.setFreeze(false);
            item10.setMerge(false);
            item10.setVisible(false);
            if (mFieldNamelist.contains("FInvoiceNumber")) {
                item10.setVisible(true);
            }
            item10.setTitles(new String[]{"AccountCusAttribute", "InvoiceNumber"});
            acclist.add(item10);
            item10 = new ReportTableHeadItemInfo();
            item10.setColumnName("FSettlementCode");
            item10.setWidth(100);
            item10.setAlignment(0);
            item10.setFreeze(false);
            item10.setMerge(false);
            item10.setVisible(false);
            if (mFieldNamelist.contains("FSettlementCode")) {
                item10.setVisible(true);
            }
            item10.setTitles(new String[]{"AccountCusAttribute", "SettlementCode"});
            acclist.add(item10);
            item10 = new ReportTableHeadItemInfo();
            item10.setColumnName("FSettlementType");
            item10.setWidth(100);
            item10.setAlignment(0);
            item10.setFreeze(false);
            item10.setMerge(false);
            item10.setVisible(false);
            if (mFieldNamelist.contains("FSettlementTypeID")) {
                item10.setVisible(true);
            }
            item10.setTitles(new String[]{"AccountCusAttribute", "SettlementType"});
            acclist.add(item10);
            item10 = new ReportTableHeadItemInfo();
            item10.setColumnName("FTicketNumber");
            item10.setWidth(100);
            item10.setAlignment(0);
            item10.setFreeze(false);
            item10.setMerge(false);
            item10.setVisible(false);
            if (mFieldNamelist.contains("FTicketNumber")) {
                item10.setVisible(true);
            }
            item10.setTitles(new String[]{"AccountCusAttribute", "TicketNumber"});
            acclist.add(item10);
            itemList.addAll(acclist);
        }
        ReportTableHeadItemInfo FNumber = new ReportTableHeadItemInfo();
        FNumber.setColumnName("FNumber");
        FNumber.setWidth(-1);
        FNumber.setAlignment(0);
        FNumber.setFreeze(false);
        FNumber.setMerge(false);
        FNumber.setVisible(false);
        FNumber.setTitles(new String[]{"FNumber"});
        itemList.add(FNumber);
        ReportTableHeadItemInfo itemFName = new ReportTableHeadItemInfo();
        itemFName.setColumnName("FName");
        itemFName.setWidth(-1);
        itemFName.setAlignment(0);
        itemFName.setFreeze(false);
        itemFName.setMerge(false);
        itemFName.setVisible(false);
        itemFName.setTitles(new String[]{"FName"});
        itemList.add(itemFName);
        if (condition.getOptionOtherAccount()) {
            ReportTableHeadItemInfo item11 = new ReportTableHeadItemInfo();
            item11 = new ReportTableHeadItemInfo();
            item11.setColumnName("currencyID");
            item11.setWidth(-1);
            item11.setAlignment(0);
            item11.setFreeze(false);
            item11.setMerge(false);
            item11.setVisible(false);
            item11.setTitles(new String[]{"otherAccount"});
            itemList.add(item11);
        }
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
            ReportTableHeadItemInfo item12 = new ReportTableHeadItemInfo();
            item12.setColumnName("fcurrencyid");
            item12.setWidth(0);
            item12.setAlignment(0);
            item12.setFreeze(false);
            item12.setMerge(false);
            item12.setVisible(false);
            item12.setTitles(new String[]{"fcurrencyid"});
            itemList.add(item12);
        }
        if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
            int i;
            ArrayList t = new ArrayList();
            String headStr = itemList.toString();
            String[] headStrs = headStr.split(",");
            int fDebitPriceIndex = 0;
            int fCreditPriceIndex = 0;
            for (i = 0; i < headStrs.length; ++i) {
                if ("FDebitPrice".equals(headStrs[i].toString().trim())) {
                    fDebitPriceIndex = i;
                }
                if (!"FCreditPrice".equals(headStrs[i].toString().trim())) continue;
                fCreditPriceIndex = i;
            }
            for (i = 0; i <= fDebitPriceIndex; ++i) {
                t.add(itemList.get(i));
            }
            for (i = fDebitPriceIndex + 1; i < fCreditPriceIndex; ++i) {
                if ("FDebitAssistUnit,FDebitAssistPrice,FDebitAssistQty".indexOf(itemList.get(i).toString().trim()) < 0) continue;
                t.add(itemList.get(i));
            }
            for (i = fDebitPriceIndex + 1; i <= fCreditPriceIndex; ++i) {
                if ("FDebitAssistUnit,FDebitAssistPrice,FDebitAssistQty".indexOf(itemList.get(i).toString().trim()) >= 0) continue;
                t.add(itemList.get(i));
            }
            for (i = fCreditPriceIndex + 1; i < itemList.size(); ++i) {
                if ("FCreditAssistUnit,FCreditAssistPrice,FCreditAssistQty".indexOf(itemList.get(i).toString().trim()) < 0) continue;
                t.add(itemList.get(i));
            }
            for (i = fCreditPriceIndex + 1; i < itemList.size(); ++i) {
                if ("FCreditAssistUnit,FCreditAssistPrice,FCreditAssistQty".indexOf(itemList.get(i).toString().trim()) >= 0) continue;
                t.add(itemList.get(i));
            }
            itemList = t;
        }
        ReportTableHeadItemInfo[] items = new ReportTableHeadItemInfo[itemList.size()];
        for (int i = 0; i < itemList.size(); ++i) {
            items[i] = (ReportTableHeadItemInfo)itemList.get(i);
        }
        ReportTableHeadInfo head = new ReportTableHeadInfo(items);
        head.setHeadMerge(true);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        partner.setTableHeadInfo(head);
    }

    @Override
    protected Collection getDataFromResult(ReportPartner partner, ResultSet rs) throws BOSException, SQLException, EASBizException {
        String unitGroupid;
        if (partner.getStartIndex() + partner.getLineCount() == 0) {
            return new ArrayList();
        }
        ArrayList startBalaceList = new ArrayList();
        ArrayList<Object> arrayList = new ArrayList<Object>(partner.getLineCount());
        this.isTransAccountDefaultMu = partner.getParmUseMuAccountDefalut();
        if (!partner.getParmQtyAsst() && partner.getAccountViewInfo().isIsQty() && partner.getDefaultMeasureUnitInfoForAccount() != null) {
            this.isAccountQty = true;
        }
        BigDecimal[] balances = null;
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        boolean isQueryLocalCuryCol = this.isShowLocalCurrencyColumns(partner);
        boolean isQueryRptCuryCol = this.isShowReportingCurrencyColumns(partner);
        ArrayList<String> list = new ArrayList<String>();
        JdbcRowSet rs2 = new JdbcRowSet();
        rs2.populate(rs);
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)partner.getContext());
        BigDecimal coefficient = new BigDecimal("1.0000");
        MeasureUnitInfo accMU = partner.getAccountViewInfo().getMeasureUnitID();
        if ((this.isTransAccountDefaultMu || partner.isRptTransferMeasureUnit() && partner.getAccountViewInfo().getCAA() == null) && accMU != null || this.isAccountQty) {
            if ((accMU = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(accMU.getId()))) != null) {
                coefficient = accMU.getCoefficient();
            }
        } else if (partner.getParmQtyAsst() && partner.getAsstActTypeInfo().isIsQty() && ((ReportConditionSubsidiaryLedgerAssist)partner.getFixCondition()).getAssistItem().size() == 0) {
            coefficient = this.getAsstQtyCoefficient(partner.getContext(), ((ReportConditionSubsidiaryLedgerAssist)partner.getFixCondition()).getAssistTypeId(), ((ReportConditionSubsidiaryLedgerAssist)partner.getFixCondition()).getAssistItemId());
        }
        MeasureUnitGroupInfo groupInfo = partner.getAccountViewInfo().getMeasureUnitGroupID();
        if (this.isShowQuantity) {
            if (groupInfo != null) {
                list.add(groupInfo.getId().toString());
            }
            while (rs2.next()) {
                String unitDebitid = rs2.getString("FDebitUnitId");
                if (unitDebitid == null) continue;
                unitGroupid = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitDebitid)).getMeasureUnitGroup().getId().toString();
                if (!list.contains(unitGroupid)) {
                    list.add(unitGroupid);
                }
                if (list.size() <= 1) continue;
                this.isSameDebitUnitGroup = false;
                break;
            }
        }
        list.clear();
        if (this.isShowQuantity) {
            if (groupInfo != null) {
                list.add(groupInfo.getId().toString());
            }
            rs2.beforeFirst();
            while (rs2.next()) {
                String unitCreditid = rs2.getString("FCreditUnitId");
                if (unitCreditid == null) continue;
                unitGroupid = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitCreditid)).getMeasureUnitGroup().getId().toString();
                if (!list.contains(unitGroupid)) {
                    list.add(unitGroupid);
                }
                if (list.size() <= 1) continue;
                this.isSameCreditUnitGroup = false;
                break;
            }
        }
        BigDecimal rptRate = new BigDecimal("1.00");
        CurrencyInfo rptCurrency = partner.getCompany().getReportCurrency();
        CurrencyInfo baseCurrency = partner.getCompany().getBaseCurrency();
        if (isQueryRptCuryCol && rptCurrency != null && baseCurrency != null) {
            ExchangeTableInfo exchangeTableInfo = partner.getCompany().getBaseExchangeTable();
            IExchangeRate iExchangeRate = ExchangeRateFactory.getLocalInstance((Context)partner.getContext());
            ExchangeRateInfo exchangeRateInfo = iExchangeRate.getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTableInfo.getId()), (IObjectPK)new ObjectUuidPK(baseCurrency.getId()), (IObjectPK)new ObjectUuidPK(rptCurrency.getId()), (Date)partner.getCurrentPeriod().getEndDate());
            if (exchangeRateInfo != null) {
                rptRate = exchangeRateInfo.getConvertRate();
            }
            if (exchangeRateInfo != null && rptRate.compareTo(GlUtils.zero) > 0 && exchangeRateInfo.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
                rptRate = GlUtils.one.divide(rptRate, 10, 4);
            }
        }
        rs2.beforeFirst();
        int index = 0;
        String lastVoucherID = null;
        ArrayList<HashMap> debitDataList = new ArrayList<HashMap>();
        ArrayList<HashMap> creditDataList = new ArrayList<HashMap>();
        ArrayList<HashMap> dcDataList = new ArrayList<HashMap>();
        boolean isChangeCur = false;
        String curId = null;
        int assiId = 0;
        while (rs2.next()) {
            Object[] obj;
            HashMap<String, Object[]> asssiHeIdMap = new HashMap<String, Object[]>();
            if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
                if (curId != null && !curId.equals(rs2.getString("FCurrencyid"))) {
                    isChangeCur = true;
                }
                curId = rs2.getString("fcurrencyid");
            }
            if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).getOptionOnlyAsst()) {
                int n = assiId = rs2.getObject("FdivisionBalance") == null ? 0 : rs2.getInt("FdivisionBalance");
            }
            if (balances == null) {
                balances = partner.getStartIndex() == 0 ? new BigDecimal[4] : (assiId == 2 ? new BigDecimal[4] : (partner.getFixCondition() instanceof ReportConditionSubsidiaryLedgerAssist ? (BigDecimal[])partner.getContext().get((Object)"balances_Assist") : (BigDecimal[])partner.getContext().get((Object)"balances")));
            }
            if (index == 0 && partner.getStartIndex() == 0 || isChangeCur) {
                isChangeCur = false;
                if (this.isShowQuantity) {
                    balances[0] = rs2.getBigDecimal("FDebitQtyDefault");
                    balances[0] = balances[0] == null ? ZERO : balances[0];
                }
                balances[1] = rs2.getBigDecimal("FDebitFor");
                BigDecimal bigDecimal = balances[1] = balances[1] == null ? ZERO : balances[1];
                if (isQueryLocalCuryCol) {
                    balances[2] = rs2.getBigDecimal("FDebitLocal");
                    BigDecimal bigDecimal2 = balances[2] = balances[1] == null ? ZERO : balances[2];
                }
                if (isQueryRptCuryCol) {
                    balances[3] = rs2.getBigDecimal("FDebitRpt");
                    BigDecimal bigDecimal3 = balances[3] = balances[3] == null ? ZERO : balances[3];
                }
            }
            if (partner.getStartIndex() > index) {
                // empty if block
            }
            String voucherID = rs2.getString("FVoucherID");
            if (condition.getOptionOtherAccount()) {
                if (voucherID != null && !voucherID.equalsIgnoreCase(lastVoucherID) || voucherID == null && lastVoucherID != null) {
                    ArrayList resultData = new ArrayList();
                    this.divideVoucherEntry(resultData, partner, debitDataList, creditDataList, dcDataList, balances, rptRate, isQueryLocalCuryCol, isQueryRptCuryCol, coefficient);
                    if (resultData.size() > 0) {
                        arrayList.addAll(resultData);
                    }
                    lastVoucherID = voucherID;
                }
                if (voucherID != null) {
                    BigDecimal debitFor = rs2.getBigDecimal("FDebitFor");
                    BigDecimal creditFor = rs2.getBigDecimal("FCreditFor");
                    BigDecimal debitLocal = ZERO;
                    BigDecimal creditLocal = ZERO;
                    BigDecimal debitRpt = ZERO;
                    BigDecimal creditRpt = ZERO;
                    debitLocal = rs2.getBigDecimal("FDebitLocal");
                    creditLocal = rs2.getBigDecimal("FCreditLocal");
                    if (isQueryRptCuryCol) {
                        debitRpt = rs2.getBigDecimal("FDebitRpt");
                        creditRpt = rs2.getBigDecimal("FCreditRpt");
                    }
                    if (debitFor != null && debitFor.doubleValue() > 0.0 || debitLocal != null && debitLocal.doubleValue() > 0.0 || debitRpt != null && debitRpt.doubleValue() > 0.0 || creditFor != null && creditFor.doubleValue() < 0.0 || creditLocal != null && creditLocal.doubleValue() < 0.0 || creditRpt != null && creditRpt.doubleValue() < 0.0) {
                        debitDataList.add(this.transfer(partner, rs2, isQueryRptCuryCol));
                    } else if (debitFor != null && debitFor.doubleValue() < 0.0 || debitLocal != null && debitLocal.doubleValue() < 0.0 || debitRpt != null && debitRpt.doubleValue() < 0.0 || creditFor != null && creditFor.doubleValue() > 0.0 || creditLocal != null && creditLocal.doubleValue() > 0.0 || creditRpt != null && creditRpt.doubleValue() > 0.0) {
                        creditDataList.add(this.transfer(partner, rs2, isQueryRptCuryCol));
                    }
                    dcDataList.add(this.transfer(partner, rs2, isQueryRptCuryCol));
                } else if (assiId == 2) {
                    obj = this.getLineObjects(partner, (ResultSet)rs2, balances, index == 0 && partner.getStartIndex() == 0, isQueryLocalCuryCol, isQueryRptCuryCol, coefficient);
                    asssiHeIdMap.put(rs2.getString("Fasstaccountperid"), obj);
                    startBalaceList.add(asssiHeIdMap);
                } else {
                    arrayList.add(this.getLineObjects(partner, (ResultSet)rs2, balances, index == 0 && partner.getStartIndex() == 0, isQueryLocalCuryCol, isQueryRptCuryCol, coefficient));
                }
            } else if (assiId == 2) {
                obj = this.getLineObjects(partner, (ResultSet)rs2, balances, index == 0 && partner.getStartIndex() == 0, isQueryLocalCuryCol, isQueryRptCuryCol, coefficient);
                asssiHeIdMap.put(rs2.getString("Fasstaccountperid"), obj);
                startBalaceList.add(asssiHeIdMap);
            } else {
                arrayList.add(this.getLineObjects(partner, (ResultSet)rs2, balances, index == 0 && partner.getStartIndex() == 0, isQueryLocalCuryCol, isQueryRptCuryCol, coefficient));
            }
            if (assiId == 2) {
                index = 0;
                continue;
            }
            ++index;
        }
        if (assiId != 2) {
            if (partner.getFixCondition() instanceof ReportConditionSubsidiaryLedgerAssist) {
                partner.getContext().put((Object)"balances_Assist", balances);
            } else {
                partner.getContext().put((Object)"balances", balances);
            }
        }
        if (assiId == 2) {
            return startBalaceList;
        }
        return arrayList;
    }

    private HashMap transfer(ReportPartner partner, JdbcRowSet rs, boolean isShowRptCuryCol) throws SQLException, EASBizException, BOSException {
        if (rs == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        map.put("FDescription", rs.getString("FDescription"));
        map.put("FNumber", rs.getString("FNumber"));
        map.put("FName", rs.getString("FName"));
        map.put("FDate", rs.getDate("FDate"));
        if (condition.getOptionShowBusinessDate()) {
            map.put("FBizDate", rs.getDate("FBizDate"));
        }
        map.put("FVoucherNumber", rs.getString("FVoucherTypeName") == null ? null : rs.getString("FVoucherTypeName") + " - " + rs.getString("FVoucherNumber"));
        map.put("FLineType", rs.getObject("FLineType"));
        map.put("FDescription", rs.getString("FDescription"));
        map.put("accountLongNumber", rs.getString("accountLongNumber"));
        map.put("accountName", rs.getString("accountName"));
        map.put("currencyID", rs.getString("currencyID"));
        map.put("FAccounttableid", rs.getString("FAccounttableid"));
        map.put("FSOURCETYPE", rs.getString("FSOURCETYPE"));
        if (partner.getFixCondition().isAllCurrency()) {
            map.put("FCurrencyName", rs.getString("FCurrencyName"));
            map.put("fcurrencyid", rs.getString("FCurrencyID"));
        }
        map.put("FLocalRate", rs.getBigDecimal("FLocalRate"));
        if (isShowRptCuryCol) {
            map.put("FRptRate", rs.getBigDecimal("FRptRate"));
        }
        if (this.isShowQuantity) {
            map.put("FDebitQtyDefault", rs.getBigDecimal("FDebitQtyDefault"));
            map.put("FDebitUnitId", rs.getString("FDebitUnitId"));
            map.put("FDebitQty", rs.getBigDecimal("FDebitQty"));
            map.put("FDebitPrice", rs.getBigDecimal("FDebitPrice"));
        }
        BigDecimal debitFor = rs.getBigDecimal("FDebitFor");
        map.put("FDebitFor", debitFor);
        map.put("FDebitLocal", rs.getBigDecimal("FDebitLocal"));
        if (isShowRptCuryCol) {
            map.put("FDebitRpt", rs.getBigDecimal("FDebitRpt"));
        }
        if (this.isShowQuantity) {
            map.put("FCreditQtyDefault", rs.getBigDecimal("FCreditQtyDefault"));
            map.put("FCreditUnitId", rs.getString("FCreditUnitId"));
            map.put("FCreditQty", rs.getBigDecimal("FCreditQty"));
            map.put("FCreditPrice", rs.getBigDecimal("FCreditPrice"));
        }
        map.put("FCreditFor", rs.getBigDecimal("FCreditFor"));
        map.put("FCreditLocal", rs.getBigDecimal("FCreditLocal"));
        if (isShowRptCuryCol) {
            map.put("FCreditRpt", rs.getBigDecimal("FCreditRpt"));
        }
        map.put("FVoucherID", rs.getString("FVoucherID"));
        map.put("FentryID", rs.getString("FSeq"));
        return map;
    }

    private void divideVoucherEntry(Collection resultData, ReportPartner partner, ArrayList debitDataList, ArrayList creditDataList, ArrayList dcDataList, BigDecimal[] balances, BigDecimal rptRate, boolean isShowLocalCuryCol, boolean isShowRptCuryCol, BigDecimal coefficient) throws EASBizException, BOSException, SQLException {
        HashMap value;
        String creditAccountNumber;
        BigDecimal credit_credit_Local;
        HashMap creditData;
        BigDecimal FCreditRpt;
        BigDecimal FCreditFor;
        BigDecimal FDebitRpt;
        BigDecimal FDebitFor;
        String debitAccountNumber;
        BigDecimal debit_debit_Local;
        HashMap debitData;
        int i;
        if (debitDataList == null || creditDataList == null || debitDataList.size() == 0 || creditDataList.size() == 0) {
            return;
        }
        int debitCount = 0;
        int creditCount = 0;
        BigDecimal totalDebitQty = new BigDecimal("0");
        BigDecimal totalCreditQty = new BigDecimal("0");
        BigDecimal totalDebitQtyDefault = new BigDecimal("0");
        BigDecimal totalCreditQtyDefault = new BigDecimal("0");
        BigDecimal totalDebitFor = new BigDecimal("0");
        BigDecimal totalCreditFor = new BigDecimal("0");
        BigDecimal totalDebitRpt = new BigDecimal("0");
        BigDecimal totalCreditRpt = new BigDecimal("0");
        BigDecimal creditPrice = null;
        BigDecimal debitPrice = null;
        HashMap<String, HashMap> debitDataList0 = new HashMap<String, HashMap>();
        HashMap<String, HashMap> creditDataList0 = new HashMap<String, HashMap>();
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)partner.getContext());
        paramKeyMap.put("GL_002", partner.getCompany().getId().toString());
        String qtyScale = (String)iParamControl.getParamHashMap(paramKeyMap).get("GL_002");
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        String accountLongNumber = partner.getAccountViewInfo().getLongNumber();
        String partnerCurrencyId = "";
        if (!partner.getFixCondition().isAllCurrency() && partner.getCurrencyType() == 0) {
            partnerCurrencyId = partner.getCurrency().getId().toString();
        }
        for (i = 0; i < debitDataList.size(); ++i) {
            debitData = (HashMap)debitDataList.get(i);
            debit_debit_Local = (BigDecimal)debitData.get("FDebitLocal");
            debitAccountNumber = (String)debitData.get("accountLongNumber");
            if (!accountLongNumber.equals(debitAccountNumber) && !debitAccountNumber.startsWith(accountLongNumber + "!") || !StringUtils.isEmpty((String)partnerCurrencyId) && !partnerCurrencyId.equalsIgnoreCase((String)debitData.get("currencyID"))) continue;
            if (debit_debit_Local.doubleValue() > 0.0) {
                FDebitFor = (BigDecimal)debitData.get("FDebitFor");
                totalDebitFor = totalDebitFor.add(FDebitFor);
                if (!isShowRptCuryCol) continue;
                FDebitRpt = (BigDecimal)debitData.get("FDebitRpt");
                totalDebitRpt = totalDebitRpt.add(FDebitRpt);
                continue;
            }
            FCreditFor = (BigDecimal)debitData.get("FCreditFor");
            totalCreditFor = totalCreditFor.add(FCreditFor);
            if (!isShowRptCuryCol) continue;
            FCreditRpt = (BigDecimal)debitData.get("FCreditRpt");
            totalCreditRpt = totalCreditRpt.add(FCreditRpt);
        }
        for (i = 0; i < creditDataList.size(); ++i) {
            creditData = (HashMap)creditDataList.get(i);
            credit_credit_Local = (BigDecimal)creditData.get("FCreditLocal");
            creditAccountNumber = (String)creditData.get("accountLongNumber");
            if (!accountLongNumber.equals(creditAccountNumber) && !creditAccountNumber.startsWith(accountLongNumber + "!") || !StringUtils.isEmpty((String)partnerCurrencyId) && !partnerCurrencyId.equalsIgnoreCase((String)creditData.get("currencyID"))) continue;
            if (credit_credit_Local.doubleValue() > 0.0) {
                FCreditFor = (BigDecimal)creditData.get("FCreditFor");
                totalCreditFor = totalCreditFor.add(FCreditFor);
                if (!isShowRptCuryCol) continue;
                FCreditRpt = (BigDecimal)creditData.get("FCreditRpt");
                totalCreditRpt = totalCreditRpt.add(FCreditRpt);
                continue;
            }
            FDebitFor = (BigDecimal)creditData.get("FDebitFor");
            totalDebitFor = totalDebitFor.add(FDebitFor);
            if (!isShowRptCuryCol) continue;
            FDebitRpt = (BigDecimal)creditData.get("FDebitRpt");
            totalDebitRpt = totalDebitRpt.add(FDebitRpt);
        }
        if (this.isShowQuantity) {
            BigDecimal FCreditQtyDefault;
            BigDecimal FCreditQty;
            BigDecimal FDebitQtyDefault;
            BigDecimal FDebitQty;
            for (i = 0; i < debitDataList.size(); ++i) {
                debitData = (HashMap)debitDataList.get(i);
                debit_debit_Local = (BigDecimal)debitData.get("FDebitLocal");
                debitAccountNumber = (String)debitData.get("accountLongNumber");
                if (!accountLongNumber.equals(debitAccountNumber) && !debitAccountNumber.startsWith(accountLongNumber + "!")) continue;
                if (debit_debit_Local.doubleValue() > 0.0) {
                    FDebitQty = (BigDecimal)debitData.get("FDebitQty");
                    FDebitQtyDefault = (BigDecimal)debitData.get("FDebitQtyDefault");
                    totalDebitQty = totalDebitQty.add(FDebitQty);
                    totalDebitQtyDefault = totalDebitQtyDefault.add(FDebitQtyDefault);
                    continue;
                }
                FCreditQty = (BigDecimal)debitData.get("FCreditQty");
                FCreditQtyDefault = (BigDecimal)debitData.get("FCreditQtyDefault");
                totalCreditQty = totalCreditQty.add(FCreditQty);
                totalCreditQtyDefault = totalCreditQtyDefault.add(FCreditQtyDefault);
            }
            for (i = 0; i < creditDataList.size(); ++i) {
                creditData = (HashMap)creditDataList.get(i);
                credit_credit_Local = (BigDecimal)creditData.get("FCreditLocal");
                creditAccountNumber = (String)creditData.get("accountLongNumber");
                if (!accountLongNumber.equals(creditAccountNumber) && !creditAccountNumber.startsWith(accountLongNumber + "!")) continue;
                if (credit_credit_Local.doubleValue() > 0.0) {
                    FCreditQty = (BigDecimal)creditData.get("FCreditQty");
                    FCreditQtyDefault = (BigDecimal)creditData.get("FCreditQtyDefault");
                    totalCreditQty = totalCreditQty.add(FCreditQty);
                    totalCreditQtyDefault = totalCreditQtyDefault.add(FCreditQtyDefault);
                    continue;
                }
                FDebitQty = (BigDecimal)creditData.get("FDebitQty");
                FDebitQtyDefault = (BigDecimal)creditData.get("FDebitQtyDefault");
                totalDebitQty = totalDebitQty.add(FDebitQty);
                totalDebitQtyDefault = totalDebitQtyDefault.add(FDebitQtyDefault);
            }
        }
        ExchangeTableInfo exchangeTableInfo = partner.getCompany().getBaseExchangeTable();
        IExchangeRate iExchangeRate = ExchangeRateFactory.getLocalInstance((Context)partner.getContext());
        ExchangeRateInfo exchangeRateInfo = null;
        String srcCurrencyId = "";
        String baseCurrencyId = partner.getCompany().getBaseCurrency().getId().toString();
        HashMap<Integer, Map<Integer, HashMap>> splitedDataEntryMap = new HashMap<Integer, Map<Integer, HashMap>>();
        Map<Integer, HashMap> splitedDataEntrySefMap = new HashMap();
        do {
            HashMap splitedData;
            Integer creditDataEntrySEQ;
            Integer debitDataEntrySEQ;
            if (debitDataList.size() == 0 || creditDataList.size() == 0) {
                return;
            }
            HashMap debitData2 = (HashMap)debitDataList.get(0);
            HashMap creditData2 = (HashMap)creditDataList.get(0);
            BigDecimal debit_debit_Local2 = (BigDecimal)debitData2.get("FDebitLocal");
            BigDecimal debit_credit_Local = (BigDecimal)debitData2.get("FCreditLocal");
            BigDecimal debitLocal = debit_debit_Local2.add(debit_credit_Local.negate());
            BigDecimal credit_debit_Local = (BigDecimal)creditData2.get("FDebitLocal");
            BigDecimal credit_credit_Local2 = (BigDecimal)creditData2.get("FCreditLocal");
            BigDecimal creditLocal = credit_credit_Local2.add(credit_debit_Local.negate());
            BigDecimal debit_debit_Rpt = GlUtils.zero;
            BigDecimal debit_credit_Rpt = GlUtils.zero;
            BigDecimal debitRpt = GlUtils.zero;
            BigDecimal credit_debit_Rpt = GlUtils.zero;
            BigDecimal credit_credit_Rpt = GlUtils.zero;
            BigDecimal creditRpt = GlUtils.zero;
            if (isShowRptCuryCol) {
                debit_debit_Rpt = (BigDecimal)debitData2.get("FDebitRpt");
                debit_credit_Rpt = (BigDecimal)debitData2.get("FCreditRpt");
                debitRpt = debit_debit_Rpt.add(debit_credit_Rpt.negate());
                credit_debit_Rpt = (BigDecimal)creditData2.get("FDebitRpt");
                credit_credit_Rpt = (BigDecimal)creditData2.get("FCreditRpt");
                creditRpt = credit_credit_Rpt.add(credit_debit_Rpt.negate());
            }
            String debitAccountNumber2 = (String)debitData2.get("accountLongNumber");
            String creditAccountNumber2 = (String)creditData2.get("accountLongNumber");
            if (debitLocal == null || creditLocal == null) {
                return;
            }
            int scale = 2;
            String currencyID = null;
            Object currencyInfo = null;
            if (!condition.isAllCurrency()) {
                scale = partner.getScaleFor();
            } else {
                String accountcode = condition.getAccountCodeStart();
                if (debitAccountNumber2.endsWith("!" + accountcode) && (StringUtils.isEmpty((String)partnerCurrencyId) || partnerCurrencyId.equalsIgnoreCase((String)debitData2.get("currencyID")))) {
                    currencyID = debitData2.get("currencyID").toString();
                } else if (creditAccountNumber2.endsWith("!" + accountcode) && (StringUtils.isEmpty((String)partnerCurrencyId) || partnerCurrencyId.equalsIgnoreCase((String)creditData2.get("currencyID")))) {
                    currencyID = creditData2.get("currencyID").toString();
                }
                scale = currencyID != null ? this.getCurrency(partner, currencyID).getPrecision() : Integer.parseInt(qtyScale);
            }
            int rptScale = partner.getScaleRpt();
            BigDecimal rate = new BigDecimal("1.00");
            if (partner.getCurrencyType() == 0 && !partner.isBaseCurrency()) {
                srcCurrencyId = "";
                if ((accountLongNumber.equals(debitAccountNumber2) || debitAccountNumber2.startsWith(accountLongNumber + "!")) && (StringUtils.isEmpty((String)partnerCurrencyId) || partnerCurrencyId.equalsIgnoreCase((String)debitData2.get("currencyID")))) {
                    rate = (BigDecimal)debitData2.get("FLocalRate");
                    srcCurrencyId = (String)debitData2.get("currencyID");
                } else if ((accountLongNumber.equals(creditAccountNumber2) || creditAccountNumber2.startsWith(accountLongNumber + "!")) && (StringUtils.isEmpty((String)partnerCurrencyId) || partnerCurrencyId.equalsIgnoreCase((String)creditData2.get("currencyID")))) {
                    rate = (BigDecimal)creditData2.get("FLocalRate");
                    srcCurrencyId = (String)creditData2.get("currencyID");
                }
                if (!StringUtils.isEmpty((String)srcCurrencyId) && (exchangeRateInfo = iExchangeRate.getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTableInfo.getId()), (IObjectPK)new ObjectUuidPK(srcCurrencyId), (IObjectPK)new ObjectUuidPK(baseCurrencyId), (Date)partner.getCurrentPeriod().getEndDate())) != null && rate.compareTo(GlUtils.zero) > 0 && exchangeRateInfo.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
                    rate = GlUtils.one.divide(rate, 10, 4);
                }
            } else {
                rptRate = rate;
            }
            BigDecimal debitFor = debitLocal.divide(rate, scale, 4);
            BigDecimal creditFor = creditLocal.divide(rate, scale, 4);
            if (debitLocal.compareTo(creditLocal) == 0) {
                HashMap tmpHap;
                if ((accountLongNumber.equals(debitAccountNumber2) || debitAccountNumber2.startsWith(accountLongNumber + "!")) && (partner.getCurrencyType() != 0 || !partner.getFixCondition().isAllCurrency() && partner.getCurrency().getId().toString().equalsIgnoreCase((String)debitData2.get("currencyID")) || debitData2.get("currencyID") != null && debitData2.get("currencyID").equals(creditData2.get("currencyID")) || partner.getFixCondition().isAllCurrency())) {
                    tmpHap = (HashMap)debitData2.clone();
                    tmpHap.put("accountName", creditData2.get("accountName"));
                    tmpHap.put("FAccounttableid", creditData2.get("FAccounttableid"));
                    tmpHap.put("FSOURCETYPE", creditData2.get("FSOURCETYPE"));
                    tmpHap.put("FDescription", creditData2.get("FDescription"));
                    if (this.isShowQuantity) {
                        debitPrice = (BigDecimal)debitData2.get("FDebitPrice");
                        creditPrice = (BigDecimal)debitData2.get("FCreditPrice");
                        if (debit_debit_Local2.doubleValue() > 0.0) {
                            if (debitPrice != null && debitPrice.doubleValue() != 0.0) {
                                if (debitData2.get("FDebitUnitId") != null) {
                                    tmpHap.put("FDebitQty", creditLocal.divide(debitPrice, scale, 4));
                                    tmpHap.put("FDebitQtyDefault", creditLocal.divide(debitPrice, scale, 4).multiply(coefficient));
                                } else {
                                    debitPrice = debitPrice.multiply(coefficient);
                                    tmpHap.put("FDebitPrice", debitPrice);
                                    tmpHap.put("FDebitQty", creditLocal.divide(debitPrice, scale, 4));
                                    tmpHap.put("FDebitQtyDefault", creditLocal.divide(debitPrice, scale, 4).multiply(coefficient));
                                }
                            } else {
                                tmpHap.put("FDebitQty", GlUtils.zero);
                                tmpHap.put("FDebitQtyDefault", GlUtils.zero);
                            }
                        } else if (debit_debit_Local2.doubleValue() <= 0.0) {
                            if (creditPrice != null && creditPrice.doubleValue() != 0.0) {
                                if (debitData2.get("FCreditUnitId") != null) {
                                    tmpHap.put("FCreditQty", creditLocal.negate().divide(creditPrice, scale, 4));
                                    tmpHap.put("FCreditQtyDefault", creditLocal.negate().divide(creditPrice, scale, 4).multiply(coefficient));
                                } else {
                                    creditPrice = creditPrice.multiply(coefficient);
                                    tmpHap.put("FCreditPrice", creditPrice);
                                    tmpHap.put("FCreditQty", creditLocal.negate().divide(creditPrice, scale, 4));
                                    tmpHap.put("FCreditQtyDefault", creditLocal.negate().divide(creditPrice, scale, 4).multiply(coefficient));
                                }
                            } else {
                                tmpHap.put("FCreditQty", GlUtils.zero);
                                tmpHap.put("FCreditQtyDefault", GlUtils.zero);
                            }
                        }
                    }
                    if (creditDataList0 != null && creditDataList0.size() != 0) {
                        tmpHap.put("oppFentryID", debitData2.get("FentryID").toString());
                        creditDataList0.put(String.valueOf(creditCount++), tmpHap);
                    } else {
                        debitDataEntrySEQ = new Integer(debitData2.get("FentryID").toString());
                        if (splitedDataEntryMap.get(debitDataEntrySEQ) != null) {
                            splitedDataEntrySefMap = (Map)splitedDataEntryMap.get(debitDataEntrySEQ);
                            splitedDataEntrySefMap.put(new Integer(splitedDataEntrySefMap.size() + 1), tmpHap);
                        } else {
                            splitedDataEntrySefMap = new HashMap();
                            splitedDataEntrySefMap.put(new Integer(splitedDataEntrySefMap.size() + 1), tmpHap);
                            splitedDataEntryMap.put(debitDataEntrySEQ, splitedDataEntrySefMap);
                        }
                    }
                }
                if ((accountLongNumber.equals(creditAccountNumber2) || creditAccountNumber2.startsWith(accountLongNumber + "!")) && (partner.getCurrencyType() != 0 || !partner.getFixCondition().isAllCurrency() && partner.getCurrency().getId().toString().equalsIgnoreCase((String)creditData2.get("currencyID")) || debitData2.get("currencyID") != null && debitData2.get("currencyID").equals(creditData2.get("currencyID")) || partner.getFixCondition().isAllCurrency())) {
                    tmpHap = (HashMap)creditData2.clone();
                    tmpHap.put("accountName", debitData2.get("accountName"));
                    tmpHap.put("FAccounttableid", debitData2.get("FAccounttableid"));
                    tmpHap.put("FSOURCETYPE", debitData2.get("FSOURCETYPE"));
                    tmpHap.put("FDescription", debitData2.get("FDescription"));
                    if (this.isShowQuantity) {
                        creditPrice = (BigDecimal)creditData2.get("FCreditPrice");
                        debitPrice = (BigDecimal)creditData2.get("FDebitPrice");
                        if (credit_credit_Local2.doubleValue() > 0.0) {
                            if (creditPrice != null && creditPrice.doubleValue() != 0.0) {
                                if (creditData2.get("FCreditUnitId") != null) {
                                    tmpHap.put("FCreditQty", debitLocal.divide(creditPrice, scale, 4));
                                    tmpHap.put("FCreditQtyDefault", debitLocal.divide(creditPrice, scale, 4).multiply(coefficient));
                                } else {
                                    creditPrice = creditPrice.multiply(coefficient);
                                    tmpHap.put("FCreditPrice", creditPrice);
                                    tmpHap.put("FCreditQty", debitLocal.divide(creditPrice, scale, 4));
                                    tmpHap.put("FCreditQtyDefault", debitLocal.divide(creditPrice, scale, 4).multiply(coefficient));
                                }
                            } else {
                                tmpHap.put("FCreditQty", GlUtils.zero);
                                tmpHap.put("FCreditQtyDefault", GlUtils.zero);
                            }
                        } else if (debitPrice != null && debitPrice.doubleValue() != 0.0) {
                            if (creditData2.get("FDebitUnitId") != null) {
                                tmpHap.put("FDebitQty", debitLocal.negate().divide(debitPrice, scale, 4));
                                tmpHap.put("FDebitQtyDefault", debitLocal.negate().divide(debitPrice, scale, 4).multiply(coefficient));
                            } else {
                                debitPrice = debitPrice.multiply(coefficient);
                                tmpHap.put("FDebitPrice", debitPrice);
                                tmpHap.put("FDebitQty", debitLocal.negate().divide(debitPrice, scale, 4));
                                tmpHap.put("FDebitQtyDefault", debitLocal.negate().divide(debitPrice, scale, 4).multiply(coefficient));
                            }
                        } else {
                            tmpHap.put("FDebitQty", GlUtils.zero);
                            tmpHap.put("FDebitQtyDefault", GlUtils.zero);
                        }
                    }
                    if (debitDataList0 != null && debitDataList0.size() != 0) {
                        tmpHap.put("oppFentryID", creditData2.get("FentryID").toString());
                        debitDataList0.put(String.valueOf(debitCount++), tmpHap);
                    } else {
                        creditDataEntrySEQ = new Integer(creditData2.get("FentryID").toString());
                        if (splitedDataEntryMap.get(creditDataEntrySEQ) != null) {
                            splitedDataEntrySefMap = (Map)splitedDataEntryMap.get(creditDataEntrySEQ);
                            splitedDataEntrySefMap.put(new Integer(splitedDataEntrySefMap.size() + 1), tmpHap);
                        } else {
                            splitedDataEntrySefMap = new HashMap();
                            splitedDataEntrySefMap.put(new Integer(splitedDataEntrySefMap.size() + 1), tmpHap);
                            splitedDataEntryMap.put(creditDataEntrySEQ, splitedDataEntrySefMap);
                        }
                    }
                }
                debitDataList.remove(0);
                creditDataList.remove(0);
                continue;
            }
            if (debitLocal.compareTo(creditLocal) > 0) {
                debitLocal = debitLocal.subtract(creditLocal);
                debitFor = debitLocal.divide(rate, scale, 4);
                debitRpt = debitRpt.subtract(creditRpt);
                if (debit_debit_Local2.doubleValue() > 0.0) {
                    debitData2.put("FDebitFor", debitFor);
                    debitData2.put("FDebitRpt", debitRpt);
                    debitData2.put("FDebitLocal", debitLocal);
                } else {
                    debitData2.put("FCreditFor", debitFor.negate());
                    debitData2.put("FCreditRpt", debitRpt.negate());
                    debitData2.put("FCreditLocal", debitLocal.negate());
                }
                if ((accountLongNumber.equals(debitAccountNumber2) || debitAccountNumber2.startsWith(accountLongNumber + "!")) && (StringUtils.isEmpty((String)partnerCurrencyId) || partnerCurrencyId.equalsIgnoreCase((String)debitData2.get("currencyID")))) {
                    splitedData = (HashMap)debitData2.clone();
                    if (this.isShowQuantity) {
                        debitPrice = (BigDecimal)debitData2.get("FDebitPrice");
                        creditPrice = (BigDecimal)debitData2.get("FCreditPrice");
                    }
                    if (debit_debit_Local2.doubleValue() > 0.0) {
                        splitedData.put("FDebitFor", creditFor);
                        splitedData.put("FDebitRpt", creditRpt);
                        splitedData.put("FDebitLocal", creditLocal);
                        if (this.isShowQuantity) {
                            if (debitPrice != null && debitPrice.doubleValue() != 0.0) {
                                if (debitData2.get("FDebitUnitId") != null) {
                                    splitedData.put("FDebitQty", creditLocal.divide(debitPrice, scale, 4));
                                    splitedData.put("FDebitQtyDefault", creditLocal.divide(debitPrice, scale, 4).multiply(coefficient));
                                } else {
                                    debitPrice = debitPrice.multiply(coefficient);
                                    splitedData.put("FDebitPrice", debitPrice);
                                    splitedData.put("FDebitQty", creditLocal.divide(debitPrice, scale, 4));
                                    splitedData.put("FDebitQtyDefault", creditLocal.divide(debitPrice, scale, 4).multiply(coefficient));
                                }
                            } else {
                                splitedData.put("FDebitQty", GlUtils.zero);
                                splitedData.put("FDebitQtyDefault", GlUtils.zero);
                            }
                        }
                    } else {
                        splitedData.put("FCreditFor", creditFor.negate());
                        splitedData.put("FCreditRpt", creditRpt.negate());
                        splitedData.put("FCreditLocal", creditLocal.negate());
                        if (this.isShowQuantity) {
                            if (creditPrice != null && creditPrice.doubleValue() != 0.0) {
                                if (debitData2.get("FCreditUnitId") != null) {
                                    splitedData.put("FCreditQty", creditLocal.negate().divide(creditPrice, scale, 4));
                                    splitedData.put("FCreditQtyDefault", creditLocal.negate().divide(creditPrice, scale, 4).multiply(coefficient));
                                } else {
                                    creditPrice = creditPrice.multiply(coefficient);
                                    splitedData.put("FCreditPrice", creditPrice);
                                    splitedData.put("FCreditQty", creditLocal.negate().divide(creditPrice, scale, 4));
                                    splitedData.put("FCreditQtyDefault", creditLocal.negate().divide(creditPrice, scale, 4).multiply(coefficient));
                                }
                            } else {
                                splitedData.put("FCreditQty", GlUtils.zero);
                                splitedData.put("FCreditQtyDefault", GlUtils.zero);
                            }
                        }
                    }
                    if (partner.getCurrencyType() != 0 || !partner.getFixCondition().isAllCurrency() && partner.getCurrency().getId().toString().equalsIgnoreCase((String)splitedData.get("currencyID")) || splitedData.get("currencyID") != null && splitedData.get("currencyID").equals(creditData2.get("currencyID")) || partner.getFixCondition().isAllCurrency()) {
                        splitedData.put("accountName", creditData2.get("accountName"));
                        splitedData.put("FAccounttableid", creditData2.get("FAccounttableid"));
                        splitedData.put("FSOURCETYPE", creditData2.get("FSOURCETYPE"));
                        splitedData.put("FDescription", creditData2.get("FDescription"));
                        debitDataEntrySEQ = new Integer(debitData2.get("FentryID").toString());
                        if (splitedDataEntryMap.get(debitDataEntrySEQ) != null) {
                            splitedDataEntrySefMap = (Map)splitedDataEntryMap.get(debitDataEntrySEQ);
                            splitedDataEntrySefMap.put(new Integer(splitedDataEntrySefMap.size() + 1), splitedData);
                        } else {
                            splitedDataEntrySefMap = new HashMap();
                            splitedDataEntrySefMap.put(new Integer(splitedDataEntrySefMap.size() + 1), splitedData);
                            splitedDataEntryMap.put(debitDataEntrySEQ, splitedDataEntrySefMap);
                        }
                    }
                }
                if ((accountLongNumber.equals(creditAccountNumber2) || creditAccountNumber2.startsWith(accountLongNumber + "!")) && (StringUtils.isEmpty((String)partnerCurrencyId) || partnerCurrencyId.equalsIgnoreCase((String)creditData2.get("currencyID")))) {
                    splitedData = (HashMap)creditData2.clone();
                    if (this.isShowQuantity) {
                        creditPrice = (BigDecimal)creditData2.get("FCreditPrice");
                        debitPrice = (BigDecimal)creditData2.get("FDebitPrice");
                    }
                    if (credit_credit_Local2.doubleValue() > 0.0) {
                        if (this.isShowQuantity) {
                            if (creditPrice != null && creditPrice.doubleValue() != 0.0) {
                                if (creditData2.get("FCreditUnitId") != null) {
                                    splitedData.put("FCreditQty", creditLocal.divide(creditPrice, scale, 4));
                                    splitedData.put("FCreditQtyDefault", creditLocal.divide(creditPrice, scale, 4).multiply(coefficient));
                                } else {
                                    creditPrice = creditPrice.multiply(coefficient);
                                    splitedData.put("FCreditPrice", creditPrice);
                                    splitedData.put("FCreditQty", creditLocal.divide(creditPrice, scale, 4));
                                    splitedData.put("FCreditQtyDefault", creditLocal.divide(creditPrice, scale, 4).multiply(coefficient));
                                }
                            } else {
                                splitedData.put("FCreditQty", GlUtils.zero);
                                splitedData.put("FCreditQtyDefault", GlUtils.zero);
                            }
                        }
                    } else if (this.isShowQuantity) {
                        if (debitPrice != null && debitPrice.doubleValue() != 0.0) {
                            if (creditData2.get("FDebitUnitId") != null) {
                                splitedData.put("FDebitQty", creditLocal.negate().divide(debitPrice, scale, 4));
                                splitedData.put("FDebitQtyDefault", creditLocal.negate().divide(debitPrice, scale, 4).multiply(coefficient));
                            } else {
                                debitPrice = debitPrice.multiply(coefficient);
                                splitedData.put("FDebitPrice", debitPrice);
                                splitedData.put("FDebitQty", creditLocal.negate().divide(debitPrice, scale, 4));
                                splitedData.put("FDebitQtyDefault", creditLocal.negate().divide(debitPrice, scale, 4).multiply(coefficient));
                            }
                        } else {
                            splitedData.put("FDebitQty", GlUtils.zero);
                            splitedData.put("FDebitQtyDefault", GlUtils.zero);
                        }
                    }
                    if (partner.getCurrencyType() != 0 || !partner.getFixCondition().isAllCurrency() && partner.getCurrency().getId().toString().equalsIgnoreCase((String)splitedData.get("currencyID")) || debitData2.get("currencyID") != null && debitData2.get("currencyID").equals(splitedData.get("currencyID")) || partner.getFixCondition().isAllCurrency()) {
                        splitedData.put("accountName", debitData2.get("accountName"));
                        splitedData.put("FAccounttableid", debitData2.get("FAccounttableid"));
                        splitedData.put("FSOURCETYPE", debitData2.get("FSOURCETYPE"));
                        splitedData.put("FDescription", debitData2.get("FDescription"));
                        splitedData.put("oppFentryID", creditData2.get("FentryID").toString());
                        debitDataList0.put(String.valueOf(debitCount++), splitedData);
                    }
                }
                creditDataList.remove(0);
                continue;
            }
            creditLocal = creditLocal.subtract(debitLocal);
            creditFor = creditLocal.divide(rate, scale, 4);
            creditRpt = creditRpt.subtract(debitRpt);
            if (credit_credit_Local2.doubleValue() > 0.0) {
                creditData2.put("FCreditFor", creditFor);
                creditData2.put("FCreditRpt", creditRpt);
                creditData2.put("FCreditLocal", creditLocal);
            } else {
                creditData2.put("FDebitFor", creditFor.negate());
                creditData2.put("FDebitRpt", creditRpt.negate());
                creditData2.put("FDebitLocal", creditLocal.negate());
            }
            if ((accountLongNumber.equals(creditAccountNumber2) || creditAccountNumber2.startsWith(accountLongNumber + "!")) && (StringUtils.isEmpty((String)partnerCurrencyId) || partnerCurrencyId.equalsIgnoreCase((String)creditData2.get("currencyID")))) {
                splitedData = (HashMap)creditData2.clone();
                if (this.isShowQuantity) {
                    creditPrice = (BigDecimal)creditData2.get("FCreditPrice");
                    debitPrice = (BigDecimal)creditData2.get("FDebitPrice");
                }
                if (credit_credit_Local2.doubleValue() > 0.0) {
                    splitedData.put("FCreditFor", debitFor);
                    splitedData.put("FCreditRpt", debitRpt);
                    splitedData.put("FCreditLocal", debitLocal);
                    if (this.isShowQuantity) {
                        if (creditPrice != null && creditPrice.doubleValue() != 0.0) {
                            if (creditData2.get("FCreditUnitId") != null) {
                                splitedData.put("FCreditQty", debitLocal.divide(creditPrice, scale, 4));
                                splitedData.put("FCreditQtyDefault", debitLocal.divide(creditPrice, scale, 4).multiply(coefficient));
                            } else {
                                creditPrice = creditPrice.multiply(coefficient);
                                splitedData.put("FCreditPrice", creditPrice);
                                splitedData.put("FCreditQty", debitLocal.divide(creditPrice, scale, 4));
                                splitedData.put("FCreditQtyDefault", debitLocal.divide(creditPrice, scale, 4).multiply(coefficient));
                            }
                        } else {
                            splitedData.put("FCreditQty", GlUtils.zero);
                            splitedData.put("FCreditQtyDefault", GlUtils.zero);
                        }
                    }
                } else {
                    splitedData.put("FDebitFor", debitFor.negate());
                    splitedData.put("FDebitRpt", debitRpt.negate());
                    splitedData.put("FDebitLocal", debitLocal.negate());
                    if (this.isShowQuantity) {
                        if (debitPrice != null && debitPrice.doubleValue() != 0.0) {
                            if (creditData2.get("FDebitUnitId") != null) {
                                splitedData.put("FDebitQty", debitLocal.negate().divide(debitPrice, scale, 4));
                                splitedData.put("FDebitQtyDefault", debitLocal.negate().divide(debitPrice, scale, 4).multiply(coefficient));
                            } else {
                                debitPrice = debitPrice.multiply(coefficient);
                                splitedData.put("FDebitPrice", debitPrice);
                                splitedData.put("FDebitQty", debitLocal.negate().divide(debitPrice, scale, 4));
                                splitedData.put("FDebitQtyDefault", debitLocal.negate().divide(debitPrice, scale, 4).multiply(coefficient));
                            }
                        } else {
                            splitedData.put("FDebitQty", GlUtils.zero);
                            splitedData.put("FDebitQtyDefault", GlUtils.zero);
                        }
                    }
                }
                if (partner.getCurrencyType() != 0 || !partner.getFixCondition().isAllCurrency() && partner.getCurrency().getId().toString().equalsIgnoreCase((String)splitedData.get("currencyID")) || debitData2.get("currencyID") != null && debitData2.get("currencyID").equals(splitedData.get("currencyID")) || partner.getFixCondition().isAllCurrency()) {
                    splitedData.put("accountName", debitData2.get("accountName"));
                    splitedData.put("FAccounttableid", debitData2.get("FAccounttableid"));
                    splitedData.put("FSOURCETYPE", debitData2.get("FSOURCETYPE"));
                    splitedData.put("FDescription", debitData2.get("FDescription"));
                    creditDataEntrySEQ = new Integer(creditData2.get("FentryID").toString());
                    if (splitedDataEntryMap.get(creditDataEntrySEQ) != null) {
                        splitedDataEntrySefMap = (Map)splitedDataEntryMap.get(creditDataEntrySEQ);
                        splitedDataEntrySefMap.put(new Integer(splitedDataEntrySefMap.size() + 1), splitedData);
                    } else {
                        splitedDataEntrySefMap = new HashMap();
                        splitedDataEntrySefMap.put(new Integer(splitedDataEntrySefMap.size() + 1), splitedData);
                        splitedDataEntryMap.put(creditDataEntrySEQ, splitedDataEntrySefMap);
                    }
                }
            }
            if ((accountLongNumber.equals(debitAccountNumber2) || debitAccountNumber2.startsWith(accountLongNumber + "!")) && (StringUtils.isEmpty((String)partnerCurrencyId) || partnerCurrencyId.equalsIgnoreCase((String)debitData2.get("currencyID")))) {
                splitedData = (HashMap)debitData2.clone();
                if (this.isShowQuantity) {
                    debitPrice = (BigDecimal)debitData2.get("FDebitPrice");
                    creditPrice = (BigDecimal)debitData2.get("FCreditPrice");
                }
                if (debit_debit_Local2.doubleValue() > 0.0) {
                    if (this.isShowQuantity) {
                        if (debitPrice != null && debitPrice.doubleValue() != 0.0) {
                            if (debitData2.get("FDebitUnitId") != null) {
                                splitedData.put("FDebitQty", debitLocal.divide(debitPrice, scale, 4));
                                splitedData.put("FDebitQtyDefault", debitLocal.divide(debitPrice, scale, 4).multiply(coefficient));
                            } else {
                                debitPrice = debitPrice.multiply(coefficient);
                                splitedData.put("FDebitPrice", debitPrice);
                                splitedData.put("FDebitQty", debitLocal.divide(debitPrice, scale, 4));
                                splitedData.put("FDebitQtyDefault", debitLocal.divide(debitPrice, scale, 4).multiply(coefficient));
                            }
                        } else {
                            splitedData.put("FDebitQty", GlUtils.zero);
                            splitedData.put("FDebitQtyDefault", GlUtils.zero);
                        }
                    }
                } else if (this.isShowQuantity) {
                    if (creditPrice != null && creditPrice.doubleValue() != 0.0) {
                        if (debitData2.get("FCreditUnitId") != null) {
                            splitedData.put("FCreditQty", debitLocal.negate().divide(creditPrice, scale, 4));
                            splitedData.put("FCreditQtyDefault", debitLocal.negate().divide(creditPrice, scale, 4).multiply(coefficient));
                        } else {
                            creditPrice = creditPrice.multiply(coefficient);
                            splitedData.put("FCreditPrice", creditPrice);
                            splitedData.put("FCreditQty", debitLocal.negate().divide(creditPrice, scale, 4));
                            splitedData.put("FCreditQtyDefault", debitLocal.negate().divide(creditPrice, scale, 4).multiply(coefficient));
                        }
                    } else {
                        splitedData.put("FCreditQty", GlUtils.zero);
                        splitedData.put("FCreditQtyDefault", GlUtils.zero);
                    }
                }
                if (partner.getCurrencyType() != 0 || !partner.getFixCondition().isAllCurrency() && partner.getCurrency().getId().toString().equalsIgnoreCase((String)splitedData.get("currencyID")) || splitedData.get("currencyID") != null && splitedData.get("currencyID").equals(creditData2.get("currencyID")) || partner.getFixCondition().isAllCurrency()) {
                    splitedData.put("accountName", creditData2.get("accountName"));
                    splitedData.put("FAccounttableid", creditData2.get("FAccounttableid"));
                    splitedData.put("FSOURCETYPE", creditData2.get("FSOURCETYPE"));
                    splitedData.put("FDescription", creditData2.get("FDescription"));
                    splitedData.put("oppFentryID", debitData2.get("FentryID").toString());
                    creditDataList0.put(String.valueOf(creditCount++), splitedData);
                }
            }
            debitDataList.remove(0);
        } while (debitDataList != null && creditDataList != null && debitDataList.size() > 0 && creditDataList.size() > 0);
        if (creditDataList0 != null && creditDataList0.size() != 0) {
            for (int i2 = 0; i2 < creditCount; ++i2) {
                value = (HashMap)creditDataList0.get(String.valueOf(i2));
                Integer debitDataEntrySEQ = new Integer(value.get("oppFentryID").toString());
                if (splitedDataEntryMap.get(debitDataEntrySEQ) != null) {
                    splitedDataEntrySefMap = (Map)splitedDataEntryMap.get(debitDataEntrySEQ);
                    splitedDataEntrySefMap.put(new Integer(splitedDataEntrySefMap.size() + 1), value);
                    continue;
                }
                splitedDataEntrySefMap = new HashMap();
                splitedDataEntrySefMap.put(new Integer(splitedDataEntrySefMap.size() + 1), value);
                splitedDataEntryMap.put(debitDataEntrySEQ, splitedDataEntrySefMap);
            }
        }
        if (debitDataList0 != null && debitDataList0.size() != 0) {
            for (int i3 = 0; i3 < debitCount; ++i3) {
                value = (HashMap)debitDataList0.get(String.valueOf(i3));
                Integer creditDataEntrySEQ = new Integer(value.get("oppFentryID").toString());
                if (splitedDataEntryMap.get(creditDataEntrySEQ) != null) {
                    splitedDataEntrySefMap = (Map)splitedDataEntryMap.get(creditDataEntrySEQ);
                    splitedDataEntrySefMap.put(new Integer(splitedDataEntrySefMap.size() + 1), value);
                    continue;
                }
                splitedDataEntrySefMap = new HashMap();
                splitedDataEntrySefMap.put(new Integer(splitedDataEntrySefMap.size() + 1), value);
                splitedDataEntryMap.put(creditDataEntrySEQ, splitedDataEntrySefMap);
            }
        }
        ArrayList splitedDataEntryList = new ArrayList(splitedDataEntryMap.keySet());
        Collections.sort(splitedDataEntryList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return (Integer)o1 - (Integer)o2;
            }
        });
        BigDecimal sumCQty = new BigDecimal("0");
        BigDecimal sumDQty = new BigDecimal("0");
        BigDecimal sumCQtyDefault = new BigDecimal("0");
        BigDecimal sumDQtyDefault = new BigDecimal("0");
        BigDecimal sumCFor = new BigDecimal("0");
        BigDecimal sumDFor = new BigDecimal("0");
        BigDecimal sumCRpt = new BigDecimal("0");
        BigDecimal sumDRpt = new BigDecimal("0");
        for (int i4 = 0; i4 < splitedDataEntryList.size(); ++i4) {
            Map splitedDataEntry = (Map)splitedDataEntryMap.get(splitedDataEntryList.get(i4));
            ArrayList splitedDataEntrySefList = new ArrayList(splitedDataEntry.keySet());
            Collections.sort(splitedDataEntrySefList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return (Integer)o1 - (Integer)o2;
                }
            });
            String otherAccountTableid = null;
            for (int j = 0; j < splitedDataEntrySefList.size(); ++j) {
                Object dRpt;
                Object cRpt;
                Object dFor;
                Object cFor;
                HashMap splitedDataEntrySef = (HashMap)splitedDataEntry.get(splitedDataEntrySefList.get(j));
                if (i4 == splitedDataEntryList.size() - 1 && j == splitedDataEntrySefList.size() - 1) {
                    cFor = splitedDataEntrySef.get("FCreditFor");
                    dFor = splitedDataEntrySef.get("FDebitFor");
                    if (cFor != null) {
                        splitedDataEntrySef.put("FCreditFor", totalCreditFor.subtract(sumCFor));
                    }
                    if (dFor != null) {
                        splitedDataEntrySef.put("FDebitFor", totalDebitFor.subtract(sumDFor));
                    }
                    if (isShowRptCuryCol) {
                        cRpt = splitedDataEntrySef.get("FCreditRpt");
                        dRpt = splitedDataEntrySef.get("FDebitRpt");
                        if (cRpt != null) {
                            splitedDataEntrySef.put("FCreditRpt", totalCreditRpt.subtract(sumCRpt));
                        }
                        if (dRpt != null) {
                            splitedDataEntrySef.put("FDebitRpt", totalDebitRpt.subtract(sumDRpt));
                        }
                    }
                } else {
                    cFor = splitedDataEntrySef.get("FCreditFor");
                    dFor = splitedDataEntrySef.get("FDebitFor");
                    sumCFor = sumCFor.add(cFor == null ? new BigDecimal("0") : (BigDecimal)cFor);
                    sumDFor = sumDFor.add(dFor == null ? new BigDecimal("0") : (BigDecimal)dFor);
                    if (isShowRptCuryCol) {
                        cRpt = splitedDataEntrySef.get("FCreditRpt");
                        dRpt = splitedDataEntrySef.get("FDebitRpt");
                        sumCRpt = sumCRpt.add(cRpt == null ? new BigDecimal("0") : (BigDecimal)cRpt);
                        sumDRpt = sumDRpt.add(dRpt == null ? new BigDecimal("0") : (BigDecimal)dRpt);
                    }
                }
                if (this.isShowQuantity) {
                    Object dQtyDefault;
                    Object cQtyDefault;
                    Object dQty;
                    Object cQty;
                    if (i4 == splitedDataEntryList.size() - 1 && j == splitedDataEntrySefList.size() - 1) {
                        cQty = splitedDataEntrySef.get("FCreditQty");
                        dQty = splitedDataEntrySef.get("FDebitQty");
                        cQtyDefault = splitedDataEntrySef.get("FCreditQtyDefault");
                        dQtyDefault = splitedDataEntrySef.get("FDebitQtyDefault");
                        if (cQty != null) {
                            splitedDataEntrySef.put("FCreditQty", totalCreditQty.subtract(sumCQty));
                        }
                        if (dQty != null) {
                            splitedDataEntrySef.put("FDebitQty", totalDebitQty.subtract(sumDQty));
                        }
                        if (cQtyDefault != null) {
                            splitedDataEntrySef.put("FCreditQtyDefault", totalCreditQtyDefault.subtract(sumCQtyDefault));
                        }
                        if (dQtyDefault != null) {
                            splitedDataEntrySef.put("FDebitQtyDefault", totalDebitQtyDefault.subtract(sumDQtyDefault));
                        }
                    } else {
                        cQty = splitedDataEntrySef.get("FCreditQty");
                        dQty = splitedDataEntrySef.get("FDebitQty");
                        cQtyDefault = splitedDataEntrySef.get("FCreditQtyDefault");
                        dQtyDefault = splitedDataEntrySef.get("FDebitQtyDefault");
                        sumCQty = sumCQty.add(cQty == null ? new BigDecimal("0") : (BigDecimal)cQty);
                        sumDQty = sumDQty.add(dQty == null ? new BigDecimal("0") : (BigDecimal)dQty);
                        sumCQtyDefault = sumCQtyDefault.add(cQtyDefault == null ? new BigDecimal("0") : (BigDecimal)cQtyDefault);
                        sumDQtyDefault = sumDQtyDefault.add(dQtyDefault == null ? new BigDecimal("0") : (BigDecimal)dQtyDefault);
                    }
                }
                String accountAbleId = (String)splitedDataEntrySef.get("FAccounttableid");
                int sourceType = new Integer((String)splitedDataEntrySef.get("FSOURCETYPE"));
                if (sourceType == 7) {
                    AccountRefContrastInfo ar;
                    if (otherAccountTableid == null && (ar = AccountRefContrastFactory.getLocalInstance((Context)partner.getContext()).getLastAcctInfo(partner.getCompanyId(), ContextUtil.getCurrentFIUnit((Context)partner.getContext()).getAccountTable().getId().toString(), condition.getPeriodYearEnd(), condition.getPeriodNumberEnd())) != null && partner.getAccountTableId() != null) {
                        if (ar.getEnabledAcctTable() != null && ar.getEnabledAcctTable().getId() != null && ar.getEnabledAcctTable().getId().toString().equals(partner.getAccountTableId()) && ar.getDisabledAcctTable() != null && ar.getDisabledAcctTable().getId() != null) {
                            otherAccountTableid = ar.getDisabledAcctTable().getId().toString();
                        } else if (ar.getDisabledAcctTable() != null && ar.getDisabledAcctTable().getId() != null && ar.getDisabledAcctTable().getId().toString().equals(partner.getAccountTableId()) && ar.getEnabledAcctTable() != null && ar.getEnabledAcctTable().getId() != null) {
                            otherAccountTableid = ar.getEnabledAcctTable().getId().toString();
                        }
                    }
                    if (!accountAbleId.equals(otherAccountTableid)) continue;
                }
                resultData.add(this.getLineObjects(partner, splitedDataEntrySef, balances, isShowLocalCuryCol, isShowRptCuryCol, coefficient));
            }
        }
    }

    public int[] getDCQtyIndexs(ReportPartner partner, boolean isShowLocalCuryCol, boolean isShowRptCuryCol) {
        int[] qtyIndexs = new int[2];
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        int index = 0;
        ++index;
        if (condition.getOptionShowBusinessDate()) {
            ++index;
        }
        index += 4;
        if (condition.isAllCurrency()) {
            ++index;
        }
        if (isShowLocalCuryCol) {
            ++index;
        }
        if (isShowRptCuryCol) {
            ++index;
        }
        int n = ++index;
        ++index;
        qtyIndexs[0] = n;
        index += 2;
        if (isShowLocalCuryCol) {
            ++index;
        }
        if (isShowRptCuryCol) {
            ++index;
        }
        qtyIndexs[1] = ++index;
        return qtyIndexs;
    }

    public CurrencyInfo getCurrency(ReportPartner partner, String currencyId) throws BOSException, EASBizException {
        CurrencyInfo currencyInfo = null;
        if (currencyInfo == null) {
            if (currencyId == null) {
                return null;
            }
            CurrencyCollection cc = partner.getAllCurrency();
            int n = cc.size();
            for (int i = 0; i < n; ++i) {
                if (!currencyId.equals(cc.get(i).getId().toString())) continue;
                currencyInfo = cc.get(i);
                break;
            }
        }
        return currencyInfo;
    }

    protected void addBalance(BigDecimal[] debits, BigDecimal[] credits, BigDecimal[] balances) {
        if (balances == null) {
            balances = new BigDecimal[4];
        }
        for (int i = 0; i < balances.length; ++i) {
            if (debits[i] != null) {
                if (balances[i] == null) {
                    balances[i] = ZERO;
                }
                balances[i] = balances[i].add(debits[i]);
            }
            if (credits[i] == null) continue;
            if (balances[i] == null) {
                balances[i] = ZERO;
            }
            balances[i] = balances[i].subtract(credits[i]);
        }
    }

    protected int getColumnCount(ReportPartner partner, boolean isShowLocalCuryCol, boolean isShowRptCuryCol) throws EASBizException, BOSException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        Integer columnCountObject = (Integer)partner.getVariable("ColumnCount");
        if (columnCountObject == null) {
            int columnCount = 9;
            if (condition.getOptionShowBusinessDate()) {
                ++columnCount;
            }
            if (condition.getOptionOtherAccount()) {
                columnCount += 2;
            }
            if (isShowLocalCuryCol) {
                columnCount += 4;
            }
            if (isShowRptCuryCol) {
                columnCount += 4;
            }
            if (this.isShowQuantity) {
                columnCount += 9;
            }
            if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
                columnCount += 2;
            }
            columnCount += 2;
            if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
                columnCount += 2;
            }
            if (condition.getOptionShowAccountCusAttribute()) {
                columnCount += 7;
            }
            columnCountObject = new Integer(columnCount);
        }
        return columnCountObject;
    }

    protected Object[] getLineObjects(ReportPartner partner, HashMap rs, BigDecimal[] balances, boolean isShowLocalCuryCol, boolean isShowRptCuryCol, BigDecimal coefficient) throws SQLException, BOSException, EASBizException {
        BigDecimal price;
        BigDecimal qty;
        MeasureUnitInfo measureUnitInfo;
        int index = 0;
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        boolean isRptTransferMeasureUnit = partner.isRptTransferMeasureUnit();
        Object[] row = new Object[this.getColumnCount(partner, isShowLocalCuryCol, isShowRptCuryCol)];
        row[index++] = rs.get("FDate");
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).getOptionShowBusinessDate()) {
            row[index++] = rs.get("FBizDate");
        }
        row[index++] = rs.get("FVoucherNumber");
        int lineType = Integer.parseInt(rs.get("FLineType").toString());
        row[index++] = lineType == 0 ? rs.get("FDescription") : this.getDescription(partner, lineType);
        row[index++] = rs.get("accountName");
        if (partner.getFixCondition().isAllCurrency()) {
            row[index++] = rs.get("FCurrencyName");
        }
        BigDecimal[] debits = new BigDecimal[4];
        BigDecimal[] credits = new BigDecimal[4];
        if (isShowLocalCuryCol) {
            row[index++] = GlUtils.getScaleBigDecimal((BigDecimal)rs.get("FLocalRate"), partner.getScaleRateLocal(partner.getFixCondition().isAllCurrency() ? (rs.get("fcurrencyid") != null ? rs.get("fcurrencyid").toString() : null) : null));
        }
        if (isShowRptCuryCol) {
            row[index++] = GlUtils.getScaleBigDecimal((BigDecimal)rs.get("FRptRate"), partner.getScaleRateRpt(partner.getFixCondition().isAllCurrency() ? (rs.get("fcurrencyid") != null ? rs.get("fcurrencyid").toString() : null) : null));
        }
        debits[1] = (BigDecimal)rs.get("FDebitFor");
        if (this.isShowQuantity) {
            debits[0] = (BigDecimal)rs.get("FDebitQtyDefault");
            measureUnitInfo = null;
            if (lineType == 0) {
                measureUnitInfo = partner.getParmQtyAsst() && partner.getAccountViewInfo().getCAA() != null && !condition.getOptionOnlyAsst() && this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit ? partner.getDefaultMeasureUnitInfoForAccount() : partner.getMeasureUnitInfoForAsst((String)rs.get("FDebitUnitId"));
            } else {
                if (this.isSameCreditUnitGroup && this.isSameDebitUnitGroup && this.isShowUnit) {
                    measureUnitInfo = isRptTransferMeasureUnit && partner.getAccountViewInfo().getCAA() == null ? partner.getDefaultMeasureUnitInfoForAccount() : partner.getBaseMeasureUnitInfoForAccount();
                }
                if (this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit) {
                    measureUnitInfo = partner.getDefaultMeasureUnitInfoForAccount();
                }
            }
            row[index] = measureUnitInfo == null ? null : measureUnitInfo.getName();
            ++index;
            qty = null;
            if (lineType == 0) {
                if (partner.getParmQtyAsst() && partner.getAccountViewInfo().getCAA() != null && !condition.getOptionOnlyAsst() && this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit) {
                    qty = (BigDecimal)rs.get("FDebitQtyDefault");
                    if (qty != null) {
                        qty = qty.divide(coefficient, 4, 4);
                    }
                } else {
                    qty = (BigDecimal)rs.get("FDebitQty");
                }
            } else {
                qty = debits[0];
                if (qty != null) {
                    qty = qty.divide(coefficient, 4, 4);
                }
            }
            row[index++] = this.getBigDecimalForScale(qty, partner.getParmQtyScale());
            if (lineType == 0) {
                price = (BigDecimal)rs.get("FDebitPrice");
                if (price != null && partner.getCurrencyType() != 1 && partner.getCurrencyType() != 2) {
                    if (partner.getParmQtyAsst() && partner.getAccountViewInfo().getCAA() != null && !condition.getOptionOnlyAsst() && this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit && qty != null && qty.compareTo(GlUtils.zero) != 0) {
                        price = ((BigDecimal)rs.get("FDebitFor")).divide(qty, partner.getParmPriceScale(), 4);
                    }
                    row[index++] = this.getBigDecimalForScale(price.abs(), partner.getParmPriceScale());
                }
            } else {
                row[index++] = debits[1] == null || qty == null || debits[1].compareTo(ZERO) == 0 || debits[0].compareTo(ZERO) == 0 || qty == null || qty.compareTo(GlUtils.zero) == 0 ? null : debits[1].divide(qty, partner.getParmPriceScale(), 4).abs();
            }
        }
        int n = ++index;
        ++index;
        row[n] = this.getBigDecimalForScale(debits[1], this.getScaleFor(partner, rs.get("currencyID") != null ? rs.get("currencyID").toString() : null));
        if (isShowLocalCuryCol) {
            debits[2] = (BigDecimal)rs.get("FDebitLocal");
            row[index++] = this.getBigDecimalForScale(debits[2], partner.getScaleLocal());
        }
        if (isShowRptCuryCol) {
            debits[3] = (BigDecimal)rs.get("FDebitRpt");
            row[index++] = this.getBigDecimalForScale(debits[3], partner.getScaleRpt());
        }
        credits[1] = (BigDecimal)rs.get("FCreditFor");
        if (this.isShowQuantity) {
            credits[0] = (BigDecimal)rs.get("FCreditQtyDefault");
            measureUnitInfo = null;
            if (lineType == 0) {
                measureUnitInfo = partner.getParmQtyAsst() && partner.getAccountViewInfo().getCAA() != null && !condition.getOptionOnlyAsst() && this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit ? partner.getDefaultMeasureUnitInfoForAccount() : partner.getMeasureUnitInfoForAsst((String)rs.get("FCreditUnitId"));
            } else {
                if (this.isSameCreditUnitGroup && this.isSameDebitUnitGroup && this.isShowUnit) {
                    measureUnitInfo = isRptTransferMeasureUnit && partner.getAccountViewInfo().getCAA() == null ? partner.getDefaultMeasureUnitInfoForAccount() : partner.getBaseMeasureUnitInfoForAccount();
                }
                if (this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit) {
                    measureUnitInfo = partner.getDefaultMeasureUnitInfoForAccount();
                }
            }
            row[index] = measureUnitInfo == null ? null : measureUnitInfo.getName();
            ++index;
            qty = null;
            if (lineType == 0) {
                if (partner.getParmQtyAsst() && partner.getAccountViewInfo().getCAA() != null && !condition.getOptionOnlyAsst() && this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit) {
                    qty = (BigDecimal)rs.get("FCreditQtyDefault");
                    if (qty != null) {
                        qty = qty.divide(coefficient, 4, 4);
                    }
                } else {
                    qty = (BigDecimal)rs.get("FCreditQty");
                }
            } else {
                qty = debits[0];
                if (qty != null) {
                    qty = qty.divide(coefficient, 4, 4);
                }
            }
            row[index++] = this.getBigDecimalForScale(qty, partner.getParmQtyScale());
            if (lineType == 0) {
                price = (BigDecimal)rs.get("FCreditPrice");
                if (price != null && partner.getCurrencyType() != 1 && partner.getCurrencyType() != 2) {
                    if (partner.getParmQtyAsst() && partner.getAccountViewInfo().getCAA() != null && !condition.getOptionOnlyAsst() && this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit && qty != null && qty.compareTo(GlUtils.zero) != 0) {
                        price = ((BigDecimal)rs.get("FCreditFor")).divide(qty, partner.getParmPriceScale(), 4);
                    }
                    row[index++] = this.getBigDecimalForScale(price.abs(), partner.getParmPriceScale());
                }
            } else {
                row[index++] = credits[1] == null || qty == null || credits[1].compareTo(ZERO) == 0 || credits[0].compareTo(ZERO) == 0 || qty == null || qty.compareTo(GlUtils.zero) == 0 ? null : credits[1].divide(qty, partner.getParmPriceScale(), 4).abs();
            }
        }
        credits[1] = (BigDecimal)rs.get("FCreditFor");
        int n2 = ++index;
        ++index;
        row[n2] = this.getBigDecimalForScale(credits[1], this.getScaleFor(partner, rs.get("currencyID") != null ? rs.get("currencyID").toString() : null));
        if (isShowLocalCuryCol) {
            credits[2] = (BigDecimal)rs.get("FCreditLocal");
            row[index++] = this.getBigDecimalForScale(credits[2], partner.getScaleLocal());
        }
        if (isShowRptCuryCol) {
            credits[3] = (BigDecimal)rs.get("FCreditRpt");
            row[index++] = this.getBigDecimalForScale(credits[3], partner.getScaleRpt());
        }
        if (lineType == 0) {
            this.addBalance(debits, credits, balances);
        }
        if (this.isShowQuantity) {
            measureUnitInfo = null;
            if (this.isSameCreditUnitGroup && this.isSameDebitUnitGroup && this.isShowUnit) {
                measureUnitInfo = partner.getAccountViewInfo().getCAA() == null && partner.isRptTransferMeasureUnit() ? partner.getDefaultMeasureUnitInfoForAccount() : partner.getMeasureUnitInfoForAccount((String)rs.get("FBalanceUnitId"));
            }
            if (lineType != 0) {
                measureUnitInfo = isRptTransferMeasureUnit && partner.getAccountViewInfo().getCAA() == null ? partner.getDefaultMeasureUnitInfoForAccount() : partner.getBaseMeasureUnitInfoForAccount();
            }
            if (this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit) {
                measureUnitInfo = partner.getDefaultMeasureUnitInfoForAccount();
            }
            row[index] = measureUnitInfo == null ? null : measureUnitInfo.getName();
            ++index;
            qty = balances[0];
            if (qty != null) {
                qty = qty.divide(coefficient, 4, 4);
            }
            row[index++] = this.getBigDecimalForScale(qty, partner.getParmQtyScale());
            if (balances[0].compareTo(ZERO) != 0 && qty != null && qty.compareTo(GlUtils.zero) != 0) {
                try {
                    BigDecimal rowendqty = balances[1].divide(qty, partner.getParmPriceScale(), 4).abs();
                    row[index++] = rowendqty;
                }
                catch (ArithmeticException e) {
                    ++index;
                }
            }
        }
        int n3 = ++index;
        row[n3] = partner.getDCString(balances[1]);
        int n4 = ++index;
        row[n4] = this.getBigDecimalForScale(partner.getBalanceForDC(balances[1]), this.getScaleFor(partner, rs.get("currencyID") != null ? rs.get("currencyID").toString() : null));
        if (balances[1] != null && !partner.getBalanceForDC(balances[1]).equals(balances[1]) && this.isShowQuantity && row[++index - 4] != null) {
            row[index - 4] = ((BigDecimal)row[index - 4]).negate();
        }
        if (isShowLocalCuryCol) {
            row[index++] = this.getBigDecimalForScale(partner.getBalanceForDC(balances[2]), partner.getScaleLocal());
        }
        if (isShowRptCuryCol) {
            row[index++] = this.getBigDecimalForScale(partner.getBalanceForDC(balances[3]), partner.getScaleRpt());
        }
        row[index++] = rs.get("FNumber");
        row[index++] = rs.get("FName");
        row[index++] = rs.get("currencyID");
        if (partner.getFixCondition().isAllCurrency()) {
            row[index++] = rs.get("fcurrencyid");
        }
        row[index++] = lineType == -3 ? ReportResultInfo.LINE_YEAR_BEGIN : (lineType == -2 ? ReportResultInfo.LINE_PERIOD_BEGIN : (lineType == -1 ? ReportResultInfo.LINE_DATE_BEGIN : new Integer(lineType)));
        row[index++] = rs.get("FVoucherID");
        return row;
    }

    protected Object[] getLineObjects(ReportPartner partner, ResultSet rs, BigDecimal[] balances, boolean isFirstLine, boolean isShowLocalCuryCol, boolean isShowRptCuryCol, BigDecimal coefficient) throws SQLException, EASBizException, BOSException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        int assiId = 0;
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).getOptionOnlyAsst()) {
            assiId = rs.getInt("FdivisionBalance");
        }
        if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.k == -1 || assiId == 2) {
            RptRowSet rsCount;
            StringBuffer sqlForAsstCount = new StringBuffer();
            sqlForAsstCount.append("SELECT MAX(FCount) FROM  ").append(partner.getTempTableName());
            try {
                rsCount = DBUtilx.executeQuery((String)sqlForAsstCount.toString(), null, (Context)partner.getContext());
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (rsCount.next()) {
                this.k = rsCount.getObject(0) != null ? rsCount.getInt(0) : 0;
            }
        }
        int index = 0;
        Object[] row = new Object[this.getColumnCount(partner, isShowLocalCuryCol, isShowRptCuryCol)];
        if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
            row = new Object[this.getColumnCount(partner, isShowLocalCuryCol, isShowRptCuryCol) + this.k + 6];
        } else if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
            row = new Object[this.getColumnCount(partner, isShowLocalCuryCol, isShowRptCuryCol) + this.k];
        }
        int accountOrAssist = 0;
        if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
            accountOrAssist = rs.getInt("FAccountOrAssist");
        }
        row[index++] = rs.getDate("FDate");
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).getOptionShowBusinessDate()) {
            row[index++] = rs.getDate("FBizDate");
        }
        row[index++] = rs.getString("FVoucherTypeName") == null ? null : rs.getString("FVoucherTypeName") + " - " + rs.getString("FVoucherNumber");
        int lineType = rs.getInt("FLineType");
        Object object = row[index++] = lineType == 0 ? rs.getString("FDescription") : this.getDescription(partner, lineType);
        if (condition.getOptionOtherAccount()) {
            row[index++] = rs.getString("accountName");
        }
        if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
            String asstNameL = null;
            String asstNameD = null;
            String asstNameN = null;
            String[] strAsstNameL = null;
            String[] strAsstNameD = null;
            String[] strAsstNameN = null;
            String number = null;
            int acctTypeFlag = 0;
            if (this.k > 0 && accountOrAssist == 2) {
                if (this.actTypeMap == null) {
                    this.actTypeMap = GLRptHelper.initAcctTypeMap(partner.getContext());
                }
                asstNameL = rs.getString("FAsstAccountName");
                asstNameD = rs.getString("FdisplaynameGroup");
                asstNameN = rs.getString("FNumberGroup");
                if (asstNameL != null) {
                    asstNameL = asstNameL.substring(0, asstNameL.length() - 1);
                    asstNameD = asstNameD.substring(0, asstNameD.length() - 1);
                    asstNameN = asstNameN.substring(0, asstNameN.length() - 1);
                }
                strAsstNameL = StringUtil.split((String)asstNameL, (String)";");
                strAsstNameD = StringUtil.split((String)asstNameD, (String)";");
                strAsstNameN = StringUtil.split((String)asstNameN, (String)";");
            }
            for (int i = 0; i < this.k; ++i) {
                if (accountOrAssist == 2) {
                    if (strAsstNameL != null && strAsstNameL.length > i) {
                        if (number == null && this.actTypeMap.get(number = strAsstNameN[i].substring(0, strAsstNameN[i].indexOf("_!"))) != null) {
                            acctTypeFlag = this.actTypeMap.get(number);
                        }
                        row[index++] = GLRptHelper.getAssDisplayName(partner.isParmAssitemShowNumber(), partner.isRptShowLongNameFromGeneral(), partner.isRptShowLongNumberFromGeneral(), acctTypeFlag, strAsstNameL[i], strAsstNameD[i], strAsstNameN[i]);
                        continue;
                    }
                    row[index++] = "";
                    continue;
                }
                row[index++] = "";
            }
        }
        if (condition.isAllCurrency()) {
            row[index++] = rs.getString("FCurrencyName");
        }
        boolean isRptTransferMeasureUnit = partner.isRptTransferMeasureUnit();
        if (isFirstLine || lineType == -2 || lineType == -3) {
            if (isShowLocalCuryCol) {
                index += 3;
            }
            if (isShowRptCuryCol) {
                index += 3;
            }
            if (this.isShowQuantity) {
                index += 6;
            }
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                index += 6;
            }
            index += 2;
            if (this.isShowQuantity) {
                MeasureUnitInfo measureUnitInfo = null;
                if (this.isSameCreditUnitGroup && this.isSameDebitUnitGroup && this.isShowUnit) {
                    measureUnitInfo = isRptTransferMeasureUnit && partner.getAccountViewInfo().getCAA() == null ? partner.getDefaultMeasureUnitInfoForAccount() : partner.getBaseMeasureUnitInfoForAccount();
                }
                if (this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit || this.isAccountQty) {
                    measureUnitInfo = partner.getDefaultMeasureUnitInfoForAccount();
                }
                if (partner.getParmQtyAsst() && ((ReportConditionSubsidiaryLedgerAssist)partner.getFixCondition()).getAssistItem().size() == 0) {
                    measureUnitInfo = this.accountingMeasureUnitInfo;
                }
                row[index] = measureUnitInfo == null ? null : measureUnitInfo.getName();
                ++index;
                BigDecimal endQty = this.getBigDecimalForScale(balances[0], partner.getParmQtyScale());
                if (endQty != null) {
                    endQty = endQty.divide(coefficient, partner.getParmQtyScale(), 4);
                }
                row[index++] = endQty;
                if (balances[0].compareTo(ZERO) != 0 && endQty != null && endQty.compareTo(GlUtils.zero) != 0) {
                    row[index++] = balances[1].divide(endQty, partner.getParmPriceScale(), 4).abs();
                }
            }
            int n = ++index;
            row[n] = partner.getDCString(balances[1]);
            int n2 = ++index;
            row[n2] = this.getBigDecimalForScale(partner.getBalanceForDC(balances[1]), this.getScaleFor(partner, condition.isAllCurrency() ? rs.getString("fcurrencyid") : null));
            if (balances[1] != null && !partner.getBalanceForDC(balances[1]).equals(balances[1]) && this.isShowQuantity && row[++index - 4] != null) {
                row[index - 4] = ((BigDecimal)row[index - 4]).negate();
            }
            if (isShowLocalCuryCol) {
                balances[2] = rs.getBigDecimal("FDebitLocal");
                row[index++] = partner.TITLE_BALANCE.equals(partner.getDCString(balances[1])) || partner.getDCString(balances[1]).equals(partner.getDCString(balances[2])) ? this.getBigDecimalForScale(partner.getBalanceForDC(balances[2]), partner.getScaleLocal()) : this.getBigDecimalForScale(partner.getBalanceForDC(balances[2]), partner.getScaleLocal()).negate();
            }
            if (isShowRptCuryCol) {
                balances[3] = rs.getBigDecimal("FDebitRpt");
                row[index++] = partner.TITLE_BALANCE.equals(partner.getDCString(balances[1])) || partner.getDCString(balances[1]).equals(partner.getDCString(balances[3])) ? this.getBigDecimalForScale(partner.getBalanceForDC(balances[3]), partner.getScaleRpt()) : this.getBigDecimalForScale(partner.getBalanceForDC(balances[3]), partner.getScaleRpt()).negate();
            }
        } else {
            BigDecimal price;
            BigDecimal qty;
            Object measureUnitInfo;
            BigDecimal[] debits = new BigDecimal[4];
            BigDecimal[] credits = new BigDecimal[4];
            if (isShowLocalCuryCol) {
                row[index++] = GlUtils.getScaleBigDecimal(rs.getBigDecimal("FLocalRate"), partner.getScaleRateLocal(condition.isAllCurrency() ? rs.getString("fcurrencyid") : null));
            }
            if (isShowRptCuryCol) {
                row[index++] = GlUtils.getScaleBigDecimal(rs.getBigDecimal("FRptRate"), partner.getScaleRateRpt(condition.isAllCurrency() ? rs.getString("fcurrencyid") : null));
            }
            debits[1] = rs.getBigDecimal("FDebitFor");
            if (this.isShowQuantity) {
                debits[0] = rs.getBigDecimal("FDebitQtyDefault");
                measureUnitInfo = null;
                if (lineType == 0) {
                    measureUnitInfo = partner.getParmQtyAsst() && partner.getAccountViewInfo().getCAA() != null && !condition.getOptionOnlyAsst() && this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit ? partner.getDefaultMeasureUnitInfoForAccount() : partner.getMeasureUnitInfoForAsst(rs.getString("FDebitUnitId"));
                } else {
                    if (this.isSameCreditUnitGroup && this.isSameDebitUnitGroup && this.isShowUnit) {
                        measureUnitInfo = isRptTransferMeasureUnit && partner.getAccountViewInfo().getCAA() == null ? partner.getDefaultMeasureUnitInfoForAccount() : partner.getBaseMeasureUnitInfoForAccount();
                    }
                    if (this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit || this.isAccountQty) {
                        measureUnitInfo = partner.getDefaultMeasureUnitInfoForAccount();
                    }
                    if (partner.getParmQtyAsst() && ((ReportConditionSubsidiaryLedgerAssist)partner.getFixCondition()).getAssistItem().size() == 0) {
                        measureUnitInfo = this.accountingMeasureUnitInfo;
                    }
                }
                row[index] = measureUnitInfo == null ? null : measureUnitInfo.getName();
                ++index;
                qty = null;
                if (lineType == 0) {
                    if (partner.getParmQtyAsst() && partner.getAccountViewInfo().getCAA() != null && !condition.getOptionOnlyAsst() && this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit) {
                        qty = rs.getBigDecimal("FDebitQtyDefault");
                        if (qty != null) {
                            qty = qty.divide(coefficient, partner.getParmQtyScale(), 4);
                        }
                    } else {
                        qty = rs.getBigDecimal("FDebitQty");
                    }
                } else {
                    qty = debits[0];
                    if (qty != null) {
                        qty = qty.divide(coefficient, partner.getParmQtyScale(), 4);
                    }
                }
                row[index++] = this.getBigDecimalForScale(qty, partner.getParmQtyScale());
                if (lineType == 0) {
                    price = rs.getBigDecimal("FDebitPrice");
                    if (price == null || partner.getCurrencyType() == 1 || partner.getCurrencyType() == 2) {
                        ++index;
                    } else {
                        if (partner.getParmQtyAsst() && partner.getAccountViewInfo().getCAA() != null && !condition.getOptionOnlyAsst() && this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit && qty != null && qty.compareTo(GlUtils.zero) != 0) {
                            price = rs.getBigDecimal("FDebitFor").divide(qty, partner.getParmPriceScale(), 4);
                        }
                        row[index++] = this.getBigDecimalForScale(price.abs(), partner.getParmPriceScale());
                    }
                } else {
                    row[index++] = debits[1] == null || debits[0] == null || debits[1].compareTo(ZERO) == 0 || debits[0].compareTo(ZERO) == 0 || qty == null || qty.compareTo(GlUtils.zero) == 0 ? null : debits[1].divide(qty, partner.getParmPriceScale(), 4).abs();
                }
                if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                    row[index++] = rs.getString("FDebitAssistUnit");
                    row[index++] = rs.getBigDecimal("FDebitAssistPrice");
                    row[index++] = rs.getBigDecimal("FDebitAssistQty");
                }
            }
            row[index++] = this.getBigDecimalForScale(debits[1], this.getScaleFor(partner, condition.isAllCurrency() ? rs.getString("fcurrencyid") : null));
            if (isShowLocalCuryCol) {
                debits[2] = rs.getBigDecimal("FDebitLocal");
                row[index++] = this.getBigDecimalForScale(debits[2], partner.getScaleLocal());
            }
            if (isShowRptCuryCol) {
                debits[3] = rs.getBigDecimal("FDebitRpt");
                row[index++] = this.getBigDecimalForScale(debits[3], partner.getScaleRpt());
            }
            credits[1] = rs.getBigDecimal("FCreditFor");
            if (this.isShowQuantity) {
                credits[0] = rs.getBigDecimal("FCreditQtyDefault");
                measureUnitInfo = null;
                if (lineType == 0) {
                    measureUnitInfo = partner.getParmQtyAsst() && partner.getAccountViewInfo().getCAA() != null && !condition.getOptionOnlyAsst() && this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit ? partner.getDefaultMeasureUnitInfoForAccount() : (partner.getParmQtyAsst() && partner.getAccountViewInfo().getCAA() != null && !condition.getOptionOnlyAsst() ? null : partner.getMeasureUnitInfoForAsst(rs.getString("FCreditUnitId")));
                } else {
                    if (this.isSameCreditUnitGroup && this.isSameDebitUnitGroup && this.isShowUnit) {
                        measureUnitInfo = isRptTransferMeasureUnit && partner.getAccountViewInfo().getCAA() == null ? partner.getDefaultMeasureUnitInfoForAccount() : partner.getBaseMeasureUnitInfoForAccount();
                    }
                    if (this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit || this.isAccountQty) {
                        measureUnitInfo = partner.getDefaultMeasureUnitInfoForAccount();
                    }
                    if (partner.getParmQtyAsst() && ((ReportConditionSubsidiaryLedgerAssist)partner.getFixCondition()).getAssistItem().size() == 0) {
                        measureUnitInfo = this.accountingMeasureUnitInfo;
                    }
                }
                row[index] = measureUnitInfo == null ? null : measureUnitInfo.getName();
                ++index;
                qty = null;
                if (lineType == 0) {
                    if (partner.getParmQtyAsst() && partner.getAccountViewInfo().getCAA() != null && !condition.getOptionOnlyAsst() && this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit) {
                        qty = rs.getBigDecimal("FCreditQtyDefault");
                        if (qty != null) {
                            qty = qty.divide(coefficient, partner.getParmQtyScale(), 4);
                        }
                    } else {
                        qty = rs.getBigDecimal("FCreditQty");
                    }
                } else {
                    qty = credits[0];
                    if (qty != null) {
                        qty = qty.divide(coefficient, partner.getParmQtyScale(), 4);
                    }
                }
                row[index++] = this.getBigDecimalForScale(qty, partner.getParmQtyScale());
                if (lineType == 0) {
                    price = rs.getBigDecimal("FCreditPrice");
                    if (price == null || partner.getCurrencyType() == 1 || partner.getCurrencyType() == 2) {
                        ++index;
                    } else {
                        if (partner.getParmQtyAsst() && partner.getAccountViewInfo().getCAA() != null && !condition.getOptionOnlyAsst() && this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit && qty != null && qty.compareTo(GlUtils.zero) != 0) {
                            price = rs.getBigDecimal("FCreditFor").divide(qty, partner.getParmPriceScale(), 4);
                        }
                        row[index++] = this.getBigDecimalForScale(price.abs(), partner.getParmPriceScale());
                    }
                } else {
                    row[index++] = credits[1] == null || credits[0] == null || credits[1].compareTo(ZERO) == 0 || credits[0].compareTo(ZERO) == 0 || qty == null || qty.compareTo(GlUtils.zero) == 0 ? null : credits[1].divide(qty, partner.getParmPriceScale(), 4).abs();
                }
                if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.getPar(partner)) {
                    row[index++] = rs.getString("FCreditAssistUnit");
                    row[index++] = rs.getBigDecimal("FCreditAssistPrice");
                    row[index++] = rs.getBigDecimal("FCreditAssistQty");
                }
            }
            credits[1] = rs.getBigDecimal("FCreditFor");
            row[index++] = this.getBigDecimalForScale(credits[1], this.getScaleFor(partner, condition.isAllCurrency() ? rs.getString("fcurrencyid") : null));
            if (isShowLocalCuryCol) {
                credits[2] = rs.getBigDecimal("FCreditLocal");
                row[index++] = this.getBigDecimalForScale(credits[2], partner.getScaleLocal());
            }
            if (isShowRptCuryCol) {
                credits[3] = rs.getBigDecimal("FCreditRpt");
                row[index++] = this.getBigDecimalForScale(credits[3], partner.getScaleRpt());
            }
            if (lineType == 0) {
                this.addBalance(debits, credits, balances);
            }
            if (this.isShowQuantity) {
                measureUnitInfo = null;
                if (this.isSameCreditUnitGroup && this.isSameDebitUnitGroup && this.isShowUnit) {
                    measureUnitInfo = partner.getAccountViewInfo().getCAA() == null && partner.isRptTransferMeasureUnit() ? partner.getDefaultMeasureUnitInfoForAccount() : partner.getMeasureUnitInfoForAccount(rs.getString("FBalanceUnitId"));
                }
                if (lineType != 0) {
                    measureUnitInfo = isRptTransferMeasureUnit && partner.getAccountViewInfo().getCAA() == null ? partner.getDefaultMeasureUnitInfoForAccount() : partner.getBaseMeasureUnitInfoForAccount();
                }
                if (this.isTransAccountDefaultMu && partner.getDefaultMeasureUnitInfoForAccount() != null && this.isShowUnit || this.isAccountQty) {
                    measureUnitInfo = partner.getDefaultMeasureUnitInfoForAccount();
                }
                if (partner.getParmQtyAsst() && ((ReportConditionSubsidiaryLedgerAssist)partner.getFixCondition()).getAssistItem().size() == 0) {
                    measureUnitInfo = this.accountingMeasureUnitInfo;
                }
                row[index] = measureUnitInfo == null ? null : measureUnitInfo.getName();
                ++index;
                qty = balances[0];
                if (qty != null) {
                    qty = qty.divide(coefficient, partner.getParmQtyScale(), 4);
                }
                row[index++] = this.getBigDecimalForScale(qty, partner.getParmQtyScale());
                if (balances[0].compareTo(ZERO) != 0 && qty != null && qty.compareTo(GlUtils.zero) != 0) {
                    try {
                        BigDecimal rowendqty = balances[1].divide(qty, partner.getParmPriceScale(), 4).abs();
                        row[index++] = rowendqty;
                    }
                    catch (ArithmeticException e) {
                        ++index;
                    }
                }
            }
            int n = ++index;
            row[n] = partner.getDCString(balances[1]);
            int n3 = ++index;
            row[n3] = this.getBigDecimalForScale(partner.getBalanceForDC(balances[1]), this.getScaleFor(partner, condition.isAllCurrency() ? rs.getString("fcurrencyid") : null));
            if (balances[1] != null && !partner.getBalanceForDC(balances[1]).equals(balances[1]) && this.isShowQuantity && row[++index - 4] != null) {
                row[index - 4] = ((BigDecimal)row[index - 4]).negate();
            }
            if (isShowLocalCuryCol) {
                row[index++] = partner.TITLE_BALANCE.equals(partner.getDCString(balances[1])) || partner.getDCString(balances[1]).equals(partner.getDCString(balances[2])) ? this.getBigDecimalForScale(partner.getBalanceForDC(balances[2]), partner.getScaleLocal()) : this.getBigDecimalForScale(partner.getBalanceForDC(balances[2]), partner.getScaleLocal()).negate();
            }
            if (isShowRptCuryCol) {
                row[index++] = partner.TITLE_BALANCE.equals(partner.getDCString(balances[1])) || partner.getDCString(balances[1]).equals(partner.getDCString(balances[3])) ? this.getBigDecimalForScale(partner.getBalanceForDC(balances[3]), partner.getScaleRpt()) : this.getBigDecimalForScale(partner.getBalanceForDC(balances[3]), partner.getScaleRpt()).negate();
            }
        }
        if (condition.getOptionShowAccountCusAttribute()) {
            row[index++] = rs.getString("FBizNumber");
            row[index++] = rs.getString("FFeeType");
            row[index++] = rs.getString("FHandler");
            row[index++] = rs.getString("FInvoiceNumber");
            row[index++] = rs.getString("FSettlementCode");
            row[index++] = rs.getString("FSettlementType");
            row[index++] = rs.getString("FTicketNumber");
        }
        row[index++] = rs.getString("FNumber");
        row[index++] = rs.getString("FName");
        if (condition.getOptionOtherAccount()) {
            row[index++] = rs.getString("currencyID");
        }
        if (condition.isAllCurrency()) {
            row[index++] = rs.getString("fcurrencyid");
        }
        if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
            String numberGroupAsst = rs.getString("FNumberGroupAsst");
            row[index++] = numberGroupAsst == null ? null : numberGroupAsst;
            String asstId = rs.getString("FAsstAccountPerId");
            row[index++] = asstId == null ? null : asstId;
        }
        row[index++] = lineType == -3 ? ReportResultInfo.LINE_YEAR_BEGIN : (lineType == -2 ? ReportResultInfo.LINE_PERIOD_BEGIN : (lineType == -1 ? ReportResultInfo.LINE_DATE_BEGIN : new Integer(lineType)));
        row[index++] = rs.getString("FVoucherID");
        return row;
    }

    @Override
    protected Object[] getLineObjects(ReportPartner partner, ResultSet rs) throws SQLException, EASBizException, BOSException {
        return null;
    }

    protected String getDescription(ReportPartner partner, int lineType) {
        String description = null;
        switch (lineType) {
            case -3: {
                description = partner.TITLE_YEAR_START;
                break;
            }
            case -2: {
                description = partner.TITLE_PERIOD_START;
                break;
            }
            case 1: {
                description = partner.TITLE_DAY_SUM;
                break;
            }
            case 2: {
                description = partner.TITLE_DAY_SUM;
                break;
            }
            case 3: {
                description = partner.TITLE_PERIOD_SUM;
                break;
            }
            case 4: {
                description = partner.TITLE_YEAR_SUM;
                break;
            }
            default: {
                description = "UnKnow Line Type";
            }
        }
        return description;
    }

    @Override
    protected CurrencyCollection getAllCurrency(ReportPartner partner) throws BOSException, EASBizException {
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)partner.getContext());
        CurrencyCollection currencyCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("sign"));
        sic.add(new SelectorItemInfo("BaseUnit"));
        if (partner.isParmForeignCurrencySu()) {
            currencyCollection = currency.getCurrencyCollection(view, true);
        } else {
            if (!partner.isParmUseReportCurrency()) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID, CompareType.NOTEQUALS));
                view.setFilter(filter);
            }
            currencyCollection = currency.getCurrencyCollection(view, false);
        }
        return currencyCollection;
    }

    @Override
    protected CurrencyInfo getDefaultCurrency(ReportPartner partner) throws BOSException, EASBizException {
        return partner.getCompany().getBaseCurrency();
    }

    protected String getTempTableStruct(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        boolean isQtyAsst = partner.getParmQtyAsst();
        this.isShowQuantity = this.getIsShowQuantity(partner);
        StringBuffer sql = new StringBuffer();
        sql.append("( \r\n");
        if (HAS_KSQL_SEQ.equals(partner.getVariable(HAS_KSQL_SEQ))) {
            sql.append("\tKSQL_SEQ INT IDENTITY (1, 1), \r\n");
        }
        sql.append("\tFDate DateTime, \r\n");
        sql.append("\tFBizDate DateTime, \r\n");
        sql.append("\tFVoucherNumber NVarchar(100), \r\n");
        sql.append("\tFVoucherTypeNumber NVarchar(80), \r\n");
        sql.append("\tFVoucherTypeName NVarchar(80), \r\n");
        sql.append("\tFCREATETIME DateTime, \r\n");
        sql.append("    FSeq Int,\r\n");
        sql.append("\tFDescription NVarchar(320), \r\n");
        if (condition.getOptionOtherAccount()) {
            sql.append("\taccountName NVarchar(640), \r\n");
            sql.append("\taccountLongNumber NVarchar(400), \r\n");
            sql.append("\tcurrencyID varChar(44),\r\n");
            sql.append("FAccounttableid varChar(44),\r\n");
            sql.append("FSOURCETYPE Int,\r\n");
        }
        sql.append("\tFSettlementType NVarchar(320), \r\n");
        sql.append("\tFSettlementCode NVarchar(320), \r\n");
        sql.append("\tFBizNumber NVarchar(320), \r\n");
        sql.append("\tFTicketNumber NVARCHAR(320), \r\n");
        sql.append("\tFInvoiceNumber NVARCHAR(320) , \r\n");
        sql.append("\tFFeeType NVARCHAR(320) , \r\n");
        sql.append("\tFHandler NVARCHAR(320) , \r\n");
        sql.append("\tFLocalRate Decimal(28,10), \r\n");
        sql.append("\tFRptRate Decimal(28,10), \r\n");
        if (this.isShowQuantity) {
            sql.append(" FDebitUnitId varChar(44),\r\n");
            sql.append(" FCreditUnitId varChar(44),\r\n");
            sql.append(" FDebitQty Decimal(28,10), \r\n");
            sql.append(" FCreditQty Decimal(28,10), \r\n");
            sql.append(" FDebitQtyDefault Decimal(28,10), \r\n");
            sql.append(" FCreditQtyDefault Decimal(28,10), \r\n");
            sql.append(" FDebitPrice Decimal(28,10), \r\n");
            sql.append(" FCreditPrice Decimal(28,10), \r\n");
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                sql.append(" FDebitAssistUnit varChar(44),\r\n");
                sql.append(" FCreditAssistUnit varChar(44),\r\n");
                sql.append(" FDebitAssistPrice Decimal(28,10), \r\n");
                sql.append(" FCreditAssistPrice Decimal(28,10), \r\n");
                sql.append(" FDebitAssistQty Decimal(28,10), \r\n");
                sql.append(" FCreditAssistQty Decimal(28,10), \r\n");
            }
        }
        sql.append("\tFDebitFor Decimal(28,10), \r\n");
        sql.append("\tFCreditFor Decimal(28,10), \r\n");
        sql.append("\tFDebitLocal Decimal(28,10), \r\n");
        sql.append("\tFCreditLocal Decimal(28,10), \r\n");
        sql.append("\tFDebitRpt Decimal(28,10), \r\n");
        sql.append("\tFCreditRpt Decimal(28,10), \r\n");
        sql.append("\tFBalanceUnitId varChar(44), \r\n");
        sql.append("\tFLineType Int, \r\n");
        sql.append("\tFVoucherID varChar(44), \r\n");
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
            sql.append("    FCurrencyid varChar(44), \r\n");
        }
        sql.append("\tFPeriodYear Int, \r\n");
        sql.append("\tFNumber NVarchar(640),  \r\n ");
        sql.append("\tFName NVarchar(640),  \r\n ");
        if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
            sql.append("  FPeriodNumber Int,  \r\n ");
            sql.append("  FAccountOrAssist Int,  \r\n");
            sql.append("  FAsstAccountPerId  varChar(44)\r\n");
            sql.append(" \t,FdivisionBalance Int  \r\n");
            sql.append("   ,FNumberGroupAsst NVARCHAR(500), \r\n");
            sql.append("  FCount Int, \r\n ");
            sql.append("  FdisplaynameGroup NVARCHAR(500), \r\n");
            sql.append("  FNumberGroup NVARCHAR(500), \r\n");
            sql.append("  FAsstAccountName NVARCHAR(500) )\r\n");
        } else {
            sql.append("\tFPeriodNumber Int  \r\n )");
        }
        return sql.toString();
    }

    private String getTempTableColumns(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        boolean isQtyAsst = partner.getParmQtyAsst();
        this.isShowQuantity = this.getIsShowQuantity(partner);
        StringBuffer sql = new StringBuffer();
        sql.append("(");
        if (HAS_KSQL_SEQ.equals(partner.getVariable(HAS_KSQL_SEQ))) {
            sql.append("KSQL_SEQ, ");
        }
        sql.append("FDate, ");
        sql.append("FBizDate, ");
        sql.append("FVoucherNumber, ");
        sql.append("FVoucherTypeNumber, ");
        sql.append("FVoucherTypeName, ");
        sql.append("FCREATETIME, ");
        sql.append("FSeq, ");
        sql.append("FDescription, ");
        if (condition.getOptionOtherAccount()) {
            sql.append("accountName, ");
            sql.append("accountLongNumber, ");
            sql.append("currencyID, ");
            sql.append("FAccounttableid,\r\n");
            sql.append("FSOURCETYPE,\r\n");
        }
        sql.append("FSettlementType, ");
        sql.append("FSettlementCode, ");
        sql.append("FBizNumber, ");
        sql.append("FTicketNumber, ");
        sql.append("FInvoiceNumber, ");
        sql.append("FFeeType, ");
        sql.append("FHandler, ");
        sql.append("FLocalRate, ");
        sql.append("FRptRate, ");
        if (this.isShowQuantity) {
            sql.append("FDebitUnitId, ");
            sql.append("FCreditUnitId, ");
            sql.append("FDebitQty, ");
            sql.append("FCreditQty, ");
            sql.append("FDebitQtyDefault, ");
            sql.append("FCreditQtyDefault, ");
            sql.append("FDebitPrice, ");
            sql.append("FCreditPrice, ");
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                sql.append(" FDebitAssistUnit,\r\n");
                sql.append(" FCreditAssistUnit,\r\n");
                sql.append(" FDebitAssistPrice, \r\n");
                sql.append(" FCreditAssistPrice, \r\n");
                sql.append(" FDebitAssistQty, \r\n");
                sql.append(" FCreditAssistQty, \r\n");
            }
        }
        sql.append("FDebitFor, ");
        sql.append("FCreditFor, ");
        sql.append("FDebitLocal, ");
        sql.append("FCreditLocal, ");
        sql.append("FDebitRpt, ");
        sql.append("FCreditRpt, ");
        sql.append("FBalanceUnitId, ");
        sql.append("FLineType, ");
        sql.append("FVoucherID, ");
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
            sql.append("FCurrencyid, ");
        }
        sql.append("FPeriodYear, ");
        sql.append("FNumber, ");
        sql.append("FName, ");
        if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
            sql.append("FPeriodNumber, ");
            sql.append("FAccountOrAssist, ");
            sql.append("  FAsstAccountPerId ");
            sql.append(" \t,FdivisionBalance  \r\n");
            sql.append("   ,FNumberGroupAsst, \r\n");
            sql.append("FCount, ");
            sql.append("FdisplaynameGroup, ");
            sql.append("FNumberGroup, ");
            sql.append("FAsstAccountName )");
        } else {
            sql.append("FPeriodNumber )");
        }
        return sql.toString();
    }

    @Override
    protected void insertDataIntoTempTable(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        partner.setTempTableName(partner.createTempTableAsynchronism("GLSL", this.getTempTableStruct(partner)));
        boolean isShowAsst = condition.getOptionOnlyAsst() || condition.getAssisthgId() != null;
        HashMap mapStartBalance = null;
        mapStartBalance = isShowAsst ? this.getStartAsstBalance(partner) : this.getStartBalance(partner);
        this.insertStartBalance(mapStartBalance, partner);
        if (isShowAsst || condition.getOptionShowAccountCusAttribute()) {
            this.insertVoucherOrAsst(partner);
        } else if (condition.getOptionOtherAccount()) {
            this.insertVoucherEntry(partner);
        } else {
            this.insertSelfVoucherEntry(partner);
        }
        if (condition.getOptionDailyTotal()) {
            this.insertDailySum(partner);
        }
        this.insertPeriodSum(partner);
        this.insertYearSum(mapStartBalance, partner);
        this.addSeqColToTable(partner);
    }

    protected void addSeqColToTable(ReportPartner partner) throws EASBizException, BOSException {
        partner.setVariable(HAS_KSQL_SEQ, HAS_KSQL_SEQ);
        String tableStruct = this.getTempTableStruct(partner);
        String tableColumns = this.getTempTableColumns(partner);
        partner.setVariable(HAS_KSQL_SEQ, null);
        String oldTempTable = partner.getTempTableName();
        String newTempTable = partner.createTempTableAsynchronism("GLSL", tableStruct);
        StringBuffer sql = new StringBuffer("INSERT INTO ").append(newTempTable).append(" \r\n").append(tableColumns).append(" \r\n").append(" (SELECT t.* FROM ").append(oldTempTable).append(" T ");
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
            sql.append(" inner join t_bd_currency cc on cc.fid = t.fcurrencyid \r\n");
        }
        sql.append(this.getSqlForDataOrder(partner)).append(")");
        try {
            partner.executeSql(sql.toString(), null);
        }
        catch (RuntimeException e) {
            logger.error((Object)e);
            throw e;
        }
        partner.setTempTableName(newTempTable);
        partner.dropTempTableAsynchronism(oldTempTable);
    }

    protected boolean insertDailySum(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        boolean isQtyAsst = partner.getParmQtyAsst();
        this.isShowQuantity = this.getIsShowQuantity(partner);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append("\t(FDate, FDebitFor, FCreditFor,  \r\n");
        sql.append("\t FDebitLocal,FCreditLocal, \r\n");
        sql.append("\t FDebitRpt,FCreditRpt ,\r\n");
        if (this.isShowQuantity) {
            sql.append("FDebitQtyDefault,FCreditQtyDefault, \r\n");
        }
        if (condition.isAllCurrency()) {
            sql.append("FCurrencyid,\r\n");
        }
        sql.append(" FLineType,FPeriodYear, FPeriodNumber) \r\n");
        sql.append("SELECT FDate, \r\n");
        sql.append("\tSUM(FDebitFor) FDebitFor,SUM(FCreditFor) FCreditFor, \r\n");
        sql.append("\tSUM(FDebitLocal) FDebitLocal, SUM(FCreditLocal) FCreditLocal, \r\n");
        sql.append("\tSUM(FDebitRpt) FDebitRpt, SUM(FCreditRpt) FCreditRpt, \r\n");
        if (this.isShowQuantity) {
            sql.append("SUM(FDebitQtyDefault) FDebitQtyDefault, \r\n");
            sql.append("SUM(FCreditQtyDefault) FCreditQtyDefault, \r\n");
        }
        if (condition.isAllCurrency()) {
            sql.append("FCurrencyid, \r\n");
        }
        sql.append("\t1 FLineType,FPeriodYear, FPeriodNumber \r\n");
        sql.append("FROM ");
        sql.append(partner.getTempTableName());
        sql.append(" WHERE FLineType = 0 \r\n");
        if (condition.getOptionOtherAccount()) {
            sql.append(" and accountLongNumber like '").append(partner.getAccountViewInfo().getLongNumber()).append("%' \r\n");
        }
        if (condition.getOptionOtherAccount() && partner.getCurrencyType() == 0 && !condition.isAllCurrency()) {
            sql.append(" and currencyid = '").append(condition.getCurrencyID()).append("' \r\n");
        }
        sql.append("GROUP BY FDate,FPeriodYear, FPeriodNumber \r\n");
        if (condition.isAllCurrency()) {
            sql.append(",FCurrencyid \r\n");
        }
        return partner.executeSql(sql.toString(), null);
    }

    protected void insertPeriodSum(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append("\t(FDate, FDebitFor, FCreditFor,  \r\n");
        sql.append("\t FDebitLocal,FCreditLocal, \r\n");
        sql.append("\t FDebitRpt,FCreditRpt ,\r\n");
        if (this.isShowQuantity) {
            sql.append("FDebitQtyDefault,FCreditQtyDefault, \r\n");
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                sql.append(" FCreditAssistPrice, \r\n");
                sql.append(" FCreditAssistQty, \r\n");
            }
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                sql.append(" FDebitAssistPrice, \r\n");
                sql.append(" FDebitAssistQty, \r\n");
            }
        }
        if (condition.isAllCurrency()) {
            sql.append("FCurrencyid,\r\n");
        }
        sql.append("\tFLineType,FPeriodYear, FPeriodNumber) \r\n");
        sql.append("SELECT TBP.FEndDate FDate, \r\n");
        if (condition.isAllCurrency()) {
            sql.append("\tSUM(case when cc.fid is null then 0.0 else FDebitFor end) FDebitFor,   SUM(case when cc.fid is null then 0.0 else FCreditFor end) FCreditFor, \r\n");
            sql.append("\tSUM(case when cc.fid is null then 0.0 else FDebitLocal end) FDebitLocal,    SUM(case when cc.fid is null then 0.0 else FCreditLocal end) FCreditLocal, \r\n");
            sql.append("\tSUM(case when cc.fid is null then 0.0 else FDebitRpt end) FDebitRpt, \tSUM(case when cc.fid is null then 0.0 else FCreditRpt end) FCreditRpt, \r\n");
            if (this.isShowQuantity) {
                sql.append("SUM(case when cc.fid is null then 0.0 else FDebitQtyDefault end) FDebitQtyDefault, \r\n");
                sql.append("SUM(case when cc.fid is null then 0.0 else FCreditQtyDefault end) FCreditQtyDefault, \r\n");
                if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                    sql.append(" (case when SUM(case when cc.fid is null then 0.0 else FCreditAssistQty end)=0 then null else SUM(case when cc.fid is null then 0.0 else FCreditFor end)/SUM(case when cc.fid is null then 0.0 else FCreditAssistQty end) end) FCreditAssistPrice, \r\n");
                    sql.append(" SUM(case when cc.fid is null then 0.0 else FCreditAssistQty end) FCreditAssistQty, \r\n");
                }
                if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                    sql.append(" (case when SUM(case when cc.fid is null then 0.0 else FDebitAssistQty end)=0 then null else SUM(case when cc.fid is null then 0.0 else FDebitFor end)/SUM(case when cc.fid is null then 0.0 else FDebitAssistQty end) end) FDebitAssistPrice, \r\n");
                    sql.append(" SUM(case when cc.fid is null then 0.0 else FDebitAssistQty end) FDebitAssistQty, \r\n");
                }
            }
        } else {
            sql.append("\tSUM(FDebitFor) FDebitFor,SUM(FCreditFor) FCreditFor, \r\n");
            sql.append("\tSUM(FDebitLocal) FDebitLocal, SUM(FCreditLocal) FCreditLocal, \r\n");
            sql.append("\tSUM(FDebitRpt) FDebitRpt, SUM(FCreditRpt) FCreditRpt, \r\n");
            if (this.isShowQuantity) {
                sql.append("SUM(FDebitQtyDefault) FDebitQtyDefault, \r\n");
                sql.append("SUM(FCreditQtyDefault) FCreditQtyDefault, \r\n");
                if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                    sql.append(" (case when SUM(isnull(FCreditAssistQty,0))=0 then null else SUM(FCreditFor)/SUM(isnull(FCreditAssistQty,0)) end) FCreditAssistPrice, \r\n");
                    sql.append(" SUM(FCreditAssistQty) FCreditAssistQty, \r\n");
                }
                if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                    sql.append(" (case when SUM(isnull(FDebitAssistQty,0))=0 then null else SUM(FDebitFor)/SUM(isnull(FDebitAssistQty,0)) end) FDebitAssistPrice, \r\n");
                    sql.append(" SUM(FDebitAssistQty) FDebitAssistQty, \r\n");
                }
            }
        }
        if (condition.isAllCurrency()) {
            sql.append("TP.FCurrencyid,\r\n");
        }
        sql.append("\t3 FLineType,TBP.FPeriodYear, TBP.FPeriodNumber \r\n");
        sql.append("FROM T_BD_PERIOD TBP \r\n");
        sql.append("\tLEFT OUTER JOIN  ");
        sql.append(partner.getTempTableName());
        sql.append(" TP ON 1 = 1 \r\n");
        if (!condition.getOptionNoDisplayZeroTotal() && condition.isAllCurrency()) {
            sql.append(" left join t_bd_currency cc on cc.fid = tp.fcurrencyid ");
        }
        sql.append(" AND TP.FPeriodYear = TBP.FPeriodYear \r\n");
        sql.append("\t\tAND TP.FPeriodNumber = TBP.FPeriodNumber \r\n");
        sql.append("\t\tAND TP.FLineType = 0 \r\n");
        if (condition.getOptionNoDisplayZeroTotal() && condition.isAllCurrency()) {
            sql.append(" left join t_bd_currency cc on cc.fid = tp.fcurrencyid ");
        }
        sql.append("WHERE TBP.FTypeID = '").append(partner.getCompany().getAccountPeriodType().getId().toString()).append("' \r\n");
        int[] periodRange = new int[]{condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart(), condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()};
        sql.append(" AND ");
        sql.append(SQLUtil.getPeriodCondition("TBP.FNumber", periodRange));
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).getOptionOtherAccount()) {
            sql.append(" AND (TP.accountLongNumber = '").append(partner.getAccountViewInfo().getLongNumber());
            sql.append("' OR TP.accountLongNumber like '").append(partner.getAccountViewInfo().getLongNumber()).append("!%' OR  TP.accountLongNumber IS null) \r\n");
            sql.append("and ((TP.FAccountTableId = '").append(partner.getAccountTableId()).append("' and TBP.FISADJUSTPERIOD = 1) or  TBP.FISADJUSTPERIOD<>1)");
            if (condition.isAllCurrency()) {
                sql.append(" AND TP.fcurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' and TP.FCurrencyId <> '22222222-2222-2222-2222-222222222222DEB58FDC' ");
            } else {
                String currencyid = partner.getCurrency().getId().toString();
                if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyid) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyid)) {
                    sql.append(" AND (TP.currencyID = '").append(currencyid).append("' OR TP.currencyID IS NULL) ");
                }
            }
        }
        if (condition.getOptionNoDisplayZeroTotal()) {
            sql.append(" and ((TP.FDebitFor<>0 or TP.FCreditFor<>0)");
            sql.append(" or (TP.FDebitLocal<>0 or TP.FCreditLocal<>0)");
            sql.append(" or (TP.FDebitRpt<>0 or TP.FCreditRpt<>0))");
        }
        sql.append(" GROUP BY TBP.FPeriodYear,TBP.FPeriodNumber,TBP.FEndDate \r\n");
        if (condition.isAllCurrency()) {
            sql.append(",TP.FCurrencyid\r\n");
        }
        if (condition.getOptionNoDisplayZeroTotal()) {
            sql.append("  Having ((SUM(FDebitFor)<>0 or SUM(FCreditFor)<>0)");
            sql.append("  or (SUM(FDebitLocal)<>0 or SUM(FCreditLocal)<>0)");
            sql.append("  or (SUM(FDebitRpt)<>0 or SUM(FCreditRpt)<>0))");
        }
        this.execute(partner.getContext(), sql.toString());
    }

    protected boolean insertYearSum(Map startBalance, ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append("\t(FDate, FDebitFor, FCreditFor,  \r\n");
        sql.append("\t FDebitLocal,FCreditLocal, \r\n");
        sql.append("\t FDebitRpt,FCreditRpt ,\r\n");
        if (this.isShowQuantity) {
            sql.append("FDebitQtyDefault,FCreditQtyDefault, \r\n");
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                sql.append(" FDebitAssistPrice, \r\n");
                sql.append(" FDebitAssistQty, \r\n");
            }
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                sql.append(" FCreditAssistPrice, \r\n");
                sql.append(" FCreditAssistQty, \r\n");
            }
        }
        if (condition.isAllCurrency()) {
            sql.append("FCurrencyid,\r\n");
        }
        sql.append("\tFLineType,FPeriodYear, FPeriodNumber) \r\n");
        sql.append("SELECT MAX(TP1.FDate) FDate, \r\n");
        sql.append("\tSUM(ISNULL(TP2.FDebitFor,0))+CASE WHEN TP1.FPeriodYear=? THEN ? ELSE 0 END FDebitFor, \r\n");
        sql.append("\tSUM(ISNULL(TP2.FCreditFor,0))+CASE WHEN TP1.FPeriodYear=? THEN ? ELSE 0 END FCreditFor, \r\n");
        sql.append("\tSUM(ISNULL(TP2.FDebitLocal,0))+CASE WHEN TP1.FPeriodYear=? THEN ? ELSE 0 END FDebitLocal, \r\n");
        sql.append("\tSUM(ISNULL(TP2.FCreditLocal,0))+CASE WHEN TP1.FPeriodYear=? THEN ? ELSE 0 END FCreditLocal, \r\n");
        sql.append("\tSUM(ISNULL(TP2.FDebitRpt,0))+CASE WHEN TP1.FPeriodYear=? THEN ? ELSE 0 END FDebitRpt, \r\n");
        sql.append("\tSUM(ISNULL(TP2.FCreditRpt,0))+CASE WHEN TP1.FPeriodYear=? THEN ? ELSE 0 END FCreditRpt, \r\n");
        if (this.isShowQuantity) {
            sql.append("\tSUM(ISNULL(TP2.FDebitQtyDefault,0))+CASE WHEN TP1.FPeriodYear=? THEN ? ELSE 0 END FDebitQtyDefault, \r\n");
            sql.append("\tSUM(ISNULL(TP2.FCreditQtyDefault,0))+CASE WHEN TP1.FPeriodYear=? THEN ? ELSE 0 END FCreditQtyDefault, \r\n");
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                sql.append(" SUM(ISNULL(TP2.FDebitAssistPrice,0))+CASE WHEN TP1.FPeriodYear=? THEN ? ELSE 0 END FDebitAssistPrice, \r\n");
                sql.append(" SUM(ISNULL(TP2.FDebitAssistQty,0))+CASE WHEN TP1.FPeriodYear=? THEN ? ELSE 0 END FDebitAssistQty, \r\n");
            }
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                sql.append(" SUM(ISNULL(TP2.FCreditAssistPrice,0))+CASE WHEN TP1.FPeriodYear=? THEN ? ELSE 0 END FCreditAssistPrice, \r\n");
                sql.append(" SUM(ISNULL(TP2.FCreditAssistQty,0))+CASE WHEN TP1.FPeriodYear=? THEN ? ELSE 0 END FCreditAssistQty, \r\n");
            }
        }
        if (condition.isAllCurrency()) {
            sql.append("TP1.FCurrencyid,\r\n");
        }
        sql.append("\t4 FLineType,TP1.FPeriodYear, TP1.FPeriodNumber \r\n");
        sql.append("FROM ");
        sql.append(partner.getTempTableName());
        sql.append(" TP1 \r\n");
        sql.append("\tINNER JOIN ");
        sql.append(partner.getTempTableName());
        sql.append(" TP2  \r\n");
        sql.append("\tON TP1.FPeriodYear = TP2.FPeriodYear \r\n");
        sql.append("\tAND TP1.FLineType = TP2.FLineType \r\n");
        if (condition.isAllCurrency()) {
            sql.append("\tand TP1.FCurrencyid = TP2.FCurrencyid \r\n");
        }
        sql.append("WHERE TP1.FLineType = 3 AND \r\n");
        sql.append("\tTP1.FPeriodNumber >= TP2.FPeriodNumber \r\n");
        if (condition.getOptionNoDisplayZeroTotal()) {
            sql.append(" and ((TP2.FDebitFor<>0 or TP2.FCreditFor<>0)");
            sql.append(" or (TP2.FDebitLocal<>0 or TP2.FCreditLocal<>0)");
            sql.append(" or (TP2.FDebitRpt<>0 or TP2.FCreditRpt<>0))");
        }
        String otherAccountTableid = null;
        if (condition.getOptionOtherAccount()) {
            AccountRefContrastInfo ar = AccountRefContrastFactory.getLocalInstance((Context)partner.getContext()).getLastAcctInfo(partner.getCompanyId(), ContextUtil.getCurrentFIUnit((Context)partner.getContext()).getAccountTable().getId().toString(), condition.getPeriodYearEnd(), condition.getPeriodNumberEnd());
            if (ar != null && partner.getAccountTableId() != null) {
                if (ar.getEnabledAcctTable() != null && ar.getEnabledAcctTable().getId() != null && ar.getEnabledAcctTable().getId().toString().equals(partner.getAccountTableId()) && ar.getDisabledAcctTable() != null && ar.getDisabledAcctTable().getId() != null) {
                    otherAccountTableid = ar.getDisabledAcctTable().getId().toString();
                } else if (ar.getDisabledAcctTable() != null && ar.getDisabledAcctTable().getId() != null && ar.getDisabledAcctTable().getId().toString().equals(partner.getAccountTableId()) && ar.getEnabledAcctTable() != null && ar.getEnabledAcctTable().getId() != null) {
                    otherAccountTableid = ar.getEnabledAcctTable().getId().toString();
                }
            }
            if (otherAccountTableid != null) {
                sql.append(" and ((TP2.FSOURCETYPE<>?  and TP2.FAccounttableid = ?) or (TP2.FSOURCETYPE=? and TP2.FAccounttableid = ? ) or TP2.FAccounttableid is null ) ");
            }
        }
        int sqlLegth = sql.length();
        if (condition.isAllCurrency()) {
            ArrayList hasInsertCur = new ArrayList();
            for (int i = 0; i < startBalance.size(); ++i) {
                HashMap curStartBalance = (HashMap)startBalance.get(new Integer(i));
                if (hasInsertCur.contains(curStartBalance.get("FCurrencyid"))) continue;
                hasInsertCur.add(curStartBalance.get("FCurrencyid"));
                sql.setLength(sqlLegth);
                sql.append(" and TP1.fcurrencyid = ? \r\n");
                sql.append("GROUP BY TP1.FPeriodYear,TP1.FPeriodNumber \r\n");
                if (condition.isAllCurrency()) {
                    sql.append(",TP1.FCurrencyid\r\n");
                }
                SqlParameter2 parameter = new SqlParameter2();
                Integer periodYear = (Integer)curStartBalance.get("FPeriodYear");
                parameter.addValue(periodYear);
                parameter.addValue(curStartBalance.get("FYearDebitFor"));
                parameter.addValue(periodYear);
                parameter.addValue(curStartBalance.get("FYearCreditFor"));
                parameter.addValue(periodYear);
                parameter.addValue(curStartBalance.get("FYearDebitLocal"));
                parameter.addValue(periodYear);
                parameter.addValue(curStartBalance.get("FYearCreditLocal"));
                parameter.addValue(periodYear);
                parameter.addValue(curStartBalance.get("FYearDebitRpt"));
                parameter.addValue(periodYear);
                parameter.addValue(curStartBalance.get("FYearCreditRpt"));
                if (this.isShowQuantity) {
                    parameter.addValue(periodYear);
                    BigDecimal yearDebitQty = (BigDecimal)curStartBalance.get("FYearDebitQty");
                    parameter.addValue(yearDebitQty.compareTo(GlUtils.zero) == 0 ? GlUtils.zero : yearDebitQty.setScale(10, 4));
                    parameter.addValue(periodYear);
                    BigDecimal yearCreditQty = (BigDecimal)curStartBalance.get("FYearCreditQty");
                    parameter.addValue(yearCreditQty.compareTo(GlUtils.zero) == 0 ? GlUtils.zero : yearCreditQty.setScale(10, 4));
                    if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                        parameter.addValue(periodYear);
                        if (curStartBalance.get("FDebitAssistPrice") == null) {
                            parameter.addValue(GlUtils.zero);
                        } else {
                            BigDecimal debitAssistPrice = (BigDecimal)curStartBalance.get("FDebitAssistPrice");
                            parameter.addValue(debitAssistPrice.compareTo(GlUtils.zero) == 0 ? GlUtils.zero : debitAssistPrice.setScale(10, 4));
                        }
                        parameter.addValue(periodYear);
                        if (curStartBalance.get("FDebitAssistQty") == null) {
                            parameter.addValue(GlUtils.zero);
                        } else {
                            BigDecimal debitAssistQty = (BigDecimal)curStartBalance.get("FDebitAssistQty");
                            parameter.addValue(debitAssistQty.compareTo(GlUtils.zero) == 0 ? GlUtils.zero : debitAssistQty.setScale(10, 4));
                        }
                    }
                    if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                        parameter.addValue(periodYear);
                        if (curStartBalance.get("FCreditAssistPrice") == null) {
                            parameter.addValue(GlUtils.zero);
                        } else {
                            BigDecimal creditAssistPrice = (BigDecimal)curStartBalance.get("FCreditAssistPrice");
                            parameter.addValue(creditAssistPrice.compareTo(GlUtils.zero) == 0 ? GlUtils.zero : creditAssistPrice.setScale(10, 4));
                        }
                        parameter.addValue(periodYear);
                        if (curStartBalance.get("FCreditAssistQty") == null) {
                            parameter.addValue(GlUtils.zero);
                        } else {
                            BigDecimal creditAssistQty = (BigDecimal)curStartBalance.get("FCreditAssistQty");
                            parameter.addValue(creditAssistQty.compareTo(GlUtils.zero) == 0 ? GlUtils.zero : creditAssistQty.setScale(10, 4));
                        }
                    }
                }
                if (otherAccountTableid != null) {
                    parameter.addValue(7);
                    parameter.addValue(partner.getAccountTableId());
                    parameter.addValue(7);
                    parameter.addValue(otherAccountTableid);
                }
                parameter.addValue(curStartBalance.get("FCurrencyid"));
                String sql1 = parameter.getSqlWithParameters(sql.toString());
                try {
                    DbUtil.execute((Context)partner.getContext(), (String)sql1);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity) {
                this.setAssCou(partner);
            }
            return true;
        }
        sql.append("GROUP BY TP1.FPeriodYear,TP1.FPeriodNumber \r\n");
        SqlParameter2 parameter = new SqlParameter2();
        Integer periodYear = (Integer)startBalance.get("FPeriodYear");
        parameter.addValue(periodYear);
        parameter.addValue(startBalance.get("FYearDebitFor"));
        parameter.addValue(periodYear);
        parameter.addValue(startBalance.get("FYearCreditFor"));
        parameter.addValue(periodYear);
        parameter.addValue(startBalance.get("FYearDebitLocal"));
        parameter.addValue(periodYear);
        parameter.addValue(startBalance.get("FYearCreditLocal"));
        parameter.addValue(periodYear);
        parameter.addValue(startBalance.get("FYearDebitRpt"));
        parameter.addValue(periodYear);
        parameter.addValue(startBalance.get("FYearCreditRpt"));
        if (this.isShowQuantity) {
            parameter.addValue(periodYear);
            BigDecimal yearDebitQty = (BigDecimal)startBalance.get("FYearDebitQty");
            parameter.addValue(yearDebitQty.compareTo(GlUtils.zero) == 0 ? GlUtils.zero : yearDebitQty.setScale(10, 4));
            parameter.addValue(periodYear);
            BigDecimal yearCreditQty = (BigDecimal)startBalance.get("FYearCreditQty");
            parameter.addValue(yearCreditQty.compareTo(GlUtils.zero) == 0 ? GlUtils.zero : yearCreditQty.setScale(10, 4));
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                parameter.addValue(periodYear);
                if (startBalance.get("FDebitAssistPrice") == null) {
                    parameter.addValue(GlUtils.zero);
                } else {
                    BigDecimal debitAssistPrice = (BigDecimal)startBalance.get("FDebitAssistPrice");
                    parameter.addValue(debitAssistPrice.compareTo(GlUtils.zero) == 0 ? GlUtils.zero : debitAssistPrice.setScale(10, 4));
                }
                parameter.addValue(periodYear);
                if (startBalance.get("FDebitAssistQty") == null) {
                    parameter.addValue(GlUtils.zero);
                } else {
                    BigDecimal debitAssistQty = (BigDecimal)startBalance.get("FDebitAssistQty");
                    parameter.addValue(debitAssistQty.compareTo(GlUtils.zero) == 0 ? GlUtils.zero : debitAssistQty.setScale(10, 4));
                }
            }
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                parameter.addValue(periodYear);
                if (startBalance.get("FCreditAssistPrice") == null) {
                    parameter.addValue(GlUtils.zero);
                } else {
                    BigDecimal creditAssistPrice = (BigDecimal)startBalance.get("FCreditAssistPrice");
                    parameter.addValue(creditAssistPrice.compareTo(GlUtils.zero) == 0 ? GlUtils.zero : creditAssistPrice.setScale(10, 4));
                }
                parameter.addValue(periodYear);
                if (startBalance.get("FCreditAssistQty") == null) {
                    parameter.addValue(GlUtils.zero);
                } else {
                    BigDecimal creditAssistQty = (BigDecimal)startBalance.get("FCreditAssistQty");
                    parameter.addValue(creditAssistQty.compareTo(GlUtils.zero) == 0 ? GlUtils.zero : creditAssistQty.setScale(10, 4));
                }
            }
        }
        if (otherAccountTableid != null) {
            parameter.addValue(7);
            parameter.addValue(partner.getAccountTableId());
            parameter.addValue(7);
            parameter.addValue(otherAccountTableid);
        }
        String sql1 = parameter.getSqlWithParameters(sql.toString());
        try {
            DbUtil.execute((Context)partner.getContext(), (String)sql1);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity) {
            this.setAssCou(partner);
        }
        return true;
    }

    protected void setAssCou(ReportPartner partner) throws EASBizException, BOSException {
        String sql2;
        int cou;
        IRowSet rs;
        String sql = "select FPeriodNumber ,count(FDebitAssistUnit) co from( select FPeriodNumber,FDebitAssistUnit from " + partner.getTempTableName() + " \r\n where FPeriodNumber in \r\n (select FPeriodNumber from " + partner.getTempTableName() + "  where Flinetype=3 group by FPeriodNumber) \r\n and FDebitAssistUnit is not null group by FDebitAssistUnit,FPeriodNumber \r\n ) group by FPeriodNumber";
        String ids = "";
        try {
            rs = DbUtil.executeQuery((Context)partner.getContext(), (String)sql);
            while (rs.next()) {
                cou = rs.getInt("co");
                if (cou == 1) continue;
                ids = ids + rs.getString("FPeriodNumber") + "','";
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (ids.length() > 0) {
            ids = ids.substring(0, ids.length() - 3);
            sql2 = "update " + partner.getTempTableName() + " set FDebitAssistQty=null,FDebitAssistPrice=null where FPeriodNumber in('" + ids + "') and (Flinetype=3 or Flinetype=4)";
            partner.executeSql(sql2, null);
        }
        sql = "select FPeriodNumber ,count(FCreditAssistUnit) co from( select FPeriodNumber,FCreditAssistUnit from " + partner.getTempTableName() + " \r\n where FPeriodNumber in \r\n (select FPeriodNumber from " + partner.getTempTableName() + "  where Flinetype=3 group by FPeriodNumber) \r\n and FCreditAssistUnit is not null group by FCreditAssistUnit,FPeriodNumber \r\n ) group by FPeriodNumber";
        ids = "";
        try {
            rs = DbUtil.executeQuery((Context)partner.getContext(), (String)sql);
            while (rs.next()) {
                cou = rs.getInt("co");
                if (cou == 1) continue;
                ids = ids + rs.getString("FPeriodNumber") + "','";
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (ids.length() > 0) {
            ids = ids.substring(0, ids.length() - 3);
            sql2 = "update " + partner.getTempTableName() + " set FCreditAssistPrice=null,FCreditAssistQty=null where FPeriodNumber in('" + ids + "') and (Flinetype=3 or Flinetype=4)";
            partner.executeSql(sql2, null);
        }
    }

    protected boolean insertYearStart(String tempTableName, ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(tempTableName);
        sql.append(" \r\n");
        sql.append("\t(FDate, FLineType,FPeriodYear, FPeriodNumber) \r\n");
        sql.append("SELECT TP.FBeginDate,-3 FLineType,TP.FPeriodYear,TP.FPeriodNumber \r\n");
        sql.append("FROM ");
        sql.append(tempTableName);
        sql.append(" TPT \r\n");
        sql.append("\tINNER JOIN T_BD_Period TP \r\n");
        sql.append("\tON TPT.FPeriodYear = TP.FPeriodYear \r\n");
        sql.append("\tAND TPT.FPeriodNumber = TP.FPeriodNumber \r\n");
        sql.append("WHERE TPT.FLineType = 3 AND \r\n");
        sql.append("\tTPT.FPeriodNumber = 1 AND \r\n");
        sql.append("\tTP.FTypeID = ? AND  \r\n");
        sql.append("\tTP.FPeriodNumber = 1  \r\n");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        return partner.executeSql(sql.toString(), parameter);
    }

    protected boolean insertSelfVoucherEntry(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append("\t(FDate, FBizDate,FVoucherNumber,FVoucherTypeNumber ,FVoucherTypeName ,FCREATETIME ,FSeq, FDescription,  \r\n");
        if (condition.getOptionOtherAccount()) {
            sql.append(" accountName, \r\n");
            sql.append(" otheraccountLongNumber, \r\n");
            sql.append(" currencyID,\r\n");
        }
        sql.append("\t FDebitFor, FCreditFor,  \r\n");
        sql.append("\t FLocalRate,FRptRate, \r\n");
        sql.append("\t FDebitLocal,FCreditLocal, \r\n");
        sql.append("\t FDebitRpt,FCreditRpt, \r\n");
        if (this.isShowQuantity) {
            sql.append(" FDebitUnitId,FCreditUnitId, \r\n");
            sql.append(" FDebitQty,FCreditQty,\r\n");
            sql.append(" FDebitQtyDefault,FCreditQtyDefault, \r\n");
            sql.append(" FDebitPrice,FCreditPrice, \r\n");
        }
        sql.append("\tFBalanceUnitId,FLineType,FVoucherID,   \r\n");
        if (condition.isAllCurrency()) {
            sql.append("    FCurrencyid , \r\n");
        }
        sql.append("FPeriodYear, FPeriodNumber) \r\n");
        Map editParame = condition.getExpandInfo();
        boolean isChkSum = editParame.get("isChkSum") != null && editParame.get("isChkSum") instanceof Boolean && (Boolean)editParame.get("isChkSum") != false && !condition.getOptionOnlyAsst();
        boolean isRdoIsAccountAndDesc = editParame.get("isRdoIsAccountAndDesc") != null && editParame.get("isRdoIsAccountAndDesc") instanceof Boolean && (Boolean)editParame.get("isRdoIsAccountAndDesc") != false;
        boolean isChkIsZeroNoDisplay = editParame.get("isChkIsZeroNoDisplay") != null && editParame.get("isChkIsZeroNoDisplay") instanceof Boolean && (Boolean)editParame.get("isChkIsZeroNoDisplay") != false;
        int spnAccountLevel = 1;
        if (editParame.get("spnAccountLevel") != null && editParame.get("spnAccountLevel") instanceof Integer) {
            spnAccountLevel = (Integer)editParame.get("spnAccountLevel");
        }
        if (isChkSum) {
            if (isChkIsZeroNoDisplay) {
                sql.append("SELECT * from ( \r\n");
            }
            sql.append("SELECT min(FBookedDate) FBookedDate, min(FBizDate) FBizDate, min(FNumber_tv) FNumber_tv, min(fnumber_tvt) fnumber_tvt, \r\n");
            sql.append("min(FName_tvt) FName_tvt, min(FCREATETIME_tv) FCREATETIME_tv, min(FSeq) FSeq, ");
            if (isRdoIsAccountAndDesc) {
                sql.append("FDescription_tve, \r\n");
            } else {
                sql.append("substring(min( TOCHAR (FSeq) || FDescription_tve), len(min(FSeq)) + 1, len(min( TOCHAR (FSeq) || FDescription_tve)) - 1) FDescription_tve,\r\n");
            }
            sql.append("sum(FDebitFor) FDebitFor, sum(FCreditFor) FCreditFor, min(FLocalRate) FLocalRate, min(FRptRate) FRptRate, sum(FDebitLocal) FDebitLocal, \r\n");
            sql.append("sum(FCreditLocal) FCreditLocal, sum(FDebitRpt) FDebitRpt, sum(FCreditRpt) FCreditRpt,  \r\n");
            if (this.isShowQuantity) {
                sql.append(" min(FDebitUnitId) FDebitUnitId,min(FCreditUnitId) FCreditUnitId, \r\n");
                sql.append(" min(FDebitQty) FDebitQty,min(FCreditQty) FCreditQty,\r\n");
                sql.append(" min(FDebitQtyDefault) FDebitQtyDefault,min(FCreditQtyDefault) FCreditQtyDefault, \r\n");
                sql.append(" min(FDebitPrice) FDebitPrice,min(FCreditPrice) FCreditPrice, \r\n");
            }
            sql.append("min(FBalanceUnitId) FBalanceUnitId,min(FLineType) FLineType,FVoucherID,  \r\n");
            if (condition.isAllCurrency()) {
                sql.append(" min(FCurrencyid) FCurrencyid, \r\n");
            }
            sql.append("min(FPeriodYear) FPeriodYear,min(FPeriodNumber) FPeriodNumber \r\n");
            sql.append("from ( \r\n");
        }
        sql.append("SELECT TV.FBookedDate,TV.FBizDate,TV.FNumber FNumber_tv,TVT.fnumber fnumber_tvt,TVT.FName");
        sql.append(partner.getFieldNameExtend());
        sql.append(" FName_tvt,TV.FCREATETIME FCREATETIME_tv,TVE.FSeq,TVE.FDescription FDescription_tve, \r\n");
        if (partner.getCurrencyType() == 1) {
            this.addDebitCreditFieldSQL(sql, "TVE.FLocalAmount", "0", "For");
        } else if (partner.getCurrencyType() == 2) {
            this.addDebitCreditFieldSQL(sql, "TVE.FReportingAmount", "0", "For");
        } else {
            this.addDebitCreditFieldSQL(sql, "TVE.FOriginalAmount", "0", "For");
        }
        sql.append(" TVE.FLocalExchangeRate FLocalRate,\r\n");
        sql.append(" TVE.FReportingExchangeRate FRptRate,\r\n");
        this.addDebitCreditFieldSQL(sql, "TVE.FLocalAmount", "0", "Local");
        this.addDebitCreditFieldSQL(sql, "TVE.FReportingAmount", "0", "Rpt");
        if (this.isShowQuantity) {
            this.addDebitCreditFieldSQL(sql, "TVE.FMeasureUnitID", "NULL", "UnitId");
            this.addDebitCreditFieldSQL(sql, "TVE.FQuantity", "0", "Qty");
            this.addDebitCreditFieldSQL(sql, "TVE.FStandardQuantity", "0", "QtyDefault");
            this.addDebitCreditFieldSQL(sql, "TVE.FPrice", "NULL", "Price");
        }
        sql.append("CASE WHEN MUG.FDefaultunitID IS NULL THEN AV.FMeasureUnitID ELSE MUG.FDefaultunitID END FBalanceUnitId, \r\n");
        sql.append("\t0 FLineType,TV.FID FVoucherID, \r\n");
        if (condition.isAllCurrency()) {
            sql.append("    TVE.FCurrencyid , \r\n");
        }
        sql.append("\tTP.FPeriodYear  FPeriodYear,TP.FPeriodNumber FPeriodNumber \r\n");
        if (isChkSum) {
            int accountLevel = partner.getAccountViewInfo().getLevel();
            sql.append(", (CASE WHEN av.flevel > ");
            sql.append(accountLevel > spnAccountLevel ? accountLevel : spnAccountLevel);
            sql.append(" THEN '~~~~~~~~~~' ELSE AV.FID END) accountid \r\n");
            sql.append(", (CASE WHEN av.flevel >= ");
            sql.append(accountLevel > spnAccountLevel ? accountLevel : spnAccountLevel);
            sql.append(" THEN '~~~~~~~~~~' ELSE TVE.fid END) voucherentryid \r\n");
        }
        sql.append("FROM T_GL_Voucher TV \r\n");
        sql.append("\tINNER JOIN T_BD_VoucherTypes TVT \r\n ");
        sql.append("\tON TV.FVoucherTypeID = TVT.FID \r\n");
        sql.append("\tINNER JOIN T_GL_VoucherEntry TVE \r\n");
        sql.append("\tON TV.FID = TVE.FBillID \r\n");
        sql.append("\tINNER JOIN T_BD_Period TP \r\n");
        sql.append("\tON TV.FPeriodID = TP.FID \r\n");
        sql.append("\tINNER JOIN T_BD_AccountView AV \r\n");
        sql.append("\tON TVE.FAccountID =AV.FID AND AV.FCompanyID = TV.FCompanyID \r\n");
        sql.append("\tLEFT JOIN t_bd_measureunitgroup MUG ON AV.FMeasureUnitGroupID=MUG.fid \r\n");
        HashMap<String, String> table = new HashMap<String, String>();
        table.put("VOUCHER", "TV");
        table.put("ENTRIES", "TVE");
        table.put("VOUCHERTYPE", "TVT");
        table.put("PERIOD", "TP");
        table.put("ACCOUNTVIEW", "AV");
        HashMap tableValue = RptServerUtil.getRptSelfCongdition(partner.getContext(), partner.getCondition(), table, true, false);
        if (tableValue != null && tableValue.get("join") != null) {
            sql.append(tableValue.get("join").toString());
        }
        sql.append(" WHERE TV.FCompanyID = ? AND \r\n");
        sql.append("  AV.FCompanyID = ? AND \r\n");
        sql.append("    (TV.FBizStatus =   ");
        sql.append(5);
        sql.append("  \r\n");
        if (condition.getOptionPosting()) {
            sql.append("    OR TV.FBizStatus =   ");
            sql.append(1);
            sql.append(" \r\n");
            sql.append("    OR TV.FBizStatus =   ");
            sql.append(3);
            sql.append("  \r\n");
        }
        sql.append(") AND \r\n");
        if (condition.getOptionNotIncludePLVoucher()) {
            sql.append(" TV.FSourceType != ").append(1);
            sql.append(" AND \r\n");
        }
        if (partner.getAccountViewInfo().isIsLeaf()) {
            sql.append("\tTVE.FAccountID = '");
            sql.append(partner.getAccountViewInfo().getId().toString());
            sql.append("' AND \r\n");
        } else {
            sql.append("\tTVE.FAccountID IN (");
            sql.append(this.getChildAccountIds(partner, partner.getAccountViewInfo()));
            sql.append(") AND \r\n");
        }
        if (partner.getCurrencyType() == 0 && !condition.isAllCurrency()) {
            sql.append("\tTVE.FCurrencyID = ? AND \r\n");
        } else if (condition.isAllCurrency()) {
            sql.append("\tTVE.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' and TVE.FCurrencyId <> '22222222-2222-2222-2222-222222222222DEB58FDC'  and\t\t\r\n");
        }
        sql.append("\tTP.FNumber>=? AND \r\n");
        sql.append("\tTP.FNumber<=? AND \r\n");
        sql.append("\tTP.FTypeID = ? \r\n");
        if (tableValue != null && tableValue.get("cond") != null) {
            sql.append("  and " + tableValue.get("cond").toString());
        }
        Context ctx = partner.getContext();
        BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        BOSUuid cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
        String rule = PermissionServiceProviderFactory.getLocalInstance((Context)ctx).getPermissionRule((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(cuId), "bd_assistant_voucherType_view");
        if (!StringUtils.isEmpty((String)rule)) {
            String p = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(cuId), "bd_assistant_voucherType_view");
            sql.append("    and TVT.FID IN \n(" + p + ")");
        }
        if (isChkSum) {
            sql.append(") tmp \r\n");
            sql.append("inner join \r\n");
            sql.append("(select fid from T_BD_AccountView \r\n");
            sql.append("union all \r\n");
            sql.append("select top 1 '~~~~~~~~~~' fid from T_BD_AccountView \r\n");
            sql.append(") account on tmp.accountid = account.fid \r\n");
            sql.append("group by account.fid,FVoucherID,voucherentryid \r\n");
            if (isRdoIsAccountAndDesc) {
                sql.append(",FDescription_tve \r\n");
            }
            if (isChkIsZeroNoDisplay) {
                sql.append(") outtmp where  \r\n");
                sql.append("not (FDebitFor = 0 and FCreditFor = 0 and FDebitLocal = 0 and  \r\n");
                sql.append("FCreditLocal = 0 and FDebitRpt = 0 and FCreditRpt = 0) \r\n");
            }
        }
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValueChar(partner.getCompanyId());
        parameter.addValueChar(partner.getCompanyId());
        if (partner.getCurrencyType() == 0 && !condition.isAllCurrency()) {
            parameter.addValueChar(condition.getCurrencyID());
        }
        parameter.addValue(new Integer(condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart()));
        parameter.addValue(new Integer(condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()));
        parameter.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        partner.executeSql(sql.toString(), parameter);
        return true;
    }

    protected boolean insertVoucherEntry(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append("\t(FDate, FBizDate,FVoucherNumber,FVoucherTypeNumber ,FVoucherTypeName ,FCREATETIME ,FSeq, FDescription,  \r\n");
        sql.append(" \t accountName, \r\n");
        sql.append(" \t accountLongNumber, \r\n");
        sql.append("\t currencyID,\r\n");
        sql.append("     FAccounttableid,\r\n");
        sql.append("     FSOURCETYPE,\r\n");
        sql.append("\t FDebitFor, FCreditFor,  \r\n");
        sql.append("\t FLocalRate,FRptRate, \r\n");
        sql.append("\t FDebitLocal,FCreditLocal, \r\n");
        sql.append("\t FDebitRpt,FCreditRpt, \r\n");
        if (this.isShowQuantity) {
            sql.append(" FDebitUnitId,FCreditUnitId, \r\n");
            sql.append(" FDebitQty,FCreditQty,\r\n");
            sql.append(" FDebitQtyDefault,FCreditQtyDefault, \r\n");
            sql.append(" FDebitPrice,FCreditPrice, \r\n");
        }
        sql.append("\tFBalanceUnitId,FLineType,FVoucherID,   \r\n");
        if (condition.isAllCurrency()) {
            sql.append("    FCurrencyid , \r\n");
        }
        sql.append("FPeriodYear, FPeriodNumber) \r\n");
        sql.append("SELECT TV.FBookedDate FDate,TV.FBizDate FBizDate,TV.fnumber,tvt.fnumber,TVT.FName");
        sql.append(partner.getFieldNameExtend());
        sql.append(" ,TV.FCREATETIME,TVE.FSeq,TVE.FDescription FDescription, \r\n");
        if (partner.isParmAccountShowLongName()) {
            sql.append(" AV.FNumber ||' - '|| AV.FLongName").append(partner.getFieldNameExtend());
        } else {
            sql.append(" AV.FNumber ||' - '|| AV.FName").append(partner.getFieldNameExtend());
        }
        sql.append(" AS accountName, \r\n");
        sql.append("AV.FLongNumber AS accountLongNumber, \r\n");
        sql.append(" TVE.FCurrencyID currencyID,\r\n");
        sql.append(" AV.FACCOUNTTABLEID FACCOUNTTABLEID,\r\n");
        sql.append(" TV.FSOURCETYPE FSOURCETYPE,\r\n");
        if (partner.getCurrencyType() == 1) {
            this.addDebitCreditFieldSQL(sql, "TVE.FLocalAmount", "0", "For");
        } else if (partner.getCurrencyType() == 2) {
            this.addDebitCreditFieldSQL(sql, "TVE.FReportingAmount", "0", "For");
        } else {
            this.addDebitCreditFieldSQL(sql, "TVE.FOriginalAmount", "0", "For");
        }
        sql.append(" TVE.FLocalExchangeRate FLocalRate,\r\n");
        sql.append(" TVE.FReportingExchangeRate FRptRate,\r\n");
        if (partner.getCurrencyType() == 2) {
            this.addDebitCreditFieldSQL(sql, "TVE.FReportingAmount", "0", "Local");
        } else {
            this.addDebitCreditFieldSQL(sql, "TVE.FLocalAmount", "0", "Local");
        }
        this.addDebitCreditFieldSQL(sql, "TVE.FReportingAmount", "0", "Rpt");
        if (this.isShowQuantity) {
            this.addDebitCreditFieldSQL(sql, "TVE.FMeasureUnitID", "NULL", "UnitId");
            this.addDebitCreditFieldSQL(sql, "TVE.FQuantity", "0", "Qty");
            this.addDebitCreditFieldSQL(sql, "TVE.FStandardQuantity", "0", "QtyDefault");
            this.addDebitCreditFieldSQL(sql, "TVE.FPrice", "NULL", "Price");
        }
        sql.append("CASE WHEN MUG.FDefaultunitID IS NULL THEN AV.FMeasureUnitID ELSE MUG.FDefaultunitID END FBalanceUnitId, \r\n");
        sql.append(" 0 FLineType,TV.FID FVoucherID, \r\n");
        if (condition.isAllCurrency()) {
            sql.append("    TVE.FCurrencyid , \r\n");
        }
        sql.append(" TP.FPeriodYear  FPeriodYear,TP.FPeriodNumber FPeriodNumber \r\n");
        sql.append(" FROM T_GL_Voucher TV \r\n");
        sql.append(" INNER JOIN T_BD_VoucherTypes TVT ON TV.FVoucherTypeID = TVT.FID \r\n");
        sql.append(" INNER JOIN T_GL_VoucherEntry TVE ON TV.FID = TVE.FBillID \r\n");
        sql.append(" INNER JOIN T_BD_Period TP ON TV.FPeriodID = TP.FID \r\n");
        sql.append(" INNER JOIN T_BD_AccountView AV ON TVE.FAccountID =AV.FID AND AV.FCompanyID = TV.FCompanyID \r\n");
        sql.append(" LEFT OUTER JOIN t_bd_measureunitgroup MUG ON AV.FMeasureUnitGroupID=MUG.fid \r\n");
        HashMap<String, String> table = new HashMap<String, String>();
        table.put("VOUCHER", "TV");
        table.put("ENTRIES", "TVE");
        table.put("VOUCHERTYPE", "TVT");
        table.put("PERIOD", "TP");
        table.put("ACCOUNTVIEW", "AV");
        HashMap tableValue = RptServerUtil.getRptSelfCongdition(partner.getContext(), partner.getCondition(), table, true, false);
        if (tableValue != null && tableValue.get("join") != null) {
            sql.append(tableValue.get("join").toString());
        }
        sql.append(" WHERE TV.FCompanyID = ? \r\n");
        sql.append(" AND AV.FCompanyID = ? \r\n");
        sql.append(" AND (TV.FBizStatus = ").append(5).append("  \r\n");
        if (condition.getOptionPosting()) {
            sql.append(" OR TV.FBizStatus = ").append(1).append(" \r\n");
            sql.append(" OR TV.FBizStatus = ").append(3).append(" \r\n");
        }
        sql.append(") \r\n");
        if (condition.getOptionNotIncludePLVoucher()) {
            sql.append(" AND TV.FSourceType != ").append(1);
        }
        sql.append(" AND EXISTS \r\n").append("( SELECT 'LV' FROM T_GL_VoucherEntry VE \r\n").append(" WHERE VE.FBillID = TV.FID \r\n");
        if (partner.getAccountViewInfo().isIsLeaf()) {
            sql.append(" AND VE.FAccountID = '").append(partner.getAccountViewInfo().getId().toString()).append("' \r\n");
        } else {
            sql.append(" AND VE.FAccountID IN (").append(this.getChildAccountIds(partner, partner.getAccountViewInfo())).append(") \r\n");
        }
        if (partner.getCurrencyType() == 0 && !condition.isAllCurrency()) {
            sql.append("\tand VE.FCurrencyID = ?  \r\n");
        } else if (condition.isAllCurrency()) {
            sql.append("\tand VE.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' and VE.FCurrencyId <> '22222222-2222-2222-2222-222222222222DEB58FDC'  \t\t\r\n");
        }
        sql.append(")");
        sql.append(" AND TP.FNumber>=? \r\n");
        sql.append(" AND TP.FNumber<=? \r\n");
        sql.append(" AND TP.FTypeID = ? \r\n");
        sql.append(" AND AV.FCompanyID = ? \r\n");
        Context ctx = partner.getContext();
        if (tableValue != null && tableValue.get("cond") != null) {
            sql.append("  AND " + tableValue.get("cond").toString());
        }
        BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        BOSUuid cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
        String rule = PermissionServiceProviderFactory.getLocalInstance((Context)ctx).getPermissionRule((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(cuId), "bd_assistant_voucherType_view");
        if (!StringUtils.isEmpty((String)rule)) {
            String p = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(cuId), "bd_assistant_voucherType_view");
            sql.append("    and TVT.FID IN \n(" + p + ")");
        }
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValueChar(partner.getCompanyId());
        parameter.addValueChar(partner.getCompanyId());
        if (partner.getCurrencyType() == 0 && !condition.isAllCurrency()) {
            parameter.addValueChar(condition.getCurrencyID());
        }
        parameter.addValue(new Integer(condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart()));
        parameter.addValue(new Integer(condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()));
        parameter.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        parameter.addValueChar(partner.getCompanyId());
        return partner.executeSql(sql.toString(), parameter);
    }

    protected boolean insertVoucherOrAsst(ReportPartner partner) throws BOSException, EASBizException {
        boolean isChkIsZeroNoDisplay;
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append("\t(FDate, FBizDate,FVoucherNumber,FVoucherTypeNumber ,FVoucherTypeName ,FCREATETIME ,FSeq, FDescription,  \r\n");
        if (condition.getOptionShowAccountCusAttribute()) {
            sql.append(" \tFSettlementType,FSettlementCode, \r\n");
            sql.append("\tFBizNumber, \r\n");
            sql.append("\tFTicketNumber,FInvoiceNumber,\r\n");
            sql.append("\tFFeeType,FHandler,\r\n");
        }
        sql.append("\t FDebitFor, FCreditFor,  \r\n");
        sql.append("\t FLocalRate,FRptRate, \r\n");
        sql.append("\t FDebitLocal,FCreditLocal, \r\n");
        sql.append("\t FDebitRpt,FCreditRpt, \r\n");
        if (this.isShowQuantity) {
            sql.append(" FDebitUnitId,FCreditUnitId, \r\n");
            sql.append(" FDebitQty,FCreditQty,\r\n");
            sql.append(" FDebitQtyDefault,FCreditQtyDefault, \r\n");
            sql.append(" FDebitPrice,FCreditPrice, \r\n");
            if (this.getPar(partner)) {
                sql.append(" FDebitAssistUnit,FCreditAssistUnit,\r\n");
                sql.append(" FDebitAssistPrice,FCreditAssistPrice, \r\n");
                sql.append(" FDebitAssistQty,FCreditAssistQty, \r\n");
            }
        }
        sql.append("\tFBalanceUnitId,FLineType,FVoucherID,   \r\n");
        if (condition.isAllCurrency()) {
            sql.append("    FCurrencyid , \r\n");
        }
        sql.append("FPeriodYear, FPeriodNumber \r\n");
        if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
            sql.append(" , FAccountOrAssist, \r\n");
            sql.append("  FCount, \r\n");
            sql.append(" FAsstAccountPerId, \r\n");
            sql.append("FNumberGroupAsst, \r\n");
            sql.append("  FdisplaynameGroup, \r\n");
            sql.append("  FNumberGroup, \r\n");
            sql.append("  FAsstAccountName \r\n");
        }
        Map editParame = condition.getExpandInfo();
        boolean isChkSum = false;
        boolean isRdoIsAccountAndDesc = editParame.get("isRdoIsAccountAndDesc") != null && editParame.get("isRdoIsAccountAndDesc") instanceof Boolean && (Boolean)editParame.get("isRdoIsAccountAndDesc") != false;
        boolean bl = isChkIsZeroNoDisplay = editParame.get("isChkIsZeroNoDisplay") != null && editParame.get("isChkIsZeroNoDisplay") instanceof Boolean && (Boolean)editParame.get("isChkIsZeroNoDisplay") != false;
        if (isChkSum) {
            if (isChkIsZeroNoDisplay) {
                sql.append(") SELECT * from ( \r\n");
            } else {
                sql.append(")");
            }
            sql.append(" SELECT min(FBookedDate), min(FBizDate), min(FNumber_tv), min(fnumber_tvt), \r\n");
            sql.append("min(FName_tvt), min(FCREATETIME_tv), min(FSeq), ");
            if (isRdoIsAccountAndDesc) {
                sql.append("FDescription_tve, \r\n");
            } else {
                sql.append("min(FDescription_tve), \r\n");
            }
            if (condition.getOptionShowAccountCusAttribute()) {
                sql.append("min(FSettlementType), min(FSettlementCode), min(FBizNumber), \r\n");
                sql.append("min(FTicketNumber), min(FInvoiceNumber),\r\n");
                sql.append("min(FFeeType), min(FHandler),\r\n");
            }
            sql.append("sum(FDebitFor) FDebitFor, sum(FCreditFor) FCreditFor, min(FLocalRate), min(FRptRate), sum(FDebitLocal) FDebitLocal, \r\n");
            sql.append("sum(FCreditLocal) FCreditLocal, sum(FDebitRpt) FDebitRpt, sum(FCreditRpt) FCreditRpt,  \r\n");
            if (this.isShowQuantity) {
                sql.append(" min(FDebitUnitId),min(FCreditUnitId), \r\n");
                sql.append(" min(FDebitQty),min(FCreditQty),\r\n");
                sql.append(" min(FDebitQtyDefault),min(FCreditQtyDefault), \r\n");
                sql.append(" min(FDebitPrice),min(FCreditPrice), \r\n");
            }
            sql.append("min(FBalanceUnitId), min(FLineType),FVoucherID,  \r\n");
            if (condition.isAllCurrency()) {
                sql.append(" min(FCurrencyid) , \r\n");
            }
            sql.append("min(FPeriodYear),min(FPeriodNumber) \r\n");
            sql.append(",min(FAccountOrAssist), min(FCount), min(FAsstAccountName) \r\n");
            sql.append("from ( \r\n");
        } else {
            sql.append(") ");
        }
        sql.append("SELECT TV.FBookedDate, TV.FBizDate,TV.fnumber FNumber_tv,tvt.fnumber fnumber_tvt,TVT.FName");
        sql.append(partner.getFieldNameExtend());
        sql.append(" FName_tvt,TV.FCREATETIME FCREATETIME_tv,TVE.FSeq,TVE.FDescription FDescription_tve, \r\n");
        if (condition.getOptionShowAccountCusAttribute()) {
            sql.append(" TST.FName");
            sql.append(partner.getFieldNameExtend());
            sql.append(" FSettlementType,");
            sql.append(" TVAR.FSettlementCode,");
            sql.append(" TVAR.FBizNumber, ");
            sql.append(" TVAR.FTicketNumber,TVAR.FInvoiceNumber,");
            sql.append(" (case when TVAR.FFeeType=1 then '" + FeeTypeEnum.getEnum((int)1).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=2 then '" + FeeTypeEnum.getEnum((int)2).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=3 then '" + FeeTypeEnum.getEnum((int)3).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=4 then '" + FeeTypeEnum.getEnum((int)4).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=5 then '" + FeeTypeEnum.getEnum((int)5).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=6 then '" + FeeTypeEnum.getEnum((int)6).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=7 then '" + FeeTypeEnum.getEnum((int)7).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=8 then '" + FeeTypeEnum.getEnum((int)8).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=9 then '" + FeeTypeEnum.getEnum((int)9).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=10 then '" + FeeTypeEnum.getEnum((int)10).getAlias() + "'");
            sql.append("       else '' end)as FFeeType,");
            sql.append(" THdl.FName");
            sql.append(partner.getFieldNameExtend());
            sql.append(" FHandler, ");
        }
        if (partner.getCurrencyType() == 1) {
            this.addDebitCreditFieldSQL(sql, "TVE.FLocalAmount", "0", "For");
        } else if (partner.getCurrencyType() == 2) {
            this.addDebitCreditFieldSQL(sql, "TVE.FReportingAmount", "0", "For");
        } else {
            this.addDebitCreditFieldSQL(sql, "TVE.FOriginalAmount", "0", "For");
        }
        sql.append(" TVE.FLocalExchangeRate FLocalRate,\r\n");
        sql.append(" TVE.FReportingExchangeRate FRptRate,\r\n");
        this.addDebitCreditFieldSQL(sql, "TVE.FLocalAmount", "0", "Local");
        this.addDebitCreditFieldSQL(sql, "TVE.FReportingAmount", "0", "Rpt");
        if (this.isShowQuantity) {
            this.addDebitCreditFieldSQL(sql, "TVE.FMeasureUnitID", "NULL", "UnitId");
            this.addDebitCreditFieldSQL(sql, "TVE.FQuantity", "0", "Qty");
            this.addDebitCreditFieldSQL(sql, "TVE.FStandardQuantity", "0", "QtyDefault");
            this.addDebitCreditFieldSQL(sql, "TVE.FPrice", "NULL", "Price");
            if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.getPar(partner)) {
                this.addDebitCreditFieldSQL(sql, "MUI.FName_l2", "NULL", "AssistUnit");
                this.addDebitCreditFieldSQL(sql, "TVAR.FAssistPrice", "0", "AssistPrice");
                this.addDebitCreditFieldSQL(sql, "TVAR.FAssistQty", "0", "AssistQty");
            }
        }
        sql.append("CASE WHEN MUG.FDefaultunitID IS NULL THEN AV.FMeasureUnitID ELSE MUG.FDefaultunitID END FBalanceUnitId, \r\n");
        sql.append("\t0 FLineType,TV.FID FVoucherID, \r\n");
        if (condition.isAllCurrency()) {
            sql.append("    TVE.FCurrencyID FCurrencyID, \r\n");
        }
        sql.append("\tTP.FPeriodYear  FPeriodYear,TP.FPeriodNumber FPeriodNumber \r\n");
        if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
            sql.append("  \t,1 FAccountOrAssist, 0 FCount,null FAsstAccountPerId,null FNumberGroupAsst,null FdisplaynameGroup,null FNumberGroup, null FAsstAccountName  \r\n");
        }
        if (isChkSum) {
            sql.append(" ,AV.FID accountid \r\n");
        }
        sql.append("    FROM T_GL_Voucher TV \r\n");
        sql.append("\tINNER JOIN T_BD_VoucherTypes TVT \r\n ");
        sql.append("\tON TV.FVoucherTypeID = TVT.FID \r\n");
        sql.append("\tINNER JOIN T_GL_VoucherEntry TVE \r\n");
        sql.append("\tON TV.FID = TVE.FBillID \r\n");
        sql.append("\tINNER JOIN T_BD_Period TP \r\n");
        sql.append("\tON TV.FPeriodID = TP.FID \r\n");
        sql.append("\tINNER JOIN T_BD_AccountView AV \r\n");
        sql.append("\tON TVE.FAccountID =AV.FID  AND AV.FCompanyID = TV.FCompanyID and AV.fcaa is  null and AV.FhasUserProperty=0 \r\n");
        sql.append("\tLEFT JOIN t_bd_measureunitgroup MUG ON AV.FMeasureUnitGroupID=MUG.fid \r\n");
        HashMap<String, String> table = new HashMap<String, String>();
        table.put("VOUCHER", "TV");
        table.put("ENTRIES", "TVE");
        table.put("VOUCHERTYPE", "TVT");
        table.put("PERIOD", "TP");
        table.put("ACCOUNTVIEW", "AV");
        if (condition.getOptionShowAccountCusAttribute()) {
            table.put("SETTLEMENTTYPE", "TST");
        }
        boolean isIncludeAssist = false;
        sql.append(" LEFT OUTER JOIN T_GL_VoucherAssistRecord TVAR \r\n");
        if (this.isShowQuantity && this.getPar(partner)) {
            sql.append("\tLEFT JOIN T_BD_MeasureUnit MUI ON TVAR.FAssistUnit=MUI.fid \r\n");
        }
        sql.append(" ON TVE.FID = TVAR.FentryID \r\n");
        sql.append(" LEFT OUTER JOIN T_BD_SettlementType TST \r\n");
        sql.append(" ON TST.FID = TVAR.FSettlementTypeID \r\n");
        if (partner.getAccountViewInfo().isHasUserProperty() || condition.getOptionShowAccountCusAttribute()) {
            sql.append(" LEFT OUTER JOIN T_PM_User THdl \r\n");
            sql.append(" ON THdl.FID = TVAR.FHandlerID \r\n");
            table.put("ASSHANDLER", "THdl");
        }
        table.put("ASSISTRECORDS", "TVAR");
        isIncludeAssist = true;
        HashMap tableValue = RptServerUtil.getRptSelfCongdition(partner.getContext(), partner.getCondition(), table, isIncludeAssist, false);
        if (tableValue != null && tableValue.get("join") != null) {
            sql.append(tableValue.get("join").toString());
        }
        sql.append(" WHERE TV.FCompanyID = ? \r\n");
        sql.append(" AND AV.FCompanyID = ? AND \r\n");
        sql.append("    (TV.FBizStatus =   ");
        sql.append(5);
        sql.append("  \r\n");
        if (condition.getOptionPosting()) {
            sql.append("    OR TV.FBizStatus =   ");
            sql.append(1);
            sql.append(" \r\n");
            sql.append("    OR TV.FBizStatus =   ");
            sql.append(3);
            sql.append("  \r\n");
        }
        sql.append(") AND \r\n");
        if (condition.getOptionNotIncludePLVoucher()) {
            sql.append(" TV.FSourceType != ").append(1);
            sql.append(" AND \r\n");
        }
        if (partner.getAccountViewInfo().isIsLeaf()) {
            sql.append("\tTVE.FAccountID = '");
            sql.append(partner.getAccountViewInfo().getId().toString());
            sql.append("' AND \r\n");
        } else {
            sql.append("\tTVE.FAccountID IN (");
            sql.append(this.getChildAccountIds(partner, partner.getAccountViewInfo()));
            sql.append(") AND \r\n");
        }
        if (partner.getCurrencyType() == 0 && !condition.isAllCurrency()) {
            sql.append("\tTVE.FCurrencyID = ? AND \r\n");
        } else if (condition.isAllCurrency()) {
            sql.append("\tTVE.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' and TVE.FCurrencyId <> '22222222-2222-2222-2222-222222222222DEB58FDC'  and\t\t\r\n");
        }
        sql.append("\tTP.FNumber>=? AND \r\n");
        sql.append("\tTP.FNumber<=? AND \r\n");
        sql.append("\tTP.FTypeID = ? \r\n");
        boolean isAsstFilter = false;
        List asstTable = condition.getTableData();
        int size = asstTable.size();
        for (int i = 0; i < size; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)asstTable.get(i);
            if (!at.isSelected()) continue;
            isAsstFilter = true;
            break;
        }
        if (!isAsstFilter) {
            sql.append("\tand AV.FCAA is null \r\n");
        } else {
            sql.append("\tand AV.FCAA is not null \r\n");
        }
        if (tableValue != null && tableValue.get("cond") != null) {
            sql.append("  and " + tableValue.get("cond").toString());
        }
        Context ctx = partner.getContext();
        BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        BOSUuid cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
        String rule = PermissionServiceProviderFactory.getLocalInstance((Context)ctx).getPermissionRule((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(cuId), "bd_assistant_voucherType_view");
        String p = null;
        if (!StringUtils.isEmpty((String)rule)) {
            p = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(cuId), "bd_assistant_voucherType_view");
            sql.append("    and TVT.FID IN \n(" + p + ")");
        }
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValueChar(partner.getCompanyId());
        parameter.addValueChar(partner.getCompanyId());
        if (partner.getCurrencyType() == 0 && !condition.isAllCurrency()) {
            parameter.addValueChar(condition.getCurrencyID());
        }
        parameter.addValue(new Integer(condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart()));
        parameter.addValue(new Integer(condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()));
        parameter.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        sql.append(" UNION ALL \r\n");
        sql.append("SELECT TV.FBookedDate,TVAR.FBizDate,TV.fnumber,TVT.fnumber,TVT.FName");
        sql.append(partner.getFieldNameExtend());
        sql.append(",TV.FCREATETIME, \r\n");
        sql.append(" TVE.FSeq * 1000 + TVAR.FSeq FSeq,\r\n");
        sql.append("(CASE WHEN TVAR.FDescription is not null THEN TVAR.FDescription ELSE TVE.FDescription END ) FDescription, \r\n");
        if (condition.getOptionShowAccountCusAttribute()) {
            sql.append(" TST.FName");
            sql.append(partner.getFieldNameExtend());
            sql.append(" FSettlementType,");
            sql.append(" TVAR.FSettlementCode,");
            sql.append(" TVAR.FBizNumber, ");
            sql.append(" TVAR.FTicketNumber,TVAR.FInvoiceNumber,");
            sql.append(" (case when TVAR.FFeeType=1 then '" + FeeTypeEnum.getEnum((int)1).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=2 then '" + FeeTypeEnum.getEnum((int)2).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=3 then '" + FeeTypeEnum.getEnum((int)3).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=4 then '" + FeeTypeEnum.getEnum((int)4).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=5 then '" + FeeTypeEnum.getEnum((int)5).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=6 then '" + FeeTypeEnum.getEnum((int)6).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=7 then '" + FeeTypeEnum.getEnum((int)7).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=8 then '" + FeeTypeEnum.getEnum((int)8).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=9 then '" + FeeTypeEnum.getEnum((int)9).getAlias() + "'");
            sql.append("       when TVAR.FFeeType=10 then '" + FeeTypeEnum.getEnum((int)10).getAlias() + "'");
            sql.append("       else '' end)as FFeeType,");
            sql.append(" THdl.FName");
            sql.append(partner.getFieldNameExtend());
            sql.append(" FHandler, ");
        }
        if (partner.getCurrencyType() == 1) {
            this.addDebitCreditFieldSQL(sql, "TVAR.FLocalAmount", "0", "For");
        } else if (partner.getCurrencyType() == 2) {
            this.addDebitCreditFieldSQL(sql, "TVAR.FReportingAmount", "0", "For");
        } else {
            this.addDebitCreditFieldSQL(sql, "TVAR.FOriginalAmount", "0", "For");
        }
        sql.append(" TVE.FLocalExchangeRate FLocalRate,\r\n");
        sql.append(" TVE.FReportingExchangeRate FRptRate,\r\n");
        this.addDebitCreditFieldSQL(sql, "TVAR.FLocalAmount", "0", "Local");
        this.addDebitCreditFieldSQL(sql, "TVAR.FReportingAmount", "0", "Rpt");
        if (this.isShowQuantity) {
            boolean isQtyAsst = partner.getParmQtyAsst();
            if (!isQtyAsst || isQtyAsst && partner.getAccountViewInfo().isIsQty() && partner.getAccountViewInfo().getCAA() != null && !partner.getAccountViewInfo().getCAA().isIsQty()) {
                this.addDebitCreditFieldSQL(sql, "TVAR.FMeasureUnitID", "NULL", "UnitId");
                this.addDebitCreditFieldSQL(sql, "TVAR.FQuantity", "0", "Qty");
                this.addDebitCreditFieldSQL(sql, "TVAR.FStandardQuantity", "0", "QtyDefault");
                this.addDebitCreditFieldSQL(sql, "TVE.FPrice", "NULL", "Price");
                if (this.isShowQuantity && this.getPar(partner)) {
                    this.addDebitCreditFieldSQL(sql, "MUI.FName_l2", "NULL", "AssistUnit");
                    this.addDebitCreditFieldSQL(sql, "TVAR.FAssistPrice", "0", "AssistPrice");
                    this.addDebitCreditFieldSQL(sql, "TVAR.FAssistQty", "0", "AssistQty");
                }
            } else {
                this.addDebitCreditFieldSQL(sql, "TVAR.FMeasureUnitID", "NULL", "UnitId");
                this.addDebitCreditFieldSQL(sql, "TVAR.FQuantity", "0", "Qty");
                this.addDebitCreditFieldSQL(sql, "TVAR.FStandardQuantity", "0", "QtyDefault");
                this.addDebitCreditFieldSQL(sql, "TVAR.FPrice", "NULL", "Price");
                if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
                    this.addDebitCreditFieldSQL(sql, "MUI.FName_l2", "NULL", "AssistUnit");
                    this.addDebitCreditFieldSQL(sql, "TVAR.FAssistPrice", "0", "AssistPrice");
                    this.addDebitCreditFieldSQL(sql, "TVAR.FAssistQty", "0", "AssistQty");
                }
            }
        }
        if (partner.getAccountViewInfo().isIsQty()) {
            sql.append("(CASE WHEN MUG.fdefaultunitid IS NOT NULL THEN MUG.fdefaultunitid ELSE AV.FMeasureUnitID END ) FBalanceUnitId, \r\n");
        } else {
            sql.append("(CASE WHEN MUG.fdefaultunitid IS NOT NULL THEN MUG.fdefaultunitid ELSE TVAR.FMeasureUnitID END ) FBalanceUnitId, \r\n");
        }
        sql.append("\t0 FLineType,TV.FID FVoucherID, \r\n");
        if (condition.isAllCurrency()) {
            sql.append("    TVE.FCurrencyid FCurrencyid, \r\n");
        }
        sql.append("\tTP.FPeriodYear  FPeriodYear,TP.FPeriodNumber FPeriodNumber \r\n");
        if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
            sql.append(" ,2 FAccountOrAssist, \t\r\n");
            sql.append(" HG.FCount FCount,  \t\r\n");
            sql.append(" HG.FID   FAsstAccountPerId, \r\n");
            Locale loc = partner.getContext().getLocale();
            sql.append(" Replace(");
            sql.append("HG.FNumberGroup_");
            sql.append(loc);
            sql.append(", '_!', ' ')");
            sql.append("FNumberGroupAsst, \r\n");
            sql.append(" HG.FdisplaynameGroup_").append(loc).append(" FdisplaynameGroup, \r\n");
            sql.append(" HG.FNumberGroup_").append(loc).append(" FNumberGroup, \r\n");
            sql.append(" HG.flongnamegroup_").append(loc);
            sql.append(" FAsstAccountName  \t\r\n");
        }
        if (isChkSum) {
            sql.append(" ,AV.FID accountid \r\n");
        }
        sql.append("FROM T_GL_Voucher TV \r\n");
        sql.append("\tINNER JOIN T_BD_VoucherTypes TVT \r\n ");
        sql.append("\tON TV.FVoucherTypeID = TVT.FID \r\n");
        sql.append("\tINNER JOIN T_GL_VoucherEntry TVE \r\n");
        sql.append("\tON TV.FID = TVE.FBillID \r\n");
        sql.append("\tINNER JOIN T_BD_Period TP \r\n");
        sql.append("\tON TV.FPeriodID = TP.FID \r\n");
        sql.append("\tINNER JOIN T_GL_VoucherAssistRecord TVAR  \r\n");
        sql.append("\tON TVE.FID = TVAR.FentryID \r\n");
        sql.append("\tLEFT JOIN T_BD_AssistantHG HG \r\n");
        sql.append("\tON TVAR.FAssGrpID = HG.FID \r\n");
        if (partner.getAccountViewInfo().isAC() || partner.getAccountViewInfo().isIsBank() || partner.getAccountViewInfo().isHasUserProperty() || condition.getOptionShowAccountCusAttribute()) {
            sql.append("\tLEFT OUTER JOIN T_BD_SettlementType TST  \r\n");
            sql.append("\tON TST.FID = TVAR.FSettlementTypeID \r\n");
            sql.append(" LEFT OUTER JOIN T_PM_User THdl \r\n");
            sql.append(" ON THdl.FID = TVAR.FHandlerID \r\n");
        }
        sql.append("\tINNER JOIN T_BD_AccountView AV \r\n");
        sql.append("\tON TVE.FAccountID =AV.FID AND AV.FCompanyID = TV.FCompanyID \r\n");
        sql.append("\tLEFT JOIN t_bd_measureunitgroup MUG \r\n");
        sql.append("\tON AV.FMeasureUnitGroupID=MUG.fid \r\n");
        if ((condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) && this.isShowQuantity && this.getPar(partner)) {
            sql.append("\tLEFT JOIN T_BD_MeasureUnit MUI ON TVAR.FAssistUnit=MUI.fid \r\n");
        }
        table.clear();
        table.put("VOUCHER", "TV");
        table.put("ENTRIES", "TVE");
        table.put("VOUCHERTYPE", "TVT");
        table.put("PERIOD", "TP");
        table.put("ACCOUNTVIEW", "AV");
        table.put("ASSISTRECORDS", "TVAR");
        if (condition.getOptionShowAccountCusAttribute()) {
            table.put("SETTLEMENTTYPE", "TST");
            table.put("ASSHANDLER", "THdl");
        }
        if ((tableValue = RptServerUtil.getRptSelfCongdition(partner.getContext(), partner.getCondition(), table, true, condition.getOptionShowAccountCusAttribute())) != null && tableValue.get("join") != null) {
            sql.append(tableValue.get("join").toString());
        }
        sql.append(" WHERE TV.FCompanyID = ? \r\n");
        sql.append(" AND TV.FCompanyID = ? AND \r\n");
        if (condition.getOptionPosting()) {
            sql.append("\t(TV.FBizStatus = ");
            sql.append(1);
            sql.append(" OR TV.FBizStatus = ");
            sql.append(3);
            sql.append(" OR TV.FBizStatus = ");
            sql.append(5);
            sql.append(" ) AND \r\n");
        } else {
            sql.append("\tTV.FBizStatus = ");
            sql.append(5);
            sql.append(" AND \r\n");
        }
        if (condition.getOptionNotIncludePLVoucher()) {
            sql.append(" TV.FSourceType != ").append(1);
            sql.append(" AND \r\n");
        }
        if (partner.getAccountViewInfo().isIsLeaf()) {
            sql.append("\tTVE.FAccountID = '");
            sql.append(partner.getAccountViewInfo().getId().toString());
            sql.append("' AND \r\n");
        } else {
            sql.append("\tTVE.FAccountID IN (");
            sql.append(this.getChildAccountIds(partner, partner.getAccountViewInfo()));
            sql.append(") AND \r\n");
        }
        if (partner.getCurrencyType() == 0 && !condition.isAllCurrency()) {
            sql.append("\tTVE.FCurrencyID = ? AND \r\n");
        } else if (condition.isAllCurrency()) {
            sql.append("\tTVE.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' and TVE.FCurrencyId <> '22222222-2222-2222-2222-222222222222DEB58FDC'  and\t\t\r\n");
        }
        sql.append(" TP.FNumber>=? AND \r\n");
        sql.append(" TP.FNumber<=? AND \r\n");
        sql.append(" TP.FTypeID =? \r\n");
        if (tableValue != null && tableValue.get("cond") != null) {
            sql.append("  and " + tableValue.get("cond").toString());
        }
        if (!StringUtils.isEmpty((String)rule)) {
            sql.append("    and TVT.FID IN \n(" + p + ")");
        }
        parameter.addValueChar(partner.getCompanyId());
        parameter.addValueChar(partner.getCompanyId());
        if (partner.getCurrencyType() == 0 && !condition.isAllCurrency()) {
            parameter.addValueChar(condition.getCurrencyID());
        }
        parameter.addValue(new Integer(condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart()));
        parameter.addValue(new Integer(condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()));
        parameter.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        SqlParams AsstWhereSp = new SqlParams();
        sql.append(" and ");
        try {
            sql.append(RptServerUtil.GetAsstSqlWithoutPermissionFilter(ctx, condition.getTableData(), condition.getOptionAsstGroup(), true, "TVAR.FAssGrpID", AsstWhereSp));
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, AsstactTypeEntity> actTypes = new HashMap<String, AsstactTypeEntity>();
        boolean needHandlePerm = false;
        List tblData = condition.getTableData();
        int size2 = tblData.size();
        for (int i = 0; i < size2; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)tblData.get(i);
            actTypes.put(at.getId().toString(), at);
            if (!at.isEnabledPermissionLimit()) continue;
            needHandlePerm = true;
        }
        if (needHandlePerm) {
            HashMap<String, ArrayList<String>> acct2ActType = new HashMap<String, ArrayList<String>>();
            HashSet<String> intersectActType = new HashSet<String>();
            StringBuffer sqlAsstPerm = new StringBuffer();
            sqlAsstPerm.append("select a.fid accountid,d.fid acttypeid \r\n");
            sqlAsstPerm.append("from t_bd_accountview a \r\n");
            sqlAsstPerm.append("inner join T_BD_AsstAccount b on a.fcaa=b.fid \r\n");
            sqlAsstPerm.append("inner join T_BD_AsstActGroupDetail c on c.FAsstAccountID=b.fid \r\n");
            sqlAsstPerm.append("inner join T_BD_AsstActType d on d.fid=c.FAsstActTypeID \r\n");
            sqlAsstPerm.append("where a.fcompanyid=? and a.faccounttableid=? and a.fisleaf=1 and a.flongnumber like ? \r\n");
            IRowSet rsActType = DbUtil.executeQuery((Context)partner.getContext(), (String)sqlAsstPerm.toString(), (Object[])new Object[]{partner.getCompanyId(), partner.getAccountTableId(), partner.getAccountViewInfo().getLongNumber() + "%"});
            try {
                while (rsActType.next()) {
                    ArrayList<String> list = (ArrayList<String>)acct2ActType.get(rsActType.getString("accountid"));
                    if (list == null) {
                        list = new ArrayList<String>();
                        acct2ActType.put(rsActType.getString("accountid"), list);
                    }
                    list.add(rsActType.getString("acttypeid"));
                    intersectActType.add(rsActType.getString("acttypeid"));
                }
            }
            catch (SQLException sqle) {
                throw new SQLDataException(sqle);
            }
            HashMap<String, Object[]> asst2PermSql = new HashMap<String, Object[]>();
            IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
            IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
            for (String actTypeId : intersectActType) {
                String asstRule;
                AsstactTypeEntity at = (AsstactTypeEntity)actTypes.get(actTypeId);
                if (at == null || !at.isEnabledPermissionLimit() || StringUtils.isEmpty((String)(asstRule = provider.getPermissionRule((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(cuId), at.getPermissionItem())))) continue;
                String permSql = permission.getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(cuId), at.getPermissionItem());
                asst2PermSql.put(at.getId().toString(), new Object[]{at, permSql});
            }
            if (asst2PermSql.size() > 0) {
                StringBuffer collectAsstPermSql = new StringBuffer();
                StringBuffer acctAsstPermSql = new StringBuffer();
                for (String accountId : acct2ActType.keySet()) {
                    List list = (List)acct2ActType.get(accountId);
                    acctAsstPermSql.setLength(0);
                    int size3 = list.size();
                    for (int i = 0; i < size3; ++i) {
                        Object[] obj = (Object[])asst2PermSql.get(list.get(i));
                        if (obj == null) continue;
                        if (acctAsstPermSql.length() > 0) {
                            acctAsstPermSql.append(" and ");
                        }
                        acctAsstPermSql.append("HG.").append(((AsstactTypeEntity)obj[0]).getHgField()).append(" in (").append(obj[1]).append(")");
                    }
                    if (acctAsstPermSql.length() <= 0) continue;
                    acctAsstPermSql.append(" and TVE.FAccountID='").append(accountId).append("'");
                    if (collectAsstPermSql.length() > 0) {
                        collectAsstPermSql.append(" or ");
                    }
                    collectAsstPermSql.append("(").append(acctAsstPermSql).append(")");
                }
                if (collectAsstPermSql.length() > 0) {
                    sql.append(" and (").append(collectAsstPermSql).append(")");
                }
            }
        }
        if (isChkSum) {
            sql.append(") tmp \r\n");
            sql.append("group by accountid,FVoucherID \r\n");
            if (isRdoIsAccountAndDesc) {
                sql.append(",FDescription_tve \r\n");
            }
            if (isChkIsZeroNoDisplay) {
                sql.append(") where  \r\n");
                sql.append("not (FDebitFor = 0 and FCreditFor = 0 and FDebitLocal = 0 and  \r\n");
                sql.append("FCreditLocal = 0 and FDebitRpt = 0 and FCreditRpt = 0) \r\n");
            }
        }
        Object[] Asst = AsstWhereSp.getParams();
        for (int i = 0; i < Asst.length; ++i) {
            parameter.addValueChar(Asst[i].toString());
        }
        return partner.executeSql(parameter.getSqlWithParameters(sql.toString()), null);
    }

    protected void addDebitCreditFieldSQL(StringBuffer sql, String fieldName, String elseValue, String asFieldName) {
        sql.append("\t(CASE WHEN TVE.FEntryDC=");
        sql.append(1);
        sql.append(" THEN ");
        sql.append(fieldName);
        sql.append(" ELSE ");
        sql.append(elseValue);
        sql.append(" END) FDebit");
        sql.append(asFieldName);
        sql.append(" ,\r\n");
        sql.append("\t(CASE WHEN TVE.FEntryDC=");
        sql.append(0);
        sql.append(" THEN ");
        sql.append(fieldName);
        sql.append(" ELSE ");
        sql.append(elseValue);
        sql.append(" END) FCredit");
        sql.append(asFieldName);
        sql.append(" ,\r\n");
    }

    protected String getChildAccountIds(ReportPartner partner, AccountViewInfo accountViewInfo) throws BOSException, EASBizException {
        if (accountViewInfo == null) {
            throw new ReportException(ReportException.ACCOUNT_EMPTY);
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TA.FID \r\n ");
        sql.append("FROM T_BD_AccountView---\r\n TA \r\n ");
        sql.append("WHERE TA.FLongNumber like ? \r\n ");
        sql.append("\tAND TA.FAccountTableID = ? \r\n ");
        sql.append("\tAND TA.FCompanyID = ? ");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = partner.getConnection().prepareStatement(sql.toString());
            stmt.setFetchSize(100);
            SqlParameter2 parameter = new SqlParameter2();
            parameter.addValueChar(accountViewInfo.getLongNumber() + "!%");
            parameter.addValueChar(partner.getAccountTableId());
            parameter.addValueChar(partner.getCompanyId());
            parameter.putToStatement(stmt);
            rs = stmt.executeQuery();
            int index = 0;
            while (rs.next()) {
                sb.append(index > 0 ? ",'" : "'");
                sb.append(rs.getString("FID"));
                sb.append(index % 5 == 0 ? "'\r\n" : "'");
                ++index;
            }
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return sb.length() > 0 ? sb.toString() : null;
    }

    protected boolean insertStartBalance(Map startBalance, ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append("\t(FNumber,FName,FDate,FDebitFor,FDebitLocal,FDebitRpt, \r\n");
        if (this.isShowQuantity) {
            sql.append(" FDebitQtyDefault , \r\n");
        }
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
            sql.append(" FCurrencyid,\r\n");
        }
        sql.append("\t FLineType,FPeriodYear,FPeriodNumber) \r\n");
        sql.append("VALUES (?,?,#,?,?,?,");
        if (this.isShowQuantity) {
            sql.append("?,");
        }
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
            sql.append(" ?,");
        }
        sql.append("?,?,?) \r\n");
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
            ArrayList hasInsertCur = new ArrayList();
            for (int i = 0; i < startBalance.size(); ++i) {
                HashMap curStartBalance = (HashMap)startBalance.get(new Integer(i));
                if (curStartBalance.get("FCurrencyid") == null || "".equals(curStartBalance.get("FCurrencyid")) || hasInsertCur.contains(curStartBalance.get("FCurrencyid"))) continue;
                hasInsertCur.add(curStartBalance.get("FCurrencyid"));
                int periodNumberStart = ((ReportConditionSubsidiaryLedger)partner.getFixCondition()).getPeriodNumberStart();
                int periodYearStart = ((ReportConditionSubsidiaryLedger)partner.getFixCondition()).getPeriodYearStart();
                Integer periodNumber = (Integer)curStartBalance.get("FPeriodNumber");
                SqlParameter2 parameter = new SqlParameter2();
                parameter.addValue(startBalance.get("FNumber") == null ? "" : startBalance.get("FNumber"));
                parameter.addValue(startBalance.get("FName") == null ? "" : startBalance.get("FName"));
                if (periodNumberStart < periodNumber) {
                    parameter.addValue(partner.getPeriodTypeID());
                    parameter.addValue(periodYearStart * 100 + periodNumberStart);
                    parameter.addValue(ZERO);
                    parameter.addValue(ZERO);
                    parameter.addValue(ZERO);
                    if (this.isShowQuantity) {
                        parameter.addValue(ZERO);
                    }
                    if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
                        parameter.addValue(curStartBalance.get("FCurrencyid"));
                    }
                    parameter.addValue(new Integer(periodNumber == 1 ? -3 : -2));
                    parameter.addValue(periodNumberStart);
                    parameter.addValue(periodYearStart);
                    partner.executeSql(sql.toString().replaceFirst("#", "(select fbegindate from t_bd_period where ftypeid = ? and fnumber = ?)"), parameter);
                    continue;
                }
                parameter.addValue(curStartBalance.get("FBeginDate"));
                parameter.addValue(curStartBalance.get("FBeginBalanceFor"));
                parameter.addValue(curStartBalance.get("FBeginBalanceLocal"));
                parameter.addValue(curStartBalance.get("FBeginBalanceRpt"));
                if (this.isShowQuantity) {
                    parameter.addValue(curStartBalance.get("FBeginQty"));
                }
                if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
                    parameter.addValue(curStartBalance.get("FCurrencyid"));
                }
                parameter.addValue(new Integer(periodNumber == 1 ? -3 : -2));
                parameter.addValue(curStartBalance.get("FPeriodYear"));
                parameter.addValue(curStartBalance.get("FPeriodNumber"));
                partner.executeSql(sql.toString().replaceFirst("#", "?"), parameter);
            }
        } else {
            Integer periodNumber;
            SqlParameter2 parameter = new SqlParameter2();
            parameter.addValue(startBalance.get("FNumber") == null ? "" : startBalance.get("FNumber"));
            parameter.addValue(startBalance.get("FName") == null ? "" : startBalance.get("FName"));
            parameter.addValue(startBalance.get("FBeginDate"));
            parameter.addValue(startBalance.get("FBeginBalanceFor"));
            parameter.addValue(startBalance.get("FBeginBalanceLocal"));
            parameter.addValue(startBalance.get("FBeginBalanceRpt"));
            if (this.isShowQuantity) {
                parameter.addValue(startBalance.get("FBeginQty"));
            }
            if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
                parameter.addValue(startBalance.get("FCurrencyid"));
            }
            parameter.addValue(new Integer((periodNumber = (Integer)startBalance.get("FPeriodNumber")) == 1 ? -3 : -2));
            parameter.addValue(startBalance.get("FPeriodYear"));
            parameter.addValue(startBalance.get("FPeriodNumber"));
            partner.executeSql(sql.toString().replaceFirst("#", "?"), parameter);
        }
        return true;
    }

    protected HashMap getStartBalance(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \r\n");
        sql.append("\tTP.FBeginDate,TP.FPeriodYear,TP.FPeriodNumber,\r\n");
        if (condition.isAllCurrency()) {
            sql.append("    TB.FCurrencyid , \r\n");
        }
        sql.append(" sum(TB.FBeginBalanceFor) FBeginBalanceFor,sum(FBeginBalanceLocal) FBeginBalanceLocal,sum(FBeginBalanceRpt) FBeginBalanceRpt,\r\n");
        sql.append(" sum(FBeginQty) FBeginQty,\r\n");
        sql.append(" sum(TB.FYearDebitFor - TB.FDebitFor) FYearDebitFor,\r\n");
        sql.append(" sum(TB.FYearDebitLocal - TB.FDebitLocal) FYearDebitLocal,\r\n");
        sql.append(" sum(TB.FYearDebitRpt - TB.FDebitRpt) FYearDebitRpt,\r\n");
        sql.append(" sum(TB.FYearDebitQty - TB.FDebitQty) FYearDebitQty,\r\n");
        sql.append(" sum(TB.FYearCreditFor - TB.FCreditFor) FYearCreditFor, \r\n");
        sql.append(" sum(TB.FYearCreditLocal - TB.FCreditLocal) FYearCreditLocal, \r\n");
        sql.append(" sum(TB.FYearCreditRpt - TB.FCreditRpt) FYearCreditRpt, \r\n");
        sql.append(" sum(TB.FYearCreditQty - TB.FCreditQty) FYearCreditQty \r\n");
        sql.append(" from  ").append(this.getGeneralLedgerTableName(partner) + " TB \r\n");
        sql.append(" RIGHT OUTER JOIN T_BD_Period TP ON TB.FPeriodID = TP.FID \r\n");
        sql.append(" AND TB.FBalType = ? \r\n");
        sql.append(" AND TB.FOrgUnitID = ?  \r\n");
        sql.append(" AND TB.FAccountID = ?  \r\n");
        if (!condition.isAllCurrency()) {
            sql.append(" AND TB.FCurrencyID = ?  \r\n");
        }
        sql.append("WHERE TP.FTypeID = ? AND \r\n");
        int[] periodRange = new int[]{condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart(), condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()};
        sql.append(SQLUtil.getPeriodCondition("TP.FNumber", periodRange));
        if (condition.isAllCurrency()) {
            sql.append(" AND TB.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' and TB.FCurrencyId <> '22222222-2222-2222-2222-222222222222DEB58FDC'  \t\t\r\n");
        }
        sql.append("\r\n group by TP.FBeginDate,TP.FPeriodYear,TP.FPeriodNumber \r\n");
        if (condition.isAllCurrency()) {
            sql.append(", TB.FCurrencyid  \r\n");
        }
        sql.append(" order by fbegindate");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(new Integer(condition.getOptionPosting() ? 1 : 5));
        params.add(partner.getCompanyId());
        params.add(condition.getAccountId());
        if (!condition.isAllCurrency()) {
            params.add(condition.getCurrencyID());
        }
        params.add(partner.getCompany().getAccountPeriodType().getId().toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<Integer, HashMap<String, Object>> curMap = new HashMap<Integer, HashMap<String, Object>>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)partner.getContext(), (String)sql.toString(), (Object[])params.toArray());
            int ci = 0;
            if (rs.next()) {
                do {
                    BigDecimal val;
                    map.put("FBeginDate", rs.getTimestamp("FBeginDate"));
                    map.put("FPeriodYear", new Integer(rs.getInt("FPeriodYear")));
                    map.put("FPeriodNumber", new Integer(rs.getInt("FPeriodNumber")));
                    if (condition.isAllCurrency()) {
                        map.put("FCurrencyid", rs.getString("FCurrencyid"));
                    }
                    map.put("FBeginBalanceFor", (val = rs.getBigDecimal("FBeginBalanceFor")) == null ? ZERO : val);
                    val = rs.getBigDecimal("FBeginBalanceLocal");
                    map.put("FBeginBalanceLocal", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FBeginBalanceRpt");
                    map.put("FBeginBalanceRpt", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FBeginQty");
                    map.put("FBeginQty", val == null ? ZERO : val.setScale(10, 4));
                    val = rs.getBigDecimal("FYearDebitFor");
                    map.put("FYearDebitFor", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearCreditFor");
                    map.put("FYearCreditFor", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearDebitLocal");
                    map.put("FYearDebitLocal", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearCreditLocal");
                    map.put("FYearCreditLocal", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearDebitRpt");
                    map.put("FYearDebitRpt", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearCreditRpt");
                    map.put("FYearCreditRpt", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearDebitQty");
                    map.put("FYearDebitQty", val == null ? ZERO : val.setScale(10, 4));
                    val = rs.getBigDecimal("FYearCreditQty");
                    map.put("FYearCreditQty", val == null ? ZERO : val.setScale(10, 4));
                    map.put("FDebitAssistPrice", ZERO);
                    map.put("FDebitAssistQty", ZERO);
                    map.put("FCreditAssistPrice", ZERO);
                    map.put("FCreditAssistQty", ZERO);
                    if (!condition.isAllCurrency()) continue;
                    curMap.put(new Integer(ci++), map);
                    map = new HashMap();
                } while (rs.next() && condition.isAllCurrency());
            }
        }
        catch (SQLException sqle) {
            sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
            throw new SQLDataException(sqle);
        }
        if (condition.isAllCurrency()) {
            return curMap;
        }
        return map;
    }

    @Override
    protected void doSomethingBeforeReturn(ReportPartner partner, ReportResultInfo result) throws BOSException, EASBizException {
        super.doSomethingBeforeReturn(partner, result);
        if (partner.getStartIndex() == 0) {
            result.getExtendData().put("Account", partner.getAccountViewInfo());
            result.getExtendData().put("AccountShowLongName", partner.isParmAccountShowLongName());
        }
    }

    @Override
    protected String getAuthoritySql(ReportPartner partner, String authorityName) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String getReportName() {
        return "SubsidiaryLedger";
    }

    @Override
    protected String getAuthorityName() {
        return "SubsidiaryLedger";
    }

    protected String getQueryName() {
        return "SubsidiaryLedger";
    }

    @Override
    protected boolean isSupportVirtual() {
        return false;
    }

    protected String getGeneralLedgerTableName(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        boolean isAfterCurrPeriod = partner.getCurrentPeriod().getNumber() < condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart();
        int balType = condition.getOptionPosting() ? 1 : 5;
        return isAfterCurrPeriod ? "V_GL_AccountBalance" : GLBalanceUtils.getAccountBalanceTable(balType, condition.getCurrencyID());
    }

    protected int getScaleFor(ReportPartner partner, String curId) throws BOSException, EASBizException {
        if (partner.getFixCondition().isAllCurrency()) {
            if (curId != null) {
                return partner.getAmountScale(curId);
            }
            return 2;
        }
        return partner.getScaleFor();
    }

    @Override
    protected Collection executeSqlForData(Context ctx, ReportPartner partner) throws BOSException, EASBizException {
        String sqlFrom = this.getSqlForDataFrom(partner);
        if (sqlFrom == null) {
            return new ArrayList();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        String sqlSelect = this.getSqlForDataSelect(partner);
        if (sqlSelect == null || sqlSelect.length() == 0) {
            throw new ReportException(ReportException.SQL_SELECT_EMPTY);
        }
        sql.append(sqlSelect);
        sql.append(" from (select T.* \r\n");
        if (((ReportConditionSubsidiaryLedger)partner.getFixCondition()).isAllCurrency()) {
            sql.append(", cc.fname").append(partner.getFieldNameExtend()).append(" FCurrencyName ,\r\n");
            sql.append(" cc.fnumber fcurrencynumber \r\n");
        }
        sql.append(sqlFrom);
        sql.append("\r\n");
        sql.append(") t_out where KSQL_SEQ >= ? and KSQL_SEQ <= ? ");
        sql.append(" order by KSQL_SEQ ");
        SqlParameter2 parameters = new SqlParameter2();
        parameters.addValue(partner.getStartIndex() + 1);
        parameters.addValue(partner.getStartIndex() + (Integer)partner.getVariable(COUNT));
        this.setParameters(partner, parameters);
        Collection cols = this.getDataFormSQL(ctx, partner, sql.toString());
        return cols;
    }

    @Override
    protected void doSomethingBeforeExecuteSql(ReportPartner partner) throws BOSException, EASBizException {
        partner.setVariable(COUNT, new Integer(partner.getLineCount()));
        boolean isQtyAsst = partner.getParmQtyAsst();
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        this.isShowQuantity = this.getIsShowQuantity(partner);
        if (condition.getOptionOnlyAsst() || condition.getAssisthgId() != null) {
            this.isShowUnit = true;
        }
    }

    public boolean isShowQuantity() {
        return this.isShowQuantity;
    }

    public void setShowQuantity(boolean isShowQuantity) {
        this.isShowQuantity = isShowQuantity;
    }

    protected HashMap getStartAsstBalance(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        Context ctx = partner.getContext();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sqlSubQuery = new StringBuffer();
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        sqlSubQuery.append("SELECT \r\n");
        sqlSubQuery.append("\tTP.FBeginDate,TP.FPeriodYear,TP.FPeriodNumber,\r\n");
        if (condition.isAllCurrency()) {
            sqlSubQuery.append("    TB_FCurrencyid , \r\n");
        }
        sqlSubQuery.append(" sum(case when TBA_FBALTYPE IS NULL then TB_FBeginBalanceFor else TBA_FBeginBalanceFor end) FBeginBalanceFor,\r\n");
        sqlSubQuery.append(" sum(case when TBA_FBALTYPE IS NULL then TB_FBeginBalanceLocal else TBA_FBeginBalanceLocal end) FBeginBalanceLocal, \r\n");
        sqlSubQuery.append(" sum(case when TBA_FBALTYPE IS NULL then TB_FBeginBalanceRpt else TBA_FBeginBalanceRpt end) FBeginBalanceRpt, \r\n");
        sqlSubQuery.append(" sum(case when TBA_FBALTYPE IS NULL then TB_FBeginQty else TBA_FBeginQty end) FBeginQty,\r\n");
        sqlSubQuery.append(" sum(case when TBA_FBALTYPE IS NULL then TB_FYearDebitFor - TB_FDebitFor else TBA_FYearDebitFor - TBA_FDebitFor end) FYearDebitFor,\r\n");
        sqlSubQuery.append(" sum(case when TBA_FBALTYPE IS NULL then TB_FYearDebitLocal - TB_FDebitLocal else TBA_FYearDebitLocal - TBA_FDebitLocal end) FYearDebitLocal,\r\n");
        sqlSubQuery.append(" sum(case when TBA_FBALTYPE IS NULL then TB_FYearDebitRpt - TB_FDebitRpt else TBA_FYearDebitRpt - TBA_FDebitRpt end) FYearDebitRpt,\r\n");
        sqlSubQuery.append(" sum(case when TBA_FBALTYPE IS NULL then TB_FYearDebitQty - TB_FDebitQty else TBA_FYearDebitQty - TBA_FDebitQty end) FYearDebitQty,\r\n");
        sqlSubQuery.append(" sum(case when TBA_FBALTYPE IS NULL then TB_FYearCreditFor - TB_FCreditFor else TBA_FYearCreditFor - TBA_FCreditFor end) FYearCreditFor, \r\n");
        sqlSubQuery.append(" sum(case when TBA_FBALTYPE IS NULL then TB_FYearCreditLocal - TB_FCreditLocal else TBA_FYearCreditLocal - TBA_FCreditLocal end) FYearCreditLocal, \r\n");
        sqlSubQuery.append(" sum(case when TBA_FBALTYPE IS NULL then TB_FYearCreditRpt - TB_FCreditRpt else TBA_FYearCreditRpt - TBA_FCreditRpt end) FYearCreditRpt, \r\n");
        sqlSubQuery.append(" sum(case when TBA_FBALTYPE IS NULL then TB_FYearCreditQty - TB_FCreditQty else TBA_FYearCreditQty - TBA_FCreditQty end) FYearCreditQty \r\n");
        sqlSubQuery.append(" from T_BD_Period  TP left outer join (select tb.FPeriodID,  \r\n");
        sqlSubQuery.append(" TBA.FBALTYPE TBA_FBALTYPE,TB.FBeginBalanceFor TB_FBeginBalanceFor,TBA.FBeginBalanceFor TBA_FBeginBalanceFor,  \r\n");
        sqlSubQuery.append(" TB.FBeginBalanceLocal TB_FBeginBalanceLocal,TBA.FBeginBalanceLocal TBA_FBeginBalanceLocal, \r\n");
        sqlSubQuery.append(" TB.FBeginBalanceRpt TB_FBeginBalanceRpt,TBA.FBeginBalanceRpt TBA_FBeginBalanceRpt, \r\n");
        sqlSubQuery.append(" TB.FBeginQty TB_FBeginQty,TBA.FBeginQty TBA_FBeginQty, \r\n");
        sqlSubQuery.append(" TB.FYearDebitFor TB_FYearDebitFor, TB.FDebitFor TB_FDebitFor,TBA.FYearDebitFor TBA_FYearDebitFor, \r\n");
        sqlSubQuery.append(" TBA.FDebitFor TBA_FDebitFor,TB.FYearDebitLocal TB_FYearDebitLocal, TB.FDebitLocal TB_FDebitLocal, \r\n");
        sqlSubQuery.append(" TBA.FYearDebitLocal TBA_FYearDebitLocal, TBA.FDebitLocal TBA_FDebitLocal, \r\n");
        sqlSubQuery.append(" TB.FYearDebitRpt TB_FYearDebitRpt, TB.FDebitRpt TB_FDebitRpt,TBA.FYearDebitRpt TBA_FYearDebitRpt,  \r\n");
        sqlSubQuery.append(" TBA.FDebitRpt TBA_FDebitRpt,TB.FYearDebitQty TB_FYearDebitQty, TB.FDebitQty TB_FDebitQty, \r\n");
        sqlSubQuery.append(" TBA.FYearDebitQty TBA_FYearDebitQty, TBA.FDebitQty TBA_FDebitQty,TB.FYearCreditFor TB_FYearCreditFor, TB.FCreditFor TB_FCreditFor, \r\n");
        sqlSubQuery.append(" TBA.FYearCreditFor TBA_FYearCreditFor, TBA.FCreditFor TBA_FCreditFor, \r\n");
        sqlSubQuery.append(" TB.FYearCreditLocal TB_FYearCreditLocal, TB.FCreditLocal TB_FCreditLocal, \r\n");
        sqlSubQuery.append(" TBA.FYearCreditLocal TBA_FYearCreditLocal, TBA.FCreditLocal TBA_FCreditLocal, \r\n");
        sqlSubQuery.append(" TB.FYearCreditRpt TB_FYearCreditRpt, TB.FCreditRpt TB_FCreditRpt, \r\n");
        sqlSubQuery.append(" TBA.FYearCreditRpt TBA_FYearCreditRpt, TBA.FCreditRpt TBA_FCreditRpt, \r\n");
        sqlSubQuery.append(" TB.FYearCreditQty TB_FYearCreditQty, TB.FCreditQty TB_FCreditQty, \r\n");
        sqlSubQuery.append(" TBA.FYearCreditQty TBA_FYearCreditQty, TBA.FCreditQty TBA_FCreditQty \r\n");
        if (condition.isAllCurrency()) {
            sqlSubQuery.append("    ,TB.FCurrencyid TB_FCurrencyid \r\n");
        }
        sqlSubQuery.append(" from  ").append(this.getGeneralLedgerTableName(partner) + " TB \r\n");
        boolean isAfterCurrPeriod = partner.getCurrentPeriod().getNumber() < condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart();
        int balType = condition.getOptionPosting() ? 1 : 5;
        sqlSubQuery.append(" left join ").append(isAfterCurrPeriod ? "V_GL_AssistBalance" : GLBalanceUtils.getAssistBalanceTable(balType, condition.getCurrencyID())).append(" TBA \r\n");
        sqlSubQuery.append(" on TB.FBALTYPE=TBA.FBALTYPE AND TB.FORGUNITID=TBA.FORGUNITID AND TB.FACCOUNTID=TBA.FACCOUNTID ");
        sqlSubQuery.append(" AND TB.FCURRENCYID=TBA.FCURRENCYID AND TB.FPERIODID=TBA.FPERIODID \r\n");
        sqlSubQuery.append(" left join T_BD_AssistantHG HG ON TBA.FAssistGrpID = HG.FID \r\n");
        sqlSubQuery.append(" inner join t_bd_accountview ta on tb.faccountid=ta.fid \r\n");
        sqlSubQuery.append("WHERE 1 = 1 \r\n");
        if (condition.isAllCurrency()) {
            sqlSubQuery.append(" AND TB.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' and TB.FCurrencyId <> '22222222-2222-2222-2222-222222222222DEB58FDC'  \t\t\r\n");
        }
        SqlParams AsstWhereSp = new SqlParams();
        sqlSubQuery.append(" and ");
        try {
            sqlSubQuery.append(RptServerUtil.GetAsstSqlWithoutPermissionFilter(ctx, condition.getTableData(), condition.getOptionAsstGroup(), true, "TBA.FAssistGrpID", AsstWhereSp));
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        Object[] Asst = AsstWhereSp.getParams();
        for (int i = 0; i < Asst.length; ++i) {
            sqlParams.add(Asst[i].toString());
        }
        HashMap<String, AsstactTypeEntity> actTypes = new HashMap<String, AsstactTypeEntity>();
        boolean needHandlePerm = false;
        List tblData = condition.getTableData();
        int size = tblData.size();
        for (int i = 0; i < size; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)tblData.get(i);
            actTypes.put(at.getId().toString(), at);
            if (!at.isEnabledPermissionLimit()) continue;
            needHandlePerm = true;
        }
        if (needHandlePerm) {
            HashMap<String, ArrayList<String>> acct2ActType = new HashMap<String, ArrayList<String>>();
            HashSet<String> intersectActType = new HashSet<String>();
            StringBuffer sqlAsstPerm = new StringBuffer();
            sqlAsstPerm.append("select a.fid accountid,d.fid acttypeid \r\n");
            sqlAsstPerm.append("from t_bd_accountview a \r\n");
            sqlAsstPerm.append("inner join T_BD_AsstAccount b on a.fcaa=b.fid \r\n");
            sqlAsstPerm.append("inner join T_BD_AsstActGroupDetail c on c.FAsstAccountID=b.fid \r\n");
            sqlAsstPerm.append("inner join T_BD_AsstActType d on d.fid=c.FAsstActTypeID \r\n");
            sqlAsstPerm.append("where a.fcompanyid=? and a.faccounttableid=? and a.fisleaf=1 and a.flongnumber like ? \r\n");
            IRowSet rsActType = DbUtil.executeQuery((Context)partner.getContext(), (String)sqlAsstPerm.toString(), (Object[])new Object[]{partner.getCompanyId(), partner.getAccountTableId(), partner.getAccountViewInfo().getLongNumber() + "%"});
            try {
                while (rsActType.next()) {
                    ArrayList<String> list = (ArrayList<String>)acct2ActType.get(rsActType.getString("accountid"));
                    if (list == null) {
                        list = new ArrayList<String>();
                        acct2ActType.put(rsActType.getString("accountid"), list);
                    }
                    list.add(rsActType.getString("acttypeid"));
                    intersectActType.add(rsActType.getString("acttypeid"));
                }
            }
            catch (SQLException sqle) {
                throw new SQLDataException(sqle);
            }
            HashMap<String, Object[]> asst2PermSql = new HashMap<String, Object[]>();
            IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
            IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
            for (String actTypeId : intersectActType) {
                String asstRule;
                AsstactTypeEntity at = (AsstactTypeEntity)actTypes.get(actTypeId);
                if (at == null || !at.isEnabledPermissionLimit() || StringUtils.isEmpty((String)(asstRule = provider.getPermissionRule((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(cuId), at.getPermissionItem())))) continue;
                String permSql = permission.getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(cuId), at.getPermissionItem());
                asst2PermSql.put(at.getId().toString(), new Object[]{at, permSql});
            }
            if (asst2PermSql.size() > 0) {
                StringBuffer collectAsstPermSql = new StringBuffer();
                StringBuffer acctAsstPermSql = new StringBuffer();
                for (String accountId : acct2ActType.keySet()) {
                    List list = (List)acct2ActType.get(accountId);
                    acctAsstPermSql.setLength(0);
                    int size2 = list.size();
                    for (int i = 0; i < size2; ++i) {
                        Object[] obj = (Object[])asst2PermSql.get(list.get(i));
                        if (obj == null) continue;
                        if (acctAsstPermSql.length() > 0) {
                            acctAsstPermSql.append(" and ");
                        }
                        acctAsstPermSql.append("HG.").append(((AsstactTypeEntity)obj[0]).getHgField()).append(" in (").append(obj[1]).append(")");
                    }
                    if (acctAsstPermSql.length() <= 0) continue;
                    acctAsstPermSql.append(" and TB.FAccountID='").append(accountId).append("'");
                    if (collectAsstPermSql.length() > 0) {
                        collectAsstPermSql.append(" or ");
                    }
                    collectAsstPermSql.append("(").append(acctAsstPermSql).append(")");
                }
                if (collectAsstPermSql.length() > 0) {
                    sqlSubQuery.append(" and (").append(collectAsstPermSql).append(")");
                }
            }
        }
        sqlSubQuery.append(" AND TB.FBalType = ? \r\n");
        sqlSubQuery.append(" AND TB.FOrgUnitID = ?  \r\n");
        if (partner.getAccountViewInfo().isIsLeaf()) {
            sqlSubQuery.append(" AND TB.FAccountID = ?  \r\n");
        } else {
            sqlSubQuery.append("\tAND TA.fisleaf = 1 and TA.FNumber like ?  ");
            if (partner.getAccountTableId() != null && !"".equals(partner.getAccountTableId())) {
                sqlSubQuery.append(" AND TA.FAccountTableid = ?");
            }
        }
        if (!condition.isAllCurrency()) {
            sqlSubQuery.append(" AND TB.FCurrencyID = ?  \r\n");
        }
        sqlSubQuery.append("\r\n ) tmp ON Tmp.FPeriodID = TP.FID where TP.FTypeID = ? and \r\n");
        int[] periodRange = new int[]{condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart(), condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()};
        sqlSubQuery.append(SQLUtil.getPeriodCondition("TP.FNumber", periodRange));
        sqlSubQuery.append("\r\n group by FBeginDate,TP.FPeriodYear,TP.FPeriodNumber \r\n");
        if (condition.isAllCurrency()) {
            sqlSubQuery.append(", TB_FCurrencyid  \r\n");
        }
        sqlSubQuery.append(" order by fbegindate");
        sqlParams.add(new Integer(condition.getOptionPosting() ? 1 : 5));
        sqlParams.add(partner.getCompanyId());
        if (partner.getAccountViewInfo().isIsLeaf()) {
            sqlParams.add(condition.getAccountId());
        } else {
            sqlParams.add(condition.getAccountCodeStart() + "%");
            if (partner.getAccountTableId() != null && !"".equals(partner.getAccountTableId())) {
                sqlParams.add(partner.getAccountTableId());
            }
        }
        if (!condition.isAllCurrency()) {
            sqlParams.add(condition.getCurrencyID());
        }
        sqlParams.add(partner.getCompany().getAccountPeriodType().getId().toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<Integer, HashMap<String, Object>> curMap = new HashMap<Integer, HashMap<String, Object>>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)partner.getContext(), (String)sqlSubQuery.toString(), (Object[])sqlParams.toArray());
            int ci = 0;
            if (rs.next()) {
                do {
                    BigDecimal val;
                    map.put("FBeginDate", rs.getTimestamp("FBeginDate"));
                    map.put("FPeriodYear", new Integer(rs.getInt("FPeriodYear")));
                    map.put("FPeriodNumber", new Integer(rs.getInt("FPeriodNumber")));
                    if (condition.isAllCurrency()) {
                        map.put("FCurrencyid", rs.getString("TB_FCurrencyid"));
                    }
                    map.put("FBeginBalanceFor", (val = rs.getBigDecimal("FBeginBalanceFor")) == null ? ZERO : val);
                    val = rs.getBigDecimal("FBeginBalanceLocal");
                    map.put("FBeginBalanceLocal", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FBeginBalanceRpt");
                    map.put("FBeginBalanceRpt", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FBeginQty");
                    map.put("FBeginQty", val == null ? ZERO : val.setScale(10, 4));
                    val = rs.getBigDecimal("FYearDebitFor");
                    map.put("FYearDebitFor", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearCreditFor");
                    map.put("FYearCreditFor", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearDebitLocal");
                    map.put("FYearDebitLocal", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearCreditLocal");
                    map.put("FYearCreditLocal", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearDebitRpt");
                    map.put("FYearDebitRpt", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearCreditRpt");
                    map.put("FYearCreditRpt", val == null ? ZERO : val);
                    val = rs.getBigDecimal("FYearDebitQty");
                    map.put("FYearDebitQty", val == null ? ZERO : val.setScale(10, 4));
                    val = rs.getBigDecimal("FYearCreditQty");
                    map.put("FYearCreditQty", val == null ? ZERO : val.setScale(10, 4));
                    map.put("FDebitAssistPrice", ZERO);
                    map.put("FDebitAssistQty", ZERO);
                    map.put("FCreditAssistPrice", ZERO);
                    map.put("FCreditAssistQty", ZERO);
                    if (!condition.isAllCurrency()) continue;
                    curMap.put(new Integer(ci++), map);
                    map = new HashMap();
                } while (rs.next() && condition.isAllCurrency());
            } else {
                String sql = "select FBeginDate from t_bd_period where FTypeID=? and fperiodyear=? and fperiodnumber=?";
                rs = DbUtil.executeQuery((Context)partner.getContext(), (String)sql, (Object[])new Object[]{partner.getCompany().getAccountPeriodType().getId().toString(), new Integer(condition.getPeriodYearStart()), new Integer(condition.getPeriodNumberStart())});
                rs.next();
                map.put("FBeginDate", rs.getTimestamp("FBeginDate"));
                map.put("FPeriodYear", new Integer(condition.getPeriodYearStart()));
                map.put("FPeriodNumber", new Integer(condition.getPeriodNumberStart()));
                map.put("FBeginBalanceFor", ZERO);
                map.put("FBeginBalanceLocal", ZERO);
                map.put("FBeginBalanceRpt", ZERO);
                map.put("FBeginQty", ZERO);
                map.put("FYearDebitFor", ZERO);
                map.put("FYearCreditFor", ZERO);
                map.put("FYearDebitLocal", ZERO);
                map.put("FYearCreditLocal", ZERO);
                map.put("FYearDebitRpt", ZERO);
                map.put("FYearCreditRpt", ZERO);
                map.put("FYearDebitQty", ZERO);
                map.put("FYearCreditQty", ZERO);
                map.put("FDebitAssistPrice", ZERO);
                map.put("FDebitAssistQty", ZERO);
                map.put("FCreditAssistPrice", ZERO);
                map.put("FCreditAssistQty", ZERO);
            }
        }
        catch (SQLException sqle) {
            sqle.setNextException(new SQLException("The query sql is:" + sqlSubQuery.toString()));
            throw new SQLDataException(sqle);
        }
        if (condition.isAllCurrency()) {
            return curMap;
        }
        return map;
    }

    protected BigDecimal getAsstQtyCoefficient(Context ctx, String asstActTypeId, String asstActItemId) throws BOSException, EASBizException {
        if (this.accountingCoefficient != null) {
            return this.accountingCoefficient;
        }
        IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        AsstActTypeInfo accountingAsstActType = iAsstActType.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActTypeId));
        if (accountingAsstActType.getGlAsstActTypeGrp() != null) {
            GeneralAsstActTypeInfo accountingAsstAct = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActItemId));
            if (accountingAsstAct != null) {
                if (accountingAsstAct.getMeasureUnit() != null) {
                    this.accountingMeasureUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(accountingAsstAct.getMeasureUnit().getId().toString()));
                    this.accountingCoefficient = this.accountingMeasureUnitInfo.getCoefficient();
                } else if (accountingAsstAct.getMeasureUnitGroup() != null) {
                    this.accountingMeasureUnitInfo = accountingAsstAct.getMeasureUnitGroup().getDefaultUnit();
                    this.accountingCoefficient = GlUtils.one;
                } else if (accountingAsstActType.getMeasureUnit() != null) {
                    this.accountingMeasureUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(accountingAsstActType.getMeasureUnit().getId().toString()));
                    this.accountingCoefficient = this.accountingMeasureUnitInfo.getCoefficient();
                } else if (accountingAsstActType.getMeasureUnitGroup() != null) {
                    this.accountingMeasureUnitInfo = accountingAsstActType.getMeasureUnitGroup().getDefaultUnit();
                    this.accountingCoefficient = GlUtils.one;
                } else {
                    this.accountingMeasureUnitInfo = null;
                    this.accountingCoefficient = GlUtils.one;
                }
            } else {
                this.accountingMeasureUnitInfo = null;
                this.accountingCoefficient = GlUtils.one;
            }
        } else if ("material".equals(accountingAsstActType.getAsstHGAttribute())) {
            MaterialInfo mateial = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(asstActItemId));
            if (mateial != null) {
                if (mateial.getBaseUnit() != null) {
                    String measureunitId = mateial.getBaseUnit().getId().toString();
                    EntityViewInfo view = new EntityViewInfo();
                    view.getSelector().add(new SelectorItemInfo("id"));
                    view.getSelector().add(new SelectorItemInfo("name"));
                    view.getSelector().add(new SelectorItemInfo("number"));
                    view.getSelector().add(new SelectorItemInfo("coefficient"));
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)measureunitId));
                    view.setFilter(filter);
                    this.accountingMeasureUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(view).get(0);
                    this.accountingCoefficient = this.accountingMeasureUnitInfo.getCoefficient();
                } else if (accountingAsstActType.getMeasureUnit() != null) {
                    this.accountingMeasureUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(accountingAsstActType.getMeasureUnit().getId().toString()));
                    this.accountingCoefficient = this.accountingMeasureUnitInfo.getCoefficient();
                } else if (accountingAsstActType.getMeasureUnitGroup() != null) {
                    this.accountingMeasureUnitInfo = accountingAsstActType.getMeasureUnitGroup().getDefaultUnit();
                    this.accountingCoefficient = GlUtils.one;
                } else {
                    this.accountingMeasureUnitInfo = null;
                    this.accountingCoefficient = GlUtils.one;
                }
            } else {
                this.accountingMeasureUnitInfo = null;
                this.accountingCoefficient = GlUtils.one;
            }
        } else if (accountingAsstActType.getMeasureUnit() != null) {
            this.accountingMeasureUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(accountingAsstActType.getMeasureUnit().getId().toString()));
            this.accountingCoefficient = this.accountingMeasureUnitInfo.getCoefficient();
        } else if (accountingAsstActType.getMeasureUnitGroup() != null) {
            this.accountingMeasureUnitInfo = accountingAsstActType.getMeasureUnitGroup().getDefaultUnit();
            this.accountingCoefficient = GlUtils.one;
        } else {
            this.accountingMeasureUnitInfo = null;
            this.accountingCoefficient = GlUtils.one;
        }
        return this.accountingCoefficient;
    }
}

