/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionTrialBalance;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.app.AbstractGLReportTrialBalanceControllerBean;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class GLReportTrialBalanceControllerBean
extends AbstractGLReportTrialBalanceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLReportTrialBalanceControllerBean");
    protected static final String TRIL_ACCOUNT_LEVEL = "TRIL_ACCOUNT_LEVEL";
    protected static final String TRIL_TOTAL_LINE = "TRIL_TOTAL_LINE";

    @Override
    protected String getSqlForDataSelect(ReportPartner partner) throws BOSException, EASBizException {
        return " * ";
    }

    @Override
    protected String getSqlForDataFrom(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sqlFrom = new StringBuffer();
        sqlFrom.append(" FROM \r\n");
        sqlFrom.append(partner.getTempTableName());
        return sqlFrom.toString();
    }

    @Override
    protected String getSqlForDataWhere(ReportPartner partner) throws BOSException, EASBizException {
        return "where 1 = 1  \r\n";
    }

    protected SqlParameter2 getParametersTrialBalance(ReportPartner partner, boolean isOnlyLeaf) throws BOSException, EASBizException {
        String currencyId = partner.getFixCondition().getCurrencyID();
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        }
        SqlParameter2 parameter = new SqlParameter2();
        int period = partner.getFixCondition().getPeriodYearStart() * 100 + partner.getFixCondition().getPeriodNumberStart();
        parameter.addValue(new Integer(period));
        parameter.addValueChar(partner.getCompanyId());
        parameter.addValueChar(partner.getAccountTableId());
        if (!isOnlyLeaf) {
            this.setAccountLevelParameterIndex(partner, parameter.getIndex());
            parameter.addValue(new Integer(partner.getFixCondition().getAccountLevelStart()));
        }
        if (!(isLocalCurrency || isRptCurrency || partner.getFixCondition().isAllCurrency())) {
            parameter.addValueChar(partner.getFixCondition().getCurrencyID());
        }
        return parameter;
    }

    @Override
    protected String getSqlForDataOrder(ReportPartner partner) throws BOSException, EASBizException {
        return "ORDER BY FBWType,FLineType,FAccountNumber,FCurrencyName ";
    }

    @Override
    protected void doSomethingBeforeQuery(ReportPartner partner) throws BOSException, EASBizException {
        super.doSomethingBeforeQuery(partner);
        if (partner.isNewQuery()) {
            partner.setTableHeadInfo(this.getTableHeadInfo(partner));
        }
    }

    @Override
    protected void insertDataIntoTempTable(ReportPartner partner) throws EASBizException, BOSException {
        String strStructure = this.getTempTableStructure();
        String strTempTable = partner.createTempTableAsynchronism("GLREportTrialBal1121", strStructure);
        partner.setTempTableName(strTempTable);
        this.insertTempData(partner, strTempTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTempData(ReportPartner partner, String strTempTable) throws EASBizException, BOSException {
        boolean balanceDirSamAsAccount = partner.isParmBalanceDirSamAsAccount();
        String currencyId = partner.getFixCondition().getCurrencyID();
        String T_AccountBalance = GLBalanceUtils.getBalanceTable(1, partner.getFixCondition().getOptionPosting() ? 1 : 5, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append(" select ");
        sqlSelect.append("    TA.FNumber FAccountNumber,\r\n");
        sqlSelect.append(this.getAccountName(partner));
        sqlSelect.append(partner.getFieldNameExtend());
        sqlSelect.append(" FAccountName, \r\n");
        sqlSelect.append("TA.fbw FBWType ,\r\n");
        if (isForCurrency) {
            sqlSelect.append("    TC.FName");
            sqlSelect.append(partner.getFieldNameExtend());
        } else {
            sqlSelect.append("    ''");
        }
        sqlSelect.append(" FCurrencyName, \r\n");
        if (balanceDirSamAsAccount) {
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then T_Main.FBeginBalanceFor else Null end ) FBeginDebitFor, \r\n");
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then Null else -1 * T_Main.FBeginBalanceFor end ) FBeginCreditFor, \r\n");
        } else {
            sqlSelect.append("    (CASE WHEN T_Main.FBeginBalanceFor > 0 then T_Main.FBeginBalanceFor else Null end ) FBeginDebitFor, \r\n");
            sqlSelect.append("    (CASE WHEN T_Main.FBeginBalanceFor > 0 then Null else -1 * T_Main.FBeginBalanceFor end ) FBeginCreditFor, \r\n");
        }
        sqlSelect.append("    T_Main.FDebitFor FDebitFor, \r\n");
        sqlSelect.append("    T_Main.FCreditFor FCreditFor, \r\n");
        if (balanceDirSamAsAccount) {
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then T_Main.FEndBalanceFor else Null end ) FEndDebitFor, \r\n");
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then Null else -1 * T_Main.FEndBalanceFor end ) FEndCreditFor, \r\n");
        } else {
            sqlSelect.append("    (CASE WHEN T_Main.FEndBalanceFor > 0 ");
            sqlSelect.append(" then T_Main.FEndBalanceFor else Null end ) FEndDebitFor, \r\n");
            sqlSelect.append("    (CASE WHEN T_Main.FEndBalanceFor > 0 ");
            sqlSelect.append(" then Null else -1 * T_Main.FEndBalanceFor end ) FEndCreditFor, \r\n");
        }
        sqlSelect.append(" 1 FLineType\r\n,");
        sqlSelect.append(" TA.FLevel FLevel\r\n,");
        sqlSelect.append(" TA.FIsLeaf FIsLeaf\r\n");
        boolean isOnlyLeaf = ((ReportConditionTrialBalance)partner.getFixCondition()).getOptionOnlyLeaf();
        StringBuffer sqlFrom = new StringBuffer();
        sqlFrom.append("FROM " + T_AccountBalance + " T_Main \r\n");
        sqlFrom.append("\tINNER JOIN T_BD_AccountView TA \r\n");
        sqlFrom.append("\tON T_Main.FAccountID = TA.FID \r\n");
        if (isForCurrency) {
            sqlFrom.append("\tINNER JOIN T_BD_Currency TC \r\n");
            sqlFrom.append("\tON T_Main.FCurrencyID = TC.FID \r\n");
        }
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append("WHERE \r\n");
        if (!((ReportConditionTrialBalance)partner.getFixCondition()).getIncludeBWAccount()) {
            sqlWhere.append("  TA.FBW = 0 and \r\n");
        }
        sqlWhere.append("\tT_Main.FPeriod = ? AND \r\n");
        sqlWhere.append("\tT_Main.FOrgUnitID = ? AND \r\n");
        sqlWhere.append("\tTA.FAccountTableID = ? AND \r\n");
        if (isOnlyLeaf) {
            sqlWhere.append("\tTA.FIsLeaf = 1 AND \r\n");
        } else {
            sqlWhere.append("\tTA.FLevel <= ? AND \r\n");
        }
        if (!(isLocalCurrency || isRptCurrency || partner.getFixCondition().isAllCurrency())) {
            sqlWhere.append("\tT_Main.FCurrencyID = ? AND \r\n");
        }
        sqlWhere.append("\t( \r\n");
        sqlWhere.append("\t\tT_Main.FBeginBalanceFor <> 0 OR \r\n");
        sqlWhere.append("\t\tT_Main.FDebitFor <> 0 OR \r\n");
        sqlWhere.append("\t\tT_Main.FCreditFor <> 0 OR \r\n");
        sqlWhere.append("\t\tT_Main.FEndBalanceFor <> 0 \r\n");
        sqlWhere.append("   ) \r\n");
        this.setPermissionFilter(sqlWhere, partner);
        StringBuffer sqlOrder = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append(sqlSelect).append(sqlFrom).append(this.getParametersTrialBalance(partner, isOnlyLeaf).getSqlWithParameters(sqlWhere.toString())).append(sqlOrder);
        Connection cn = null;
        PreparedStatement stmt = null;
        cn = partner.getConnection();
        String strInsertTable = " insert into " + strTempTable + sql.toString();
        if (isLocalCurrency) {
            strInsertTable = strInsertTable.replaceAll("For", "Local");
        } else if (isRptCurrency) {
            strInsertTable = strInsertTable.replaceAll("For", "Rpt");
        }
        try {
            stmt = cn.prepareStatement(strInsertTable);
            stmt.executeUpdate();
        }
        catch (SQLException sQLException) {
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
        if (((ReportConditionTrialBalance)partner.getFixCondition()).getIncludeBWAccount()) {
            sql.setLength(0);
            sql.append("insert into ").append(strTempTable);
            sql.append(" select ' ',' ',FBWtype,' ',sum(FBeginDebitFor ) FBeginDebitFor ,sum(FBeginCreditFor ) FBeginCreditFor ,sum(FDebitFor ) FDebitFor,sum(FCreditFor ) FCreditFor ,sum(FEndDebitFor ) FEndDebitFor ,sum(FEndCreditFor ) FEndCreditFor,  2 FLineType,to_integer(null),to_integer(null)");
            sql.append("  from ").append("  ").append(strTempTable);
            if (isOnlyLeaf) {
                sql.append(" T_Main where T_Main.fisleaf = 1 group by FBWtype   ");
            } else {
                sql.append(" T_Main where T_Main.flevel = ").append(((ReportConditionTrialBalance)partner.getFixCondition()).getAccountLevelStart()).append(" or T_Main.FIsLeaf = 1 ").append(" group by FBWtype   ");
            }
            try {
                stmt = cn.prepareStatement(sql.toString());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
        }
        sql.setLength(0);
        sql.append("insert into ").append(strTempTable);
        sql.append(" select ' ',' ',2 FBWtype,' ',sum(FBeginDebitFor ) FBeginDebitFor ,sum(FBeginCreditFor ) FBeginCreditFor ,sum(FDebitFor ) FDebitFor,sum(FCreditFor ) FCreditFor ,sum(FEndDebitFor ) FEndDebitFor ,sum(FEndCreditFor ) FEndCreditFor,  2 FLineType,to_integer(null),to_integer(null)");
        sql.append("  from ").append("  ").append(strTempTable);
        sql.append(" where flinetype = 1  and (fisleaf = 1 or  FLevel = ").append(partner.getFixCondition().getAccountLevelStart()).append(") ");
        try {
            stmt = cn.prepareStatement(sql.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    protected void setPermissionFilter(StringBuffer sql, ReportPartner partner) throws EASBizException, BOSException {
        if (partner.getParmIsUseAccountPermission().booleanValue()) {
            String strPermItem = "bd_account_accountView_view";
            CompanyDisplayModeEnum companyDisplayMode = null;
            String companyIds = "";
            String permSql = GLRptDaoUtil.getDataPermSqlFilter(partner.getContext(), companyDisplayMode, partner.getCompany(), companyIds, strPermItem, false, "TA.FID", "TA.fcompanyid");
            if (!StringUtils.isEmpty((String)permSql)) {
                if (sql.length() > 0) {
                    sql.append(" AND ");
                }
                sql.append(permSql);
            }
        }
    }

    private String getTempTableStructure() {
        String tempTempTalbleSql = " (FAccountNumber VARCHAR(80),FAccountName VARCHAR(256),FBWType INT,FCurrencyName VARCHAR(80),FBeginDebitFor DECIMAL(28,10),FBeginCreditFor DECIMAL(28,10),FDebitFor DECIMAL(28,10),FCreditFor DECIMAL(28,10),FEndDebitFor DECIMAL(28,10),FEndCreditFor DECIMAL(28,10),FLineType Int,FLevel Int,FIsLeaf Int)";
        return tempTempTalbleSql;
    }

    @Override
    protected ReportTableHeadInfo getDefalutTableHeadInfo(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = new ReportTableHeadInfo();
        String[] columnNames = new String[]{"FAccountNumber", "FAccountName", "FCurrencyName", "FBeginDebitFor", "FBeginCreditFor", "FDebitFor", "FCreditFor", "FEndDebitFor", "FEndCreditFor"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AccountCode", "AccountName", "CurrencyType", "PeriodOpenBalance", "PeriodOpenBalance", "PeriodTotal", "PeriodTotal", "PeriodEndBalance", "PeriodEndBalance"}, {"AccountCode", "AccountName", "CurrencyType", "Debit", "Credit", "Debit", "Credit", "Debit", "Credit"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{80, 200, 110, 110, 110, 110, 110, 110, 110};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{true, true, false, false, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false, false, false};
        head.setFreezes(freezes);
        boolean[] visibles = new boolean[]{true, true, false, true, true, true, true, true, true};
        head.setVisibles(visibles);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        return head;
    }

    protected ReportTableHeadInfo getTableHeadInfo(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = new ReportTableHeadInfo();
        String[] columnNames = new String[]{"FAccountNumber", "FAccountName", "FCurrencyName", "FBeginDebitFor", "FBeginCreditFor", "FDebitFor", "FCreditFor", "FEndDebitFor", "FEndCreditFor"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AccountCode", "AccountName", "CurrencyType", "PeriodOpenBalance", "PeriodOpenBalance", "PeriodTotal", "PeriodTotal", "PeriodEndBalance", "PeriodEndBalance"}, {"AccountCode", "AccountName", "CurrencyType", "Debit", "Credit", "Debit", "Credit", "Debit", "Credit"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{80, 200, 110, 110, 110, 110, 110, 110, 110};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{true, true, false, false, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false, false, false};
        head.setFreezes(freezes);
        boolean[] visibles = new boolean[]{true, true, false, true, true, true, true, true, true};
        visibles[2] = partner.getFixCondition().isAllCurrency();
        head.setVisibles(visibles);
        int[] numberStyleTypes = new int[]{0, 0, 0, 1, 1, 1, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, true, true, true, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int[] numberScales = new int[]{0, 0, 0, scaleFor, scaleFor, scaleFor, scaleFor, scaleFor, scaleFor};
        head.setNumberScales(numberScales);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        return head;
    }

    @Override
    protected Object[] getLineObjects(ReportPartner partner, ResultSet rs) throws SQLException, BOSException, EASBizException {
        int scale = partner.getScaleFor();
        int index = 0;
        int sumColTag = 0;
        int lineType = rs.getInt("FLineType");
        int BWType = rs.getInt("FBWType");
        Object[] row = new Object[11];
        row[index++] = rs.getString("FAccountNumber");
        sumColTag = index;
        row[index++] = rs.getString("FAccountName");
        row[index++] = rs.getString("FCurrencyName");
        row[index++] = rs.getBigDecimal("FBeginDebitFor");
        row[index++] = rs.getBigDecimal("FBeginCreditFor");
        row[index++] = rs.getBigDecimal("FDebitFor");
        row[index++] = rs.getBigDecimal("FCreditFor");
        row[index++] = rs.getBigDecimal("FEndDebitFor");
        row[index++] = rs.getBigDecimal("FEndCreditFor");
        if (((ReportConditionTrialBalance)partner.getFixCondition()).getIncludeBWAccount()) {
            if (lineType == 2) {
                if (BWType == 0) {
                    row[index++] = ReportResultInfo.LINE_PERIOD_TOTAL;
                    row[sumColTag] = partner.TITLE_BNSum;
                } else if (BWType == 1) {
                    row[index++] = ReportResultInfo.LINE_PERIOD_TOTAL;
                    row[sumColTag] = partner.TITLE_BWSum;
                } else {
                    row[index++] = ReportResultInfo.LINE_TOTAL;
                    row[sumColTag] = partner.TITLE_SUM;
                }
            } else {
                row[index++] = ReportResultInfo.LINE_NORMAL;
            }
        } else if (lineType == 2) {
            row[index++] = ReportResultInfo.LINE_TOTAL;
            row[sumColTag] = partner.TITLE_SUM;
        } else {
            row[index++] = ReportResultInfo.LINE_NORMAL;
        }
        row[index++] = null;
        for (int i = 3; i < row.length - 2; ++i) {
            if (row[i] == null) continue;
            row[i] = ((BigDecimal)row[i]).setScale(scale, 4);
        }
        return row;
    }

    @Override
    protected boolean isAddTotalLine(ReportPartner partner) {
        return false;
    }

    protected Object[] getTotalLine1(ReportPartner partner) throws BOSException, EASBizException {
        Object[] totalLineObj;
        block6: {
            totalLineObj = this.getTotalLineObj(partner);
            if (totalLineObj != null) break block6;
            StringBuffer sql = new StringBuffer();
            sql.append("select * from ").append(partner.getTempTableName()).append(" T_Main ");
            sql.append("\r\n");
            sql.append(" where fbwType = 0 and flinetype = 2\r\n");
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = partner.getConnection().prepareStatement(sql.toString());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    totalLineObj = this.getLineObjects(partner, rs);
                }
                this.setTotalLineObj(partner, totalLineObj);
            }
            catch (SQLException sqle) {
                try {
                    sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                    throw new SQLDataException(sqle);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            if (totalLineObj != null && totalLineObj.length > 1) {
                totalLineObj[1] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Total", (Locale)partner.getContext().getLocale());
                totalLineObj[totalLineObj.length - 2] = ReportResultInfo.LINE_TOTAL;
            }
        }
        return totalLineObj;
    }

    protected Object[] getTotalLineObj(ReportPartner partner) {
        return (Object[])partner.getVariable(TRIL_TOTAL_LINE);
    }

    protected void setTotalLineObj(ReportPartner partner, Object[] lineObjs) {
        partner.setVariable(TRIL_TOTAL_LINE, lineObjs);
    }

    protected Integer getAccountLevelParameterIndex(ReportPartner partner) {
        return (Integer)partner.getVariable(TRIL_ACCOUNT_LEVEL);
    }

    protected void setAccountLevelParameterIndex(ReportPartner partner, int levelIndex) {
        partner.setVariable(TRIL_ACCOUNT_LEVEL, new Integer(levelIndex));
    }

    @Override
    protected void doSomethingBeforeReturn(ReportPartner partner, ReportResultInfo result) throws BOSException, EASBizException {
        if (partner.isNewQuery()) {
            result.getExtendData().put("TrialBalance", this.isBalance(partner));
        }
        super.doSomethingBeforeReturn(partner, result);
    }

    protected boolean isBalance(ReportPartner partner) throws BOSException, EASBizException {
        Object[] totalLine = null;
        totalLine = this.getTotalLine1(partner);
        if (totalLine == null) {
            return true;
        }
        boolean balance = this.isBalance((BigDecimal)totalLine[3], (BigDecimal)totalLine[4]) && this.isBalance((BigDecimal)totalLine[5], (BigDecimal)totalLine[6]) && this.isBalance((BigDecimal)totalLine[7], (BigDecimal)totalLine[8]);
        return balance;
    }

    protected boolean isBalance(BigDecimal debit, BigDecimal credit) {
        if (debit == null) {
            BigDecimal zero = new BigDecimal("0");
            return credit == null || credit.compareTo(zero) == 0;
        }
        if (credit == null) {
            return false;
        }
        return debit.compareTo(credit) == 0;
    }

    @Override
    protected CurrencyCollection getAllCurrency(ReportPartner partner) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("sign"));
        sic.add(new SelectorItemInfo("BaseUnit"));
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)partner.getContext());
        CurrencyCollection currencyCollection = null;
        if (partner.isParmForeignCurrencySu()) {
            currencyCollection = currency.getCurrencyCollection(view, true);
        } else {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()));
            if (partner.isParmUseReportCurrency()) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString()));
                filter.setMaskString("(#0 OR #1)");
            }
            view.setFilter(filter);
            currencyCollection = currency.getCurrencyCollection(view, false);
        }
        return currencyCollection;
    }

    @Override
    protected CurrencyInfo getDefaultCurrency(ReportPartner partner) throws BOSException, EASBizException {
        if (partner.isParmForeignCurrencySu()) {
            return partner.getCompany().getBaseCurrency();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("sign"));
        sic.add(new SelectorItemInfo("BaseUnit"));
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)partner.getContext());
        return currency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID), sic);
    }

    @Override
    protected String getReportName() {
        return "TrialBalance";
    }

    @Override
    protected String getAuthorityName() {
        return "GLTrialBalance";
    }

    protected String getQueryName() {
        return "com.kingdee.eas.fi.gl.app.GLReportTrialBalanceQuery";
    }

    protected CompanyOrgUnitInfo getInitCompany(ReportPartner partner) throws BOSException, EASBizException {
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        return partner.getCompany();
    }

    private String getAccountName(ReportPartner partner) throws BOSException, EASBizException {
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)partner.getContext());
        boolean isAccountShowLongName = false;
        paramKeyMap.put("GL_012", partner.getCompany().getId().toString());
        String strAccountShowLongName = (String)iParamControl.getParamHashMap(paramKeyMap).get("GL_012");
        if (strAccountShowLongName != null && strAccountShowLongName.trim().length() > 0) {
            isAccountShowLongName = Boolean.valueOf(strAccountShowLongName.trim());
        }
        return isAccountShowLongName ? "    TA.FLongName" : "    TA.FName";
    }
}

