/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.ReportConditionBalanceList;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadItemInfo;
import com.kingdee.eas.fi.gl.app.AbstractGLReportVirtualBalanceListControllerBean;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class GLReportVirtualBalanceListControllerBean
extends AbstractGLReportVirtualBalanceListControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLReportVirtualBalanceListControllerBean");
    protected static final String TRIL_ACCOUNT_LEVEL = "TRIL_ACCOUNT_LEVEL";
    protected static final String TRIL_TOTAL_LINE = "TRIL_TOTAL_LINE";

    @Override
    protected String getSqlForDataSelect(ReportPartner partner) throws BOSException, EASBizException {
        boolean isShowReportingCurrency;
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append(" \r\n");
        sqlSelect.append("\tTCompany.FName" + partner.getFieldNameExtend() + " FCompanyName ,\r\n");
        sqlSelect.append("\tT_Main.FBeginBalanceFor,                  \r\n");
        sqlSelect.append("\tT_Main.FDebitFor,                         \r\n");
        sqlSelect.append("\tT_Main.FCreditFor,                        \r\n");
        sqlSelect.append("\tT_Main.FYearDebitFor,                     \r\n");
        sqlSelect.append("\tT_Main.FYearCreditFor,                    \r\n");
        boolean bl = isShowReportingCurrency = !partner.isReportingCurrency() && partner.getCurrencyType() != 2;
        if (isShowReportingCurrency) {
            sqlSelect.append("\tT_Main.FBeginBalanceRpt,              \r\n");
            sqlSelect.append("\tT_Main.FDebitRpt,                     \r\n");
            sqlSelect.append("\tT_Main.FCreditRpt,                    \r\n");
            sqlSelect.append("\tT_Main.FYearDebitRpt,                 \r\n");
            sqlSelect.append("\tT_Main.FYearCreditRpt,                \r\n");
        }
        sqlSelect.append("\tT_Main.FCompanyId                        \r\n");
        return sqlSelect.toString();
    }

    @Override
    protected String getSqlForDataFrom(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sqlFrom = new StringBuffer();
        sqlFrom.append("FROM ");
        sqlFrom.append(partner.getTempTableName());
        sqlFrom.append(" T_Main \r\n");
        sqlFrom.append("\tINNER JOIN T_ORG_BaseUnit TCompany \r\n");
        sqlFrom.append("\tON T_Main.FCompanyID = TCompany.FID ");
        return sqlFrom.toString();
    }

    @Override
    protected String getSqlForDataWhere(ReportPartner partner) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String getSqlForDataOrder(ReportPartner partner) throws BOSException, EASBizException {
        return "ORDER BY TCompany.FLongNumber ";
    }

    @Override
    protected void doSomethingBeforeQuery(ReportPartner partner) throws BOSException, EASBizException {
        super.doSomethingBeforeQuery(partner);
        this.addTableHeadInfo(partner);
    }

    @Override
    protected ReportTableHeadInfo getDefalutTableHeadInfo(ReportPartner partner) throws BOSException, EASBizException {
        throw new ReportException(ReportException.FUNCTION_USE_WRONG);
    }

    @Override
    protected Object[] getLineObjects(ReportPartner partner, ResultSet rs) throws SQLException, BOSException, EASBizException {
        boolean isShowReportingCurrency = !partner.isReportingCurrency() && partner.getCurrencyType() != 2;
        boolean accountDCIsDebit = partner.getAccountViewInfo().getDC() == BalanceDirectionEnum.DEBIT;
        BigDecimal beginBalanceFor = rs.getBigDecimal("FBeginBalanceFor");
        BigDecimal debitFor = rs.getBigDecimal("FDebitFor");
        BigDecimal creditFor = rs.getBigDecimal("FCreditFor");
        BigDecimal yearDebitFor = rs.getBigDecimal("FYearDebitFor");
        BigDecimal yearCreditFor = rs.getBigDecimal("FYearCreditFor");
        BigDecimal beginBalanceRpt = null;
        BigDecimal debitRpt = null;
        BigDecimal creditRpt = null;
        BigDecimal yearDebitRpt = null;
        BigDecimal yearCreditRpt = null;
        if (isShowReportingCurrency) {
            beginBalanceRpt = rs.getBigDecimal("FBeginBalanceRpt");
            debitRpt = rs.getBigDecimal("FDebitRpt");
            creditRpt = rs.getBigDecimal("FCreditRpt");
            yearDebitRpt = rs.getBigDecimal("FYearDebitRpt");
            yearCreditRpt = rs.getBigDecimal("FYearCreditRpt");
        }
        BigDecimal endBalanceFor = beginBalanceFor;
        BigDecimal endBalanceRpt = beginBalanceRpt;
        if (debitFor != null) {
            BigDecimal bigDecimal = endBalanceFor = endBalanceFor == null ? debitFor : endBalanceFor.add(debitFor);
        }
        if (creditFor != null) {
            BigDecimal bigDecimal = endBalanceFor = endBalanceFor == null ? creditFor : endBalanceFor.add(creditFor);
        }
        if (debitRpt != null) {
            BigDecimal bigDecimal = endBalanceRpt = endBalanceRpt == null ? debitRpt : endBalanceRpt.add(debitRpt);
        }
        if (creditRpt != null) {
            endBalanceRpt = endBalanceRpt == null ? creditRpt : endBalanceRpt.add(creditRpt);
        }
        int index = 0;
        Object[] row = new Object[isShowReportingCurrency ? 21 : 13];
        row[index++] = rs.getString("FCompanyName");
        AccountViewInfo account = partner.getAccountViewInfo();
        row[index++] = account.getNumber();
        row[index++] = account.getName();
        if (accountDCIsDebit) {
            row[index++] = beginBalanceFor;
            if (isShowReportingCurrency) {
                row[index++] = beginBalanceRpt;
            }
            index = isShowReportingCurrency ? index + 2 : index + 1;
        } else {
            index = isShowReportingCurrency ? index + 2 : index + 1;
            Object object = row[index++] = beginBalanceFor == null ? null : beginBalanceFor.negate();
            if (isShowReportingCurrency) {
                row[index++] = beginBalanceRpt == null ? null : beginBalanceRpt.negate();
            }
        }
        row[index++] = debitFor;
        if (isShowReportingCurrency) {
            row[index++] = debitRpt;
        }
        row[index++] = creditFor;
        if (isShowReportingCurrency) {
            row[index++] = creditRpt;
        }
        row[index++] = yearDebitFor;
        if (isShowReportingCurrency) {
            row[index++] = yearDebitRpt;
        }
        row[index++] = yearCreditFor;
        if (isShowReportingCurrency) {
            row[index++] = yearCreditRpt;
        }
        if (accountDCIsDebit) {
            row[index++] = endBalanceFor;
            if (isShowReportingCurrency) {
                row[index++] = endBalanceRpt;
            }
            index = isShowReportingCurrency ? index + 2 : index + 1;
        } else {
            index = isShowReportingCurrency ? index + 2 : index + 1;
            Object object = row[index++] = endBalanceFor == null ? null : endBalanceFor.negate();
            if (isShowReportingCurrency) {
                row[index++] = endBalanceRpt == null ? null : endBalanceRpt.negate();
            }
        }
        row[index++] = ReportResultInfo.LINE_NORMAL;
        row[index++] = rs.getString("FCompanyID");
        return row;
    }

    @Override
    protected void doSomethingBeforeReturn(ReportPartner partner, ReportResultInfo result) throws BOSException, EASBizException {
        if (partner.isNewQuery()) {
            result.getExtendData().put("Account", partner.getAccountViewInfo());
            result.getExtendData().put("AccountShowLongName", partner.isParmAccountShowLongName());
        }
        super.doSomethingBeforeReturn(partner, result);
    }

    protected void insertDataIntoTempTable(Context ctx, ReportPartner partner) throws BOSException, EASBizException {
        partner.setTempTableName(partner.createTempTableAsynchronism("GLBLV", this.getTempTableStruct(partner)));
        logger.debug((Object)"findData.insertDataIntoTempTable.insertCurrentCompanyBalance ");
        this.insertCurrentCompanyBalance(partner);
        logger.debug((Object)"findData.insertDataIntoTempTable.getAccountRef ");
        String accountRefTableName = this.getAccountRef(ctx, partner);
        logger.debug((Object)"findData.insertDataIntoTempTable.getPeriodRef ");
        String periodRefTableName = this.getPeriodRef(ctx, partner);
        logger.debug((Object)"findData.insertDataIntoTempTable.insertChildCompanyBalance ");
        this.insertChildCompanyBalance(partner, accountRefTableName, periodRefTableName);
        partner.dropTempTable(accountRefTableName);
        partner.dropTempTable(periodRefTableName);
    }

    protected String getTempTableStruct(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("( \r\n");
        sql.append("\tFCompanyId           varchar(44)           ,                    \r\n");
        sql.append("\tFBeginBalanceFor     Decimal(28,10)        ,                    \r\n");
        sql.append("\tFBeginBalanceRpt     Decimal(28,10)        ,                    \r\n");
        sql.append("\tFDebitFor            Decimal(28,10)        ,                    \r\n");
        sql.append("\tFDebitRpt            Decimal(28,10)        ,                    \r\n");
        sql.append("\tFCreditFor           Decimal(28,10)        ,                    \r\n");
        sql.append("\tFCreditRpt           Decimal(28,10)        ,                    \r\n");
        sql.append("\tFYearDebitFor        Decimal(28,10)        ,                    \r\n");
        sql.append("\tFYearDebitRpt        Decimal(28,10)        ,                    \r\n");
        sql.append("\tFYearCreditFor       Decimal(28,10)        ,                    \r\n");
        sql.append("\tFYearCreditRpt       Decimal(28,10)                             \r\n");
        sql.append(")                                                                   \r\n");
        return sql.toString();
    }

    protected void insertCurrentCompanyBalance(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append("\t(FCompanyID,                                                                   \r\n");
        sql.append("\t FBeginBalanceFor,FBeginBalanceRpt ,                                           \r\n");
        sql.append("\t FDebitFor,FDebitRpt,                                                          \r\n");
        sql.append("\t FCreditFor,FCreditRpt,                                                        \r\n");
        sql.append("\t FYearDebitFor,FYearDebitRpt,                                                  \r\n");
        sql.append("\t FYearCreditFor,FYearCreditRpt )                                               \r\n");
        sql.append("SELECT ? FCompanyID,                                                               \r\n");
        sql.append("\tSUM(CASE WHEN (tp.FPeriodYear=? and tp.FPeriodNumber =?)                         \r\n");
        sql.append("\t\t\t THEN tb.FBeginBalanceFor ELSE 0 END) FBeginBalanceFor,                \r\n");
        sql.append("\tSUM(CASE WHEN (tp.FPeriodYear=? and tp.FPeriodNumber =?)                         \r\n");
        sql.append("\t\t\t THEN tb.FBeginBalanceRpt ELSE 0 END) FBeginBalanceRpt,                \r\n");
        sql.append("\tSUM(tb.FDebitFor) FDebitFor,                                                   \r\n");
        sql.append("\tSUM(tb.FDebitRpt) FDebitRpt,                                                   \r\n");
        sql.append("\tSUM(tb.FCreditFor) FCreditFor,                                                 \r\n");
        sql.append("\tSUM(tb.FCreditRpt) FCreditRpt,                                                 \r\n");
        sql.append("\tSUM(CASE WHEN (tp.FPeriodYear=? and tp.FPeriodNumber =?)                         \r\n");
        sql.append("\t\t\t THEN tb.FYearDebitFor ELSE 0 END) FYearDebitFor,                      \r\n");
        sql.append("\tSUM(CASE WHEN (tp.FPeriodYear=? and tp.FPeriodNumber =?)                         \r\n");
        sql.append("\t\t\t THEN tb.FYearDebitRpt ELSE 0 END) FYearDebitRpt,                      \r\n");
        sql.append("\tSUM(CASE WHEN (tp.FPeriodYear=? and tp.FPeriodNumber =?)                         \r\n");
        sql.append("\t\t\t THEN tb.FYearCreditFor ELSE 0 END) FYearCreditFor,                    \r\n");
        sql.append("\tSUM(CASE WHEN (tp.FPeriodYear=? and tp.FPeriodNumber =?)                         \r\n");
        sql.append("\t\t\t THEN tb.FYearCreditRpt ELSE 0 END) FYearCreditRpt                     \r\n");
        sql.append("FROM T_GL_AccountBalanceUnion tb                                                   \r\n");
        sql.append("\tINNER JOIN T_BD_Period tp                                                      \r\n");
        sql.append("\tON tb.FPeriodID = tp.FID                                                       \r\n");
        sql.append("WHERE tb.FBalType = ?                                                              \r\n");
        sql.append("\tAND tb.FAccountID = ?                                                          \r\n");
        sql.append("\tAND (tp.FPeriodYear>? or(tp.FPeriodYear=? and tp.FPeriodNumber >=?))                                  \r\n");
        sql.append("\tAND (tp.FPeriodYear<? or(tp.FPeriodYear=? and tp.FPeriodNumber <=?))                                  \r\n");
        sql.append("\tAND tb.FCurrencyID = ?                                                         \r\n");
        SqlParameter2 parameter = new SqlParameter2();
        CompanyOrgUnitInfo company = partner.getCompany();
        parameter.addValueChar(company.getId().toString());
        ReportConditionBalanceList condition = (ReportConditionBalanceList)partner.getFixCondition();
        Integer yearStart = new Integer(condition.getPeriodYearStart());
        Integer numberStart = new Integer(condition.getPeriodNumberStart());
        Integer yearEnd = new Integer(condition.getPeriodYearEnd());
        Integer numberEnd = new Integer(condition.getPeriodNumberEnd());
        parameter.addValue(yearStart);
        parameter.addValue(numberStart);
        parameter.addValue(yearStart);
        parameter.addValue(numberStart);
        parameter.addValue(yearEnd);
        parameter.addValue(numberEnd);
        parameter.addValue(yearEnd);
        parameter.addValue(numberEnd);
        parameter.addValue(yearEnd);
        parameter.addValue(numberEnd);
        parameter.addValue(yearEnd);
        parameter.addValue(numberEnd);
        parameter.addValue(new Integer(5));
        parameter.addValueId((CoreBaseInfo)partner.getAccountViewInfo());
        parameter.addValue(yearStart);
        parameter.addValue(yearStart);
        parameter.addValue(numberStart);
        parameter.addValue(yearEnd);
        parameter.addValue(yearEnd);
        parameter.addValue(numberEnd);
        parameter.addValueChar(condition.getCurrencyID());
        partner.executeSql(sql.toString(), parameter);
    }

    protected void insertChildCompanyBalance(ReportPartner partner, String accountRefTableName, String periodRefTableName) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + partner.getTempTableName() + "                      \r\n");
        sql.append("   (FCompanyId,                                                     \r\n");
        sql.append("    FBeginBalanceFor,FBeginBalanceRpt,                              \r\n");
        sql.append("    FDebitFor,FDebitRpt,                                            \r\n");
        sql.append("    FCreditFor,FCreditRpt,                                          \r\n");
        sql.append("    FYearDebitFor,FYearDebitRpt,                                    \r\n");
        sql.append("    FYearCreditFor,FYearCreditRpt)                                  \r\n");
        sql.append("SELECT tb.FOrgUnitID FCompanyID,                                                                     \r\n");
        sql.append("\tSUM(CASE WHEN tp.FIsStartPerid = 1 THEN tb.FBeginBalanceFor ELSE 0 END) FBeginBalanceFor, \r\n");
        sql.append("\tSUM(CASE WHEN tp.FIsStartPerid = 1 THEN tb.FBeginBalanceRpt ELSE 0 END) FBeginBalanceRpt, \r\n");
        sql.append("\tSUM(tb.FDebitFor) FDebitFor,                                                              \r\n");
        sql.append("\tSUM(tb.FDebitRpt) FDebitRpt,                                                              \r\n");
        sql.append("\tSUM(tb.FCreditFor) FCreditFor,                                                            \r\n");
        sql.append("\tSUM(tb.FCreditRpt) FCreditRpt,                                                            \r\n");
        sql.append("\tSUM(CASE WHEN tp.FIsEndPerid = 1 THEN tb.FYearDebitFor  ELSE 0 END) FYearDebitFor,        \r\n");
        sql.append("\tSUM(CASE WHEN tp.FIsEndPerid = 1 THEN tb.FYearDebitRpt  ELSE 0 END) FYearDebitRpt,        \r\n");
        sql.append("\tSUM(CASE WHEN tp.FIsEndPerid = 1 THEN tb.FYearCreditFor ELSE 0 END) FYearCreditFor,       \r\n");
        sql.append("\tSUM(CASE WHEN tp.FIsEndPerid = 1 THEN tb.FYearCreditRpt ELSE 0 END) FYearCreditRpt        \r\n");
        sql.append("FROM " + GLBalanceUtils.getAccountBalanceTable(5, partner.getFixCondition().getCurrencyID()) + " tb                                                                   \r\n");
        sql.append("\tINNER JOIN " + periodRefTableName + " tp                                                  \r\n");
        sql.append("\tON tb.FPeriodID = tp.FPeriodID                                                            \r\n");
        sql.append("\tAND tb.FOrgUnitID = tp.FCompanyID                                                         \r\n");
        sql.append("\tINNER JOIN " + accountRefTableName + " ta                                                 \r\n");
        sql.append("\tON tb.FAccountID = ta.FAccountID                                                          \r\n");
        sql.append("\tAND tb.FOrgUnitID = ta.FCompanyID                                                         \r\n");
        sql.append("WHERE tb.FCurrencyID = ?                                                                    \r\n");
        sql.append("GROUP BY tb.FOrgUnitID                                                                        \r\n");
        SqlParameter2 parameter = new SqlParameter2();
        CompanyOrgUnitInfo company = partner.getCompany();
        parameter.addValueChar(partner.getFixCondition().getCurrencyID());
        partner.executeSql(sql.toString(), parameter);
    }

    protected String getAccountRef(Context ctx, ReportPartner partner) throws BOSException, EASBizException {
        SqlParameter2 parameter = new SqlParameter2();
        StringBuffer sqlStruct = new StringBuffer();
        sqlStruct.append("(                                                      \r\n");
        sqlStruct.append("\tFCompanyId          varchar(44),                     \r\n");
        sqlStruct.append("\tFAccountID          varchar(44),                     \r\n");
        sqlStruct.append("\tFAccountNumber      Nvarchar(80),                    \r\n");
        sqlStruct.append("\tFAccountName        Nvarchar(80)                     \r\n");
        sqlStruct.append(")                                                      \r\n");
        String tempTableName = partner.createTempTable("GLBLV", sqlStruct.toString());
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + tempTableName + "                                   \r\n");
        sql.append("   (FCompanyId, FAccountID,FAccountNumber,FAccountName)             \r\n");
        sql.append("SELECT toc.FID FCompanyID,taDest.FID,taDest.FNumber,                \r\n");
        sql.append("       taDest.FName" + partner.getFieldNameExtend() + " FAccountName \r\n");
        sql.append("FROM T_BD_AccountView---\r\n ta                                            \r\n");
        sql.append("\tINNER JOIN T_BD_AccountView---\r\n taLeaf                              \r\n");
        sql.append("\tON ((taLeaf.FLongNumber like ? )                                \r\n");
        sql.append("\t    OR (taLeaf.FID = ? ))                                       \r\n");
        sql.append("\t    AND ta.FID = ?                                              \r\n");
        sql.append("\t    AND taLeaf.FIsLeaf = 1                                      \r\n");
        sql.append("\t    AND taLeaf.FCompanyID = ta.FCompanyID                       \r\n");
        sql.append("\tINNER JOIN T_BD_AccountView---\r\n taDest                              \r\n");
        sql.append("\tON taLeaf.FAccountID = taDest.FAccountID                        \r\n");
        sql.append("\tINNER JOIN T_ORG_BaseUnit tob                                   \r\n");
        sql.append("\tON taDest.FCompanyID = tob.FID                                  \r\n");
        sql.append("\tINNER JOIN T_ORG_Company toc                                    \r\n");
        sql.append("\ton taDest.FCompanyID = toc.FID                                  \r\n");
        sql.append("WHERE tob.FLongNumber like ?                                        \r\n");
        sql.append("\tAND toc.FIsGroup = 0                                            \r\n");
        sql.append("\tAND toc.FISOnlyUnion = 0                                        \r\n");
        parameter.clear();
        parameter.addValueVarchar(partner.getAccountViewInfo().getLongNumber() + "!%");
        parameter.addValueChar(partner.getFixCondition().getAccountId());
        parameter.addValueChar(partner.getFixCondition().getAccountId());
        parameter.addValueVarchar(partner.getCompany().getLongNumber() + "!%");
        partner.executeSql(sql.toString(), parameter);
        sql = new StringBuffer();
        sql.append("INSERT INTO " + tempTableName + "                                     \r\n");
        sql.append("   (FCompanyId, FAccountID,FAccountNumber,FAccountName)               \r\n");
        sql.append("SELECT toc.FID FCompanyID,taDest.FID,taDest.FNumber,                  \r\n");
        sql.append("       taDest.FName" + partner.getFieldNameExtend() + " FAccountName   \r\n");
        sql.append("FROM T_BD_AccountView---\r\n ta                                              \r\n");
        sql.append("\tINNER JOIN T_BD_AccountView---\r\n taLeaf                                \r\n");
        sql.append("\tON ((taLeaf.FLongNumber like ? )                                  \r\n");
        sql.append("\t    OR (taLeaf.FID = ? ))                                         \r\n");
        sql.append("\t    AND ta.FID = ?                                                \r\n");
        sql.append("\t    AND taLeaf.FIsLeaf = 1                                        \r\n");
        sql.append("\t    AND taLeaf.FCompanyID = ta.FCompanyID                         \r\n");
        sql.append("\tINNER JOIN T_BD_AccountRef tar                                    \r\n");
        sql.append("\tON taLeaf.FAccountID = tar.FDesAccountID                          \r\n");
        sql.append("\tINNER JOIN T_BD_AccountView---\r\n taDest                                \r\n");
        sql.append("\tON tar.FSrcAccountID = taDest.FAccountID                          \r\n");
        sql.append("\tINNER JOIN T_ORG_BaseUnit tob                                     \r\n");
        sql.append("\tON taDest.FCompanyID = tob.FID                                    \r\n");
        sql.append("\tINNER JOIN T_ORG_Company toc                                      \r\n");
        sql.append("\ton taDest.FCompanyID = toc.FID                                    \r\n");
        sql.append("WHERE tob.FLongNumber like ?                                          \r\n");
        sql.append("\tAND toc.FIsGroup = 0                                              \r\n");
        sql.append("\tAND toc.FISOnlyUnion = 0                                          \r\n");
        parameter.clear();
        parameter.addValueVarchar(partner.getAccountViewInfo().getLongNumber() + "!%");
        parameter.addValueChar(partner.getFixCondition().getAccountId());
        parameter.addValueChar(partner.getFixCondition().getAccountId());
        parameter.addValueVarchar(partner.getCompany().getLongNumber() + "!%");
        partner.executeSql(sql.toString(), parameter);
        return tempTableName;
    }

    protected String getPeriodRef(Context ctx, ReportPartner partner) throws BOSException, EASBizException {
        SqlParameter2 parameter = new SqlParameter2();
        ReportConditionBalanceList condition = (ReportConditionBalanceList)partner.getFixCondition();
        Integer yearNumberBegin = new Integer(condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart());
        Integer yearNumberEnd = new Integer(condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd());
        StringBuffer sqlStruct = new StringBuffer();
        sqlStruct.append("(                                                      \r\n");
        sqlStruct.append("\tFCompanyId          varchar(44),                     \r\n");
        sqlStruct.append("\tFPeriodID           varchar(44),                     \r\n");
        sqlStruct.append("\tFIsStartPerid       int,                             \r\n");
        sqlStruct.append("\tFIsEndPerid         int                              \r\n");
        sqlStruct.append(")                                                      \r\n");
        String tempTableName = partner.createTempTable("GLBLV", sqlStruct.toString());
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + tempTableName + "                                                           \r\n");
        sql.append("   (FCompanyId, FPeriodID, FIsStartPerid, FIsEndPerid)                                      \r\n");
        sql.append("SELECT tob.FID FCompanyId ,tpd.FID FPeriodID,                                               \r\n");
        sql.append("   CASE WHEN tp.FPeriodYear*100 + tp.FPeriodNumber = ? THEN 1 ELSE 0 END FIsStartPerid,     \r\n");
        sql.append("   CASE WHEN tp.FPeriodYear*100 + tp.FPeriodNumber = ? THEN 1 ELSE 0 END FIsEndPerid        \r\n");
        sql.append("FROM T_BD_Period tp                                                                         \r\n");
        sql.append("   INNER JOIN T_BD_PeriodRelation tpr                                                       \r\n");
        sql.append("   ON tp.FID = tpr.FTargetPeriod                                                            \r\n");
        sql.append("   INNER JOIN T_BD_Period tpd                                                               \r\n");
        sql.append("   ON tpr.FSourcePeriod = tpd.FID                                                           \r\n");
        sql.append("   INNER JOIN T_ORG_Company toc                                                             \r\n");
        sql.append("   ON tpd.FTypeID = toc.FAccountPeriodID                                                    \r\n");
        sql.append("   INNER JOIN T_ORG_BaseUnit tob                                                            \r\n");
        sql.append("   ON tob.FID = toc.FID                                                                     \r\n");
        sql.append("WHERE tp.FPeriodYear*100 + tp.FPeriodNumber >= ?                                            \r\n");
        sql.append("   AND tp.FPeriodYear*100 + tp.FPeriodNumber <= ?                                           \r\n");
        sql.append("   AND tob.FLongNumber like ?                                                               \r\n");
        sql.append("   AND tpd.FTypeID <> ?                                                                     \r\n");
        CompanyOrgUnitInfo company = partner.getCompany();
        parameter.clear();
        parameter.addValue(yearNumberBegin);
        parameter.addValue(yearNumberEnd);
        parameter.addValue(yearNumberBegin);
        parameter.addValue(yearNumberEnd);
        parameter.addValueVarchar(partner.getCompany().getLongNumber() + "!%");
        parameter.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        partner.executeSql(sql.toString(), parameter);
        sql = new StringBuffer();
        sql.append("INSERT INTO " + tempTableName + "                                                           \r\n");
        sql.append("   (FCompanyId, FPeriodID, FIsStartPerid, FIsEndPerid)                                      \r\n");
        sql.append("SELECT tob.FID FCompanyId ,tp.FID FPeriodID,                                                \r\n");
        sql.append("\tCASE WHEN tp.FPeriodYear*100 + tp.FPeriodNumber = ? THEN 1 ELSE 0 END FIsStartPerid,    \r\n");
        sql.append("\tCASE WHEN tp.FPeriodYear*100 + tp.FPeriodNumber = ? THEN 1 ELSE 0 END FIsEndPerid       \r\n");
        sql.append("FROM T_BD_Period tp                                                                         \r\n");
        sql.append("\tINNER JOIN T_ORG_Company toc                                                            \r\n");
        sql.append("\tON tp.FTypeID = toc.FAccountPeriodID                                                    \r\n");
        sql.append("\tINNER JOIN T_ORG_BaseUnit tob                                                           \r\n");
        sql.append("\ton tob.FID = toc.FID                                                                    \r\n");
        sql.append("WHERE tp.FPeriodYear*100 + tp.FPeriodNumber >= ?                                            \r\n");
        sql.append("\tAND tp.FPeriodYear*100 + tp.FPeriodNumber <= ?                                          \r\n");
        sql.append("\tAND tob.FLongNumber like ?                                                              \r\n");
        sql.append("\tAND toc.FAccountPeriodID = ?                                                            \r\n");
        company = partner.getCompany();
        parameter.clear();
        parameter.addValue(yearNumberBegin);
        parameter.addValue(yearNumberEnd);
        parameter.addValue(yearNumberBegin);
        parameter.addValue(yearNumberEnd);
        parameter.addValueVarchar(partner.getCompany().getLongNumber() + "!%");
        parameter.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        partner.executeSql(sql.toString(), parameter);
        return tempTableName;
    }

    protected void addTableHeadInfo(ReportPartner partner) throws EASBizException, BOSException {
        ArrayList<ReportTableHeadItemInfo> itemList = new ArrayList<ReportTableHeadItemInfo>();
        ReportTableHeadItemInfo item = new ReportTableHeadItemInfo();
        item.setColumnName("FCompanyName");
        item.setWidth(200);
        item.setAlignment(0);
        item.setFreeze(false);
        item.setMerge(false);
        item.setVisible(true);
        item.setTitles(new String[]{"Company"});
        itemList.add(item);
        item = new ReportTableHeadItemInfo();
        item.setColumnName("FAccountNumber");
        item.setWidth(100);
        item.setAlignment(0);
        item.setFreeze(false);
        item.setMerge(false);
        item.setVisible(true);
        item.setTitles(new String[]{"AccountCode"});
        itemList.add(item);
        item = new ReportTableHeadItemInfo();
        item.setColumnName("FAccountName");
        item.setWidth(200);
        item.setAlignment(0);
        item.setFreeze(false);
        item.setMerge(false);
        item.setVisible(true);
        item.setTitles(new String[]{"AccountName"});
        itemList.add(item);
        boolean isShowReportingCurrency = !partner.isReportingCurrency() && partner.getCurrencyType() != 2;
        String[] nameFirst = new String[]{"Begin", "", "Year", "End"};
        String[] nameSecond = new String[]{"Debit", "Credit"};
        String[] nameThree = new String[]{"For", "Rpt"};
        String[] titleFirst = new String[]{"BalanceBegin", "NumberTotal", "YearTotal", "BalanceEnd"};
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    if (k != 0 && !isShowReportingCurrency) continue;
                    StringBuffer sbName = new StringBuffer("F");
                    sbName.append(nameFirst[i]);
                    sbName.append(nameSecond[j]);
                    sbName.append(nameThree[k]);
                    ReportTableHeadItemInfo item2 = new ReportTableHeadItemInfo();
                    item2.setColumnName(sbName.toString());
                    item2.setWidth(80);
                    item2.setAlignment(2);
                    item2.setFreeze(false);
                    item2.setMerge(false);
                    item2.setVisible(true);
                    item2.setNumberStyleType(1);
                    item2.setNumberScale(partner.getScaleFor());
                    item2.setNeedKilobit(true);
                    if (k == 0) {
                        if (isShowReportingCurrency) {
                            item2.setTitles(new String[]{titleFirst[i], nameSecond[j], "LabelFor"});
                        } else {
                            item2.setTitles(new String[]{titleFirst[i], nameSecond[j]});
                        }
                    } else {
                        item2.setTitles(new String[]{titleFirst[i], nameSecond[j], "LabelRpt"});
                    }
                    itemList.add(item2);
                }
            }
        }
        ReportTableHeadItemInfo[] items = new ReportTableHeadItemInfo[itemList.size()];
        for (int i = 0; i < itemList.size(); ++i) {
            items[i] = (ReportTableHeadItemInfo)itemList.get(i);
        }
        ReportTableHeadInfo head = new ReportTableHeadInfo(items);
        head.setHeadMerge(true);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        partner.setTableHeadInfo(head);
    }

    @Override
    protected String getReportName() {
        return "VirtualBalanceList";
    }

    @Override
    protected String getAuthorityName() {
        return "VirtualBalanceList";
    }

    protected String getQueryName() {
        return "com.kingdee.eas.fi.gl.app.GLReportBalanceListQuery";
    }
}

