/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.FeeTypeEnum;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.task.util.IAccountingDataInterface;
import com.kingdee.eas.tools.datatask.task.util.XMLGenerator;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public class GLXMLGenerator
extends XMLGenerator
implements IAccountingDataInterface {
    private String STANDARD_NUMBER = "GB/T 24589.1\u20142010";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLXMLGenerator");
    private BigDecimal ZERO = new BigDecimal(0);

    public Document generateXML(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) {
        throw new UnsupportedOperationException();
    }

    public File generate(Context ctx, CompanyOrgUnitInfo companyInfo, List<PeriodInfo> periodInfos) {
        if (!this.checkAccountTable(ctx, companyInfo, periodInfos)) {
            this.addException((Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"206_GLXMLGenerator", (Locale)ctx.getLocale()))));
            return this.file;
        }
        String type = this.getTypeName(ctx);
        Element root = this.initHeadAndFileName(ctx, companyInfo, type);
        this.setCommDocument(ctx, root, companyInfo, periodInfos.get(periodInfos.size() - 1));
        PeriodInfo startPeriodInfo = null;
        try {
            startPeriodInfo = GlUtils.getStartPeriod(ctx, companyInfo.getId().toString());
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"205_GLXMLGenerator", (Locale)ctx.getLocale()), (Throwable)e);
        }
        for (PeriodInfo periodInfo : periodInfos) {
            if (startPeriodInfo == null || periodInfo.getNumber() < startPeriodInfo.getNumber()) continue;
            this.generateAccountBalance(root, ctx, companyInfo, periodInfo);
            this.generateVoucher(root, ctx, companyInfo, periodInfo);
            this.generateCashFlowVoucherItem(root, ctx, companyInfo, periodInfo);
        }
        this.endElement();
        this.close();
        return this.file;
    }

    public File generate(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) {
        ArrayList<PeriodInfo> periodInfos = new ArrayList<PeriodInfo>();
        periodInfos.add(periodInfo);
        return this.generate(ctx, companyInfo, periodInfos);
    }

    private boolean checkAccountTable(Context ctx, CompanyOrgUnitInfo companyInfo, List<PeriodInfo> periodInfos) {
        try {
            AccountTableInfo accountTableInfo = null;
            for (PeriodInfo periodInfo : periodInfos) {
                AccountRefContrastInfo ar = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(companyInfo.getId().toString(), companyInfo.getAccountTable().getId().toString(), periodInfo.getPeriodYear(), periodInfo.getPeriodNumber());
                if (ar == null || ar.getEnabledAcctTable() == null) continue;
                if (accountTableInfo != null) {
                    if (accountTableInfo.getId().toString().equals(ar.getEnabledAcctTable().getId().toString())) continue;
                    this.addException((Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"613_GLXMLGenerator", (Locale)ctx.getLocale()))));
                    return false;
                }
                accountTableInfo = ar.getEnabledAcctTable();
            }
            if (accountTableInfo != null) {
                companyInfo.setAccountTable(accountTableInfo);
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"206_GLXMLGenerator", (Locale)ctx.getLocale()), (Throwable)e);
            this.addException((Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"206_GLXMLGenerator", (Locale)ctx.getLocale()) + e.getMessage())));
            return false;
        }
    }

    private void setCommDocument(Context ctx, Element root, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) {
        try {
            CurrencyInfo baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyInfo.getBaseCurrency().getId().toString()));
            companyInfo.setBaseCurrency(baseCurrency);
            this.generateBaseInfo(root, ctx, companyInfo, periodInfo);
            this.generateAccount(root, ctx, companyInfo, periodInfo);
            this.generateAsstAccount(root, ctx, companyInfo, periodInfo);
            this.generateCashFlowItem(root, ctx, companyInfo, periodInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"206_GLXMLGenerator", (Locale)ctx.getLocale()), (Throwable)e);
            this.addException((Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"206_GLXMLGenerator", (Locale)ctx.getLocale()) + e.getMessage())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCashFlowVoucherItem(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT   \r\n");
        sql.append("\"VOUCHER\".FID AS \"ID\", \r\n");
        sql.append("\"VOUCHER\".FNumber AS \"NUMBER\",  \r\n");
        sql.append("\"PERIOD\".FPeriodYear AS \"PERIOD.PERIODYEAR\", \r\n");
        sql.append("\"PERIOD\".FPeriodNumber AS \"PERIOD.PERIODNUMBER\", \r\n");
        sql.append("\"PERIOD\".FNumber AS \"PERIOD.NUMBER\", \r\n");
        sql.append("((TO_CHAR(\"PERIOD\".FPeriodYear) || '.') || TO_CHAR(\"PERIOD\".FPeriodNumber)) AS \"PERIOD\", \r\n");
        sql.append("\"VOUCHERTYPE\".FName_l2 AS \"VOUCHERTYPE.NAME\", \r\n");
        sql.append("\"VOUCHERTYPE\".FNumber AS \"VOUCHERTYPE.NUMBER\", \r\n");
        sql.append("\"VOUCHER\".FAbstract AS \"ENTRIES.DESCRIPTION\",\r\n");
        sql.append("\"CREATOR\".FName_l2 AS \"CREATOR.NAME\", \r\n");
        sql.append("\"CASHIER\".FName_l2 AS \"CASHIER.NAME\", \r\n");
        sql.append("\"POSTER\".FName_l2 AS \"POSTER.NAME\", \r\n");
        sql.append("\"AUDITOR\".FName_l2 AS \"AUDITOR.NAME\", \r\n");
        sql.append("\"VOUCHER\".FCreateTime AS \"CREATETIME\",\r\n");
        sql.append("\"CURRENCY\".FNumber AS \"CURRENCY.Number\",\r\n");
        sql.append("\"CURRENCY\".FPrecision AS \"CURRENCY.FPrecision\",\r\n");
        sql.append("\"PRIMARYITEM\".FID AS \"PRIMARYITEM.ID\",\r\n");
        sql.append("\"PRIMARYITEM\".FNUMBER AS \"PRIMARYITEM.NUMBER\",\r\n");
        sql.append("\"PRIMARYITEM\".FDirection AS \"PRIMARYITEM.Direction\",\r\n");
        sql.append("\"CashflowRecord\".FOriginalAmount AS \"CashflowRecord.OriginalAmount\",\r\n");
        sql.append("\"CashflowRecord\".FLocalAmount AS \"CashflowRecord.LocalAmount\",\r\n");
        sql.append("\"CashflowRecord\".FPrimaryCoeffient AS \"PrimaryCoeffient\"\r\n");
        sql.append("FROM T_GL_Voucher AS \"VOUCHER\"\r\n");
        sql.append("INNER JOIN T_BD_Period AS \"PERIOD\"\r\n");
        sql.append("ON \"VOUCHER\".FPeriodID = \"PERIOD\".FID\r\n");
        sql.append("INNER JOIN T_ORG_Company AS \"COMPANY\"\r\n");
        sql.append("ON \"VOUCHER\".FCompanyID = \"COMPANY\".FID\r\n");
        sql.append("INNER JOIN T_BD_VoucherTypes AS \"VOUCHERTYPE\"\r\n");
        sql.append("ON \"VOUCHER\".FVoucherTypeID = \"VOUCHERTYPE\".FID\r\n");
        sql.append("INNER JOIN T_PM_User AS \"CREATOR\"\r\n");
        sql.append("ON \"VOUCHER\".FCreatorID = \"CREATOR\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_PM_User AS \"AUDITOR\"\r\n");
        sql.append("ON \"VOUCHER\".FAuditorID = \"AUDITOR\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_PM_User AS \"POSTER\"\r\n");
        sql.append("ON \"VOUCHER\".FPosterID = \"POSTER\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_PM_User AS \"CASHIER\"\r\n");
        sql.append("ON \"VOUCHER\".FCashierID = \"CASHIER\".FID\r\n");
        sql.append("INNER JOIN T_GL_VoucherEntry AS \"ENTRIES\"\r\n");
        sql.append("ON \"VOUCHER\".FID = \"ENTRIES\".FBillID\r\n");
        sql.append("INNER JOIN T_GL_CashflowRecord AS \"CashflowRecord\"\r\n");
        sql.append("ON \"ENTRIES\".FID = \"CashflowRecord\".FEntryID\r\n");
        sql.append("LEFT OUTER JOIN T_BD_Currency AS \"CURRENCY\"\r\n");
        sql.append("ON \"ENTRIES\".FCurrencyID = \"CURRENCY\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_BD_CashFlowItem AS \"PRIMARYITEM\"\r\n");
        sql.append("ON \"CashflowRecord\".FPrimaryItemID = \"PRIMARYITEM\".FID\r\n");
        sql.append("WHERE \"VOUCHER\".FCompanyID = ? AND \"PERIOD\".FNumber = ?\r\n");
        sql.append("AND (\"VOUCHER\".FBizStatus <> 0)\r\n");
        sql.append("AND ((\"CashflowRecord\".FItemFlag = 1) OR (\"CashflowRecord\".FItemFlag = 3)) \r\n");
        sql.append("ORDER BY \r\n");
        sql.append("\"VOUCHERTYPE.NUMBER\" ASC,\r\n");
        sql.append("\"NUMBER\" ASC,\r\n");
        sql.append("\"ENTRIES\".FSeq ASC,\r\n");
        sql.append("\"CashflowRecord\".FSeq ASC\r\n");
        int baseCurrencyPre = companyInfo.getBaseCurrency().getPrecision();
        baseCurrencyPre = 2;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rowset = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setObject(1, companyInfo.getId().toString());
            pstmt.setObject(2, new Integer(periodInfo.getNumber()));
            rowset = pstmt.executeQuery();
            String voucherId = null;
            int count = 1;
            while (rowset.next()) {
                if (!rowset.getString("ID").equals(voucherId)) {
                    voucherId = rowset.getString("ID");
                    count = 1;
                }
                Element cashFlowInfo = this.startElement(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"207_GLXMLGenerator", (Locale)ctx.getLocale()));
                this.addStringElement(cashFlowInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"208_GLXMLGenerator", (Locale)ctx.getLocale()), rowset.getString("VOUCHERTYPE.NUMBER"));
                this.addStringElement(cashFlowInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"209_GLXMLGenerator", (Locale)ctx.getLocale()), rowset.getString("NUMBER"));
                this.addStringElement(cashFlowInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"210_GLXMLGenerator", (Locale)ctx.getLocale()), rowset.getString("CURRENCY.Number"));
                this.addStringElement(cashFlowInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"211_GLXMLGenerator", (Locale)ctx.getLocale()), String.valueOf(count));
                this.addStringElement(cashFlowInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"212_GLXMLGenerator", (Locale)ctx.getLocale()), "");
                String cashFlowItemNumber = "";
                if (!GlUtils.isEmpty(rowset.getString("PRIMARYITEM.NUMBER"))) {
                    cashFlowItemNumber = rowset.getString("PRIMARYITEM.NUMBER");
                }
                this.addStringElement(cashFlowInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"213_GLXMLGenerator", (Locale)ctx.getLocale()), cashFlowItemNumber);
                String cashFlowProperty = "";
                if (!GlUtils.isEmpty(rowset.getString("PRIMARYITEM.ID"))) {
                    cashFlowProperty = String.valueOf(this.convertCashFlowProperty(rowset.getInt("PRIMARYITEM.Direction")));
                }
                this.addStringElement(cashFlowInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"214_GLXMLGenerator", (Locale)ctx.getLocale()), cashFlowProperty);
                int precision = rowset.getInt("CURRENCY.FPrecision");
                if (rowset.getString("CURRENCY.Number") == null || "".equals(rowset.getString("CURRENCY.Number"))) {
                    precision = 2;
                }
                precision = 2;
                this.addStringElement(cashFlowInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"215_GLXMLGenerator", (Locale)ctx.getLocale()), this.bigDecimalToString(rowset.getBigDecimal("CashflowRecord.OriginalAmount").multiply(new BigDecimal(rowset.getInt("PrimaryCoeffient"))), precision));
                this.addStringElement(cashFlowInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"216_GLXMLGenerator", (Locale)ctx.getLocale()), this.bigDecimalToString(rowset.getBigDecimal("CashflowRecord.LocalAmount").multiply(new BigDecimal(rowset.getInt("PrimaryCoeffient"))), baseCurrencyPre));
                ++count;
                this.endElement();
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"217_GLXMLGenerator", (Locale)ctx.getLocale()), (Throwable)e);
                this.addException((Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"218_GLXMLGenerator", (Locale)ctx.getLocale()) + e.getMessage())));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rowset, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rowset, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateVoucher(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) {
        StringBuffer sql = new StringBuffer("select * from (");
        String s = "T_NT_ReceivableBill";
        this.bulidVoucherMainSQL(sql, s);
        this.bulidVoucherUnionSQL(sql, s);
        sql.append(" UNION  ");
        s = "T_NT_PayableBill";
        this.bulidVoucherMainSQL(sql, s);
        this.bulidVoucherUnionSQL(sql, s);
        sql.append(" UNION  ");
        s = "T_NT_Cheque";
        this.bulidVoucherMainSQL(sql, s);
        this.bulidVoucherUnionSQL(sql, s);
        sql.append(" UNION  ");
        s = "T_NT_RecCheque";
        this.bulidVoucherMainSQL(sql, s);
        this.bulidVoucherUnionSQL(sql, s);
        sql.append(" UNION  ");
        s = "T_NT_BankDraft";
        this.bulidVoucherMainSQL(sql, s);
        this.bulidVoucherUnionSQL(sql, s);
        sql.append(" UNION  ");
        s = "T_CAS_RECEIVINGBILL";
        this.bulidVoucherMainSQL(sql, s);
        this.bulidVoucherUnionSQL(sql, s);
        sql.append(" UNION  ");
        s = "T_CAS_paymentbill";
        this.bulidVoucherMainSQL(sql, s);
        this.bulidVoucherUnionSQL(sql, s);
        sql.append(" UNION  ");
        s = "ALL";
        this.bulidVoucherMainSQL(sql, s);
        this.bulidVoucherUnionSQL(sql, s);
        sql.append(") TP ");
        sql.append("ORDER BY \r\n");
        sql.append("\"VOUCHERTYPE.NUMBER\" ASC,\r\n");
        sql.append("\"NUMBER\" ASC,\r\n");
        sql.append("\"ID\" ASC,\r\n");
        sql.append("\"ENTRIES.SEQ\" ASC,\r\n");
        sql.append("\"ASSITRECORD.NUMBER\" ASC,\r\n");
        sql.append("\"Bill.NUMBER\" ASC\r\n");
        int baseCurrencyPre = companyInfo.getBaseCurrency().getPrecision();
        baseCurrencyPre = 2;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rowset = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            Object[] params = new Object[]{companyInfo.getId().toString(), new Integer(periodInfo.getNumber()), companyInfo.getId().toString(), new Integer(periodInfo.getNumber()), companyInfo.getId().toString(), new Integer(periodInfo.getNumber()), companyInfo.getId().toString(), new Integer(periodInfo.getNumber()), companyInfo.getId().toString(), new Integer(periodInfo.getNumber()), companyInfo.getId().toString(), new Integer(periodInfo.getNumber()), companyInfo.getId().toString(), new Integer(periodInfo.getNumber()), companyInfo.getId().toString(), new Integer(periodInfo.getNumber())};
            for (int i = 0; i < params.length; ++i) {
                pstmt.setObject(i + 1, params[i]);
            }
            rowset = pstmt.executeQuery();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String voucherId = null;
            String botpId = null;
            int count = 1;
            while (rowset.next()) {
                if (this.isHasBillId(rowset.getString("Bill.SRCENTITYNAME")) && rowset.getString("BOTP.SRCOBJECTID") != null && rowset.getString("BILL.ID") == null) continue;
                if (!rowset.getString("ID").equals(voucherId)) {
                    voucherId = rowset.getString("ID");
                    botpId = rowset.getString("BOTP.SRCOBJECTID");
                    count = 1;
                }
                Element voucherInfo = this.startElement(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"219_GLXMLGenerator", (Locale)ctx.getLocale()));
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"220_GLXMLGenerator", (Locale)ctx.getLocale()), sdf.format(rowset.getDate("BOOKEDDATE")));
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"221_GLXMLGenerator", (Locale)ctx.getLocale()), String.valueOf(periodInfo.getPeriodYear()));
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"222_GLXMLGenerator", (Locale)ctx.getLocale()), this.getPeriodNumber(periodInfo.getPeriodNumber()));
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"208_GLXMLGenerator", (Locale)ctx.getLocale()), rowset.getString("VOUCHERTYPE.NUMBER"));
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"209_GLXMLGenerator", (Locale)ctx.getLocale()), rowset.getString("NUMBER"));
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"223_GLXMLGenerator", (Locale)ctx.getLocale()), String.valueOf(count));
                if (!GlUtils.isEmpty(rowset.getString("ASSITRECORD.id"))) {
                    this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"224_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(rowset.getString("ASSITRECORD.Description")));
                } else {
                    this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"224_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(rowset.getString("ENTRIES.DESCRIPTION")));
                }
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"225_GLXMLGenerator", (Locale)ctx.getLocale()), rowset.getString("ACCOUNT.NUMBER"));
                String asstAccountNumber = rowset.getString("AsstAccountNumber");
                String[] asstAccountNumbers = null;
                if (asstAccountNumber != null) {
                    asstAccountNumbers = asstAccountNumber.split(";");
                }
                for (int i = 1; i <= 30; ++i) {
                    asstAccountNumber = asstAccountNumbers != null && i - 1 < asstAccountNumbers.length ? asstAccountNumbers[i - 1] : "";
                    this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"226_GLXMLGenerator", (Locale)ctx.getLocale()) + i + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"227_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventasstNumber(asstAccountNumber));
                }
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"210_GLXMLGenerator", (Locale)ctx.getLocale()), rowset.getString("CURRENCY.NUMBER"));
                int precision = rowset.getInt("CURRENCY.PRECISION");
                if (rowset.getString("CURRENCY.NUMBER") == null || "".equals(rowset.getString("CURRENCY.NUMBER"))) {
                    precision = 4;
                }
                precision = 2;
                String qtyStr = null;
                String localAmountDebitStr = null;
                String localAmountCredit = null;
                String originalAmountStr = null;
                String price = null;
                if (!GlUtils.isEmpty(rowset.getString("ASSITRECORD.id"))) {
                    String measureunitName = rowset.getString("ASSITMEASUREUNIT.NAME");
                    price = this.bigDecimalToString(rowset.getBigDecimal("ASSITRECORD.PRICE"), 4);
                    if (GlUtils.isEmpty(measureunitName)) {
                        measureunitName = rowset.getString("MEASUREUNIT.NAME");
                        price = this.bigDecimalToString(rowset.getBigDecimal("ENTRIES.PRICE"), 4);
                    }
                    this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"228_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(measureunitName));
                    qtyStr = this.bigDecimalToString(rowset.getBigDecimal("ASSITRECORD.QUANTITY"), 6);
                    localAmountDebitStr = this.bigDecimalToString(rowset.getBigDecimal("ASSITRECORD.LOCALAMOUNTDEBIT"), baseCurrencyPre);
                    localAmountCredit = this.bigDecimalToString(rowset.getBigDecimal("ASSITRECORD.LOCALAMOUNTCREDIT"), baseCurrencyPre);
                    originalAmountStr = this.bigDecimalToString(rowset.getBigDecimal("ASSITRECORD.ORIGINALAMOUNT"), precision);
                } else {
                    this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"228_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(rowset.getString("MEASUREUNIT.NAME")));
                    qtyStr = this.bigDecimalToString(rowset.getBigDecimal("ENTRIES.QUANTITY"), 6);
                    localAmountDebitStr = this.bigDecimalToString(rowset.getBigDecimal("LOCALAMOUNTDEBIT"), baseCurrencyPre);
                    localAmountCredit = this.bigDecimalToString(rowset.getBigDecimal("LOCALAMOUNTCREDIT"), baseCurrencyPre);
                    originalAmountStr = this.bigDecimalToString(rowset.getBigDecimal("ENTRIES.ORIGINALAMOUNT"), precision);
                    price = this.bigDecimalToString(rowset.getBigDecimal("ENTRIES.PRICE"), 4);
                }
                int entryDC = rowset.getInt("ENTRIES.EntryDC");
                if (entryDC == 1) {
                    this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"229_GLXMLGenerator", (Locale)ctx.getLocale()), qtyStr);
                    this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"230_GLXMLGenerator", (Locale)ctx.getLocale()), originalAmountStr);
                } else {
                    this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"229_GLXMLGenerator", (Locale)ctx.getLocale()), "");
                    this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"230_GLXMLGenerator", (Locale)ctx.getLocale()), "");
                }
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"231_GLXMLGenerator", (Locale)ctx.getLocale()), localAmountDebitStr);
                if (entryDC == 0) {
                    this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"232_GLXMLGenerator", (Locale)ctx.getLocale()), qtyStr);
                    this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"233_GLXMLGenerator", (Locale)ctx.getLocale()), originalAmountStr);
                } else {
                    this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"232_GLXMLGenerator", (Locale)ctx.getLocale()), "");
                    this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"233_GLXMLGenerator", (Locale)ctx.getLocale()), "");
                }
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"234_GLXMLGenerator", (Locale)ctx.getLocale()), localAmountCredit);
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"235_GLXMLGenerator", (Locale)ctx.getLocale()), "");
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"236_GLXMLGenerator", (Locale)ctx.getLocale()), this.bigDecimalToString(rowset.getBigDecimal("ENTRIES.localExchangeRate"), 4));
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"237_GLXMLGenerator", (Locale)ctx.getLocale()), price);
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"238_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(rowset.getString("DESCRIPTION")) + "-" + sdf.format(rowset.getDate("BIZDATE")));
                String bizNum = rowset.getString("BizNumber");
                String invoiceNumber = rowset.getString("InvoiceNumber");
                String settlementType = rowset.getString("SettlementType.NAME");
                String settlementCode = rowset.getString("SettlementCode");
                String ticketNumber = rowset.getString("TicketNumber");
                String feeType = this.conventFeeType(rowset.getInt("FeeType"));
                String expand = null;
                expand = GlUtils.isEmpty(bizNum) && GlUtils.isEmpty(invoiceNumber) && GlUtils.isEmpty(settlementType) && GlUtils.isEmpty(settlementCode) && GlUtils.isEmpty(ticketNumber) && GlUtils.isEmpty(feeType) ? "" : bizNum + "-" + invoiceNumber + "-" + settlementType + "-" + settlementCode + "-" + ticketNumber + "-" + feeType;
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"239_GLXMLGenerator", (Locale)ctx.getLocale()), "");
                String billTypeName = "";
                String billNumber = "";
                String billDate = "";
                String billTypeNumber = "";
                if (rowset.getString("Bill.id") != null) {
                    billNumber = this.conventNullString(rowset.getString("Bill.NUMBER"));
                    if (rowset.getDate("Bill.issuesDate") != null) {
                        billDate = sdf.format(rowset.getDate("Bill.issuesDate"));
                    }
                    billTypeName = this.conventNullString(rowset.getString("BillType.NAME"));
                    if ("com.kingdee.eas.fm.nt.app.BankDraft".equalsIgnoreCase(rowset.getString("Bill.SRCENTITYNAME"))) {
                        billTypeName = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"240_GLXMLGenerator", (Locale)ctx.getLocale());
                    }
                    billTypeNumber = this.conventNullString(rowset.getString("BillType.NUMBER"));
                }
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"241_GLXMLGenerator", (Locale)ctx.getLocale()), billTypeNumber);
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"242_GLXMLGenerator", (Locale)ctx.getLocale()), billTypeName);
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"243_GLXMLGenerator", (Locale)ctx.getLocale()), billNumber);
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"244_GLXMLGenerator", (Locale)ctx.getLocale()), billDate);
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"245_GLXMLGenerator", (Locale)ctx.getLocale()), String.valueOf(rowset.getInt("Attachments")));
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"246_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(rowset.getString("CREATOR.NAME")));
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"247_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(rowset.getString("AUDITOR.NAME")));
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"248_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(rowset.getString("POSTER.NAME")));
                String isPost = null;
                String isCancel = null;
                isPost = rowset.getInt("BIZSTATUS") == 5 ? "1" : "0";
                isCancel = rowset.getInt("BIZSTATUS") == 2 ? "1" : "0";
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"249_GLXMLGenerator", (Locale)ctx.getLocale()), isPost);
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"250_GLXMLGenerator", (Locale)ctx.getLocale()), isCancel);
                this.addStringElement(voucherInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"251_GLXMLGenerator", (Locale)ctx.getLocale()), SystemEnum.getEnum((int)rowset.getInt("SourceSys")).getAlias());
                ++count;
                this.endElement();
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"252_GLXMLGenerator", (Locale)ctx.getLocale()), (Throwable)e);
                this.addException((Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"253_GLXMLGenerator", (Locale)ctx.getLocale()) + e.getMessage())));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rowset, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rowset, (Statement)pstmt, (Connection)conn);
    }

    private boolean isHasBillId(String s) {
        if ("com.kingdee.eas.fm.nt.app.ReceivableBill".equalsIgnoreCase(s)) {
            return true;
        }
        if ("com.kingdee.eas.fm.nt.app.PayableBill".equalsIgnoreCase(s)) {
            return true;
        }
        if ("com.kingdee.eas.fm.nt.app.Cheque".equalsIgnoreCase(s)) {
            return true;
        }
        if ("com.kingdee.eas.fm.nt.app.RecCheque".equalsIgnoreCase(s)) {
            return true;
        }
        if ("com.kingdee.eas.fm.nt.app.BankDraft".equalsIgnoreCase(s)) {
            return true;
        }
        if ("com.kingdee.eas.fi.cas.app.ReceivingBill".equalsIgnoreCase(s)) {
            return true;
        }
        return "com.kingdee.eas.fi.cas.app.PaymentBill".equalsIgnoreCase(s);
    }

    private void bulidVoucherUnionSQL(StringBuffer sql, String s) {
        if (s.equalsIgnoreCase("T_CAS_RECEIVINGBILL") || s.equalsIgnoreCase("T_CAS_paymentbill")) {
            sql.append("LEFT OUTER JOIN t_bot_relation AS \"BOTP\"\r\n");
            sql.append("ON \"VOUCHER\".FID = \"BOTP\".FDESTOBJECTID\r\n");
            sql.append("LEFT OUTER JOIN T_BOT_Mapping ");
            sql.append(" AS \"Mapping\"\r\n");
            sql.append("ON \"BOTP\".FBOTMAPPINGID = \"Mapping\".FID\r\n");
            sql.append("LEFT OUTER JOIN ");
            sql.append(s);
            sql.append(" AS \"Bill\"\r\n");
            sql.append("ON \"BOTP\".FSRCOBJECTID = \"Bill\".FID\r\n");
            sql.append("LEFT OUTER JOIN T_BD_SettlementType AS \"BillType\"\r\n");
            sql.append("ON \"Bill\".FSettlementTypeID = \"BillType\".FID\r\n");
            sql.append("WHERE \"VOUCHER\".FCompanyID = ? AND \"PERIOD\".FNumber = ? AND \"VOUCHER\".FBizStatus <> 0\r\n");
            sql.append(" AND (\"VOUCHER\".FSourceSys = 7 OR \"VOUCHER\".FSourceSys = 12 OR \"VOUCHER\".FSourceSys = 13)");
        } else if (s.equalsIgnoreCase("ALL")) {
            sql.append("WHERE \"VOUCHER\".FCompanyID = ? AND \"PERIOD\".FNumber = ? AND \"VOUCHER\".FBizStatus <> 0\r\n");
            sql.append(" AND \"VOUCHER\".FSourceSys <>7 AND \"VOUCHER\".FSourceSys <>12 AND \"VOUCHER\".FSourceSys <>13 AND \"VOUCHER\".FSourceSys <>21 AND \"VOUCHER\".FSourceSys <>28");
        } else {
            sql.append("LEFT OUTER JOIN t_bot_relation AS \"BOTP\"\r\n");
            sql.append("ON \"VOUCHER\".FID = \"BOTP\".FDESTOBJECTID\r\n");
            sql.append("LEFT OUTER JOIN T_BOT_Mapping ");
            sql.append(" AS \"Mapping\"\r\n");
            sql.append("ON \"BOTP\".FBOTMAPPINGID = \"Mapping\".FID\r\n");
            sql.append("LEFT OUTER JOIN ");
            sql.append(s);
            sql.append(" AS \"Bill\"\r\n");
            sql.append("ON \"BOTP\".FSRCOBJECTID = \"Bill\".FID\r\n");
            sql.append("LEFT OUTER JOIN T_NT_NTType AS \"BillType\"\r\n");
            sql.append("ON \"Bill\".FNtTypeID = \"BillType\".FID\r\n");
            sql.append("WHERE \"VOUCHER\".FCompanyID = ? AND \"PERIOD\".FNumber = ? AND \"VOUCHER\".FBizStatus <> 0\r\n");
            sql.append(" AND (\"VOUCHER\".FSourceSys = 28 OR \"VOUCHER\".FSourceSys = 21)");
        }
    }

    private void bulidVoucherMainSQL(StringBuffer sql, String s) {
        sql.append("SELECT \r\n");
        sql.append("\"VOUCHER\".FID AS \"ID\", \r\n");
        sql.append("\"COMPANY\".FName_l2 AS \"COMPANY.NAME\",\r\n");
        sql.append("\"VOUCHERTYPE\".FName_l2 AS \"VOUCHERTYPE.NAME\", \r\n");
        sql.append("\"VOUCHERTYPE\".FNumber AS \"VOUCHERTYPE.NUMBER\", \r\n");
        sql.append("\"VOUCHER\".FNumber AS \"NUMBER\", \r\n");
        sql.append("\"VOUCHER\".FBookedDate AS \"BOOKEDDATE\", \r\n");
        sql.append("\"VOUCHER\".FBizDate AS \"BIZDATE\", \r\n");
        sql.append("\"VOUCHER\".FDescription AS \"DESCRIPTION\", \r\n");
        sql.append("\"VOUCHER\".FIsCheck AS \"ISCHECK\", \r\n");
        sql.append("\"VOUCHER\".FSourceSys AS \"SOURCESYS\", \r\n");
        sql.append("\"CASHIER\".FName_l2 AS \"CASHIER.NAME\",\r\n");
        sql.append("\"AUDITOR\".FName_l2 AS \"AUDITOR.NAME\",\r\n");
        sql.append("\"CREATOR\".FName_l2 AS \"CREATOR.NAME\",\r\n");
        sql.append("\"POSTER\".FName_l2 AS \"POSTER.NAME\", \r\n");
        sql.append("\"CANCELLER\".FName_l2 AS \"CANCELLER.NAME\", \r\n");
        sql.append("\"VOUCHER\".FBizStatus AS \"BIZSTATUS\", \r\n");
        sql.append("\"ENTRIES\".FSeq AS \"ENTRIES.SEQ\", \r\n");
        sql.append("\"ENTRIES\".FDescription AS \"ENTRIES.DESCRIPTION\",\r\n");
        sql.append("\"ACCOUNT\".FNumber AS \"ACCOUNT.NUMBER\", \r\n");
        sql.append("\"CURRENCY\".FPrecision AS \"CURRENCY.PRECISION\",\r\n");
        sql.append("\"CURRENCY\".FNumber AS \"CURRENCY.NUMBER\",\r\n");
        sql.append("CASE  WHEN (\"ENTRIES\".FMeasureUnitID IS NULL) THEN NULL ELSE \"ENTRIES\".FPrice END AS \"ENTRIES.PRICE\", \r\n");
        sql.append("CASE  WHEN (\"ENTRIES\".FMeasureUnitID IS NULL) THEN NULL ELSE \"ENTRIES\".FQuantity END AS \"ENTRIES.QUANTITY\", \r\n");
        sql.append("CASE  WHEN (\"ENTRIES\".FMeasureUnitID IS NULL) THEN NULL ELSE \"MEASUREUNIT\".FNAME_L2 END AS \"MEASUREUNIT.NAME\", \r\n");
        sql.append("CASE  WHEN (\"ASSITRECORD\".FMeasureUnitID IS NULL) THEN NULL ELSE \"ASSITRECORD\".FPrice END AS \"ASSITRECORD.PRICE\", \r\n");
        sql.append("CASE  WHEN (\"ASSITRECORD\".FMeasureUnitID IS NULL) THEN NULL ELSE \"ASSITRECORD\".FQuantity END AS \"ASSITRECORD.QUANTITY\", \r\n");
        sql.append("CASE  WHEN (\"ASSITRECORD\".FMeasureUnitID IS NULL) THEN NULL ELSE \"ASSITMEASUREUNIT\".FNAME_L2 END AS \"ASSITMEASUREUNIT.NAME\", \r\n");
        sql.append("\"ENTRIES\".FOriginalAmount AS \"ENTRIES.ORIGINALAMOUNT\", \r\n");
        sql.append("\"ENTRIES\".FLocalAmount AS \"ENTRIES.LOCALAMOUNT\",\r\n");
        sql.append("CASE \"ENTRIES\".FEntryDC WHEN 1 THEN \"ENTRIES\".FLocalAmount ELSE NULL END AS \"LOCALAMOUNTDEBIT\", \r\n");
        sql.append("CASE \"ENTRIES\".FEntryDC WHEN 1 THEN NULL ELSE \"ENTRIES\".FLocalAmount END AS \"LOCALAMOUNTCREDIT\", \r\n");
        sql.append("\"ASSITRECORD\".FOriginalAmount AS \"ASSITRECORD.ORIGINALAMOUNT\", \r\n");
        sql.append("\"ASSITRECORD\".FLocalAmount AS \"ASSITRECORD.LOCALAMOUNT\",\r\n");
        sql.append("CASE \"ENTRIES\".FEntryDC WHEN 1 THEN \"ASSITRECORD\".FLocalAmount ELSE NULL END AS \"ASSITRECORD.LOCALAMOUNTDEBIT\", \r\n");
        sql.append("CASE \"ENTRIES\".FEntryDC WHEN 1 THEN NULL ELSE \"ASSITRECORD\".FLocalAmount END AS \"ASSITRECORD.LOCALAMOUNTCREDIT\", \r\n");
        sql.append("\"ENTRIES\".FEntryDC AS \"ENTRIES.EntryDC\",\r\n");
        sql.append("\"VOUCHER\".FAttachments AS \"ATTACHMENTS\", \r\n");
        sql.append("\"VOUCHER\".FCreateTime AS \"CREATETIME\", \r\n");
        sql.append("\"ENTRIES\".FLocalExchangeRate AS \"ENTRIES.localExchangeRate\",\r\n");
        sql.append("\"ASSITRECORD\".FBizNumber AS \"BizNumber\",\r\n");
        sql.append("\"ASSITRECORD\".FInvoiceNumber AS \"InvoiceNumber\",\r\n");
        sql.append("\"SettlementType\".FNAME_l2 AS \"SettlementType.NAME\",\r\n");
        sql.append("\"ASSITRECORD\".FSettlementCode AS \"SettlementCode\",\r\n");
        sql.append("\"ASSITRECORD\".FDescription AS \"ASSITRECORD.Description\",\r\n");
        sql.append("\"ASSITRECORD\".FTicketNumber AS \"TicketNumber\", \r\n");
        sql.append("\"ASSITRECORD\".FFeeType AS \"FeeType\",  \r\n");
        sql.append("\"AssistantH\".flongnamegroup_l2 AS \"AsstAccountName\",\r\n");
        sql.append("Replace(\"AssistantH\".FNumberGroup_l2, '!', '') AS \"AsstAccountNumber\",\r\n");
        sql.append("\"ASSITRECORD\".fid AS \"ASSITRECORD.id\",\r\n");
        sql.append("\"ASSITRECORD\".fNUMBER AS \"ASSITRECORD.NUMBER\",\r\n");
        sql.append("\"SettlementType\".fNUMBER AS \"SettlementType.NUMBER\",\r\n");
        if (s.equalsIgnoreCase("T_CAS_RECEIVINGBILL") || s.equalsIgnoreCase("T_CAS_paymentbill")) {
            sql.append("\"BOTP\".FSRCOBJECTID AS \"BOTP.SRCOBJECTID\",\r\n");
            sql.append("\"Bill\".fid AS \"Bill.id\",\r\n");
            sql.append("\"Mapping\".FSRCENTITYFULLNAME AS \"Bill.SRCENTITYNAME\",\r\n");
            sql.append(" NULL AS \"Bill.issuesDate\",\r\n");
            sql.append(" NULL AS \"Bill.NUMBER\",\r\n");
            sql.append(" NULL AS \"BillType.NAME\",\r\n");
            sql.append(" \"BillType\".FNumber AS \"BillType.NUMBER\",\r\n");
        } else if (s.equals("ALL")) {
            sql.append(" NULL AS \"BOTP.SRCOBJECTID\",\r\n");
            sql.append(" NULL AS \"Bill.id\",\r\n");
            sql.append(" NULL AS \"Bill.SRCENTITYNAME\",\r\n");
            sql.append(" NULL AS \"Bill.issuesDate\",\r\n");
            sql.append(" NULL AS \"Bill.NUMBER\",\r\n");
            sql.append(" NULL AS \"BillType.NAME\",\r\n");
            sql.append(" NULL AS \"BillType.NUMBER\",\r\n");
        } else {
            sql.append("\"BOTP\".FSRCOBJECTID AS \"BOTP.SRCOBJECTID\",\r\n");
            sql.append("\"Bill\".fid AS \"Bill.id\",\r\n");
            sql.append("\"Mapping\".FSRCENTITYFULLNAME AS \"Bill.SRCENTITYNAME\",\r\n");
            if (s.equals("T_NT_ReceivableBill")) {
                sql.append("\"Bill\".FIssuesDate AS \"Bill.issuesDate\",\r\n");
            } else if (s.equalsIgnoreCase("T_NT_BankDraft")) {
                sql.append("\"Bill\".FpayerDate AS \"Bill.issuesDate\",\r\n");
            } else {
                sql.append("\"Bill\".FISSUEDATE AS \"Bill.issuesDate\",\r\n");
            }
            sql.append("\"Bill\".FNUMBER AS \"Bill.NUMBER\",\r\n");
            sql.append("\"BillType\".FName_L2 AS \"BillType.NAME\",\r\n");
            sql.append(" NULL AS \"BillType.NUMBER\",\r\n");
        }
        sql.append("\"ASSITRECORD\".fSEQ AS \"ASSITRECORD.SEQ\"\r\n");
        sql.append("FROM T_GL_Voucher AS \"VOUCHER\"\r\n");
        sql.append("LEFT OUTER JOIN T_BD_Period AS \"PERIOD\"\r\n");
        sql.append("ON \"VOUCHER\".FPeriodID = \"PERIOD\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_ORG_BaseUnit AS \"COMPANY\"\r\n");
        sql.append("ON \"VOUCHER\".FCompanyID = \"COMPANY\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_PM_User AS \"CASHIER\"\r\n");
        sql.append("ON \"VOUCHER\".FCashierID = \"CASHIER\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_BD_VoucherTypes AS \"VOUCHERTYPE\"\r\n");
        sql.append("ON \"VOUCHER\".FVoucherTypeID = \"VOUCHERTYPE\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_PM_User AS \"AUDITOR\"\r\n");
        sql.append("ON \"VOUCHER\".FAuditorID = \"AUDITOR\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_PM_User AS \"HANDLER\"\r\n");
        sql.append("ON \"VOUCHER\".FHandlerID = \"HANDLER\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_PM_User AS \"CREATOR\"\r\n");
        sql.append("ON \"VOUCHER\".FCreatorID = \"CREATOR\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_PM_User AS \"POSTER\"\r\n");
        sql.append("ON \"VOUCHER\".FPosterID = \"POSTER\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_PM_User AS \"CANCELLER\"\r\n");
        sql.append("ON \"CANCELLER\".FID = \"VOUCHER\".FCancellerID\r\n");
        sql.append("INNER JOIN T_GL_VoucherEntry AS \"ENTRIES\"\r\n");
        sql.append("ON \"VOUCHER\".FID = \"ENTRIES\".FBillID\r\n");
        sql.append("LEFT OUTER JOIN T_BD_Currency AS \"CURRENCY\"\r\n");
        sql.append("ON \"ENTRIES\".FCurrencyID = \"CURRENCY\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_BD_MeasureUnit AS \"MEASUREUNIT\"\r\n");
        sql.append("ON \"ENTRIES\".FMeasureUnitID = \"MEASUREUNIT\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_BD_AccountView AS \"ACCOUNT\"\r\n");
        sql.append("ON \"ENTRIES\".FAccountID = \"ACCOUNT\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_GL_VoucherAssistRecord AS \"ASSITRECORD\"\r\n");
        sql.append("ON \"ASSITRECORD\".FEntryID = \"ENTRIES\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_BD_MeasureUnit AS \"ASSITMEASUREUNIT\"\r\n");
        sql.append("ON \"ASSITRECORD\".FMeasureUnitID = \"ASSITMEASUREUNIT\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_BD_AssistantHG AS \"AssistantH\"\r\n");
        sql.append("ON \"ASSITRECORD\".FAssGrpID = \"AssistantH\".FID\r\n");
        sql.append("LEFT OUTER JOIN T_BD_SettlementType AS \"SettlementType\"\r\n");
        sql.append("ON \"ASSITRECORD\".FSettlementTypeID = \"SettlementType\".FID \r\n");
    }

    private String conventFeeType(int feeType) {
        FeeTypeEnum feeTypeEnum = FeeTypeEnum.getEnum((int)feeType);
        if (feeTypeEnum != null) {
            return feeTypeEnum.getAlias();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAccountBalance(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) {
        ReportPartner partner = new ReportPartner(ctx);
        String tempTableName = null;
        Connection con = null;
        try {
            PeriodInfo currentPeriod = GlUtils.getCurrentPeriod(ctx, companyInfo.getId().toString());
            boolean isAfterPeriod = false;
            boolean balanceDirSamAsAccount = false;
            if (periodInfo.getNumber() > currentPeriod.getNumber()) {
                isAfterPeriod = true;
            }
            con = EJBFactory.getConnection((Context)ctx);
            partner.setConnection(con);
            tempTableName = partner.createTempTable("EGLSL", this.getTempTableStruct(partner));
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("INSERT ");
            insertSql.append(tempTableName);
            insertSql.append(" \r\n");
            insertSql.append(" (FAccountID, FCurrencyID, \t\t\t\r\n");
            insertSql.append("FCurrencyName,                      \r\n");
            insertSql.append("  FYearBeginDebitFor,FYearBeginCreditFor,\t\r\n");
            insertSql.append("  FBeginDebitFor,FBeginCreditFor,\t\r\n");
            insertSql.append("  FDebitFor, FCreditFor, \t\t\t\r\n");
            insertSql.append("  FYearDebitFor, FYearCreditFor,\t\r\n");
            insertSql.append("  FEndDebitFor, FEndCreditFor,\t\t\r\n");
            insertSql.append("  FYearBeginDebitLocal,FYearBeginCreditLocal,\r\n");
            insertSql.append("  FBeginDebitLocal,FBeginCreditLocal,\r\n");
            insertSql.append("  FDebitLocal, FCreditLocal, \t\t\r\n");
            insertSql.append("  FYearDebitLocal, FYearCreditLocal,\r\n");
            insertSql.append("  FEndDebitLocal, FEndCreditLocal,\t\r\n");
            insertSql.append("  FYearBeginDebitRpt, FYearBeginCreditRpt,\t\r\n");
            insertSql.append("  FBeginDebitRpt, FBeginCreditRpt,\t\r\n");
            insertSql.append("  FDebitRpt, FCreditRpt, \t\t\t\r\n");
            insertSql.append("  FYearDebitRpt, FYearCreditRpt,\t\r\n");
            insertSql.append("  FEndDebitRpt, FEndCreditRpt,\t\t\r\n");
            insertSql.append("  FYearBeginQty , \r\n");
            insertSql.append("  FBeginQty , \r\n");
            insertSql.append("  FYearDebitQty , \r\n");
            insertSql.append("  FYearCreditQty , \r\n");
            insertSql.append("  FDebitQty , \r\n");
            insertSql.append("  FCreditQty , \r\n");
            insertSql.append("  FEndQty , \r\n");
            insertSql.append("  FLineTypeSum, \t\r\n");
            insertSql.append("  FLineType, \r\n");
            insertSql.append("  FAccountOrAssist, \r\n");
            insertSql.append("  FCount, \r\n");
            insertSql.append("  FAssistGrpID, \r\n");
            insertSql.append("  FBWType) \r\n");
            SqlParameter2 parameterAccount = new SqlParameter2();
            SqlParameter2 parameterAssist = new SqlParameter2();
            StringBuffer assitAccountSql = new StringBuffer();
            assitAccountSql.append(" select\t\r\n");
            assitAccountSql.append("FAccountID, FCurrencyID,\t \r\n");
            assitAccountSql.append("fcurrencyname,\r\n");
            assitAccountSql.append("FYearBeginDebitFor,FYearBeginCreditFor,\t \r\n");
            assitAccountSql.append("FBeginDebitFor,FBeginCreditFor,\t \r\n");
            assitAccountSql.append("FDebitFor, FCreditFor,\t \r\n");
            assitAccountSql.append("FYearDebitFor, FYearCreditFor,\t \r\n");
            assitAccountSql.append("FEndDebitFor, FEndCreditFor,\t\t \r\n");
            assitAccountSql.append("FYearBeginDebitLocal,FYearBeginCreditLocal, \r\n");
            assitAccountSql.append("FBeginDebitLocal,FBeginCreditLocal, \r\n");
            assitAccountSql.append("FDebitLocal, FCreditLocal, \r\n");
            assitAccountSql.append("FYearDebitLocal, FYearCreditLocal,\r\n");
            assitAccountSql.append("FEndDebitLocal, FEndCreditLocal,\t \r\n");
            assitAccountSql.append("FYearBeginDebitRpt, FYearBeginCreditRpt,\t \r\n");
            assitAccountSql.append("FBeginDebitRpt, FBeginCreditRpt,\t \r\n");
            assitAccountSql.append("FDebitRpt, FCreditRpt,\t \r\n");
            assitAccountSql.append("FYearDebitRpt, FYearCreditRpt,\t \r\n");
            assitAccountSql.append("FEndDebitRpt, FEndCreditRpt,\t\t \r\n");
            assitAccountSql.append("FYearBeginQty , \r\n");
            assitAccountSql.append("FBeginQty , \r\n");
            assitAccountSql.append("FYearDebitQty , \r\n");
            assitAccountSql.append("FYearCreditQty ,\r\n");
            assitAccountSql.append("FDebitQty , \r\n");
            assitAccountSql.append("FCreditQty ,\r\n");
            assitAccountSql.append("FEndQty , \r\n");
            assitAccountSql.append("FLineTypeSum, \t \r\n");
            assitAccountSql.append("FLineType,\r\n");
            assitAccountSql.append("FAccountOrAssist, \r\n");
            assitAccountSql.append("FCount, \r\n");
            assitAccountSql.append("FAssistGrpID, \r\n");
            assitAccountSql.append("FBWType \r\n");
            assitAccountSql.append("from (\r\n");
            assitAccountSql.append("select TA.FID FAccountID, tb.FCurrencyID, \t \r\n");
            assitAccountSql.append(" tb.fcurrencyname , \r\n");
            this.addInsertSqlForCurrency(assitAccountSql, "For", balanceDirSamAsAccount, isAfterPeriod);
            this.addInsertSqlForCurrency(assitAccountSql, "Local", balanceDirSamAsAccount, isAfterPeriod);
            this.addInsertSqlForCurrency(assitAccountSql, "Rpt", balanceDirSamAsAccount, isAfterPeriod);
            assitAccountSql.append(" 0.0 FYearBeginQty,\t\t\t\t\t \r\n");
            assitAccountSql.append(" sum( case when TA.FIsQty = 0 then 0 else case WHEN TB.FIsStartPeriod = 1 THEN TB.FBeginQty ELSE 0.0 END end) FBeginQty,\t\t\t\t\t\t \r\n");
            this.addInsertSqlForYearQty(assitAccountSql, balanceDirSamAsAccount, isAfterPeriod);
            assitAccountSql.append("sum(case when TA.FIsQty = 0then 0 else TB.FDebitQty end) FDebitQty,sum(case when TA.FIsQty = 0then 0 else TB.FCreditQty end) FCreditQty,  \r\n");
            this.addInsertSqlForEndQty(assitAccountSql, balanceDirSamAsAccount, isAfterPeriod);
            assitAccountSql.append(" '0' FLineTypeSum, \t \r\n");
            assitAccountSql.append("\t0 FLineType,\t\t\t\t\t\t\t\t\t\t \r\n");
            assitAccountSql.append(" 2 FAccountOrAssist,\t\t\t\t\t\t\t \r\n");
            assitAccountSql.append(" HG.FCount FCount,\t\t\t\t\t\t\t\t \r\n");
            assitAccountSql.append(" TB.FAssistGrpID FAssistGrpID,\t\t\t\t\t \r\n");
            assitAccountSql.append("TA.fbw FBWType\r\n");
            assitAccountSql.append("FROM T_BD_AccountView TA\t\t\t\t\t\t\t\t \r\n");
            assitAccountSql.append("\r\n");
            assitAccountSql.append(" inner join \r\n");
            assitAccountSql.append("(SELECT T0.FID ID FROM T_BD_ACCOUNTVIEW T0 WHERE (T0.FNUMBER <> '7003'))\r\n");
            assitAccountSql.append(" PT18 on PT18.ID=TA.FID\tINNER JOIN\t\t\t\t\t\t\t\t\t \r\n");
            assitAccountSql.append("\t\t(SELECT TAB.*,\t\t\t\t\t\t\t \r\n");
            assitAccountSql.append(" cc.fname_l2 fcurrencyname, \r\n");
            assitAccountSql.append(" CASE WHEN tab.tpFPeriodYear = ? AND tab.tpFPeriodNumber = ? THEN 1 ELSE 0 END FIsStartPeriod,\r\n");
            assitAccountSql.append(" CASE WHEN tab.tpFPeriodYear = ? AND tab.tpFPeriodNumber = ? THEN 1 ELSE 0 END FIsEndPeriod,\r\n");
            assitAccountSql.append("1 FEndPeriodNoAfterCurrent, \r\n");
            assitAccountSql.append(" CASE WHEN tab.tpFPeriodYear = ? AND tab.tpFPeriodNumber = ? THEN 1 ELSE 0 END FIsCurrentPeriod,\r\n");
            assitAccountSql.append(" CASE WHEN tab.tpFPeriodYear *100+tab.tpFPeriodNumber > ? THEN 1 ELSE 0 END FIsAfterCurrentPeriod,\r\n");
            assitAccountSql.append("0 FIsOverCurrentYear\r\n");
            assitAccountSql.append("\t\t FROM ( \r\n");
            assitAccountSql.append("     select tab.*, tp.fnumber tpfnumber, tp.fperiodyear tpfperiodyear, tp.fperiodnumber tpfperiodnumber, tp.ftypeid tpftypeid \r\n");
            assitAccountSql.append("     from " + GLBalanceUtils.getAssistBalanceTable(1) + " tab  \r\n");
            assitAccountSql.append("     INNER JOIN T_BD_Period TP ON TAB.FPeriod = TP.FNumber \r\n");
            assitAccountSql.append(" ) TAB \r\n");
            assitAccountSql.append(" inner join t_bd_currency cc on cc.fid = tab.fcurrencyid\r\n");
            assitAccountSql.append("\t\t WHERE TAB.FOrgUnitID = ?\t\t\t\t\t\t\t \r\n");
            assitAccountSql.append("\t\t\tAND tab.tpFTypeID = ?\t\t\t\t\t\t\t\t\t \r\n");
            assitAccountSql.append(" AND tab.tpFPeriodYear=? and tab.tpFPeriodNumber=?\t\t ) TB\t\t\t\t\t\t\t\t\t\t\t\t\t\t \r\n");
            assitAccountSql.append("\tON TA.FID = TB.FAccountID\t\t\t\t\t\t\t\t\t\t \r\n");
            assitAccountSql.append(" INNER JOIN t_bd_assistanthg HG on TB.FAssistGrpID=HG.fid \r\n");
            assitAccountSql.append(" WHERE\t\t\t\t\t\t\t\t\t\t\t\t \r\n");
            assitAccountSql.append(" TA.FAccountTableID = ?\t\t\t\t\t\t\t\t\t\t\t \r\n");
            assitAccountSql.append(" AND TA.fcompanyid = ?\t\t\t\t\t\t\t\t\t\t \r\n");
            assitAccountSql.append("\tgroup by ta.fid,TB.FAssistGrpID,hg.fcount,TA.fbw,tb.FCurrencyID,\t tb.fcurrencyname\r\n");
            assitAccountSql.append(") as TEP\r\n");
            parameterAssist.addValue(periodInfo.getPeriodYear());
            parameterAssist.addValue(periodInfo.getPeriodNumber());
            parameterAssist.addValue(periodInfo.getPeriodYear());
            parameterAssist.addValue(periodInfo.getPeriodNumber());
            parameterAssist.addValue(currentPeriod.getPeriodYear());
            parameterAssist.addValue(currentPeriod.getPeriodNumber());
            parameterAssist.addValue(currentPeriod.getPeriodYear() * 100 + currentPeriod.getPeriodNumber());
            parameterAssist.addValueChar(companyInfo.getId().toString());
            parameterAssist.addValueId((CoreBaseInfo)companyInfo.getAccountPeriodType());
            parameterAssist.addValue(periodInfo.getPeriodYear());
            parameterAssist.addValue(periodInfo.getPeriodNumber());
            parameterAssist.addValueId((CoreBaseInfo)companyInfo.getAccountTable());
            parameterAssist.addValueChar(companyInfo.getId().toString());
            StringBuffer accountSql = new StringBuffer();
            accountSql.append(" select * from (\r\n");
            accountSql.append("select TA.FID FAccountID, tb.FCurrencyID,\t\r\n");
            accountSql.append(" tb.fcurrencyname fcurrencyname,\r\n");
            this.addInsertSqlForCurrency(accountSql, "For", balanceDirSamAsAccount, isAfterPeriod);
            this.addInsertSqlForCurrency(accountSql, "Local", balanceDirSamAsAccount, isAfterPeriod);
            this.addInsertSqlForCurrency(accountSql, "Rpt", balanceDirSamAsAccount, isAfterPeriod);
            accountSql.append(" 0.0 FYearBeginQty, \t\t\t\t\t\t\t\t\r\n");
            accountSql.append(" sum( case when TA.FIsQty = 0then 0 else case WHEN TB.FIsStartPeriod = 1 THEN TB.FBeginQty ELSE 0.0 END end) FBeginQty,\t\t\t\t\t\t\t\t\t\r\n");
            this.addInsertSqlForYearQty(accountSql, balanceDirSamAsAccount, isAfterPeriod);
            accountSql.append("sum(case when TA.FIsQty = 0 then 0 else TB.FDebitQty end) FDebitQty,sum(case when TA.FIsQty = 0 then 0 else TB.FCreditQty end) FCreditQty,  \r\n");
            this.addInsertSqlForEndQty(accountSql, balanceDirSamAsAccount, isAfterPeriod);
            accountSql.append("'0'FLineTypeSum, \t\r\n");
            accountSql.append(" 0 FLineType,1 FAccountOrAssist, 0 FCount, ' ' FAssistGrpID ,\t\t\r\n");
            accountSql.append(" TA.fbw FBWType \r\n");
            accountSql.append("FROM T_BD_AccountView TA\t\t\t\t\t\t\t\t\t\r\n");
            accountSql.append("\r\n");
            accountSql.append(" inner join \r\n");
            accountSql.append("(SELECT T0.FID ID FROM T_BD_ACCOUNTVIEW T0 WHERE (T0.FNUMBER <> '7003'))\r\n");
            accountSql.append(" PT17 on PT17.ID=TA.FID left outer join(SELECT TAB.*, \t\t\t\t\t\t\t\t\r\n");
            accountSql.append(" cc.fname_l2 fcurrencyname ,\r\n");
            accountSql.append("CASE WHEN tab.tpFPeriodYear = ? AND tab.tpFPeriodNumber = ? THEN 1 ELSE 0 END FIsStartPeriod, \r\n");
            accountSql.append("CASE WHEN tab.tpFPeriodYear = ? AND tab.tpFPeriodNumber = ? THEN 1 ELSE 0 END FIsEndPeriod, \r\n");
            accountSql.append("1 FEndPeriodNoAfterCurrent, \r\n");
            accountSql.append("CASE WHEN tab.tpFPeriodYear = ? AND tab.tpFPeriodNumber = ? THEN 1 ELSE 0 END FIsCurrentPeriod, \r\n");
            accountSql.append("CASE WHEN tab.tpFPeriodYear *100+tab.tpFPeriodNumber > ? THEN 1 ELSE 0 END FIsAfterCurrentPeriod, \r\n");
            accountSql.append("0 FIsOverCurrentYear\r\n");
            accountSql.append("\t\t FROM ( \r\n");
            accountSql.append("     select tab.*, tp.fnumber tpfnumber, tp.fperiodyear tpfperiodyear, tp.fperiodnumber tpfperiodnumber, tp.ftypeid tpftypeid \r\n");
            accountSql.append("     from " + GLBalanceUtils.getAccountBalanceTable(1) + " tab \r\n");
            accountSql.append("     INNER JOIN T_BD_Period TP ON TAB.FPeriod = TP.FNumber \r\n");
            accountSql.append(" ) TAB \r\n");
            accountSql.append(" inner join t_bd_currency cc on cc.fid = tab.fcurrencyid WHERE TAB.FOrgUnitID = ?\t\t\t\t\t\t\t\t\t\r\n");
            accountSql.append("AND tab.tpFTypeID = ? \t\t\t\t\t\t\t\t\t\t\r\n");
            accountSql.append(" AND tab.tpFPeriodYear=? and tab.tpFPeriodNumber=? ) TB ON TA.FID = TB.FAccountID\t\t\t\t\t\t\t\t\r\n");
            accountSql.append(" WHERE \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            accountSql.append(" TA.FAccountTableID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
            accountSql.append(" AND TA.fcompanyid = ?\t\t\t\t\t\t\t\t\t\t\r\n");
            accountSql.append(" GROUP BY TA.FID,TA.fbw\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            accountSql.append(" ,tb.FCurrencyID,\t tb.fcurrencyname \r\n");
            accountSql.append(") as TP \r\n");
            accountSql.append(" Where TP.FACCOUNTID NOT IN \r\n");
            accountSql.append(" (SELECT FACCOUNTID FROM \r\n");
            accountSql.append(tempTableName);
            accountSql.append(") \r\n");
            parameterAccount.addValue(periodInfo.getPeriodYear());
            parameterAccount.addValue(periodInfo.getPeriodNumber());
            parameterAccount.addValue(periodInfo.getPeriodYear());
            parameterAccount.addValue(periodInfo.getPeriodNumber());
            parameterAccount.addValue(currentPeriod.getPeriodYear());
            parameterAccount.addValue(currentPeriod.getPeriodNumber());
            parameterAccount.addValue(currentPeriod.getPeriodYear() * 100 + currentPeriod.getPeriodNumber());
            parameterAccount.addValueChar(companyInfo.getId().toString());
            parameterAccount.addValueId((CoreBaseInfo)companyInfo.getAccountPeriodType());
            parameterAccount.addValue(periodInfo.getPeriodYear());
            parameterAccount.addValue(periodInfo.getPeriodNumber());
            parameterAccount.addValueId((CoreBaseInfo)companyInfo.getAccountTable());
            parameterAccount.addValueChar(companyInfo.getId().toString());
            String sqlToBeExcuteAssist = parameterAssist.getSqlWithParameters(assitAccountSql.toString());
            String sqlToBeExcuteAccount = parameterAccount.getSqlWithParameters(accountSql.toString());
            String insertAssistSql = new StringBuffer().append(insertSql).append(sqlToBeExcuteAssist).toString();
            String insertAccountSql = new StringBuffer().append(insertSql).append(sqlToBeExcuteAccount).toString();
            partner.executeSql(insertAssistSql, null);
            partner.executeSql(insertAccountSql, null);
            StringBuffer sql = new StringBuffer();
            sql.append("Select CASE\r\n");
            sql.append(" WHEN T_Main.FAccountOrAssist = 1 THEN \r\n");
            sql.append("TA.FLevel\r\n");
            sql.append(" when T_Main.FAccountOrAssist = 2 THEN \r\n");
            sql.append("0\r\n");
            sql.append(" ELSE\r\n");
            sql.append("null \r\n");
            sql.append(" END FAccountLevel,\r\n");
            sql.append(" TA.FNumber FAccountNumber,\r\n");
            sql.append(" TC.FNumber FCurrencyNumber,\r\n");
            sql.append(" TC.FPrecision FPrecision, \r\n");
            sql.append(" MU.FName_l2 FMuName, \r\n");
            sql.append(" CASE\r\n");
            sql.append(" WHEN T_Main.FLineType = 3 THEN\r\n");
            sql.append("T_Main.FYearBeginQty \r\n");
            sql.append(" ELSE\r\n");
            sql.append("T_Main.FEndQty + T_Main.FYearCreditQty - T_Main.FYearDebitQty\r\n");
            sql.append(" END FYearBeginQty,\r\n");
            sql.append(" CASE\r\n");
            sql.append(" WHEN T_Main.FLineType = 3 THEN\r\n");
            sql.append("T_Main.FYearBeginDebitFor\r\n");
            sql.append(" ELSE\r\n");
            sql.append("CASE \r\n");
            sql.append("WHEN (T_Main.FEndDebitFor - T_Main.FEndCreditFor + \r\n");
            sql.append(" T_Main.FYearCreditFor - T_Main.FYearDebitFor) >= 0 THEN \r\n");
            sql.append(" (T_Main.FEndDebitFor - T_Main.FEndCreditFor + \r\n");
            sql.append(" T_Main.FYearCreditFor - T_Main.FYearDebitFor) \r\n");
            sql.append("ELSE \r\n");
            sql.append(" 0 \r\n");
            sql.append("END\r\n");
            sql.append(" END FYearBeginDebitFor, \r\n");
            sql.append(" CASE\r\n");
            sql.append(" WHEN T_Main.FLineType = 3 THEN\r\n");
            sql.append("T_Main.FYearBeginDebitLocal\r\n");
            sql.append(" ELSE\r\n");
            sql.append("CASE \r\n");
            sql.append("WHEN (T_Main.FEndDebitLocal - T_Main.FEndCreditLocal + \r\n");
            sql.append(" T_Main.FYearCreditLocal - T_Main.FYearDebitLocal) >= 0 THEN \r\n");
            sql.append(" (T_Main.FEndDebitLocal - T_Main.FEndCreditLocal + \r\n");
            sql.append(" T_Main.FYearCreditLocal - T_Main.FYearDebitLocal) \r\n");
            sql.append("ELSE \r\n");
            sql.append(" 0 \r\n");
            sql.append("END\r\n");
            sql.append(" END FYearBeginDebitLocal, \r\n");
            sql.append(" CASE\r\n");
            sql.append(" WHEN T_Main.FLineType = 3 THEN\r\n");
            sql.append("T_Main.FYearBeginDebitRpt\r\n");
            sql.append(" ELSE\r\n");
            sql.append("CASE \r\n");
            sql.append("WHEN (T_Main.FEndDebitRpt - T_Main.FEndCreditRpt + \r\n");
            sql.append(" T_Main.FYearCreditRpt - T_Main.FYearDebitRpt) >= 0 THEN \r\n");
            sql.append(" (T_Main.FEndDebitRpt - T_Main.FEndCreditRpt + \r\n");
            sql.append(" T_Main.FYearCreditRpt - T_Main.FYearDebitRpt) \r\n");
            sql.append("ELSE \r\n");
            sql.append(" 0 \r\n");
            sql.append("END\r\n");
            sql.append(" END FYearBeginDebitRpt, \r\n");
            sql.append(" CASE\r\n");
            sql.append(" WHEN T_Main.FLineType = 3 THEN\r\n");
            sql.append("T_Main.FYearBeginCreditFor \r\n");
            sql.append(" ELSE\r\n");
            sql.append("CASE \r\n");
            sql.append("WHEN T_Main.FEndDebitFor - T_Main.FEndCreditFor +\r\n");
            sql.append(" T_Main.FYearCreditFor - T_Main.FYearDebitFor < 0 THEN \r\n");
            sql.append(" -1 * (T_Main.FEndDebitFor - T_Main.FEndCreditFor +\r\n");
            sql.append(" T_Main.FYearCreditFor - T_Main.FYearDebitFor) \r\n");
            sql.append("ELSE \r\n");
            sql.append(" 0 \r\n");
            sql.append("END\r\n");
            sql.append(" END FYearBeginCreditFor,\r\n");
            sql.append(" CASE\r\n");
            sql.append(" WHEN T_Main.FLineType = 3 THEN\r\n");
            sql.append("T_Main.FYearBeginCreditLocal \r\n");
            sql.append(" ELSE\r\n");
            sql.append("CASE \r\n");
            sql.append("WHEN T_Main.FEndDebitLocal - T_Main.FEndCreditLocal +\r\n");
            sql.append(" T_Main.FYearCreditLocal - T_Main.FYearDebitLocal < 0 THEN \r\n");
            sql.append(" -1 * (T_Main.FEndDebitLocal - T_Main.FEndCreditLocal +\r\n");
            sql.append(" T_Main.FYearCreditLocal - T_Main.FYearDebitLocal) \r\n");
            sql.append("ELSE \r\n");
            sql.append(" 0 \r\n");
            sql.append("END\r\n");
            sql.append(" END FYearBeginCreditLocal,\r\n");
            sql.append(" CASE\r\n");
            sql.append(" WHEN T_Main.FLineType = 3 THEN\r\n");
            sql.append("T_Main.FYearBeginCreditRpt \r\n");
            sql.append(" ELSE\r\n");
            sql.append("CASE \r\n");
            sql.append("WHEN T_Main.FEndDebitRpt - T_Main.FEndCreditRpt +\r\n");
            sql.append(" T_Main.FYearCreditRpt - T_Main.FYearDebitRpt < 0 THEN \r\n");
            sql.append(" -1 * (T_Main.FEndDebitRpt - T_Main.FEndCreditRpt +\r\n");
            sql.append(" T_Main.FYearCreditRpt - T_Main.FYearDebitRpt) \r\n");
            sql.append("ELSE \r\n");
            sql.append(" 0 \r\n");
            sql.append("END\r\n");
            sql.append(" END FYearBeginCreditRpt,\r\n");
            sql.append(" T_Main.FBeginQty FBeginQty, \r\n");
            sql.append(" T_Main.FBeginDebitFor,\r\n");
            sql.append(" T_Main.FBeginDebitLocal,\r\n");
            sql.append(" T_Main.FBeginDebitrpt,\r\n");
            sql.append(" T_Main.FBeginCreditFor, \r\n");
            sql.append(" T_Main.FBeginCreditLocal, \r\n");
            sql.append(" T_Main.FBeginCreditRpt, \r\n");
            sql.append(" T_Main.FDebitQty FDebitQty, \r\n");
            sql.append(" T_Main.FDebitFor FDebitFor, \r\n");
            sql.append(" T_Main.FDebitLocal FDebitLocal, \r\n");
            sql.append(" T_Main.FDebitRpt FDebitRpt, \r\n");
            sql.append(" T_Main.FCreditQty FCreditQty, \r\n");
            sql.append(" T_Main.FCreditFor FCreditFor, \r\n");
            sql.append(" T_Main.FCreditLocal FCreditLocal, \r\n");
            sql.append(" T_Main.FCreditRpt FCreditRpt, \r\n");
            sql.append(" T_Main.FYearDebitQty FYearDebitQty, \r\n");
            sql.append(" T_Main.FYearDebitFor FYearDebitFor, \r\n");
            sql.append(" T_Main.FYearDebitLocal FYearDebitLocal, \r\n");
            sql.append(" T_Main.FYearDebitRpt FYearDebitRpt, \r\n");
            sql.append(" T_Main.FYearCreditQty FYearCreditQty, \r\n");
            sql.append(" T_Main.FYearCreditFor FYearCreditFor, \r\n");
            sql.append(" T_Main.FYearCreditLocal FYearCreditLocal, \r\n");
            sql.append(" T_Main.FYearCreditRpt FYearCreditRpt, \r\n");
            sql.append(" T_Main.FEndQty FEndQty, \r\n");
            sql.append(" T_Main.FEndDebitFor FEndDebitFor, \r\n");
            sql.append(" T_Main.FEndDebitLocal FEndDebitLocal, \r\n");
            sql.append(" T_Main.FEndDebitRpt FEndDebitRpt, \r\n");
            sql.append(" T_Main.FEndCreditFor FEndCreditFor, \r\n");
            sql.append(" T_Main.FEndCreditLocal FEndCreditLocal, \r\n");
            sql.append(" T_Main.FEndCreditRpt FEndCreditRpt, \r\n");
            sql.append(" Replace(HG.FNumberGroup_l2, '!', '') FAsstAccountNumber\r\n");
            sql.append("FROM ");
            sql.append(tempTableName);
            sql.append(" AS T_Main\r\n");
            sql.append("left outer join T_BD_AccountView TA\r\n");
            sql.append("ON T_Main.FAccountID = TA.FID\r\n");
            sql.append(" and ta.fcompanyid = ? \r\n");
            sql.append(" and TA.FAccountTableId = ? \r\n");
            sql.append("LEFT OUTER JOIN t_BD_CURRENCY TC \r\n");
            sql.append("ON T_Main.FCurrencyID = TC.FID \r\n");
            sql.append("left outer join t_bd_assistanthg HG\r\n");
            sql.append("on T_Main.FAssistGrpID = HG.fid\r\n");
            sql.append("LEFT JOIN T_org_company com\r\n");
            sql.append("ON T_Main.Fcompanyid = com.FID \r\n");
            sql.append("LEFT OUTER JOIN T_BD_MEASUREUNIT MU\r\n");
            sql.append("on MU.FID = TA.FMeasureUnitID\r\n");
            sql.append(" \r\n");
            sql.append(" where T_Main.FBWType = 0\r\n");
            sql.append(" ORDER BY T_Main.FBWType,\r\n");
            sql.append("T_Main.FLineType,\r\n");
            sql.append("TA.FNumber,\r\n");
            sql.append("T_Main.FLineTypeSum, \r\n");
            sql.append("TC.FNumber,\r\n");
            sql.append("com.flongnumber, \r\n");
            sql.append("T_Main.FAccountOrAssist, \r\n");
            sql.append("HG.FNumberGroup_l2 ASC \r\n");
            PreparedStatement pstmt = null;
            ResultSet rowset = null;
            try {
                con = EJBFactory.getConnection((Context)ctx);
                pstmt = con.prepareStatement(sql.toString());
                pstmt.setObject(1, companyInfo.getId().toString());
                pstmt.setObject(2, companyInfo.getAccountTable().getId().toString());
                rowset = pstmt.executeQuery();
                while (rowset.next()) {
                    String accountNumber = rowset.getString("FAccountNumber");
                    Element accountBalaceItem = this.startElement(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"254_GLXMLGenerator", (Locale)ctx.getLocale()));
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"225_GLXMLGenerator", (Locale)ctx.getLocale()), accountNumber);
                    String asstAccountNumber = rowset.getString("FAsstAccountNumber");
                    String[] asstAccountNumbers = null;
                    if (asstAccountNumber != null) {
                        asstAccountNumbers = asstAccountNumber.split(";");
                    }
                    for (int i = 1; i <= 30; ++i) {
                        asstAccountNumber = asstAccountNumbers != null && i - 1 < asstAccountNumbers.length ? asstAccountNumbers[i - 1] : "";
                        this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"226_GLXMLGenerator", (Locale)ctx.getLocale()) + i + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"227_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventasstNumber(asstAccountNumber));
                    }
                    BigDecimal beginFor = rowset.getBigDecimal("FBeginDebitFor").subtract(rowset.getBigDecimal("FBeginCreditFor"));
                    BigDecimal beginLocal = rowset.getBigDecimal("FBeginDebitLocal").subtract(rowset.getBigDecimal("FBeginCreditLocal"));
                    String beginDirection = this.getDirection(ctx, beginFor);
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"255_GLXMLGenerator", (Locale)ctx.getLocale()), beginDirection);
                    BigDecimal endFor = rowset.getBigDecimal("FEndDebitFor").subtract(rowset.getBigDecimal("FEndCreditFor"));
                    BigDecimal endLocal = rowset.getBigDecimal("FEndDebitLocal").subtract(rowset.getBigDecimal("FEndCreditLocal"));
                    String endDirection = this.getDirection(ctx, endFor);
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"256_GLXMLGenerator", (Locale)ctx.getLocale()), endDirection);
                    String currencyNumber = rowset.getString("FCurrencyNumber");
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"210_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(currencyNumber));
                    int precision = rowset.getInt("FPrecision");
                    if (currencyNumber == null || "".equals(currencyNumber)) {
                        precision = 4;
                    }
                    precision = 2;
                    int baseCurrencyPre = companyInfo.getBaseCurrency().getPrecision();
                    baseCurrencyPre = 2;
                    String MeasureUnitName = rowset.getString("FMuName");
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"228_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(MeasureUnitName));
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"221_GLXMLGenerator", (Locale)ctx.getLocale()), String.valueOf(periodInfo.getPeriodYear()));
                    int periodNumber = periodInfo.getPeriodNumber();
                    String periodNumStr = this.getPeriodNumber(periodNumber);
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"222_GLXMLGenerator", (Locale)ctx.getLocale()), periodNumStr);
                    String beginQtyStr = null;
                    BigDecimal beginQty = rowset.getBigDecimal("FBeginQty");
                    beginQtyStr = this.bigDecimalToString(beginQty, 6);
                    String beginForStr = this.bigDecimalToString(beginFor.abs(), precision);
                    String beginLocalStr = this.bigDecimalToString(beginLocal.abs(), baseCurrencyPre);
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"257_GLXMLGenerator", (Locale)ctx.getLocale()), beginQtyStr);
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"258_GLXMLGenerator", (Locale)ctx.getLocale()), beginForStr);
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"259_GLXMLGenerator", (Locale)ctx.getLocale()), beginLocalStr);
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"229_GLXMLGenerator", (Locale)ctx.getLocale()), this.bigDecimalToString(rowset.getBigDecimal("FDebitQty"), 6));
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"230_GLXMLGenerator", (Locale)ctx.getLocale()), this.bigDecimalToString(rowset.getBigDecimal("FDebitFor"), precision));
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"231_GLXMLGenerator", (Locale)ctx.getLocale()), this.bigDecimalToString(rowset.getBigDecimal("FDebitLocal"), baseCurrencyPre));
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"232_GLXMLGenerator", (Locale)ctx.getLocale()), this.bigDecimalToString(rowset.getBigDecimal("FCreditQty"), 6));
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"233_GLXMLGenerator", (Locale)ctx.getLocale()), this.bigDecimalToString(rowset.getBigDecimal("FCreditFor"), precision));
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"234_GLXMLGenerator", (Locale)ctx.getLocale()), this.bigDecimalToString(rowset.getBigDecimal("FCreditLocal"), baseCurrencyPre));
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"260_GLXMLGenerator", (Locale)ctx.getLocale()), this.bigDecimalToString(rowset.getBigDecimal("FEndQty"), 6));
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"261_GLXMLGenerator", (Locale)ctx.getLocale()), this.bigDecimalToString(endFor.abs(), precision));
                    this.addStringElement(accountBalaceItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"262_GLXMLGenerator", (Locale)ctx.getLocale()), this.bigDecimalToString(endLocal.abs(), baseCurrencyPre));
                    partner.dropTempTable(tempTableName);
                    this.endElement();
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset, pstmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rowset, (Statement)pstmt);
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"263_GLXMLGenerator", (Locale)ctx.getLocale()), (Throwable)e);
                this.addException((Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"264_GLXMLGenerator", (Locale)ctx.getLocale()) + e.getMessage())));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(con);
                throw throwable;
            }
            SQLUtils.cleanup((Connection)con);
        }
        SQLUtils.cleanup((Connection)con);
    }

    private String conventasstNumber(String asstNumber) {
        String[] asstNumbers = asstNumber.split(":");
        if (asstNumbers != null && asstNumbers.length > 0) {
            asstNumber = asstNumbers[asstNumbers.length - 1];
            if ((asstNumbers = asstNumber.split("_")) != null && asstNumbers.length > 0) {
                return asstNumbers[0];
            }
            return asstNumber;
        }
        return asstNumber;
    }

    private String bigDecimalToString(BigDecimal balace, int precision) {
        String balaceStr = null;
        balaceStr = balace == null || balace.compareTo(this.ZERO) == 0 ? "" : balace.setScale(precision, 4).toString();
        return balaceStr;
    }

    private String bigDecimalToString(BigDecimal balace) {
        String balaceStr = null;
        balaceStr = balace == null || balace.compareTo(this.ZERO) == 0 ? "" : balace.toString();
        return balaceStr;
    }

    private String getPeriodNumber(int periodNumber) {
        String periodNumStr = null;
        if (periodNumber > 12) {
            StringBuffer sb = new StringBuffer();
            if (periodNumber - 12 < 10) {
                sb.append(12).append("0").append(periodNumber - 12);
            } else {
                sb.append(12).append(periodNumber - 12);
            }
            periodNumStr = sb.toString();
        } else {
            periodNumStr = String.valueOf(periodNumber);
        }
        return periodNumStr;
    }

    private String getDirection(Context ctx, BigDecimal balance) {
        String direction = balance.compareTo(this.ZERO) > 0 ? ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"265_GLXMLGenerator", (Locale)ctx.getLocale()) : (balance.compareTo(this.ZERO) < 0 ? ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"266_GLXMLGenerator", (Locale)ctx.getLocale()) : ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"267_GLXMLGenerator", (Locale)ctx.getLocale()));
        return direction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCashFlowItem(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select child.FType,child.FDirection,child.FISLEAF,child.FLEVEL,child.FNUMBER childNumber,child.FNAME_L2 FNAME,parent.FNUMBER parentNumber");
        sql.append(" from T_BD_CashFlowItem child left join T_BD_CashFlowItem parent on child.FParentID = parent.fid Order by child.FlongNumber ASC");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rowset = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rowset = pstmt.executeQuery();
            while (rowset.next()) {
                String cashFolwNumber = rowset.getString("childNumber");
                String cashFlowName = rowset.getString("FNAME");
                int isLeaf = rowset.getInt("FISLEAF");
                int cashFlowLevel = rowset.getInt("FLEVEL");
                String cashFlowParentNumber = rowset.getString("parentNumber");
                int cashFlowSource = rowset.getInt("FType");
                cashFlowSource = this.convertCashFlowSource(cashFlowSource);
                int cashFlowProperty = rowset.getInt("FDirection");
                cashFlowProperty = this.convertCashFlowProperty(cashFlowProperty);
                Element cashFlowItem = this.startElement(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"268_GLXMLGenerator", (Locale)ctx.getLocale()));
                this.addStringElement(cashFlowItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"213_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(cashFolwNumber));
                this.addStringElement(cashFlowItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"269_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(cashFlowName));
                this.addStringElement(cashFlowItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"270_GLXMLGenerator", (Locale)ctx.getLocale()), "");
                this.addStringElement(cashFlowItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"271_GLXMLGenerator", (Locale)ctx.getLocale()), String.valueOf(isLeaf));
                this.addStringElement(cashFlowItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"272_GLXMLGenerator", (Locale)ctx.getLocale()), String.valueOf(cashFlowLevel));
                this.addStringElement(cashFlowItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"273_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(cashFlowParentNumber));
                this.addStringElement(cashFlowItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"274_GLXMLGenerator", (Locale)ctx.getLocale()), String.valueOf(cashFlowSource));
                if (cashFlowSource == 0) {
                    this.addStringElement(cashFlowItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"214_GLXMLGenerator", (Locale)ctx.getLocale()), "");
                } else {
                    this.addStringElement(cashFlowItem, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"214_GLXMLGenerator", (Locale)ctx.getLocale()), String.valueOf(cashFlowProperty));
                }
                this.endElement();
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"275_GLXMLGenerator", (Locale)ctx.getLocale()), (Throwable)e);
                this.addException((Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"276_GLXMLGenerator", (Locale)ctx.getLocale()) + e.getMessage())));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rowset, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rowset, (Statement)pstmt, (Connection)conn);
    }

    private int convertCashFlowProperty(int cashFlowProperty) {
        if (cashFlowProperty == 2) {
            cashFlowProperty = 0;
        } else if (cashFlowProperty == 0) {
            cashFlowProperty = 2;
        }
        return cashFlowProperty;
    }

    private int convertCashFlowSource(int cashFlowSource) {
        if (cashFlowSource == 0) {
            cashFlowSource = 1;
        } else if (cashFlowSource == 1) {
            cashFlowSource = 0;
        } else if (cashFlowSource == 2) {
            cashFlowSource = 0;
        }
        return cashFlowSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAsstAccount(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) {
        ResultSet rowset;
        PreparedStatement pstmt;
        Connection conn;
        block12: {
            StringBuffer sql = new StringBuffer();
            sql.append(" select account.FNumber FAccountShortNumber,account.fLongNumber FAccountNumber, ");
            sql.append(" assttype.fname_l2 FAsstTypeName,assttype.FNUMBER FAsstTypeNumber,assttype.FDESCRIPTION_L2 FDESCRIPTION");
            sql.append("  from T_BD_AsstActType assttype inner join T_BD_AsstActGroupDetail asstde on asstde.FAsstActTypeID = assttype.fid");
            sql.append("  inner join T_BD_AsstAccount asst on asstde.FASSTACCOUNTID = asst.fid");
            sql.append("  inner join t_bd_accountview account on account.FCAA = asst.fid");
            sql.append(" where account.FCOMPANYID = ? ");
            sql.append(" and account.faccounttableid = ? ");
            sql.append(" and account.FCAA = asst.fid ");
            sql.append(" order by account.fnumber,asstde.fseq,assttype.FNumber ");
            conn = null;
            pstmt = null;
            rowset = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setObject(1, companyInfo.getId().toString());
                pstmt.setObject(2, companyInfo.getAccountTable().getId().toString());
                rowset = pstmt.executeQuery();
                ArrayList asstAccountList = new ArrayList();
                HashSet<String> accountNumberSet = new HashSet<String>();
                while (rowset.next()) {
                    HashMap<String, String> asstAccountMap = new HashMap<String, String>();
                    String accoutShortNumber = rowset.getString("FAccountShortNumber");
                    String accountNumber = rowset.getString("FAccountNumber");
                    String asstTypeName = rowset.getString("FAsstTypeName");
                    String asstTypeNumber = rowset.getString("FAsstTypeNumber");
                    String descrption = rowset.getString("FDESCRIPTION");
                    asstAccountMap.put("accoutShortNumber", accoutShortNumber);
                    asstAccountMap.put("accountNumber", accountNumber);
                    asstAccountMap.put("asstTypeName", asstTypeName);
                    asstAccountMap.put("asstTypeNumber", asstTypeNumber);
                    asstAccountMap.put("descrption", descrption);
                    asstAccountList.add(asstAccountMap);
                    accountNumberSet.add(accountNumber);
                }
                if (accountNumberSet.size() <= 0) break block12;
                ArrayList accountNumberList = new ArrayList(accountNumberSet);
                Collections.sort(accountNumberList);
                Iterator it = accountNumberList.iterator();
                while (it.hasNext()) {
                    Element asstAccount = this.startElement(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"277_GLXMLGenerator", (Locale)ctx.getLocale()));
                    String accoutNumber = (String)it.next();
                    StringBuffer asstNumber = new StringBuffer();
                    StringBuffer asstName = new StringBuffer();
                    StringBuffer asstDescrption = new StringBuffer();
                    String accoutShortNumber = null;
                    for (int i = 0; i < asstAccountList.size(); ++i) {
                        Map asstAccountMap = (Map)asstAccountList.get(i);
                        if (!accoutNumber.equals((String)asstAccountMap.get("accountNumber"))) continue;
                        accoutShortNumber = (String)asstAccountMap.get("accoutShortNumber");
                        if (asstName.length() != 0) {
                            asstName.append("/");
                        }
                        if (!GlUtils.isEmpty(asstAccountMap.get("asstTypeName"))) {
                            asstName.append(asstAccountMap.get("asstTypeName"));
                        }
                        if (asstNumber.length() != 0) {
                            asstNumber.append("/");
                        }
                        if (!GlUtils.isEmpty(asstAccountMap.get("asstTypeNumber"))) {
                            asstNumber.append(asstAccountMap.get("asstTypeNumber"));
                        }
                        if (asstDescrption.length() != 0) {
                            asstDescrption.append("/");
                        }
                        if (GlUtils.isEmpty(asstAccountMap.get("descrption"))) continue;
                        asstDescrption.append(asstAccountMap.get("descrption"));
                    }
                    this.addStringElement(asstAccount, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"225_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(accoutShortNumber));
                    this.addStringElement(asstAccount, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"278_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(asstNumber.toString()));
                    this.addStringElement(asstAccount, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"279_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(asstName.toString()));
                    this.addStringElement(asstAccount, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"280_GLXMLGenerator", (Locale)ctx.getLocale()), "");
                    this.addStringElement(asstAccount, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"281_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(asstDescrption.toString()));
                    this.endElement();
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e);
                    logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"282_GLXMLGenerator", (Locale)ctx.getLocale()), (Throwable)e);
                    this.addException((Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"283_GLXMLGenerator", (Locale)ctx.getLocale()) + e.getMessage())));
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rowset, pstmt, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rowset, (Statement)pstmt, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rowset, (Statement)pstmt, (Connection)conn);
    }

    private String conventNullString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAccount(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t_bd_accountview.fnumber FAccountNumber, ");
        sql.append(" t_bd_accountview.fname_l2 FAccountName, ");
        sql.append(" t_bd_accountview.flevel FAccountLevel, ");
        sql.append(" t_bd_accounttype.fname_l2 FAccountTypeName, ");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"284_GLXMLGenerator", (Locale)ctx.getLocale()));
        sql.append("  from t_bd_accountview left outer join t_bd_accounttype on t_bd_accountview.FACCOUNTTYPEID = t_bd_accounttype.FID ");
        sql.append(" where t_bd_accountview.FCOMPANYID = ? ");
        sql.append(" and t_bd_accountview.faccounttableid = ? ");
        sql.append(" order by t_bd_accountview.fnumber ");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rowset = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setObject(1, companyInfo.getId().toString());
            pstmt.setObject(2, companyInfo.getAccountTable().getId().toString());
            rowset = pstmt.executeQuery();
            while (rowset.next()) {
                String accountNumber = rowset.getString("FAccountNumber");
                String accountName = rowset.getString("FAccountName");
                String accountLevel = rowset.getString("FAccountLevel");
                String accountTypeName = rowset.getString("FAccountTypeName");
                String accountDC = rowset.getString("FAccountDC");
                Element account = this.startElement(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"285_GLXMLGenerator", (Locale)ctx.getLocale()));
                this.addStringElement(account, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"225_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(accountNumber));
                this.addStringElement(account, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"286_GLXMLGenerator", (Locale)ctx.getLocale()), accountName);
                this.addStringElement(account, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"287_GLXMLGenerator", (Locale)ctx.getLocale()), accountLevel);
                this.addStringElement(account, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"288_GLXMLGenerator", (Locale)ctx.getLocale()), accountTypeName);
                this.addStringElement(account, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"289_GLXMLGenerator", (Locale)ctx.getLocale()), accountDC);
                this.endElement();
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"290_GLXMLGenerator", (Locale)ctx.getLocale()), (Throwable)e);
                this.addException((Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"291_GLXMLGenerator", (Locale)ctx.getLocale()) + e.getMessage())));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rowset, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rowset, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateBaseInfo(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append("select FIsUseSeparator,FSEPARATOR from t_BD_accounttable where fid = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rowset = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setObject(1, companyInfo.getAccountTable().getId().toString());
            rowset = pstmt.executeQuery();
            Element baseInfo = this.startElement(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"292_GLXMLGenerator", (Locale)ctx.getLocale()));
            String separator = "";
            boolean isUseSeparator = false;
            while (rowset.next()) {
                separator = rowset.getString("FSEPARATOR");
                isUseSeparator = rowset.getBoolean("FIsUseSeparator");
            }
            rowset.close();
            pstmt.close();
            if (!isUseSeparator) {
                separator = "";
            }
            this.addStringElement(baseInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"293_GLXMLGenerator", (Locale)ctx.getLocale()), this.conventNullString(separator));
            sql = new StringBuffer();
            sql.append("select flength from T_BD_AccountLev where faccounttableid = ? Order by flevel");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setObject(1, companyInfo.getAccountTable().getId().toString());
            rowset = pstmt.executeQuery();
            StringBuffer codeRule = new StringBuffer();
            while (rowset.next()) {
                int length = rowset.getInt("flength");
                codeRule.append(length);
                codeRule.append("-");
            }
            rowset.close();
            if (codeRule.length() > 0) {
                codeRule.deleteCharAt(codeRule.length() - 1);
            }
            this.addStringElement(baseInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"294_GLXMLGenerator", (Locale)ctx.getLocale()), codeRule.toString());
            this.addStringElement(baseInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"295_GLXMLGenerator", (Locale)ctx.getLocale()), "");
            this.addStringElement(baseInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"296_GLXMLGenerator", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"297_GLXMLGenerator", (Locale)ctx.getLocale()));
            this.addStringElement(baseInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"298_GLXMLGenerator", (Locale)ctx.getLocale()), "");
            this.addStringElement(baseInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"299_GLXMLGenerator", (Locale)ctx.getLocale()), "");
            this.addStringElement(baseInfo, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"300_GLXMLGenerator", (Locale)ctx.getLocale()), "");
            this.endElement();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"301_GLXMLGenerator", (Locale)ctx.getLocale()), (Throwable)e);
                this.addException((Exception)((Object)new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"302_GLXMLGenerator", (Locale)ctx.getLocale()) + e.getMessage())));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rowset, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rowset, (Statement)pstmt, (Connection)conn);
    }

    public String getTypeName(Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"303_GLXMLGenerator", (Locale)ctx.getLocale());
    }

    protected String getTempTableStruct(ReportPartner partner) {
        StringBuffer sql = new StringBuffer();
        sql.append(" (FAccountID VARCHAR(44),\r\n");
        sql.append("  FCurrencyID VARCHAR(44),\r\n");
        sql.append("  FCurrencyName VARCHAR(44),\r\n");
        sql.append("  FCompanyID VARCHAR(44),\r\n");
        sql.append("  FYearBeginDebitFor DECIMAL(28,10),FYearBeginCreditFor DECIMAL(28,10),\r\n");
        sql.append("  FBeginDebitFor DECIMAL(28,10),FBeginCreditFor DECIMAL(28,10),\r\n");
        sql.append("  FDebitFor DECIMAL(28,10),FCreditFor DECIMAL(28,10), \r\n");
        sql.append("  FYearDebitFor DECIMAL(28,10),FYearCreditFor DECIMAL(28,10),\r\n");
        sql.append("  FEndDebitFor DECIMAL(28,10),FEndCreditFor DECIMAL(28,10),\r\n");
        sql.append("  FYearBeginDebitLocal DECIMAL(28,10),FYearBeginCreditLocal DECIMAL(28,10),\r\n");
        sql.append("  FBeginDebitLocal DECIMAL(28,10),FBeginCreditLocal DECIMAL(28,10),\r\n");
        sql.append("  FDebitLocal DECIMAL(28,10),FCreditLocal DECIMAL(28,10), \r\n");
        sql.append("  FYearDebitLocal DECIMAL(28,10),FYearCreditLocal DECIMAL(28,10),\r\n");
        sql.append("  FEndDebitLocal DECIMAL(28,10),FEndCreditLocal DECIMAL(28,10),\r\n");
        sql.append("  FYearBeginDebitRpt DECIMAL(28,10), FYearBeginCreditRpt DECIMAL(28,10),\r\n");
        sql.append("  FBeginDebitRpt DECIMAL(28,10), FBeginCreditRpt DECIMAL(28,10),\r\n");
        sql.append("  FDebitRpt DECIMAL(28,10),FCreditRpt DECIMAL(28,10), \r\n");
        sql.append("  FYearDebitRpt DECIMAL(28,10),FYearCreditRpt DECIMAL(28,10),\r\n");
        sql.append("  FEndDebitRpt DECIMAL(28,10),FEndCreditRpt DECIMAL(28,10),\r\n");
        sql.append("  FYearBeginQty DECIMAL(28,10), \r\n");
        sql.append("  FBeginQty DECIMAL(28,10), \r\n");
        sql.append("  FYearDebitQty DECIMAL(28,10), \r\n");
        sql.append("  FYearCreditQty DECIMAL(28,10), \r\n");
        sql.append("  FDebitQty DECIMAL(28,10), \r\n");
        sql.append("  FCreditQty DECIMAL(28,10), \r\n");
        sql.append("  FEndQty DECIMAL(28,10), \r\n");
        sql.append("  FLineTypeSum VARCHAR(44) , \r\n");
        sql.append("  FLineType Int , \r\n");
        sql.append("  FAccountOrAssist Int, \r\n");
        sql.append("  FCount Int, \r\n");
        sql.append("  FAssistGrpID VARCHAR(44) ,\r\n");
        sql.append("  FBWType Int )\r\n");
        return sql.toString();
    }

    private void addInsertSqlForCurrency(StringBuffer sql, String currencyFlag, boolean balanceDirSamAsAccount, boolean isAfterPeriod) {
        sql.append("0.0 FYearBeginDebit" + currencyFlag + ",\t\t\r\n");
        sql.append("0.0 FYearBeginCredit" + currencyFlag + ",\t\r\n");
        sql.append(" SUM(CASE WHEN TB.FIsStartPeriod = 1 ");
        if (balanceDirSamAsAccount) {
            sql.append(" AND TA.FDC = ").append(1);
        } else {
            sql.append(" AND TB.FBeginBalance" + currencyFlag + " > 0 ");
        }
        sql.append(" THEN TB.FBeginBalance" + currencyFlag + " ELSE 0.0 END) FBeginDebit" + currencyFlag + ",      \r\n");
        sql.append(" SUM(CASE WHEN TB.FIsStartPeriod = 1 ");
        if (balanceDirSamAsAccount) {
            sql.append(" AND TA.FDC = ").append(-1);
        } else {
            sql.append(" AND TB.FBeginBalance" + currencyFlag + " < 0 ");
        }
        sql.append(" THEN -1 * TB.FBeginBalance" + currencyFlag + " ELSE 0.0 END) FBeginCredit" + currencyFlag + ",\t\r\n");
        sql.append(" SUM(TB.FDebit" + currencyFlag + ") FDebit" + currencyFlag + ",\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" SUM(TB.FCredit" + currencyFlag + ") FCredit" + currencyFlag + ",\t\t\t\t\t\t\t\t\r\n");
        for (int i = 0; i < 2; ++i) {
            String f = (i == 0 ? "Debit" : "Credit") + currencyFlag;
            if (isAfterPeriod) {
                sql.append("sum( case when TB.FIsEndPeriod=1 then TB.FYear" + f).append(" else 0.0 end) FYear" + f + ",\n");
                continue;
            }
            sql.append("sum( case when TB.FIsAfterCurrentPeriod=1 then TB.F" + f).append(" when TB.FEndPeriodNoAfterCurrent=1 and TB.FIsEndPeriod=1 then TB.FYear" + f).append(" when TB.FIsOverCurrentYear=0 and TB.FIsCurrentPeriod=1 then TB.FYear" + f).append(" else 0.0 end) FYear" + f + ",\n");
        }
        if (isAfterPeriod) {
            sql.append(" SUM(CASE WHEN  TB.FIsEndPeriod=1 ");
        } else {
            sql.append(" SUM(CASE WHEN  (TB.FIsCurrentPeriod = 1 or (TB.FEndPeriodNoAfterCurrent=1 and TB.FIsEndPeriod=1) ) ");
        }
        if (balanceDirSamAsAccount) {
            sql.append("  and TA.FDC= ").append(1);
        } else {
            sql.append(" and TB.FEndBalance" + currencyFlag + ">0");
        }
        sql.append(" THEN TB.FEndBalance" + currencyFlag);
        if (!isAfterPeriod) {
            sql.append(" when TB.FIsAfterCurrentPeriod=1 ");
            if (balanceDirSamAsAccount) {
                sql.append("  and TA.FDC= ").append(1);
            } else {
                sql.append(" and TB.FDebit" + currencyFlag + "-TB.FCredit" + currencyFlag + ">0");
            }
            sql.append(" then TB.FDebit" + currencyFlag + "-TB.FCredit" + currencyFlag);
        }
        sql.append(" ELSE 0.0 END) FEndDebit" + currencyFlag + ",      \t\t\t\t\t\t\t\t\t\t\t\r\n");
        if (isAfterPeriod) {
            sql.append(" SUM(CASE WHEN TB.FIsEndPeriod=1 ");
        } else {
            sql.append(" SUM(CASE WHEN (TB.FIsCurrentPeriod = 1 or (TB.FEndPeriodNoAfterCurrent=1 and TB.FIsEndPeriod=1) ) ");
        }
        if (balanceDirSamAsAccount) {
            sql.append("  and TA.FDC= ").append(-1);
        } else {
            sql.append(" and TB.FEndBalance" + currencyFlag + "<0");
        }
        sql.append(" THEN -1*TB.FEndBalance" + currencyFlag);
        if (!isAfterPeriod) {
            sql.append(" when TB.FIsAfterCurrentPeriod=1");
            if (balanceDirSamAsAccount) {
                sql.append("  and TA.FDC= ").append(-1);
            } else {
                sql.append(" and TB.FCredit" + currencyFlag + "-TB.FDebit" + currencyFlag + ">0");
            }
            sql.append(" then TB.FCredit" + currencyFlag + "-TB.FDebit" + currencyFlag);
        }
        sql.append(" ELSE 0.0 END) FEndCredit" + currencyFlag + ",\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
    }

    private void addInsertSqlForYearQty(StringBuffer sql, boolean balanceDirSamAsAccount, boolean isAfterPeriod) {
        for (int i = 0; i < 2; ++i) {
            String f = (i == 0 ? "Debit" : "Credit") + "Qty";
            if (isAfterPeriod) {
                sql.append("sum( case when TA.FIsQty = 0  then 0 when TB.FIsEndPeriod=1 then TB.FYear" + f);
                sql.append(" else 0.0 end) FYear" + f + ",\n");
                continue;
            }
            sql.append("sum( case when TA.FIsQty = 0 then 0 else case when TA.FIsQty = 0 then 0 else case when TB.FIsAfterCurrentPeriod=1 then TB.F" + f);
            sql.append(" when TB.FEndPeriodNoAfterCurrent=1 and TB.FIsEndPeriod=1 then TB.FYear" + f);
            sql.append(" when TB.FIsOverCurrentYear=0 and TB.FIsCurrentPeriod=1 then TB.FYear" + f);
            sql.append(" else 0.0 end end end) FYear" + f + ",\n");
        }
    }

    private void addInsertSqlForEndQty(StringBuffer sql, boolean balanceDirSamAsAccount, boolean isAfterPeriod) {
        String qty = "Qty";
        if (isAfterPeriod) {
            sql.append(" SUM(case when TA.FIsQty = 0  then 0 WHEN TB.FIsEndPeriod=1 THEN TB.FEnd" + qty);
            sql.append(" ELSE 0.0 END) FEnd" + qty + ",\n");
        } else {
            sql.append(" SUM(case when TA.FIsQty = 0 then 0 else case when TA.FIsQty = 0  then 0 else case when TA.FIsQty = 0  then 0 else CASE WHEN  (TB.FIsCurrentPeriod = 1 or (TB.FEndPeriodNoAfterCurrent=1 and TB.FIsEndPeriod=1) ) ");
            sql.append(" THEN TB.FEnd" + qty);
            sql.append(" WHEN TB.FIsAfterCurrentPeriod=1 ");
            sql.append(" THEN TB.FDebit" + qty + "-TB.FCredit" + qty + " \r\n");
            sql.append(" ELSE 0.0 END end end end) FEnd" + qty + ",\n");
        }
    }

    public String getTypeName() {
        return null;
    }
}

