/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GetAccountService {
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLNResource";
    protected Map params = null;
    protected HashMap<String, Object> result = null;
    protected List<String> errs = null;
    protected List rows = null;

    public Map getAccounts(Context ctx, Map params) throws EASBizException, BOSException {
        int pn;
        CompanyOrgUnitInfo company;
        block9: {
            PeriodInfo current;
            this.init(ctx, params);
            if (!this.checkUsePermission(ctx, params)) {
                return this.result;
            }
            String companyNumber = (String)params.get("companyNumber");
            if (companyNumber == null || companyNumber.trim().length() == 0) {
                this.appendErr("companyNumber", "", ResourceBase.getString((String)RESOURCE, (String)"needCompanyNumber_foundNull", (Locale)ctx.getLocale()));
                return this.result;
            }
            company = this.getCompany(ctx, companyNumber = companyNumber.trim());
            if (company == null) {
                this.appendErr("companyNumber", companyNumber, ResourceBase.getString((String)RESOURCE, (String)"companyNotFound", (Locale)ctx.getLocale()));
                return this.result;
            }
            if (company.getAccountTable() == null) {
                this.appendErr("companyNumber", companyNumber, ResourceBase.getString((String)RESOURCE, (String)"noSetAccountTable", (Locale)ctx.getLocale()));
                return this.result;
            }
            pn = 0;
            if (company.isIsBizUnit() && (current = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(company.getId()))) != null) {
                String periodNumber = (String)params.get("periodNumber");
                if (periodNumber != null && periodNumber.trim().length() > 0) {
                    periodNumber = periodNumber.trim();
                    try {
                        pn = Integer.parseInt(periodNumber);
                        if (pn <= 198000 || pn > 209913) {
                            this.appendErr("periodNumber", periodNumber, ResourceBase.getString((String)RESOURCE, (String)"periodSetError", (Locale)ctx.getLocale()));
                            return this.result;
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        this.appendErr("periodNumber", periodNumber, ResourceBase.getString((String)RESOURCE, (String)"periodSetError", (Locale)ctx.getLocale()));
                        return this.result;
                    }
                }
                pn = current.getNumber();
            }
        }
        String number = (String)params.get("accountNumber");
        Set<String> numbers = this.getParamStrings(number);
        this.doGetAccounts(ctx, company, numbers, pn);
        return this.result;
    }

    protected boolean checkUsePermission(Context ctx, Map params) throws EASBizException, BOSException {
        boolean isInterfaceInvoke = (Boolean)params.get("isInterfaceInvoke");
        if (isInterfaceInvoke) {
            boolean r;
            boolean isCheckUsePerm = false;
            try {
                Object p = VoucherProcessCache.getParam(ctx, null, "GL_IfcUsePerm_Enable");
                if (p != null && Boolean.valueOf(p.toString()).booleanValue()) {
                    isCheckUsePerm = true;
                }
            }
            catch (Exception p) {
                // empty catch block
            }
            if (isCheckUsePerm && !(r = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), null, "gl_ifc_baseData"))) {
                this.appendErr("", "", MessageFormat.format(ResourceBase.getString((String)RESOURCE, (String)"NO_IfcBaseData_UsePerm", (Locale)ctx.getLocale()), ContextUtil.getCurrentUserInfo((Context)ctx).getNumber()));
                return false;
            }
        }
        return true;
    }

    protected void appendErr(String key, String val, String msg) {
        this.errs.add(key + "[" + val + "]:" + msg);
    }

    public void init(Context ctx, Map params) throws EASBizException, BOSException {
        this.params = params;
        this.result = new HashMap();
        this.errs = new ArrayList<String>();
        this.rows = new LinkedList();
        this.result.put("errs", this.errs);
        this.result.put("rows", this.rows);
    }

    protected Set<String> getParamStrings(Object param) {
        HashSet<String> result;
        block2: {
            String[] strs;
            block3: {
                result = new HashSet<String>();
                if (param == null) break block2;
                if (!(param instanceof Collection)) break block3;
                for (Object item : (Collection)param) {
                    if (item == null || item.toString().trim().length() <= 0) continue;
                    result.add(item.toString().trim());
                }
                break block2;
            }
            if (!(param instanceof String)) break block2;
            for (String str : strs = ((String)param).trim().split(";")) {
                if (str.trim().length() <= 0) continue;
                result.add(str.trim());
            }
        }
        return result;
    }

    protected CompanyOrgUnitInfo getCompany(Context ctx, String companyNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isBizUnit");
        selector.add("accountTable.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber));
        view.setFilter(filter);
        CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        if (companys != null && companys.size() > 0) {
            return companys.get(0);
        }
        return null;
    }

    protected void doGetAccounts(Context ctx, CompanyOrgUnitInfo company, Set<String> numbers, int periodNumber) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("helpCode"));
        sic.add(new SelectorItemInfo("CAA.id"));
        sic.add(new SelectorItemInfo("CAA.number"));
        sic.add(new SelectorItemInfo("CAA.name"));
        sic.add(new SelectorItemInfo("accountTypeID.id"));
        sic.add(new SelectorItemInfo("accountTypeID.number"));
        sic.add(new SelectorItemInfo("accountTypeID.name"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("AC"));
        sic.add(new SelectorItemInfo("ACNotice"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("isCashEquivalent"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("accrualDirection"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("bw"));
        sic.add(new SelectorItemInfo("isControl"));
        sic.add(new SelectorItemInfo("isChangeCurrency"));
        sic.add(new SelectorItemInfo("isBizChangeCurrency"));
        sic.add(new SelectorItemInfo("isCFreeze"));
        sic.add(new SelectorItemInfo("PLType"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        if (numbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("longNumber"));
        AccountViewCollection accounts = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        Map caas = null;
        if (company.isIsBizUnit() && periodNumber > 0) {
            HashSet<String> accountIds = new HashSet<String>();
            for (int i = 0; i < accounts.size(); ++i) {
                AccountViewInfo account = accounts.get(i);
                if (!account.isIsLeaf()) continue;
                accountIds.add(account.getId().toString());
            }
            if (accountIds.size() > 0) {
                caas = AccountFacadeFactory.getLocalInstance((Context)ctx).getCAAsByPeriod(accountIds, periodNumber);
            }
        }
        for (int i = 0; i < accounts.size(); ++i) {
            AccountTypeInfo accountType;
            AccountViewInfo account = accounts.get(i);
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", account.getId().toString());
            row.put("number", account.getNumber());
            row.put("name", account.getName());
            String longNumber = account.getLongNumber();
            if (longNumber != null) {
                longNumber = longNumber.replace('!', '.');
            }
            row.put("longNumber", longNumber);
            row.put("isLeaf", String.valueOf(account.isIsLeaf()));
            row.put("level", String.valueOf(account.getLevel()));
            row.put("helpCode", account.getHelpCode());
            AsstAccountInfo aa = account.getCAA();
            if (caas != null && caas.containsKey(account.getId().toString())) {
                aa = (AsstAccountInfo)caas.get(account.getId().toString());
            }
            if (aa != null) {
                row.put("CAA.id", aa.getId().toString());
                row.put("CAA.number", aa.getNumber());
                row.put("CAA.name", aa.getName());
            }
            if ((accountType = account.getAccountTypeID()) != null) {
                row.put("accountTypeID.id", accountType.getId().toString());
                row.put("accountTypeID.number", accountType.getNumber());
                row.put("accountTypeID.name", accountType.getName());
                row.put("accountTypeID.property", String.valueOf(accountType.getProperty().getValue()));
            }
            row.put("isQty", String.valueOf(account.isIsQty()));
            row.put("AC", String.valueOf(account.isAC()));
            row.put("ACNotice", String.valueOf(account.isACNotice()));
            row.put("isBank", String.valueOf(account.isIsBank()));
            row.put("isCash", String.valueOf(account.isIsCash()));
            row.put("isCashEquivalent", String.valueOf(account.isIsCashEquivalent()));
            row.put("DC", String.valueOf(account.getDC().getValue()));
            row.put("accrualDirection", String.valueOf(account.getAccrualDirection().getValue()));
            row.put("hasUserProperty", String.valueOf(account.isHasUserProperty()));
            row.put("bw", String.valueOf(account.isBw()));
            row.put("isControl", String.valueOf(account.isIsControl()));
            row.put("isChangeCurrency", String.valueOf(account.isIsChangeCurrency()));
            row.put("isBizChangeCurrency", String.valueOf(account.isIsBizChangeCurrency()));
            row.put("isCFreeze", String.valueOf(account.isIsCFreeze()));
            row.put("PLType", String.valueOf(account.getPLType().getValue()));
            row.put("accountingcurrency", String.valueOf(account.getAccountingcurrency().getValue()));
            this.rows.add(row);
        }
    }
}

