/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountCussentCollection;
import com.kingdee.eas.basedata.assistant.AccountCussentFactory;
import com.kingdee.eas.basedata.assistant.AccountCussentInfo;
import com.kingdee.eas.basedata.assistant.AreaCollection;
import com.kingdee.eas.basedata.assistant.AreaFactory;
import com.kingdee.eas.basedata.assistant.AreaInfo;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CityCollection;
import com.kingdee.eas.basedata.assistant.CityFactory;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CountryCollection;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ProjectCollection;
import com.kingdee.eas.basedata.assistant.ProjectFactory;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.assistant.ProvinceCollection;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.assistant.RegionCollection;
import com.kingdee.eas.basedata.assistant.RegionFactory;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AuxAccountUtils;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.ShareTacticEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitExtInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FeeTypeCollection;
import com.kingdee.eas.fi.cas.FeeTypeFactory;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fi.gl.RunningBusinessMethod;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GetAsstActService {
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLNResource";
    private final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private final DateFormat DF2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final DateFormat DF3 = new SimpleDateFormat("yyyy-MM-dd");
    protected Map<String, FilterInfo> gFilters = new HashMap<String, FilterInfo>();
    protected Map<String, EntityObjectInfo> entityObjects = null;
    protected Map<String, Object> gl043s = new HashMap<String, Object>();
    protected Map<String, Object> gl069s = new HashMap<String, Object>();
    private Map<String, Set<String>> relationss = new HashMap<String, Set<String>>();
    private Map<String, Map> authOrgss = new HashMap<String, Map>();
    private Map<String, Set<String>> permOrgss = new HashMap<String, Set<String>>();
    protected Map params = null;
    protected HashMap<String, Object> result = null;
    protected List<String> errs = null;
    protected List rows = null;
    protected boolean isOnlyLeaf = true;

    public Map getAsstActs(Context ctx, Map params) throws EASBizException, BOSException {
        this.init(ctx, params);
        if (!this.checkUsePermission(ctx, params)) {
            return this.result;
        }
        String asstActTypeNumber = (String)params.get("asstActTypeNumber");
        if (asstActTypeNumber == null || asstActTypeNumber.trim().length() == 0) {
            this.appendErr("asstActTypeNumber", "", ResourceBase.getString((String)RESOURCE, (String)"NeedAATNumber_FoundEmpty", (Locale)ctx.getLocale()));
            return this.result;
        }
        AsstActTypeInfo asstActType = this.getAsstActType(ctx, asstActTypeNumber = asstActTypeNumber.trim());
        if (asstActType == null) {
            this.appendErr("asstActTypeNumber", asstActTypeNumber, ResourceBase.getString((String)RESOURCE, (String)"AAT_NotFound", (Locale)ctx.getLocale()));
            return this.result;
        }
        String asstActNumber = (String)params.get("asstActNumber");
        Set<String> asstActNumbers = this.getParamStrings(asstActNumber);
        CompanyOrgUnitInfo company = null;
        CtrlUnitInfo cu = null;
        String companyNumber = (String)params.get("companyNumber");
        if (companyNumber != null && companyNumber.trim().length() > 0) {
            company = this.getCompany(ctx, companyNumber = companyNumber.trim());
            if (company == null) {
                this.appendErr("companyNumber", companyNumber, ResourceBase.getString((String)RESOURCE, (String)"companyNotFound", (Locale)ctx.getLocale()));
                return this.result;
            }
            cu = company.getCU();
        }
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
            cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        }
        String cuId = cu.getId().toString();
        UserInfo user = null;
        String userNumber = (String)params.get("user");
        if (userNumber != null && userNumber.trim().length() > 0 && (user = GetAsstActService.getUser(ctx, userNumber = userNumber.trim())) == null) {
            this.appendErr("user", userNumber, ResourceBase.getString((String)RESOURCE, (String)"User_NotFound", (Locale)ctx.getLocale()));
            return this.result;
        }
        if (user == null) {
            user = ContextUtil.getCurrentUserInfo((Context)ctx);
        }
        String userId = user.getId().toString();
        String onlyLeaf = (String)params.get("onlyLeaf");
        if (onlyLeaf != null && onlyLeaf.trim().equalsIgnoreCase("false")) {
            this.isOnlyLeaf = false;
        }
        String asstHGAttribute = asstActType.getAsstHGAttribute();
        try {
            if ("material".equalsIgnoreCase(asstHGAttribute)) {
                this.findMaterial(ctx, params, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("customer".equalsIgnoreCase(asstHGAttribute)) {
                this.findCustomer(ctx, params, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("provider".equalsIgnoreCase(asstHGAttribute)) {
                this.findProvider(ctx, params, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("project".equalsIgnoreCase(asstHGAttribute)) {
                this.findProject(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("bankAccount".equalsIgnoreCase(asstHGAttribute)) {
                this.findBankAccount(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("industry".equalsIgnoreCase(asstHGAttribute)) {
                this.findIndustry(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("region".equalsIgnoreCase(asstHGAttribute)) {
                this.findRegion(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("cashFlowItem".equalsIgnoreCase(asstHGAttribute)) {
                this.findCashFlowItem(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("country".equalsIgnoreCase(asstHGAttribute)) {
                this.findCountry(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("province".equalsIgnoreCase(asstHGAttribute)) {
                this.findProvince(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("city".equalsIgnoreCase(asstHGAttribute)) {
                this.findCity(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("accountCussent".equalsIgnoreCase(asstHGAttribute)) {
                this.findAccountCussent(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("costObject".equalsIgnoreCase(asstHGAttribute)) {
                this.findCostObject(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("adminOrg".equalsIgnoreCase(asstHGAttribute)) {
                this.findAdminOrg(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("saleOrg".equalsIgnoreCase(asstHGAttribute) || "profitOrg".equalsIgnoreCase(asstHGAttribute) || "purchaseOrg".equalsIgnoreCase(asstHGAttribute) || "storeageOrg".equalsIgnoreCase(asstHGAttribute) || "companyOrg".equalsIgnoreCase(asstHGAttribute) || "costOrg".equalsIgnoreCase(asstHGAttribute)) {
                this.findOrg(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("person".equalsIgnoreCase(asstHGAttribute)) {
                this.findPerson(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if (asstHGAttribute.startsWith("generalAssActType")) {
                this.findGeneral(ctx, params, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("innerAccount".equalsIgnoreCase(asstHGAttribute)) {
                this.findInnerAccount(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("fpItem".equalsIgnoreCase(asstHGAttribute)) {
                this.findFpItem(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("ntType".equalsIgnoreCase(asstHGAttribute)) {
                this.findNtType(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("feeType".equalsIgnoreCase(asstHGAttribute)) {
                this.findFeeType(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("costItem".equalsIgnoreCase(asstHGAttribute)) {
                this.findCostItem(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("nation".equalsIgnoreCase(asstHGAttribute)) {
                this.findNation(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("area".equalsIgnoreCase(asstHGAttribute)) {
                this.findArea(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else if ("village".equalsIgnoreCase(asstHGAttribute)) {
                this.findVillage(ctx, asstActType, asstActNumbers, company, cuId, userId);
            } else {
                this.findOther(ctx, asstActType, asstActNumbers, company, cuId, userId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return this.result;
    }

    protected boolean checkUsePermission(Context ctx, Map params) throws EASBizException, BOSException {
        boolean isInterfaceInvoke = (Boolean)params.get("isInterfaceInvoke");
        if (isInterfaceInvoke) {
            boolean r;
            boolean isCheckUsePerm = false;
            try {
                Object p = VoucherProcessCache.getParam(ctx, null, "GL_IfcUsePerm_Enable");
                if (p != null && Boolean.valueOf(p.toString()).booleanValue()) {
                    isCheckUsePerm = true;
                }
            }
            catch (Exception p) {
                // empty catch block
            }
            if (isCheckUsePerm && !(r = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), null, "gl_ifc_baseData"))) {
                this.appendErr("", "", MessageFormat.format(ResourceBase.getString((String)RESOURCE, (String)"NO_IfcBaseData_UsePerm", (Locale)ctx.getLocale()), ContextUtil.getCurrentUserInfo((Context)ctx).getNumber()));
                return false;
            }
        }
        return true;
    }

    protected void appendErr(String key, String val, String msg) {
        this.errs.add(key + "[" + val + "]:" + msg);
    }

    public void init(Context ctx, Map params) throws EASBizException, BOSException {
        this.params = params;
        this.result = new HashMap();
        this.errs = new ArrayList<String>();
        this.rows = new LinkedList();
        this.result.put("errs", this.errs);
        this.result.put("rows", this.rows);
    }

    protected Set<String> getParamStrings(Object param) {
        HashSet<String> result;
        block2: {
            String[] strs;
            block3: {
                result = new HashSet<String>();
                if (param == null) break block2;
                if (!(param instanceof Collection)) break block3;
                for (Object item : (Collection)param) {
                    if (item == null || item.toString().trim().length() <= 0) continue;
                    result.add(item.toString().trim());
                }
                break block2;
            }
            if (!(param instanceof String)) break block2;
            for (String str : strs = ((String)param).trim().split(";")) {
                if (str.trim().length() <= 0) continue;
                result.add(str.trim());
            }
        }
        return result;
    }

    protected AsstActTypeInfo getAsstActType(Context ctx, String numberOrName) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("asstHGAttribute");
        selector.add("realtionDataObject");
        selector.add("mappingFieldName");
        selector.add("groupTableName");
        selector.add("isMultilevel");
        selector.add("useLongNumber");
        selector.add("glAsstActTypeGrp.*");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberOrName));
        AsstActTypeInfo type = null;
        AsstActTypeCollection coll = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
        if (coll.size() > 0) {
            type = coll.get(0);
        } else {
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)numberOrName));
            coll = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
            if (coll.size() > 0) {
                type = coll.get(0);
            } else {
                filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("asstHGAttribute", (Object)numberOrName));
                coll = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
                if (coll.size() > 0) {
                    type = coll.get(0);
                }
            }
        }
        return type;
    }

    private EntityObjectInfo getEntityObject(Context ctx, String asstHGAttribute) throws BOSException {
        if (this.entityObjects == null) {
            this.entityObjects = new HashMap<String, EntityObjectInfo>();
            IAssistantHG iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
            BOSObjectType type = iAssistantHG.getType();
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo entityObject = loader.getEntity(type);
            PropertyCollection props = entityObject.getInheritedNoDuplicatedProperties();
            for (PropertyInfo p : props) {
                if (!(p instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo prop = (LinkPropertyInfo)p;
                EntityObjectInfo pEntityObject = prop.getRelationship().getSupplierObject();
                this.entityObjects.put(p.getName().toLowerCase(), pEntityObject);
            }
        }
        return this.entityObjects.get(asstHGAttribute.toLowerCase());
    }

    private void initParam(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        if (this.gl043s.containsKey(company.getId().toString())) {
            return;
        }
        HashMap<String, String> in = new HashMap<String, String>();
        in.put("GL_043", company.getId().toString());
        in.put("GL_069", company.getId().toString());
        HashMap out = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(in);
        this.gl043s.put(company.getId().toString(), out.get("GL_043"));
        this.gl069s.put(company.getId().toString(), out.get("GL_069"));
    }

    private FilterInfo getGFilter(Context ctx, AsstActTypeInfo asstActType, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        String key = company.getId() + "_" + asstActType.getId();
        if (this.gFilters.containsKey(key)) {
            return this.gFilters.get(key);
        }
        FilterInfo gFilter = AuxAccountUtils.getFilterForGeneral((Context)ctx, (String)asstActType.getGlAsstActTypeGrp().getId().toString(), (CompanyOrgUnitInfo[])new CompanyOrgUnitInfo[]{company});
        this.gFilters.put(key, gFilter);
        return gFilter;
    }

    private Set<String> getRelations(Context ctx, CompanyOrgUnitInfo company, OrgType fromOrg) throws BOSException {
        String key = company.getId() + "_" + fromOrg.getValue();
        if (this.relationss.containsKey(key)) {
            return this.relationss.get(key);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("toUnit.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)new Integer(fromOrg.getValue())));
        OrgUnitRelationCollection orColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null));
        HashSet<String> relations = new HashSet<String>();
        relations.add(company.getId().toString());
        int j = orColl.size();
        for (int i = 0; i < j; ++i) {
            relations.add(orColl.get(i).getFromUnit().getId().toString());
        }
        this.relationss.put(key, relations);
        return relations;
    }

    private Map getAuthOrgs(Context ctx, String userId, OrgType fromOrg) throws BOSException, EASBizException {
        String key = userId + "_" + fromOrg.getValue();
        if (this.authOrgss.containsKey(key)) {
            return this.authOrgss.get(key);
        }
        HashMap authOrgs = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgs((IObjectPK)new ObjectUuidPK(userId), fromOrg, null, null, null);
        if (authOrgs == null) {
            authOrgs = new HashMap();
        }
        this.authOrgss.put(key, authOrgs);
        return authOrgs;
    }

    private Set<String> getPermOrgs(Context ctx, String userId, String permItemName) throws EASBizException, BOSException {
        String key = userId + "_" + permItemName;
        if (this.permOrgss.containsKey(key)) {
            return this.permOrgss.get(key);
        }
        String rule = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName);
        String sql = "select id where id in (" + rule + ") and id in (select forgid from t_pm_orgrange where fuserid = '" + userId + "' and ftype = " + 10 + ")";
        IObjectPK[] pks = FullOrgUnitFactory.getLocalInstance((Context)ctx).getPKList(sql);
        HashSet<String> permOrgs = new HashSet<String>();
        if (pks != null) {
            for (IObjectPK pk : pks) {
                permOrgs.add(pk.toString());
            }
        }
        this.permOrgss.put(key, permOrgs);
        return permOrgs;
    }

    protected CompanyOrgUnitInfo getCompany(Context ctx, String companyNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("isBizUnit");
        selector.add("isAssistantOrg");
        selector.add("mainOrg.id");
        selector.add("CU.id");
        selector.add("CU.number");
        selector.add("CU.name");
        selector.add("CU.longNumber");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber));
        view.setFilter(filter);
        CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        if (companys != null && companys.size() > 0) {
            return companys.get(0);
        }
        return null;
    }

    public static UserInfo getUser(Context ctx, String strName) throws BOSException {
        if (strName == null || strName.trim().equals("")) {
            return null;
        }
        IUser user = UserFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)strName.trim()));
        view.setFilter(filter);
        UserCollection userCollection = user.getUserCollection(view);
        if (userCollection != null && userCollection.size() != 0) {
            return userCollection.get(0);
        }
        filter = new FilterInfo();
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)strName.trim()));
        view.setFilter(filter);
        userCollection = user.getUserCollection(view);
        if (userCollection != null && userCollection.size() != 0) {
            return userCollection.get(0);
        }
        return null;
    }

    public static String buildMarkSQL(int count) {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        return "(" + sql.toString() + ")";
    }

    private Date getDate(Map params, String key) {
        Date date = null;
        if (params.get(key) != null) {
            String value = params.get(key).toString().trim();
            try {
                if (value.length() == 23) {
                    date = this.DF.parse(value);
                } else if (value.length() == 19) {
                    date = this.DF2.parse(value);
                } else if (value.length() == 10) {
                    date = this.DF3.parse(value);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    protected void findMaterial(Context ctx, Map params, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, SQLException {
        Date date;
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("select \n");
        sql.append("    m.FID, m.FNumber, m.FName_" + loc + " FName, m.FSimpleName, m.FModel, m.FHelpCode, \n");
        sql.append("    mu.FID FMuID, mu.FNumber FMuNumber, mu.FName_" + loc + " FMuName, \n");
        sql.append("    m.FCreateTime, m.FLastUpdateTime \n");
        sql.append("from T_BD_Material m \n");
        sql.append("join T_BD_MaterialCompanyInfo mc on mc.FMaterialID = m.FID \n");
        sql.append("left join T_BD_MeasureUnit mu on mu.FID = m.FBaseUnit \n");
        sql.append("where m.FStatus = 1 \n");
        sql.append(" and mc.FCompanyID = ? \n");
        sqlParams.add(company.getId().toString());
        sql.append(" and mc.FStatus = 1 \n");
        if (asstActNumbers.size() > 0) {
            sql.append(" and m.FNumber in " + GetAsstActService.buildMarkSQL(asstActNumbers.size()) + " \n");
            sqlParams.addAll(asstActNumbers);
        }
        if ((date = this.getDate(params, "lastUpdateTime")) != null) {
            sql.append(" and m.FLastUpdateTime >= ? \n");
            sqlParams.add(new Timestamp(date.getTime()));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlParams.toArray());
        while (rs.next()) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", rs.getString("FID"));
            row.put("number", rs.getString("FNumber"));
            row.put("name", rs.getString("FName"));
            row.put("simpleName", rs.getString("FSimpleName"));
            row.put("model", rs.getString("FModel"));
            row.put("helpCode", rs.getString("FHelpCode"));
            row.put("baseUnit.id", rs.getString("FMuID"));
            row.put("baseUnit.number", rs.getString("FMuNumber"));
            row.put("baseUnit.name", rs.getString("FMuName"));
            Timestamp time = rs.getTimestamp("FCreateTime");
            if (time != null) {
                row.put("createTime", this.DF.format(time));
            }
            if ((time = rs.getTimestamp("FLastUpdateTime")) != null) {
                row.put("lastUpdateTime", this.DF.format(time));
            }
            this.rows.add(row);
        }
    }

    protected void findCustomer(Context ctx, Map params, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, SQLException {
        Date date;
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("select c.FID, c.FNumber, c.FName_" + loc + " FName, c.FSimpleName, c.FMnemonicCode, c.FIsInternalCompany, c.FEffectedStatus, \n");
        sql.append("    c.FCreateTime, c.FLastUpdateTime, \n");
        sql.append("    cc.FEffectedStatus FCEffectedStatus \n");
        sql.append("from T_BD_Customer c \n");
        sql.append("join T_BD_CustomerCompanyInfo cc on cc.FCustomerID = c.FID \n");
        sql.append("where c.FUsedStatus = 1 \n");
        sql.append(" and cc.FComOrgID = ? \n");
        sqlParams.add(company.getId().toString());
        sql.append(" and cc.FUsingStatus = 0 \n");
        if (asstActNumbers.size() > 0) {
            sql.append(" and c.FNumber in " + GetAsstActService.buildMarkSQL(asstActNumbers.size()) + " \n");
            sqlParams.addAll(asstActNumbers);
        }
        if ((date = this.getDate(params, "lastUpdateTime")) != null) {
            sql.append(" and c.FLastUpdateTime >= ? \n");
            sqlParams.add(new Timestamp(date.getTime()));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlParams.toArray());
        while (rs.next()) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", rs.getString("FID"));
            row.put("number", rs.getString("FNumber"));
            row.put("name", rs.getString("FName"));
            row.put("simpleName", rs.getString("FSimpleName"));
            row.put("mnemonicCode", rs.getString("FMnemonicCode"));
            row.put("isInternalCompany", String.valueOf(rs.getInt("FIsInternalCompany") == 1));
            row.put("effectedStatus", String.valueOf(rs.getInt("FEffectedStatus")));
            row.put("companyInfo.effectedStatus", String.valueOf(rs.getInt("FCEffectedStatus")));
            Timestamp time = rs.getTimestamp("FCreateTime");
            if (time != null) {
                row.put("createTime", this.DF.format(time));
            }
            if ((time = rs.getTimestamp("FLastUpdateTime")) != null) {
                row.put("lastUpdateTime", this.DF.format(time));
            }
            this.rows.add(row);
        }
    }

    protected void findProvider(Context ctx, Map params, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, SQLException {
        Date date;
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("select s.FID, s.FNumber, s.FName_" + loc + " FName, s.FSimpleName, s.FMnemonicCode, s.FIsInternalCompany, s.FEffectedStatus, \n");
        sql.append("    s.FCreateTime, s.FLastUpdateTime, \n");
        sql.append("    sc.FEffectedStatus FCEffectedStatus \n");
        sql.append("from T_BD_Supplier s \n");
        sql.append("join T_BD_SupplierCompanyInfo sc on sc.FSupplierID = s.FID \n");
        sql.append("where s.FUsedStatus = 1 \n");
        sql.append(" and sc.FComOrgID = ? \n");
        sqlParams.add(company.getId().toString());
        sql.append(" and sc.FUsingStatus = 0 \n");
        if (asstActNumbers.size() > 0) {
            sql.append(" and s.FNumber in " + GetAsstActService.buildMarkSQL(asstActNumbers.size()) + " \n");
            sqlParams.addAll(asstActNumbers);
        }
        if ((date = this.getDate(params, "lastUpdateTime")) != null) {
            sql.append(" and s.FLastUpdateTime >= ? \n");
            sqlParams.add(new Timestamp(date.getTime()));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlParams.toArray());
        while (rs.next()) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", rs.getString("FID"));
            row.put("number", rs.getString("FNumber"));
            row.put("name", rs.getString("FName"));
            row.put("simpleName", rs.getString("FSimpleName"));
            row.put("mnemonicCode", rs.getString("FMnemonicCode"));
            row.put("isInternalCompany", String.valueOf(rs.getInt("FIsInternalCompany") == 1));
            row.put("effectedStatus", String.valueOf(rs.getInt("FEffectedStatus")));
            row.put("companyInfo.effectedStatus", String.valueOf(rs.getInt("FCEffectedStatus")));
            Timestamp time = rs.getTimestamp("FCreateTime");
            if (time != null) {
                row.put("createTime", this.DF.format(time));
            }
            if ((time = rs.getTimestamp("FLastUpdateTime")) != null) {
                row.put("lastUpdateTime", this.DF.format(time));
            }
            this.rows.add(row);
        }
    }

    protected void findProject(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, SQLException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("displayName");
        selector.add("isLeaf");
        selector.add("level");
        selector.add("type");
        selector.add("status");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            if (asstActType.isUseLongNumber()) {
                HashSet<String> asstActLongNumbers = new HashSet<String>();
                for (String asstActNumber : asstActNumbers) {
                    asstActLongNumbers.add(asstActNumber.replace('.', '!'));
                }
                filter.getFilterItems().add(new FilterItemInfo("longNumber", asstActLongNumbers, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
            }
        }
        if (this.isOnlyLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        }
        filter.getFilterItems().add(new FilterItemInfo("isListItem", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(2), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        ProjectCollection coll = ProjectFactory.getLocalInstance((Context)ctx).getProjectCollection(view);
        for (ProjectInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            String longNumber = aa.getLongNumber();
            if (longNumber != null) {
                longNumber = longNumber.replace('!', '.');
            }
            row.put("longNumber", longNumber);
            row.put("displayName", aa.getDisplayName());
            row.put("isLeaf", String.valueOf(aa.isIsLeaf()));
            row.put("level", String.valueOf(aa.getLevel()));
            row.put("type", String.valueOf(aa.getType().getValue()));
            row.put("status", String.valueOf(aa.getStatus().getValue()));
            this.rows.add(row);
        }
    }

    protected void findBankAccount(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, SQLException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("bank.id");
        selector.add("bank.name");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        selector.add("bankAccountNumber");
        selector.add("currency.id");
        selector.add("currency.number");
        selector.add("currency.name");
        selector.add("company.id");
        selector.add("company.number");
        selector.add("company.name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        HashSet<String> orgIds = new HashSet<String>();
        orgIds.add(company.getId().toString());
        if (company.isIsAssistantOrg()) {
            orgIds.add(company.getMainOrg().getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", orgIds, CompareType.INCLUDE));
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        for (AccountBankInfo aa : coll) {
            CompanyOrgUnitInfo c;
            AccountViewInfo account;
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            BankInfo bank = aa.getBank();
            if (bank != null) {
                row.put("bank.id", bank.getId().toString());
                row.put("bank.name", bank.getName());
            }
            if ((account = aa.getAccount()) != null) {
                row.put("account.id", account.getId().toString());
                row.put("account.number", account.getNumber());
                row.put("account.name", account.getName());
            }
            row.put("bankAccountNumber", aa.getBankAccountNumber());
            CurrencyInfo currency = aa.getCurrency();
            if (currency != null) {
                row.put("currency.id", currency.getId().toString());
                row.put("currency.number", currency.getNumber());
                row.put("currency.name", currency.getName());
            }
            if ((c = aa.getCompany()) != null) {
                row.put("company.id", c.getId().toString());
                row.put("company.number", c.getNumber());
                row.put("company.name", c.getName());
            }
            this.rows.add(row);
        }
    }

    protected void findIndustry(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        this.findOther(ctx, asstActType, asstActNumbers, company, cuId, userId);
    }

    protected void findRegion(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        BankCollection coll = BankFactory.getLocalInstance((Context)ctx).getBankCollection(view);
        for (BankInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            this.rows.add(row);
        }
    }

    protected void findCashFlowItem(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, SQLException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("displayName");
        selector.add("isLeaf");
        selector.add("level");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            if (asstActType.isUseLongNumber()) {
                HashSet<String> asstActLongNumbers = new HashSet<String>();
                for (String asstActNumber : asstActNumbers) {
                    asstActLongNumbers.add(asstActNumber.replace('.', '!'));
                }
                filter.getFilterItems().add(new FilterItemInfo("longNumber", asstActLongNumbers, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
            }
        }
        if (this.isOnlyLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        }
        filter.getFilterItems().add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        CashFlowItemCollection coll = CashFlowItemFactory.getLocalInstance((Context)ctx).getCashFlowItemCollection(view);
        for (CashFlowItemInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            String longNumber = aa.getLongNumber();
            if (longNumber != null) {
                longNumber = longNumber.replace('!', '.');
            }
            row.put("longNumber", longNumber);
            row.put("displayName", aa.getDisplayName());
            row.put("isLeaf", String.valueOf(aa.isIsLeaf()));
            row.put("level", String.valueOf(aa.getLevel()));
            this.rows.add(row);
        }
    }

    protected void findCountry(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        this.findOther(ctx, asstActType, asstActNumbers, company, cuId, userId);
    }

    protected void findProvince(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("country.id");
        selector.add("country.number");
        selector.add("country.name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        ProvinceCollection coll = ProvinceFactory.getLocalInstance((Context)ctx).getProvinceCollection(view);
        for (ProvinceInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            CountryInfo country = aa.getCountry();
            if (country != null) {
                row.put("country.id", country.getId().toString());
                row.put("country.number", country.getNumber());
                row.put("country.name", country.getName());
            }
            this.rows.add(row);
        }
    }

    protected void findCity(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, SQLException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("cityNumber");
        selector.add("province.id");
        selector.add("province.number");
        selector.add("province.name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        CityCollection coll = CityFactory.getLocalInstance((Context)ctx).getCityCollection(view);
        for (CityInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            row.put("cityNumber", aa.getCityNumber());
            ProvinceInfo province = aa.getProvince();
            if (province != null) {
                row.put("province.id", province.getId().toString());
                row.put("province.number", province.getNumber());
                row.put("province.name", province.getName());
            }
            this.rows.add(row);
        }
    }

    protected void findAccountCussent(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, SQLException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)new Integer(0)));
        AccountCussentCollection coll = AccountCussentFactory.getLocalInstance((Context)ctx).getAccountCussentCollection(view);
        for (AccountCussentInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            this.rows.add(row);
        }
    }

    protected void findCostObject(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, SQLException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)new Integer(0)));
        CostObjectCollection coll = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(view);
        for (CostObjectInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            this.rows.add(row);
        }
    }

    protected void findAdminOrg(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("displayName");
        selector.add("simpleName");
        selector.add("isLeaf");
        selector.add("level");
        selector.add("code");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        if (this.isOnlyLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        }
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
        AdminOrgUnitCollection coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
        ArrayList<AdminOrgUnitInfo> aas = new ArrayList<AdminOrgUnitInfo>(coll.size());
        this.initParam(ctx, company);
        if ("true".equals(this.gl069s.get(company.getId().toString()))) {
            Set<String> relations = this.getRelations(ctx, company, OrgType.Admin);
            for (AdminOrgUnitInfo aa : coll) {
                if (!relations.contains(aa.getId().toString())) continue;
                aas.add(aa);
            }
        } else if ("true".equals(this.gl043s.get(company.getId().toString()))) {
            Map authOrgs = this.getAuthOrgs(ctx, userId, OrgType.Admin);
            for (AdminOrgUnitInfo aa : coll) {
                if (!authOrgs.containsKey(aa.getId().toString())) continue;
                aas.add(aa);
            }
        } else {
            for (AdminOrgUnitInfo aa : coll) {
                aas.add(aa);
            }
        }
        for (AdminOrgUnitInfo aa : aas) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            String longNumber = aa.getLongNumber();
            if (longNumber != null) {
                longNumber = longNumber.replace('!', '.');
            }
            row.put("longNumber", longNumber);
            row.put("displayName", aa.getDisplayName());
            row.put("simpleName", aa.getSimpleName());
            row.put("isLeaf", String.valueOf(aa.isIsLeaf()));
            row.put("level", String.valueOf(aa.getLevel()));
            row.put("code", aa.getCode());
            this.rows.add(row);
        }
    }

    protected void findOrg(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("displayName");
        selector.add("simpleName");
        selector.add("level");
        selector.add("isBizUnit");
        selector.add("code");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        if (this.isOnlyLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
        }
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
        String asstHGAttribute = asstActType.getAsstHGAttribute();
        ICostCenterOrgUnit iOrgUnit = null;
        OrgType fromOrg = null;
        String permItemName = null;
        if (asstHGAttribute.equals("costOrg")) {
            iOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            fromOrg = OrgType.CostCenter;
            permItemName = "CostCenter_View";
        } else if (asstHGAttribute.equals("saleOrg")) {
            iOrgUnit = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
            fromOrg = OrgType.Sale;
            permItemName = "Sale_View";
        } else if (asstHGAttribute.equals("profitOrg")) {
            iOrgUnit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            fromOrg = OrgType.ProfitCenter;
            permItemName = "ProfitCenter_View";
        } else if (asstHGAttribute.equals("purchaseOrg")) {
            iOrgUnit = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
            fromOrg = OrgType.Purchase;
            permItemName = "Purchase_View";
        } else if (asstHGAttribute.equals("storeageOrg")) {
            iOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            fromOrg = OrgType.Storage;
            permItemName = "Storage_View";
        } else if (asstHGAttribute.equals("companyOrg")) {
            iOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            fromOrg = OrgType.Company;
            permItemName = "Company_View";
        } else {
            return;
        }
        OrgUnitCollection coll = iOrgUnit.getOrgUnitCollection(view);
        ArrayList<OrgUnitExtInfo> aas = new ArrayList<OrgUnitExtInfo>(coll.size());
        this.initParam(ctx, company);
        if ("true".equals(this.gl069s.get(company.getId().toString())) && !asstHGAttribute.equals("companyOrg") && !asstHGAttribute.equals("profitOrg")) {
            Set<String> relations = this.getRelations(ctx, company, fromOrg);
            for (OrgUnitExtInfo aa : coll) {
                if (!relations.contains(aa.getId().toString())) continue;
                aas.add(aa);
            }
        } else if ("true".equals(this.gl043s.get(company.getId().toString()))) {
            Map authOrgs = this.getAuthOrgs(ctx, userId, fromOrg);
            Set<String> permOrgs = this.getPermOrgs(ctx, userId, permItemName);
            for (OrgUnitExtInfo aa : coll) {
                if (!authOrgs.containsKey(aa.getId().toString()) || !permOrgs.contains(aa.getId().toString())) continue;
                aas.add(aa);
            }
        } else {
            for (OrgUnitExtInfo aa : coll) {
                aas.add(aa);
            }
        }
        for (OrgUnitExtInfo aa : aas) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            String longNumber = aa.getLongNumber();
            if (longNumber != null) {
                longNumber = longNumber.replace('!', '.');
            }
            row.put("longNumber", longNumber);
            row.put("displayName", aa.getDisplayName());
            row.put("simpleName", aa.getSimpleName());
            row.put("level", String.valueOf(aa.getLevel()));
            row.put("isBizUnit", String.valueOf(aa.isIsBizUnit()));
            row.put("code", aa.getCode());
            this.rows.add(row);
        }
    }

    protected void findPerson(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        PersonCollection coll = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
        for (PersonInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            this.rows.add(row);
        }
    }

    protected void findGeneral(Context ctx, Map params, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("displayName");
        selector.add("level");
        selector.add("creator.id");
        selector.add("creator.number");
        selector.add("creator.name");
        selector.add("creatorCompany.id");
        selector.add("creatorCompany.number");
        selector.add("creatorCompany.name");
        selector.add("createTime");
        selector.add("lastUpdateTime");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            if (asstActType.isUseLongNumber()) {
                HashSet<String> asstActLongNumbers = new HashSet<String>();
                for (String asstActNumber : asstActNumbers) {
                    asstActLongNumbers.add(asstActNumber.replace('.', '!'));
                }
                filter.getFilterItems().add(new FilterItemInfo("longNumber", asstActLongNumbers, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)asstActType.getGlAsstActTypeGrp().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)new Integer(1)));
        Date date = this.getDate(params, "lastUpdateTime");
        if (date != null) {
            filter.getFilterItems().add(new FilterItemInfo("lastUpdateTime", (Object)new Timestamp(date.getTime()), CompareType.GREATER_EQUALS));
        }
        HashSet<String> pIds = new HashSet<String>();
        if (asstActType.isIsMultilevel()) {
            FilterInfo pfilter = new FilterInfo();
            String groupID = asstActType.getGlAsstActTypeGrp().getId().toString();
            if (asstActType.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.S2) || asstActType.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.B1)) {
                StringBuffer sql = new StringBuffer();
                sql.append("select A.fparentid \n");
                sql.append("from T_BD_Generalasstacttype A \n");
                sql.append("inner join T_ORG_CtrlUnit D on D.FID='" + cuId + "' \n");
                sql.append("inner join T_ORG_CtrlUnit E on E.FID=A.FControlUnitID ");
                sql.append("and (CHARINDEX(E.FLongNumber||'!',D.FLongNumber)=1 or d.fid=e.fid) \n");
                sql.append("where A.fparentid is not null and FgroupID='" + groupID + "' ");
                if (this.isOnlyLeaf) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
                } else {
                    pfilter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
                }
            }
            FilterInfo gFilter = this.getGFilter(ctx, asstActType, company);
            String defaultSql = this.oqlToSql(gFilter);
            StringBuffer sql = new StringBuffer();
            sql.append(" select cg.fparentid from T_BD_GeneralAsstActType cg ");
            sql.append(" inner JOIN T_ORG_CtrlUnit AS CU ON cg.FControlUnitID = CU.FID ");
            sql.append(" inner join T_ORG_Company AS creatorCompany ON cg.FCreatorCompanyID = creatorCompany.FID ");
            sql.append(" where ");
            sql.append(" cg.fparentid is not null  ");
            if (groupID != null) {
                sql.append(" and cg.fgroupid='").append(groupID).append("'");
            }
            if (defaultSql != null) {
                sql.append(" and ( ").append(defaultSql);
                sql.append(" ) ");
            }
            if (this.isOnlyLeaf) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
            } else {
                pfilter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
            }
            if (gFilter != null && gFilter.getFilterItems().size() > 0) {
                filter.mergeFilter(gFilter, "and");
                pfilter.mergeFilter(gFilter, "and");
            }
            if (!this.isOnlyLeaf) {
                EntityViewInfo pview = new EntityViewInfo();
                SelectorItemCollection pselector = new SelectorItemCollection();
                pview.setSelector(pselector);
                pselector.add("id");
                pview.setFilter(pfilter);
                GeneralAsstActTypeCollection pcoll = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeCollection(pview);
                Iterator it = pcoll.iterator();
                while (it.hasNext()) {
                    pIds.add(((GeneralAsstActTypeInfo)it.next()).getId().toString());
                }
            }
        }
        GeneralAsstActTypeCollection coll = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeCollection(view);
        for (GeneralAsstActTypeInfo aa : coll) {
            CompanyOrgUnitInfo cc;
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            String longNumber = aa.getLongNumber();
            if (longNumber != null) {
                longNumber = longNumber.replace('!', '.');
            }
            row.put("longNumber", longNumber);
            row.put("displayName", aa.getDisplayName());
            if (this.isOnlyLeaf) {
                row.put("isLeaf", "true");
            } else {
                row.put("isLeaf", pIds.contains(aa.getId().toString()) ? "false" : "true");
            }
            row.put("level", String.valueOf(aa.getLevel()));
            UserInfo creator = aa.getCreator();
            if (creator != null) {
                row.put("creator.id", creator.getId().toString());
                row.put("creator.number", creator.getNumber());
                row.put("creator.name", creator.getName());
            }
            if ((cc = aa.getCreatorCompany()) != null) {
                row.put("creatorCompany.id", cc.getId().toString());
                row.put("creatorCompany.number", cc.getNumber());
                row.put("creatorCompany.name", cc.getName());
            }
            if (aa.getCreateTime() != null) {
                row.put("createTime", this.DF.format(aa.getCreateTime()));
            }
            if (aa.getLastUpdateTime() != null) {
                row.put("lastUpdateTime", this.DF.format(aa.getLastUpdateTime()));
            }
            this.rows.add(row);
        }
    }

    private String oqlToSql(FilterInfo defaultFilter) {
        String sql = null;
        if (defaultFilter != null && defaultFilter.getFilterItems().size() > 0) {
            sql = defaultFilter.toSql();
            sql = sql.replaceAll("\\.id", ".fid");
            sql = sql.replaceAll("\\.longNumber", ".flongNumber");
        }
        return sql;
    }

    protected void findInnerAccount(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)new Integer(1)));
        InnerAccountCollection coll = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountCollection(view);
        for (InnerAccountInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            this.rows.add(row);
        }
    }

    protected void findFpItem(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        this.findOther(ctx, asstActType, asstActNumbers, company, cuId, userId);
    }

    protected void findNtType(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)new Integer(1)));
        NTTypeCollection coll = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeCollection(view);
        for (NTTypeInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            this.rows.add(row);
        }
    }

    protected void findFeeType(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("displayName");
        selector.add("isLeaf");
        selector.add("level");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            if (asstActType.isUseLongNumber()) {
                HashSet<String> asstActLongNumbers = new HashSet<String>();
                for (String asstActNumber : asstActNumbers) {
                    asstActLongNumbers.add(asstActNumber.replace('.', '!'));
                }
                filter.getFilterItems().add(new FilterItemInfo("longNumber", asstActLongNumbers, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("enable", (Object)new Integer(1)));
        if (this.isOnlyLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        }
        FeeTypeCollection coll = FeeTypeFactory.getLocalInstance((Context)ctx).getFeeTypeCollection(view);
        for (FeeTypeInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            String longNumber = aa.getLongNumber();
            if (longNumber != null) {
                longNumber = longNumber.replace('!', '.');
            }
            row.put("longNumber", longNumber);
            row.put("displayName", aa.getDisplayName());
            row.put("isLeaf", String.valueOf(aa.isIsLeaf()));
            row.put("level", String.valueOf(aa.getLevel()));
            this.rows.add(row);
        }
    }

    protected void findCostItem(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        this.findOther(ctx, asstActType, asstActNumbers, company, cuId, userId);
    }

    protected void findNation(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        CountryCollection coll = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection(view);
        for (CountryInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            this.rows.add(row);
        }
    }

    protected void findArea(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        AreaCollection coll = AreaFactory.getLocalInstance((Context)ctx).getAreaCollection(view);
        for (AreaInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            this.rows.add(row);
        }
    }

    protected void findVillage(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("city.id");
        selector.add("city.number");
        selector.add("city.name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        RegionCollection coll = RegionFactory.getLocalInstance((Context)ctx).getRegionCollection(view);
        for (RegionInfo aa : coll) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", aa.getId().toString());
            row.put("number", aa.getNumber());
            row.put("name", aa.getName());
            CityInfo city = aa.getCity();
            if (city != null) {
                row.put("city.id", city.getId().toString());
                row.put("city.number", city.getNumber());
                row.put("city.name", city.getName());
            }
            this.rows.add(row);
        }
    }

    protected void findOther(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws BOSException, EASBizException {
        String asstHGAttribute = asstActType.getAsstHGAttribute();
        EntityObjectInfo entityObject = this.getEntityObject(ctx, asstHGAttribute);
        if (entityObject == null) {
            this.appendErr("asstActTypeNumber", (String)this.params.get("asstActTypeNumber"), ResourceBase.getString((String)RESOURCE, (String)"AAT_Disable", (Locale)ctx.getLocale()));
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        if (asstActType.isIsMultilevel() && asstActType.getGroupTableName() == null) {
            selector.add("longNumber");
            selector.add("displayName");
            selector.add("isLeaf");
        }
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (asstActNumbers.size() > 0) {
            if (asstActType.isIsMultilevel() && asstActType.getGroupTableName() == null && asstActType.isUseLongNumber()) {
                HashSet<String> asstActLongNumbers = new HashSet<String>();
                for (String asstActNumber : asstActNumbers) {
                    asstActLongNumbers.add(asstActNumber.replace('.', '!'));
                }
                filter.getFilterItems().add(new FilterItemInfo("longNumber", asstActLongNumbers, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
            }
        }
        if (asstActType.isIsMultilevel() && asstActType.getGroupTableName() == null && this.isOnlyLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        }
        if ("country".equalsIgnoreCase(asstHGAttribute)) {
            filter.getFilterItems().add(new FilterItemInfo("whState", (Object)"1"));
        }
        String strFacotry = entityObject.getBusinessImplFactory();
        String strLocal = entityObject.getBusinessImplName();
        String strMethod = "getDataBaseCollection";
        Class[] argTypes = new Class[]{view.getClass()};
        Object[] args = new Object[]{view};
        Object result = null;
        try {
            result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args);
        }
        catch (Exception e) {
            strMethod = "getDataBaseCollection";
            result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args, entityObject.getType());
        }
        if (result != null) {
            DataBaseCollection coll = (DataBaseCollection)result;
            for (DataBaseInfo aa : coll) {
                HashMap<String, String> row = new HashMap<String, String>();
                row.put("id", aa.getId().toString());
                row.put("number", aa.getNumber());
                row.put("name", aa.getName());
                if (aa.containsKey("longNumber")) {
                    String longNumber = aa.getString("longNumber");
                    if (longNumber != null) {
                        longNumber = longNumber.replace('!', '.');
                    }
                    row.put("longNumber", longNumber);
                }
                if (aa.containsKey("displayName")) {
                    row.put("displayName", aa.getString("displayName"));
                }
                if (aa.containsKey("isLeaf")) {
                    row.put("isLeaf", String.valueOf(aa.getBoolean("isLeaf")));
                }
                this.rows.add(row);
            }
        }
    }
}

