/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLFlagCollection;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GLFlagInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class GlAcctCussentGlFlagDeal {
    private static final Logger logger = CoreUIObject.getLogger(GlAcctCussentGlFlagDeal.class);
    public static final String cussentInitFlag = "cussentinit";
    private Map<String, Boolean> allowCussentCache = new HashMap<String, Boolean>();
    private Map<String, PeriodInfo> startPeriodCache = new HashMap<String, PeriodInfo>();
    private Map<String, PeriodInfo> currentPeriodCache = new HashMap<String, PeriodInfo>();

    public void deal(Context ctx, AccountViewCollection accountCol) throws EASBizException, BOSException {
        if (accountCol == null || accountCol.isEmpty()) {
            return;
        }
        for (int i = 0; i < accountCol.size(); ++i) {
            AccountViewInfo accountViewInfo = accountCol.get(i);
            String accountId = accountViewInfo.getId().toString();
            String companyId = accountViewInfo.getCompanyID().getId().toString();
            boolean allowCussent = this.isAllowCussent(ctx, companyId);
            if (!allowCussent) continue;
            if (!accountViewInfo.isIsLeaf()) {
                this.delCussentGlFlag(ctx, companyId, accountId);
                continue;
            }
            try {
                if (accountViewInfo.isAC()) {
                    PeriodInfo currentPeriod;
                    if (this.acctHasHisVchData(ctx, accountId)) {
                        PeriodInfo currentPeriod2 = this.getGLCurrentPeriod(ctx, companyId);
                        this.dealCussentGlFlag(ctx, accountViewInfo.getCompanyID(), accountId, currentPeriod2, false);
                        continue;
                    }
                    PeriodInfo startPeriod = this.getGLStartPeriod(ctx, companyId);
                    if (this.isGlStartPeriod(startPeriod, currentPeriod = this.getGLCurrentPeriod(ctx, companyId))) {
                        this.dealCussentGlFlag(ctx, accountViewInfo.getCompanyID(), accountId, startPeriod, false);
                        continue;
                    }
                    this.dealCussentGlFlag(ctx, accountViewInfo.getCompanyID(), accountId, currentPeriod, !this.hasAsstInitData(ctx, accountId));
                    continue;
                }
                this.delCussentGlFlag(ctx, companyId, accountId);
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)"gl acctCussent deal flag sql exception.", (Throwable)e);
                throw new BOSException("gl acctCussent deal flag sql exception", (Throwable)e);
            }
        }
    }

    public void deleteCussentGlFlag(Context ctx, String accountId) throws BOSException {
        String sql = "delete from t_gl_flag where FNAME ='cussentinit' and fkey = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{accountId});
    }

    public PeriodInfo getGLCurrentPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        PeriodInfo currentPeriod = null;
        if (this.currentPeriodCache.containsKey(companyId)) {
            currentPeriod = this.currentPeriodCache.get(companyId);
        } else {
            currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
            this.currentPeriodCache.put(companyId, currentPeriod);
        }
        return currentPeriod;
    }

    public PeriodInfo getGLStartPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        PeriodInfo startPeriod = null;
        if (this.startPeriodCache.containsKey(companyId)) {
            startPeriod = this.startPeriodCache.get(companyId);
        } else {
            startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
            this.startPeriodCache.put(companyId, startPeriod);
        }
        return startPeriod;
    }

    public boolean isAllowCussent(Context ctx, String companyId) throws EASBizException, BOSException {
        boolean isAllowCussent = false;
        if (this.allowCussentCache.containsKey(companyId)) {
            isAllowCussent = this.allowCussentCache.get(companyId);
        } else {
            Object allowCussentObj = GlUtils.getParamByKey(ctx, companyId, "GL_028");
            isAllowCussent = allowCussentObj == null ? false : Boolean.valueOf(allowCussentObj.toString());
            this.allowCussentCache.put(companyId, isAllowCussent);
        }
        return isAllowCussent;
    }

    public boolean hasAsstInitData(Context ctx, String accountId) throws BOSException, SQLException {
        String sql = "select 1 from t_gl_initassistbalance where faccountid = ?";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{accountId});
        return result.next();
    }

    public boolean acctHasHisVchData(Context ctx, String accountId) throws BOSException, SQLException {
        String sql = "select 1 from T_GL_VOUCHERENTRY where faccountid = ? ";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{accountId});
        return result.next();
    }

    public boolean acctHasVchDataWithPeriod(Context ctx, String accountId, PeriodInfo currentPeriod) throws BOSException, SQLException {
        int periodNumber = currentPeriod.getNumber();
        String sql = "select 1 from T_GL_VOUCHERENTRY entry inner join t_bd_period bp on entry.FPeriodID = bp.fid where faccountid = ? and bp.FNumber>=?";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{accountId, periodNumber});
        return result.next();
    }

    public boolean acctHasAssistBal(Context ctx, String accountId, PeriodInfo period) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 ");
        sql.append(" from ").append(GLBalanceUtils.getAssistBalanceTable(1));
        sql.append(" where faccountid =? and fperiod=? and fendbalancefor<>0");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountId, period.getNumber()});
        return result.next();
    }

    public boolean isGlStartPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
        return this.isGlStartPeriod(startPeriod, currentPeriod);
    }

    public boolean isGlStartPeriod(PeriodInfo startPeriod, PeriodInfo currentPeriod) throws EASBizException, BOSException {
        boolean isStartPeriod = false;
        if (currentPeriod != null && startPeriod != null) {
            isStartPeriod = startPeriod.getId().toString().equals(currentPeriod.getId().toString());
        }
        return isStartPeriod;
    }

    public PeriodInfo getGlCurrentPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
        return currentPeriod;
    }

    public PeriodInfo getGlPrePeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        PeriodInfo currentPeriod = this.getGlCurrentPeriod(ctx, companyId);
        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        return prePeriod;
    }

    public PeriodInfo getAcPeriod(Context ctx, String companyId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)6));
        viewInfo.setFilter(filter);
        SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection(viewInfo);
        SystemStatusCtrolInfo systemStatusCtrolInfo = ctrols.get(0);
        PeriodInfo startPeriod = systemStatusCtrolInfo.getStartPeriod();
        PeriodInfo acPeriod = systemStatusCtrolInfo.getAcPeriod();
        if (acPeriod == null) {
            acPeriod = startPeriod;
        }
        return acPeriod;
    }

    public PeriodInfo getCussentInitFlagPeriod(Context ctx, String companyId) throws BOSException {
        PeriodInfo currentPeriod;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)6));
        viewInfo.setFilter(filter);
        SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection(viewInfo);
        SystemStatusCtrolInfo systemStatusCtrolInfo = ctrols.get(0);
        PeriodInfo startPeriod = systemStatusCtrolInfo.getStartPeriod();
        PeriodInfo acPeriod = systemStatusCtrolInfo.getAcPeriod();
        if (acPeriod == null) {
            acPeriod = startPeriod;
        }
        if ((currentPeriod = systemStatusCtrolInfo.getCurrentPeriod()).getNumber() >= acPeriod.getNumber()) {
            return currentPeriod;
        }
        return acPeriod;
    }

    public void dealCussentGlFlag(Context ctx, CompanyOrgUnitInfo company, String accountId, PeriodInfo period, boolean isFinishInit) throws BOSException {
        GLFlagCollection cussentGlFlagCol = this.getCussentGlFlagCol(ctx, company.getId().toString(), accountId);
        if (cussentGlFlagCol != null && cussentGlFlagCol.size() > 0) {
            GLFlagInfo glFlagInfo = cussentGlFlagCol.get(0);
            if (glFlagInfo.getInitPeriod() == null || !glFlagInfo.getValue().equals(Boolean.toString(isFinishInit))) {
                glFlagInfo.setInitPeriod(glFlagInfo.getInitPeriod() == null ? period : glFlagInfo.getInitPeriod());
                glFlagInfo.setValue(isFinishInit ? Boolean.toString(isFinishInit) : glFlagInfo.getValue());
                GLFlagFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(glFlagInfo.getId()), glFlagInfo);
            }
        } else {
            this.addCussentGlFlag(ctx, company, accountId, period, isFinishInit);
        }
    }

    public void addCussentGlFlag(Context ctx, CompanyOrgUnitInfo company, String accountId, PeriodInfo period, boolean isFinishInit) throws BOSException {
        GLFlagInfo glFlagInfo = new GLFlagInfo();
        glFlagInfo.setName(cussentInitFlag);
        glFlagInfo.setValue(Boolean.toString(isFinishInit));
        glFlagInfo.setOrgUnit(company);
        glFlagInfo.setKey(accountId);
        glFlagInfo.setInitPeriod(period);
        GLFlagFactory.getLocalInstance(ctx).addnew(glFlagInfo);
    }

    public GLFlagCollection getCussentGlFlagCol(Context ctx, String companyId, String accountId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("initPeriod"));
        viewInfo.getSelector().add(new SelectorItemInfo("value"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)cussentInitFlag));
        filter.getFilterItems().add(new FilterItemInfo("key", (Object)accountId));
        viewInfo.setFilter(filter);
        GLFlagCollection collection = GLFlagFactory.getLocalInstance(ctx).getCollection(viewInfo);
        return collection;
    }

    public boolean existCussentGlFlag(Context ctx, String companyId, String accountId) throws BOSException {
        GLFlagCollection cussentGlFlagCol = this.getCussentGlFlagCol(ctx, companyId, accountId);
        return cussentGlFlagCol != null && cussentGlFlagCol.size() > 0;
    }

    public void delCussentGlFlag(Context ctx, String companyId, String accountId) throws BOSException {
        String sql = "delete from t_gl_flag where forgunitid = ? and fkey = ? and fname = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{companyId, accountId, cussentInitFlag});
    }

    public void delCussentGlFlagByCompany(Context ctx, String companyId) throws BOSException {
        String sql = "delete from t_gl_flag where forgunitid = ? and fname = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{companyId, cussentInitFlag});
    }

    public boolean acctHasAcAsstType(Context ctx, AccountViewInfo account, String companyId) throws BOSException {
        if (account != null && account.isAC()) {
            AsstActTypeCollection asstActTypes = this.getAsstActTypes(ctx, account.getCAA().getId().toString());
            HashSet<String> asstActTypeIds = new HashSet<String>();
            for (AsstActTypeInfo type : asstActTypes) {
                asstActTypeIds.add(type.getId().toString());
            }
            if (asstActTypeIds.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("asstActType.id");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                filter.getFilterItems().add(new FilterItemInfo("isAccountCussent", (Object)1));
                filter.getFilterItems().add(new FilterItemInfo("asstActType.id", asstActTypeIds, CompareType.INCLUDE));
                view.setFilter(filter);
                AsstActTypeDefaultCollection coll = AsstActTypeDefaultFactory.getLocalInstance((Context)ctx).getAsstActTypeDefaultCollection(view);
                return coll != null && coll.size() > 0;
            }
        }
        return false;
    }

    private AsstActTypeCollection getAsstActTypes(Context ctx, String caaId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)caaId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        return asstActTypes;
    }

    public void gl028ChangeToTrue(Context ctx, String companyId, PeriodInfo currentPeriod) throws BOSException {
        this.delCussentGlFlagByCompany(ctx, companyId);
        this.addAllAcAccountGlFlag(ctx, companyId, currentPeriod, false);
    }

    public void gl028ChangeToFalse(Context ctx, String companyId) throws BOSException {
        this.delCussentGlFlagByCompany(ctx, companyId);
    }

    private void addAllAcAccountGlFlag(Context ctx, String companyId, PeriodInfo currentPeriod, boolean isFinishInit) throws BOSException {
        String currentPeriodId = currentPeriod.getId().toString();
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append("insert into t_gl_flag (fid,fname,fvalue,forgunitid,fkey,finitperiodid)");
        sqlInsert.append(" select newBosID('E5A15661'),?,?,a.fcompanyid,a.fid,?");
        sqlInsert.append(" from t_bd_accountview a");
        sqlInsert.append(" inner join t_org_company c on c.fid = a.fcompanyid");
        sqlInsert.append(" where a.fisleaf = 1 and a.fcaa is not null and a.fac=1");
        sqlInsert.append(" and a.fcompanyid = ?");
        DbUtil.execute((Context)ctx, (String)sqlInsert.toString(), (Object[])new String[]{cussentInitFlag, Boolean.toString(isFinishInit), currentPeriodId, companyId});
    }

    public void closePeriodWhenGl028ToTrue(Context ctx, String companyId, boolean isFinishInit) throws BOSException, SQLException {
        String acPeriodSql = "select facperiodid from t_bd_systemstatusctrol where fcompanyid =? and fsystemstatusid=(select fid from t_bd_systemstatus where fname=6)";
        IRowSet acRowSet = DbUtil.executeQuery((Context)ctx, (String)acPeriodSql, (Object[])new Object[]{companyId});
        if (acRowSet.next()) {
            String acPeriod = acRowSet.getString(1);
            StringBuffer sqlInsert = new StringBuffer();
            sqlInsert.append("insert into t_gl_flag (fid,fname,fvalue,forgunitid,fkey,finitperiodid)");
            sqlInsert.append(" select newBosID('E5A15661'),'cussentinit','false',a.fcompanyid,a.fid,?");
            sqlInsert.append(" from t_bd_accountview a");
            sqlInsert.append(" inner join t_org_company c on c.fid = a.fcompanyid and c.faccounttableid = a.faccounttableid");
            sqlInsert.append(" where a.fisleaf=1 and a.fcaa is not null  and a.fac=1");
            sqlInsert.append(" and a.fcompanyid=?");
            sqlInsert.append(" and not exists (select 1 from T_gl_flag");
            sqlInsert.append(" where forgunitid = a.fcompanyid");
            sqlInsert.append(" and fkey = a.fid");
            sqlInsert.append(" and fname = 'cussentinit')");
            DbUtil.execute((Context)ctx, (String)sqlInsert.toString(), (Object[])new String[]{acPeriod, companyId});
        }
    }
}

