/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Collection;
import org.apache.log4j.Logger;

public class PsSql {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.PsSql");
    private static final DecimalFormat df = new DecimalFormat("0.##########");

    public static String getSqlWithParams(Object sql, Collection params) throws SQLException {
        return PsSql.getSqlWithParams(sql, params, 7);
    }

    public static String getSqlWithParams(Object sql, Object[] paramArr) throws SQLException {
        return PsSql.getSqlWithParams(sql, paramArr, 7, true);
    }

    public static String getSqlWithParams(Object sql, Collection params, int dabaBaseType) throws SQLException {
        Object[] paramArr = params.toArray();
        return PsSql.getSqlWithParams(sql, paramArr, dabaBaseType, true);
    }

    public static String getSqlWithParams(Object sql, Object[] paramArr, int dabaBaseType, boolean isTrans) throws SQLException {
        StringBuffer sb = new StringBuffer();
        char[] chs = sql.toString().toCharArray();
        int quoteCount = 0;
        int position = 0;
        block4: for (int i = 0; i < chs.length; ++i) {
            char ch = chs[i];
            switch (ch) {
                case '\'': {
                    ++quoteCount;
                    sb.append(ch);
                    continue block4;
                }
                case '?': {
                    if (quoteCount % 2 == 0) {
                        sb.append(PsSql.getFormatedValue(paramArr[position], dabaBaseType));
                        ++position;
                        continue block4;
                    }
                    sb.append(ch);
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        if (quoteCount % 2 != 0) {
            throw new SQLException("Statement not close the quote:" + sql);
        }
        if (isTrans) {
            return PsSql.transSql(sb.toString(), dabaBaseType);
        }
        return sb.toString();
    }

    private static String getFormatedValue(Object obj, int dabaBaseType) {
        if (obj == null) {
            return "Null";
        }
        Class<?> objClass = obj.getClass();
        if (objClass == String.class) {
            return "'" + obj.toString() + "'";
        }
        if (objClass == Timestamp.class) {
            StringBuffer sb = new StringBuffer("'");
            sb.append(DateFormat.getDateTimeInstance().format((Timestamp)obj));
            sb.append("'");
            return sb.toString();
        }
        if (obj instanceof Date) {
            if (dabaBaseType == 8 || dabaBaseType == 7 || dabaBaseType == 1) {
                return "{ts'" + obj.toString() + " 00:00:00'}";
            }
            return "'" + obj.toString() + "'";
        }
        if (objClass == Double.class) {
            return df.format((Double)obj);
        }
        if (objClass == Float.class) {
            return df.format(((Float)obj).floatValue());
        }
        return obj.toString();
    }

    public static String transSql(String script, int dabaBaseType) {
        String rst = script;
        try {
            rst = TransUtil.Translate((String)script, (int)dabaBaseType);
        }
        catch (SqlTranslateException e) {
            logger.error((Object)e);
        }
        return rst;
    }
}

