/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxCollection;
import com.kingdee.eas.basedata.assistant.ExchangeAuxFactory;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeAux;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.IMeasureUnitGroup;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IReportConditionAssist;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ReportPartner {
    protected static final BigDecimal ZERO = new BigDecimal("0.0");
    protected static final String resource = "com.kingdee.eas.fi.gl.ReportBase";
    public static final int CURRENCY_COMMON = 0;
    public static final int CURRENCY_BASE_TOTAL = 1;
    public static final int CURRENCY_REPORTING_TOTAL = 2;
    protected String TITLE_DEBIT = "FlagDebit";
    protected String TITLE_CREDIT = "FlagCredit";
    protected String TITLE_BALANCE = "FlagBalance";
    protected String TITLE_YEAR_START = "strBalanceYearStart";
    protected String TITLE_PERIOD_START = "strBalancePeriodStart";
    protected String TITLE_DAY_SUM = "strDaySum";
    protected String TITLE_PERIOD_SUM = "strPeriodSum";
    protected String TITLE_YEAR_SUM = "strYearSum";
    protected String TITLE_SUM = "Total";
    protected String TITLE_TOTAL = "Total";
    protected String TITLE_BNSum = "BNSum";
    protected String TITLE_BWSum = "BWSum";
    protected String TITLE_CONVERT_LOCAL = "CONVERT_LOCAL";
    protected String TITLE_CONVERT_RPT = "CONVERT_RPT";
    protected String TITLE_SUB_TOTAL = "strSubTitle";
    private Connection connection = null;
    private Context context = null;
    private EntityViewInfo condition = null;
    private ReportConditionBase fixCondition = null;
    private int startIndex = -1;
    private int lineCount = -1;
    private String tempTableName = null;
    private String accountTempTableName = null;
    private int scaleFor = -1;
    private int scaleLocal = -1;
    private int scaleRpt = -1;
    private int scaleRateLocal = -1;
    private int scaleRateRpt = -1;
    private CurrencyCollection allCurrencyCollection = null;
    private CurrencyInfo currencyInfo = null;
    private PeriodInfo startPeriod = null;
    private PeriodInfo currentPeriod = null;
    private int currencyType = -1;
    private int currencyIsBaseCurrency = -1;
    private int currencyIsReportingCurrency = -1;
    private ReportTableHeadInfo tableheadInfo = null;
    private String fieldNameExtend = null;
    private Map variables = new HashMap();
    private AccountViewInfo accountViewInfo = null;
    private Map measureUnitMap = null;
    private MeasureUnitInfo baseMeasureUnit = null;
    private boolean afterGetSysParm = false;
    private boolean parmUseReportCurrency = false;
    private boolean useAccountPermission = false;
    private boolean parmAssitemShowNumber = false;
    private boolean parmBalanceDirSamAsAccount = false;
    private boolean parmAssitemShowLongName = false;
    private boolean paramShowLongNumberForGeneral = false;
    private boolean paramShowLongNameForGeneral = false;
    private boolean parmGoodShowSpec = false;
    private boolean parmAccountShowLongName = false;
    private boolean parmForeignCurrencySu = false;
    private boolean parmGroupPattern = false;
    private boolean paramTransferMeasureUnit = false;
    private MeasureUnitInfo defaultMeasureUnit = null;
    private boolean paramQtyAsst = false;
    private boolean paramUseMuAccountDefalut = false;
    private int parmQtyScale = 0;
    private int parmPriceScale = 0;
    private AsstActTypeInfo asstActTypeInfo = null;
    private String childCompanyIDs = null;
    private CompanyOrgUnitInfo company = null;
    private boolean paramAsstIsUnit = false;
    private String accountTableId = null;

    public ReportPartner(Context ctx) {
        this.context = ctx;
        this.initResource();
    }

    private void initResource() {
        this.TITLE_DEBIT = this.getString(this.TITLE_DEBIT);
        this.TITLE_CREDIT = this.getString(this.TITLE_CREDIT);
        this.TITLE_BALANCE = this.getString(this.TITLE_BALANCE);
        this.TITLE_YEAR_START = this.getString(this.TITLE_YEAR_START);
        this.TITLE_PERIOD_START = this.getString(this.TITLE_PERIOD_START);
        this.TITLE_DAY_SUM = this.getString(this.TITLE_DAY_SUM);
        this.TITLE_PERIOD_SUM = this.getString(this.TITLE_PERIOD_SUM);
        this.TITLE_YEAR_SUM = this.getString(this.TITLE_YEAR_SUM);
        this.TITLE_SUM = this.getString(this.TITLE_SUM);
        this.TITLE_TOTAL = this.getString(this.TITLE_TOTAL);
        this.TITLE_CONVERT_LOCAL = this.getString(this.TITLE_CONVERT_LOCAL);
        this.TITLE_CONVERT_RPT = this.getString(this.TITLE_CONVERT_RPT);
        this.TITLE_SUB_TOTAL = this.getString(this.TITLE_SUB_TOTAL);
        this.TITLE_BNSum = this.getString(this.TITLE_BNSum);
        this.TITLE_BWSum = this.getString(this.TITLE_BWSum);
    }

    private String getResource(String str) {
        return str;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public String getString(String key) {
        return ResourceBase.getString((String)resource, (String)key, (Locale)this.context.getLocale());
    }

    public EntityViewInfo getCondition() {
        return this.condition;
    }

    public void setCondition(EntityViewInfo conditionInfo) {
        this.condition = conditionInfo;
        this.fixCondition = this.condition == null ? null : (ReportConditionBase)this.condition.get("GLFixCondition");
    }

    public ReportConditionBase getFixCondition() {
        return this.fixCondition;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int index) {
        this.startIndex = index;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int count) {
        this.lineCount = count;
    }

    public void setTempTableName(String tableName) {
        this.tempTableName = tableName;
    }

    public String getTempTableName() {
        return this.tempTableName;
    }

    public String getAccountTempTableName() {
        return this.accountTempTableName;
    }

    public void setAccountTempTableName(String accountTempTableName) {
        this.accountTempTableName = accountTempTableName;
    }

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public String getCompanyId() {
        return this.company.getId().toString();
    }

    public CurrencyInfo getCurrency() throws BOSException, EASBizException {
        if (this.currencyInfo == null) {
            String currencyId = this.getFixCondition().getCurrencyID();
            if (currencyId == null) {
                return null;
            }
            CurrencyCollection cc = this.getAllCurrency();
            int n = cc.size();
            for (int i = 0; i < n; ++i) {
                if (!currencyId.equals(cc.get(i).getId().toString())) continue;
                this.currencyInfo = cc.get(i);
                break;
            }
        }
        return this.currencyInfo;
    }

    public String getPeriodTypeID() throws BOSException, EASBizException {
        return this.getCompany().getAccountPeriodType().getId().toString();
    }

    public String getAccountTableId() {
        if (StringUtils.isEmpty((String)this.accountTableId)) {
            return this.getCompany().getAccountTable().getId().toString();
        }
        return this.accountTableId;
    }

    public boolean isNewQuery() {
        EntityViewInfo evi = this.getCondition();
        ReportConditionBase customCondition = (ReportConditionBase)evi.get("GLFixCondition");
        return customCondition.isNewQuery();
    }

    public CurrencyCollection getAllCurrency() throws BOSException, EASBizException {
        if (this.allCurrencyCollection == null) {
            this.allCurrencyCollection = RptServerUtil.getAllCurrency(this.company.getId().toString(), this.context);
        }
        return this.allCurrencyCollection;
    }

    public int getAmountScale(String currencyID) throws BOSException, EASBizException {
        for (CurrencyInfo currencyInfo : this.getAllCurrency()) {
            if (!currencyID.equals(currencyInfo.getId().toString())) continue;
            return currencyInfo.getPrecision();
        }
        throw new ReportException(ReportException.GET_CURRENCY_ERROR);
    }

    public int getScaleFor() throws BOSException, EASBizException {
        if (this.scaleFor == -1 && this.getCurrency() != null) {
            this.scaleFor = this.getCurrency().getPrecision();
        }
        return this.scaleFor;
    }

    public int getScaleLocal() throws BOSException, EASBizException {
        if (this.scaleLocal == -1) {
            CurrencyInfo currencyInfo = this.getCompany().getBaseCurrency();
            this.scaleLocal = currencyInfo != null ? currencyInfo.getPrecision() : 0;
        }
        return this.scaleLocal;
    }

    public int getScaleRpt() throws BOSException, EASBizException {
        if (this.scaleRpt == -1) {
            CurrencyInfo currencyInfo = this.getCompany().getReportCurrency();
            this.scaleRpt = currencyInfo != null ? currencyInfo.getPrecision() : 0;
        }
        return this.scaleRpt;
    }

    public int getScaleRateLocal() throws BOSException, EASBizException {
        if (this.scaleRateLocal == -1) {
            this.getRateLocalAndRpt();
        }
        return this.scaleRateLocal;
    }

    public int getScaleRateLocal(String curId) throws BOSException, EASBizException {
        if (curId == null) {
            return this.getScaleRateLocal();
        }
        return this.getRateLocalAndRpt(curId, true);
    }

    private int getRateLocalAndRpt(String sourceId, boolean isLocal) throws BOSException, EASBizException {
        if ("AllCurrency".equals(sourceId)) {
            return 3;
        }
        int scaleRateRpt = -1;
        int scaleRateLocal = -1;
        CompanyOrgUnitInfo fullCompanyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.getCompanyId()));
        ExchangeTableInfo rptTableInfo = fullCompanyInfo.getReportExchangeTable();
        ExchangeTableInfo baseTableInfo = fullCompanyInfo.getBaseExchangeTable();
        if (this.getContext() == null) {
            throw new ReportException(ReportException.CONTEXT_EMPTY);
        }
        if (this.getCompany() == null) {
            throw new ReportException(ReportException.COMPANY_EMPTY);
        }
        String localId = null;
        String rptId = null;
        if (this.getCompany().getBaseCurrency() != null) {
            localId = this.getCompany().getBaseCurrency().getId().toString();
        }
        if (this.getCompany().getReportCurrency() != null) {
            rptId = this.getCompany().getReportCurrency().getId().toString();
        }
        if (isLocal && sourceId.equals(localId)) {
            return 3;
        }
        if (!isLocal && sourceId.equals(rptId)) {
            return 3;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int index = 0;
        StringBuffer maskString = new StringBuffer("");
        filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)sourceId));
        maskString.append(" #").append(index++);
        if (localId != null) {
            filter.getFilterItems().add(new FilterItemInfo("targetCurrency.id", (Object)localId));
            maskString.append(" and ( (#").append(index++);
            if (baseTableInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("exchangeTable.id", (Object)baseTableInfo.getId().toString()));
                maskString.append(" and #").append(index++);
            }
            maskString.append(") ");
        }
        if (rptId != null) {
            filter.getFilterItems().add(new FilterItemInfo("targetCurrency.id", (Object)rptId));
            if (localId != null) {
                maskString.append(" or (#").append(index++);
            } else {
                maskString.append(" and (#").append(index++);
            }
            if (rptTableInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("exchangeTable.id", (Object)rptTableInfo.getId().toString()));
                maskString.append(" and #").append(index++);
            }
            maskString.append(")");
        }
        if (localId != null) {
            maskString.append(")");
        }
        view.setFilter(filter);
        filter.setMaskString(maskString.toString());
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("targetCurrency.id"));
        sic.add(new SelectorItemInfo("precision"));
        IExchangeAux exchangeAux = ExchangeAuxFactory.getLocalInstance((Context)this.getContext());
        ExchangeAuxCollection collection = exchangeAux.getExchangeAuxCollection(view);
        for (ExchangeAuxInfo info : collection) {
            if (this.isBaseCurrency(info.getTargetCurrency().getId().toString()) && baseTableInfo != null && baseTableInfo.getId().toString().equals(info.getExchangeTable().getId().toString())) {
                scaleRateLocal = info.getPrecision();
            }
            if (!this.isReportingCurrency(info.getTargetCurrency().getId().toString()) || rptTableInfo == null || !rptTableInfo.getId().toString().equals(info.getExchangeTable().getId().toString())) continue;
            scaleRateRpt = info.getPrecision();
        }
        if (isLocal) {
            return scaleRateLocal;
        }
        return scaleRateRpt;
    }

    public int getScaleRateRpt() throws BOSException, EASBizException {
        if (this.scaleRateRpt == -1) {
            this.getRateLocalAndRpt();
        }
        return this.scaleRateRpt;
    }

    public int getScaleRateRpt(String curId) throws BOSException, EASBizException {
        if (curId == null) {
            return this.getScaleRateRpt();
        }
        return this.getRateLocalAndRpt(curId, false);
    }

    protected void getRateLocalAndRpt() throws BOSException, EASBizException {
        if (this.getCurrencyType() != 0) {
            this.scaleRateLocal = 3;
            this.scaleRateRpt = 3;
            return;
        }
        CompanyOrgUnitInfo fullCompanyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.getCompanyId()));
        ExchangeTableInfo rptTableInfo = fullCompanyInfo.getReportExchangeTable();
        ExchangeTableInfo baseTableInfo = fullCompanyInfo.getBaseExchangeTable();
        if (this.getContext() == null) {
            throw new ReportException(ReportException.CONTEXT_EMPTY);
        }
        if (this.getCompany() == null) {
            throw new ReportException(ReportException.COMPANY_EMPTY);
        }
        if (this.isBaseCurrency()) {
            this.scaleRateLocal = 3;
        }
        if (this.isReportingCurrency()) {
            this.scaleRateRpt = 3;
        }
        if (this.scaleRateLocal >= 0 && this.scaleRateRpt >= 0) {
            return;
        }
        String sourceId = this.getFixCondition().getCurrencyID();
        if ("AllCurrency".equals(sourceId)) {
            this.scaleRateLocal = 3;
            this.scaleRateRpt = 3;
            return;
        }
        String localId = null;
        String rptId = null;
        if (this.getCompany().getBaseCurrency() != null) {
            localId = this.getCompany().getBaseCurrency().getId().toString();
        }
        if (this.getCompany().getReportCurrency() != null) {
            rptId = this.getCompany().getReportCurrency().getId().toString();
        }
        if (localId == null) {
            this.scaleRateLocal = 3;
        }
        if (rptId == null) {
            this.scaleRateRpt = 3;
        }
        if (this.scaleRateLocal >= 0 && this.scaleRateRpt >= 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int index = 0;
        StringBuffer maskString = new StringBuffer("");
        filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)sourceId));
        maskString.append(" #").append(index++);
        if (localId != null) {
            filter.getFilterItems().add(new FilterItemInfo("targetCurrency.id", (Object)localId));
            maskString.append(" and ( (#").append(index++);
            if (baseTableInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("exchangeTable.id", (Object)baseTableInfo.getId().toString()));
                maskString.append(" and #").append(index++);
            }
            maskString.append(") ");
        }
        if (rptId != null) {
            filter.getFilterItems().add(new FilterItemInfo("targetCurrency.id", (Object)rptId));
            if (localId != null) {
                maskString.append(" or (#").append(index++);
            } else {
                maskString.append(" and (#").append(index++);
            }
            if (rptTableInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("exchangeTable.id", (Object)rptTableInfo.getId().toString()));
                maskString.append(" and #").append(index++);
            }
            maskString.append(")");
        }
        if (localId != null) {
            maskString.append(")");
        }
        view.setFilter(filter);
        filter.setMaskString(maskString.toString());
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("targetCurrency.id"));
        sic.add(new SelectorItemInfo("precision"));
        IExchangeAux exchangeAux = ExchangeAuxFactory.getLocalInstance((Context)this.getContext());
        ExchangeAuxCollection collection = exchangeAux.getExchangeAuxCollection(view);
        for (ExchangeAuxInfo info : collection) {
            if (this.isBaseCurrency(info.getTargetCurrency().getId().toString()) && baseTableInfo != null && baseTableInfo.getId().toString().equals(info.getExchangeTable().getId().toString())) {
                this.scaleRateLocal = info.getPrecision();
            }
            if (!this.isReportingCurrency(info.getTargetCurrency().getId().toString()) || rptTableInfo == null || !rptTableInfo.getId().toString().equals(info.getExchangeTable().getId().toString())) continue;
            this.scaleRateRpt = info.getPrecision();
        }
    }

    public Boolean getParmForeignCurrencyFUse() throws BOSException, EASBizException {
        return !this.isParmForeignCurrencySu();
    }

    public Boolean getParmUsingReportingCurrency() throws BOSException, EASBizException {
        return this.isParmUseReportCurrency();
    }

    public Boolean getParmIsUseAccountPermission() throws BOSException, EASBizException {
        return this.isUseAccountPermission();
    }

    public int getQuantityScale() throws BOSException, EASBizException {
        return this.getParmQtyScale();
    }

    public int getPriceAmountScale() throws BOSException, EASBizException {
        return this.getParmPriceScale();
    }

    public ReportTableHeadInfo getTableHeadInfo() {
        if (this.tableheadInfo == null) {
            this.tableheadInfo = new ReportTableHeadInfo();
        }
        return this.tableheadInfo;
    }

    public void setTableHeadInfo(ReportTableHeadInfo info) {
        this.tableheadInfo = info;
    }

    public Object getVariable(String name) {
        return this.variables.get(name);
    }

    public void setVariable(String name, Object obj) {
        this.variables.put(name, obj);
    }

    public String getFieldNameExtend() throws BOSException {
        if (this.fieldNameExtend == null) {
            this.fieldNameExtend = "_" + this.getContext().getLocale().getLanguage();
        }
        return this.fieldNameExtend;
    }

    public PeriodInfo getStartPeriod() throws BOSException, EASBizException {
        if (this.startPeriod == null) {
            this.startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)this.getContext(), (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.getCompany());
        }
        return this.startPeriod;
    }

    public PeriodInfo getCurrentPeriod() throws BOSException, EASBizException {
        if (this.currentPeriod == null) {
            this.currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.getContext(), (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.getCompany());
        }
        return this.currentPeriod;
    }

    protected void getSysParm() throws BOSException, EASBizException {
        if (!this.afterGetSysParm) {
            String[] paramList = new String[]{"G001", "GL_061", "GL_004", "GL_005", "GL_006", "GL_009", "GL_012", "GL_002", "GL_003", "GL_008", "G010", "GL_063_01", "GL_063", "GL_064", "GL_066", "GL_098"};
            GlParam glParam = GlParam.getGlParams((Context)this.context, (String[])paramList, (String)this.getCompanyId());
            this.parmUseReportCurrency = glParam.getBoolean("G001");
            this.useAccountPermission = glParam.getBoolean("GL_061");
            this.parmAssitemShowNumber = glParam.getBoolean("GL_004");
            this.parmBalanceDirSamAsAccount = glParam.getBoolean("GL_005");
            this.parmAssitemShowLongName = glParam.getBoolean("GL_006");
            this.parmGoodShowSpec = glParam.getBoolean("GL_009");
            this.parmAccountShowLongName = glParam.getBoolean("GL_012");
            this.parmForeignCurrencySu = glParam.getBoolean("GL_008");
            this.parmQtyScale = glParam.getInt("GL_002");
            this.parmPriceScale = glParam.getInt("GL_003");
            this.paramQtyAsst = glParam.getBoolean("G010");
            this.paramUseMuAccountDefalut = glParam.getBoolean("GL_063_01");
            this.paramTransferMeasureUnit = glParam.getBoolean("GL_063");
            this.paramShowLongNumberForGeneral = glParam.getBoolean("GL_064");
            this.paramShowLongNameForGeneral = glParam.getBoolean("GL_066");
            this.paramAsstIsUnit = glParam.getBoolean("GL_098");
            this.afterGetSysParm = true;
        }
    }

    protected Integer getMaxAccountLevel() throws BOSException, EASBizException {
        if (this.getCompanyId() != null) {
            return new Integer(AccountUtils.getMaxAccountLeve((Context)this.getContext(), (IObjectPK)new ObjectUuidPK(this.getCompanyId())));
        }
        return new Integer(0);
    }

    public Integer getMaxGroupControlAccountLeve() throws BOSException, EASBizException {
        if (this.getCompanyId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.getCompanyId());
            return new Integer(AccountUtils.getMaxGroupControlAccountLeve((Context)this.getContext(), (IObjectPK)pk));
        }
        return new Integer(0);
    }

    public Map getPeriodRange() throws BOSException, EASBizException {
        return CommRptBaseFactory.getLocalInstance((Context)this.context).getPeriodRange(this.company);
    }

    public Map getPeriodRange(int type) throws BOSException, EASBizException {
        HashMap<Object, int[]> hashMap;
        if (this.getStartPeriod() == null || this.getCurrentPeriod() == null) {
            throw new ReportException(ReportException.PERIOD_ERROR);
        }
        HashMap<Object, int[]> map = new HashMap<Object, int[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FPeriodYear, \r\n");
        sql.append("\tMin(TP.FPeriodNumber) MinNumber, \r\n");
        sql.append("\tMax(TP.FPeriodNumber) MaxNumber \r\n");
        sql.append("FROM T_BD_Period TP \r\n");
        sql.append("WHERE TP.FTypeID = ? \r\n");
        if ((type == 1 || type == 3) && this.getStartPeriod() != null) {
            sql.append("\tAND (TP.FPeriodYear>? or (TP.FPeriodYear=? and TP.FPeriodNumber >= ?)) \r\n");
        }
        if ((type == 2 || type == 3) && this.getCurrentPeriod() != null) {
            sql.append("\tAND (TP.FPeriodYear<? or (TP.FPeriodYear=? and TP.FPeriodNumber <= ?)) \r\n");
        }
        sql.append("GROUP BY TP.FPeriodYear \r\n");
        sql.append("ORDER BY TP.FPeriodYear \r\n");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValueId((CoreBaseInfo)this.getCompany().getAccountPeriodType());
        if ((type == 1 || type == 3) && this.getStartPeriod() != null) {
            parameter.addValue(this.getStartPeriod().getPeriodYear());
            parameter.addValue(this.getStartPeriod().getPeriodYear());
            parameter.addValue(this.getStartPeriod().getPeriodNumber());
        }
        if ((type == 2 || type == 3) && this.getCurrentPeriod() != null) {
            parameter.addValue(this.getCurrentPeriod().getPeriodYear());
            parameter.addValue(this.getCurrentPeriod().getPeriodYear());
            parameter.addValue(this.getCurrentPeriod().getPeriodNumber());
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getConnection().prepareStatement(parameter.getSqlWithParameters(sql.toString()));
            stmt.setFetchSize(100);
            rs = stmt.executeQuery();
            int[] yearRange = new int[]{-1, -1};
            map.put("YearRange", yearRange);
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                yearRange[0] = yearRange[0] == -1 ? year : yearRange[0];
                yearRange[1] = year;
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                if (periodRange[0] <= 0 || periodRange[1] <= 0) {
                    throw new ReportException(ReportException.PERIOD_ERROR);
                }
                map.put(new Integer(year), periodRange);
            }
            if (yearRange[0] <= 0 || yearRange[1] <= 0 || yearRange[0] < this.getStartPeriod().getPeriodYear() || (type == 2 || type == 3) && yearRange[1] > this.getCurrentPeriod().getPeriodYear() || map.size() <= 0) {
                throw new ReportException(ReportException.PERIOD_ERROR);
            }
            hashMap = map;
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return hashMap;
    }

    public Map getPeriodRangeUnion() throws BOSException, EASBizException {
        HashMap<Object, int[]> hashMap;
        HashMap<Object, int[]> map = new HashMap<Object, int[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FPeriodYear, \t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tMin(TP.FPeriodNumber) MinNumber, \t\t\t\t\t\t\t\r\n");
        sql.append("\tMax(TP.FPeriodNumber) MaxNumber \t\t\t\t\t\t\t\r\n");
        sql.append("FROM T_BD_Period TP ,\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("(SELECT Min(TPS.FBeginDate) FBeginDate, \t\t\t\t\t\t\r\n");
        sql.append("\t\tMin(TPC.FEndDate) FEndDate\t\t\t\t\t \t\t\t\r\n");
        sql.append(" FROM T_BD_SystemStatusCtrol TSSC\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tinner join t_bd_systemstatus tsst \r\n");
        sql.append(" on TSSC.FSystemStatusID=tsst.fid and TSST.fname=?\t\r\n");
        sql.append("\tINNER JOIN T_BD_Period TPS\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FStartPeriodID = TPS.FID \t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_BD_Period TPC\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FCurrentPeriodID = TPC.FID\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_Org_BaseUnit TC\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FCompanyID = TC.FID\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_Org_structure SC \t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FCompanyID = SC.FUnitId\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_Org_structure SP\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON CHARINDEX(SP.FLongNumber||'!',SC.FLongNumber) = 1\t\t\r\n");
        sql.append("\tinner join t_org_company cc on cc.fid=sc.funitId and cc.fisOnlyUnion=0 and cc.fIsCompanyOrgUnit=1 \r\n");
        sql.append(" WHERE SP.FUnitId = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tAND TPS.FTypeID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tAND TPC.FTypeID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t) TPRange\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("WHERE TP.FBeginDate >= TPRange.FBeginDate\t\t\t\t\t\t\r\n");
        sql.append("\tAND TP.FEndDate <= TPRange.FEndDate\t\t\t\t\t\t\t\r\n");
        sql.append("\tAND TP.FTypeID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("GROUP BY TP.FPeriodYear\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("ORDER BY TP.FPeriodYear \t\t\t\t\t\t\t\t\t\t\r\n");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValue(6);
        parameter.addValueChar(this.getCompanyId());
        parameter.addValueChar(this.getPeriodTypeID());
        parameter.addValueChar(this.getPeriodTypeID());
        parameter.addValueChar(this.getPeriodTypeID());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getConnection().prepareStatement(parameter.getSqlWithParameters(sql.toString()));
            stmt.setFetchSize(100);
            rs = stmt.executeQuery();
            int[] yearRange = new int[]{-1, -1};
            map.put("YearRange", yearRange);
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                yearRange[0] = yearRange[0] == -1 ? year : yearRange[0];
                yearRange[1] = year;
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                if (periodRange[0] <= 0 || periodRange[1] <= 0) {
                    throw new ReportException(ReportException.PERIOD_UNION_ERROR);
                }
                map.put(new Integer(year), periodRange);
            }
            if (yearRange[0] <= 0 || yearRange[1] <= 0 || map.size() <= 0) {
                throw new ReportException(ReportException.PERIOD_UNION_ERROR);
            }
            hashMap = map;
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return hashMap;
    }

    public int getCurrencyType() throws BOSException, EASBizException {
        if (this.currencyType < 0) {
            this.currencyType = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.getFixCondition().getCurrencyID()) ? 1 : (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.getFixCondition().getCurrencyID()) ? 2 : 0);
        }
        return this.currencyType;
    }

    public boolean isBaseCurrency() throws BOSException, EASBizException {
        if (this.currencyIsBaseCurrency <= 0) {
            CurrencyInfo baseCurrency;
            this.currencyIsBaseCurrency = 2;
            if (this.getCurrencyType() == 0 && (baseCurrency = this.getCompany().getBaseCurrency()) != null && baseCurrency.getId().toString().equals(this.getFixCondition().getCurrencyID())) {
                this.currencyIsBaseCurrency = 1;
            }
        }
        return this.currencyIsBaseCurrency == 1;
    }

    public boolean isBaseCurrency(String currencyId) throws BOSException, EASBizException {
        if (currencyId == null) {
            return false;
        }
        CurrencyInfo currencyInfo = this.getCompany().getBaseCurrency();
        if (currencyInfo == null) {
            return false;
        }
        return currencyId.equals(currencyInfo.getId().toString());
    }

    public boolean isReportingCurrency() throws BOSException, EASBizException {
        if (this.currencyIsReportingCurrency <= 0) {
            CurrencyInfo reportingCurrency;
            this.currencyIsReportingCurrency = 2;
            if (this.getCurrencyType() == 0 && (reportingCurrency = this.getCompany().getReportCurrency()) != null && reportingCurrency.getId().toString().equals(this.getFixCondition().getCurrencyID())) {
                this.currencyIsReportingCurrency = 1;
            }
        }
        return this.currencyIsReportingCurrency == 1;
    }

    public boolean isReportingCurrency(String currencyId) throws BOSException, EASBizException {
        if (currencyId == null) {
            return false;
        }
        CurrencyInfo currencyInfo = this.getCompany().getReportCurrency();
        if (currencyInfo == null) {
            return false;
        }
        return currencyId.equals(currencyInfo.getId().toString());
    }

    public Connection getConnection() throws BOSException, EASBizException {
        if (this.connection == null) {
            throw new ReportException(ReportException.CONNECTION_EMPTY);
        }
        boolean isClosed = false;
        try {
            isClosed = this.connection.isClosed();
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
        if (isClosed) {
            throw new ReportException(ReportException.CONNECTION_CLOSE);
        }
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    protected final String createTempTable(String nameKey, String fieldDefine) throws BOSException, EASBizException {
        return InitHelp.createTempTable(this.context, fieldDefine, nameKey);
    }

    protected final String createTempTableAsynchronism(String nameKey, String fieldDefine, boolean faceCreate) throws BOSException, EASBizException {
        return this.createTempTable(nameKey, fieldDefine);
    }

    protected final String createTempTableAsynchronism(String nameKey, String fieldDefine) throws BOSException, EASBizException {
        return this.createTempTableAsynchronism(nameKey, fieldDefine, false);
    }

    protected void dropTempTable(String tempTableName) throws BOSException, EASBizException {
        InitHelp.dropTempTable(this.context, tempTableName);
    }

    protected void dropTempTableAsynchronism(String tempTableName) throws BOSException, EASBizException {
        if (tempTableName != null) {
            this.dropTempTable(tempTableName);
        }
    }

    public AccountViewInfo getAccountViewInfo() throws BOSException, EASBizException {
        String accountId;
        if (this.getContext() == null) {
            throw new ReportException(ReportException.CONTEXT_EMPTY);
        }
        if (this.accountViewInfo == null && (accountId = this.getFixCondition().getAccountId()) != null && accountId.length() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(accountId);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("longName"));
            sic.add(new SelectorItemInfo("level"));
            sic.add(new SelectorItemInfo("DC"));
            sic.add(new SelectorItemInfo("isLeaf"));
            sic.add(new SelectorItemInfo("isCash"));
            sic.add(new SelectorItemInfo("isBank"));
            sic.add(new SelectorItemInfo("isQty"));
            sic.add(new SelectorItemInfo("AC"));
            sic.add(new SelectorItemInfo("hasUserProperty"));
            sic.add(new SelectorItemInfo("longNumber"));
            sic.add(new SelectorItemInfo("parent.id"));
            sic.add(new SelectorItemInfo("measureUnitID.id"));
            sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
            sic.add(new SelectorItemInfo("accountTypeID.id"));
            sic.add(new SelectorItemInfo("accountTableID.id"));
            sic.add(new SelectorItemInfo("CAA.id"));
            sic.add(new SelectorItemInfo("CAA.measureUnit.number"));
            sic.add(new SelectorItemInfo("CAA.measureUnit.name"));
            sic.add(new SelectorItemInfo("CAA.measureUnit.coefficient"));
            sic.add(new SelectorItemInfo("CAA.measureUnitGroup.id"));
            sic.add(new SelectorItemInfo("CAA.isQty"));
            IAccountView iAccount = AccountViewFactory.getLocalInstance((Context)this.getContext());
            this.accountViewInfo = iAccount.getAccountViewInfo((IObjectPK)pk, sic);
        }
        if (this.accountViewInfo == null) {
            throw new ReportException(ReportException.GET_ACCOUNT_ERROR);
        }
        return this.accountViewInfo;
    }

    public boolean isParmAccountShowLongName() throws BOSException, EASBizException {
        this.getSysParm();
        return this.parmAccountShowLongName;
    }

    public boolean isParmAssitemShowLongName() throws BOSException, EASBizException {
        this.getSysParm();
        return this.parmAssitemShowLongName;
    }

    public boolean isParmAssitemShowNumber() throws BOSException, EASBizException {
        this.getSysParm();
        return this.parmAssitemShowNumber;
    }

    public boolean isParmBalanceDirSamAsAccount() throws BOSException, EASBizException {
        this.getSysParm();
        return this.parmBalanceDirSamAsAccount;
    }

    public boolean isParmForeignCurrencySu() throws BOSException, EASBizException {
        this.getSysParm();
        return this.parmForeignCurrencySu;
    }

    public boolean isParmGoodShowSpec() throws BOSException, EASBizException {
        this.getSysParm();
        return this.parmGoodShowSpec;
    }

    public int getParmPriceScale() throws BOSException, EASBizException {
        this.getSysParm();
        return this.parmPriceScale;
    }

    public boolean getParmQtyAsst() throws BOSException, EASBizException {
        this.getSysParm();
        return this.paramQtyAsst;
    }

    public boolean getParmUseMuAccountDefalut() throws BOSException, EASBizException {
        this.getSysParm();
        return this.paramUseMuAccountDefalut;
    }

    public int getParmQtyScale() throws BOSException, EASBizException {
        this.getSysParm();
        return this.parmQtyScale;
    }

    public boolean isParmUseReportCurrency() throws BOSException, EASBizException {
        this.getSysParm();
        return this.parmUseReportCurrency;
    }

    public boolean isUseAccountPermission() throws BOSException, EASBizException {
        this.getSysParm();
        return this.useAccountPermission;
    }

    public boolean isParmGroupPattern() throws BOSException, EASBizException {
        this.getSysParm();
        return this.parmGroupPattern;
    }

    public void getAllMeasureUnitForAccount(String groupId) throws BOSException, EASBizException {
        this.measureUnitMap = new HashMap();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (groupId != null) {
            filter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.id", (Object)groupId));
        }
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isBaseUnit"));
        sic.add(new SelectorItemInfo("coefficient"));
        sic.add(new SelectorItemInfo("measureUnitGroup.id"));
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)this.getContext());
        MeasureUnitCollection collection = iMeasureUnit.getMeasureUnitCollection(view);
        for (MeasureUnitInfo info : collection) {
            this.measureUnitMap.put(info.getId().toString(), info);
            if (groupId == null || !info.isIsBaseUnit()) continue;
            this.baseMeasureUnit = info;
        }
    }

    public MeasureUnitInfo getMeasureUnitInfoForAccount(String id) throws BOSException, EASBizException {
        if (id == null) {
            return null;
        }
        if (this.measureUnitMap == null) {
            MeasureUnitGroupInfo measureUnitGroupInfo = this.getAccountViewInfo().getMeasureUnitGroupID();
            if (measureUnitGroupInfo == null) {
                return null;
            }
            this.getAllMeasureUnitForAccount(measureUnitGroupInfo.getId().toString());
        }
        return (MeasureUnitInfo)this.measureUnitMap.get(id);
    }

    public MeasureUnitInfo getMeasureUnitInfoForAsst(String id) throws BOSException, EASBizException {
        if (id == null) {
            return null;
        }
        if (this.measureUnitMap == null || this.measureUnitMap.get(id) == null) {
            this.getAllMeasureUnitForAccount(null);
        }
        return (MeasureUnitInfo)this.measureUnitMap.get(id);
    }

    public MeasureUnitInfo getMeasureUnitInfoForAsstBal(String id) throws BOSException, EASBizException {
        if (id == null) {
            return null;
        }
        IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)this.context);
        MeasureUnitInfo muInfo = imu.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(id));
        IMeasureUnitGroup imug = MeasureUnitGroupFactory.getLocalInstance((Context)this.context);
        MeasureUnitGroupInfo mug = imug.getMeasureUnitGroupInfo((IObjectPK)new ObjectUuidPK(muInfo.getMeasureUnitGroup().getId().toString()));
        if (mug == null) {
            return null;
        }
        muInfo = imu.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(mug.getDefaultUnit().getId().toString()));
        if (muInfo == null) {
            return null;
        }
        return muInfo;
    }

    public MeasureUnitInfo getBaseMeasureUnitInfoForAccount() throws BOSException, EASBizException {
        if (this.baseMeasureUnit == null) {
            MeasureUnitGroupInfo measureUnitGroupInfo = this.getAccountViewInfo().getMeasureUnitGroupID();
            if (measureUnitGroupInfo == null) {
                return null;
            }
            this.getAllMeasureUnitForAccount(measureUnitGroupInfo.getId().toString());
        }
        return this.baseMeasureUnit;
    }

    public String getDCString(BigDecimal balance) throws BOSException, EASBizException {
        if (balance == null) {
            return this.TITLE_BALANCE;
        }
        int dc = balance.compareTo(ZERO);
        if (dc == 0) {
            return this.TITLE_BALANCE;
        }
        if (this.isParmBalanceDirSamAsAccount()) {
            return this.getAccountViewInfo().getDC() == BalanceDirectionEnum.DEBIT ? this.getResource(this.TITLE_DEBIT) : this.getResource(this.TITLE_CREDIT);
        }
        return dc > 0 ? this.TITLE_DEBIT : this.TITLE_CREDIT;
    }

    public String getDCStringWithParm(BigDecimal balance, int enumDC) throws BOSException, EASBizException {
        if (balance == null) {
            return this.getResource(this.TITLE_BALANCE);
        }
        int dc = balance.compareTo(ZERO);
        if (dc == 0) {
            return this.getResource(this.TITLE_BALANCE);
        }
        if (this.isParmBalanceDirSamAsAccount()) {
            return enumDC == 1 ? this.getResource(this.TITLE_DEBIT) : this.getResource(this.TITLE_CREDIT);
        }
        return dc > 0 ? this.getResource(this.TITLE_DEBIT) : this.getResource(this.TITLE_CREDIT);
    }

    public String getDCString(EntryDC dc) throws BOSException, EASBizException {
        return dc == EntryDC.DEBIT ? this.getResource(this.TITLE_DEBIT) : this.getResource(this.TITLE_CREDIT);
    }

    public String getDCStringWithoutParm(BigDecimal balance) throws BOSException, EASBizException {
        if (balance == null) {
            return this.getResource(this.TITLE_BALANCE);
        }
        int dc = balance.compareTo(ZERO);
        if (dc == 0) {
            return this.getResource(this.TITLE_BALANCE);
        }
        return dc > 0 ? this.getResource(this.TITLE_DEBIT) : this.getResource(this.TITLE_CREDIT);
    }

    public BigDecimal getBalanceForDC(BigDecimal balance) throws BOSException, EASBizException {
        if (balance == null) {
            return balance;
        }
        int dc = balance.compareTo(ZERO);
        if (dc == 0) {
            return balance;
        }
        if (this.isParmBalanceDirSamAsAccount()) {
            return this.getAccountViewInfo().getDC() == BalanceDirectionEnum.DEBIT ? balance : balance.negate();
        }
        return balance.abs();
    }

    public BigDecimal getBalanceForDCWithParm(BigDecimal balance, int enumDC) throws BOSException, EASBizException {
        if (balance == null) {
            return balance;
        }
        int dc = balance.compareTo(ZERO);
        if (dc == 0) {
            return balance;
        }
        if (this.isParmBalanceDirSamAsAccount()) {
            return enumDC == 1 ? balance : balance.negate();
        }
        return balance.abs();
    }

    public AsstActTypeInfo getAsstActTypeInfo() throws BOSException, EASBizException {
        if (this.getContext() == null) {
            throw new ReportException(ReportException.CONTEXT_EMPTY);
        }
        if (this.asstActTypeInfo == null) {
            String assistTypeId = ((IReportConditionAssist)((Object)this.getFixCondition())).getAssistTypeId();
            if (assistTypeId == null || assistTypeId.length() == 0) {
                throw new ReportException(ReportException.COMPANY_EMPTY);
            }
            IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)this.getContext());
            ObjectUuidPK pk = new ObjectUuidPK(assistTypeId);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("realtionDataObject"));
            sic.add(new SelectorItemInfo("mappingFieldName"));
            sic.add(new SelectorItemInfo("useLongNumber"));
            sic.add(new SelectorItemInfo("isQty"));
            this.asstActTypeInfo = asstActType.getAsstActTypeInfo((IObjectPK)pk, sic);
        }
        return this.asstActTypeInfo;
    }

    protected boolean executeSql(String sql, SqlParameter2 parameter) throws BOSException, EASBizException {
        PreparedStatement stmt = null;
        boolean executeResult = false;
        try {
            stmt = this.getConnection().prepareStatement(sql);
            if (parameter != null) {
                parameter.putToStatement(stmt);
            }
            executeResult = stmt.execute();
        }
        catch (SQLException sqle) {
            try {
                throw new SQLDataException(sql, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        return executeResult;
    }

    public String getChildCompanyId() throws BOSException, EASBizException {
        if (this.childCompanyIDs == null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT SC.FUnitId  \t\t\t\t\t\t\t\t\t\r\n");
            sql.append(" FROM T_Org_structure SC\t\t\t\t\t\t\t\t\r\n");
            sql.append("  INNER JOIN T_Org_structure SP\t\t\t\t\t\t\t\r\n");
            sql.append("  ON CHARINDEX(SP.FLongNumber||'!',SC.FLongNumber) = 1\t\r\n");
            sql.append(" WHERE SP.FUnitId = ?\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\tAND SC.FIsLeaf = 1\t\t\t\t\t\t\t\t\t\r\n");
            SqlParameter2 parameter = new SqlParameter2();
            parameter.addValueChar(this.getCompanyId());
            PreparedStatement stmt = null;
            ResultSet rs = null;
            StringBuffer sbRet = new StringBuffer();
            try {
                stmt = this.getConnection().prepareStatement(sql.toString());
                stmt.setFetchSize(100);
                if (parameter != null) {
                    parameter.putToStatement(stmt);
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String childId = rs.getString("FUnitId");
                    if (childId == null || childId.length() <= 0) continue;
                    if (sbRet.length() > 0) {
                        sbRet.append(",");
                    }
                    sbRet.append("'");
                    sbRet.append(childId);
                    sbRet.append("'");
                }
                this.childCompanyIDs = sbRet.length() > 0 ? sbRet.toString() : "''";
            }
            catch (SQLException sqle) {
                try {
                    sqle.setNextException(new SQLException("The query sql is:" + sql));
                    throw new SQLDataException(sqle);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        return this.childCompanyIDs;
    }

    public String getPhysicalCompanyId(boolean useCUID) {
        StringBuffer result = new StringBuffer("(");
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.fixCondition.getTreeModelOfCompany();
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.isLeaf()) continue;
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            result.append("'").append(useCUID ? userObject.getCuId() : userObject.getCompanyId()).append("',");
        }
        if (result.length() > 1) {
            result.replace(result.length() - 1, result.length(), ")");
        } else {
            result.append(")");
        }
        return result.toString();
    }

    public String getPhysicalCompanyIdByParent(SimpleCompanyUserObject parent) {
        SimpleCompanyUserObject userObject;
        StringBuffer result = new StringBuffer("(");
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.fixCondition.getTreeModelOfCompany();
        DefaultMutableTreeNode findNode = null;
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            userObject = (SimpleCompanyUserObject)node.getUserObject();
            if (!userObject.getCompanyId().equals(parent.getCompanyId())) continue;
            findNode = node;
            break;
        }
        if (findNode != null) {
            e = findNode.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                node = (DefaultMutableTreeNode)e.nextElement();
                if (!node.isLeaf()) continue;
                userObject = (SimpleCompanyUserObject)node.getUserObject();
                result.append("'").append(userObject.getCompanyId()).append("',");
            }
        }
        if (result.length() > 1) {
            result.replace(result.length() - 1, result.length(), ")");
        } else {
            result.append(")");
        }
        return result.toString();
    }

    public String getVirtureCompanyIdByParent(SimpleCompanyUserObject parent) {
        SimpleCompanyUserObject userObject;
        StringBuffer result = new StringBuffer("(");
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.fixCondition.getTreeModelOfCompany();
        DefaultMutableTreeNode findNode = null;
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            userObject = (SimpleCompanyUserObject)node.getUserObject();
            if (!userObject.getCompanyId().equals(parent.getCompanyId())) continue;
            findNode = node;
            break;
        }
        if (findNode != null) {
            e = findNode.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                node = (DefaultMutableTreeNode)e.nextElement();
                if (node.isLeaf()) continue;
                userObject = (SimpleCompanyUserObject)node.getUserObject();
                result.append("'").append(userObject.getCompanyId()).append("',");
            }
        }
        result.append("'").append(parent.getCompanyId()).append("',");
        result.replace(result.length() - 1, result.length(), ")");
        return result.toString();
    }

    public String getRootCompanyId() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.fixCondition.getTreeModelOfCompany();
        SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
        return userObject.getCompanyId();
    }

    public SimpleCompanyUserObject getCompanyUserObjectById(String id) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.fixCondition.getTreeModelOfCompany();
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            if (!userObject.getCompanyId().equals(id)) continue;
            return userObject;
        }
        return null;
    }

    public boolean isRptTransferMeasureUnit() throws BOSException, EASBizException {
        this.getSysParm();
        return this.paramTransferMeasureUnit;
    }

    public MeasureUnitInfo getDefaultMeasureUnitInfoForAccount() throws BOSException, EASBizException {
        if (this.accountViewInfo.getMeasureUnitID() != null && this.defaultMeasureUnit == null) {
            this.defaultMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)this.context).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(this.accountViewInfo.getMeasureUnitID().getId()));
            this.accountViewInfo.setMeasureUnitID(this.defaultMeasureUnit);
        }
        return this.defaultMeasureUnit;
    }

    public boolean isRptShowLongNumberFromGeneral() throws BOSException, EASBizException {
        this.getSysParm();
        return this.paramShowLongNumberForGeneral;
    }

    public boolean isRptShowLongNameFromGeneral() throws BOSException, EASBizException {
        this.getSysParm();
        return this.paramShowLongNameForGeneral;
    }

    public boolean isParamAsstIsUnit() throws EASBizException, BOSException {
        this.getSysParm();
        return this.paramAsstIsUnit;
    }

    public void setAccountTableId(String accountTableId) {
        this.accountTableId = accountTableId;
    }
}

