/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.RunningBusinessMethod;
import com.kingdee.eas.fi.gl.app.AbstractRptAccAsstactFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class RptAccAsstactFacadeControllerBean
extends AbstractRptAccAsstactFacadeControllerBean {
    private static final long serialVersionUID = 6095981043777604313L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.RptAccAsstactFacadeControllerBean");
    private static Map<String, String> dataTypes = null;
    private AccountTableInfo accountTable;
    private String plVoucherTempTable;

    private static synchronized Map<String, String> getDataTypes(Context ctx) throws BOSException {
        if (dataTypes == null) {
            dataTypes = GLTempTableUtil.getDataTypes(ctx, "RptAccAsstactFacadeControllerBean", "dataTable");
        }
        return dataTypes;
    }

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        CurrencyInfo baseCurrency;
        BOSUuid accTableID;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        RptParams pp = new RptParams();
        BOSUuid typeID = company.getAccountPeriodType().getId();
        if (typeID != null) {
            PeriodTypeInfo typeInfo = PeriodTypeFactory.getLocalInstance((Context)ctx).getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(typeID));
            company.setAccountPeriodType(typeInfo);
        }
        if ((accTableID = company.getAccountTable().getId()) != null) {
            AccountTableInfo accTableInfo = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableInfo((IObjectPK)new ObjectUuidPK(accTableID));
            company.setAccountTable(accTableInfo);
        }
        if (company.getBaseCurrency() != null && company.getBaseCurrency().getId() != null) {
            baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
            company.setBaseCurrency(baseCurrency);
        }
        if (company.getReportCurrency() != null && company.getReportCurrency().getId() != null) {
            baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getReportCurrency().getId()));
            company.setReportCurrency(baseCurrency);
        }
        pp.setObject("company", (Object)company);
        pp.setObject("pe", (Object)new PeriodEntity(RptServerUtil.getPeriodRange(ctx, company)));
        String curAcctTableID = company.getAccountTable().getId().toString();
        AccountRefContrastInfo info = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(company.getId().toString(), curAcctTableID);
        pp.setObject("lastAcctInfo", (Object)info);
        pp.setObject("currency", (Object)RptServerUtil.getAllCurrency(company.getId().toString(), ctx));
        pp.setObject("maxLevel", (Object)RptServerUtil.getMaxAccountLevel(ctx, company.getId().toString()));
        HashMap<String, ObjectUuidPK> param = new HashMap<String, ObjectUuidPK>();
        param.put("comid", new ObjectUuidPK(company.getId()));
        pp.setObject("sysParams", (Object)this.loadSystemParams(ctx, company.getId().toString()));
        pp.setObject("defaultParam", this.getDefalutQuerySolution(ctx, company.getId()));
        return pp;
    }

    protected RptParams _query(Context ctx, RptParams params) throws EASBizException, BOSException {
        boolean showOnlySubAccountview = true;
        if (params.getObjectElement("jcbShowOnlySubAccountview.value") != null) {
            showOnlySubAccountview = (Boolean)params.getObjectElement("jcbShowOnlySubAccountview.value");
        }
        RptParams rpt = new RptParams();
        if (params.getString("SQL") != null) {
            RptRowSet rs = this.executeQuery(params.getString("SQL").toString(), null, ctx);
            rpt.setObject("rs", (Object)rs);
            return rpt;
        }
        boolean isAsstactRow = params.getBoolean("isAsstactRow");
        boolean isSumByAsstactLevel = false;
        if (!isAsstactRow && params.getObjectElement("sumByAsstactLevel.value") != null) {
            isSumByAsstactLevel = (Boolean)params.getObjectElement("sumByAsstactLevel.value");
        }
        boolean isExpend = params.getBoolean("isExpend");
        String whereSQLStr = params.getString("whereSQL");
        int yearTo = (Integer)params.getObjectElement("jspYearTo.value");
        int periodTo = (Integer)params.getObjectElement("jspPeriodTo.value");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        try {
            AccountRefContrastInfo ar = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(company.getId().toString(), company.getAccountTable().getId().toString(), yearTo, periodTo);
            if (ar != null) {
                PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (int)yearTo, (int)periodTo, (CompanyOrgUnitInfo)company);
                this.accountTable = period != null && RptClientUtil.periodCheckForAccountRefContrast(ar, yearTo, periodTo) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (this.accountTable == null) {
            this.accountTable = company.getAccountTable();
        }
        if (((Boolean)params.getObjectElement("chkNotIncluePLVoucher.value")).booleanValue()) {
            this.createPLVoucherTempTable(ctx, params);
        }
        if (whereSQLStr == null || params.getString("tempTable") == null) {
            PeriodInfo currentPeriod = GlUtils.getCurrentPeriod(ctx, company.getId().toString());
            int currentYear = currentPeriod.getPeriodYear();
            int currentNumber = currentPeriod.getPeriodNumber();
            int pYearForm = (Integer)params.getObjectElement("jspYearFrom.value");
            int periodNumberFrom = (Integer)params.getObjectElement("jspPeriodFrom.value");
            if (currentYear < pYearForm || currentYear == pYearForm && currentNumber < periodNumberFrom) {
                try {
                    RptParams nParams = (RptParams)params.clone();
                    nParams.setObjectElement("jspYearFrom.value", (Object)currentYear);
                    nParams.setObjectElement("jspYearTo.value", (Object)pYearForm);
                    nParams.setObjectElement("jspPeriodFrom.value", (Object)currentNumber);
                    nParams.setObjectElement("jspPeriodTo.value", (Object)(periodNumberFrom - 1));
                    this.queryPeriodBalance(ctx, nParams, rpt, false);
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            this.queryPeriodBalance(ctx, params, rpt, true);
        } else {
            rpt.setString("tempTable", params.getString("tempTable"));
        }
        List list = (List)params.getObject("actList");
        StringBuffer rsOrderSQL = new StringBuffer();
        StringBuffer whereSQL = new StringBuffer();
        StringBuffer rsHeadOrderSQL = new StringBuffer();
        StringBuffer rsHeadSelectSQL = new StringBuffer();
        if (isAsstactRow) {
            rsOrderSQL.append(" order by FAccountNumber ");
        } else {
            rsHeadSelectSQL.append(" select distinct FAccountId,FAccountNumber,FAccountName ");
            rsHeadOrderSQL.append(" order by FAccountNumber ");
        }
        for (int i = 0; i < list.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            String tab = at.getHgAttribute();
            if (rsOrderSQL.length() == 0) {
                rsOrderSQL.append(" order by ");
            } else {
                rsOrderSQL.append(",");
            }
            rsOrderSQL.append(tab).append("Number");
            if (!isAsstactRow) continue;
            if (rsHeadSelectSQL.length() == 0) {
                rsHeadSelectSQL.append(" select distinct ");
            } else {
                rsHeadSelectSQL.append(",");
            }
            rsHeadSelectSQL.append(tab).append("Id,");
            rsHeadSelectSQL.append(tab).append("Number,");
            rsHeadSelectSQL.append(tab).append("Name ");
            if (rsHeadOrderSQL.length() == 0) {
                rsHeadOrderSQL.append(" order by ");
            } else {
                rsHeadOrderSQL.append(",");
            }
            rsHeadOrderSQL.append(tab).append("Number");
        }
        if (!isAsstactRow) {
            rsOrderSQL.append(",FAccountNumber");
        }
        int levelFrom = (Integer)params.getObjectElement("jspLevelFrom.value");
        int levelTo = (Integer)params.getObjectElement("jspLevelTo.value");
        if (showOnlySubAccountview) {
            if (whereSQL.length() == 0) {
                whereSQL.append(" where ");
            } else {
                whereSQL.append(" and ");
            }
            whereSQL.append(" FAccountIsLeaf = 1");
        } else {
            if (whereSQL.length() == 0) {
                whereSQL.append(" where ");
            } else {
                whereSQL.append(" and ");
            }
            whereSQL.append(" ((FAccountLevel >= " + levelFrom + " and FAccountLevel <= " + levelTo + ") or FAccountLevel = 0)");
        }
        if (!isSumByAsstactLevel && !isExpend) {
            if (whereSQL.length() == 0) {
                whereSQL.append(" where ");
            } else {
                whereSQL.append(" and ");
            }
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(list.size() - 1);
            whereSQL.append(at.getHgAttribute()).append("Id != 'asstActTotal'");
        }
        if (whereSQLStr != null && whereSQLStr.trim().length() > 0) {
            if (whereSQL.length() == 0) {
                whereSQL.append(" where ");
            } else {
                whereSQL.append(" and ");
            }
            whereSQL.append(whereSQLStr);
        }
        RptRowSet rs = this.executeQuery("select * from " + rpt.getString("tempTable") + whereSQL.toString() + rsOrderSQL.toString(), null, ctx);
        rpt.setObject("rs", (Object)rs);
        if (!isExpend || isAsstactRow) {
            rs = this.executeQuery(rsHeadSelectSQL.toString() + " from " + rpt.getString("tempTable") + whereSQL.toString() + rsHeadOrderSQL.toString(), null, ctx);
            rpt.setObject("headRs", (Object)rs);
        }
        if (this.plVoucherTempTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(this.plVoucherTempTable);
        }
        return rpt;
    }

    private void dealBalanceDirect(Context ctx, String tempTable) throws BOSException {
        StringBuffer directSQL = new StringBuffer();
        directSQL.append(" update ").append(tempTable);
        directSQL.append(" set FAccountDC = (case when isnull(FBeginBalanceFor,0) <> 0 then (case when FBeginBalanceFor > 0 then 1 else -1 end)");
        directSQL.append(" else (case when isnull(FEndBalanceFor,0) <> 0 then (case when FEndBalanceFor > 0 then 1 else -1 end) ");
        directSQL.append(" else 0 end) end) where FAccountID = 'total' ");
        DbUtil.execute((Context)ctx, (String)directSQL.toString());
        StringBuffer zeroBalanceDirect = new StringBuffer();
        zeroBalanceDirect.append(" update ").append(tempTable);
        zeroBalanceDirect.append(" set FAccountDC = 2 \r\n");
        zeroBalanceDirect.append(" where Fbeginbalancefor = 0 and fdebitfor = 0 and fcreditfor = 0 and fyeardebitfor = 0 and fyearcreditfor = 0 and fendbalancefor = 0 ");
        DbUtil.execute((Context)ctx, (String)zeroBalanceDirect.toString());
    }

    private void appendJoinFilterSql(Context ctx, StringBuffer sql, SqlParams sp, RptParams params, boolean isBalance, boolean isUnit) throws BOSException, EASBizException {
        String currencyId;
        String accountFrom = (String)params.getObjectElement("jebAccountFrom.value.number");
        String accountTo = (String)params.getObjectElement("jebAccountTo.value.number");
        HashSet hashAccountIdSet = (HashSet)params.getObjectElement("hashAccountIdSet");
        boolean isAccAccount = (Boolean)params.getObjectElement("jsbInAccAccount.value");
        boolean isCostAccount = (Boolean)params.getObjectElement("jsbInCostAccount.value");
        int yearFrom = (Integer)params.getObjectElement("jspYearFrom.value");
        int yearTo = (Integer)params.getObjectElement("jspYearTo.value");
        int periodFrom = (Integer)params.getObjectElement("jspPeriodFrom.value");
        int periodTo = (Integer)params.getObjectElement("jspPeriodTo.value");
        CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String companyId = company.getId().toString();
        sql.append("\n inner join T_BD_AccountView AV on AV.FID=GL.FAccountID ");
        sql.append("\n and AV.FCompanyID = ?  and AV.fisProfitCenter <> 1 ");
        sp.addString(companyId);
        sql.append(" and AV.FAccountTableid=?");
        sp.addString(this.accountTable.getId().toString());
        if (isAccAccount) {
            sql.append(" and AV.FAC = 1");
        }
        if (isCostAccount) {
            sql.append(" and AV.FPLType >= ").append(1);
        }
        if (hashAccountIdSet == null || hashAccountIdSet.isEmpty()) {
            if (accountFrom != null) {
                sql.append(" and AV.FNumber>=?");
                sp.addString(accountFrom);
            }
            if (accountTo != null) {
                sql.append(" and AV.FNumber<=?");
                sp.addString(accountTo + 'z');
            }
        } else {
            sql.append(" and av.fid in ").append(GLRptDaoUtil.set2String(hashAccountIdSet));
        }
        if (params.getObjectElement("jbxCurrency.value.id") != null && !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId = params.getObjectElement("jbxCurrency.value.id").toString()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" and GL.FCurrencyID=? ");
            sp.addString(currencyId);
        }
        sql.append("  and GL.FOrgUnitId=?");
        sp.addString(companyId);
        sql.append("\n and GL.FPeriod in " + SQLUtil.buildPeriodNumbersInSql(yearFrom, periodFrom, yearTo, periodTo) + " ");
        String userId = params.getString("userId");
        sql.append("\n").append(RptServerUtil.innerJoinAccountPermissionSql("AV", userId, companyId, ctx));
    }

    protected String getActLongNumber(AsstactTypeEntity at, boolean isFrom) throws BOSException, EASBizException {
        DataBaseInfo obj = (DataBaseInfo)(isFrom ? at.getFrom() : at.getTo());
        if (at.isGeneralActType()) {
            return obj.get("longnumber").toString();
        }
        return obj.get("number").toString();
    }

    /*
     * Unable to fully structure code
     */
    private void queryPeriodBalance(Context ctx, RptParams params, RptParams rpt, boolean isAccountLevelSum) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        company = (CompanyOrgUnitInfo)params.getObject("company");
        company.setAccountTable(this.accountTable);
        sysParams = this.loadSystemParams(ctx, company.getId().toString());
        accountField = "AV.FName_" + this.getLoc(ctx);
        if (sysParams.getBoolean("GL_012")) {
            accountField = "AV.FLongName_" + this.getLoc(ctx);
        }
        isGeneralShowLongName = sysParams.getBoolean("GL_066");
        cuId = params.getString("cuId");
        userId = params.getString("userId");
        includeUnPost = (Boolean)params.getObjectElement("jcbIncludeUnPost.value");
        baltype = includeUnPost != false ? 1 : 5;
        currencyId = null;
        if (params.getObjectElement("jbxCurrency.value.id") != null) {
            currencyId = params.getObjectElement("jbxCurrency.value.id").toString();
        }
        tabName = "";
        selectSQL = new StringBuffer("select AV.FID FAccountId,AV.FNumber FAccountNumber,").append(accountField).append(" FAccountName,AV.FLevel FAccountLevel, AV.FIsLeaf FAccountIsLeaf, AV.FDC FAccountDC, ");
        fromSQL = new StringBuffer(" from " + GLBalanceUtils.getAssistBalanceTable(baltype, currencyId) + " GL ");
        whereSQL = new StringBuffer();
        groupSQL = new StringBuffer(" group by AV.FID,AV.FNumber,").append(accountField).append(" ,AV.FLevel, AV.FIsLeaf, AV.FDC, ");
        sp = new SqlParams();
        this.appendJoinFilterSql(ctx, fromSQL, sp, params, true, false);
        fromSQL.append("\n inner join t_bd_assistanthg HG on GL.fassistgrpid=HG.fid ");
        whereSp = new SqlParams();
        list = (List)params.getObject("actList");
        accIdList = new ArrayList<String>();
        for (i = 0; i < list.size(); ++i) {
            at = (AsstactTypeEntity)list.get(i);
            tabName = tab = at.getHgAttribute();
            tmpName = "B_" + i;
            accIdList.add(tab + "Id");
            selectSQL.append(tab).append(".FID ").append(tab).append("Id,");
            groupSQL.append(tab).append(".FID, ");
            if (at.isUseLongNumber()) {
                selectSQL.append(" replace(").append(tab).append(".FLongNumber, '!', '.') ");
                groupSQL.append(tab).append(".FLongNumber, ");
            } else {
                selectSQL.append(tab).append(".FNumber ");
                groupSQL.append(tab).append(".FNumber, ");
            }
            selectSQL.append(tab).append("Number,");
            if (at.isUseLongNumber() && isGeneralShowLongName) {
                selectSQL.append("case when ").append(tab).append(".FDisplayName_").append(this.getLoc(ctx)).append(" is not null then ");
                selectSQL.append(tab).append(".FDisplayName_").append(this.getLoc(ctx)).append(" ");
                selectSQL.append("else ").append(tab).append(".FName_").append(this.getLoc(ctx)).append(" end ");
                selectSQL.append(tab).append("Name,");
                groupSQL.append("case when ").append(tab).append(".FDisplayName_").append(this.getLoc(ctx)).append(" is not null then ");
                groupSQL.append(tab).append(".FDisplayName_").append(this.getLoc(ctx)).append(" ");
                groupSQL.append("else ").append(tab).append(".FName_").append(this.getLoc(ctx)).append(" end");
                groupSQL.append(",");
            } else {
                selectSQL.append(tab).append(".FName_").append(this.getLoc(ctx)).append(" ").append(tab).append("Name,");
                groupSQL.append(tab).append(".FName_").append(this.getLoc(ctx)).append(",");
            }
            selectSQL.append(" 1 ").append(tab).append("IsLeaf,");
            fromSQL.append("\n inner join ").append(at.getTableName()).append(" ").append(tab);
            fromSQL.append(" on HG.").append(at.getHgField()).append("=").append(tab).append(".FID");
            if (at.isGeneralActType()) {
                fromSQL.append(" and ").append(tab).append(".FGroupID='").append(at.getGeneralAsstactGroupId()).append("'");
            }
            if (at.getFrom() != null) {
                whereSQL.append(whereSQL.length() != 0 ? " and " : "\n where ");
                if (at.isGeneralActType()) {
                    whereSQL.append(tab).append(".FLongNumber").append(">= ? ");
                } else {
                    whereSQL.append(tab).append(".FNumber").append(">= ? ");
                }
                whereSp.addString(this.getActLongNumber(at, true));
            }
            if (at.getTo() != null) {
                whereSQL.append(whereSQL.length() != 0 ? " and " : "\n where ");
                if (at.isGeneralActType()) {
                    whereSQL.append(tab).append(".FLongNumber").append("<=?");
                } else {
                    whereSQL.append(tab).append(".FNumber").append("<=?");
                }
                whereSp.addString(this.getActLongNumber(at, false));
            }
            if (at.getDist() != null) {
                dist = at.getDist();
                whereSQL.append(whereSQL.length() != 0 ? " and " : "\n where ");
                whereSQL.append(tab).append(".FID").append(" in (");
                if (dist instanceof Set) {
                    obj = null;
                    for (Object obj : (Set)dist) {
                        if (obj instanceof AssistViewFilterInfo) {
                            idSet = ((AssistViewFilterInfo)obj).getIdSet();
                            for (E next : idSet) {
                                whereSp.addString(next.toString());
                            }
                        }
                        whereSQL.append("?,");
                    }
                    whereSQL.deleteCharAt(whereSQL.lastIndexOf(",")).append(")");
                }
            }
            if (!at.isEnabledPermissionLimit()) continue;
            fromSQL.append("\n").append(RptServerUtil.innerJoinAsstactPermissionSql("HG." + at.getHgField(), at.getPermissionItem(), userId, cuId, ctx));
        }
        pYearForm = (Integer)params.getObjectElement("jspYearFrom.value");
        pYearTo = (Integer)params.getObjectElement("jspYearTo.value");
        pNumberFrom = 0;
        pNumberTo = 0;
        pNumberFrNumber = 0;
        pNumberFromNumber = 0;
        pNumberToNumber = 0;
        if (pYearForm != pYearTo) {
            pNumberFrom = (Integer)params.getObjectElement("jspYearTo.value") * 100 + 1;
            pNumberTo = (Integer)params.getObjectElement("jspYearTo.value") * 100 + (Integer)params.getObjectElement("jspPeriodTo.value");
            try {
                prs = DbUtil.executeQuery((Context)ctx, (String)" select pd.FNumber from t_bd_period pd inner join t_org_company cp on cp.faccountperiodid = pd.ftypeid where cp.fid = ? and (pd.fnumber = ? or pd.fnumber = ?) order by pd.fnumber", (Object[])new Object[]{company.getId().toString(), new Integer(pNumberFrom), new Integer(pNumberTo)});
                if (prs.size() == 1) {
                    if (!prs.next()) ** GOTO lbl161
                    pNumberFrNumber = prs.getInt("FNumber");
                }
                if (prs.size() <= 1 || !prs.next()) ** GOTO lbl161
                pNumberFrNumber = prs.getInt("FNumber");
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
        } else {
            pNumberFrom = (Integer)params.getObjectElement("jspYearFrom.value") * 100 + (Integer)params.getObjectElement("jspPeriodFrom.value");
            pNumberTo = (Integer)params.getObjectElement("jspYearTo.value") * 100 + (Integer)params.getObjectElement("jspPeriodTo.value");
            try {
                prs = DbUtil.executeQuery((Context)ctx, (String)" select pd.FNumber from t_bd_period pd inner join t_org_company cp on cp.faccountperiodid = pd.ftypeid where cp.fid = ? and (pd.fnumber = ? or pd.fnumber = ?) order by pd.fnumber", (Object[])new Object[]{company.getId().toString(), new Integer(pNumberFrom), new Integer(pNumberTo)});
                if (prs.size() == 1) {
                    if (prs.next()) {
                        pNumberFrNumber = prs.getInt("FNumber");
                    }
                } else if (prs.size() > 1 && prs.next()) {
                    pNumberFrNumber = prs.getInt("FNumber");
                }
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
        }
lbl161:
        // 6 sources

        try {
            pNumberFrom = (Integer)params.getObjectElement("jspYearFrom.value") * 100 + (Integer)params.getObjectElement("jspPeriodFrom.value");
            pNumberTo = (Integer)params.getObjectElement("jspYearTo.value") * 100 + (Integer)params.getObjectElement("jspPeriodTo.value");
            prs = DbUtil.executeQuery((Context)ctx, (String)" select pd.fnumber from t_bd_period pd inner join t_org_company cp on cp.faccountperiodid = pd.ftypeid where cp.fid = ? and (pd.fnumber = ? or pd.fnumber = ?) order by pd.fnumber", (Object[])new Object[]{company.getId().toString(), new Integer(pNumberFrom), new Integer(pNumberTo)});
            if (prs.size() == 1) {
                if (prs.next()) {
                    pNumberToNumber = pNumberFromNumber = prs.getInt("fnumber");
                }
            } else if (prs.size() > 1) {
                if (prs.next()) {
                    pNumberFromNumber = prs.getInt("fnumber");
                }
                if (prs.next()) {
                    pNumberToNumber = prs.getInt("fnumber");
                }
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        suffix = "For";
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            suffix = "Local";
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            suffix = "Rpt";
        }
        selectSQL.append("sum(case when GL.FPeriod =").append(pNumberFromNumber).append(" then GL.FBeginBalance" + suffix + " else 0 end) FBeginBalanceFor,");
        selectSQL.append("sum(GL.FDebit" + suffix + ") FDebitFor,sum(GL.FCredit" + suffix + ") FCreditFor,");
        selectSQL.append("sum(case when GL.FPeriod =").append(pNumberFrNumber).append(" then GL.FYearDebit" + suffix + "-GL.FDebit" + suffix + " else 0 end) FYearDebitFor,");
        selectSQL.append("sum(case when GL.FPeriod =").append(pNumberFrNumber).append(" then GL.FYearCredit" + suffix + "-GL.FCredit" + suffix + " else 0 end) FYearCreditFor,");
        selectSQL.append("sum(case when TO_INT(GL.FPeriod/100) =").append(pYearTo).append(" then GL.FDebit" + suffix + " else 0 end) FTYearDebitFor,");
        selectSQL.append("sum(case when TO_INT(GL.FPeriod/100) =").append(pYearTo).append(" then GL.FCredit" + suffix + " else 0 end) FTYearCreditFor,");
        selectSQL.append("sum(case when GL.FPeriod =").append(pNumberToNumber).append(" then GL.FEndBalance" + suffix + " else 0 end) FEndBalanceFor ");
        sql = selectSQL.toString() + fromSQL + whereSQL + groupSQL.substring(0, groupSQL.length() - 1);
        sp.addParams(whereSp);
        sourceTempTable = rpt.getString("tempTable");
        dataTypes = RptAccAsstactFacadeControllerBean.getDataTypes(ctx);
        tbl = new StringBuffer();
        tbl.append("FACCOUNTID\tvarchar(44),").append(GLTempTableUtil.getDataType("FACCOUNTNUMBER", dataTypes, "varchar(400)") + ",").append(GLTempTableUtil.getDataType("FACCOUNTNAME", dataTypes, "varchar(255)") + ",");
        tbl.append("FACCOUNTLEVEL\tint,").append("FACCOUNTISLEAF\tint,").append("FACCOUNTDC\tint,");
        asstSelect = new StringBuffer();
        asstIdSelect = new ArrayList<String>();
        for (i = 0; i < list.size(); ++i) {
            at = (AsstactTypeEntity)list.get(i);
            tab = at.getHgAttribute();
            tbl.append(tab).append("ID\tvarchar(44),").append(GLTempTableUtil.getDataType(tab + "NUMBER", dataTypes, "varchar(400)"));
            tbl.append(",").append(GLTempTableUtil.getDataType(tab + "NAME", dataTypes, "varchar(400)")).append(",");
            tbl.append(tab).append("ISLEAF\tint,");
            asstIdSelect.add(tab + "ID");
            asstSelect.append(", balTable.").append(tab).append("ID");
            asstSelect.append(", balTable.").append(tab).append("NUMBER");
            asstSelect.append(", balTable.").append(tab).append("NAME");
            asstSelect.append(", balTable.").append(tab).append("ISLEAF");
        }
        tbl.append("FBEGINBALANCEFOR\tdecimal(28,10),").append("FDEBITFOR\tdecimal(28,10),");
        tbl.append("FCREDITFOR\tdecimal(28,10),").append("FYEARDEBITFOR\tdecimal(28,10),").append("FYEARCREDITFOR\tdecimal(28,10),");
        tbl.append("FTYEARDEBITFOR\tdecimal(28,10),").append("FTYEARCREDITFOR\tdecimal(28,10),").append("FENDBALANCEFOR\tdecimal(28,10)");
        tempTable = GLTempTableUtil.createDBSysTempTable(ctx, tbl.toString());
        rpt.setString("tempTable", tempTable);
        if (isAccountLevelSum && ((Boolean)params.getObjectElement("chkNotIncluePLVoucher.value")).booleanValue()) {
            sql = this.getNotIncludePLVoucherSQL(sql, asstSelect.toString(), list, suffix);
        }
        tempParam = sp.getParams();
        DbUtil.execute((Context)ctx, (String)("INSERT  INTO " + tempTable + "  " + sql), (Object[])tempParam);
        if (StringUtils.isEmpty((String)sourceTempTable)) {
            this.executeUpdate(ctx, " update " + tempTable + " set  FEndBalanceFor = FBeginBalanceFor + FDebitFor - FCreditFor, FYearDebitFor = FYearDebitFor + FTYearDebitFor, FYearCreditFor = FYearCreditFor + FTYearCreditFor ", null);
        } else {
            selectSql = "select 1 from " + tempTable;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            count = 0;
            try {
                rs.last();
                count = rs.getRow();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            currentPeriod = GlUtils.getCurrentPeriod(ctx, company.getId().toString());
            v0 = isNewYear = pYearForm != pYearTo;
            if (count > 0) {
                bBalanceForSql = new StringBuffer();
                yearForStr = isNewYear != false ? "" : ", FYearDebitFor, FYearCreditFor";
                bBalanceForSql.append("select FEndBalanceFor").append(yearForStr).append(" from ").append(sourceTempTable).append(" t ");
                whereSql = new StringBuffer();
                whereSql.append("where t.FAccountId = " + tempTable + ".FAccountId ");
                for (String id : accIdList) {
                    whereSql.append(" and t.").append(id).append(" = ").append(tempTable).append(".").append(id);
                }
                bBalanceForSql.append(whereSql);
                updateSql = " update " + tempTable + " set(FBeginBalanceFor" + yearForStr + ") = (" + bBalanceForSql.toString() + ")";
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
                this.executeUpdate(ctx, " update " + tempTable + " set  FEndBalanceFor = FBeginBalanceFor + FDebitFor - FCreditFor, FYearDebitFor = FYearDebitFor + FTYearDebitFor, FYearCreditFor = FYearCreditFor + FTYearCreditFor ", null);
                updateAccountSql = new StringBuilder();
                updateAccountSql.append(" insert into ").append(tempTable);
                updateAccountSql.append(" SELECT balTable.FAccountID, balTable.FAccountNumber, balTable.FAccountName, balTable.FAccountLevel, balTable.FAccountIsLeaf, balTable.FAccountDC");
                updateAccountSql.append(asstSelect);
                updateAccountSql.append(", balTable.FEndBalanceFor, 0 FDebitFor, 0 FCreditFor");
                if (isNewYear) {
                    updateAccountSql.append(", 0 FYearDebitFor, 0 FYearCreditFor");
                } else {
                    updateAccountSql.append(", balTable.FYearDebitFor, balTable.FYearCreditFor");
                }
                updateAccountSql.append(", 0 FTYearDebitFor, 0 FTYearCreditFor, balTable.FEndBalanceFor");
                updateAccountSql.append(" from ").append(sourceTempTable).append(" balTable ");
                updateAccountSql.append(" where not exists (SELECT 1 from ").append(tempTable).append(" t where balTable.faccountid = t.faccountid");
                idFilterSQL = new StringBuffer();
                for (i = 0; i < asstIdSelect.size(); ++i) {
                    asstId = (String)asstIdSelect.get(i);
                    updateAccountSql.append(" and balTable.").append(asstId).append(" = t.").append(asstId);
                    idFilterSQL.append(" and balTable.").append(asstId).append(" <> 'total'");
                }
                updateAccountSql.append(" ) and balTable.FAccountID <> 'total'").append(idFilterSQL);
                DbUtil.execute((Context)ctx, (String)updateAccountSql.toString());
            } else {
                inSql = new StringBuffer();
                inSql.append("insert into ").append(tempTable);
                inSql.append(" select * from ").append(sourceTempTable);
                inSql.append(" where FAccountID <> 'total'");
                for (i = 0; i < asstIdSelect.size(); ++i) {
                    asstId = (String)asstIdSelect.get(i);
                    inSql.append(" and ").append(asstId).append(" <> 'total'");
                }
                DbUtil.execute((Context)ctx, (String)inSql.toString());
                yearForStr = isNewYear != false ? ", FYearDebitFor = 0, FYearCreditFor = 0" : "";
                updateSql = "update " + tempTable + " set FBeginBalanceFor = FEndBalanceFor, FDebitFor = 0, FCreditFor = 0" + yearForStr;
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
        }
        if (isAccountLevelSum) {
            filterSql = "";
            noDisplayZero = (Boolean)params.getObjectElement("jcbNoDisplayZero.value");
            noDisplayAllZero = (Boolean)params.getObjectElement("jcbNoDisplayAllZero.value");
            opBalanceZero = (Boolean)params.getObjectElement("chkOpBalanceZero.value");
            if (noDisplayAllZero) {
                filterSql = "delete from " + tempTable + " where FDebitFor = 0 and FCreditFor = 0 and FEndBalanceFor = 0";
            } else if (noDisplayZero) {
                filterSql = "delete from " + tempTable + " where FDebitFor = 0 and FCreditFor = 0";
            } else if (opBalanceZero) {
                filterSql = "delete from " + tempTable + " where FEndBalanceFor = 0";
            }
            if (filterSql.length() > 0) {
                DbUtil.execute((Context)ctx, (String)filterSql);
            }
        }
        sumAccSelectSQL = new StringBuffer(" select AV.FID FAccountId,AV.FNumber FAccountNumber,").append(accountField).append(" FAccountName,AV.FLevel FAccountLevel, AV.FIsLeaf FAccountIsLeaf ,AV.FDC FAccountDC ");
        sumAsstSelectSQL = new StringBuffer(" select FAccountId,FAccountNumber, FAccountName,FAccountLevel, FAccountIsLeaf,FAccountDC ");
        sumAccGroupSQL = new StringBuffer(" group by AV.FID,AV.FNumber,").append(accountField).append(",AV.FLevel,AV.FIsLeaf,AV.FDC ");
        sumAsstGroupSQL = new StringBuffer(" group by FAccountId,FAccountNumber, FAccountName,FAccountLevel, FAccountIsLeaf,FAccountDC ");
        sumAsstWhereSQL = new StringBuffer();
        for (i = 0; i < list.size(); ++i) {
            sumAllAsstSelectSQL = new StringBuffer();
            at = (AsstactTypeEntity)list.get(i);
            tab = at.getHgAttribute();
            sumAccSelectSQL.append(",").append(tab).append("Id ");
            sumAccSelectSQL.append(",").append(tab).append("Number ");
            sumAccSelectSQL.append(",").append(tab).append("Name ");
            sumAccSelectSQL.append(",").append(tab).append("IsLeaf ");
            sumAsstSelectSQL.append(",").append(tab).append("Id ");
            sumAsstSelectSQL.append(",").append(tab).append("Number ");
            sumAsstSelectSQL.append(",").append(tab).append("Name ");
            sumAsstSelectSQL.append(",").append(tab).append("IsLeaf ");
            sumAccGroupSQL.append(",").append(tab).append("Id ");
            sumAccGroupSQL.append(",").append(tab).append("Number ");
            sumAccGroupSQL.append(",").append(tab).append("Name ");
            sumAccGroupSQL.append(",").append(tab).append("IsLeaf ");
            sumAsstGroupSQL.append(",").append(tab).append("Id ");
            sumAsstGroupSQL.append(",").append(tab).append("Number ");
            sumAsstGroupSQL.append(",").append(tab).append("Name ");
            sumAsstGroupSQL.append(",").append(tab).append("IsLeaf");
            sumAllAsstSelectSQL.append(sumAsstSelectSQL);
            sumRes = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1075_XiaoJi", (Locale)ctx.getOriginLocale());
            if (i + 1 >= list.size()) continue;
            for (j = i + 1; j < list.size(); ++j) {
                at = (AsstactTypeEntity)list.get(j);
                tab = at.getHgAttribute();
                sumAllAsstSelectSQL.append(",'asstActTotal' ").append(tab).append("Id ");
                sumAllAsstSelectSQL.append(",N'").append(GlUtils.getMaxChar(ctx)).append("' ").append(tab).append("Number ");
                sumAllAsstSelectSQL.append(",N'" + sumRes + "' ").append(tab).append("Name ");
                sumAllAsstSelectSQL.append(",0 ").append(tab).append("IsLeaf ");
                if (sumAsstWhereSQL.length() == 0) {
                    sumAsstWhereSQL.append(" where ");
                } else {
                    sumAsstWhereSQL.append(" and ");
                }
                sumAsstWhereSQL.append(tab).append("IsLeaf = 1");
            }
            DbUtil.execute((Context)ctx, (String)("insert into " + tempTable + sumAllAsstSelectSQL.toString() + " ,sum(FBeginBalanceFor) FBeginBalanceFor,sum(FDebitFor) FDebitFor,sum(FCreditFor) FCreditFor,sum(FYearDebitFor) FYearDebitFor,sum(FYearCreditFor) FYearCreditFor,0,0,sum(FEndBalanceFor) FEndBalanceFor from " + tempTable + sumAsstWhereSQL.toString() + sumAsstGroupSQL.toString()));
        }
        sumAccSelectSQL.append(",sum(FBeginBalanceFor) FBeginBalanceFor,sum(FDebitFor) FDebitFor,sum(FCreditFor) FCreditFor,sum(FYearDebitFor) FYearDebitFor,sum(FYearCreditFor) FYearCreditFor,0,0,sum(FEndBalanceFor) FEndBalanceFor ");
        showOnlySubAccountview = (Boolean)params.getObjectElement("jcbShowOnlySubAccountview.value");
        if (isAccountLevelSum && !showOnlySubAccountview) {
            rs = DbUtil.executeQuery((Context)ctx, (String)("select max(FAccountLevel) maxLevel from " + tempTable));
            maxLevel = 1;
            try {
                if (rs.next()) {
                    maxLevel = rs.getInt("maxLevel");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            for (level = maxLevel; level > 1; --level) {
                DbUtil.execute((Context)ctx, (String)("insert into " + tempTable + sumAccSelectSQL.toString() + " from " + tempTable + " t inner join t_bd_accountview lav on lav.FID = t.FAccountId inner join t_bd_accountview AV on AV.FID = lav.FParentID  where t.FAccountLevel = ? and lav.fisProfitCenter <> 1 " + sumAccGroupSQL.toString()), (Object[])new Object[]{level});
            }
        }
        sumAsstSelectSQL = new StringBuffer(" select FAccountId,FAccountNumber, FAccountName,FAccountLevel, FAccountIsLeaf,FAccountDC ");
        sumAsstGroupSQL = new StringBuffer(" group by FAccountId,FAccountNumber, FAccountName,FAccountLevel, FAccountIsLeaf,FAccountDC ");
        sumAsstWhereSQL = new StringBuffer();
        sumRes = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"480_GLAcctCussentGeneralFacadeControllerBean", (Locale)ctx.getOriginLocale());
        for (i = 0; i < list.size(); ++i) {
            at = (AsstactTypeEntity)list.get(i);
            tab = at.getHgAttribute();
            sumAsstSelectSQL.append(",'total' ");
            sumAsstSelectSQL.append(",N'").append(GlUtils.getMaxChar(ctx)).append("' ");
            sumAsstSelectSQL.append(",N'" + sumRes + "' ");
            sumAsstSelectSQL.append(",1 ");
            if (sumAsstWhereSQL.length() == 0) {
                sumAsstWhereSQL.append(" where ");
            } else {
                sumAsstWhereSQL.append(" and ");
            }
            sumAsstWhereSQL.append(tab).append("IsLeaf = 1");
        }
        sumAsstSelectSQL.append(",sum(FBeginBalanceFor) FBeginBalanceFor,sum(FDebitFor) FDebitFor,sum(FCreditFor) FCreditFor,sum(FYearDebitFor) FYearDebitFor,sum(FYearCreditFor) FYearCreditFor,0,0,sum(FEndBalanceFor) FEndBalanceFor ");
        DbUtil.execute((Context)ctx, (String)("insert into " + tempTable + sumAsstSelectSQL.toString() + " from " + tempTable + sumAsstWhereSQL.toString() + sumAsstGroupSQL.toString()));
        levelFrom = (Integer)params.getObjectElement("jspLevelFrom.value");
        levelTo = (Integer)params.getObjectElement("jspLevelTo.value");
        sumAccSelectSQL = new StringBuffer(" select 'total',N'").append(GlUtils.getMaxChar(ctx)).append("',N'" + sumRes + "' ,0 , 1  ,1 ");
        sumAccGroupSQL = new StringBuffer();
        for (i = 0; i < list.size(); ++i) {
            at = (AsstactTypeEntity)list.get(i);
            tab = at.getHgAttribute();
            sumAccSelectSQL.append(",").append(tab).append("Id ");
            sumAccSelectSQL.append(",").append(tab).append("Number ");
            sumAccSelectSQL.append(",").append(tab).append("Name ");
            sumAccSelectSQL.append(",").append(tab).append("IsLeaf ");
            if (sumAccGroupSQL.length() > 0) {
                sumAccGroupSQL.append(",");
            } else {
                sumAccGroupSQL.append(" group by ");
            }
            sumAccGroupSQL.append(tab).append("Id ");
            sumAccGroupSQL.append(",").append(tab).append("Number ");
            sumAccGroupSQL.append(",").append(tab).append("Name ");
            sumAccGroupSQL.append(",").append(tab).append("IsLeaf ");
        }
        sumAccSelectSQL.append(",sum(FBeginBalanceFor) FBeginBalanceFor,sum(FDebitFor) FDebitFor,sum(FCreditFor) FCreditFor,sum(FYearDebitFor) FYearDebitFor,sum(FYearCreditFor) FYearCreditFor,0,0,sum(FEndBalanceFor) FEndBalanceFor ");
        resultSql = new StringBuffer();
        resultSql.append("insert into ").append(tempTable).append(sumAccSelectSQL.toString()).append(" from ").append(tempTable).append(" where ");
        if (showOnlySubAccountview) {
            resultSql.append(" FAccountIsLeaf = 1 ");
        } else {
            resultSql.append(" FAccountLevel = ").append(levelFrom);
        }
        resultSql.append(sumAccGroupSQL);
        DbUtil.execute((Context)ctx, (String)resultSql.toString());
        if (isAccountLevelSum) {
            this.dealBalanceDirect(ctx, tempTable);
        }
    }

    private Object getDefalutQuerySolution(Context ctx, BOSUuid companyID) throws EASBizException, BOSException {
        RptParams defaultPm = null;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getLocalInstance((Context)ctx);
        String uiName = "com.kingdee.eas.fi.gl.client.RptAccAsstactUI";
        String queryName = "com.kingdee.eas.framework.report.app.CommRptEmptyQuery";
        String currUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (iQuery.hasDefaultSolution(uiName, queryName, companyID.toString(), currUserID)) {
            QuerySolutionInfo solution;
            QueryPanelCollection queryPanels;
            EntityViewInfo ev = (EntityViewInfo)iQuery.getDefaultFilterInfo(uiName, queryName, companyID.toString(), currUserID);
            if (ev == null) {
                ev = new EntityViewInfo();
            }
            if (ev.getFilter() == null) {
                ev.setFilter(new FilterInfo());
            }
            if ((queryPanels = (solution = iQuery.getDefaultSolution(uiName, queryName, companyID.toString(), currUserID)).getQueryPanelInfo()) == null) {
                return null;
            }
            QueryPanelInfo queryPanel = null;
            int size = queryPanels.size();
            for (int i = 0; i < size; ++i) {
                if (queryPanels.get(i).getQueryPanelType() != QueryPanelTypeEnum.CUSTOMER_PANEL) continue;
                queryPanel = queryPanels.get(i);
                break;
            }
            if (queryPanel != null && queryPanel.getCustomerParams() != null) {
                try {
                    String pm;
                    String strParam = queryPanel.getCustomerParams();
                    if (strParam != null && (pm = this.TransStrToCustParams(ctx, strParam)) != null) {
                        byte[] bytes = Base64Encoder.base64ToByteArray((String)pm);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        defaultPm = (RptParams)objectInputStream.readObject();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        return defaultPm;
    }

    private RptParams loadSystemParams(Context ctx, String companyId) throws BOSException, EASBizException {
        String[] paramList = new String[]{"GL_004", "GL_006", "GL_064", "GL_066", "GL_053", "GL_012", "GL_008", "G001"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyId);
        return RptParams.parseFrom((Map)glParam.getParamMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String TransStrToCustParams(Context ctx, String customerParams) {
        HashMap hm = new HashMap();
        StringReader in = null;
        try {
            in = new StringReader(customerParams);
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build((Reader)in);
            Element root = doc.getRootElement();
            List properties = root.getChildren();
            hm = this.readFromXml(hm, properties);
        }
        catch (Exception e) {
            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"885_RptAsstActCrossFacadeControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException e) {
                    logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"885_RptAsstActCrossFacadeControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
                }
            }
        }
        return (String)hm.get("RPTPARAMS_KEY_AT_CUSTOMERPARAMS");
    }

    private HashMap readFromXml(HashMap hm, List properties) {
        XMLBean xml = null;
        Element property = null;
        for (int i = 0; i < properties.size(); ++i) {
            xml = new XMLBean();
            property = (Element)properties.get(i);
            xml.setName(property.getChild("name").getText());
            if (property.getChild("value") == null && property.getChild("properties") != null) {
                Element rootElement = property.getChild("properties");
                HashMap map = this.readFromXml(hm, rootElement.getChildren());
                hm.put(xml.getName(), map);
                continue;
            }
            if (property.getChild("value") == null) continue;
            xml.setValue(property.getChild("value").getText());
            hm.put(xml.getName(), xml.getValue());
        }
        return hm;
    }

    protected void createPLVoucherTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String hgFilter;
        String caaIds;
        StringBuffer struct = new StringBuffer();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        String currencyId = null;
        if (params.getObjectElement("jbxCurrency.value.id") != null) {
            currencyId = params.getObjectElement("jbxCurrency.value.id").toString();
        }
        String suffix = "For";
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            suffix = "Local";
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            suffix = "Rpt";
        }
        StringBuffer selectSQL = new StringBuffer();
        StringBuffer joinSQL = new StringBuffer();
        StringBuffer groupSQL = new StringBuffer();
        struct.append("accountid varchar(44)");
        List actList = (List)params.getObject("actList");
        for (int i = 0; i < actList.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i);
            String tab = at.getHgAttribute();
            struct.append(",").append(tab).append("Id varchar(44)");
            selectSQL.append(",").append(tab).append(".FID ").append(tab).append("ID");
            groupSQL.append(",").append(tab).append(".FID ");
            joinSQL.append(" inner join ").append(at.getTableName()).append(" ").append(tab);
            joinSQL.append(" on HG.").append(at.getHgField()).append(" = ").append(tab).append(".FID");
            if (!at.isGeneralActType()) continue;
            joinSQL.append(" and ").append(tab).append(".FGroupID='").append(at.getGeneralAsstactGroupId()).append("'");
        }
        struct.append(",debit").append(suffix).append(" NUMERIC(28,10)");
        struct.append(",credit").append(suffix).append(" NUMERIC(28,10)");
        struct.append(",yeardebit").append(suffix).append(" NUMERIC(28,10)");
        struct.append(",yearcredit").append(suffix).append(" NUMERIC(28,10)");
        StringBuffer indexStr = new StringBuffer();
        indexStr.append("accountid");
        this.plVoucherTempTable = GLTempTableUtil.createDBSysTempTable(ctx, struct.toString(), indexStr.toString());
        int pYearForm = (Integer)params.getObjectElement("jspYearFrom.value");
        int pNumberFrom = (Integer)params.getObjectElement("jspPeriodFrom.value");
        int pYearTo = (Integer)params.getObjectElement("jspYearTo.value");
        int pNumberTo = (Integer)params.getObjectElement("jspPeriodTo.value");
        int startPeriod = pYearForm * 100 + pNumberFrom;
        int endPeriod = pYearTo * 100 + pNumberTo;
        StringBuffer sql = new StringBuffer("select ");
        sql.append("ve.faccountid accountid");
        sql.append(selectSQL);
        if ("For".equals(suffix)) {
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FOriginalAmount else 0 end) debitfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FOriginalAmount else 0 end) creditfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(pYearTo).append(" then vr.FOriginalAmount else 0 end) yeardebitfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(pYearTo).append(" then vr.FOriginalAmount else 0 end) yearcreditfor ");
        } else if ("Local".equals(suffix)) {
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FLocalAmount else 0 end) debitlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FLocalAmount else 0 end) creditlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(pYearTo).append(" then vr.FLocalAmount else 0 end) yeardebitlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(pYearTo).append(" then vr.FLocalAmount else 0 end) yearcreditlocal ");
        } else {
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FReportingAmount else 0 end) debitrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FReportingAmount else 0 end) creditrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(pYearTo).append(" then vr.FReportingAmount else 0 end) yeardebitrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(pYearTo).append(" then vr.FReportingAmount else 0 end) yearcreditrpt ");
        }
        sql.append(" from t_gl_voucher v ");
        sql.append(" inner join t_gl_voucherentry ve on ve.fbillid = v.fid ");
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid ");
        sql.append(" inner JOIN T_GL_VoucherAssistRecord vr ON ve.FID = vr.FEntryID ");
        ArrayList<String> sp = new ArrayList<String>();
        sql.append(" inner join t_bd_period pd on pd.fid = v.fperiodid ");
        sql.append(" inner join t_bd_assistanthg hg on hg.fid = vr.FAssGrpId ");
        sql.append(joinSQL);
        boolean includeUnPost = (Boolean)params.getObjectElement("jcbIncludeUnPost.value");
        sql.append(" where v.fbizstatus ").append(includeUnPost ? " in (1,3,5)" : "=5");
        sql.append(" and fsourcetype = ").append(1);
        sql.append(" and v.fcompanyid = ?");
        sp.add(company.getId().toString());
        sql.append(" and av.faccounttableid = ? ");
        sp.add(this.accountTable.getId().toString());
        sql.append(" and av.fcompanyid = ? ");
        sp.add(company.getId().toString());
        String accountFrom = (String)params.getObjectElement("jebAccountFrom.value.number");
        String accountTo = (String)params.getObjectElement("jebAccountTo.value.number");
        if (accountFrom != null) {
            sql.append(" and AV.FNumber >= ? ");
            sp.add(accountFrom);
        }
        if (accountTo != null) {
            sql.append(" and AV.FNumber <= ? ");
            sp.add(accountTo + 'z');
        }
        sql.append(" and pd.fnumber >= ");
        int yearMinPeriod = pYearTo * 100 + 1;
        if (startPeriod < yearMinPeriod) {
            sql.append(startPeriod);
        } else {
            sql.append(yearMinPeriod);
        }
        sql.append(" and pd.fnumber <= ").append(endPeriod);
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" and ve.fcurrencyid = ?");
            sp.add(currencyId);
        }
        if (!StringUtils.isEmpty((String)(caaIds = this.getAsstAccountIds(ctx, actList, company.getId().toString())))) {
            sql.append(" and ve.FCAA IN (").append(caaIds).append(") ");
        }
        if (!StringUtils.isEmpty((String)(hgFilter = this.getHGFilterSQL(ctx, actList)))) {
            sql.append(" and vr.FAssGrpId in (");
            sql.append("select hg.fid from t_bd_assistanthg hg where " + hgFilter);
            sql.append(")");
        }
        sql.append(" group by ve.faccountid ");
        sql.append(groupSQL);
        try {
            DbUtil.execute((Context)ctx, (String)("insert into " + this.plVoucherTempTable + " " + sql), (Object[])sp.toArray());
        }
        catch (Exception e) {
            logger.error((Object)("Execute select into failed.(" + sql + ")"), (Throwable)e);
            throw new BOSException("Error sql: " + sql, (Throwable)e);
        }
    }

    protected String getNotIncludePLVoucherSQL(String sql, String asstSelect, List actList, String suffix) throws BOSException, EASBizException {
        StringBuilder noPLSql = new StringBuilder();
        noPLSql.append(" SELECT balTable.FAccountID, balTable.FAccountNumber, balTable.FAccountName, balTable.FAccountLevel, balTable.FAccountIsLeaf, balTable.FAccountDC");
        noPLSql.append(asstSelect);
        noPLSql.append(", balTable.FBeginBalanceFor");
        noPLSql.append(", balTable.FDebitFor").append(" - isnull(plBalTable.Debit").append(suffix).append(",0) FDebitFor");
        noPLSql.append(", balTable.FCreditFor").append(" - isnull(plBalTable.Credit").append(suffix).append(",0) FCreditFor");
        noPLSql.append(", balTable.FYearDebitFor FYearDebitFor");
        noPLSql.append(", balTable.FYearCreditFor FYearCreditFor");
        noPLSql.append(", balTable.FTYearDebitFor").append(" - isnull(plBalTable.YearDebit").append(suffix).append(",0) FTYearDebitFor");
        noPLSql.append(", balTable.FTYearCreditFor").append(" - isnull(plBalTable.YearCredit").append(suffix).append(",0) FTYearCreditFor");
        noPLSql.append(", balTable.FEndBalanceFor").append(" + isnull(plBalTable.Credit").append(suffix).append(",0) - isnull(plBalTable.Debit").append(suffix).append(",0) FEndBalanceFor");
        noPLSql.append(" from (").append(sql).append(") balTable");
        noPLSql.append(" left outer join ").append(this.plVoucherTempTable).append(" plBalTable on balTable.FAccountID = plBalTable.accountID");
        for (int i = 0; i < actList.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i);
            String name = at.getHgAttribute() + "ID";
            noPLSql.append(" and plBalTable.").append(name).append(" = balTable.").append(name);
        }
        return noPLSql.toString();
    }

    public String getAsstAccountIds(Context ctx, List asstActList, String companyId) throws BOSException {
        StringBuffer asstAccountIds = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        Iterator it = asstActList.iterator();
        AsstactTypeEntity at = (AsstactTypeEntity)it.next();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct \n");
        sql.append("  aa.FCAA \n");
        sql.append("from ( \n");
        sql.append("  SELECT av.FCAA FCAA \n");
        sql.append("  from t_bd_accountview av \n");
        sql.append("  where av.FCompanyID = '" + companyId + "' \n");
        sql.append("    and av.FCAA is not null \n");
        sql.append("  union \n");
        sql.append("  select aac.fbeforeid FCAA \n");
        sql.append("  from t_bd_asstAccountChange aac \n");
        sql.append("  join t_bd_accountview av on av.fid = aac.faccountid \n");
        sql.append("  where av.FCompanyID = '" + companyId + "' \n");
        sql.append("  and aac.fbeforeid is not null \n");
        sql.append(") aa \n");
        sql.append("inner join t_bd_asstactgroupdetail det on det.fasstaccountid = aa.fcaa and det.fasstacttypeid = ? \n");
        params.add(at.getId());
        int index = 1;
        while (it.hasNext()) {
            at = (AsstactTypeEntity)it.next();
            sql.append(" inner join t_bd_asstactgroupdetail det").append(index).append(" on det").append(index).append(".fasstaccountid = aa.fcaa and det").append(index).append(".fasstacttypeid = ? ");
            params.add(at.getId());
            ++index;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                if (asstAccountIds.length() > 0) {
                    asstAccountIds.append(", ");
                }
                asstAccountIds.append("'").append(rs.getString("fcaa")).append("'");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return asstAccountIds.toString();
    }

    private String getHGFilterSQL(Context ctx, List asstActList) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        for (AsstactTypeEntity at : asstActList) {
            String fieldHg = "hg." + at.getHgField();
            if (at.getFrom() == null && at.getTo() == null && at.getDist() == null) continue;
            if (sql.length() > 0) {
                sql.append(" and ");
            }
            sql.append(fieldHg).append(" in (");
            sql.append(this.getAssistItemFilterSQL(ctx, at)).append(")");
        }
        return sql.toString();
    }

    private String getAssistItemFilterSQL(Context ctx, AsstactTypeEntity at) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(at.getHgAttribute()).append(".fid from ").append(at.getTableName()).append(" ").append(at.getHgAttribute());
        boolean f = false;
        if (at.isGeneralActType()) {
            sql.append(" where ");
            f = true;
            sql.append(at.getHgAttribute()).append(".FGroupID= '").append(at.getGeneralAsstactGroupId()).append("'");
        }
        Object[] assists = null;
        Object dist = at.getDist();
        if (dist instanceof List) {
            assists = ((List)dist).toArray();
        } else if (dist instanceof Set) {
            assists = ((Set)dist).toArray();
        }
        if (assists != null && assists.length > 0) {
            boolean isGeneralActType;
            sql.append(f ? " AND " : " where ");
            boolean bl = isGeneralActType = at.getHgAttribute() != null && at.getHgAttribute().startsWith("generalAssActType");
            if (isGeneralActType) {
                sql.append(at.getHgAttribute()).append(".").append("flongnumber").append(" in (");
            } else {
                sql.append(at.getHgAttribute()).append(".").append("fnumber").append(" in (");
            }
            Object obj = null;
            String number = null;
            for (int i = 0; i < assists.length; ++i) {
                obj = assists[i];
                number = obj instanceof AssistViewFilterInfo ? ((AssistViewFilterInfo)obj).getNumber() : (obj instanceof Map ? (String)((Map)obj).get("number") : (String)obj);
                if (isGeneralActType && number != null) {
                    number = number.replace(".", "!");
                }
                sql.append("'").append(number).append("', ");
            }
            sql.deleteCharAt(sql.lastIndexOf(",")).append(")");
        } else {
            DataBaseInfo toValue;
            DataBaseInfo fromValue = (DataBaseInfo)at.getFrom();
            if (fromValue != null) {
                DataBaseInfo data;
                boolean useLongNumber;
                if (at.isGeneralActType()) {
                    ObjectUuidPK pk = new ObjectUuidPK(fromValue.getId());
                    fromValue = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getDataBaseInfo((IObjectPK)pk);
                }
                sql.append(f ? " AND " : " where ");
                if (!f) {
                    f = true;
                }
                boolean bl = useLongNumber = at.isUseLongNumber() || at.isUseLevel() && !fromValue.getBoolean("isLeaf");
                if (useLongNumber && fromValue.get("longnumber") == null && (data = this.findAsstActObject(ctx, at.getHgAttribute(), fromValue.getString("id"))) != null) {
                    fromValue = data;
                }
                if (!useLongNumber && fromValue.get("number") == null && (data = this.findAsstActObject(ctx, at.getHgAttribute(), fromValue.getString("id"))) != null) {
                    fromValue = data;
                }
                String fromNumber = this.getActLongNumber(useLongNumber, fromValue);
                sql.append(at.getHgAttribute()).append(".").append(useLongNumber ? "flongnumber" : "fnumber").append(" >= '").append(fromNumber).append("'");
            }
            if ((toValue = (DataBaseInfo)at.getTo()) != null) {
                DataBaseInfo data;
                boolean useLongNumber;
                if (at.isGeneralActType()) {
                    ObjectUuidPK pk = new ObjectUuidPK(toValue.getId());
                    toValue = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getDataBaseInfo((IObjectPK)pk);
                }
                sql.append(f ? " and " : " where ");
                boolean bl = useLongNumber = at.isUseLongNumber() || at.isUseLevel() && !toValue.getBoolean("isLeaf");
                if (useLongNumber && toValue.get("longnumber") == null && (data = this.findAsstActObject(ctx, at.getHgAttribute(), toValue.getString("id"))) != null) {
                    toValue = data;
                }
                if (!useLongNumber && toValue.get("number") == null && (data = this.findAsstActObject(ctx, at.getHgAttribute(), toValue.getString("id"))) != null) {
                    toValue = data;
                }
                String toNumber = this.getActLongNumber(useLongNumber, toValue);
                if (at.isUseLevel() && !"true".equals(toValue.getString("isLeaf")) && toValue.getString("isLeaf") != null) {
                    toNumber = toNumber + "Z";
                }
                sql.append(at.getHgAttribute()).append(".").append(useLongNumber ? "flongnumber" : "fnumber").append(" <= '").append(toNumber).append("'");
            }
        }
        return sql.toString();
    }

    private String getActLongNumber(boolean useLongNumber, Object value) {
        if (value instanceof DataBaseInfo) {
            DataBaseInfo obj = (DataBaseInfo)value;
            if (useLongNumber) {
                return obj.get("longnumber").toString();
            }
            return obj.get("number").toString();
        }
        return value.toString();
    }

    private DataBaseInfo findAsstActObject(Context ctx, String asstHGAttribute, String id) throws BOSException {
        IAssistantHG iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        BOSObjectType type = iAssistantHG.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = loader.getEntity(type);
        PropertyCollection props = eo.getInheritedNoDuplicatedProperties();
        Iterator itr = props.iterator();
        LinkPropertyInfo pi = null;
        DataBaseInfo data = null;
        while (itr.hasNext()) {
            PropertyInfo p = (PropertyInfo)itr.next();
            if (!asstHGAttribute.equalsIgnoreCase(p.getName()) || !(p instanceof LinkPropertyInfo)) continue;
            pi = (LinkPropertyInfo)p;
            break;
        }
        if (pi != null) {
            DataBaseCollection collection;
            EntityObjectInfo eobj = pi.getRelationship().getSupplierObject();
            String strFacotry = eobj.getBusinessImplFactory();
            String strLocal = eobj.getBusinessImplName();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("longnumber"));
            sic.add(new SelectorItemInfo("CU.id"));
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("id", (Object)id);
            view.setFilter(filter);
            String strMethod = "getDataBaseCollection";
            Class[] argTypes = new Class[]{view.getClass()};
            Object[] args = new Object[]{view};
            Object result = null;
            try {
                result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args);
            }
            catch (Exception e) {
                result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args, eobj.getType());
            }
            if (result != null && (collection = (DataBaseCollection)result).size() > 0) {
                data = collection.get(0);
            }
        }
        return data;
    }
}

