/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.AbstractRptAsstactBalanceControllerBean;
import com.kingdee.eas.fi.gl.app.RptBalanceTempBase;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.CellMatrix;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RptAsstactBalanceControllerBean
extends AbstractRptAsstactBalanceControllerBean {
    private static final long serialVersionUID = -5536215909613285250L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.RptAsstactBalanceControllerBean");

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        RptParams pp = new RptParams();
        pp.setObject("pe", (Object)new PeriodEntity(RptServerUtil.getPeriodRange(ctx, company)));
        pp.setObject("currency", (Object)RptServerUtil.getAllCurrency(company.getId().toString(), ctx));
        pp.setObject("maxLevel", (Object)new Integer(RptServerUtil.getMaxAccountLevel(ctx, company.getId().toString())));
        pp.setObject("asstact", (Object)RptServerUtil.queryAsstAct(null, company.getCU().getId().toString(), ctx));
        return pp;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        return null;
    }

    private static String getActLongNumber(AsstactTypeEntity at, boolean isFrom, Context ctx) throws BOSException, EASBizException {
        if (at.getFrom() instanceof DataBaseInfo || at.getTo() instanceof DataBaseInfo) {
            DataBaseInfo obj = (DataBaseInfo)(isFrom ? at.getFrom() : at.getTo());
            if (at.isUseLongNumber()) {
                return obj.get("longNumber").toString();
            }
            return obj.get("number").toString();
        }
        return null;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        SqlParams spNew;
        String strShowLongNameFromGeneral;
        String strAsstActShowLongNumber;
        String asstBalanceTable;
        String loc = this.getLoc(ctx);
        List actList = (List)params.getObject("actList");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        String companyId = company.getId().toString();
        String cuId = params.getString("cuId");
        String userId = params.getString("userId");
        int levelFrom = (Integer)params.getObjectElement("spnLevelFrom.value");
        int levelTo = (Integer)params.getObjectElement("spnLevelTo.value");
        boolean includeNoPost = (Boolean)params.getObjectElement("cbIncludeNoPost.value");
        boolean noDisplayZero = (Boolean)params.getObjectElement("jcbNoDisplayZero.value");
        boolean ckbNoDisplayBalanceZero = (Boolean)params.getObjectElement("ckbNoDisplayBalanceZero.value");
        boolean ckbNoDisplayBalanceZeroUnhappen = (Boolean)params.getObjectElement("ckbNoDisplayBalanceZeroUnhappen.value");
        String actNumberFrom = (String)params.getObjectElement("ktAsstactNumberFrom.value");
        String actNumberTo = (String)params.getObjectElement("ktAsstactNumberTo.value");
        String accountFrom = (String)params.getObjectElement("bpAccountNumberFrom.value.number");
        String accountTo = (String)params.getObjectElement("bpAccountNumberTo.value.number");
        String currencyId = (String)params.getObjectElement("cbCurrency.value.id.toString");
        String baseCurrencyId = params.getString("baseCurrencyId");
        boolean isSumByAcctActType = (Boolean)params.getObjectElement("sumByAsst.value");
        int[] periodRange = new int[]{(Integer)params.getObjectElement("spnPeriodYearFrom.value"), (Integer)params.getObjectElement("spnPeriodNumberFrom.value"), (Integer)params.getObjectElement("spnPeriodYearTo.value"), (Integer)params.getObjectElement("spnPeriodNumberTo.value")};
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company") == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : (CompanyOrgUnitInfo)params.getObject("company")), (Context)ctx);
        int curPeriod = pe.getCurrentYear() * 100 + pe.getCurrentPeriod();
        int periodTo = periodRange[2] * 100 + periodRange[3];
        boolean isAfterPeriod = periodTo > curPeriod;
        String tempTableName = null;
        if (isAfterPeriod) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("companyid", companyId);
            map.put("currencyId", currencyId);
            map.put("accounttableid", company.getAccountTable().getId().toString());
            map.put("periodRange", periodRange);
            map.put("levelFrom", new Integer(levelFrom));
            map.put("levelTo", new Integer(levelTo));
            int balType = includeNoPost ? 1 : 5;
            map.put("balType", new Integer(balType));
            asstBalanceTable = tempTableName = RptBalanceTempBase.buildTempTableData(ctx, map);
        } else {
            asstBalanceTable = "(select tab.*, tp.fnumber tpfnumber, tp.fperiodyear tpfperiodyear, tp.fperiodnumber tpfperiodnumber, tp.ftypeid tpftypeid from t_GL_assistBalance tab INNER JOIN T_BD_Period TP ON TAB.FPeriodID = TP.FID where " + SQLUtil.getPeriodCondition("tp.fperiodyear", "tp.fperiodnumber", periodRange) + ")";
        }
        SqlParams sp = new SqlParams();
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        boolean isAccountShowLongName = false;
        boolean isAsstActShowLongNumber = false;
        boolean isShowLongNameFromGeneral = false;
        paramKeyMap.put("GL_012", companyId);
        paramKeyMap.put("GL_064", null);
        paramKeyMap.put("GL_066", companyId);
        HashMap paramHashMap = iParamControl.getParamHashMap(paramKeyMap);
        String strAccountShowLongName = (String)paramHashMap.get("GL_012");
        if (strAccountShowLongName != null && strAccountShowLongName.trim().length() > 0) {
            isAccountShowLongName = Boolean.valueOf(strAccountShowLongName.trim());
        }
        if ((strAsstActShowLongNumber = (String)paramHashMap.get("GL_064")) != null && strAsstActShowLongNumber.trim().length() > 0) {
            isAsstActShowLongNumber = Boolean.valueOf(strAsstActShowLongNumber.trim());
        }
        if ((strShowLongNameFromGeneral = (String)paramHashMap.get("GL_066")) != null && strShowLongNameFromGeneral.trim().length() > 0) {
            isShowLongNameFromGeneral = Boolean.valueOf(strShowLongNameFromGeneral.trim());
        }
        String accountName = this.getAccountName(companyId, paramKeyMap, isAccountShowLongName);
        StringBuffer sql = new StringBuffer();
        sql.append("select GL.FID, GL.FNumber, GL.FName, GL.FActTypeID, GL.FActTypeName, D.FNumber FAccountNumber, ").append(accountName).append("_").append(loc).append(" FAccountName, C.FName_").append(loc).append(" FCurrencyName, ").append("B.tpFPeriodYear, B.tpFPeriodNumber, ").append("\n sum(D.FDC*B.FBeginBalanceFor-D.FDC*(B.FYearDebitFor-B.FYearCreditFor)+D.FDC*(B.FDebitFor-B.FCreditFor)) FYearBeginBalanceFor,").append("\n sum(D.FDC*B.FBeginBalanceLocal-D.FDC*(B.FYearDebitLocal-B.FYearCreditLocal)+D.FDC*(B.FDebitLocal-B.FCreditLocal)) FYearBeginBalanceLocal,").append("\n sum(D.FDC*B.FBeginBalanceFor) FBeginBalanceFor, ").append("\n sum(D.FDC*B.FBeginBalanceLocal) FBeginBalanceLocal, ").append("\n sum(B.FDebitFor) FDebitFor, sum(B.FDebitLocal) FDebitLocal, sum(B.FCreditFor) FCreditFor, sum(B.FCreditLocal) FCreditLocal, ").append("\n sum(B.FYearDebitFor) FYearDebitFor, ").append("\n sum(B.FYearDebitLocal) FYearDebitLocal, ").append("\n sum(B.FYearCreditFor) FYearCreditFor, ").append("\n sum(B.FYearCreditLocal) FYearCreditLocal, ").append("\n D.FDC, ").append("\n sum(D.FDC*B.FEndBalanceFor) FEndBalanceFor, ").append("\n sum(D.FDC*B.FEndBalanceLocal) FEndBalanceLocal, ").append("\n C.FPrecision ").append("\n from ").append(asstBalanceTable).append(" B ").append("\n inner join t_bd_currency C on C.FID=B.FCurrencyID ");
        if (currencyId == null) {
            sql.append(" and C.FID<>'11111111-1111-1111-1111-111111111111DEB58FDC' and C.FID<>'22222222-2222-2222-2222-222222222222DEB58FDC' ");
        }
        sql.append("\n inner join t_bd_accountView D on D.FID=B.FAccountID and d.fcompanyid = b.FORGUNITID");
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        sql.append("\n").append(RptServerUtil.innerJoinAccountPermissionSql("D", userID, companyID, ctx)).append("\n");
        sql.append("\n inner join \n(\n");
        int n = actList.size();
        for (int i = 0; i < n; ++i) {
            String permission;
            String alis = "T_" + i;
            AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i);
            if (i > 0) {
                sql.append("\n union all \n");
            }
            boolean isGeneralActType = at.getHgAttribute() != null && at.getHgAttribute().startsWith("generalAssActType");
            boolean isUseLongNumber = !isGeneralActType && at.isUseLongNumber() || isGeneralActType && isAsstActShowLongNumber;
            String numberField = isUseLongNumber ? "replace(" + alis + ".FLongNumber,'!','.') FNumber," : alis + ".FNumber,";
            String nameField = alis + ".FName_" + loc;
            if (at.isGeneralActType() && isShowLongNameFromGeneral) {
                nameField = alis + ".FDISPLAYNAME_" + loc;
            }
            sql.append("select HG.FID FAssistGrpId, ").append(alis).append(".FID, ").append(numberField).append(nameField).append(" FName, '").append(at.getId()).append("' FActTypeID, N'").append(at.getName()).append("' FActTypeName ").append("\n from t_bd_assistanthg HG ").append("\n inner join ").append(at.getTableName()).append(" ").append(alis).append(" on ").append(alis).append(".FID=HG.").append(at.getHgField());
            String fromNumber = null;
            String toNumber = null;
            if (at.getFrom() != null) {
                fromNumber = RptAsstactBalanceControllerBean.getActLongNumber(at, true, ctx);
            }
            if (at.getTo() != null) {
                toNumber = RptAsstactBalanceControllerBean.getActLongNumber(at, false, ctx);
            }
            if (at.getGeneralAsstactGroupId() != null) {
                sql.append(" and " + alis + ".fgroupid = ?");
                sp.addString(at.getGeneralAsstactGroupId());
            }
            if (isUseLongNumber) {
                if (!StringUtils.isEmpty((String)fromNumber)) {
                    sql.append(" and " + alis + ".FLongNumber>=?");
                    sp.addString(fromNumber);
                }
                if (!StringUtils.isEmpty((String)toNumber)) {
                    sql.append(" and " + alis + ".FLongNumber<=?");
                    sp.addString(toNumber + 'z');
                }
            } else {
                if (!StringUtils.isEmpty((String)fromNumber)) {
                    sql.append(" and " + alis + ".FNumber>=?");
                    sp.addString(fromNumber);
                }
                if (!StringUtils.isEmpty((String)toNumber)) {
                    sql.append(" and " + alis + ".FNumber<=?");
                    sp.addString(toNumber + 'z');
                }
            }
            if (isUseLongNumber) {
                if (!StringUtils.isEmpty((String)actNumberFrom)) {
                    sql.append(" and replace(" + alis + ".FLongNumber,'!','.')>=?");
                    sp.addString(actNumberFrom);
                }
                if (!StringUtils.isEmpty((String)actNumberTo)) {
                    sql.append(" and replace(" + alis + ".FLongNumber,'!','.')<=?");
                    sp.addString(actNumberTo + 'z');
                }
            } else {
                if (!StringUtils.isEmpty((String)actNumberFrom)) {
                    sql.append(" and " + alis + ".FNumber>=?");
                    sp.addString(actNumberFrom);
                }
                if (!StringUtils.isEmpty((String)actNumberTo)) {
                    sql.append(" and " + alis + ".FNumber<=?");
                    sp.addString(actNumberTo + 'z');
                }
            }
            if (!at.isEnabledPermissionLimit() || (permission = at.getPermissionItem()) == null || permission.trim().length() <= 0) continue;
            sql.append("\n").append(RptServerUtil.innerJoinAsstactPermissionSql("HG." + at.getHgField(), permission, userId, cuId, ctx));
        }
        sql.append("\n) GL on GL.FAssistGrpId=B.FAssistGrpId ");
        sql.append("\n where B.FOrgUnitID=? and B.FBalType=? ");
        if (isAfterPeriod) {
            sql.append("\n and " + this.getPeriodIdInCondition(ctx, companyId, "B.FPeriodId", periodRange) + " \n");
        }
        sp.addString(companyId).addInt(includeNoPost ? 1 : 5);
        if (levelFrom == levelTo) {
            sql.append(" and D.FLevel=?");
            sp.addInt(levelFrom);
        } else {
            sql.append(" and D.FLevel>=? and D.FLevel<=? ");
            sp.addInt(levelFrom).addInt(levelTo);
        }
        if (!StringUtils.isEmpty((String)accountFrom)) {
            sql.append(" and D.FNumber>=?");
            sp.addString(accountFrom);
        }
        if (!StringUtils.isEmpty((String)accountTo)) {
            sql.append(" and D.FNumber<=?");
            sp.addString(accountTo + "Z");
        }
        if (currencyId != null) {
            sql.append("\n and B.FCurrencyID=?");
            sp.addString(currencyId);
        }
        sql.append(" and D.Faccounttableid=? ");
        sp.addString(company.getAccountTable().getId().toString());
        if (isSumByAcctActType) {
            sql.append("\n and ").append(SQLUtil.getPeriodCondition("B.tpFPeriodYear", "B.tpFPeriodNumber", periodRange));
        } else if (periodRange[1] > 1) {
            sql.append("\n and ((").append(SQLUtil.getPeriodCondition("B.tpFPeriodYear", "B.tpFPeriodNumber", periodRange)).append(") or (B.tpFPeriodYear=? and B.tpFPeriodNumber=1))");
            sp.addInt(periodRange[0]);
        } else {
            sql.append("\n and ").append(SQLUtil.getPeriodCondition("B.tpFPeriodYear", "B.tpFPeriodNumber", periodRange));
        }
        sql.append("\n group by GL.FID, GL.FNumber, GL.FName, FActTypeID, GL.FActTypeName, D.FNumber, ").append(accountName).append("_").append(loc).append(", C.FName_").append(loc).append(", ").append("B.tpFPeriodYear, B.tpFPeriodNumber, C.FPrecision , d.fdc ");
        if (periodRange[1] > 1) {
            sql.append("\n having ").append(SQLUtil.getPeriodCondition("tpFPeriodYear", "tpFPeriodNumber", periodRange));
        } else {
            sql.append("\n having 1=1 ");
        }
        sql.append(" and ( \n");
        if (ckbNoDisplayBalanceZero || !noDisplayZero && ckbNoDisplayBalanceZeroUnhappen) {
            sql.append(" ((sum(D.FDC*B.FEndBalanceFor)<>0 or sum(D.FDC*B.FEndBalanceLocal)<>0)) \n");
            if (noDisplayZero) {
                sql.append(" and ");
            } else if (!ckbNoDisplayBalanceZero) {
                sql.append(" or ");
            }
        } else if (!noDisplayZero) {
            sql.append(" 1=1 ");
        }
        if (noDisplayZero || !ckbNoDisplayBalanceZero && ckbNoDisplayBalanceZeroUnhappen) {
            sql.append(" (sum(FDebitLocal)<>0 or sum(FCreditLocal)<>0 ");
            sql.append(" or sum(FDebitFor)<>0 or sum(FCreditFor)<>0 ) \n");
        }
        sql.append(" ) \n");
        sql.append("\n order by FActTypeName, gl.FNumber, FAccountNumber, FName, tpFPeriodYear, tpFPeriodNumber, FCurrencyName ");
        RptRowSet rs = null;
        try {
            rs = this.executeQuery(sql.toString(), sp, from, len, ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tempTableName != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
        }
        RptParams rp = new RptParams();
        rp.setObject("rs", (Object)rs);
        if (isSumByAcctActType) {
            spNew = this.getNewSqlParamsForSum(ctx, periodRange, actList, actNumberFrom, actNumberTo, companyId, includeNoPost, levelFrom, levelTo, accountFrom, accountTo, currencyId, company, isSumByAcctActType);
            RptRowSet sumRsOne = this.getSumByAssctActType(sql.toString(), spNew, from, len, ctx, 1, periodRange, asstBalanceTable, params);
            RptRowSet sumRsTwo = this.getSumByAssctActType(sql.toString(), spNew, from, len, ctx, 2, periodRange, asstBalanceTable, params);
            RptRowSet sumRsThree = this.getSumByAssctActType(sql.toString(), spNew, from, len, ctx, 3, periodRange, asstBalanceTable, params);
            if (sumRsOne != null) {
                rp.setObject("sumRsOne", (Object)sumRsOne);
            }
            if (sumRsTwo != null) {
                rp.setObject("sumRsTwo", (Object)sumRsTwo);
            }
            if (sumRsThree != null) {
                rp.setObject("sumRsThree", (Object)sumRsThree);
            }
        } else {
            spNew = this.getNewSqlParamsForSum(ctx, periodRange, actList, actNumberFrom, actNumberTo, companyId, includeNoPost, levelFrom, levelTo, accountFrom, accountTo, currencyId, company, isSumByAcctActType);
            RptRowSet sumRsThree = this.getSumByAssctActType(sql.toString(), spNew, from, len, ctx, 4, periodRange, asstBalanceTable, params);
            if (sumRsThree != null) {
                rp.setObject("sumRsThree", (Object)sumRsThree);
            }
        }
        if (from == 0) {
            int i;
            int[] hs;
            RptTableHeader head = new RptTableHeader();
            int colCount = 26;
            int[] widths = null;
            widths = new int[]{80, 80, 160, 80, 80, 80, 160, 80, 60, 40, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 30, 80, 80, 80};
            for (int i2 = 0; i2 < colCount; ++i2) {
                RptTableColumn col = new RptTableColumn("A" + i2);
                col.setWidth(widths[i2]);
                head.addColumn(col);
            }
            Object[][] headLabel = new Object[][]{{"FID", GLResUtil.getRes("act_item_number", ctx), GLResUtil.getRes("act_item_name", ctx), "FActTypeID", GLResUtil.getRes("act_item_type", ctx), GLResUtil.getRes("accountView_number", ctx), GLResUtil.getRes("accountView_name", ctx), GLResUtil.getRes("currency", ctx), GLResUtil.getRes("fiscal_year", ctx), GLResUtil.getRes("period", ctx), GLResUtil.getRes("balance_year_begin", ctx), GLResUtil.getRes("balance_year_begin", ctx), GLResUtil.getRes("balance_period_begin", ctx), GLResUtil.getRes("balance_period_begin", ctx), GLResUtil.getRes("dir_debit", ctx), GLResUtil.getRes("dir_debit", ctx), GLResUtil.getRes("dir_credit", ctx), GLResUtil.getRes("dir_credit", ctx), GLResUtil.getRes("debit_year_sum", ctx), GLResUtil.getRes("debit_year_sum", ctx), GLResUtil.getRes("debit_period_sum", ctx), GLResUtil.getRes("debit_period_sum", ctx), GLResUtil.getRes("balance_period_end", ctx), GLResUtil.getRes("balance_period_end", ctx), GLResUtil.getRes("balance_period_end", ctx), GLResUtil.getRes("currency_precision", ctx)}, {"FID", GLResUtil.getRes("act_item_number", ctx), GLResUtil.getRes("act_item_name", ctx), "FActTypeID", GLResUtil.getRes("act_item_type", ctx), GLResUtil.getRes("accountView_number", ctx), GLResUtil.getRes("accountView_name", ctx), GLResUtil.getRes("currency", ctx), GLResUtil.getRes("fiscal_year", ctx), GLResUtil.getRes("period", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("direction", ctx), GLResUtil.getRes("currency_for", ctx), GLResUtil.getRes("currency_local", ctx), GLResUtil.getRes("currency_precision", ctx)}};
            boolean isForeignCurrencySU = false;
            paramKeyMap.put("GL_008", companyId);
            String strForeignCurrencySU = (String)iParamControl.getParamHashMap(paramKeyMap).get("GL_008");
            if (strForeignCurrencySU != null && strForeignCurrencySU.trim().length() > 0) {
                isForeignCurrencySU = Boolean.valueOf(strForeignCurrencySU.trim());
            }
            if (isForeignCurrencySU) {
                hs = new int[]{0, 3, 7, 11, 13, 15, 17, 19, 21, 24, 25};
                headLabel = CellMatrix.removeRows((Object[][])headLabel, (int[])new int[]{1});
            } else if (RptClientUtil.isGeneralLocalCurrency(currencyId) || baseCurrencyId.equals(currencyId)) {
                hs = new int[]{0, 3, 7, 10, 12, 14, 16, 18, 20, 23, 25};
                headLabel = CellMatrix.removeRows((Object[][])headLabel, (int[])new int[]{1});
            } else {
                hs = new int[]{0, 3, 25};
            }
            for (i = 0; i < hs.length; ++i) {
                head.getColumn(hs[i]).setHided(true);
            }
            for (i = 10; i < colCount; ++i) {
                head.getColumn(i).setAligment(2);
            }
            head.getColumn(22).setAligment(1);
            head.setLabels(headLabel, true);
            rp.setObject("head", (Object)head);
        }
        return rp;
    }

    private String getAccountName(String companyId, HashMap paramKeyMap, boolean isAccountShowLongName) throws BOSException, EASBizException {
        String accountName = null;
        accountName = isAccountShowLongName ? "D.FLongName" : "D.FName";
        return accountName;
    }

    private RptRowSet getSumByAssctActType(String sql, SqlParams parameters, int from, int length, Context ctx, int sumType, int[] periodRange, String asstBalanceTable, RptParams params) throws BOSException {
        StringBuffer sqlStaic = new StringBuffer();
        String groupBySql = "group by  FNumber, FName, FActTypeID,FActTypeName, FPrecision,FCurrencyName ";
        String groupBySqlTwo = " group by  FActTypeID,FActTypeName, FPrecision ,FCurrencyName  ";
        String groupBySqlThree = " group by  FPrecision ,FCurrencyName  ";
        String loc = this.getLoc(ctx);
        sqlStaic.append("\n sum(FYearBeginBalanceFor) FYearBeginBalanceFor,");
        sqlStaic.append("\n sum(FYearBeginBalanceLocal) FYearBeginBalanceLocal,");
        sqlStaic.append("\n sum(FBeginBalanceFor) FBeginBalanceFor, ");
        sqlStaic.append("\n sum(FBeginBalanceLocal) FBeginBalanceLocal, ");
        sqlStaic.append("\n sum(FDebitFor) FDebitFor, sum(FDebitLocal) FDebitLocal, sum(FCreditFor) FCreditFor, sum(FCreditLocal) FCreditLocal, ");
        sqlStaic.append("\n sum(FYearDebitFor) FYearDebitFor, ").append("\n sum(FYearDebitLocal) FYearDebitLocal, ");
        sqlStaic.append("\n sum(FYearCreditFor) FYearCreditFor, ").append("\n sum(FYearCreditLocal) FYearCreditLocal, ");
        sqlStaic.append("\n 0 FDC , ");
        sqlStaic.append("\n sum(FEndBalanceFor) FEndBalanceFor, ").append("\n sum(FEndBalanceLocal) FEndBalanceLocal, ");
        sqlStaic.append("\n FPrecision ");
        String joinAndWhereSql = null;
        String groupSql = null;
        StringBuffer sqlNew = new StringBuffer();
        StringBuffer selectSql = new StringBuffer();
        StringBuffer selectSqlForSum = new StringBuffer();
        int begin = sql.indexOf("from " + asstBalanceTable);
        int end = sql.indexOf("group by");
        joinAndWhereSql = sql.substring(begin, end);
        switch (sumType) {
            case 1: {
                groupSql = "  group by  GL.FNumber, GL.FName, FActTypeID, GL.FActTypeName, C.FName_" + loc + ", C.FPrecision ";
                String sumRes = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1075_XiaoJi", (Locale)ctx.getLocale());
                selectSql = selectSql.append(" select TO_CHAR(null) FID, FNumber, FName, FActTypeID, FActTypeName, N'" + sumRes + "' FAccountNumber,  ");
                selectSql.append("TO_CHAR(null) FAccountName,");
                selectSql.append(" FCurrencyName, ").append("TO_INT(null) FPeriodYear, TO_INT(null) FPeriodNumber, ");
                selectSqlForSum.append(" select TO_CHAR(null) FID, GL.FNumber, GL.FName, GL.FActTypeID, GL.FActTypeName, N'" + sumRes + "' FAccountNumber,  ");
                selectSqlForSum.append(" TO_CHAR(null) FAccountName, C.FName_").append(loc);
                selectSqlForSum.append(" FCurrencyName, ").append("TO_INT(null) FPeriodYear, TO_INT(null) FPeriodNumber, ");
                selectSql.append(sqlStaic);
                selectSql.append("\n from ( \n");
                selectSql.append(this.getYearBeginBalanceForSql(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType));
                selectSql.append("\n union all \n");
                selectSql.append(this.getYearFBeginBalanceForSql(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType, params));
                selectSql.append("\n union all \n");
                selectSql.append(this.getFYearDebitAndYearCreditForSql(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType));
                selectSql.append("\n union all \n");
                selectSql.append(this.getFEndBalanceFor(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType));
                selectSql.append("\n union all \n");
                selectSql.append(this.getFDebitAndCreditFor(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType));
                selectSql.append(" ) tmp \n");
                selectSql.append(groupBySql);
                break;
            }
            case 2: {
                groupSql = "  group by   FActTypeID, GL.FActTypeName, C.FName_" + loc + ", C.FPrecision ";
                String totalRes = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1076_HeJi", (Locale)ctx.getLocale());
                selectSqlForSum.append(" select TO_CHAR(null) FID, TO_CHAR(null) FNumber, TO_CHAR(null) FName, GL.FActTypeID, GL.FActTypeName, N'" + totalRes + "' FAccountNumber,  ");
                selectSqlForSum.append(" TO_CHAR(null) FAccountName, C.FName_").append(loc);
                selectSqlForSum.append(" FCurrencyName, ").append("TO_CHAR(null) FPeriodYear, TO_CHAR(null) FPeriodNumber, ");
                selectSql = selectSql.append(" select TO_CHAR(null) FID, TO_CHAR(null) FNumber, TO_CHAR(null) FName, FActTypeID, FActTypeName, N'" + totalRes + "' FAccountNumber,  ");
                selectSql.append(" TO_CHAR(null) FAccountName, ");
                selectSql.append(" FCurrencyName, ").append("TO_INT(null) FPeriodYear, TO_INT(null) FPeriodNumber, ");
                selectSql.append(sqlStaic);
                selectSql.append("\n from ( \n");
                selectSql.append(this.getYearBeginBalanceForSql(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType));
                selectSql.append("\n union all \n");
                selectSql.append(this.getYearFBeginBalanceForSql(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType, params));
                selectSql.append("\n union all \n");
                selectSql.append(this.getFYearDebitAndYearCreditForSql(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType));
                selectSql.append("\n union all \n");
                selectSql.append(this.getFEndBalanceFor(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType));
                selectSql.append("\n union all \n");
                selectSql.append(this.getFDebitAndCreditFor(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType));
                selectSql.append(" ) tmp \n");
                selectSql.append(groupBySqlTwo);
                break;
            }
            case 3: {
                groupSql = "  group by    C.FName_" + loc + ",C.FPrecision ";
                selectSqlForSum.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"331_RptAsstactBalanceControllerBean", (Locale)ctx.getLocale()));
                selectSqlForSum.append(" TO_CHAR(null) FAccountName, C.FName_").append(loc);
                selectSqlForSum.append(" FCurrencyName, ").append("TO_CHAR(null) FPeriodYear, TO_CHAR(null) FPeriodNumber, ");
                selectSql = selectSql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"332_RptAsstactBalanceControllerBean", (Locale)ctx.getLocale()));
                selectSql.append(" TO_CHAR(null) FAccountName,");
                selectSql.append(" FCurrencyName, ").append("TO_INT(null) FPeriodYear, TO_INT(null) FPeriodNumber, ");
                selectSql.append(sqlStaic);
                selectSql.append("\n from ( \n");
                selectSql.append(this.getYearBeginBalanceForSql(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType));
                selectSql.append("\n union all \n");
                selectSql.append(this.getYearFBeginBalanceForSql(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType, params));
                selectSql.append("\n union all \n");
                selectSql.append(this.getFYearDebitAndYearCreditForSql(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType));
                selectSql.append("\n union all \n");
                selectSql.append(this.getFEndBalanceFor(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType));
                selectSql.append("\n union all \n");
                selectSql.append(this.getFDebitAndCreditFor(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, sumType));
                selectSql.append(" ) tmp \n");
                selectSql.append(groupBySqlThree);
                break;
            }
            case 4: {
                groupSql = "  group by    C.FName_" + loc + ",C.FPrecision ";
                selectSqlForSum.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"333_RptAsstactBalanceControllerBean", (Locale)ctx.getLocale()));
                selectSqlForSum.append(" TO_CHAR(null) FAccountName, C.FName_").append(loc);
                selectSqlForSum.append(" FCurrencyName, ").append("TO_CHAR(null) FPeriodYear, TO_CHAR(null) FPeriodNumber, ");
                selectSql = selectSql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"334_RptAsstactBalanceControllerBean", (Locale)ctx.getLocale()));
                selectSql.append(" TO_CHAR(null) FAccountName,");
                selectSql.append(" FCurrencyName, ").append("TO_INT(null) FPeriodYear, TO_INT(null) FPeriodNumber, ");
                selectSql.append(sqlStaic);
                selectSql.append("\n from ( \n");
                selectSql.append(this.getYearBeginBalanceForSql(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, 3));
                selectSql.append("\n union all \n");
                selectSql.append(this.getYearFBeginBalanceForSql(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, 3, params));
                selectSql.append("\n union all \n");
                selectSql.append(this.getFYearDebitAndYearCreditForSql(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, 3));
                selectSql.append("\n union all \n");
                selectSql.append(this.getFEndBalanceFor(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, 3));
                selectSql.append("\n union all \n");
                selectSql.append(this.getFDebitAndCreditFor(ctx, groupSql, joinAndWhereSql, periodRange, selectSqlForSum, 3));
                selectSql.append(" ) tmp \n");
                selectSql.append(groupBySqlThree);
            }
        }
        sqlNew = selectSql;
        RptRowSet rs = this.executeQuery(sqlNew.toString(), parameters, from, length, ctx);
        return rs;
    }

    private StringBuffer getYearBeginBalanceForSql(Context ctx, String groupSql, String joinAndWhereSql, int[] periodRange, StringBuffer selectSql, int sumType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer newJoinAndWhereSql = new StringBuffer();
        sql.append(selectSql);
        sql.append("\n sum((D.FDC*B.FBeginBalanceFor-D.FDC*(B.FYearDebitFor-B.FYearCreditFor)+D.FDC*(B.FDebitFor-B.FCreditFor))*D.FDC) FYearBeginBalanceFor,");
        sql.append("\n sum((D.FDC*B.FBeginBalanceLocal-D.FDC*(B.FYearDebitLocal-B.FYearCreditLocal)+D.FDC*(B.FDebitLocal-B.FCreditLocal))*D.FDC) FYearBeginBalanceLocal,");
        sql.append("\n 0 FBeginBalanceFor, ");
        sql.append("\n 0 FBeginBalanceLocal, ");
        sql.append("\n 0 FDebitFor, 0 FDebitLocal, 0 FCreditFor, 0 FCreditLocal, ");
        sql.append("\n 0 FYearDebitFor, ").append("\n 0 FYearDebitLocal, ").append("\n 0 FYearCreditFor, ");
        sql.append("\n 0 FYearCreditLocal, ");
        sql.append("\n 0 FDC , ");
        sql.append("\n 0 FEndBalanceFor, ").append("\n 0 FEndBalanceLocal, ");
        sql.append("\n C.FPrecision ");
        int begin = 0;
        if (joinAndWhereSql.indexOf("(B.tpFPeriodYear") != -1) {
            String indexOfStr = "(B.tpFPeriodYear";
            while (joinAndWhereSql.indexOf("(" + indexOfStr) != -1) {
                indexOfStr = "(" + indexOfStr;
            }
            begin = joinAndWhereSql.indexOf(indexOfStr);
        } else {
            begin = joinAndWhereSql.indexOf("B.tpFPeriodYear");
        }
        newJoinAndWhereSql.append(joinAndWhereSql.substring(0, begin));
        int[] period = this.checkPeriod(ctx, periodRange, 1);
        newJoinAndWhereSql.append(SQLUtil.getPeriodCondition("B.tpFPeriodYear", "B.tpFPeriodNumber", period));
        sql.append(" ").append(newJoinAndWhereSql).append(" ").append(groupSql);
        return sql;
    }

    private StringBuffer getYearFBeginBalanceForSql(Context ctx, String groupSql, String joinAndWhereSql, int[] periodRange, StringBuffer selectSql, int sumType, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer newJoinAndWhereSql = new StringBuffer();
        sql.append(selectSql);
        sql.append("\n 0 FYearBeginBalanceFor,");
        sql.append("\n 0 FYearBeginBalanceLocal,");
        sql.append("\n sum((D.FDC*B.FBeginBalanceFor)*D.FDC) FBeginBalanceFor, ");
        sql.append("\n sum((D.FDC*B.FBeginBalanceLocal)*D.FDC) FBeginBalanceLocal, ");
        sql.append("\n 0 FDebitFor, 0 FDebitLocal, 0 FCreditFor, 0 FCreditLocal, ");
        sql.append("\n 0 FYearDebitFor, ").append("\n 0 FYearDebitLocal, ").append("\n 0 FYearCreditFor, ");
        sql.append("\n 0 FYearCreditLocal, ");
        sql.append("\n 0 FDC , ");
        sql.append("\n 0 FEndBalanceFor, ").append("\n 0 FEndBalanceLocal, ");
        sql.append("\n C.FPrecision ");
        int begin = 0;
        if (joinAndWhereSql.indexOf("(B.tpFPeriodYear") != -1) {
            String indexOfStr = "(B.tpFPeriodYear";
            while (joinAndWhereSql.indexOf("(" + indexOfStr) != -1) {
                indexOfStr = "(" + indexOfStr;
            }
            begin = joinAndWhereSql.indexOf(indexOfStr);
        } else {
            begin = joinAndWhereSql.indexOf("B.tpFPeriodYear");
        }
        newJoinAndWhereSql.append(joinAndWhereSql.substring(0, begin));
        int[] period = this.checkPeriod(ctx, periodRange, 2);
        newJoinAndWhereSql.append(SQLUtil.getPeriodCondition("B.tpFPeriodYear", "B.tpFPeriodNumber", period));
        boolean noDisplayZero = (Boolean)params.getObjectElement("jcbNoDisplayZero.value");
        boolean ckbNoDisplayBalanceZeroUnhappen = (Boolean)params.getObjectElement("ckbNoDisplayBalanceZeroUnhappen.value");
        if (noDisplayZero || ckbNoDisplayBalanceZeroUnhappen) {
            newJoinAndWhereSql.append(" and (B.FCreditFor<>0 or B.FDebitFor<>0) ");
        }
        sql.append(" ").append(newJoinAndWhereSql).append(" ").append(groupSql);
        return sql;
    }

    private StringBuffer getFYearDebitAndYearCreditForSql(Context ctx, String groupSql, String joinAndWhereSql, int[] periodRange, StringBuffer selectSql, int sumType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer newJoinAndWhereSql = new StringBuffer();
        sql.append(selectSql);
        sql.append("\n 0 FYearBeginBalanceFor,");
        sql.append("\n 0 FYearBeginBalanceLocal,");
        sql.append("\n 0 FBeginBalanceFor, ");
        sql.append("\n 0 FBeginBalanceLocal, ");
        sql.append("\n 0 FDebitFor, 0 FDebitLocal, 0 FCreditFor, 0 FCreditLocal, ");
        sql.append("\n sum(B.FYearDebitFor) FYearDebitFor, ").append("\n sum(B.FYearDebitLocal) FYearDebitLocal, ");
        sql.append("\n sum(B.FYearCreditFor) FYearCreditFor, ").append("\n sum(B.FYearCreditLocal) FYearCreditLocal, ");
        sql.append("\n 0 FDC , ");
        sql.append("\n 0 FEndBalanceFor, ").append("\n 0 FEndBalanceLocal, ");
        sql.append("\n C.FPrecision ");
        int begin = 0;
        if (joinAndWhereSql.indexOf("(B.tpFPeriodYear") != -1) {
            String indexOfStr = "(B.tpFPeriodYear";
            while (joinAndWhereSql.indexOf("(" + indexOfStr) != -1) {
                indexOfStr = "(" + indexOfStr;
            }
            begin = joinAndWhereSql.indexOf(indexOfStr);
        } else {
            begin = joinAndWhereSql.indexOf("B.tpFPeriodYear");
        }
        newJoinAndWhereSql.append(joinAndWhereSql.substring(0, begin));
        int[] period = this.checkPeriod(ctx, periodRange, 3);
        newJoinAndWhereSql.append(SQLUtil.getPeriodCondition("B.tpFPeriodYear", "B.tpFPeriodNumber", period));
        sql.append(" ").append(newJoinAndWhereSql).append(" ").append(groupSql);
        return sql;
    }

    private StringBuffer getFEndBalanceFor(Context ctx, String groupSql, String joinAndWhereSql, int[] periodRange, StringBuffer selectSql, int sumType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer newJoinAndWhereSql = new StringBuffer();
        sql.append(selectSql);
        sql.append("\n 0 FYearBeginBalanceFor,");
        sql.append("\n 0 FYearBeginBalanceLocal,");
        sql.append("\n 0 FBeginBalanceFor, ");
        sql.append("\n 0 FBeginBalanceLocal, ");
        sql.append("\n 0 FDebitFor, 0 FDebitLocal, 0 FCreditFor, 0 FCreditLocal, ");
        sql.append("\n 0 FYearDebitFor, ").append("\n 0 FYearDebitLocal, ").append("\n 0 FYearCreditFor, ");
        sql.append("\n 0 FYearCreditLocal, ");
        sql.append("\n 0 FDC , ");
        sql.append("\n sum((D.FDC*B.FEndBalanceFor)*D.FDC) FEndBalanceFor, ").append("\n sum((D.FDC*B.FEndBalanceLocal)*D.FDC) FEndBalanceLocal, ");
        sql.append("\n C.FPrecision ");
        int begin = 0;
        if (joinAndWhereSql.indexOf("(B.tpFPeriodYear") != -1) {
            String indexOfStr = "(B.tpFPeriodYear";
            while (joinAndWhereSql.indexOf("(" + indexOfStr) != -1) {
                indexOfStr = "(" + indexOfStr;
            }
            begin = joinAndWhereSql.indexOf(indexOfStr);
        } else {
            begin = joinAndWhereSql.indexOf("B.tpFPeriodYear");
        }
        newJoinAndWhereSql.append(joinAndWhereSql.substring(0, begin));
        int[] period = this.checkPeriod(ctx, periodRange, 3);
        newJoinAndWhereSql.append(SQLUtil.getPeriodCondition("B.tpFPeriodYear", "B.tpFPeriodNumber", period));
        sql.append(" ").append(newJoinAndWhereSql).append(" ").append(groupSql);
        return sql;
    }

    private StringBuffer getFDebitAndCreditFor(Context ctx, String groupSql, String joinAndWhereSql, int[] periodRange, StringBuffer selectSql, int sumType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(selectSql);
        sql.append("\n 0 FYearBeginBalanceFor,");
        sql.append("\n 0 FYearBeginBalanceLocal,");
        sql.append("\n 0 FBeginBalanceFor, ");
        sql.append("\n 0 FBeginBalanceLocal, ");
        sql.append("\n sum(B.FDebitFor) FDebitFor, sum(B.FDebitLocal) FDebitLocal, sum(B.FCreditFor) FCreditFor, sum(B.FCreditLocal) FCreditLocal, ");
        sql.append("\n 0 FYearDebitFor, ").append("\n 0 FYearDebitLocal, ").append("\n 0 FYearCreditFor, ");
        sql.append("\n 0 FYearCreditLocal, ");
        sql.append("\n 0 FDC , ");
        sql.append("\n 0 FEndBalanceFor, ").append("\n 0 FEndBalanceLocal, ");
        sql.append("\n C.FPrecision ");
        sql.append(" ").append(joinAndWhereSql).append(" ").append(groupSql);
        return sql;
    }

    private int[] checkPeriod(Context ctx, int[] periodRange, int type) throws BOSException {
        int[] yearAndNumber = new int[4];
        if (type == 1) {
            if (periodRange[0] != periodRange[2]) {
                yearAndNumber[0] = periodRange[2];
                yearAndNumber[1] = 1;
                yearAndNumber[2] = periodRange[2];
                yearAndNumber[3] = 1;
                return yearAndNumber;
            }
            yearAndNumber[0] = periodRange[0];
            CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
            ObjectUuidPK companyPK = new ObjectUuidPK(company.getId());
            PeriodInfo aPeriodInfo = null;
            try {
                aPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)periodRange[0], (int)1, (CompanyOrgUnitInfo)company);
                if (aPeriodInfo != null) {
                    yearAndNumber[1] = periodRange[1];
                    yearAndNumber[2] = periodRange[0];
                    yearAndNumber[3] = periodRange[1];
                    return yearAndNumber;
                }
                aPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)companyPK);
                yearAndNumber[1] = aPeriodInfo.getPeriodNumber();
                yearAndNumber[2] = periodRange[0];
                yearAndNumber[3] = aPeriodInfo.getPeriodNumber();
                return yearAndNumber;
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        if (type == 2) {
            yearAndNumber[0] = periodRange[0];
            yearAndNumber[1] = periodRange[1];
            yearAndNumber[2] = periodRange[0];
            yearAndNumber[3] = periodRange[1];
            return yearAndNumber;
        }
        if (type == 3) {
            yearAndNumber[0] = periodRange[2];
            yearAndNumber[1] = periodRange[3];
            yearAndNumber[2] = periodRange[2];
            yearAndNumber[3] = periodRange[3];
            return yearAndNumber;
        }
        if (type == 4) {
            return yearAndNumber;
        }
        return null;
    }

    private SqlParams getNewSqlParamsForSum(Context ctx, int[] periodRange, List actList, String actNumberFrom, String actNumberTo, String companyId, boolean includeNoPost, int levelFrom, int levelTo, String accountFrom, String accountTo, String currencyId, CompanyOrgUnitInfo company, boolean isSumByAcctActType) throws EASBizException, BOSException {
        SqlParams sp = new SqlParams();
        for (int j = 0; j < 5; ++j) {
            int n = actList.size();
            for (int i = 0; i < n; ++i) {
                String fromNumber = null;
                String toNumber = null;
                AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i);
                if (at.getGeneralAsstactGroupId() != null) {
                    sp.addString(at.getGeneralAsstactGroupId());
                }
                if (at.getFrom() != null) {
                    fromNumber = RptAsstactBalanceControllerBean.getActLongNumber(at, true, ctx);
                }
                if (at.getTo() != null) {
                    toNumber = RptAsstactBalanceControllerBean.getActLongNumber(at, false, ctx);
                }
                if (!StringUtils.isEmpty((String)fromNumber)) {
                    sp.addString(fromNumber);
                }
                if (!StringUtils.isEmpty((String)toNumber)) {
                    sp.addString(toNumber + 'Z');
                }
                if (!StringUtils.isEmpty((String)actNumberFrom)) {
                    sp.addString(actNumberFrom);
                }
                if (StringUtils.isEmpty((String)actNumberTo)) continue;
                sp.addString(actNumberTo + 'Z');
            }
            sp.addString(companyId).addInt(includeNoPost ? 1 : 5);
            if (levelFrom == levelTo) {
                sp.addInt(levelFrom);
            } else {
                sp.addInt(levelFrom).addInt(levelTo);
            }
            if (!StringUtils.isEmpty((String)accountFrom)) {
                sp.addString(accountFrom);
            }
            if (!StringUtils.isEmpty((String)accountTo)) {
                sp.addString(accountTo + "Z");
            }
            if (currencyId != null) {
                sp.addString(currencyId);
            }
            sp.addString(company.getAccountTable().getId().toString());
            if (isSumByAcctActType || periodRange[1] <= 1 || j != 4) continue;
            sp.addInt(periodRange[0]);
        }
        return sp;
    }

    private String getPeriodIdInCondition(Context ctx, String companyId, String periodIdField, int[] periodRange) throws BOSException {
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT DISTINCT p.FID \n");
        kSql.append(" FROM   T_BD_Period p \n");
        kSql.append("        INNER JOIN T_BD_PeriodType pt \n");
        kSql.append("          ON p.FTypeID = pt.FID \n");
        kSql.append("        INNER JOIN T_ORG_Company c \n");
        kSql.append("          ON c.FAccountPeriodID = pt.FID \n");
        kSql.append(" WHERE  c.FID = '" + companyId + "' \n");
        kSql.append("   AND (").append(SQLUtil.getPeriodCondition("p.FPeriodYear", "p.FPeriodNumber", periodRange)).append(")");
        StringBuffer inCondition = new StringBuffer(" " + periodIdField + " in ('null'");
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
        try {
            while (rst.next()) {
                inCondition.append(",'" + rst.getString(1) + "'");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        inCondition.append(") \n");
        return inCondition.toString();
    }
}

