/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.AbstractRptAsstactGGControllerBean;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class RptAsstactGGControllerBean
extends AbstractRptAsstactGGControllerBean {
    private static final long serialVersionUID = 7673805011598570253L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.RptAsstactGGControllerBean");

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
        RptParams pp = new RptParams();
        company = this.fullCompany(ctx, company);
        pp.setObject("company", (Object)company);
        if (!GlUtils.isCompanyUnion(company)) {
            pp.setObject("pe", (Object)new PeriodEntity(RptServerUtil.getPeriodRange(ctx, company)));
        }
        String cuID = company.getCU().getId().toString();
        String curAcctTableID = company.getAccountTable().getId().toString();
        AccountRefContrastInfo info = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(cuID, curAcctTableID);
        pp.setObject("lastAcctInfo", (Object)info);
        pp.setObject("currency", (Object)RptServerUtil.getAllCurrency(company.getId().toString(), ctx));
        pp.setObject("maxLevel", (Object)new Integer(RptServerUtil.getMaxAccountLevel(ctx, company.getId().toString())));
        pp.setObject("sysParams", (Object)this.loadSystemParams(ctx, company.getId().toString()));
        RptParams defaultParams = (RptParams)this.getDefalutQuerySolution(ctx, company.getId());
        pp.setObject("defaultParam", (Object)defaultParams);
        if (GlUtils.isCompanyUnion(company)) {
            if (defaultParams != null) {
                TreeNode companyTreeNode = (TreeNode)defaultParams.getObjectElement("companyTreeNode");
                DefaultTreeModel treeModelOfCompany = new DefaultTreeModel(companyTreeNode);
                company.setDescription(RptClientUtil.getLeafCompany(treeModelOfCompany));
            }
        } else {
            pp.setObject("pe", (Object)new PeriodEntity(RptServerUtil.getPeriodRange(ctx, company)));
        }
        return pp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RptParams _createTempTable(Context ctx, RptParams params) throws EASBizException, BOSException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        params.setString("tempTable", null);
        this.dropTempTable(params.getString("balanceTempTable"), ctx);
        params.setString("balanceTempTable", null);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        int yearEnd = (Integer)params.getObjectElement("jspYearTo.value");
        int numberEnd = (Integer)params.getObjectElement("jspPeriodTo.value");
        Boolean noDisplayZeroObj = (Boolean)params.getObjectElement("jcbNoDisplayZero.value");
        boolean noDisplayZero = noDisplayZeroObj == null ? false : noDisplayZeroObj;
        Boolean noDisplayAllZeroObj = (Boolean)params.getObjectElement("jcbNoDisplayAllZero.value");
        boolean noDisplayAllZero = noDisplayAllZeroObj == null ? false : noDisplayAllZeroObj;
        Boolean noDisplayYearZeroObj = (Boolean)params.getObjectElement("jcbNoDisplayYearZero.value");
        boolean noDisplayYearZero = noDisplayYearZeroObj == null ? false : noDisplayYearZeroObj;
        Object currencyIdObj = params.getObjectElement("jbxCurrency.value.id");
        boolean isGroupFilter = params.getObjectElement("chkFilterByCat.value") == null ? false : (Boolean)params.getObjectElement("chkFilterByCat.value");
        String currencyId = currencyIdObj == null ? null : currencyIdObj.toString();
        boolean showGeneAcctLongName = params.getBoolean("GL_066");
        String curAcctTableID = company.getAccountTable().getId().toString();
        AccountRefContrastInfo ar = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(company.getId().toString(), curAcctTableID, yearEnd, numberEnd);
        if (ar != null && ar.getEnabledAcctTable() != null) {
            company.setAccountTable(RptClientUtil.periodCheckForAccountRefContrast(ar, yearEnd, numberEnd) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable());
        }
        RptParams rpt = new RptParams();
        try {
            int i;
            StringBuffer selectSQL = new StringBuffer("select distinct ");
            StringBuffer conSelectSQL = new StringBuffer();
            StringBuffer conFromSQL = new StringBuffer();
            StringBuffer conOnSQL = new StringBuffer();
            StringBuffer grpbySQL = new StringBuffer();
            StringBuffer fromSQL2 = new StringBuffer();
            StringBuffer fromSQL = new StringBuffer();
            StringBuffer whereSQL = new StringBuffer();
            fromSQL2.append(" t_bd_assistanthg HG ");
            String balanceTempTable = this.getAssistBalanceTable(ctx, params);
            rpt.setString("balanceTempTable", balanceTempTable);
            fromSQL2.append("\n inner join ").append(balanceTempTable).append(" GL on GL.fassistgrpid=HG.fid ");
            conFromSQL.append(balanceTempTable).append(" GL ");
            conFromSQL.append("\n inner join ").append("  t_bd_assistanthg HG on GL.fassistgrpid=HG.fid ");
            List list = (List)params.getObject("actList");
            String[] indexCols = new String[list.size()];
            int size = list.size();
            for (int i2 = 0; i2 < size; ++i2) {
                String asstGroup;
                AsstactTypeEntity at = (AsstactTypeEntity)list.get(i2);
                String tab = "T_" + i2;
                String grpTab = "B_" + i2;
                selectSQL.append(tab).append(".FID FID").append(i2).append(",");
                conSelectSQL.append(tab).append(".FID FID").append(i2).append(",");
                grpbySQL.append(tab).append(".FID").append(",");
                conOnSQL.append(" condition.FID").append(i2).append(" = ").append(tab).append(".FID").append(" and ");
                if (at.isUseGroup()) {
                    asstGroup = at.getAsstGroup();
                    if (isGroupFilter && !StringUtils.isEmpty((String)asstGroup)) {
                        grpTab = grpTab + "_0";
                    }
                    selectSQL.append(grpTab).append(".FID FParentID").append(i2).append(",");
                } else if (at.isMultilevel()) {
                    selectSQL.append(tab).append(".FParentID FParentID").append(i2).append(",");
                } else {
                    selectSQL.append("' ' FParentID").append(i2).append(",");
                }
                selectSQL.append(tab).append(".FNumber FNumber" + i2 + ",");
                if (at.isUseGroup()) {
                    selectSQL.append(" (case when ").append(grpTab).append(".FLongNumber is null then ").append(tab).append(".FNumber else ").append(grpTab).append(".FLongNumber||'!'||");
                    selectSQL.append(tab).append(".FNumber end ) FLongNumber").append(i2).append(",");
                } else if (at.isMultilevel()) {
                    selectSQL.append(tab).append(".FLongNumber FLongNumber").append(i2).append(",");
                } else {
                    selectSQL.append(tab).append(".FNumber FLongNumber").append(i2).append(",");
                }
                selectSQL.append(tab).append(at.isGeneralActType() && at.isMultilevel() && showGeneAcctLongName ? ".FdisplayName_" : ".FName_").append(this.getLoc(ctx)).append(" FName" + i2 + ",");
                selectSQL.append("1 Fisleaf" + i2 + ",");
                if (at.isUseGroup()) {
                    selectSQL.append(" 1+IsNull(").append(grpTab).append(".FLevel,0) FLevel").append(i2).append(",");
                } else if (at.isMultilevel()) {
                    selectSQL.append(tab).append(".FLevel FLevel").append(i2).append(",");
                } else {
                    selectSQL.append("1 FLevel").append(i2).append(",");
                }
                fromSQL.append("\n inner join ").append(at.getTableName()).append(" ").append(tab);
                fromSQL.append(" on HG.").append(at.getHgField()).append("=").append(tab).append(".FID").append(" \r\n");
                if (at.isUseGroup()) {
                    asstGroup = at.getAsstGroup();
                    if (!isGroupFilter || StringUtils.isEmpty((String)asstGroup)) {
                        fromSQL.append(" left join ").append(at.getGroupTable()).append(" ").append(grpTab);
                        fromSQL.append(" on ").append(grpTab).append(".FID=").append(tab).append(".").append(at.getGroupField());
                    } else {
                        String[] groups = asstGroup.split("&");
                        int grpSize = groups.length;
                        for (int k = 0; k < grpSize; ++k) {
                            String tmpName = "B_" + i2 + "_" + k;
                            String groupDetailTab = "D_" + i2 + "_" + k;
                            String groupStdTab = "E_" + i2 + "_" + k;
                            String[] groupSlice = groups[k].split("#");
                            String groupStdNumber = groupSlice[0];
                            String startNumber = null;
                            String endNumber = null;
                            if (groupSlice.length > 1) {
                                String[] groupNumbers = groupSlice[1].split(":");
                                endNumber = startNumber = groupNumbers[0];
                                if (groupNumbers.length > 1) {
                                    endNumber = groupNumbers[1];
                                }
                            }
                            if ("customer".equalsIgnoreCase(at.getHgAttribute())) {
                                fromSQL.append(" inner join T_BD_CUSTOMERGROUPDETAIL ").append(groupDetailTab);
                                fromSQL.append(" on ").append(tab).append(".fid=").append(groupDetailTab).append(".fcustomerid \r\n");
                                fromSQL.append(" inner join ").append(at.getGroupTable()).append(" ").append(tmpName);
                                fromSQL.append(" on ").append(tmpName).append(".FID=").append(groupDetailTab).append(".fcustomergroupid \r\n");
                                fromSQL.append(" inner join T_BD_CSSPGroupStandard ").append(groupStdTab).append(" on ").append(groupStdTab).append(".fid=");
                                fromSQL.append(tmpName).append(".FCSSPGROUPSTANDARDID");
                                fromSQL.append(" and ").append(groupStdTab).append(".fnumber='").append(groupStdNumber).append("' \r\n");
                            } else if ("provider".equalsIgnoreCase(at.getHgAttribute())) {
                                fromSQL.append(" inner join T_BD_SUPPLIERGROUPDETAIL ").append(groupDetailTab);
                                fromSQL.append(" on ").append(tab).append(".fid=").append(groupDetailTab).append(".fsupplierid \r\n");
                                fromSQL.append(" inner join ").append(at.getGroupTable()).append(" ").append(tmpName);
                                fromSQL.append(" on ").append(tmpName).append(".FID=").append(groupDetailTab).append(".fsuppliergroupid \r\n");
                                fromSQL.append(" inner join T_BD_CSSPGroupStandard ").append(groupStdTab).append(" on ").append(groupStdTab).append(".fid=");
                                fromSQL.append(tmpName).append(".FCSSPGROUPSTANDARDID");
                                fromSQL.append(" and ").append(groupStdTab).append(".fnumber='").append(groupStdNumber).append("' \r\n");
                            } else if ("material".equalsIgnoreCase(at.getHgAttribute())) {
                                fromSQL.append(" inner join T_BD_MATERIALGROUPDETIAL ").append(groupDetailTab);
                                fromSQL.append(" on ").append(tab).append(".fid=").append(groupDetailTab).append(".fmaterialid \r\n");
                                fromSQL.append(" inner join ").append(at.getGroupTable()).append(" ").append(tmpName);
                                fromSQL.append(" on ").append(tmpName).append(".FID=").append(groupDetailTab).append(".fmaterialgroupid \r\n");
                                fromSQL.append(" inner join T_BD_MaterialGroupStandard ").append(groupStdTab).append(" on ").append(groupStdTab).append(".fid=");
                                fromSQL.append(tmpName).append(".FGROUPSTANDARD");
                                fromSQL.append(" and ").append(groupStdTab).append(".fnumber='").append(groupStdNumber).append("' \r\n");
                            }
                            if (StringUtils.isEmpty((String)startNumber)) continue;
                            whereSQL.append(" and ");
                            whereSQL.append(" (").append(tmpName).append(".FLONGNUMBER >='").append(startNumber).append("'");
                            whereSQL.append(" OR ").append(tmpName).append(".FLONGNUMBER LIKE '").append(startNumber).append("%')");
                            whereSQL.append(" and (").append(tmpName).append(".FLONGNUMBER <='").append(endNumber).append("'");
                            whereSQL.append(" OR ").append(tmpName).append(".FLONGNUMBER LIKE '").append(endNumber).append("%')");
                        }
                    }
                }
                if (at.isGeneralActType()) {
                    fromSQL.append(" and ").append(tab).append(".FGroupID='").append(at.getGeneralAsstactGroupId()).append("'");
                }
                indexCols[i2] = "FID" + i2;
            }
            selectSQL.setLength(selectSQL.length() - 1);
            String sql = selectSQL.toString() + " from " + fromSQL2.toString() + fromSQL.toString() + whereSQL.toString();
            String yeSuffix = null;
            yeSuffix = RptClientUtil.isGeneralLocalCurrency(currencyId) ? "Local" : (RptClientUtil.isGeneralReportCurrency(currencyId) ? "Rpt" : "For");
            if (noDisplayZero || noDisplayAllZero || noDisplayYearZero) {
                StringBuffer condition = new StringBuffer();
                condition.append("\r\n inner join (  ");
                condition.append("\r\n select ").append(conSelectSQL.toString());
                condition.append("\r\n GL.FOrgUnitID,GL.FAccountID,GL.FPeriodID,GL.FCurrencyID,HG.Fid ");
                condition.append("\r\n from ").append(conFromSQL.toString()).append(fromSQL.toString());
                condition.append("\r\n group by ").append(grpbySQL.toString());
                condition.append("\r\n GL.FOrgUnitID,GL.FAccountID,GL.FPeriodID,GL.FCurrencyID,HG.Fid");
                if (noDisplayAllZero || noDisplayYearZero) {
                    if (noDisplayAllZero && noDisplayYearZero) {
                        condition.append("\r\n having ((Sum(FDebit" + yeSuffix + ")<>0 or Sum(FCredit" + yeSuffix + ")<>0)");
                        condition.append("\r\n and (Sum(FYearDebit" + yeSuffix + ")<>0 or Sum(FYearCredit" + yeSuffix + ")<>0) or Sum(FEndBalance" + yeSuffix + ")<>0)");
                    } else if (noDisplayAllZero) {
                        condition.append("\r\n having (Sum(FDebit" + yeSuffix + ")<>0 or Sum(FCredit" + yeSuffix + ")<>0 or Sum(FEndBalance" + yeSuffix + ")<>0)");
                    } else {
                        condition.append("\r\n having (Sum(FYearDebit" + yeSuffix + ")<>0 or Sum(FYearCredit" + yeSuffix + ")<>0 or Sum(FEndBalance" + yeSuffix + ")<>0)");
                    }
                } else if (noDisplayZero) {
                    condition.append("\r\n having (Sum(FDebit" + yeSuffix + ")<>0 or Sum(FCredit" + yeSuffix + ")<>0)");
                }
                condition.append("\r\n) condition on \r\n");
                condition.append(conOnSQL.toString());
                condition.append("\r\n condition.ForgunitID=GL.ForgunitID and condition.FAccountID=GL.FAccountID and GL.FPeriodID=condition.fperiodID and condition.FCurrencyID=GL.FCurrencyID and condition.FID = GL.fassistgrpid ");
                sql = sql + condition.toString();
            }
            String tempTable = this.executeCreateTableAsSelectInto("select * into TEMP_GL_GG_LEFT from (" + sql + ") as tempTable ", null, ctx).getTempTable();
            rpt.setString("tempTable", tempTable);
            boolean isUnit = GlUtils.isCompanyUnion(company);
            if (isUnit) {
                boolean hasLevelGeneralType = false;
                String levelGeneralLongNumberField = null;
                ArrayList<String> fieldIDs = new ArrayList<String>();
                int size2 = list.size();
                for (int i3 = 0; i3 < size2; ++i3) {
                    AsstactTypeEntity at = (AsstactTypeEntity)list.get(i3);
                    if (at.getCollect() == CollectEnum.LEAF || !at.isMultilevel()) continue;
                    if (at.isGeneralActType()) {
                        hasLevelGeneralType = true;
                        levelGeneralLongNumberField = "FLongNumber" + i3;
                        continue;
                    }
                    fieldIDs.add("FID" + i3);
                }
                if (hasLevelGeneralType) {
                    StringBuffer selectSql = new StringBuffer(" select ");
                    StringBuffer IDs = new StringBuffer();
                    int size3 = list.size();
                    for (int i4 = 0; i4 < size3; ++i4) {
                        if (i4 > 0) {
                            selectSql.append("||");
                            IDs.append("||");
                        }
                        selectSql.append(" a.FID").append(i4);
                        IDs.append("FID").append(i4);
                    }
                    StringBuffer deleteSql = new StringBuffer();
                    deleteSql.append("delete from ").append(tempTable).append(" where ").append(IDs).append(" in (").append(selectSql);
                    deleteSql.append(" from ").append(tempTable).append(" a inner join ").append(tempTable).append(" b on ");
                    deleteSql.append(" charindex(a.").append(levelGeneralLongNumberField).append("||'!',b.").append(levelGeneralLongNumberField).append(")=1");
                    if (fieldIDs.size() > 0) {
                        for (int i5 = 0; i5 < fieldIDs.size(); ++i5) {
                            deleteSql.append(" and a.").append((String)fieldIDs.get(i5)).append(" = b.").append((String)fieldIDs.get(i5));
                        }
                    }
                    deleteSql.append(")");
                    this.executeUpdate(deleteSql.toString(), null, ctx);
                }
            }
            int size4 = list.size();
            for (i = 0; i < size4; ++i) {
                AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
                if (at.getCollect() == CollectEnum.LEAF || !at.isMultilevel()) continue;
                for (int j = at.getMaxLevel(); j >= at.getSelectedLevel(); --j) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(" insert into ").append(tempTable).append(" \n");
                    StringBuffer selectActSQL = new StringBuffer("select distinct ");
                    StringBuffer fromActSQL = new StringBuffer(" from ").append(tempTable).append(" ").append("tempTable \n");
                    StringBuffer whereActSQL = new StringBuffer();
                    for (int k = 0; k < size4; ++k) {
                        AsstactTypeEntity at_ = (AsstactTypeEntity)list.get(k);
                        boolean isLeaf = at_ != at;
                        String tab = isLeaf ? "tempTable" : "T_" + k;
                        selectActSQL.append(tab).append(".FID").append(isLeaf ? "" + k : "").append(" FID").append(k).append(",");
                        selectActSQL.append(tab).append(".FParentID").append(isLeaf ? "" + k : "").append(" FParentID").append(k).append(",");
                        selectActSQL.append(tab).append(".FNumber").append(isLeaf ? "" + k : "").append(" FNumber").append(k).append(",");
                        selectActSQL.append(tab).append(".FLongNumber").append(isLeaf ? "" + k : "").append(" FLongNumber").append(k).append(",");
                        selectActSQL.append(tab).append(".FName").append(isLeaf ? "" + k : "_" + this.getLoc(ctx)).append(" FName").append(k).append(",");
                        selectActSQL.append("0 Fisleaf" + k + ",");
                        if (at.isUseGroup() && !isLeaf) {
                            selectActSQL.append("IsNull(").append(tab).append(".FLevel,0) FLevel").append(k).append(",");
                        } else {
                            selectActSQL.append(tab).append(".FLevel").append(isLeaf ? "" + k : "").append(" FLevel").append(k).append(",");
                        }
                        if (isLeaf) continue;
                        String tableName = at.isUseGroup() ? at.getGroupTable() : at_.getTableName();
                        fromActSQL.append("inner join ").append(tableName).append(" ").append(tab);
                        fromActSQL.append(" on ").append(tab).append(".FID = tempTable.FParentID").append(k);
                        whereActSQL.append(whereActSQL.length() == 0 ? " where " : " and ");
                        whereActSQL.append("tempTable.FLevel").append(k).append("= ").append(j);
                    }
                    selectActSQL.setLength(selectActSQL.length() - 1);
                    sb.append(selectActSQL).append(fromActSQL).append(whereActSQL);
                    this.executeUpdate(sb.toString(), null, ctx);
                }
            }
            for (i = 0; i < indexCols.length; ++i) {
                try {
                    TempTablePool.getInstance((Context)ctx).createIndex(tempTable, indexCols[i], false, false);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"Create index ERROR", (Throwable)e);
                }
            }
            rpt.setObject("header", (Object)this.buildTableHeader(ctx, params));
            rpt.setObject("leftRs", (Object)this.getLeftRs(ctx, params, tempTable, isUnit, false));
        }
        catch (Exception ex) {
            try {
                this.dropPoolTempTable(ctx, params.getString("tempTable"));
            }
            finally {
                this.dropPoolTempTable(ctx, params.getString("balanceTempTable"));
            }
            if (ex instanceof EASBizException) {
                throw (EASBizException)((Object)ex);
            }
            if (ex instanceof BOSException) {
                throw (BOSException)((Object)ex);
            }
            logger.error((Object)"ERROR", (Throwable)ex);
        }
        return rpt;
    }

    private RptRowSet getLeftRs(Context ctx, RptParams params, String tempTable, boolean isUnit, boolean isExpand) throws EASBizException, BOSException {
        StringBuffer selectSQL = new StringBuffer();
        StringBuffer fromSQL = new StringBuffer();
        SqlParams sp = new SqlParams();
        StringBuffer orderByPart = new StringBuffer();
        StringBuffer whereSQL = new StringBuffer();
        List list = (List)params.getObject("actList");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            String parentid = at.getObjectId();
            if (isExpand) {
                if (selectSQL.length() == 0) {
                    selectSQL.append("select distinct ");
                } else {
                    selectSQL.append(",");
                }
                selectSQL.append(" FID").append(i).append(",fparentid").append(i).append(",fnumber").append(i);
                selectSQL.append(",flongnumber").append(i).append(",fname").append(i).append(",fisleaf").append(i);
                selectSQL.append(",flevel").append(i);
                if (CollectEnum.LEAF != at.getCollect()) {
                    int level = (Integer)params.getObject("level");
                    if (CollectEnum.UP.equals((Object)at.getCollect())) {
                        level = level + at.getSelectedLevel() - 1;
                    }
                    whereSQL.append(whereSQL.length() == 0 ? " where " : " and ");
                    whereSQL.append("FLevel").append(i).append("= ?");
                    sp.addInt(level);
                    if (parentid == null) continue;
                    whereSQL.append(" and ");
                    whereSQL.append("FParentID").append(i).append("=?");
                    sp.addString(parentid);
                    if (orderByPart.length() == 0) {
                        orderByPart.append(" order by ");
                    } else {
                        orderByPart.append(",");
                    }
                    orderByPart.append("FLongNumber").append(i);
                    continue;
                }
                if (parentid == null) continue;
                whereSQL.append(" and ");
                whereSQL.append("FID").append(i).append("=?");
                sp.addString(parentid);
                if (orderByPart.length() == 0) {
                    orderByPart.append(" order by ");
                } else {
                    orderByPart.append(",");
                }
                orderByPart.append("FLongNumber").append(i);
                continue;
            }
            if (i == 0) {
                selectSQL.append("select * ");
            }
            if (at.getCollect() != CollectEnum.LEAF) {
                whereSQL.append(whereSQL.length() == 0 ? " where " : " and ");
                whereSQL.append("((FIsLeaf").append(i).append(" = 0 and FLevel").append(i).append("= ?)");
                whereSQL.append(" or (FIsLeaf").append(i).append(" = 1 and FLevel").append(i).append(" <= ?))");
                sp.addInt(at.getSelectedLevel());
                sp.addInt(at.getSelectedLevel());
            }
            if (orderByPart.length() == 0) {
                orderByPart.append(" order by ");
            } else {
                orderByPart.append(",");
            }
            orderByPart.append("FLongNumber").append(i);
        }
        fromSQL.append(" from ").append(tempTable);
        orderByPart.setLength(orderByPart.length());
        String tempSql = selectSQL.append(fromSQL).append(whereSQL).append(orderByPart).toString();
        RptRowSet rs = this.executeQuery(tempSql, sp, ctx);
        return rs;
    }

    protected String getActLongNumber(AsstactTypeEntity at, boolean isFrom, Context ctx) throws BOSException, EASBizException {
        DataBaseInfo obj = (DataBaseInfo)(isFrom ? at.getFrom() : at.getTo());
        if (at.isUseGroup()) {
            String sql = "select B.FLongNumber from " + at.getTableName() + " A inner join " + at.getGroupTable() + " B on A." + at.getGroupField() + "=B.FID where A.FID=?";
            RptRowSet rst = this.executeQuery(sql, new SqlParams().setString(1, obj.getId().toString()), ctx);
            if (rst.next()) {
                return rst.getString(0) + "!" + obj.get("number").toString();
            }
            if (obj.get("longnumber") != null) {
                return obj.get("longnumber").toString();
            }
            return obj.get("number").toString();
        }
        if (at.isUseLevel()) {
            String sql = "select FLongNumber from " + at.getTableName() + "  where FID=? ";
            RptRowSet rst = this.executeQuery(sql, new SqlParams().setString(1, obj.getId().toString()), ctx);
            if (rst.next()) {
                return rst.getString(0);
            }
            return obj.get("longnumber").toString();
        }
        return obj.get("number").toString();
    }

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        return this.getMainRs(ctx, params, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RptParams getMainRs(Context ctx, RptParams params, boolean isExpand) throws BOSException, EASBizException {
        Boolean noDisplayZeroObj = (Boolean)params.getObjectElement("jcbNoDisplayZero.value");
        boolean noDisplayZero = noDisplayZeroObj == null ? false : noDisplayZeroObj;
        Boolean noDisplayAllZeroObj = (Boolean)params.getObjectElement("jcbNoDisplayAllZero.value");
        boolean noDisplayAllZero = noDisplayAllZeroObj == null ? false : noDisplayAllZeroObj;
        Boolean noDisplayYearZeroObj = (Boolean)params.getObjectElement("jcbNoDisplayYearZero.value");
        boolean noDisplayYearZero = noDisplayYearZeroObj == null ? false : noDisplayYearZeroObj;
        String balanceTempTable = "GGbalanceTempTable";
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        boolean isUnit = GlUtils.isCompanyUnion(company);
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company") == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : (CompanyOrgUnitInfo)params.getObject("company")), (Context)ctx);
        int curPeriod = pe.getCurrentYear() * 100 + pe.getCurrentPeriod();
        int periodFrom = (Integer)params.getObjectElement("jspYearFrom.value") * 100 + (Integer)params.getObjectElement("jspPeriodFrom.value");
        boolean isAfterPeriod = periodFrom > curPeriod;
        try {
            String tmpSql;
            balanceTempTable = this.createMainTempTable(ctx, params, balanceTempTable, isExpand, 0);
            if (!isUnit && !isAfterPeriod) {
                this.updateBalance(ctx, params, balanceTempTable, isUnit);
            }
            if (noDisplayAllZero || noDisplayYearZero) {
                if (noDisplayAllZero && noDisplayYearZero) {
                    tmpSql = "select * from " + balanceTempTable + " where (FDebit<>0 or FCredit<>0)";
                    tmpSql = tmpSql + " and (FYearDebit<>0 or FYearCredit<>0) or FEndBalance<>0";
                } else {
                    tmpSql = noDisplayAllZero ? "select * from " + balanceTempTable + " where FDebit<>0 or FCredit<>0 or FEndBalance<>0" : "select * from " + balanceTempTable + " where FYearDebit<>0 or FYearCredit<>0 or FEndBalance<>0";
                }
            } else {
                tmpSql = noDisplayZero ? "select * from " + balanceTempTable + " where FDebit<>0 or FCredit<>0" : "select * from " + balanceTempTable;
            }
            String orderSql = null;
            orderSql = isUnit ? " order by FPERIOD,FACCOUNTNUMBER,FACCOUNTNAME,CompanyLongNumber" : " order by FPERIOD,FACCOUNTNUMBER,FACCOUNTNAME,FCompanyNumber";
            RptRowSet rs = this.executeQuery(tmpSql + orderSql, null, ctx);
            RptParams rpt = new RptParams();
            rpt.setObject("rs", (Object)rs);
            RptParams rptParams = rpt;
            return rptParams;
        }
        finally {
            this.dropPoolTempTable(ctx, balanceTempTable);
        }
    }

    protected String getAccountName(Context ctx, boolean isAccountShowLongName) throws BOSException, EASBizException {
        return isAccountShowLongName ? "AV.FLongName_" : "AV.FName_";
    }

    private void appendJoinFilterSql(Context ctx, StringBuffer sql, SqlParams sp, RptParams params, boolean isBalance, boolean isUnit) throws BOSException, EASBizException {
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company") == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : (CompanyOrgUnitInfo)params.getObject("company")), (Context)ctx);
        int curPeriod = pe.getCurrentYear() * 100 + pe.getCurrentPeriod();
        int periodFrom = (Integer)params.getObjectElement("jspYearFrom.value") * 100 + (Integer)params.getObjectElement("jspPeriodFrom.value");
        int periodTo = (Integer)params.getObjectElement("jspYearTo.value") * 100 + (Integer)params.getObjectElement("jspPeriodTo.value");
        boolean isAfterPeriod = periodFrom > curPeriod || periodTo > curPeriod;
        int[] periodRange = new int[]{(Integer)params.getObjectElement("jspYearFrom.value") * 100 + (Integer)params.getObjectElement("jspPeriodFrom.value"), (Integer)params.getObjectElement("jspYearTo.value") * 100 + (Integer)params.getObjectElement("jspPeriodTo.value")};
        int levelFrom = (Integer)params.getObjectElement("jspLevelFrom.value");
        int levelTo = (Integer)params.getObjectElement("jspLevelTo.value");
        String accountFrom = (String)params.getObjectElement("jebAccountFrom.value.number");
        String accountTo = (String)params.getObjectElement("jebAccountTo.value.number");
        boolean includeUnPost = (Boolean)params.getObjectElement("jcbIncludeUnPost.value");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        String companyId = company.getId().toString();
        String asstAccountID = (String)params.getObjectElement("jebAcct.value.id.toString");
        boolean displayAmount = false;
        if (params.getObjectElement("jcbDisplayAmount.value") != null) {
            displayAmount = (Boolean)params.getObjectElement("jcbDisplayAmount.value");
        }
        String measureUnitID = null;
        if (params.getObjectElement("jebMeasureUnit.value") != null) {
            measureUnitID = ((MeasureUnitInfo)params.getObjectElement("jebMeasureUnit.value")).getId().toString();
        }
        boolean showOnlySubAccountview = true;
        if (params.getObjectElement("jcbShowOnlySubAccountview.value") != null) {
            showOnlySubAccountview = (Boolean)params.getObjectElement("jcbShowOnlySubAccountview.value");
        }
        if (showOnlySubAccountview) {
            levelTo = AccountUtils.getMaxAccountLeve((Context)ctx, (IObjectPK)new ObjectUuidPK(company.getId()));
            levelFrom = 1;
        }
        boolean sumByMeasureUnit = false;
        if (params.getObjectElement("jcbSumByMeasureUnit.value") != null) {
            sumByMeasureUnit = (Boolean)params.getObjectElement("jcbSumByMeasureUnit.value");
        }
        String assistbalanceTable = this.getAssistBalanceTableName(params, isAfterPeriod, displayAmount, measureUnitID, sumByMeasureUnit);
        sql.append(" inner join ").append(assistbalanceTable).append(" GL on GL.fassistgrpid=HG.fid ");
        if (isUnit) {
            sql.append(" and GL.FOrgUnitId in (").append(company.getDescription()).append(")");
        } else {
            sql.append(" and GL.FOrgUnitId=?");
            sp.addString(companyId);
        }
        if (params.getObjectElement("jbxCurrency.value.id") != null) {
            String currencyId = params.getObjectElement("jbxCurrency.value.id").toString();
            sql.append(" and GL.FCurrencyID=? ");
            sp.addString(currencyId);
        } else {
            sql.append(" and GL.FCurrencyID <>? and GL.FCurrencyID <>?");
            sp.addString("11111111-1111-1111-1111-111111111111DEB58FDC");
            sp.addString("22222222-2222-2222-2222-222222222222DEB58FDC");
        }
        sql.append(" and GL.FBalType=? ");
        sp.addInt(includeUnPost ? 1 : 5);
        if (displayAmount && measureUnitID != null) {
            sql.append(" and GL.FMeasureunitID = ? ");
            sp.addString(measureUnitID);
        }
        if (displayAmount && (measureUnitID != null || sumByMeasureUnit)) {
            sql.append("\n inner join T_BD_Period PE on PE.FID=GL.FPeriodID and ").append(SQLUtil.getPeriodCondition("PE.FNumber", periodRange));
        } else if (isAfterPeriod) {
            sql.append(" and ").append(SQLUtil.getPeriodCondition("GL.TPFNUMBER", periodRange)).append(" ");
        } else {
            sql.append("\n inner join T_BD_Period PE on PE.FID=GL.FPeriodID and ").append(SQLUtil.getPeriodCondition("PE.FNumber", periodRange));
        }
        sql.append("\n inner join T_BD_AccountView AV on AV.FID=GL.FAccountID ");
        if (isUnit) {
            sql.append(" and av.fglevel >= av.flevel ");
        }
        if (asstAccountID != null) {
            sql.append(" and AV.FCAA=?");
            sp.addString(asstAccountID);
        }
        if (showOnlySubAccountview) {
            if (levelFrom == levelTo) {
                sql.append(" and AV.FLevel=?");
                sp.addInt(levelFrom);
            } else {
                sql.append(" and AV.FLevel>=? and AV.FLevel<=?");
                sp.addInt(levelFrom).addInt(levelTo);
            }
        }
        if (accountFrom != null) {
            sql.append(" and AV.FNumber>=?");
            sp.addString(accountFrom);
        }
        if (accountTo != null) {
            sql.append(" and AV.FNumber<=?");
            sp.addString(accountTo + 'z');
        }
        sql.append(" and AV.FAccountTableID = ? ");
        sp.addString(((CompanyOrgUnitInfo)params.getObject("company")).getAccountTable().getId().toString());
        if (GlUtils.isCompanyUnion(company)) {
            sql.append(" and AV.fcompanyid in (").append(company.getDescription()).append(")");
        } else {
            sql.append(" and AV.fcompanyid = ?");
            sp.addString(company.getId().toString());
        }
        String userId = params.getString("userId");
        String permSql = RptServerUtil.innerJoinAccountPermissionSql("AV", userId, company.getId().toString(), ctx);
        if (permSql != null && permSql.trim().length() > 0) {
            sql.append("\n").append(permSql);
        }
    }

    protected String getAssistBalanceTableName(RptParams params, boolean isAfterPeriod, boolean displayAmount, String measureUnitID, boolean sumByMeasureUnit) {
        String assistbalanceTable = displayAmount && (measureUnitID != null || sumByMeasureUnit) ? "t_gl_assistmeasurebalance" : "t_gl_assistbalance";
        return assistbalanceTable;
    }

    @Override
    protected RptParams _queryDownLevel(Context ctx, RptParams params) throws BOSException, EASBizException {
        Boolean isTableMain = (Boolean)params.getObject("isTableMain");
        if (isTableMain.booleanValue()) {
            return this.queryDownLevelMain(ctx, params);
        }
        return this.queryDownLevelLeft(ctx, params);
    }

    protected RptParams queryDownLevelLeft(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        boolean isUnit = GlUtils.isCompanyUnion(company);
        String tempTable = params.getString("tempTable");
        RptParams rpt = new RptParams();
        rpt.setObject("leftRs", (Object)this.getLeftRs(ctx, params, tempTable, isUnit, true));
        return rpt;
    }

    protected RptParams queryDownLevelMain(Context ctx, RptParams params) throws BOSException, EASBizException {
        return this.getMainRs(ctx, params, true);
    }

    private Object getDefalutQuerySolution(Context ctx, BOSUuid companyID) throws EASBizException, BOSException {
        RptParams defaultPm = null;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getLocalInstance((Context)ctx);
        String uiName = this.getParentUIName();
        String queryName = this.getQueryName();
        String currUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (iQuery.hasDefaultSolution(uiName, queryName, companyID.toString(), currUserID)) {
            QuerySolutionInfo solution;
            QueryPanelCollection queryPanels;
            EntityViewInfo ev = (EntityViewInfo)iQuery.getDefaultFilterInfo(uiName, queryName, companyID.toString(), currUserID);
            if (ev == null) {
                ev = new EntityViewInfo();
            }
            if (ev.getFilter() == null) {
                ev.setFilter(new FilterInfo());
            }
            if ((queryPanels = (solution = iQuery.getDefaultSolution(uiName, queryName, companyID.toString(), currUserID)).getQueryPanelInfo()) == null) {
                return null;
            }
            QueryPanelInfo queryPanel = null;
            int size = queryPanels.size();
            for (int i = 0; i < size; ++i) {
                if (queryPanels.get(i).getQueryPanelType() != QueryPanelTypeEnum.CUSTOMER_PANEL) continue;
                queryPanel = queryPanels.get(i);
                break;
            }
            if (queryPanel != null && queryPanel.getCustomerParams() != null) {
                try {
                    String pm;
                    String strParam = queryPanel.getCustomerParams();
                    if (strParam != null && (pm = this.TransStrToCustParams(strParam)) != null) {
                        byte[] bytes = Base64Encoder.base64ToByteArray((String)pm);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        Object obj = objectInputStream.readObject();
                        defaultPm = obj instanceof RptFilterInfo ? (RptParams)RptFilterUtils.toObjectFromRptFilterMap((Object)obj) : (RptParams)obj;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        return defaultPm;
    }

    private RptParams loadSystemParams(Context ctx, String comId) throws BOSException, EASBizException {
        String[] paramList = new String[]{"G001", "GL_004", "GL_005", "GL_006", "GL_009", "GL_012", "GL_002", "GL_003", "GL_008", "GL_028", "GL_053", "G010", "GL_064", "GL_066"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)comId);
        RptParams pp = new RptParams();
        return RptParams.parseFrom((Map)glParam.getParamMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String TransStrToCustParams(String customerParams) throws Exception {
        StringReader in = null;
        HashMap hm = null;
        try {
            in = new StringReader(customerParams);
            hm = new HashMap();
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build((Reader)in);
            Element root = doc.getRootElement();
            List properties = root.getChildren();
            hm = this.readFromXml(hm, properties);
        }
        catch (Exception e) {
            logger.error((Object)("Get QuerySolution ERROR:" + e));
        }
        finally {
            try {
                ((Reader)in).close();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return (String)hm.get("RPTPARAMS_KEY_AT_CUSTOMERPARAMS");
    }

    private HashMap readFromXml(HashMap hm, List properties) {
        XMLBean xml = null;
        Element property = null;
        for (int i = 0; i < properties.size(); ++i) {
            xml = new XMLBean();
            property = (Element)properties.get(i);
            xml.setName(property.getChild("name").getText());
            if (property.getChild("value") == null && property.getChild("properties") != null) {
                Element rootElement = property.getChild("properties");
                HashMap map = this.readFromXml(hm, rootElement.getChildren());
                hm.put(xml.getName(), map);
                continue;
            }
            if (property.getChild("value") == null) continue;
            xml.setValue(property.getChild("value").getText());
            hm.put(xml.getName(), xml.getValue());
        }
        return hm;
    }

    private RptTableHeader buildTableHeader(Context ctx, RptParams params) throws BOSException {
        AsstactTypeEntity at;
        List list = (List)params.getObject("actList");
        int itemCount = list.size();
        RptTableHeader header = new RptTableHeader();
        for (int i = 0; i < itemCount; ++i) {
            RptTableColumn col = new RptTableColumn();
            col.setWidth(150);
            header.addColumn(col);
        }
        Object[][] hh = new Object[1][itemCount];
        HashSet<String> idSet = new HashSet<String>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            at = (AsstactTypeEntity)list.get(i);
            idSet.add(at.getId());
        }
        AsstActTypeCollection asstActColl = null;
        if (idSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("name"));
            view.getSelector().add(new SelectorItemInfo("number"));
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(fi);
            asstActColl = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
        }
        if (asstActColl != null) {
            for (int i = 0; i < itemCount; ++i) {
                at = (AsstactTypeEntity)list.get(i);
                AsstActTypeInfo asstActTypeInfo = this.findAsstActTypeInfo(asstActColl, at.getId());
                if (asstActTypeInfo == null) continue;
                hh[0][i] = asstActTypeInfo.getName();
            }
        }
        header.setLabels(hh);
        return header;
    }

    private AsstActTypeInfo findAsstActTypeInfo(AsstActTypeCollection asstActCol, String id) {
        if (asstActCol == null || id == null || id.trim().length() == 0) {
            return null;
        }
        for (int i = 0; i < asstActCol.size(); ++i) {
            if (!BOSUuid.read((String)id).equals((Object)asstActCol.get(i).getId())) continue;
            return asstActCol.get(i);
        }
        return null;
    }

    protected ArrayList exportTransmit(Context ctx, IRowSet rs, RptParams params, String[] fields) throws BOSException {
        int localPre;
        boolean onlyEndPeriod = false;
        if (params.getObjectElement("jcbEndPeriod.value") != null) {
            onlyEndPeriod = (Boolean)params.getObjectElement("jcbEndPeriod.value");
        }
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        RptParams sysParams = (RptParams)params.getObject("sysParams");
        String strQty = sysParams.getString("GL_002");
        String strPri = sysParams.getString("GL_003");
        boolean isShowAsstNumber = sysParams.getBoolean("GL_004");
        int scaleQty = new Integer(strQty);
        int scalePrice = new Integer(strPri);
        int forPre = localPre = company.getBaseCurrency().getPrecision();
        if (params.getObjectElement("jbxCurrency.value.id") != null) {
            CurrencyInfo currency = (CurrencyInfo)params.getObjectElement("jbxCurrency.value");
            forPre = currency.getPrecision();
        }
        int rptPre = localPre;
        if (company.getReportCurrency() != null) {
            rptPre = company.getReportCurrency().getPrecision();
        }
        ArrayList data = new ArrayList();
        try {
            HashMap<String, Integer> typeMap = new HashMap<String, Integer>();
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                int columnType = rs.getMetaData().getColumnType(i);
                String columnName = rs.getMetaData().getColumnName(i);
                typeMap.put(columnName.toUpperCase(), new Integer(columnType));
            }
            int rateScale = 2;
            while (rs.next()) {
                HashMap<String, String> rowData = new HashMap<String, String>();
                for (int i = 0; i < fields.length; ++i) {
                    String field = fields[i].toUpperCase();
                    Object obj = rs.getObject(field);
                    if (obj == null) continue;
                    int type = (Integer)typeMap.get(field);
                    if (type == 91 || type == 92 || type == 93) {
                        Date date = rs.getDate(field);
                        rowData.put(field, this.dateToString(formater, date));
                        continue;
                    }
                    if (type == 3 || type == 2 || type == 4) {
                        if (field.endsWith("_FOR")) {
                            if (params.getObjectElement("jbxCurrency.value.id") == null) {
                                forPre = rs.getInt("FPrecision");
                            }
                            rowData.put(field, rs.getBigDecimal(field).setScale(forPre, 4).toString());
                            continue;
                        }
                        if (field.endsWith("_LOCAL")) {
                            rowData.put(field, rs.getBigDecimal(field).setScale(localPre, 4).toString());
                            continue;
                        }
                        if (field.endsWith("_RPT")) {
                            rowData.put(field, rs.getBigDecimal(field).setScale(rptPre, 4).toString());
                            continue;
                        }
                        if (field.endsWith("QTY")) {
                            rowData.put(field, rs.getBigDecimal(field).setScale(scaleQty, 4).toString());
                            continue;
                        }
                        if (field.endsWith("PRICE")) {
                            rowData.put(field, rs.getBigDecimal(field).setScale(scalePrice, 4).toString());
                            continue;
                        }
                        if (field.endsWith("RATE")) {
                            rowData.put(field, rs.getBigDecimal(field).setScale(rateScale, 4).toString());
                            continue;
                        }
                        if (field.endsWith("FDC")) {
                            int dc = rs.getInt(field);
                            rowData.put(field, dc == 1 ? BalanceDirectionEnum.DEBIT.getAlias() : BalanceDirectionEnum.CREDIT.getAlias());
                            continue;
                        }
                        if (field.endsWith("PERIOD")) {
                            if (onlyEndPeriod && (rs.getInt("FRowType") == 2 || rs.getInt("FRowType") == 3)) {
                                rowData.put(field, " ");
                                continue;
                            }
                            int period = rs.getInt(field);
                            rowData.put(field, period / 100 + "." + period % 100);
                            continue;
                        }
                        rowData.put(field, rs.getBigDecimal(field).setScale(forPre, 4).toString());
                        continue;
                    }
                    if (field.indexOf("ASSTITEM") != -1) {
                        String _value = rs.getString(field);
                        if (_value != null) {
                            _value = _value.trim();
                            if (isShowAsstNumber) {
                                rowData.put(field, _value);
                                continue;
                            }
                            rowData.put(field, _value.substring(_value.indexOf(" ") + 1));
                            continue;
                        }
                        rowData.put(field, "");
                        continue;
                    }
                    rowData.put(field, rs.getString(field));
                }
                data.add(rowData);
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return data;
    }

    protected String dateToString(SimpleDateFormat formater, Date date) {
        if (date == null) {
            return null;
        }
        return formater.format(date);
    }

    protected String getParentUIName() {
        return "com.kingdee.eas.fi.gl.client.RptAsstactGGUI";
    }

    protected String getQueryName() {
        return "com.kingdee.eas.framework.report.app.CommRptEmptyQuery";
    }

    @Override
    protected List _exportToExcel(Context ctx, RptParams params) throws BOSException, EASBizException {
        int i;
        ArrayList asstActTypeList = (ArrayList)params.getObject("asstActTypeList");
        if (asstActTypeList == null) {
            asstActTypeList = new ArrayList();
            ArrayList actList = (ArrayList)params.getObject("actList");
            String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"subtotal", (Locale)ctx.getLocale());
            String total = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"total", (Locale)ctx.getLocale());
            for (int i2 = actList.size() - 1; i2 >= 0; --i2) {
                int j;
                ArrayList actitemList = new ArrayList();
                for (j = 0; j <= i2; ++j) {
                    actitemList.add(actList.get(j));
                }
                for (j = i2 + 1; j < actList.size(); ++j) {
                    actitemList.add(subTotal);
                }
                asstActTypeList.add(actitemList);
            }
            ArrayList<String> actitemList = new ArrayList<String>();
            for (i = 0; i < actList.size(); ++i) {
                actitemList.add(total);
            }
            asstActTypeList.add(actitemList);
            params.setObject("asstActTypeList", asstActTypeList);
        }
        IRowSet rs = this.getExportData(ctx, params);
        String[][] headAndFields = this.getHeadAndFields(ctx, params);
        String[] fields = headAndFields[0];
        ArrayList data = this.exportTransmit(ctx, rs, params, fields);
        data.add(0, fields);
        for (i = 1; i < headAndFields.length; ++i) {
            String[] head = headAndFields[i];
            HashMap<String, String> headMap = new HashMap<String, String>();
            for (int j = 0; j < fields.length; ++j) {
                String field = fields[j].toUpperCase();
                headMap.put(field, head[j]);
            }
            data.add(i, headMap);
        }
        return data;
    }

    protected IRowSet getExportData(Context ctx, RptParams params) throws BOSException, EASBizException {
        Boolean noDisplayZeroObj = (Boolean)params.getObjectElement("jcbNoDisplayZero.value");
        boolean noDisplayZero = noDisplayZeroObj == null ? false : noDisplayZeroObj;
        Boolean noDisplayAllZeroObj = (Boolean)params.getObjectElement("jcbNoDisplayAllZero.value");
        boolean noDisplayAllZero = noDisplayAllZeroObj == null ? false : noDisplayAllZeroObj;
        Boolean noDisplayYearZeroObj = (Boolean)params.getObjectElement("jcbNoDisplayYearZero.value");
        boolean noDisplayYearZero = noDisplayYearZeroObj == null ? false : noDisplayYearZeroObj;
        boolean showOnlySubAccountview = true;
        if (params.getObjectElement("jcbShowOnlySubAccountview.value") != null) {
            showOnlySubAccountview = (Boolean)params.getObjectElement("jcbShowOnlySubAccountview.value");
        }
        String balanceTempTable = "GGbalanceTempTable";
        try {
            int i;
            ArrayList asstActTypeList = (ArrayList)params.getObject("asstActTypeList");
            if (asstActTypeList == null) {
                asstActTypeList = new ArrayList();
                ArrayList actList = (ArrayList)params.getObject("actList");
                String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"subtotal", (Locale)ctx.getLocale());
                String total = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"total", (Locale)ctx.getLocale());
                for (int i2 = actList.size() - 1; i2 >= 0; --i2) {
                    int j;
                    ArrayList actitemList = new ArrayList();
                    for (j = 0; j <= i2; ++j) {
                        actitemList.add(actList.get(j));
                    }
                    for (j = i2 + 1; j < actList.size(); ++j) {
                        actitemList.add(subTotal);
                    }
                    asstActTypeList.add(actitemList);
                }
                ArrayList<String> actitemList = new ArrayList<String>();
                for (int i3 = 0; i3 < actList.size(); ++i3) {
                    actitemList.add(total);
                }
                asstActTypeList.add(actitemList);
                params.setObject("asstActTypeList", asstActTypeList);
            }
            for (int i4 = 0; i4 < asstActTypeList.size(); ++i4) {
                if (i4 == 0) {
                    balanceTempTable = this.createMainTempTable(ctx, params, balanceTempTable, false, i4);
                    continue;
                }
                this.createMainTempTable(ctx, params, balanceTempTable, false, i4);
            }
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
            boolean isUnit = GlUtils.isCompanyUnion(company);
            if (!isUnit) {
                this.updateBalance(ctx, params, balanceTempTable, isUnit);
            }
            List itemList = (List)params.getObject("actList");
            int itemCount = itemList.size();
            StringBuffer sql = new StringBuffer();
            sql.append(" insert into ").append(balanceTempTable);
            sql.append(" (");
            for (i = 0; i < itemCount; ++i) {
                sql.append(" ASSTITEM").append(i).append(",");
            }
            sql.append("isTotal,FACCOUNTNUMBER,FACCOUNTNAME,FPeriodYear,FPeriodNumber,fdc,isleaf,flevel,");
            if (isUnit) {
                sql.append("COMPANYLONGNUMBER,");
            }
            sql.append("FCOMPANYNUMBER,FCOMPANYNAME,FCOMPANYLEVEL,FCOMPANYLEAF,FCOMPANYID,");
            sql.append("FPARENTID,FperiodID,FBEGINBALANCE,FYEARDEBIT,FYEARCREDIT,FDEBIT,FCREDIT,FENDBALANCE,FPERIOD )");
            sql.append(" select ");
            for (i = 0; i < itemCount; ++i) {
                sql.append(" ASSTITEM").append(i).append(",");
            }
            sql.append(" 1 ,");
            String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"subtotal", (Locale)ctx.getLocale());
            sql.append("N'").append(subTotal).append("',");
            sql.append("N'").append(subTotal).append("',");
            sql.append("FPeriodYear,FPeriodNumber,");
            sql.append("1,0,0, ");
            if (isUnit) {
                sql.append("'',");
            }
            sql.append("'','',1,0,'','',FPeriodID,sum(FBeginBalance),sum(FYearDebit),sum(FYearCredit),");
            sql.append("sum(FDebit),sum(FCredit),sum(FEndBalance),FPeriod");
            sql.append(" from ").append(balanceTempTable);
            int levelFrom = (Integer)params.getObjectElement("jspLevelFrom.value");
            boolean existWhere = false;
            if (!showOnlySubAccountview) {
                sql.append(" where flevel =").append(levelFrom);
                existWhere = true;
            }
            if (noDisplayAllZero || noDisplayYearZero) {
                if (existWhere) {
                    sql.append(" and ");
                } else {
                    sql.append(" where ");
                    existWhere = true;
                }
                if (noDisplayAllZero && noDisplayYearZero) {
                    sql.append(" ((FDebit<>0 or FCredit<>0) and (FYearDebit<>0 or FYearCredit<>0) or FEndBalance<>0) ");
                } else if (noDisplayAllZero) {
                    sql.append(" (FDebit<>0 or FCredit<>0 or FEndBalance<>0) ");
                } else {
                    sql.append(" (FYearDebit<>0 or FYearCredit<>0 or FEndBalance<>0) ");
                }
            } else if (noDisplayZero) {
                if (existWhere) {
                    sql.append(" and ");
                } else {
                    sql.append(" where ");
                    existWhere = true;
                }
                sql.append(" (FDebit<>0 or FCredit<>0) ");
            }
            if (isUnit) {
                if (existWhere) {
                    sql.append(" and fcompanylevel = ").append(company.getLevel());
                } else {
                    sql.append(" where fcompanylevel = ").append(company.getLevel());
                }
            }
            sql.append(" group by ");
            for (int i5 = 0; i5 < itemCount; ++i5) {
                sql.append(" ASSTITEM").append(i5).append(",");
            }
            sql.append(" FPeriodID,FPeriodYear,FPeriodNumber,FPeriod");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            String tmpSql = noDisplayAllZero || noDisplayYearZero ? (noDisplayAllZero ? "select * from " + balanceTempTable + " where FDebit<>0 or FCredit<>0 or FEndBalance<>0" : "select * from " + balanceTempTable + " where FYearDebit<>0 or FYearCredit<>0 or FEndBalance<>0") : (noDisplayZero ? "select * from " + balanceTempTable + " where FDebit<>0 or FCredit<>0" : "select * from " + balanceTempTable);
            StringBuffer orderBySql = new StringBuffer(" order by ");
            for (int i6 = 0; i6 < itemCount; ++i6) {
                orderBySql.append(" ASSTITEM").append(i6).append(",");
            }
            orderBySql.append(" FPERIOD,isTotal, FACCOUNTNUMBER, FCompanyNumber");
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)(tmpSql + orderBySql.toString()));
            return iRowSet;
        }
        catch (Exception ex) {
            logger.error((Object)"Query export data fail:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            this.dropPoolTempTable(ctx, balanceTempTable);
        }
    }

    private void updateBalance(Context ctx, final RptParams params, String balanceTempTable, boolean isUnit) throws BOSException, EASBizException {
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company") == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : (CompanyOrgUnitInfo)params.getObject("company")), (Context)ctx);
        int curYear = pe.getCurrentYear();
        int toYear = (Integer)params.getObjectElement("jspYearTo.value");
        final int curPeriodOrder = pe.getCurrentYear() * 100 + pe.getCurrentPeriod();
        int toYearPeriodStart = (curYear + 1) * 100 + 1;
        if ((Integer)params.getObjectElement("jspYearTo.value") * 100 + (Integer)params.getObjectElement("jspPeriodTo.value") > curPeriodOrder && !isUnit) {
            StringBuffer updateBalance = new StringBuffer();
            updateBalance.append(" update  ").append(balanceTempTable).append(" set   ");
            class MyInnerClass {
                private String tempTableName = null;

                MyInnerClass(String tempTable) {
                    this.tempTableName = tempTable;
                }

                private void setYearUpdt(StringBuffer sql, String yearcolumn, String column) {
                    int i;
                    int itemCount;
                    List itemList;
                    sql.append("\n ").append(yearcolumn).append(" = ").append(" to_decimal(0.0,19,4)   ");
                    sql.append("\n + (select sum(").append(column).append(") from ").append(this.tempTableName).append(" ta where ta.FPERIOD <= ");
                    sql.append(this.tempTableName).append(".FPERIOD ");
                    sql.append(" and FPERIOD >").append(curPeriodOrder);
                    sql.append(" and ta.faccountid = ");
                    sql.append(this.tempTableName).append(".faccountid ");
                    if (params.getBoolean("isExportToExcel")) {
                        itemList = (List)params.getObject("actList");
                        itemCount = itemList.size();
                        for (i = 0; i < itemCount; ++i) {
                            sql.append(" and ").append(this.tempTableName).append(".ASSTITEM").append(i).append(" = ");
                            sql.append("ta.ASSTITEM").append(i);
                        }
                    }
                    sql.append(" )");
                    sql.append("\n      +  case when (select ").append(yearcolumn).append(" from ").append(this.tempTableName);
                    sql.append(" tb ").append(" where tb.FPERIOD = ");
                    sql.append(curPeriodOrder).append(" and tb.faccountid = ");
                    sql.append(this.tempTableName).append(".faccountid ");
                    if (params.getBoolean("isExportToExcel")) {
                        itemList = (List)params.getObject("actList");
                        itemCount = itemList.size();
                        for (i = 0; i < itemCount; ++i) {
                            sql.append(" and ").append(this.tempTableName).append(".ASSTITEM").append(i).append(" = ");
                            sql.append("tb.ASSTITEM").append(i);
                        }
                    }
                    sql.append(" ) is null then to_decimal(0.0,19,4) ");
                    sql.append(" else (select ").append(yearcolumn).append(" from ").append(this.tempTableName).append(" tb ");
                    sql.append(" where tb.FPERIOD = ");
                    sql.append(curPeriodOrder).append(" and tb.faccountid = ");
                    sql.append(this.tempTableName).append(".faccountid ");
                    if (params.getBoolean("isExportToExcel")) {
                        List itemList2 = (List)params.getObject("actList");
                        int itemCount2 = itemList2.size();
                        for (i = 0; i < itemCount2; ++i) {
                            sql.append(" and ").append(this.tempTableName).append(".ASSTITEM").append(i).append(" = ");
                            sql.append("tb.ASSTITEM").append(i);
                        }
                    }
                    sql.append(" ) end ,");
                }

                private void setEndUpdt(StringBuffer sql, String yearcolumn, String endcolumn) {
                    int i;
                    sql.append("\n ").append(endcolumn).append(" = ").append(" to_decimal(0.0,19,4)   ");
                    sql.append(" + ").append(yearcolumn);
                    sql.append("\n     - ISNULL((select ").append(yearcolumn).append(" from ").append(this.tempTableName);
                    sql.append(" tb ").append(" where tb.FPERIOD = ").append(curPeriodOrder).append(" and tb.faccountid = ");
                    sql.append(this.tempTableName).append(".faccountid ");
                    if (params.getBoolean("isExportToExcel")) {
                        List itemList = (List)params.getObject("actList");
                        int itemCount = itemList.size();
                        for (i = 0; i < itemCount; ++i) {
                            sql.append(" and ").append(this.tempTableName).append(".ASSTITEM").append(i).append(" = ");
                            sql.append("tb.ASSTITEM").append(i);
                        }
                    }
                    sql.append(" ),0.0000)");
                    sql.append(" \n     + ISNULL((select ").append(endcolumn).append(" from ").append(this.tempTableName);
                    sql.append(" tc ").append(" where tc.FPERIOD = ").append(curPeriodOrder).append(" and tc.faccountid = ");
                    sql.append(this.tempTableName).append(".faccountid ");
                    if (params.getBoolean("isExportToExcel")) {
                        List itemList2 = (List)params.getObject("actList");
                        int itemCount2 = itemList2.size();
                        for (i = 0; i < itemCount2; ++i) {
                            sql.append(" and ").append(this.tempTableName).append(".ASSTITEM").append(i).append(" = ");
                            sql.append("tc.ASSTITEM").append(i);
                        }
                    }
                    sql.append(" ),0.0000),");
                }

                private void setBeginUpdt(StringBuffer sql, String begincolumn, String endcolumn, String column) {
                    sql.append("\n ").append(begincolumn).append(" = ").append(" to_decimal(0.0,19,4)   ");
                    sql.append(" + ").append(endcolumn).append(" - ").append(column);
                    sql.append(",");
                }
            }
            MyInnerClass myInner = new MyInnerClass(balanceTempTable);
            myInner.setYearUpdt(updateBalance, "FYEARDEBIT", "FDEBIT");
            myInner.setYearUpdt(updateBalance, "FYearCredit", "FCredit");
            updateBalance.deleteCharAt(updateBalance.length() - 1);
            updateBalance.append("\n   where FPERIOD > ").append(curPeriodOrder);
            if (curYear < toYear) {
                updateBalance.append(" and FPERIOD < ").append(toYearPeriodStart);
            }
            this.executeUpdate(ctx, updateBalance.toString(), null);
            updateBalance.setLength(0);
            updateBalance.append(" update  ").append(balanceTempTable).append(" set   ");
            myInner.setEndUpdt(updateBalance, "(FYEARDEBIT - FYEARCredit)", "FENDBALANCE");
            updateBalance.deleteCharAt(updateBalance.length() - 1);
            updateBalance.append("\n   where FPERIOD > ").append(curPeriodOrder);
            if (curYear < toYear) {
                updateBalance.append(" and FPERIOD < ").append(toYearPeriodStart);
            }
            this.executeUpdate(ctx, updateBalance.toString(), null);
            updateBalance.setLength(0);
            if (curYear < toYear) {
                for (int i = 0; i < toYear - curYear; ++i) {
                    String fromYearPeriod = String.valueOf((curYear + 1 + i) * 100 + 1);
                    String toYearPeriod = String.valueOf((curYear + 1 + i) * 100 + pe.getMaxPeriod(curYear + 1 + i));
                    String curMaxYearPeriod = String.valueOf((curYear + i) * 100 + pe.getMaxPeriod(curYear + i));
                    updateBalance.append(" update  ").append(balanceTempTable).append(" set   ");
                    class MyInnerClass0 {
                        private String tempTableName = null;

                        MyInnerClass0(String tempTable) {
                            this.tempTableName = tempTable;
                        }

                        private void setYearUpdt(StringBuffer sql, String yearcolumn, String column, String fromYearPeriod, String toYearPeriod) {
                            sql.append("\n ").append(yearcolumn).append(" = ").append(" to_decimal(0.0,19,4)   ");
                            sql.append("\n + (select sum(").append(column).append(") from ").append(this.tempTableName).append(" ta where ta.FPERIOD <= ");
                            sql.append(this.tempTableName).append(".FPERIOD ");
                            sql.append(" and FPERIOD >= ").append(fromYearPeriod);
                            sql.append(" and FPERIOD <= ").append(toYearPeriod);
                            sql.append(" and ta.faccountid = ");
                            sql.append(this.tempTableName).append(".faccountid ");
                            if (params.getBoolean("isExportToExcel")) {
                                List itemList = (List)params.getObject("actList");
                                int itemCount = itemList.size();
                                for (int i = 0; i < itemCount; ++i) {
                                    sql.append(" and ").append(this.tempTableName).append(".ASSTITEM").append(i).append(" = ");
                                    sql.append("ta.ASSTITEM").append(i);
                                }
                            }
                            sql.append(") ,");
                        }

                        private void setEndUpdt(StringBuffer sql, String yearcolumn, String endcolumn, String curMaxYearPeriod) {
                            sql.append("\n ").append(endcolumn).append(" = ").append(" to_decimal(0.0,19,4)   ");
                            sql.append(" + ").append(yearcolumn);
                            sql.append(" \n     + ISNULL((select ").append(endcolumn).append(" from ").append(this.tempTableName);
                            sql.append(" tc ").append(" where tc.FPERIOD = ").append(curMaxYearPeriod).append(" and tc.faccountid = ");
                            sql.append(this.tempTableName).append(".faccountid ");
                            if (params.getBoolean("isExportToExcel")) {
                                List itemList = (List)params.getObject("actList");
                                int itemCount = itemList.size();
                                for (int i = 0; i < itemCount; ++i) {
                                    sql.append(" and ").append(this.tempTableName).append(".ASSTITEM").append(i).append(" = ");
                                    sql.append("tc.ASSTITEM").append(i);
                                }
                            }
                            sql.append(" ),0.0000),");
                        }
                    }
                    MyInnerClass0 myInner0 = new MyInnerClass0(balanceTempTable);
                    myInner0.setYearUpdt(updateBalance, "FYEARDEBIT", "FDEBIT", fromYearPeriod, toYearPeriod);
                    myInner0.setYearUpdt(updateBalance, "FYearCredit", "FCredit", fromYearPeriod, toYearPeriod);
                    updateBalance.deleteCharAt(updateBalance.length() - 1);
                    updateBalance.append("\n   where FPERIOD >= ").append(fromYearPeriod);
                    updateBalance.append("\n   and FPERIOD <= ").append(toYearPeriod);
                    this.executeUpdate(ctx, updateBalance.toString(), null);
                    updateBalance.setLength(0);
                    updateBalance.append(" update  ").append(balanceTempTable).append(" set   ");
                    myInner0.setEndUpdt(updateBalance, "(FYEARDEBIT - FYEARCredit)", "FENDBALANCE", curMaxYearPeriod);
                    updateBalance.deleteCharAt(updateBalance.length() - 1);
                    updateBalance.append("\n   where FPERIOD >= ").append(fromYearPeriod);
                    updateBalance.append("\n   and FPERIOD <= ").append(toYearPeriod);
                    this.executeUpdate(ctx, updateBalance.toString(), null);
                    updateBalance.setLength(0);
                }
            }
            updateBalance.append(" update  ").append(balanceTempTable).append(" set   ");
            myInner.setBeginUpdt(updateBalance, "FBEGINBALANCE", "FENDBALANCE", "(FDEBIT - FCredit)");
            updateBalance.deleteCharAt(updateBalance.length() - 1);
            updateBalance.append("\n   where FPERIOD > ").append(curPeriodOrder);
            this.executeUpdate(ctx, updateBalance.toString(), null);
        }
    }

    protected String[][] getHeadAndFields(Context ctx, RptParams params) {
        ArrayList<String> head = new ArrayList<String>();
        ArrayList<String> fields = new ArrayList<String>();
        List itemList = (List)params.getObject("actList");
        int itemCount = itemList.size();
        for (int i = 0; i < itemCount; ++i) {
            fields.add("ASSTITEM" + i);
            AsstactTypeEntity at = (AsstactTypeEntity)itemList.get(i);
            head.add(at.getName());
        }
        fields.add("FAccountNumber");
        fields.add("FAccountName");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        if (!company.isIsBizUnit()) {
            fields.add("FCompanyName");
        }
        fields.add("FPeriod");
        head.add(GLResUtil.getRes("accountView_number", ctx));
        head.add(GLResUtil.getRes("accountView_name", ctx));
        if (!company.isIsBizUnit()) {
            head.add(GLResUtil.getRes("company", ctx));
        }
        head.add(GLResUtil.getRes("period", ctx));
        String RES_PATH = "com.kingdee.eas.fi.gl.GLRes";
        fields.add("FDC");
        fields.add("FBEGINBALANCE");
        head.add(ResourceBase.getString((String)RES_PATH, (String)"balance_period_begin", (Locale)ctx.getLocale()));
        head.add(ResourceBase.getString((String)RES_PATH, (String)"balance_period_begin", (Locale)ctx.getLocale()));
        fields.add("FDEBIT");
        head.add(ResourceBase.getString((String)RES_PATH, (String)"dir_debit", (Locale)ctx.getLocale()));
        fields.add("FCREDIT");
        head.add(ResourceBase.getString((String)RES_PATH, (String)"dir_credit", (Locale)ctx.getLocale()));
        fields.add("FYEARDEBIT");
        head.add(ResourceBase.getString((String)RES_PATH, (String)"debit_year_sum", (Locale)ctx.getLocale()));
        fields.add("FYEARCREDIT");
        head.add(ResourceBase.getString((String)RES_PATH, (String)"debit_period_sum", (Locale)ctx.getLocale()));
        fields.add("FDC");
        fields.add("FENDBALANCE");
        head.add(ResourceBase.getString((String)RES_PATH, (String)"balance_period_end", (Locale)ctx.getLocale()));
        head.add(ResourceBase.getString((String)RES_PATH, (String)"balance_period_end", (Locale)ctx.getLocale()));
        String[][] headAndFields = new String[][]{fields.toArray(new String[fields.size()]), head.toArray(new String[head.size()])};
        return headAndFields;
    }

    protected String createMainTempTable(Context ctx, RptParams params, String balanceTempTable, boolean isExpand, int index) throws BOSException, EASBizException {
        List itemList;
        int i;
        boolean showOnlySubAccountview;
        SqlParams sp;
        StringBuffer sql;
        boolean isUnit;
        String accountName;
        String companyId;
        boolean isAccountShowLongName;
        CompanyOrgUnitInfo company;
        int levelTo;
        int levelFrom;
        String userId;
        String loc;
        block60: {
            List actList;
            block59: {
                loc = this.getLoc(ctx);
                userId = params.getString("userId");
                String tempTable = params.getString("tempTable");
                actList = (List)params.getObject("actList");
                Object currencyIdObj = params.getObjectElement("jbxCurrency.value.id");
                String currencyId = currencyIdObj == null ? null : currencyIdObj.toString();
                levelFrom = (Integer)params.getObjectElement("jspLevelFrom.value");
                levelTo = (Integer)params.getObjectElement("jspLevelTo.value");
                company = (CompanyOrgUnitInfo)params.getObject("company");
                int yearEnd = (Integer)params.getObjectElement("jspYearTo.value");
                int numberEnd = (Integer)params.getObjectElement("jspPeriodTo.value");
                String curAcctTableID = company.getAccountTable().getId().toString();
                AccountRefContrastInfo ar = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(company.getCU().getId().toString(), curAcctTableID, yearEnd, numberEnd);
                if (ar != null && ar.getEnabledAcctTable() != null) {
                    company.setAccountTable(RptClientUtil.periodCheckForAccountRefContrast(ar, yearEnd, numberEnd) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable());
                }
                RptParams sysParams = (RptParams)params.getObject("sysParams");
                isAccountShowLongName = sysParams.getBoolean("GL_012");
                companyId = company.getId().toString();
                accountName = this.getAccountName(ctx, isAccountShowLongName);
                isUnit = GlUtils.isCompanyUnion(company);
                sql = new StringBuffer();
                sp = new SqlParams();
                if (index != 0) {
                    sql.append(" insert into ").append(balanceTempTable);
                }
                if (isUnit) {
                    sql.append(" SELECT ");
                    if (params.getBoolean("isExportToExcel")) {
                        boolean isShowLongNumber = sysParams.getBoolean("GL_064");
                        int size = actList.size();
                        for (int i2 = 0; i2 < size; ++i2) {
                            Object asstActType = actList.get(i2);
                            if (asstActType instanceof AsstactTypeEntity && (((AsstactTypeEntity)asstActType).isUseGroup() || isShowLongNumber && ((AsstactTypeEntity)asstActType).getHgAttribute().startsWith("general"))) {
                                sql.append(" replace(tc.ASSTITEM").append(i2).append(",'!','.') ASSTITEM").append(i2).append(",");
                                continue;
                            }
                            sql.append(" tc.ASSTITEM").append(i2).append(",");
                        }
                        sql.append(" tc.isTotal,");
                    }
                    sql.append(" tc.FACCOUNTNUMBER,").append(" tc.FACCOUNTNAME,").append(" tc.FPeriodYear,tc.FPeriodNumber,tc.fdc,tc.isleaf ,tc.flevel,").append(" PCOM.FNumber FCompanyNumber,PCOM.FLongNumber CompanyLongNumber,  pcom.fname_").append(loc).append(" FCompanyName,PCOM.flevel FCompanyLevel,PCOM.fisbizUnit FCOMPANYLEAF").append(" ,PCOM.fid FCompanyID,PCOM.fparentid FParentID,tc.FperiodID, ").append("\n sum (tc.FBEGINBALANCE) FBEGINBALANCE,").append(" sum (tc.FYEARDEBIT) FYEARDEBIT,").append(" sum (tc.FYEARCREDIT) FYEARCREDIT,").append(" sum (tc.FDEBIT) FDEBIT,").append(" sum (tc.FCREDIT) FCREDIT,").append(" sum (tc.FENDBALANCE) FENDBALANCE, ").append("  tc.FPeriodYear*100 + tc.FPeriodNumber FPERIOD ").append(" FROM ( ");
                    if (index == 0) {
                        sql.append(" \n into ").append(balanceTempTable).append("\n ");
                    }
                }
                showOnlySubAccountview = true;
                if (params.getObjectElement("jcbShowOnlySubAccountview.value") != null) {
                    showOnlySubAccountview = (Boolean)params.getObjectElement("jcbShowOnlySubAccountview.value");
                }
                if (showOnlySubAccountview) {
                    levelTo = AccountUtils.getMaxAccountLeve((Context)ctx, (IObjectPK)new ObjectUuidPK(company.getId()));
                    levelFrom = 1;
                }
                if (!showOnlySubAccountview) {
                    sql.append(" SELECT ");
                    if (params.getBoolean("isExportToExcel")) {
                        boolean isShowLongNumber = sysParams.getBoolean("GL_064");
                        int size = actList.size();
                        for (int i3 = 0; i3 < size; ++i3) {
                            Object asstActType = actList.get(i3);
                            if (asstActType instanceof AsstactTypeEntity && (((AsstactTypeEntity)asstActType).isUseGroup() || isShowLongNumber && ((AsstactTypeEntity)asstActType).getHgAttribute().startsWith("general"))) {
                                sql.append(" replace(t.ASSTITEM").append(i3).append(",'!','.') ASSTITEM").append(i3).append(",");
                                continue;
                            }
                            sql.append(" t.ASSTITEM").append(i3).append(",");
                        }
                        sql.append(" t.isTotal,");
                    }
                    sql.append(" pacct.fnumber FACCOUNTNUMBER,").append(" pacct.").append(isAccountShowLongName ? "FLongName_" : "FName_").append(loc).append(" FACCOUNTNAME,").append(" t.FCompanyName,t.FCompanyNumber,t.FCompanyLevel,t.FCOMPANYLEAF,t.FCompanyID,t.fparentid FParentID,").append(" t.FPeriodYear,t.FPeriodNumber,pacct.fdc, pacct.fisleaf isleaf,pacct.flevel,t.FperiodID,pacct.FID FAccountId, ").append("\n sum (t.FBEGINBALANCE) FBEGINBALANCE,").append(" sum (t.FYEARDEBIT) FYEARDEBIT,").append(" sum (t.FYEARCREDIT) FYEARCREDIT,").append(" sum (t.FDEBIT) FDEBIT,").append(" sum (t.FCREDIT) FCREDIT,").append(" sum (t.FENDBALANCE) FENDBALANCE ,").append("  t.FPeriodYear*100 + t.FPeriodNumber FPERIOD");
                    if (!isUnit && index == 0) {
                        sql.append(" \n into ").append(balanceTempTable);
                    }
                    sql.append("\n FROM ( ");
                }
                sql.append(" select ");
                if (params.getBoolean("isExportToExcel")) {
                    ArrayList asstActTypeList = (ArrayList)params.getObject("asstActTypeList");
                    List asstItemList = (List)asstActTypeList.get(index);
                    boolean isShowLongNumber = sysParams.getBoolean("GL_064");
                    boolean isShowAsstNumber = sysParams.getBoolean("GL_004");
                    int size = asstItemList.size();
                    for (i = 0; i < size; ++i) {
                        Object asstActType = asstItemList.get(i);
                        if (asstActType instanceof AsstactTypeEntity) {
                            AsstactTypeEntity at = (AsstactTypeEntity)asstActType;
                            if (at.getHgAttribute().startsWith("general")) {
                                if (isShowLongNumber) {
                                    if (isShowAsstNumber) {
                                        sql.append("temp.FLongNumber").append(i).append("||' '||").append("temp.FName").append(i).append(" ASSTITEM").append(i).append(",");
                                        continue;
                                    }
                                    sql.append("temp.FLongNumber").append(i).append("||' '||").append("temp.FName").append(i).append(" ASSTITEM").append(i).append(",");
                                    continue;
                                }
                                if (isShowAsstNumber) {
                                    sql.append("temp.FNumber").append(i).append("||' '||").append("temp.FName").append(i).append(" ASSTITEM").append(i).append(",");
                                    continue;
                                }
                                sql.append("temp.FNumber").append(i).append("||' '||").append("temp.FName").append(i).append(" ASSTITEM").append(i).append(",");
                                continue;
                            }
                            if (isShowAsstNumber) {
                                sql.append("temp.FNumber").append(i).append("||' '||").append("temp.FName").append(i).append(" ASSTITEM").append(i).append(",");
                                continue;
                            }
                            sql.append("temp.FNumber").append(i).append("||' '||").append("temp.FName").append(i).append(" ASSTITEM").append(i).append(",");
                            continue;
                        }
                        if (index == 0) {
                            sql.append(" N'").append(asstActType.toString()).append("                                                                                                                                                                                ' ASSTITEM").append(i).append(",");
                            continue;
                        }
                        sql.append(" N'").append(asstActType.toString()).append("' ASSTITEM").append(i).append(",");
                    }
                    sql.append(" 0 isTotal,");
                }
                sql.append(" AV.FNumber FAccountNumber, ").append(accountName).append(loc).append(" FAccountName, com.fname_").append(loc).append(" FCompanyName,com.fnumber FCompanyNumber,com.flevel FCompanyLevel,com.fisbizUnit FCOMPANYLEAF,").append(" \n com.fid FCompanyID,com.fparentid FParentID,PE.FPeriodYear, PE.FPeriodNumber, AV.FDC,AV.fisleaf isleaf, AV.FLEVEL, ");
                sql.append(" av.fid FACCOUNTID,PE.FID FperiodID ,");
                String yeSuffix = null;
                yeSuffix = RptClientUtil.isGeneralLocalCurrency(currencyId) ? "Local" : (RptClientUtil.isGeneralReportCurrency(currencyId) ? "Rpt" : "For");
                sql.append("sum(FBeginBalance").append(yeSuffix).append(") FBeginBalance, sum(FYearDebit").append(yeSuffix).append(") FYearDebit, sum(FYearCredit").append(yeSuffix).append(") FYearCredit, sum(FDebit").append(yeSuffix).append(") FDebit, sum(FCredit").append(yeSuffix).append(") FCredit, sum(FEndBalance").append(yeSuffix).append(") FEndBalance,");
                sql.append("  PE.FNumber FPERIOD ");
                if (index == 0 && showOnlySubAccountview && !isUnit) {
                    sql.append(" \n into ").append(balanceTempTable);
                }
                sql.append("\n from t_bd_assistanthg HG ");
                sql.append("\n inner join ").append(this.getAssistBalanceTable(ctx, params)).append(" GL on GL.fassistgrpid=HG.fid ");
                sql.append("\n inner join T_BD_Period PE on PE.FID=GL.FPeriodID ");
                sql.append("\n inner join T_BD_AccountView AV on AV.FID=GL.FAccountID ");
                sql.append("\n inner join t_Org_Company com on com.fid=GL.Forgunitid ");
                sql.append("\n inner join ").append(tempTable).append(" temp ");
                if (!params.getBoolean("isExportToExcel")) break block59;
                for (int i4 = 0; i4 < actList.size(); ++i4) {
                    AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i4);
                    sql.append(i4 == 0 ? " on " : " and ");
                    sql.append(" temp.FID").append(i4).append("=HG.").append(at.getHgField());
                }
                ArrayList asstActItemList = (ArrayList)params.getObject("actList");
                int assActNum = 0;
                for (int i5 = 0; i5 < asstActItemList.size(); ++i5) {
                    if (!(asstActItemList.get(i5) instanceof AsstactTypeEntity)) continue;
                    ++assActNum;
                }
                ArrayList selectAsstActList = (ArrayList)params.getObject("selectedAsstAct");
                if (selectAsstActList == null) break block60;
                boolean first = true;
                for (int i6 = 0; i6 < selectAsstActList.size(); ++i6) {
                    int j;
                    ArrayList asstActList = (ArrayList)selectAsstActList.get(i6);
                    int num = 0;
                    for (j = 0; j < asstActList.size(); ++j) {
                        if (!(asstActList.get(j) instanceof LabelValueBean)) continue;
                        ++num;
                    }
                    if (num != assActNum) continue;
                    if (first) {
                        sql.append(" and ((");
                        first = false;
                    } else {
                        sql.append(" or (");
                    }
                    for (j = 0; j < asstActList.size(); ++j) {
                        AsstactTypeEntity at = (AsstactTypeEntity)actList.get(j);
                        Object value = asstActList.get(j);
                        if (value instanceof LabelValueBean) {
                            LabelValueBean item = (LabelValueBean)asstActList.get(j);
                            sql.append(j == 0 ? "" : " and ");
                            if (item instanceof LabelValueBean) {
                                Object isLeafObj = item.getProperty("FISLeaf");
                                if (isLeafObj != null && isLeafObj instanceof Integer && (Integer)isLeafObj == 1) {
                                    sql.append(" HG.").append(at.getHgField()).append(" = ? ");
                                    sp.addString(item.getValue());
                                } else {
                                    sql.append(" (charIndex('");
                                    sql.append(item.getProperty("FLongNumber"));
                                    sql.append("!',temp.FLongNumber").append(j).append(")=1 or ");
                                    sql.append("temp.FID").append(j).append(" = ?)");
                                    sp.addString(item.getValue());
                                }
                            }
                        }
                        if (j != asstActList.size() - 1) continue;
                        sql.append(") ");
                    }
                }
                if (first) break block60;
                sql.append(")");
                break block60;
            }
            itemList = (List)params.getObject("itemList");
            int itemCount = itemList.size();
            for (int i7 = 0; i7 < itemCount; ++i7) {
                int n;
                Set s;
                AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i7);
                Object item = itemList.get(i7);
                sql.append(i7 == 0 ? " on " : " and ");
                sql.append("temp.FID").append(i7).append("=HG.").append(at.getHgField());
                if (at.isMultilevel() && at.getSelectedLevel() != at.getMaxLevel()) {
                    if (item instanceof LabelValueBean) {
                        sql.append(" and (charIndex('").append(((LabelValueBean)item).getProperty("FLongNumber")).append("!',").append("temp.FLongNumber").append(i7).append(")=1 or '").append(((LabelValueBean)item).getProperty("FLongNumber")).append("'=").append("temp.FLongNumber").append(i7).append(")");
                        continue;
                    }
                    s = (Set)item;
                    sql.append(" and (");
                    n = 0;
                    for (LabelValueBean itemLvb : s) {
                        sql.append(n == 0 ? "" : " or ");
                        String longNumber = itemLvb.getProperty("FLongNumber").toString();
                        sql.append(" (charIndex('").append(longNumber).append("!',").append("temp.FLongNumber").append(i7).append(")=1 or '").append(longNumber).append("'=").append("temp.FLongNumber").append(i7).append(")");
                        ++n;
                    }
                    if (n == 0) {
                        sql.append(" 1 = 1 ");
                    }
                    sql.append(")");
                    continue;
                }
                if (item instanceof LabelValueBean) {
                    sql.append(" and ").append("temp.FID").append(i7).append("=?");
                    sp.addString(((LabelValueBean)item).getValue());
                    continue;
                }
                s = (Set)item;
                sql.append(" and (");
                n = 0;
                for (LabelValueBean itemLvb : s) {
                    sql.append(n == 0 ? "" : " or ");
                    sql.append("temp.FID").append(i7).append("=?");
                    sp.addString(itemLvb.getValue());
                    ++n;
                }
                if (n == 0) {
                    sql.append(" 1 = 1 ");
                }
                sql.append(")");
            }
        }
        if (isExpand) {
            sql.append("\n and PE.Fid=?");
            sp.addString((String)params.getObject("PeriodID"));
            if (showOnlySubAccountview) {
                sql.append("\n and av.FNumber=?");
                sp.addString((String)params.getObject("AccountID"));
            }
        }
        sql.append("\n group by ");
        if (params.getBoolean("isExportToExcel")) {
            List asstActTypeList = (List)params.getObject("asstActTypeList");
            List asstItemList = (List)asstActTypeList.get(index);
            int itemCount = asstItemList.size();
            for (i = 0; i < itemCount; ++i) {
                if (!(asstItemList.get(i) instanceof AsstactTypeEntity)) continue;
                sql.append("temp.FNumber").append(i).append(",");
                sql.append("temp.FLongNumber").append(i).append(",");
                sql.append("temp.FName").append(i).append(",");
            }
        }
        sql.append(" AV.FNumber, ").append(accountName).append(loc).append(", com.fname_").append(loc);
        sql.append(",com.fnumber ,com.flevel,com.fisbizUnit,com.fid,com.fparentid,PE.FNumber,PE.FPeriodYear, PE.FPeriodNumber, AV.FDC,AV.fisleaf ,AV.FLEVEL,av.fid,PE.FID");
        if (!showOnlySubAccountview) {
            sql.append(") t");
            sql.append("\n INNER JOIN t_BD_AccountView ACCT ON t.FAccountID = acct.FID ");
            sql.append("\n INNER JOIN T_BD_AccountView PACCT  ").append(" ON PACCT.FCompanyID ='");
            sql.append(company.getId().toString()).append("'");
            sql.append(" AND PACCT.faccounttableid = '");
            sql.append(company.getAccountTable().getId().toString()).append("'");
            sql.append(" AND acct.faccounttableid = '");
            sql.append(company.getAccountTable().getId().toString()).append("'");
            sql.append(" AND charindex(pacct.FLongNumber ||'!',acct.FLongNumber || '!') = 1  ").append(" AND pacct.flevel>= " + levelFrom + " and pacct.flevel<= " + levelTo);
            sql.append("\n").append(RptServerUtil.innerJoinAccountPermissionSql("PACCT", userId, companyId, ctx));
            if (isExpand) {
                sql.append("\n where pacct.FNumber=?");
                sp.addString((String)params.getObject("AccountID"));
            }
            sql.append("\n GROUP BY ");
            if (params.getBoolean("isExportToExcel")) {
                itemList = (List)params.getObject("actList");
                int itemCount = itemList.size();
                for (int i8 = 0; i8 < itemCount; ++i8) {
                    sql.append(" t.ASSTITEM").append(i8).append(",");
                }
                sql.append("t.isTotal,");
            }
            sql.append(" pacct.fnumber,pacct.").append(isAccountShowLongName ? "FLongName_" : "FName_").append(loc).append(",");
            sql.append("t.FCompanyName,t.FCompanyNumber,t.FCompanyLevel,t.FCOMPANYLEAF,t.FCompanyId,");
            sql.append("t.fparentid,t.FPeriodYear, t.FPeriodNumber, pacct.FDC, pacct.fisleaf,pacct.flevel,t.FperiodID,pacct.FId  ");
        }
        if (isUnit) {
            sql.append(") tc");
            sql.append("\n INNER JOIN T_Org_Company COM ON tc.FCompanyId = com.FID ");
            sql.append("\n INNER JOIN T_Org_Company PCOM ON  charindex(PCOM.FLongNumber ||'!',COM.FLongNumber || '!') = 1  ");
            if (isExpand) {
                int level = (Integer)params.getObject("level");
                String parent = (String)params.getObject("parent");
                sql.append(" AND PCOM.Flevel =").append(level).append(" AND PCOM.FParentId = '").append(parent).append("' ");
            } else {
                Object expandLevel = params.getObjectElement("spCompanyLevel.value");
                if (expandLevel != null && Integer.parseInt(expandLevel.toString()) > 1) {
                    sql.append(" AND PCOM.Flevel >=").append(company.getLevel());
                    sql.append(" AND PCOM.Flevel <").append(company.getLevel() + Integer.parseInt(expandLevel.toString()));
                } else {
                    sql.append(" AND PCOM.Flevel =").append(company.getLevel());
                }
            }
            sql.append("\n GROUP BY ");
            if (params.getBoolean("isExportToExcel")) {
                List itemList2 = (List)params.getObject("actList");
                int itemCount = itemList2.size();
                for (int i9 = 0; i9 < itemCount; ++i9) {
                    sql.append(" tc.ASSTITEM").append(i9).append(",");
                }
                sql.append("tc.isTotal,");
            }
            sql.append(" tc.FACCOUNTNUMBER,tc.FACCOUNTNAME,PCOM.FNumber,PCOM.FLongNumber,");
            sql.append("PCOM.FName_").append(loc).append(",PCOM.flevel,PCOM.fisbizUnit,PCOM.fid,PCOM.fparentid,");
            sql.append("tc.FPeriodYear, tc.FPeriodNumber, tc.FDC, tc.isleaf,tc.flevel,tc.FperiodID ");
        }
        if (index == 0) {
            return this.executeCreateTableAsSelectInto(sql.toString(), sp, ctx).getTempTable();
        }
        this.executeUpdate(ctx, sql.toString(), sp);
        return null;
    }

    protected CompanyOrgUnitInfo fullCompany(Context ctx, CompanyOrgUnitInfo company) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select cp.fid cpId, cp.fnumber cpNumber,cp.fname_").append(this.getLoc(ctx)).append(" cpName,cp.fcontrolunitid cpCuid, cp.fisbizunit cpIsbizunit,");
        sql.append("pt.fid ptId, pt.fnumber ptNumber, pt.fName_").append(this.getLoc(ctx)).append(" ptName,");
        sql.append("at.fid atId, at.fnumber atNumber, at.fName_").append(this.getLoc(ctx)).append(" atName,");
        sql.append("bc.fid bcId, bc.fnumber bcNumber, bc.fname_").append(this.getLoc(ctx)).append(" bcName,bc.fprecision bcPrecision,");
        sql.append("rc.fid rcId, rc.fnumber rcNumber, rc.fname_").append(this.getLoc(ctx)).append(" rcName,rc.fprecision rcPrecision ");
        sql.append(" from t_org_company cp ");
        sql.append(" left outer join t_bd_periodtype pt on pt.fid = cp.faccountperiodid");
        sql.append(" left outer join t_bd_accounttable at on at.fid = cp.faccounttableid");
        sql.append(" left outer join t_bd_currency bc on bc.fid = cp.fbasecurrencyid");
        sql.append(" left outer join t_bd_currency rc on rc.fid = cp.freportcurrencyid");
        sql.append(" where cp.fid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString()});
        try {
            if (rs.next()) {
                String rcId;
                String bcId;
                String atId;
                String ptId;
                company.setNumber(rs.getString("cpNumber"));
                company.setName(rs.getString("cpName"));
                company.setIsBizUnit(rs.getBoolean("cpIsbizunit"));
                String cpCuid = rs.getString("cpCuid");
                if (cpCuid != null) {
                    CtrlUnitInfo cu = new CtrlUnitInfo();
                    cu.setId(BOSUuid.read((String)cpCuid));
                    company.setCU(cu);
                }
                if ((ptId = rs.getString("ptId")) != null) {
                    PeriodTypeInfo typeInfo = new PeriodTypeInfo();
                    typeInfo.setId(BOSUuid.read((String)ptId));
                    typeInfo.setNumber(rs.getString("ptNumber"));
                    typeInfo.setName(rs.getString("ptName"));
                    company.setAccountPeriodType(typeInfo);
                }
                if ((atId = rs.getString("atId")) != null) {
                    AccountTableInfo accTableInfo = new AccountTableInfo();
                    accTableInfo.setId(BOSUuid.read((String)atId));
                    accTableInfo.setNumber(rs.getString("atNumber"));
                    accTableInfo.setName(rs.getString("atName"));
                    company.setAccountTable(accTableInfo);
                }
                if ((bcId = rs.getString("bcId")) != null) {
                    CurrencyInfo baseCurrency = new CurrencyInfo();
                    baseCurrency.setId(BOSUuid.read((String)bcId));
                    baseCurrency.setNumber(rs.getString("bcNumber"));
                    baseCurrency.setName(rs.getString("bcName"));
                    baseCurrency.setPrecision(rs.getInt("bcPrecision"));
                    company.setBaseCurrency(baseCurrency);
                }
                if ((rcId = rs.getString("rcId")) != null) {
                    CurrencyInfo rptCurrency = new CurrencyInfo();
                    rptCurrency.setId(BOSUuid.read((String)rcId));
                    rptCurrency.setNumber(rs.getString("rcNumber"));
                    rptCurrency.setName(rs.getString("rcName"));
                    rptCurrency.setPrecision(rs.getInt("rcPrecision"));
                    company.setReportCurrency(rptCurrency);
                }
            }
            return company;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAssistBalanceTable(Context ctx, RptParams params) throws EASBizException, BOSException {
        boolean sumByMU;
        if (params.getString("balanceTempTable") != null) {
            return params.getString("balanceTempTable");
        }
        boolean displayAmount = false;
        if (params.getObjectElement("jcbDisplayAmount.value") != null) {
            displayAmount = (Boolean)params.getObjectElement("jcbDisplayAmount.value");
        }
        String asstAccountID = (String)params.getObjectElement("jebAcct.value.id.toString");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        boolean isUnit = GlUtils.isCompanyUnion(company);
        String cuId = params.getString("cuId");
        String userId = params.getString("userId");
        StringBuffer selectSQL = new StringBuffer("select GL.FOrgUnitID,GL.FAccountID,GL.FPeriodID,GL.fassistgrpid,GL.FCurrencyID,");
        selectSQL.append("GL.FBeginBalanceFor,GL.FBeginBalanceLocal,GL.FBeginBalanceRpt, ");
        selectSQL.append("GL.FYearDebitFor,GL.FYearDebitLocal,GL.FYearDebitRpt, ");
        selectSQL.append("GL.FYearCreditFor,GL.FYearCreditLocal,GL.FYearCreditRpt, ");
        selectSQL.append("GL.FDebitFor,GL.FDebitLocal,GL.FDebitRpt, GL.FCreditFor,GL.FCreditLocal,GL.FCreditRpt, ");
        selectSQL.append("GL.FEndBalanceFor,GL.FEndBalanceLocal,GL.FEndBalanceRpt ");
        if (displayAmount) {
            selectSQL.append(",GL.FBeginQty,GL.FYearDebitQty,GL.FYearCreditQty,GL.FDebitQty,GL.FCreditQty,GL.FEndQty ");
        }
        if (sumByMU = Boolean.valueOf(String.valueOf(params.getObjectElement("jcbSumByMeasureUnit.value"))).booleanValue()) {
            selectSQL.append(",GL.fmeasureunitid,GL.Fbaltype ");
        }
        StringBuffer fromSQL = new StringBuffer();
        StringBuffer whereSQL = new StringBuffer();
        fromSQL.append("\n from t_bd_assistanthg HG ");
        SqlParams sp = new SqlParams();
        this.appendJoinFilterSql(ctx, fromSQL, sp, params, true, isUnit);
        if (asstAccountID != null) {
            whereSQL.append(" where HG.FAsstAccountID = ? ");
            sp.addString(asstAccountID);
        }
        List list = (List)params.getObject("actList");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            String tab = "T_" + i;
            String tmpName = "B_" + i;
            fromSQL.append("\n inner join ").append(at.getTableName()).append(" ").append(tab).append(" on HG.").append(at.getHgField()).append("=").append(tab).append(".FID");
            if (at.isUseGroup() && (at.getFrom() != null || at.getTo() != null)) {
                fromSQL.append(" left join ").append(at.getGroupTable()).append(" ").append(tmpName).append(" on ").append(tmpName).append(".FID=").append(tab).append(".").append(at.getGroupField());
            }
            if (at.isGeneralActType()) {
                fromSQL.append(" and ").append(tab).append(".FGroupID='").append(at.getGeneralAsstactGroupId()).append("'");
            }
            if (at.getFrom() != null) {
                whereSQL.append(whereSQL.length() == 0 ? "\n where " : " and ");
                if (at.isUseGroup()) {
                    whereSQL.append(" (case when ").append(tmpName).append(".FLongNumber is null then ").append(tab).append(".FNumber else ").append(tmpName).append(".FLongNumber||'!'||");
                    whereSQL.append(tab).append(".FNumber end )").append(">=?");
                } else {
                    whereSQL.append(tab).append(at.isMultilevel() ? ".FLongNumber" : ".FNumber").append(">=?");
                }
                sp.addString(this.getActLongNumber(at, true, ctx));
            }
            if (at.getTo() != null) {
                whereSQL.append(whereSQL.length() == 0 ? "\n where " : " and ");
                if (at.isUseGroup()) {
                    whereSQL.append(" (case when ").append(tmpName).append(".FLongNumber is null then ").append(tab).append(".FNumber else ").append(tmpName).append(".FLongNumber||'!'||");
                    whereSQL.append(tab).append(".FNumber end )").append("<=?");
                } else {
                    whereSQL.append(tab).append(at.isMultilevel() ? ".FLongNumber" : ".FNumber").append("<=?");
                }
                sp.addString(this.getActLongNumber(at, false, ctx));
            }
            if (!at.isEnabledPermissionLimit()) continue;
            fromSQL.append("\n").append(RptServerUtil.innerJoinAsstactPermissionSql("HG." + at.getHgField(), at.getPermissionItem(), userId, cuId, ctx));
        }
        String sqlGetData = selectSQL.toString() + fromSQL.toString() + whereSQL.toString();
        boolean includeNoTransPLVoucher = false;
        if (params.getObjectElement("jcbincludeNoTransPLVoucher.value") != null) {
            includeNoTransPLVoucher = (Boolean)params.getObjectElement("jcbincludeNoTransPLVoucher.value");
        }
        String balanceTempTable = null;
        if (includeNoTransPLVoucher) {
            String plVoucherBalance = this.getPLVoucherBalance(ctx, params);
            StringBuffer sql = new StringBuffer("select t1.FOrgUnitID,t1.FAccountID,t1.FPeriodID,t1.fassistgrpid,t1.FCurrencyID,");
            sql.append("t1.FBeginBalancelocal").append(" - isnull(t2.fbeginbalancelocal,0) FBeginBalancelocal,");
            sql.append("t1.FBeginBalancerpt").append(" - isnull(t2.fbeginbalancerpt,0) FBeginBalancerpt,");
            sql.append("t1.FBeginBalancefor").append(" - isnull(t2.fbeginbalancefor,0) FBeginBalancefor,");
            sql.append("t1.FYearDebitlocal - isnull(t2.FYearDebitlocal,0) FYearDebitlocal,");
            sql.append("t1.FYearDebitrpt - isnull(t2.FYearDebitrpt,0) FYearDebitrpt,");
            sql.append("t1.FYearDebitfor - isnull(t2.FYearDebitFor,0) FYearDebitfor,");
            sql.append("t1.FYearCreditlocal - isnull(t2.FYearCreditlocal,0) FYearCreditlocal,");
            sql.append("t1.FYearCreditrpt - isnull(t2.FYearCreditrpt,0) FYearCreditrpt,");
            sql.append("t1.FYearCreditfor - isnull(t2.FYearCreditFor,0) FYearCreditfor,");
            sql.append("t1.FDebitlocal - isnull(t2.fdebitlocal,0) FDebitlocal,");
            sql.append("t1.FDebitrpt - isnull(t2.fdebitrpt,0) FDebitrpt,");
            sql.append("t1.FDebitfor - isnull(t2.fdebitfor,0) FDebitfor,");
            sql.append("t1.FCreditlocal - isnull(t2.fcreditlocal,0) FCreditlocal,");
            sql.append("t1.FCreditrpt - isnull(t2.fcreditrpt,0) FCreditrpt,");
            sql.append("t1.FCreditfor - isnull(t2.fcreditfor,0) FCreditfor,");
            sql.append("t1.FEndBalancelocal - isnull(t2.FEndBalancelocal,0) FEndBalancelocal,");
            sql.append("t1.FEndBalancerpt - isnull(t2.FEndBalancerpt,0) FEndBalancerpt,");
            sql.append("t1.FEndBalancefor - isnull(t2.FEndBalanceFor,0) FEndBalancefor");
            if (displayAmount) {
                sql.append(",t1.FBeginqty").append(" - isnull(t2.fbeginqty,0) FBeginqty,");
                sql.append("t1.FYearDebitqty - isnull(t2.FYearDebitqty,0) FYearDebitqty,");
                sql.append("t1.FYearCreditqty - isnull(t2.FYearCreditqty,0) FYearCreditqty,");
                sql.append("t1.FDebitqty - isnull(t2.fdebitqty,0) FDebitqty,");
                sql.append("t1.FCreditqty - isnull(t2.fcreditqty,0) FCreditqty,");
                sql.append("t1.FEndqty - isnull(t2.FEndqty,0) FEndqty");
            }
            if (sumByMU) {
                sql.append(",t1.fmeasureunitid,t1.Fbaltype ");
            }
            sql.append(" from (").append(sqlGetData).append(") t1 \r\n");
            sql.append(" left outer join ").append(plVoucherBalance).append(" t2 on t1.FOrgUnitID = t2.fcompanyid ");
            sql.append(" and t1.FAccountID = t2.FAccountID and t1.FPeriodID = t2.FPeriodID and t1.fassistgrpid = t2.fassgrpid and t1.FCurrencyID = t2.FCurrencyID ");
            try {
                balanceTempTable = this.executeCreateTableAsSelectInto("select * into TEMP_GL_GG_Balance from (" + sql.toString() + ") as tempTable ", sp, ctx).getTempTable();
            }
            finally {
                this.dropPoolTempTable(ctx, plVoucherBalance);
            }
        } else {
            balanceTempTable = this.executeCreateTableAsSelectInto("select * into TEMP_GL_GG_Balance from (" + sqlGetData + ") as tempTable ", sp, ctx).getTempTable();
        }
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(balanceTempTable, "FAssistGrpID,FPeriodID,FAccountID,FOrgUnitID", false, false);
        }
        catch (Exception e) {
            logger.error((Object)"Create Index ERROR", (Throwable)e);
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, balanceTempTable);
        }
        catch (Exception e) {
            logger.error((Object)"Analye Table ERROR", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return balanceTempTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPLVoucherBalance(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        String currencyID = String.valueOf(params.getObjectElement("jbxCurrency.value.id"));
        boolean includeUnPost = (Boolean)params.getObjectElement("jcbIncludeUnPost.value");
        SqlParams sp = new SqlParams();
        StringBuffer sql = new StringBuffer();
        sql.append(" select pd.fperiodyear,pd.fperiodnumber,pd.fnumber,v.fcompanyid,v.fperiodid,ve.faccountid,r.fassgrpid,");
        if (currencyID == null) {
            sql.append("ve.fcurrencyid,");
        } else {
            sql.append("'").append(currencyID).append("' fcurrencyid,");
        }
        sql.append(" sum(case ve.FEntryDC when ").append(1).append(" then r.FLocalAmount else 0 end) fdebitlocal, \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(0).append(" then r.FLocalAmount else 0 end) fcreditlocal, \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(1).append(" then r.FReportingAmount else 0 end) fdebitrpt,  \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(0).append(" then r.FReportingAmount else 0 end) fcreditrpt, \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(1).append(" then r.FOriginalAmount else 0 end) fdebitfor,   \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(0).append(" then r.FOriginalAmount else 0 end) fcreditfor,  \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(1).append(" then r.FStandardQuantity else 0 end) fdebitqty,   \r\n");
        sql.append(" sum(case ve.FEntryDC when ").append(0).append(" then r.FStandardQuantity else 0 end) fcreditqty,  \r\n");
        sql.append(" to_decimal(0.00,19,4) fyeardebitlocal,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fyeardebitrpt,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fyeardebitfor,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fyeardebitqty,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fyearcreditlocal,    \r\n");
        sql.append(" to_decimal(0.00,19,4) fyearcreditrpt,    \r\n");
        sql.append(" to_decimal(0.00,19,4) fyearcreditfor,    \r\n");
        sql.append(" to_decimal(0.00,19,4) fyearcreditqty,    \r\n");
        sql.append(" to_decimal(0.00,19,4) fbeginbalancelocal, \r\n");
        sql.append(" to_decimal(0.00,19,4) fbeginbalancerpt, \r\n");
        sql.append(" to_decimal(0.00,19,4) fbeginbalancefor, \r\n");
        sql.append(" to_decimal(0.00,19,4) fbeginqty, \r\n");
        sql.append(" to_decimal(0.00,19,4) fendbalancelocal,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fendbalancerpt,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fendbalancefor,     \r\n");
        sql.append(" to_decimal(0.00,19,4) fendqty    \r\n");
        sql.append(" from t_gl_voucher v \r\n");
        sql.append(" inner join t_gl_voucherentry ve on ve.fbillid = v.fid \r\n");
        sql.append(" inner join t_gl_voucherassistrecord r on r.fbillid = v.fid and r.fentryid = ve.fid \r\n");
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid \r\n");
        sql.append(" inner join t_bd_period pd on pd.fid = v.fperiodid \r\n");
        sql.append(" where v.fbizstatus ").append(includeUnPost ? " in (1,3,5)" : "=5");
        sql.append(" and fsourcetype = ").append(1);
        if (GlUtils.isCompanyUnion(company)) {
            sql.append(" and v.fcompanyid in (").append(company.getDescription()).append(")");
        } else {
            sql.append(" and v.fcompanyid = ?");
            sp.addString(company.getId().toString());
        }
        sql.append(" and av.faccounttableid = ? ");
        sp.addString(((CompanyOrgUnitInfo)params.getObject("company")).getAccountTable().getId().toString());
        sql.append(" and pd.ftypeid = ?");
        sp.addString(company.getAccountPeriodType().getId().toString());
        sql.append(" and pd.fnumber >= ?").append(" and pd.fnumber <=?");
        int fromNumber = (Integer)params.getObjectElement("jspYearFrom.value") * 100 + (Integer)params.getObjectElement("jspPeriodFrom.value");
        int toNumber = (Integer)params.getObjectElement("jspYearTo.value") * 100 + (Integer)params.getObjectElement("jspPeriodTo.value");
        sp.addInt(fromNumber);
        sp.addInt(toNumber);
        if (currencyID != null && !currencyID.equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !currencyID.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sql.append(" and ve.fcurrencyid = ?");
            sp.addString(currencyID);
        }
        sql.append("\r\n group by v.fcompanyid,v.fperiodid,ve.faccountid,r.fassgrpid \r\n");
        if (currencyID == null) {
            sql.append(",ve.fcurrencyid");
        }
        sql.append(",pd.fnumber,pd.fperiodyear,pd.fperiodnumber");
        String plVoucherTempTable = this.executeCreateTableAsSelectInto("select * into TEMP_GL_GG_PLVOUCHER from (" + sql.toString() + ") as tempTable ", sp, ctx).getTempTable();
        sql = new StringBuffer();
        sql.append("insert into ").append(plVoucherTempTable).append(" select pd.fperiodyear,pd.fperiodnumber,pd.fnumber,");
        sql.append(" t1.fcompanyid,pd.fid,t1.faccountid,t1.fassgrpid,t1.fcurrencyid,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ");
        sql.append(" from (select distinct fcompanyid,faccountid,fassgrpid,fcurrencyid from ").append(plVoucherTempTable).append(")");
        sql.append(" t1 inner join t_bd_period pd on 1 = 1 ");
        sql.append(" where pd.fnumber >= ").append(fromNumber).append(" and pd.fnumber <=").append(toNumber);
        sql.append(" and not exists (select 1 from ").append(plVoucherTempTable).append(" t2 where ");
        sql.append(" t2.fcompanyid = t1.fcompanyid and t2.fperiodid = pd.fid and t2.faccountid =t1.faccountid and t2.fassgrpid = t1.fassgrpid and t2.fcurrencyid = t1.fcurrencyid)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(plVoucherTempTable, "fcompanyid,fperiodid,faccountid,fassgrpid,fcurrencyid", false, false);
        }
        catch (Exception e) {
            logger.error((Object)"Create Index ERROR", (Throwable)e);
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, plVoucherTempTable);
        }
        catch (Exception e) {
            logger.error((Object)"Analye Table ERROR", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        sql.setLength(0);
        sql.append("update ").append(plVoucherTempTable);
        sql.append(" set (fyeardebitlocal,fyeardebitrpt,fyeardebitfor,fyearcreditlocal,fyearcreditrpt,fyearcreditfor,fyeardebitqty,fyearcreditqty,fendbalancelocal,fendbalancerpt,fendbalancefor,fendqty) \r\n");
        sql.append(" = (select t.fyeardebitlocal,t.fyeardebitrpt,t.fyeardebitfor,t.fyearcreditlocal,t.fyearcreditrpt,t.fyearcreditfor,t.fyeardebitqty,fyearcreditqty,t.fendbalancelocal,t.fendbalancerpt,t.fendbalancefor,t.fendqty \r\n");
        sql.append(" from (select t1.fcompanyid companyid,t1.fperiodid periodid,t1.faccountid accountid,t1.fassgrpid assgrpid,t1.fcurrencyid currencyid,");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fdebitlocal else 0 end) fyeardebitlocal,");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fdebitrpt else 0 end) fyeardebitrpt,");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fdebitfor else 0 end) fyeardebitfor,");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fcreditlocal else 0 end) fyearcreditlocal, ");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fcreditrpt else 0 end) fyearcreditrpt, ");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fcreditfor else 0 end) fyearcreditfor, ");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fdebitqty else 0 end) fyeardebitqty, ");
        sql.append(" sum(case when t1.fperiodyear = t2.fperiodyear then t2.fcreditqty else 0 end) fyearcreditqty, ");
        sql.append(" sum(t2.fdebitlocal - t2.fcreditlocal) fendbalancelocal, ");
        sql.append(" sum(t2.fdebitrpt - t2.fcreditrpt) fendbalancerpt, ");
        sql.append(" sum(t2.fdebitfor - t2.fcreditfor) fendbalancefor, ");
        sql.append(" sum(t2.fdebitqty - t2.fcreditqty) fendqty ");
        sql.append(" from ").append(plVoucherTempTable).append(" t1 inner join ").append(plVoucherTempTable).append(" t2 on t1.fcompanyid = t2.fcompanyid and t1.faccountid = t2.faccountid and t1.fassgrpid = t2.fassgrpid and t1.fcurrencyid = t2.fcurrencyid ");
        sql.append(" where t1.fnumber>=t2.fnumber ");
        sql.append(" group by t1.fcompanyid,t1.fperiodid,t1.faccountid,t1.fassgrpid,t1.fcurrencyid) t where t.companyid = fcompanyid and t.periodid = fperiodid and t.accountid = faccountid and t.assgrpid = fassgrpid and t.currencyid = fcurrencyid) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(plVoucherTempTable);
        sql.append(" set fbeginbalancelocal = fendbalancelocal + fcreditlocal - fdebitlocal");
        sql.append(",fbeginbalancerpt = fendbalancerpt + fcreditrpt - fdebitrpt");
        sql.append(",fbeginbalancefor = fendbalancefor + fcreditfor - fdebitfor");
        sql.append(",fbeginqty = fendqty + fcreditqty - fdebitqty");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return plVoucherTempTable;
    }
}

