/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.app.AbstractRptAsstactXBalanceControllerBean;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.CellMatrix;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class RptAsstactXBalanceControllerBean
extends AbstractRptAsstactXBalanceControllerBean {
    private static final long serialVersionUID = -8328134694213558104L;

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        RptParams rp = new RptParams();
        rp.setObject("currencys", (Object)RptServerUtil.getAllCurrency(company.getId().toString(), ctx));
        rp.setObject("periodRange", (Object)RptServerUtil.getPeriodRange(ctx, company));
        rp.setObject("maxLevel", (Object)new Integer(RptServerUtil.getMaxAccountLevel(ctx, company.getId().toString())));
        return rp;
    }

    @Override
    protected RptParams _getAsstactByAccount(Context ctx, RptParams params) throws BOSException, EASBizException {
        SqlParams sp = new SqlParams();
        sp.setString(1, params.getString("fid"));
        String ss = "select B.FID from t_bd_accountview A\n inner join t_bd_accountview B on A.faccounttableid=B.faccounttableid and A.Fcompanyid=B.Fcompanyid\n and charIndex(A.fnumber,  B.fnumber)=1\n where A.fid=? ";
        RptRowSet allIds = this.executeQuery(ss, sp, ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select B.FID as AccountID, B.FNumber as AllAccountNumber, C.FID, C.Fname_").append(this.getLoc(ctx)).append(" FName, C.FNumber, FDefaultQueryName, FIsMultiLevel, FGLAsstActTypeGrpID, FAsstHGAttribute, ").append(" FisForCompany, FRealtionDataObject, FMappingFieldName, FGroupTableName, FGroupMappingFieldName, FUseLongNumber, ").append(" 'true' as fselected, null as ffrom, null as fto, ").append(" C.FPermissionItem, 'true' as FEnablePermissionLimit ").append(" ,  C.fisqty as FQtyAsst , C.FMeasureUnitGroupID as FAsstMeasureUnitGroupId, ").append(" null as FCollect,null as FAsstGroupInfo ,1 as FMaxLevel , 1 as selectedLevel ").append("\n from t_bd_asstactgroupdetail A ").append("\n inner join t_bd_accountview B on B.FCAA=A.Fasstaccountid").append("\n inner join t_bd_asstacttype C on C.Fid=A.Fasstacttypeid").append("\n where B.FID in(\n").append(ss).append("\n )order by B.FNumber,C.FNumber");
        RptRowSet rs = this.executeQuery(sql.toString(), sp, ctx);
        while (rs.next()) {
            String id = rs.getString("AccountID");
            allIds.reset();
            while (allIds.next()) {
                if (!id.equals(allIds.getString("FID"))) continue;
                allIds.remove();
            }
        }
        if (allIds.getRowCount() != 0) {
            rs.removeAllRow();
        } else {
            ArrayList list = new ArrayList();
            ArrayList<String> buf = new ArrayList<String>();
            String accountNumber = null;
            String oldAccountNumber = null;
            rs.reset();
            while (rs.next()) {
                accountNumber = rs.getString("AllAccountNumber");
                if (oldAccountNumber == null) {
                    oldAccountNumber = accountNumber;
                } else if (!accountNumber.equals(oldAccountNumber)) {
                    list.add(buf);
                    buf = new ArrayList();
                    oldAccountNumber = accountNumber;
                }
                buf.add(rs.getString("FNumber"));
            }
            list.add(buf);
            ArrayList actNumberList = (ArrayList)list.get(0);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                actNumberList.retainAll((List)list.get(i));
            }
            rs.reset();
            while (rs.next()) {
                int n2 = actNumberList.indexOf(rs.getString("FNumber"));
                if (n2 != -1) {
                    actNumberList.remove(n2);
                    continue;
                }
                rs.remove();
            }
        }
        StringBuffer ids = new StringBuffer();
        ids.append("select fasstacttypeid,fasstaccountid from T_BD_AsstActGroupDetail where fasstacttypeid in(''");
        rs.reset();
        while (rs.next()) {
            ids.append(",'").append(rs.getString("fid")).append("'");
        }
        ids.append(')');
        RptRowSet idsRst = this.executeQuery(ids.toString(), null, ctx);
        rs.reset();
        rs.setProperty("asstAccountIdRst", (Object)idsRst);
        this.setMaxLevel(ctx, rs);
        RptParams rp = new RptParams();
        rp.setObject("rs", (Object)rs);
        return rp;
    }

    private void setMaxLevel(Context ctx, RptRowSet rs) {
        rs.reset();
        while (rs.next()) {
            try {
                RptRowSet levelRst;
                String levelSql;
                if (rs.getInt("FIsMultiLevel") != 1) continue;
                if (rs.getString("FGroupTableName") != null) {
                    levelSql = " select max(flevel) flevel from " + rs.getString("FGroupTableName");
                    levelRst = this.executeQuery(levelSql, null, ctx);
                    levelRst.next();
                    rs.setValue("FmaxLevel", (Object)new Integer(levelRst.getInt("flevel") + 1));
                    continue;
                }
                levelSql = " select max(flevel) flevel from " + rs.getString("frealtiondataobject");
                if (rs.getString("FGLAsstActTypeGrpID") != null) {
                    levelSql = levelSql + " where fgroupid='" + rs.getString("FGLAsstActTypeGrpID") + "'";
                }
                levelRst = this.executeQuery(levelSql, null, ctx);
                levelRst.next();
                rs.setValue("FmaxLevel", (Object)new Integer(levelRst.getInt("flevel")));
            }
            catch (Exception exception) {}
        }
    }

    private String getGroupLongNumber(String fid, String actTableName, String groupTableName, String groupMappingFieldName, Context ctx) throws BOSException, EASBizException {
        String sql = "select B.FLongNumber from " + actTableName + " A inner join " + groupTableName + " B on A." + groupMappingFieldName + "=B.FID where A.FID=?";
        RptRowSet rst = this.executeQuery(sql, new SqlParams().setString(1, fid), ctx);
        if (rst.next()) {
            return rst.getString(0);
        }
        return "";
    }

    private String getCSSPGroupLongNumber(String fid, String stand, String groupTableName, String detail, AcctountAsstItemParser.AccountAsstItem accountAsstItem, String mappingfieldname, String fGDcsspGroupID, String fGDcsspGroupStandardID, Context ctx) throws BOSException, EASBizException {
        AcctountAsstItemParser.Group[] groups = accountAsstItem.asstItems[0].group;
        String sql = "select G.FLongNumber from " + detail + " GD inner join " + stand + " GS on GS.fid = GD." + fGDcsspGroupStandardID + " inner join " + groupTableName + " G on G.fid = GD." + fGDcsspGroupID + " where GD." + mappingfieldname + "=?";
        int i = 1;
        SqlParams sqlpa = new SqlParams().setString(i++, fid);
        for (int j = 0; j < groups.length; ++j) {
            AcctountAsstItemParser.Group group = groups[j];
            sqlpa.setString(i++, group.standardNumber);
            sql = sql + " and GS.fnumber = ? -- \n";
            if (group.startNumber != null) {
                sqlpa.setString(i++, group.startNumber).setString(i++, group.startNumber);
                sql = sql + "and (G.FLongNumber >= ? or  G.FLongNumber like ?) ";
            }
            if (group.endNumber == null) continue;
            sqlpa.setString(i++, group.endNumber).setString(i++, group.endNumber);
            sql = sql + "and (G.FLongNumber <= ? or  G.FLongNumber like ?) ";
        }
        RptRowSet rst = this.executeQuery(sql, sqlpa, ctx);
        if (rst.next()) {
            return rst.getString(0);
        }
        return "";
    }

    protected String[] getCellObjectNumberID(Object actObject, boolean isMultiLevel, boolean useGroup) {
        String[] re = new String[2];
        if (actObject instanceof DataBaseInfo) {
            re[0] = isMultiLevel && !useGroup ? ((DataBaseInfo)actObject).get("longnumber").toString() : ((DataBaseInfo)actObject).get("number").toString();
            re[1] = ((DataBaseInfo)actObject).getId().toString();
        } else {
            re[0] = isMultiLevel && !useGroup ? (String)((Object[])((LabelValueBean)actObject).getProperty())[5] : ((LabelValueBean)actObject).getValue();
            re[1] = (String)((Object[])((LabelValueBean)actObject).getProperty())[4];
        }
        return re;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        int levelFrom;
        int h2ColumnCount;
        Object[][] h2;
        boolean isBaseCurrencyQuery;
        String groupTable;
        int n;
        String strBalDcSameAsAccount;
        String strAccountShowLongName;
        GLResUtil.setLocale(ctx);
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = "act_item_balance_table";
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        String loc = this.getLoc(ctx);
        RptRowSet rs = (RptRowSet)params.getObject("rs");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        MeasureUnitInfo standardUnit = (MeasureUnitInfo)params.getObject("standardUnit");
        if (standardUnit != null) {
            IMeasureUnit iunit = MeasureUnitFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(standardUnit.getId());
            standardUnit = iunit.getMeasureUnitInfo((IObjectPK)pk);
        }
        String companyID = company.getId().toString();
        String cuId = params.getString("cuId");
        String userId = params.getString("userId");
        String currencyID = String.valueOf(params.getObjectElement("jbxCurrency.value.id"));
        Object[] accountView = null;
        accountView = params.getObjectElement("jebAccountFrom.value") instanceof AccountViewInfo ? new Object[]{params.getObjectElement("jebAccountFrom.value")} : (Object[])params.getObjectElement("jebAccountFrom.value");
        Object[] accountViewTo = null;
        accountViewTo = params.getObjectElement("jebAccountTo.value") instanceof AccountViewInfo ? new Object[]{params.getObjectElement("jebAccountTo.value")} : (Object[])params.getObjectElement("jebAccountTo.value");
        boolean showOnlySubAccountview = false;
        if (params.getObjectElement("chkShowLeafAccount.value") != null) {
            showOnlySubAccountview = (Boolean)params.getObjectElement("chkShowLeafAccount.value");
        }
        String bizCodeFromNumber = (String)params.getObjectElement("jebBizCodeFrom.value.number");
        String bizCodeToNumber = (String)params.getObjectElement("jebBizCodeTo.value.number");
        boolean isDCSeparate = (Boolean)params.getObjectElement("jcbisDCSperate.value");
        boolean includeUnPost = (Boolean)params.getObjectElement("jcbIncludeUnPost.value");
        boolean noDisplayZero = (Boolean)params.getObjectElement("jcbNoDisplayZero.value");
        boolean isQtyAsst = (Boolean)params.getObjectElement("isQtyAsst");
        boolean noDisplayBalanceZero = (Boolean)params.getObjectElement("jcbNoPlayBalanceZero.value");
        boolean displayAmount = (Boolean)params.getObjectElement("jcbDisplayAmount.value");
        boolean displayUnit = displayAmount && isQtyAsst;
        boolean isBizCode = (Boolean)params.getObjectElement("rdBizAnalysisCode.value");
        String muId = String.valueOf(params.getObjectElement("jebMeasureUnit.value.id"));
        boolean isExchangeStandardUnit = (Boolean)params.getObjectElement("jcbExchangeStandardUnit.value");
        boolean ischkOpAsstGroup = (Boolean)params.getObjectElement("chkOpAsstGroup.value");
        boolean includeNoTransPLVoucher = (Boolean)params.getObjectElement("jcbincludeNoTransPLVoucher.value");
        boolean isAsstActShowLongNumber = false;
        boolean isAccountShowLongName = false;
        boolean isShowLongNameFromGeneral = false;
        Boolean isBalDcSameAsAccount = null;
        boolean isDisplayAssSum = false;
        if (params.getObjectElement("jcbDisplayAssSum.value") instanceof Boolean) {
            isDisplayAssSum = (Boolean)params.getObjectElement("jcbDisplayAssSum.value");
        }
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        paramKeyMap.put("GL_005", companyID);
        paramKeyMap.put("GL_012", companyID);
        paramKeyMap.put("GL_064", null);
        paramKeyMap.put("GL_066", companyID);
        paramKeyMap.put("GL_008", companyID);
        HashMap paramHashMap = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(paramKeyMap);
        String strAsstActShowLongNumber = (String)paramHashMap.get("GL_064");
        if (strAsstActShowLongNumber != null && strAsstActShowLongNumber.trim().length() > 0) {
            isAsstActShowLongNumber = Boolean.valueOf(strAsstActShowLongNumber.trim());
        }
        if ((strAccountShowLongName = (String)paramHashMap.get("GL_012")) != null && strAccountShowLongName.trim().length() > 0) {
            isAccountShowLongName = Boolean.valueOf(strAccountShowLongName.trim());
        }
        int[] periodRange = new int[]{(Integer)params.getObjectElement("jspYearFrom.value"), (Integer)params.getObjectElement("jspPeriodFrom.value"), (Integer)params.getObjectElement("jspYearTo.value"), (Integer)params.getObjectElement("jspPeriodTo.value")};
        String strShowLongNameFromGeneral = (String)paramHashMap.get("GL_066");
        if (strShowLongNameFromGeneral != null && strShowLongNameFromGeneral.trim().length() > 0) {
            isShowLongNameFromGeneral = Boolean.valueOf(strShowLongNameFromGeneral.trim());
        }
        if ((strBalDcSameAsAccount = (String)paramHashMap.get("GL_005")) != null && strBalDcSameAsAccount.trim().length() > 0) {
            isBalDcSameAsAccount = Boolean.valueOf(strBalDcSameAsAccount.trim());
        }
        String isForegnCurrStr = (String)paramHashMap.get("GL_008");
        boolean isForegnCurr = false;
        if (!GlUtils.isEmpty(isForegnCurrStr)) {
            isForegnCurr = Boolean.valueOf(isForegnCurrStr);
        }
        params.setObject("isBalDcSameAsAccount", (Object)isBalDcSameAsAccount);
        boolean isMultiLevel = false;
        boolean useGroup = false;
        if (!GlUtils.isEmpty(isForegnCurrStr)) {
            isForegnCurr = Boolean.valueOf(isForegnCurrStr);
        }
        String groupLongNumber = null;
        String actItemFIDFrom = null;
        String actItemFIDTo = null;
        String asstGroupInfo = null;
        String[] numberID = null;
        StringBuffer fromWhere = new StringBuffer();
        StringBuffer select = new StringBuffer();
        SqlParams sp = new SqlParams();
        ArrayList<String> fields = new ArrayList<String>();
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        select.append("select d.fid FAccountID,");
        select.append(isAccountShowLongName ? "d.fdisplayName_" : "d.fname_").append(loc).append(" FAccountName,d.fnumber FAccountNumber,d.fdc faccountdc,\r\n");
        String tempNoTransPLVoucherTable = null;
        if (includeNoTransPLVoucher) {
            String[] tempNoTransPL;
            try {
                tempNoTransPL = RptServerUtil.getQueryNOTransPnLBalanceTable(ctx, (Integer)params.getObjectElement("jspYearTo.value"), periodRange[0] * 100 + periodRange[1], periodRange[2] * 100 + periodRange[3], "'" + companyID + "'", false, includeUnPost, displayUnit ? 3 : 2, currencyID, this.getBOSType());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            tempNoTransPLVoucherTable = tempNoTransPL[1];
            fromWhere.append("\n from " + tempNoTransPL[0] + " A ");
        } else if (displayUnit) {
            fromWhere.append("\n from " + GLBalanceUtils.getAssistMeasureBalanceTable(includeUnPost ? 1 : 5, currencyID) + " A ");
        } else {
            fromWhere.append("\n from " + GLBalanceUtils.getAssistBalanceTable(includeUnPost ? 1 : 5, currencyID) + " A ");
        }
        fromWhere.append("\n inner join T_BD_AssistantHG B on A.FAssistGrpID=B.FID ");
        if (isBizCode) {
            fromWhere.append("\n inner join ").append(this.queryBizCodeHgid(ctx, bizCodeFromNumber, bizCodeToNumber)).append(" on T_Hgid.fid = B.fid ");
        }
        if (showOnlySubAccountview) {
            fromWhere.append("\n inner join T_BD_AccountView D on D.Fid=A.Faccountid and D.fcompanyid = A.forgunitid and d.fcompanyid = ? ");
        } else {
            fromWhere.append("\n inner join T_BD_AccountView AV on AV.Fid=A.Faccountid and AV.fcompanyid = A.forgunitid and av.fcompanyid = ? ");
            fromWhere.append("\n inner join T_BD_AccountView D on (charIndex(D.FLongNumber||'!', AV.FLongNumber)=1 ").append(" or D.fid = AV.fid) ").append(" and D.Faccounttableid =AV.Faccounttableid and D.fcompanyid =AV.fcompanyid and d.fcompanyid = ? ");
        }
        fromWhere.append("\n").append(RptServerUtil.innerJoinAccountPermissionSql("D", userId, companyID, ctx));
        if (displayUnit) {
            fromWhere.append("\n left join T_BD_MeasureUnit mu on A.FMeasureUnitID = mu.fid ");
        }
        String cuList = this.getAllParentCuIdList(companyID, ctx);
        String alis = null;
        rs.reset();
        if (isBizCode) {
            select.append(" T_Hgid.bacnumber fnumber0,T_Hgid.bacid fid0,T_Hgid.bacname fname0, ");
            fields.add(GLResUtil.getRes("bizcode_number", ctx));
            fields.add("FID");
            fields.add(GLResUtil.getRes("bizcode_name", ctx));
            col = new RptTableColumn("FNumber0");
            col.setWidth(90);
            header.addColumn(col);
            col = new RptTableColumn("FID0");
            col.setWidth(-1);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FName0");
            col.setWidth(120);
            header.addColumn(col);
        } else {
            while (rs.next()) {
                String permission;
                n = rs.getRow();
                alis = "T_" + n;
                fields.add(GLResUtil.getRes("item_number", ctx));
                fields.add("FLongNumber" + n);
                fields.add("FID");
                fields.add(rs.getString("FName"));
                col = new RptTableColumn("FNumber" + n);
                col.setWidth(110);
                header.addColumn(col);
                col = new RptTableColumn("FLongNumber" + n);
                col.setHided(true);
                col.setWidth(-1);
                header.addColumn(col);
                col = new RptTableColumn("FID" + n);
                col.setWidth(-1);
                col.setHided(true);
                header.addColumn(col);
                col = new RptTableColumn("FName" + n);
                col.setWidth(110);
                header.addColumn(col);
                fromWhere.append("\n inner join ").append(rs.getString("FRealtionDataObject")).append(' ').append(alis).append(" on ").append(alis).append(".FID=B.").append(rs.getString("FMappingFieldName"));
                isMultiLevel = "1".equals(String.valueOf(rs.getObject("fismultilevel")));
                useGroup = rs.getString("FGroupTableName") != null;
                boolean isGeneralActType = rs.getString("fassthgattribute") != null && rs.getString("fassthgattribute").startsWith("generalAssActType");
                boolean isUseLongNumber = "1".equals(rs.getString("fassthgattribute"));
                if (isMultiLevel && !useGroup) {
                    if (!(isAsstActShowLongNumber && isGeneralActType || !isGeneralActType && isUseLongNumber)) {
                        select.append(alis).append(".FNumber FNumber").append(n).append(",");
                    } else {
                        select.append(" replace(").append(alis).append(".FLongNumber,'!','.') FNumber").append(n).append(",");
                    }
                    select.append(alis).append(".FLongNumber FLongNumber").append(n).append(",");
                } else if (useGroup) {
                    groupTable = rs.getString("FGroupTableName");
                    asstGroupInfo = rs.getString("FAsstGroupInfo");
                    select.append(alis).append(".FNumber FNumber").append(n).append(",");
                    select.append("\n case when ").append(groupTable).append(n).append(".FLongNumber is null then ").append(alis).append(".FNumber else ").append(groupTable).append(n).append(".FLongNumber||'!'||").append(alis).append(".FNumber end FLongNumber").append(n).append(",");
                    String asstHG = rs.getString("FAsstHGAttribute");
                    if (ischkOpAsstGroup && (asstHG.equals("customer") || asstHG.equals("provider") || asstHG.equals("material")) && asstGroupInfo != null && asstGroupInfo.length() > 0 && asstGroupInfo.indexOf(35) >= 0) {
                        String standardTable = groupTable + "Standard";
                        String detail = rs.getString("FRealtionDataObject") + "Group" + (asstHG.equals("material") ? "Detial" : "Detail");
                        fromWhere.append("\n inner join ").append(detail).append(" GD").append(n).append(" on GD").append(n).append(".").append(asstHG.equalsIgnoreCase("provider") ? "FSupplierID" : rs.getString("FMAPPINGFIELDNAME")).append(" = ").append(alis).append(".fid ").append("\r\n inner join ").append(standardTable).append(" GS").append(n).append(" on GS").append(n).append(".fid = GD").append(n).append(".F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupStandardID").append("\r\n inner join ").append(groupTable).append(" ").append(groupTable).append(n).append(" on ").append(groupTable).append(n).append(".fid = GD").append(n).append(".F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupID");
                    } else {
                        fromWhere.append("\n left join ").append(groupTable).append(" ").append(groupTable).append(n).append(" on ").append(alis).append(".").append(rs.getString("FGroupMappingFieldName")).append("=").append(groupTable).append(n).append(".FID");
                    }
                    select.append(groupTable).append(n).append(".FID FGPID").append(n).append(",");
                } else {
                    select.append(alis).append(".FNumber FNumber").append(n).append(",");
                    select.append(alis).append(".FNumber FLongNumber").append(n).append(",");
                }
                String nameField = null;
                nameField = isShowLongNameFromGeneral && isGeneralActType ? ".FDISPLAYName_" + loc : ".FName_" + loc;
                select.append(alis).append(".FID FID").append(n).append(",").append(alis).append(nameField).append(" FName").append(n).append(",");
                if (!rs.getBoolean("FEnablePermissionLimit", false) || (permission = rs.getString("FPermissionItem")) == null || permission.trim().length() <= 0 || !AsstactTypeEntity.takeOffPersonPerm(permission)) continue;
                fromWhere.append("\n").append(RptServerUtil.innerJoinAsstactPermissionSql("B." + rs.getString("FMappingFieldName"), permission, userId, cuId, ctx));
            }
        }
        col = new RptTableColumn("FAccountNumber");
        col.setWidth(110);
        header.addColumn(col);
        fields.add(GLResUtil.getRes("accountView_number", ctx));
        col = new RptTableColumn("FAccountName");
        col.setWidth(110);
        header.addColumn(col);
        fields.add(GLResUtil.getRes("accountView_name", ctx));
        col = new RptTableColumn("FAccountID");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        fields.add(GLResUtil.getRes("accountView_ID", ctx));
        col = new RptTableColumn("FAccountDC");
        col.setHided(true);
        col.setWidth(-1);
        header.addColumn(col);
        fields.add(GLResUtil.getRes("accountView_DC", ctx));
        if (displayUnit) {
            fields.add("MeasureUnitID");
            col = new RptTableColumn("MeasureUnitID");
            col.setWidth(-1);
            col.setHided(true);
            header.addColumn(col);
            fields.add(GLResUtil.getRes("MeasureUnit"));
            col = new RptTableColumn("FMeasureUnit");
            col.setWidth(60);
            header.addColumn(col);
        }
        boolean bl = isBaseCurrencyQuery = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID) || company.getBaseCurrency().getId().toString().equalsIgnoreCase(currencyID);
        if (isForegnCurr) {
            isBaseCurrencyQuery = true;
        }
        if (displayAmount) {
            if (isBaseCurrencyQuery) {
                sp.addInt(periodRange[0] * 100 + periodRange[1]).addInt(periodRange[0] * 100 + periodRange[1]).addInt(periodRange[0] * 100 + periodRange[1]);
            } else {
                sp.addInt(periodRange[0] * 100 + periodRange[1]).addInt(periodRange[0] * 100 + periodRange[1]).addInt(periodRange[0] * 100 + periodRange[1]).addInt(periodRange[0] * 100 + periodRange[1]).addInt(periodRange[0] * 100 + periodRange[1]);
            }
        } else if (isBaseCurrencyQuery) {
            sp.addInt(periodRange[0] * 100 + periodRange[1]).addInt(periodRange[0] * 100 + periodRange[1]);
        } else {
            sp.addInt(periodRange[0] * 100 + periodRange[1]).addInt(periodRange[0] * 100 + periodRange[1]).addInt(periodRange[0] * 100 + periodRange[1]).addInt(periodRange[0] * 100 + periodRange[1]);
        }
        if (showOnlySubAccountview) {
            sp.addString(companyID);
        } else {
            sp.addString(companyID);
            sp.addString(companyID);
        }
        fromWhere.append("\n where A.FOrgunitID=? ");
        sp.addString(companyID);
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID)) {
            fromWhere.append("\n and A.FCurrencyID=? ");
            sp.addString(currencyID);
        }
        fromWhere.append("\n and A.FPeriod in " + SQLUtil.buildPeriodNumbersInSql(periodRange[0], periodRange[1], periodRange[2], periodRange[3]));
        String asstAccountID = (String)params.getObjectElement("jebAcct.value.id.toString");
        if (!isBizCode && asstAccountID != null) {
            if (showOnlySubAccountview) {
                fromWhere.append(" and D.FCAA = ? ");
            } else {
                fromWhere.append(" and AV.FCAA = ? ");
            }
            sp.addString(asstAccountID);
        }
        fromWhere.append(" and (1=1 ");
        String accountNumber = null;
        String accountNumberTo = null;
        if (accountView != null && accountView.length >= 1 && accountView[accountView.length - 1] != null && (accountNumber = ((AccountViewInfo)accountView[accountView.length - 1]).getNumber()) != null && !accountNumber.equals("null")) {
            if (showOnlySubAccountview) {
                fromWhere.append(" and D.FNumber >= ? ");
            } else {
                fromWhere.append(" and AV.FNumber >= ? ");
            }
            sp.addString(accountNumber);
        }
        if (accountViewTo != null && accountViewTo.length >= 1 && accountViewTo[0] != null && (accountNumberTo = ((AccountViewInfo)accountViewTo[0]).getNumber()) != null && !accountNumberTo.equals("null")) {
            if (showOnlySubAccountview) {
                fromWhere.append(" and D.FNumber < ? ");
            } else {
                fromWhere.append(" and AV.FNumber < ? ");
            }
            sp.addString(accountNumberTo + GlUtils.getMaxChar());
        }
        if (accountView != null && accountView.length > 1) {
            for (int i = accountView.length - 2; i >= 0; --i) {
                if (accountView[i] == null) continue;
                if (showOnlySubAccountview) {
                    fromWhere.append(" or D.FNumber like ? ");
                } else {
                    fromWhere.append(" or AV.FNumber like ? ");
                }
                sp.addString(((AccountViewInfo)accountView[i]).getNumber() + "%");
            }
        }
        if (accountViewTo != null && accountViewTo.length > 1) {
            for (int i = accountViewTo.length - 1; i >= 1; --i) {
                if (accountViewTo[i] == null) continue;
                if (showOnlySubAccountview) {
                    fromWhere.append(" or D.FNumber like ? ");
                } else {
                    fromWhere.append(" or AV.FNumber like ? ");
                }
                sp.addString(((AccountViewInfo)accountViewTo[i]).getNumber() + "%");
            }
        }
        fromWhere.append(" )");
        if (!showOnlySubAccountview) {
            fromWhere.append(" and D.FLevel >= ? and D.FLevel <= ? ");
            int levelFrom2 = 1;
            int levelTo = 1;
            if (params.getObjectElement("jspLevelFrom.value") != null && params.getObjectElement("jspLevelTo.value") != null) {
                levelFrom2 = (Integer)params.getObjectElement("jspLevelFrom.value");
                levelTo = (Integer)params.getObjectElement("jspLevelTo.value");
            }
            sp.addInt(levelFrom2);
            sp.addInt(levelTo);
        }
        rs.reset();
        while (rs.next() && !isBizCode) {
            String fGDcsspGroupStandardID;
            String fGDcsspGroupID;
            String standardTable2;
            AcctountAsstItemParser.AccountAsstItem accountAsstItem2;
            String asstHG;
            n = rs.getRow();
            alis = "T_" + n;
            isMultiLevel = "1".equals(String.valueOf(rs.getObject("fismultilevel")));
            useGroup = rs.getString("FGroupTableName") != null;
            Object from = rs.getObject("FFrom");
            Object to = rs.getObject("FTo");
            if ((!isMultiLevel || useGroup) && useGroup) {
                asstHG = rs.getString("FAsstHGAttribute");
                asstGroupInfo = rs.getString("FAsstGroupInfo");
                if (ischkOpAsstGroup && (asstHG.equals("customer") || asstHG.equals("provider") || asstHG.equals("material")) && asstGroupInfo != null && asstGroupInfo.length() > 0 && asstGroupInfo.indexOf(35) >= 0) {
                    try {
                        accountAsstItem2 = AcctountAsstItemParser.parse((String)("||" + asstGroupInfo + "#"));
                        AcctountAsstItemParser.Group[] groups = accountAsstItem2.asstItems[0].group;
                        groupTable = rs.getString("FGroupTableName") + rs.getRow();
                        for (int j = 0; j < groups.length; ++j) {
                            fromWhere.append("\n and GS").append(n).append(".fnumber=? ");
                            AcctountAsstItemParser.Group group = groups[j];
                            sp.addString(group.standardNumber);
                            if (group.startNumber != null) {
                                fromWhere.append(" and (").append(groupTable).append(".FLongNumber >= ? or ").append(groupTable).append(".FLongNumber like ?)");
                                sp.addString(group.startNumber).addString(group.startNumber + "%");
                            }
                            if (group.endNumber == null) continue;
                            fromWhere.append(" and (").append(groupTable).append(".FLongNumber <= ? or ").append(groupTable).append(".FLongNumber like ?)");
                            sp.addString(group.endNumber).addString(group.endNumber + "%");
                        }
                    }
                    catch (ParseException accountAsstItem2) {
                        // empty catch block
                    }
                }
            }
            if (from != null) {
                numberID = this.getCellObjectNumberID(from, isMultiLevel, useGroup);
                String actItemFrom = numberID[0];
                actItemFIDFrom = numberID[1];
                fromWhere.append("\n and ");
                if (isMultiLevel && !useGroup) {
                    fromWhere.append(alis).append(".FLongNumber>=?");
                    sp.addString(actItemFrom);
                } else if (useGroup) {
                    asstGroupInfo = rs.getString("FAsstGroupInfo");
                    groupTable = rs.getString("FGroupTableName") + rs.getRow();
                    asstHG = rs.getString("FAsstHGAttribute");
                    if (ischkOpAsstGroup && (asstHG.equals("customer") || asstHG.equals("provider") || asstHG.equals("material")) && asstGroupInfo != null && asstGroupInfo.length() > 0 && asstGroupInfo.indexOf(35) >= 0) {
                        try {
                            accountAsstItem2 = AcctountAsstItemParser.parse((String)("||" + asstGroupInfo + "#"));
                            standardTable2 = rs.getString("FGroupTableName") + "Standard";
                            String detail = rs.getString("FRealtionDataObject") + "Group" + (asstHG.equals("material") ? "Detial" : "Detail");
                            fGDcsspGroupID = "F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupID";
                            fGDcsspGroupStandardID = "F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupStandardID";
                            groupLongNumber = this.getCSSPGroupLongNumber(actItemFIDFrom, standardTable2, rs.getString("FGroupTableName"), detail, accountAsstItem2, asstHG.equalsIgnoreCase("provider") ? "FSupplierID" : rs.getString("FMAPPINGFIELDNAME"), fGDcsspGroupID, fGDcsspGroupStandardID, ctx);
                        }
                        catch (ParseException standardTable2) {}
                    } else {
                        groupLongNumber = this.getGroupLongNumber(actItemFIDFrom, rs.getString("FRealtionDataObject"), rs.getString("FGroupTableName"), rs.getString("FGroupMappingFieldName"), ctx);
                    }
                    fromWhere.append("(isNull(").append(groupTable).append(".FLongNumber,'')||").append(alis).append(".FNumber >= ?");
                    fromWhere.append(" or ").append(groupTable).append(".FLongNumber is null and ").append(alis).append(".FNumber >= ? )");
                    sp.addString(groupLongNumber + actItemFrom);
                    sp.addString(actItemFrom);
                } else {
                    fromWhere.append(alis).append(".FNumber>=?");
                    sp.addString(actItemFrom);
                }
            }
            if (to == null) continue;
            numberID = this.getCellObjectNumberID(to, isMultiLevel, useGroup);
            String actItemTo = numberID[0];
            actItemFIDTo = numberID[1];
            fromWhere.append("\n and ");
            if (isMultiLevel && !useGroup) {
                fromWhere.append(alis).append(".FLongNumber<=?");
                sp.addString(actItemTo);
                continue;
            }
            if (useGroup) {
                asstGroupInfo = rs.getString("FAsstGroupInfo");
                groupTable = rs.getString("FGroupTableName") + rs.getRow();
                asstHG = rs.getString("FAsstHGAttribute");
                if (ischkOpAsstGroup && (asstHG.equals("customer") || asstHG.equals("provider") || asstHG.equals("material")) && asstGroupInfo != null && asstGroupInfo.length() > 0 && asstGroupInfo.indexOf(35) >= 0) {
                    try {
                        accountAsstItem2 = AcctountAsstItemParser.parse((String)("||" + asstGroupInfo + "#"));
                        standardTable2 = rs.getString("FGroupTableName") + "Standard";
                        String detail = rs.getString("FRealtionDataObject") + "Group" + (asstHG.equals("material") ? "Detial" : "Detail");
                        fGDcsspGroupID = "F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupID";
                        fGDcsspGroupStandardID = "F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupStandardID";
                        groupLongNumber = this.getCSSPGroupLongNumber(actItemFIDTo, standardTable2, rs.getString("FGroupTableName"), detail, accountAsstItem2, asstHG.equalsIgnoreCase("provider") ? "FSupplierID" : rs.getString("FMAPPINGFIELDNAME"), fGDcsspGroupID, fGDcsspGroupStandardID, ctx);
                    }
                    catch (ParseException standardTable3) {}
                } else {
                    groupLongNumber = this.getGroupLongNumber(actItemFIDTo, rs.getString("FRealtionDataObject"), rs.getString("FGroupTableName"), rs.getString("FGroupMappingFieldName"), ctx);
                }
                fromWhere.append("(isNull(").append(groupTable).append(".FLongNumber,'')||").append(alis).append(".FNumber <= ?");
                fromWhere.append(" or ").append(groupTable).append(".FLongNumber is null and ").append(alis).append(".FNumber <= ? )");
                sp.addString(groupLongNumber + actItemTo);
                sp.addString(actItemTo);
                continue;
            }
            fromWhere.append(alis).append(".FNumber<=?");
            sp.addString(actItemTo);
        }
        int yearTo = (Integer)params.getObjectElement("jspYearTo.value");
        int periodTo = (Integer)params.getObjectElement("jspPeriodTo.value");
        AccountTableInfo newAccountTable = null;
        try {
            AccountRefContrastInfo ar = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(company.getId().toString(), company.getAccountTable().getId().toString(), yearTo, periodTo);
            if (ar != null) {
                PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (int)yearTo, (int)periodTo, (CompanyOrgUnitInfo)company);
                newAccountTable = period != null && RptClientUtil.periodCheckForAccountRefContrast(ar, yearTo, periodTo) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (newAccountTable != null) {
            fromWhere.append(" and D.Faccounttableid=? ");
            sp.addString(newAccountTable.getId().toString());
        }
        if (displayUnit && !muId.equals("null")) {
            fromWhere.append(" and a.FMeasureUnitID = '");
            fromWhere.append(muId);
            fromWhere.append("' ");
        }
        if (isBaseCurrencyQuery) {
            params.setBoolean("isForgenCurr", isForegnCurr);
            this.buildLocalSelect(params, currPeriod, displayAmount, isExchangeStandardUnit, select);
        } else {
            this.buildForSelect(params, currPeriod, displayAmount, isExchangeStandardUnit, select);
        }
        select.append("\n 0 as FLEVEL,1 as FIsLeaf, ");
        if (displayUnit && !isExchangeStandardUnit) {
            select.append("\n mu.fid muId, mu.fname_").append(loc).append(" muName ,");
        } else if (displayUnit && standardUnit != null) {
            select.append("\n '").append(standardUnit.getId().toString()).append("' muId ,'").append(standardUnit.getName()).append("' muName ,");
        } else if (displayUnit) {
            select.append("\n ' ' muId, ' ' muName ,");
        }
        rs.moveTo(0);
        if (!isBizCode) {
            isMultiLevel = "1".equals(String.valueOf(rs.getObject("fismultilevel")));
            boolean bl2 = useGroup = rs.getString("FGroupTableName") != null;
        }
        if (isBizCode) {
            select.append("T_Hgid.bacnumber as FOrderNumber");
        } else if (isMultiLevel && !useGroup) {
            select.append("T_0.FLongNumber as FOrderNumber");
        } else if (useGroup) {
            asstGroupInfo = rs.getString("FAsstGroupInfo");
            groupTable = rs.getString("FGroupTableName") + rs.getRow();
            select.append("isNull(").append(groupTable).append(".FLongNumber,'')||").append("T_0.FNumber as FOrderNumber");
        } else {
            select.append("T_0.FNumber  as FOrderNumber");
        }
        select.append("\n into ").append(tempTable);
        rs.reset();
        if (!isBizCode) {
            while (rs.next()) {
                n = rs.getRow();
                alis = "T_" + n;
                String asstHG = rs.getString("FAsstHGAttribute");
                if (!"1".equals(String.valueOf(rs.getObject("FIsForCompany"))) || asstHG.equals("person") || asstHG.equals("innerAccount") || asstHG.equals("ProductType") || asstHG.equals("CurProject")) continue;
                fromWhere.append(" and (" + alis + ".fcompanyId='" + companyID + "' or " + alis + ".fcompanyId is null)");
            }
        }
        rs.reset();
        fromWhere.append("\n group by d.fid ,").append(isAccountShowLongName ? "d.fdisplayName_" : "d.fname_").append(loc).append(" ,d.fnumber,d.fdc,");
        if (isBizCode) {
            fromWhere.append(" T_Hgid.bacnumber ,T_Hgid.bacid ,T_Hgid.bacname ,");
        } else {
            while (rs.next()) {
                alis = "T_" + rs.getRow();
                isMultiLevel = "1".equals(String.valueOf(rs.getObject("fismultilevel")));
                boolean bl3 = useGroup = rs.getString("FGroupTableName") != null;
                if (isMultiLevel && !useGroup) {
                    fromWhere.append(alis).append(".FLongNumber,");
                    fromWhere.append(alis).append(".FNumber,");
                } else if (useGroup) {
                    asstGroupInfo = rs.getString("FAsstGroupInfo");
                    groupTable = rs.getString("FGroupTableName") + rs.getRow();
                    fromWhere.append(groupTable).append(".FID,");
                    fromWhere.append(groupTable).append(".FLongNumber,");
                    fromWhere.append(alis).append(".FNumber,");
                } else {
                    fromWhere.append(alis).append(".FNumber,");
                }
                boolean isGeneralActType = rs.getString("fassthgattribute") != null && rs.getString("fassthgattribute").startsWith("generalAssActType");
                String nameField = null;
                nameField = isShowLongNameFromGeneral && isGeneralActType ? ".FDISPLAYName_" + loc : ".FName_" + loc;
                fromWhere.append(alis).append(".FID,").append(alis).append(nameField).append(",");
            }
        }
        if (displayUnit && !isExchangeStandardUnit) {
            fromWhere.append(" mu.fid, mu.fname_").append(loc).append(" ");
        } else {
            fromWhere.deleteCharAt(fromWhere.length() - 1);
        }
        fromWhere.insert(0, select);
        String sqlGetData = fromWhere.toString();
        if (noDisplayZero) {
            sqlGetData = isBaseCurrencyQuery ? " select * from (" + sqlGetData + ") T where FDebitFor<>0 or FCreditFor<>0" : " select * from (" + sqlGetData + ") T where FDebitfor<>0 or FCreditfor<>0 or FDebitLocal<>0 or FCreditLocal<>0";
        }
        if (noDisplayBalanceZero) {
            sqlGetData = isBaseCurrencyQuery ? " select * from (" + sqlGetData + ") TT where TT.FEndBalanceDebitFor<>0 or TT.FEndBalanceCreditFor<>0  " : " select * from (" + sqlGetData + ") TT where TT.FEndBalanceDebitFor<>0 or TT.FEndBalanceDebitLocal<>0 or TT.FEndBalanceCreditFor<>0 or TT.FEndBalanceCreditLocal<>0 ";
        }
        Object[] paramsArray = sp.getParams();
        int j = paramsArray.length;
        for (int i = 0; i < j; ++i) {
            if (paramsArray[i] instanceof Integer) {
                sqlGetData = sqlGetData.replaceFirst("\\?", paramsArray[i].toString());
                continue;
            }
            if (!(paramsArray[i] instanceof String)) continue;
            sqlGetData = sqlGetData.replaceFirst("\\?", "'" + paramsArray[i].toString() + "'");
        }
        sp.clear();
        tempTable = this.executeCreateTableAsSelectInto(sqlGetData, sp, ctx).getTempTable();
        if (isDCSeparate) {
            StringBuffer updatesql = new StringBuffer();
            if (isBaseCurrencyQuery) {
                updatesql.append(" update ").append(tempTable).append(" set FBeginBalanceDebitFor=case when FBeginBalanceDebitFor - FBeginBalanceCreditFor > 0 then FBeginBalanceDebitFor - FBeginBalanceCreditFor else 0 end ,").append(" FBeginBalanceCreditFor = case when FBeginBalanceDebitFor - FBeginBalanceCreditFor < 0 then  FBeginBalanceCreditFor - FBeginBalanceDebitFor  else 0 end ,").append(" FEndBalanceDebitFor  = case when FEndBalanceDebitFor  - FEndBalanceCreditFor > 0 then  FEndBalanceDebitFor  - FEndBalanceCreditFor else 0 end,").append(" FEndBalanceCreditFor  = case when FEndBalanceDebitFor  - FEndBalanceCreditFor < 0 then  FEndBalanceCreditFor-FEndBalanceDebitFor   else 0 end ");
                updatesql.append("where (FBeginBalanceDebitFor<> 0 and FBeginBalanceCreditFor<> 0) or (FEndBalanceDebitFor<>0 and FEndBalanceCreditFor<>0)");
            } else {
                updatesql.append(" update ").append(tempTable).append(" set FBeginBalanceDebitFor=case when FBeginBalanceDebitFor - FBeginBalanceCreditFor > 0 then FBeginBalanceDebitFor - FBeginBalanceCreditFor else 0 end ,").append(" FBeginBalanceCreditFor = case when FBeginBalanceDebitFor - FBeginBalanceCreditFor < 0 then  FBeginBalanceCreditFor - FBeginBalanceDebitFor  else 0 end ,").append(" FEndBalanceDebitFor  = case when FEndBalanceDebitFor  - FEndBalanceCreditFor > 0 then  FEndBalanceDebitFor  - FEndBalanceCreditFor else 0 end,").append(" FEndBalanceCreditFor  = case when FEndBalanceDebitFor  - FEndBalanceCreditFor < 0 then  FEndBalanceCreditFor-FEndBalanceDebitFor   else 0 end, ").append(" FBeginBalanceDebitLocal=case when FBeginBalanceDebitLocal - FBeginBalanceCreditLocal > 0 then FBeginBalanceDebitLocal - FBeginBalanceCreditLocal else 0 end ,").append(" FBeginBalanceCreditLocal = case when FBeginBalanceDebitLocal - FBeginBalanceCreditLocal < 0 then  FBeginBalanceCreditLocal - FBeginBalanceDebitLocal  else 0 end ,").append(" FEndBalanceDebitLocal  = case when FEndBalanceDebitLocal  - FEndBalanceCreditLocal > 0 then  FEndBalanceDebitLocal  - FEndBalanceCreditLocal else 0 end,").append(" FEndBalanceCreditLocal  = case when FEndBalanceDebitLocal  - FEndBalanceCreditLocal < 0 then  FEndBalanceCreditLocal-FEndBalanceDebitLocal   else 0 end ");
                updatesql.append("where (FBeginBalanceDebitFor<> 0 and FBeginBalanceCreditFor<> 0) or (FEndBalanceDebitFor<>0 and FEndBalanceCreditFor<>0) or (FBeginBalanceDebitLocal<> 0 and FBeginBalanceCreditLocal<> 0) or (FEndBalanceDebitLocal<>0 and FEndBalanceCreditLocal<>0)");
            }
            this.executeUpdate(updatesql.toString(), null, ctx);
        }
        Object[][] h1 = null;
        h1 = isBaseCurrencyQuery ? new String[2][fields.size()] : new String[3][fields.size()];
        fields.toArray(h1[0]);
        fields.toArray(h1[1]);
        if (!isBaseCurrencyQuery) {
            fields.toArray(h1[2]);
        }
        String balPeriodBegin = GLResUtil.getRes("balance_period_begin", ctx);
        String peirodHappend = GLResUtil.getRes("period_happened", ctx);
        String sumYear = GLResUtil.getRes("sum_year", ctx);
        String balPeriodEnd = GLResUtil.getRes("balance_period_end", ctx);
        String asstQuantity = GLResUtil.getRes("asst_quantity", ctx);
        String dirDebit = GLResUtil.getRes("dir_debit", ctx);
        String dirCredit = GLResUtil.getRes("dir_credit", ctx);
        String currencyFor = GLResUtil.getRes("currency_for", ctx);
        String currencyLocal = GLResUtil.getRes("currency_local", ctx);
        if (displayAmount) {
            String price = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase.Price", (Locale)ctx.getLocale());
            if (isBaseCurrencyQuery) {
                h2 = new String[][]{{balPeriodBegin, balPeriodBegin, balPeriodBegin, balPeriodBegin, peirodHappend, peirodHappend, peirodHappend, peirodHappend, peirodHappend, peirodHappend, sumYear, sumYear, sumYear, sumYear, sumYear, sumYear, balPeriodEnd, balPeriodEnd, balPeriodEnd, balPeriodEnd, "FLevel", "FIsLeaf", "FOrderNumber"}, {asstQuantity, price, dirDebit, dirCredit, asstQuantity, price, dirDebit, asstQuantity, price, dirCredit, asstQuantity, price, dirDebit, asstQuantity, price, dirCredit, asstQuantity, price, dirDebit, dirCredit, "FLevel", "FIsLeaf", "FOrderNumber"}};
                h2ColumnCount = 20;
            } else {
                h2 = new String[][]{{balPeriodBegin, balPeriodBegin, balPeriodBegin, balPeriodBegin, balPeriodBegin, balPeriodBegin, peirodHappend, peirodHappend, peirodHappend, peirodHappend, peirodHappend, peirodHappend, peirodHappend, peirodHappend, sumYear, sumYear, sumYear, sumYear, sumYear, sumYear, sumYear, sumYear, balPeriodEnd, balPeriodEnd, balPeriodEnd, balPeriodEnd, balPeriodEnd, balPeriodEnd, "FLevel", "FIsLeaf", "FOrderNumber"}, {asstQuantity, price, dirDebit, dirDebit, dirCredit, dirCredit, dirDebit, dirDebit, dirDebit, dirDebit, dirCredit, dirCredit, dirCredit, dirCredit, dirDebit, dirDebit, dirDebit, dirDebit, dirCredit, dirCredit, dirCredit, dirCredit, asstQuantity, price, dirDebit, dirDebit, dirCredit, dirCredit, "FLevel", "FIsLeaf", "FOrderNumber"}, {asstQuantity, price, currencyFor, currencyLocal, currencyFor, currencyLocal, asstQuantity, price, currencyFor, currencyLocal, asstQuantity, price, currencyFor, currencyLocal, asstQuantity, price, currencyFor, currencyLocal, asstQuantity, price, currencyFor, currencyLocal, asstQuantity, price, currencyFor, currencyLocal, currencyFor, currencyLocal, "FLevel", "FIsLeaf", "FOrderNumber"}};
                h2ColumnCount = 28;
            }
        } else if (displayAmount) {
            if (isBaseCurrencyQuery) {
                h2 = new String[][]{{balPeriodBegin, balPeriodBegin, balPeriodBegin, peirodHappend, peirodHappend, peirodHappend, peirodHappend, sumYear, sumYear, sumYear, sumYear, balPeriodEnd, balPeriodEnd, balPeriodEnd, "FLevel", "FIsLeaf", "FOrderNumber"}, {asstQuantity, dirDebit, dirCredit, asstQuantity, dirDebit, asstQuantity, dirCredit, asstQuantity, dirDebit, asstQuantity, dirCredit, asstQuantity, dirDebit, dirCredit, "FLevel", "FIsLeaf", "FOrderNumber"}};
                h2ColumnCount = 14;
            } else {
                h2 = new String[][]{{balPeriodBegin, balPeriodBegin, balPeriodBegin, balPeriodBegin, balPeriodBegin, peirodHappend, peirodHappend, peirodHappend, peirodHappend, peirodHappend, peirodHappend, sumYear, sumYear, sumYear, sumYear, sumYear, sumYear, balPeriodEnd, balPeriodEnd, balPeriodEnd, balPeriodEnd, balPeriodEnd, "FLevel", "FIsLeaf", "FOrderNumber"}, {asstQuantity, dirDebit, dirDebit, dirCredit, dirCredit, dirDebit, dirDebit, dirDebit, dirCredit, dirCredit, dirCredit, dirDebit, dirDebit, dirDebit, dirCredit, dirCredit, dirCredit, asstQuantity, dirDebit, dirDebit, dirCredit, dirCredit, "FLevel", "FIsLeaf", "FOrderNumber"}, {asstQuantity, currencyFor, currencyLocal, currencyFor, currencyLocal, asstQuantity, currencyFor, currencyLocal, asstQuantity, currencyFor, currencyLocal, asstQuantity, currencyFor, currencyLocal, asstQuantity, currencyFor, currencyLocal, asstQuantity, currencyFor, currencyLocal, currencyFor, currencyLocal, "FLevel", "FIsLeaf", "FOrderNumber"}};
                h2ColumnCount = 22;
            }
        } else if (isBaseCurrencyQuery) {
            h2 = new String[][]{{balPeriodBegin, balPeriodBegin, peirodHappend, peirodHappend, sumYear, sumYear, balPeriodEnd, balPeriodEnd, "FLevel", "FIsLeaf", "FOrderNumber"}, {dirDebit, dirCredit, dirDebit, dirCredit, dirDebit, dirCredit, dirDebit, dirCredit, "FLevel", "FIsLeaf", "FOrderNumber"}};
            h2ColumnCount = 8;
        } else {
            h2 = new String[][]{{balPeriodBegin, balPeriodBegin, balPeriodBegin, balPeriodBegin, peirodHappend, peirodHappend, peirodHappend, peirodHappend, sumYear, sumYear, sumYear, sumYear, balPeriodEnd, balPeriodEnd, balPeriodEnd, balPeriodEnd, "FLevel", "FIsLeaf", "FOrderNumber"}, {dirDebit, dirDebit, dirCredit, dirCredit, dirDebit, dirDebit, dirCredit, dirCredit, dirDebit, dirDebit, dirCredit, dirCredit, dirDebit, dirDebit, dirCredit, dirCredit, "FLevel", "FIsLeaf", "FOrderNumber"}, {currencyFor, currencyLocal, currencyFor, currencyLocal, currencyFor, currencyLocal, currencyFor, currencyLocal, currencyFor, currencyLocal, currencyFor, currencyLocal, currencyFor, currencyLocal, currencyFor, currencyLocal, "FLevel", "FIsLeaf", "FOrderNumber"}};
            h2ColumnCount = 16;
        }
        header.setLabels(CellMatrix.join((Object[][])h1, (Object[][])h2), true);
        for (int i = 0; i < h2ColumnCount; ++i) {
            col = new RptTableColumn("amount" + i);
            col.setWidth(100);
            col.setAligment(2);
            header.addColumn(col);
        }
        col = new RptTableColumn("FLevel");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FIsLeaf");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FOrderNumber");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        rs.moveTo(0);
        if (!isBizCode) {
            String firstTable = rs.getString("frealtiondataobject");
            isMultiLevel = "1".equals(String.valueOf(rs.getObject("fismultilevel")));
            boolean bl4 = useGroup = rs.getString("FGroupTableName") != null;
            if (isMultiLevel && !useGroup) {
                StringBuffer s = new StringBuffer();
                s.append("select max(B.FLevel) FLevel from ").append(tempTable).append(" A \n inner join ").append(firstTable).append(" B on B.FID=A.FID0");
                RptRowSet rr = this.executeQuery(s.toString(), null, ctx);
                if (rr.next() && rr.getObject(0) != null) {
                    int m;
                    boolean isGeneralActType = rs.getString("fassthgattribute") != null && rs.getString("fassthgattribute").startsWith("generalAssActType");
                    boolean isUseLongNumber = "1".equals(rs.getString("fassthgattribute"));
                    boolean showasstNumber = !(isAsstActShowLongNumber && isGeneralActType || !isGeneralActType && isUseLongNumber);
                    s.setLength(0);
                    s.append(this.getSQL4InsertSumLvl1Insert(tempTable, rs, displayAmount, displayUnit, isBaseCurrencyQuery, loc, true));
                    s.append(" select FaccountID,FaccountName,FaccountNumber, faccountdc,").append("\n");
                    s.append(showasstNumber ? "C.FNumber" : "replace(C.FLongNumber,'!','.')");
                    int maxLevel = rr.getInt(0);
                    s.append(" FNumber0, C.FLongNumber, C.FID FID0, ").append("C.FName_").append(loc).append(" FName0, ");
                    rs.moveTo(0);
                    while (rs.next()) {
                        m = rs.getRow();
                        s.append("\n A.FNumber").append(m).append(", A.FLongNumber").append(m).append(", A.FID").append(m).append(",A.FName").append(m).append(",");
                    }
                    if (displayAmount) {
                        if (isBaseCurrencyQuery) {
                            s.append("\n sum(FBeginQty), sum(FBeginBalanceDebitFor), sum(FBeginBalanceCreditFor), sum(FDebitQty), sum(FDebitFor), sum(FCreditQty), sum(FCreditFor),");
                            s.append(" sum(FYearDebitQty), sum(FYearDebitFor), sum(FYearCreditQty), sum(FYearCreditFor), sum(FEndQty), sum(FEndBalanceDebitFor), sum(FEndBalanceCreditFor),");
                        } else {
                            s.append("\n sum(FBeginQty),").append("sum(FBeginBalanceDebitFor),sum(FBeginBalanceDebitLocal),").append("sum(FBeginBalanceCreditFor), sum(FBeginBalanceCreditLocal),").append("sum(FDebitQty),").append("sum(FDebitFor), sum(FDebitLocal),").append("sum(FCreditQty),").append("sum(FCreditFor),sum(FCreditLocal), ").append("sum(FYearDebitQty),").append("sum(FYearDebitFor),sum(FYearDebitLocal),").append("sum(FYearCreditQty),").append("sum(FYearCreditFor),sum(FYearCreditLocal),").append("sum(FEndQty),").append("sum(FEndBalanceDebitFor),sum(FEndBalanceDebitLocal),").append("sum(FEndBalanceCreditFor),sum(FEndBalanceCreditLocal),");
                        }
                    } else if (isBaseCurrencyQuery) {
                        s.append("\n sum(FBeginBalanceDebitFor), sum(FBeginBalanceCreditFor), sum(FDebitFor), sum(FCreditFor), sum(FYearDebitFor), sum(FYearCreditFor), sum(FEndBalanceDebitFor), sum(FEndBalanceCreditFor),");
                    } else {
                        s.append("\n sum(FBeginBalanceDebitFor),sum(FBeginBalanceDebitLocal),").append("sum(FBeginBalanceCreditFor), sum(FBeginBalanceCreditLocal),").append("sum(FDebitFor), sum(FDebitLocal),").append("sum(FCreditFor),sum(FCreditLocal),").append("sum(FYearDebitFor),sum(FYearDebitLocal),").append("sum(FYearCreditFor),sum(FYearCreditLocal),").append("sum(FEndBalanceDebitFor),sum(FEndBalanceDebitLocal),").append("sum(FEndBalanceCreditFor),sum(FEndBalanceCreditLocal),");
                    }
                    s.append(" C.FLevel, 0,");
                    if (displayUnit) {
                        s.append("A.muId, A.muName,");
                    }
                    s.append(" C.FLongNumber \r\n");
                    s.append(" from ").append(tempTable).append(" A \n inner join ").append(firstTable).append(" B  on B.FID=A.FID0 and B.FLevel=? ").append(" \n inner join ").append(firstTable).append(" C  on C.FID=B.FParentID ").append(" \n group by C.FLongNumber,      FaccountID,FaccountName,FaccountNumber, ").append("faccountdc,");
                    if (showasstNumber) {
                        s.append("C.FNumber,");
                    }
                    s.append("C.FID, C.FName_").append(loc).append(", ");
                    if (displayUnit) {
                        s.append(" muId, muName ,");
                    }
                    rs.moveTo(0);
                    while (rs.next()) {
                        m = rs.getRow();
                        s.append("\n A.FNumber").append(m).append(", A.FLongNumber").append(m).append(", A.FID").append(m).append(",A.FName").append(m).append(",");
                    }
                    s.append("C.FLevel");
                    SqlParams ss = new SqlParams();
                    for (int i = maxLevel; i > 1; --i) {
                        ss.setInt(1, i);
                        this.executeUpdate(s.toString(), ss, ctx);
                    }
                    String u = "update " + tempTable + " set FLevel = ( select A.FLevel from " + firstTable + " A where A.FID= " + tempTable + ".FID0) \n where " + tempTable + ".FLevel=0 ";
                    this.executeUpdate(u, null, ctx);
                }
            } else if (useGroup) {
                boolean isCsspGroup;
                String asstHG = rs.getString("FAsstHGAttribute");
                asstGroupInfo = rs.getString("FAsstGroupInfo");
                String standardTable = null;
                String detail = null;
                String fGDcsspGroupID = null;
                String fGDcsspGroupStandardID = null;
                String fmappingfieldname = null;
                AcctountAsstItemParser.AccountAsstItem accountAsstItem = null;
                boolean bl5 = isCsspGroup = ischkOpAsstGroup && (asstHG.equals("customer") || asstHG.equals("provider") || asstHG.equals("material")) && asstGroupInfo != null && asstGroupInfo.length() > 0 && asstGroupInfo.indexOf(35) >= 0;
                if (isCsspGroup) {
                    standardTable = rs.getString("FGroupTableName") + "Standard";
                    detail = rs.getString("FRealtionDataObject") + "Group" + (asstHG.equals("material") ? "Detial" : "Detail");
                    fGDcsspGroupID = "F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupID";
                    fGDcsspGroupStandardID = "F" + (asstHG.equalsIgnoreCase("provider") ? "Supplier" : asstHG) + "GroupStandardID";
                    fmappingfieldname = asstHG.equalsIgnoreCase("provider") ? "FSupplierID" : rs.getString("FMAPPINGFIELDNAME");
                    try {
                        accountAsstItem = AcctountAsstItemParser.parse((String)("||" + asstGroupInfo + "#"));
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                StringBuffer s = new StringBuffer();
                groupTable = rs.getString("FGroupTableName");
                String groupTableField = rs.getString("FGroupMappingFieldName");
                if (isCsspGroup) {
                    s.append("select max(C.FLevel) FLevel from ").append(tempTable).append(" A \n inner join ").append(detail).append(" B on B.").append(fmappingfieldname).append("=A.FID0\n").append("inner join ").append(standardTable).append(" GS on GS.FID = B.").append(fGDcsspGroupStandardID).append(" inner join ").append(groupTable).append(" c on c.FID =  B.").append(fGDcsspGroupID);
                } else {
                    s.append("select max(C.FLevel) FLevel from ").append(tempTable).append(" A \n inner join ").append(groupTable).append(" C on C.FID=a.FGPID0");
                }
                RptRowSet rr = this.executeQuery(s.toString(), null, ctx);
                if (rr.next() && rr.getObject(0) != null) {
                    int maxLevel = rr.getInt(0);
                    s.setLength(0);
                    s.append(this.getSQL4InsertSumLvl1Insert(tempTable, rs, displayAmount, displayUnit, isBaseCurrencyQuery, loc, false));
                    s.append(this.getSQL4InsertSumLvl1Select(tempTable, rs, displayAmount, isBaseCurrencyQuery, loc, displayUnit, isCsspGroup, groupTable, standardTable, detail, fGDcsspGroupID, fGDcsspGroupStandardID, fmappingfieldname, accountAsstItem));
                    this.executeUpdate(s.toString(), null, ctx);
                    String u = "update " + tempTable + " set(FLevel)=(select isnull(B.FLevel,0)+1 from " + firstTable + " A," + groupTable + " B where A.FID=" + tempTable + ".FID0 and  B.FID=A." + groupTableField + ")\n where " + tempTable + ".FLevel=0";
                    if (isCsspGroup) {
                        AcctountAsstItemParser.Group group = accountAsstItem.asstItems[0].group[0];
                        u = "update " + tempTable + " set(FLevel)=(select isnull(B.FLevel,0)+1 from " + detail + " A," + standardTable + " GS," + groupTable + " B where A." + fmappingfieldname + "=" + tempTable + ".FID0 and  GS.FID=A." + fGDcsspGroupStandardID + " and B.fid = A." + fGDcsspGroupID + " and GS.fnumber = '" + group.standardNumber + "')\n where " + tempTable + ".FLevel=0 ";
                    }
                    this.executeUpdate(u, null, ctx);
                    s.setLength(0);
                    s.append(this.getSQL4InsertSumLvl1Insert(tempTable, rs, displayAmount, displayUnit, isBaseCurrencyQuery, loc, false));
                    s.append(this.getSQL4InsertSumLvl2Select(tempTable, rs, displayAmount, isBaseCurrencyQuery, loc, displayUnit, isCsspGroup, groupTable, standardTable, detail, fGDcsspGroupID, fGDcsspGroupStandardID, fmappingfieldname, accountAsstItem));
                    SqlParams ss = new SqlParams();
                    for (int i = maxLevel; i > 0; --i) {
                        ss.setInt(1, i);
                        this.executeUpdate(s.toString(), ss, ctx);
                    }
                }
            }
        }
        String balanceTempTable = "RptAsstActBalance_Balance";
        StringBuffer qq = new StringBuffer("select ");
        StringBuffer qqSum = new StringBuffer();
        StringBuffer qqSumAss = new StringBuffer();
        StringBuffer gg = new StringBuffer("\n group by ");
        rs.reset();
        if (isBizCode) {
            StringBuffer ff = new StringBuffer().append("FNumber0").append(',').append("FID0").append(',').append("FName0").append(',');
            qqSum.append("' ',' ','").append(GLResUtil.getRes("subtotal", ctx)).append(" ',");
            qq.append(ff);
            qqSumAss.append(ff);
            gg.append(ff);
        } else {
            while (rs.next()) {
                n = rs.getRow();
                StringBuffer ff = new StringBuffer().append("FNumber").append(n).append(',').append("FLongNumber").append(n).append(',').append("FID").append(n).append(',').append("FName").append(n).append(',');
                qqSum.append("' ',' ',' ','");
                if (n == 0) {
                    qqSum.append(GLResUtil.getRes("subtotal", ctx)).append(" ',");
                } else {
                    qqSum.append(" ',");
                }
                qqSumAss.append(ff);
                qq.append(ff);
                gg.append(ff);
            }
        }
        qq.append("  FaccountNumber,  FaccountName, FaccountID,faccountdc,");
        if (isBaseCurrencyQuery) {
            qqSumAss.append(" '").append(GLResUtil.getRes("subtotal", ctx)).append("','").append(" ").append("',' ',case when sum(FBeginBalanceDebitFor) >= sum(FBeginBalanceCreditFor) then 1 else 0 end,");
            qqSum.append(" ' ',' ',' ',case when sum(FBeginBalanceDebitFor) >= sum(FBeginBalanceCreditFor) then 1 else 0 end,");
        } else {
            qqSumAss.append(" '").append(GLResUtil.getRes("subtotal", ctx)).append("','").append(" ").append("',' ',case when sum(FBeginBalanceDebitFor) >= sum(FBeginBalanceCreditFor) then 1 else 0 end,");
            qqSum.append(" ' ',' ',' ',case when sum(FBeginBalanceDebitFor) >= sum(FBeginBalanceCreditFor) then 1 else 0 end,");
        }
        if (displayUnit) {
            qq.append(" muId, muName, ");
            qqSumAss.append(" muId,muName, ");
            qqSum.append(" ' ',' ',");
        }
        StringBuffer sumFBeginBalanceDebitFor = new StringBuffer();
        StringBuffer sumFBeginBalanceCreditFor = new StringBuffer();
        StringBuffer sumFBeginBalanceDebitLocal = new StringBuffer();
        StringBuffer sumFBeginBalanceCreditLocal = new StringBuffer();
        StringBuffer sumFEndBalanceDebitFor = new StringBuffer();
        StringBuffer sumFEndBalanceCreditFor = new StringBuffer();
        StringBuffer sumFEndBalanceDebitLocal = new StringBuffer();
        StringBuffer sumFEndBalanceCreditLocal = new StringBuffer();
        StringBuffer amount = new StringBuffer();
        if (isBaseCurrencyQuery) {
            if (displayAmount) {
                qq.append(" sum(FBeginQty) FBeginQty, \t\t\t\t\t\t\n");
                qqSumAss.append(" sum(FBeginQty) FBeginQty, \t\t\t\t\t\t\n");
                qqSum.append(" sum(FBeginQty) FBeginQty, \t\t\t\t\t\n");
                amount.append(" sum(FDebitQty) FDebitQty, \t\t\t\t\t\n");
                amount.append(" sum(FDebitFor) FDebitFor, \t\t\t\t\t\t\n");
                amount.append(" sum(FCreditQty) FCreditQty, \t\t\t\t\n");
                amount.append(" sum(FCreditFor) FCreditFor,\t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitQty) FYearDebitQty, \t\t\t\n");
                amount.append(" sum(FYearDebitFor) FYearDebitFor,\t\t\t\t\t\n");
                amount.append(" sum(FYearCreditQty) FYearCreditQty, \t\t\n");
                amount.append(" sum(FYearCreditFor) FYearCreditFor, \t\t\t\t\n");
                amount.append(" sum(FEndQty) FEndQty, \t\t\t\t\t\t\n");
            } else {
                amount.append("sum(FDebitFor) FDebitFor, sum(FCreditFor) FCreditFor, \r\n");
                amount.append("sum(FYearDebitFor) FYearDebitFor, \r\n");
                amount.append("sum(FYearCreditFor) FYearCreditFor, \r\n");
            }
            qq.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t\n");
            qq.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor, \t\n");
            qqSumAss.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t\n");
            qqSumAss.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor, \t\n");
            qqSum.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t\n");
            qqSum.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor, \t\n");
            qq.append(amount);
            qq.append(" sum(FEndBalanceDebitFor) FEndBalanceDebitFor, \t\t\t\t\t\t\n");
            qq.append(" sum(FEndBalanceCreditFor) FEndBalanceCreditFor, \t\t\t\t\t\t\n");
            qqSumAss.append(amount);
            qqSumAss.append(" sum(FEndBalanceDebitFor) FEndBalanceDebitFor, \t\t\t\t\t\t\n");
            qqSumAss.append(" sum(FEndBalanceCreditFor) FEndBalanceCreditFor, \t\t\t\t\t\t\n");
            qqSum.append(amount);
            qqSum.append(" sum(FEndBalanceDebitFor) FEndBalanceDebitFor, \t\t\t\t\t\t\n");
            qqSum.append(" sum(FEndBalanceCreditFor) FEndBalanceCreditFor, \t\t\t\t\t\n");
        } else {
            if (displayAmount) {
                qq.append(" sum(FBeginQty) FBeginQty, \t\t\t\t\t\t\t\t\t\n");
                qqSumAss.append(" sum(FBeginQty) FBeginQty, \t\t\t\t\t\t\t\t\t\n");
                qqSum.append(" sum(FBeginQty) FBeginQty, \t\t\t\t\t\t\t\t\n");
                amount.append(" sum(FDebitQty) FDebitQty, \t\t\t\t\t\t\t\t\n");
                amount.append(" sum(FDebitFor) FDebitFor, \t\t\t\t\t\t\t\t\n");
                amount.append(" sum(FDebitLocal) FDebitLocal, \t\t\t\t\t\t\t\n");
                amount.append(" sum(FCreditQty) FCreditQty, \t\t\t\t\t\t\t\n");
                amount.append(" sum(FCreditFor) FCreditFor,\t\t\t\t\t\t\t\t\n");
                amount.append(" sum(FCreditLocal) FCreditLocal,\t\t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitQty) FYearDebitQty, \t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitFor) FYearDebitFor,\t\t\t\t\t\t\n");
                amount.append(" sum(FYearDebitLocal) FYearDebitLocal,\t\t\t\t\t\n");
                amount.append(" sum(FYearCreditQty) FYearCreditQty, \t\t\t\t\t\n");
                amount.append(" sum(FYearCreditFor) FYearCreditFor, \t\t\t\t\t\n");
                amount.append(" sum(FYearCreditLocal) FYearCreditLocal, \t\t\t\t\n");
                amount.append(" sum(FEndQty) FEndQty, \t\t\t\t\t\t\t\t\t\n");
            } else {
                amount.append("sum(FDebitFor) FDebitFor, \t\t\t\t\t\t\t\t\n");
                amount.append("sum(FDebitLocal) FDebitLocal, \t\t\t\t\t\t\t\n");
                amount.append("sum(FCreditFor) FCreditFor, \t\t\t\t\t\t\t\t\n");
                amount.append("sum(FCreditLocal) FCreditLocal, \t\t\t\t\t\t\t\n");
                amount.append("sum(FYearDebitFor) FYearDebitFor,\t\t\t\t\t\t\n");
                amount.append("sum(FYearDebitLocal) FYearDebitLocal,\t\t\t\t\t\n");
                amount.append("sum(FYearCreditFor) FYearCreditFor, \t\t\t\t\t\t\n");
                amount.append("sum(FYearCreditLocal) FYearCreditLocal, \t\t\t\t\t\n");
            }
            qq.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t\t\t\n");
            qq.append(" sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal, \t\t\n");
            qq.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor, \t\t\n");
            qq.append(" sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal, \t\n");
            qq.append(amount);
            qq.append(" sum(FEndBalanceDebitFor) FEndBalanceDebitFor, \t\t\t\t\t\n");
            qq.append(" sum(FEndBalanceDebitLocal) FEndBalanceDebitLocal, \t\t\t\t\n");
            qq.append(" sum(FEndBalanceCreditFor) FEndBalanceCreditFor, \t\t\t\t\n");
            qq.append(" sum(FEndBalanceCreditLocal) FEndBalanceCreditLocal, \t\t\t\n");
            qqSumAss.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t\t\t\n");
            qqSumAss.append(" sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal, \t\t\n");
            qqSumAss.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor, \t\t\n");
            qqSumAss.append(" sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal, \t\n");
            qqSumAss.append(amount);
            qqSumAss.append(" sum(FEndBalanceDebitFor) FEndBalanceDebitFor, \t\t\t\t\t\n");
            qqSumAss.append(" sum(FEndBalanceDebitLocal) FEndBalanceDebitLocal, \t\t\t\t\n");
            qqSumAss.append(" sum(FEndBalanceCreditFor) FEndBalanceCreditFor, \t\t\t\t\n");
            qqSumAss.append(" sum(FEndBalanceCreditLocal) FEndBalanceCreditLocal, \t\t\t\n");
            qqSum.append(" sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor, \t\t\n");
            qqSum.append(" sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal, \t\n");
            qqSum.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor,\n");
            qqSum.append(" sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal,\t\n");
            qqSum.append(amount);
            qqSum.append(" sum(FEndBalanceDebitFor) FEndBalanceDebitFor, \t\t\t\t\n");
            qqSum.append(" sum(FEndBalanceDebitLocal) FEndBalanceDebitLocal, \t\t\t\n");
            qqSum.append(" sum(FEndBalanceCreditFor) FEndBalanceCreditFor, \t\t\t\t\n");
            qqSum.append(" sum(FEndBalanceCreditLocal) FEndBalanceCreditLocal, \t\t\t\n");
        }
        qq.append("FLevel,FIsLeaf,FOrderNumber");
        qqSumAss.append("t.FLevel,t.FIsLeaf,FOrderNumber");
        qq.append("\n from ").append(tempTable).append(" t ");
        gg.append("t.FLevel,t.FIsLeaf,FOrderNumber");
        if (displayUnit) {
            gg.append(" ,muId, muName ");
        }
        qq.append(gg);
        qq.append(",FaccountNumber,  FaccountName, FaccountID,faccountdc");
        balanceTempTable = this.executeCreateTableAsSelectInto("select * into " + balanceTempTable + " from ( " + qq + ") a", null, ctx).getTempTable();
        qqSum.append(" 0,0,'").append(GlUtils.getMaxChar()).append("'  from ").append(balanceTempTable).append(" t ");
        if (!showOnlySubAccountview) {
            qqSum.append(" inner join t_bd_accountview av on av.fid = t.faccountid ");
        }
        qqSum.append(" where t.FIsLeaf = 1 ");
        if (!showOnlySubAccountview) {
            levelFrom = 1;
            if (params.getObjectElement("jspLevelFrom.value") != null) {
                levelFrom = (Integer)params.getObjectElement("jspLevelFrom.value");
            }
            qqSum.append(" and av.flevel = ").append(levelFrom);
        }
        qqSumAss.append("  from ").append(balanceTempTable).append(" t ");
        if (!showOnlySubAccountview) {
            qqSumAss.append(" inner join t_bd_accountview av on av.fid = t.faccountid ");
        }
        qqSumAss.append("\r\n where t.FOrderNumber <> '").append(GlUtils.getMaxChar()).append("'");
        if (!showOnlySubAccountview) {
            levelFrom = 1;
            if (params.getObjectElement("jspLevelFrom.value") != null) {
                levelFrom = (Integer)params.getObjectElement("jspLevelFrom.value");
            }
            qqSumAss.append(" and av.flevel = ").append(levelFrom);
        }
        qqSumAss.append(gg);
        qqSumAss = new StringBuffer().append("insert into " + balanceTempTable + " select ").append(qqSumAss);
        String sql = " select top 1 * from  " + balanceTempTable;
        RptRowSet set = this.executeQuery(sql, null, ctx);
        if (set != null && set.next()) {
            this.executeUpdate("insert into " + balanceTempTable + " select " + qqSum.toString(), null, ctx);
        }
        if (isDisplayAssSum) {
            this.executeUpdate(qqSumAss.toString(), null, ctx);
        }
        if (isBalDcSameAsAccount.booleanValue()) {
            this.updateBalanceDC4SumLine(ctx, balanceTempTable, isBaseCurrencyQuery);
        }
        StringBuffer rsWhere = new StringBuffer("");
        if (noDisplayBalanceZero) {
            if (isBaseCurrencyQuery) {
                rsWhere.append(" where FEndBalanceDebitFor<>0 or FEndBalanceCreditFor<>0  ");
            } else {
                rsWhere.append(" where FEndBalanceDebitFor<>0 or FEndBalanceDebitLocal<>0 or FEndBalanceCreditFor<>0 or FEndBalanceCreditLocal<>0 ");
            }
        }
        StringBuffer rsOrder = new StringBuffer();
        rsOrder.append(" \n order by ");
        rsOrder.append(" FOrderNumber,");
        rs.reset();
        if (isBizCode) {
            rsOrder.append(" fnumber0,");
        } else {
            while (rs.next()) {
                rsOrder.append("FNumber").append(rs.getRow()).append(',');
            }
        }
        rsOrder.append("FLevel");
        if (displayUnit) {
            rsOrder.append(" ,muId, muName ");
        }
        rsOrder.append(",faccountnumber");
        RptRowSet prs = this.executeQuery("select * from " + balanceTempTable + rsWhere + rsOrder, null, ctx);
        RptParams rp = new RptParams();
        rp.setString("tempTable", tempTable);
        rp.setObject("header", (Object)header);
        rp.setObject("prs", (Object)prs);
        int rsRowCont = isBizCode ? 3 : rs.getRowCount() * 4;
        rsRowCont += 4;
        if (displayUnit) {
            rp.setInt("amountBeginIndex", rsRowCont + 2);
        } else {
            rp.setInt("amountBeginIndex", rsRowCont);
        }
        if (tempNoTransPLVoucherTable != null) {
            this._dropPoolTempTable(ctx, tempNoTransPLVoucherTable);
        }
        return rp;
    }

    private StringBuffer queryBizCodeHgid(Context ctx, String bizCodeFromNumber, String bizCodeToNumber) throws BOSException {
        StringBuffer queryBizCodeHgid = new StringBuffer();
        String loc = this.getLoc(ctx);
        queryBizCodeHgid.append("(select distinct * from (select hg.fid fid,bac.fid bacid ,bac.fnumber bacnumber ,bac.fname_").append(loc).append(" bacname from t_bd_assistanthg hg inner join t_bd_customer cst on hg.fcustomerid = cst.fid inner join T_BD_BizAnaylysisCode bac on bac.fid = cst.FBizAnalysisCodeID ");
        if (bizCodeFromNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber >='").append(bizCodeFromNumber).append("' ");
        }
        if (bizCodeToNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber <='").append(bizCodeToNumber).append("~' ");
        }
        queryBizCodeHgid.append("\r\n union all ");
        queryBizCodeHgid.append("select hg1.fid fid,bac.fid bacid,bac.fnumber bacnumber ,bac.fname_").append(loc).append(" bacname  from t_bd_assistanthg hg1 inner join T_BD_Supplier sup on hg1.FProviderID = sup.fid inner join T_BD_BizAnaylysisCode bac on bac.fid = sup.FBizAnalysisCodeID ");
        if (bizCodeFromNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber >='").append(bizCodeFromNumber).append("' ");
        }
        if (bizCodeToNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber <='").append(bizCodeToNumber).append("~' ");
        }
        queryBizCodeHgid.append("\r\n) T_Hgid0) T_Hgid ");
        return queryBizCodeHgid;
    }

    private void buildLocalSelect(RptParams params, PeriodInfo currPeriod, boolean displayAmount, boolean isExchangeStandardUnit, StringBuffer select) {
        boolean isOverCurrentYear;
        String currencyID = String.valueOf(params.getObjectElement("jbxCurrency.value.id"));
        String fieldSuffix = RptServerUtil.getCurrencyFieldSuffix(currencyID);
        boolean isForgenCurr = params.getBoolean("isForgenCurr");
        if (isForgenCurr) {
            fieldSuffix = "For";
        }
        boolean isDCSeparate = (Boolean)params.getObjectElement("jcbisDCSperate.value");
        boolean isBalDcSameAsAccount = (Boolean)params.getObject("isBalDcSameAsAccount");
        if (displayAmount) {
            select.append("\n sum(case when A.FPeriod=? then ");
            if (isExchangeStandardUnit) {
                select.append("D.FDC*A.FBeginQty*mu.fcoefficient");
            } else {
                select.append("D.FDC*A.FBeginQty");
            }
            select.append(" else 0 end) FBeginQty,\t\t\t\t\t\t\r\n");
        }
        if (!isDCSeparate) {
            select.append("\n sum(case when D.FDC=1  and A.FPeriod=? then A.FBeginBalance").append(fieldSuffix).append(" else 0 end) FBeginBalanceDebitFor,");
            select.append("\n sum(case when D.FDC=-1 and A.FPeriod=? then D.FDC*A.FBeginBalance").append(fieldSuffix).append(" else 0 end) FBeginBalanceCreditFor,");
        } else {
            select.append("\n sum(case when A.FBeginBalance").append(fieldSuffix).append(">0  and A.FPeriod=? then A.FBeginBalance").append(fieldSuffix).append(" else 0 end) FBeginBalanceDebitFor,");
            select.append("\n sum(case when A.FBeginBalance").append(fieldSuffix).append("<0 and A.FPeriod=? then -1*A.FBeginBalance").append(fieldSuffix).append(" else 0 end) FBeginBalanceCreditFor,");
        }
        if (displayAmount) {
            if (isExchangeStandardUnit) {
                select.append("\n sum(A.FDebitQty*mu.fcoefficient) FDebitQty, \t\t\t \r\n");
                select.append("\n sum(A.FDebit").append(fieldSuffix).append(") FDebitFor,   \r\n");
                select.append("\n sum(A.FCreditQty*mu.fcoefficient) FCreditQty, \t\t \r\n");
                select.append("\n sum(A.FCredit").append(fieldSuffix).append(") FCreditFor, \r\n");
            } else {
                select.append("\n sum(A.FDebitQty) FDebitQty, \r\n");
                select.append("\n sum(A.FDebit").append(fieldSuffix).append(") FDebitFor,   \r\n");
                select.append("\n sum(A.FCreditQty) FCreditQty, \t\t\t\t\t\t \r\n");
                select.append("\n sum(A.FCredit").append(fieldSuffix).append(") FCreditFor, \r\n");
            }
        } else {
            select.append("\n sum(A.FDebit").append(fieldSuffix).append(") FDebitFor, \t\t \r\n");
            select.append("\n sum(A.FCredit").append(fieldSuffix).append(") FCreditFor, \t \r\n");
        }
        int currPeriodNum = currPeriod.getPeriodYear() * 100 + currPeriod.getPeriodNumber();
        int currPeriodYear = currPeriod.getPeriodYear();
        int yearTo = (Integer)params.getObjectElement("jspYearTo.value");
        int periodTo = (Integer)params.getObjectElement("jspPeriodTo.value");
        int pNumberTo = yearTo * 100 + periodTo;
        boolean endPeriodNoAfterCurrent = yearTo * 100 + periodTo <= currPeriodNum;
        boolean bl = isOverCurrentYear = yearTo > currPeriod.getPeriodYear();
        if (displayAmount) {
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when A.FPeriod =").append(pNumberTo);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FYearDebitQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FYearDebitQty");
                }
            } else if (!isOverCurrentYear) {
                select.append(" sum(case when A.FPeriod > ").append(currPeriodNum);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FDebitQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FDebitQty");
                }
                select.append(" when A.FPeriod = ").append(currPeriodNum);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FYearDebitQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FYearDebitQty");
                }
            } else {
                select.append(" sum(case when TO_INT(A.FPeriod/100) > ").append(currPeriodYear);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FDebitQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FDebitQty");
                }
            }
            select.append(" else 0 end) FYearDebitQty,\t\t\t\t\r\n");
        }
        if (endPeriodNoAfterCurrent) {
            select.append(" sum(case when A.FPeriod =").append(pNumberTo).append(" then A.FYearDebit").append(fieldSuffix);
        } else if (!isOverCurrentYear) {
            select.append(" sum(case when A.FPeriod > ").append(currPeriodNum).append(" then A.FDebit").append(fieldSuffix);
            select.append(" when A.FPeriod = ").append(currPeriodNum).append(" then A.FYearDebit").append(fieldSuffix);
        } else {
            select.append(" sum(case when TO_INT(A.FPeriod/100) > ").append(currPeriodYear).append(" then A.FDebit").append(fieldSuffix);
        }
        select.append(" else 0 end) FYearDebitFor,\t\t\t\t\t\t\r\n");
        if (displayAmount) {
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when A.FPeriod =").append(pNumberTo);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FYearCreditQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FYearCreditQty");
                }
            } else if (!isOverCurrentYear) {
                select.append(" sum(case when A.FPeriod > ").append(currPeriodNum);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FCreditQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FCreditQty");
                }
                select.append(" when A.FPeriod = ").append(currPeriodNum);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FYearCreditQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FYearCreditQty");
                }
            } else {
                select.append(" sum(case when TO_INT(A.FPeriod/100) > ").append(currPeriodYear);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FCreditQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FCreditQty");
                }
            }
            select.append(" else 0 end) FYearCreditQty,\t\t\t\t\r\n");
        }
        if (endPeriodNoAfterCurrent) {
            select.append(" sum(case when A.FPeriod =").append(pNumberTo).append(" then A.FYearCredit").append(fieldSuffix);
        } else if (!isOverCurrentYear) {
            select.append(" sum(case when A.FPeriod > ").append(currPeriodNum).append(" then A.FCredit").append(fieldSuffix);
            select.append(" when A.FPeriod = ").append(currPeriodNum).append(" then A.FYearCredit").append(fieldSuffix);
        } else {
            select.append(" sum(case when TO_INT(A.FPeriod/100) > ").append(currPeriodYear).append(" then A.FCredit").append(fieldSuffix);
        }
        select.append(" else 0 end) FYearCreditFor,\t\t\t\t\r\n");
        if (displayAmount) {
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when A.FPeriod =").append(pNumberTo);
                if (isExchangeStandardUnit) {
                    select.append(" then D.FDC*A.FEndQty *mu.fcoefficient ");
                } else {
                    select.append(" then D.FDC*A.FEndQty  ");
                }
            } else {
                select.append(" sum(case when A.FPeriod > ").append(currPeriodNum);
                if (isExchangeStandardUnit) {
                    select.append(" then D.FDC*(A.FDebitQty-A.FCreditQty) * mu.fcoefficient ");
                } else {
                    select.append(" then D.FDC*(A.FDebitQty-A.FCreditQty)  ");
                }
                select.append(" when A.FPeriod = ").append(currPeriodNum);
                if (isExchangeStandardUnit) {
                    select.append(" then D.FDC*A.FEndQty *mu.fcoefficient ");
                } else {
                    select.append(" then D.FDC*A.FEndQty  ");
                }
            }
            select.append(" else 0 end) FEndQty,\t\t\t\r\n");
        }
        if (!isDCSeparate) {
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when D.FDC=1 and A.FPeriod =").append(pNumberTo).append(" then A.FEndBalance").append(fieldSuffix);
            } else {
                select.append(" sum(case when D.FDC=1 and A.FPeriod > ").append(currPeriodNum).append(" then A.FDebit").append(fieldSuffix).append("-").append("A.FCredit").append(fieldSuffix);
                select.append(" when D.FDC=1 and A.FPeriod = ").append(currPeriodNum).append(" then A.FEndBalance").append(fieldSuffix);
            }
            select.append(" else 0 end) FEndBalanceDebitFor, \t\t\r\n");
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when D.FDC=-1 and A.FPeriod =").append(pNumberTo).append(" then -1*A.FEndBalance").append(fieldSuffix);
            } else {
                select.append(" sum(case when D.FDC=-1 and A.FPeriod > ").append(currPeriodNum).append(" then A.FCredit").append(fieldSuffix).append("-").append("A.FDebit").append(fieldSuffix);
                select.append(" when D.FDC=-1 and A.FPeriod = ").append(currPeriodNum).append(" then -1*A.FEndBalance").append(fieldSuffix);
            }
            select.append(" else 0 end) FEndBalanceCreditFor,\t\t\r\n");
        } else {
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when A.FEndBalance").append(fieldSuffix).append(">0 and A.FPeriod =").append(pNumberTo).append(" then A.FEndBalance").append(fieldSuffix);
            } else {
                select.append(" sum(case when A.FDebit").append(fieldSuffix).append("-").append("A.FCredit").append(fieldSuffix).append(">0 and A.FPeriod > ").append(currPeriodNum).append(" then A.FDebit").append(fieldSuffix).append("-").append("A.FCredit").append(fieldSuffix);
                select.append(" when A.FEndBalance").append(fieldSuffix).append(">0 and A.FPeriod = ").append(currPeriodNum).append(" then A.FEndBalance").append(fieldSuffix);
            }
            select.append(" else 0 end) FEndBalanceDebitFor, \t\t\r\n");
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when A.FEndBalance").append(fieldSuffix).append("<0 and A.FPeriod =").append(pNumberTo).append(" then -1*A.FEndBalance").append(fieldSuffix);
            } else {
                select.append(" sum(case when A.FDebit").append(fieldSuffix).append("-").append("A.FCredit").append(fieldSuffix).append("<0 and A.FPeriod > ").append(currPeriodNum).append(" then A.FCredit").append(fieldSuffix).append("-").append("A.FDebit").append(fieldSuffix);
                select.append(" when A.FEndBalance").append(fieldSuffix).append("<0 and A.FPeriod = ").append(currPeriodNum).append(" then -1*A.FEndBalance").append(fieldSuffix);
            }
            select.append(" else 0 end) FEndBalanceCreditFor,\t\t\r\n");
        }
    }

    private void buildForSelect(RptParams params, PeriodInfo currPeriod, boolean displayAmount, boolean isExchangeStandardUnit, StringBuffer select) {
        boolean isOverCurrentYear;
        boolean isDCSeparate = (Boolean)params.getObjectElement("jcbisDCSperate.value");
        boolean isBalDcSameAsAccount = (Boolean)params.getObject("isBalDcSameAsAccount");
        if (displayAmount) {
            select.append("\n sum(case when A.FPeriod=? then ");
            if (isExchangeStandardUnit) {
                select.append("D.FDC*A.FBeginQty*mu.fcoefficient* D.FDC");
            } else {
                select.append("D.FDC*A.FBeginQty* D.FDC");
            }
            select.append(" else 0 end) FBeginQty,\t\t\t\t\t\t\r\n");
        }
        if (!isDCSeparate) {
            select.append("\n sum(case when D.FDC=1  and A.FPeriod=? then A.FBeginBalanceFor else 0 end) FBeginBalanceDebitFor,");
            select.append("\n sum(case when D.FDC=1  and A.FPeriod=? then A.FBeginBalanceLocal else 0 end) FBeginBalanceDebitLocal,");
            select.append("\n sum(case when D.FDC=-1 and A.FPeriod=? then D.FDC*A.FBeginBalanceFor else 0 end) FBeginBalanceCreditFor,");
            select.append("\n sum(case when D.FDC=-1 and A.FPeriod=? then D.FDC*A.FBeginBalanceLocal else 0 end) FBeginBalanceCreditLocal,");
        } else {
            select.append("\n sum(case when A.FBeginBalanceFor>0  and A.FPeriod=? then A.FBeginBalanceFor else 0 end) FBeginBalanceDebitFor,");
            select.append("\n sum(case when A.FBeginBalanceLocal>0  and A.FPeriod=? then A.FBeginBalanceLocal else 0 end) FBeginBalanceDebitLocal,");
            select.append("\n sum(case when A.FBeginBalanceFor<0 and A.FPeriod=? then -1*A.FBeginBalanceFor else 0 end) FBeginBalanceCreditFor,");
            select.append("\n sum(case when A.FBeginBalanceLocal<0 and A.FPeriod=? then -1*A.FBeginBalanceLocal else 0 end) FBeginBalanceCreditLocal,");
        }
        if (displayAmount) {
            if (isExchangeStandardUnit) {
                select.append("\n sum(A.FDebitQty*mu.fcoefficient) FDebitQty, \t\t\t \r\n");
                select.append("\n sum(A.FDebitFor) FDebitFor,   \t\t\t\t\t\t \r\n");
                select.append("\n sum(A.FDebitLocal) FDebitLocal,   \t\t\t\t\t \r\n");
                select.append("\n sum(A.FCreditQty*mu.fcoefficient) FCreditQty, \t\t \r\n");
                select.append("\n sum(A.FCreditFor) FCreditFor, \t\t\t\t\t\t \r\n");
                select.append("\n sum(A.FCreditLocal) FCreditLocal, \t\t\t\t\t \r\n");
            } else {
                select.append("\n sum(A.FDebitQty) FDebitQty, \t\t\t\t\t\t\t \r\n");
                select.append("\n sum(A.FDebitFor) FDebitFor,  \t\t\t\t\t\t\t \r\n");
                select.append("\n sum(A.FDebitLocal) FDebitLocal,   \t\t\t\t\t \r\n");
                select.append("\n sum(A.FCreditQty) FCreditQty, \t\t\t\t\t\t \r\n");
                select.append("\n sum(A.FCreditFor) FCreditFor,\t\t\t\t\t\t\t \r\n");
                select.append("\n sum(A.FCreditLocal) FCreditLocal, \t\t\t\t\t \r\n");
            }
        } else {
            select.append("\n sum(A.FDebitFor) FDebitFor,  \t\t\t\t\t\t\t \r\n");
            select.append("\n sum(A.FDebitLocal) FDebitLocal,   \t\t\t\t\t \r\n");
            select.append("\n sum(A.FCreditFor) FCreditFor,\t\t\t\t\t\t\t \r\n");
            select.append("\n sum(A.FCreditLocal) FCreditLocal, \t\t\t\t\t \r\n");
        }
        int currPeriodNum = currPeriod.getPeriodYear() * 100 + currPeriod.getPeriodNumber();
        int currPeriodYear = currPeriod.getPeriodYear();
        int yearTo = (Integer)params.getObjectElement("jspYearTo.value");
        int periodTo = (Integer)params.getObjectElement("jspPeriodTo.value");
        int pNumberTo = yearTo * 100 + periodTo;
        boolean endPeriodNoAfterCurrent = yearTo * 100 + periodTo <= currPeriodNum;
        boolean bl = isOverCurrentYear = yearTo > currPeriod.getPeriodYear();
        if (displayAmount) {
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when A.FPeriod =").append(periodTo);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FYearDebitQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FYearDebitQty");
                }
            } else if (!isOverCurrentYear) {
                select.append(" sum(case when A.FPeriod > ").append(currPeriodNum);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FDebitQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FDebitQty");
                }
                select.append(" when A.FPeriod = ").append(currPeriodNum);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FYearDebitQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FYearDebitQty");
                }
            } else {
                select.append(" sum(case when TO_INT(A.FPeriod/100) > ").append(currPeriodYear);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FDebitQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FDebitQty");
                }
            }
            select.append(" else 0 end) FYearDebitQty,\t\t\t\t        \r\n");
        }
        if (endPeriodNoAfterCurrent) {
            select.append(" sum(case when A.FPeriod =").append(pNumberTo).append(" then A.FYearDebitFor");
            select.append(" else 0 end) FYearDebitFor,\t\t\t\t\t\t\r\n");
            select.append(" sum(case when A.FPeriod =").append(pNumberTo).append(" then A.FYearDebitLocal");
            select.append(" else 0 end) FYearDebitLocal,\t\t\t\t\t\t\r\n");
        } else {
            if (!isOverCurrentYear) {
                select.append(" sum(case when A.FPeriod > ").append(currPeriodNum).append(" then A.FDebitFor");
                select.append(" when A.FPeriod = ").append(currPeriodNum).append(" then A.FYearDebitFor");
            } else {
                select.append(" sum(case when TO_INT(A.FPeriod/100) > ").append(currPeriodYear).append(" then A.FDebitFor");
            }
            select.append(" else 0 end) FYearDebitFor,\t\t\t\t\t\t\r\n");
            if (!isOverCurrentYear) {
                select.append(" sum(case when A.FPeriod > ").append(currPeriodNum).append(" then A.FDebitLocal");
                select.append(" when A.FPeriod = ").append(currPeriodNum).append(" then A.FYearDebitLocal");
            } else {
                select.append(" sum(case when TO_INT(A.FPeriod/100) > ").append(currPeriodYear).append(" then A.FDebitLocal");
            }
            select.append(" else 0 end) FYearDebitLocal,\t\t\t\t\t\t\r\n");
        }
        if (displayAmount) {
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when A.FPeriod =").append(pNumberTo);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FYearCreditQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FYearCreditQty");
                }
            } else if (!isOverCurrentYear) {
                select.append(" sum(case when A.FPeriod > ").append(currPeriodNum);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FCreditQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FCreditQty");
                }
                select.append(" when A.FPeriod = ").append(currPeriodNum);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FYearCreditQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FYearCreditQty");
                }
            } else {
                select.append(" sum(case when TO_INT(A.FPeriod/100) > ").append(currPeriodYear);
                if (isExchangeStandardUnit) {
                    select.append(" then A.FCreditQty*mu.fcoefficient");
                } else {
                    select.append(" then A.FCreditQty");
                }
            }
            select.append(" else 0 end) FYearCreditQty,\t\t\t\t\r\n");
        }
        if (endPeriodNoAfterCurrent) {
            select.append(" sum(case when A.FPeriod =").append(pNumberTo).append(" then A.FYearCreditFor");
            select.append(" else 0 end) FYearCreditFor,\t\t\t\t\r\n");
            select.append(" sum(case when A.FPeriod =").append(pNumberTo).append(" then A.FYearCreditLocal");
            select.append(" else 0 end) FYearCreditLocal,\t\t\t\t\r\n");
        } else {
            if (!isOverCurrentYear) {
                select.append(" sum(case when A.FPeriod > ").append(currPeriodNum).append(" then A.FCreditFor");
                select.append(" when A.FPeriod = ").append(currPeriodNum).append(" then A.FYearCreditFor");
            } else {
                select.append(" sum(case when TO_INT(A.FPeriod/100) > ").append(currPeriodYear).append(" then A.FCreditFor");
            }
            select.append(" else 0 end) FYearCreditFor,\t\t\t\t\r\n");
            if (!isOverCurrentYear) {
                select.append(" sum(case when A.FPeriod > ").append(currPeriodNum).append(" then A.FCreditLocal");
                select.append(" when A.FPeriod = ").append(currPeriodNum).append(" then A.FYearCreditLocal");
            } else {
                select.append(" sum(case when TO_INT(A.FPeriod/100) > ").append(currPeriodYear).append(" then A.FCreditLocal");
            }
            select.append(" else 0 end) FYearCreditLocal,\t\t\t\t\r\n");
        }
        if (displayAmount) {
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when A.FPeriod =").append(pNumberTo);
                if (isExchangeStandardUnit) {
                    select.append(" then D.FDC*A.FEndQty *mu.fcoefficient* D.FDC ");
                } else {
                    select.append(" then D.FDC*A.FEndQty * D.FDC ");
                }
            } else {
                select.append(" sum(case when A.FPeriod > ").append(currPeriodNum);
                if (isExchangeStandardUnit) {
                    select.append(" then D.FDC*(A.FDebitQty-A.FCreditQty) * mu.fcoefficient* D.FDC ");
                } else {
                    select.append(" then D.FDC*(A.FDebitQty-A.FCreditQty) * D.FDC ");
                }
                select.append(" when A.FPeriod = ").append(currPeriodNum);
                if (isExchangeStandardUnit) {
                    select.append(" then D.FDC*A.FEndQty *mu.fcoefficient* D.FDC ");
                } else {
                    select.append(" then D.FDC*A.FEndQty * D.FDC ");
                }
            }
            select.append(" else 0 end) FEndQty,\t\t\t\r\n");
        }
        if (!isDCSeparate) {
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when D.FDC=1 and A.FPeriod =").append(pNumberTo).append(" then A.FEndBalanceFor");
            } else {
                select.append(" sum(case when D.FDC=1 and A.FPeriod > ").append(currPeriodNum).append(" then A.FDebitFor-A.FCreditFor");
                select.append(" when D.FDC=1 and A.FPeriod = ").append(currPeriodNum).append(" then A.FEndBalanceFor");
            }
            select.append(" else 0 end) FEndBalanceDebitFor, \t\t\r\n");
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when D.FDC=1 and A.FPeriod =").append(pNumberTo).append(" then A.FEndBalanceLocal");
            } else {
                select.append(" sum(case when D.FDC=1 and A.FPeriod > ").append(currPeriodNum).append(" then A.FDebitLocal-A.FCreditLocal");
                select.append(" when D.FDC=1 and A.FPeriod = ").append(currPeriodNum).append(" then A.FEndBalanceLocal");
            }
            select.append(" else 0 end) FEndBalanceDebitLocal, \t\t\r\n");
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when D.FDC=-1 and A.FPeriod =").append(pNumberTo).append(" then -1*A.FEndBalanceFor");
                select.append(" else 0 end) FEndBalanceCreditFor,\t\t\r\n");
                select.append(" sum(case when D.FDC=-1 and A.FPeriod =").append(pNumberTo).append(" then -1*A.FEndBalanceLocal");
                select.append(" else 0 end) FEndBalanceCreditLocal,\t\t\r\n");
            } else {
                select.append(" sum(case when D.FDC=-1 and A.FPeriod > ").append(currPeriodNum).append(" then A.FCreditFor-A.FDebitFor");
                select.append(" when D.FDC=-1 and A.FPeriod = ").append(currPeriodNum).append(" then -1*A.FEndBalanceFor");
                select.append(" else 0 end) FEndBalanceCreditFor,\t\t\r\n");
                select.append(" sum(case when D.FDC=-1 and A.FPeriod > ").append(currPeriodNum).append(" then A.FCreditLocal-A.FDebitLocal");
                select.append(" when D.FDC=-1 and A.FPeriod = ").append(currPeriodNum).append(" then -1*A.FEndBalanceLocal");
                select.append(" else 0 end) FEndBalanceCreditLocal,\t\t\r\n");
            }
        } else {
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when A.FEndBalanceFor>0 and A.FPeriod =").append(pNumberTo).append(" then A.FEndBalanceFor");
            } else {
                select.append(" sum(case when A.FDebitFor-A.FCreditFor>0 and A.FPeriod > ").append(currPeriodNum).append(" then A.FDebitFor-A.FCreditFor");
                select.append(" when A.FEndBalanceFor>0 and A.FPeriod = ").append(currPeriodNum).append(" then A.FEndBalanceFor");
            }
            select.append(" else 0 end) FEndBalanceDebitFor, \t\t\r\n");
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when A.FEndBalanceLocal>0 and A.FPeriod =").append(pNumberTo).append(" then A.FEndBalanceLocal");
            } else {
                select.append(" sum(case when A.FDebitLocal-A.FCreditLocal>0 and A.FPeriod > ").append(currPeriodNum).append(" then A.FDebitLocal-A.FCreditLocal");
                select.append(" when A.FEndBalanceLocal>0 and A.FPeriod = ").append(currPeriodNum).append(" then A.FEndBalanceLocal");
            }
            select.append(" else 0 end) FEndBalanceDebitLocal, \t\t\r\n");
            if (endPeriodNoAfterCurrent) {
                select.append(" sum(case when A.FEndBalanceFor<0 and A.FPeriod =").append(pNumberTo).append(" then -1*A.FEndBalanceFor");
                select.append(" else 0 end) FEndBalanceCreditFor,\t\t\r\n");
                select.append(" sum(case when A.FEndBalanceLocal<0 and A.FPeriod =").append(pNumberTo).append(" then -1*A.FEndBalanceLocal");
                select.append(" else 0 end) FEndBalanceCreditLocal,\t\t\r\n");
            } else {
                select.append(" sum(case when A.FDebitFor-A.FCreditFor<0 and A.FPeriod > ").append(currPeriodNum).append(" then A.FCreditFor-A.FDebitFor");
                select.append(" when A.FEndBalanceFor<0 and A.FPeriod = ").append(currPeriodNum).append(" then -1*A.FEndBalanceFor");
                select.append(" else 0 end) FEndBalanceCreditFor,\t\t\r\n");
                select.append(" sum(case when A.FDebitLocal-A.FCreditLocal<0  and A.FPeriod > ").append(currPeriodNum).append(" then A.FCreditLocal-A.FDebitLocal");
                select.append(" when A.FEndBalanceLocal<0 and A.FPeriod = ").append(currPeriodNum).append(" then -1*A.FEndBalanceLocal");
                select.append(" else 0 end) FEndBalanceCreditLocal,\t\t\r\n");
            }
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        return null;
    }

    public String[] getAsstactNumber(Object params, Context ctx) throws BOSException, EASBizException {
        RptParams p = (RptParams)params;
        boolean useLongNumber = p.getBoolean("useLongNumber");
        String sql = "select fnumber," + (useLongNumber ? "flongnumber" : "fnumber") + " from " + p.getString("table") + " where fid='" + p.getString("fid") + "'";
        RptRowSet rs = this.executeQuery(sql, null, ctx);
        if (rs.next()) {
            return new String[]{rs.getString(0), rs.getString(1)};
        }
        return new String[]{"", ""};
    }

    protected String getAllParentCuIdList(String companyId, Context ctx) throws BOSException, ReportBizException, EASBizException {
        String sql = "select A.FID from t_org_baseUnit A, t_org_baseUnit B \nwhere A.FIsCU=1 and B.FID='" + companyId + "' and charindex(A.FLongNumber||'!',B.FLongNumber)=1";
        RptRowSet rst = this.executeQuery(sql, null, ctx);
        StringBuffer sb = new StringBuffer();
        while (rst.next()) {
            sb.append('\'').append(rst.getString(0)).append("',");
        }
        sb.append('\'').append(companyId).append('\'');
        return sb.toString();
    }

    @Override
    protected boolean _isAccountQty(Context ctx, String accountFrom, String accountTo, String cuId, HashMap otherParam, FilterInfo filter) throws BOSException, EASBizException {
        FilterInfo acctOldFilter = (FilterInfo)filter.clone();
        FilterInfo acctNewFilter = new FilterInfo();
        FilterItemCollection acctFic = acctNewFilter.getFilterItems();
        String mask = "";
        int index = 0;
        acctFic.add(new FilterItemInfo("isQty", (Object)0));
        acctFic.add(new FilterItemInfo("CU.id", (Object)cuId));
        mask = "#0 AND #1";
        index = 2;
        if (accountFrom != null && accountTo != null) {
            acctFic.add(new FilterItemInfo("number", (Object)accountFrom, CompareType.GREATER_EQUALS));
            acctFic.add(new FilterItemInfo("number", (Object)(accountTo + GlUtils.getMaxChar()), CompareType.LESS_EQUALS));
            mask = mask + " AND (#2 AND #3";
            index = 4;
        } else if (accountFrom != null || accountTo != null) {
            if (accountFrom != null) {
                acctFic.add(new FilterItemInfo("number", (Object)accountFrom, CompareType.GREATER_EQUALS));
            }
            if (accountTo != null) {
                acctFic.add(new FilterItemInfo("number", (Object)(accountTo + GlUtils.getMaxChar()), CompareType.LESS_EQUALS));
            }
            mask = mask + " AND (#2";
            index = 3;
        }
        if (accountFrom != null || accountTo != null) {
            int i;
            Object[] accountViewFrom = null;
            if (otherParam.get("avFrom") != null) {
                accountViewFrom = (Object[])otherParam.get("avFrom");
            }
            Object[] accountViewTo = null;
            if (otherParam.get("avTo") != null) {
                accountViewTo = (Object[])otherParam.get("avTo");
            }
            if (accountViewFrom != null && accountViewFrom.length > 1) {
                for (i = accountViewFrom.length - 2; i >= 0; --i) {
                    acctFic.add(new FilterItemInfo("number", (Object)((AccountViewInfo)accountViewFrom[i]).getNumber(), CompareType.LIKE));
                    mask = mask + " OR #" + index++;
                }
            }
            if (accountViewTo != null && accountViewTo.length > 1) {
                for (i = accountViewTo.length - 1; i >= 1; --i) {
                    acctFic.add(new FilterItemInfo("number", (Object)((AccountViewInfo)accountViewTo[i]).getNumber(), CompareType.LIKE));
                    mask = mask + " OR #" + index++;
                }
            }
            mask = mask + " )";
        }
        if (otherParam.get("hashAccountIdStr") != null) {
            acctFic.add(new FilterItemInfo("id", otherParam.get("hashAccountIdStr"), CompareType.INCLUDE));
        }
        acctOldFilter.mergeFilter(acctNewFilter, "AND");
        IAccountView iAcct = AccountViewFactory.getLocalInstance((Context)ctx);
        return !iAcct.exists(acctOldFilter);
    }

    private StringBuffer getSqlUpdateSum4BalSameAsAcct(String tempTable, boolean isBaseCurrencyQuery) {
        StringBuffer updatesql = new StringBuffer();
        updatesql.append(" update ").append(tempTable).append("  \r\n");
        updatesql.append(" set FBeginBalanceDebitFor = case when FBeginBalanceDebitFor - FBeginBalanceCreditFor >= 0 then FBeginBalanceDebitFor - FBeginBalanceCreditFor else 0 end ,  \r\n").append(" FBeginBalanceCreditFor = case when FBeginBalanceDebitFor - FBeginBalanceCreditFor < 0 then FBeginBalanceCreditFor - FBeginBalanceDebitFor  else 0 end ,  \r\n").append(" FEndBalanceDebitFor  = case when FEndBalanceDebitFor  - FEndBalanceCreditFor >= 0 then FEndBalanceDebitFor  - FEndBalanceCreditFor else 0 end,  \r\n").append(" FEndBalanceCreditFor  = case when FEndBalanceDebitFor  - FEndBalanceCreditFor < 0 then FEndBalanceCreditFor - FEndBalanceDebitFor else 0 end   \r\n");
        if (!isBaseCurrencyQuery) {
            updatesql.append(", FBeginBalanceDebitLocal = case when FBeginBalanceDebitLocal - FBeginBalanceCreditLocal > 0 then FBeginBalanceDebitLocal - FBeginBalanceCreditLocal else 0 end ,  \r\n").append(" FBeginBalanceCreditLocal = case when FBeginBalanceDebitLocal - FBeginBalanceCreditLocal < 0 then  FBeginBalanceCreditLocal - FBeginBalanceDebitLocal  else 0 end ,  \r\n").append(" FEndBalanceDebitLocal  = case when FEndBalanceDebitLocal  - FEndBalanceCreditLocal > 0 then  FEndBalanceDebitLocal  - FEndBalanceCreditLocal else 0 end,  \r\n").append(" FEndBalanceCreditLocal  = case when FEndBalanceDebitLocal  - FEndBalanceCreditLocal < 0 then  FEndBalanceCreditLocal - FEndBalanceDebitLocal   else 0 end   \r\n");
        }
        updatesql.append("where ((FBeginBalanceDebitFor<> 0 or FBeginBalanceCreditFor<> 0) or (FEndBalanceDebitFor<>0 or FEndBalanceCreditFor<>0)  \r\n");
        if (!isBaseCurrencyQuery) {
            updatesql.append(" or (FBeginBalanceDebitLocal<> 0 or FBeginBalanceCreditLocal<> 0) or (FEndBalanceDebitLocal<>0 and FEndBalanceCreditLocal<>0)  \r\n");
        }
        updatesql.append(" ) and fordernumber = '").append(GlUtils.getMaxChar()).append("'  \r\n");
        return updatesql;
    }

    private void updateBalanceDC4SumLine(Context ctx, String tempTable, boolean isBaseCurrencyQuery) throws EASBizException, BOSException {
        StringBuffer updatesql = this.getSqlUpdateSum4BalSameAsAcct(tempTable, isBaseCurrencyQuery);
        this.executeUpdate(ctx, updatesql.toString(), null);
    }

    private StringBuffer getSQL4InsertSumLvl1Insert(String tempTable, RptRowSet rs, boolean displayAmount, boolean displayUnit, boolean isBaseCurrencyQuery, String loc, boolean isForGroup) {
        StringBuffer s = new StringBuffer();
        int m = 0;
        s.append("insert into ").append(tempTable).append("    \r\n");
        s.append("   (FACCOUNTID,FACCOUNTNAME,FACCOUNTNUMBER,FACCOUNTDC,      \r\n");
        s.append("    FNUMBER0,FLONGNUMBER0,");
        if (!isForGroup) {
            s.append("FGPID0,");
        }
        s.append("FID0,FNAME0,               \r\n");
        rs.moveTo(0);
        while (rs.next()) {
            m = rs.getRow();
            s.append("\n FNumber").append(m).append(", FLongNumber").append(m).append(", FID").append(m).append(",FName").append(m).append(",  \r\n");
        }
        if (displayAmount) {
            if (isBaseCurrencyQuery) {
                s.append("\n FBeginQty,FBeginBalanceDebitFor,FBeginBalanceCreditFor,").append("FDebitQty,FDebitFor,FCreditQty,FCreditFor,");
                s.append(" FYearDebitQty,FYearDebitFor,FYearCreditQty,FYearCreditFor,").append("FEndQty,FEndBalanceDebitFor,FEndBalanceCreditFor,");
            } else {
                s.append("\n FBeginQty,").append("FBeginBalanceDebitFor,FBeginBalanceDebitLocal,").append("FBeginBalanceCreditFor,FBeginBalanceCreditLocal,").append("FDebitQty,").append("FDebitFor,FDebitLocal,").append("FCreditQty,").append("FCreditFor,FCreditLocal,").append("FYearDebitQty,").append("FYearDebitFor,FYearDebitLocal,").append("FYearCreditQty,").append("FYearCreditFor,FYearCreditLocal, ").append("FEndQty,").append("FEndBalanceDebitFor,FEndBalanceDebitLocal,").append("FEndBalanceCreditFor,FEndBalanceCreditLocal,");
            }
        } else if (isBaseCurrencyQuery) {
            s.append("\n FBeginBalanceDebitFor,FBeginBalanceCreditFor,").append("FDebitFor,FCreditFor,FYearDebitFor,FYearCreditFor,").append("FEndBalanceDebitFor,FEndBalanceCreditFor,");
        } else {
            s.append("\n FBeginBalanceDebitFor,FBeginBalanceDebitLocal,").append("FBeginBalanceCreditFor,FBeginBalanceCreditLocal,").append("FDebitFor,FDebitLocal,").append("FCreditFor,FCreditLocal,").append("FYearDebitFor,FYearDebitLocal, ").append("FYearCreditFor,FYearCreditLocal, ").append("FEndBalanceDebitFor,FEndBalanceDebitLocal,").append("FEndBalanceCreditFor,FEndBalanceCreditLocal,");
        }
        s.append("\r\n    FLEVEL,FISLEAF,");
        if (displayUnit) {
            s.append(" muId, muName, ");
        }
        s.append(" FORDERNUMBER                             \r\n");
        s.append("\t)                                                         \r\n");
        return s;
    }

    private StringBuffer getSQL4InsertSumLvl12SelectPart(String tempTable, RptRowSet rs, boolean displayAmount, boolean isBaseCurrencyQuery, String loc, boolean displayUnit, boolean isCsspGroup, String groupTable, String standardTable, String detail, String fGDcsspGroupID, String fGDcsspGroupStandardID, String fmappingfieldname, AcctountAsstItemParser.AccountAsstItem accountAsstItem) {
        StringBuffer s = new StringBuffer();
        int m = 0;
        s.append(" select  FaccountID,FaccountName,FaccountNumber, faccountdc,").append("D.FNumber FNumber0, D.FLongNumber FLongNumber0, D.FID FGPID0, D.FID FID0,").append("D.FName_").append(loc).append(" FName0, ");
        rs.moveTo(0);
        while (rs.next()) {
            m = rs.getRow();
            s.append("\n A.FNumber").append(m).append(", A.FLongNumber").append(m).append(", A.FID").append(m).append(",A.FName").append(m).append(",  \r\n");
        }
        if (displayAmount) {
            if (isBaseCurrencyQuery) {
                s.append("\n sum(FBeginQty), sum(FBeginBalanceDebitFor), sum(FBeginBalanceCreditFor), sum(FDebitQty), sum(FDebitFor), sum(FCreditQty), sum(FCreditFor),");
                s.append(" sum(FYearDebitQty), sum(FYearDebitFor), sum(FYearCreditQty), sum(FYearCreditFor), sum(FEndQty), sum(FEndBalanceDebitFor), sum(FEndBalanceCreditFor),");
            } else {
                s.append("\n sum(FBeginQty),").append("sum(FBeginBalanceDebitFor),sum(FBeginBalanceDebitLocal),").append("sum(FBeginBalanceCreditFor), sum(FBeginBalanceCreditLocal),").append("sum(FDebitQty) FDebitQty,").append("sum(FDebitFor), sum(FDebitLocal),").append("sum(FCreditQty) FCreditQty,").append("sum(FCreditFor),sum(FCreditLocal),").append("sum(FYearDebitQty) FYearDebitQty,").append("sum(FYearDebitFor),sum(FYearDebitLocal),").append("sum(FYearCreditQty) FYearCreditQty,").append("sum(FYearCreditFor),sum(FYearCreditLocal),").append("sum(FEndQty) FEndQty,").append("sum(FEndBalanceDebitFor),sum(FEndBalanceDebitLocal),").append("sum(FEndBalanceCreditFor),sum(FEndBalanceCreditLocal),");
            }
        } else if (isBaseCurrencyQuery) {
            s.append("\n sum(FBeginBalanceDebitFor), sum(FBeginBalanceCreditFor), sum(FDebitFor), sum(FCreditFor), sum(FYearDebitFor), sum(FYearCreditFor), sum(FEndBalanceDebitFor), sum(FEndBalanceCreditFor),");
        } else {
            s.append("\n sum(FBeginBalanceDebitFor),sum(FBeginBalanceDebitLocal),").append("sum(FBeginBalanceCreditFor), sum(FBeginBalanceCreditLocal),").append("sum(FDebitFor), sum(FDebitLocal),").append("sum(FCreditFor),sum(FCreditLocal),").append("sum(FYearDebitFor),sum(FYearDebitLocal),").append("sum(FYearCreditFor),sum(FYearCreditLocal),").append("sum(FEndBalanceDebitFor),sum(FEndBalanceDebitLocal), ").append("sum(FEndBalanceCreditFor),sum(FEndBalanceCreditLocal),");
        }
        s.append(" D.FLevel, 0, ");
        if (displayUnit) {
            s.append(" A.muId, A.muName ,");
        }
        s.append(" D.FLongNumber||'!!!'").append("  \r\n");
        return s;
    }

    private StringBuffer getSQL4InsertSumLvl1Select(String tempTable, RptRowSet rs, boolean displayAmount, boolean isBaseCurrencyQuery, String loc, boolean displayUnit, boolean isCsspGroup, String groupTable, String standardTable, String detail, String fGDcsspGroupID, String fGDcsspGroupStandardID, String fmappingfieldname, AcctountAsstItemParser.AccountAsstItem accountAsstItem) {
        StringBuffer s = new StringBuffer();
        s.append(this.getSQL4InsertSumLvl12SelectPart(tempTable, rs, displayAmount, isBaseCurrencyQuery, loc, displayUnit, isCsspGroup, groupTable, standardTable, detail, fGDcsspGroupID, fGDcsspGroupStandardID, fmappingfieldname, accountAsstItem));
        s.append(this.getSQL4InsertSumLvl1From(tempTable, rs, displayAmount, isBaseCurrencyQuery, loc, displayUnit, isCsspGroup, groupTable, standardTable, detail, fGDcsspGroupID, fGDcsspGroupStandardID, fmappingfieldname, accountAsstItem));
        return s;
    }

    private StringBuffer getSQL4InsertSumLvl2Select(String tempTable, RptRowSet rs, boolean displayAmount, boolean isBaseCurrencyQuery, String loc, boolean displayUnit, boolean isCsspGroup, String groupTable, String standardTable, String detail, String fGDcsspGroupID, String fGDcsspGroupStandardID, String fmappingfieldname, AcctountAsstItemParser.AccountAsstItem accountAsstItem) {
        StringBuffer s = new StringBuffer();
        s.append(this.getSQL4InsertSumLvl12SelectPart(tempTable, rs, displayAmount, isBaseCurrencyQuery, loc, displayUnit, isCsspGroup, groupTable, standardTable, detail, fGDcsspGroupID, fGDcsspGroupStandardID, fmappingfieldname, accountAsstItem));
        s.append(this.getSQL4InsertSumLvl2From(tempTable, rs, displayAmount, isBaseCurrencyQuery, loc, displayUnit, isCsspGroup, groupTable, standardTable, detail, fGDcsspGroupID, fGDcsspGroupStandardID, fmappingfieldname, accountAsstItem));
        return s;
    }

    private StringBuffer getSQL4InsertSumLvl1From(String tempTable, RptRowSet rs, boolean displayAmount, boolean isBaseCurrencyQuery, String loc, boolean displayUnit, boolean isCsspGroup, String groupTable, String standardTable, String detail, String fGDcsspGroupID, String fGDcsspGroupStandardID, String fmappingfieldname, AcctountAsstItemParser.AccountAsstItem accountAsstItem) {
        StringBuffer s = new StringBuffer();
        int m = 0;
        s.append(" from ").append(tempTable);
        if (isCsspGroup) {
            AcctountAsstItemParser.Group[] groups = accountAsstItem.asstItems[0].group;
            AcctountAsstItemParser.Group group = accountAsstItem.asstItems[0].group[0];
            s.append(" A \n inner join ").append(detail).append(" B on B.").append(fmappingfieldname).append("=A.FID0\n").append("inner join ").append(standardTable).append(" GS on GS.FID = B.").append(fGDcsspGroupStandardID).append(" inner join ").append(groupTable).append(" D on d.FID =  B.").append(fGDcsspGroupID);
            s.append(" \r\nwhere GS.fnumber = '").append(group.standardNumber).append("'");
            for (int i = 1; i < groups.length; ++i) {
                s.append(" and GS.fnumber = '").append(groups[i].standardNumber).append("'");
            }
        } else {
            s.append(" A \n inner join ").append(groupTable).append(" D  on D.FID=A.FGPID0 ");
        }
        s.append(" \n group by D.FLongNumber, D.FNumber, D.FID, D.FName_").append(loc).append(", ").append("    FaccountID,FaccountName,FaccountNumber, faccountdc,");
        if (displayUnit) {
            s.append(" A.muId, A.muName ,");
        }
        rs.moveTo(0);
        while (rs.next()) {
            m = rs.getRow();
            s.append("\n A.FNumber").append(m).append(", A.FLongNumber").append(m).append(", A.FID").append(m).append(",A.FName").append(m).append(",");
        }
        s.append("D.FLevel");
        return s;
    }

    private StringBuffer getSQL4InsertSumLvl2From(String tempTable, RptRowSet rs, boolean displayAmount, boolean isBaseCurrencyQuery, String loc, boolean displayUnit, boolean isCsspGroup, String groupTable, String standardTable, String detail, String fGDcsspGroupID, String fGDcsspGroupStandardID, String fmappingfieldname, AcctountAsstItemParser.AccountAsstItem accountAsstItem) {
        StringBuffer s = new StringBuffer();
        int m = 0;
        s.append(" from ").append(tempTable);
        s.append(" A \n inner join ").append(groupTable).append(" C  on C.FID=A.FID0  and C.FLevel=?").append(" \n inner join ").append(groupTable).append(" D  on D.FID=C.FParentID");
        s.append(" \n group by D.FLongNumber,D.FNumber, D.FID, D.FName_").append(loc).append(", ").append("    FaccountID,FaccountName,FaccountNumber, faccountdc,");
        if (displayUnit) {
            s.append(" A.muId, A.muName ,");
        }
        rs.moveTo(0);
        while (rs.next()) {
            m = rs.getRow();
            s.append("\n A.FNumber").append(m).append(", A.FLongNumber").append(m).append(", A.FID").append(m).append(",A.FName").append(m).append(",");
        }
        s.append("D.FLevel");
        return s;
    }
}

