/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.Map;

public class RptBalanceTempBase {
    public static final String COMPANYID = "companyid";
    public static final String CURRENCYID = "currencyId";
    public static final String ACCOUNTTABLEID = "accounttableid";
    public static final String PERIODRANGE = "periodRange";
    public static final String CURRENTPERIOD = "currentPeriod";
    public static final String NEXTPERIOD = "nextPeriod";
    public static final String LEVELFROM = "levelFrom";
    public static final String LEVELTO = "levelTo";
    public static final String BALTYPE = "balType";

    public static String buildTempTableData(Context ctx, Map params) throws BOSException, EASBizException {
        PeriodInfo prePeriod;
        int iCurrentPeriod;
        RptBalanceTempBase.initParam(ctx, params);
        String tempTableName = RptBalanceTempBase.creatTempTable(ctx);
        RptBalanceTempBase.insertTempBeforeData(ctx, tempTableName, params);
        RptBalanceTempBase.insertTempAfterPK(ctx, tempTableName, params);
        int[] periodRange = (int[])params.get(PERIODRANGE);
        int periodTo = periodRange[2] * 100 + periodRange[3];
        PeriodInfo currentPeriod = (PeriodInfo)params.get(CURRENTPERIOD);
        while ((iCurrentPeriod = (currentPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)(prePeriod = currentPeriod))).getPeriodYear() * 100 + currentPeriod.getPeriodNumber()) != 0 && iCurrentPeriod <= periodTo) {
            RptBalanceTempBase.insertTempBalanceForAfter(ctx, tempTableName, params, prePeriod, currentPeriod);
            RptBalanceTempBase.updateTempYearBalanceForAfter(ctx, tempTableName, params, currentPeriod);
        }
        RptBalanceTempBase.deleteTempGarbagePK(ctx, tempTableName);
        return tempTableName;
    }

    private static void insertTempBeforeData(Context ctx, String tempTableName, Map params) throws BOSException, EASBizException {
        Integer levelFrom = (Integer)params.get(LEVELFROM);
        Integer levelTo = (Integer)params.get(LEVELTO);
        PeriodInfo currentPeriod = (PeriodInfo)params.get(CURRENTPERIOD);
        int[] periodRange = (int[])params.get(PERIODRANGE);
        String currencyId = (String)params.get(CURRENCYID);
        int[] selectPeriodRange = new int[]{periodRange[0], periodRange[1], currentPeriod.getPeriodYear(), currentPeriod.getPeriodNumber()};
        StringBuffer insertTempBeforeDataSql = new StringBuffer();
        insertTempBeforeDataSql.append("Insert into " + tempTableName + " \r\n");
        insertTempBeforeDataSql.append(" ( \r\n");
        insertTempBeforeDataSql.append(RptBalanceTempBase.getInsertTempHeadSQL());
        insertTempBeforeDataSql.append(" ,FMONTHPNLFOR, FMONTHPNLLOCAL,FMONTHPNLRPT, \r\n");
        insertTempBeforeDataSql.append("fdebitfor, fcreditfor, fendbalancefor, \r\n");
        insertTempBeforeDataSql.append("fdebitlocal, fcreditlocal, fendbalancelocal, \r\n");
        insertTempBeforeDataSql.append("fdebitrpt, fcreditrpt, fendbalancerpt, \r\n");
        insertTempBeforeDataSql.append("fdebitqty, fcreditqty, fendqty \r\n");
        insertTempBeforeDataSql.append(" ) \r\n");
        insertTempBeforeDataSql.append(" SELECT tab.FBALTYPE,tab.FORGUNITID,tab.FPERIODID,tab.FACCOUNTID,tab.FAssistGrpID,tab.FCURRENCYID, \r\n");
        insertTempBeforeDataSql.append(" tab.fbeginbalancefor,tab.FYEARDEBITFOR,tab.FYEARCREDITFOR, \r\n");
        insertTempBeforeDataSql.append(" tab.fbeginbalancelocal,tab.FYEARDEBITlocal,tab.FYEARCREDITlocal, \r\n");
        insertTempBeforeDataSql.append(" tab.fbeginbalancerpt,tab.FYEARDEBITrpt,tab.FYEARCREDITrpt, \r\n");
        insertTempBeforeDataSql.append(" tab.FYEARPNLFOR,tab.FYEARPNLLOCAL,tab.FYEARPNLRPT, \r\n");
        insertTempBeforeDataSql.append(" tab.fbeginqty,tab.FYEARDEBITqty,tab.FYEARCREDITqty,p.fperiodyear,p.fperiodnumber, \r\n");
        insertTempBeforeDataSql.append(" tab.FMONTHPNLFOR, tab.FMONTHPNLLOCAL, tab.FMONTHPNLRPT, \r\n");
        insertTempBeforeDataSql.append(" isnull(tab.fdebitfor,0), isnull(tab.fcreditfor,0), isnull(tab.fendbalancefor,0), \r\n");
        insertTempBeforeDataSql.append(" isnull(tab.fdebitlocal,0), isnull(tab.fcreditlocal,0),isnull(tab.fendbalancelocal,0), \r\n");
        insertTempBeforeDataSql.append(" isnull(tab.fdebitrpt,0), isnull(tab.fcreditrpt,0), isnull(tab.fendbalancerpt,0), \r\n");
        insertTempBeforeDataSql.append(" isnull(tab.fdebitqty,0), isnull(tab.fcreditqty,0), isnull(tab.fendqty,0) \r\n");
        insertTempBeforeDataSql.append(" FROM T_GL_AssistBalance TAB \r\n");
        insertTempBeforeDataSql.append(" inner join t_bd_accountView D on D.FID=TAB.FAccountID \r\n");
        insertTempBeforeDataSql.append(" inner join t_bd_period P on P.FID=TAB.FPeriodID \r\n");
        insertTempBeforeDataSql.append(" where tab.forgunitid = ? \r\n");
        insertTempBeforeDataSql.append(" and ");
        insertTempBeforeDataSql.append(SQLUtil.getPeriodCondition("tab.fperiodyear", "tab.fperiodnumber", selectPeriodRange));
        insertTempBeforeDataSql.append(" and tab.FBalType=? \r\n");
        if (currencyId != null) {
            insertTempBeforeDataSql.append(" and tab.FCurrencyID=? \r\n");
        }
        if (levelFrom.equals(levelTo)) {
            insertTempBeforeDataSql.append(" and D.FLevel=? \r\n");
        } else {
            insertTempBeforeDataSql.append(" and D.FLevel>=? and D.FLevel<=? \r\n");
        }
        insertTempBeforeDataSql.append(" and D.Faccounttableid=? \r\n");
        ArrayList<Object> sp = new ArrayList<Object>();
        sp.add((String)params.get(COMPANYID));
        sp.add(params.get(BALTYPE));
        if (currencyId != null) {
            sp.add(currencyId);
        }
        if (levelFrom.equals(levelTo)) {
            sp.add(levelFrom);
        } else {
            sp.add(levelFrom);
            sp.add(levelTo);
        }
        sp.add((String)params.get(ACCOUNTTABLEID));
        DbUtil.execute((Context)ctx, (String)insertTempBeforeDataSql.toString(), (Object[])sp.toArray());
    }

    private static void insertTempAfterPK(Context ctx, String tempTableName, Map params) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = (PeriodInfo)params.get(CURRENTPERIOD);
        PeriodInfo nextPeriod = (PeriodInfo)params.get(NEXTPERIOD);
        int[] periodRange = (int[])params.get(PERIODRANGE);
        int[] selectPeriodRange = new int[]{nextPeriod.getPeriodYear(), nextPeriod.getPeriodNumber(), periodRange[2], periodRange[3]};
        Integer levelFrom = (Integer)params.get(LEVELFROM);
        Integer levelTo = (Integer)params.get(LEVELTO);
        String currencyId = (String)params.get(CURRENCYID);
        StringBuffer insertTempAfterPKSql = new StringBuffer();
        insertTempAfterPKSql.append(" Insert into " + tempTableName + " \r\n");
        insertTempAfterPKSql.append(" ( \r\n");
        insertTempAfterPKSql.append(" FBALTYPE, FORGUNITID, FPERIODID, FACCOUNTID, FAssistGrpID, FCURRENCYID, FSOURCETYPE \r\n");
        insertTempAfterPKSql.append(" ) \r\n");
        insertTempAfterPKSql.append(" SELECT distinct tab.FBALTYPE, tab.FORGUNITID, ? as FPERIODID, tab.FACCOUNTID, tab.FAssistGrpID, tab.FCURRENCYID, 'PK' as FSOURCETYPE \r\n");
        insertTempAfterPKSql.append(" FROM T_GL_AssistBalance TAB \r\n");
        insertTempAfterPKSql.append(" inner join t_bd_accountView D on D.FID=TAB.FAccountID --and d.fcompanyid = TAB.FORGUNITID \r\n");
        insertTempAfterPKSql.append(" left outer join " + tempTableName + " tmp \r\n");
        insertTempAfterPKSql.append(" on ((((tmp.fbaltype = tab.fbaltype AND tmp.forgunitid = tab.forgunitid) AND tmp.faccountid = tab.faccountid) AND tmp.FAssistGrpID = tab.FAssistGrpID) AND tmp.fcurrencyid = tab.fcurrencyid) \r\n");
        insertTempAfterPKSql.append(" where tab.forgunitid = ? \r\n");
        insertTempAfterPKSql.append(" and ");
        insertTempAfterPKSql.append(SQLUtil.getPeriodCondition("fperiodyear", "fperiodnumber", selectPeriodRange));
        insertTempAfterPKSql.append(" and tab.FBalType=? \r\n");
        if (currencyId != null) {
            insertTempAfterPKSql.append(" and tab.FCurrencyID=? \r\n");
        }
        if (levelFrom.equals(levelTo)) {
            insertTempAfterPKSql.append(" and D.FLevel=? \r\n");
        } else {
            insertTempAfterPKSql.append(" and D.FLevel>=? and D.FLevel<=? \r\n");
        }
        insertTempAfterPKSql.append(" and D.Faccounttableid=? \r\n");
        insertTempAfterPKSql.append(" and tmp.forgunitid is null \r\n");
        ArrayList<Object> sp = new ArrayList<Object>();
        sp.add(currentPeriod.getId().toString());
        sp.add((String)params.get(COMPANYID));
        sp.add(params.get(BALTYPE));
        if (currencyId != null) {
            sp.add((String)params.get(CURRENCYID));
        }
        if (levelFrom.equals(levelTo)) {
            sp.add(levelFrom);
        } else {
            sp.add(levelFrom);
            sp.add(levelTo);
        }
        sp.add((String)params.get(ACCOUNTTABLEID));
        DbUtil.execute((Context)ctx, (String)insertTempAfterPKSql.toString(), (Object[])sp.toArray());
    }

    private static void insertTempBalanceForAfter(Context ctx, String tempTableName, Map params, PeriodInfo prePeriod, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        StringBuffer insertBalanceForAfterSql = new StringBuffer();
        insertBalanceForAfterSql.append(" Insert Into " + tempTableName + " \r\n");
        insertBalanceForAfterSql.append(" ( \r\n");
        insertBalanceForAfterSql.append(RptBalanceTempBase.getInsertTempHeadSQL());
        insertBalanceForAfterSql.append(" ,FSOURCETYPE \r\n");
        insertBalanceForAfterSql.append(" ,fdebitfor, fcreditfor, \r\n");
        insertBalanceForAfterSql.append(" fdebitlocal, fcreditlocal, \r\n");
        insertBalanceForAfterSql.append(" fdebitrpt, fcreditrpt, \r\n");
        insertBalanceForAfterSql.append(" FMONTHPNLFOR, FMONTHPNLLOCAL,FMONTHPNLRPT, \r\n");
        insertBalanceForAfterSql.append(" fdebitqty, fcreditqty \r\n");
        insertBalanceForAfterSql.append(" ) \r\n");
        insertBalanceForAfterSql.append(" Select tmp.FBALTYPE, tmp.FORGUNITID, ? as FPeriod, tmp.FACCOUNTID, tmp.FAssistGrpID, tmp.FCURRENCYID, \r\n");
        insertBalanceForAfterSql.append(" tmp.fendbalancefor, tmp.FYEARDEBITFOR, tmp.FYEARCREDITFOR, \r\n");
        insertBalanceForAfterSql.append(" tmp.fendbalancelocal, tmp.FYEARDEBITlocal, tmp.FYEARCREDITlocal, \r\n");
        insertBalanceForAfterSql.append(" tmp.fbeginbalancerpt, tmp.FYEARDEBITrpt, tmp.FYEARCREDITrpt, \r\n");
        insertBalanceForAfterSql.append(" tmp.FYEARPNLFOR, tmp.FYEARPNLLOCAL, tmp.FYEARPNLRPT, \r\n");
        insertBalanceForAfterSql.append(" tmp.fendqty, tmp.FYEARDEBITqty, tmp.FYEARCREDITqty, ? as FPERIODYEAR, ? as FPERIODNUMBER, tmp.FSOURCETYPE, \r\n");
        insertBalanceForAfterSql.append(" isnull(tab.fdebitfor,0), isnull(tab.fcreditfor,0), \r\n");
        insertBalanceForAfterSql.append(" isnull(tab.fdebitlocal,0), isnull(tab.fcreditlocal,0), \r\n");
        insertBalanceForAfterSql.append(" isnull(tab.fdebitrpt,0), isnull(tab.fcreditrpt,0), \r\n");
        insertBalanceForAfterSql.append(" isnull(tab.FMONTHPNLFOR,0), isnull(tab.FMONTHPNLLOCAL,0), isnull(tab.FMONTHPNLRPT,0), \r\n");
        insertBalanceForAfterSql.append(" isnull(tab.fdebitqty,0), isnull(tab.fcreditqty,0) \r\n");
        insertBalanceForAfterSql.append(" From " + tempTableName + " tmp \r\n");
        insertBalanceForAfterSql.append(" left join T_GL_ASSISTBALANCE tab \r\n");
        insertBalanceForAfterSql.append(" on ((((tmp.fbaltype = tab.fbaltype AND tmp.forgunitid = tab.forgunitid) AND tmp.faccountid = tab.faccountid) AND tmp.FAssistGrpID = tab.FAssistGrpID) AND tmp.fcurrencyid = tab.fcurrencyid) \n");
        insertBalanceForAfterSql.append(" AND tab.Fperiodyear =? and tab.fperiodnumber = ?  \r\n");
        insertBalanceForAfterSql.append(" Where tmp.forgunitid = ? and tmp.fperiodid= ?     \r\n");
        ArrayList<Object> sp = new ArrayList<Object>();
        sp.add(currentPeriod.getId().toString());
        sp.add(new Integer(currentPeriod.getPeriodYear()));
        sp.add(new Integer(currentPeriod.getPeriodNumber()));
        sp.add(new Integer(currentPeriod.getPeriodYear()));
        sp.add(new Integer(currentPeriod.getPeriodNumber()));
        sp.add((String)params.get(COMPANYID));
        sp.add(prePeriod.getId().toString());
        DbUtil.execute((Context)ctx, (String)insertBalanceForAfterSql.toString(), (Object[])sp.toArray());
    }

    private static void updateTempYearBalanceForAfter(Context ctx, String tempTableName, Map params, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        StringBuffer updateYearBalanceForAfterSql = new StringBuffer();
        updateYearBalanceForAfterSql.append(" update " + tempTableName + " tmp set \r\n");
        updateYearBalanceForAfterSql.append(" FYEARDEBITFOR = FYEARDEBITFOR + fdebitfor, \r\n");
        updateYearBalanceForAfterSql.append(" FYEARCREDITFOR = FYEARCREDITFOR + fcreditfor, \r\n");
        updateYearBalanceForAfterSql.append(" fendbalancefor = fbeginbalancefor + fdebitfor - fcreditfor, \r\n");
        updateYearBalanceForAfterSql.append(" FYEARDEBITLocal = FYEARDEBITLocal + fdebitLocal, \r\n");
        updateYearBalanceForAfterSql.append(" FYEARCREDITLocal = FYEARCREDITLocal + fcreditLocal, \r\n");
        updateYearBalanceForAfterSql.append(" fendbalanceLocal = fbeginbalanceLocal + fdebitLocal - fcreditLocal, \r\n");
        updateYearBalanceForAfterSql.append(" FYEARDEBITRpt = FYEARDEBITRpt + fdebitRpt, \r\n");
        updateYearBalanceForAfterSql.append(" FYEARCREDITRpt = FYEARCREDITRpt + fcreditRpt, \r\n");
        updateYearBalanceForAfterSql.append(" fendbalanceRpt = fbeginbalanceRpt + fdebitRpt - fcreditRpt, \r\n");
        updateYearBalanceForAfterSql.append(" FYEARPNLFOR = FYEARPNLFOR + FMONTHPNLFOR, \r\n");
        updateYearBalanceForAfterSql.append(" FYEARPNLLOCAL = FYEARPNLLOCAL + FMONTHPNLLOCAL, \r\n");
        updateYearBalanceForAfterSql.append(" FYEARPNLRPT = FYEARPNLRPT + FMONTHPNLRPT, \r\n");
        updateYearBalanceForAfterSql.append(" FYEARDEBITqty = FYEARDEBITqty + fdebitqty, \r\n");
        updateYearBalanceForAfterSql.append(" FYEARCREDITqty = FYEARCREDITqty + fcreditqty, \r\n");
        updateYearBalanceForAfterSql.append(" fendqty = fbeginqty + fdebitqty - fcreditqty \r\n");
        updateYearBalanceForAfterSql.append(" where tmp.forgunitid = ? and tmp.fperiodid= ? \r\n");
        ArrayList<String> sp = new ArrayList<String>();
        sp.add((String)params.get(COMPANYID));
        sp.add(currentPeriod.getId().toString());
        DbUtil.execute((Context)ctx, (String)updateYearBalanceForAfterSql.toString(), (Object[])sp.toArray());
    }

    private static void deleteTempGarbagePK(Context ctx, String tempTableName) throws BOSException, EASBizException {
        StringBuffer deletePKSql = new StringBuffer();
        deletePKSql.append(" delete from " + tempTableName + " \r\n");
        deletePKSql.append(" where FSOURCETYPE='PK' \r\n");
        deletePKSql.append(" and ( \r\n");
        deletePKSql.append(" FBEGINBALANCEFOR=0 and FYEARDEBITFOR=0 and FYEARCREDITFOR=0 and FDEBITFOR=0 and FCREDITFOR=0 and FENDBALANCEFOR=0 \r\n");
        deletePKSql.append(" and FBEGINBALANCELOCAL=0 and FYEARDEBITLOCAL=0 and FYEARCREDITLOCAL=0 and FDEBITLOCAL=0 and FCREDITLOCAL=0 and FENDBALANCELOCAL=0 \r\n");
        deletePKSql.append(" and FBEGINBALANCERPT=0 and FYEARDEBITRPT=0 and FYEARCREDITRPT=0 and FDEBITRPT=0 and FCREDITRPT=0 and FENDBALANCERPT=0 \r\n");
        deletePKSql.append(" and FYEARPNLFOR=0 and FMONTHPNLFOR=0 and FYEARPNLLOCAL=0 and FMONTHPNLLOCAL=0 and FYEARPNLRPT=0 and FMONTHPNLRPT=0 \r\n");
        deletePKSql.append(" and FBEGINQTY=0 and FYEARDEBITQTY=0 and FYEARCREDITQTY=0 and FDEBITQTY=0 and FCREDITQTY=0 and FENDQTY=0 \r\n");
        deletePKSql.append(" ) \r\n");
        DbUtil.execute((Context)ctx, (String)deletePKSql.toString());
    }

    private static String getInsertTempHeadSQL() {
        StringBuffer insertHeadSQL = new StringBuffer();
        insertHeadSQL.append(" FBALTYPE, FORGUNITID, FPERIODID, FACCOUNTID, FAssistGrpID, FCURRENCYID, \r\n");
        insertHeadSQL.append(" fbeginbalancefor, FYEARDEBITFOR, FYEARCREDITFOR, \r\n");
        insertHeadSQL.append(" fbeginbalancelocal, FYEARDEBITlocal, FYEARCREDITlocal, \r\n");
        insertHeadSQL.append(" fbeginbalancerpt, FYEARDEBITrpt, FYEARCREDITrpt, \r\n");
        insertHeadSQL.append(" FYEARPNLFOR, FYEARPNLLOCAL,FYEARPNLRPT, \r\n");
        insertHeadSQL.append(" fbeginqty, FYEARDEBITqty, FYEARCREDITqty, TPFPERIODYEAR, TPFPERIODNUMBER \r\n");
        return insertHeadSQL.toString();
    }

    private static void initParam(Context ctx, Map params) throws BOSException, EASBizException {
        String companyId = (String)params.get(COMPANYID);
        PeriodInfo currentPeriod = GlUtils.getCurrentPeriod(ctx, companyId);
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        params.put(CURRENTPERIOD, currentPeriod);
        params.put(NEXTPERIOD, nextPeriod);
    }

    private static String creatTempTable(Context ctx) throws BOSException, EASBizException {
        String tempTableName = null;
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(" create table TMP_GL_ASSTBAL \r\n");
        createTableSql.append(" ( \r\n");
        createTableSql.append(" FBALTYPE           NUMERIC(10) not null, \r\n");
        createTableSql.append(" FORGUNITID         VARCHAR(44) not null, \r\n");
        createTableSql.append(" FPERIODID          VARCHAR(44) not null, \r\n");
        createTableSql.append(" FACCOUNTID         VARCHAR(44) not null, \r\n");
        createTableSql.append(" FASSISTGRPID       VARCHAR(44) not null, \r\n");
        createTableSql.append(" FCURRENCYID        VARCHAR(44) not null, \r\n");
        createTableSql.append(" FBEGINBALANCEFOR   NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FYEARDEBITFOR      NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FYEARCREDITFOR     NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FDEBITFOR          NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FCREDITFOR         NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FENDBALANCEFOR     NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FBEGINBALANCELOCAL NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FYEARDEBITLOCAL    NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FYEARCREDITLOCAL   NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FDEBITLOCAL        NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FCREDITLOCAL       NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FENDBALANCELOCAL   NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FBEGINBALANCERPT   NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FYEARDEBITRPT      NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FYEARCREDITRPT     NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FDEBITRPT          NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FCREDITRPT         NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FENDBALANCERPT     NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FYEARPNLFOR        NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FMONTHPNLFOR       NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FYEARPNLLOCAL      NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FMONTHPNLLOCAL     NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FYEARPNLRPT        NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FMONTHPNLRPT       NUMERIC(19,4) default 0 not null, \r\n");
        createTableSql.append(" FBEGINQTY          NUMERIC(28,10) default 0 not null, \r\n");
        createTableSql.append(" FYEARDEBITQTY      NUMERIC(28,10) default 0 not null, \r\n");
        createTableSql.append(" FYEARCREDITQTY     NUMERIC(28,10) default 0 not null, \r\n");
        createTableSql.append(" FDEBITQTY          NUMERIC(28,10) default 0 not null, \r\n");
        createTableSql.append(" FCREDITQTY         NUMERIC(28,10) default 0 not null, \r\n");
        createTableSql.append(" FENDQTY            NUMERIC(28,10) default 0 not null, \r\n");
        createTableSql.append(" TPFPERIODYEAR      NUMERIC(4) default 1900 not null,  \r\n");
        createTableSql.append(" TPFPERIODNUMBER    NUMERIC(2) default 0 not null,     \r\n");
        createTableSql.append(" FSOURCETYPE        VARCHAR(44)                        \r\n");
        createTableSql.append(" ); \r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
            String creatIndexSql = "If not exists (select 1 from KSQL_INDEXES where KSQL_INDNAME ='ix_TMP_GL_ASSTBAL') create index ix_TMP_GL_ASSTBAL on " + tempTableName + "(FORGUNITID, FPERIODID, FCURRENCYID, FBALTYPE, FACCOUNTID, FASSISTGRPID)";
            DbUtil.execute((Context)ctx, (String)creatIndexSql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }
}

