/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.app.AbstractRptVoucherGeneralControllerBean;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.KDTableHeaderModel;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptVoucherGeneralControllerBean
extends AbstractRptVoucherGeneralControllerBean {
    private static final long serialVersionUID = 4286275232763377211L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.RptAsstactBalanceListControllerBean");

    @Override
    protected Map _init(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        if (company == null) {
            throw new ReportBizException(ReportBizException.COMPANY_EMPTY);
        }
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        CurrencyCollection cc = this._getAllCurrency(ctx);
        initMap.put("getAllCurrency", cc);
        initMap.put("getCurrencyScaleMap", this._getCurrencyScaleMap(ctx, cc, company));
        initMap.put("getMaxAccountLevel", new Integer(AccountUtils.getMaxAccountLeve((Context)ctx, (IObjectPK)new ObjectUuidPK(company.getId()))));
        initMap.put("currentPeriod", this._getCurrentPeriod(ctx, company));
        return initMap;
    }

    @Override
    protected RptRowSet _createVoucherGeneralTempTable(Context ctx, RptParams params) throws BOSException, ReportBizException, EASBizException {
        int maxLevel;
        String tableName = params.getString("tableName");
        if (tableName != null) {
            this._dropTable(ctx, tableName);
        }
        tableName = this._getTemporaryTableName(ctx);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        int levelFrom = params.getInt("levelFrom");
        int levelTo = params.getInt("levelTo");
        LabelValueBean voucherType = (LabelValueBean)params.getObject("voucherType");
        boolean includeAll = false;
        int objLen = ((Object[])params.getObject("tblData")).length;
        Object[][] tblData = new Object[objLen][4];
        if (!((Object[])params.getObject("tblData") instanceof Object[][]) && (Object[])params.getObject("tblData") instanceof Object[]) {
            for (int i = 0; i < objLen; ++i) {
                for (int j = 0; j < 4; ++j) {
                    tblData[i][j] = ((Object[])((Object[])params.getObject("tblData"))[i])[j];
                }
            }
        } else {
            tblData = (Object[][])params.getObject("tblData");
        }
        CurrencyInfo currency = (CurrencyInfo)params.getObject("currency");
        String local = this._getLocaleString(ctx);
        SqlParams pp = new SqlParams();
        int pi = 1;
        StringBuffer fromWhere = new StringBuffer();
        boolean queryByPeriod = params.getBoolean("queryByPeriod");
        fromWhere.append(" from t_gl_voucherentry A \n").append("inner join t_gl_voucher B on B.FID=A.FBillID \n").append("inner join t_bd_accountview C on C.FID=A.FAccountID \n").append("inner join  t_bd_voucherTypes D on B.FVoucherTypeID=D.FID \n");
        if (queryByPeriod) {
            fromWhere.append("inner join t_bd_period pe on pe.fid = b.fperiodid \n");
        }
        fromWhere.append(" where B.FcompanyId=?  and B.fbizstatus<>0 and B.fbizstatus<>2 ");
        pp.setString(pi++, company.getId().toString());
        if (queryByPeriod) {
            fromWhere.append(" and pe.fnumber<=? and pe.fnumber>=? ");
            pp.setInt(pi++, params.getInt("endYear") * 100 + params.getInt("endPeriod"));
            pp.setInt(pi++, params.getInt("beginYear") * 100 + params.getInt("beginPeriod"));
        } else {
            pi = this.dealVoucherDate(fromWhere, pp, pi, params);
        }
        if ("-1".equals(voucherType.getValue())) {
            fromWhere.append(" and B.FBizStatus<>0");
        } else {
            int bizStatus = Integer.parseInt(voucherType.getValue());
            if (bizStatus == 5) {
                fromWhere.append(" and B.FBizStatus=5");
            } else {
                fromWhere.append(" and B.FBizStatus<>5 and  B.FBizStatus<>0 ");
            }
        }
        StringBuffer fromWhereType = new StringBuffer();
        boolean hasType = false;
        if (!includeAll) {
            fromWhereType.append(" and (");
            int n = 0;
            for (int i = 0; i < tblData.length; ++i) {
                if (!((Boolean)tblData[i][0]).booleanValue()) continue;
                if (n != 0) {
                    fromWhereType.append(" or ");
                }
                fromWhereType.append("(");
                LabelValueBean bean = (LabelValueBean)tblData[i][1];
                fromWhereType.append("D.FID=?");
                pp.setString(pi++, bean.getValue());
                if (tblData[i][2] != null && tblData[i][3] != null) {
                    if (tblData[i][2].equals(tblData[i][3])) {
                        fromWhereType.append(" and B.FNumber=? ");
                        pp.setString(pi++, String.valueOf(tblData[i][2]));
                    } else {
                        fromWhereType.append(" and B.FNumber>=?  and B.FNumber<=?");
                        pp.setString(pi++, String.valueOf(tblData[i][2]));
                        pp.setString(pi++, String.valueOf(tblData[i][3]));
                    }
                } else if (tblData[i][2] != null) {
                    fromWhereType.append(" and B.FNumber>=? ");
                    pp.setString(pi++, String.valueOf(tblData[i][2]));
                } else if (tblData[i][3] != null) {
                    fromWhereType.append(" and B.FNumber<=? ");
                    pp.setString(pi++, String.valueOf(tblData[i][3]));
                }
                fromWhereType.append(")");
                ++n;
                hasType = true;
            }
            fromWhereType.append(")");
        }
        if (hasType) {
            fromWhere.append(fromWhereType);
        } else {
            fromWhere.append(" and ( D.fid is null ) ");
        }
        String type = null;
        if (currency.isGeneralLocalCurrency()) {
            type = "1";
        } else if (currency.isGeneralReportCurrency()) {
            type = "2";
        } else {
            fromWhere.append(" and A.FCurrencyID=?");
            pp.setString(pi++, currency.getId().toString());
            type = currency.getId().toString().equals(company.getBaseCurrency().getId().toString()) ? "0" : "-1";
        }
        fromWhere.append(" and C.FLevel>=? ");
        pp.setInt(pi++, levelFrom);
        RptRowSet rst = new RptRowSet(new String[0], (Object[][])new Object[0][]);
        StringBuffer voucherCountSql = new StringBuffer();
        voucherCountSql.append("select count(1) cc ,sum(FAttachments) FAttachments from (select distinct B.fid FID, B.FAttachments FAttachments ").append(fromWhere).append(") AS TEMP");
        RptRowSet rr = null;
        long begin = System.currentTimeMillis();
        rr = this.executeQuery(voucherCountSql.toString(), pp, ctx);
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"877_RptVoucherGeneralControllerBean", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        rr.next();
        int voucherCount = rr.getInt("cc");
        int attachmentCount = rr.getObject("FAttachments") == null ? 0 : rr.getInt("FAttachments");
        StringBuffer sb = new StringBuffer();
        String faccountname = GlUtils.isAccountShowLongName(ctx, company.getId().toString()) ? "c.flongname_" + local : "c.fname_" + local;
        sb.append("  select 0 as no, C.FID accountID, C.FLevel flevel, C.FNumber,C.FLongNumber, " + faccountname + " accountName,").append(" sum(case A.FEntryDC when 1 then FOriginalAmount else 0 end) FOriginalAmount_1, ").append(" sum(case A.FEntryDC when 0 then FOriginalAmount else 0 end) FOriginalAmount_2, ").append(" sum(case A.FEntryDC when 1 then FLocalAmount else 0 end) FLocalAmount_1, ").append(" sum(case A.FEntryDC when 0 then FLocalAmount else 0 end) FLocalAmount_2, ").append(" sum(case A.FEntryDC when 1 then FReportingAmount else 0 end) FReportingAmount_1, ").append(" sum(case A.FEntryDC when 0 then FReportingAmount else 0 end) FReportingAmount_2, ").append(" sum(B.FAttachments) FAttachments  ").append(" into ").append(tableName);
        sb.append(fromWhere).append("\n group by C.FID, C.FLevel,C.FNumber,C.FLongNumber, " + faccountname + " \n");
        begin = System.currentTimeMillis();
        CreateTempTableResult result = this.executeSelectInto(sb.toString(), pp, ctx);
        tableName = result.getTempTable();
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(tableName, "accountID", false, false);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.error((Object)this, (Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"878_RptVoucherGeneralControllerBean", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        StringBuffer count = new StringBuffer();
        count.append("insert into ").append(tableName).append(" select 2,  '', -1,'" + GLResUtil.getRes("total", ctx) + "','','',sum(FOriginalAmount_1),sum(FOriginalAmount_2),sum(FLocalAmount_1),sum(FLocalAmount_2),sum(FReportingAmount_1),sum(FReportingAmount_2),-1 ").append(" from ").append(tableName).append(" union all select 3, '', -1,'" + type + "','','',0,0,0,0,0," + voucherCount + "," + attachmentCount);
        begin = System.currentTimeMillis();
        this._executeUpdate(ctx, count.toString());
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"879_RptVoucherGeneralControllerBean", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        StringBuffer levelSql = new StringBuffer();
        levelSql.append("select max(flevel) from ").append(tableName);
        RptRowSet rstLevel = this._executeQuery(ctx, levelSql.toString(), null, false, 0, -1);
        rstLevel.next();
        int n = maxLevel = rstLevel.getObject(0) == null ? 0 : rstLevel.getInt(0);
        if (maxLevel > 1) {
            String companyId = company.getId().toString();
            String accountTableId = company.getAccountTable().getId().toString();
            StringBuffer buf = new StringBuffer();
            StringBuffer sql = new StringBuffer();
            StringBuffer fields = new StringBuffer();
            begin = System.currentTimeMillis();
            for (int j = maxLevel; j > 1; --j) {
                sql.setLength(0);
                buf.setLength(0);
                sql.append("insert into ").append(tableName);
                buf.append(" \r\n inner join T_bd_accountview A0 \n on TEMP.AccountId=A0.fid  \n and A0.fcompanyid='" + companyId + "' \n and A0.FaccountTableID='" + accountTableId + "' ");
                buf.append(" \r\n inner join T_bd_accountview A1 \n on A1.FID=A0.FParentId \n and A1.fcompanyid='" + companyId + "' \n and A1.FaccountTableId='" + accountTableId + "'");
                buf.append("\n where temp.flevel=" + j);
                String alis = "A1";
                fields.setLength(0);
                fields.append("0,").append(alis).append(".FID,").append(alis).append(".flevel,").append(alis).append(".Fnumber,").append(alis).append(".Flongnumber,").append(alis).append("." + (GlUtils.isAccountShowLongName(ctx, company.getId().toString()) ? "FLongName_" : "FName_")).append(local).append(",0,0,0,0,0,0,0");
                sql.append("\n select distinct ").append(fields).append(" from ").append(tableName).append(" TEMP ");
                sql.append(buf);
                this._executeUpdate(ctx, sql.toString());
            }
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"880_RptVoucherGeneralControllerBean", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        }
        StringBuffer sc = new StringBuffer();
        sc.append("insert into ").append(tableName).append(" select 1, a1.accountid, a1.flevel,A1.fnumber,A1.flongnumber,a1.accountName,(a1.FOriginalAmount_1+a2.FOriginalAmount_1),(A1.FOriginalAmount_2+a2.FOriginalAmount_2),").append("(a1.FLocalAmount_1+a2.FLocalAmount_1),(a1.FLocalAmount_2+a2.FLocalAmount_2) ,").append("(a2.FReportingAmount_1+a1.FReportingAmount_1),(a1.FReportingAmount_2+a2.FReportingAmount_2), (a1.fAttachments+a2.fAttachments) fAttachments ").append(" from ").append(tableName).append(" a1 ").append(" inner join ").append("(select a1.flevel,A1.fnumber,sum(a2.FOriginalAmount_1) FOriginalAmount_1,sum(a2.FOriginalAmount_2) FOriginalAmount_2,").append("sum(a2.FLocalAmount_1) FLocalAmount_1,sum(a2.FLocalAmount_2) FLocalAmount_2,").append("sum(a2.FReportingAmount_1) FReportingAmount_1,sum(a2.FReportingAmount_2) FReportingAmount_2, sum(a2.fAttachments) fAttachments").append(" from ").append(tableName).append(" a1, ").append(tableName).append(" a2 ").append(" where  a1.flevel<a2.flevel and charindex(a1.flongnumber || '!', a2.flongnumber) = 1").append(" group by A1.fnumber,a1.flevel").append(")as a2").append(" on a1.fnumber=a2.fnumber ");
        begin = System.currentTimeMillis();
        this._executeUpdate(ctx, sc.toString());
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"881_RptVoucherGeneralControllerBean", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        String delDoubleSql = "delete from " + tableName + " where no!=3 and no!=2 and( flevel<" + levelFrom + " or flevel>" + levelTo + " or (no=0 and fnumber in(select fnumber from " + tableName + " where no=1)))";
        this._executeUpdate(ctx, delDoubleSql);
        rst.setProperty("tableName", (Object)tableName);
        return rst;
    }

    public int dealVoucherDate(StringBuffer fromWhere, SqlParams pp, int pi, RptParams params) {
        Timestamp dtFrom = new Timestamp(((Date)params.getObject("dateFrom")).getTime());
        Date dateTo = (Date)params.getObject("dateTo");
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(dateTo);
        gc.add(5, 1);
        Timestamp dtTo = new Timestamp(gc.getTime().getTime());
        if (dtFrom.equals(dtTo)) {
            fromWhere.append(" and B.fbookedDate=?");
            pp.setTimestamp(pi++, dtFrom);
        } else {
            fromWhere.append(" and B.fbookedDate>=? and B.fbookedDate<?");
            pp.setTimestamp(pi++, dtFrom);
            pp.setTimestamp(pi++, dtTo);
        }
        return pi;
    }

    @Override
    protected RptRowSet _queryVoucherGeneral(Context ctx, String tableName, int fromIndex, int length) throws BOSException, ReportBizException, EASBizException {
        String[][] hd2;
        String[][] hd1 = new String[][]{{GLResUtil.getRes("record_type", ctx), GLResUtil.getRes("account_number", ctx), GLResUtil.getRes("accountView_name", ctx), GLResUtil.getRes("for_debit_amount", ctx), GLResUtil.getRes("for_credit_amount", ctx), GLResUtil.getRes("local_debit_amount", ctx), GLResUtil.getRes("local_credit_amount", ctx), GLResUtil.getRes("rpt_debit_amount", ctx), GLResUtil.getRes("rpt_credit_amount", ctx)}};
        String[][] hd = hd2 = new String[][]{{GLResUtil.getRes("record_type", ctx), GLResUtil.getRes("account_number", ctx), GLResUtil.getRes("accountView_name", ctx), GLResUtil.getRes("debit_money_amount", ctx), GLResUtil.getRes("credit_money_amount", ctx)}};
        RptRowSet infoRs = this._executeQuery(ctx, "select FNumber,FReportingAmount_2 voucherCount,FAttachments from " + tableName + " where no=3");
        infoRs.next();
        String type = infoRs.getString(0);
        int voucherCount = infoRs.getObject(1) == null ? 0 : infoRs.getInt(1);
        int attachmentCount = infoRs.getObject(2) == null ? 0 : infoRs.getInt(2);
        String fields = null;
        String debit = null;
        String credit = null;
        if ("0".equals(type)) {
            fields = "FOriginalAmount_1,FOriginalAmount_2";
            debit = "FOriginalAmount_1";
            credit = "FOriginalAmount_2";
        } else if ("1".equals(type)) {
            fields = "FLocalAmount_1,FLocalAmount_2";
            debit = "FLocalAmount_1";
            credit = "FLocalAmount_2";
        } else if ("2".equals(type)) {
            fields = "FReportingAmount_1,FReportingAmount_2";
            debit = "FReportingAmount_1";
            credit = "FReportingAmount_2";
        } else {
            fields = "FOriginalAmount_1,FOriginalAmount_2,FLocalAmount_1,FLocalAmount_2,FReportingAmount_1,FReportingAmount_2";
            debit = "FOriginalAmount_1";
            credit = "FOriginalAmount_2";
        }
        String sql = "select top " + (fromIndex + length) + " no,fnumber,accountName," + fields + "  from " + tableName + " where no!=3  and (" + debit + " <> 0 or " + credit + " <> 0 )order by FNumber,no";
        RptRowSet rst = this._executeQuery(ctx, sql, null, false, fromIndex, length);
        if (fromIndex > 0) {
            return rst;
        }
        KDTableHeaderModel mm = new KDTableHeaderModel();
        mm.setHiddenColumnIndexices(new int[]{0});
        mm.setData(hd);
        if (hd == hd1) {
            rst.setProperty("numberColumnType", (Object)"1");
            rst.setProperty("numberColumns", (Object)new int[]{3, 4, 5, 6, 7, 8});
            rst.setProperty("numberColumns1", (Object)new int[]{3, 4});
            rst.setProperty("numberColumns2", (Object)new int[]{5, 6});
            rst.setProperty("numberColumns3", (Object)new int[]{7, 8});
            mm.setAlignColumns(new int[]{0, 0, 0, 2, 2, 2, 2, 2, 2, 0});
            mm.setColumnWidths(new int[]{0, 100, 100, 100, 120, 120, 120, 120, 120});
        } else {
            rst.setProperty("numberColumnType", (Object)"2");
            rst.setProperty("numberColumns", (Object)new int[]{3, 4});
            mm.setAlignColumns(new int[]{0, 0, 0, 2, 2, 0});
            mm.setColumnWidths(new int[]{0, 120, 250, 250, 250});
        }
        rst.setProperty("header", (Object)mm);
        StringBuffer countSql = new StringBuffer();
        countSql.append("select count(1) from ").append(tableName).append(" where no!=3 and (" + debit + " <> 0 or " + credit + " <> 0 )");
        rst.setVirtualRowCount(this._getRecordCount(ctx, countSql.toString(), null));
        if (rst.getVirtualRowCount() == 1) {
            rst.removeRow(0);
            rst.setVirtualRowCount(0);
            rst.setProperty("FAttachments", (Object)"0");
            rst.setProperty("voucherCount", (Object)"0");
        } else {
            rst.setProperty("FAttachments", (Object)String.valueOf(attachmentCount));
            rst.setProperty("voucherCount", (Object)String.valueOf(voucherCount));
        }
        return rst;
    }
}

