/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowKeepActivityCollection;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTypeEnum;
import com.kingdee.eas.basedata.assistant.IVoucherTypeCtrlItem;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemType;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountCategoryEnum;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ReportCurrencyConvertMode;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AssistCustomizedDataTypeEnum;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeInfo;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAssistCustomizedProperty;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.ITemplateCashflowRecord;
import com.kingdee.eas.fi.gl.ITemplateVoucherAsstRecord;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.TemplateCashflowRecordCollection;
import com.kingdee.eas.fi.gl.TemplateCashflowRecordFactory;
import com.kingdee.eas.fi.gl.TemplateCashflowRecordInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherAsstRecordCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherAsstRecordFactory;
import com.kingdee.eas.fi.gl.TemplateVoucherAsstRecordInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherInfo;
import com.kingdee.eas.fi.gl.UserSettingFactory;
import com.kingdee.eas.fi.gl.UserSettingObject;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCategoryEnum;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherHelpFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractTemplateVoucherControllerBean;
import com.kingdee.eas.fi.gl.app.VoucherHelpFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.WebTemplateVoucherCreator;
import com.kingdee.eas.fi.gl.app.WebTemplateVoucherTransfer;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TemplateVoucherControllerBean
extends AbstractTemplateVoucherControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.TemplateVoucherControllerBean");
    private Map exchangeRateCache = new HashMap();
    private Map accountAsstDefaultValue = new HashMap();

    @Override
    protected Object[] _fetchInitData(Context ctx, Object[] param) throws BOSException, EASBizException {
        return null;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TemplateVoucherInfo info = (TemplateVoucherInfo)model;
        this.checkVoucher(ctx, info);
        IObjectPK voucherPK = this.persistVoucher(ctx, info);
        return voucherPK;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this._getValue(ctx, pk, TemplateVoucherInfo.getDefaultSelector());
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.addObjectCollection((IObjectCollection)selector);
        TemplateVoucherInfo vch = null;
        try {
            vch = (TemplateVoucherInfo)super._getValue(ctx, pk, sic);
            this.fillVoucherTypeDetail(ctx, vch);
        }
        catch (Exception ex) {
            return null;
        }
        return vch;
    }

    private void fillVoucherTypeDetail(Context ctx, TemplateVoucherInfo vch) throws BOSException, EASBizException {
        VoucherTypeInfo vt = vch.getVoucherType();
        if (vt != null) {
            String comId = vch.getCompany().getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("voucherType.id", (Object)vt.getId().toString()));
            fic.add(new FilterItemInfo("company.id", (Object)comId));
            SorterItemCollection sorters = view.getSorter();
            sorters.add(new SorterItemInfo("type"));
            sorters.add(new SorterItemInfo("account.number"));
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("type"));
            sic.add(new SelectorItemInfo("account.number"));
            IVoucherTypeCtrlItem ciCtrl = VoucherTypeCtrlItemFactory.getLocalInstance((Context)ctx);
            VoucherTypeCtrlItemCollection ciCol = ciCtrl.getVoucherTypeCtrlItemCollection(view);
            vt.put("items", (Object)ciCol);
            vch.setVoucherTypeDetail(TemplateVoucherControllerBean.reorganizeCtrlItems(ciCol));
        } else {
            Object[] vtDetail = new Object[7];
            vtDetail[0] = new VoucherTypeCtrlItemCollection();
            vch.setVoucherTypeDetail(vtDetail);
        }
    }

    private static Object[] reorganizeCtrlItems(VoucherTypeCtrlItemCollection ciCol) {
        Object[] result = new Object[7];
        HashMap debitMust = new HashMap();
        HashMap creditMust = new HashMap();
        HashMap debitOrCreditMust = new HashMap();
        HashMap debitNot = new HashMap();
        HashMap creditNot = new HashMap();
        HashMap debitAndCreditNot = new HashMap();
        for (VoucherTypeCtrlItemInfo ctrlItem : ciCol) {
            VoucherTypeCtrlItemType t = ctrlItem.getType();
            if (VoucherTypeCtrlItemType.DEBIT_MUST.equals((Object)t)) {
                debitMust.put(ctrlItem.getAccount().getId().toString(), null);
                continue;
            }
            if (VoucherTypeCtrlItemType.CREDIT_MUST.equals((Object)t)) {
                creditMust.put(ctrlItem.getAccount().getId().toString(), null);
                continue;
            }
            if (VoucherTypeCtrlItemType.DEBIT_OR_CREDIT_MUST.equals((Object)t)) {
                debitOrCreditMust.put(ctrlItem.getAccount().getId().toString(), null);
                continue;
            }
            if (VoucherTypeCtrlItemType.DEBIT_MUST_NOT.equals((Object)t)) {
                debitNot.put(ctrlItem.getAccount().getId().toString(), null);
                continue;
            }
            if (VoucherTypeCtrlItemType.CREDIT_MUST_NOT.equals((Object)t)) {
                creditNot.put(ctrlItem.getAccount().getId().toString(), null);
                continue;
            }
            if (!VoucherTypeCtrlItemType.DEBIT_AND_CREDIT_MUST_NOT.equals((Object)t)) continue;
            debitAndCreditNot.put(ctrlItem.getAccount().getId().toString(), null);
        }
        if (debitMust.size() == 0) {
            debitMust = null;
        }
        if (creditMust.size() == 0) {
            creditMust = null;
        }
        if (debitOrCreditMust.size() == 0) {
            debitOrCreditMust = null;
        }
        if (debitNot.size() == 0) {
            debitNot = null;
        }
        if (creditNot.size() == 0) {
            creditNot = null;
        }
        if (debitAndCreditNot.size() == 0) {
            debitAndCreditNot = null;
        }
        result[0] = ciCol;
        result[1] = debitMust;
        result[2] = creditMust;
        result[3] = debitOrCreditMust;
        result[4] = debitNot;
        result[5] = creditNot;
        result[6] = debitAndCreditNot;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectPK persistVoucher(Context ctx, TemplateVoucherInfo voucherInfo) throws BOSException, EASBizException {
        BOSUuid vchId = voucherInfo.getId();
        boolean isNew = true;
        boolean newByGL = true;
        if (vchId != null) {
            isNew = !this._exists(ctx, (IObjectPK)new ObjectUuidPK(vchId));
            newByGL = !isNew;
        }
        IObjectPK voucherPK = null;
        int cnt = 0;
        if (voucherInfo.getNumber() == null || "".equals(voucherInfo.getNumber())) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString());
            if (null == ruleInfo) {
                throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"template_voucher", (Locale)ctx.getLocale())});
            }
            String number = iCodingRuleManager.getNumber((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "");
            while (true) {
                ++cnt;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)voucherInfo.getCompany().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
                view.setFilter(filter);
                TemplateVoucherCollection coll = this.getTemplateVoucherCollection(ctx, view);
                if (coll == null || coll.size() == 0 || cnt == 10) break;
                number = iCodingRuleManager.getNumber((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "");
            }
            voucherInfo.setNumber(number);
            if (cnt == 10) {
                this.checkVoucher(ctx, voucherInfo);
            }
        }
        if (isNew) {
            voucherPK = super.addnew(ctx, (CoreBaseInfo)voucherInfo);
            voucherInfo.put("id", voucherPK.getKeyValue("id"));
        } else {
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", (Object)vchId.toString()));
            fic.add(new FilterItemInfo("lastUpdateTime", (Object)voucherInfo.getLastUpdateTime()));
            if (!this._exists(ctx, filter)) {
                throw new VoucherException(VoucherException.EDIT_CONFLICT);
            }
            voucherPK = new ObjectUuidPK(vchId);
            super.update(ctx, voucherPK, (CoreBaseInfo)voucherInfo);
        }
        TemplateVoucherEntryCollection voucherEntryCollection = voucherInfo.getEntries();
        Iterator iteratorEntry = voucherEntryCollection.iterator();
        Connection cn = null;
        try {
            TemplateCashflowRecordCollection cashflowRecordCollection;
            Vector vecEntries;
            TemplateCashflowRecordCollection cashflowRecordCollection2;
            cn = this.getConnection(ctx);
            ORMappingDAO iTemplateVoucherEntry = new ORMappingDAO(new TemplateVoucherEntryInfo().getBOSType(), ctx, cn);
            ORMappingDAO iTemplateVoucherAsstRecord = new ORMappingDAO(new TemplateVoucherAsstRecordInfo().getBOSType(), ctx, cn);
            TemplateVoucherEntryInfo voucherEntryInfo = null;
            TemplateVoucherAsstRecordCollection voucherAssistRecordCollection = null;
            while (iteratorEntry.hasNext()) {
                voucherEntryInfo = (TemplateVoucherEntryInfo)iteratorEntry.next();
                if (voucherEntryInfo.getCurrency() == null && voucherInfo.getCompany() != null && voucherInfo.getCompany().getBaseCurrency() != null) {
                    voucherEntryInfo.setCurrency(voucherInfo.getCompany().getBaseCurrency());
                }
                if (voucherEntryInfo.getCurrency() != null && voucherEntryInfo.getCurrency().getId().equals((Object)voucherInfo.getCompany().getBaseCurrency().getId()) && voucherEntryInfo.getOriginalAmount() != null && voucherEntryInfo.getOriginalAmount().compareTo(voucherEntryInfo.getLocalAmount()) != 0) {
                    voucherEntryInfo.setOriginalAmount(voucherEntryInfo.getLocalAmount());
                }
                if (isNew) {
                    voucherEntryInfo.setOprStatus(1);
                }
                voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
                Iterator iteratorAssist = voucherAssistRecordCollection.iterator();
                TemplateVoucherAsstRecordInfo voucherAssistRecordInfo = null;
                int entryStatus = voucherEntryInfo.getOprStatus();
                if (entryStatus == 0) continue;
                voucherEntryInfo.setBill(voucherInfo);
                IObjectPK entryPK = null;
                if (entryStatus == 1) {
                    if (newByGL) {
                        voucherEntryInfo.setId(null);
                    }
                    entryPK = iTemplateVoucherEntry.addnew((IObjectValue)voucherEntryInfo);
                    voucherEntryInfo.put("id", entryPK.getKeyValue("id"));
                } else {
                    entryPK = new ObjectUuidPK(voucherEntryInfo.getId());
                    if (voucherEntryInfo.getQuantity() == null) {
                        voucherEntryInfo.setQuantity(GlUtils.zero);
                        voucherEntryInfo.setStandardQuantity(GlUtils.zero);
                    }
                    iTemplateVoucherEntry.update(entryPK, (IObjectValue)voucherEntryInfo);
                }
                while (iteratorAssist.hasNext()) {
                    int recordStatus;
                    voucherAssistRecordInfo = (TemplateVoucherAsstRecordInfo)iteratorAssist.next();
                    if (voucherEntryInfo.getCurrency() != null && voucherEntryInfo.getCurrency().getId() != null && voucherEntryInfo.getCurrency().getId().equals((Object)voucherInfo.getCompany().getBaseCurrency()) && voucherAssistRecordInfo.getOriginalAmount().compareTo(voucherAssistRecordInfo.getLocalAmount()) != 0) {
                        voucherAssistRecordInfo.setOriginalAmount(voucherAssistRecordInfo.getLocalAmount());
                    }
                    if (isNew) {
                        voucherAssistRecordInfo.setOprStatus(1);
                    }
                    if ((recordStatus = voucherAssistRecordInfo.getOprStatus()) == 0) continue;
                    voucherAssistRecordInfo.setEntry(voucherEntryInfo);
                    voucherAssistRecordInfo.setBill(voucherInfo);
                    IObjectPK recordPK = null;
                    if (recordStatus == 1) {
                        if (newByGL) {
                            voucherAssistRecordInfo.setId(null);
                        }
                        recordPK = iTemplateVoucherAsstRecord.addnew((IObjectValue)voucherAssistRecordInfo);
                        voucherAssistRecordInfo.put("id", recordPK.getKeyValue("id"));
                        continue;
                    }
                    recordPK = new ObjectUuidPK(voucherAssistRecordInfo.getId());
                    iTemplateVoucherAsstRecord.update(recordPK, (IObjectValue)voucherAssistRecordInfo);
                }
            }
            Vector vecRecords = voucherInfo.getRemovedRecords();
            if (vecRecords != null && vecRecords.size() > 0) {
                int n = vecRecords.size();
                IObjectPK[] pks = new IObjectPK[n];
                for (int i = 0; i < n; ++i) {
                    pks[i] = new ObjectUuidPK((BOSUuid)vecRecords.get(i));
                }
                iTemplateVoucherAsstRecord.delete(pks);
            }
            if (vchId != null && (cashflowRecordCollection2 = voucherInfo.getCashflowRecords()) != null && cashflowRecordCollection2.size() > 0) {
                FilterInfo filter = new FilterInfo();
                FilterItemCollection fic = filter.getFilterItems();
                String vchid = vchId.toString();
                filter.getFilterItems().add(new FilterItemInfo("voucher.ID", (Object)vchId));
                ITemplateCashflowRecord icash = TemplateCashflowRecordFactory.getLocalInstance(ctx);
                icash.delete(filter);
            }
            if ((vecEntries = voucherInfo.getRemovedEntries()) != null && vecEntries.size() > 0) {
                int n = vecEntries.size();
                IObjectPK[] pks = new IObjectPK[n];
                for (int i = 0; i < n; ++i) {
                    pks[i] = new ObjectUuidPK((BOSUuid)vecEntries.get(i));
                }
                iTemplateVoucherEntry.delete(pks);
            }
            if ((cashflowRecordCollection = voucherInfo.getCashflowRecords()) != null && cashflowRecordCollection.size() > 0) {
                ORMappingDAO iCashflowRecord = new ORMappingDAO(new TemplateCashflowRecordInfo().getBOSType(), ctx, cn);
                Iterator iteratorCF = cashflowRecordCollection.iterator();
                int seq = 0;
                while (iteratorCF.hasNext()) {
                    ++seq;
                    TemplateCashflowRecordInfo cashflowRecordInfo = (TemplateCashflowRecordInfo)iteratorCF.next();
                    CashFlowItemInfo pi = cashflowRecordInfo.getPrimaryItem();
                    if (pi != null && pi.isIsFreeze()) {
                        throw new VoucherException(VoucherException.CFITEM_DISABLED, new Object[]{pi.getNumber()});
                    }
                    CashFlowItemInfo si = cashflowRecordInfo.getSupplementaryItem();
                    if (si != null && si.isIsFreeze()) {
                        throw new VoucherException(VoucherException.CFITEM_DISABLED, new Object[]{si.getNumber()});
                    }
                    cashflowRecordInfo.setVoucher(voucherInfo);
                    UserInfo userInfo = voucherInfo.getCreator();
                    cashflowRecordInfo.setCU(voucherInfo.getCU());
                    if (cashflowRecordInfo.getCU() == null) {
                        cashflowRecordInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                    }
                    cashflowRecordInfo.setCreator(userInfo);
                    Timestamp createtime = new Timestamp(new Date().getTime());
                    cashflowRecordInfo.setCreateTime(createtime);
                    cashflowRecordInfo.setLastUpdateUser(userInfo);
                    cashflowRecordInfo.setLastUpdateTime(createtime);
                    if (cashflowRecordInfo.getSeq() == 0) {
                        cashflowRecordInfo.setSeq(seq);
                    }
                    iCashflowRecord.addnew((IObjectValue)cashflowRecordInfo);
                }
            }
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return voucherPK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectPK[] batchPersistVoucher(Context ctx, CoreBaseCollection voucherInfos) throws BOSException, EASBizException {
        TemplateVoucherInfo voucherInfo = null;
        TemplateVoucherCollection vcolls = new TemplateVoucherCollection();
        for (int i = 0; i < voucherInfos.size(); ++i) {
            vcolls.add((TemplateVoucherInfo)voucherInfos.get(i));
        }
        IObjectPK[] voucherPKs = super._addnewBatchData(ctx, (IObjectCollection)vcolls);
        voucherPKs = new IObjectPK[1];
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            ORMappingDAO iTemplateVoucherEntry = new ORMappingDAO(new TemplateVoucherEntryInfo().getBOSType(), ctx, cn);
            ORMappingDAO iTemplateVoucherAsstRecord = new ORMappingDAO(new TemplateVoucherAsstRecordInfo().getBOSType(), ctx, cn);
            ORMappingDAO iCashflowRecord = new ORMappingDAO(new TemplateCashflowRecordInfo().getBOSType(), ctx, cn);
            for (int i = 0; i < voucherInfos.size(); ++i) {
                voucherInfo = (TemplateVoucherInfo)voucherInfos.get(i);
                TemplateVoucherEntryCollection voucherEntryCollection = voucherInfo.getEntries();
                Iterator iteratorEntry = voucherEntryCollection.iterator();
                TemplateVoucherEntryInfo voucherEntryInfo = null;
                TemplateVoucherAsstRecordCollection voucherAssistRecordCollection = null;
                while (iteratorEntry.hasNext()) {
                    voucherEntryInfo = (TemplateVoucherEntryInfo)iteratorEntry.next();
                    if (voucherEntryInfo.getCurrency() != null && voucherEntryInfo.getCurrency().getId().equals((Object)voucherInfo.getCompany().getBaseCurrency().getId()) && voucherEntryInfo.getOriginalAmount().compareTo(voucherEntryInfo.getLocalAmount()) != 0) {
                        voucherEntryInfo.setOriginalAmount(voucherEntryInfo.getLocalAmount());
                    }
                    voucherEntryInfo.setOprStatus(1);
                    voucherEntryInfo.setBill(voucherInfo);
                    voucherEntryInfo.setId(null);
                    iTemplateVoucherEntry.addNewBatch((IObjectValue)voucherEntryInfo);
                    voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
                    Iterator iteratorAssist = voucherAssistRecordCollection.iterator();
                    TemplateVoucherAsstRecordInfo voucherAssistRecordInfo = null;
                    while (iteratorAssist.hasNext()) {
                        voucherAssistRecordInfo = (TemplateVoucherAsstRecordInfo)iteratorAssist.next();
                        if (voucherEntryInfo.getCurrency().getId().equals((Object)voucherInfo.getCompany().getBaseCurrency()) && voucherAssistRecordInfo.getOriginalAmount().compareTo(voucherAssistRecordInfo.getLocalAmount()) != 0) {
                            voucherAssistRecordInfo.setOriginalAmount(voucherAssistRecordInfo.getLocalAmount());
                        }
                        voucherAssistRecordInfo.setOprStatus(1);
                        voucherAssistRecordInfo.setEntry(voucherEntryInfo);
                        voucherAssistRecordInfo.setBill(voucherInfo);
                        voucherAssistRecordInfo.setId(null);
                        iTemplateVoucherAsstRecord.addNewBatch((IObjectValue)voucherAssistRecordInfo);
                    }
                }
                TemplateCashflowRecordCollection cashflowRecordCollection = voucherInfo.getCashflowRecords();
                if (cashflowRecordCollection == null || cashflowRecordCollection.size() <= 0) continue;
                Iterator iteratorCF = cashflowRecordCollection.iterator();
                int seq = 0;
                while (iteratorCF.hasNext()) {
                    ++seq;
                    TemplateCashflowRecordInfo cashflowRecordInfo = (TemplateCashflowRecordInfo)iteratorCF.next();
                    CashFlowItemInfo pi = cashflowRecordInfo.getPrimaryItem();
                    if (pi != null && pi.isIsFreeze()) {
                        throw new VoucherException(VoucherException.CFITEM_DISABLED, new Object[]{pi.getNumber()});
                    }
                    CashFlowItemInfo si = cashflowRecordInfo.getSupplementaryItem();
                    if (si != null && si.isIsFreeze()) {
                        throw new VoucherException(VoucherException.CFITEM_DISABLED, new Object[]{si.getNumber()});
                    }
                    cashflowRecordInfo.setVoucher(voucherInfo);
                    UserInfo userInfo = voucherInfo.getCreator();
                    cashflowRecordInfo.setCU(voucherInfo.getCU());
                    cashflowRecordInfo.setCreator(userInfo);
                    Timestamp createtime = new Timestamp(new Date().getTime());
                    cashflowRecordInfo.setCreateTime(createtime);
                    cashflowRecordInfo.setLastUpdateUser(userInfo);
                    cashflowRecordInfo.setLastUpdateTime(createtime);
                    if (cashflowRecordInfo.getSeq() == 0) {
                        cashflowRecordInfo.setSeq(seq);
                    }
                    iCashflowRecord.addNewBatch((IObjectValue)cashflowRecordInfo);
                }
            }
            iTemplateVoucherEntry.executeBatch();
            iTemplateVoucherAsstRecord.executeBatch();
            iCashflowRecord.executeBatch();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return voucherPKs;
    }

    public IObjectPK[] _saveBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        CoreBaseCollection info = (CoreBaseCollection)colls;
        return this.batchPersistVoucher(ctx, info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!this.exists(ctx, pk)) {
            return;
        }
        String voucherid = pk.toString();
        String sbSql = "delete from t_gl_templatecashflowrecord where fvoucherid = ?";
        this.deleteBySql(ctx, sbSql, voucherid);
        sbSql = "delete from t_gl_templatevoucherasstrecord where fbillid = ?";
        this.deleteBySql(ctx, sbSql, voucherid);
        sbSql = "delete from t_gl_templatevoucherentry where fbillid = ?";
        this.deleteBySql(ctx, sbSql, voucherid);
        super._delete(ctx, pk);
    }

    private void deleteBySql(Context ctx, String sbSql, String voucherid) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql);
            ps.setString(1, voucherid);
            sbSql = null;
            ps.executeUpdate();
        }
        catch (Exception se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
    }

    @Override
    protected Object[] _fetchAssColumnInfo(Context ctx, String acctId, String typeGroupId, String entryId) throws BOSException, EASBizException {
        Object[] result;
        VoucherInfo.DynamicColumnInfo[] itemCols = null;
        Locale[] locales = null;
        if (typeGroupId != null) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("asstActType.name"));
            sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
            sic.add(new SelectorItemInfo("asstActType.defaultQueryName"));
            sic.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
            sic.add(new SelectorItemInfo("asstActType.defaultF7UI"));
            sic.add(new SelectorItemInfo("asstActType.isForCompany"));
            sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
            sic.add(new SelectorItemInfo("asstActType.useLongNumber"));
            SorterItemCollection sorters = view.getSorter();
            sorters.add(new SorterItemInfo("seq"));
            sorters.add(new SorterItemInfo("asstActType.number"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("asstAccount.id", (Object)typeGroupId));
            IAsstActGroupDetail relCtrl = AsstActGroupDetailFactory.getLocalInstance((Context)ctx);
            AsstActGroupDetailCollection rels = relCtrl.getAsstActGroupDetailCollection(view);
            if (locales == null) {
                locales = this.getAllLocales(ctx);
            }
            itemCols = new VoucherInfo.DynamicColumnInfo[rels.size()];
            int count = 0;
            for (AsstActGroupDetailInfo r : rels) {
                AsstActTypeInfo t = r.getAsstActType();
                HashMap<Locale, String> hmMultiLangColName = new HashMap<Locale, String>();
                for (int i = 0; i < locales.length; ++i) {
                    hmMultiLangColName.put(locales[i], t.getName(locales[i]));
                }
                VoucherInfo.DynamicColumnInfo col = new VoucherInfo.DynamicColumnInfo(t.getName(), t.getAsstHGAttribute(), t.getDefaultQueryName(), t.getDefaultF7UI(), t.isIsForCompany(), hmMultiLangColName, t.getId());
                col.setGrp(t.getGlAsstActTypeGrp());
                col.setUseLongNumber(t.isUseLongNumber());
                col.setMultilevel(t.isIsMultilevel());
                itemCols[count++] = col;
            }
        } else {
            itemCols = new VoucherInfo.DynamicColumnInfo[]{};
        }
        VoucherInfo.DynamicColumnInfo[] cpCols = null;
        if (acctId != null) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("isNecessary"));
            sic.add(new SelectorItemInfo("customizedType.name"));
            sic.add(new SelectorItemInfo("customizedType.mappingPropName"));
            sic.add(new SelectorItemInfo("customizedType.dataType"));
            sic.add(new SelectorItemInfo("customizedType.defaultQueryName"));
            sic.add(new SelectorItemInfo("customizedType.defaultF7UI"));
            sic.add(new SelectorItemInfo("customizedType.precision"));
            sic.add(new SelectorItemInfo("customizedType.isForCompany"));
            SorterItemCollection sorters = view.getSorter();
            sorters.add(new SorterItemInfo("seq"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("account.id", (Object)acctId));
            fic.add(new FilterItemInfo("deletedStatus", (Object)1));
            IAssistCustomizedProperty cpCtrl = AssistCustomizedPropertyFactory.getLocalInstance(ctx);
            AssistCustomizedPropertyCollection props = cpCtrl.getAssistCustomizedPropertyCollection(view);
            if (locales == null) {
                locales = this.getAllLocales(ctx);
            }
            cpCols = new VoucherInfo.DynamicColumnInfo[props.size()];
            int count = 0;
            Iterator itr = props.iterator();
            while (itr.hasNext()) {
                AssistCustomizedPropertyInfo prop = (AssistCustomizedPropertyInfo)itr.next();
                AssistCustomizedTypeInfo t = prop.getCustomizedType();
                HashMap<Locale, String> hmMultiLangColName = new HashMap<Locale, String>();
                for (int i = 0; i < locales.length; ++i) {
                    hmMultiLangColName.put(locales[i], t.getName(locales[i]));
                }
                VoucherInfo.DynamicColumnInfo col = new VoucherInfo.DynamicColumnInfo(prop.isIsNecessary(), t.getName(), t.getDataType(), t.getMappingPropName(), t.getDefaultQueryName(), t.getDefaultF7UI(), t.getPrecision(), t.isIsForCompany(), hmMultiLangColName);
                cpCols[count++] = col;
            }
        } else {
            cpCols = new VoucherInfo.DynamicColumnInfo[]{};
        }
        result = new Object[]{itemCols, cpCols, entryId != null ? this._fetchAssData(ctx, entryId, result) : null};
        return result;
    }

    @Override
    protected IObjectCollection _fetchAssData(Context ctx, String entryId, Object[] info) throws BOSException, EASBizException {
        String propName;
        VoucherInfo.DynamicColumnInfo colInfo;
        int i;
        VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
        VoucherInfo.DynamicColumnInfo[] propCols = (VoucherInfo.DynamicColumnInfo[])info[1];
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("seq"));
        SelectorItemCollection sic = view.getSelector();
        for (i = 0; i < propCols.length; ++i) {
            colInfo = propCols[i];
            propName = colInfo.getMappingPropName();
            if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)colInfo.getDataType())) {
                sic.add(new SelectorItemInfo(propName + ".number"));
                sic.add(new SelectorItemInfo(propName + ".name"));
                continue;
            }
            sic.add(new SelectorItemInfo(propName));
        }
        for (i = 0; i < assItemCols.length; ++i) {
            colInfo = assItemCols[i];
            propName = colInfo.getMappingPropName();
            sic.add(new SelectorItemInfo("assGrp." + propName + ".number"));
            sic.add(new SelectorItemInfo("assGrp." + propName + ".name"));
            if (!colInfo.isUseLongNumber()) continue;
            sic.add(new SelectorItemInfo("assGrp." + propName + ".longNumber"));
        }
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("entry.id", (Object)entryId));
        ITemplateVoucherAsstRecord recCtrl = TemplateVoucherAsstRecordFactory.getLocalInstance(ctx);
        TemplateVoucherAsstRecordCollection records = recCtrl.getTemplateVoucherAsstRecordCollection(view);
        return records;
    }

    protected Locale[] getAllLocales(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        LanguageCollection langs = loader.getSolution().getLanguages();
        Locale[] locales = new Locale[langs.size()];
        int count = 0;
        for (LanguageInfo lang : langs) {
            locales[count++] = lang.getLocale();
        }
        return locales;
    }

    private void checkVoucher(Context ctx, TemplateVoucherInfo info) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId(), CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
            filterInfo.setMaskString("#0 and #1 and #2 ");
        } else {
            filterInfo.setMaskString("#0 and #1 ");
        }
        if (this.exists(ctx, filterInfo)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber()});
        }
    }

    private void checkBudget(Context ctx, TemplateVoucherInfo voucherInfo) throws EASBizException {
        if (voucherInfo.getCategory() == null) {
            voucherInfo.setCategory(VoucherCategoryEnum.BUDGET);
            throw new VoucherException(VoucherException.CATEGORY_CANNOT_NULL);
        }
        int count = 0;
        for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
            if (!AccountCategoryEnum.BUDGET.equals((Object)voucherInfo.getEntries().get(i).getAccount().getCategory())) continue;
            ++count;
        }
        if (VoucherCategoryEnum.FINANCE.equals((Object)voucherInfo.getCategory())) {
            if (count > 0) {
                throw new VoucherException(VoucherException.FINANCE_MORE_BUDGET);
            }
        } else if (VoucherCategoryEnum.BUDGET.equals((Object)voucherInfo.getCategory())) {
            if (count == 0) {
                throw new VoucherException(VoucherException.BUDGET_LESS_BUDGET);
            }
            if (count != voucherInfo.getEntries().size()) {
                throw new VoucherException(VoucherException.BUDGET_MORE_FINANCE);
            }
        } else if (VoucherCategoryEnum.PARALLEL.equals((Object)voucherInfo.getCategory())) {
            if (count == 0) {
                throw new VoucherException(VoucherException.PARALLEL_LESS_BUDGET);
            }
            if (count == voucherInfo.getEntries().size()) {
                throw new VoucherException(VoucherException.PARALLEL_LESS_FINANCE);
            }
        }
    }

    @Override
    protected Object[] _fetchAssColumn(Context ctx, String accid, String typegoupid, String entryid) throws EASBizException, BOSException {
        return this._fetchAssColumnInfo(ctx, accid, typegoupid, entryid);
    }

    @Override
    protected TemplateVoucherInfo _copyWebTemplateVoucherInfo(Context ctx, TemplateVoucherInfo templateVoucherInfo) throws BOSException, EASBizException {
        return new WebTemplateVoucherCreator().copy(ctx, templateVoucherInfo);
    }

    @Override
    protected TemplateVoucherInfo _createWebTemplateVoucherInfo(Context ctx, String companyId) throws BOSException, EASBizException {
        return new WebTemplateVoucherCreator().create(ctx, companyId);
    }

    @Override
    protected TemplateVoucherInfo _toWebTemplateVoucherInfo(Context ctx, TemplateVoucherInfo templateVoucherInfo) throws BOSException, EASBizException {
        return new WebTemplateVoucherTransfer(ctx, templateVoucherInfo).transfer();
    }

    @Override
    protected VoucherInfo _templateToVoucher(Context ctx, String templateVoucherId) throws BOSException, EASBizException {
        TemplateVoucherInfo templateVoucher = (TemplateVoucherInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(templateVoucherId));
        templateVoucher.put("isWeb", (Object)"isWeb");
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getDefaultSelector());
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("seq"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("voucher.id", (Object)templateVoucher.getId().toString()));
        TemplateCashflowRecordCollection cfCol = null;
        ITemplateCashflowRecord recCtrl = TemplateCashflowRecordFactory.getLocalInstance(ctx);
        cfCol = recCtrl.getTemplateCashflowRecordCollection(view);
        templateVoucher.setCashflowRecords(cfCol);
        CompanyOrgUnitInfo company = templateVoucher.getCompany();
        String companyId = company.getId().toString();
        PeriodInfo period = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(6, companyId);
        UserSettingObject settingObj = UserSettingFactory.getLocalInstance(ctx).getValue(null, "fi.gl.voucher.editSetting");
        Date date = DateTimeUtils.truncateDate((Date)new Date());
        if (settingObj != null && settingObj.getBoolean("sysData") && (period == null || date.after(period.getEndDate()))) {
            PeriodCollection periodColl = PeriodUtils.getPeriodCollection((Context)ctx, (Date)date, (Date)date, (CompanyOrgUnitInfo)company);
            if (!periodColl.isEmpty()) {
                period = periodColl.get(0);
            }
        } else {
            if (period != null) {
                if (date.before(period.getBeginDate())) {
                    date = period.getBeginDate();
                } else if (date.after(period.getEndDate())) {
                    date = period.getEndDate();
                }
            }
            date = DateTimeUtils.truncateDate((Date)date);
        }
        TemplateVoucherEntryCollection availableEntryColl = new TemplateVoucherEntryCollection();
        TemplateVoucherEntryCollection tmpVchEntryColl = templateVoucher.getEntries();
        for (int index = 0; index < tmpVchEntryColl.size(); ++index) {
            TemplateVoucherEntryInfo tempVchEntry = tmpVchEntryColl.get(index);
            if (tempVchEntry.getAccount() != null && tempVchEntry.getAccount().getControl() != null && tempVchEntry.getAccount().getControl().getValue() != 0) continue;
            availableEntryColl.add(tempVchEntry);
        }
        if (availableEntryColl.size() != tmpVchEntryColl.size() && templateVoucher.getCashflowRecords() != null) {
            templateVoucher.setCashflowRecords(null);
            templateVoucher.setCashflowFlag(CashflowFlag.NONE);
        }
        templateVoucher.setEntries(availableEntryColl);
        VoucherInfo voucher = templateVoucher.transfer();
        voucher.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        voucher.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        voucher.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
        voucher.setBizDate(date);
        voucher.setBookedDate(date);
        voucher.setPeriod(period);
        if (voucher.getEntries() != null) {
            for (int i = 0; i < voucher.getEntries().size(); ++i) {
                VoucherEntryInfo entry = voucher.getEntries().get(i);
                this.setExchangeRate(ctx, voucher, entry);
                if (entry.getId() == null) {
                    entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
                }
                entry.put("isTemplate", (Object)true);
                if (entry.getAssistRecords() == null) continue;
                for (int j = 0; j < entry.getAssistRecords().size(); ++j) {
                    VoucherAssistRecordInfo assist = entry.getAssistRecords().get(j);
                    if (assist.getId() != null) continue;
                    assist.setId(BOSUuid.create((BOSObjectType)assist.getBOSType()));
                    assist.setBizDate(date);
                    assist.setEndDate(date);
                }
            }
            this.processForAsstAccountChange(ctx, voucher);
        }
        Map<String, String> param = new HashMap<String, String>();
        param.put("companyId", companyId);
        param.put("userId", ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        param.put("voucherInfo", (String)voucher);
        param.put("voucherid", null);
        IGLGeneralFacade facade = GLGeneralFacadeFactory.getRemoteInstance();
        param = facade.dealTask("checkAccountAndAsst", param);
        voucher = VoucherFacadeFactory.getLocalInstance((Context)ctx).toWebVoucherInfo(voucher);
        VoucherEntryCollection entries = voucher.getEntries();
        HashMap<String, VoucherEntryInfo> enMap = new HashMap<String, VoucherEntryInfo>();
        if (entries != null && entries.size() > 0) {
            int count = entries.size();
            for (int i = 0; i < count; ++i) {
                VoucherEntryInfo info = entries.get(i);
                enMap.put(String.valueOf(info.getSeq()), info);
            }
            voucher.setEntriesMap(enMap);
        }
        if (voucher.getCashflowRecords() != null) {
            Map diff = VoucherProcessCache.getDifference(ctx, companyId);
            HashMap diffMap = new HashMap();
            CashFlowKeepActivityCollection cfkaColl = (CashFlowKeepActivityCollection)diff.get("CashFlowKeepActivityCollection");
            if (cfkaColl != null && !cfkaColl.isEmpty()) {
                ArrayList<String> cfKeepActivities = new ArrayList<String>();
                for (int i = 0; i < cfkaColl.size(); ++i) {
                    cfKeepActivities.add(cfkaColl.get(i).getConCashFlowItem().getId().toString());
                }
                diffMap.put("cashflowKeepActivities", cfKeepActivities);
            }
            CashFlowAccountDiffCollection placColl = (CashFlowAccountDiffCollection)diff.get("CashFlowAccountDiffCollection");
            ArrayList<String> cfAccountDiffs = null;
            if (placColl != null && !placColl.isEmpty()) {
                cfAccountDiffs = new ArrayList<String>();
                for (int i = 0; i < placColl.size(); ++i) {
                    cfAccountDiffs.add(placColl.get(i).getDiffAccount().getId().toString());
                }
                diffMap.put("cashflowAccountDiffs", cfAccountDiffs);
            }
            List cashflowList = this.getCashflowList(voucher, cfAccountDiffs);
            CashflowFlag cashflowFlag = this.computeCashflowFlag(voucher);
            voucher.setCashflowRecords(null);
            voucher.put("cashflow", (Object)cashflowList);
            voucher.put("cashflowFlag", (Object)cashflowFlag);
        }
        this.setNumberAddNew(ctx, voucher);
        return voucher;
    }

    private void doDefaultValue(Context ctx, TemplateVoucherEntryInfo tempVchEntry, String companyId) throws EASBizException, BOSException {
        if (tempVchEntry.getAccount() != null && tempVchEntry.getAccount().getId() != null && tempVchEntry.getAccount().getCAA() != null && tempVchEntry.getAccount().getCAA().getId() != null && tempVchEntry.getAssistRecords() != null) {
            String accountId = tempVchEntry.getAccount().getId().toString();
            String asstAccountId = tempVchEntry.getAccount().getCAA().getId().toString();
            TemplateVoucherAsstRecordCollection tempAsstRecordColl = tempVchEntry.getAssistRecords();
            for (int i = 0; i < tempAsstRecordColl.size(); ++i) {
                AssistantHGInfo defaultHG;
                TemplateVoucherAsstRecordInfo tempAsstRecord = tempAsstRecordColl.get(i);
                if (tempAsstRecord.getAssGrp() != null) continue;
                if (this.accountAsstDefaultValue.containsKey(accountId + "_" + asstAccountId)) {
                    defaultHG = (AssistantHGInfo)this.accountAsstDefaultValue.get(accountId + "_" + asstAccountId);
                    if (defaultHG == null) continue;
                    tempAsstRecord.setAssGrp(defaultHG);
                    continue;
                }
                defaultHG = (AssistantHGInfo)VoucherHelpFacadeFactory.getLocalInstance(ctx).getDefaultAssistantHgInfo((IObjectPK)new ObjectUuidPK(accountId), asstAccountId);
                if (defaultHG == null) {
                    defaultHG = VoucherHelpFacadeControllerBean.getAsstActObject(ctx, companyId, accountId, asstAccountId);
                }
                tempAsstRecord.setAssGrp(defaultHG);
                this.accountAsstDefaultValue.put(accountId + "_" + asstAccountId, defaultHG);
            }
        }
    }

    private List getCashflowList(VoucherInfo voucherInfo, List cfAccountDiffs) throws EASBizException, BOSException {
        ArrayList<HashMap> newCashflows = new ArrayList<HashMap>();
        CashflowRecordCollection cfColl = (CashflowRecordCollection)voucherInfo.getCashflowRecords();
        for (int i = 0; i < cfColl.size(); ++i) {
            HashMap cfMap = new HashMap();
            CashflowRecordInfo cfInfo = cfColl.get(i);
            cfMap.put("itemFlag", cfInfo.getItemFlag().getValue());
            if (cfInfo.getType() != null) {
                cfMap.put("type", CashflowTypeEnum.OUT);
            }
            List<VoucherEntryInfo> entrys = this.getVoucherEntrys(voucherInfo, String.valueOf(cfInfo.getEntry().getSeq()), null);
            for (int j = 0; j < entrys.size(); ++j) {
                VoucherEntryInfo entry = entrys.get(j);
                if (j > 0) {
                    cfMap = (HashMap)cfMap.clone();
                    cfMap.put("originalAmount", GlUtils.zero);
                    cfMap.put("localAmount", GlUtils.zero);
                    cfMap.put("reportingAmount", GlUtils.zero);
                } else {
                    cfMap.put("originalAmount", cfInfo.getOriginalAmount());
                    cfMap.put("localAmount", cfInfo.getLocalAmount());
                    cfMap.put("reportingAmount", cfInfo.getReportingAmount());
                }
                cfMap.put("ownAccount", entry.getSeq());
                if (cfMap.get("itemFlag") != null && new BigDecimal(cfMap.get("itemFlag").toString()).intValue() == 5) {
                    cfMap.put("oppAccount", entry.getSeq());
                } else {
                    String assistRecordId = null;
                    if (cfInfo.getOppVoucherAssistRecord() != null) {
                        assistRecordId = cfInfo.getOppVoucherAssistRecord().getId().toString();
                    }
                    List<VoucherEntryInfo> oppEntrys = this.getVoucherEntrys(voucherInfo, String.valueOf(cfInfo.getOpposingAccountEntry().getSeq()), assistRecordId);
                    cfMap.put("oppAccount", oppEntrys.get(0).getSeq());
                }
                if (cfInfo.getPrimaryItem() != null) {
                    CashFlowItemInfo primaryItem = cfInfo.getPrimaryItem();
                    AssistantHGInfo hgInfo = cfInfo.getAssGrp();
                    if (hgInfo != null) {
                        String displayNameGroup = hgInfo.getDisplayNameGroup();
                        String[] displayNames = displayNameGroup.split(";");
                        StringBuffer displayName = new StringBuffer();
                        for (int n = 0; n < displayNames.length; ++n) {
                            String[] name = displayNames[n].split("_!", 2);
                            if ("".equals(name[1])) continue;
                            if (displayName.length() > 0) {
                                displayName.append("|");
                            }
                            displayName.append(name[1]);
                        }
                        hgInfo.put("displayname", (Object)displayName.toString());
                        primaryItem.put("assgrp", (Object)hgInfo);
                    }
                    cfMap.put("primaryItem", primaryItem);
                }
                if (cfInfo.getSupplementaryItem() != null) {
                    cfMap.put("supplementaryItem", cfInfo.getSupplementaryItem());
                }
                if (cfInfo.getFullInfoItem() != null) {
                    cfMap.put("fullInfoItem", cfInfo.getFullInfoItem());
                }
                newCashflows.add(cfMap);
            }
        }
        return newCashflows;
    }

    private List<VoucherEntryInfo> getVoucherEntrys(VoucherInfo voucherInfo, String entryId, String assistRecordId) {
        ArrayList<VoucherEntryInfo> entries = new ArrayList<VoucherEntryInfo>();
        for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
            VoucherEntryInfo entry = voucherInfo.getEntries().get(i);
            if (!entryId.equals(String.valueOf(entry.get("seq")))) continue;
            if (assistRecordId != null && entry.get("assistrecordid") != null) {
                if (!assistRecordId.equals(entry.get("assistrecordid"))) continue;
                entries.add(entry);
                continue;
            }
            entries.add(entry);
        }
        return entries;
    }

    private CashflowFlag computeCashflowFlag(VoucherInfo voucherInfo) {
        if (SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType())) {
            return CashflowFlag.NONE;
        }
        boolean cashAccExist = false;
        boolean pnlAccExist = false;
        boolean elseAccExist = false;
        VoucherEntryCollection entries = voucherInfo.getEntries();
        int count = entries.size();
        VoucherEntryInfo entry = null;
        for (int i = 0; i < count; ++i) {
            entry = entries.get(i);
            AccountViewInfo acc = entry.getAccount();
            if (acc == null) continue;
            if (acc.isIsCash() || acc.isIsBank() || acc.isIsCashEquivalent()) {
                cashAccExist = true;
                continue;
            }
            if (acc.getAccountTypeID() != null && AccountProperty.SUNYI.equals((Object)acc.getAccountTypeID().getProperty()) && this.isShowSI(voucherInfo, acc.getNumber())) {
                pnlAccExist = true;
                continue;
            }
            elseAccExist = true;
        }
        CashflowFlag flag = null;
        flag = !cashAccExist && pnlAccExist && elseAccExist ? CashflowFlag.ONLY_PNLACCOUNT : (cashAccExist && pnlAccExist && !elseAccExist || cashAccExist && !pnlAccExist && elseAccExist ? CashflowFlag.ONLY_CASHACCOUNT : (!cashAccExist && !pnlAccExist && elseAccExist ? CashflowFlag.BOTHNONE : (cashAccExist && pnlAccExist && elseAccExist ? CashflowFlag.BOTH_CASH_AND_PNL : CashflowFlag.NONE)));
        return flag;
    }

    private boolean isShowSI(VoucherInfo voucherInfo, String accountNumber) {
        CashFlowAccountDiffCollection actCol = voucherInfo.getCashFlowAccountDiffCollection();
        boolean isShowSI = true;
        if (actCol != null) {
            int size = actCol.size();
            for (int i = 0; i < size; ++i) {
                CashFlowAccountDiffInfo actitem = actCol.get(i);
                if (actitem.getDiffAccount() == null || !accountNumber.equals(actitem.getDiffAccount().getNumber())) continue;
                isShowSI = false;
                break;
            }
        }
        return isShowSI;
    }

    private void setNumberAddNew(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            boolean isNumberAddNew = iCodingRuleManager.isAddView((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
            if (isNumberAddNew) {
                String number = iCodingRuleManager.readNumber((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus", "");
                voucherInfo.setNumber(number);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"codingRule error!", (Throwable)ex);
        }
        voucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
    }

    private void setExchangeRate(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo) throws EASBizException, BOSException {
        VoucherAssistRecordCollection assitRecordCollection;
        boolean isSettleByLocal;
        CompanyOrgUnitInfo company = voucherInfo.getCompany();
        boolean isAdjustment = voucherInfo.getSourceType() == SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT;
        ObjectUuidPK baseExchangeTableId = new ObjectUuidPK(isAdjustment && company.getAdjustExchangeTable() != null ? company.getAdjustExchangeTable().getId() : company.getBaseExchangeTable().getId());
        if (entryInfo.getCurrency() == null) {
            entryInfo.setCurrency(company.getBaseCurrency());
        }
        ObjectUuidPK currencyId = new ObjectUuidPK(entryInfo.getCurrency().getId());
        ObjectUuidPK baseCurrencyId = new ObjectUuidPK(company.getBaseCurrency().getId());
        this.cacheExchangeRate(ctx, baseExchangeTableId, currencyId, baseCurrencyId, voucherInfo.getBookedDate(), this.exchangeRateCache);
        String key = baseExchangeTableId + "_" + currencyId + "_" + baseCurrencyId;
        ExchangeRateInfo exRate = null;
        if (this.exchangeRateCache.get(key) != null) {
            exRate = (ExchangeRateInfo)this.exchangeRateCache.get(key);
            entryInfo.setLocalExchangeRate(exRate.getConvertRate());
            if (exRate.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entryInfo.setLocalAmount(entryInfo.getOriginalAmount().multiply(exRate.getConvertRate()));
            } else {
                entryInfo.setLocalAmount(entryInfo.getOriginalAmount().divide(exRate.getConvertRate(), company.getBaseCurrency().getPrecision(), 4));
            }
        }
        ExchangeRateInfo exRptRate = null;
        boolean bl = isSettleByLocal = company.getReportConvertMode() == ReportCurrencyConvertMode.Base;
        if (company.getReportExchangeTable() != null && company.getReportCurrency() != null) {
            ObjectUuidPK rptExchangeTableId = new ObjectUuidPK(company.getReportExchangeTable().getId());
            ObjectUuidPK rptCurrencyId = new ObjectUuidPK(company.getReportCurrency().getId());
            ObjectUuidPK srcCurrencyId = company.getReportConvertMode() == ReportCurrencyConvertMode.Base ? baseCurrencyId : currencyId;
            this.cacheExchangeRate(ctx, rptExchangeTableId, srcCurrencyId, rptCurrencyId, voucherInfo.getBookedDate(), this.exchangeRateCache);
            String rptKey = rptExchangeTableId + "_" + srcCurrencyId + "_" + rptCurrencyId;
            if (this.exchangeRateCache.get(rptKey) != null) {
                exRptRate = (ExchangeRateInfo)this.exchangeRateCache.get(rptKey);
                entryInfo.setReportingExchangeRate(exRptRate.getConvertRate());
                if (isSettleByLocal) {
                    if (exRptRate.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                        entryInfo.setReportingAmount(entryInfo.getLocalAmount().multiply(exRptRate.getConvertRate()));
                    } else {
                        entryInfo.setReportingAmount(entryInfo.getLocalAmount().divide(exRptRate.getConvertRate(), company.getReportCurrency().getPrecision(), 4));
                    }
                } else if (exRptRate.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                    entryInfo.setReportingAmount(entryInfo.getOriginalAmount().multiply(exRptRate.getConvertRate()));
                } else {
                    entryInfo.setReportingAmount(entryInfo.getOriginalAmount().divide(exRptRate.getConvertRate(), company.getReportCurrency().getPrecision(), 4));
                }
            }
        }
        if (entryInfo.getAssistRecords() != null && (assitRecordCollection = entryInfo.getAssistRecords()) != null && assitRecordCollection.size() > 0) {
            for (int i = 0; i < assitRecordCollection.size(); ++i) {
                VoucherAssistRecordInfo tmpAssistRecordInfo = assitRecordCollection.get(i);
                BigDecimal originalAmount = tmpAssistRecordInfo.getOriginalAmount();
                if (originalAmount != null && exRate != null) {
                    if (exRate.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                        tmpAssistRecordInfo.setLocalAmount(originalAmount.multiply(exRate.getConvertRate()));
                    } else {
                        tmpAssistRecordInfo.setLocalAmount(originalAmount.divide(exRate.getConvertRate(), company.getBaseCurrency().getPrecision(), 4));
                    }
                }
                BigDecimal localAmount = tmpAssistRecordInfo.getLocalAmount();
                if (originalAmount == null || localAmount == null || exRptRate == null) continue;
                if (isSettleByLocal) {
                    if (exRptRate.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                        tmpAssistRecordInfo.setReportingAmount(localAmount.multiply(exRptRate.getConvertRate()));
                        continue;
                    }
                    tmpAssistRecordInfo.setReportingAmount(localAmount.divide(exRptRate.getConvertRate(), company.getReportCurrency().getPrecision(), 4));
                    continue;
                }
                if (exRptRate.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                    tmpAssistRecordInfo.setReportingAmount(originalAmount.multiply(exRptRate.getConvertRate()));
                    continue;
                }
                tmpAssistRecordInfo.setReportingAmount(originalAmount.divide(exRptRate.getConvertRate(), company.getReportCurrency().getPrecision(), 4));
            }
        }
    }

    private void cacheExchangeRate(Context ctx, ObjectUuidPK exchangeTableId, ObjectUuidPK srcCurrencyId, ObjectUuidPK targetCurrencyId, Date date, Map exchangeRateCache) throws EASBizException, BOSException {
        String key = exchangeTableId + "_" + srcCurrencyId + "_" + targetCurrencyId;
        if (exchangeRateCache.get(key) == null) {
            ExchangeRateInfo exRate = null;
            if (srcCurrencyId.equals((Object)targetCurrencyId)) {
                exRate = new ExchangeRateInfo();
                exRate.setConvertRate(new BigDecimal("1"));
                ExchangeAuxInfo aux = new ExchangeAuxInfo();
                aux.setExchangeRateType(ExchangeTypeEnum.FIXEXCHANGERATE);
                aux.setPrecision(2);
                exRate.setExchangeAux(aux);
            } else {
                exRate = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateConvertInfo((IObjectPK)exchangeTableId, (IObjectPK)srcCurrencyId, (IObjectPK)targetCurrencyId, date);
            }
            exchangeRateCache.put(key, exRate);
        }
    }

    private void processForAsstAccountChange(Context ctx, VoucherInfo info) throws BOSException, EASBizException {
        HashSet<String> accountIds = new HashSet<String>();
        for (VoucherEntryInfo entry : info.getEntries()) {
            AccountViewInfo account = entry.getAccount();
            if (account == null) continue;
            accountIds.add(account.getId().toString());
        }
        if (accountIds.size() <= 0) {
            return;
        }
        Map caas = AccountFacadeFactory.getLocalInstance((Context)ctx).getCAAsByPeriod(accountIds, info.getPeriod().getId().toString());
        for (VoucherEntryInfo entry : info.getEntries()) {
            AccountViewInfo account = entry.getAccount();
            if (account == null) continue;
            AsstAccountInfo caa = (AsstAccountInfo)caas.get(account.getId().toString());
            entry.setCAA(caa);
            if ((caa == null && !account.isHasUserProperty() || account.getCAA() != null && !caa.getId().equals((Object)account.getCAA().getId())) && entry.getAssistRecords() != null) {
                entry.getAssistRecords().clear();
            }
            account.setCAA(caa);
        }
    }
}

