/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountCategoryEnum;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VoucherEntryAutoBalance {
    List autoLocalEntryList = new ArrayList();
    List autoReportEntryList = new ArrayList();
    private VoucherInfo voucherInfo;
    private GlParam sysParam;
    private CompanyOrgUnitInfo companyOrgUnitInfo;
    private Context ctx;

    public void autoBalanceVoucherEntry() throws BOSException, EASBizException {
        this.initCompanyOrgUnitInfo();
        this.befroeAutoBalance();
        if (this.getAutoBalance()) {
            Map<String, BigDecimal> sums = this.sumDebitCreditAmount();
            this.autoBalanceLoc(AccountCategoryEnum.FINANCE, sums);
            this.autoBalanceLoc(AccountCategoryEnum.BUDGET, sums);
            if (this.companyOrgUnitInfo.getReportCurrency() != null) {
                this.autoBalanceRpt(AccountCategoryEnum.FINANCE, sums);
                this.autoBalanceRpt(AccountCategoryEnum.BUDGET, sums);
            }
        }
    }

    private void befroeAutoBalance() {
        int lcPre = 0;
        int rcurPre = 0;
        lcPre = this.companyOrgUnitInfo.getBaseCurrency().getPrecision();
        rcurPre = this.companyOrgUnitInfo.getReportCurrency() == null ? 4 : this.companyOrgUnitInfo.getReportCurrency().getPrecision();
        VoucherEntryCollection entryCollection = this.voucherInfo.getEntries();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            boolean noNeedAuto;
            VoucherEntryInfo locEntryInfo = entryCollection.get(i);
            if (locEntryInfo.getAssistRecords() == null || locEntryInfo.getAssistRecords().size() == 0) {
                locEntryInfo.setLocalAmount(GlUtils.setScale(locEntryInfo.getLocalAmount() != null ? locEntryInfo.getLocalAmount() : BigDecimal.ZERO, lcPre));
                locEntryInfo.setReportingAmount(GlUtils.setScale(locEntryInfo.getReportingAmount() != null ? locEntryInfo.getReportingAmount() : BigDecimal.ZERO, rcurPre));
                continue;
            }
            boolean bl = noNeedAuto = locEntryInfo.getAccount().getCAA() == null && locEntryInfo.getAccount().isHasUserProperty();
            if (noNeedAuto && SourceType.NONE.equals((Object)this.voucherInfo.getSourceType())) continue;
            VoucherAssistRecordCollection assistRecordCollection = locEntryInfo.getAssistRecords();
            BigDecimal localTotal = new BigDecimal("0.00");
            BigDecimal rptTotal = new BigDecimal("0.00");
            for (int j = 0; j < assistRecordCollection.size(); ++j) {
                VoucherAssistRecordInfo assistRecord;
                assistRecord.setLocalAmount(GlUtils.setScale((assistRecord = assistRecordCollection.get(j)).getLocalAmount() != null ? assistRecord.getLocalAmount() : BigDecimal.ZERO, lcPre));
                assistRecord.setReportingAmount(GlUtils.setScale(assistRecord.getReportingAmount() != null ? assistRecord.getReportingAmount() : BigDecimal.ZERO, rcurPre));
                localTotal = localTotal.add(assistRecord.getLocalAmount());
                rptTotal = rptTotal.add(assistRecord.getReportingAmount());
            }
            locEntryInfo.setLocalAmount(localTotal);
            locEntryInfo.setReportingAmount(rptTotal);
        }
    }

    private void autoBalanceLoc(AccountCategoryEnum accountCategory, Map<String, BigDecimal> sums) throws BOSException, EASBizException {
        BigDecimal localAmountCreditSum;
        BigDecimal localAmountDebitSum;
        boolean canSaveZero = this.getCanSaveAsZero();
        BigDecimal autoBalanceAmountRange = this.getAutoBalanceAmountRange();
        String BalanceEntry = this.getAutoBalanceLine();
        CurrencyInfo localCurrency = this.companyOrgUnitInfo.getBaseCurrency();
        if (accountCategory.equals((Object)AccountCategoryEnum.BUDGET)) {
            localAmountDebitSum = sums.get("budgetLocalDebit");
            localAmountCreditSum = sums.get("budgetLocalCredit");
        } else {
            localAmountDebitSum = sums.get("financeLocalDebit");
            localAmountCreditSum = sums.get("financeLocalCredit");
        }
        BigDecimal result = localAmountDebitSum.subtract(localAmountCreditSum);
        if (result.abs().compareTo(new BigDecimal("0.00")) == 0) {
            return;
        }
        int compareResult = result.abs().compareTo(autoBalanceAmountRange);
        if (compareResult == 1) {
            this.ctx.put((Object)"checkDebitCredit", (Object)"9002");
        }
        if (compareResult <= -1 || compareResult == 0) {
            AccountViewInfo acc;
            BigDecimal locEx;
            int i;
            String locCurrencyID = localCurrency.getId().toString();
            VoucherEntryInfo entryInfo = new VoucherEntryInfo();
            entryInfo.setLocalAmount(new BigDecimal("0.00"));
            VoucherEntryCollection entryCollection = this.voucherInfo.getEntries();
            VoucherEntryInfo locEntryInfo = null;
            if ("4".equals(BalanceEntry)) {
                int size = entryCollection.size();
                for (i = 0; i < size; ++i) {
                    locEntryInfo = entryCollection.get(i);
                    locEx = locEntryInfo.getLocalExchangeRate();
                    if (locEx.compareTo(BigDecimal.ONE) == 0 || (acc = locEntryInfo.getAccount()) == null || (!accountCategory.equals((Object)AccountCategoryEnum.BUDGET) ? acc.isBudget() : !acc.isBudget()) || locEntryInfo.getLocalAmount().abs().compareTo(entryInfo.getLocalAmount().abs()) <= 0 || (1 == locEntryInfo.getEntryDC().getValue() ? this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0 : this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    entryInfo = locEntryInfo;
                }
            } else if ("3".equals(BalanceEntry)) {
                entryInfo.setLocalAmount(new BigDecimal("9999999999.9999"));
                int size = entryCollection.size();
                for (i = 0; i < size; ++i) {
                    locEntryInfo = entryCollection.get(i);
                    locEx = locEntryInfo.getLocalExchangeRate();
                    if (locEx.compareTo(BigDecimal.ONE) == 0 || (acc = locEntryInfo.getAccount()) == null || (!accountCategory.equals((Object)AccountCategoryEnum.BUDGET) ? acc.isBudget() : !acc.isBudget()) || locEntryInfo.getLocalAmount().abs().compareTo(entryInfo.getLocalAmount().abs()) >= 0 || (1 == locEntryInfo.getEntryDC().getValue() ? this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0 : this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    entryInfo = locEntryInfo;
                }
            } else if ("1".equals(BalanceEntry)) {
                int size = entryCollection.size();
                for (i = 0; i < size; ++i) {
                    locEntryInfo = entryCollection.get(i);
                    locEx = locEntryInfo.getLocalExchangeRate();
                    if (locEx.compareTo(BigDecimal.ONE) == 0 || (acc = locEntryInfo.getAccount()) == null || (!accountCategory.equals((Object)AccountCategoryEnum.BUDGET) ? acc.isBudget() : !acc.isBudget())) continue;
                    if (1 == locEntryInfo.getEntryDC().getValue()) {
                        if (this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    } else {
                        if (this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    }
                    break;
                }
            } else if ("2".equals(BalanceEntry)) {
                for (int size = entryCollection.size() - 1; size >= 0; --size) {
                    AccountViewInfo acc2;
                    locEntryInfo = entryCollection.get(size);
                    BigDecimal locEx2 = locEntryInfo.getLocalExchangeRate();
                    if (locEx2.compareTo(BigDecimal.ONE) == 0 || (acc2 = locEntryInfo.getAccount()) == null || (!accountCategory.equals((Object)AccountCategoryEnum.BUDGET) ? acc2.isBudget() : !acc2.isBudget())) continue;
                    if (1 == locEntryInfo.getEntryDC().getValue()) {
                        if (this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    } else {
                        if (this.autoLocalEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    }
                    break;
                }
            }
            String oriCurrencyID = entryInfo.getCurrency().getId().toString();
            VoucherAssistRecordCollection assistRecordCollection = entryInfo.getAssistRecords();
            if (assistRecordCollection == null || assistRecordCollection.size() == 0) {
                if (entryInfo.getAccount() != null) {
                    if (1 == entryInfo.getEntryDC().getValue()) {
                        entryInfo.setLocalAmount(entryInfo.getLocalAmount().subtract(result));
                        entryInfo.setOprStatus(2);
                    } else {
                        entryInfo.setLocalAmount(entryInfo.getLocalAmount().add(result));
                        entryInfo.setOprStatus(2);
                    }
                }
                if (oriCurrencyID.equals(locCurrencyID) && entryInfo.getOriginalAmount().compareTo(BigDecimal.ZERO) != 0) {
                    entryInfo.setOriginalAmount(entryInfo.getLocalAmount());
                }
                return;
            }
            VoucherAssistRecordInfo assistRecord = new VoucherAssistRecordInfo();
            assistRecord.setLocalAmount(new BigDecimal("0.00"));
            VoucherAssistRecordInfo locAssistRecord = null;
            if ("4".equals(BalanceEntry)) {
                int size = assistRecordCollection.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    locAssistRecord = assistRecordCollection.get(i2);
                    if (locAssistRecord.getLocalAmount().abs().compareTo(assistRecord.getLocalAmount().abs()) <= 0 || (1 == entryInfo.getEntryDC().getValue() ? !canSaveZero && locAssistRecord.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0 : !canSaveZero && locAssistRecord.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    assistRecord = locAssistRecord;
                }
            } else if ("3".equals(BalanceEntry)) {
                assistRecord.setLocalAmount(new BigDecimal("9999999999.9999"));
                int size = assistRecordCollection.size();
                for (int i3 = 0; i3 < size; ++i3) {
                    locAssistRecord = assistRecordCollection.get(i3);
                    if (locAssistRecord.getLocalAmount().abs().compareTo(assistRecord.getLocalAmount().abs()) >= 0 || (1 == entryInfo.getEntryDC().getValue() ? !canSaveZero && locAssistRecord.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0 : !canSaveZero && locAssistRecord.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    assistRecord = locAssistRecord;
                }
            } else if ("1".equals(BalanceEntry)) {
                if (canSaveZero) {
                    assistRecord = assistRecordCollection.get(0);
                } else {
                    int size = assistRecordCollection.size();
                    for (int i4 = 0; i4 < size; ++i4) {
                        locAssistRecord = assistRecordCollection.get(i4);
                        if (1 == entryInfo.getEntryDC().getValue()) {
                            if (locAssistRecord.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        } else {
                            if (locAssistRecord.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        }
                        break;
                    }
                }
            } else if ("2".equals(BalanceEntry)) {
                if (canSaveZero) {
                    assistRecord = assistRecordCollection.get(assistRecordCollection.size() - 1);
                } else {
                    for (int size = assistRecordCollection.size() - 1; size >= 0; --size) {
                        locAssistRecord = assistRecordCollection.get(size);
                        if (1 == entryInfo.getEntryDC().getValue()) {
                            if (locAssistRecord.getLocalAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        } else {
                            if (locAssistRecord.getLocalAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        }
                        break;
                    }
                }
            }
            if (1 == entryInfo.getEntryDC().getValue()) {
                assistRecord.setLocalAmount(assistRecord.getLocalAmount().subtract(result));
                assistRecord.setOprStatus(2);
            } else {
                assistRecord.setLocalAmount(assistRecord.getLocalAmount().add(result));
                assistRecord.setOprStatus(2);
            }
            if (oriCurrencyID.equals(locCurrencyID) && assistRecord.getOriginalAmount().compareTo(BigDecimal.ZERO) != 0) {
                assistRecord.setOriginalAmount(assistRecord.getLocalAmount());
            }
            if (!canSaveZero && assistRecord.getBizDate() == null) {
                this.autoLocalEntryList.add(entryInfo);
                this.autoBalanceLoc(accountCategory, sums);
            } else {
                if (1 == entryInfo.getEntryDC().getValue()) {
                    entryInfo.setLocalAmount(entryInfo.getLocalAmount().subtract(result));
                    entryInfo.setOprStatus(2);
                } else {
                    entryInfo.setLocalAmount(entryInfo.getLocalAmount().add(result));
                    entryInfo.setOprStatus(2);
                }
                if (oriCurrencyID.equals(locCurrencyID) && entryInfo.getOriginalAmount().compareTo(BigDecimal.ZERO) != 0) {
                    entryInfo.setOriginalAmount(entryInfo.getLocalAmount());
                }
                this.autoLocalEntryList = new ArrayList();
            }
        }
    }

    private void autoBalanceRpt(AccountCategoryEnum accountCategory, Map<String, BigDecimal> sums) throws BOSException, EASBizException {
        BigDecimal reportingAmountCreditSum;
        BigDecimal reportingAmountDebitSum;
        boolean canSaveZero = this.getCanSaveAsZero();
        BigDecimal autoBalanceAmountRange = this.getAutoBalanceAmountRange();
        String BalanceEntry = this.getAutoBalanceLine();
        CurrencyInfo reportingCurrency = this.companyOrgUnitInfo.getReportCurrency();
        if (accountCategory.equals((Object)AccountCategoryEnum.BUDGET)) {
            reportingAmountDebitSum = sums.get("budgetReportingDebit");
            reportingAmountCreditSum = sums.get("budgetReportingCredit");
        } else {
            reportingAmountDebitSum = sums.get("financeReportingDebit");
            reportingAmountCreditSum = sums.get("financeReportingCredit");
        }
        BigDecimal result = reportingAmountDebitSum.subtract(reportingAmountCreditSum);
        if (result.abs().compareTo(new BigDecimal("0.00")) == 0) {
            return;
        }
        int compareResult = result.abs().compareTo(autoBalanceAmountRange);
        if (compareResult <= -1 || compareResult == 0) {
            VoucherAssistRecordCollection assistRecordCollection;
            AccountViewInfo acc;
            BigDecimal rptEx;
            int i;
            VoucherEntryInfo entryInfo = new VoucherEntryInfo();
            entryInfo.setReportingAmount(new BigDecimal("0.00"));
            VoucherEntryCollection entryCollection = this.voucherInfo.getEntries();
            VoucherEntryInfo locEntryInfo = null;
            if ("4".equals(BalanceEntry)) {
                int size = entryCollection.size();
                for (i = 0; i < size; ++i) {
                    locEntryInfo = entryCollection.get(i);
                    rptEx = locEntryInfo.getReportingExchangeRate();
                    if (rptEx.compareTo(BigDecimal.ONE) == 0 || (acc = locEntryInfo.getAccount()) == null || (!accountCategory.equals((Object)AccountCategoryEnum.BUDGET) ? acc.isBudget() : !acc.isBudget()) || locEntryInfo.getReportingAmount().abs().compareTo(entryInfo.getReportingAmount().abs()) <= 0 || (1 == locEntryInfo.getEntryDC().getValue() ? this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0 : this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    entryInfo = locEntryInfo;
                }
            } else if ("3".equals(BalanceEntry)) {
                entryInfo.setReportingAmount(new BigDecimal("9999999999.9999"));
                int size = entryCollection.size();
                for (i = 0; i < size; ++i) {
                    locEntryInfo = entryCollection.get(i);
                    rptEx = locEntryInfo.getReportingExchangeRate();
                    if (rptEx.compareTo(BigDecimal.ONE) == 0 || (acc = locEntryInfo.getAccount()) == null || (!accountCategory.equals((Object)AccountCategoryEnum.BUDGET) ? acc.isBudget() : !acc.isBudget()) || locEntryInfo.getReportingAmount().abs().compareTo(entryInfo.getReportingAmount().abs()) >= 0 || (1 == locEntryInfo.getEntryDC().getValue() ? this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0 : this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    entryInfo = locEntryInfo;
                }
            } else if ("1".equals(BalanceEntry)) {
                int size = entryCollection.size();
                for (i = 0; i < size; ++i) {
                    locEntryInfo = entryCollection.get(i);
                    rptEx = locEntryInfo.getReportingExchangeRate();
                    if (rptEx.compareTo(BigDecimal.ONE) == 0 || (acc = locEntryInfo.getAccount()) == null || (!accountCategory.equals((Object)AccountCategoryEnum.BUDGET) ? acc.isBudget() : !acc.isBudget())) continue;
                    if (1 == locEntryInfo.getEntryDC().getValue()) {
                        if (this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    } else {
                        if (this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    }
                    break;
                }
            } else if ("2".equals(BalanceEntry)) {
                for (int size = entryCollection.size() - 1; size >= 0; --size) {
                    AccountViewInfo acc2;
                    locEntryInfo = entryCollection.get(size);
                    BigDecimal rptEx2 = locEntryInfo.getReportingExchangeRate();
                    if (rptEx2.compareTo(BigDecimal.ONE) == 0 || (acc2 = locEntryInfo.getAccount()) == null || (!accountCategory.equals((Object)AccountCategoryEnum.BUDGET) ? acc2.isBudget() : !acc2.isBudget())) continue;
                    if (1 == locEntryInfo.getEntryDC().getValue()) {
                        if (this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    } else {
                        if (this.autoReportEntryList.contains(locEntryInfo) || !canSaveZero && locEntryInfo.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                        entryInfo = locEntryInfo;
                    }
                    break;
                }
            }
            if ((assistRecordCollection = entryInfo.getAssistRecords()) == null || assistRecordCollection.size() == 0) {
                if (entryInfo.getAccount() != null) {
                    if (1 == entryInfo.getEntryDC().getValue()) {
                        entryInfo.setReportingAmount(entryInfo.getReportingAmount().subtract(result));
                        entryInfo.setOprStatus(2);
                    } else {
                        entryInfo.setReportingAmount(entryInfo.getReportingAmount().add(result));
                        entryInfo.setOprStatus(2);
                    }
                }
                return;
            }
            VoucherAssistRecordInfo assistRecord = new VoucherAssistRecordInfo();
            assistRecord.setReportingAmount(new BigDecimal("0.00"));
            VoucherAssistRecordInfo locAssistRecord = null;
            if ("4".equals(BalanceEntry)) {
                int size = assistRecordCollection.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    locAssistRecord = assistRecordCollection.get(i2);
                    if (locAssistRecord.getReportingAmount().abs().compareTo(assistRecord.getReportingAmount().abs()) <= 0 || (1 == entryInfo.getEntryDC().getValue() ? !canSaveZero && locAssistRecord.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0 : !canSaveZero && locAssistRecord.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    assistRecord = locAssistRecord;
                }
            } else if ("3".equals(BalanceEntry)) {
                assistRecord.setReportingAmount(new BigDecimal("9999999999.9999"));
                int size = assistRecordCollection.size();
                for (int i3 = 0; i3 < size; ++i3) {
                    locAssistRecord = assistRecordCollection.get(i3);
                    if (locAssistRecord.getReportingAmount().abs().compareTo(assistRecord.getReportingAmount().abs()) >= 0 || (1 == entryInfo.getEntryDC().getValue() ? !canSaveZero && locAssistRecord.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0 : !canSaveZero && locAssistRecord.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0)) continue;
                    assistRecord = locAssistRecord;
                }
            } else if ("1".equals(BalanceEntry)) {
                if (canSaveZero) {
                    assistRecord = assistRecordCollection.get(0);
                } else {
                    int size = assistRecordCollection.size();
                    for (int i4 = 0; i4 < size; ++i4) {
                        locAssistRecord = assistRecordCollection.get(i4);
                        if (1 == entryInfo.getEntryDC().getValue()) {
                            if (locAssistRecord.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        } else {
                            if (locAssistRecord.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        }
                        break;
                    }
                }
            } else if ("2".equals(BalanceEntry)) {
                if (canSaveZero) {
                    assistRecord = assistRecordCollection.get(assistRecordCollection.size() - 1);
                } else {
                    for (int size = assistRecordCollection.size() - 1; size >= 0; --size) {
                        locAssistRecord = assistRecordCollection.get(size);
                        if (1 == entryInfo.getEntryDC().getValue()) {
                            if (locAssistRecord.getReportingAmount().subtract(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        } else {
                            if (locAssistRecord.getReportingAmount().add(result).compareTo(GlUtils.zero) == 0) continue;
                            assistRecord = locAssistRecord;
                        }
                        break;
                    }
                }
            }
            if (1 == entryInfo.getEntryDC().getValue()) {
                assistRecord.setReportingAmount(assistRecord.getReportingAmount().subtract(result));
                assistRecord.setOprStatus(2);
            } else {
                assistRecord.setReportingAmount(assistRecord.getReportingAmount().add(result));
                assistRecord.setOprStatus(2);
            }
            if (!canSaveZero && assistRecord.getBizDate() == null) {
                this.autoReportEntryList.add(entryInfo);
                this.autoBalanceRpt(accountCategory, sums);
            } else {
                if (1 == entryInfo.getEntryDC().getValue()) {
                    entryInfo.setReportingAmount(entryInfo.getReportingAmount().subtract(result));
                    entryInfo.setOprStatus(2);
                } else {
                    entryInfo.setReportingAmount(entryInfo.getReportingAmount().add(result));
                    entryInfo.setOprStatus(2);
                }
                this.autoReportEntryList = new ArrayList();
            }
        }
    }

    private BigDecimal getAutoBalanceAmountRange() throws BOSException, EASBizException {
        return new BigDecimal(this.sysParam.getString("GL_100_1"));
    }

    private String getAutoBalanceLine() throws BOSException, EASBizException {
        return this.sysParam.getString("GL_100_2");
    }

    private boolean getAutoBalance() throws BOSException, EASBizException {
        return this.sysParam.getBoolean("GL_100");
    }

    private boolean getCanSaveAsZero() throws BOSException, EASBizException {
        return this.sysParam.getBoolean("GL_0301");
    }

    private boolean isCurrencyEqual(CurrencyInfo currencyInfo1, CurrencyInfo currencyInfo2) {
        if (currencyInfo1 == null || currencyInfo2 == null) {
            return false;
        }
        return currencyInfo1.getId().equals((Object)currencyInfo2.getId());
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void setVoucherInfo(VoucherInfo voucherInfo) {
        this.voucherInfo = voucherInfo;
    }

    public void setSysParam(GlParam sysParam) {
        this.sysParam = sysParam;
    }

    private void initCompanyOrgUnitInfo() throws BOSException, EASBizException {
        if (this.voucherInfo.getCompany().getBaseCurrency() != null && this.voucherInfo.getCompany().getBaseCurrency().get("precision") != null) {
            this.companyOrgUnitInfo = this.voucherInfo.getCompany();
        } else {
            ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
            ObjectUuidPK pk = new ObjectUuidPK(this.voucherInfo.getCompany().getId().toString());
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.addObjectCollection((IObjectCollection)this.getCompanySic());
            this.companyOrgUnitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
        }
    }

    private void setVoucherEntryPrecision() throws BOSException, EASBizException {
        int lcPre = 0;
        int rcurPre = 0;
        lcPre = this.companyOrgUnitInfo.getBaseCurrency().getPrecision();
        rcurPre = this.companyOrgUnitInfo.getReportCurrency() == null ? 4 : this.companyOrgUnitInfo.getReportCurrency().getPrecision();
        VoucherEntryCollection entryCollection = this.voucherInfo.getEntries();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            VoucherEntryInfo entryInfo;
            entryInfo.setLocalAmount(GlUtils.setScale((entryInfo = entryCollection.get(i)).getLocalAmount() != null ? entryInfo.getLocalAmount() : new BigDecimal("0.00"), lcPre));
            entryInfo.setReportingAmount(GlUtils.setScale(entryInfo.getReportingAmount() != null ? entryInfo.getReportingAmount() : new BigDecimal("0.00"), rcurPre));
        }
    }

    private SelectorItemCollection getCompanySic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("isGrouping"));
        sic.add(new SelectorItemInfo("isGroup"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("isCompanyOrgUnit"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("isAssistantOrg"));
        sic.add(new SelectorItemInfo("mainOrg.id"));
        sic.add(new SelectorItemInfo("mainOrg.name"));
        sic.add(new SelectorItemInfo("mainOrg.number"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.name"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.number"));
        sic.add(new SelectorItemInfo("accountScheme.id"));
        sic.add(new SelectorItemInfo("accountScheme.name"));
        sic.add(new SelectorItemInfo("accountScheme.number"));
        sic.add(new SelectorItemInfo("orgTypeStr"));
        return sic;
    }

    protected Map<String, BigDecimal> sumDebitCreditAmount() {
        HashMap<String, BigDecimal> debitCreditAmountSums = new HashMap<String, BigDecimal>();
        BigDecimal financeLocalDebit = GlUtils.pointzero;
        BigDecimal financeLocalCredit = GlUtils.pointzero;
        BigDecimal financeReportingDebit = GlUtils.pointzero;
        BigDecimal financeReportingCredit = GlUtils.pointzero;
        BigDecimal budgetLocalDebit = GlUtils.pointzero;
        BigDecimal budgetLocalCredit = GlUtils.pointzero;
        BigDecimal budgetReportingDebit = GlUtils.pointzero;
        BigDecimal budgetReportingCredit = GlUtils.pointzero;
        VoucherEntryCollection entries = this.voucherInfo.getEntries();
        VoucherEntryInfo entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            if (entry.getAccount() == null) continue;
            if (entry.getAccount().isBudget()) {
                if (EntryDC.DEBIT.equals((Object)entry.getEntryDC())) {
                    budgetLocalDebit = budgetLocalDebit.add(entry.getLocalAmount());
                    if (entry.getReportingAmount() == null) continue;
                    budgetReportingDebit = budgetReportingDebit.add(entry.getReportingAmount());
                    continue;
                }
                if (!EntryDC.CREDIT.equals((Object)entry.getEntryDC())) continue;
                budgetLocalCredit = budgetLocalCredit.add(entry.getLocalAmount());
                if (entry.getReportingAmount() == null) continue;
                budgetReportingCredit = budgetReportingCredit.add(entry.getReportingAmount());
                continue;
            }
            if (EntryDC.DEBIT.equals((Object)entry.getEntryDC())) {
                financeLocalDebit = financeLocalDebit.add(entry.getLocalAmount());
                if (entry.getReportingAmount() == null) continue;
                financeReportingDebit = financeReportingDebit.add(entry.getReportingAmount());
                continue;
            }
            if (!EntryDC.CREDIT.equals((Object)entry.getEntryDC())) continue;
            financeLocalCredit = financeLocalCredit.add(entry.getLocalAmount());
            if (entry.getReportingAmount() == null) continue;
            financeReportingCredit = financeReportingCredit.add(entry.getReportingAmount());
        }
        debitCreditAmountSums.put("financeLocalDebit", financeLocalDebit);
        debitCreditAmountSums.put("financeLocalCredit", financeLocalCredit);
        debitCreditAmountSums.put("financeReportingDebit", financeReportingDebit);
        debitCreditAmountSums.put("financeReportingCredit", financeReportingCredit);
        debitCreditAmountSums.put("budgetLocalDebit", budgetLocalDebit);
        debitCreditAmountSums.put("budgetLocalCredit", budgetLocalCredit);
        debitCreditAmountSums.put("budgetReportingDebit", budgetReportingDebit);
        debitCreditAmountSums.put("budgetReportingCredit", budgetReportingCredit);
        return debitCreditAmountSums;
    }
}

