/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTypeEnum;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.IVoucherType;
import com.kingdee.eas.basedata.assistant.IVoucherTypeCtrlItem;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherAbstractFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.AssistCustomizedDataTypeEnum;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeInfo;
import com.kingdee.eas.fi.gl.AsstF7ProcessorInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAssistCustomizedProperty;
import com.kingdee.eas.fi.gl.IAssistCustomizedType;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.IVoucherAssistRecord;
import com.kingdee.eas.fi.gl.PeriodTransFacadeFactory;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCreateColWidthFactory;
import com.kingdee.eas.fi.gl.VoucherEditUIInitData;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractVoucherFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.BudgetConstrastProcessor;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.WebVoucherCreator;
import com.kingdee.eas.fi.gl.app.WebVoucherTransfer;
import com.kingdee.eas.fi.gl.app.voucher.VoucherCacheUtil;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.nbudget.face.IBalance;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherFacadeControllerBean
extends AbstractVoucherFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.VoucherFacadeControllerBean");
    private static Map exProcessors;

    @Override
    protected IObjectValue _fetchPeriod(Context ctx, String periodTypeId, Date time) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("periodYear"));
        sic.add(new SelectorItemInfo("periodNumber"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("isAdjustPeriod"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("periodType.id", (Object)periodTypeId));
        fic.add(new FilterItemInfo("beginDate", (Object)time, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("endDate", (Object)time, CompareType.GREATER_EQUALS));
        IPeriod prdCtrl = PeriodFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection objs = prdCtrl.getCollection(view);
        if (objs.size() > 0) {
            return objs.getObject(0);
        }
        return null;
    }

    @Override
    protected VoucherEditUIInitData _fetchInitData(Context ctx, String curComId) throws BOSException, EASBizException {
        VoucherEditUIInitData result = new VoucherEditUIInitData();
        SelectorItemCollection sic1 = GlUtils.getCompanySic();
        sic1.add(new SelectorItemInfo("baseExchangeTable.isMulExchange"));
        sic1.add(new SelectorItemInfo("reportExchangeTable.isMulExchange"));
        CompanyOrgUnitInfo com = GlUtils.getCurrentCompany(ctx, curComId, sic1, true);
        String cuid = com.getCU().getId().toString();
        result.setCompany(com);
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)curComId));
        if (com.getAccountPeriodType() == null) {
            throw new GLException(GLException.NOPERIODTYPE);
        }
        if (com.getAccountTable() == null) {
            throw new GLException(GLException.NO_ACCOUNTTABLE);
        }
        PeriodInfo curPeriod = GlUtils.getCurrentPeriod(ctx, curComId);
        result.setCurrPeriod(curPeriod);
        Date now = new Date();
        Date beginDate = curPeriod.getBeginDate();
        Timestamp endDate = curPeriod.getEndDate();
        if (now.before(beginDate)) {
            now = beginDate;
        } else if (now.after(endDate)) {
            now = endDate;
        }
        now = DateTimeUtils.truncateDate((Date)now);
        result.setCurrDate(now);
        PeriodCollection col = PeriodTransFacadeFactory.getLocalInstance(ctx).fetchPeriod(com.getAccountPeriodType().getId().toString(), now);
        result.setPeriodColl(col);
        FilterInfo filterVT = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "adminCU");
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        String rule = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(cuid), "bd_assistant_voucherType_view");
        if (!StringUtils.isEmpty((String)rule)) {
            String perMissionSql = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(cuid), "bd_assistant_voucherType_view");
            try {
                FilterInfo permissionFilter = new FilterInfo(perMissionSql);
                permissionFilter.getFilterItems().add(new FilterItemInfo("id", (Object)perMissionSql, CompareType.INNER));
                filterVT.mergeFilter(permissionFilter, "AND");
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        result.setVoucherTypeFilter(filterVT);
        VoucherTypeCollection vtCol = GlUtils.getVoucherTypeCollection(ctx, filterVT, cuid);
        String voucherTypeId = null;
        if (vtCol != null && vtCol.size() > 0) {
            VoucherTypeInfo vtDefault = vtCol.get(0);
            for (VoucherTypeInfo vt : vtCol) {
                if (!vt.isPretermit()) continue;
                vtDefault = vt;
            }
            voucherTypeId = vtDefault.getId().toString();
            result.setVoucherTypeDetail(this._fetchVoucherTypeDetail(ctx, voucherTypeId, curComId));
            result.setDefaultVoucherTypeId(voucherTypeId);
        }
        String[] paramList = new String[]{"G001", AccountConstant.GovermentAccountingSystem, "GLG01", "GL_098", "G003", "GL_002", "GL_003", "GL_008", "GL_014", "GL_015", "GL_028", "GL_001", "GL_030", "GL_044_0", "GL_033", "GL_034", "GL_035", "GL_036", "GL_037", "GL_042", "GL_039", "GL_041", "GL_040", "GL_020", "GL_032", "GL_031", "GL_046", "GL_047", "GL_015", "GL_048", "CS001", "GL_052", "GL_029", "G010", "GLG03", "GL_056", "GL_057", "GL_058", "GL_060", "GL_0151", "GL_044", "GL_0301", "GL_0152", "GL_0302", "GL_013", "GL_0521", "GLG01_2", "GL_01301", "GL_067", "GL_064", "GL_072", "GL_075", "GL_076", "GL_099", "GL_073", "GL_100", "GL_100_2", "GL_100_1", "GL_101", "GLG01_1", "GL_077", "GL_VCH_POST_CONTROL", "GL_111", "GL_108", "GL_112", "G012", "GL_044_1", "GL_044_99", "GL_104", "GL_115", "GL_078", "GL_autoSaveCF", "GL_102", "GL_070", "GL_004", "GL_106", "GL_116"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)curComId);
        result.setGlParam(glParam);
        boolean foreignCurrencySU = glParam.getBoolean("GL_008");
        boolean useReportingCurrency = glParam.getBoolean("G001");
        if (!foreignCurrencySU) {
            if (com.getBaseCurrency() == null) {
                throw new GLException(GLException.NOLOCALCUR);
            }
        } else {
            ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyCollection curCol = curCtrl.getCurrencyCollection(true);
            if (curCol.size() == 0) {
                throw new GLException(GLException.NOCURRENCY);
            }
            result.setCurrencyColl(curCol);
        }
        if (useReportingCurrency && com.getReportCurrency() == null) {
            throw new GLException(GLException.NOREPORTINGCUR);
        }
        result.setMasterBook(BooksUtil.isMasterBook((Context)ctx, (String)curComId));
        result.setAssociationCashManagement(VoucherUtil.isAssociationCashManagement(ctx, com));
        result.setVoucherTypeLevel(GLGeneralFacadeFactory.getLocalInstance(ctx).dealTask("FindVoucherTypeLevel", null));
        result.setNumberAddNew(VoucherFacadeControllerBean.isNumberAddNew(ctx, comPK.toString()));
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("user.id", (Object)curUser.getId().toString()));
        view.setFilter(fi);
        result.setTableConfig(VoucherCreateColWidthFactory.getLocalInstance(ctx).getCollection(view));
        result.setCashflowDifference(VoucherProcessCache.getDifference(ctx, curComId));
        result.setVoucherTypeColl(this.getVoucherTypeCollection(ctx, filterVT, curComId));
        result.setVoucherAbstractFilter(VoucherAbstractFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "adminCU.id"));
        return result;
    }

    private VoucherTypeCollection getVoucherTypeCollection(Context ctx, FilterInfo filterVT, String companyId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        EntityViewInfo view = new EntityViewInfo();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("pretermit"));
        sic.add(new SelectorItemInfo("level"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("number"));
        view.setFilter(filterVT);
        IVoucherType vtCtrl = VoucherTypeFactory.getLocalInstance((Context)ctx);
        VoucherTypeCollection vtCol = vtCtrl.getVoucherTypeCollection(view);
        return vtCol;
    }

    public static boolean isNumberAddNew(Context ctx, String comid) {
        Map param = new HashMap<String, String>();
        param.put("comid", comid);
        try {
            IGLGeneralFacade facade = GLGeneralFacadeFactory.getLocalInstance(ctx);
            param = facade.dealTask("getNumberAddNew", param);
            if (param.get("isAddview") != null) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return false;
    }

    @Override
    protected Object[] _fetchInitFilterData(Context ctx, String curComId) throws BOSException, EASBizException {
        Object[] result = new Object[7];
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        CompanyOrgUnitInfo com = this.getCurrentCompany(ctx, curComId, sic, false);
        result[0] = com;
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)curComId));
        PeriodTypeInfo prdType = com.getAccountPeriodType();
        if (prdType == null) {
            throw new GLException(GLException.NOPERIODTYPE);
        }
        result[1] = GlUtils.getAccountPeriodInfo(ctx, curComId, prdType.getId().toString());
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection curCol = curCtrl.getCurrencyCollection(true);
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        result[2] = curCol;
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("G001", null);
        hmParamIn.put("GL_008", comPK);
        boolean isGroup = GlUtils.isGroupControl(ctx, "GLG01");
        if (isGroup) {
            hmParamIn.put("GLG01", null);
        } else {
            hmParamIn.put("GLG01", comPK);
        }
        hmParamIn.put("GL_098", comPK);
        hmParamIn.put("GL_020", comPK);
        hmParamIn.put("GL_032", comPK);
        hmParamIn.put("GL_018", comPK);
        hmParamIn.put("GL_046", comPK);
        hmParamIn.put("GL_047", comPK);
        hmParamIn.put("GL_015", comPK);
        hmParamIn.put("GL_048", comPK);
        hmParamIn.put("CS001", comPK);
        hmParamIn.put("GL_0151", comPK);
        hmParamIn.put("GL_0152", comPK);
        hmParamIn.put("G013", null);
        hmParamIn.put("GL_0302", comPK);
        hmParamIn.put("GLG01_2", comPK);
        hmParamIn.put("GLG01_1", comPK);
        hmParamIn.put("GL_029", comPK);
        hmParamIn.put("GL_013", comPK);
        hmParamIn.put("GL_075", comPK);
        hmParamIn.put("GL_064", null);
        hmParamIn.put("GL_076", comPK);
        hmParamIn.put("GL_099", comPK);
        hmParamIn.put("G003", null);
        hmParamIn.put("GL_104", comPK);
        hmParamIn.put("GL_004", comPK);
        hmParamIn.put("GL_044_99", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Boolean foreignCurrencySU = null;
        try {
            foreignCurrencySU = Boolean.valueOf(hmAllParam.get("GL_008").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_008"});
        }
        result[4] = foreignCurrencySU;
        Boolean useReportingCurrency = null;
        try {
            useReportingCurrency = Boolean.valueOf(hmAllParam.get("G001").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"G001"});
        }
        result[3] = useReportingCurrency;
        if (!foreignCurrencySU.booleanValue() && com.getBaseCurrency() == null) {
            throw new GLException(GLException.NOLOCALCUR);
        }
        if (useReportingCurrency.booleanValue() && com.getReportCurrency() == null) {
            throw new GLException(GLException.NOREPORTINGCUR);
        }
        try {
            result[5] = Boolean.valueOf(hmAllParam.get("GLG01").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GLG01"});
        }
        Object[] otherParam = new Object[25];
        try {
            otherParam[0] = Boolean.valueOf(hmAllParam.get("GL_018").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_018"});
        }
        try {
            otherParam[1] = Boolean.valueOf(hmAllParam.get("GL_032").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_032"});
        }
        try {
            otherParam[2] = Boolean.valueOf(hmAllParam.get("GL_046").toString());
        }
        catch (Exception ex) {
            otherParam[2] = Boolean.FALSE;
        }
        try {
            otherParam[3] = Integer.valueOf(hmAllParam.get("GL_047").toString());
        }
        catch (Exception ex) {
            otherParam[3] = new Integer(0);
        }
        try {
            otherParam[4] = Boolean.valueOf(hmAllParam.get("GL_048").toString());
        }
        catch (Exception ex) {
            otherParam[4] = Boolean.FALSE;
        }
        otherParam[5] = hmAllParam.get("GL_0151") != null ? Boolean.valueOf(hmAllParam.get("GL_0151").toString()) : Boolean.FALSE;
        otherParam[6] = hmAllParam.get("GL_0152") != null ? Integer.valueOf(hmAllParam.get("GL_0152").toString()) : new Integer(1);
        otherParam[7] = hmAllParam.get("G013") != null ? Boolean.valueOf(hmAllParam.get("G013").toString()) : Boolean.FALSE;
        otherParam[8] = hmAllParam.get("GLG01_2") != null ? Integer.valueOf(hmAllParam.get("GLG01_2").toString()) : new Integer(1);
        otherParam[9] = hmAllParam.get("GL_029") != null ? Boolean.valueOf(hmAllParam.get("GL_029").toString()) : Boolean.FALSE;
        result[6] = otherParam;
        otherParam[10] = VoucherUtil.isAssociationCashManagement(ctx, com);
        try {
            otherParam[11] = hmAllParam.get("GL_013") != null ? Integer.valueOf(hmAllParam.get("GL_013").toString()) : new Integer(2);
        }
        catch (Exception ex) {
            otherParam[11] = new Integer(2);
        }
        try {
            otherParam[12] = hmAllParam.get("GL_014") != null ? Boolean.valueOf(Integer.parseInt(hmAllParam.get("GL_014").toString()) == 1) : Boolean.FALSE;
        }
        catch (Exception ex) {
            otherParam[12] = Boolean.FALSE;
        }
        otherParam[13] = hmAllParam.get("GL_0302") != null ? Boolean.valueOf(hmAllParam.get("GL_0302").toString()) : Boolean.FALSE;
        try {
            int bookType = Integer.valueOf(hmAllParam.get("CS001").toString());
            otherParam[16] = bookType == 1;
        }
        catch (Exception ex) {
            otherParam[16] = Boolean.FALSE;
        }
        try {
            otherParam[17] = Integer.valueOf(hmAllParam.get("GL_075").toString());
        }
        catch (Exception ex) {
            otherParam[17] = new Integer("0");
        }
        try {
            otherParam[18] = Boolean.valueOf(hmAllParam.get("GL_076").toString());
        }
        catch (Exception ex) {
            otherParam[18] = Boolean.FALSE;
        }
        try {
            otherParam[19] = Boolean.valueOf(hmAllParam.get("GL_099").toString());
        }
        catch (Exception ex) {
            otherParam[19] = Boolean.FALSE;
        }
        try {
            otherParam[20] = Boolean.valueOf(hmAllParam.get("G003").toString());
        }
        catch (Exception ex) {
            otherParam[20] = Boolean.FALSE;
        }
        otherParam[21] = hmAllParam.get("GL_064") != null ? Boolean.valueOf(hmAllParam.get("GL_064").toString()) : Boolean.FALSE;
        otherParam[22] = hmAllParam.get("GLG01_1") != null ? Boolean.valueOf(hmAllParam.get("GLG01_1").toString()) : Boolean.FALSE;
        otherParam[23] = hmAllParam.get("GL_044_99") != null ? Boolean.valueOf(hmAllParam.get("GL_044_99").toString()) : Boolean.FALSE;
        try {
            otherParam[24] = Boolean.valueOf(hmAllParam.get("GL_104").toString());
        }
        catch (Exception ex) {
            otherParam[24] = Boolean.FALSE;
        }
        return result;
    }

    @Override
    protected Object[] _fetchExchangeRate(Context ctx, Object[] info) throws BOSException, EASBizException {
        int quotePrice;
        BigDecimal rate;
        int pre;
        ConvertModeEnum cm;
        Date availTime;
        ExchangeTypeEnum type;
        String cur;
        String table;
        ExchangeAuxInfo aux;
        Object[] result = new Object[2];
        String localTable = (String)info[0];
        String repTable = (String)info[1];
        String orgCur = (String)info[2];
        String localCur = (String)info[3];
        String repCur = (String)info[4];
        Date now = new Date();
        Date vchBookDate = (Date)info[5];
        boolean isFromVoucher = false;
        if (vchBookDate != null) {
            isFromVoucher = true;
        }
        now = (now = vchBookDate) == null ? new Date() : new Date(now.getTime() + 86400000L - 1000L);
        Date prdBegin = (Date)info[6];
        boolean isExchangeRateMustSameDate = false;
        String curCompanyID = info[7] == null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : (String)info[7];
        HashMap<String, String> hmParamIn = new HashMap<String, String>();
        hmParamIn.put("GL_067", curCompanyID);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        if (hmAllParam.get("GL_067") != null) {
            isExchangeRateMustSameDate = Integer.parseInt(hmAllParam.get("GL_067").toString()) == 1;
        }
        ExchangeTableInfo localTableInfo = null;
        if (localTable != null) {
            localTableInfo = ExchangeTableFactory.getLocalInstance((Context)ctx).getExchangeTableInfo((IObjectPK)new ObjectUuidPK(localTable));
        }
        ExchangeTableInfo repTableInfo = null;
        if (repTable != null) {
            repTableInfo = ExchangeTableFactory.getLocalInstance((Context)ctx).getExchangeTableInfo((IObjectPK)new ObjectUuidPK(repTable));
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("exchangeAux.exchangeTable.id"));
        sic.add(new SelectorItemInfo("exchangeAux.targetCurrency.id"));
        sic.add(new SelectorItemInfo("exchangeAux.convertMode"));
        sic.add(new SelectorItemInfo("exchangeAux.exchangeRateType"));
        sic.add(new SelectorItemInfo("exchangeAux.precision"));
        sic.add(new SelectorItemInfo("convertRate"));
        sic.add(new SelectorItemInfo("availTime"));
        sic.add(new SelectorItemInfo("invalidTime"));
        sic.add(new SelectorItemInfo("quoteprice"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)localTable));
        fic.add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)repTable));
        fic.add(new FilterItemInfo("exchangeAux.sourceCurrency.id", (Object)orgCur));
        fic.add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)localCur));
        fic.add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)repCur));
        fic.add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)orgCur));
        fic.add(new FilterItemInfo("exchangeAux.sourceCurrency.id", (Object)localCur));
        fic.add(new FilterItemInfo("exchangeAux.sourceCurrency.id", (Object)repCur));
        fic.add(new FilterItemInfo("isUsedBG", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("exchangeAux.exchangeTable.isMulExchange", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("exchangeAux.exchangeTable.isMulExchange", (Object)new Integer(1), CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("quoteprice", (Object)new Integer(1)));
        if (isExchangeRateMustSameDate && isFromVoucher) {
            if (vchBookDate != null) {
                now = new Date(now.getTime() - 86399000L);
            }
            fic.add(new FilterItemInfo("availTime", (Object)now, CompareType.EQUALS));
        } else {
            fic.add(new FilterItemInfo("availTime", (Object)now, CompareType.LESS_EQUALS));
        }
        filter.setMaskString("(#0 OR #1) AND ((#2 AND (#3 OR #4)) or (#5 AND (#6 OR #7))) AND #8 AND (#9 OR (#10 AND #11)) AND #12 )");
        IExchangeRate exCtrl = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateCollection exCol = exCtrl.getExchangeRateCollection(view);
        VoucherInfo.ExchangeRateWithValue lex = null;
        VoucherInfo.ExchangeRateWithValue rex = null;
        Iterator itrEx = exCol.iterator();
        Date maxTimelocal0 = null;
        Date maxTimelocal1 = null;
        Date maxTimerep0 = null;
        Date maxTimerep1 = null;
        int preQuotePrice = -1;
        while (itrEx.hasNext()) {
            ExchangeRateInfo ex = (ExchangeRateInfo)itrEx.next();
            aux = ex.getExchangeAux();
            table = aux.getExchangeTable().getId().toString();
            cur = aux.getTargetCurrency().getId().toString();
            type = aux.getExchangeRateType();
            availTime = ex.getAvailTime();
            cm = aux.getConvertMode();
            pre = aux.getPrecision();
            rate = ex.getConvertRate();
            quotePrice = ex.getQuoteprice().getValue();
            if (localTable != null && localTable.equals(table) && localCur.equals(cur)) {
                if (ExchangeTypeEnum.FLOATEXCHANGERATE.equals((Object)type) && now.compareTo(availTime) >= 0 && (maxTimelocal0 == null || maxTimelocal0.compareTo(availTime) <= 0)) {
                    if (maxTimelocal0 != null && maxTimelocal0.compareTo(availTime) == 0) {
                        if (1 != quotePrice && (3 != preQuotePrice || 2 != quotePrice)) continue;
                        lex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
                        lex.setPresion(pre);
                        maxTimelocal0 = availTime;
                        preQuotePrice = quotePrice;
                        continue;
                    }
                    lex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
                    lex.setPresion(pre);
                    maxTimelocal0 = availTime;
                    preQuotePrice = quotePrice;
                } else if (ExchangeTypeEnum.FIXEXCHANGERATE.equals((Object)type) && now.compareTo(availTime) >= 0 && (maxTimelocal1 == null || maxTimelocal1.compareTo(availTime) <= 0)) {
                    lex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
                    lex.setPresion(pre);
                    maxTimelocal1 = availTime;
                }
            }
            if (repTable == null || !repTable.equals(table) || !repCur.equals(cur)) continue;
            if (ExchangeTypeEnum.FLOATEXCHANGERATE.equals((Object)type) && now.compareTo(availTime) >= 0 && (maxTimerep0 == null || maxTimerep0.compareTo(availTime) <= 0)) {
                if (maxTimerep0 != null && maxTimerep0.compareTo(availTime) == 0) {
                    if (1 != quotePrice && (3 != preQuotePrice || 2 != quotePrice)) continue;
                    rex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
                    rex.setPresion(pre);
                    maxTimerep0 = availTime;
                    preQuotePrice = quotePrice;
                    continue;
                }
                rex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
                rex.setPresion(pre);
                maxTimerep0 = availTime;
                preQuotePrice = quotePrice;
                continue;
            }
            if (!ExchangeTypeEnum.FIXEXCHANGERATE.equals((Object)type) || now.compareTo(availTime) < 0 || maxTimerep1 != null && maxTimerep1.compareTo(availTime) > 0) continue;
            rex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
            rex.setPresion(pre);
            maxTimerep1 = availTime;
        }
        if (lex == null && localTableInfo != null && localTableInfo.isIsReversible()) {
            maxTimelocal0 = null;
            maxTimelocal1 = null;
            for (ExchangeRateInfo ex : exCol) {
                aux = ex.getExchangeAux();
                table = aux.getExchangeTable().getId().toString();
                cur = aux.getSourceCurrency().getId().toString();
                type = aux.getExchangeRateType();
                availTime = ex.getAvailTime();
                cm = aux.getConvertMode();
                pre = aux.getPrecision();
                rate = ex.getConvertRate();
                quotePrice = ex.getQuoteprice().getValue();
                if (localTable == null || !localTable.equals(table) || !localCur.equals(cur)) continue;
                if (ExchangeTypeEnum.FLOATEXCHANGERATE.equals((Object)type) && now.compareTo(availTime) >= 0 && (maxTimelocal0 == null || maxTimelocal0.compareTo(availTime) <= 0)) {
                    if (maxTimelocal0 != null && maxTimelocal0.compareTo(availTime) == 0) {
                        if (1 != quotePrice && (3 != preQuotePrice || 2 != quotePrice)) continue;
                        lex = new VoucherInfo.ExchangeRateWithValue(type, cm, GlUtils.one.divide(rate, pre, 4));
                        lex.setPresion(pre);
                        maxTimelocal0 = availTime;
                        preQuotePrice = quotePrice;
                        continue;
                    }
                    lex = new VoucherInfo.ExchangeRateWithValue(type, cm, GlUtils.one.divide(rate, pre, 4));
                    lex.setPresion(pre);
                    maxTimelocal0 = availTime;
                    preQuotePrice = quotePrice;
                    continue;
                }
                if (!ExchangeTypeEnum.FIXEXCHANGERATE.equals((Object)type) || now.compareTo(availTime) < 0 || maxTimelocal1 != null && maxTimelocal1.compareTo(availTime) > 0) continue;
                lex = new VoucherInfo.ExchangeRateWithValue(type, cm, GlUtils.one.divide(rate, pre, 4));
                lex.setPresion(pre);
                maxTimelocal1 = availTime;
            }
        }
        if (rex == null && repTableInfo != null && repTableInfo.isIsReversible()) {
            maxTimerep0 = null;
            maxTimerep1 = null;
            for (ExchangeRateInfo ex : exCol) {
                aux = ex.getExchangeAux();
                table = aux.getExchangeTable().getId().toString();
                cur = aux.getSourceCurrency().getId().toString();
                type = aux.getExchangeRateType();
                availTime = ex.getAvailTime();
                cm = aux.getConvertMode();
                pre = aux.getPrecision();
                rate = ex.getConvertRate();
                quotePrice = ex.getQuoteprice().getValue();
                if (repTable == null || !repTable.equals(table) || !repCur.equals(cur)) continue;
                if (ExchangeTypeEnum.FLOATEXCHANGERATE.equals((Object)type) && now.compareTo(availTime) >= 0 && (maxTimerep0 == null || maxTimerep0.compareTo(availTime) <= 0)) {
                    if (maxTimerep0 != null && maxTimerep0.compareTo(availTime) == 0) {
                        if (1 != quotePrice && (3 != preQuotePrice || 2 != quotePrice)) continue;
                        rex = new VoucherInfo.ExchangeRateWithValue(type, cm, GlUtils.one.divide(rate, pre, 4));
                        rex.setPresion(pre);
                        maxTimerep0 = availTime;
                        preQuotePrice = quotePrice;
                        continue;
                    }
                    rex = new VoucherInfo.ExchangeRateWithValue(type, cm, GlUtils.one.divide(rate, pre, 4));
                    rex.setPresion(pre);
                    maxTimerep0 = availTime;
                    preQuotePrice = quotePrice;
                    continue;
                }
                if (!ExchangeTypeEnum.FIXEXCHANGERATE.equals((Object)type) || now.compareTo(availTime) < 0 || maxTimerep1 != null && maxTimerep1.compareTo(availTime) > 0) continue;
                rex = new VoucherInfo.ExchangeRateWithValue(type, cm, GlUtils.one.divide(rate, pre, 4));
                rex.setPresion(pre);
                maxTimerep1 = availTime;
            }
        }
        result[0] = lex;
        result[1] = rex;
        return result;
    }

    @Override
    protected Object[] _fetchVoucherTypeDetail(Context ctx, String voucherTypeId, String comid) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("voucherType.id", (Object)voucherTypeId));
        fic.add(new FilterItemInfo("company.id", (Object)comid));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("type"));
        sorters.add(new SorterItemInfo("account.longNumber"));
        SelectorItemCollection sicItem = view.getSelector();
        sicItem.add(new SelectorItemInfo("type"));
        sicItem.add(new SelectorItemInfo("level"));
        sicItem.add(new SelectorItemInfo("account.number"));
        sicItem.add(new SelectorItemInfo("account.longNumber"));
        IVoucherTypeCtrlItem ciCtrl = VoucherTypeCtrlItemFactory.getLocalInstance((Context)ctx);
        VoucherTypeCtrlItemCollection ciCol = ciCtrl.getVoucherTypeCtrlItemCollection(view);
        return VoucherUtil.reorganizeCtrlItems(ciCol);
    }

    @Override
    protected IObjectValue _confirmAssGrp(Context ctx, AssistantHGInfo assGrp, String typeGroupId, VoucherInfo.DynamicColumnInfo[] colInfo) throws BOSException, EASBizException {
        AsstActTypeCollection types = new AsstActTypeCollection();
        for (int i = 0; i < colInfo.length; ++i) {
            AsstActTypeInfo t = new AsstActTypeInfo();
            types.add(t);
            t.setAsstHGAttribute(colInfo[i].getMappingPropName());
            t.setName(colInfo[i].getColName());
            t.setRealtionDataObject(colInfo[i].getRealtionDataObject());
            t.setMappingFieldName(colInfo[i].getMappingFieldName());
            HashMap hmMultiLangColName = colInfo[i].getHmMultiLangColName();
            for (Map.Entry e : hmMultiLangColName.entrySet()) {
                Object name = e.getValue();
                t.setName(name == null ? null : name.toString(), (Locale)e.getKey());
            }
        }
        IAssistantHG igCtrl = AssistantHGFactory.getLocalInstance((Context)ctx);
        return igCtrl.getAssistantHG(assGrp, typeGroupId, types);
    }

    @Override
    protected Object[] _fetchAssColumnInfo(Context ctx, String accId, String typeGroupId, String entryId) throws BOSException, EASBizException {
        Object[] result;
        VoucherInfo.DynamicColumnInfo[] itemCols = null;
        Locale[] locales = null;
        if (typeGroupId != null) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("asstActType.id"));
            sic.add(new SelectorItemInfo("asstActType.name"));
            sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
            sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
            sic.add(new SelectorItemInfo("asstActType.number"));
            sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
            sic.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
            sic.add(new SelectorItemInfo("asstActType.defaultQueryName"));
            sic.add(new SelectorItemInfo("asstActType.defaultF7UI"));
            sic.add(new SelectorItemInfo("asstActType.isForCompany"));
            sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
            sic.add(new SelectorItemInfo("asstActType.groupTableName"));
            sic.add(new SelectorItemInfo("asstActType.useLongNumber"));
            sic.add(new SelectorItemInfo("asstActType.isQty"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("asstAccount.id", (Object)typeGroupId));
            SorterItemCollection sort = new SorterItemCollection();
            sort.add(new SorterItemInfo("seq"));
            sort.add(new SorterItemInfo("asstActType.number"));
            view.getSorter().addObjectCollection((IObjectCollection)sort);
            IAsstActGroupDetail relCtrl = AsstActGroupDetailFactory.getLocalInstance((Context)ctx);
            AsstActGroupDetailCollection rels = relCtrl.getAsstActGroupDetailCollection(view);
            if (locales == null) {
                locales = this.getAllLocales(ctx);
            }
            itemCols = new VoucherInfo.DynamicColumnInfo[rels.size()];
            int count = 0;
            for (AsstActGroupDetailInfo r : rels) {
                AsstActTypeInfo t = r.getAsstActType();
                HashMap<Locale, String> hmMultiLangColName = new HashMap<Locale, String>();
                for (int i = 0; i < locales.length; ++i) {
                    hmMultiLangColName.put(locales[i], t.getName(locales[i]));
                }
                VoucherInfo.DynamicColumnInfo col = new VoucherInfo.DynamicColumnInfo(t.getName(), t.getAsstHGAttribute(), t.getDefaultQueryName(), t.getDefaultF7UI(), t.isIsForCompany(), hmMultiLangColName, t.getId());
                col.setGrp(t.getGlAsstActTypeGrp());
                col.setMappingFieldName(t.getMappingFieldName());
                col.setRealtionDataObject(t.getRealtionDataObject());
                col.setMultilevel(t.isIsMultilevel());
                col.setGroupTableName(t.getGroupTableName());
                col.setUseLongNumber(t.isUseLongNumber());
                col.setQty(t.isIsQty());
                itemCols[count++] = col;
            }
        } else {
            itemCols = new VoucherInfo.DynamicColumnInfo[]{};
        }
        VoucherInfo.DynamicColumnInfo[] cpCols = null;
        if (accId != null) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("isNecessary"));
            sic.add(new SelectorItemInfo("isCreditNecessary"));
            sic.add(new SelectorItemInfo("isDebitNecessary"));
            sic.add(new SelectorItemInfo("customizedType.id"));
            sic.add(new SelectorItemInfo("customizedType.name"));
            sic.add(new SelectorItemInfo("customizedType.mappingPropName"));
            sic.add(new SelectorItemInfo("customizedType.dataType"));
            sic.add(new SelectorItemInfo("customizedType.defaultQueryName"));
            sic.add(new SelectorItemInfo("customizedType.defaultF7UI"));
            sic.add(new SelectorItemInfo("customizedType.precision"));
            sic.add(new SelectorItemInfo("customizedType.isForCompany"));
            SorterItemCollection sorters = view.getSorter();
            sorters.add(new SorterItemInfo("seq"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("account.id", (Object)accId));
            fic.add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
            IAssistCustomizedProperty cpCtrl = AssistCustomizedPropertyFactory.getLocalInstance(ctx);
            AssistCustomizedPropertyCollection props = cpCtrl.getAssistCustomizedPropertyCollection(view);
            if (locales == null) {
                locales = this.getAllLocales(ctx);
            }
            cpCols = new VoucherInfo.DynamicColumnInfo[props.size()];
            int count = 0;
            Iterator itr = props.iterator();
            while (itr.hasNext()) {
                AssistCustomizedPropertyInfo prop = (AssistCustomizedPropertyInfo)itr.next();
                AssistCustomizedTypeInfo t = prop.getCustomizedType();
                HashMap<Locale, String> hmMultiLangColName = new HashMap<Locale, String>();
                for (int i = 0; i < locales.length; ++i) {
                    hmMultiLangColName.put(locales[i], t.getName(locales[i]));
                }
                VoucherInfo.DynamicColumnInfo col = new VoucherInfo.DynamicColumnInfo(prop.isIsNecessary(), t.getName(), t.getDataType(), t.getMappingPropName(), t.getDefaultQueryName(), t.getDefaultF7UI(), t.getPrecision(), t.isIsForCompany(), hmMultiLangColName);
                col.setCreditNecessary(prop.isIsCreditNecessary());
                col.setDebitNecessary(prop.isIsDebitNecessary());
                col.setId(t.getId());
                cpCols[count++] = col;
            }
        } else {
            cpCols = new VoucherInfo.DynamicColumnInfo[]{};
        }
        result = new Object[]{itemCols, cpCols, entryId != null ? this._fetchAssData(ctx, entryId, result) : null};
        return result;
    }

    protected Locale[] getAllLocales(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        LanguageCollection langs = loader.getSolution().getLanguages();
        Locale[] locales = new Locale[langs.size()];
        int count = 0;
        for (LanguageInfo lang : langs) {
            locales[count++] = lang.getLocale();
        }
        return locales;
    }

    @Override
    protected IObjectCollection _fetchAssData(Context ctx, String entryId, Object[] info) throws BOSException, EASBizException {
        String propName;
        VoucherInfo.DynamicColumnInfo colInfo;
        int i;
        VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
        VoucherInfo.DynamicColumnInfo[] propCols = (VoucherInfo.DynamicColumnInfo[])info[1];
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("seq"));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("verifiedCussent.id"));
        for (i = 0; i < propCols.length; ++i) {
            colInfo = propCols[i];
            propName = colInfo.getMappingPropName();
            if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)colInfo.getDataType())) {
                sic.add(new SelectorItemInfo(propName + ".number"));
                sic.add(new SelectorItemInfo(propName + ".name"));
                continue;
            }
            sic.add(new SelectorItemInfo(propName));
        }
        for (i = 0; i < assItemCols.length; ++i) {
            colInfo = assItemCols[i];
            propName = colInfo.getMappingPropName();
            sic.add(new SelectorItemInfo("assGrp." + propName + ".number"));
            sic.add(new SelectorItemInfo("assGrp." + propName + ".name"));
        }
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("entry.id", (Object)entryId));
        IVoucherAssistRecord recCtrl = VoucherAssistRecordFactory.getLocalInstance(ctx);
        VoucherAssistRecordCollection records = recCtrl.getVoucherAssistRecordCollection(view);
        return records;
    }

    @Override
    protected Map _fetchBotpControlAsstribute(Context ctx, String id) throws BOSException {
        String sql = "select fid,flocalamount,Foriginalamount,Freportingamount ,faccountid,fentrydc,FcurrencyId from t_gl_voucherentry where fbillid=? and fisHand=0 ";
        HashMap assMap = new HashMap();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
        try {
            HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> oamountMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> ramountMap = new HashMap<String, BigDecimal>();
            HashMap<String, Integer> entrydcMap = new HashMap<String, Integer>();
            HashMap<String, String> accountMap = new HashMap<String, String>();
            HashMap<String, String> currencyMap = new HashMap<String, String>();
            while (rs != null && rs.next()) {
                String entryid = rs.getString("fid");
                BigDecimal amount = rs.getBigDecimal("flocalamount");
                BigDecimal oamount = rs.getBigDecimal("Foriginalamount");
                BigDecimal ramount = rs.getBigDecimal("Freportingamount");
                int entrydc = rs.getInt("fentrydc");
                String account = rs.getString("faccountid");
                String currency = rs.getString("FcurrencyId");
                entrydcMap.put(entryid, new Integer(entrydc));
                amountMap.put(entryid, amount);
                oamountMap.put(entryid, oamount);
                ramountMap.put(entryid, ramount);
                accountMap.put(entryid, account);
                currencyMap.put(entryid, currency);
            }
            assMap.put("amount", amountMap);
            assMap.put("oamount", oamountMap);
            assMap.put("ramount", ramountMap);
            assMap.put("account", accountMap);
            assMap.put("entrydc", entrydcMap);
            assMap.put("currency", currencyMap);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return assMap;
    }

    @Override
    protected IObjectValue _generateAdjustVoucher(Context ctx, String vchId, Object[] genParam) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("mappingPropName"));
        sic.add(new SelectorItemInfo("dataType"));
        IAssistCustomizedType typeCtrl = AssistCustomizedTypeFactory.getLocalInstance(ctx);
        AssistCustomizedTypeCollection typeCol = typeCtrl.getAssistCustomizedTypeCollection(view);
        sic = VoucherInfo.getDefaultSelector();
        Iterator itrType = typeCol.iterator();
        while (itrType.hasNext()) {
            AssistCustomizedTypeInfo type = (AssistCustomizedTypeInfo)itrType.next();
            String propName = "entries.assistRecords." + type.getMappingPropName();
            if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)type.getDataType())) {
                propName = propName + ".id";
            }
            sic.add(new SelectorItemInfo(propName));
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)vchId));
        VoucherInfo srcVch = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)pk, sic);
        UserInfo user = (UserInfo)genParam[0];
        Date time = (Date)genParam[1];
        time = new Date(time.getYear(), time.getMonth(), time.getDate());
        PeriodInfo prd = (PeriodInfo)genParam[2];
        Date date = srcVch.getBookedDate();
        String strDate = 1900 + date.getYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
        String Year = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"Year", (Locale)ctx.getLocale());
        String Month = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"Month", (Locale)ctx.getLocale());
        String Day = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"Day", (Locale)ctx.getLocale());
        String Adjust = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"Adjust", (Locale)ctx.getLocale());
        String Number2 = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"Number", (Locale)ctx.getLocale());
        String strEntryDesc = Adjust + (1900 + date.getYear()) + Year + (date.getMonth() + 1) + Month + date.getDate() + Day + srcVch.getVoucherType().getName() + srcVch.getNumber() + Number2;
        String desc = MessageFormat.format(new VoucherException(VoucherException.ADJUSTVOUCHER).getMessage(), strDate, srcVch.getVoucherType().getName(), srcVch.getNumber());
        srcVch.setSourceBillId(srcVch.getId().toString());
        srcVch.setId(null);
        srcVch.setIsReverseVoucher(false);
        srcVch.setHasReversed(false);
        srcVch.setNumber(null);
        srcVch.setCreator(user);
        srcVch.setHandler(user);
        srcVch.setIsCheck(false);
        srcVch.setCashier(null);
        srcVch.setAuditor(null);
        srcVch.setPoster(null);
        srcVch.setCanceller(null);
        srcVch.setBizDate(time);
        srcVch.setBookedDate(time);
        srcVch.setPeriod(prd);
        srcVch.setSourceSys(SystemEnum.GENERALLEDGER);
        srcVch.setSourceType(SourceType.ADJUST);
        srcVch.setDescription(desc);
        srcVch.setAttachments(0);
        srcVch.put("bizStatus", null);
        srcVch.put("bgStatus", null);
        srcVch.put("hasCashAccount", null);
        srcVch.setCashflowRecords(null);
        for (VoucherEntryInfo entry : srcVch.getEntries()) {
            entry.setId(null);
            entry.setDescription(strEntryDesc + (entry.getDescription() != null ? entry.getDescription() : ""));
            entry.setOprStatus(1);
            entry.setIsCheck(false);
            VoucherAssistRecordCollection recCol = entry.getAssistRecords();
            if (recCol == null) continue;
            for (VoucherAssistRecordInfo rec : recCol) {
                rec.setId(null);
                rec.setDescription(strEntryDesc + (rec.getDescription() != null ? rec.getDescription() : ""));
                rec.setOprStatus(1);
            }
        }
        return srcVch;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Map _checkBudget(Context ctx, IObjectValue voucherInfo) throws BOSException, EASBizException {
        vch = (VoucherInfo)voucherInfo;
        caller = new BgControlCaller();
        if (vch.getCompany() == null || vch.getCompany().getId() == null) {
            throw new VoucherException(VoucherException.COMPANY_NULL);
        }
        fields = null;
        if (null == vch.getBOSUuid("id")) {
            try {
                if (vch.getPeriod() == null || vch.getPeriod().getId() == null) {
                    throw new VoucherException(VoucherException.PERIOD_CANNOT_NULL);
                }
                sql = "select top 1 fid from t_gl_voucher where fcompanyid = ? and fperiodid = ?";
                rst = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{vch.getCompany().getId().toString(), vch.getPeriod().getId().toString()});
                if (!rst.next()) ** GOTO lbl19
                vid = rst.getString("fid");
                fields = caller.getRequestFields(ctx, BOSUuid.read((String)vid));
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            fields = caller.getRequestFields(ctx, vch.getBOSUuid("id"));
        }
lbl19:
        // 3 sources

        if (fields == null || fields.size() <= 0) {
            result = new HashMap<String, Object>();
            result.put("isBudgetPass", Boolean.TRUE);
            result.put("message", null);
            return result;
        }
        if (vch.getId() != null || vch.get("isCopyNew") != null) {
            this.lazyLoadHGFieldData(ctx, vch, fields);
        }
        result = new HashMap<K, V>();
        try {
            caller.checkBudget(ctx, (IObjectValue)vch);
            result.put("isBudgetPass", Boolean.TRUE);
            result.put("message", null);
        }
        catch (Exception e) {
            result.put("isBudgetPass", Boolean.FALSE);
            result.put("message", e.getMessage());
        }
        if (result.get("isBudgetPass") != null && result.get("isBudgetPass") instanceof Boolean && (isBudgetPass = ((Boolean)result.get("isBudgetPass")).booleanValue()) && result.get("message") == null) {
            budgetBalance = caller.queryBalance(ctx, (IObjectValue)vch);
            for (i = 0; i < budgetBalance.getBalance().size(); ++i) {
                balance = (IBalance)budgetBalance.getBalance().get(i);
                if (!balance.isOverBudget()) continue;
                hint = "\u9884\u7b97\u53ef\u6263\u51cf\u6210\u529f\uff0c\u4f46\u5df2\u8d85\u51fa\u9884\u7b97\uff0c\u53ef\u7528\u9884\u7b97\u4f59\u989d\u4e3a:" + balance.getBalance() + "\n\u8be6\u60c5\u8bf7\u67e5\u770b\u9884\u7b97\u4f59\u989d\u3002";
                result.put("message", hint);
                break;
            }
        }
        return result;
    }

    private boolean lazyLoadHGFieldData(Context ctx, VoucherInfo vch, List fields) throws BOSException {
        AssistantHGCollection hgs;
        FilterItemCollection newFic;
        FilterInfo newFilter;
        SelectorItemCollection sic = new SelectorItemCollection();
        String fieldName = null;
        String key = ".assgrp.";
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            fieldName = fields.get(i).toString().toLowerCase();
            int idx = fieldName.indexOf(key);
            if (idx <= 0) continue;
            fieldName = fieldName.substring(idx + key.length());
            sic.add(new SelectorItemInfo(fieldName));
        }
        if (sic.size() <= 0) {
            return false;
        }
        EntityViewInfo v = new EntityViewInfo();
        v.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo propertiesFilter = new FilterInfo();
        FilterItemCollection fic = propertiesFilter.getFilterItems();
        StringBuffer maskString = new StringBuffer();
        int idx = 0;
        int size2 = sic.size();
        for (int i = 0; i < size2; ++i) {
            fic.add(new FilterItemInfo(sic.get(i).getPropertyName(), null, CompareType.NOTEQUALS));
            if (maskString.length() == 0) {
                maskString.append("#").append(idx++);
                continue;
            }
            maskString.append(" or #").append(idx++);
        }
        propertiesFilter.setMaskString(maskString.toString());
        HashSet<String> ids = new HashSet<String>();
        VoucherEntryCollection entries = vch.getEntries();
        VoucherEntryInfo entry = null;
        VoucherAssistRecordCollection assists = null;
        VoucherAssistRecordInfo assist = null;
        int size3 = entries.size();
        for (int i = 0; i < size3; ++i) {
            entry = entries.get(i);
            assists = entry.getAssistRecords();
            int asstSize = assists.size();
            for (int j = 0; j < asstSize; ++j) {
                assist = assists.get(j);
                if (assist.getAssGrp() == null || assist.getAssGrp().getId() == null) continue;
                ids.add(assist.getAssGrp().getId().toString());
            }
        }
        AssistantHGCollection assistanthg = new AssistantHGCollection();
        IAssistantHG hgCtrl = AssistantHGFactory.getLocalInstance((Context)ctx);
        HashSet tempIDs = new HashSet();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            tempIDs.add(it.next());
            if (tempIDs.size() % 200 != 0) continue;
            newFilter = new FilterInfo();
            newFic = newFilter.getFilterItems();
            newFic.add(new FilterItemInfo("id", tempIDs, CompareType.INCLUDE));
            newFilter.mergeFilter(propertiesFilter, "and");
            v.setFilter(newFilter);
            hgs = hgCtrl.getAssistantHGCollection(v);
            if (hgs != null && hgs.size() > 0) {
                assistanthg.addCollection(hgs);
            }
            tempIDs.clear();
        }
        if (tempIDs.size() > 0) {
            newFilter = new FilterInfo();
            newFic = newFilter.getFilterItems();
            newFic.add(new FilterItemInfo("id", tempIDs, CompareType.INCLUDE));
            newFilter.mergeFilter(propertiesFilter, "and");
            v.setFilter(newFilter);
            hgs = hgCtrl.getAssistantHGCollection(v);
            if (hgs != null && hgs.size() > 0) {
                assistanthg.addCollection(hgs);
            }
            tempIDs.clear();
        }
        if (assistanthg.size() <= 0) {
            return false;
        }
        AssistantHGInfo hg = null;
        int size4 = entries.size();
        for (int i = 0; i < size4; ++i) {
            entry = entries.get(i);
            assists = entry.getAssistRecords();
            int asstSize = assists.size();
            for (int j = 0; j < asstSize; ++j) {
                assist = assists.get(j);
                if (assist.getAssGrp() == null || assist.getAssGrp().getId() == null || (hg = assistanthg.get((Object)assist.getAssGrp().getId())) == null) continue;
                assist.setAssGrp(hg);
            }
        }
        return true;
    }

    @Override
    protected void _logVoucherNumber(Context ctx, VoucherInfo voucherInfo, String voucherNumber, String action, Exception except) throws BOSException, EASBizException {
        String voucherId = null;
        String periodId = null;
        String companyId = null;
        String voucherTypeId = null;
        if (voucherInfo.getId() != null) {
            voucherId = voucherInfo.getId().toString();
        }
        if (voucherInfo.getPeriod() != null && voucherInfo.getPeriod().getId() != null) {
            periodId = voucherInfo.getPeriod().getId().toString();
        }
        if (voucherInfo.getCompany() != null && voucherInfo.getCompany().getId() != null) {
            companyId = voucherInfo.getCompany().getId().toString();
        }
        if (voucherInfo.getVoucherType() != null && voucherInfo.getVoucherType().getId() != null) {
            voucherTypeId = voucherInfo.getVoucherType().getId().toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_gl_vouchernumberlog(fvoucherid,fcompanyid,fperiodid,fvouchertypeid,faction,fnumber,fbizstatus,ftime,ferrmsg,fisupdating) values (");
        sql.append("?,?,?,?,'").append(action).append("',?,?, getDate(),?,?)");
        Object[] params = new Object[8];
        params[0] = voucherId;
        params[1] = companyId;
        params[2] = periodId;
        params[3] = voucherTypeId;
        params[4] = voucherNumber;
        params[5] = new Integer(voucherInfo.getBizStatus() == null ? -1 : voucherInfo.getBizStatus().getValue());
        String errMsg = null;
        if (except != null && (errMsg = except.getMessage()) != null && errMsg.length() > 2000) {
            errMsg = errMsg.substring(0, 2000);
        }
        params[6] = errMsg;
        params[7] = (Integer)params[5] == 1 ? Integer.valueOf(0) : Integer.valueOf(1);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    public CompanyOrgUnitInfo getCurrentCompany(Context ctx, String comId, SelectorItemCollection sic, boolean mustBeEntity) throws BOSException, EASBizException {
        if (sic == null) {
            sic = GlUtils.getCompanySic();
        }
        ICompanyOrgUnit comCtrl = null;
        comCtrl = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo com = null;
        ObjectUuidPK comPK = null;
        try {
            comPK = new ObjectUuidPK(BOSUuid.read((String)comId));
            com = (CompanyOrgUnitInfo)comCtrl.getValue((IObjectPK)comPK, sic);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOCOMPANY, ex);
        }
        return com;
    }

    @Override
    protected List _queryAsstAct(Context ctx, Set companys) throws BOSException, EASBizException {
        return GlUtils.queryAsstAct(ctx, companys);
    }

    public RptRowSet executeQuery(String sql, SqlParams parameters, int from, int length, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            RptRowSet rptRowSet = DBUtil.executeQuery((String)sql, (SqlParams)parameters, (int)from, (int)length, (Connection)con);
            return rptRowSet;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected Map _getPeriodRange(Context ctx, IObjectCollection compnays, IObjectValue periodType) throws BOSException, EASBizException {
        HashSet<String> companyIdSet = new HashSet<String>();
        for (int i = 0; i < compnays.size(); ++i) {
            companyIdSet.add(((CompanyOrgUnitInfo)compnays.getObject(i)).getId().toString());
        }
        String periodTypeId = periodType == null ? null : ((PeriodTypeInfo)periodType).getId().toString();
        return GlUtils.getPeriodRange(ctx, companyIdSet, periodTypeId);
    }

    @Override
    protected ArrayList _fetchAllCompanyParams(Context ctx, List paramArray, List orgIdArray) throws BOSException, EASBizException {
        return ParamControlFactory.getLocalInstance((Context)ctx).getParamListPatch((ArrayList)paramArray, (ArrayList)orgIdArray);
    }

    @Override
    protected Map _getAsstF7Processors(Context ctx) throws BOSException {
        if (exProcessors != null) {
            return exProcessors;
        }
        exProcessors = new HashMap();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select * from t_gl_asstf7processor");
        try {
            while (rs.next()) {
                AsstF7ProcessorInfo info = new AsstF7ProcessorInfo();
                info.setName(rs.getString("fname"));
                info.setProcessor(rs.getString("fprocessor"));
                String listener = rs.getString("fdatachangelistener");
                if (listener != null) {
                    String[] listeners = listener.split(",");
                    for (int i = 0; i < listeners.length; ++i) {
                        if (listeners[i] == null || listeners[i].trim().length() <= 0) continue;
                        info.addListenerName(listeners[i].trim());
                    }
                }
                exProcessors.put(info.getName(), info);
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql error!", (Throwable)e);
        }
        return exProcessors;
    }

    @Override
    protected Map _getVoucherCountByPeriod(Context ctx, String companyId, int startPeriodNum, int endPeriodNum, int voucherstatus, String creatorid) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("select count(1) count,p.fperiodnumber periodnumber,p.fnumber number  ");
        StringBuffer where = new StringBuffer();
        StringBuffer from = new StringBuffer(" from t_gl_voucher v ");
        from.append(" inner join t_bd_period p on v.fperiodid = p.fid ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (companyId != null && !"".equals(companyId)) {
            where.append(" where v.fcompanyid = ?");
            paramList.add(companyId);
        }
        if (VoucherStatusEnum.getEnum((int)voucherstatus) != null) {
            if (paramList.size() > 0) {
                where.append(" and ");
            } else {
                where.append(" where ");
            }
            where.append("  FBIZSTATUS = ?");
            paramList.add(voucherstatus);
        }
        if (creatorid != null && !"".equals(creatorid)) {
            if (paramList.size() > 0) {
                where.append(" and v.FCREATORID = ?");
            } else {
                where.append(" where v.FCREATORID = ?");
            }
            paramList.add(creatorid);
        }
        if (paramList.size() > 0) {
            where.append(" and ");
        } else {
            where.append(" where ");
        }
        where.append(" p.FNumber >= ?");
        paramList.add(startPeriodNum);
        if (paramList.size() > 0) {
            where.append(" and ");
        } else {
            where.append(" where ");
        }
        where.append(" p.FNumber <= ?");
        paramList.add(endPeriodNum);
        StringBuffer groupBy = new StringBuffer();
        groupBy.append(" group by p.fid,p.fnumber,p.fperiodnumber");
        sql = sql.append(from).append(where).append(groupBy);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        HashMap resultMap = new HashMap();
        try {
            while (rs.next()) {
                HashMap<String, Integer> periodMap = new HashMap<String, Integer>();
                periodMap.put("periodNum", rs.getInt("periodnumber"));
                periodMap.put("count", rs.getInt("count"));
                resultMap.put(rs.getInt("number"), periodMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer periodSql = new StringBuffer("select fnumber,fperiodnumber from t_bd_period where ftypeid = ? and FNumber >= ? and FNumber <= ?");
        where = new StringBuffer();
        paramList = new ArrayList();
        CompanyOrgUnitInfo company = GlUtils.getCompanyById(ctx, companyId);
        paramList.add(company.getAccountPeriodType().getId().toString());
        paramList.add(startPeriodNum);
        paramList.add(endPeriodNum);
        rs = DbUtil.executeQuery((Context)ctx, (String)periodSql.toString(), (Object[])paramList.toArray());
        try {
            while (rs.next()) {
                int periodNum = rs.getInt("fnumber");
                if (resultMap.containsKey(periodNum)) continue;
                HashMap<String, Integer> periodMap = new HashMap<String, Integer>();
                periodMap.put("periodNum", rs.getInt("fperiodnumber"));
                periodMap.put("count", 0);
                resultMap.put(periodNum, periodMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    @Override
    protected Map _getVoucherEntryCountByPeriod(Context ctx, String companyId, int startPeriodNum, int endPeriodNum, int voucherstatus, String creatorid) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("select count(1) count ,p.fperiodnumber periodnumber,p.fnumber number ");
        StringBuffer where = new StringBuffer();
        StringBuffer from = new StringBuffer(" from t_gl_voucherentry ve ");
        from.append(" inner join t_gl_voucher v on ve.fbillid = v.fid ");
        from.append(" inner join t_bd_period p on v.fperiodid = p.fid ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (companyId != null && !"".equals(companyId)) {
            where.append(" where v.fcompanyid = ?");
            paramList.add(companyId);
        }
        if (creatorid != null && !"".equals(creatorid)) {
            if (paramList.size() > 0) {
                where.append(" and v.FCREATORID = ?");
            } else {
                where.append(" where v.FCREATORID = ?");
            }
            paramList.add(creatorid);
        }
        if (paramList.size() > 0) {
            where.append(" and ");
        } else {
            where.append(" where ");
        }
        where.append(" p.FNumber >= ?");
        paramList.add(startPeriodNum);
        if (paramList.size() > 0) {
            where.append(" and ");
        } else {
            where.append(" where ");
        }
        where.append(" p.FNumber <= ?");
        paramList.add(endPeriodNum);
        StringBuffer groupBy = new StringBuffer();
        groupBy.append(" group by p.fid,p.fnumber,p.fperiodnumber");
        sql = sql.append(from).append(where).append(groupBy);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        HashMap resultMap = new HashMap();
        try {
            while (rs.next()) {
                HashMap<String, Integer> periodMap = new HashMap<String, Integer>();
                periodMap.put("periodNum", rs.getInt("periodnumber"));
                periodMap.put("count", rs.getInt("count"));
                resultMap.put(rs.getInt("number"), periodMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer periodSql = new StringBuffer("select fnumber,fperiodnumber from t_bd_period where ftypeid = ? and FNumber >= ? and FNumber <= ?");
        where = new StringBuffer();
        paramList = new ArrayList();
        CompanyOrgUnitInfo company = GlUtils.getCompanyById(ctx, companyId);
        paramList.add(company.getAccountPeriodType().getId().toString());
        paramList.add(startPeriodNum);
        paramList.add(endPeriodNum);
        rs = DbUtil.executeQuery((Context)ctx, (String)periodSql.toString(), (Object[])paramList.toArray());
        try {
            while (rs.next()) {
                int periodNum = rs.getInt("fnumber");
                if (resultMap.containsKey(periodNum)) continue;
                HashMap<String, Integer> periodMap = new HashMap<String, Integer>();
                periodMap.put("periodNum", rs.getInt("fperiodnumber"));
                periodMap.put("count", 0);
                resultMap.put(periodNum, periodMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Map _getVoucherCountMap(Context ctx, String companyId, String periodId) throws BOSException, EASBizException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        boolean isHasPer = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(companyId), "gl_voucher01_view");
        HashMap<String, String> result = new HashMap<String, String>();
        if (isHasPer) {
            try {
                String sql = "select count(1) count from t_gl_voucher where fcompanyid = ? and fperiodid = ? and fbizstatus = ?";
                Object[] param = new Object[]{companyId, periodId, 0};
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                if (rs.next()) {
                    String tempCount = rs.getString("count");
                    result.put("savenumber", tempCount);
                }
                param[2] = 1;
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                if (rs.next()) {
                    String submitCount = rs.getString("count");
                    result.put("submitnumber", submitCount);
                }
                param[2] = 3;
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                if (!rs.next()) return result;
                String auditCount = rs.getString("count");
                result.put("auditnumber", auditCount);
                return result;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            result.put("savenumber", "0");
            result.put("submitnumber", "0");
            result.put("auditnumber", "0");
        }
        return result;
    }

    @Override
    protected VoucherInfo _createWebVoucherInfo(Context ctx, String companyId) throws BOSException, EASBizException {
        return new WebVoucherCreator().create(ctx, companyId);
    }

    @Override
    protected VoucherInfo _toWebVoucherInfo(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        return new WebVoucherTransfer(ctx, voucherInfo).transfer();
    }

    @Override
    protected VoucherInfo _copyWebVoucherInfo(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        return new WebVoucherCreator().copy(ctx, voucherInfo);
    }

    @Override
    protected Map _getBudgetBalance(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        HashMap<String, List> result = new HashMap<String, List>();
        if (billInfo == null) {
            return result;
        }
        List list = GlUtils.getBalance(ctx, billInfo);
        result.put("BGBALANCE", list);
        return result;
    }

    @Override
    protected Map _budgetConstrast(Context ctx, VoucherInfo voucher, Map params) throws BOSException, EASBizException {
        List<VoucherEntryInfo> entries;
        String tableId;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String companyId = voucher.getCompany().getId().toString();
        String constrastId = BudgetConstrastProcessor.getAccountRefConstrastId(ctx, companyId, tableId = voucher.getCompany().getAccountTable().getId().toString());
        if (constrastId == null) {
            result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"bugt_tip2", (Locale)ctx.getLocale()));
            return result;
        }
        BudgetConstrastProcessor processor = new BudgetConstrastProcessor();
        try {
            entries = processor.process(ctx, voucher, constrastId, params);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        result.put("entries", entries);
        return result;
    }

    @Override
    protected boolean _isContainBankAccount(Context ctx, String vchId) throws BOSException {
        return this.getBankAccountVchIDs(ctx, Arrays.asList(vchId)).size() > 0;
    }

    @Override
    protected String _checkCFRequisition(Context ctx, String vchId) throws BOSException, EASBizException {
        String msg = null;
        if (StringUtils.isEmpty((String)vchId)) {
            return msg;
        }
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select a.fname_l1 as accountName, f.FNAME_l2 as primaryName, cu.FNAME_l2 as currencyName, org.FNAME_l2 as orgName,ca.FORIGINALAMOUNT as oriAmount from t_gl_cfrequisition cf \r\n");
        sbSql.append("left join t_gl_cashflowrecord ca on cf.fcfrecordid = ca.fid \r\n");
        sbSql.append("inner join t_bd_accountview a on ca.faccountid = a.fid \r\n");
        sbSql.append("inner join t_bd_cashflowitem f on ca.fprimaryitemid = f.fid \r\n");
        sbSql.append("inner join t_bd_currency cu on ca.fcurrencyid = cu.fid \r\n");
        sbSql.append("inner join t_org_baseunit org on cf.FCORRELATIONORGID = org.fid \r\n");
        sbSql.append("where ca.fvoucherid = ? and cf.fstatus = '2'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])new Object[]{vchId});
        try {
            if (rs.next()) {
                String accountName = rs.getString("accountName");
                String primaryName = rs.getString("primaryName");
                String currencyName = rs.getString("currencyName");
                String orgName = rs.getString("orgName");
                String oriAmount = rs.getString("oriAmount");
                msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"CHECKREQUISITION", (Locale)ctx.getLocale()), accountName, primaryName, oriAmount, currencyName, orgName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return msg;
    }

    protected List getBankAccountVchIDs(Context ctx, List vchIDs) throws BOSException {
        if (vchIDs != null && vchIDs.size() > 0) {
            String filterSql_s = "select distinct fbillid from t_gl_voucherentry e ";
            String filterSql_i = "inner join t_bd_accountview a on e.faccountid = a.fid ";
            StringBuilder filterSql_w = new StringBuilder("where a.fisbank = 1 ");
            ArrayList params = new ArrayList();
            if (vchIDs.size() == 1) {
                filterSql_w.append(" and e.fbillid = ? ");
                params.add(vchIDs.get(0));
            } else if (vchIDs.size() > 500) {
                String temp = this.dealByTempTable(ctx, vchIDs);
                filterSql_i = filterSql_i + "inner join " + temp + " t on e.fbillid = t.fid ";
            } else {
                filterSql_w.append(" and e.fbillid in(");
                for (int i = 0; i < vchIDs.size(); ++i) {
                    filterSql_w.append("?,");
                    params.add(vchIDs.get(i));
                }
                filterSql_w.deleteCharAt(filterSql_w.length() - 1);
                filterSql_w.append(")");
            }
            String filterSql = filterSql_s + filterSql_i + filterSql_w;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)filterSql, (Object[])params.toArray());
            ArrayList<String> ids = new ArrayList<String>();
            try {
                while (rs.next()) {
                    ids.add(rs.getString("fbillid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            return ids;
        }
        return new ArrayList();
    }

    private String dealByTempTable(Context ctx, List<String> vchIDs) throws BOSException {
        String temp;
        Connection con = null;
        PreparedStatement ps = null;
        try {
            temp = TempTablePool.getInstance((Context)ctx).createTempTable("create table T_TMP_VoucherIDs (fid VARCHAR(44)) ");
            con = this.getConnection(ctx);
            ps = con.prepareStatement("insert into " + temp + " values(?)");
            int c = 0;
            for (int i = 0; i < vchIDs.size(); ++i) {
                ps.setString(1, vchIDs.get(i));
                ps.addBatch();
                ++c;
                if (i % 500 != 0) continue;
                ps.executeBatch();
                c = 0;
            }
            if (c > 0) {
                ps.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        return temp;
    }

    @Override
    protected Map _flushVoucherFastFailCache(Context ctx, Map cacheMap) throws BOSException, EASBizException {
        if (cacheMap != null) {
            VoucherCacheUtil.putCache("GL.voucherProcess", "voucherFastFail", cacheMap);
        }
        return (Map)VoucherCacheUtil.getVoucherFastFailCache();
    }
}

