/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.BOTReverseManager;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleEntryCollection;
import com.kingdee.eas.base.codingrule.CodingRuleEntryFactory;
import com.kingdee.eas.base.codingrule.CodingRuleEntryInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.DirectionType;
import com.kingdee.eas.base.codingrule.ICodingRuleEntry;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AccountBalanceFactory;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedDataTypeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.IVoucherAssistRecord;
import com.kingdee.eas.fi.gl.IVoucherEntry;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractVoucherHelpFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.common.VoucherBalance;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherHelpFacadeControllerBean
extends AbstractVoucherHelpFacadeControllerBean {
    private static final long serialVersionUID = 6922609392557430143L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.VoucherHelpFacadeControllerBean");
    final int BATCHSIZE = 200;
    private boolean ischeckVoucherExistWorkFlow = false;

    public static void botpRewriteStaticDelete(final Context ctx, final VoucherCollection voucherCol) {
        Thread voucherReverseSaveThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                    int count = voucherCol.size();
                    for (int i = 0; i < count; ++i) {
                        VoucherInfo voucherInfo = voucherCol.get(i);
                        BOTRelationCollection botRelationCol = iBTPManager.getRelationCollection(voucherInfo.getId().toString());
                        BOTReverseManager botReverseManager = new BOTReverseManager(ctx);
                        botReverseManager.setOprtState(BOTBillOperStateEnum.DELETE);
                        VoucherCollection vcll = new VoucherCollection();
                        vcll.add(voucherInfo);
                        boolean hasReversed = false;
                        int total = botRelationCol.size();
                        for (int j = 0; j < total; ++j) {
                            try {
                                BOTRelationInfo botRelationInfo = botRelationCol.get(j);
                                String bosObjType = BOSUuid.getBOSObjectType((String)botRelationInfo.getSrcObjectID(), (boolean)true).toString();
                                if ("7EB1A733".equals(bosObjType)) continue;
                                hasReversed = botRelationInfo.isIsEffected();
                                BOTRelationCollection reBotRelaColl = new BOTRelationCollection();
                                reBotRelaColl.add(botRelationInfo);
                                botReverseManager.reverseWriteBatch((IObjectCollection)reBotRelaColl, (IObjectCollection)vcll, hasReversed);
                                continue;
                            }
                            catch (Exception e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Error while rewriting Botp!", (Throwable)ex);
                }
            }
        });
        voucherReverseSaveThread.start();
    }

    public static void botpRewriteStatic(Context ctx, VoucherCollection voucherCol) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        int count = voucherCol.size();
        for (int i = 0; i < count; ++i) {
            VoucherInfo voucherInfo = voucherCol.get(i);
            BOTRelationCollection botRelationCol = iBTPManager.getRelationCollection(voucherInfo.getId().toString());
            BOTReverseManager botReverseManager = new BOTReverseManager(ctx);
            botReverseManager.setOprtState(BOTBillOperStateEnum.EDIT);
            VoucherCollection vcll = new VoucherCollection();
            vcll.add(voucherInfo);
            BOTRelationCollection reversedColl = new BOTRelationCollection();
            BOTRelationCollection notReversedColl = new BOTRelationCollection();
            int total = botRelationCol.size();
            for (int j = 0; j < total; ++j) {
                if (botRelationCol.get(j).isIsEffected()) {
                    reversedColl.add(botRelationCol.get(j));
                    continue;
                }
                notReversedColl.add(botRelationCol.get(j));
            }
            if (reversedColl.size() > 0) {
                botReverseManager.reverseWriteBatch((IObjectCollection)reversedColl, (IObjectCollection)vcll, true);
            }
            if (notReversedColl.size() <= 0) continue;
            botReverseManager.reverseWriteBatch((IObjectCollection)notReversedColl, (IObjectCollection)vcll, false);
        }
    }

    @Override
    protected boolean _updateNumber(Context ctx, Map numberMap) throws BOSException, EASBizException {
        return this.updateNumber(ctx, numberMap, 0);
    }

    private boolean updateNumber(Context ctx, Map numberMap, int sourceType) throws BOSException, EASBizException {
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = null;
        try {
            if (numberMap.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            VoucherCollection voucherCol = this.getVoucherCollection(ctx, numberMap);
            if (this.checkHasBillImageMapByVoucherCol(ctx, voucherCol).booleanValue()) {
                throw new VoucherException(VoucherException.CAN_NOT_ADJUST_NUMBER);
            }
            this.checkAllVoucherIsExistWorkFlow(ctx, voucherCol);
            VoucherInfo vch = voucherCol.get(0);
            String companyId = vch.getCompany().getId().toString();
            if (1 == sourceType) {
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                String cuid = company.getCU().getId().toString();
                String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                mp = GLMutexUtils.buildModifyBalanceParameter(ctx, companyId, userId, "GL_ReSortNumber");
                boolean isLockSucceed = mutex.requestMutex(mp);
                if (!isLockSucceed) {
                    String exStr = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLMutexResource", (String)"GL_ReSortNumber_Desc", (Locale)ctx.getLocale());
                    throw new VoucherException(VoucherException.PERIOD_ERROR_WITH_GL074, new Object[]{exStr});
                }
            }
            this.updateVoucherNumber(ctx, numberMap, voucherCol, sourceType);
            boolean isHand = GlUtils.getVoucherHandParam(ctx, companyId);
            if (!isHand) {
                this.recycleVoucherNumber(ctx, numberMap, voucherCol);
            }
            voucherCol = this.getVoucherCollection(ctx, numberMap);
            this.botpRewrite(ctx, voucherCol);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != mutex && null != mp) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
        return true;
    }

    private String getLogMethod(Context ctx, int sourceType) {
        String resPath = "com.kingdee.eas.fi.gl.GLResource";
        switch (sourceType) {
            case 0: {
                return ResourceBase.getString((String)resPath, (String)"logMethod_ResortNumber", (Locale)ctx.getLocale());
            }
            case 1: {
                return ResourceBase.getString((String)resPath, (String)"logMethod_AdjustNumberBatch", (Locale)ctx.getLocale());
            }
        }
        return null;
    }

    protected ICodingRuleManager getCodingRuleCtrl(Context ctx) throws BOSException {
        return CodingRuleManagerFactory.getLocalInstance((Context)ctx);
    }

    protected void recycleVoucherId(Context ctx, VoucherInfo voucherInfo, String voucherId) throws BOSException, EASBizException {
        this.getCodingRuleCtrl(ctx).recycleNumber((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus", "", voucherId);
    }

    @Override
    protected IObjectCollection _loadData(Context ctx, String voucherTypeId, String periodId, String companyId) throws BOSException, EASBizException {
        boolean hasZf = VoucherUtil.hasCancelCodingRule(ctx, companyId);
        SelectorItemCollection sic = new SelectorItemCollection();
        this.setSelector(sic);
        return this.loadData(ctx, voucherTypeId, periodId, companyId, hasZf, null, sic);
    }

    private VoucherCollection loadData(Context ctx, String voucherTypeId, String periodId, String companyId, boolean hasZf, SorterItemCollection s, SelectorItemCollection sic) throws BOSException, EASBizException {
        String comid = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodId));
        if (null != voucherTypeId) {
            filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)voucherTypeId));
        }
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
        boolean isControl = GlParam.getGlParams((Context)ctx, (String)"GL_VCH_POST_CONTROL", (String)companyId).getBoolean("GL_VCH_POST_CONTROL");
        if (isControl) {
            filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5), CompareType.NOTEQUALS));
        }
        evi.setFilter(filter);
        SorterItemCollection sorters = evi.getSorter();
        if (s == null) {
            sorters.add(new SorterItemInfo("number"));
        } else {
            sorters.addObjectCollection((IObjectCollection)s.getSorter());
        }
        return VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(evi);
    }

    protected SelectorItemCollection setSelector(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("voucherAbstract"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("bookedDate"));
        sic.add(new SelectorItemInfo("bizDate"));
        return sic;
    }

    protected String[] _getBatchNumber(Context ctx, IObjectValue caller, IObjectValue codingruleVo, String customStr, int count, int initial) throws BOSException, CodingRuleException, EASBizException {
        int j;
        if (!(codingruleVo instanceof CodingRuleInfo)) {
            throw new CodingRuleException(CodingRuleException.ERROR_PARAM_TYPE);
        }
        CodingRuleInfo codingruleVO = (CodingRuleInfo)codingruleVo;
        if (caller == null) {
            throw new CodingRuleException(CodingRuleException.ERROR_PARAM_NULL);
        }
        IMetaDataLoader metaLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = metaLoader.getEntity(caller.getBOSType());
        if (!codingruleVO.getBusinessObject().trim().equals(eo.getPackage() + "." + eo.getName())) {
            throw new CodingRuleException(CodingRuleException.ERROR_ENTITY_TYPE);
        }
        StringBuffer sortValue = new StringBuffer();
        logger.debug((Object)"_getNumber begin....");
        ICodingRuleEntry iCodingRuleEntry = CodingRuleEntryFactory.getLocalInstance((Context)ctx);
        StringBuffer[] sbCodeRule = new StringBuffer[count];
        for (int i = 0; i < sbCodeRule.length; ++i) {
            sbCodeRule[i] = new StringBuffer();
        }
        logger.debug((Object)("_getNumber begin....CRE has " + codingruleVO.getCodingRuleEntrys().size()));
        this.sortCollection(codingruleVO.getCodingRuleEntrys());
        this.getSNCREIndex(codingruleVO);
        for (int i = 0; i < codingruleVO.getCodingRuleEntrys().size(); ++i) {
            logger.debug((Object)"");
            logger.debug((Object)("_getNumber begin....for::: " + i));
            CodingRuleEntryInfo creVO = codingruleVO.getCodingRuleEntrys().get(i);
            if (!creVO.isIsDisplay() && !creVO.isIsSplitSign()) continue;
            if (codingruleVO.getSplitSign() != null && codingruleVO.getSplitSign().trim().length() > 0 && creVO.getSerialNumber() != 1 && creVO.isIsSplitSign() && sbCodeRule[0].length() > 0) {
                for (j = 0; j < sbCodeRule.length; ++j) {
                    sbCodeRule[j].append(codingruleVO.getSplitSign());
                }
            }
            if (!creVO.isIsDisplay()) continue;
            String strCRE = "";
            if (creVO.getCodeAttribute().trim().equals("sn")) {
                long maxvalue = initial;
                for (int j2 = 0; j2 < count; ++j2) {
                    strCRE = this.formatString(codingruleVO.getCodingRuleEntrys().get(i), maxvalue + (long)(creVO.getStep() * j2) + "");
                    sbCodeRule[j2].append(strCRE);
                }
                strCRE = "";
            } else {
                strCRE = iCodingRuleEntry.getCREString(caller, creVO);
            }
            if (strCRE.equals("isCustom == true")) {
                strCRE = customStr != null && customStr.trim().length() > 0 ? customStr.trim() : "";
            }
            strCRE = this.formatString(codingruleVO.getCodingRuleEntrys().get(i), strCRE);
            logger.debug((Object)("strCRE after formatString:" + strCRE));
            if (!creVO.getCodeAttribute().trim().equals("sn") && creVO.isIsSortByItem()) {
                sortValue.append(strCRE);
            }
            for (j = 0; j < sbCodeRule.length; ++j) {
                sbCodeRule[j].append(strCRE);
            }
        }
        logger.debug((Object)("_getNumber end. sbCodeRule : " + sbCodeRule.toString()));
        String[] codingruleStr = new String[count];
        for (j = 0; j < sbCodeRule.length; ++j) {
            codingruleStr[j] = sbCodeRule[j].toString();
        }
        return codingruleStr;
    }

    private String formatString(CodingRuleEntryInfo creVO, String initStr) throws BOSException {
        logger.debug((Object)("initStr:" + initStr));
        if (creVO.getCodeAttribute().equals("systime") || creVO.getCodeAttribute().equals("attribute") && (creVO.getAttUsingMode().equals("part") || creVO.getAttUsingMode().equals("reference")) || creVO.getCodeAttribute().equals("whole") && (creVO.getAttUsingMode().equals("part") || creVO.getAttUsingMode().equals("reference"))) {
            return initStr;
        }
        if (initStr == null || initStr.trim().length() == 0) {
            return "";
        }
        if (creVO.getLength() > 0 && creVO.getLength() > initStr.length()) {
            logger.debug((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.crResource", (String)"res_3"));
            if (creVO.getFillSign() != null && creVO.getFillSign().length() > 0 || creVO.getCodeAttribute() != null && creVO.getCodeAttribute().equals("sn") && creVO.getLength() > initStr.length()) {
                int fillNumber = creVO.getLength() - initStr.length();
                if (creVO.getFillSignDirection() == DirectionType.Forward) {
                    logger.debug((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.crResource", (String)"res_4"));
                    if (creVO.getCodeAttribute() != null && creVO.getCodeAttribute().equals("sn")) {
                        for (int i = 0; i < fillNumber; ++i) {
                            initStr = "0" + initStr;
                        }
                    } else {
                        for (int i = 0; i < fillNumber; ++i) {
                            initStr = creVO.getFillSign() + initStr;
                        }
                    }
                } else if (creVO.getFillSignDirection() == DirectionType.Backward) {
                    logger.debug((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.crResource", (String)"res_5"));
                    if (creVO.getCodeAttribute() != null && creVO.getCodeAttribute().equals("sn")) {
                        for (int i = 0; i < fillNumber; ++i) {
                            initStr = initStr + "0";
                        }
                    } else {
                        for (int i = 0; i < fillNumber; ++i) {
                            initStr = initStr + creVO.getFillSign();
                        }
                    }
                }
            }
        } else if (creVO.getLength() > 0 && creVO.getLength() < initStr.length()) {
            initStr = "sn".equals(creVO.getCodeAttribute()) ? initStr.substring(initStr.length() - creVO.getLength(), initStr.length()) : initStr.substring(0, creVO.getLength());
        }
        return initStr;
    }

    private void sortCollection(CodingRuleEntryCollection sourceCRE) {
        int i;
        if (sourceCRE.size() == 0) {
            return;
        }
        CodingRuleEntryCollection sortCRE = new CodingRuleEntryCollection();
        CodingRuleEntryInfo[] creCompare = new CodingRuleEntryInfo[sourceCRE.size()];
        for (i = 0; i < sourceCRE.size(); ++i) {
            creCompare[i] = sourceCRE.get(i);
        }
        for (i = 0; i < creCompare.length; ++i) {
            for (int j = i + 1; j < creCompare.length; ++j) {
                if (creCompare[i].getSerialNumber() <= creCompare[j].getSerialNumber() && (creCompare[i].getSerialNumber() != creCompare[j].getSerialNumber() || creCompare[i].getCodeSerialNumber() <= creCompare[j].getCodeSerialNumber())) continue;
                CodingRuleEntryInfo creMin = creCompare[i];
                creCompare[i] = creCompare[j];
                creCompare[j] = creMin;
            }
        }
        for (i = 0; i < creCompare.length; ++i) {
            sortCRE.add(creCompare[i]);
        }
        sourceCRE.clear();
        for (i = 0; i < sortCRE.size(); ++i) {
            sourceCRE.add(sortCRE.get(i));
        }
    }

    private int getSNCREIndex(CodingRuleInfo codingruleVO) throws BOSException, CodingRuleException {
        for (int i = 0; i < codingruleVO.getCodingRuleEntrys().size(); ++i) {
            CodingRuleEntryInfo creVO = codingruleVO.getCodingRuleEntrys().get(i);
            if (!creVO.getCodeAttribute().trim().equals("sn")) continue;
            return i;
        }
        throw new CodingRuleException(CodingRuleException.ERROR_SN_NOTEXIST);
    }

    @Override
    protected String[] _getBatchNumber(Context ctx, int count, int initial, IObjectValue type) throws BOSException, EASBizException {
        return this._getBatchNumber(ctx, count, initial, type, (IObjectValue)ContextUtil.getCurrentFIUnit((Context)ctx));
    }

    @Override
    protected String[] _getBatchNumber(Context ctx, int count, int initial, IObjectValue type, IObjectValue company) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrg = (CompanyOrgUnitInfo)company;
        VoucherInfo voucherInfo = new VoucherInfo();
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        voucherInfo.setCompany(companyOrg);
        if (type != null) {
            voucherInfo.setVoucherType((VoucherTypeInfo)type);
        }
        PeriodInfo period = GlUtils.getCurrentPeriod(ctx, companyOrg.getId().toString());
        voucherInfo.setVoucherType((VoucherTypeInfo)type);
        voucherInfo.setPeriod(period);
        voucherInfo.setCU(companyOrg.getCU());
        voucherInfo.setBookedDate(period.getBeginDate());
        voucherInfo.setBizDate(period.getBeginDate());
        voucherInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        CodingRuleInfo codingruleVo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
        if (codingruleVo != null) {
            return this._getBatchNumber(ctx, (IObjectValue)voucherInfo, (IObjectValue)codingruleVo, null, count, initial);
        }
        IMetaDataLoader metaLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = metaLoader.getEntity(voucherInfo.getBOSType());
        throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{eo.getAlias()});
    }

    @Override
    protected boolean _unitSameAcct(Context ctx, String id) throws BOSException, EASBizException {
        IRowSet rowset;
        boolean isInTimeVerify;
        Object[] param = new Object[]{id};
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherInfo voucherInfo = (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(id), this.getDefaultEntrySelector(true));
        if (voucherInfo.getBizStatus().getValue() > 1 || voucherInfo.isIsCheck()) {
            throw new VoucherException(VoucherException.CANTUNIT_OTHERSTATUS, new Object[]{voucherInfo.getBizStatus().getAlias()});
        }
        if (this.isExistCashflow(ctx, id)) {
            throw new VoucherException(VoucherException.CANTUNIT_HASCASHFLOW);
        }
        boolean bl = isInTimeVerify = GlUtils.getVerifyMode(ctx, voucherInfo.getCompany().getId().toString()) == 0;
        if (!isInTimeVerify) {
            boolean hasVerified;
            if (voucherInfo.getId() != null && (hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).hasVerify(voucherInfo.getId().toString()))) {
                throw new VoucherException(VoucherException.CANTUNIT_HASVERIFY);
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("select vast.FID from t_gl_VoucherAssistRecord vast, t_GL_AcctCussent cust                          \r\n");
            sql.append("\twhere vast.FVerifiedCussentID = cust.FID            \r\n");
            sql.append("\tand vast.FBillID = ?                            \r\n");
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
            try {
                if (rowset != null && rowset.next()) {
                    throw new VoucherException(VoucherException.CANTUNIT_HASVERIFY);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            sql = new StringBuffer();
            sql.append("select vast.FID from t_gl_VoucherAssistRecord vast, t_GL_AcctCussent cust,t_gl_VoucherAssistRecord vast2         \r\n");
            sql.append("\twhere vast.FVerifiedCussentID = cust.FID  and   cust.FVchAssistRecordId =  vast2.fid       \r\n");
            sql.append("\tand vast2.FBillID = ?                            \r\n");
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
            try {
                if (rowset != null && rowset.next()) {
                    throw new VoucherException(VoucherException.CANTUNIT_HASVERIFY);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        StringBuffer sqlNotice = new StringBuffer();
        sqlNotice.append("select top 1 fid from t_csl_requisition where fvoucherid=?");
        rowset = DbUtil.executeQuery((Context)ctx, (String)sqlNotice.toString(), (Object[])new Object[]{id});
        try {
            if (rowset != null && rowset.next()) {
                throw new VoucherException(VoucherException.CANTUNIT_HASNOTICE);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        boolean existAcctCus = false;
        boolean existVerify = false;
        if (!isInTimeVerify) {
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("select 1 from t_gl_acctcussent where FVOUCHERID = ? ");
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
                if (result.next()) {
                    sql.setLength(0);
                    sql.append("delete from t_gl_acctcussent where FVchAssistRecordID in (select fid from t_gl_voucherassistrecord asst where asst.FBillID = ?)");
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
                    existAcctCus = true;
                }
                sql.setLength(0);
                sql.append("select 1 from t_gl_acctverify where FVOUCHERID = ? ");
                result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
                if (result.next()) {
                    sql.setLength(0);
                    sql.append("delete from t_gl_acctverify where FVchAssistRecordID in (select fid from t_gl_voucherassistrecord asst where asst.FBillID = ?)");
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
                    existVerify = true;
                }
            }
            catch (SQLException e) {
                logger.error((Object)"deal acctcussent error.", (Throwable)e);
                throw new BOSException("deal acctcussent error.", (Throwable)e);
            }
        }
        boolean needUnit = false;
        String sql = "select b.fprofitcenterid,b.faccountid,b.fcurrencyid,b.fmeasureunitid,b.fentrydc from t_gl_voucher a \t\r\n  \tinner join t_gl_voucherentry b on a.fid=b.fbillid \t\t\t\t\t\t\t\t\r\n  \twhere a.fid=?  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n\tgroup by b.fprofitcenterid,b.faccountid,b.fcurrencyid,b.fmeasureunitid,b.fentrydc\t\t\t\t\r\n\thaving count(*)>1 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        String updateVoucherSql = "update t_gl_voucher set Fentrycount = ? where fid=? ";
        String updateVoucherUnitSql = "update t_gl_voucher set Fiscussent=1 where fid=? ";
        String updateVoucherAssSql = "update t_gl_voucherAssistRecord set FentryId = ? where FentryId=? ";
        IVoucherEntry iVoucherEntry = VoucherEntryFactory.getLocalInstance(ctx);
        IVoucherAssistRecord iVoucherAsst = VoucherAssistRecordFactory.getLocalInstance(ctx);
        try {
            if (rs != null && rs.next()) {
                ArrayList sameEntry;
                HashMap<String, VoucherEntryInfo> entry = new HashMap<String, VoucherEntryInfo>();
                HashMap<String, ArrayList> same = new HashMap<String, ArrayList>();
                VoucherEntryCollection entries = voucherInfo.getEntries();
                int size = entries.size();
                if (size == 2) {
                    throw new VoucherException(VoucherException.NOTNEEUNIT, new Object[]{voucherInfo.getNumber()});
                }
                for (int i = 0; i < size; ++i) {
                    VoucherEntryInfo entryInfo = entries.get(i);
                    entry.put(entryInfo.getId().toString(), entryInfo);
                    AccountViewInfo acct = entryInfo.getAccount();
                    String key = null;
                    StringBuffer keyBuffer = new StringBuffer();
                    if (entryInfo.getProfitCenter() != null) {
                        keyBuffer.append(entryInfo.getProfitCenter().getId().toString());
                    }
                    if (acct.isIsQty() && entryInfo.getMeasureUnit() != null) {
                        keyBuffer.append(entryInfo.getAccount().getId().toString() + entryInfo.getCurrency().getId().toString() + entryInfo.getEntryDC().getValue() + entryInfo.getMeasureUnit().getId().toString());
                    } else {
                        keyBuffer.append(entryInfo.getAccount().getId().toString() + entryInfo.getCurrency().getId().toString() + entryInfo.getEntryDC().getValue());
                    }
                    key = keyBuffer.toString();
                    sameEntry = null;
                    if (same.containsKey(key)) {
                        sameEntry = (ArrayList)same.get(key);
                    } else {
                        sameEntry = new ArrayList();
                        same.put(key, sameEntry);
                    }
                    sameEntry.add(entryInfo);
                }
                ArrayList<VoucherEntryInfo> updateEntry = new ArrayList<VoucherEntryInfo>();
                HashMap delEntry = new HashMap();
                Set set = same.keySet();
                for (String key : set) {
                    sameEntry = (ArrayList)same.get(key);
                    if (sameEntry.size() <= 1) continue;
                    needUnit = true;
                    int count = sameEntry.size();
                    VoucherEntryInfo updateEntryInfo = (VoucherEntryInfo)sameEntry.get(0);
                    updateEntry.add(updateEntryInfo);
                    ArrayList<VoucherEntryInfo> delEntryList = new ArrayList<VoucherEntryInfo>();
                    for (int i = 1; i < count; ++i) {
                        VoucherEntryInfo delEntryInfo = (VoucherEntryInfo)sameEntry.get(i);
                        delEntryList.add(delEntryInfo);
                        updateEntryInfo.setOriginalAmount(this.addAmount(updateEntryInfo.getOriginalAmount(), delEntryInfo.getOriginalAmount()));
                        updateEntryInfo.setLocalAmount(this.addAmount(updateEntryInfo.getLocalAmount(), delEntryInfo.getLocalAmount()));
                        updateEntryInfo.setReportingAmount(this.addAmount(updateEntryInfo.getReportingAmount(), delEntryInfo.getReportingAmount()));
                        updateEntryInfo.setQuantity(this.addAmount(updateEntryInfo.getQuantity(), delEntryInfo.getQuantity()));
                        updateEntryInfo.setStandardQuantity(this.addAmount(updateEntryInfo.getStandardQuantity(), delEntryInfo.getStandardQuantity()));
                        updateEntryInfo.setMaCtrlAmount(this.addAmount(updateEntryInfo.getMaCtrlAmount(), delEntryInfo.getMaCtrlAmount()));
                        updateEntryInfo.setMaHoldAmount(this.addAmount(updateEntryInfo.getMaHoldAmount(), delEntryInfo.getMaHoldAmount()));
                    }
                    delEntry.put(updateEntryInfo.getId().toString(), delEntryList);
                }
                int count = updateEntry.size();
                for (int i = 0; i < count; ++i) {
                    VoucherEntryInfo updateEntryInfo = (VoucherEntryInfo)updateEntry.get(i);
                    iVoucherEntry.update((IObjectPK)new ObjectUuidPK(updateEntryInfo.getId()), (CoreBaseInfo)updateEntryInfo);
                }
                set = delEntry.keySet();
                for (String key : set) {
                    List delEntryList = (List)delEntry.get(key);
                    for (int i = 0; i < delEntryList.size(); ++i) {
                        VoucherEntryInfo delEntryInfo = (VoucherEntryInfo)delEntryList.get(i);
                        DbUtil.execute((Context)ctx, (String)updateVoucherAssSql, (Object[])new Object[]{key, delEntryInfo.getId().toString()});
                        iVoucherEntry.delete((IObjectPK)new ObjectUuidPK(delEntryInfo.getId()));
                    }
                }
                DbUtil.execute((Context)ctx, (String)updateVoucherSql, (Object[])new Object[]{new Integer(same.size()), id});
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "select b.fprofitcenterid,b.faccountid,b.fcurrencyid,b.fmeasureunitid,b.fentrydc,c.fassgrpid,c.fmeasureunitid from t_gl_voucher a \t\r\n  \tinner join t_gl_voucherentry b on a.fid=b.fbillid \t\t\t\t\t\t\t\t\r\n\tinner join t_gl_voucherAssistRecord c on c.fentryid=b.fid \t\t\t\t\t\t\r\n  \twhere a.fid=?  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n\tgroup by b.fprofitcenterid,b.faccountid,b.fcurrencyid,b.fmeasureunitid,b.fentrydc,c.fassgrpid,c.fmeasureunitid\t\t\t\t\r\n\thaving count(*)>1 \t\t\t\t\t\t\t\t\t\t\t\t\t"), (Object[])param)) != null && rs.next()) {
                voucherInfo = (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(id), this.getDefaultEntrySelector(false));
                VoucherEntryCollection entries0 = voucherInfo.getEntries();
                int ensize = entries0.size();
                for (int j = 0; j < ensize; ++j) {
                    VoucherEntryInfo entryInfo0 = entries0.get(j);
                    HashMap<String, VoucherAssistRecordInfo> entry = new HashMap<String, VoucherAssistRecordInfo>();
                    HashMap<String, ArrayList> same = new HashMap<String, ArrayList>();
                    VoucherAssistRecordCollection entries = entryInfo0.getAssistRecords();
                    AccountViewInfo acct = entryInfo0.getAccount();
                    if (acct.getCAA() == null) continue;
                    int size = entries.size();
                    for (int i = 0; i < size; ++i) {
                        VoucherAssistRecordInfo entryInfo = entries.get(i);
                        entry.put(entryInfo.getId().toString(), entryInfo);
                        String key = null;
                        StringBuffer keyBuffer = new StringBuffer();
                        if (entryInfo0.getProfitCenter() != null) {
                            keyBuffer.append(entryInfo0.getProfitCenter().getId().toString());
                        }
                        if (acct.isIsQty() && entryInfo0.getMeasureUnit() != null) {
                            if (acct.getCAA().isIsQty() && entryInfo.getMeasureUnit() != null) {
                                keyBuffer.append(entryInfo0.getAccount().getId().toString() + entryInfo0.getCurrency().getId().toString() + entryInfo0.getEntryDC().getValue() + entryInfo0.getMeasureUnit().getId().toString() + entryInfo.getAssGrp().getId().toString() + entryInfo.getMeasureUnit().getId().toString());
                            } else {
                                keyBuffer.append(entryInfo0.getAccount().getId().toString() + entryInfo0.getCurrency().getId().toString() + entryInfo0.getEntryDC().getValue() + entryInfo0.getMeasureUnit().getId().toString() + entryInfo.getAssGrp().getId().toString());
                            }
                        } else if (acct.getCAA().isIsQty() && entryInfo.getMeasureUnit() != null) {
                            keyBuffer.append(entryInfo0.getAccount().getId().toString() + entryInfo0.getCurrency().getId().toString() + entryInfo0.getEntryDC().getValue() + entryInfo.getAssGrp().getId().toString() + entryInfo.getMeasureUnit().getId().toString());
                        } else {
                            keyBuffer.append(entryInfo0.getAccount().getId().toString() + entryInfo0.getCurrency().getId().toString() + entryInfo0.getEntryDC().getValue() + entryInfo.getAssGrp().getId().toString());
                        }
                        key = keyBuffer.toString();
                        ArrayList sameEntry = null;
                        if (same.containsKey(key)) {
                            sameEntry = (ArrayList)same.get(key);
                        } else {
                            sameEntry = new ArrayList();
                            same.put(key, sameEntry);
                        }
                        sameEntry.add(entryInfo);
                    }
                    ArrayList<VoucherAssistRecordInfo> updateEntry = new ArrayList<VoucherAssistRecordInfo>();
                    HashMap<String, VoucherAssistRecordInfo> delEntry = new HashMap<String, VoucherAssistRecordInfo>();
                    Set set = same.keySet();
                    for (String key : set) {
                        ArrayList sameEntry = (ArrayList)same.get(key);
                        if (sameEntry.size() <= 1) continue;
                        needUnit = true;
                        int count = sameEntry.size();
                        VoucherAssistRecordInfo updateEntryInfo = (VoucherAssistRecordInfo)sameEntry.get(0);
                        updateEntry.add(updateEntryInfo);
                        for (int i = 1; i < count; ++i) {
                            VoucherAssistRecordInfo delEntryInfo = (VoucherAssistRecordInfo)sameEntry.get(i);
                            delEntry.put(delEntryInfo.getId().toString(), delEntryInfo);
                            updateEntryInfo.setOriginalAmount(this.addAmount(updateEntryInfo.getOriginalAmount(), delEntryInfo.getOriginalAmount()));
                            updateEntryInfo.setLocalAmount(this.addAmount(updateEntryInfo.getLocalAmount(), delEntryInfo.getLocalAmount()));
                            updateEntryInfo.setReportingAmount(this.addAmount(updateEntryInfo.getReportingAmount(), delEntryInfo.getReportingAmount()));
                            updateEntryInfo.setQuantity(this.addAmount(updateEntryInfo.getQuantity(), delEntryInfo.getQuantity()));
                            updateEntryInfo.setStandardQuantity(this.addAmount(updateEntryInfo.getStandardQuantity(), delEntryInfo.getStandardQuantity()));
                            updateEntryInfo.setMaCtrlAmount(this.addAmount(updateEntryInfo.getMaCtrlAmount(), delEntryInfo.getMaCtrlAmount()));
                            updateEntryInfo.setMaHoldAmount(this.addAmount(updateEntryInfo.getMaHoldAmount(), delEntryInfo.getMaHoldAmount()));
                        }
                    }
                    int count = updateEntry.size();
                    for (int i = 0; i < count; ++i) {
                        VoucherAssistRecordInfo updateEntryInfo = (VoucherAssistRecordInfo)updateEntry.get(i);
                        iVoucherAsst.update((IObjectPK)new ObjectUuidPK(updateEntryInfo.getId()), (CoreBaseInfo)updateEntryInfo);
                    }
                    set = delEntry.keySet();
                    for (String key : set) {
                        VoucherAssistRecordInfo delEntryInfo = (VoucherAssistRecordInfo)delEntry.get(key);
                        iVoucherAsst.delete((IObjectPK)new ObjectUuidPK(delEntryInfo.getId()));
                    }
                }
            }
            if (!needUnit) {
                throw new VoucherException(VoucherException.NOTNEEUNIT, new Object[]{voucherInfo.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateVoucherUnitSql, (Object[])new Object[]{id});
            boolean zeroSub = GlUtils.getDefaultGLParam(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), "GL_0301");
            if (!zeroSub) {
                sql = "select fid from  t_gl_voucherentry b \t\t\r\n  \twhere b.fbillid=? and b.foriginalAmount=0 and b.flocalAmount=0 and b.freportingAmount=0\tand fQuantity=0\t\t\t\r\n";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
                if (rs != null && rs.next()) {
                    throw new VoucherException(VoucherException.UNIT_FAILED);
                }
                sql = "select fid from  t_gl_voucherAssistRecord b \t\t\r\n  \twhere b.fbillid=? and b.foriginalAmount=0 and b.flocalAmount=0 and b.freportingAmount=0\tand fQuantity=0\t\t\t\t\r\n";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
                if (rs != null && rs.next()) {
                    throw new VoucherException(VoucherException.UNIT_FAILED);
                }
                if (!isInTimeVerify) {
                    if (existAcctCus) {
                        AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).insertCussent(voucherInfo.getId().toString());
                    }
                    if (existVerify) {
                        AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).insertVerify(voucherInfo.getId().toString(), false);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (needUnit && voucherInfo.getBizStatus().getValue() == 1) {
            iVoucher.submitVoucher((IObjectPK)new ObjectUuidPK(id));
        }
        return needUnit;
    }

    private boolean isExistCashflow(Context ctx, String vchId) throws BOSException {
        String sql = "select top 1 FID from T_GL_CashflowRecord where FVoucherId=?  AND fitemFlag <> 7 and fitemFlag<>5";
        Object[] params = new Object[]{vchId};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            return rowset != null && rowset.next();
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }

    public SelectorItemCollection getDefaultEntrySelector(boolean isEntry) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entryCount"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.entryDC"));
        sic.add(new SelectorItemInfo("entries.account.id"));
        sic.add(new SelectorItemInfo("entries.account.isQty"));
        sic.add(new SelectorItemInfo("entries.currency.id"));
        sic.add(new SelectorItemInfo("entries.measureUnit.id"));
        sic.add(new SelectorItemInfo("entries.profitcenter.id"));
        if (isEntry) {
            sic.add(new SelectorItemInfo("entries.price"));
            sic.add(new SelectorItemInfo("entries.quantity"));
            sic.add(new SelectorItemInfo("entries.standardQuantity"));
            sic.add(new SelectorItemInfo("entries.originalAmount"));
            sic.add(new SelectorItemInfo("entries.localExchangeRate"));
            sic.add(new SelectorItemInfo("entries.localAmount"));
            sic.add(new SelectorItemInfo("entries.reportingExchangeRate"));
            sic.add(new SelectorItemInfo("entries.reportingAmount"));
            sic.add(new SelectorItemInfo("entries.maCtrlAmount"));
            sic.add(new SelectorItemInfo("entries.maHoldAmount"));
        } else {
            sic.add(new SelectorItemInfo("entries.account.CAA.isQty"));
            sic.add(new SelectorItemInfo("entries.assistRecords.quantity"));
            sic.add(new SelectorItemInfo("entries.assistRecords.standardQuantity"));
            sic.add(new SelectorItemInfo("entries.assistRecords.originalAmount"));
            sic.add(new SelectorItemInfo("entries.assistRecords.maCtrlAmount"));
            sic.add(new SelectorItemInfo("entries.assistRecords.maHoldAmount"));
            sic.add(new SelectorItemInfo("entries.assistRecords.localAmount"));
            sic.add(new SelectorItemInfo("entries.assistRecords.reportingAmount"));
            sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.id"));
            sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.id"));
        }
        return sic;
    }

    private BigDecimal addAmount(BigDecimal update, BigDecimal del) {
        BigDecimal add = GlUtils.zero;
        if (update == null) {
            if (del != null) {
                add = del;
            }
        } else {
            add = del != null ? update.add(del) : update;
        }
        return add;
    }

    @Override
    protected IObjectValue _checkProfitOrg(Context ctx, String mapping, IObjectValue obj1, IObjectValue obj2) throws BOSException, EASBizException {
        CoreBaseInfo info = (CoreBaseInfo)obj1;
        CoreBaseInfo info2 = (CoreBaseInfo)obj2;
        CoreBaseInfo baseinfo = null;
        if (info == null) {
            return null;
        }
        boolean isExit = false;
        if (info2 == null) {
            FilterInfo filter = null;
            do {
                filter = new FilterInfo();
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("id", (Object)info.getId().toString()));
                fic.add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
                isExit = this.getRemoteInstance(ctx, mapping, false).exists(filter);
                if (isExit) {
                    baseinfo = (OrgUnitInfo)this.getRemoteInstance(ctx, mapping, false).getValue((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                    continue;
                }
                OrgUnitInfo orginfo = (OrgUnitInfo)this.getRemoteInstance(ctx, mapping, true).getValue((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                info = this.getParent(mapping, orginfo, true);
            } while (!isExit && info != null);
        } else {
            OrgUnitInfo orginfo;
            do {
                if (!(isExit = info.getId().toString().equals(info2.getId().toString()))) {
                    orginfo = (OrgUnitInfo)this.getRemoteInstance(ctx, mapping, true).getValue((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                    info = this.getParent(mapping, orginfo, true);
                    continue;
                }
                baseinfo = info2;
            } while (!isExit && info != null);
            if (baseinfo == null) {
                info = (CoreBaseInfo)obj1;
                do {
                    if (!(isExit = info.getId().toString().equals(info2.getId().toString()))) {
                        orginfo = (OrgUnitInfo)this.getRemoteInstance(ctx, mapping, false).getValue((IObjectPK)new ObjectUuidPK(info2.getId().toString()));
                        info2 = this.getParent(mapping, orginfo, false);
                        continue;
                    }
                    baseinfo = info;
                } while (!isExit && info2 != null);
            }
        }
        return baseinfo;
    }

    private OrgUnitInfo getParent(String mappingFieldName, OrgUnitInfo orginfo, boolean findParent) {
        if (findParent) {
            if ("costOrg".equals(mappingFieldName)) {
                return ((CostCenterOrgUnitInfo)orginfo).getParent();
            }
            return ((ProfitCenterOrgUnitInfo)orginfo).getParent();
        }
        if (!"costOrg".equals(mappingFieldName)) {
            return ((CostCenterOrgUnitInfo)orginfo).getParent();
        }
        return ((ProfitCenterOrgUnitInfo)orginfo).getParent();
    }

    private IOrgUnit getRemoteInstance(Context ctx, String mappingFieldName, boolean findParent) throws BOSException {
        if (findParent) {
            if ("costOrg".equals(mappingFieldName)) {
                return CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            }
            return ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        }
        if ("costOrg".equals(mappingFieldName)) {
            return ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        }
        return CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected boolean _setMgCtrl(Context ctx, Map list) throws BOSException, EASBizException {
        String sql = "update t_gl_voucher set fismgCtrl=? where fid=?";
        Set set = list.keySet();
        for (String key : set) {
            Boolean value = (Boolean)list.get(key);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{value, key});
        }
        return true;
    }

    @Override
    protected String _checkVoucherCashAlert(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("GL_013");
        keys.add("GL_073");
        Map params = GlUtils.getParamsByKeys(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), keys);
        Boolean acAlert = Boolean.valueOf(String.valueOf(params.get("GL_073")));
        int option = Integer.valueOf(params.get("GL_013").toString());
        if (option == 2 && acAlert == Boolean.FALSE) {
            return "";
        }
        EntityViewInfo v = new EntityViewInfo();
        v.getSelector().addObjectCollection((IObjectCollection)VoucherInfo.getDefaultSelector());
        v.setFilter(filterInfo);
        VoucherCollection vchCol = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(v);
        String submitNegroAccount = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"SubmitNegroAccount", (Locale)ctx.getLocale());
        String submitNegroAsst = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"SubmitNegroAsst", (Locale)ctx.getLocale());
        StringBuffer sbCash = new StringBuffer();
        StringBuffer sbAc = new StringBuffer();
        HashMap balanceMap = new HashMap();
        HashMap longNameMap = new HashMap();
        Map param = null;
        int n = vchCol.size();
        for (int i = 0; i < n; ++i) {
            VoucherInfo voucherInfo = vchCol.get(i);
            param = this.getBalanceKey(ctx, voucherInfo, balanceMap, longNameMap, option != 2, acAlert);
            Map balanceKeyMap = (Map)param.get("balanceKeyMap");
            Map endMap = (Map)param.get("endMap");
            Map accountMap = (Map)param.get("accountMap");
            Map currencyMap = (Map)param.get("currencyMap");
            Map asstMap = (Map)param.get("asstMap");
            Map asstAccountMap = (Map)param.get("asstAccountMap");
            Map asstCurrenyMap = (Map)param.get("asstCurrenyMap");
            BigDecimal loAmount = GlUtils.zero;
            BigDecimal origAmount = GlUtils.zero;
            Set keyset = balanceKeyMap.keySet();
            for (String key : keyset) {
                Map query = (Map)balanceKeyMap.get(key);
                query.put("FbookDate", voucherInfo.getBookedDate());
                query.put("FeditDataPeriod", voucherInfo.getPeriod().getId().toString());
                balanceKeyMap.put(key, query);
            }
            Map balanceBatchMap = this.getBalance(ctx, balanceKeyMap);
            if (balanceBatchMap != null) {
                balanceMap.putAll(balanceBatchMap);
            }
            Set set = endMap.keySet();
            for (String key : set) {
                String msg;
                List amt = (List)endMap.get(key);
                origAmount = (BigDecimal)amt.get(0);
                loAmount = (BigDecimal)amt.get(1);
                if (balanceMap.containsKey(key)) {
                    VoucherBalance balance = (VoucherBalance)balanceMap.get(key);
                    origAmount = origAmount.add(balance.getEndbalanceOriginal());
                    loAmount = loAmount.add(balance.getEndbalance());
                }
                AccountViewInfo account = (AccountViewInfo)accountMap.get(key);
                CurrencyInfo currency = (CurrencyInfo)currencyMap.get(key);
                if (BalanceDirectionEnum.CREDIT.equals((Object)account.getDC())) {
                    origAmount = origAmount.negate();
                    loAmount = loAmount.negate();
                }
                if ((account.isIsCash() || account.isIsBank()) && origAmount.compareTo(GlUtils.zero) < 0) {
                    msg = null;
                    msg = asstMap.get(key) == null ? MessageFormat.format(submitNegroAccount, account.getNumber(), currency.getName()) : MessageFormat.format(submitNegroAsst, asstAccountMap.get(key), asstCurrenyMap.get(key), asstMap.get(key));
                    if (sbCash.length() > 0) {
                        sbCash.append("\u3000\r\n");
                    }
                    sbCash.append(msg);
                    continue;
                }
                if (!account.isAC() || origAmount.compareTo(GlUtils.zero) >= 0) continue;
                msg = null;
                msg = asstMap.get(key) == null ? MessageFormat.format(submitNegroAccount, account.getNumber(), currency.getName()) : MessageFormat.format(submitNegroAsst, asstAccountMap.get(key), asstCurrenyMap.get(key), asstMap.get(key));
                if (sbAc.length() > 0) {
                    sbAc.append("\u3000\r\n");
                }
                sbAc.append(msg);
            }
        }
        StringBuffer sbMsg = new StringBuffer();
        if (sbCash.length() > 0 && option == 0) {
            sbMsg.append("forbidden:").append(sbCash);
        }
        if (sbAc.length() > 0) {
            if (sbMsg.length() > 0) {
                sbMsg.append("  \r\n");
            }
            sbMsg.append(sbAc);
        }
        return sbMsg.toString();
    }

    private Map getBalance(Context ctx, Map keyMap) {
        Map balanceBatch = null;
        try {
            Map resultBatch = AccountBalanceFactory.getLocalInstance(ctx).getBalanceBatch(keyMap);
            balanceBatch = this.getbalanceBatch(keyMap, resultBatch);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return balanceBatch;
    }

    protected Map getbalanceBatch(Map keyMap, Map resultBatch) {
        HashMap<String, VoucherBalance> balanceBatch = new HashMap<String, VoucherBalance>();
        if (resultBatch != null) {
            Set keySet = keyMap.keySet();
            for (String key : keySet) {
                Map queryMap = (Map)keyMap.get(key);
                CurrencyInfo cur = (CurrencyInfo)queryMap.get("currency");
                if (!resultBatch.containsKey(key)) continue;
                VoucherBalance balance = new VoucherBalance();
                Map result = (Map)resultBatch.get(key);
                balance.setCreditOriginal(GlUtils.setScale((BigDecimal)result.get("creditFor"), cur.getPrecision(), 4));
                balance.setDebitOriginal(GlUtils.setScale((BigDecimal)result.get("debitFor"), cur.getPrecision(), 4));
                balance.setEndbalanceOriginal(GlUtils.setScale((BigDecimal)result.get("endbalanceFor"), cur.getPrecision(), 4));
                balance.setCredit(GlUtils.setScale((BigDecimal)result.get("credit"), cur.getPrecision(), 4));
                balance.setDebit(GlUtils.setScale((BigDecimal)result.get("debit"), cur.getPrecision(), 4));
                balance.setEndbalance(GlUtils.setScale((BigDecimal)result.get("endbalance"), cur.getPrecision(), 4));
                balanceBatch.put(key, balance);
            }
        }
        return balanceBatch;
    }

    protected Map getBalanceKey(Context ctx, VoucherInfo voucherInfo, Map balanceMap, Map longNameMap, boolean isCashCheck, boolean isAcCheck) throws BOSException, EASBizException {
        HashMap param = new HashMap();
        HashMap balanceKeyMap = new HashMap();
        param.put("balanceKeyMap", balanceKeyMap);
        HashMap<String, List<BigDecimal>> endMap = new HashMap<String, List<BigDecimal>>();
        param.put("endMap", endMap);
        HashMap<String, AccountViewInfo> accountMap = new HashMap<String, AccountViewInfo>();
        param.put("accountMap", accountMap);
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        param.put("currencyMap", currencyMap);
        HashMap<String, String> asstMap = new HashMap<String, String>();
        param.put("asstMap", asstMap);
        HashMap<String, String> asstAccountMap = new HashMap<String, String>();
        param.put("asstAccountMap", asstAccountMap);
        HashMap<String, String> asstCurrenyMap = new HashMap<String, String>();
        param.put("asstCurrenyMap", asstCurrenyMap);
        VoucherEntryCollection voucherEntryCollection = voucherInfo.getEntries();
        for (VoucherEntryInfo voucherEntryInfo : voucherEntryCollection) {
            VoucherAssistRecordCollection tvar;
            List<BigDecimal> amt;
            if (voucherEntryInfo.getAccount() == null || voucherEntryInfo.getCurrency() == null) continue;
            boolean isNeedCheck = false;
            if (isCashCheck && (voucherEntryInfo.getAccount().isIsCash() || voucherEntryInfo.getAccount().isIsBank())) {
                isNeedCheck = true;
            } else if (isAcCheck && voucherEntryInfo.getAccount().isAC()) {
                isNeedCheck = true;
            }
            if (!isNeedCheck) continue;
            String hgid = null;
            String key = voucherEntryInfo.getAccount().getId().toString() + voucherEntryInfo.getCurrency().getId().toString();
            EntryDC dc = voucherEntryInfo.getEntryDC();
            BigDecimal lineLoc = voucherEntryInfo.getLocalAmount();
            BigDecimal lineOrig = voucherEntryInfo.getOriginalAmount();
            if (!endMap.containsKey(key)) {
                amt = new ArrayList<BigDecimal>();
                amt.add(lineOrig.multiply(new BigDecimal(String.valueOf(dc.getValue() * 2 - 1))));
                amt.add(lineLoc.multiply(new BigDecimal(String.valueOf(dc.getValue() * 2 - 1))));
                endMap.put(key, amt);
                accountMap.put(key, voucherEntryInfo.getAccount());
                currencyMap.put(key, voucherEntryInfo.getCurrency());
            } else {
                amt = (List)endMap.get(key);
                BigDecimal origAmt = (BigDecimal)amt.get(0);
                BigDecimal localAmt = (BigDecimal)amt.get(1);
                origAmt = origAmt.add(lineOrig.multiply(new BigDecimal(String.valueOf(dc.getValue() * 2 - 1))));
                localAmt = localAmt.add(lineLoc.multiply(new BigDecimal(String.valueOf(dc.getValue() * 2 - 1))));
                amt.set(0, origAmt);
                amt.set(1, localAmt);
            }
            if (!balanceKeyMap.containsKey(key) && !balanceMap.containsKey(key)) {
                HashMap<String, String> query = new HashMap<String, String>();
                query.put("acct", voucherEntryInfo.getAccount().getId().toString());
                query.put("asstribut", null);
                query.put("curPeriod", voucherInfo.getPeriod().getId().toString());
                query.put("curCompany", voucherInfo.getCompany().getId().toString());
                query.put("currency", (String)voucherEntryInfo.getCurrency());
                balanceKeyMap.put(key, query);
            }
            if (voucherEntryInfo.getAccount() == null || voucherEntryInfo.getAccount().getCAA() == null || (tvar = voucherEntryInfo.getAssistRecords()) == null || tvar.size() <= 0) continue;
            int count = tvar.size();
            for (int i = 0; i < count; ++i) {
                List<BigDecimal> amt2;
                VoucherAssistRecordInfo asstInfo = tvar.get(i);
                String key2 = key;
                if (asstInfo.getAssGrp() == null) continue;
                hgid = asstInfo.getAssGrp().getId().toString();
                key2 = key2 + hgid;
                BigDecimal assOrig = asstInfo.getOriginalAmount();
                BigDecimal assLoc = asstInfo.getLocalAmount();
                if (assLoc == null) {
                    return null;
                }
                if (!endMap.containsKey(key2)) {
                    amt2 = new ArrayList<BigDecimal>();
                    amt2.add(assOrig.multiply(new BigDecimal(String.valueOf(dc.getValue() * 2 - 1))));
                    amt2.add(assLoc.multiply(new BigDecimal(String.valueOf(dc.getValue() * 2 - 1))));
                    endMap.put(key2, amt2);
                    accountMap.put(key2, voucherEntryInfo.getAccount());
                    currencyMap.put(key2, voucherEntryInfo.getCurrency());
                    String longname = asstInfo.getAssGrp().getLongNameGroup();
                    if (longname == null) {
                        longname = this.getLongName(ctx, asstInfo.getAssGrp(), longNameMap);
                    } else {
                        longNameMap.put(asstInfo.getAssGrp().getId().toString(), longname);
                    }
                    if (longname != null) {
                        longname = longname.substring(0, longname.length() - 1);
                    }
                    asstMap.put(key2, longname);
                    asstAccountMap.put(key2, voucherEntryInfo.getAccount().getNumber());
                    asstCurrenyMap.put(key2, voucherEntryInfo.getCurrency().getName());
                } else {
                    amt2 = (List)endMap.get(key2);
                    BigDecimal asstOrigAmt = (BigDecimal)amt2.get(0);
                    BigDecimal asstLocalAmt = (BigDecimal)amt2.get(1);
                    asstOrigAmt = asstOrigAmt.add(assOrig.multiply(new BigDecimal(String.valueOf(dc.getValue() * 2 - 1))));
                    asstLocalAmt = asstLocalAmt.add(assLoc.multiply(new BigDecimal(String.valueOf(dc.getValue() * 2 - 1))));
                    amt2.set(0, asstOrigAmt);
                    amt2.set(1, asstLocalAmt);
                }
                if (balanceKeyMap.containsKey(key2) || balanceMap.containsKey(key2)) continue;
                HashMap<String, String> query = new HashMap<String, String>();
                query.put("acct", voucherEntryInfo.getAccount().getId().toString());
                query.put("asstribut", (String)(asstInfo.getAssGrp() != null ? asstInfo.getAssGrp() : null));
                query.put("curPeriod", voucherInfo.getPeriod().getId().toString());
                query.put("curCompany", voucherInfo.getCompany().getId().toString());
                query.put("currency", (String)voucherEntryInfo.getCurrency());
                balanceKeyMap.put(key2, query);
            }
        }
        return param;
    }

    private String getLongName(Context ctx, AssistantHGInfo asst, Map longNameMap) throws BOSException, EASBizException {
        if (asst == null) {
            return null;
        }
        if (longNameMap.containsKey(asst.getId().toString())) {
            return (String)longNameMap.get(asst.getId().toString());
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("longNameGroup"));
        AssistantHGInfo info = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(asst.getId().toString()), sic);
        longNameMap.put(asst.getId().toString(), info.getLongNameGroup());
        return info.getLongNameGroup();
    }

    @Override
    protected void _modifyAttech(Context ctx, String boid, int count) throws BOSException, EASBizException {
        String updateSql = "update t_gl_voucher set FAttachments=? where fid=?";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{new Integer(count), boid});
    }

    @Override
    protected void _reSortNumber(Context ctx, String companyId) throws BOSException, EASBizException {
        block14: {
            IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            MutexParameter mp = null;
            try {
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                String cuid = company.getCU().getId().toString();
                PeriodInfo curPeriod = GlUtils.getCurrentPeriod(ctx, companyId);
                String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                mp = GLMutexUtils.buildModifyBalanceParameter(ctx, companyId, userId, "GL_ReSortNumber");
                boolean isLockSucceed = mutex.requestMutex(mp);
                if (!isLockSucceed) {
                    throw new VoucherException(VoucherException.RESORTNUMLOCKFAILED);
                }
                FilterInfo filterVT = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "adminCU");
                VoucherTypeCollection vtCol = GlUtils.getVoucherTypeCollection(ctx, filterVT, "true");
                CodingRuleInfo codingruleVO = (CodingRuleInfo)this.getCodingRuleVo(ctx, this.getVoucherInfo(ctx, null));
                boolean hasVT = this.hasAttributeInCodingRule(codingruleVO, "voucherType", false);
                boolean hasPeroidYear = this.hasAttributeInCodingRule(codingruleVO, "period.periodYear", false);
                boolean hasPeroidNumber = this.hasAttributeInCodingRule(codingruleVO, "period.periodNumber", false);
                boolean hasPeroidInfo = this.hasAttributeInCodingRule(codingruleVO, "period", true);
                boolean hasPeroid = hasPeroidInfo || hasPeroidYear && hasPeroidNumber;
                String voucherTypeId = null;
                EntityViewInfo evi = new EntityViewInfo();
                SorterItemCollection sorters = evi.getSorter();
                sorters.add(new SorterItemInfo("bookedDate"));
                sorters.add(new SorterItemInfo("number"));
                SelectorItemCollection sic = new SelectorItemCollection();
                this.setSelector(sic);
                VoucherCollection col = (VoucherCollection)this.loadData(ctx, curPeriod.getId().toString(), sorters);
                if (this.checkHasBillImageMapByVoucherCol(ctx, col).booleanValue()) {
                    throw new VoucherException(VoucherException.CAN_NOT_RESORT_NUMBER);
                }
                this.checkAllVoucherIsExistWorkFlow(ctx, col);
                if (hasVT && hasPeroid) {
                    if (vtCol != null && vtCol.size() > 0) {
                        for (VoucherTypeInfo vt : vtCol) {
                            int count;
                            voucherTypeId = vt.getId().toString();
                            VoucherCollection colWithVt = this.loadData(ctx, voucherTypeId, curPeriod.getId().toString(), companyId, false, sorters, sic);
                            boolean isControl = GlParam.getGlParams((Context)ctx, (String)"GL_VCH_POST_CONTROL", (String)companyId).getBoolean("GL_VCH_POST_CONTROL");
                            int sum = 0;
                            if (isControl) {
                                EntityViewInfo e = new EntityViewInfo();
                                e.setSelector(sic);
                                FilterInfo filter = new FilterInfo();
                                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                                filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)curPeriod.getId().toString()));
                                filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)voucherTypeId));
                                filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5), CompareType.EQUALS));
                                e.setFilter(filter);
                                VoucherCollection postColl = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(e);
                                sum = postColl.size();
                            }
                            if ((count = colWithVt.size()) <= 0) continue;
                            String[] number = this._getBatchNumber(ctx, count, sum + 1, (IObjectValue)vt, (IObjectValue)company);
                            ctx.put((Object)"isCheckNumberRepeated", (Object)Boolean.FALSE);
                            this._updateNumber(ctx, this.getSelectedValues(colWithVt, count, number));
                        }
                    }
                    break block14;
                }
                if (hasPeroid) {
                    int count = col.size();
                    if (count > 0) {
                        String[] number = this._getBatchNumber(ctx, count, 1, null, (IObjectValue)company);
                        ctx.put((Object)"resortNumber", (Object)"resortNumber");
                        this._updateNumber(ctx, this.getSelectedValues(col, count, number), 0, false);
                        ctx.remove((Object)"resortNumber");
                        String updateReq = "update T_CSL_Requisition set FNumber= replace(FNumber,'$123$','')  where fid in (select req.fid from T_CSL_Requisition as req inner join t_gl_voucher as voucher on req.FVoucherID = voucher.fid where  req.fnumber like '$123$%' and voucher.fperiodid='" + curPeriod.getId().toString() + "')";
                        DbUtil.execute((Context)ctx, (String)updateReq);
                    }
                    break block14;
                }
                throw new VoucherException(VoucherException.NOPERIODEXIST);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (null != mutex && null != mp) {
                    mutex.releaseMutex(mp.getRequestId());
                }
            }
        }
    }

    protected Map getSelectedValues(VoucherCollection col, int count, String[] number) throws BOSException, EASBizException {
        HashMap<String, String[]> numberMap = new HashMap<String, String[]>();
        for (int i = 0; i < count; ++i) {
            VoucherInfo voucher = col.get(i);
            String id = voucher.getId().toString();
            String newnumber = number[i];
            String oldNumber = voucher.getNumber();
            String[] numbermap = new String[]{newnumber, oldNumber, voucher.getVoucherType() == null ? "" : voucher.getVoucherType().getName()};
            numberMap.put(id, numbermap);
        }
        return numberMap;
    }

    @Override
    protected IObjectCollection _createVerifyAssistRecords(Context ctx, String accountId, String groupid, String currencyId, int count, String companyId) throws BOSException, EASBizException {
        VoucherInfo.DynamicColumnInfo colInfo;
        int i;
        String companyid = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String selectsql = "select top " + count + " cus.fvchassistrecordid ,cus.funholdedamtfor,cus.funholdedamtlocal,cus.funholdedamtrpt,cus.funholdedqty,cus.funholdedstdqty,cus.fid from t_gl_acctcussent cus \t\t\t\t\r\n inner join t_bd_accountview acct on acct.fid=cus.faccountid\t\t\t\t\t\t\t\t\r\n inner join t_bd_currency cur on cur.fid=cus.fcurrencyid\t\t\t\t\t\t\t\r\n inner join t_org_company com on com.fid=cus.fcompanyid\t\t\t\t\t\t\t\r\n inner join t_gl_voucherassistrecord record on record.fid=cus.fvchassistrecordid\t\t\t\t\r\n where cus.funholdedamtfor<>0 and acct.fid=? and cur.fid=? and com.fid=? \t\t\t  order by  record.fbizdate ,record.fbiznumber";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectsql.toString(), (Object[])new Object[]{accountId, currencyId, companyId});
        IVoucherAssistRecord recCtrl = VoucherAssistRecordFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("measureUnit.id"));
        sic.add(new SelectorItemInfo("measureUnit.number"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        Object[] info = VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchAssColumnInfo(accountId, groupid, null);
        VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
        VoucherInfo.DynamicColumnInfo[] propCols = (VoucherInfo.DynamicColumnInfo[])info[1];
        for (i = 0; i < assItemCols.length; ++i) {
            colInfo = assItemCols[i];
            sic.add(new SelectorItemInfo("assGrp." + colInfo.getMappingPropName() + ".number"));
            sic.add(new SelectorItemInfo("assGrp." + colInfo.getMappingPropName() + ".name"));
        }
        for (i = 0; i < propCols.length; ++i) {
            colInfo = propCols[i];
            if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)colInfo.getDataType())) {
                sic.add(new SelectorItemInfo(colInfo.getMappingPropName() + ".number"));
                sic.add(new SelectorItemInfo(colInfo.getMappingPropName() + ".name"));
                continue;
            }
            sic.add(new SelectorItemInfo(colInfo.getMappingPropName()));
        }
        VoucherAssistRecordCollection recCol = new VoucherAssistRecordCollection();
        try {
            int seq = 1;
            while (rs != null && rs.next()) {
                String vchassistrecord = rs.getString("fvchassistrecordid");
                FilterInfo filter = new FilterInfo();
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("id", (Object)vchassistrecord));
                view.setFilter(filter);
                VoucherAssistRecordInfo recordInfo = (VoucherAssistRecordInfo)recCtrl.getValue((IObjectPK)new ObjectUuidPK(vchassistrecord), sic);
                BigDecimal la = rs.getBigDecimal("funholdedamtlocal");
                BigDecimal oa = rs.getBigDecimal("funholdedamtfor");
                BigDecimal ra = rs.getBigDecimal("funholdedamtrpt");
                String cussent = rs.getString("fid");
                AcctCussentInfo acctCussentInfo = new AcctCussentInfo();
                acctCussentInfo.setId(BOSUuid.read((String)cussent));
                BigDecimal qa = rs.getBigDecimal("funholdedqty");
                BigDecimal sqa = rs.getBigDecimal("funholdedstdqty");
                recordInfo.setLocalAmount(la);
                recordInfo.setOriginalAmount(oa);
                recordInfo.setReportingAmount(ra);
                recordInfo.setId(null);
                recordInfo.setOprStatus(1);
                recordInfo.setVerifiedCussent(acctCussentInfo);
                recordInfo.setQuantity(qa);
                recordInfo.setStandardQuantity(sqa);
                recordInfo.setSeq(seq++);
                recCol.add(recordInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return recCol;
    }

    @Override
    protected boolean _updateNumber(Context ctx, Map numberMap, Map paramterMap) throws BOSException, EASBizException {
        if (paramterMap == null) {
            return false;
        }
        if (paramterMap != null) {
            ctx.put((Object)"isCheckNumberRepeated", (Object)((Boolean)paramterMap.get("isCheckNumberRepeated")));
        } else {
            ctx.put((Object)"isCheckNumberRepeated", (Object)Boolean.FALSE);
        }
        if (paramterMap.get("sourceType") != null && "1".equals(paramterMap.get("sourceType").toString())) {
            this.updateNumber(ctx, numberMap, 1);
        } else {
            this.updateNumber(ctx, numberMap);
        }
        return false;
    }

    private void updateVoucherNumber(Context ctx, Map numberMap, VoucherCollection voucherCol, int sourceType) throws BOSException, EASBizException {
        if (numberMap == null) {
            return;
        }
        LinkedHashMap<String, String[]> voucherMap = new LinkedHashMap<String, String[]>();
        boolean isCheckNumberRepeated = ctx.get((Object)"isCheckNumberRepeated") == null || (Boolean)ctx.get((Object)"isCheckNumberRepeated") != false;
        IGLGeneralFacade facade = null;
        if (isCheckNumberRepeated) {
            facade = GLGeneralFacadeFactory.getLocalInstance(ctx);
        } else {
            ctx.remove((Object)"isCheckNumberRepeated");
        }
        BOSObjectType bosType = new VoucherInfo().getBOSType();
        String strLogRes = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"vchResortNumber", (Locale)ctx.getLocale());
        String strLogMethod = this.getLogMethod(ctx, sourceType);
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        String updateSql = "update t_gl_voucher set fnumber=? where fid=?";
        Set idKeySet = numberMap.keySet();
        HashSet filterIdSet = new HashSet(idKeySet);
        for (String key : idKeySet) {
            String[] numbermap = (String[])numberMap.get(key);
            String newNumber = numbermap[0];
            String oldNumber = numbermap[1];
            String vchType = numbermap[2];
            String[] vchNumberMap = new String[]{oldNumber, newNumber};
            voucherMap.put(key, vchNumberMap);
            if (isCheckNumberRepeated) {
                VoucherInfo chkVoucherInfo = voucherCol.get((Object)BOSUuid.read((String)key));
                if (chkVoucherInfo == null) {
                    throw new BOSException("Get Voucher Error!");
                }
                Map<String, Object> param = new HashMap<String, Object>();
                param.put("voucherid", chkVoucherInfo.getId().toString());
                param.put("vouchertypeid", chkVoucherInfo.getVoucherType().getId().toString());
                param.put("period", chkVoucherInfo.getPeriod());
                param.put("number", newNumber);
                param.put("filterIdSet", filterIdSet);
                param.put("companyid", chkVoucherInfo.getCompany().getId().toString());
                param = facade.dealTask("getPreNumberRepeated", param);
                if (param != null) {
                    throw new VoucherException(VoucherException.VOUCHERNUMBERREPEAT);
                }
            }
            VoucherInfo voucherInfo = voucherCol.get((Object)BOSUuid.read((String)key));
            voucherInfo.setNumber(newNumber);
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{newNumber, key});
            filterIdSet.remove(key);
            String logDetail = MessageFormat.format(strLogRes, vchType + "-" + oldNumber, vchType + "-" + newNumber);
            IObjectPK logPk = LogUtil.beginLogWithDescription((Context)ctx, (String)strLogMethod, (BOSObjectType)bosType, null, (String)logDetail, (String)strLogMethod);
            logPkList.add(logPk);
        }
        VoucherUtil.modifyVoucherNumberBatch(ctx, voucherMap);
        Iterator it = logPkList.iterator();
        while (it.hasNext()) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)((IObjectPK)it.next()));
        }
    }

    private VoucherCollection getVoucherCollection(Context ctx, Map numberMap) throws BOSException {
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherCollection voucherCol = null;
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(VoucherInfo.getDefaultProcessSelector());
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        Set idKeySet = numberMap.keySet();
        int size = idKeySet.size();
        Iterator keyIterator = idKeySet.iterator();
        HashSet<String> tempIdSet = new HashSet<String>();
        while (keyIterator.hasNext()) {
            String id = (String)keyIterator.next();
            tempIdSet.add(id);
            if (tempIdSet.size() < 200 && keyIterator.hasNext()) continue;
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("id", tempIdSet, CompareType.INCLUDE));
            VoucherCollection col = iVoucher.getVoucherCollection(view);
            if (voucherCol == null) {
                voucherCol = new VoucherCollection();
            }
            voucherCol.addCollection(col);
            tempIdSet.clear();
        }
        return voucherCol;
    }

    private void recycleVoucherNumber(Context ctx, Map numberMap, VoucherCollection voucherCol) throws BOSException, EASBizException {
        HashMap<String, String> oldNumberMap = new HashMap<String, String>();
        HashMap<String, String> newNumberMap = new HashMap<String, String>();
        Set idKeySet = numberMap.keySet();
        HashSet filterIdSet = new HashSet(idKeySet);
        for (String id : idKeySet) {
            String[] numbermap = (String[])numberMap.get(id);
            String newNumber = numbermap[0];
            String oldNumber = numbermap[1];
            oldNumberMap.put(id, oldNumber);
            newNumberMap.put(newNumber, oldNumber);
        }
        Set keySet = oldNumberMap.keySet();
        Iterator it = keySet.iterator();
        VoucherInfo voucherInfo = null;
        IVoucher ivoucher = VoucherFactory.getLocalInstance((Context)ctx);
        while (it.hasNext()) {
            String key = (String)it.next();
            String number = (String)oldNumberMap.get(key);
            if (newNumberMap.containsKey(number)) continue;
            BOSUuid id = BOSUuid.read((String)key);
            voucherInfo = voucherCol.containsKey((Object)id) ? voucherCol.get((Object)id) : (VoucherInfo)ivoucher.getValue((IObjectPK)new ObjectUuidPK(key), VoucherInfo.getDefaultProcessSelector());
            voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            voucherInfo.setNumber(number);
            this.recycleVoucherId(ctx, voucherInfo, voucherInfo.getNumber());
        }
    }

    private void botpRewrite(final Context ctx, final VoucherCollection voucherCol) {
        Thread voucherReverseSaveThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                    int count = voucherCol.size();
                    for (int i = 0; i < count; ++i) {
                        VoucherInfo voucherInfo = voucherCol.get(i);
                        BOTRelationCollection botRelationCol = iBTPManager.getRelationCollection(voucherInfo.getId().toString());
                        BOTReverseManager botReverseManager = new BOTReverseManager(ctx);
                        botReverseManager.setOprtState(BOTBillOperStateEnum.EDIT);
                        VoucherCollection vcll = new VoucherCollection();
                        vcll.add(voucherInfo);
                        boolean hasReversed = false;
                        int total = botRelationCol.size();
                        for (int j = 0; j < total; ++j) {
                            try {
                                BOTRelationInfo botRelationInfo = botRelationCol.get(j);
                                hasReversed = botRelationInfo.isIsEffected();
                                BOTRelationCollection reBotRelaColl = new BOTRelationCollection();
                                reBotRelaColl.add(botRelationInfo);
                                botReverseManager.reverseWriteBatch((IObjectCollection)reBotRelaColl, (IObjectCollection)vcll, hasReversed);
                                continue;
                            }
                            catch (Exception e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Error while rewriting Botp!", (Throwable)ex);
                }
            }
        });
        voucherReverseSaveThread.start();
    }

    @Override
    protected IObjectValue _getDefaultAssistantHgInfo(Context ctx, IObjectPK accountPK) throws BOSException, EASBizException {
        return this._getDefaultAssistantHgInfo(ctx, accountPK, null);
    }

    public static AssistantHGInfo getAsstActObject(Context ctx, String companyId, String accountId, String asstAccountId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.defaultQueryName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.groupTableName"));
        sic.add(new SelectorItemInfo("asstActType.groupMappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.isForCompany"));
        sic.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
        sic.add(new SelectorItemInfo("asstActType.useLongNumber"));
        sic.add(new SelectorItemInfo("asstActType.permissionItem"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("seq"));
        AsstActGroupDetailCollection detailColl = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        VoucherInfo.DynamicColumnInfo[] assItemCols = null;
        AssistantHGInfo assistantHGInfo = new AssistantHGInfo();
        if (detailColl.size() > 0) {
            Object[] colInfo = VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchAssColumnInfo(accountId, asstAccountId, null);
            assItemCols = (VoucherInfo.DynamicColumnInfo[])colInfo[0];
            Iterator it = detailColl.iterator();
            boolean canGetAsst = false;
            while (it.hasNext()) {
                AsstActTypeDefaultInfo defalt;
                AsstActTypeInfo asstActTypeInfo = ((AsstActGroupDetailInfo)it.next()).getAsstActType();
                if (assistantHGInfo.get(asstActTypeInfo.getAsstHGAttribute()) != null || (defalt = (AsstActTypeDefaultInfo)AsstActTypeDefaultFactory.getLocalInstance((Context)ctx).getDefaultAcctItem(companyId, (IObjectValue)asstActTypeInfo)).getDefaultId() == null) continue;
                try {
                    DataBaseInfo data = GlUtils.findAsstActObject(asstActTypeInfo.getAsstHGAttribute(), defalt.getDefaultId().toString());
                    if (data instanceof GeneralAsstActTypeInfo) {
                        GeneralAsstActTypeInfo asst = (GeneralAsstActTypeInfo)data;
                        data.setString("displayLongNumber", asst.getLongNumber().replace("!", "."));
                    }
                    if (data == null) continue;
                    if ("bankAccount".equals(asstActTypeInfo.getAsstHGAttribute()) && ((AccountBankInfo)data).getAccount() != null) {
                        if (!accountId.equals(((AccountBankInfo)data).getAccount().getId().toString())) continue;
                        assistantHGInfo.put(asstActTypeInfo.getAsstHGAttribute(), (Object)data);
                        canGetAsst = true;
                        continue;
                    }
                    assistantHGInfo.put(asstActTypeInfo.getAsstHGAttribute(), (Object)data);
                    canGetAsst = true;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (canGetAsst && (assistantHGInfo = VoucherFacadeFactory.getLocalInstance((Context)ctx).confirmAssGrp(assistantHGInfo, asstAccountId, assItemCols)) != null && assistantHGInfo.getId() != null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("displayNameGroup"));
                selector.add(new SelectorItemInfo("longNameGroup"));
                for (int i = 0; i < detailColl.size(); ++i) {
                    AsstActTypeInfo asstActInfo = detailColl.get(i).getAsstActType();
                    String attribute = asstActInfo.getAsstHGAttribute();
                    selector.add(new SelectorItemInfo(attribute + ".id"));
                    selector.add(new SelectorItemInfo(attribute + ".number"));
                    selector.add(new SelectorItemInfo(attribute + ".name"));
                }
                String assgrpId = assistantHGInfo.getId().toString();
                assistantHGInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(assgrpId), selector);
                for (int i = 0; i < detailColl.size(); ++i) {
                    AsstActTypeInfo asstActInfo = detailColl.get(i).getAsstActType();
                    String attribute = asstActInfo.getAsstHGAttribute();
                    if (assistantHGInfo.get(attribute) == null) continue;
                    return assistantHGInfo;
                }
            }
        }
        return null;
    }

    @Override
    protected IObjectValue _getDefaultAssistantHgInfo(Context ctx, IObjectPK accountPK, String caaId) throws BOSException, EASBizException {
        if (caaId == null) {
            SelectorItemCollection sel = new SelectorItemCollection();
            sel.add("id");
            sel.add("CAA.id");
            AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo(accountPK, sel);
            if (account.getCAA() == null) {
                return null;
            }
            caaId = account.getCAA().getId().toString();
        }
        String sql = "select FASSGRPID from T_BD_ACCOUNTASSTDFTVALUE where FACCOUNTID = ? AND FAsstAccountID = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{accountPK.toString(), caaId});
        try {
            if (rowSet.next()) {
                AsstActGroupDetailCollection detailColl = this.getAsstActGroupDetailColl(ctx, caaId);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                for (int i = 0; i < detailColl.size(); ++i) {
                    AsstActTypeInfo asstActInfo = detailColl.get(i).getAsstActType();
                    String attribute = asstActInfo.getAsstHGAttribute();
                    selector.add(new SelectorItemInfo(attribute + ".id"));
                    selector.add(new SelectorItemInfo(attribute + ".number"));
                    selector.add(new SelectorItemInfo(attribute + ".name"));
                }
                String assgrpId = rowSet.getString("FASSGRPID");
                AssistantHGInfo assistantHGInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(assgrpId), selector);
                for (int i = 0; i < detailColl.size(); ++i) {
                    AsstActTypeInfo asstActInfo = detailColl.get(i).getAsstActType();
                    String attribute = asstActInfo.getAsstHGAttribute();
                    if (assistantHGInfo.get(attribute) == null) continue;
                    return assistantHGInfo;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private AsstActGroupDetailCollection getAsstActGroupDetailColl(Context ctx, IObjectPK accountPK) throws BOSException, EASBizException {
        AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo(accountPK);
        if (account.getCAA() == null) {
            return null;
        }
        return this.getAsstActGroupDetailColl(ctx, account.getCAA().getId().toString());
    }

    private AsstActGroupDetailCollection getAsstActGroupDetailColl(Context ctx, String caa) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("asstActType.id");
        evi.getSelector().add("asstActType.number");
        evi.getSelector().add("asstActType.name");
        evi.getSelector().add("asstActType.asstHGAttribute");
        evi.getSelector().add("asstActType.mappingFieldName");
        evi.getSelector().add("asstActType.defaultQueryName");
        evi.getSelector().add("asstActType.isForCompany");
        evi.getSelector().add("asstActType.defaultF7UI");
        evi.getSelector().add("asstActType.glAsstActTypeGrp.id");
        evi.getSelector().add("asstActType.isMultilevel");
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)caa));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection newasstcol = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(evi);
        return newasstcol;
    }

    private IObjectValue getCodingRuleVo(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        CodingRuleInfo codingruleVo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
        if (codingruleVo == null) {
            IMetaDataLoader metaLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo eo = metaLoader.getEntity(voucherInfo.getBOSType());
            throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{eo.getAlias()});
        }
        return codingruleVo;
    }

    private boolean hasAttributeInCodingRule(CodingRuleInfo codingRule, String attribute, boolean isEqual) throws BOSException, EASBizException {
        if (codingRule != null && codingRule.getCodingRuleEntrys().size() > 0) {
            for (int i = 0; i < codingRule.getCodingRuleEntrys().size(); ++i) {
                if (codingRule.getCodingRuleEntrys().get(i).getValueAttribute() == null || (!isEqual || !codingRule.getCodingRuleEntrys().get(i).getValueAttribute().equals(attribute)) && (isEqual || !codingRule.getCodingRuleEntrys().get(i).getValueAttribute().startsWith(attribute))) continue;
                return true;
            }
        }
        return false;
    }

    private VoucherInfo getVoucherInfo(Context ctx, IObjectValue type) throws BOSException, EASBizException {
        VoucherTypeCollection col;
        IObjectValue ttype = type;
        CompanyOrgUnitInfo companyOrg = ContextUtil.getCurrentFIUnit((Context)ctx);
        VoucherInfo voucherInfo = new VoucherInfo();
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        voucherInfo.setCompany(companyOrg);
        if (type == null && (col = GlUtils.getVoucherTypeCollection(ctx, null, companyOrg.getCU().getId().toString())).size() > 0) {
            type = col.get(0);
        }
        PeriodInfo period = GlUtils.getCurrentPeriod(ctx, companyOrg.getId().toString());
        voucherInfo.setVoucherType((VoucherTypeInfo)ttype);
        voucherInfo.setPeriod(period);
        voucherInfo.setBookedDate(period.getBeginDate());
        voucherInfo.setCU(companyOrg.getCU());
        return voucherInfo;
    }

    protected boolean _updateNumber(Context ctx, Map numberMap, int sourceType, boolean checkNumberDup) throws BOSException, EASBizException {
        if (numberMap == null || numberMap.isEmpty()) {
            return false;
        }
        VoucherCollection voucherCol = new VoucherCollection();
        VoucherCollection voucherColBotp = new VoucherCollection();
        BOSObjectType bosType = new VoucherInfo().getBOSType();
        String strLogRes = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"vchResortNumber", (Locale)ctx.getLocale());
        String strLogMethod = this.getLogMethod(ctx, sourceType);
        HashMap voucherMap = new HashMap();
        Set idKeySet = numberMap.keySet();
        HashSet filterIdSet = new HashSet(idKeySet);
        Iterator keyIterator = idKeySet.iterator();
        while (keyIterator.hasNext()) {
            Map param;
            String updateSql = "update t_gl_voucher set fnumber=? where fid=?";
            String id = (String)keyIterator.next();
            String[] numbermap = (String[])numberMap.get(id);
            String newNumber = numbermap[0];
            String oldNumber = numbermap[1];
            String vchType = numbermap[2];
            String logDetail = MessageFormat.format(strLogRes, vchType + "-" + oldNumber, vchType + "-" + newNumber);
            IObjectPK logPk = LogUtil.beginLogWithDescription((Context)ctx, (String)strLogMethod, (BOSObjectType)bosType, null, (String)logDetail, (String)strLogMethod);
            VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(id), VoucherInfo.getDefaultProcessSelector());
            if (checkNumberDup && (param = this.checkNumber(ctx, voucherInfo, newNumber, filterIdSet)) != null) {
                throw new VoucherException(VoucherException.VOUCHERNUMBERREPEAT);
            }
            voucherInfo.setNumber(newNumber);
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{newNumber, id});
            String bgSql = "update T_BG_BgCtrlRecord set  FBillNumber=? where FBillId=?";
            DbUtil.execute((Context)ctx, (String)bgSql, (Object[])new Object[]{newNumber, id});
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
            filterIdSet.remove(id);
            VoucherUtil.midifyVoucherNumber(ctx, id, oldNumber, newNumber);
            voucherCol.add(voucherInfo);
            voucherColBotp.add((VoucherInfo)voucherInfo.clone());
        }
        boolean isHand = GlUtils.getVoucherHandParam(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        if (!isHand) {
            this.recycleVoucherNumber(ctx, numberMap, voucherCol);
        }
        this.botpRewrite(ctx, voucherColBotp);
        return true;
    }

    private Map checkNumber(Context ctx, VoucherInfo voucherInfo, String number, Set filterIdSet) throws BOSException, EASBizException {
        Map<String, Object> param = new HashMap<String, Object>();
        if (voucherInfo.getId() != null) {
            param.put("voucherid", voucherInfo.getId().toString());
        }
        param.put("vouchertypeid", voucherInfo.getVoucherType().getId().toString());
        param.put("period", voucherInfo.getPeriod());
        param.put("number", number);
        param.put("companyid", voucherInfo.getCompany().getId().toString());
        param.put("filterIdSet", filterIdSet);
        IGLGeneralFacade facade = GLGeneralFacadeFactory.getLocalInstance(ctx);
        param = facade.dealTask("getPreNumberRepeated", param);
        return param;
    }

    private IObjectCollection loadData(Context ctx, String period, SorterItemCollection s) throws BOSException, EASBizException {
        String comid = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = evi.getSelector();
        this.setSelector(selectorItemCollection);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)comid));
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period));
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
        evi.setFilter(filter);
        SorterItemCollection sorters = evi.getSorter();
        if (s == null) {
            sorters.add(new SorterItemInfo("number"));
        } else {
            sorters.addObjectCollection((IObjectCollection)s.getSorter());
        }
        return VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(evi);
    }

    private void checkAllVoucherIsExistWorkFlow(Context ctx, VoucherCollection col) throws EASBizException, BOSException {
        if (!this.ischeckVoucherExistWorkFlow) {
            int count = 0;
            StringBuilder errorNumSb = new StringBuilder();
            if (col != null && col.size() > 0) {
                for (VoucherInfo vi : col) {
                    if (!GlUtils.isRunningWorkflow(ctx, vi.getId().toString())) continue;
                    ++count;
                    errorNumSb.append("\n\r");
                    errorNumSb.append(vi.getNumber());
                }
            }
            if (count > 0) {
                String msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"not_allow_resort_number", (Locale)ctx.getLocale()), count, errorNumSb.toString());
                throw new EASBizException(new NumericExceptionSubItem("1", msg));
            }
            this.ischeckVoucherExistWorkFlow = true;
        }
    }

    private Boolean checkHasBillImageMapByVoucherCol(Context ctx, VoucherCollection col) throws BOSException {
        boolean result = false;
        if (col != null && col.size() > 0) {
            int size = col.size();
            for (int cu = 0; cu < size; cu += 500) {
                StringBuffer strFilter = new StringBuffer();
                ArrayList<String> paramSet = new ArrayList<String>();
                paramSet.add("0");
                int j = 0;
                while (500 - j++ > 0 && cu < size) {
                    String id = col.get(cu).getId().toString();
                    if (j > 1) {
                        strFilter.append(",");
                    }
                    paramSet.add(id);
                    strFilter.append("?");
                    ++cu;
                }
                StringBuffer sql = new StringBuffer();
                sql.append("select fid from t_wsc_billimagemap  where fimagestate <> ? and fbillid in (");
                sql.append(strFilter);
                sql.append(")");
                try {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramSet.toArray());
                    if (!rs.next()) continue;
                    result = true;
                    break;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    throw new BOSException("SQL ERROR!", (Throwable)e);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new BOSException("SQL ERROR!", (Throwable)e);
                }
            }
        }
        return result;
    }
}

