/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTypeEnum;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.AbstractVoucherImpExpFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.framework.SystemEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class VoucherImpExpFacadeControllerBean
extends AbstractVoucherImpExpFacadeControllerBean {
    @Override
    protected Collection _getInitData(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        Object[] param = new Object[]{orgUnitId};
        ArrayList<Object> result = new ArrayList<Object>(5);
        CompanyOrgUnitInfo company = InitHelp.getCurrentCompany(ctx, orgUnitId);
        result.add(company);
        PeriodInfo period = this.getCurrentPeriod(ctx, company);
        result.add(period);
        Map hmParamValue = InitHelp.getInitParam(ctx, company);
        result.add(hmParamValue.get("GL_008"));
        result.add(hmParamValue.get("G001"));
        result.add(hmParamValue.get("GL_111"));
        return result;
    }

    private PeriodInfo getCurrentPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo p = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        return p;
    }

    @Override
    protected Map _getReportExrate(Context ctx, Set currencyIds, Map otherCtx) throws BOSException, EASBizException {
        HashMap<String, VoucherInfo.ExchangeRateWithValue> result = new HashMap<String, VoucherInfo.ExchangeRateWithValue>();
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        PeriodInfo currentPeriod = (PeriodInfo)otherCtx.get("CURRENTPERIOD");
        if (currentPeriod == null) {
            currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)curCompany);
        }
        String repCur = curCompany.getReportCurrency().getId().toString();
        String repTable = curCompany.getReportExchangeTable().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("exchangeAux.exchangeTable.id"));
        sic.add(new SelectorItemInfo("exchangeAux.targetCurrency.id"));
        sic.add(new SelectorItemInfo("exchangeAux.convertMode"));
        sic.add(new SelectorItemInfo("exchangeAux.exchangeRateType"));
        sic.add(new SelectorItemInfo("exchangeAux.precision"));
        sic.add(new SelectorItemInfo("convertRate"));
        sic.add(new SelectorItemInfo("availTime"));
        sic.add(new SelectorItemInfo("invalidTime"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)repTable));
        fic.add(new FilterItemInfo("exchangeAux.sourceCurrency.id", (Object)currencyIds, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)repCur));
        fic.add(new FilterItemInfo("availTime", (Object)currentPeriod.getEndDate(), CompareType.LESS_EQUALS));
        filter.setMaskString("#0 AND #1 AND #2 and #3");
        IExchangeRate exCtrl = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateCollection exCol = exCtrl.getExchangeRateCollection(view);
        HashMap<String, Date> cache = new HashMap<String, Date>();
        Date date = null;
        VoucherInfo.ExchangeRateWithValue rex = null;
        for (ExchangeRateInfo ex : exCol) {
            ExchangeAuxInfo aux = ex.getExchangeAux();
            String cur = aux.getSourceCurrency().get("id").toString();
            ExchangeTypeEnum type = aux.getExchangeRateType();
            Date availTime = ex.getAvailTime();
            ConvertModeEnum cm = aux.getConvertMode();
            BigDecimal rate = ex.getConvertRate();
            rex = new VoucherInfo.ExchangeRateWithValue(type, cm, rate);
            date = (Date)cache.get(cur);
            if (date != null && availTime.compareTo(date) <= 0) continue;
            cache.put(cur, availTime);
            result.put(cur, rex);
        }
        return result;
    }

    @Override
    protected IObjectCollection _exportVoucher(Context ctx) throws BOSException {
        return null;
    }
}

