/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.IVoucherType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FeeTypeEnum;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeInfo;
import com.kingdee.eas.fi.gl.AsstDataInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAssistCustomizedProperty;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.fi.gl.app.AbstractVoucherLeadControlControllerBean;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class VoucherLeadControlControllerBean
extends AbstractVoucherLeadControlControllerBean {
    private static final long serialVersionUID = 7465816167290078867L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.VoucherLeadControlControllerBean");
    private static final String EXP_RES_NAME = "com.kingdee.eas.fi.gl.VoucherinputResource";
    private static final String ImpVoucherListCache = "ImpVoucherListCache";

    @Override
    protected ArrayList _getAsstData(Context ctx, String CUID, String accounttableid) throws BOSException {
        String fname = "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String sql = "select A.Fnumber Fnumber,A." + fname + " FName from t_bd_asstacttype A inner join T_ORG_CtrlUnit D on D.FID=? inner join T_ORG_CtrlUnit E on E.FID=A.FControlUnitID and CHARINDEX(E.FLongNumber,D.FLongNumber)=1 order by Fnumber";
        ArrayList<AsstDataInfo> lists = new ArrayList<AsstDataInfo>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{CUID});
        sql = "select Fnumber," + fname + " FName from T_GL_AssistCustomizedType order by fnumber";
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            AsstDataInfo info;
            while (rs.next()) {
                info = new AsstDataInfo();
                info.setCustom(false);
                info.setAsstacttypefname(rs.getString("FName"));
                info.setAsstacttypenumber(rs.getString("Fnumber"));
                lists.add(info);
            }
            while (rs1.next()) {
                info = new AsstDataInfo();
                info.setAsstacttypefname(rs1.getString("FName"));
                info.setAsstacttypenumber(rs1.getString("Fnumber"));
                info.setCustom(true);
                lists.add(info);
            }
        }
        catch (SQLException err) {
            throw new BOSException((Throwable)err);
        }
        return lists;
    }

    @Override
    protected AsstDataInfo _getAsstDataInfo(Context ctx, String acttypenumber, String accountID, String CUID, String accounttableid) throws BOSException {
        AsstDataInfo info = null;
        String fname = "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String sql = "select distinct top 1 b.fid,d.fid as asstactid,fcaa fcaa,b.fnumber asstFnumber,b." + fname + " as asstFname,d.fnumber asstacttypenumber ,d." + fname + " as  asstacttypefname,d.FRealtionDataObject as  RealtionDataObject, d.fMappingFieldName as  MappingFieldName ,d.fassthgattribute  as fassthgattribute  from t_bd_accountview  a  inner join t_bd_asstaccount b on a.fcaa=b.fid  inner join t_bd_asstactgroupdetail c on c.fasstaccountid=b.fid  inner join t_bd_asstacttype d on d.fid=c.fasstacttypeid where a.fid=? and  d.fnumber=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{accountID, acttypenumber});
        try {
            while (rs.next()) {
                info = new AsstDataInfo();
                info.setAsstID(rs.getString("fid"));
                info.setAsstacttypeID(rs.getString("asstactid"));
                info.setAsstFname(rs.getString("asstFname"));
                info.setAsstacttypefname(rs.getString("asstacttypefname"));
                info.setMappingFieldName(rs.getString("MappingFieldName"));
                info.setRealtionDataObject(rs.getString("RealtionDataObject"));
                info.setAsstnumber(rs.getString("asstFnumber"));
                info.setAsstacttypenumber(rs.getString("asstacttypenumber"));
                info.setFassthgattribute(rs.getString("fassthgattribute"));
            }
        }
        catch (SQLException err) {
            throw new BOSException((Throwable)err);
        }
        return info;
    }

    @Override
    protected String _getAsstinfo(Context ctx, Map param) throws BOSException {
        String fid;
        block20: {
            Object actType = param.get("actType");
            String numbers = param.get("numbers").toString();
            String companyNum = ContextUtil.getCurrentFIUnit((Context)ctx).getNumber();
            fid = null;
            try {
                StringBuffer sql = new StringBuffer();
                if (actType instanceof AsstActTypeInfo) {
                    Object[] params;
                    AsstActTypeInfo actTypeInfo = (AsstActTypeInfo)actType;
                    String RealtionDataObject = actTypeInfo.getRealtionDataObject();
                    String assthg = actTypeInfo.getAsstHGAttribute();
                    if (actTypeInfo.getGlAsstActTypeGrp() != null) {
                        if (actTypeInfo.isUseLongNumber()) {
                            sql.append("select top 2 fid, fnumber from " + RealtionDataObject + "  where flongnumber=? and fgroupid='" + actTypeInfo.getGlAsstActTypeGrp().getId() + "'");
                            numbers = numbers.replace('.', '!');
                        } else {
                            sql.append("select top 2 fid, fnumber from " + RealtionDataObject + "  where fnumber=? and fgroupid='" + actTypeInfo.getGlAsstActTypeGrp().getId() + "'");
                        }
                    } else if (assthg.equals("customer") || assthg.equals("provider") || assthg.equals("material") || assthg.equals("costOrg")) {
                        sql.append("select top 2 fid, fnumber from " + RealtionDataObject + "  where (fnumber=? or fnumber=?) ");
                    } else {
                        sql.append("select top 2 fid, fnumber from " + RealtionDataObject + "  where fnumber=?");
                    }
                    String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                    if (RealtionDataObject.equalsIgnoreCase("T_BD_Customer")) {
                        sql.append(" and (FusedStatus = 1 AND (FadminCUid = ? OR Fid IN (SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE (FBOSObjectType = 'BF0C040E' AND FAssignCUID = ?))))");
                        params = new Object[]{numbers, companyNum + numbers, cuId, cuId};
                    } else if (RealtionDataObject.equalsIgnoreCase("T_BD_Supplier")) {
                        sql.append(" and (FusedStatus = 1 AND (FadminCUid = ? OR Fid IN (SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE (FBOSObjectType = '37C67DFC' AND FAssignCUID = ?))))");
                        params = new Object[]{numbers, companyNum + numbers, cuId, cuId};
                    } else if (RealtionDataObject.equalsIgnoreCase("T_ORG_Admin")) {
                        sql.append(" and fisleaf=1 ");
                        params = new Object[]{numbers};
                    } else if (RealtionDataObject.startsWith("T_ORG_")) {
                        sql.append(" and fisbizunit=1 ");
                        params = assthg.equals("costOrg") ? new Object[]{numbers, companyNum + numbers} : new Object[]{numbers};
                    } else {
                        params = assthg.equals("material") ? new Object[]{numbers, companyNum + numbers} : new Object[]{numbers};
                    }
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
                    while (rs.next()) {
                        fid = rs.getString("fid");
                        if (!numbers.equals(rs.getString("fnumber"))) continue;
                        break block20;
                    }
                    break block20;
                }
                String mappingpropname = actType.toString();
                sql.setLength(0);
                sql.append("select top 1 FDatatableName from T_GL_AssistCustomizedType where fmappingpropname='" + mappingpropname + "'");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs.next()) {
                    String tableName = rs.getString("FDatatableName");
                    sql.setLength(0);
                    sql.append("select top 1 fid from " + tableName + "  where fnumber='" + numbers + "'");
                    IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    if (rs1.next()) {
                        fid = rs1.getString("fid");
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return fid;
    }

    @Override
    protected IObjectValue _getAcctCussentInfo(Context ctx, Map param) throws BOSException {
        AcctCussentInfo info = new AcctCussentInfo();
        String unHoldedAmtFor = param.get("unHoldedAmtFor").toString();
        String bizNumber = "";
        if (param.get("bizNumber") != null) {
            bizNumber = param.get("bizNumber").toString();
        }
        String currencyID = param.get("currency").toString();
        String accountId = param.get("Account").toString();
        String hgID = param.get("hgID").toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 cust.FID,vast.FendDate \n from t_gl_VoucherAssistRecord vast \n join t_GL_AcctCussent cust").append("\n on cust.FVchAssistRecordID = vast.fid").append("\n and cust.funholdedamtfor>=").append(unHoldedAmtFor).append(" and vast.fbizNumber='").append(bizNumber).append("'").append(" and cust.fcurrencyId='").append(currencyID).append("'").append("and cust.faccountid='").append(accountId).append("' and vast.fassgrpid='").append(hgID).append("'");
        sql.append(" order by vast.FbizDate");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setBizDate((Date)rs.getDate("FendDate"));
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    private static void addSet(Set set, Object value) {
        if (value == null || "".equals(value.toString().trim())) {
            return;
        }
        set.add(value);
    }

    @Override
    protected IObjectPK[] _saveVoucher(Context ctx) throws BOSException, EASBizException {
        if (ctx.get((Object)ImpVoucherListCache) != null) {
            VoucherCollection voucherCol = (VoucherCollection)ctx.get((Object)ImpVoucherListCache);
            IObjectPK[] pks = new IObjectPK[voucherCol.size()];
            VoucherInfo info = null;
            IObjectPK pk = null;
            int count = voucherCol.size();
            for (int i = 0; i < count; ++i) {
                info = voucherCol.get(i);
                if (info.getBizDate() == null) {
                    info.setBizDate(new Date());
                }
                pks[i] = pk = VoucherFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
            }
            ctx.remove((Object)ImpVoucherListCache);
            return pks;
        }
        return null;
    }

    @Override
    protected void _cleanCache(Context ctx) throws BOSException {
        if (ctx.get((Object)ImpVoucherListCache) != null) {
            ctx.remove((Object)ImpVoucherListCache);
        }
    }

    @Override
    protected Map _createVoucher(Context ctx, WSVoucherCollection wsVoucherCol) throws BOSException, EASBizException {
        this._cleanCache(ctx);
        HashMap<String, String> returnMap = new HashMap<String, String>();
        StringBuffer msg = new StringBuffer();
        VoucherCollection voucherlist = new VoucherCollection();
        VoucherEntryCollection entrys = null;
        VoucherAssistRecordCollection assistrecords = null;
        VoucherInfo voucher = null;
        VoucherEntryInfo entry = null;
        VoucherAssistRecordInfo assistrecord = null;
        HashMap<String, VoucherInfo> voucherMap = null;
        HashSet<String> voucherSet = new HashSet<String>();
        HashMap<String, VoucherEntryInfo> voucherentryMap = null;
        HashSet<String> voucherentrySet = new HashSet<String>();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        ObjectUuidPK comPK = new ObjectUuidPK(company.getId());
        company = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)comPK, sic);
        Map accountViewInfoMap = null;
        HashSet accountNumbers = new HashSet();
        Map periodMap = null;
        HashSet bookDates = new HashSet();
        Map currencyInfoMap = null;
        HashSet currencyNumbers = new HashSet();
        Map voucherTypeInfoMap = null;
        HashSet vchTypeNumbers = new HashSet();
        Map settlementTypeInfoMap = null;
        HashSet settlementTypeNumbers = new HashSet();
        Map handlerInfoMap = null;
        HashSet handlerNumbers = new HashSet();
        Map materialInfoMap = null;
        HashSet materialNumbers = new HashSet();
        Map orgUnitInfoMap = null;
        HashSet orgUnitNumbers = new HashSet();
        Map supplierInfoMap = null;
        HashSet supplierNumbers = new HashSet();
        Map customerInfoMap = null;
        HashSet customerNumbers = new HashSet();
        Object asstInfoMap = null;
        HashSet<String> asstNumbers = new HashSet<String>();
        Map asstActTypeByGroupMap = new HashMap();
        HashSet<String> caaIds = new HashSet<String>();
        Map accountPropertyMap = new HashMap();
        HashSet<String> accountIds = new HashSet<String>();
        HashMap<String, IObjectValue> hgAsstActTypeMap = new HashMap<String, IObjectValue>();
        HashMap<String, IObjectValue> hgMap = new HashMap<String, IObjectValue>();
        PeriodInfo curPeriod = this.getCurrentPeriod(ctx);
        VoucherTypeInfo defaultType = null;
        VoucherTypeCollection vtCol = GlUtils.getVoucherTypeCollection(ctx, null, company.getCU().getId().toString());
        defaultType = vtCol.get(0);
        for (VoucherTypeInfo vt : vtCol) {
            if (!vt.isPretermit()) continue;
            defaultType = vt;
        }
        for (int i = 0; i < wsVoucherCol.size(); ++i) {
            WSVoucherInfo wsvoucher = wsVoucherCol.get(i);
            if (wsvoucher == null) continue;
            if ((wsvoucher.getVoucherType() == null || "".equals(wsvoucher.getVoucherType().trim())) && defaultType != null) {
                wsvoucher.setVoucherType(defaultType.getNumber());
            }
            voucherSet.add(wsvoucher.getVoucherType() + "_" + wsvoucher.getVoucherNumber());
            voucherentrySet.add(wsvoucher.getVoucherType() + "_" + wsvoucher.getVoucherNumber() + "_" + wsvoucher.getEntrySeq());
            VoucherLeadControlControllerBean.addSet(accountNumbers, wsvoucher.getAccountNumber());
            VoucherLeadControlControllerBean.addSet(bookDates, wsvoucher.getBookedDate());
            VoucherLeadControlControllerBean.addSet(currencyNumbers, wsvoucher.getCurrencyNumber());
            VoucherLeadControlControllerBean.addSet(vchTypeNumbers, wsvoucher.getVoucherType());
            VoucherLeadControlControllerBean.addSet(settlementTypeNumbers, wsvoucher.getSettlementType());
            VoucherLeadControlControllerBean.addSet(handlerNumbers, wsvoucher.get("handler"));
            VoucherLeadControlControllerBean.addSet(materialNumbers, wsvoucher.get("material"));
            VoucherLeadControlControllerBean.addSet(orgUnitNumbers, wsvoucher.get("orgUnit"));
            VoucherLeadControlControllerBean.addSet(supplierNumbers, wsvoucher.get("supplier"));
            VoucherLeadControlControllerBean.addSet(customerNumbers, wsvoucher.get("customer"));
            int assistCount = (Integer)wsvoucher.get("assistCount");
            for (int j = 1; j <= assistCount; ++j) {
                asstNumbers.add((String)wsvoucher.get("asstActType" + j) + "_" + (String)wsvoucher.get("asstActNumber" + j));
            }
        }
        voucherMap = new HashMap<String, VoucherInfo>();
        Iterator it = voucherSet.iterator();
        while (it.hasNext()) {
            voucherMap.put((String)it.next(), null);
        }
        voucherentryMap = new HashMap<String, VoucherEntryInfo>();
        Iterator entryit = voucherSet.iterator();
        while (entryit.hasNext()) {
            voucherentryMap.put((String)entryit.next(), null);
        }
        accountViewInfoMap = VoucherLeadControlControllerBean.getAccountViewInfoMap(ctx, accountNumbers);
        periodMap = VoucherLeadControlControllerBean.getPeriodMap(ctx, bookDates);
        currencyInfoMap = VoucherLeadControlControllerBean.getCurrencyInfoMap(ctx, currencyNumbers);
        voucherTypeInfoMap = VoucherLeadControlControllerBean.getVoucherTypeInfoMap(ctx, vchTypeNumbers);
        settlementTypeInfoMap = VoucherLeadControlControllerBean.getSettlementTypeInfoMap(ctx, settlementTypeNumbers);
        handlerInfoMap = VoucherLeadControlControllerBean.getHandlerInfoMap(ctx, handlerNumbers);
        materialInfoMap = VoucherLeadControlControllerBean.getMaterialInfoMap(ctx, materialNumbers);
        orgUnitInfoMap = VoucherLeadControlControllerBean.getOrgUnitInfoMap(ctx, orgUnitNumbers);
        supplierInfoMap = VoucherLeadControlControllerBean.getSupplierInfoMap(ctx, supplierNumbers);
        customerInfoMap = VoucherLeadControlControllerBean.getCustomerInfoMap(ctx, customerNumbers);
        Iterator accountit = accountViewInfoMap.keySet().iterator();
        while (accountit.hasNext()) {
            AccountViewInfo _account = (AccountViewInfo)accountViewInfoMap.get(accountit.next());
            if (_account != null && _account.getCAA() != null && _account.getCAA().getId() != null) {
                caaIds.add(_account.getCAA().getId().toString());
            }
            if (_account == null) continue;
            accountIds.add(_account.getId().toString());
        }
        asstActTypeByGroupMap = VoucherLeadControlControllerBean.getAsstActTypeByGroupMap(ctx, caaIds);
        accountPropertyMap = VoucherLeadControlControllerBean.getAccountPropertyMap(ctx, accountIds);
        for (int i = 0; i < wsVoucherCol.size(); ++i) {
            CurrencyInfo currency;
            boolean rowError = false;
            WSVoucherInfo wsvoucher = wsVoucherCol.get(i);
            String key = wsvoucher.getVoucherType() + "_" + wsvoucher.getVoucherNumber();
            if (voucherMap.get(key) == null) {
                PeriodInfo period;
                voucher = new VoucherInfo();
                voucher.setCompany(company);
                voucher.setSourceSys(SystemEnum.GENERALLEDGER);
                voucher.setSourceType(SourceType.OTHER_IMPORT);
                boolean isAC = (Boolean)wsvoucher.get("IsAC");
                voucher.setIsAC(isAC);
                Date bookeddate = wsvoucher.getBookedDate();
                if (bookeddate == null) {
                    bookeddate = new Date();
                    if (bookeddate.before(curPeriod.getBeginDate())) {
                        bookeddate = curPeriod.getBeginDate();
                    } else if (bookeddate.after(curPeriod.getEndDate())) {
                        bookeddate = curPeriod.getEndDate();
                    }
                    period = curPeriod;
                } else {
                    period = (PeriodInfo)periodMap.get(bookeddate);
                }
                voucher.setBookedDate(bookeddate);
                if (period != null) {
                    voucher.setPeriod(period);
                } else {
                    rowError = true;
                    msg.append(GLResUtil.getRes("voucher_index")).append(i + 1).append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"353_VoucherLeadControlControllerBean", (Locale)ctx.getLocale())).append(new VoucherException(VoucherException.BOOKEDDATENOTPERIOD).getMessage()).append("\n");
                }
                voucher.setBizDate(wsvoucher.getBizDate());
                if (voucher.getBizDate() == null) {
                    voucher.setBizDate(bookeddate);
                } else if (voucher.getBizDate().after(voucher.getBookedDate())) {
                    this.getMsg(ctx, msg, i + 1, "com.kingdee.eas.fi.gl.GLAutoGenerateResource", "157_VoucherLeadControlImportUI", "");
                }
                voucher.setAttachments(wsvoucher.getAttaches());
                voucher.setDescription(wsvoucher.getDescription());
                if (wsvoucher.get("number") != null && !"".equals(wsvoucher.get("number").toString().trim())) {
                    voucher.setNumber(wsvoucher.get("number").toString());
                }
                voucher.setLocalDebitAmount((BigDecimal)wsvoucher.get("localDebitAmount"));
                voucher.setLocalCreditAmount((BigDecimal)wsvoucher.get("localCreditAmount"));
                voucher.setReportingDebitAmount((BigDecimal)wsvoucher.get("reportingDebitAmount"));
                voucher.setReportingCreditAmount((BigDecimal)wsvoucher.get("reportingCreditAmount"));
                VoucherTypeInfo vcheType = (VoucherTypeInfo)voucherTypeInfoMap.get(wsvoucher.getVoucherType());
                if (vcheType == null) {
                    rowError = true;
                    this.getMsg(ctx, msg, i + 1, "voucherTypeNot");
                }
                voucher.setVoucherType(vcheType);
                if (!rowError) {
                    voucherlist.add(voucher);
                    voucherMap.put(key, voucher);
                }
            } else {
                voucher = (VoucherInfo)voucherMap.get(key);
            }
            entrys = voucher.getEntries();
            String entrykey = key + "_" + wsvoucher.getEntrySeq();
            String accountNumber = wsvoucher.getAccountNumber();
            String currencyNumber = wsvoucher.getCurrencyNumber();
            int entryDC = wsvoucher.getEntryDC();
            AccountViewInfo account = (AccountViewInfo)accountViewInfoMap.get(accountNumber);
            if (account == null) {
                rowError = true;
                this.getMsg(ctx, msg, i + 1, "accountNot");
            }
            if ((currency = (CurrencyInfo)currencyInfoMap.get(currencyNumber)) == null) {
                rowError = true;
                this.getMsg(ctx, msg, i + 1, "currencyNot");
            }
            boolean isFirstEntry = true;
            if (voucherentryMap.get(entrykey) == null) {
                isFirstEntry = true;
                entry = new VoucherEntryInfo();
                voucherentryMap.put(entrykey, entry);
                entry.setSeq(wsvoucher.getEntrySeq());
                entry.setDescription((String)wsvoucher.get("VoucherEntrydescription"));
                entry.setAccount(account);
                entry.setCurrency(currency);
                entry.setLocalExchangeRate(new BigDecimal(wsvoucher.getLocalRate()));
                entry.setReportingExchangeRate(wsvoucher.getBigDecimal("VoucherEntryreportingExchangeRate"));
                entry.setEntryDC(EntryDC.getEnum((int)entryDC));
                entry.setLocalAmount(wsvoucher.getBigDecimal("VoucherEntrylocalAmount"));
                entry.setOriginalAmount(wsvoucher.getBigDecimal("VoucherEntryoriginalAmount"));
                entry.setReportingAmount(wsvoucher.getBigDecimal("VoucherEntryoriginalAmount"));
                if (!rowError) {
                    entrys.add(entry);
                }
            } else {
                int preEntryDC;
                isFirstEntry = false;
                entry = (VoucherEntryInfo)voucherentryMap.get(entrykey);
                if (entry.getAccount() != null) {
                    String preaccountNumber = entry.getAccount().getNumber();
                    if (accountNumber != null && !accountNumber.equals(preaccountNumber)) {
                        rowError = true;
                        this.getMsg(ctx, msg, i + 1, "accountError");
                    }
                }
                if (entry.getCurrency() != null) {
                    String preCurrencyNumber = entry.getCurrency().getNumber();
                    if (currencyNumber != null && !currencyNumber.equals(preCurrencyNumber)) {
                        rowError = true;
                        this.getMsg(ctx, msg, i + 1, "com.kingdee.eas.fi.gl.GLAutoGenerateResource", "146_VoucherLeadControlImportUI");
                    }
                }
                if (entry.getEntryDC() != null && entryDC != (preEntryDC = entry.getEntryDC().getValue())) {
                    rowError = true;
                    this.getMsg(ctx, msg, i + 1, "DCError");
                }
            }
            if (account != null && (account.getCAA() != null || account.isHasUserProperty())) {
                assistrecords = entry.getAssistRecords() == null ? new VoucherAssistRecordCollection() : entry.getAssistRecords();
                assistrecord = new VoucherAssistRecordInfo();
                assistrecord.setOriginalAmount(wsvoucher.getBigDecimal("VoucherAssistlocalAmountsoriginalAmount"));
                assistrecord.setLocalAmount(wsvoucher.getBigDecimal("VoucherAssistRecordlocalAmount"));
                String voucherAssistdescription = (String)wsvoucher.get("VoucherAssistdescription");
                if (voucherAssistdescription != null && voucherAssistdescription.length() > 100) {
                    voucherAssistdescription = voucherAssistdescription.substring(0, 100);
                }
                assistrecord.setDescription(voucherAssistdescription);
                assistrecord.setBizDate(wsvoucher.getBizDate());
                assistrecord.setEndDate((Date)wsvoucher.get("VoucherAssistendDate"));
                Date date = new Date();
                if (assistrecord.getBizDate() == null) {
                    assistrecord.setBizDate(date);
                }
                if (assistrecord.getEndDate() == null) {
                    assistrecord.setEndDate(date);
                }
                this.setRecordLocalReportAmount(entry, assistrecord, company);
                if (account.isHasUserProperty()) {
                    boolean hasErr = false;
                    AssistCustomizedPropertyCollection props = (AssistCustomizedPropertyCollection)((Object)accountPropertyMap.get(account.getId().toString()));
                    if (props == null) continue;
                    Iterator itr = props.iterator();
                    HashMap<String, AssistCustomizedTypeInfo> customizedProperty = new HashMap<String, AssistCustomizedTypeInfo>();
                    while (itr.hasNext()) {
                        AssistCustomizedPropertyInfo prop = (AssistCustomizedPropertyInfo)itr.next();
                        AssistCustomizedTypeInfo t = prop.getCustomizedType();
                        if ((entry.getEntryDC() != EntryDC.CREDIT || !prop.isIsCreditNecessary() || prop.getDeletedStatus() != DeletedStatusEnum.NORMAL) && (entry.getEntryDC() != EntryDC.DEBIT || !prop.isIsDebitNecessary() || prop.getDeletedStatus() != DeletedStatusEnum.NORMAL)) continue;
                        customizedProperty.put(t.getMappingPropName(), t);
                    }
                    UserInfo handler = (UserInfo)handlerInfoMap.get(wsvoucher.get("handler"));
                    String handlerStr = null;
                    if (handler != null) {
                        handlerStr = (String)wsvoucher.get("handler");
                    }
                    hasErr = this.checkAccountProperty(ctx, customizedProperty, "handler", handlerStr, assistrecord, msg, i);
                    FeeTypeEnum feeType = null;
                    String feeTypeStr = null;
                    try {
                        feeTypeStr = (String)wsvoucher.get("feeType");
                        feeType = FeeTypeEnum.getEnum((int)Integer.parseInt(feeTypeStr));
                    }
                    catch (Exception e) {
                        feeTypeStr = null;
                    }
                    hasErr = this.checkAccountProperty(ctx, customizedProperty, "feeType", feeTypeStr, assistrecord, msg, i);
                    CustomerInfo customerInfo = (CustomerInfo)customerInfoMap.get(wsvoucher.get("customer"));
                    String customerInfoStr = null;
                    if (customerInfo != null) {
                        customerInfoStr = (String)wsvoucher.get("customer");
                    }
                    hasErr = this.checkAccountProperty(ctx, customizedProperty, "customer", customerInfoStr, assistrecord, msg, i);
                    SupplierInfo supplierInfo = (SupplierInfo)supplierInfoMap.get(wsvoucher.get("supplier"));
                    String supplierInfoStr = null;
                    if (supplierInfo != null) {
                        supplierInfoStr = (String)wsvoucher.get("supplier");
                    }
                    hasErr = this.checkAccountProperty(ctx, customizedProperty, "supplier", supplierInfoStr, assistrecord, msg, i);
                    MaterialInfo materialInfo = (MaterialInfo)materialInfoMap.get(wsvoucher.get("material"));
                    String materialInfoStr = null;
                    if (materialInfo != null) {
                        materialInfoStr = (String)wsvoucher.get("material");
                    }
                    hasErr = this.checkAccountProperty(ctx, customizedProperty, "material", materialInfoStr, assistrecord, msg, i);
                    CompanyOrgUnitInfo orgUnit = (CompanyOrgUnitInfo)orgUnitInfoMap.get(wsvoucher.get("orgUnit"));
                    String orgUnitStr = null;
                    if (orgUnit != null) {
                        orgUnitStr = (String)wsvoucher.get("orgUnit");
                    }
                    hasErr = this.checkAccountProperty(ctx, customizedProperty, "orgUnit", orgUnitStr, assistrecord, msg, i);
                    SettlementTypeInfo settlementTypeInfo = (SettlementTypeInfo)settlementTypeInfoMap.get(wsvoucher.getSettlementType());
                    String settlementTypeInfoStr = null;
                    if (settlementTypeInfo != null) {
                        settlementTypeInfoStr = wsvoucher.getSettlementType();
                    }
                    hasErr = this.checkAccountProperty(ctx, customizedProperty, "settlementType", settlementTypeInfoStr, assistrecord, msg, i);
                    hasErr = this.checkAccountProperty(ctx, customizedProperty, "bizNumber", wsvoucher.getBizNumber(), assistrecord, msg, i);
                    hasErr = this.checkAccountProperty(ctx, customizedProperty, "settlementCode", (String)wsvoucher.get("settlementCode"), assistrecord, msg, i);
                    hasErr = this.checkAccountProperty(ctx, customizedProperty, "ticketNumber", (String)wsvoucher.get("ticketNumber"), assistrecord, msg, i);
                    hasErr = this.checkAccountProperty(ctx, customizedProperty, "invoiceNumber", (String)wsvoucher.get("invoiceNumber"), assistrecord, msg, i);
                    assistrecord.setBizNumber(wsvoucher.getBizNumber());
                    assistrecord.setSettlementCode(wsvoucher.getSettlementNumber());
                    assistrecord.setTicketNumber((String)wsvoucher.get("ticketNumber"));
                    assistrecord.setSettlementType(settlementTypeInfo);
                    assistrecord.setInvoiceNumber(wsvoucher.getInvoiceNumber());
                    assistrecord.setHandler(handler);
                    assistrecord.setOrgUnit(orgUnit);
                    assistrecord.setMaterial(materialInfo);
                    assistrecord.setSupplier(supplierInfo);
                    assistrecord.setCustomer(customerInfo);
                    if (hasErr) {
                        rowError = true;
                    }
                }
                if (account.getCAA() != null) {
                    AsstActGroupDetailCollection con;
                    AssistantHGInfo assistantHGInfos = new AssistantHGInfo();
                    StringBuffer HGKey = new StringBuffer();
                    AsstActTypeCollection items = new AsstActTypeCollection();
                    Vector<AsstActTypeInfo> vector = null;
                    String actTypeID = null;
                    if (asstActTypeByGroupMap.get(account.getCAA().getId().toString()) == null || (con = (AsstActGroupDetailCollection)asstActTypeByGroupMap.get(account.getCAA().getId().toString())) == null || con.size() == 0) continue;
                    vector = new Vector<AsstActTypeInfo>(con.size());
                    for (int t = 0; t < con.size(); ++t) {
                        if (con.get(t).getAsstActType().getId() == null) continue;
                        AsstActTypeInfo info = con.get(t).getAsstActType();
                        vector.add(info);
                    }
                    Iterator iterator = vector.iterator();
                    HashMap<String, AsstActTypeInfo> actTypeMap = new HashMap<String, AsstActTypeInfo>();
                    while (iterator.hasNext()) {
                        AsstActTypeInfo actType = (AsstActTypeInfo)iterator.next();
                        actTypeMap.put(actType.getNumber(), actType);
                    }
                    AsstActTypeInfo actTypeInfo = null;
                    int assistCount = (Integer)wsvoucher.get("assistCount");
                    try {
                        for (int op = 1; op <= assistCount; ++op) {
                            AsstActTypeInfo asstActInfo = new AsstActTypeInfo();
                            String actTypeNumber = (String)wsvoucher.get("asstActType" + op);
                            if (!actTypeMap.containsKey(actTypeNumber) || (actTypeInfo = (AsstActTypeInfo)actTypeMap.get(actTypeNumber)) == null) continue;
                            String getDataInfo = (String)wsvoucher.get("asstActNumber" + op);
                            if (getDataInfo != null) {
                                IObjectValue iObjectValue;
                                String dataInfo = getDataInfo;
                                char cr = '\u0000';
                                String _key = actTypeInfo.getNumber() + cr + dataInfo;
                                if (hgAsstActTypeMap.containsKey(_key)) {
                                    iObjectValue = (IObjectValue)hgAsstActTypeMap.get(_key);
                                    asstActInfo.setAsstHGAttribute(actTypeInfo.getAsstHGAttribute());
                                    asstActInfo.setName(actTypeInfo.getName());
                                    actTypeID = iObjectValue.getString(iObjectValue.getPKField());
                                } else {
                                    HashMap<String, String> map = new HashMap<String, String>();
                                    map.put("numbers", dataInfo);
                                    map.put("actType", (String)actTypeInfo);
                                    actTypeID = this._getAsstinfo(ctx, map);
                                    if (actTypeID == null) {
                                        rowError = true;
                                        this.getMsg(ctx, msg, GLResUtil.getRes("voucher_index") + (i + 1));
                                        this.getMsg(ctx, msg, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"149_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + actTypeInfo.getName() + ResourceBase.getString((String)EXP_RES_NAME, (String)"not", (Locale)ctx.getLocale()) + "\n");
                                        asstActInfo = null;
                                        break;
                                    }
                                    BOSUuid bosid = BOSUuid.read((String)actTypeID);
                                    IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
                                    iObjectValue = iDynamicObject.getValue(bosid.getType(), (IObjectPK)new ObjectUuidPK(bosid));
                                    asstActInfo.setAsstHGAttribute(actTypeInfo.getAsstHGAttribute());
                                    asstActInfo.setName(actTypeInfo.getName());
                                    hgAsstActTypeMap.put(_key, iObjectValue);
                                }
                                assistantHGInfos.put(actTypeInfo.getAsstHGAttribute(), (Object)iObjectValue);
                                HGKey.append(actTypeID);
                            }
                            items.add(asstActInfo);
                        }
                    }
                    catch (BOSException e) {
                        logger.error((Object)"Obtain asstActInfo Error:", (Throwable)e);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("actTypeID:" + actTypeID + "\n\r"));
                    }
                    if (actTypeInfo != null) {
                        BalanceDirectionEnum accDC;
                        IObjectValue assistantHG;
                        if (hgMap.containsKey(HGKey.toString())) {
                            assistantHG = (IObjectValue)hgMap.get(HGKey.toString());
                            assistrecord.setAssGrp((AssistantHGInfo)assistantHG);
                        } else {
                            try {
                                assistantHG = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(assistantHGInfos, account.getCAA().getId().toString(), items);
                                ((AssistantHGInfo)assistantHG).setAsstAccount(account.getCAA());
                                hgMap.put(HGKey.toString(), assistantHG);
                                assistrecord.setAssGrp((AssistantHGInfo)assistantHG);
                            }
                            catch (Exception e) {
                                rowError = true;
                                msg.append(MessageFormat.format(GLResUtil.getRes("ObtainHgError"), new Integer(i + 1), e.getMessage()) + "\r\n");
                                logger.error((Object)"Obtain Assistanthg Error:", (Throwable)e);
                                break;
                            }
                        }
                        boolean needFindHistory = false;
                        if (account.isAC() && (BalanceDirectionEnum.DEBIT.equals((Object)(accDC = account.getDC())) && EntryDC.CREDIT.equals((Object)entry.getEntryDC()) || BalanceDirectionEnum.CREDIT.equals((Object)accDC) && EntryDC.DEBIT.equals((Object)entry.getEntryDC()))) {
                            needFindHistory = true;
                        }
                        entry.setIsVerify(this.isVerify(account, entry.getEntryDC(), true));
                        if (voucher.isIsAC() && needFindHistory && assistantHG.getBOSUuid("id") != null) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("unHoldedAmtFor", assistrecord.getOriginalAmount());
                            map.put("bizNumber", assistrecord.getBizNumber());
                            map.put("currency", entry.getCurrency().getId().toString());
                            map.put("Account", account.getId().toString());
                            map.put("hgID", assistantHG.getBOSUuid("id").toString());
                            AcctCussentInfo acctInfo = this.getAcctCussentInfo(ctx, map);
                            assistrecord.setVerifiedCussent(acctInfo);
                            if (acctInfo.getId() != null) {
                                entry.setIsVerify(this.isVerify(account, entry.getEntryDC(), true));
                                assistrecord.setEndDate(acctInfo.getBizDate());
                            } else {
                                rowError = true;
                                this.getMsg(ctx, msg, i + 1, "com.kingdee.eas.fi.gl.GLAutoGenerateResource", "150_VoucherLeadControlImportUI", "");
                                this.getMsg(ctx, msg, "com.kingdee.eas.fi.gl.GLAutoGenerateResource", "151_VoucherLeadControlImportUI");
                                this.getMsg(ctx, msg, wsvoucher.getVoucherNumber());
                                this.getMsg(ctx, msg, "com.kingdee.eas.fi.gl.GLAutoGenerateResource", "152_VoucherLeadControlImportUI");
                                this.getMsg(ctx, msg, "" + wsvoucher.getEntrySeq());
                                this.getMsg(ctx, msg, "com.kingdee.eas.fi.gl.GLAutoGenerateResource", "153_VoucherLeadControlImportUI");
                                this.getMsg(ctx, msg, "\n");
                            }
                        }
                    }
                }
                if (!rowError) {
                    entry.setAssistRecords((AbstractObjectCollection)assistrecords);
                    assistrecords.add(assistrecord);
                }
            } else if (!isFirstEntry) {
                if (entry.getLocalAmount() != null && wsvoucher.getBigDecimal("VoucherEntrylocalAmount") != null) {
                    entry.setLocalAmount(entry.getLocalAmount().add(wsvoucher.getBigDecimal("VoucherEntrylocalAmount")));
                }
                if (entry.getOriginalAmount() != null && wsvoucher.getBigDecimal("VoucherEntryoriginalAmount") != null) {
                    entry.setOriginalAmount(entry.getOriginalAmount().add(wsvoucher.getBigDecimal("VoucherEntryoriginalAmount")));
                }
            }
            BigDecimal originalAmount = entry.getOriginalAmount();
            if (entry.getLocalAmount() == null && originalAmount != null) {
                if (entry.getLocalExchangeRate() != null) {
                    entry.setLocalAmount(originalAmount.multiply(entry.getLocalExchangeRate()));
                } else {
                    entry.setLocalAmount(originalAmount);
                }
            }
            if ((originalAmount == null || originalAmount.signum() == 0) && (entry.getLocalAmount() == null || entry.getLocalAmount().signum() == 0)) continue;
            if (company.getReportConvertMode().getValue() == 1) {
                if (entry.getReportingExchangeRate() != null) {
                    entry.setReportingAmount(originalAmount.multiply(entry.getReportingExchangeRate()));
                    continue;
                }
                entry.setReportingAmount(originalAmount);
                continue;
            }
            if (entry.getReportingExchangeRate() != null && entry.getLocalAmount() != null) {
                entry.setReportingAmount(entry.getLocalAmount().multiply(entry.getReportingExchangeRate()));
                continue;
            }
            entry.setReportingAmount(entry.getLocalAmount());
        }
        returnMap.put("msg", msg.toString());
        ctx.put((Object)ImpVoucherListCache, (Object)voucherlist);
        return returnMap;
    }

    private boolean checkAccountProperty(Context ctx, Map customizedProperty, String propertyName, String value, VoucherAssistRecordInfo assistrecord, StringBuffer msg, int i) {
        boolean hasErr = false;
        if (customizedProperty.get(propertyName) != null && (value == null || value.length() == 0)) {
            assistrecord.setIsFullProp(false);
            msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"354_VoucherLeadControlControllerBean", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"150_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + ((AssistCustomizedTypeInfo)customizedProperty.get(propertyName)).getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"155_VoucherLeadControlImportUI", (Locale)ctx.getLocale()));
            hasErr = true;
        }
        return hasErr;
    }

    private void setRecordLocalReportAmount(VoucherEntryInfo infoRow, VoucherAssistRecordInfo record, CompanyOrgUnitInfo com) {
        if (com.getReportConvertMode().getValue() == 1) {
            if (infoRow.getReportingExchangeRate() != null && record.getOriginalAmount() != null) {
                record.setReportingAmount(record.getOriginalAmount().multiply(infoRow.getReportingExchangeRate()));
            } else {
                record.setReportingAmount(record.getOriginalAmount());
            }
            if (infoRow.getLocalAmount() == null) {
                if (infoRow.getLocalExchangeRate() != null && record.getOriginalAmount() != null) {
                    record.setLocalAmount(record.getOriginalAmount().multiply(infoRow.getLocalExchangeRate()));
                } else {
                    record.setLocalAmount(record.getOriginalAmount());
                }
            }
        } else {
            if (infoRow.getReportingExchangeRate() != null && record.getLocalAmount() != null) {
                record.setReportingAmount(record.getLocalAmount().multiply(infoRow.getReportingExchangeRate()));
            } else {
                record.setReportingAmount(record.getLocalAmount());
                infoRow.setReportingExchangeRate(new BigDecimal("1"));
            }
            if (infoRow.getOriginalAmount() == null) {
                if (infoRow.getLocalExchangeRate() != null && record.getLocalAmount() != null) {
                    record.setOriginalAmount(record.getLocalAmount().divide(infoRow.getLocalExchangeRate(), 4));
                } else {
                    record.setOriginalAmount(record.getLocalAmount());
                }
            }
        }
    }

    private void getMsg(Context ctx, StringBuffer msg, int i, String msgNumber) {
        this.getMsg(ctx, msg, i, EXP_RES_NAME, msgNumber);
    }

    private void getMsg(Context ctx, StringBuffer msg, int i, String resName, String msgNumber) {
        this.getMsg(ctx, msg, i, EXP_RES_NAME, msgNumber, "");
    }

    private void getMsg(Context ctx, StringBuffer msg, int i, String resName, String msgNumber, String appendString) {
        msg.append(GLResUtil.getRes("voucher_index") + i + ResourceBase.getString((String)resName, (String)msgNumber, (Locale)ctx.getLocale()) + appendString);
    }

    private void getMsg(Context ctx, StringBuffer msg, String resName, String msgNumber) {
        msg.append(ResourceBase.getString((String)resName, (String)msgNumber, (Locale)ctx.getLocale()));
    }

    private void getMsg(Context ctx, StringBuffer msg, String msgString) {
        msg.append(msgString);
    }

    private PeriodInfo getCurrentPeriod(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.GENERALLEDGER.getValue())));
        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
        sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
        sic.add(new SelectorItemInfo("currentPeriod.endDate"));
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        SystemStatusCtrolCollection col = ctrl.getSystemStatusCtrolCollection(view);
        PeriodInfo prd = null;
        if (col.size() == 1) {
            prd = col.get(0).getCurrentPeriod();
        }
        if (prd == null) {
            throw new ReportException(ReportException.CURRENCY_PERIOD_ERROR);
        }
        return prd;
    }

    private static Map getAccountPropertyMap(Context ctx, Set accountIds) throws BOSException {
        AssistCustomizedPropertyInfo tempAssistCustomizedProperty;
        int i;
        AssistCustomizedPropertyCollection valuecols;
        AssistCustomizedPropertyCollection assistCustomizedPropertys;
        HashMap<String, AssistCustomizedPropertyCollection> accountPropertyMap = new HashMap<String, AssistCustomizedPropertyCollection>();
        if (accountIds.size() == 0) {
            return accountPropertyMap;
        }
        long begin = System.currentTimeMillis();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        ArrayList list = new ArrayList(accountIds);
        HashSet subset = null;
        int size = accountIds.size();
        int time = 0;
        int fetchCount = 50;
        while (size / fetchCount != 0) {
            size -= fetchCount;
            subset = new HashSet(list.subList(time * fetchCount, time * fetchCount + fetchCount));
            assistCustomizedPropertys = VoucherLeadControlControllerBean.findAccountPropertyByAccountID(ctx, company, subset);
            valuecols = null;
            for (i = 0; i < assistCustomizedPropertys.size(); ++i) {
                tempAssistCustomizedProperty = assistCustomizedPropertys.get(i);
                if (accountPropertyMap.get(tempAssistCustomizedProperty.getAccount().getId().toString()) == null) {
                    valuecols = new AssistCustomizedPropertyCollection();
                    valuecols.add(tempAssistCustomizedProperty);
                    accountPropertyMap.put(tempAssistCustomizedProperty.getAccount().getId().toString(), valuecols);
                    continue;
                }
                valuecols = (AssistCustomizedPropertyCollection)((Object)accountPropertyMap.get(tempAssistCustomizedProperty.getAccount().getId().toString()));
                valuecols.add(tempAssistCustomizedProperty);
            }
            ++time;
        }
        if (size % fetchCount != 0) {
            subset = new HashSet(list.subList(time * fetchCount, accountIds.size()));
            assistCustomizedPropertys = VoucherLeadControlControllerBean.findAccountPropertyByAccountID(ctx, company, subset);
            valuecols = null;
            for (i = 0; i < assistCustomizedPropertys.size(); ++i) {
                tempAssistCustomizedProperty = assistCustomizedPropertys.get(i);
                if (accountPropertyMap.get(tempAssistCustomizedProperty.getAccount().getId().toString()) == null) {
                    valuecols = new AssistCustomizedPropertyCollection();
                    valuecols.add(tempAssistCustomizedProperty);
                    accountPropertyMap.put(tempAssistCustomizedProperty.getAccount().getId().toString(), valuecols);
                    continue;
                }
                valuecols = (AssistCustomizedPropertyCollection)((Object)accountPropertyMap.get(tempAssistCustomizedProperty.getAccount().getId().toString()));
                valuecols.add(tempAssistCustomizedProperty);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"160_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        }
        return accountPropertyMap;
    }

    private static AssistCustomizedPropertyCollection findAccountPropertyByAccountID(Context ctx, CompanyOrgUnitInfo company, Set accountIds) throws BOSException {
        AssistCustomizedPropertyCollection props = new AssistCustomizedPropertyCollection();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountIds, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        evi.getSelector().add(new SelectorItemInfo("account.id"));
        evi.getSelector().add(new SelectorItemInfo("isNecessary"));
        evi.getSelector().add(new SelectorItemInfo("customizedType.mappingPropName"));
        evi.getSelector().add(new SelectorItemInfo("customizedType.name"));
        evi.getSelector().add(new SelectorItemInfo("isCreditNecessary"));
        evi.getSelector().add(new SelectorItemInfo("isDebitNecessary"));
        evi.getSelector().add(new SelectorItemInfo("deletedStatus"));
        IAssistCustomizedProperty cpCtrl = AssistCustomizedPropertyFactory.getLocalInstance(ctx);
        props = cpCtrl.getAssistCustomizedPropertyCollection(evi);
        return props;
    }

    private static Map getAsstActTypeByGroupMap(Context ctx, Set caaIds) throws BOSException {
        AsstActGroupDetailInfo tempAsstActGroupDetail;
        int i;
        AsstActGroupDetailCollection valuecols;
        AsstActGroupDetailCollection asstActGroupDetails;
        HashMap<String, AsstActGroupDetailCollection> asstActTypeByGroupMap = new HashMap<String, AsstActGroupDetailCollection>();
        if (caaIds.size() == 0) {
            return asstActTypeByGroupMap;
        }
        long begin = System.currentTimeMillis();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        ArrayList list = new ArrayList(caaIds);
        HashSet subset = null;
        int size = caaIds.size();
        int time = 0;
        int fetchCount = 50;
        while (size / fetchCount != 0) {
            size -= fetchCount;
            subset = new HashSet(list.subList(time * fetchCount, time * fetchCount + fetchCount));
            asstActGroupDetails = VoucherLeadControlControllerBean.findAsstActTypeByID(ctx, company, subset);
            valuecols = null;
            for (i = 0; i < asstActGroupDetails.size(); ++i) {
                tempAsstActGroupDetail = asstActGroupDetails.get(i);
                if (asstActTypeByGroupMap.get(tempAsstActGroupDetail.getAsstAccount().getId().toString()) == null) {
                    valuecols = new AsstActGroupDetailCollection();
                    valuecols.add(tempAsstActGroupDetail);
                    asstActTypeByGroupMap.put(tempAsstActGroupDetail.getAsstAccount().getId().toString(), valuecols);
                    continue;
                }
                valuecols = (AsstActGroupDetailCollection)asstActTypeByGroupMap.get(tempAsstActGroupDetail.getAsstAccount().getId().toString());
                valuecols.add(tempAsstActGroupDetail);
            }
            ++time;
        }
        if (size % fetchCount != 0) {
            subset = new HashSet(list.subList(time * fetchCount, caaIds.size()));
            asstActGroupDetails = VoucherLeadControlControllerBean.findAsstActTypeByID(ctx, company, subset);
            valuecols = null;
            for (i = 0; i < asstActGroupDetails.size(); ++i) {
                tempAsstActGroupDetail = asstActGroupDetails.get(i);
                if (asstActTypeByGroupMap.get(tempAsstActGroupDetail.getAsstAccount().getId().toString()) == null) {
                    valuecols = new AsstActGroupDetailCollection();
                    valuecols.add(tempAsstActGroupDetail);
                    asstActTypeByGroupMap.put(tempAsstActGroupDetail.getAsstAccount().getId().toString(), valuecols);
                    continue;
                }
                valuecols = (AsstActGroupDetailCollection)asstActTypeByGroupMap.get(tempAsstActGroupDetail.getAsstAccount().getId().toString());
                valuecols.add(tempAsstActGroupDetail);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"160_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        }
        return asstActTypeByGroupMap;
    }

    private static AsstActGroupDetailCollection findAsstActTypeByID(Context ctx, CompanyOrgUnitInfo company, Set supplierNumbers) throws BOSException {
        AsstActGroupDetailCollection con = new AsstActGroupDetailCollection();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("asstAccount", (Object)supplierNumbers, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        evi.getSelector().add(new SelectorItemInfo("asstAccount.id"));
        evi.getSelector().add(new SelectorItemInfo("asstActType.id"));
        evi.getSelector().add(new SelectorItemInfo("asstActType.number"));
        evi.getSelector().add(new SelectorItemInfo("asstActType.name"));
        evi.getSelector().add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        evi.getSelector().add(new SelectorItemInfo("asstActType.useLongNumber"));
        evi.getSelector().add(new SelectorItemInfo("asstActType.realtionDataObject"));
        evi.getSelector().add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
        IAsstActGroupDetail iasstActGroupDt = AsstActGroupDetailFactory.getLocalInstance((Context)ctx);
        con = iasstActGroupDt.getAsstActGroupDetailCollection(evi);
        return con;
    }

    private static Map getCustomerInfoMap(Context ctx, Set customerNumbers) throws BOSException {
        CustomerInfo tempCustomer;
        int i;
        CustomerCollection customers;
        HashMap<String, CustomerInfo> customerInfoMap = new HashMap<String, CustomerInfo>();
        if (customerNumbers.size() == 0) {
            return customerInfoMap;
        }
        long begin = System.currentTimeMillis();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        ArrayList list = new ArrayList(customerNumbers);
        HashSet subset = null;
        int size = customerNumbers.size();
        int time = 0;
        int fetchCount = 50;
        while (size / fetchCount != 0) {
            size -= fetchCount;
            subset = new HashSet(list.subList(time * fetchCount, time * fetchCount + fetchCount));
            customers = VoucherLeadControlControllerBean.findCustomerInfoByNumber(ctx, company, subset);
            for (i = 0; i < customers.size(); ++i) {
                tempCustomer = customers.get(i);
                customerInfoMap.put(tempCustomer.getNumber(), tempCustomer);
            }
            ++time;
        }
        if (size % fetchCount != 0) {
            subset = new HashSet(list.subList(time * fetchCount, customerNumbers.size()));
            customers = VoucherLeadControlControllerBean.findCustomerInfoByNumber(ctx, company, subset);
            for (i = 0; i < customers.size(); ++i) {
                tempCustomer = customers.get(i);
                customerInfoMap.put(tempCustomer.getNumber(), tempCustomer);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"160_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        }
        return customerInfoMap;
    }

    private static CustomerCollection findCustomerInfoByNumber(Context ctx, CompanyOrgUnitInfo company, Set customerNumbers) throws BOSException {
        CustomerCollection customerCollection = new CustomerCollection();
        ICustomerCompanyInfo customerCompanyInfo = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("customer.name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("customer.number", (Object)customerNumbers, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
        CustomerInfo customerInfo = null;
        CustomerCompanyInfoInfo customerCompanyInfoInfo = null;
        CustomerCompanyInfoCollection customerCompanyInfoCollection = customerCompanyInfo.getCustomerCompanyInfoCollection(view);
        if (customerCompanyInfoCollection != null && customerCompanyInfoCollection.size() != 0 && (customerCompanyInfoInfo = customerCompanyInfoCollection.get(0)) != null) {
            customerInfo = customerCompanyInfoInfo.getCustomer();
        }
        for (int i = 0; customerCompanyInfoCollection != null && i < customerCompanyInfoCollection.size(); ++i) {
            customerCompanyInfoInfo = customerCompanyInfoCollection.get(0);
            if (customerCompanyInfoInfo != null) {
                customerInfo = customerCompanyInfoInfo.getCustomer();
            }
            customerCollection.add(customerInfo);
        }
        return customerCollection;
    }

    private static Map getSupplierInfoMap(Context ctx, Set supplierNumbers) throws BOSException {
        SupplierInfo tempSupplier;
        int i;
        SupplierCollection suppliers;
        HashMap<String, SupplierInfo> supplierInfoMap = new HashMap<String, SupplierInfo>();
        if (supplierNumbers.size() == 0) {
            return supplierInfoMap;
        }
        long begin = System.currentTimeMillis();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        ArrayList list = new ArrayList(supplierNumbers);
        HashSet subset = null;
        int size = supplierNumbers.size();
        int time = 0;
        int fetchCount = 50;
        while (size / fetchCount != 0) {
            size -= fetchCount;
            subset = new HashSet(list.subList(time * fetchCount, time * fetchCount + fetchCount));
            suppliers = VoucherLeadControlControllerBean.findSupplierInfoByNumber(ctx, company, subset);
            for (i = 0; i < suppliers.size(); ++i) {
                tempSupplier = suppliers.get(i);
                supplierInfoMap.put(tempSupplier.getNumber(), tempSupplier);
            }
            ++time;
        }
        if (size % fetchCount != 0) {
            subset = new HashSet(list.subList(time * fetchCount, supplierNumbers.size()));
            suppliers = VoucherLeadControlControllerBean.findSupplierInfoByNumber(ctx, company, subset);
            for (i = 0; i < suppliers.size(); ++i) {
                tempSupplier = suppliers.get(i);
                supplierInfoMap.put(tempSupplier.getNumber(), tempSupplier);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"160_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        }
        return supplierInfoMap;
    }

    private static SupplierCollection findSupplierInfoByNumber(Context ctx, CompanyOrgUnitInfo company, Set supplierNumbers) throws BOSException {
        SupplierCollection supplierCollection = new SupplierCollection();
        ISupplierCompanyInfo supplierCompanyInfo = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("supplier.name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("supplier.number", (Object)supplierNumbers, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
        SupplierInfo supplierInfo = null;
        SupplierCompanyInfoInfo supplierCompanyInfoInfo = null;
        SupplierCompanyInfoCollection supplierCompanyInfoCollection = supplierCompanyInfo.getSupplierCompanyInfoCollection(view);
        if (supplierCompanyInfoCollection != null && supplierCompanyInfoCollection.size() != 0 && (supplierCompanyInfoInfo = supplierCompanyInfoCollection.get(0)) != null) {
            supplierInfo = supplierCompanyInfoInfo.getSupplier();
        }
        for (int i = 0; supplierCompanyInfoCollection != null && i < supplierCompanyInfoCollection.size(); ++i) {
            supplierCompanyInfoInfo = supplierCompanyInfoCollection.get(0);
            if (supplierCompanyInfoInfo != null) {
                supplierInfo = supplierCompanyInfoInfo.getSupplier();
            }
            supplierCollection.add(supplierInfo);
        }
        return supplierCollection;
    }

    private static Map getOrgUnitInfoMap(Context ctx, Set orgUnitNumbers) throws BOSException {
        CompanyOrgUnitInfo tempOrgUnit;
        int i;
        CompanyOrgUnitCollection orgUnits;
        HashMap<String, CompanyOrgUnitInfo> orgUnitInfoMap = new HashMap<String, CompanyOrgUnitInfo>();
        if (orgUnitNumbers.size() == 0) {
            return orgUnitInfoMap;
        }
        long begin = System.currentTimeMillis();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        ArrayList list = new ArrayList(orgUnitNumbers);
        HashSet subset = null;
        int size = orgUnitNumbers.size();
        int time = 0;
        int fetchCount = 50;
        while (size / fetchCount != 0) {
            size -= fetchCount;
            subset = new HashSet(list.subList(time * fetchCount, time * fetchCount + fetchCount));
            orgUnits = VoucherLeadControlControllerBean.findOrgUnitInfoByNumber(ctx, company, subset);
            for (i = 0; i < orgUnits.size(); ++i) {
                tempOrgUnit = orgUnits.get(i);
                orgUnitInfoMap.put(tempOrgUnit.getNumber(), tempOrgUnit);
            }
            ++time;
        }
        if (size % fetchCount != 0) {
            subset = new HashSet(list.subList(time * fetchCount, orgUnitNumbers.size()));
            orgUnits = VoucherLeadControlControllerBean.findOrgUnitInfoByNumber(ctx, company, subset);
            for (i = 0; i < orgUnits.size(); ++i) {
                tempOrgUnit = orgUnits.get(i);
                orgUnitInfoMap.put(tempOrgUnit.getNumber(), tempOrgUnit);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"160_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        }
        return orgUnitInfoMap;
    }

    private static CompanyOrgUnitCollection findOrgUnitInfoByNumber(Context ctx, CompanyOrgUnitInfo company, Set orgUnitNumbers) throws BOSException {
        CompanyOrgUnitCollection companyOrgUnitCollection = new CompanyOrgUnitCollection();
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)orgUnitNumbers, CompareType.INCLUDE));
        companyOrgUnitCollection = companyOrgUnit.getCompanyOrgUnitCollection(view);
        return companyOrgUnitCollection;
    }

    private static Map getMaterialInfoMap(Context ctx, Set materialNumbers) throws BOSException {
        MaterialInfo tempMaterial;
        int i;
        MaterialCollection materials;
        HashMap<String, MaterialInfo> materialInfoMap = new HashMap<String, MaterialInfo>();
        if (materialNumbers.size() == 0) {
            return materialInfoMap;
        }
        long begin = System.currentTimeMillis();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        ArrayList list = new ArrayList(materialNumbers);
        HashSet subset = null;
        int size = materialNumbers.size();
        int time = 0;
        int fetchCount = 50;
        while (size / fetchCount != 0) {
            size -= fetchCount;
            subset = new HashSet(list.subList(time * fetchCount, time * fetchCount + fetchCount));
            materials = VoucherLeadControlControllerBean.findMaterialInfoByNumber(ctx, company, subset);
            for (i = 0; i < materials.size(); ++i) {
                tempMaterial = materials.get(i);
                materialInfoMap.put(tempMaterial.getNumber(), tempMaterial);
            }
            ++time;
        }
        if (size % fetchCount != 0) {
            subset = new HashSet(list.subList(time * fetchCount, materialNumbers.size()));
            materials = VoucherLeadControlControllerBean.findMaterialInfoByNumber(ctx, company, subset);
            for (i = 0; i < materials.size(); ++i) {
                tempMaterial = materials.get(i);
                materialInfoMap.put(tempMaterial.getNumber(), tempMaterial);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"160_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        }
        return materialInfoMap;
    }

    private static MaterialCollection findMaterialInfoByNumber(Context ctx, CompanyOrgUnitInfo company, Set materialNumbers) throws BOSException {
        MaterialCollection materialCollection = new MaterialCollection();
        IMaterialCompanyInfo materialCompanyInfo = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("mateial.id"));
        sic.add(new SelectorItemInfo("mateial.number"));
        sic.add(new SelectorItemInfo("mateial.name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("mateial.number", (Object)materialNumbers, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        MaterialInfo materialInfo = null;
        MaterialCompanyInfoInfo materialCompanyInfoInfo = null;
        MaterialCompanyInfoCollection materialCompanyInfoCollection = materialCompanyInfo.getMaterialCompanyInfoCollection(view);
        for (int i = 0; materialCompanyInfoCollection != null && i < materialCompanyInfoCollection.size(); ++i) {
            materialCompanyInfoInfo = materialCompanyInfoCollection.get(0);
            if (materialCompanyInfoInfo != null) {
                materialInfo = materialCompanyInfoInfo.getMateial();
            }
            materialCollection.add(materialInfo);
        }
        return materialCollection;
    }

    private static Map getHandlerInfoMap(Context ctx, Set handlerNumbers) throws BOSException {
        UserInfo tempHandler;
        int i;
        HashMap<String, UserInfo> handlerInfoMap = new HashMap<String, UserInfo>();
        if (handlerNumbers.size() == 0) {
            return handlerInfoMap;
        }
        long begin = System.currentTimeMillis();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        ArrayList list = new ArrayList(handlerNumbers);
        HashSet subset = null;
        int size = handlerNumbers.size();
        int time = 0;
        int fetchCount = 50;
        while (size / fetchCount != 0) {
            size -= fetchCount;
            subset = new HashSet(list.subList(time * fetchCount, time * fetchCount + fetchCount));
            UserCollection sandlers = VoucherLeadControlControllerBean.findHandlerInfoByNumber(ctx, company, subset);
            for (i = 0; i < sandlers.size(); ++i) {
                tempHandler = sandlers.get(i);
                handlerInfoMap.put(tempHandler.getNumber(), tempHandler);
            }
            ++time;
        }
        if (size % fetchCount != 0) {
            subset = new HashSet(list.subList(time * fetchCount, handlerNumbers.size()));
            UserCollection handlers = VoucherLeadControlControllerBean.findHandlerInfoByNumber(ctx, company, subset);
            for (i = 0; i < handlers.size(); ++i) {
                tempHandler = handlers.get(i);
                handlerInfoMap.put(tempHandler.getNumber(), tempHandler);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"160_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        }
        return handlerInfoMap;
    }

    private static UserCollection findHandlerInfoByNumber(Context ctx, CompanyOrgUnitInfo company, Set handlerNumbers) throws BOSException {
        IUser user = UserFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)handlerNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        UserCollection userCollection = user.getUserCollection(view);
        return userCollection;
    }

    private static Map getSettlementTypeInfoMap(Context ctx, Set settlementTypeNumbers) throws BOSException {
        SettlementTypeInfo tempSettlementType;
        int i;
        SettlementTypeCollection settlementTypes;
        HashMap<String, SettlementTypeInfo> settlementTypeInfoMap = new HashMap<String, SettlementTypeInfo>();
        if (settlementTypeNumbers.size() == 0) {
            return settlementTypeInfoMap;
        }
        long begin = System.currentTimeMillis();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        ArrayList list = new ArrayList(settlementTypeNumbers);
        HashSet subset = null;
        int size = settlementTypeNumbers.size();
        int time = 0;
        int fetchCount = 50;
        while (size / fetchCount != 0) {
            size -= fetchCount;
            subset = new HashSet(list.subList(time * fetchCount, time * fetchCount + fetchCount));
            settlementTypes = VoucherLeadControlControllerBean.findSettlementTypeInfoByNumber(ctx, company, subset);
            for (i = 0; i < settlementTypes.size(); ++i) {
                tempSettlementType = settlementTypes.get(i);
                settlementTypeInfoMap.put(tempSettlementType.getNumber(), tempSettlementType);
            }
            ++time;
        }
        if (size % fetchCount != 0) {
            subset = new HashSet(list.subList(time * fetchCount, settlementTypeNumbers.size()));
            settlementTypes = VoucherLeadControlControllerBean.findSettlementTypeInfoByNumber(ctx, company, subset);
            for (i = 0; i < settlementTypes.size(); ++i) {
                tempSettlementType = settlementTypes.get(i);
                settlementTypeInfoMap.put(tempSettlementType.getNumber(), tempSettlementType);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"160_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        }
        return settlementTypeInfoMap;
    }

    private static SettlementTypeCollection findSettlementTypeInfoByNumber(Context ctx, CompanyOrgUnitInfo company, Set settlementTypeNumbers) throws BOSException {
        ISettlementType settlementType = SettlementTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)settlementTypeNumbers, CompareType.INCLUDE));
        SettlementTypeCollection settlementTypeCollection = settlementType.getSettlementTypeCollection(view);
        return settlementTypeCollection;
    }

    private static Map getVoucherTypeInfoMap(Context ctx, Set vchTypeNumbers) throws BOSException {
        VoucherTypeInfo tempvchType;
        int i;
        VoucherTypeCollection vchTypes;
        HashMap<String, VoucherTypeInfo> voucherTypeInfoMap = new HashMap<String, VoucherTypeInfo>();
        if (vchTypeNumbers.size() == 0) {
            return voucherTypeInfoMap;
        }
        long begin = System.currentTimeMillis();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        ArrayList list = new ArrayList(vchTypeNumbers);
        HashSet subset = null;
        int size = vchTypeNumbers.size();
        int time = 0;
        int fetchCount = 50;
        while (size / fetchCount != 0) {
            size -= fetchCount;
            subset = new HashSet(list.subList(time * fetchCount, time * fetchCount + fetchCount));
            vchTypes = VoucherLeadControlControllerBean.findVoucherTypeInfoByNumber(ctx, company, subset);
            for (i = 0; i < vchTypes.size(); ++i) {
                tempvchType = vchTypes.get(i);
                voucherTypeInfoMap.put(tempvchType.getNumber(), tempvchType);
            }
            ++time;
        }
        if (size % fetchCount != 0) {
            subset = new HashSet(list.subList(time * fetchCount, vchTypeNumbers.size()));
            vchTypes = VoucherLeadControlControllerBean.findVoucherTypeInfoByNumber(ctx, company, subset);
            for (i = 0; i < vchTypes.size(); ++i) {
                tempvchType = vchTypes.get(i);
                voucherTypeInfoMap.put(tempvchType.getNumber(), tempvchType);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"160_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        }
        return voucherTypeInfoMap;
    }

    private static VoucherTypeCollection findVoucherTypeInfoByNumber(Context ctx, CompanyOrgUnitInfo company, Set currencyNumbers) throws BOSException {
        VoucherTypeCollection vchTypes = null;
        IVoucherType voucherType = VoucherTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)currencyNumbers, CompareType.INCLUDE));
        BOSUuid pk = company.getCU().getId();
        FilterInfo filterVT = new FilterInfo();
        try {
            filterVT = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(pk.toString()), "id", "adminCU");
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        filter.mergeFilter(filterVT, "and");
        view.setFilter(filter);
        vchTypes = voucherType.getVoucherTypeCollection(view);
        return vchTypes;
    }

    private static Map getCurrencyInfoMap(Context ctx, Set currencyNumbers) throws BOSException {
        CurrencyInfo tempCurrency;
        int i;
        CurrencyCollection currencys;
        HashMap<String, CurrencyInfo> currencyInfoMap = new HashMap<String, CurrencyInfo>();
        if (currencyNumbers.size() == 0) {
            return currencyInfoMap;
        }
        long begin = System.currentTimeMillis();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        ArrayList list = new ArrayList(currencyNumbers);
        HashSet subset = null;
        int size = currencyNumbers.size();
        int time = 0;
        int fetchCount = 50;
        while (size / fetchCount != 0) {
            size -= fetchCount;
            subset = new HashSet(list.subList(time * fetchCount, time * fetchCount + fetchCount));
            currencys = VoucherLeadControlControllerBean.findCurrencyInfoByNumber(ctx, company, subset);
            for (i = 0; i < currencys.size(); ++i) {
                tempCurrency = currencys.get(i);
                currencyInfoMap.put(tempCurrency.getNumber(), tempCurrency);
            }
            ++time;
        }
        if (size % fetchCount != 0) {
            subset = new HashSet(list.subList(time * fetchCount, currencyNumbers.size()));
            currencys = VoucherLeadControlControllerBean.findCurrencyInfoByNumber(ctx, company, subset);
            for (i = 0; i < currencys.size(); ++i) {
                tempCurrency = currencys.get(i);
                currencyInfoMap.put(tempCurrency.getNumber(), tempCurrency);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"160_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        }
        return currencyInfoMap;
    }

    private static CurrencyCollection findCurrencyInfoByNumber(Context ctx, CompanyOrgUnitInfo company, Set currencyNumbers) throws BOSException {
        CurrencyCollection currencys = null;
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)currencyNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        currencys = currency.getCurrencyCollection(view);
        return currencys;
    }

    private static Map getPeriodMap(Context ctx, Set bookDates) throws BOSException {
        HashMap<Date, PeriodInfo> periodMap = new HashMap<Date, PeriodInfo>();
        if (bookDates.size() == 0) {
            return periodMap;
        }
        long begin = System.currentTimeMillis();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String periodTypeId = company.getAccountPeriodType().getId().toString();
        Iterator it = bookDates.iterator();
        Date bookedDate = null;
        PeriodInfo tempPeriod = null;
        while (it.hasNext()) {
            bookedDate = (Date)it.next();
            tempPeriod = VoucherLeadControlControllerBean.findPeriodInfoByBookedDate(ctx, periodTypeId, bookedDate);
            periodMap.put(bookedDate, tempPeriod);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"160_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        }
        return periodMap;
    }

    private static PeriodInfo findPeriodInfoByBookedDate(Context ctx, String periodTypeId, Date time) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("periodYear"));
        sic.add(new SelectorItemInfo("periodNumber"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("isAdjustPeriod"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("periodType.id", (Object)periodTypeId));
        fic.add(new FilterItemInfo("beginDate", (Object)time, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("endDate", (Object)time, CompareType.GREATER_EQUALS));
        IPeriod prdCtrl = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection objs = prdCtrl.getPeriodCollection(view);
        if (objs.size() > 0) {
            return (PeriodInfo)objs.getObject(0);
        }
        return null;
    }

    private static Map getAccountViewInfoMap(Context ctx, Set accountNumbers) throws BOSException {
        AccountViewInfo tempAccount;
        int i;
        AccountViewCollection accounts;
        HashMap<String, AccountViewInfo> accountViewInfoMap = new HashMap<String, AccountViewInfo>();
        if (accountNumbers.size() == 0) {
            return accountViewInfoMap;
        }
        long begin = System.currentTimeMillis();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        ArrayList list = new ArrayList(accountNumbers);
        HashSet subset = null;
        int size = accountNumbers.size();
        int time = 0;
        int fetchCount = 50;
        while (size / fetchCount != 0) {
            size -= fetchCount;
            subset = new HashSet(list.subList(time * fetchCount, time * fetchCount + fetchCount));
            accounts = VoucherLeadControlControllerBean.findAccountViewInfoByNumber(ctx, company, subset);
            for (i = 0; i < accounts.size(); ++i) {
                tempAccount = accounts.get(i);
                accountViewInfoMap.put(tempAccount.getNumber(), tempAccount);
            }
            ++time;
        }
        if (size % fetchCount != 0) {
            subset = new HashSet(list.subList(time * fetchCount, accountNumbers.size()));
            accounts = VoucherLeadControlControllerBean.findAccountViewInfoByNumber(ctx, company, subset);
            for (i = 0; i < accounts.size(); ++i) {
                tempAccount = accounts.get(i);
                accountViewInfoMap.put(tempAccount.getNumber(), tempAccount);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"160_VoucherLeadControlImportUI", (Locale)ctx.getLocale()) + (System.currentTimeMillis() - begin) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"145_VoucherLeadControlImportUI", (Locale)ctx.getLocale())));
        }
        return accountViewInfoMap;
    }

    private static AccountViewCollection findAccountViewInfoByNumber(Context ctx, CompanyOrgUnitInfo company, Set accountNumbers) throws BOSException {
        AccountViewCollection accounts = null;
        IAccountView de = AccountViewFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)accountNumbers, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("isSelfFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isParentFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("control", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("control", null));
        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and (#6 or #7) ");
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("AC"));
        sic.add(new SelectorItemInfo("bw"));
        sic.add(new SelectorItemInfo("ACNotice"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("control"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCashEquivalent"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("isGFreeze"));
        sic.add(new SelectorItemInfo("isCFreeze"));
        sic.add(new SelectorItemInfo("isSelfFreeze"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("PLType"));
        sic.add(new SelectorItemInfo("isChangeCurrency"));
        sic.add(new SelectorItemInfo("companyID.id"));
        sic.add(new SelectorItemInfo("currencyID.id"));
        sic.add(new SelectorItemInfo("mainCashFlowItem.*"));
        sic.add(new SelectorItemInfo("attCashFlowItem.*"));
        sic.add(new SelectorItemInfo("borrowerMainCashFlowItem.*"));
        sic.add(new SelectorItemInfo("borrowerAttCashFlowItem.*"));
        sic.add(new SelectorItemInfo("lenderMainCashFlowItem.*"));
        sic.add(new SelectorItemInfo("lenderAttCashFlowItem.*"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.number"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.name"));
        sic.add(new SelectorItemInfo("accountTableID.id"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("CAA.id"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.number"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.name"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("CAA.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("CAA.isQty"));
        sic.add(new SelectorItemInfo("CAA.name"));
        sic.add(new SelectorItemInfo("CAA.number"));
        evi.setSelector(sic);
        accounts = de.getAccountViewCollection(evi);
        return accounts;
    }

    private boolean isVerify(AccountViewInfo acc, EntryDC entryDC, boolean allowCussent) {
        BalanceDirectionEnum accDC;
        return allowCussent && acc != null && acc.isAC() && (BalanceDirectionEnum.DEBIT.equals((Object)(accDC = acc.getDC())) && EntryDC.CREDIT.equals((Object)entryDC) || BalanceDirectionEnum.CREDIT.equals((Object)accDC) && EntryDC.DEBIT.equals((Object)entryDC));
    }
}

