/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AbstractAccountRuleInfo;
import com.kingdee.eas.fi.books.AccountRuleFactory;
import com.kingdee.eas.fi.books.AccountRuleInfo;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.VoucherMessageFactory;
import com.kingdee.eas.fi.books.util.BooksRuleInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractVoucherMessageFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.BookUtil;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherMessageFacadeControllerBean
extends AbstractVoucherMessageFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.VoucherMessageFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _transferVoucher(Context ctx, Map idMap) throws BOSException, EASBizException {
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        StringBuffer sbMsg = new StringBuffer();
        try {
            VoucherProcessCache.initCache(ctx, cacheId);
            for (String voucherId : idMap.keySet()) {
                List transferOrgList = (List)idMap.get(voucherId);
                if (transferOrgList == null || transferOrgList.size() <= 0) continue;
                for (CompanyOrgUnitInfo transferOrg : transferOrgList) {
                    AcountSchemeInfo accountScheme = this.getCurrentBook(ctx, transferOrg.getId().toString());
                    CompanyOrgUnitInfo masterCompany = this.getCurrentMasterCompany(ctx, transferOrg);
                    BooksRuleInfo ruleInfo = AccountRuleFactory.getLocalInstance((Context)ctx).getRuleS(accountScheme.getId().toString(), masterCompany);
                    Object accoutRuleInfo = ruleInfo.getProperties().get("B001");
                    if (accoutRuleInfo == null) continue;
                    String filter = null;
                    Class<AbstractAccountRuleInfo> clazz = AbstractAccountRuleInfo.class;
                    try {
                        Method method = clazz.getMethod("getFilter", new Class[0]);
                        filter = ((AccountRuleInfo)accoutRuleInfo).getFilter();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    if (transferOrg.getBaseCurrency() != null && transferOrg.getBaseCurrency().getId() != null) {
                        transferOrg.setBaseCurrency(this.getCurrencyInfo(ctx, transferOrg.getBaseCurrency().getId().toString()));
                    }
                    if (transferOrg.getReportCurrency() != null && transferOrg.getReportCurrency().getId() != null) {
                        transferOrg.setReportCurrency(this.getCurrencyInfo(ctx, transferOrg.getReportCurrency().getId().toString()));
                    }
                    try {
                        VoucherMessageFactory.getLocalInstance(ctx).tranferVou(voucherId, transferOrg, accountScheme.getId().toString(), filter);
                    }
                    catch (EASBizException e) {
                        sbMsg.append(e.getMessage()).append(" \n");
                    }
                }
            }
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
            throw new EASBizException(new NumericExceptionSubItem("101", sbMsg.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _batchCancelImportVoucher(Context ctx, Map idMap) throws BOSException, EASBizException {
        String cachId = BOSUuid.create((String)"ABCD1234").toString();
        StringBuffer str = new StringBuffer();
        String msg = new String();
        IMutexServiceControl mutex = null;
        MutexParameter mp = null;
        boolean sucNum = false;
        try {
            VoucherProcessCache.initCache(ctx, cachId);
            Iterator iter = idMap.keySet().iterator();
            while (iter.hasNext()) {
                boolean isSuc = true;
                VoucherInfo info = (VoucherInfo)iter.next();
                List transferOrderList = (List)idMap.get(info);
                if (transferOrderList == null || transferOrderList.size() <= 0) continue;
                for (CompanyOrgUnitInfo transferOrg : transferOrderList) {
                    try {
                        MutexParameter current;
                        mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                        mp = VoucherMessageFacadeControllerBean.buildCancelVoucherParameter(ctx, info.getId().toString(), transferOrg.getId().toString());
                        if (mp != null && (current = mutex.requestMutex3(mp)) != null) {
                            str.append("\n").append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"TRANSFER8006", (Locale)ctx.getLocale()), transferOrg.getMainOrg().getName(), info.getNumber(), transferOrg.getName()));
                            isSuc = false;
                            continue;
                        }
                        if (BookUtil.checkVchAndOrgPeriod(ctx, info.getBookedDate(), transferOrg.getId().toString(), transferOrg.getAccountPeriodType().getId().toString(), info.getPeriod().getNumber())) {
                            isSuc = false;
                            continue;
                        }
                        EntityViewInfo evi = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        SelectorItemCollection sic = new SelectorItemCollection();
                        String transferOrgId = transferOrg.getId().toString();
                        String bookid = this.getCurrentBook(ctx, transferOrgId).getId().toString();
                        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)transferOrgId));
                        String sql = " select FTagVoucherID from T_BKS_VoucherMessage where FisSuc = 1 and FaccountSchemeID='" + bookid + "' and FSrcVoucherID = '" + info.getId().toString() + "'";
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                        sic.add(new SelectorItemInfo("number"));
                        sic.add(new SelectorItemInfo("period.periodNumber"));
                        sic.add(new SelectorItemInfo("period.periodYear"));
                        sic.add(new SelectorItemInfo("voucherType.*"));
                        sic.add(new SelectorItemInfo("creator.name"));
                        sic.add(new SelectorItemInfo("bookedDate"));
                        sic.add(new SelectorItemInfo("bizStatus"));
                        sic.add(new SelectorItemInfo("voucherAbstract"));
                        sic.add(new SelectorItemInfo("sourceSys"));
                        sic.add(new SelectorItemInfo("sourceType"));
                        sic.add(new SelectorItemInfo("localDebitAmount"));
                        sic.add(new SelectorItemInfo("localCreditAmount"));
                        evi.setSelector(sic);
                        evi.setFilter(filter);
                        VoucherCollection collection = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(evi);
                        if (collection == null || collection.size() == 0) {
                            String message = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"cancel_import_exception", (Locale)ctx.getLocale());
                            logger.error((Object)MessageFormat.format(message, info.getId().toString(), info.getNumber()));
                            FilterInfo filterInfo = new FilterInfo();
                            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)transferOrgId));
                            sql = " select Fid from T_BKS_VoucherMessage where FisSuc = 1 and FaccountSchemeID='" + bookid + "' and FSrcVoucherID = '" + info.getId().toString() + "'";
                            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                            VoucherMessageFactory.getLocalInstance(ctx).delete(filterInfo);
                            isSuc = false;
                            continue;
                        }
                        VoucherInfo infoTemp = collection.get(0);
                        if (infoTemp == null) continue;
                        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"update", (BOSObjectType)this.getBOSType(), null, (String)infoTemp.getNumber(), (String)"books_voucherCancelimp");
                        boolean isReverse = this.isReverse(ctx, infoTemp.getId().toString());
                        if (isReverse) {
                            str.append("\n").append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"TRANSFER8004", (Locale)ctx.getLocale()), transferOrg.getMainOrg().getName(), info.getNumber(), transferOrg.getName()));
                            isSuc = false;
                            continue;
                        }
                        if (BookUtil._existBotRelation(ctx, infoTemp.getId().toString(), infoTemp.getBOSType())) {
                            str.append("\n").append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"TRANSFER8005", (Locale)ctx.getLocale()), transferOrg.getMainOrg().getName(), info.getNumber(), transferOrg.getName()));
                            isSuc = false;
                            continue;
                        }
                        this.cancelImportVoucher(ctx, infoTemp.getId().toString(), transferOrg);
                        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
                    }
                    finally {
                        if (mutex == null || mp == null) continue;
                        mutex.releaseMutex(mp.getRequestId());
                    }
                }
            }
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cachId);
        }
        return str.toString();
    }

    public static MutexParameter buildCancelVoucherParameter(Context ctx, String VoucherID, String transferOrgID) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        MutexParameter mp = new MutexParameter();
        Uuid requestId = Uuid.create();
        mp.setRequestId(requestId);
        String actionName = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"voucher_cancel_import", (Locale)ctx.getLocale());
        mp.setMutexName("books_mutexlock_cancelVoucher_" + VoucherID + "_" + transferOrgID);
        mp.setActionName(actionName);
        mp.setOrgUnitID(BOSUuid.read((String)transferOrgID));
        mp.setUserID(BOSUuid.read((String)userId));
        mp.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        mp.setDcName(ctx.getAIS());
        mp.setDescription(actionName);
        return mp;
    }

    private boolean cancelImportVoucher(Context ctx, String id, CompanyOrgUnitInfo transferOrg) throws BOSException, EASBizException {
        VoucherMessageFacadeControllerBean.deleteVoucher(ctx, id, transferOrg);
        this._deleteVoucherMessageByTagVoucher(ctx, (IObjectPK)new ObjectUuidPK(id));
        return false;
    }

    protected void _deleteVoucherMessageByTagVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        VoucherMessageFactory.getLocalInstance(ctx).delete("where tagVoucher = '" + pk.toString() + "'");
    }

    private static void deleteVoucher(Context ctx, String id, CompanyOrgUnitInfo transferOrg) throws EASBizException, BOSException {
        IGLPeriodEndFacade iGLPeriodEndFacade = GLPeriodEndFacadeFactory.getLocalInstance(ctx);
        VoucherInfo tagvoucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(id));
        String sql = "select FAccountSchemeID,Fcompanyid,FSrcVoucherID from T_BKS_VoucherMessage where FIsSuc=1 and FTAGVOUCHERID=? ";
        IRowSet set = null;
        String[] paramList = new String[]{"G001"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)transferOrg.getId().toString());
        boolean useReport = glParam.getBoolean("G001");
        String transCompanyId = null;
        String tagVoucherid = tagvoucher.getId().toString();
        String srcVoucherID = null;
        try {
            set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tagVoucherid});
            while (set != null && set.next()) {
                List beforeListeners;
                transCompanyId = set.getString(2);
                srcVoucherID = set.getString(3);
                VoucherInfo voucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(tagVoucherid), VoucherInfo.getNumberSelector());
                iGLPeriodEndFacade.postVoucherOnBook(tagvoucher.getCompany().getCU().getId().toString(), transCompanyId, new String[]{tagVoucherid}, useReport, 1, true);
                if (voucher.getBizStatus() == VoucherStatusEnum.POSTED) {
                    iGLPeriodEndFacade.postVoucherOnBook(tagvoucher.getCompany().getCU().getId().toString(), transCompanyId, new String[]{tagVoucherid}, useReport, 5, true);
                }
                if ((beforeListeners = VoucherMessageFacadeControllerBean.getDeleteActionBeforeListeners(ctx)) != null) {
                    for (Object beforeListener : beforeListeners) {
                        ((GLActionListener)beforeListener).actionPerformed(ctx, voucher);
                    }
                }
                voucher.setId(BOSUuid.read((String)tagVoucherid));
                VoucherUtil._deleteAllAcctcussent(ctx, voucher);
                VoucherUtil._deleteAllCashflowRecords(ctx, voucher);
                VoucherUtil._deleteAllCashflowSplitRecords(ctx, voucher);
                VoucherUtil._deleteAllAssistRecords(ctx, voucher);
                VoucherUtil._deleteAllEntries(ctx, voucher);
                VoucherUtil._deleteVoucher(ctx, voucher);
                VoucherUtil._removeBotRelation(ctx, srcVoucherID, tagVoucherid, voucher.getBOSType());
                BoAttchAssoFactory.getLocalInstance((Context)ctx).deleteAllAssociationsByBoID(tagVoucherid);
                List afterListeners = VoucherMessageFacadeControllerBean.getDeleteActionAfterListeners(ctx);
                if (afterListeners == null) continue;
                for (Object afterListener : afterListeners) {
                    ((GLActionListener)afterListener).actionPerformed(ctx, voucher);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    private static List getDeleteActionBeforeListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherDelete", "Before");
    }

    private static List getDeleteActionAfterListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherDelete", "After");
    }

    public boolean isReverse(Context ctx, String id) throws BOSException {
        StringBuffer sqlReverse = new StringBuffer();
        sqlReverse.append("select fid from t_gl_voucher where fsourcebillid=? and FIsReverseVoucher=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlReverse.toString(), (Object[])new Object[]{id, new Integer(1)});
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private BooksRuleInfo getBooksRule(Context ctx, String accountSchemeId, CompanyOrgUnitInfo masterCompany) throws BOSException {
        String key = accountSchemeId + "_" + masterCompany.getId().toString();
        Map<String, Object> datas = VoucherProcessCache.getDatas(ctx, "getBooksRule");
        if (datas.containsKey(key)) {
            return (BooksRuleInfo)datas.get(key);
        }
        BooksRuleInfo ruleInfo = AccountRuleFactory.getLocalInstance((Context)ctx).getRuleS(accountSchemeId, masterCompany);
        datas.put(key, ruleInfo);
        return ruleInfo;
    }

    private CompanyOrgUnitInfo getCurrentMasterCompany(Context ctx, CompanyOrgUnitInfo transferOrg) {
        String transferOrgId = transferOrg.getId().toString();
        Map<String, Object> datas = VoucherProcessCache.getDatas(ctx, "getCurrentMasterCompany");
        if (datas.containsKey(transferOrgId)) {
            return (CompanyOrgUnitInfo)datas.get(transferOrgId);
        }
        CompanyOrgUnitInfo masterCompany = BooksUtil.getCurrentMasterCompany((Context)ctx, (CompanyOrgUnitInfo)transferOrg);
        datas.put(transferOrgId, masterCompany);
        return masterCompany;
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, String currencyId) throws EASBizException, BOSException {
        Map<String, Object> datas = VoucherProcessCache.getDatas(ctx, "getCurrencyInfo");
        if (datas.containsKey(currencyId)) {
            return (CurrencyInfo)datas.get(currencyId);
        }
        CurrencyInfo cur = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        datas.put(currencyId, cur);
        return cur;
    }

    private AcountSchemeInfo getCurrentBook(Context ctx, String transferOrgId) {
        Map<String, Object> datas = VoucherProcessCache.getDatas(ctx, "getCurrentBook");
        if (datas.containsKey(transferOrgId)) {
            return (AcountSchemeInfo)datas.get(transferOrgId);
        }
        AcountSchemeInfo accountScheme = BooksUtil.getCurrentBook((Context)ctx, (String)transferOrgId);
        datas.put(transferOrgId, accountScheme);
        return accountScheme;
    }
}

