/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractBaseObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleEntryCollection;
import com.kingdee.eas.base.codingrule.CodingRuleEntryFactory;
import com.kingdee.eas.base.codingrule.CodingRuleEntryInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.DirectionType;
import com.kingdee.eas.base.codingrule.ICodingRuleEntry;
import com.kingdee.eas.base.codingrule.app.CodingRuleAppUtils;
import com.kingdee.eas.base.codingrule.app.CodingRuleDAO;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherNumberCheckFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractVoucherNumberCheckFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class VoucherNumberCheckFacadeControllerBean
extends AbstractVoucherNumberCheckFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.VoucherNumberCheckFacadeControllerBean");
    private static final int MAX_TIMECOUNT = 10000;
    private final String SplitOfSortValue = "_split_";

    @Override
    protected void _checkVoucherNumber(Context ctx) throws BOSException, EASBizException {
        Calendar cal = Calendar.getInstance();
        GlParam glparam = GlParam.getGlParams((Context)ctx, (String)"GL_VOUCHERCHECKNUMBER_TIME", null);
        int checkVoucherTimeInterval = glparam.getInt("GL_VOUCHERCHECKNUMBER_TIME");
        cal.add(12, -checkVoucherTimeInterval);
        Date checkDate = new Date(cal.getTimeInMillis());
        List companyIdList = null;
        MutexParameter mp = null;
        boolean isLock = false;
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        String companyId = null;
        String curperiodId = null;
        int index = 0;
        while (!isLock) {
            companyIdList = this.isNeedCheckVoucherNumber(ctx);
            if (companyIdList.size() == 0 || index == companyIdList.size()) {
                return;
            }
            Map result = (Map)companyIdList.get(index);
            companyId = (String)result.get("companyId");
            curperiodId = (String)result.get("periodId");
            String userId = null;
            userId = ContextUtil.getCurrentUserInfo((Context)ctx) != null && ContextUtil.getCurrentUserInfo((Context)ctx).getId() != null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : "00000000-0000-0000-0000-00000000000013B7DE7F";
            if (curperiodId == null) {
                return;
            }
            mp = GLMutexUtils.buildModifyMutexParameterForCheckNumber(ctx, companyId, curperiodId, userId);
            isLock = mutex.requestMutex(mp);
            ++index;
        }
        try {
            if (curperiodId == null) {
                return;
            }
            VoucherNumberCheckFacadeFactory.getLocalInstance(ctx).repairVoucherNumber(checkDate, companyId, curperiodId);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            mutex.releaseMutex(mp.getRequestId());
        }
    }

    @Override
    protected void _repairVoucherNumber(Context ctx, Date checkDate, String companyId, String curperiodId) throws BOSException, EASBizException {
        try {
            PeriodInfo currPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(curperiodId));
            CompanyOrgUnitInfo company = GlUtils.getCompanyById(ctx, companyId);
            CodingRuleInfo codingRule = this.getCodingRuleInfo(ctx, company, currPeriod);
            if (codingRule == null) {
                this.updateAllVoucherLog(ctx, companyId, currPeriod.getId().toString(), 1);
                return;
            }
            boolean isValidate = this.validateCodingRule(codingRule);
            if (!isValidate) {
                this.updateAllVoucherLog(ctx, companyId, currPeriod.getId().toString(), 1);
                return;
            }
            CodingRuleEntryCollection codienentrys = codingRule.getCodingRuleEntrys();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection select = new SelectorItemCollection();
            select.add(new SelectorItemInfo("id"));
            select.add(new SelectorItemInfo("number"));
            select.add(new SelectorItemInfo("company.id"));
            select.add(new SelectorItemInfo("company.number"));
            select.add(new SelectorItemInfo("period.id"));
            select.add(new SelectorItemInfo("period.number"));
            SorterItemCollection sorter = new SorterItemCollection();
            ArrayList<String> attList = new ArrayList<String>();
            for (int i = 0; i < codienentrys.size(); ++i) {
                CodingRuleEntryInfo codingRuleEntry = codienentrys.get(i);
                if (codingRuleEntry.getCodeAttribute().trim().equals("sn") || codingRuleEntry.getValueAttribute() == null) continue;
                String attr = codingRuleEntry.getValueAttribute().trim();
                select.add(new SelectorItemInfo(attr));
                if (!codingRuleEntry.isIsSortByItem()) continue;
                sorter.add(new SorterItemInfo(attr));
                attList.add(attr);
            }
            sorter.add(new SorterItemInfo("number"));
            String currPeriodId = currPeriod.getId().toString();
            filter.appendFilterItem("company.id", (Object)companyId);
            filter.appendFilterItem("period.id", (Object)currPeriodId);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateStr = sdf.format(checkDate);
            StringBuffer sql = new StringBuffer();
            sql.append("select fvoucherid from ").append(this.getVoucherNumberLogTable()).append(" where fisupdating = 0 and ").append(" fcompanyid = '").append(companyId).append("'  and fperiodId = '").append(currPeriodId).append("' and FACTION = 'getNumber' and ftime <= {ts'").append(dateStr).append("'}");
            Set voucherIdSet = this.getVoucherIdSet(ctx, companyId, currPeriodId, dateStr);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
            ev.setFilter(filter);
            ev.setSelector(select);
            ev.setSorter(sorter);
            ArrayList voucherIdList = new ArrayList(voucherIdSet);
            VoucherCollection coll = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(ev);
            Iterator it = coll.iterator();
            long lastSnNumber = -1L;
            String lastSortItemValue = "$$##";
            HashMap breakNoMap = new HashMap();
            HashMap firstNoMap = new HashMap();
            this.sortCollection(codingRule.getCodingRuleEntrys());
            int creIndex = this.getSNCREIndex(codingRule);
            int step = codingRule.getCodingRuleEntrys().get(creIndex).getStep();
            int initNumber = codingRule.getCodingRuleEntrys().get(creIndex).getInitial();
            HashMap breakNoVoucherMap = new HashMap();
            ArrayList breakNoList = new ArrayList();
            while (it.hasNext()) {
                Map breakNoResultMap;
                String sortItemValue;
                VoucherInfo voucher = (VoucherInfo)it.next();
                voucherIdList.remove(voucher.getId().toString());
                String number = voucher.getNumber();
                String strValue = null;
                if (codingRule.getSeqSegment() != null) {
                    strValue = CodingRuleAppUtils.getPropertyValue((String)codingRule.getSeqSegment().getAttrName(), (IObjectValue)voucher);
                }
                strValue = strValue != null ? strValue : "";
                logger.error((Object)("strValue is: " + strValue));
                logger.error((Object)("sn is at " + creIndex));
                String[] valueStrings = this.getValueStrings(ctx, (IObjectValue)voucher, codingRule, "", creIndex);
                if (codingRule.getCodingRuleEntrys().get(codingRule.getCodingRuleEntrys().size() - 1).getCodeAttribute().trim().equals("check")) {
                    valueStrings[valueStrings.length - 1] = valueStrings[valueStrings.length - 1] + number.substring(number.length() - 1);
                }
                sortItemValue = (sortItemValue = valueStrings[0]).length() > 0 ? sortItemValue : "codingrule_maxserial";
                logger.error((Object)("sortItemValue is:" + sortItemValue));
                String beforeSNNumber = valueStrings[1];
                beforeSNNumber = this.checkString(beforeSNNumber, codingRule.getSplitSign());
                logger.error((Object)("beforeSNNumber is:" + beforeSNNumber));
                String afterSNNumber = valueStrings[2];
                afterSNNumber = this.checkString(afterSNNumber, codingRule.getSplitSign());
                logger.error((Object)("afterSNNumber is:" + afterSNNumber));
                number = this.checkString(number, codingRule.getSplitSign());
                long recycleNumber = this.getRecycleNumber(number, beforeSNNumber, afterSNNumber, codingRule);
                logger.error((Object)("recycleNumber is:" + recycleNumber));
                if (recycleNumber == -9999L) continue;
                boolean isValidNum = false;
                if (strValue != null && strValue.trim().length() > 0) {
                    isValidNum = this.checkRecycleNumber(ctx, codingRule.getCodingRuleEntrys().get(creIndex), sortItemValue, recycleNumber, strValue);
                    logger.error((Object)("strValue is not null isValidNum is:" + String.valueOf(isValidNum)));
                } else {
                    isValidNum = this.checkRecycleNumber(ctx, codingRule.getCodingRuleEntrys().get(creIndex), sortItemValue, recycleNumber);
                    logger.error((Object)("isValidNum is:" + String.valueOf(isValidNum)));
                }
                if (!isValidNum) {
                    logger.error((Object)"check  number false");
                    continue;
                }
                if (lastSnNumber == -1L || !lastSortItemValue.equals(sortItemValue)) {
                    this.checkBeforeFirstNo(ctx, codingRule, voucher, recycleNumber, step, breakNoList, initNumber, companyId, sortItemValue, attList);
                    lastSnNumber = recycleNumber;
                    lastSortItemValue = sortItemValue;
                    continue;
                }
                if (lastSnNumber + (long)step == recycleNumber || lastSnNumber == recycleNumber) {
                    lastSnNumber = recycleNumber;
                    continue;
                }
                if (breakNoMap.get(sortItemValue) == null) {
                    breakNoResultMap = new HashMap<String, VoucherInfo>();
                    breakNoResultMap.put("voucher", voucher);
                    breakNoResultMap.put("breakNoList", new ArrayList());
                    breakNoMap.put(sortItemValue, breakNoResultMap);
                }
                breakNoResultMap = (Map)breakNoMap.get(sortItemValue);
                List sortBreakNoList = (List)breakNoResultMap.get("breakNoList");
                while (lastSnNumber + (long)step < recycleNumber) {
                    long breakNo = lastSnNumber + (long)step;
                    sortBreakNoList.add(breakNo);
                    breakNoResultMap.put("breakNoList", sortBreakNoList);
                    lastSnNumber = breakNo;
                }
                lastSnNumber = recycleNumber;
            }
            this.getBreakNO(ctx, codingRule, breakNoMap, breakNoList);
            Set deleteVchIdSet = this.getDeleteNo(ctx, companyId, currPeriodId, breakNoList, dateStr);
            this.getDisappearVoucherNo(ctx, breakNoList, voucherIdList);
            if (breakNoList.size() > 0) {
                this.checkBreakNOList(ctx, breakNoList, attList);
            }
            for (int i = 0; i < breakNoList.size(); ++i) {
                Map map = (Map)breakNoList.get(i);
                String breakNo = (String)map.get("number");
                VoucherInfo voucher = (VoucherInfo)map.get("voucher");
                if (voucher == null) continue;
                try {
                    CodingRuleFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)voucher, codingRule, breakNo);
                    continue;
                }
                catch (CodingRuleException ce) {
                    logger.error((Object)(breakNo + " recycleNumber error!"), (Throwable)ce);
                }
            }
            voucherIdSet.addAll(deleteVchIdSet);
            voucherIdSet.addAll(voucherIdList);
            this.updateVoucherNumberLog(ctx, voucherIdSet);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _unLockCompany(Context ctx, String companyId) throws BOSException {
        return false;
    }

    private void updateVoucherNumberLog(Context ctx, Set voucherIdSet) throws BOSException {
        if (voucherIdSet.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(this.getVoucherNumberLogTable()).append(" set fisupdating = 1 where fisupdating = 0 and ").append(" fvoucherid in (");
        Iterator it = voucherIdSet.iterator();
        while (it.hasNext()) {
            String voucherId = (String)it.next();
            sql.append("'").append(voucherId).append("'");
            if (!it.hasNext()) continue;
            sql.append(",");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void getDisappearVoucherNo(Context ctx, List breakNoList, List voucherIdList) throws BOSException, UuidException, SQLException {
        if (voucherIdList.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select vnl.fvoucherid,vnl.FNUMBER,vnl.FVOUCHERTYPEID,vnl.FPERIODID,vnl.FCOMPANYID,vt.FNAME_").append(ctx.getLocale().getLanguage()).append(" vtName,vt.FNUMBER vtNumber,p.fnumber periodNumber,p.FPERIODYEAR,p.FPERIODNUMBER,p.FBEGINDATE,p.FENDDATE,company.fnumber companyNumber,company.FNAME_").append(ctx.getLocale().getLanguage()).append(" companyName from ").append(this.getVoucherNumberLogTable()).append(" vnl inner join t_bd_vouchertypes vt on vt.fid = vnl.FVOUCHERTYPEID inner join t_bd_period p on p.fid = vnl.fperiodid ").append(" inner join t_org_company company on company.fid = vnl.fcompanyid where fisupdating = 0 and vnl.FACTION = ?  and ").append(" vnl.fvoucherid in (");
        for (int i = 0; i < voucherIdList.size(); ++i) {
            if (i != 0) {
                sql.append(" ,");
            }
            sql.append("'");
            sql.append(voucherIdList.get(i));
            sql.append("'");
        }
        sql.append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"getNumber"});
        while (rs.next()) {
            VoucherInfo voucher = new VoucherInfo();
            if ("".equals(rs.getString("FNUMBER"))) continue;
            voucher.setNumber(rs.getString("FNUMBER"));
            voucher.setId(BOSUuid.read((String)rs.getString("fvoucherid")));
            if (rs.getString("FVOUCHERTYPEID") != null && !"".equals(rs.getString("FVOUCHERTYPEID"))) {
                VoucherTypeInfo voucherType = new VoucherTypeInfo();
                voucherType.setId(BOSUuid.read((String)rs.getString("FVOUCHERTYPEID")));
                voucherType.setName(rs.getString("vtName"));
                voucherType.setNumber(rs.getString("vtNumber"));
                voucher.setVoucherType(voucherType);
            }
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)rs.getString("FCOMPANYID")));
            company.setNumber(rs.getString("companyNumber"));
            company.setName(rs.getString("companyName"));
            voucher.setCompany(company);
            PeriodInfo period = new PeriodInfo();
            period.setId(BOSUuid.read((String)rs.getString("FPERIODID")));
            period.setNumber(rs.getInt("periodNumber"));
            period.setPeriodNumber(rs.getInt("FPERIODNUMBER"));
            period.setPeriodYear(rs.getInt("FPERIODYEAR"));
            period.setBeginDate((java.util.Date)rs.getDate("FBEGINDATE"));
            period.setEndDate(rs.getTimestamp("FENDDATE"));
            voucher.setPeriod(period);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("voucher", voucher);
            resultMap.put("number", rs.getString("FNUMBER"));
            breakNoList.add(resultMap);
        }
    }

    private Set getDeleteNo(Context ctx, String companyId, String currPeriodId, List breakNoList, String dateStr) throws BOSException, SQLException {
        HashSet<String> voucherIdSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select vnl.fvoucherid,vnl.FNUMBER,vnl.FVOUCHERTYPEID,vnl.FPERIODID,vnl.FCOMPANYID,vt.FNAME_").append(ctx.getLocale().getLanguage()).append(" vtName,vt.FNUMBER vtNumber,p.fnumber periodNumber,p.FPERIODYEAR,p.FPERIODNUMBER,p.FBEGINDATE,p.FENDDATE,company.fnumber companyNumber,company.FNAME_").append(ctx.getLocale().getLanguage()).append(" companyName from ").append(this.getVoucherNumberLogTable()).append(" vnl inner join t_bd_vouchertypes vt on vt.fid = vnl.FVOUCHERTYPEID inner join t_bd_period p on p.fid = vnl.fperiodid ").append(" inner join t_org_company company on company.fid = vnl.fcompanyid where fisupdating = 0 and ").append(" vnl.fcompanyid = ?  and vnl.fperiodId = ? and vnl.FACTION = ? and vnl.ftime <= {ts'").append(dateStr).append("'} ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, currPeriodId, "recycleNumber"});
        while (rs.next()) {
            voucherIdSet.add(rs.getString("fvoucherid"));
            VoucherInfo voucher = new VoucherInfo();
            voucher.setNumber(rs.getString("FNUMBER"));
            voucher.setId(BOSUuid.read((String)rs.getString("fvoucherid")));
            VoucherTypeInfo voucherType = new VoucherTypeInfo();
            voucherType.setId(BOSUuid.read((String)rs.getString("FVOUCHERTYPEID")));
            voucherType.setName(rs.getString("vtName"));
            voucherType.setNumber(rs.getString("vtNumber"));
            voucher.setVoucherType(voucherType);
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)rs.getString("FCOMPANYID")));
            company.setNumber(rs.getString("companyNumber"));
            company.setName(rs.getString("companyName"));
            voucher.setCompany(company);
            PeriodInfo period = new PeriodInfo();
            period.setId(BOSUuid.read((String)rs.getString("FPERIODID")));
            period.setNumber(rs.getInt("periodNumber"));
            period.setPeriodNumber(rs.getInt("FPERIODNUMBER"));
            period.setPeriodYear(rs.getInt("FPERIODYEAR"));
            period.setBeginDate((java.util.Date)rs.getDate("FBEGINDATE"));
            period.setEndDate(rs.getTimestamp("FENDDATE"));
            voucher.setPeriod(period);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("voucher", voucher);
            resultMap.put("number", rs.getString("FNUMBER"));
            breakNoList.add(resultMap);
        }
        return voucherIdSet;
    }

    private void getBreakNO(Context ctx, CodingRuleInfo codingRule, Map breakNoMap, List breakNoList) throws BOSException, CodingRuleException, EASBizException {
        for (String key : breakNoMap.keySet()) {
            Map breakNoResultMap = (Map)breakNoMap.get(key);
            VoucherInfo voucher = (VoucherInfo)breakNoResultMap.get("voucher");
            List sortBreakNoList = (List)breakNoResultMap.get("breakNoList");
            for (int i = 0; i < sortBreakNoList.size(); ++i) {
                long snNO = (Long)sortBreakNoList.get(i);
                String[] breakNo = this._getBatchNumber(ctx, (IObjectValue)voucher, (IObjectValue)codingRule, null, 1, (int)snNO);
                if (breakNo == null || breakNo.length <= 0) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("number", breakNo[0]);
                map.put("voucher", (String)voucher);
                breakNoList.add(map);
            }
        }
    }

    private void checkBeforeFirstNo(Context ctx, CodingRuleInfo codingRule, VoucherInfo voucher, long firstNo, int step, List breakNoList, int initNumber, String companyId, String sortItemValue, List attList) throws CodingRuleException, EASBizException, BOSException, SQLException {
        boolean isCheck = false;
        long i = 1L;
        while (!isCheck) {
            isCheck = this.checkBeforeNo(ctx, companyId, voucher, codingRule, firstNo, step, breakNoList, initNumber, i, sortItemValue, attList);
            if ((firstNo -= i * firstNo) < (long)initNumber) break;
            i *= 2L;
        }
    }

    private boolean checkBeforeNo(Context ctx, String companyId, VoucherInfo voucher, CodingRuleInfo codingRule, long firstNo, int step, List breakNoList, int initNumber, long amount, String sortItemValue, List attList) throws CodingRuleException, EASBizException, BOSException, SQLException {
        String[] numbers;
        if (firstNo - (long)initNumber < 0L) {
            return true;
        }
        boolean isCheck = false;
        if ((firstNo - (long)initNumber) / (long)step < amount) {
            amount = (firstNo - (long)initNumber) / (long)step;
        }
        if ((numbers = this._getBatchNumber(ctx, (IObjectValue)voucher, (IObjectValue)codingRule, null, (int)amount, (int)(firstNo - amount * (long)step))) == null || numbers.length == 0) {
            return true;
        }
        ArrayList numberList = new ArrayList(numbers.length);
        for (int i = 0; i < numbers.length; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", numbers[i]);
            map.put("voucher", (String)voucher);
            numberList.add(map);
        }
        isCheck = this.checkBreakNOList(ctx, numberList, attList);
        breakNoList.addAll(numberList);
        return isCheck;
    }

    private boolean checkBreakNOList(Context ctx, List numberList, List attList) throws BOSException, SQLException, EASBizException {
        boolean isCheck = false;
        ArrayList<Map> removeList = new ArrayList<Map>();
        for (int i = 0; i < numberList.size(); ++i) {
            Map map = (Map)numberList.get(i);
            VoucherInfo voucher = (VoucherInfo)map.get("voucher");
            String number = (String)map.get("number");
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("number", (Object)number);
            filter.appendFilterItem("company.id", (Object)voucher.getCompany().getId().toString());
            filter.appendFilterItem("period.id", (Object)voucher.getPeriod().getId().toString());
            for (int j = 0; j < attList.size(); ++j) {
                String attr = (String)attList.get(j);
                String[] attrs = attr.split("\\.");
                Object value = null;
                for (int k = 0; k < attrs.length; ++k) {
                    if (k == 0) {
                        value = voucher.get(attrs[k]);
                        continue;
                    }
                    if (value instanceof AbstractBaseObjectValue) {
                        value = ((AbstractBaseObjectValue)value).get(attrs[k]);
                        continue;
                    }
                    value = null;
                    break;
                }
                if (value == null) continue;
                filter.appendFilterItem(attr, value);
            }
            if (!VoucherFactory.getLocalInstance((Context)ctx).exists(filter)) continue;
            removeList.add(map);
        }
        numberList.removeAll(removeList);
        return numberList.size() == 0;
    }

    private boolean checkRecycleNumber(Context ctx, CodingRuleEntryInfo cre, String sortItemValue, long recycleNumber, String attrValue) throws BOSException {
        RowSet rowset = CodingRuleDAO.getMaxSerialInfoValueOfSegment((Context)ctx, (String)cre.getId().toString(), (String)sortItemValue, (String)attrValue);
        try {
            boolean flag = rowset.next();
            logger.error((Object)("checkRecycleNumber attrValue is:" + String.valueOf(flag)));
            if (!flag) {
                if (sortItemValue.indexOf(this.SplitOfSortValue) != -1) {
                    rowset = CodingRuleDAO.getMaxSerialInfoValue((Context)ctx, (String)cre.getId().toString(), (String)sortItemValue.replaceAll(this.SplitOfSortValue, ""));
                    flag = rowset.next();
                    logger.info((Object)("getMaxSerialInfoValue's flag is: " + String.valueOf(flag)));
                }
                if (!flag) {
                    return false;
                }
            }
            long serialNumber = rowset.getLong("FSerialNumber");
            if (cre.getStep() >= 0 && serialNumber != -1L ? recycleNumber < (long)cre.getInitial() || recycleNumber > serialNumber : cre.getStep() < 0 && serialNumber != -1L && (recycleNumber > (long)cre.getInitial() || recycleNumber < serialNumber)) {
                return false;
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return true;
    }

    private boolean checkRecycleNumber(Context ctx, CodingRuleEntryInfo cre, String sortItemValue, long recycleNumber) throws BOSException {
        RowSet rowset = CodingRuleDAO.getMaxSerialInfoValue((Context)ctx, (String)cre.getId().toString(), (String)sortItemValue);
        try {
            boolean flag = rowset.next();
            if (!flag) {
                if (sortItemValue.indexOf(this.SplitOfSortValue) != -1) {
                    rowset = CodingRuleDAO.getMaxSerialInfoValue((Context)ctx, (String)cre.getId().toString(), (String)sortItemValue.replaceAll(this.SplitOfSortValue, ""));
                    flag = rowset.next();
                }
                if (!flag) {
                    return false;
                }
            }
            long serialNumber = rowset.getLong("FSerialNumber");
            if (cre.getStep() >= 0 ? recycleNumber < (long)cre.getInitial() || recycleNumber > serialNumber : recycleNumber > (long)cre.getInitial() || recycleNumber < serialNumber) {
                return false;
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private long getRecycleNumber(String number, String beforeSNNumber, String afterSNNumber, CodingRuleInfo codingrule) throws BOSException, CodingRuleException {
        dateIsBefore = false;
        dateIsAfter = false;
        creIndex = this.getSNCREIndex(codingrule);
        dateIndex = this.getDateCREIndex(codingrule);
        if (creIndex > 0 && dateIndex >= 0) {
            try {
                if (creIndex > dateIndex) {
                    dateIsBefore = true;
                } else {
                    dateIsAfter = true;
                }
                if (dateIsBefore || dateIsAfter) {
                    modelnumber = null;
                    if (dateIsBefore) {
                        if (number.length() > beforeSNNumber.length()) {
                            modelnumber = number.substring(beforeSNNumber.length(), number.length());
                        } else {
                            return -9999L;
                        }
                    }
                    if (dateIsAfter) {
                        if (number.length() > afterSNNumber.length()) {
                            modelnumber = number.substring(number.length() - afterSNNumber.length(), number.length());
                        } else {
                            return -9999L;
                        }
                    }
                    if (number.indexOf(modelnumber) < 0) {
                        return -9999L;
                    }
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                return -9999L;
            }
            beforeSNNumber = beforeSNNumber == null ? "" : beforeSNNumber;
            afterSNNumber = afterSNNumber == null ? "" : afterSNNumber;
        } else {
            beforeSNNumber = beforeSNNumber == null ? "" : beforeSNNumber;
            v0 = afterSNNumber = afterSNNumber == null ? "" : afterSNNumber;
            if (number.indexOf(beforeSNNumber) < 0 || number.indexOf(afterSNNumber) < 0) {
                return -9999L;
            }
        }
        if (number.indexOf("\\") != -1) {
            number = number.replaceAll("\\\\", "");
        }
        if (beforeSNNumber.indexOf("\\") != -1) {
            beforeSNNumber = beforeSNNumber.replaceAll("\\\\", "");
        }
        if (afterSNNumber.indexOf("\\") != -1) {
            afterSNNumber = afterSNNumber.replaceAll("\\\\", "");
        }
        if (dateIsBefore || dateIsAfter) {
            VoucherNumberCheckFacadeControllerBean.logger.error((Object)" if (dateIsBefore || dateIsAfter) ");
            try {
                if (dateIsBefore) {
                    VoucherNumberCheckFacadeControllerBean.logger.error((Object)"dateIsBefore");
                    VoucherNumberCheckFacadeControllerBean.logger.error((Object)("beforeSNNumber is:" + beforeSNNumber));
                    VoucherNumberCheckFacadeControllerBean.logger.error((Object)("number is:" + number));
                    number = number.substring(beforeSNNumber.length(), number.length());
                    if (afterSNNumber != null && afterSNNumber.length() > 0) {
                        VoucherNumberCheckFacadeControllerBean.logger.error((Object)("number is:" + number));
                        VoucherNumberCheckFacadeControllerBean.logger.error((Object)("afterSNNumber is:" + afterSNNumber));
                        number = number.substring(0, number.length() - afterSNNumber.length());
                    }
                }
                if (!dateIsAfter) ** GOTO lbl69
                VoucherNumberCheckFacadeControllerBean.logger.error((Object)("number is:" + number));
                VoucherNumberCheckFacadeControllerBean.logger.error((Object)("afterSNNumber is:" + afterSNNumber));
                number = number.substring(0, number.length() - afterSNNumber.length());
                if (beforeSNNumber == null || beforeSNNumber.length() <= 0) ** GOTO lbl69
                VoucherNumberCheckFacadeControllerBean.logger.error((Object)("number is:" + number));
                VoucherNumberCheckFacadeControllerBean.logger.error((Object)("beforeSNNumber is:" + beforeSNNumber));
                number = number.substring(beforeSNNumber.length());
            }
            catch (StringIndexOutOfBoundsException e) {
                return -9999L;
            }
        } else {
            VoucherNumberCheckFacadeControllerBean.logger.error((Object)("else beforeSNNumber is:" + beforeSNNumber));
            number = number.substring(beforeSNNumber.length());
            VoucherNumberCheckFacadeControllerBean.logger.error((Object)("else number is:" + number));
            VoucherNumberCheckFacadeControllerBean.logger.error((Object)("else afterSNNumber is:" + afterSNNumber));
            number = number.substring(0, number.length() - afterSNNumber.length());
        }
lbl69:
        // 4 sources

        tempstr = "";
        if (codingrule.getSplitSign() != null && codingrule.getSplitSign().trim().length() > 0 && codingrule.getCodingRuleEntrys().size() != 0) {
            for (i = 0; i < codingrule.getCodingRuleEntrys().size(); ++i) {
                if (number.indexOf(codingrule.getSplitSign()) == -1) continue;
                num = number.indexOf("-");
                tempstr = tempstr + number.substring(0, num);
                number = number.substring(num + 1, number.length());
            }
            number = tempstr = tempstr + number;
        }
        try {
            recycleNumbeObj = new Long(number);
            return recycleNumbeObj;
        }
        catch (NumberFormatException err) {
            return -9999L;
        }
    }

    private String checkString(String str, String checkStr) {
        while (str.indexOf(checkStr) != -1) {
            int num = str.indexOf(checkStr);
            str = str.substring(0, num) + str.substring(num + 1, str.length());
        }
        return str;
    }

    private int getDateCREIndex(CodingRuleInfo codingruleVO) throws BOSException, CodingRuleException {
        for (int i = 0; i < codingruleVO.getCodingRuleEntrys().size(); ++i) {
            CodingRuleEntryInfo creVO = codingruleVO.getCodingRuleEntrys().get(i);
            if (!creVO.getCodeAttribute().trim().equals("systime")) continue;
            return i;
        }
        return -9999;
    }

    private String[] getValueStrings(Context ctx, IObjectValue caller, CodingRuleInfo codingruleVO, String customStr, int creIndex) throws BOSException, CodingRuleException, EASBizException {
        StringBuffer sortValue = new StringBuffer();
        StringBuffer sbCodeRuleBefore = new StringBuffer();
        StringBuffer sbCodeRuleAfter = new StringBuffer();
        boolean before = true;
        ICodingRuleEntry iCodingRuleEntry = CodingRuleEntryFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < codingruleVO.getCodingRuleEntrys().size(); ++i) {
            logger.debug((Object)"");
            logger.debug((Object)("_getNumber begin....for::: " + i));
            logger.info((Object)("feilu object is" + codingruleVO.getCodingRuleEntrys().get(i).getCodeAttribute()));
            CodingRuleEntryInfo creVO = codingruleVO.getCodingRuleEntrys().get(i);
            creVO.setCodingRule(codingruleVO);
            if (before) {
                if (codingruleVO.getSplitSign() != null && codingruleVO.getSplitSign().trim().length() > 0 && creVO.getSerialNumber() != 1 && creVO.isIsSplitSign() && sbCodeRuleBefore.length() > 0) {
                    sbCodeRuleBefore.append(codingruleVO.getSplitSign());
                }
            } else if (codingruleVO.getSplitSign() != null && codingruleVO.getSplitSign().trim().length() > 0 && creVO.getSerialNumber() != 1 && creVO.isIsSplitSign()) {
                sbCodeRuleAfter.append(codingruleVO.getSplitSign());
            }
            String strCRE = "";
            if (creVO.getCodeAttribute().trim().equals("sn")) {
                strCRE = "";
                before = false;
            } else {
                strCRE = iCodingRuleEntry.getCREString(caller, creVO);
            }
            if ("isCustom == true".equals(strCRE)) {
                strCRE = customStr != null && customStr.trim().length() > 0 ? customStr.trim() : "";
            }
            strCRE = this.formatString(creVO, strCRE);
            logger.debug((Object)("strCRE after formatString:" + strCRE));
            if (!creVO.getCodeAttribute().trim().equals("sn") && creVO.isIsSortByItem()) {
                if (sortValue.toString().length() > 0) {
                    sortValue.append("_split_");
                }
                sortValue.append(strCRE);
            }
            if (!creVO.isIsDisplay()) continue;
            if (before) {
                sbCodeRuleBefore.append(strCRE);
                continue;
            }
            sbCodeRuleAfter.append(strCRE);
        }
        String[] values = new String[]{sortValue.toString(), sbCodeRuleBefore.toString() == null ? "" : sbCodeRuleBefore.toString(), sbCodeRuleAfter.toString() == null ? "" : sbCodeRuleAfter.toString()};
        return values;
    }

    private Set getVoucherIdSet(Context ctx, String companyId, String currPeriodId, String dateStr) throws BOSException, SQLException {
        HashSet<String> voucherIdSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select fvoucherid from ").append(this.getVoucherNumberLogTable()).append(" where fisupdating = 0 and ").append(" fcompanyid = ?  and fperiodId = ? and FACTION = ? and ftime <= {ts'").append(dateStr).append("'}");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, currPeriodId, "getNumber"});
        while (rs.next()) {
            voucherIdSet.add(rs.getString("fvoucherid"));
        }
        return voucherIdSet;
    }

    private void deleteVoucherLog(Context ctx, String companyId, String currPeriodId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete ").append(this.getVoucherNumberLogTable()).append(" where  ").append(" fcompanyid = ?  and fperiodId = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, currPeriodId});
    }

    private void updateAllVoucherLog(Context ctx, String companyId, String currPeriodId, int status) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update  ").append(this.getVoucherNumberLogTable()).append(" set fisupdating = ? where  ").append(" fcompanyid = ?  and fperiodId = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{status, companyId, currPeriodId});
    }

    private boolean validateCodingRule(CodingRuleInfo codingRule) {
        boolean isNotAllowNumberBreak = false;
        boolean bl = isNotAllowNumberBreak = codingRule.isIsMainRule() || codingRule.isIsaddnewbreak();
        if (!isNotAllowNumberBreak) {
            return false;
        }
        if (!codingRule.isOrgFirst()) {
            return false;
        }
        boolean isContainPeriod = false;
        boolean isContainSn = false;
        if (codingRule != null && codingRule.getCodingRuleEntrys().size() > 0) {
            for (int i = 0; i < codingRule.getCodingRuleEntrys().size(); ++i) {
                if (codingRule.getCodingRuleEntrys().get(i).getCodeAttribute().trim().equals("systime")) {
                    return false;
                }
                if (codingRule.getCodingRuleEntrys().get(i).getCodeAttribute() != null && codingRule.getCodingRuleEntrys().get(i).getCodeAttribute().trim().equals("sn")) {
                    isContainSn = true;
                }
                if (codingRule.getCodingRuleEntrys().get(i).getValueAttribute() == null || !"period.periodNumber".equals(codingRule.getCodingRuleEntrys().get(i).getValueAttribute())) continue;
                isContainPeriod = true;
            }
        }
        return isContainSn && isContainPeriod;
    }

    private List isNeedCheckVoucherNumber(Context ctx) throws BOSException {
        ArrayList companyIdList = new ArrayList();
        StringBuffer sql = new StringBuffer();
        boolean isMSSQLServer = this.isMSSQLSERVER(ctx);
        if (isMSSQLServer) {
            sql.append("/*dialect*/ ");
        }
        sql.append("select distinct fcompanyid,fperiodid from ").append(this.getVoucherNumberLogTable());
        if (isMSSQLServer) {
            sql.append(" with(readpast)");
        }
        sql.append(" where fisupdating = 0");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("companyId", rs.getString("fcompanyid"));
                result.put("periodId", rs.getString("fperiodid"));
                companyIdList.add(result);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return companyIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMSSQLSERVER(Context ctx) {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            boolean bl = 3 == dbType;
            return bl;
        }
        catch (SQLException e) {
            logger.error((Object)"EJBFactory getConnection error!", (Throwable)e);
        }
        finally {
            if (conn != null) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return false;
    }

    protected void _fillTransaction(Context ctx, String companyId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select cp.fid from " + this.getOrgTable() + " cp ");
        if (companyId != null) {
            sql.append(" where cp.fid = '" + companyId + "' and ");
        } else {
            sql.append(" where ");
        }
        sql.append(" not exists (select 1 from t_bas_transaction t where t.fid = cp.fid and t.fnumber = 'checkVoucherNumber' and t.fsystype = " + this.getSystemTypeValue() + ")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                StringBuffer insertSql = new StringBuffer();
                insertSql.append(" insert into t_bas_transaction(fid,fsystype,fnumber,fupdatetime,ftimecount,fisupdating) ");
                insertSql.append(" select cp.fid," + this.getSystemTypeValue() + " fsystype,'checkVoucherNumber' fnumber, getDate() fupdatetime,0 ftimecount,0 fisupdating ");
                insertSql.append(" from " + this.getOrgTable() + " cp ");
                if (companyId != null) {
                    insertSql.append(" where cp.fid = '" + companyId + "' and ");
                } else {
                    insertSql.append(" where ");
                }
                insertSql.append(" not exists (select 1 from t_bas_transaction t where t.fid = cp.fid and t.fsystype = " + this.getSystemTypeValue() + ")");
                DbUtil.execute((Context)ctx, (String)insertSql.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
    }

    protected int getSystemTypeValue() {
        return 6;
    }

    protected String getOrgTable() {
        return "t_org_company";
    }

    private String listId2StrId(String[] companyIds) {
        if (companyIds != null) {
            StringBuffer cpIds = new StringBuffer();
            for (int i = 0; i < companyIds.length; ++i) {
                if (i > 0) {
                    cpIds.append(",");
                }
                cpIds.append("'").append(companyIds[i]).append("'");
            }
            return cpIds.toString();
        }
        return null;
    }

    private String getVoucherNumberLogTable() {
        return "t_gl_vouchernumberlog";
    }

    @Override
    public boolean _tryLockCompany(Context ctx, String companyId) throws BOSException {
        PreparedStatement ps;
        Connection conn;
        block5: {
            boolean bl;
            String sql = "update t_bas_transaction set fupdateTime = getDate(), ftimecount = case when ftimecount >= 9999 then 0 else ftimecount + 1 end, fisupdating=1 where fnumber = 'checkVoucherNumber' and fsystype = " + this.getSystemTypeValue() + " and fisupdating=0 ";
            if (companyId != null && companyId.length() > 0) {
                sql = sql + " and fid = '" + companyId + "'";
            }
            conn = null;
            ps = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(sql);
                int updateCount = ps.executeUpdate();
                if (updateCount <= 0) break block5;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException("SQL ERROR!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return false;
    }

    private CodingRuleInfo getCodingRuleInfo(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currPeriod) throws EASBizException, BOSException {
        VoucherInfo voucherInfo = new VoucherInfo();
        voucherInfo.setPeriod(currPeriod);
        voucherInfo.setCU(company.getCU());
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        voucherInfo.setCompany(company);
        return CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
    }

    private void sortCollection(CodingRuleEntryCollection sourceCRE) {
        int i;
        if (sourceCRE.size() == 0) {
            return;
        }
        CodingRuleEntryCollection sortCRE = new CodingRuleEntryCollection();
        CodingRuleEntryInfo[] creCompare = new CodingRuleEntryInfo[sourceCRE.size()];
        for (i = 0; i < sourceCRE.size(); ++i) {
            creCompare[i] = sourceCRE.get(i);
        }
        for (i = 0; i < creCompare.length; ++i) {
            for (int j = i + 1; j < creCompare.length; ++j) {
                if (creCompare[i].getSerialNumber() <= creCompare[j].getSerialNumber() && (creCompare[i].getSerialNumber() != creCompare[j].getSerialNumber() || creCompare[i].getCodeSerialNumber() <= creCompare[j].getCodeSerialNumber())) continue;
                CodingRuleEntryInfo creMin = creCompare[i];
                creCompare[i] = creCompare[j];
                creCompare[j] = creMin;
            }
        }
        for (i = 0; i < creCompare.length; ++i) {
            sortCRE.add(creCompare[i]);
        }
        sourceCRE.clear();
        for (i = 0; i < sortCRE.size(); ++i) {
            sourceCRE.add(sortCRE.get(i));
        }
    }

    private int getSNCREIndex(CodingRuleInfo codingruleVO) throws BOSException, CodingRuleException {
        for (int i = 0; i < codingruleVO.getCodingRuleEntrys().size(); ++i) {
            CodingRuleEntryInfo creVO = codingruleVO.getCodingRuleEntrys().get(i);
            if (!creVO.getCodeAttribute().trim().equals("sn")) continue;
            return i;
        }
        throw new CodingRuleException(CodingRuleException.ERROR_SN_NOTEXIST);
    }

    protected String[] _getBatchNumber(Context ctx, IObjectValue caller, IObjectValue codingruleVo, String customStr, int count, int initial) throws BOSException, CodingRuleException, EASBizException {
        int j;
        if (count == 0) {
            return null;
        }
        if (!(codingruleVo instanceof CodingRuleInfo)) {
            throw new CodingRuleException(CodingRuleException.ERROR_PARAM_TYPE);
        }
        CodingRuleInfo codingruleVO = (CodingRuleInfo)codingruleVo;
        if (caller == null) {
            throw new CodingRuleException(CodingRuleException.ERROR_PARAM_NULL);
        }
        IMetaDataLoader metaLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = metaLoader.getEntity(caller.getBOSType());
        if (!codingruleVO.getBusinessObject().trim().equals(eo.getPackage() + "." + eo.getName())) {
            throw new CodingRuleException(CodingRuleException.ERROR_ENTITY_TYPE);
        }
        StringBuffer sortValue = new StringBuffer();
        logger.debug((Object)"_getNumber begin....");
        ICodingRuleEntry iCodingRuleEntry = CodingRuleEntryFactory.getLocalInstance((Context)ctx);
        StringBuffer[] sbCodeRule = new StringBuffer[count];
        for (int i = 0; i < sbCodeRule.length; ++i) {
            sbCodeRule[i] = new StringBuffer();
        }
        logger.debug((Object)("_getNumber begin....CRE has " + codingruleVO.getCodingRuleEntrys().size()));
        this.sortCollection(codingruleVO.getCodingRuleEntrys());
        this.getSNCREIndex(codingruleVO);
        for (int i = 0; i < codingruleVO.getCodingRuleEntrys().size(); ++i) {
            logger.debug((Object)"");
            logger.debug((Object)("_getNumber begin....for::: " + i));
            CodingRuleEntryInfo creVO = codingruleVO.getCodingRuleEntrys().get(i);
            if (!creVO.isIsDisplay() && !creVO.isIsSplitSign()) continue;
            if (codingruleVO.getSplitSign() != null && codingruleVO.getSplitSign().trim().length() > 0 && creVO.getSerialNumber() != 1 && creVO.isIsSplitSign() && sbCodeRule[0].length() > 0) {
                for (j = 0; j < sbCodeRule.length; ++j) {
                    sbCodeRule[j].append(codingruleVO.getSplitSign());
                }
            }
            if (!creVO.isIsDisplay()) continue;
            String strCRE = "";
            if (creVO.getCodeAttribute().trim().equals("sn")) {
                long maxvalue = initial;
                for (int j2 = 0; j2 < count; ++j2) {
                    strCRE = this.formatString(codingruleVO.getCodingRuleEntrys().get(i), maxvalue + (long)(creVO.getStep() * j2) + "");
                    sbCodeRule[j2].append(strCRE);
                }
                strCRE = "";
            } else {
                strCRE = iCodingRuleEntry.getCREString(caller, creVO);
            }
            if (strCRE.equals("isCustom == true")) {
                strCRE = customStr != null && customStr.trim().length() > 0 ? customStr.trim() : "";
            }
            strCRE = this.formatString(codingruleVO.getCodingRuleEntrys().get(i), strCRE);
            logger.debug((Object)("strCRE after formatString:" + strCRE));
            if (!creVO.getCodeAttribute().trim().equals("sn") && creVO.isIsSortByItem()) {
                sortValue.append(strCRE);
            }
            for (j = 0; j < sbCodeRule.length; ++j) {
                sbCodeRule[j].append(strCRE);
            }
        }
        logger.debug((Object)("_getNumber end. sbCodeRule : " + sbCodeRule.toString()));
        String[] codingruleStr = new String[count];
        for (j = 0; j < sbCodeRule.length; ++j) {
            codingruleStr[j] = sbCodeRule[j].toString();
        }
        return codingruleStr;
    }

    private String formatString(CodingRuleEntryInfo creVO, String initStr) throws BOSException {
        logger.debug((Object)("initStr:" + initStr));
        if (creVO.getCodeAttribute().equals("systime") || creVO.getCodeAttribute().equals("attribute") && (creVO.getAttUsingMode().equals("part") || creVO.getAttUsingMode().equals("reference")) || creVO.getCodeAttribute().equals("whole") && (creVO.getAttUsingMode().equals("part") || creVO.getAttUsingMode().equals("reference"))) {
            return initStr;
        }
        if (initStr == null || initStr.trim().length() == 0) {
            return "";
        }
        if (creVO.getLength() > 0 && creVO.getLength() > initStr.length()) {
            logger.debug((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.crResource", (String)"res_3"));
            if (creVO.getFillSign() != null && creVO.getFillSign().length() > 0 || creVO.getCodeAttribute() != null && creVO.getCodeAttribute().equals("sn") && creVO.getLength() > initStr.length()) {
                int fillNumber = creVO.getLength() - initStr.length();
                if (creVO.getFillSignDirection() == DirectionType.Forward) {
                    logger.debug((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.crResource", (String)"res_4"));
                    if (creVO.getCodeAttribute() != null && creVO.getCodeAttribute().equals("sn")) {
                        for (int i = 0; i < fillNumber; ++i) {
                            initStr = "0" + initStr;
                        }
                    } else {
                        for (int i = 0; i < fillNumber; ++i) {
                            initStr = creVO.getFillSign() + initStr;
                        }
                    }
                } else if (creVO.getFillSignDirection() == DirectionType.Backward) {
                    logger.debug((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.crResource", (String)"res_5"));
                    if (creVO.getCodeAttribute() != null && creVO.getCodeAttribute().equals("sn")) {
                        for (int i = 0; i < fillNumber; ++i) {
                            initStr = initStr + "0";
                        }
                    } else {
                        for (int i = 0; i < fillNumber; ++i) {
                            initStr = initStr + creVO.getFillSign();
                        }
                    }
                }
            }
        } else if (creVO.getLength() > 0 && creVO.getLength() < initStr.length()) {
            initStr = "sn".equals(creVO.getCodeAttribute()) ? initStr.substring(initStr.length() - creVO.getLength(), initStr.length()) : initStr.substring(0, creVO.getLength());
        }
        return initStr;
    }
}

