/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.gl.AbstractBaseAccountBalanceInfo;
import com.kingdee.eas.fi.gl.AccountBalanceInfo;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.WSAccountBalanceInfo;
import com.kingdee.eas.fi.gl.app.AbstractWSAccountBalanceControllerBean;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WSAccountBalanceControllerBean
extends AbstractWSAccountBalanceControllerBean {
    private static final long serialVersionUID = 7548884641411031188L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.WSAccountBalanceControllerBean");
    private static final String tableName = "T_GL_TempAccountBalance";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _importAccountBalance(Context ctx, IObjectCollection accountBalanceCols) throws EASBizException, BOSException {
        if (accountBalanceCols == null || accountBalanceCols.size() == 0) {
            return "None AccountBlance";
        }
        String sqlDelete = "delete from  T_GL_TempAccountBalance";
        StringBuffer buffer = new StringBuffer();
        try {
            LowTimer low = new LowTimer();
            low.reset();
            DbUtil.execute((Context)ctx, (String)sqlDelete);
            AccountBalanceInfo acctBalInfo = null;
            CompanyOrgUnitInfo companyOrgUnitInfo = null;
            PeriodInfo period = null;
            CurrencyInfo currencyInfo = null;
            int balType = 5;
            Connection con = null;
            PreparedStatement insert = null;
            PeriodInfo lastPeriod = null;
            PreparedStatement[] arrStmt = new PreparedStatement[1];
            HashMap<String, String> keyMap = new HashMap<String, String>();
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"538_WSAccountBalanceControllerBean", (Locale)ctx.getLocale()) + low.msValue()));
            low.reset();
            HashSet<String> orgNumberSet = new HashSet<String>();
            try {
                con = this.getConnection(ctx);
                int acctCount = 0;
                int count = accountBalanceCols.size();
                for (int i = 0; i < count; ++i) {
                    Object[] exs;
                    WSAccountBalanceInfo wsAccountBal = (WSAccountBalanceInfo)accountBalanceCols.getObject(i);
                    acctBalInfo = new AccountBalanceInfo();
                    String orgnumber = wsAccountBal.getOrgUnitNumber();
                    orgNumberSet.add(orgnumber);
                    Map currencyMap = GlWebServiceUtil.getWsObject(ctx, orgnumber, "currency");
                    Map companyMap = GlWebServiceUtil.getWsObject(ctx, orgnumber, "orgUnit");
                    Map periodMap = GlWebServiceUtil.getWsObject(ctx, orgnumber, "period");
                    Map lastperiodMap = GlWebServiceUtil.getWsObject(ctx, orgnumber, "lastperiod");
                    Map accountViewInfoMap = GlWebServiceUtil.getWsObject(ctx, orgnumber, "accountView");
                    if (!companyMap.containsKey(orgnumber)) {
                        companyOrgUnitInfo = GlWebServiceUtil.getCompany(ctx, orgnumber);
                        if (companyOrgUnitInfo != null) {
                            companyMap.put(orgnumber, companyOrgUnitInfo);
                        }
                    } else {
                        companyOrgUnitInfo = (CompanyOrgUnitInfo)companyMap.get(orgnumber);
                    }
                    if (companyOrgUnitInfo == null) {
                        buffer.append("1001");
                        logger.info((Object)"WSAccountBalanceControllerBean1001");
                        break;
                    }
                    acctBalInfo.setOrgUnit(companyOrgUnitInfo);
                    String comId = companyOrgUnitInfo.getId().toString();
                    String accountNumber = wsAccountBal.getAccountNumber();
                    AccountViewInfo accountViewInfo = null;
                    String accountKey = orgnumber + accountNumber;
                    if (accountViewInfoMap.containsKey(accountKey) && accountViewInfoMap.get(accountKey) != null) {
                        accountViewInfo = (AccountViewInfo)accountViewInfoMap.get(accountKey);
                    } else {
                        accountViewInfo = GlWebServiceUtil.findAccountViewInfoByNumber(ctx, accountNumber, companyOrgUnitInfo);
                        if (accountViewInfo != null) {
                            accountViewInfoMap.put(accountKey, accountViewInfo);
                        }
                    }
                    if (accountViewInfo == null) {
                        buffer.append("1002");
                        logger.info((Object)"WSAccountBalanceControllerBean1002");
                        break;
                    }
                    acctBalInfo.setAccount(accountViewInfo);
                    if (!accountViewInfo.isIsLeaf()) continue;
                    keyMap.put(accountViewInfo.getId().toString(), accountViewInfo.getId().toString());
                    String acctId = accountViewInfo.getId().toString();
                    boolean isQty = accountViewInfo.isIsQty();
                    String curnumber = wsAccountBal.getCurrencyNumber();
                    if (!currencyMap.containsKey(curnumber)) {
                        currencyInfo = GlWebServiceUtil.findCurrencyByNumber(ctx, curnumber);
                        if (currencyInfo != null) {
                            currencyMap.put(curnumber, currencyInfo);
                        }
                    } else {
                        currencyInfo = (CurrencyInfo)currencyMap.get(curnumber);
                    }
                    if (currencyInfo == null) {
                        buffer.append("1003");
                        logger.info((Object)"WSAccountBalanceControllerBean1003");
                        break;
                    }
                    acctBalInfo.setCurrency(currencyInfo);
                    String curId = currencyInfo.getId().toString();
                    acctBalInfo.setBalType(VoucherStatusEnum.POSTED);
                    int year = wsAccountBal.getPeriodYear();
                    int number = wsAccountBal.getPeriodNumber();
                    String typeId = companyOrgUnitInfo.getAccountPeriodType().getId().toString();
                    String periodnumber = year + "_" + number;
                    if (!periodMap.containsKey(periodnumber)) {
                        period = GlWebServiceUtil.fetchPeriod(ctx, typeId, year, number);
                        if (period != null) {
                            periodMap.put(periodnumber, period);
                        }
                    } else {
                        period = (PeriodInfo)periodMap.get(periodnumber);
                    }
                    if (period == null) {
                        buffer.append("1004");
                        break;
                    }
                    if (!lastperiodMap.containsKey(periodnumber)) {
                        lastPeriod = GlWebServiceUtil.getPrePeriodInfo(ctx, period);
                        if (lastPeriod != null) {
                            lastperiodMap.put(periodnumber, lastPeriod);
                        }
                    } else {
                        lastPeriod = (PeriodInfo)lastperiodMap.get(periodnumber);
                    }
                    acctBalInfo.setPeriod(period);
                    String prdId = period.getId().toString();
                    BigDecimal bq = new BigDecimal(String.valueOf(wsAccountBal.getBeginQty()));
                    BigDecimal dq = new BigDecimal(String.valueOf(wsAccountBal.getDebitQty()));
                    BigDecimal cq = new BigDecimal(String.valueOf(wsAccountBal.getCreditQty()));
                    BigDecimal eq = new BigDecimal(String.valueOf(wsAccountBal.getEndQty()));
                    bq = bq.setScale(currencyInfo.getPrecision(), 4);
                    cq = cq.setScale(currencyInfo.getPrecision(), 4);
                    dq = dq.setScale(currencyInfo.getPrecision(), 4);
                    eq = eq.setScale(currencyInfo.getPrecision(), 4);
                    acctBalInfo.setBeginQty(bq);
                    acctBalInfo.setDebitQty(cq);
                    acctBalInfo.setCreditQty(dq);
                    acctBalInfo.setEndQty(eq);
                    BigDecimal bf = new BigDecimal(String.valueOf(wsAccountBal.getBeginBalanceFor()));
                    BigDecimal df = new BigDecimal(String.valueOf(wsAccountBal.getDebitFor()));
                    BigDecimal cf = new BigDecimal(String.valueOf(wsAccountBal.getCreditFor()));
                    BigDecimal ef = new BigDecimal(String.valueOf(wsAccountBal.getEndBalanceFor()));
                    BigDecimal pnf = new BigDecimal(String.valueOf(wsAccountBal.getMonthPnLFor()));
                    bf = bf.setScale(currencyInfo.getPrecision(), 4);
                    df = df.setScale(currencyInfo.getPrecision(), 4);
                    cf = cf.setScale(currencyInfo.getPrecision(), 4);
                    ef = ef.setScale(currencyInfo.getPrecision(), 4);
                    pnf = pnf.setScale(currencyInfo.getPrecision(), 4);
                    acctBalInfo.setBeginBalanceFor(bf);
                    acctBalInfo.setDebitFor(df);
                    acctBalInfo.setCreditFor(cf);
                    acctBalInfo.setEndBalanceFor(ef);
                    acctBalInfo.setMonthPnLFor(pnf);
                    VoucherInfo.ExchangeRateWithValue localchangeRate = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
                    VoucherInfo.ExchangeRateWithValue rptchangeRate = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
                    if ((companyOrgUnitInfo.getBaseCurrency() != null && !currencyInfo.getId().toString().equalsIgnoreCase(companyOrgUnitInfo.getBaseCurrency().getId().toString()) || companyOrgUnitInfo.getReportCurrency() != null && !currencyInfo.getId().toString().equalsIgnoreCase(companyOrgUnitInfo.getReportCurrency().getId().toString())) && (exs = GlWebServiceUtil.getExchangeRate(ctx, companyOrgUnitInfo, currencyInfo, period)) != null) {
                        localchangeRate = (VoucherInfo.ExchangeRateWithValue)exs[0];
                        if (localchangeRate == null) {
                            localchangeRate = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
                        }
                        if ((rptchangeRate = (VoucherInfo.ExchangeRateWithValue)exs[1]) == null) {
                            rptchangeRate = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
                        }
                    }
                    acctBalInfo.setBeginBalanceLocal(localchangeRate.getValue().multiply(acctBalInfo.getBeginBalanceFor()));
                    acctBalInfo.setDebitLocal(localchangeRate.getValue().multiply(acctBalInfo.getDebitFor()));
                    acctBalInfo.setCreditLocal(localchangeRate.getValue().multiply(acctBalInfo.getCreditFor()));
                    acctBalInfo.setEndBalanceLocal(localchangeRate.getValue().multiply(acctBalInfo.getEndBalanceFor()));
                    acctBalInfo.setMonthPnLLocal(localchangeRate.getValue().multiply(acctBalInfo.getMonthPnLFor()));
                    BigDecimal bl = acctBalInfo.getBeginBalanceLocal();
                    BigDecimal dl = acctBalInfo.getDebitLocal();
                    BigDecimal cl = acctBalInfo.getCreditLocal();
                    BigDecimal el = acctBalInfo.getEndBalanceLocal();
                    BigDecimal pnl = acctBalInfo.getMonthPnLLocal();
                    acctBalInfo.setBeginBalanceRpt(rptchangeRate.getValue().multiply(acctBalInfo.getBeginBalanceFor()));
                    acctBalInfo.setDebitRpt(rptchangeRate.getValue().multiply(acctBalInfo.getDebitFor()));
                    acctBalInfo.setCreditRpt(rptchangeRate.getValue().multiply(acctBalInfo.getCreditFor()));
                    acctBalInfo.setEndBalanceRpt(rptchangeRate.getValue().multiply(acctBalInfo.getEndBalanceFor()));
                    acctBalInfo.setMonthPnLRpt(rptchangeRate.getValue().multiply(acctBalInfo.getMonthPnLFor()));
                    BigDecimal br = acctBalInfo.getBeginBalanceRpt();
                    BigDecimal dr = acctBalInfo.getDebitRpt();
                    BigDecimal cr = acctBalInfo.getCreditRpt();
                    BigDecimal er = acctBalInfo.getEndBalanceRpt();
                    BigDecimal pnr = acctBalInfo.getMonthPnLRpt();
                    AbstractBaseAccountBalanceInfo lasAccountBalanceInfot = null;
                    if (lastPeriod != null && lastPeriod.getPeriodYear() == period.getPeriodYear()) {
                        lasAccountBalanceInfot = this.findLastPeriodAccountBalance(ctx, companyOrgUnitInfo, lastPeriod, currencyInfo, accountViewInfo, balType);
                    }
                    if (lasAccountBalanceInfot != null) {
                        acctBalInfo.setYearCreditFor(lasAccountBalanceInfot.getYearCreditFor().add(acctBalInfo.getCreditFor()));
                        acctBalInfo.setYearDebitFor(lasAccountBalanceInfot.getYearDebitFor().add(acctBalInfo.getDebitFor()));
                        acctBalInfo.setYearCreditLocal(lasAccountBalanceInfot.getYearCreditLocal().add(acctBalInfo.getCreditLocal()));
                        acctBalInfo.setYearDebitLocal(lasAccountBalanceInfot.getYearDebitLocal().add(acctBalInfo.getDebitLocal()));
                        acctBalInfo.setYearCreditRpt(lasAccountBalanceInfot.getYearCreditRpt().add(acctBalInfo.getCreditRpt()));
                        acctBalInfo.setYearDebitRpt(lasAccountBalanceInfot.getYearDebitRpt().add(acctBalInfo.getDebitRpt()));
                        acctBalInfo.setYearCreditQty(lasAccountBalanceInfot.getYearCreditQty().add(acctBalInfo.getCreditQty()));
                        acctBalInfo.setYearDebitQty(lasAccountBalanceInfot.getYearDebitQty().add(acctBalInfo.getDebitQty()));
                        acctBalInfo.setYearPnLFor(lasAccountBalanceInfot.getYearPnLFor().add(acctBalInfo.getMonthPnLFor()));
                        acctBalInfo.setYearPnLLocal(lasAccountBalanceInfot.getYearPnLLocal().add(acctBalInfo.getMonthPnLLocal()));
                        acctBalInfo.setYearPnLRpt(lasAccountBalanceInfot.getYearPnLRpt().add(acctBalInfo.getMonthPnLRpt()));
                    } else {
                        acctBalInfo.setYearCreditFor(cf);
                        acctBalInfo.setYearDebitFor(df);
                        acctBalInfo.setYearCreditLocal(cl);
                        acctBalInfo.setYearDebitLocal(dl);
                        acctBalInfo.setYearCreditRpt(cr);
                        acctBalInfo.setYearDebitRpt(dr);
                        acctBalInfo.setYearCreditQty(cq);
                        acctBalInfo.setYearDebitQty(dq);
                        acctBalInfo.setYearPnLFor(pnf);
                        acctBalInfo.setYearPnLLocal(pnl);
                        acctBalInfo.setYearPnLRpt(pnr);
                    }
                    BigDecimal cYf = acctBalInfo.getYearCreditFor();
                    BigDecimal dYf = acctBalInfo.getYearDebitFor();
                    BigDecimal cYl = acctBalInfo.getYearCreditLocal();
                    BigDecimal dYl = acctBalInfo.getYearDebitLocal();
                    BigDecimal cYr = acctBalInfo.getYearCreditRpt();
                    BigDecimal dYr = acctBalInfo.getYearDebitRpt();
                    BigDecimal cYq = acctBalInfo.getYearCreditQty();
                    BigDecimal dYq = acctBalInfo.getYearDebitQty();
                    BigDecimal pnYf = acctBalInfo.getYearPnLFor();
                    BigDecimal pnYl = acctBalInfo.getYearPnLLocal();
                    BigDecimal pnYr = acctBalInfo.getYearPnLRpt();
                    insert = this.getStmtTempInsert(arrStmt, con);
                    this.insertTempBal(insert, balType, comId, prdId, acctId, curId, isQty, false, bf, df, cf, dYf, cYf, ef, bl, dl, cl, dYl, cYl, el, br, dr, cr, dYr, cYr, er, bq, dq, cq, dYq, cYq, eq, pnf, pnl, pnr, pnYf, pnYl, pnYr, year, number);
                    ++acctCount;
                }
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"539_WSAccountBalanceControllerBean", (Locale)ctx.getLocale()) + low.msValue()));
                low.reset();
                if (lastPeriod != null && acctCount > 0) {
                    this.copyLastAccount(ctx, companyOrgUnitInfo, period, lastPeriod, keyMap);
                }
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"540_WSAccountBalanceControllerBean", (Locale)ctx.getLocale()) + low.msValue()));
                low.reset();
            }
            finally {
                this.clearStmts(arrStmt);
                SQLUtils.cleanup(insert, (Connection)con);
            }
            if (buffer.length() == 0) {
                this.sum(ctx, companyOrgUnitInfo, period, currencyInfo, balType);
                buffer.append("1000");
            }
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"541_WSAccountBalanceControllerBean", (Locale)ctx.getLocale()) + low.msValue()));
            low.reset();
            if (orgNumberSet != null && orgNumberSet.size() > 0) {
                for (String orgNum : orgNumberSet) {
                    GlWebServiceUtil.cleanWsObject(ctx, orgNum);
                }
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            logger.error((Object)e1.getMessage());
            return "1111";
        }
        return buffer.toString();
    }

    private AccountBalanceInfo findLastPeriodAccountBalance(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo lastPeriod, CurrencyInfo currencyInfo, AccountViewInfo accountViewInfo, int baltype) throws EASBizException, BOSException {
        if (lastPeriod == null) {
            return null;
        }
        String lastBalSql = "select FYearCreditFor,FYearDebitFor,FYearCreditLocal,FYearDebitLocal,FYearCreditRpt,FYearDebitRpt,FYearCreditQty,FYearDebitQty,FYearPnLFor,FYearPnLLocal,FYearPnLRpt from " + GLBalanceUtils.getAccountBalanceTable(baltype, currencyInfo.getId().toString()) + " where  forgunitid=? and fperiod=? and faccountid=? and fcurrencyid=? ";
        AccountBalanceInfo acctBalInfo = null;
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)lastBalSql, (Object[])new Object[]{companyOrgUnitInfo.getId().toString(), lastPeriod.getNumber(), accountViewInfo.getId().toString(), currencyInfo.getId().toString()});
        try {
            if (rowset != null && rowset.next()) {
                acctBalInfo = new AccountBalanceInfo();
                acctBalInfo.setYearCreditFor(rowset.getBigDecimal("FYearCreditFor"));
                acctBalInfo.setYearDebitFor(rowset.getBigDecimal("FYearDebitFor"));
                acctBalInfo.setYearCreditLocal(rowset.getBigDecimal("FYearCreditLocal"));
                acctBalInfo.setYearDebitLocal(rowset.getBigDecimal("FYearDebitLocal"));
                acctBalInfo.setYearCreditRpt(rowset.getBigDecimal("FYearCreditRpt"));
                acctBalInfo.setYearDebitRpt(rowset.getBigDecimal("FYearDebitRpt"));
                acctBalInfo.setYearCreditQty(rowset.getBigDecimal("FYearCreditQty"));
                acctBalInfo.setYearDebitQty(rowset.getBigDecimal("FYearDebitQty"));
                acctBalInfo.setYearPnLFor(rowset.getBigDecimal("FYearPnLFor"));
                acctBalInfo.setYearPnLLocal(rowset.getBigDecimal("FYearPnLLocal"));
                acctBalInfo.setYearPnLRpt(rowset.getBigDecimal("FYearPnLRpt"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return acctBalInfo;
    }

    private void sum(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo nextPeriod, CurrencyInfo currencyInfo, int balType) throws EASBizException, BOSException {
        String sql = "select t.FCompanyID FCompanyID, t.FPeriodID FPeriodID, pacct.FID FAccountID,pacct.FisQty FisQty, t.FCurrencyID FCurrencyID,\t\t\t\r\n t.FDebitForV FDebitForV, t.FCreditForV FCreditForV, t.FEndBalanceForV FEndBalanceForV,\t\t\t\t\t\t\t\t\r\n t.FDebitLocalV FDebitLocalV, t.FCreditLocalV FCreditLocalV, t.FEndBalanceLocalV FEndBalanceLocalV,\t\t\t\t\t\r\n t.FDebitRptV FDebitRptV, t.FCreditRptV FCreditRptV, t.FEndBalanceRptV FEndBalanceRptV,\t\t\t\t\t\t\t\t\r\n t.FDebitQtyV FDebitQty, t.FCreditQtyV FCreditQtyV, t.FEndQtyV FEndQtyV,pacct.FIsLeaf, \t\t\t\t\t\t\t\t\r\n t.FBeginBalanceFor,t.FBeginBalanceLocal,t.FBeginBalanceRpt,t.FBeginQty, \t\t\t\t\t\t\t\t\t\t\t\r\n t.FYearDebitFor, t.FYearCreditFor ,t.FYearDebitLocal, t.FYearCreditLocal, \t\t\t\t\t\t\t\t\t\t\r\n t.FYearDebitRpt, t.FYearCreditRpt ,t.FYearDebitQty, t.FYearCreditQty \t, t.FMonthPnLFor, t.FYearPnLFor, t.FMonthPnLLocal, t.FYearPnLLocal, t.FMonthPnLRpt, t.FYearPnLRpt\t\t\t\t\t\t\t\t\t\t\t\r\n from\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n (\t\t\r\n select  ForgUnitid FCompanyID, FPeriodID, FAccountID, FCurrencyID,\t\t\r\n\tFDebitFor FDebitForV, FCreditFor FCreditForV, FEndBalanceFor FEndBalanceForV,\t\t\t\r\n\tFDebitLocal FDebitLocalV, FCreditLocal FCreditLocalV, FEndBalanceLocal FEndBalanceLocalV,\t\t\r\n FDebitRpt FDebitRptV, FCreditRpt FCreditRptV, FEndBalanceRpt FEndBalanceRptV,\t\t\t\t\t\t\t\t\r\n FDebitQty FDebitQtyV, FCreditQty FCreditQtyV, FEndQty FEndQtyV,  FBeginBalanceFor,FBeginBalanceLocal,FBeginBalanceRpt,FBeginQty, FYearDebitFor, FYearCreditFor ,FYearDebitLocal, FYearCreditLocal,  FYearDebitRpt, FYearCreditRpt ,FYearDebitQty, FYearCreditQty , FMonthPnLFor, FYearPnLFor, FMonthPnLLocal, FYearPnLLocal, FMonthPnLRpt, FYearPnLRpt from   \r\nT_GL_TempAccountBalance where   FBalType=? and ForgUnitid=? and FPeriodID=? and FCurrencyID=? \t\t\r\n ) t      \t\t\r\n inner join t_BD_AccountView acct\t\t\r\n on t.FAccountID = acct.FID                         \t\t\r\n inner join t_BD_AccountView pacct                                      \t\t\r\n on pacct.Fcompanyid = acct.Fcompanyid    and pacct.faccounttableid = acct.faccounttableid\t\t\r\n and (charindex(pacct.FLongNumber || '!', acct.FLongNumber) = 1 or pacct.fid = acct.fid)        \t\t\r\n order by pacct.fnumber --and pacct.FIsLeaf=0 and acct.FIsLeaf=1 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(balType), companyOrgUnitInfo.getId().toString(), nextPeriod.getId().toString(), currencyInfo.getId().toString()});
        HashMap<String, PreparedStatement> stmts = new HashMap<String, PreparedStatement>();
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            while (rs != null && rs.next()) {
                PreparedStatement stmtInsert;
                String comId = rs.getString(1);
                String prdId = rs.getString(2);
                int prd = nextPeriod.getNumber();
                String acctId = rs.getString(3);
                String curId = rs.getString(5);
                boolean isQty = rs.getInt(4) != 0;
                BigDecimal df = rs.getBigDecimal(6);
                BigDecimal cf = rs.getBigDecimal(7);
                BigDecimal ef = rs.getBigDecimal(8);
                BigDecimal bf = rs.getBigDecimal(19);
                BigDecimal dYf = rs.getBigDecimal(23);
                BigDecimal cYf = rs.getBigDecimal(24);
                BigDecimal dl = rs.getBigDecimal(9);
                BigDecimal cl = rs.getBigDecimal(10);
                BigDecimal el = rs.getBigDecimal(11);
                BigDecimal bl = rs.getBigDecimal(20);
                BigDecimal dYl = rs.getBigDecimal(25);
                BigDecimal cYl = rs.getBigDecimal(26);
                BigDecimal dr = rs.getBigDecimal(12);
                BigDecimal cr = rs.getBigDecimal(13);
                BigDecimal er = rs.getBigDecimal(14);
                BigDecimal br = rs.getBigDecimal(21);
                BigDecimal dYr = rs.getBigDecimal(27);
                BigDecimal cYr = rs.getBigDecimal(28);
                BigDecimal bq = rs.getBigDecimal(22);
                BigDecimal dq = rs.getBigDecimal(15);
                BigDecimal cq = rs.getBigDecimal(16);
                BigDecimal eq = rs.getBigDecimal(17);
                BigDecimal dYq = rs.getBigDecimal(29);
                BigDecimal cYq = rs.getBigDecimal(30);
                BigDecimal pnf = rs.getBigDecimal(31);
                BigDecimal pnYf = rs.getBigDecimal(32);
                BigDecimal pnl = rs.getBigDecimal(33);
                BigDecimal pnYl = rs.getBigDecimal(34);
                BigDecimal pnr = rs.getBigDecimal(35);
                BigDecimal pnYr = rs.getBigDecimal(36);
                boolean isleaf = rs.getInt(18) != 0;
                PreparedStatement stmtUpdate = this.getStmtUpdate(con, stmts, balType, curId, isQty);
                if (this.updateBal(stmtUpdate, balType, comId, prd, acctId, curId, isQty, false, bf, df, cf, dYf, cYf, ef, bl, dl, cl, dYl, cYl, el, br, dr, cr, dYr, cYr, er, bq, dq, cq, dYq, cYq, eq, pnf, pnl, pnr, pnYf, pnYl, pnYr) != 1) {
                    stmtInsert = this.getStmtInsert(con, stmts, balType, curId);
                    this.insertBal(stmtInsert, balType, comId, prd, acctId, curId, isQty, false, bf, df, cf, dYf, cYf, ef, bl, dl, cl, dYl, cYl, el, br, dr, cr, dYr, cYr, er, bq, dq, cq, dYq, cYq, eq, pnf, pnl, pnr, pnYf, pnYl, pnYr, nextPeriod.getPeriodYear(), nextPeriod.getPeriodNumber());
                }
                if (this.updateBal(stmtUpdate = this.getStmtUpdate(con, stmts, balType, "11111111-1111-1111-1111-111111111111DEB58FDC", isQty), balType, comId, prd, acctId, "11111111-1111-1111-1111-111111111111DEB58FDC", isQty, false, bl, dl, cl, dYl, cYl, el, bl, dl, cl, dYl, cYl, el, br, dr, cr, dYr, cYr, er, bq, dq, cq, dYq, cYq, eq, pnf, pnl, pnr, pnYf, pnYl, pnYr) != 1) {
                    stmtInsert = this.getStmtInsert(con, stmts, balType, "11111111-1111-1111-1111-111111111111DEB58FDC");
                    this.insertBal(stmtInsert, balType, comId, prd, acctId, "11111111-1111-1111-1111-111111111111DEB58FDC", isQty, false, bl, dl, cl, dYl, cYl, el, bl, dl, cl, dYl, cYl, el, br, dr, cr, dYr, cYr, er, bq, dq, cq, dYq, cYq, eq, pnf, pnl, pnr, pnYf, pnYl, pnYr, nextPeriod.getPeriodYear(), nextPeriod.getPeriodNumber());
                }
                if (this.updateBal(stmtUpdate = this.getStmtUpdate(con, stmts, balType, "22222222-2222-2222-2222-222222222222DEB58FDC", isQty), balType, comId, prd, acctId, "22222222-2222-2222-2222-222222222222DEB58FDC", isQty, false, br, dr, cr, dYr, cYr, er, br, dr, cr, dYr, cYr, er, br, dr, cr, dYr, cYr, er, bq, dq, cq, dYq, cYq, eq, pnf, pnl, pnr, pnYf, pnYl, pnYr) == 1) continue;
                stmtInsert = this.getStmtInsert(con, stmts, balType, "22222222-2222-2222-2222-222222222222DEB58FDC");
                this.insertBal(stmtInsert, balType, comId, prd, acctId, "22222222-2222-2222-2222-222222222222DEB58FDC", isQty, false, br, dr, cr, dYr, cYr, er, br, dr, cr, dYr, cYr, er, br, dr, cr, dYr, cYr, er, bq, dq, cq, dYq, cYq, eq, pnf, pnl, pnr, pnYf, pnYl, pnYr, nextPeriod.getPeriodYear(), nextPeriod.getPeriodNumber());
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.clearStmts(stmts);
            SQLUtils.cleanup((ResultSet)rs, null, (Connection)con);
        }
    }

    private void copyLastAccount(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo period, PeriodInfo lastPeriod, Map keyMap) throws BOSException, SQLException, EASBizException {
        int size;
        String selectAccountSql = " select fid from t_bd_accountview \t\t\r\nwhere fisleaf=1 and fcompanyid=? and faccounttableid=?  \t\r\n";
        logger.info((Object)(" " + selectAccountSql));
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)selectAccountSql, (Object[])new Object[]{companyOrgUnitInfo.getId().toString(), companyOrgUnitInfo.getAccountTable().getId().toString()});
        ArrayList<String> accountList = new ArrayList<String>();
        if (rowset != null) {
            while (rowset.next()) {
                String id = rowset.getString("fid");
                if (keyMap.containsKey(id)) continue;
                accountList.add(id);
            }
            rowset = null;
        }
        if ((size = accountList.size()) > 0) {
            String tablenameTABLE = this.getTemporaryTableName(ctx);
            String craeteTable = "CREATE TABLE " + tablenameTABLE + " (\tFID varchar (44) NOT NULL)";
            this.createTable(ctx, craeteTable);
            String insertSql = "insert into " + tablenameTABLE + "  ( FID) values(?) ";
            for (int i = 0; i < size; ++i) {
                String id = (String)accountList.get(i);
                DbUtil.execute((Context)ctx, (String)insertSql, (Object[])new Object[]{id});
            }
            String selectBalSql = " select ForgUnitid , FPeriod, FAccountID, FCurrencyID,\t\t\r\n\t  FEndBalanceFor ,FEndBalanceLocal ,FEndBalanceRpt, FEndQty ,    \t\t\t\t\t\r\n   FYearDebitFor, FYearCreditFor ,FYearDebitLocal, FYearCreditLocal,   \t\t\t\t\r\n   FYearDebitRpt, FYearCreditRpt ,FYearDebitQty, FYearCreditQty ,      \t\t\t\t\r\n   FYearPnLFor,  FYearPnLLocal,  FYearPnLRpt from   \t\t\t\t\t\t\t\t\t\r\n   " + GLBalanceUtils.getAccountBalanceTable(5) + " bal   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n\t  inner join " + tablenameTABLE + " acct on bal.FAccountID=acct.fid\t \t\t\t\t\t\t\r\n   where ForgUnitid=? and FPeriod=? \t\t\t\t\t\t\t\t\r\n  \r\n";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectBalSql, (Object[])new Object[]{companyOrgUnitInfo.getId().toString(), lastPeriod.getNumber()});
            logger.info((Object)(" " + selectBalSql));
            if (rs != null) {
                Connection con = this.getConnection(ctx);
                PreparedStatement[] arrStmt = new PreparedStatement[1];
                String prdId = period.getId().toString();
                while (rs != null && rs.next()) {
                    int baltype = rs.getInt(1);
                    String comId = rs.getString(2);
                    String acctId = rs.getString(4);
                    String curId = rs.getString(5);
                    BigDecimal df = GlUtils.zero;
                    BigDecimal cf = GlUtils.zero;
                    BigDecimal ef = rs.getBigDecimal(6);
                    BigDecimal bf = rs.getBigDecimal(6);
                    BigDecimal dYf = rs.getBigDecimal(10);
                    BigDecimal cYf = rs.getBigDecimal(11);
                    BigDecimal dl = GlUtils.zero;
                    BigDecimal cl = GlUtils.zero;
                    BigDecimal el = rs.getBigDecimal(7);
                    BigDecimal bl = rs.getBigDecimal(7);
                    BigDecimal dYl = rs.getBigDecimal(12);
                    BigDecimal cYl = rs.getBigDecimal(13);
                    BigDecimal dr = GlUtils.zero;
                    BigDecimal cr = GlUtils.zero;
                    BigDecimal er = rs.getBigDecimal(8);
                    BigDecimal br = rs.getBigDecimal(8);
                    BigDecimal dYr = rs.getBigDecimal(14);
                    BigDecimal cYr = rs.getBigDecimal(15);
                    BigDecimal bq = GlUtils.zero;
                    BigDecimal dq = GlUtils.zero;
                    BigDecimal cq = rs.getBigDecimal(9);
                    BigDecimal eq = rs.getBigDecimal(9);
                    BigDecimal dYq = rs.getBigDecimal(16);
                    BigDecimal cYq = rs.getBigDecimal(17);
                    BigDecimal pnf = GlUtils.zero;
                    BigDecimal pnYf = rs.getBigDecimal(18);
                    BigDecimal pnl = GlUtils.zero;
                    BigDecimal pnYl = rs.getBigDecimal(19);
                    BigDecimal pnr = GlUtils.zero;
                    BigDecimal pnYr = rs.getBigDecimal(20);
                    PreparedStatement stmtInsert = this.getStmtTempInsert(arrStmt, con);
                    this.insertTempBal(stmtInsert, baltype, comId, prdId, acctId, curId, true, false, bf, df, cf, dYf, cYf, ef, bl, dl, cl, dYl, cYl, el, br, dr, cr, dYr, cYr, er, bq, dq, cq, dYq, cYq, eq, pnf, pnl, pnr, pnYf, pnYl, pnYr, period.getPeriodYear(), period.getPeriodNumber());
                }
            }
        }
    }

    private void clearStmts(PreparedStatement[] arrStmt) {
        for (int i = 0; i < arrStmt.length; ++i) {
            SQLUtils.cleanup((Statement)arrStmt[i]);
            arrStmt[i] = null;
        }
    }

    private void clearStmts(Map<String, PreparedStatement> stmts) {
        for (PreparedStatement stmt : stmts.values()) {
            SQLUtils.cleanup((Statement)stmt);
        }
        stmts.clear();
    }

    private PreparedStatement getStmtUpdate(Connection conn, Map<String, PreparedStatement> stmts, int balType, String currencyId, boolean qty) throws SQLException {
        String key = "update_" + balType + "_" + currencyId + "_" + qty;
        if (stmts.containsKey(key)) {
            return stmts.get(key);
        }
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update " + GLBalanceUtils.getAccountBalanceTable(balType, currencyId) + " set                                 \r\n");
        if (isForCurrency) {
            sql.append("    FBeginBalanceFor = FBeginBalanceFor + ?,\t                \r\n");
            sql.append("\tFDebitFor = FDebitFor + ?,                                \t\r\n");
            sql.append("\tFYearDebitFor = FYearDebitFor + ?,                     \t\t\r\n");
            sql.append("\tFCreditFor = FCreditFor + ?,                          \t\t\r\n");
            sql.append("\tFYearCreditFor = FYearCreditFor + ?,                   \t\t\r\n");
            sql.append("\tFEndBalanceFor = FEndBalanceFor + ?,\t                    \r\n");
            sql.append("\tFMonthPnLFor = FMonthPnLFor + ?,\t\t\t\t\t\t\t\r\n");
            sql.append("\tFYearPnLFor = FYearPnLFor + ?,\t\t\t\t\t\t\t\t\r\n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("\tFBeginBalanceLocal = FBeginBalanceLocal + ?,\t\t\t\t\r\n");
            sql.append("\tFDebitLocal = FDebitLocal + ?,                       \t\t\r\n");
            sql.append("\tFYearDebitLocal = FYearDebitLocal + ?,               \t\t\r\n");
            sql.append("\tFCreditLocal = FCreditLocal + ?,                    \t\t\r\n");
            sql.append("\tFYearCreditLocal = FYearCreditLocal + ?,             \t\t\r\n");
            sql.append("\tFEndBalanceLocal = FEndBalanceLocal + ?,\t\t            \r\n");
            sql.append("\tFMonthPnLLocal = FMonthPnLLocal + ?,\t\t\t\t\t\t\r\n");
            sql.append("\tFYearPnLLocal = FYearPnLLocal + ?\t\t\t\t\t\t\t\r\n");
        }
        if (isForCurrency) {
            sql.append("    ,                                                           \r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("\tFBeginBalanceRpt = FBeginBalanceRpt + ?,\t\t\t\t    \r\n");
            sql.append("\tFDebitRpt = FDebitRpt + ?,                             \t\t\r\n");
            sql.append("\tFYearDebitRpt = FYearDebitRpt + ?,                     \t\t\r\n");
            sql.append("\tFCreditRpt = FCreditRpt + ?,                         \t\t\r\n");
            sql.append("\tFYearCreditRpt = FYearCreditRpt + ?,                   \t\t\r\n");
            sql.append("\tFEndBalanceRpt = FEndBalanceRpt + ?,               \t\t\t\r\n");
            sql.append("\tFMonthPnLRpt = FMonthPnLRpt + ?,\t\t\t\t\t\t\t\r\n");
            sql.append("\tFYearPnLRpt = FYearPnLRpt + ?\t\t\t\t\t\t\t\t\r\n");
        }
        if (qty) {
            sql.append("    ,                                                           \r\n");
            sql.append("\tFBeginQty = FBeginQty + ?,\t                                \r\n");
            sql.append("    FDebitQty = FDebitQty + ?,                             \t\t\r\n");
            sql.append("\tFYearDebitQty = FYearDebitQty + ?,                     \t\t\r\n");
            sql.append("\tFCreditQty = FCreditQty + ?,                          \t\t\r\n");
            sql.append("\tFYearCreditQty = FYearCreditQty + ?,                  \t\t\r\n");
            sql.append("\tFEndQty = FEndQty + ?               \t\t\t\t\t\t\r\n");
        }
        sql.append("where FOrgUnitID = ?                                   \t\t\r\n");
        sql.append("\tand FPeriod = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tand FAccountID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        if (isForCurrency) {
            sql.append("\tand FCurrencyID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        }
        sql.append("");
        PreparedStatement stmt = conn.prepareStatement(sql.toString());
        stmts.put(key, stmt);
        return stmt;
    }

    private int updateBal(PreparedStatement stmtUpdate, int balType, String comId, int prd, String acctId, String curId, boolean isQty, boolean isPL, BigDecimal bf, BigDecimal df, BigDecimal cf, BigDecimal dYf, BigDecimal cYf, BigDecimal ef, BigDecimal bl, BigDecimal dl, BigDecimal cl, BigDecimal dYl, BigDecimal cYl, BigDecimal el, BigDecimal br, BigDecimal dr, BigDecimal cr, BigDecimal dYr, BigDecimal cYr, BigDecimal er, BigDecimal bq, BigDecimal dq, BigDecimal cq, BigDecimal dYq, BigDecimal cYq, BigDecimal eq, BigDecimal pnf, BigDecimal pnl, BigDecimal pnr, BigDecimal pnYf, BigDecimal pnYl, BigDecimal pnYr) throws BOSException, EASBizException, SQLException {
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(curId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(curId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        int index = 1;
        if (isForCurrency) {
            stmtUpdate.setBigDecimal(index++, bf);
            stmtUpdate.setBigDecimal(index++, df);
            stmtUpdate.setBigDecimal(index++, dYf);
            stmtUpdate.setBigDecimal(index++, cf);
            stmtUpdate.setBigDecimal(index++, cYf);
            stmtUpdate.setBigDecimal(index++, ef);
            stmtUpdate.setBigDecimal(index++, pnf);
            stmtUpdate.setBigDecimal(index++, pnYf);
        }
        if (isLocalCurrency || isForCurrency) {
            stmtUpdate.setBigDecimal(index++, bl);
            stmtUpdate.setBigDecimal(index++, dl);
            stmtUpdate.setBigDecimal(index++, dYl);
            stmtUpdate.setBigDecimal(index++, cl);
            stmtUpdate.setBigDecimal(index++, cYl);
            stmtUpdate.setBigDecimal(index++, el);
            stmtUpdate.setBigDecimal(index++, pnl);
            stmtUpdate.setBigDecimal(index++, pnYl);
        }
        if (isRptCurrency || isForCurrency) {
            stmtUpdate.setBigDecimal(index++, br);
            stmtUpdate.setBigDecimal(index++, dr);
            stmtUpdate.setBigDecimal(index++, dYr);
            stmtUpdate.setBigDecimal(index++, cr);
            stmtUpdate.setBigDecimal(index++, cYr);
            stmtUpdate.setBigDecimal(index++, er);
            stmtUpdate.setBigDecimal(index++, pnr);
            stmtUpdate.setBigDecimal(index++, pnYr);
        }
        if (isQty) {
            stmtUpdate.setBigDecimal(index++, bq);
            stmtUpdate.setBigDecimal(index++, dq);
            stmtUpdate.setBigDecimal(index++, dYq);
            stmtUpdate.setBigDecimal(index++, cq);
            stmtUpdate.setBigDecimal(index++, cYq);
            stmtUpdate.setBigDecimal(index++, eq);
        }
        DbUtil.prepareVarcharParam((PreparedStatement)stmtUpdate, (int)index++, (String)comId);
        stmtUpdate.setInt(index++, prd);
        DbUtil.prepareVarcharParam((PreparedStatement)stmtUpdate, (int)index++, (String)acctId);
        if (isForCurrency) {
            DbUtil.prepareVarcharParam((PreparedStatement)stmtUpdate, (int)index++, (String)curId);
        }
        return stmtUpdate.executeUpdate();
    }

    private PreparedStatement getStmtTempInsert(PreparedStatement[] arrStmt, Connection conn) throws SQLException {
        if (arrStmt[0] != null) {
            return arrStmt[0];
        }
        String sql = "insert into T_GL_TempAccountBalance (FBalType, FOrgUnitID, FPeriodID, FAccountID, FCurrencyID, FBeginBalanceFor,FDebitFor, FYearDebitFor, FCreditFor, FYearCreditFor, FEndBalanceFor, FBeginBalanceLocal, FDebitLocal, FYearDebitLocal, FCreditLocal, FYearCreditLocal, FEndBalanceLocal, FBeginBalanceRpt,FDebitRpt, FYearDebitRpt, FCreditRpt, FYearCreditRpt, FEndBalanceRpt, FBeginQty,FDebitQty, FYearDebitQty, FCreditQty, FYearCreditQty, FEndQty, FMonthPnLFor, FYearPnLFor, FMonthPnLLocal, FYearPnLLocal, FMonthPnLRpt, FYearPnLRpt, FPeriodYear, FPeriodNumber) values(?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        arrStmt[0] = conn.prepareStatement(sql);
        return arrStmt[0];
    }

    private boolean insertTempBal(PreparedStatement stmt, int balType, String comId, String prdId, String acctId, String curId, boolean isQty, boolean isPL, BigDecimal bf, BigDecimal df, BigDecimal cf, BigDecimal dYf, BigDecimal cYf, BigDecimal ef, BigDecimal bl, BigDecimal dl, BigDecimal cl, BigDecimal dYl, BigDecimal cYl, BigDecimal el, BigDecimal br, BigDecimal dr, BigDecimal cr, BigDecimal dYr, BigDecimal cYr, BigDecimal er, BigDecimal bq, BigDecimal dq, BigDecimal cq, BigDecimal dYq, BigDecimal cYq, BigDecimal eq, BigDecimal pnf, BigDecimal pnl, BigDecimal pnr, BigDecimal pnYf, BigDecimal pnYl, BigDecimal pnYr, int py, int pn) throws BOSException, EASBizException, SQLException {
        if (!isQty) {
            cq = eq = GlUtils.zero;
            dq = eq;
        }
        int index = 1;
        stmt.setInt(index++, balType);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)comId);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)prdId);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)acctId);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curId);
        stmt.setBigDecimal(index++, bf);
        stmt.setBigDecimal(index++, df);
        stmt.setBigDecimal(index++, dYf);
        stmt.setBigDecimal(index++, cf);
        stmt.setBigDecimal(index++, cYf);
        stmt.setBigDecimal(index++, ef);
        stmt.setBigDecimal(index++, bl);
        stmt.setBigDecimal(index++, dl);
        stmt.setBigDecimal(index++, dYl);
        stmt.setBigDecimal(index++, cl);
        stmt.setBigDecimal(index++, cYl);
        stmt.setBigDecimal(index++, el);
        stmt.setBigDecimal(index++, br);
        stmt.setBigDecimal(index++, dr);
        stmt.setBigDecimal(index++, dYr);
        stmt.setBigDecimal(index++, cr);
        stmt.setBigDecimal(index++, cYr);
        stmt.setBigDecimal(index++, er);
        stmt.setBigDecimal(index++, bq);
        stmt.setBigDecimal(index++, dq);
        stmt.setBigDecimal(index++, dYq);
        stmt.setBigDecimal(index++, cq);
        stmt.setBigDecimal(index++, cYq);
        stmt.setBigDecimal(index++, eq);
        stmt.setBigDecimal(index++, pnf);
        stmt.setBigDecimal(index++, pnYf);
        stmt.setBigDecimal(index++, pnl);
        stmt.setBigDecimal(index++, pnYl);
        stmt.setBigDecimal(index++, pnr);
        stmt.setBigDecimal(index++, pnYr);
        stmt.setInt(index++, py);
        stmt.setInt(index++, pn);
        return stmt.execute();
    }

    private PreparedStatement getStmtInsert(Connection conn, Map<String, PreparedStatement> stmts, int balType, String currencyId) throws SQLException {
        String key = "insert_" + balType + "_" + currencyId;
        if (stmts.containsKey(key)) {
            return stmts.get(key);
        }
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + GLBalanceUtils.getAccountBalanceTable(balType, currencyId) + "( \n");
        sql.append("FOrgUnitID, FPeriod, FAccountID, \n");
        if (isForCurrency) {
            sql.append("FCurrencyID, \n");
            sql.append("FBeginBalanceFor,FDebitFor, FYearDebitFor, FCreditFor, FYearCreditFor, FEndBalanceFor, FMonthPnLFor, FYearPnLFor, \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("FBeginBalanceLocal, FDebitLocal, FYearDebitLocal, FCreditLocal, FYearCreditLocal, FEndBalanceLocal, FMonthPnLLocal, FYearPnLLocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("FBeginBalanceRpt,FDebitRpt, FYearDebitRpt, FCreditRpt, FYearCreditRpt, FEndBalanceRpt, FMonthPnLRpt, FYearPnLRpt, \n");
        }
        sql.append("FBeginQty,FDebitQty, FYearDebitQty, FCreditQty, FYearCreditQty, FEndQty) ");
        sql.append("values(?, ?, ?, ");
        if (isForCurrency) {
            sql.append(" ?, ");
            sql.append(" ?, ?, ?, ?, ?, ?, ?, ?, ");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append(" ?, ?, ?, ?, ?, ?, ?, ?, ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" ?, ?, ?, ?, ?, ?, ?, ?, ");
        }
        sql.append(" ?, ?, ?, ?, ?, ?)");
        PreparedStatement stmt = conn.prepareStatement(sql.toString());
        stmts.put(key, stmt);
        return stmt;
    }

    private boolean insertBal(PreparedStatement stmt, int balType, String comId, int prd, String acctId, String curId, boolean isQty, boolean isPL, BigDecimal bf, BigDecimal df, BigDecimal cf, BigDecimal dYf, BigDecimal cYf, BigDecimal ef, BigDecimal bl, BigDecimal dl, BigDecimal cl, BigDecimal dYl, BigDecimal cYl, BigDecimal el, BigDecimal br, BigDecimal dr, BigDecimal cr, BigDecimal dYr, BigDecimal cYr, BigDecimal er, BigDecimal bq, BigDecimal dq, BigDecimal cq, BigDecimal dYq, BigDecimal cYq, BigDecimal eq, BigDecimal pnf, BigDecimal pnl, BigDecimal pnr, BigDecimal pnYf, BigDecimal pnYl, BigDecimal pnYr, int py, int pn) throws BOSException, EASBizException, SQLException {
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(curId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(curId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        if (!isQty) {
            cq = eq = GlUtils.zero;
            dq = eq;
        }
        int index = 1;
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)comId);
        stmt.setInt(index++, prd);
        DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)acctId);
        if (isForCurrency) {
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curId);
            stmt.setBigDecimal(index++, bf);
            stmt.setBigDecimal(index++, df);
            stmt.setBigDecimal(index++, dYf);
            stmt.setBigDecimal(index++, cf);
            stmt.setBigDecimal(index++, cYf);
            stmt.setBigDecimal(index++, ef);
            stmt.setBigDecimal(index++, pnf);
            stmt.setBigDecimal(index++, pnYf);
        }
        if (isLocalCurrency || isForCurrency) {
            stmt.setBigDecimal(index++, bl);
            stmt.setBigDecimal(index++, dl);
            stmt.setBigDecimal(index++, dYl);
            stmt.setBigDecimal(index++, cl);
            stmt.setBigDecimal(index++, cYl);
            stmt.setBigDecimal(index++, el);
            stmt.setBigDecimal(index++, pnl);
            stmt.setBigDecimal(index++, pnYl);
        }
        if (isRptCurrency || isForCurrency) {
            stmt.setBigDecimal(index++, br);
            stmt.setBigDecimal(index++, dr);
            stmt.setBigDecimal(index++, dYr);
            stmt.setBigDecimal(index++, cr);
            stmt.setBigDecimal(index++, cYr);
            stmt.setBigDecimal(index++, er);
            stmt.setBigDecimal(index++, pnr);
            stmt.setBigDecimal(index++, pnYr);
        }
        stmt.setBigDecimal(index++, bq);
        stmt.setBigDecimal(index++, dq);
        stmt.setBigDecimal(index++, dYq);
        stmt.setBigDecimal(index++, cq);
        stmt.setBigDecimal(index++, cYq);
        stmt.setBigDecimal(index++, eq);
        return stmt.execute();
    }

    @Override
    protected boolean _deleteAccountBalance(Context ctx, String companyNumber, int periodYear, int periodNumber) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        PeriodInfo period = null;
        companyOrgUnitInfo = GlWebServiceUtil.getCompany(ctx, companyNumber);
        if (companyOrgUnitInfo == null) {
            return false;
        }
        String comId = companyOrgUnitInfo.getId().toString();
        String typeId = companyOrgUnitInfo.getAccountPeriodType().getId().toString();
        period = GlWebServiceUtil.fetchPeriod(ctx, typeId, periodYear, periodNumber);
        int prd = period.getNumber();
        try {
            this.doDeleteAccountBalance(ctx, 1, null, comId, prd);
            this.doDeleteAccountBalance(ctx, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", comId, prd);
            this.doDeleteAccountBalance(ctx, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", comId, prd);
            this.doDeleteAccountBalance(ctx, 5, null, comId, prd);
            this.doDeleteAccountBalance(ctx, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", comId, prd);
            this.doDeleteAccountBalance(ctx, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", comId, prd);
        }
        catch (BOSException e) {
            return false;
        }
        return true;
    }

    private void doDeleteAccountBalance(Context ctx, int balType, String currencyId, String comId, int prd) throws BOSException {
        String sql = "delete from " + GLBalanceUtils.getAccountBalanceTable(balType, currencyId) + " where forgunitid=? and fperiod=? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{comId, prd});
    }

    @Override
    protected String _findObjectByNumber(Context ctx, String number) throws BOSException {
        return null;
    }

    @Override
    protected String _closePeriod(Context ctx, String companyNumber, int periodYear, int periodNumber, int status) throws BOSException {
        String result = "0000";
        CompanyOrgUnitInfo companyOrgUnitInfo = GlWebServiceUtil.getCompany(ctx, companyNumber);
        if (companyOrgUnitInfo == null) {
            result = "1001";
            return result;
        }
        ISystemStatusCtrol sysStatus = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        try {
            if (!sysStatus.hasStartPeriod(companyOrgUnitInfo.getId())) {
                result = "2000";
                return result;
            }
        }
        catch (EASBizException e2) {
            result = "2001";
            return result;
        }
        if (status == 0) {
            try {
                sysStatus.start(SystemEnum.GENERALLEDGER, companyOrgUnitInfo, true);
            }
            catch (EASBizException e1) {
                result = "2002";
                return result;
            }
        }
        if (status == 1) {
            try {
                sysStatus.start(SystemEnum.GENERALLEDGER, companyOrgUnitInfo, false);
            }
            catch (EASBizException e) {
                result = "2003";
                return result;
            }
        }
        if (status == 2) {
            try {
                sysStatus.nextPeriod(SystemEnum.GENERALLEDGER, (OrgUnitInfo)companyOrgUnitInfo);
            }
            catch (EASBizException e1) {
                result = "2004";
                return result;
            }
        }
        if (status == 3) {
            try {
                sysStatus.prePeriod(SystemEnum.GENERALLEDGER, (OrgUnitInfo)companyOrgUnitInfo);
            }
            catch (EASBizException e) {
                result = "2005";
                return result;
            }
        }
        return result;
    }

    protected ITableManagerFacade getTableManagerFacade(Context ctx) throws BOSException {
        ITableManagerFacade tableManagerFacade = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        return tableManagerFacade;
    }

    protected void createTable(Context ctx, String sql) throws BOSException {
        this.getTableManagerFacade(ctx).createTable(sql);
    }

    protected void dropTable(Context ctx, String tableName) throws BOSException {
        if (tableName == null) {
            return;
        }
        this.getTableManagerFacade(ctx).releaseTableName(tableName);
    }

    protected void clearTableData(Context ctx, String tableName) throws BOSException {
        DbUtil.execute((Context)ctx, (String)("delete from " + tableName));
    }

    protected String getTemporaryTableName(Context ctx) throws BOSException {
        return this.getTableManagerFacade(ctx).getTableName(GLResUtil.getRes("gl_temp_table") + System.currentTimeMillis());
    }
}

