/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountCategoryEnum;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordImpInfo;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.CussentStatusEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCategoryEnum;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.WSRtnInfoCollection;
import com.kingdee.eas.fi.gl.WSRtnInfoInfo;
import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherFactory;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.fi.gl.ZipUtils;
import com.kingdee.eas.fi.gl.app.AbstractWSVoucherControllerBean;
import com.kingdee.eas.fi.gl.app.CashflowRecordImpCollection;
import com.kingdee.eas.fi.gl.app.GetAccountService;
import com.kingdee.eas.fi.gl.app.GetAsstActService;
import com.kingdee.eas.fi.gl.app.GetAsstActTypeService;
import com.kingdee.eas.fi.gl.app.VoucherExportService;
import com.kingdee.eas.fi.gl.app.VoucherImportService;
import com.kingdee.eas.fi.gl.app.VoucherOperateService;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.SubmitVoucherServiceHelper;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.rpt.app.GLNRptBaseService;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WSVoucherControllerBean
extends AbstractWSVoucherControllerBean {
    private static final long serialVersionUID = 7464876043639725995L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.WSVoucherControllerBean");
    private static final int SEQ = -1000;

    private VoucherInfo contructVoucherHeader(Context ctx, WSVoucherInfo wsVoucher, CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo period, VoucherTypeInfo voucherTypeInfo, CurrencyInfo currencyInfo) throws EASBizException, BOSException {
        VoucherInfo voucherInfo = new VoucherInfo();
        voucherInfo.setSourceSys(SystemEnum.BASICSYSTEM);
        voucherInfo.setSourceType(SourceType.OTHER_IMPORT);
        voucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
        voucherInfo.setAttachments(wsVoucher.getAttaches());
        voucherInfo.setDescription(wsVoucher.getDescription());
        voucherInfo.setVoucherAbstract(wsVoucher.getVoucherAbstract());
        voucherInfo.setBookedDate(wsVoucher.getBookedDate());
        voucherInfo.setBizDate(wsVoucher.getBizDate());
        voucherInfo.setIsCheck(wsVoucher.isIsCheck());
        if (wsVoucher.getCompanyNumber() == null) {
            wsVoucher.setCompanyNumber("");
        }
        voucherInfo.setCompany(companyOrgUnitInfo);
        voucherInfo.setCU(companyOrgUnitInfo.getCU());
        ctx.put((Object)OrgType.Company, (Object)companyOrgUnitInfo);
        voucherInfo.setPeriod(period);
        voucherInfo.setVoucherType(voucherTypeInfo);
        voucherInfo.setCurrency(currencyInfo);
        voucherInfo.put("fixAsstAccount", (Object)Boolean.TRUE);
        return voucherInfo;
    }

    private VoucherEntryInfo contructVoucherEntry(Context ctx, WSVoucherInfo wsVoucher, VoucherInfo voucher, ProfitCenterOrgUnitInfo profitCenterOrgUnitInfo, AccountViewInfo accountViewInfo, CurrencyInfo currencyInfo, IObjectCollection cashflowCols, boolean sSettleByLocal, VoucherInfo.ExchangeRateWithValue localToRpt) throws BOSException, EASBizException {
        BigDecimal local;
        boolean commonVoucherProcess;
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        VoucherEntryInfo entry = new VoucherEntryInfo();
        entry.setIsHand(true);
        String vouchernumber = wsVoucher.getVoucherNumber();
        int iSeq = wsVoucher.getEntrySeq();
        if (wsVoucher.getLocalRate() == 0.0) {
            wsVoucher.setLocalRate(1.0);
        }
        BigDecimal exchangeRate = new BigDecimal(String.valueOf(wsVoucher.getLocalRate()));
        BigDecimal reportchangeRate = exchangeRate = exchangeRate.setScale(10, 4);
        VoucherInfo.ExchangeRateWithValue reportRate = null;
        if (sSettleByLocal) {
            reportchangeRate = localToRpt.getValue();
        }
        if (voucher.getCompany().getReportCurrency() != null && 1 == voucher.getCompany().getReportConvertMode().getValue()) {
            if (currencyInfo.getId().toString().equals(voucher.getCompany().getReportCurrency().getId().toString())) {
                reportchangeRate = new BigDecimal(1);
            } else {
                reportRate = this.getExChangeRate(ctx, voucher.getCompany(), currencyInfo, voucher.getPeriod(), wsVoucher.getBookedDate());
                reportchangeRate = reportRate.getValue();
            }
        }
        entry.setSeq(iSeq);
        entry.setBill(voucher);
        entry.setDescription(wsVoucher.getVoucherAbstract());
        try {
            commonVoucherProcess = Boolean.valueOf(VoucherProcessCache.getParam(ctx, voucher.getCompany().getId().toString(), "GL_111").toString());
        }
        catch (EASBizException e) {
            commonVoucherProcess = false;
        }
        if (commonVoucherProcess) {
            entry.setProfitCenter(profitCenterOrgUnitInfo);
        }
        entry.setAccount(accountViewInfo);
        entry.setCAA(cache.getCaa(ctx, accountViewInfo, voucher.getPeriod()));
        entry.setCurrency(currencyInfo);
        entry.setLocalExchangeRate(exchangeRate);
        entry.setReportingExchangeRate(reportchangeRate);
        BigDecimal orignal = new BigDecimal(String.valueOf(wsVoucher.getOriginalAmount()));
        orignal = orignal.setScale(currencyInfo.getPrecision(), 4);
        entry.setOriginalAmount(orignal);
        BigDecimal rpt = BigDecimal.ZERO;
        int rptPre = voucher.getCompany().getBaseCurrency().getPrecision();
        if (wsVoucher.getEntryDC() == 1) {
            entry.setEntryDC(EntryDC.DEBIT);
            local = new BigDecimal(String.valueOf(wsVoucher.getDebitAmount()));
            local = local.setScale(voucher.getCompany().getBaseCurrency().getPrecision(), 4);
            if (local != null && local.compareTo(BigDecimal.ZERO) == 0 && currencyInfo != null) {
                local = currencyInfo.getId().toString().equals(voucher.getCompany().getBaseCurrency().getId().toString()) ? orignal : orignal.multiply(exchangeRate);
            }
            entry.setLocalAmount(local);
            if (sSettleByLocal) {
                if (localToRpt.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                    rpt = entry.getLocalAmount().multiply(reportchangeRate);
                    rpt = rpt.setScale(rptPre, 4);
                    entry.setReportingAmount(rpt);
                } else {
                    rpt = entry.getLocalAmount().divide(reportchangeRate, 6);
                    rpt = rpt.setScale(rptPre, 4);
                    entry.setReportingAmount(rpt);
                }
            } else if (reportRate == null || reportRate.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                rpt = orignal.multiply(reportchangeRate);
                rpt = rpt.setScale(rptPre, 4);
                entry.setReportingAmount(orignal.multiply(reportchangeRate));
            } else {
                rpt = orignal.divide(reportchangeRate, 6);
                rpt = rpt.setScale(rptPre, 4);
                entry.setReportingAmount(orignal.divide(reportchangeRate, 6));
            }
        } else {
            entry.setEntryDC(EntryDC.CREDIT);
            local = new BigDecimal(String.valueOf(wsVoucher.getCreditAmount()));
            local = local.setScale(voucher.getCompany().getBaseCurrency().getPrecision(), 4);
            if (local != null && local.compareTo(BigDecimal.ZERO) == 0 && currencyInfo != null) {
                local = currencyInfo.getId().toString().equals(voucher.getCompany().getBaseCurrency().getId().toString()) ? orignal : orignal.multiply(exchangeRate);
            }
            entry.setLocalAmount(local);
            if (sSettleByLocal) {
                if (localToRpt.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                    rpt = entry.getLocalAmount().multiply(reportchangeRate);
                    rpt = rpt.setScale(rptPre, 4);
                    entry.setReportingAmount(rpt);
                } else {
                    rpt = entry.getLocalAmount().divide(reportchangeRate, 6);
                    rpt = rpt.setScale(rptPre, 4);
                    entry.setReportingAmount(rpt);
                }
            } else if (reportRate == null || reportRate.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                rpt = orignal.multiply(reportchangeRate);
                rpt = rpt.setScale(rptPre, 4);
                entry.setReportingAmount(rpt);
            } else {
                rpt = orignal.divide(reportchangeRate, 6);
                rpt = rpt.setScale(rptPre, 4);
                entry.setReportingAmount(rpt);
            }
        }
        if (accountViewInfo.isIsQty()) {
            BigDecimal price = new BigDecimal(String.valueOf(wsVoucher.getPrice()));
            entry.setPrice(price);
            String measurement = wsVoucher.getMeasurement();
            if (measurement != null && !StringUtils.isEmpty((String)measurement)) {
                MeasureUnitInfo measureUnitInfo;
                String measureUnitGroupID = null;
                if (accountViewInfo.getMeasureUnitGroupID() != null) {
                    measureUnitGroupID = accountViewInfo.getMeasureUnitGroupID().getId().toString();
                }
                if ((measureUnitInfo = cache.findMeasureUnitByName(ctx, measureUnitGroupID, measurement)) != null) {
                    entry.setMeasureUnit(measureUnitInfo);
                } else {
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"916_WSVoucherControllerBean", (Locale)ctx.getLocale()) + measurement));
                }
                entry.setQuantity(new BigDecimal(String.valueOf(wsVoucher.getQty())));
            } else {
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"917_WSVoucherControllerBean", (Locale)ctx.getLocale()) + measurement));
            }
        }
        entry.setCussent(CussentStatusEnum.getEnum((String)String.valueOf(wsVoucher.getCussent())));
        entry.setOprStatus(1);
        if (cashflowCols != null && cashflowCols.size() > 0) {
            int n = cashflowCols.size();
            for (int ca = 0; ca < n; ++ca) {
                CashflowRecordImpInfo key = (CashflowRecordImpInfo)cashflowCols.getObject(ca);
                String vnumber = key.getVouchernumber();
                String seqnumber = key.getSeq();
                String oppseqnumber = key.getOppseq();
                if (vouchernumber.equalsIgnoreCase(vnumber) && seqnumber.equalsIgnoreCase(String.valueOf(iSeq))) {
                    key.getRecord().setEntry(entry);
                    key.getRecord().setAccount(entry.getAccount());
                    key.getRecord().setEntryDC(entry.getEntryDC());
                    key.getRecord().setCurrency(entry.getCurrency());
                    int pc = 1;
                    if (key.getRecord().getPrimaryItem() != null) {
                        CashFlowDirection direct = key.getRecord().getPrimaryItem().getDirection();
                        if (EntryDC.DEBIT.equals((Object)entry.getEntryDC()) && CashFlowDirection.OUT.equals((Object)direct) || EntryDC.CREDIT.equals((Object)entry.getEntryDC()) && CashFlowDirection.IN.equals((Object)direct)) {
                            pc = -1;
                        }
                    }
                    key.getRecord().setPrimaryCoefficient(pc);
                }
                if (vouchernumber.equalsIgnoreCase(vnumber) && oppseqnumber.equalsIgnoreCase(String.valueOf(iSeq))) {
                    key.getRecord().setOpposingAccountEntry(entry);
                    key.getRecord().setOppAccount(entry.getAccount());
                    key.getRecord().setOppEntryDC(entry.getEntryDC());
                    if (entry.getAccount().getAccountTypeID().getProperty().getValue() == 4 && (key.getRecord().getPrimaryItem() == null || key.getRecord().getPrimaryItem().isIsDealActivity())) {
                        key.getRecord().setSupplementaryItem(null);
                    }
                }
                if (!vouchernumber.equalsIgnoreCase(vnumber) || !seqnumber.equalsIgnoreCase(String.valueOf(iSeq))) continue;
                CashflowRecordInfo record = key.getRecord();
                if (sSettleByLocal) {
                    if (localToRpt.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                        rpt = record.getLocalAmount().multiply(reportchangeRate);
                        rpt = rpt.setScale(rptPre, 4);
                        record.setReportingAmount(rpt);
                        continue;
                    }
                    rpt = record.getLocalAmount().divide(reportchangeRate, rptPre, 4);
                    record.setReportingAmount(rpt);
                    continue;
                }
                if (reportRate == null || reportRate.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                    rpt = record.getOriginalAmount().multiply(reportchangeRate);
                    rpt = rpt.setScale(rptPre, 4);
                    record.setReportingAmount(rpt);
                    continue;
                }
                rpt = record.getOriginalAmount().divide(reportchangeRate, rptPre, 4);
                record.setReportingAmount(rpt);
            }
        }
        return entry;
    }

    private String contructVoucherAsstRecord(Context ctx, WSVoucherInfo wsVoucher, VoucherInfo voucherInfo, AsstAccountInfo fcaa, VoucherEntryInfo entry, VoucherAssistRecordInfo assitInfo, boolean isVerify, boolean sSettleByLocal, VoucherInfo.ExchangeRateWithValue localToRpt, boolean isSubmit) throws EASBizException, BOSException {
        String strSettleCode;
        BigDecimal local;
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        String errorNumber = null;
        boolean entryNeedRemark = false;
        Object pvalue = VoucherProcessCache.getParam(ctx, voucherInfo.getCompany().getId().toString(), "GL_030");
        entryNeedRemark = pvalue != null ? Boolean.valueOf(pvalue.toString()) : true;
        if (isSubmit && entryNeedRemark && wsVoucher.getAssistAbstract() == null && wsVoucher.getVoucherAbstract() == null) {
            errorNumber = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1088_WSVoucherControllerBean", (Locale)ctx.getLocale()), wsVoucher.getEntrySeq());
            logger.info((Object)errorNumber);
            return errorNumber;
        }
        assitInfo.setDescription(wsVoucher.getAssistAbstract() != null ? wsVoucher.getAssistAbstract() : wsVoucher.getVoucherAbstract());
        if (wsVoucher.getAssistBizDate() != null) {
            assitInfo.setBizDate(wsVoucher.getAssistBizDate());
        } else {
            assitInfo.setBizDate(wsVoucher.getBizDate());
        }
        if (wsVoucher.getAssistEndDate() != null) {
            assitInfo.setEndDate(wsVoucher.getAssistEndDate());
        } else {
            assitInfo.setEndDate(wsVoucher.getBizDate());
        }
        assitInfo.setIsFullProp(true);
        assitInfo.setSeq(wsVoucher.getAsstSeq());
        assitInfo.setBill(entry.getBill());
        assitInfo.setBizNumber(wsVoucher.getBizNumber());
        BigDecimal exchangeRate = new BigDecimal(String.valueOf(wsVoucher.getLocalRate()));
        BigDecimal reportchangeRate = exchangeRate = exchangeRate.setScale(10, 4);
        VoucherInfo.ExchangeRateWithValue reportRate = null;
        if (sSettleByLocal) {
            reportchangeRate = localToRpt.getValue();
        } else if (voucherInfo.getCompany().getReportCurrency() != null && !entry.getCurrency().getId().toString().equals(voucherInfo.getCompany().getReportCurrency().getId().toString())) {
            reportRate = this.getExChangeRate(ctx, voucherInfo.getCompany(), entry.getCurrency(), voucherInfo.getPeriod(), wsVoucher.getBookedDate());
            reportchangeRate = reportRate.getValue();
        } else if (voucherInfo.getCompany().getReportCurrency() != null && entry.getCurrency().getId().toString().equals(voucherInfo.getCompany().getReportCurrency().getId().toString()) && 1 == voucherInfo.getCompany().getReportConvertMode().getValue()) {
            reportchangeRate = new BigDecimal(1);
        }
        BigDecimal orignal = new BigDecimal(String.valueOf(wsVoucher.getOriginalAmount()));
        orignal = orignal.setScale(entry.getCurrency().getPrecision(), 4);
        assitInfo.setOriginalAmount(orignal);
        if (wsVoucher.getEntryDC() == 1) {
            local = new BigDecimal(String.valueOf(wsVoucher.getDebitAmount()));
            if (local != null && local.compareTo(BigDecimal.ZERO) == 0 && entry.getCurrency() != null) {
                local = entry.getCurrency().getId().toString().equals(entry.getBill().getCompany().getBaseCurrency().getId().toString()) ? orignal : orignal.multiply(exchangeRate);
            }
            local = local.setScale(entry.getBill().getCompany().getBaseCurrency().getPrecision(), 4);
            assitInfo.setLocalAmount(local);
        } else {
            local = new BigDecimal(String.valueOf(wsVoucher.getCreditAmount()));
            if (local != null && local.compareTo(BigDecimal.ZERO) == 0 && entry.getCurrency() != null) {
                local = entry.getCurrency().getId().toString().equals(entry.getBill().getCompany().getBaseCurrency().getId().toString()) ? orignal : orignal.multiply(exchangeRate);
            }
            local = local.setScale(entry.getBill().getCompany().getBaseCurrency().getPrecision(), 4);
            assitInfo.setLocalAmount(local);
        }
        BigDecimal rpt = BigDecimal.ZERO;
        int rptSca = voucherInfo.getCompany().getBaseCurrency().getPrecision();
        if (sSettleByLocal) {
            if (localToRpt.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                rpt = assitInfo.getLocalAmount().multiply(localToRpt.getValue());
                rpt = rpt.setScale(rptSca, 4);
                assitInfo.setReportingAmount(rpt);
            } else {
                rpt = assitInfo.getLocalAmount().divide(localToRpt.getValue(), 6);
                rpt = rpt.setScale(rptSca, 4);
                assitInfo.setReportingAmount(rpt);
            }
        } else if (reportRate == null || reportRate.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            rpt = orignal.multiply(reportchangeRate);
            rpt = rpt.setScale(rptSca, 4);
            assitInfo.setReportingAmount(rpt);
        } else {
            rpt = orignal.divide(reportchangeRate, 6);
            rpt = rpt.setScale(rptSca, 4);
            assitInfo.setReportingAmount(rpt);
        }
        if (entry.getAccount() != null && entry.getAccount().isIsQty()) {
            if (fcaa.isIsQty()) {
                BigDecimal price = new BigDecimal(String.valueOf(wsVoucher.getPrice()));
                assitInfo.setPrice(price);
                String measurement = wsVoucher.getMeasurement();
                if (measurement != null && !StringUtils.isEmpty((String)measurement)) {
                    MeasureUnitInfo measureUnitInfo;
                    String measureUnitGroupID = null;
                    if (fcaa.getMeasureUnitGroup() != null) {
                        measureUnitGroupID = fcaa.getMeasureUnitGroup().getId().toString();
                    }
                    if ((measureUnitInfo = cache.findMeasureUnitByName(ctx, measureUnitGroupID, measurement)) != null) {
                        assitInfo.setMeasureUnit(measureUnitInfo);
                        assitInfo.setQuantity(new BigDecimal(String.valueOf(wsVoucher.getQty())));
                        assitInfo.setStandardQuantity(assitInfo.getQuantity().multiply(measureUnitInfo.getCoefficient()));
                    } else {
                        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"918_WSVoucherControllerBean", (Locale)ctx.getLocale()) + measurement));
                    }
                    assitInfo.setQuantity(new BigDecimal(String.valueOf(wsVoucher.getQty())));
                } else {
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"919_WSVoucherControllerBean", (Locale)ctx.getLocale()) + measurement));
                }
            } else {
                assitInfo.setQuantity(new BigDecimal(String.valueOf(wsVoucher.getQty())));
            }
        }
        if ((strSettleCode = wsVoucher.getSettlementType()) != null) {
            SettlementTypeInfo settlementTypeInfo = cache.findSettelmentTypeByName(ctx, strSettleCode);
            assitInfo.setSettlementType(settlementTypeInfo);
        }
        assitInfo.setSettlementCode(wsVoucher.getSettlementNumber());
        assitInfo.setTicketNumber(wsVoucher.getIcketNumber());
        assitInfo.setInvoiceNumber(wsVoucher.getInvoiceNumber());
        String[] asstactTypeName = this.getAsstactArray(wsVoucher, 1);
        String[] asstactTypeNumber = this.getAsstactArray(wsVoucher, 2);
        String[] asstactType = this.getAsstactArray(wsVoucher, 3);
        AssistantHGInfo assistantHGInfo = new AssistantHGInfo();
        AsstActTypeCollection arrayAsstActTypeInfo = new AsstActTypeCollection();
        if (fcaa != null && fcaa.getId() != null) {
            AsstActTypeCollection asstActTypes = VoucherProcessCache.getAsstActTypes(ctx, fcaa.getId().toString());
            int count = fcaa.getCount();
            int findCount = 0;
            for (int i = 0; i < count; ++i) {
                if (asstactType[i] == null || asstactType[i].trim().length() == 0 || asstactTypeNumber[i] == null || asstactTypeNumber[i].trim().length() == 0) continue;
                boolean hasResult = false;
                try {
                    hasResult = this.constructAssistInfo(ctx, assistantHGInfo, asstactType[i], asstactTypeNumber[i], asstactTypeName[i], arrayAsstActTypeInfo, entry.getBill().getCompany().getCU().getId().toString(), entry.getBill().getCompany(), entry.getAccount(), entry.getCurrency());
                }
                catch (VoucherException e) {
                    errorNumber = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"920_WSVoucherControllerBean", (Locale)ctx.getLocale()) + entry.getSeq() + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"921_WSVoucherControllerBean", (Locale)ctx.getLocale()) + assitInfo.getSeq() + e.getMessage();
                    logger.info((Object)errorNumber);
                    return errorNumber;
                }
                if (!hasResult) {
                    errorNumber = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"920_WSVoucherControllerBean", (Locale)ctx.getLocale()) + entry.getSeq() + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"921_WSVoucherControllerBean", (Locale)ctx.getLocale()) + assitInfo.getSeq() + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"922_WSVoucherControllerBean", (Locale)ctx.getLocale()) + asstactType[i] + "(" + asstactTypeNumber[i] + ":" + asstactTypeName[i] + ")";
                    logger.info((Object)errorNumber);
                    return errorNumber;
                }
                ++findCount;
            }
            AssistantHGInfo actualAssistantHGInfo = null;
            if (findCount > 0) {
                assistantHGInfo.put("aatok", (Object)Boolean.TRUE);
                actualAssistantHGInfo = cache.findAssistantHG(ctx, fcaa, asstActTypes, assistantHGInfo);
            }
            if (actualAssistantHGInfo == null) {
                return null;
            }
            assitInfo.setAssGrp(actualAssistantHGInfo);
            if (entry.isIsVerify() && isVerify) {
                AcctCussentInfo acctInfo = this.getAcctCussentInfo(ctx, assitInfo.getOriginalAmount(), actualAssistantHGInfo.getId().toString(), assitInfo.getBizNumber(), assitInfo.getInvoiceNumber());
                if (acctInfo == null) {
                    errorNumber = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"920_WSVoucherControllerBean", (Locale)ctx.getLocale()) + entry.getSeq() + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"921_WSVoucherControllerBean", (Locale)ctx.getLocale()) + assitInfo.getSeq() + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"923_WSVoucherControllerBean", (Locale)ctx.getLocale());
                    logger.info((Object)errorNumber);
                    return errorNumber;
                }
                assitInfo.setVerifiedCussent(acctInfo);
            }
        }
        assitInfo.setIsFullProp(true);
        return errorNumber;
    }

    protected AcctCussentInfo getAcctCussentInfo(Context ctx, BigDecimal unHoldedAmtFor, String hgid, String bizNumber, String invoiceNumber) throws BOSException {
        AcctCussentInfo info = new AcctCussentInfo();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 cust.FID,vast.FendDate").append("\n from t_gl_VoucherAssistRecord vast").append("\n inner join t_bd_assistanthg hg on vast.fassgrpid=hg.fid").append("\n inner join t_GL_AcctCussent cust on cust.FVchAssistRecordID = vast.fid").append("\n where hg.fid='").append(hgid).append("' \n  and cust.funholdedamtfor>=").append(unHoldedAmtFor).append("and vast.fbizNumber='").append(bizNumber).append("'").append(" order by vast.FbizDate");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setBizDate((Date)rs.getDate("FendDate"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    protected boolean constructAssistInfo(Context ctx, AssistantHGInfo assistantHGInfo, String strAsstActTypeName, String strAsstActID, String strAsstName, AsstActTypeCollection arrayAsstActTypeInfo, String cuid, CompanyOrgUnitInfo infoCompany, AccountViewInfo accountViewInfo, CurrencyInfo currencyInfo) throws BOSException, EASBizException {
        AsstActTypeInfo asstActTypeInfo;
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        boolean hasResult = false;
        boolean isAssit = false;
        if (strAsstActTypeName != null && strAsstActTypeName.trim().length() > 0) {
            isAssit = true;
            strAsstActTypeName = strAsstActTypeName.trim();
        }
        if (!StringUtil.isEmptyString((String)strAsstActID)) {
            isAssit = true;
            strAsstActID = strAsstActID.trim();
        }
        if (!StringUtil.isEmptyString((String)strAsstName)) {
            isAssit = true;
            strAsstName = strAsstName.trim();
        }
        if (isAssit && (asstActTypeInfo = VoucherProcessCache.findAsstActTypeByNumberOrName(ctx, strAsstActTypeName)) != null) {
            arrayAsstActTypeInfo.add(asstActTypeInfo);
            String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
            Object dataInfo = null;
            try {
                dataInfo = this.findAsstActByNumber(ctx, asstActTypeInfo, strAsstActID, infoCompany, cuid, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
                throw new BOSException(exception.getMessage());
            }
            if (dataInfo == null) {
                return false;
            }
            String msg = "";
            if (dataInfo instanceof String) {
                msg = ": " + asstActTypeInfo.getName() + " " + dataInfo;
            }
            if (dataInfo instanceof AccountBankInfo && accountViewInfo != null) {
                BankInfo bankinfo;
                boolean accounterror = false;
                boolean currenyerror = false;
                boolean bankerror = false;
                AccountBankInfo accountbank = (AccountBankInfo)dataInfo;
                boolean isImp = false;
                try {
                    isImp = Boolean.valueOf(VoucherProcessCache.getParam(ctx, infoCompany.getId().toString(), "GL_0155").toString());
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                if (accountbank.isIsClosed()) {
                    msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"accountbank_closed", (Locale)ctx.getLocale(), (Object[])new Object[]{accountbank.getName()});
                }
                if (accountViewInfo.isIsBank()) {
                    if (accountbank.getAccount() == null || !accountViewInfo.getId().equals((Object)accountbank.getAccount().getId())) {
                        accounterror = true;
                    }
                } else if (accountViewInfo.isIsCashEquivalent() && isImp && (accountbank.getAccount() == null || !accountViewInfo.getId().equals((Object)accountbank.getAccount().getId()))) {
                    accounterror = true;
                }
                if ((bankinfo = assistantHGInfo.getRegion()) != null && !accountbank.getBank().getId().equals((Object)bankinfo.getId())) {
                    bankerror = true;
                }
                if (currencyInfo != null && accountbank.isIsByCurrency() && !currencyInfo.getId().equals((Object)accountbank.getCurrency().getId())) {
                    currenyerror = true;
                }
                if (accounterror) {
                    msg = msg.equals("") ? ResourceBase.getString((String)"com.kingdee.eas.fi.gl.VoucherImpWizardUI", (String)"bankaccount_notequals_accounview", (Locale)ctx.getLocale()) : ", " + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.VoucherImpWizardUI", (String)"bankaccount_notequals_accounview", (Locale)ctx.getLocale());
                }
                if (currenyerror) {
                    msg = msg.equals("") ? ResourceBase.getString((String)"com.kingdee.eas.fi.gl.VoucherImpWizardUI", (String)"bankaccount_notequals_currency", (Locale)ctx.getLocale()) : ", " + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.VoucherImpWizardUI", (String)"bankaccount_notequals_currency", (Locale)ctx.getLocale());
                }
                if (bankerror) {
                    msg = msg.equals("") ? ResourceBase.getString((String)"com.kingdee.eas.fi.gl.VoucherImpWizardUI", (String)"bankaccount_notequals_bank", (Locale)ctx.getLocale()) : ", " + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.VoucherImpWizardUI", (String)"bankaccount_notequals_bank", (Locale)ctx.getLocale());
                }
            }
            if (dataInfo instanceof BankInfo) {
                AccountBankInfo accountbank = assistantHGInfo.getBankAccount();
                BankInfo bankinfo = (BankInfo)dataInfo;
                if (accountbank != null && !accountbank.getBank().getId().equals((Object)bankinfo.getId())) {
                    msg = msg.equals("") ? ResourceBase.getString((String)"com.kingdee.eas.fi.gl.VoucherImpWizardUI", (String)"bankaccount_notequals_bank", (Locale)ctx.getLocale()) : ", " + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.VoucherImpWizardUI", (String)"bankaccount_notequals_bank", (Locale)ctx.getLocale());
                }
            }
            if (!msg.equals("")) {
                throw new VoucherException(VoucherException.NO_MSG, new Object[]{msg});
            }
            if (dataInfo != null) {
                assistantHGInfo.put(asstHGAttribute, dataInfo);
                hasResult = true;
            }
        }
        return hasResult;
    }

    private Object findAsstActByNumber(Context ctx, AsstActTypeInfo asstActType, String asstActNumber, CompanyOrgUnitInfo company, String cuId, String userId) throws Exception {
        HashSet<String> numbers = new HashSet<String>();
        numbers.add(asstActNumber);
        Map<String, Object> asstActs = VoucherProcessCache.findAsstActByNumbers(ctx, asstActType, numbers, company, cuId, userId);
        Object asstAct = asstActs.get(asstActNumber);
        return asstAct;
    }

    private String[] getAsstactArray(WSVoucherInfo wsVoucher, int type) {
        String[] asstact = new String[8];
        switch (type) {
            case 1: {
                asstact[0] = wsVoucher.getAsstActName1();
                asstact[1] = wsVoucher.getAsstActName2();
                asstact[2] = wsVoucher.getAsstActName3();
                asstact[3] = wsVoucher.getAsstActName4();
                asstact[4] = wsVoucher.getAsstActName5();
                asstact[5] = wsVoucher.getAsstActName6();
                asstact[6] = wsVoucher.getAsstActName7();
                asstact[7] = wsVoucher.getAsstActName8();
                break;
            }
            case 2: {
                asstact[0] = wsVoucher.getAsstActNumber1();
                asstact[1] = wsVoucher.getAsstActNumber2();
                asstact[2] = wsVoucher.getAsstActNumber3();
                asstact[3] = wsVoucher.getAsstActNumber4();
                asstact[4] = wsVoucher.getAsstActNumber5();
                asstact[5] = wsVoucher.getAsstActNumber6();
                asstact[6] = wsVoucher.getAsstActNumber7();
                asstact[7] = wsVoucher.getAsstActNumber8();
                break;
            }
            case 3: {
                asstact[0] = wsVoucher.getAsstActType1();
                asstact[1] = wsVoucher.getAsstActType2();
                asstact[2] = wsVoucher.getAsstActType3();
                asstact[3] = wsVoucher.getAsstActType4();
                asstact[4] = wsVoucher.getAsstActType5();
                asstact[5] = wsVoucher.getAsstActType6();
                asstact[6] = wsVoucher.getAsstActType7();
                asstact[7] = wsVoucher.getAsstActType8();
            }
        }
        return asstact;
    }

    private String checkImpRepeated(Context ctx, String desdription, String comId, String vouchertypeid, String periodid, boolean importParam) throws BOSException, EASBizException {
        if (importParam) {
            StringBuffer sql = new StringBuffer("");
            sql.append("SELECT fnumber from t_gl_voucher where fcompanyid=? and fdescription=?");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{comId, desdription});
                if (rs.next()) {
                    return rs.getString("fnumber");
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    private String checkImport(Context ctx, String importKey) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select v.FNumber \n");
        sql.append("from T_GL_VoucherImportKey k \n");
        sql.append("join T_GL_Voucher v on v.FID = k.FVoucherID \n");
        sql.append("where k.FImportKey = ? \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{importKey});
            if (rs.next()) {
                return rs.getString("FNumber");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public VoucherCollection getVoucherIsTemp(FilterInfo filter, IVoucher voucher) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = evi.getSelector();
        selectorItemCollection.add(new SelectorItemInfo("description"));
        selectorItemCollection.add(new SelectorItemInfo("id"));
        evi.setFilter(filter);
        VoucherCollection voucherCollection = voucher.getVoucherCollection(evi);
        return voucherCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectCollection importVoucher(Context ctx, IObjectCollection voucherCols, boolean isVerify, IObjectCollection cashflowCols, boolean isImpCashflow, boolean isSubmit, boolean post) throws BOSException, EASBizException {
        HashSet<String> comNumbers = new HashSet<String>();
        int count = voucherCols.size();
        for (int i = 0; i < count; ++i) {
            WSVoucherInfo wsVoucher = (WSVoucherInfo)voucherCols.getObject(i);
            String comNumber = wsVoucher.getCompanyNumber();
            if (comNumber == null || comNumber.trim().length() <= 0) continue;
            comNumbers.add(comNumber.trim());
        }
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        cache.setMutexLockModifyBalance(true);
        ArrayList<MutexParameter> mps = new ArrayList<MutexParameter>(comNumbers.size());
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            for (String comNumber : comNumbers) {
                boolean isSucceed;
                CompanyOrgUnitInfo company = cache.getCompanyByNumber(ctx, comNumber);
                if (company == null) continue;
                MutexParameter mp = GLMutexUtils.buildModifyBalanceParameter(ctx, company.getId().toString(), userId, "GL_VoucherImportWebService", null, MutexLockType.SHARE_LOCK);
                MutexParameter current = mutex.requestMutex3(mp);
                boolean bl = isSucceed = current == null;
                if (!isSucceed) {
                    throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
                }
                mps.add(mp);
                GlWebServiceUtil.setWsObject(ctx, comNumber, "accountView");
            }
            IObjectCollection iObjectCollection = this.doImportVoucher(ctx, voucherCols, isVerify, cashflowCols, isImpCashflow, isSubmit, post);
            return iObjectCollection;
        }
        finally {
            for (MutexParameter mp : mps) {
                try {
                    mutex.releaseMutex(mp.getRequestId());
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected IObjectCollection doImportVoucher(Context ctx, IObjectCollection voucherCols, boolean isVerify, IObjectCollection cashflowCols, boolean isImpCashflow, boolean isSubmit, boolean post) throws BOSException, EASBizException {
        Set s;
        WSVoucherInfo wsVoucher;
        int i;
        int count;
        if (voucherCols == null || voucherCols.size() == 0) {
            return null;
        }
        int tatal = 0;
        LinkedHashMap<String, VoucherInfo> impList = new LinkedHashMap<String, VoucherInfo>();
        LinkedHashMap<String, String> errList = new LinkedHashMap<String, String>();
        LinkedHashMap<String, StringBuffer> bufferList = new LinkedHashMap<String, StringBuffer>();
        LinkedHashMap<String, String> repeatList = new LinkedHashMap<String, String>();
        HashMap<String, String> comList = new HashMap<String, String>();
        VoucherInfo voucherInfo = null;
        VoucherEntryInfo entryInfo = null;
        VoucherAssistRecordInfo asstInfo = null;
        String prenumber = null;
        int preentrySeq = -1000;
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"924_WSVoucherControllerBean", (Locale)ctx.getLocale()));
        LowTimer low = new LowTimer();
        low.reset();
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        PeriodInfo period = null;
        CurrencyInfo currencyInfo = null;
        VoucherTypeInfo voucherTypeInfo = null;
        boolean importParam = false;
        boolean useImportKey = false;
        StringBuffer buffer = new StringBuffer();
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        this.prepareCache(ctx, cache, voucherCols);
        Map voucherMap = null;
        HashMap<String, String> importKeys = new HashMap<String, String>();
        Map profitCenterMap = null;
        Map periodMap = null;
        Map currencyInfoMap = null;
        Map voucherTypeInfoMap = null;
        Map userMap = null;
        Map tempMap = null;
        Map customerMap = null;
        boolean isInTimeVerify = true;
        boolean isSettleByLocal = true;
        boolean handnumberParam = false;
        VoucherInfo.ExchangeRateWithValue localToRpt = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
        CashflowRecordImpCollection cashflow2Cols = new CashflowRecordImpCollection();
        if (cashflowCols != null && cashflowCols.size() > 0) {
            count = cashflowCols.size();
            for (i = 0; i < count; ++i) {
                wsVoucher = (WSVoucherInfo)cashflowCols.getObject(i);
                CashflowRecordImpInfo record2 = this.getCashFlowMap(ctx, wsVoucher, errList, buffer, cache);
                if (record2.getRecord() == null) continue;
                cashflow2Cols.addObject(record2);
            }
        }
        count = voucherCols.size();
        for (i = 0; i < count; ++i) {
            String number;
            String line;
            wsVoucher = (WSVoucherInfo)voucherCols.getObject(i);
            String comNumber = wsVoucher.getCompanyNumber();
            if (comNumber != null && !comList.containsKey(comNumber)) {
                comList.put(comNumber, comNumber);
            }
            voucherMap = GlWebServiceUtil.getWsObject(ctx, comNumber, "voucher");
            tempMap = GlWebServiceUtil.getWsObject(ctx, comNumber, "temp");
            periodMap = GlWebServiceUtil.getWsObject(ctx, comNumber, "period");
            currencyInfoMap = GlWebServiceUtil.getWsObject(ctx, comNumber, "currency");
            voucherTypeInfoMap = GlWebServiceUtil.getWsObject(ctx, comNumber, "voucherType");
            userMap = GlWebServiceUtil.getWsObject(ctx, comNumber, "user");
            customerMap = GlWebServiceUtil.getWsObject(ctx, comNumber, "customer");
            profitCenterMap = GlWebServiceUtil.getWsObject(ctx, comNumber, "profitCenter");
            if (wsVoucher.getItemFlag() == 1) continue;
            if (logger.isDebugEnabled() && (line = wsVoucher.toString()) != null) {
                if (line.startsWith("[: null]")) {
                    logger.debug((Object)line.substring(8));
                } else {
                    logger.debug((Object)line);
                }
            }
            if (errList.containsKey(number = wsVoucher.getVoucherNumber())) {
                bufferList.put(number, buffer);
                continue;
            }
            if (prenumber == null || !prenumber.equalsIgnoreCase(number)) {
                block117: {
                    String curNumber;
                    String periodNumber;
                    block116: {
                        bufferList.put(number, buffer);
                        prenumber = number;
                        preentrySeq = -1000;
                        ++tatal;
                        companyOrgUnitInfo = cache.getCompanyByNumber(ctx, comNumber);
                        if (companyOrgUnitInfo == null) {
                            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"925_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getCompanyNumber());
                            errList.put(number, "1001");
                            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"926_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getCompanyNumber()));
                            continue;
                        }
                        if (companyOrgUnitInfo.isIsSealUp()) {
                            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.VoucherImport", (String)"COMPANY_IS_SEALUP", (Locale)ctx.getLocale()) + ":" + wsVoucher.getCompanyNumber());
                            errList.put(number, "1001");
                            continue;
                        }
                        importParam = cache.getImportParam(ctx, companyOrgUnitInfo.getId().toString());
                        useImportKey = cache.getUseImportKey(ctx);
                        isInTimeVerify = cache.getVerifyMode(ctx, companyOrgUnitInfo.getId().toString()) == 0;
                        handnumberParam = cache.getHandnumberParam(ctx, companyOrgUnitInfo.getId().toString());
                        if (companyOrgUnitInfo.getReportConvertMode() == null) {
                            errList.put(number, "3008");
                            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"927_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getCompanyNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"928_WSVoucherControllerBean", (Locale)ctx.getLocale()));
                            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"927_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getCompanyNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"928_WSVoucherControllerBean", (Locale)ctx.getLocale())));
                        }
                        if (!isInTimeVerify) {
                            isVerify = false;
                        }
                        isSettleByLocal = 3 == companyOrgUnitInfo.getReportConvertMode().getValue();
                        String typeId = companyOrgUnitInfo.getAccountPeriodType().getId().toString();
                        periodNumber = String.valueOf(wsVoucher.getPeriodYear() + "_" + wsVoucher.getPeriodNumber());
                        if (wsVoucher.getPeriodYear() == 0) {
                            periodNumber = String.valueOf(wsVoucher.getPeriodNumber());
                        }
                        try {
                            if (periodMap.containsKey(periodNumber + "_" + wsVoucher.getBookedDate()) && periodMap.get(periodNumber + "_" + wsVoucher.getBookedDate()) != null) {
                                period = (PeriodInfo)periodMap.get(periodNumber + "_" + wsVoucher.getBookedDate());
                                break block116;
                            }
                            PeriodCollection periodCollection = GlWebServiceUtil.fetchPeriod(ctx, typeId, wsVoucher.getBookedDate());
                            if (periodCollection.size() <= 0) break block116;
                            for (PeriodInfo periodInfo : periodCollection) {
                                if (periodInfo == null) continue;
                                String checkNumber = String.valueOf(periodInfo.getPeriodYear() + "_" + periodInfo.getPeriodNumber());
                                if (wsVoucher.getPeriodYear() == 0) {
                                    checkNumber = String.valueOf(periodInfo.getPeriodNumber());
                                }
                                if (!checkNumber.equals(periodNumber)) continue;
                                periodMap.put(periodNumber + "_" + wsVoucher.getBookedDate(), periodInfo);
                                period = periodInfo;
                                break;
                            }
                        }
                        catch (Exception e) {
                            errList.put(number, "1004");
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + e.getMessage());
                            continue;
                        }
                    }
                    if (period == null) {
                        errList.put(number, "1004");
                        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"929_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getBookedDate()));
                        buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"929_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getBookedDate());
                        continue;
                    }
                    String checkNumber = String.valueOf(period.getPeriodYear() + "_" + period.getPeriodNumber());
                    if (!checkNumber.equals(periodNumber)) {
                        errList.put(number, "3003");
                        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"930_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getBookedDate() + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"931_WSVoucherControllerBean", (Locale)ctx.getLocale()) + periodNumber + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"932_WSVoucherControllerBean", (Locale)ctx.getLocale())));
                        buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"930_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getBookedDate() + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"931_WSVoucherControllerBean", (Locale)ctx.getLocale()) + periodNumber + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"932_WSVoucherControllerBean", (Locale)ctx.getLocale()));
                        continue;
                    }
                    String voucherNumber = wsVoucher.getVoucherType();
                    if (voucherTypeInfoMap.containsKey(voucherNumber) && voucherTypeInfoMap.get(voucherNumber) != null) {
                        voucherTypeInfo = (VoucherTypeInfo)voucherTypeInfoMap.get(voucherNumber);
                    } else {
                        voucherTypeInfo = GlWebServiceUtil.findVouherTypeByName(ctx, voucherNumber, companyOrgUnitInfo.getCU().getId());
                        if (voucherTypeInfo != null) {
                            voucherTypeInfoMap.put(voucherNumber, voucherTypeInfo);
                        }
                    }
                    if (voucherTypeInfo == null) {
                        errList.put(number, "1005");
                        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"933_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getVoucherType()));
                        buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"934_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getVoucherType());
                        continue;
                    }
                    String importKey = wsVoucher.getImportKey();
                    if (importParam && useImportKey && importKey != null && importKey.trim().length() > 0) {
                        if (importKeys.containsKey(importKey = importKey.trim())) {
                            errList.put(number, "3101");
                            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"936_WSVoucherControllerBean", (Locale)ctx.getLocale()) + importKeys.get(importKey) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"937_WSVoucherControllerBean", (Locale)ctx.getLocale()));
                            continue;
                        }
                        importKeys.put(importKey, number);
                        String repnumber = this.checkImport(ctx, importKey);
                        if (repnumber != null) {
                            errList.put(number, "3100");
                            repeatList.put(number, repnumber);
                            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"935_WSVoucherControllerBean", (Locale)ctx.getLocale()) + repnumber);
                            continue;
                        }
                    } else {
                        String desc = wsVoucher.getDescription();
                        String repnumber = null;
                        if (!StringUtils.isEmpty((String)desc)) {
                            if (importParam && voucherMap.containsKey(desc) && voucherMap.get(desc) != null) {
                                repnumber = (String)voucherMap.get(desc);
                            } else {
                                repnumber = this.checkImpRepeated(ctx, desc, companyOrgUnitInfo.getId().toString(), voucherTypeInfo.getId().toString(), period.getId().toString(), importParam);
                                if (repnumber != null) {
                                    voucherMap.put(desc, repnumber);
                                }
                            }
                        }
                        if (repnumber != null) {
                            errList.put(number, "3100");
                            repeatList.put(number, repnumber);
                            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"935_WSVoucherControllerBean", (Locale)ctx.getLocale()) + repnumber);
                            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"935_WSVoucherControllerBean", (Locale)ctx.getLocale()) + repnumber));
                            continue;
                        }
                        if (desc != null && importParam && tempMap.containsKey(desc) && tempMap.get(desc) != null) {
                            repnumber = (String)tempMap.get(desc);
                        }
                        if (repnumber != null) {
                            errList.put(number, "3101");
                            repeatList.put(number, repnumber);
                            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"936_WSVoucherControllerBean", (Locale)ctx.getLocale()) + repnumber + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"937_WSVoucherControllerBean", (Locale)ctx.getLocale()));
                            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"936_WSVoucherControllerBean", (Locale)ctx.getLocale()) + repnumber + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"938_WSVoucherControllerBean", (Locale)ctx.getLocale())));
                            continue;
                        }
                        tempMap.put(desc, desc);
                    }
                    if (wsVoucher.getCurrencyNumber() == null) {
                        wsVoucher.setCurrencyNumber("BB01");
                    }
                    if (currencyInfoMap.containsKey(curNumber = wsVoucher.getCurrencyNumber()) && currencyInfoMap.get(curNumber) != null) {
                        currencyInfo = (CurrencyInfo)currencyInfoMap.get(curNumber);
                    } else {
                        currencyInfo = GlWebServiceUtil.findCurrencyByNumber(ctx, wsVoucher.getCurrencyNumber());
                        if (currencyInfo != null) {
                            currencyInfoMap.put(curNumber, currencyInfo);
                        }
                    }
                    if (currencyInfo == null) {
                        errList.put(number, "1003");
                        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"939_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getCurrencyNumber()));
                        buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"939_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getCurrencyNumber());
                        continue;
                    }
                    String cteator = wsVoucher.getCreator();
                    UserInfo creatorInfo = null;
                    if (userMap.containsKey(cteator) && userMap.get(cteator) != null) {
                        creatorInfo = (UserInfo)userMap.get(cteator);
                    } else {
                        creatorInfo = GlWebServiceUtil.findUserUByName(ctx, cteator);
                        if (creatorInfo != null) {
                            userMap.put(cteator, creatorInfo);
                        }
                    }
                    if (creatorInfo == null) {
                        errList.put(number, "1008");
                        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"940_WSVoucherControllerBean", (Locale)ctx.getLocale()) + cteator));
                        buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"940_WSVoucherControllerBean", (Locale)ctx.getLocale()) + cteator);
                        continue;
                    }
                    UserInfo auditorInfo = null;
                    UserInfo posterInfo = null;
                    if (post) {
                        String auditor = wsVoucher.getPoster();
                        if (userMap.containsKey(auditor) && userMap.get(auditor) != null) {
                            auditorInfo = (UserInfo)userMap.get(auditor);
                        } else {
                            auditorInfo = GlWebServiceUtil.findUserUByName(ctx, auditor);
                            if (auditorInfo != null) {
                                userMap.put(auditor, auditorInfo);
                            }
                        }
                        String poster = wsVoucher.getPoster();
                        if (userMap.containsKey(poster) && userMap.get(poster) != null) {
                            posterInfo = (UserInfo)userMap.get(poster);
                        } else {
                            posterInfo = GlWebServiceUtil.findUserUByName(ctx, poster);
                            if (posterInfo != null) {
                                userMap.put(poster, posterInfo);
                            }
                        }
                        if (posterInfo == null) {
                            errList.put(number, "1020");
                            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"941_WSVoucherControllerBean", (Locale)ctx.getLocale()) + poster));
                            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"941_WSVoucherControllerBean", (Locale)ctx.getLocale()) + poster);
                            continue;
                        }
                    }
                    try {
                        voucherInfo = this.contructVoucherHeader(ctx, wsVoucher, companyOrgUnitInfo, period, voucherTypeInfo, currencyInfo);
                        voucherInfo.setCreator(creatorInfo);
                        voucherInfo.setHandler(creatorInfo);
                        voucherInfo.setAuditor(auditorInfo);
                        voucherInfo.setPoster(posterInfo);
                        if (!importParam || !useImportKey || importKey == null || importKey.trim().length() <= 0) break block117;
                        voucherInfo.put("importKey", (Object)importKey.trim());
                    }
                    catch (EASBizException e) {
                        logger.info((Object)e);
                        logger.info((Object)e.getMessage());
                        buffer.append(e.getMessage());
                        continue;
                    }
                }
                if (handnumberParam) {
                    voucherInfo.setNumber(number);
                    voucherInfo.setPostedByUI(true);
                }
                if (companyOrgUnitInfo.getReportCurrency() != null && isSettleByLocal && companyOrgUnitInfo.getReportExchangeTable() != null && companyOrgUnitInfo.getBaseExchangeTable() != null && (localToRpt = GlUtils.getLocalToReportingExchangeRate(companyOrgUnitInfo.getReportCurrency(), companyOrgUnitInfo.getReportExchangeTable().getId().toString(), companyOrgUnitInfo.getBaseCurrency(), companyOrgUnitInfo.getBaseExchangeTable().getId().toString(), voucherInfo.getBookedDate(), period, false, ctx)) == null) {
                    localToRpt = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
                }
                if (isImpCashflow && cashflow2Cols != null && cashflow2Cols.size() > 0) {
                    CashflowRecordCollection cos = new CashflowRecordCollection();
                    int n = cashflow2Cols.size();
                    for (int ca = 0; ca < n; ++ca) {
                        CashflowRecordImpInfo key = (CashflowRecordImpInfo)cashflow2Cols.getObject(ca);
                        String value = key.getVouchernumber();
                        if (key.getBoolean("error")) {
                            errList.put(number, "2001");
                            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"945_WSVoucherControllerBean", (Locale)ctx.getLocale()) + value);
                            continue;
                        }
                        if (!number.equalsIgnoreCase(value)) continue;
                        CashflowRecordInfo record = key.getRecord();
                        if (isSettleByLocal) {
                            record.setReportingAmount(record.getLocalAmount().multiply(localToRpt.getValue()));
                        }
                        record.setVoucher(voucherInfo);
                        cos.add(record);
                    }
                    voucherInfo.setCashflowRecords((AbstractObjectCollection)cos);
                    if (cos.size() > 0) {
                        voucherInfo.setCashflowFlag(CashflowFlag.FINISHED);
                    }
                }
                impList.put(number, voucherInfo);
            }
            int entrySeq = wsVoucher.getEntrySeq();
            int asstCountSeq = 0;
            if (preentrySeq == -1000 || preentrySeq != entrySeq) {
                preentrySeq = entrySeq;
                asstCountSeq = 1;
                String profitCenterNumber = wsVoucher.getProfitCenterNumber();
                ProfitCenterOrgUnitInfo profitCenterOrgUnitInfo = null;
                if (profitCenterMap.containsKey(profitCenterNumber) && profitCenterMap.get(profitCenterNumber) != null) {
                    profitCenterOrgUnitInfo = (ProfitCenterOrgUnitInfo)profitCenterMap.get(profitCenterNumber);
                } else {
                    profitCenterOrgUnitInfo = GlWebServiceUtil.findProfitCenterOrgByNumber(ctx, profitCenterNumber);
                    if (profitCenterOrgUnitInfo != null) {
                        if (!profitCenterOrgUnitInfo.isIsBizUnit()) {
                            errList.put(number, "1101");
                            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1101_WSVoucherControllerBean", (Locale)ctx.getLocale(), (Object[])new Object[]{profitCenterNumber}));
                            continue;
                        }
                        String profitCenterId = profitCenterOrgUnitInfo.getId().toString();
                        String companyId = GlWebServiceUtil.getRelatedCompanyIds(ctx, profitCenterId);
                        if (!companyOrgUnitInfo.getId().toString().equals(companyId)) {
                            errList.put(number, "1089");
                            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1089_WSVoucherControllerBean", (Locale)ctx.getLocale(), (Object[])new Object[]{profitCenterOrgUnitInfo.getNumber(), companyOrgUnitInfo.getNumber()}));
                            continue;
                        }
                        profitCenterMap.put(profitCenterNumber, profitCenterOrgUnitInfo);
                    } else if (!StringUtils.isEmpty((String)profitCenterNumber)) {
                        errList.put(number, "1100");
                        buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1100_WSVoucherControllerBean", (Locale)ctx.getLocale(), (Object[])new Object[]{profitCenterNumber}));
                        continue;
                    }
                }
                String accountNumber = wsVoucher.getAccountNumber();
                AccountViewInfo accountViewInfo = cache.findAccountByNumber(ctx, accountNumber, voucherInfo.getCompany());
                if (accountViewInfo == null) {
                    errList.put(number, "1002");
                    logger.info((Object)"1002");
                    buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"946_WSVoucherControllerBean", (Locale)ctx.getLocale()) + entrySeq + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"947_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getAccountNumber());
                    continue;
                }
                if (accountViewInfo.isAC()) {
                    voucherInfo.setIsAC(true);
                }
                if (voucherInfo.getCategory() == null) {
                    if (AccountCategoryEnum.FINANCE.equals((Object)accountViewInfo.getCategory())) {
                        voucherInfo.setCategory(VoucherCategoryEnum.FINANCE);
                    } else if (AccountCategoryEnum.BUDGET.equals((Object)accountViewInfo.getCategory())) {
                        voucherInfo.setCategory(VoucherCategoryEnum.BUDGET);
                    }
                } else if (VoucherCategoryEnum.FINANCE.equals((Object)voucherInfo.getCategory())) {
                    if (AccountCategoryEnum.BUDGET.equals((Object)accountViewInfo.getCategory())) {
                        voucherInfo.setCategory(VoucherCategoryEnum.PARALLEL);
                    }
                } else if (VoucherCategoryEnum.BUDGET.equals((Object)voucherInfo.getCategory()) && AccountCategoryEnum.FINANCE.equals((Object)accountViewInfo.getCategory())) {
                    voucherInfo.setCategory(VoucherCategoryEnum.PARALLEL);
                }
                String customerNumber = wsVoucher.getCustomerNumber();
                CustomerInfo customerInfo = null;
                if (customerMap.containsKey(customerNumber) && customerMap.get(customerNumber) != null) {
                    customerInfo = (CustomerInfo)customerMap.get(customerNumber);
                } else {
                    customerInfo = GlWebServiceUtil.findCustomerNumber(ctx, wsVoucher.getCustomerNumber(), voucherInfo.getCompany());
                    if (customerInfo != null) {
                        customerMap.put(customerNumber, customerInfo);
                    }
                }
                String curNumber = wsVoucher.getCurrencyNumber();
                if (currencyInfoMap.containsKey(curNumber) && currencyInfoMap.get(curNumber) != null) {
                    currencyInfo = (CurrencyInfo)currencyInfoMap.get(curNumber);
                } else {
                    currencyInfo = GlWebServiceUtil.findCurrencyByNumber(ctx, wsVoucher.getCurrencyNumber());
                    if (currencyInfo != null) {
                        currencyInfoMap.put(curNumber, currencyInfo);
                    }
                }
                if (currencyInfo == null) {
                    errList.put(number, "1003");
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"939_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getCurrencyNumber()));
                    buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"939_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getCurrencyNumber());
                    continue;
                }
                boolean commonVoucherProcess = Boolean.valueOf(VoucherProcessCache.getParam(ctx, voucherInfo.getCompany().getId().toString(), "GL_111").toString());
                boolean profitCenterNeed = Boolean.valueOf(VoucherProcessCache.getParam(ctx, companyOrgUnitInfo.getId().toString(), "GL_108").toString());
                if (commonVoucherProcess && profitCenterNeed && (profitCenterNumber == null || profitCenterNumber.equals(""))) {
                    errList.put(number, "1010");
                    logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"971_WSVoucherControllerBean", (Locale)ctx.getLocale()));
                    buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"971_WSVoucherControllerBean", (Locale)ctx.getLocale()));
                    continue;
                }
                if (commonVoucherProcess && profitCenterNeed && profitCenterOrgUnitInfo == null) {
                    errList.put(number, "1009");
                    logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"970_WSVoucherControllerBean", (Locale)ctx.getLocale()));
                    buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"970_WSVoucherControllerBean", (Locale)ctx.getLocale()));
                    continue;
                }
                boolean checkAccountAndCurrency = cache.checkAccountAndCurrency(ctx, accountViewInfo, currencyInfo, voucherInfo.getCompany());
                if (currencyInfo == null) {
                    errList.put(number, "1003");
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"939_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getCurrencyNumber()));
                    buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"939_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getCurrencyNumber());
                    continue;
                }
                if (!checkAccountAndCurrency) {
                    errList.put(number, "1006");
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"950_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getCurrencyNumber()));
                    buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"950_WSVoucherControllerBean", (Locale)ctx.getLocale()) + wsVoucher.getCurrencyNumber());
                    continue;
                }
                if (accountViewInfo.isIsCash() || accountViewInfo.isIsBank() || accountViewInfo.isIsCashEquivalent()) {
                    voucherInfo.setHasCashAccount(true);
                }
                entryInfo = this.contructVoucherEntry(ctx, wsVoucher, voucherInfo, profitCenterOrgUnitInfo, accountViewInfo, currencyInfo, cashflow2Cols, isSettleByLocal, localToRpt);
                voucherInfo.getEntries().appendObject((IObjectValue)entryInfo);
                entryInfo.setBill(voucherInfo);
                voucherInfo.setEntryCount(entrySeq);
                entryInfo.setCustomer(customerInfo);
                entryInfo.setIsVerify(this.isVerify(accountViewInfo, entryInfo.getEntryDC(), true));
            }
            AsstAccountInfo fcaa = entryInfo.getCAA();
            if (entryInfo.getAccount().isHasUserProperty() && fcaa == null) {
                fcaa = new AsstAccountInfo();
            }
            if (fcaa != null) {
                int asstSeq;
                block118: {
                    asstSeq = wsVoucher.getAsstSeq();
                    try {
                        asstInfo = new VoucherAssistRecordInfo();
                        String errNumber = this.contructVoucherAsstRecord(ctx, wsVoucher, voucherInfo, fcaa, entryInfo, asstInfo, isVerify, isSettleByLocal, localToRpt, isSubmit);
                        if (errNumber != null) {
                            errList.put(number, errNumber);
                            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + errNumber);
                        }
                        break block118;
                    }
                    catch (EASBizException e) {
                        logger.info((Object)e);
                        buffer.append("\n1007: \r\n");
                        buffer.append(e.getMessage());
                    }
                    continue;
                }
                asstInfo.setSeq(asstSeq);
                entryInfo.getAssistRecords().add(asstInfo);
                asstInfo.setEntry(entryInfo);
                asstInfo.setBill(voucherInfo);
                if (asstCountSeq == 1) {
                    entryInfo.setOriginalAmount(asstInfo.getOriginalAmount());
                    entryInfo.setLocalAmount(asstInfo.getLocalAmount());
                    entryInfo.setReportingAmount(asstInfo.getReportingAmount());
                    ++asstCountSeq;
                } else {
                    entryInfo.setOriginalAmount(entryInfo.getOriginalAmount().add(asstInfo.getOriginalAmount()));
                    entryInfo.setLocalAmount(entryInfo.getLocalAmount().add(asstInfo.getLocalAmount()));
                    entryInfo.setReportingAmount(entryInfo.getReportingAmount().add(asstInfo.getReportingAmount()));
                }
            }
            if (wsVoucher.getEntryDC() == 0) {
                if (voucherInfo.getLocalCreditAmount() == null) {
                    voucherInfo.setLocalCreditAmount(entryInfo.getLocalAmount());
                } else {
                    voucherInfo.setLocalCreditAmount(voucherInfo.getLocalCreditAmount().add(entryInfo.getLocalAmount()));
                }
            } else if (voucherInfo.getLocalDebitAmount() == null) {
                voucherInfo.setLocalDebitAmount(entryInfo.getLocalAmount());
            } else {
                voucherInfo.setLocalDebitAmount(voucherInfo.getLocalDebitAmount().add(entryInfo.getLocalAmount()));
            }
            voucherInfo.setReportingCreditAmount(voucherInfo.getReportingCreditAmount());
            voucherInfo.setReportingDebitAmount(voucherInfo.getReportingDebitAmount());
        }
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"953_WSVoucherControllerBean", (Locale)ctx.getLocale()) + low.msValue()));
        low.reset();
        WSVoucherCollection cols = new WSVoucherCollection();
        WSVoucherInfo wsVoucher2 = null;
        int sucCount = 0;
        Set set = impList.keySet();
        Iterator it = set.iterator();
        Map result = null;
        while (it.hasNext()) {
            String key = (String)it.next();
            VoucherInfo tmpVoucherInfo = (VoucherInfo)impList.get(key);
            boolean checkImpRepeated = cache.getImportParam(ctx, tmpVoucherInfo.getCompany().getId().toString());
            boolean checkImportKey = cache.getUseImportKey(ctx);
            this.calcSupplementaryCoefficient(tmpVoucherInfo);
            result = this.saveVoucher(ctx, key, tmpVoucherInfo, errList, voucherMap, low, isSubmit, post, sucCount, checkImpRepeated, checkImportKey);
            cols.addObjectCollection((IObjectCollection)result.get("cols"));
            voucherMap = (Map)result.get("voucherMap");
            sucCount = Integer.parseInt((String)result.get("sucCount"));
        }
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"954_WSVoucherControllerBean", (Locale)ctx.getLocale()) + tatal));
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"955_WSVoucherControllerBean", (Locale)ctx.getLocale()) + sucCount));
        set = errList.keySet();
        it = set.iterator();
        boolean isClearTemp = true;
        while (it.hasNext()) {
            String key = (String)it.next();
            wsVoucher2 = new WSVoucherInfo();
            wsVoucher2.setVoucherNumber(key);
            String errCode = (String)errList.get(key);
            wsVoucher2.setDescription(errCode);
            buffer = (StringBuffer)bufferList.get(key);
            if (buffer != null) {
                wsVoucher2.setVoucherAbstract(buffer.toString());
            }
            if ("3100".equals(errCode) && repeatList.get(key) != null) {
                wsVoucher2.setAccountNumber((String)repeatList.get(key));
            }
            if ("3101".equals(errCode)) {
                isClearTemp = false;
            }
            cols.addObject((IObjectValue)wsVoucher2);
        }
        if (isClearTemp && comList.size() > 0) {
            s = comList.keySet();
            Iterator i2 = s.iterator();
            while (i2.hasNext()) {
                GlWebServiceUtil.setWsObject(ctx, (String)i2.next(), "temp");
            }
        }
        if (comList.size() > 0) {
            s = comList.keySet();
            for (String comNumber : s) {
                GlWebServiceUtil.cleanWsObject(ctx, comNumber);
                GlWebServiceUtil.setWsObject(ctx, comNumber, "accountView");
            }
        }
        return cols;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("description"));
        return sic;
    }

    protected boolean isVerify(AccountViewInfo acc, EntryDC entryDC, boolean allowCussent) {
        BalanceDirectionEnum accDC;
        return allowCussent && acc != null && acc.isAC() && (BalanceDirectionEnum.DEBIT.equals((Object)(accDC = acc.getDC())) && EntryDC.CREDIT.equals((Object)entryDC) || BalanceDirectionEnum.CREDIT.equals((Object)accDC) && EntryDC.DEBIT.equals((Object)entryDC));
    }

    @Override
    protected String[][] _importVoucher(Context ctx, IObjectCollection voucherCols, int isVerify, int isImpCashflow) throws BOSException, EASBizException {
        return this.importVoucherOfReturnInfo(ctx, voucherCols, isVerify, isImpCashflow, false);
    }

    private String[][] checkDebitAmountByGL0301(Context ctx, IObjectCollection voucherCols) throws EASBizException, BOSException {
        int voucherSize = voucherCols.size();
        if (0 == voucherSize) {
            return null;
        }
        WSVoucherInfo wsVoucher = null;
        String comNumber = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        GlParam param = null;
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        HashMap<String, GlParam> paramsMap = new HashMap<String, GlParam>();
        for (int i = 0; i < voucherSize; ++i) {
            wsVoucher = (WSVoucherInfo)voucherCols.getObject(i);
            if (wsVoucher.getItemFlag() == 1 || (companyOrgUnitInfo = cache.getCompanyByNumber(ctx, comNumber = wsVoucher.getCompanyNumber())) == null || (param = this.getParamFromParamsMap(ctx, paramsMap, companyOrgUnitInfo.getId().toString())).getBoolean("GL_0301") || !this.checkDebitAmountIsNull(wsVoucher)) continue;
            return this.getGL0301ErrorMsy(wsVoucher, i);
        }
        return null;
    }

    private GlParam getParamFromParamsMap(Context ctx, HashMap<String, GlParam> paramsMap, String paramKey) throws EASBizException, BOSException {
        if (null != paramsMap.get(paramKey)) {
            return paramsMap.get(paramKey);
        }
        GlParam param = GlParam.getGlParams((Context)ctx, (String)"GL_0301", (String)paramKey);
        paramsMap.put(paramKey, param);
        return param;
    }

    private String[][] getGL0301ErrorMsy(WSVoucherInfo wsVoucher, int num) {
        String[][] result = new String[1][8];
        result[0][0] = wsVoucher.getVoucherNumber();
        result[0][1] = wsVoucher.getVoucherType();
        result[0][2] = String.valueOf(wsVoucher.getPeriodYear());
        result[0][3] = String.valueOf(wsVoucher.getPeriodNumber());
        result[0][4] = "4001";
        result[0][5] = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"please_check_gl0301", (Locale)Locale.getDefault()), num + 1);
        result[0][6] = wsVoucher.getAccountNumber();
        result[0][7] = (String)wsVoucher.get("id");
        return result;
    }

    private boolean checkDebitAmountIsNull(WSVoucherInfo wsVoucher) {
        if (new BigDecimal(wsVoucher.getOriginalAmount()).compareTo(BigDecimal.ZERO) != 0 && new BigDecimal(wsVoucher.getLocalRate()).compareTo(BigDecimal.ZERO) != 0) {
            return false;
        }
        return new BigDecimal(wsVoucher.getDebitAmount()).compareTo(new BigDecimal(0)) == 0 && new BigDecimal(wsVoucher.getCreditAmount()).compareTo(new BigDecimal(0)) == 0;
    }

    @Override
    protected String[][] _importVoucherOfReturnID(Context ctx, IObjectCollection voucherCols, int isVerify, int isImpCashflow) throws BOSException, EASBizException {
        return this.importVoucherOfReturnInfo(ctx, voucherCols, isVerify, isImpCashflow, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[][] importVoucherOfReturnInfo(Context ctx, IObjectCollection voucherCols, int isVerify, int isImpCashflow, boolean returnVchID) throws BOSException, EASBizException {
        WSVoucherInfo wsVoucher;
        int i;
        int count;
        int stringSize = 7;
        if (returnVchID) {
            stringSize = 8;
        }
        if (voucherCols == null || voucherCols.size() == 0) {
            String[][] result = new String[1][stringSize];
            result[0][0] = "none voucher need introduce !";
            result[0][4] = "1000";
            return result;
        }
        String[][] result = null;
        CashflowRecordImpCollection cashflowCols = null;
        WSVoucherCollection voucher2Cols = null;
        if (isImpCashflow == 1) {
            cashflowCols = new CashflowRecordImpCollection();
            voucher2Cols = new WSVoucherCollection();
            count = voucherCols.size();
            for (i = 0; i < count; ++i) {
                wsVoucher = (WSVoucherInfo)voucherCols.getObject(i);
                if (wsVoucher.getItemFlag() == 1) {
                    cashflowCols.addObject((IObjectValue)wsVoucher);
                    continue;
                }
                voucher2Cols.addObject((IObjectValue)wsVoucher);
            }
        } else {
            voucher2Cols = new WSVoucherCollection();
            count = voucherCols.size();
            for (i = 0; i < count; ++i) {
                wsVoucher = (WSVoucherInfo)voucherCols.getObject(i);
                if (wsVoucher.getItemFlag() == 1) continue;
                voucher2Cols.addObject((IObjectValue)wsVoucher);
            }
        }
        boolean verify = isVerify == 1 || isVerify == 3;
        boolean isSubmit = isVerify == 2 || isVerify == 3;
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"956_WSVoucherControllerBean", (Locale)ctx.getLocale()) + voucher2Cols.size()));
        if (isImpCashflow == 1) {
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"957_WSVoucherControllerBean", (Locale)ctx.getLocale()) + cashflowCols.size()));
        } else {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"958_WSVoucherControllerBean", (Locale)ctx.getLocale()));
        }
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"959_WSVoucherControllerBean", (Locale)ctx.getLocale()) + verify + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"960_WSVoucherControllerBean", (Locale)ctx.getLocale()) + isSubmit + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"961_WSVoucherControllerBean", (Locale)ctx.getLocale()) + (isImpCashflow == 1)));
        boolean post = false;
        if (isVerify == 99) {
            post = true;
            verify = false;
            isSubmit = false;
        }
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        IObjectCollection resultCol = null;
        try {
            VoucherProcessCache.initCache(ctx, cacheId);
            String[][] checkResult = this.checkDebitAmountByGL0301(ctx, (IObjectCollection)voucher2Cols);
            if (null != checkResult) {
                String[][] stringArray = checkResult;
                return stringArray;
            }
            resultCol = this.importVoucher(ctx, (IObjectCollection)voucher2Cols, verify, cashflowCols, isImpCashflow == 1, isSubmit, post);
        }
        finally {
            VoucherProcessCache.clearCache(ctx, cacheId);
            GlWebServiceUtil.cleanAllWsObject();
        }
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"962_WSVoucherControllerBean", (Locale)ctx.getLocale()));
        if (resultCol != null) {
            result = new String[resultCol.size()][stringSize];
            int count2 = resultCol.size();
            for (int i2 = 0; i2 < count2; ++i2) {
                WSVoucherInfo wsVoucher2 = (WSVoucherInfo)resultCol.getObject(i2);
                result[i2][0] = wsVoucher2.getVoucherNumber();
                result[i2][1] = wsVoucher2.getVoucherType();
                result[i2][2] = String.valueOf(wsVoucher2.getPeriodYear());
                result[i2][3] = String.valueOf(wsVoucher2.getPeriodNumber());
                result[i2][4] = wsVoucher2.getDescription();
                result[i2][5] = wsVoucher2.getVoucherAbstract();
                result[i2][6] = wsVoucher2.getAccountNumber();
                if (returnVchID) {
                    result[i2][7] = (String)wsVoucher2.get("id");
                }
                if (returnVchID) {
                    logger.info((Object)("[" + i2 + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"963_WSVoucherControllerBean", (Locale)ctx.getLocale()) + result[i2][0] + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"964_WSVoucherControllerBean", (Locale)ctx.getLocale()) + result[i2][4] + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"965_WSVoucherControllerBean", (Locale)ctx.getLocale()) + result[i2][5] + result[i2][6] + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"966_WSVoucherControllerBean", (Locale)ctx.getLocale()) + result[i2][7]));
                    continue;
                }
                logger.info((Object)("[" + i2 + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"963_WSVoucherControllerBean", (Locale)ctx.getLocale()) + result[i2][0] + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"964_WSVoucherControllerBean", (Locale)ctx.getLocale()) + result[i2][4] + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"965_WSVoucherControllerBean", (Locale)ctx.getLocale()) + result[i2][5] + result[i2][6]));
            }
        }
        return result;
    }

    private CashflowRecordImpInfo getCashFlowMap(Context ctx, WSVoucherInfo wsVoucher, Map errList, StringBuffer buffer, VoucherProcessCache cache) throws BOSException {
        String supplynumber;
        CashFlowItemInfo sucashInfo;
        CashflowRecordImpInfo recodImp = new CashflowRecordImpInfo();
        recodImp.setVouchernumber(wsVoucher.getVoucherNumber());
        recodImp.setSeq(String.valueOf(wsVoucher.getEntrySeq()));
        recodImp.setOppseq(String.valueOf(wsVoucher.getOppAccountSeq()));
        String primarynumber = wsVoucher.getPrimaryItem();
        CashFlowItemInfo cashInfo = GlWebServiceUtil.findCashflowItemByName(ctx, primarynumber, wsVoucher, cache);
        if (primarynumber != null && !"".equals(primarynumber.trim()) && cashInfo == null) {
            recodImp.setBoolean("error", true);
        }
        if (cashInfo != null && !cashInfo.isIsLeaf()) {
            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.VoucherImport", (String)"CASHFLOW_NOT_LEAF", (Locale)ctx.getLocale()));
            errList.put(wsVoucher.getVoucherNumber(), "2001");
            logger.info((Object)("\u4e3b\u8868\u9879\u76ee\uff1a" + primarynumber + "\u4e3a\u975e\u660e\u7ec6\u9879\u76ee\uff01"));
        }
        if ((sucashInfo = GlWebServiceUtil.findCashflowItemByName(ctx, supplynumber = wsVoucher.getSupplyItem(), wsVoucher, cache)) != null && !sucashInfo.isIsLeaf()) {
            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.VoucherImport", (String)"CASHFLOW_NOT_LEAF", (Locale)ctx.getLocale()));
            errList.put(wsVoucher.getVoucherNumber(), "2001");
            logger.info((Object)("\u9644\u8868\u9879\u76ee\uff1a" + supplynumber + " \u4e3a\u975e\u660e\u7ec6\u9879\u76ee\uff01"));
        }
        String companyNumber = wsVoucher.getCompanyNumber();
        CompanyOrgUnitInfo company = GlWebServiceUtil.getCompany(ctx, companyNumber);
        BigDecimal originalAmount = new BigDecimal(String.valueOf(wsVoucher.getCashflowAmountOriginal()));
        BigDecimal localamount = new BigDecimal(String.valueOf(wsVoucher.getCashflowAmountLocal()));
        BigDecimal reportamount = new BigDecimal(String.valueOf(wsVoucher.getCashflowAmountRpt()));
        int primarycoef = (int)wsVoucher.getPrimaryCoef();
        int supplycoef = (int)wsVoucher.getSupplyCoef();
        CashflowRecordInfo record = new CashflowRecordInfo();
        record.setOriginalAmount(originalAmount);
        record.setLocalAmount(localamount);
        record.setReportingAmount(reportamount);
        record.setPrimaryCoefficient(primarycoef);
        record.setSupplementaryCoefficient(supplycoef);
        record.setSupplementaryItem(sucashInfo);
        record.setPrimaryItem(cashInfo);
        if (sucashInfo == null) {
            record.setItemFlag(ItemFlag.PRIMARY);
        } else if (cashInfo == null) {
            record.setItemFlag(ItemFlag.SUPPLEMENTARY);
        } else {
            record.setItemFlag(ItemFlag.BOTH);
        }
        if (ItemFlag.PRIMARY == record.getItemFlag() && record.getPrimaryItem() == null) {
            buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"481_VoucherUtil", (Locale)ctx.getLocale()));
            errList.put(wsVoucher.getVoucherNumber(), "2001");
            logger.info((Object)("\u51ed\u8bc1\u53f7\uff1a" + wsVoucher.getVoucherNumber() + "\u5bf9\u5e94\u7684\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\u7f16\u7801\u627e\u4e0d\u5230\u4e3b\u8868\u9879\u76ee\uff01"));
        }
        String type = wsVoucher.getType();
        String TYPE_IN = this.getResource(ctx, "type_in");
        String TYPE_OUT = this.getResource(ctx, "type_out");
        if (primarynumber != null && !"".equals(primarynumber.trim()) && !"null".equalsIgnoreCase(primarynumber)) {
            if (cashInfo == null) {
                errList.put(wsVoucher.getVoucherNumber(), "2001");
            } else if (type == null) {
                String[] asstactTypeNumber;
                boolean hasAsstact = false;
                for (String string : asstactTypeNumber = this.getCashAsstactArray(wsVoucher, 2)) {
                    if (string == null) continue;
                    hasAsstact = true;
                }
                if (hasAsstact) {
                    errList.put(wsVoucher.getVoucherNumber(), "2004");
                } else {
                    type = TYPE_OUT;
                }
            } else if (cashInfo.getAsstAccount() == null && !CashflowTypeEnum.OUT.getAlias().equals(type)) {
                errList.put(wsVoucher.getVoucherNumber(), "2005");
            } else if (!type.equals(TYPE_OUT) && !type.equals(TYPE_IN)) {
                errList.put(wsVoucher.getVoucherNumber(), "2002");
            } else {
                String[] asstactType = this.getCashAsstactArray(wsVoucher, 1);
                String[] asstactTypeNumber = this.getCashAsstactArray(wsVoucher, 2);
                String[] asstactTypeName = this.getCashAsstactArray(wsVoucher, 3);
                AssistantHGInfo assistantHGInfo = new AssistantHGInfo();
                AsstActTypeCollection arrayAsstActTypeInfo = new AsstActTypeCollection();
                boolean assistSubFlag = false;
                if (cashInfo.getAsstAccount() != null) {
                    HashMap<String, ObjectUuidPK> hmNumAndOrgId = new HashMap<String, ObjectUuidPK>();
                    ObjectUuidPK comPk = new ObjectUuidPK(company.getId().toString());
                    hmNumAndOrgId.put("GL_102", comPk);
                    HashMap hmAllParam = null;
                    try {
                        hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmNumAndOrgId);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                    int cashOutAsst = Integer.parseInt(hmAllParam.get("GL_102").toString());
                    boolean isAllMust = cashOutAsst == 0 || "\u5185\u90e8".equals(type) && cashOutAsst == 1;
                    int inAttrCount = 0;
                    int asstCount = cashInfo.getAsstAccount().getCount();
                    for (int k = 0; k < asstCount; ++k) {
                        String atype = asstactType[k];
                        String anumber = asstactTypeNumber[k];
                        String aname = asstactTypeName[k];
                        if (isAllMust && StringUtil.isEmptyString((String)atype)) {
                            errList.put(wsVoucher.getVoucherNumber(), "2008");
                            logger.info((Object)("\u51ed\u8bc1\u53f7\uff1a" + wsVoucher.getVoucherNumber() + "\u5bf9\u5e94\u7684\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\u8f85\u52a9\u7c7b\u578b\u4e0e\u8f93\u5165\u4e0d\u7b26\uff0c\u6838\u7b97\u9879\u76ee\u7c7b\u578b\u4e3a\u7a7a\uff01"));
                            assistSubFlag = true;
                            break;
                        }
                        String string = atype = StringUtils.isEmpty((String)atype) ? "" : atype.trim();
                        if (isAllMust && StringUtil.isEmptyString((String)anumber)) {
                            errList.put(wsVoucher.getVoucherNumber(), "2009");
                            logger.info((Object)("\u51ed\u8bc1\u53f7\uff1a" + wsVoucher.getVoucherNumber() + "\u5bf9\u5e94\u7684\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\u8f85\u52a9\u7c7b\u578b\u4e0e\u8f93\u5165\u4e0d\u7b26\uff0c\u6838\u7b97\u9879\u76ee\u7f16\u7801\u4e3a\u7a7a\uff01"));
                            assistSubFlag = true;
                            break;
                        }
                        String string2 = anumber = StringUtils.isEmpty((String)anumber) ? "" : anumber.trim();
                        if (!StringUtil.isEmptyString((String)aname)) {
                            aname = aname.trim();
                        }
                        AsstActTypeInfo asstActTypeInfo = VoucherProcessCache.findAsstActTypeByNumberOrName(ctx, atype);
                        if (isAllMust && asstActTypeInfo == null) {
                            errList.put(wsVoucher.getVoucherNumber(), "2003");
                            logger.info((Object)("\u51ed\u8bc1\u53f7\uff1a" + wsVoucher.getVoucherNumber() + "\u5bf9\u5e94\u7684\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\u6240\u5e26\u6838\u7b97\u9879\u76ee\u7c7b\u578b:" + atype + "\u5728\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\uff01"));
                            assistSubFlag = true;
                            break;
                        }
                        if (asstActTypeInfo == null) continue;
                        arrayAsstActTypeInfo.add(asstActTypeInfo);
                        String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
                        DataBaseInfo dataInfo = GlWebServiceUtil.findAsstActObject(ctx, asstHGAttribute, anumber, aname, company.getCU().getId().toString(), company);
                        if (isAllMust && dataInfo == null) {
                            errList.put(wsVoucher.getVoucherNumber(), "2007");
                            logger.info((Object)("\u51ed\u8bc1\u53f7\uff1a" + wsVoucher.getVoucherNumber() + "\u5bf9\u5e94\u7684\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\u6240\u5e26\u6838\u7b97\u9879\u76ee\u7f16\u7801" + anumber + "\u5728\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\uff01"));
                            assistSubFlag = true;
                            break;
                        }
                        assistantHGInfo.put(asstHGAttribute, (Object)dataInfo);
                        if (dataInfo == null) continue;
                        if ("companyOrg".equals(asstHGAttribute)) {
                            ++inAttrCount;
                            continue;
                        }
                        if (!"customer".equals(asstHGAttribute) && !"provider".equals(asstHGAttribute)) continue;
                        if ("customer".equals(asstHGAttribute)) {
                            if (!(dataInfo instanceof CustomerInfo) || !((CustomerInfo)dataInfo).isIsInternalCompany()) continue;
                            ++inAttrCount;
                            continue;
                        }
                        if (!(dataInfo instanceof SupplierInfo) || !((SupplierInfo)dataInfo).isIsInternalCompany()) continue;
                        ++inAttrCount;
                    }
                    if (!assistSubFlag) {
                        if (inAttrCount == 0 && CashflowTypeEnum.IN.getAlias().equals(type) && cashOutAsst == 2) {
                            errList.put(wsVoucher.getVoucherNumber(), "2006");
                            String errorMsgStr = "\u51ed\u8bc1\u53f7\uff1a" + wsVoucher.getVoucherNumber() + "\u5bf9\u5e94\u7684\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\u5fc5\u987b\u81f3\u5c11\u5f55\u5165\u4e00\u4e2a\u516c\u53f8\u6216\u8005\u5185\u90e8\u5ba2\u5546\uff01";
                            logger.info((Object)errorMsgStr);
                        } else if (arrayAsstActTypeInfo.size() != 0 || !CashflowTypeEnum.OUT.getAlias().equals(type) || cashOutAsst == 0) {
                            AssistantHGInfo actualAssistantHGInfo = null;
                            try {
                                IAssistantHG igCtrl = AssistantHGFactory.getLocalInstance((Context)ctx);
                                actualAssistantHGInfo = igCtrl.getAssistantHG(assistantHGInfo, cashInfo.getAsstAccount().getId().toString(), arrayAsstActTypeInfo);
                                record.setAssGrp(actualAssistantHGInfo);
                            }
                            catch (Exception e) {
                                errList.put(wsVoucher.getVoucherNumber(), "2006");
                                logger.info((Object)("\u51ed\u8bc1\u53f7\uff1a" + wsVoucher.getVoucherNumber() + "\u5bf9\u5e94\u7684\u73b0\u91d1\u6d41\u91cf\u4e3b\u8868\u9879\u76ee\u6784\u5efa\u8f85\u52a9\u6a2a\u8868\u51fa\u9519\uff01"));
                            }
                        }
                    }
                }
            }
        }
        record.setType(this.getCashflowTypeEnum(ctx, type));
        recodImp.setRecord(record);
        return recodImp;
    }

    private void calcSupplementaryCoefficient(VoucherInfo voucher) {
        if (voucher.getCashflowRecords() == null) {
            return;
        }
        for (CashflowRecordInfo record : voucher.getCashflowRecords()) {
            if (record.getSupplementaryItem() != null && record.getEntry() != null && record.getOpposingAccountEntry() != null) {
                int sc;
                VoucherEntryInfo entry = record.getEntry();
                VoucherEntryInfo oppEntry = record.getOpposingAccountEntry();
                boolean isPnL = AccountProperty.SUNYI.equals((Object)oppEntry.getAccount().getAccountTypeID().getProperty());
                EntryDC entryDC = entry.getEntryDC();
                if (isPnL) {
                    sc = -1;
                    if (EntryDC.DEBIT.equals((Object)oppEntry.getEntryDC())) {
                        sc = 1;
                        if (EntryDC.DEBIT.equals((Object)entryDC)) {
                            sc = -1;
                        }
                    } else if (EntryDC.CREDIT.equals((Object)entryDC)) {
                        sc = 1;
                    }
                    record.setSupplementaryCoefficient(sc);
                    continue;
                }
                sc = -1;
                if (EntryDC.DEBIT.equals((Object)entryDC)) {
                    sc = 1;
                }
                record.setSupplementaryCoefficient(sc);
                continue;
            }
            record.setSupplementaryCoefficient(0);
        }
    }

    private String[] getCashAsstactArray(WSVoucherInfo wsVoucher, int type) {
        String[] asstact = new String[8];
        switch (type) {
            case 1: {
                asstact[0] = wsVoucher.getCashAsstActType1();
                asstact[1] = wsVoucher.getCashAsstActType2();
                asstact[2] = wsVoucher.getCashAsstActType3();
                asstact[3] = wsVoucher.getCashAsstActType4();
                asstact[4] = wsVoucher.getCashAsstActType5();
                asstact[5] = wsVoucher.getCashAsstActType6();
                asstact[6] = wsVoucher.getCashAsstActType7();
                asstact[7] = wsVoucher.getCashAsstActType8();
                break;
            }
            case 2: {
                asstact[0] = wsVoucher.getCashAsstActNumber1();
                asstact[1] = wsVoucher.getCashAsstActNumber2();
                asstact[2] = wsVoucher.getCashAsstActNumber3();
                asstact[3] = wsVoucher.getCashAsstActNumber4();
                asstact[4] = wsVoucher.getCashAsstActNumber5();
                asstact[5] = wsVoucher.getCashAsstActNumber6();
                asstact[6] = wsVoucher.getCashAsstActNumber7();
                asstact[7] = wsVoucher.getCashAsstActNumber8();
                break;
            }
            case 3: {
                asstact[0] = wsVoucher.getCashAsstActName1();
                asstact[1] = wsVoucher.getCashAsstActName2();
                asstact[2] = wsVoucher.getCashAsstActName3();
                asstact[3] = wsVoucher.getCashAsstActName4();
                asstact[4] = wsVoucher.getCashAsstActName5();
                asstact[5] = wsVoucher.getCashAsstActName6();
                asstact[6] = wsVoucher.getCashAsstActName7();
                asstact[7] = wsVoucher.getCashAsstActName8();
            }
        }
        return asstact;
    }

    protected CashflowTypeEnum getCashflowTypeEnum(Context ctx, String key) {
        if (CashflowTypeEnum.IN.getAlias(ctx.getLocale()).equals(key)) {
            return CashflowTypeEnum.IN;
        }
        if (CashflowTypeEnum.OUT.getAlias(ctx.getLocale()).equals(key)) {
            return CashflowTypeEnum.OUT;
        }
        return CashflowTypeEnum.NONE;
    }

    private VoucherInfo.ExchangeRateWithValue getExChangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo currencyInfo, PeriodInfo period, Date bookDate) throws BOSException {
        Object[] exs = null;
        try {
            exs = VoucherProcessCache.getCache(ctx).getExchangeRate(ctx, companyOrgUnitInfo, currencyInfo, period, bookDate);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        VoucherInfo.ExchangeRateWithValue rptchangeRate = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
        if (exs != null && (rptchangeRate = (VoucherInfo.ExchangeRateWithValue)exs[1]) == null) {
            rptchangeRate = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
        }
        return rptchangeRate;
    }

    @Override
    protected IObjectCollection _importVoucher(Context ctx, IObjectCollection voucherCols, boolean isTempSave, boolean isVerify, boolean hasCashflow) throws BOSException, EASBizException {
        int verify = 0;
        if (isTempSave && !isVerify) {
            verify = 0;
        } else if (isTempSave && isVerify) {
            verify = 1;
        } else if (!isTempSave && !isVerify) {
            verify = 2;
        } else if (!isTempSave && isVerify) {
            verify = 3;
        }
        String[][] result = this._importVoucher(ctx, voucherCols, verify, hasCashflow ? 1 : 0);
        WSRtnInfoCollection rtnCol = new WSRtnInfoCollection();
        if (result != null) {
            int count = result.length;
            for (int i = 0; i < count; ++i) {
                WSRtnInfoInfo wsRtnInfo = new WSRtnInfoInfo();
                wsRtnInfo.setNumber(result[i][0]);
                wsRtnInfo.setVoucherType(result[i][1]);
                wsRtnInfo.setYear(result[i][2]);
                wsRtnInfo.setPeriod(result[i][3]);
                wsRtnInfo.setMessage(result[i][4]);
                wsRtnInfo.setException(result[i][5]);
                wsRtnInfo.setEasNumber(result[i][6]);
                rtnCol.add(wsRtnInfo);
            }
        }
        return rtnCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map saveVoucher(Context ctx, String number, VoucherInfo voucherInfo, Map errList, Map voucherMap, LowTimer low, boolean isSubmit, boolean post, int sucCount, boolean checkImpRepeated, boolean useImportKey) throws BOSException, EASBizException {
        String importKey = (String)voucherInfo.get("importKey");
        if (checkImpRepeated && useImportKey && importKey != null && importKey.length() > 0) {
            return this.saveVoucher(ctx, number, voucherInfo, errList, voucherMap, low, isSubmit, post, sucCount);
        }
        if (!checkImpRepeated || StringUtils.isEmpty((String)voucherInfo.getDescription())) {
            return this.saveVoucher(ctx, number, voucherInfo, errList, voucherMap, low, isSubmit, post, sucCount);
        }
        String companyId = voucherInfo.getCompany().getId().toString();
        Object object = GlWebServiceUtil.getSynObj(companyId);
        synchronized (object) {
            String repnumber = this.checkImpRepeated(ctx, voucherInfo.getDescription(), companyId, voucherInfo.getVoucherType().getId().toString(), voucherInfo.getPeriod().getId().toString(), checkImpRepeated);
            if (repnumber != null) {
                WSVoucherCollection cols = new WSVoucherCollection();
                WSVoucherInfo wsVoucher = new WSVoucherInfo();
                wsVoucher.setVoucherNumber(number);
                wsVoucher.setDescription("3100");
                wsVoucher.setVoucherAbstract(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"935_WSVoucherControllerBean", (Locale)ctx.getLocale()) + repnumber);
                wsVoucher.setAccountNumber(repnumber);
                cols.addObject((IObjectValue)wsVoucher);
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("cols", (Object)cols);
                result.put("voucherMap", voucherMap);
                result.put("sucCount", sucCount + "");
                return result;
            }
            return this.saveVoucher(ctx, number, voucherInfo, errList, voucherMap, low, isSubmit, post, sucCount);
        }
    }

    protected Map saveVoucher(Context ctx, String number, VoucherInfo tmpVoucherInfo, Map errList, Map voucherMap, LowTimer low, boolean isSubmit, boolean post, int sucCount) throws BOSException, EASBizException {
        WSVoucherCollection cols = new WSVoucherCollection();
        if (!errList.containsKey(number)) {
            WSVoucherInfo wsVoucher = new WSVoucherInfo();
            wsVoucher.setVoucherNumber(number);
            try {
                HashMap<String, VoucherInfo> impList = new HashMap<String, VoucherInfo>();
                impList.put(number, tmpVoucherInfo);
                Map iResult = WSVoucherFactory.getLocalInstance(ctx).saveVoucher(impList, errList, voucherMap, low, isSubmit, post, sucCount);
                VoucherInfo voucherInfo = (VoucherInfo)iResult.get("voucherInfo");
                ++sucCount;
                if (tmpVoucherInfo.getDescription() != null) {
                    voucherMap.put(tmpVoucherInfo.getDescription(), voucherInfo.getNumber());
                }
                wsVoucher.setVoucherType(tmpVoucherInfo.getVoucherType().getName());
                wsVoucher.setPeriodYear(tmpVoucherInfo.getPeriod().getPeriodYear());
                wsVoucher.setPeriodNumber(tmpVoucherInfo.getPeriod().getPeriodNumber());
                wsVoucher.put("id", voucherInfo.getId().toString());
                wsVoucher.setDescription("0000");
                wsVoucher.setVoucherAbstract(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"967_WSVoucherControllerBean", (Locale)ctx.getLocale()));
                wsVoucher.setAccountNumber(voucherInfo.getNumber());
                cols.addObject((IObjectValue)wsVoucher);
                low.reset();
            }
            catch (Exception e) {
                if (e instanceof PermissionException) {
                    wsVoucher.setDescription("3001");
                } else if (e instanceof CodingRuleException) {
                    wsVoucher.setDescription("3002");
                } else if (e instanceof VoucherException) {
                    wsVoucher.setDescription("4" + ((VoucherException)((Object)e)).getSubCode());
                } else {
                    wsVoucher.setDescription("1111");
                }
                e.printStackTrace();
                logger.error((Object)"---------");
                if (tmpVoucherInfo.getCompany() != null) {
                    logger.error((Object)("\u7528\u6237:" + ctx.getUserName() + " \u7ec4\u7ec7:" + tmpVoucherInfo.getCompany().getName()));
                    logger.error((Object)("\u7528\u6237ID:" + ctx.getCaller() + " \u7ec4\u7ec7:" + tmpVoucherInfo.getCompany().getId()));
                    logger.error((Object)"---------");
                }
                logger.error((Object)e);
                wsVoucher.setVoucherAbstract(e.getMessage());
                cols.addObject((IObjectValue)wsVoucher);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("cols", (Object)cols);
        result.put("voucherMap", voucherMap);
        result.put("sucCount", sucCount + "");
        return result;
    }

    @Override
    protected Map _saveVoucher(Context ctx, Map impList, Map errList, Map voucherMap, LowTimer low, boolean isSubmit, boolean post, int sucCount) throws BOSException, EASBizException {
        IVoucher bean = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherInfo tmpVoucherInfo = (VoucherInfo)impList.values().iterator().next();
        String creatorid = tmpVoucherInfo.getCreator().getId().toString();
        this.checkCashflow(ctx, tmpVoucherInfo);
        IObjectPK pk = null;
        if (post) {
            tmpVoucherInfo.setBizStatus(VoucherStatusEnum.POSTED);
            pk = VoucherUtil._addnewVoucher(ctx, tmpVoucherInfo);
            IGLPeriodEndFacade iGLPeriodEndFacade = GLPeriodEndFacadeFactory.getLocalInstance(ctx);
            iGLPeriodEndFacade.postVoucherOnBook(tmpVoucherInfo.getCU().getId().toString(), tmpVoucherInfo.getCompany().getId().toString(), new String[]{pk.toString()}, true, 1, false);
            iGLPeriodEndFacade.postVoucherOnBook(tmpVoucherInfo.getCU().getId().toString(), tmpVoucherInfo.getCompany().getId().toString(), new String[]{pk.toString()}, true, 5, false);
        } else {
            tmpVoucherInfo.put("entrance", (Object)"WebService");
            pk = isSubmit ? bean.submit((CoreBaseInfo)tmpVoucherInfo) : bean.save((CoreBaseInfo)tmpVoucherInfo);
        }
        String sql = "update t_gl_voucher set fcreatorid=? where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{creatorid, pk.toString()});
        VoucherInfo voucherInfo = (VoucherInfo)bean.getValue(pk, this.getSelector());
        HashMap<String, VoucherInfo> result = new HashMap<String, VoucherInfo>();
        result.put("voucherInfo", voucherInfo);
        return result;
    }

    private void checkCashflow(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (CashflowFlag.FINISHED.equals((Object)voucherInfo.getCashflowFlag()) && voucherInfo.getCashflowRecords() != null) {
            VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
            boolean mustPI = true;
            boolean mustBoth = true;
            String cacheKey = voucherInfo.getCompany().getId().toString() + "ISubmitVoucherService";
            GlParam sysParam = cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam ? (GlParam)cache.getSysParams().get(cacheKey) : GlParam.getGlParams((Context)ctx, (String[])GlParam.getCommonParamKeyList(), (String)voucherInfo.getCompany().getId().toString());
            mustPI = sysParam.getInt("GL_014") != 2;
            mustBoth = sysParam.getBoolean("GL_015");
            CashflowFlag cfFlag = CashFlowUtils.computeCashflowFlag(voucherInfo);
            if (CashflowFlag.ONLY_PNLACCOUNT.equals((Object)cfFlag)) {
                mustBoth = true;
            }
            if (CashflowFlag.BOTH_CASH_AND_PNL.equals((Object)cfFlag)) {
                CashflowRecordCollection vchCashflowRecords = (CashflowRecordCollection)voucherInfo.getCashflowRecords();
                for (CashflowRecordInfo cfRecord : vchCashflowRecords) {
                    if (cfRecord.getItemFlag() == null || !ItemFlag.SUPPLEMENTARY.equals((Object)cfRecord.getItemFlag()) && !ItemFlag.BOTH.equals((Object)cfRecord.getItemFlag())) continue;
                    mustBoth = true;
                    break;
                }
            }
            SubmitVoucherServiceHelper.compareAmount(ctx, (CashflowRecordCollection)voucherInfo.getCashflowRecords(), voucherInfo.getEntries(), true, mustBoth, sysParam, voucherInfo);
        }
    }

    private void setOpposingAccountEntry(VoucherInfo tmpVoucherInfo) {
        tmpVoucherInfo.getCashflowRecords();
    }

    private void prepareCache(Context ctx, VoucherProcessCache cache, IObjectCollection voucherCols) throws EASBizException, BOSException {
        HashSet<String> comNumbers = new HashSet<String>();
        HashMap<String, HashSet<String>> accNumberss = new HashMap<String, HashSet<String>>();
        int count = voucherCols.size();
        for (int i = 0; i < count; ++i) {
            WSVoucherInfo wsVoucher = (WSVoucherInfo)voucherCols.getObject(i);
            String comNumber = wsVoucher.getCompanyNumber();
            if (comNumber == null || comNumber.trim().length() == 0) continue;
            comNumber = comNumber.trim();
            comNumbers.add(comNumber);
            String accNumber = wsVoucher.getAccountNumber();
            if (accNumber == null || accNumber.trim().length() <= 0) continue;
            HashSet<String> accNumbers = (HashSet<String>)accNumberss.get(comNumber);
            if (accNumbers == null) {
                accNumbers = new HashSet<String>();
                accNumberss.put(comNumber, accNumbers);
            }
            accNumbers.add(accNumber.trim());
        }
        HashSet<String> params = new HashSet<String>();
        params.add("GL_016");
        params.add("GL_052");
        params.add("GL_031");
        params.add("GL_111");
        params.add("GL_0155");
        cache.cacheCompanys(ctx, comNumbers);
        for (String comNumber : comNumbers) {
            CompanyOrgUnitInfo company = cache.getCompanyByNumber(ctx, comNumber);
            if (company == null) continue;
            cache.cacheParams(ctx, company.getId().toString(), params);
            Set accNumbers = (Set)accNumberss.get(comNumber);
            if (accNumbers == null || accNumbers.size() <= 0) continue;
            cache.cacheAccounts(ctx, company, accNumbers);
        }
    }

    @Override
    protected String _nImportVoucher(Context ctx, String rows, String params) throws BOSException, EASBizException {
        return this._nImportVoucher(ctx, rows, params, true);
    }

    @Override
    protected String _nImportVoucher(Context ctx, String rows, String params, boolean isInterfaceInvoke) throws BOSException, EASBizException {
        try {
            VoucherImportService service;
            long start = System.currentTimeMillis();
            Map map = (Map)JSON.parseObject((String)params, Map.class);
            map.put("isInterfaceInvoke", isInterfaceInvoke);
            boolean isCompress = "true".equals(map.get("isCompress") == null ? "false" : map.get("isCompress").toString());
            if (isCompress) {
                rows = ZipUtils.gunzip(rows);
            }
            List list = (List)JSON.parseObject((String)rows, List.class);
            long prepareTime = System.currentTimeMillis() - start;
            String extend = (String)map.get("extend");
            if (extend != null && extend.trim().length() > 0) {
                if ((extend = extend.trim()).equals("true")) {
                    extend = "com.kingdee.eas.fi.gl.app.VoucherImportServiceEx";
                }
                try {
                    Class<?> clazz = Class.forName(extend);
                    service = (VoucherImportService)clazz.newInstance();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            } else {
                service = new VoucherImportService();
            }
            Map result = service.importVoucher(ctx, list, map);
            result.put("prepareTime", prepareTime);
            long current = System.currentTimeMillis();
            result.put("analysisTime", current - start - prepareTime - (Long)result.get("saveTime"));
            result.put("totalTime", current - start);
            if (isCompress) {
                return ZipUtils.gzip(JSON.toJSONString((Object)result));
            }
            return JSON.toJSONString((Object)result);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _nSaveVoucher(Context ctx, IObjectValue voucher, Map params) throws BOSException, EASBizException {
        VoucherInfo tmp = (VoucherInfo)voucher;
        boolean isSubmit = "true".equals(params.get("isSubmit") == null ? "false" : params.get("isSubmit").toString());
        UserInfo auditor = tmp.getAuditor();
        UserInfo poster = tmp.getPoster();
        boolean isCheck = tmp.isIsCheck();
        UserInfo cashier = tmp.getCashier();
        tmp.setAuditor(null);
        tmp.setPoster(null);
        tmp.setIsCheck(false);
        tmp.setCashier(null);
        boolean isCheckBizPerm = (Boolean)params.get("isCheckBizPerm");
        boolean isAdvanceMode = (Boolean)params.get("isAdvanceMode");
        Context newCtx = new Context(ctx.getCaller(), ctx.getSolution(), ctx.getAIS(), ctx.getLocale());
        newCtx.setReadAIS(ctx.getReadAIS());
        newCtx.setClientHostIP(ctx.getClientHostIP());
        newCtx.setClientHostName(ctx.getClientHostName());
        newCtx.setUserName(ctx.getUserName());
        ContextUtil.setCurrentUserInfo((Context)newCtx, (UserInfo)ContextUtil.getCurrentUserInfo((Context)ctx));
        ContextUtil.setCurrentFIUnit((Context)newCtx, (CompanyOrgUnitInfo)tmp.getCompany());
        if (tmp.getCompany().getCU() != null) {
            ContextUtil.setCurrentCtrlUnit((Context)newCtx, (CtrlUnitInfo)tmp.getCompany().getCU());
        }
        IObjectPK pk = null;
        voucher.put("entrance", (Object)"WebService");
        if (isAdvanceMode) {
            newCtx.setCaller((IObjectPK)new ObjectUuidPK(tmp.getCreator().getId()));
            ContextUtil.setCurrentUserInfo((Context)newCtx, (UserInfo)tmp.getCreator());
        }
        if (isSubmit) {
            pk = VoucherFactory.getLocalInstance((Context)newCtx).submit((CoreBaseInfo)tmp);
        } else {
            if (isCheckBizPerm) {
                ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            }
            pk = VoucherFactory.getLocalInstance((Context)newCtx).save((CoreBaseInfo)tmp);
        }
        Object useWorkflow = VoucherProcessCache.getParam(ctx, tmp.getCompany().getId().toString(), "GL_032");
        boolean isUseWorkflow = Boolean.valueOf(useWorkflow.toString());
        if (isUseWorkflow && (useWorkflow = params.get("isUseWorkflow")) != null && useWorkflow.toString().trim().length() > 0 && "false".equalsIgnoreCase(useWorkflow.toString().trim())) {
            isUseWorkflow = false;
        }
        if (!isUseWorkflow && isSubmit) {
            boolean existsCashOrBankAccount = false;
            Iterator it = tmp.getEntries().iterator();
            while (it.hasNext()) {
                AccountViewInfo account = ((VoucherEntryInfo)it.next()).getAccount();
                if (account == null || !account.isIsCash() && !account.isIsBank()) continue;
                existsCashOrBankAccount = true;
                break;
            }
            int iCheckAFAudit = 0;
            Object checkAFAudit = VoucherProcessCache.getParam(ctx, tmp.getCompany().getId().toString(), "GL_047");
            if (checkAFAudit != null) {
                iCheckAFAudit = Integer.parseInt(checkAFAudit.toString());
            }
            boolean check = false;
            if (isCheck && cashier != null && existsCashOrBankAccount && iCheckAFAudit == 1) {
                if (isAdvanceMode) {
                    newCtx.setCaller((IObjectPK)new ObjectUuidPK(cashier.getId()));
                    ContextUtil.setCurrentUserInfo((Context)newCtx, (UserInfo)cashier);
                }
                if (isCheckBizPerm) {
                    ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                }
                VoucherFactory.getLocalInstance((Context)newCtx).checkVoucher(pk.toString());
                check = true;
            }
            boolean isAudit = "true".equals(params.get("isAudit") == null ? "false" : params.get("isAudit").toString());
            if (auditor == null) {
                isAudit = false;
            }
            if (isAudit) {
                if (!existsCashOrBankAccount || iCheckAFAudit != 1 || check) {
                    if (isAdvanceMode) {
                        newCtx.setCaller((IObjectPK)new ObjectUuidPK(auditor.getId()));
                        ContextUtil.setCurrentUserInfo((Context)newCtx, (UserInfo)auditor);
                    }
                    if (isCheckBizPerm) {
                        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                    }
                    VoucherFactory.getLocalInstance((Context)newCtx).auditVoucher(pk, auditor.getId());
                } else {
                    isAudit = false;
                }
            }
            if (isCheck && cashier != null && existsCashOrBankAccount && !check && (iCheckAFAudit != 2 || isAudit)) {
                if (isAdvanceMode) {
                    newCtx.setCaller((IObjectPK)new ObjectUuidPK(cashier.getId()));
                    ContextUtil.setCurrentUserInfo((Context)newCtx, (UserInfo)cashier);
                }
                if (isCheckBizPerm) {
                    ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                }
                VoucherFactory.getLocalInstance((Context)newCtx).checkVoucher(pk.toString());
                check = true;
            }
            boolean isPost = "true".equals(params.get("isPost") == null ? "false" : params.get("isPost").toString());
            if (poster == null) {
                isPost = false;
            }
            if (isAudit && isPost) {
                boolean isCheckBFPost = false;
                Object checkBFPost = VoucherProcessCache.getParam(ctx, tmp.getCompany().getId().toString(), "GL_046");
                if (checkBFPost != null) {
                    isCheckBFPost = Boolean.valueOf(checkBFPost.toString());
                }
                if (!existsCashOrBankAccount || !isCheckBFPost || check) {
                    if (isAdvanceMode) {
                        newCtx.setCaller((IObjectPK)new ObjectUuidPK(poster.getId()));
                        ContextUtil.setCurrentUserInfo((Context)newCtx, (UserInfo)poster);
                    }
                    if (isCheckBizPerm) {
                        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                    }
                    VoucherFactory.getLocalInstance((Context)newCtx).post(pk, null);
                }
            }
        }
        HashMap<String, CoreBaseInfo> result = new HashMap<String, CoreBaseInfo>();
        if (isAdvanceMode) {
            newCtx.setCaller((IObjectPK)new ObjectUuidPK(tmp.getCreator().getId()));
            ContextUtil.setCurrentUserInfo((Context)newCtx, (UserInfo)tmp.getCreator());
        }
        result.put("voucher", VoucherFactory.getLocalInstance((Context)newCtx).getValue(pk, this.getSelector()));
        return result;
    }

    @Override
    protected String _nExportVoucher(Context ctx, String params) throws BOSException, EASBizException {
        return this._nExportVoucher(ctx, params, true);
    }

    @Override
    protected String _nExportVoucher(Context ctx, String params, boolean isInterfaceInvoke) throws BOSException, EASBizException {
        try {
            long start = System.currentTimeMillis();
            Map map = (Map)JSON.parseObject((String)params, Map.class);
            map.put("isInterfaceInvoke", isInterfaceInvoke);
            boolean isCompress = "true".equals(map.get("isCompress") == null ? "false" : map.get("isCompress").toString());
            VoucherExportService service = new VoucherExportService();
            Map result = service.exportVoucher(ctx, map);
            result.put("totalTime", System.currentTimeMillis() - start);
            String str = JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteSlashAsSpecial});
            if (isCompress) {
                str = ZipUtils.gzip(str);
            }
            return str;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _nOperateVoucher(Context ctx, String params) throws BOSException, EASBizException {
        return this._nOperateVoucher(ctx, params, true);
    }

    @Override
    protected String _nOperateVoucher(Context ctx, String params, boolean isInterfaceInvoke) throws BOSException, EASBizException {
        VoucherOperateService service;
        long start = System.currentTimeMillis();
        Map map = (Map)JSON.parseObject((String)params, Map.class);
        map.put("isInterfaceInvoke", isInterfaceInvoke);
        String extend = (String)map.get("extend");
        if (extend != null && extend.trim().length() > 0) {
            if ((extend = extend.trim()).equals("true")) {
                extend = "com.kingdee.eas.fi.gl.app.VoucherOperateServiceEx";
            }
            try {
                Class<?> clazz = Class.forName(extend);
                service = (VoucherOperateService)clazz.newInstance();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        } else {
            service = new VoucherOperateService();
        }
        Map result = service.operateVoucher(ctx, map);
        result.put("totalTime", System.currentTimeMillis() - start);
        return JSON.toJSONString((Object)result);
    }

    @Override
    protected String _nGetBalance(Context ctx, String params) throws BOSException, EASBizException {
        return this._nGetBalance(ctx, params, true);
    }

    @Override
    protected String _nGetBalance(Context ctx, String params, boolean isInterfaceInvoke) throws BOSException, EASBizException {
        try {
            long start = System.currentTimeMillis();
            Map map = (Map)JSON.parseObject((String)params, Map.class);
            map.put("isInterfaceInvoke", isInterfaceInvoke);
            boolean isCompress = "true".equals(map.get("isCompress") == null ? "false" : map.get("isCompress").toString());
            Map result = GLNRptBaseService.getService(ctx, map).executeQuery();
            result.put("totalTime", System.currentTimeMillis() - start);
            if (isCompress) {
                return ZipUtils.gzip(JSON.toJSONString((Object)result));
            }
            return JSON.toJSONString((Object)result);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _nGetAsstActTypes(Context ctx, String params) throws BOSException, EASBizException {
        return this._nGetAsstActTypes(ctx, params, true);
    }

    @Override
    protected String _nGetAsstActTypes(Context ctx, String params, boolean isInterfaceInvoke) throws BOSException, EASBizException {
        try {
            long start = System.currentTimeMillis();
            Map map = (Map)JSON.parseObject((String)params, Map.class);
            map.put("isInterfaceInvoke", isInterfaceInvoke);
            boolean isCompress = "true".equals(map.get("isCompress") == null ? "false" : map.get("isCompress").toString());
            GetAsstActTypeService service = new GetAsstActTypeService();
            Map result = service.getAsstActTypes(ctx, map);
            result.put("totalTime", System.currentTimeMillis() - start);
            String str = JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteSlashAsSpecial});
            if (isCompress) {
                return ZipUtils.gzip(str);
            }
            return str;
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _nGetAsstActs(Context ctx, String params) throws BOSException, EASBizException {
        return this._nGetAsstActs(ctx, params, true);
    }

    @Override
    protected String _nGetAsstActs(Context ctx, String params, boolean isInterfaceInvoke) throws BOSException, EASBizException {
        try {
            long start = System.currentTimeMillis();
            Map map = (Map)JSON.parseObject((String)params, Map.class);
            map.put("isInterfaceInvoke", isInterfaceInvoke);
            boolean isCompress = "true".equals(map.get("isCompress") == null ? "false" : map.get("isCompress").toString());
            GetAsstActService service = new GetAsstActService();
            Map result = service.getAsstActs(ctx, map);
            result.put("totalTime", System.currentTimeMillis() - start);
            String str = JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteSlashAsSpecial});
            if (isCompress) {
                return ZipUtils.gzip(str);
            }
            return str;
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _nGetAccounts(Context ctx, String params) throws BOSException, EASBizException {
        return this._nGetAccounts(ctx, params, true);
    }

    @Override
    protected String _nGetAccounts(Context ctx, String params, boolean isInterfaceInvoke) throws BOSException, EASBizException {
        try {
            long start = System.currentTimeMillis();
            Map map = (Map)JSON.parseObject((String)params, Map.class);
            map.put("isInterfaceInvoke", isInterfaceInvoke);
            boolean isCompress = "true".equals(map.get("isCompress") == null ? "false" : map.get("isCompress").toString());
            GetAccountService service = new GetAccountService();
            Map result = service.getAccounts(ctx, map);
            result.put("totalTime", System.currentTimeMillis() - start);
            String str = JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteSlashAsSpecial});
            if (isCompress) {
                return ZipUtils.gzip(str);
            }
            return str;
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)resName, (Locale)ctx.getLocale());
    }
}

