/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherInfo;
import com.kingdee.eas.fi.gl.UserSettingFactory;
import com.kingdee.eas.fi.gl.UserSettingObject;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.ServerUtils;
import com.kingdee.eas.fi.gl.app.WebTemplateVoucherTransfer;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WebTemplateVoucherCreator {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.WebVoucherCreator");

    public TemplateVoucherInfo create(Context ctx, String companyId) throws BOSException, EASBizException {
        TemplateVoucherInfo voucherInfo = new TemplateVoucherInfo();
        CompanyOrgUnitInfo comapny = ServerUtils.getDefaultCompany(ctx, companyId, "gl_templatevoucher_addnew");
        voucherInfo.setCompany(comapny);
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        voucherInfo.setCreator(curUser);
        voucherInfo.setHandler(curUser);
        voucherInfo.setAttachments(0);
        voucherInfo.setCashflowFetched(true);
        voucherInfo.setCashflowFlag(CashflowFlag.NONE);
        TemplateVoucherInfo webVoucherInfo = new WebTemplateVoucherTransfer(ctx, voucherInfo).transfer();
        return webVoucherInfo;
    }

    private CompanyOrgUnitInfo getCompany(Context ctx, String companyId) throws BOSException, EASBizException, GLException {
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        CompanyOrgUnitInfo company = null;
        if (StringUtils.isEmpty((String)companyId)) {
            company = GLGeneralFacadeFactory.getLocalInstance(ctx).getFirstCompany("gl_templatevoucher_addnew");
            if (company == null) {
                String addNewVoucher = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"addNewTemplateVoucher", (Locale)ctx.getLocale());
                throw new GLException(GLException.NO_PERMISSON, new String[]{addNewVoucher});
            }
        } else {
            String[] companyIds = companyId.split(",");
            if (PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(companyIds[0]), "gl_templatevoucher_addnew")) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("isBizUnit"));
                sic.add(new SelectorItemInfo("CU.id"));
                sic.add(new SelectorItemInfo("isBizUnit"));
                sic.add(new SelectorItemInfo("accountPeriodType.id"));
                sic.add(new SelectorItemInfo("baseCurrency.id"));
                sic.add(new SelectorItemInfo("reportCurrency.id"));
                sic.add(new SelectorItemInfo("baseExchangeTable.id"));
                sic.add(new SelectorItemInfo("reportExchangeTable.id"));
                sic.add(new SelectorItemInfo("reportConvertMode"));
                sic.add(new SelectorItemInfo("accountTable.id"));
                sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyIds[0]), sic);
            } else {
                if (companyIds.length > 1) {
                    StringBuffer filterSql = new StringBuffer();
                    for (int i = 0; i < companyIds.length; ++i) {
                        if (StringUtils.isEmpty((String)companyIds[i])) continue;
                        if (filterSql.length() > 0) {
                            filterSql.append(",");
                        }
                        filterSql.append("'").append(companyIds[i]).append("'");
                    }
                    company = GLGeneralFacadeFactory.getLocalInstance(ctx).getFirstCompany("gl_templatevoucher_addnew", " and cp.fid in (" + filterSql.toString() + ")");
                }
                if (company == null && (company = GLGeneralFacadeFactory.getLocalInstance(ctx).getFirstCompany("gl_templatevoucher_addnew")) == null) {
                    String addNewVoucher = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"addNewTemplateVoucher", (Locale)ctx.getLocale());
                    throw new GLException(GLException.NO_PERMISSON, new String[]{addNewVoucher});
                }
            }
        }
        return company;
    }

    public TemplateVoucherInfo copy(Context ctx, TemplateVoucherInfo voucherInfo) throws EASBizException, BOSException {
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (!PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(voucherInfo.getCompany().getId()), "gl_templatevoucher_addnew")) {
            String addNewVoucher = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"addNewTemplateVoucher", (Locale)ctx.getLocale());
            throw new GLException(GLException.NO_PERMISSON, new String[]{addNewVoucher});
        }
        voucherInfo.setId(null);
        voucherInfo.setNumber(null);
        voucherInfo.setCreator(curUser);
        voucherInfo.setHandler(curUser);
        voucherInfo.setAuditor(null);
        voucherInfo.setAttachments(0);
        voucherInfo.setCashflowFetched(true);
        voucherInfo.setCashflowFlag(CashflowFlag.NONE);
        voucherInfo.setSourceBillId(null);
        this.setNumberAddNew(ctx, voucherInfo);
        Iterator it = voucherInfo.getEntries().iterator();
        int index = 1;
        while (it.hasNext()) {
            TemplateVoucherEntryInfo entry = (TemplateVoucherEntryInfo)it.next();
            entry.put("entryid", null);
            entry.put("assistrecordid", null);
            entry.put("entry_assistrecord_id", (Object)index++);
            entry.setOprStatus(1);
            AccountViewInfo account = entry.getAccount();
            if (account == null || account.getCAA() == null && !account.isHasUserProperty()) continue;
            account.put("asstbizdate", (Object)voucherInfo.getBizDate());
        }
        return voucherInfo;
    }

    private void setPeriod(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = voucherInfo.getCompany();
        String companyId = company.getId().toString();
        PeriodInfo period = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(6, companyId);
        UserSettingObject settingObj = UserSettingFactory.getLocalInstance(ctx).getValue(null, "fi.gl.voucher.editSetting");
        Date date = DateTimeUtils.truncateDate((Date)new Date());
        if (settingObj != null && settingObj.getBoolean("sysData") && (period == null || date.after(period.getEndDate()))) {
            PeriodCollection periodColl = PeriodUtils.getPeriodCollection((Context)ctx, (Date)date, (Date)date, (CompanyOrgUnitInfo)company);
            if (!periodColl.isEmpty()) {
                period = periodColl.get(0);
            }
        } else {
            if (period != null) {
                if (date.before(period.getBeginDate())) {
                    date = period.getBeginDate();
                } else if (date.after(period.getEndDate())) {
                    date = period.getEndDate();
                }
            }
            date = DateTimeUtils.truncateDate((Date)date);
        }
        voucherInfo.setBizDate(date);
        voucherInfo.setBookedDate(date);
        voucherInfo.setPeriod(period);
    }

    private void setNumberAddNew(Context ctx, TemplateVoucherInfo voucherInfo) throws EASBizException, BOSException {
        try {
            boolean isAddShow;
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString());
            if (null != ruleInfo && (isAddShow = ruleInfo.isIsAddView())) {
                String number = iCodingRuleManager.getNumber((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "");
                voucherInfo.setNumber(number);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List getCurrencyComboList(Context ctx) throws EASBizException, BOSException {
        CurrencyCollection currencyColl = this.getCurrencyCollection(ctx);
        ArrayList currencyComboList = new ArrayList();
        for (int i = 0; i < currencyColl.size(); ++i) {
            CurrencyInfo currency = currencyColl.get(i);
            HashMap<String, Object> currencyMap = new HashMap<String, Object>();
            currencyMap.put("value", currency.getId().toString());
            currencyMap.put("alias", currency.getName());
            currencyMap.put("precision", currency.getPrecision());
            currencyMap.put("invalid", currency.getDeletedStatus() == DeletedStatusEnum.DELETED);
            currencyComboList.add(currencyMap);
        }
        return currencyComboList;
    }

    private CurrencyCollection getCurrencyCollection(Context ctx) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("precision"));
        view.getSelector().add(new SelectorItemInfo("deletedStatus"));
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view, true);
    }
}

