/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.ExchangeTypeEnum;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ReportCurrencyConvertMode;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AssistCustomizedDataTypeEnum;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.TemplateVoucherAsstRecordCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherAsstRecordFactory;
import com.kingdee.eas.fi.gl.TemplateVoucherAsstRecordInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WebTemplateVoucherTransfer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.WebVoucherTransfer");
    private Context ctx;
    private TemplateVoucherInfo voucherInfo;
    private Map exchangeRateCache = new HashMap();

    public WebTemplateVoucherTransfer(Context ctx, TemplateVoucherInfo voucherInfo) {
        this.ctx = ctx;
        this.voucherInfo = voucherInfo;
    }

    public TemplateVoucherInfo transfer() throws EASBizException, BOSException {
        int i;
        Map paramMap = this.getSysParam(this.ctx);
        CompanyOrgUnitInfo company = this.voucherInfo.getCompany();
        company.put("sysparam", (Object)paramMap);
        this.voucherInfo.put("currencies", (Object)this.getCurrencyComboList());
        List<Map> voucherTypeList = this.getVoucherTypeList(company);
        this.voucherInfo.put("vouchertypeenum", voucherTypeList);
        if (this.voucherInfo.get("vouchertypeid") == null) {
            VoucherTypeInfo vt = this.voucherInfo.getVoucherType();
            if (vt != null) {
                this.voucherInfo.put("vouchertypeid", (Object)vt.getId().toString());
            } else {
                VoucherTypeInfo voucherTypeInfo = this.getDefaultVoucherTypeInfo(voucherTypeList);
                this.voucherInfo.setVoucherType(voucherTypeInfo);
                if (voucherTypeInfo != null) {
                    this.voucherInfo.put("vouchertypeid", (Object)voucherTypeInfo.getId().toString());
                }
            }
        }
        TemplateVoucherEntryCollection entryColl = this.voucherInfo.getEntries();
        TemplateVoucherEntryCollection newEntryColl = new TemplateVoucherEntryCollection();
        boolean isAsstQty = Boolean.TRUE.equals(paramMap.get("G010"));
        for (i = 0; i < entryColl.size(); ++i) {
            this.toWebVoucherEntryInfo(this.ctx, this.voucherInfo, entryColl.get(i), newEntryColl, isAsstQty);
        }
        this.voucherInfo.put("exchangerate", (Object)this.exchangeRateCache);
        this.voucherInfo.getEntries().clear();
        if (newEntryColl.size() < 6) {
            int j = 6 - newEntryColl.size();
            for (i = 0; i < j; ++i) {
                newEntryColl.add(new TemplateVoucherEntryInfo());
            }
        }
        this.voucherInfo.getEntries().addCollection(newEntryColl);
        return this.voucherInfo;
    }

    private void toWebVoucherEntryInfo(Context ctx, TemplateVoucherInfo voucherInfo, TemplateVoucherEntryInfo entryInfo, TemplateVoucherEntryCollection newEntryColl, boolean isAsstQty) throws EASBizException, BOSException {
        if (entryInfo.getCurrency() == null) {
            entryInfo.setCurrency(voucherInfo.getCompany().getBaseCurrency());
        }
        this.setExchangeRate(ctx, voucherInfo, entryInfo);
        entryInfo.setLocalExchangeRate(BigDecimal.ONE);
        entryInfo.setReportingExchangeRate(BigDecimal.ONE);
        String entryId = entryInfo.getId().toString();
        entryInfo.setId(null);
        entryInfo.put("entryid", (Object)entryId);
        TemplateVoucherAsstRecordCollection assistRecords = entryInfo.getAssistRecords();
        if (entryInfo.getAccount() != null && entryInfo.getAccount().getCAA() != null && assistRecords != null && !assistRecords.isEmpty()) {
            for (int j = 0; j < assistRecords.size(); ++j) {
                TemplateVoucherAsstRecordInfo record = assistRecords.get(j);
                TemplateVoucherEntryInfo entry = (TemplateVoucherEntryInfo)entryInfo.clone();
                String voucherassistrecordId = record.getId().toString();
                entry.put("entry_assistrecord_id", (Object)(entryId + voucherassistrecordId));
                entry.put("assistrecordid", (Object)voucherassistrecordId);
                AccountViewInfo account = entry.getAccount();
                AssistantHGInfo hgInfo = record.getAssGrp();
                if (hgInfo != null) {
                    String displayNameGroup = hgInfo.getDisplayNameGroup();
                    String[] displayNames = displayNameGroup.split(";");
                    StringBuffer displayName = new StringBuffer();
                    for (int n = 0; n < displayNames.length; ++n) {
                        String[] name = displayNames[n].split(":", 2);
                        if (name.length < 2 || StringUtils.isEmpty((String)name[1]) || "null".equals(name[1])) continue;
                        if (displayName.length() > 0) {
                            displayName.append("|");
                        }
                        if (name[1].indexOf("_!") != 0) {
                            displayName.append(name[1].split("_!")[1].trim());
                            continue;
                        }
                        displayName.append(name[1].trim());
                    }
                    hgInfo.put("displayname", (Object)displayName.toString());
                    String nameGroup = hgInfo.getLongNameGroup();
                    String[] names = nameGroup.split(";");
                    StringBuffer name = new StringBuffer();
                    for (int n = 0; n < names.length; ++n) {
                        String[] nm = names[n].split(":", 2);
                        if (nm.length < 2 || StringUtils.isEmpty((String)nm[1]) || "null".equals(nm[1])) continue;
                        if (name.length() > 0) {
                            name.append("|");
                        }
                        name.append(nm[1].trim());
                    }
                    hgInfo.put("name", (Object)name.toString());
                    account.put("assgrp", (Object)hgInfo);
                }
                if (account != null && account.isHasUserProperty()) {
                    AssistCustomizedPropertyCollection props = this.getAccountCustProp(ctx, account.getId().toString());
                    SelectorItemCollection selector = new SelectorItemCollection();
                    for (int k = 0; k < props.size(); ++k) {
                        AssistCustomizedPropertyInfo propInfo = props.get(k);
                        String propName = propInfo.getCustomizedType().getMappingPropName();
                        if (propInfo.getCustomizedType().getDataType() == AssistCustomizedDataTypeEnum.BUSINESSOBJECT) {
                            selector.add(new SelectorItemInfo(propName + ".id"));
                            selector.add(new SelectorItemInfo(propName + ".name"));
                            selector.add(new SelectorItemInfo(propName + ".number"));
                            continue;
                        }
                        selector.add(new SelectorItemInfo(propName));
                    }
                    TemplateVoucherAsstRecordInfo custVchRecrd = (TemplateVoucherAsstRecordInfo)TemplateVoucherAsstRecordFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(voucherassistrecordId), selector);
                    ArrayList<AssistCustomizedPropertyInfo> propList = new ArrayList<AssistCustomizedPropertyInfo>();
                    for (int k = 0; k < props.size(); ++k) {
                        AssistCustomizedPropertyInfo propInfo = props.get(k);
                        String propName = propInfo.getCustomizedType().getMappingPropName();
                        propInfo.put("value", custVchRecrd.get(propName));
                        propList.add(propInfo);
                    }
                    account.put("accountcustprop", propList);
                }
                entry.setDescription(record.getDescription());
                entry.setOriginalAmount(record.getOriginalAmount());
                entry.setLocalAmount(record.getLocalAmount());
                entry.setReportingAmount(record.getReportingAmount());
                entry.setQuantity(record.getQuantity());
                entry.setPrice(record.getPrice());
                if (isAsstQty) {
                    entry.setMeasureUnit(record.getMeasureUnitID());
                }
                this.setOrginal(entry);
                entry.getAssistRecords().clear();
                this.separateDebitCredit(entry);
                newEntryColl.add(entry);
            }
        } else {
            entryInfo.put("entry_assistrecord_id", (Object)entryId);
            this.setOrginal(entryInfo);
            this.separateDebitCredit(entryInfo);
            newEntryColl.add(entryInfo);
        }
    }

    private List getCurrencyComboList() throws EASBizException, BOSException {
        CurrencyCollection currencyColl = this.getCurrencyCollection();
        ArrayList currencyComboList = new ArrayList();
        for (int i = 0; i < currencyColl.size(); ++i) {
            CurrencyInfo currency = currencyColl.get(i);
            HashMap<String, Object> currencyMap = new HashMap<String, Object>();
            currencyMap.put("value", currency.getId().toString());
            currencyMap.put("alias", currency.getName());
            currencyMap.put("precision", currency.getPrecision());
            currencyMap.put("invalid", currency.getDeletedStatus() == DeletedStatusEnum.DELETED);
            currencyComboList.add(currencyMap);
        }
        return currencyComboList;
    }

    private CurrencyCollection getCurrencyCollection() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("precision"));
        view.getSelector().add(new SelectorItemInfo("deletedStatus"));
        return CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyCollection(view, true);
    }

    private List<Map> getVoucherTypeList(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        ArrayList<Map> voucherTypeList = new ArrayList<Map>();
        VoucherTypeCollection voucherTypes = VoucherTypeFactory.getLocalInstance((Context)this.ctx).getVoucherTypes(company.getCU().getId().toString());
        for (int i = 0; i < voucherTypes.size(); ++i) {
            VoucherTypeInfo voucherTypeInfo = voucherTypes.get(i);
            HashMap<String, Object> vt = new HashMap<String, Object>();
            vt.put("value", voucherTypeInfo.getId().toString());
            vt.put("alias", voucherTypeInfo.getName());
            vt.put("isDefault", voucherTypeInfo.isPretermit());
            vt.put("level", voucherTypeInfo.getLevel());
            voucherTypeList.add(vt);
        }
        return voucherTypeList;
    }

    private VoucherTypeInfo getDefaultVoucherTypeInfo(List<Map> voucherTypeList) throws BOSException, EASBizException {
        Iterator<Map> it = voucherTypeList.iterator();
        Map defaultVoucherType = null;
        Map topLevelDefVType = null;
        while (it.hasNext()) {
            Map vt = it.next();
            if (topLevelDefVType == null || vt.get("level") != null && (Integer)vt.get("level") < (Integer)topLevelDefVType.get("level")) {
                topLevelDefVType = vt;
            }
            if (!Boolean.TRUE.equals(vt.get("isDefault"))) continue;
            defaultVoucherType = vt;
            break;
        }
        if (defaultVoucherType == null) {
            if (topLevelDefVType != null) {
                defaultVoucherType = topLevelDefVType;
            } else if (!voucherTypeList.isEmpty()) {
                defaultVoucherType = voucherTypeList.get(0);
            }
        }
        if (defaultVoucherType != null) {
            VoucherTypeInfo voucherTypeInfo = new VoucherTypeInfo();
            voucherTypeInfo.setId(BOSUuid.read((String)((String)defaultVoucherType.get("value"))));
            voucherTypeInfo.setName((String)defaultVoucherType.get("alias"));
            return voucherTypeInfo;
        }
        return null;
    }

    protected static List getPeriodListByDate(Context ctx, String periodTypeId, Date bookedDate) throws BOSException {
        ArrayList listSource = new ArrayList();
        PeriodTypeInfo periodType = new PeriodTypeInfo();
        periodType.setId(BOSUuid.read((String)periodTypeId));
        PeriodCollection periodColl = WebTemplateVoucherTransfer.getPeriodCollection(ctx, periodTypeId, bookedDate);
        if (periodColl != null) {
            for (int i = 0; i < periodColl.size(); ++i) {
                PeriodInfo period = periodColl.get(i);
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("alias", period.toString());
                item.put("value", WebTemplateVoucherTransfer.toPeriodString(period));
                listSource.add(item);
            }
        }
        return listSource;
    }

    protected static String toPeriodString(PeriodInfo period) {
        StringBuffer periodStr = new StringBuffer();
        periodStr.append(period.getId());
        periodStr.append(";").append(period.getNumber());
        periodStr.append(";").append(period.isIsAdjustPeriod());
        return periodStr.toString();
    }

    private static PeriodCollection getPeriodCollection(Context ctx, String periodTypeId, Date date) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodTypeId, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        return PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
    }

    private void separateDebitCredit(TemplateVoucherEntryInfo entryInfo) {
        if (entryInfo.getEntryDC() == EntryDC.CREDIT) {
            entryInfo.put("localDebitAmount", null);
            entryInfo.put("rptDebitAmount", null);
            entryInfo.put("localCreditAmount", (Object)entryInfo.getLocalAmount());
            entryInfo.put("rptCreditAmount", (Object)entryInfo.getReportingAmount());
        } else {
            entryInfo.put("localDebitAmount", (Object)entryInfo.getLocalAmount());
            entryInfo.put("rptDebitAmount", (Object)entryInfo.getReportingAmount());
            entryInfo.remove("localCreditAmount");
            entryInfo.remove("rptCreditAmount");
        }
        entryInfo.remove("entryDC");
        entryInfo.remove("localAmount");
        entryInfo.remove("reportingAmount");
    }

    private Map getSysParam(Context ctx) throws GLException, EASBizException, BOSException {
        String companyId = this.voucherInfo.getCompany().getId().toString();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String[] groupParamNumbers = new String[]{"G001", "G010", "GL_VCH_POST_CONTROL", "G003"};
        HashMap paramMap = iParamControl.getParamHashMap(groupParamNumbers, null);
        String[] paramNumbers = new String[]{"GL_002", "GL_003", "GL_047", "GL_0151", "GL_069", "GL_043", "GL_0155", "GL_014", "GL_015", "GL_014_1", "GL_0151", "GL_102", "GL_031", "GL_099", "GL_067", "GL_012", "GL_029"};
        paramMap.putAll(iParamControl.getParamHashMap(paramNumbers, companyId));
        for (String key : paramMap.keySet()) {
            Object value = paramMap.get(key);
            if ("true".equals(value) || "false".equals(value)) {
                paramMap.put(key, Boolean.valueOf((String)value));
                continue;
            }
            if (!key.equals("GL_102")) continue;
            paramMap.put(key, value);
        }
        return paramMap;
    }

    private void setOrginal(TemplateVoucherEntryInfo entryInfo) {
        HashMap<String, Object> original = new HashMap<String, Object>();
        original.put("currencyid", entryInfo.getCurrency().getId().toString());
        original.put("originalamount", entryInfo.getOriginalAmount());
        original.put("quantity", entryInfo.getQuantity());
        original.put("measureunit", entryInfo.getMeasureUnit());
        original.put("price", entryInfo.getPrice());
        entryInfo.put("original", original);
    }

    private AssistCustomizedPropertyCollection getAccountCustProp(Context ctx, String accountId) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("isNecessary"));
        sic.add(new SelectorItemInfo("isCreditNecessary"));
        sic.add(new SelectorItemInfo("isDebitNecessary"));
        sic.add(new SelectorItemInfo("customizedType.id"));
        sic.add(new SelectorItemInfo("customizedType.name"));
        sic.add(new SelectorItemInfo("customizedType.mappingPropName"));
        sic.add(new SelectorItemInfo("customizedType.dataType"));
        sic.add(new SelectorItemInfo("customizedType.defaultQueryName"));
        sic.add(new SelectorItemInfo("customizedType.precision"));
        sic.add(new SelectorItemInfo("customizedType.isForCompany"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("seq"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("account.id", (Object)accountId));
        fic.add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        AssistCustomizedPropertyCollection coll = AssistCustomizedPropertyFactory.getLocalInstance(ctx).getAssistCustomizedPropertyCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            AssistCustomizedPropertyInfo prop = coll.get(i);
            AssistCustomizedTypeInfo type = prop.getCustomizedType();
            if (type.getDataType() != AssistCustomizedDataTypeEnum.ENUM) continue;
            try {
                List enumList = EnumUtils.getEnumList(Class.forName(type.getDefaultQueryName()));
                Iterator it = enumList.iterator();
                ArrayList eList = new ArrayList();
                while (it.hasNext()) {
                    Enum e = (Enum)it.next();
                    HashMap<String, Object> eMap = new HashMap<String, Object>();
                    eMap.put("alias", e.getAlias());
                    eMap.put("value", e instanceof IntEnum ? Integer.valueOf(((IntEnum)e).getValue()) : (e instanceof StringEnum ? ((StringEnum)e).getValue() : null));
                    eList.add(eMap);
                }
                type.put("enumsource", eList);
                continue;
            }
            catch (Exception e) {
                throw new BOSException("", (Throwable)e);
            }
        }
        return coll;
    }

    private void setExchangeRate(Context ctx, TemplateVoucherInfo voucherInfo, TemplateVoucherEntryInfo entryInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = voucherInfo.getCompany();
        ObjectUuidPK baseExchangeTableId = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        ObjectUuidPK currencyId = new ObjectUuidPK(entryInfo.getCurrency().getId());
        ObjectUuidPK baseCurrencyId = new ObjectUuidPK(company.getBaseCurrency().getId());
        this.cacheExchangeRate(ctx, baseExchangeTableId, currencyId, baseCurrencyId, this.exchangeRateCache);
        if (company.getReportExchangeTable() != null && company.getReportCurrency() != null) {
            ObjectUuidPK rptExchangeTableId = new ObjectUuidPK(company.getReportExchangeTable().getId());
            ObjectUuidPK rptCurrencyId = new ObjectUuidPK(company.getReportCurrency().getId());
            ObjectUuidPK srcCurrencyId = company.getReportConvertMode() == ReportCurrencyConvertMode.Base ? baseCurrencyId : currencyId;
            this.cacheExchangeRate(ctx, rptExchangeTableId, srcCurrencyId, rptCurrencyId, this.exchangeRateCache);
        }
    }

    private void cacheExchangeRate(Context ctx, ObjectUuidPK exchangeTableId, ObjectUuidPK srcCurrencyId, ObjectUuidPK targetCurrencyId, Map exchangeRateCache) throws EASBizException, BOSException {
        String key = exchangeTableId + "_" + srcCurrencyId + "_" + targetCurrencyId;
        if (exchangeRateCache.get(key) == null) {
            ExchangeRateInfo exRate = null;
            exRate = new ExchangeRateInfo();
            exRate.setConvertRate(new BigDecimal("1"));
            ExchangeAuxInfo aux = new ExchangeAuxInfo();
            aux.setExchangeRateType(ExchangeTypeEnum.FIXEXCHANGERATE);
            aux.setPrecision(2);
            exRate.setExchangeAux(aux);
            exchangeRateCache.put(key, exRate);
        }
    }
}

