/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CussentStatusEnum;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.UserSettingFactory;
import com.kingdee.eas.fi.gl.UserSettingObject;
import com.kingdee.eas.fi.gl.VoucherCategoryEnum;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.ServerUtils;
import com.kingdee.eas.fi.gl.app.VoucherFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.WebVoucherTransfer;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WebVoucherCreator {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.WebVoucherCreator");
    private String resClassName = "com.kingdee.eas.fi.gl.GLResource";

    public VoucherInfo create(Context ctx, String companyId) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = new VoucherInfo();
        voucherInfo.setPostedByUI(true);
        CompanyOrgUnitInfo comapny = ServerUtils.getDefaultCompany(ctx, companyId, "gl_voucher_add");
        voucherInfo.setCompany(comapny);
        voucherInfo.setCU(comapny.getCU());
        this.setPeriod(ctx, voucherInfo);
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        voucherInfo.setCreator(curUser);
        voucherInfo.setHandler(curUser);
        voucherInfo.setAttachments(0);
        voucherInfo.setSourceSys(SystemEnum.GENERALLEDGER);
        voucherInfo.setSourceType(SourceType.HANDCRAFT);
        voucherInfo.setCashflowFetched(true);
        voucherInfo.setCashflowFlag(CashflowFlag.NONE);
        voucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
        voucherInfo.setCategory(VoucherCategoryEnum.FINANCE);
        this.setNumberAddNew(ctx, voucherInfo);
        VoucherInfo webVoucherInfo = new WebVoucherTransfer(ctx, voucherInfo).transfer();
        return webVoucherInfo;
    }

    public VoucherInfo copy(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (voucherInfo.getCompany().isIsSealUp()) {
            throw new VoucherException(VoucherException.NO_MSG, new String[]{MessageFormat.format(EASResource.getString((String)this.resClassName, (String)"sealed_org_addunable"), voucherInfo.getCompany().getName())});
        }
        if (!PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(voucherInfo.getCompany().getId()), "gl_voucher_add")) {
            String addNewVoucher = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"addNewVoucher", (Locale)ctx.getLocale());
            throw new GLException(GLException.NO_PERMISSON, new String[]{addNewVoucher});
        }
        VoucherInfo voucher = new VoucherInfo();
        voucher.putAll((IObjectValue)voucherInfo);
        voucher.setId(null);
        voucher.setNumber(null);
        this.setPeriod(ctx, voucher);
        String periodTypeId = voucher.getCompany().getAccountPeriodType().getId().toString();
        voucher.put("periodenum", (Object)WebVoucherTransfer.getPeriodListByDate(ctx, periodTypeId, voucher.getBookedDate()));
        voucher.put("periodstr", (Object)WebVoucherTransfer.toPeriodString(voucher.getPeriod()));
        voucher.setCreator(curUser);
        voucher.setHandler(curUser);
        voucher.setCashier(null);
        voucher.setAuditor(null);
        voucher.setPoster(null);
        voucher.setCanceller(null);
        voucher.setAttachments(0);
        voucher.setBizStatus(VoucherStatusEnum.TEMP);
        voucher.setSourceSys(SystemEnum.GENERALLEDGER);
        voucher.setSourceType(SourceType.HANDCRAFT);
        voucher.setIsCussent(false);
        voucher.setCashflowFetched(true);
        voucher.setCashflowFlag(CashflowFlag.NONE);
        voucher.setSourceBillId(null);
        voucher.setIsReverseVoucher(false);
        voucher.setHasReversed(false);
        voucher.setIsCheck(false);
        voucher.setIsAuditBack(false);
        voucher.put("isAcNoticeVch", null);
        this.setNumberAddNew(ctx, voucher);
        Iterator it = voucher.getEntries().iterator();
        int index = 1;
        VoucherEntryCollection newEntryColl = new VoucherEntryCollection();
        while (it.hasNext()) {
            VoucherEntryInfo oldEntry = (VoucherEntryInfo)it.next();
            VoucherEntryInfo entry = new VoucherEntryInfo();
            entry.putAll((IObjectValue)oldEntry);
            entry.put("entryid", null);
            entry.put("assistrecordid", null);
            entry.put("assisthasverifyed", (Object)false);
            entry.put("entry_assistrecord_id", (Object)index++);
            entry.setOprStatus(1);
            entry.setCussent(CussentStatusEnum.NONE);
            AccountViewInfo account = entry.getAccount();
            if (account != null && (account.getCAA() != null || account.isHasUserProperty())) {
                account.put("asstbizdate", (Object)voucher.getBizDate());
                if (account.isAC()) {
                    Date asstEndDate = DateTimeUtils.truncateDate((Date)voucher.getPeriod().getEndDate());
                    account.put("asstenddate", (Object)asstEndDate);
                }
            }
            if (account != null && account.getControl() != null && account.getControl().getValue() != 0) continue;
            newEntryColl.add(entry);
        }
        voucher.setEntries((AbstractObjectCollection)newEntryColl);
        this.processForAsstAccountChange(ctx, voucher);
        return voucher;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setPeriod(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = voucherInfo.getCompany();
        String companyId = company.getId().toString();
        PeriodInfo period = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(6, companyId);
        if (period == null && SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getStartPeriod(6, companyId) == null) {
            throw new VoucherException(VoucherException.NO_MSG, new String[]{EASResource.getString((String)this.resClassName, (String)"cur_org_no_period")});
        }
        UserSettingObject settingObj = UserSettingFactory.getLocalInstance(ctx).getValue(null, "fi.gl.voucher.editSetting");
        Date date = DateTimeUtils.truncateDate((Date)new Date());
        if (settingObj != null && settingObj.getBoolean("sysData") && date.after(period.getEndDate())) {
            PeriodCollection periodColl = PeriodUtils.getPeriodCollection((Context)ctx, (Date)date, (Date)date, (CompanyOrgUnitInfo)company);
            if (periodColl.isEmpty()) throw new VoucherException(VoucherException.NO_MSG, new String[]{EASResource.getString((String)this.resClassName, (String)"cur_date_no_period")});
            period = periodColl.get(0);
        } else {
            if (period != null) {
                if (date.before(period.getBeginDate())) {
                    date = period.getBeginDate();
                } else if (date.after(period.getEndDate())) {
                    date = period.getEndDate();
                }
            }
            date = DateTimeUtils.truncateDate((Date)date);
        }
        voucherInfo.setBizDate(date);
        voucherInfo.setBookedDate(date);
        voucherInfo.setPeriod(period);
    }

    private void setNumberAddNew(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        try {
            String compangId = voucherInfo.getCompany().getId().toString();
            if (VoucherFacadeControllerBean.isNumberAddNew(ctx, compangId)) {
                String preViewNumber = VoucherUtil.preViewNumber(ctx, compangId, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED);
                voucherInfo.setNumber(preViewNumber);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"codingRule error!", (Throwable)ex);
        }
        voucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
    }

    private void processForAsstAccountChange(Context ctx, VoucherInfo info) throws BOSException, EASBizException {
        HashSet<String> accountIds = new HashSet<String>();
        for (VoucherEntryInfo entry : info.getEntries()) {
            AccountViewInfo account = entry.getAccount();
            if (account == null) continue;
            accountIds.add(account.getId().toString());
        }
        if (accountIds.size() <= 0) {
            return;
        }
        Map caas = AccountFacadeFactory.getLocalInstance((Context)ctx).getCAAsByPeriod(accountIds, info.getPeriod().getId().toString());
        for (VoucherEntryInfo entry : info.getEntries()) {
            AccountViewInfo account = entry.getAccount();
            if (account == null) continue;
            AsstAccountInfo caa = (AsstAccountInfo)caas.get(account.getId().toString());
            if (caa == null) {
                account.put("assgrp", null);
                account.setCAA(null);
                entry.setCAA(null);
                continue;
            }
            if (account.getCAA() == null) {
                account.put("assgrp", null);
                account.setCAA(caa);
                entry.setCAA(caa);
                continue;
            }
            if (caa.getId().equals((Object)account.getCAA().getId())) continue;
            AssistantHGInfo hgInfo = (AssistantHGInfo)account.get("assgrp");
            hgInfo.setId(null);
            account.setCAA(caa);
            entry.setCAA(caa);
        }
    }
}

