/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.ExchangeTypeEnum;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlCUFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlCUInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ReportCurrencyConvertMode;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentFactory;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedDataTypeEnum;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.cslacct.RequisitionInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WebVoucherTransfer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.WebVoucherTransfer");
    private Context ctx;
    private VoucherInfo voucherInfo;
    private Map exchangeRateCache = new HashMap();

    public WebVoucherTransfer(Context ctx, VoucherInfo voucherInfo) {
        this.ctx = ctx;
        this.voucherInfo = voucherInfo;
    }

    public VoucherInfo transfer() throws EASBizException, BOSException {
        int i;
        List<Map> voucherTypeList = this.getVoucherTypeList(this.voucherInfo.getCompany());
        Map paramMap = this.getSysParam(this.ctx);
        VoucherInfo voucher = new VoucherInfo();
        voucher.putAll((IObjectValue)this.voucherInfo);
        CompanyOrgUnitInfo company = voucher.getCompany();
        company.put("sysparam", (Object)paramMap);
        voucher.put("currencies", (Object)this.getCurrencyComboList());
        voucher.put("vouchertypeenum", voucherTypeList);
        if (voucher.get("vouchertypeid") == null) {
            VoucherTypeInfo vt = voucher.getVoucherType();
            if (vt != null) {
                voucher.put("vouchertypeid", (Object)vt.getId().toString());
            } else {
                VoucherTypeInfo voucherTypeInfo = this.getDefaultVoucherTypeInfo(voucherTypeList);
                voucher.setVoucherType(voucherTypeInfo);
                if (voucherTypeInfo != null) {
                    voucher.put("vouchertypeid", (Object)voucherTypeInfo.getId().toString());
                }
            }
        }
        String periodTypeId = company.getAccountPeriodType().getId().toString();
        voucher.put("periodenum", (Object)WebVoucherTransfer.getPeriodListByDate(this.ctx, periodTypeId, voucher.getBookedDate()));
        voucher.put("periodstr", (Object)WebVoucherTransfer.toPeriodString(voucher.getPeriod()));
        VoucherEntryCollection entryColl = voucher.getEntries();
        VoucherEntryCollection newEntryColl = new VoucherEntryCollection();
        ArrayList<String> vchAsstAboutAc = new ArrayList<String>();
        for (i = 0; i < entryColl.size(); ++i) {
            this.toWebVoucherEntryInfo(this.ctx, voucher, entryColl.get(i), newEntryColl, paramMap, vchAsstAboutAc);
        }
        if (vchAsstAboutAc.size() > 0) {
            Map<String, Boolean> hasVerifyMap = AcctCussentHistoryFacadeFactory.getLocalInstance(this.ctx).hasVerifyAboutAsstBatch(vchAsstAboutAc);
            Set<String> keySet = hasVerifyMap.keySet();
            for (int i2 = 0; i2 < newEntryColl.size(); ++i2) {
                String vchAsstId = (String)newEntryColl.get(i2).get("assistrecordid");
                if (!keySet.contains(vchAsstId)) continue;
                newEntryColl.get(i2).put("assisthasverifyed", (Object)true);
            }
        }
        if (this.isAcNoticeVch(voucher)) {
            voucher.put("isAcNoticeVch", (Object)true);
        }
        voucher.put("exchangerate", (Object)this.exchangeRateCache);
        voucher.getEntries().clear();
        if (newEntryColl.size() < 6) {
            int j = 6 - newEntryColl.size();
            for (i = 0; i < j; ++i) {
                newEntryColl.add(new VoucherEntryInfo());
            }
        }
        voucher.getEntries().addCollection(newEntryColl);
        boolean useProfitCenterAccount = Boolean.TRUE.equals(paramMap.get("GL_115"));
        String profitCenterF7Filter = this.getProfitCenterF7Filter(company.getId().toString(), useProfitCenterAccount);
        voucher.put("profitcenterf7filter", (Object)profitCenterF7Filter);
        return voucher;
    }

    private boolean isAcNoticeVch(VoucherInfo voucher) {
        if (voucher.getSourceType() == SourceType.NONE && voucher.getId() != null) {
            try {
                BOTRelationCollection relationColl = BTPManagerFactory.getLocalInstance((Context)this.ctx).getRelationCollection(voucher.getId().toString());
                if (relationColl != null && relationColl.size() > 0) {
                    BOTRelationInfo relationInfo = relationColl.get(0);
                    RequisitionInfo requisitionInfo = new RequisitionInfo();
                    if (requisitionInfo.getBOSType().toString().equals(relationInfo.getSrcEntityID())) {
                        return true;
                    }
                }
            }
            catch (BTPException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return false;
    }

    public VoucherInfo transferReverseVoucher() throws EASBizException, BOSException {
        int i;
        Map paramMap = this.getSysParam(this.ctx);
        VoucherInfo voucher = (VoucherInfo)this.voucherInfo.clone();
        CompanyOrgUnitInfo company = voucher.getCompany();
        company.put("sysparam", (Object)paramMap);
        voucher.put("currencies", (Object)this.getCurrencyComboList());
        List<Map> voucherTypeList = this.getVoucherTypeList(company);
        voucher.put("vouchertypeenum", voucherTypeList);
        if (voucher.get("vouchertypeid") == null) {
            VoucherTypeInfo vt = voucher.getVoucherType();
            if (vt != null) {
                voucher.put("vouchertypeid", (Object)vt.getId().toString());
            } else {
                VoucherTypeInfo voucherTypeInfo = this.getDefaultVoucherTypeInfo(voucherTypeList);
                voucher.setVoucherType(voucherTypeInfo);
                if (voucherTypeInfo != null) {
                    voucher.put("vouchertypeid", (Object)voucherTypeInfo.getId().toString());
                }
            }
        }
        String periodTypeId = company.getAccountPeriodType().getId().toString();
        voucher.put("periodenum", (Object)WebVoucherTransfer.getPeriodListByDate(this.ctx, periodTypeId, voucher.getBookedDate()));
        voucher.put("periodstr", (Object)WebVoucherTransfer.toPeriodString(voucher.getPeriod()));
        VoucherEntryCollection entryColl = voucher.getEntries();
        VoucherEntryCollection newEntryColl = new VoucherEntryCollection();
        boolean isAsstQty = Boolean.TRUE.equals(paramMap.get("G010"));
        for (i = 0; i < entryColl.size(); ++i) {
            this.toWebVoucherReverseEntryInfo(this.ctx, voucher, entryColl.get(i), newEntryColl, isAsstQty);
        }
        voucher.put("exchangerate", (Object)this.exchangeRateCache);
        voucher.getEntries().clear();
        if (newEntryColl.size() < 6) {
            int j = 6 - newEntryColl.size();
            for (i = 0; i < j; ++i) {
                newEntryColl.add(new VoucherEntryInfo());
            }
        }
        voucher.getEntries().addCollection(newEntryColl);
        boolean useProfitCenterAccount = Boolean.TRUE.equals(paramMap.get("GL_115"));
        String profitCenterF7Filter = this.getProfitCenterF7Filter(company.getId().toString(), useProfitCenterAccount);
        voucher.put("profitcenterf7filter", (Object)profitCenterF7Filter);
        return voucher;
    }

    private String getProfitCenterF7Filter(String companyId, boolean useProfitCenterAccount) {
        StringBuffer sql = new StringBuffer();
        sql.append(" unit.id IN (SELECT FFromUnitId FROM T_ORG_UnitRelation ");
        sql.append(" WHERE FTypeRelationId = (SELECT fid FROM T_ORG_TypeRelation WHERE FFromType = 6 AND FToType = 1) ");
        sql.append(" AND FToUnitId = '").append(companyId).append("'");
        if (useProfitCenterAccount) {
            sql.append(" union SELECT fprofitorgunitid FROM T_ORG_FIACCOUNTRANGE WHERE ffiorgunitid = '").append(companyId).append("'");
        }
        sql.append(") ");
        sql.append(" AND unit.id IN (SELECT ssc.FprofitCenterId FROM T_BD_SystemStatusCtrol ssc ");
        sql.append(" INNER JOIN T_BD_SystemStatus ss on ss.FId = ssc.FSystemStatusId ");
        sql.append(" where ss.FName = ").append(1006);
        sql.append(" AND ssc.FStartPeriodId IS NOT NULL) ");
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        sql.append(" AND unit.id IN (SELECT FOrgId FROM T_PM_OrgRange WHERE FUserId = '").append(curUser.getId().toString()).append("' ");
        sql.append(" AND ftype = 10) ");
        sql.append(" AND unit.id IN (select fid from t_org_ProfitCenter where fissealup = 0 and FISOUSEALUP = 0) ");
        return sql.toString();
    }

    private void toWebVoucherEntryInfo(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo, VoucherEntryCollection newEntryColl, Map paramMap, List<String> vchAsstAboutAc) throws EASBizException, BOSException {
        boolean isAsstQty = Boolean.TRUE.equals(paramMap.get("G010"));
        boolean allowCussent = Boolean.TRUE.equals(paramMap.get("GL_028"));
        int verifyModel = Integer.valueOf(paramMap.get("GL_052").toString());
        boolean isShowAsstNumber = Boolean.TRUE.equals(paramMap.get("GL_004"));
        this.setExchangeRate(ctx, voucherInfo, entryInfo);
        String entryId = entryInfo.getId().toString();
        entryInfo.setId(null);
        entryInfo.put("entryid", (Object)entryId);
        VoucherAssistRecordCollection assistRecords = entryInfo.getAssistRecords();
        if (assistRecords != null && !assistRecords.isEmpty()) {
            voucherInfo.put("entry_desc_" + entryId, (Object)entryInfo.getDescription());
            boolean isAc = entryInfo.getAccount().isAC();
            boolean isInTimeVerify = verifyModel == 0;
            for (int j = 0; j < assistRecords.size(); ++j) {
                VoucherAssistRecordInfo record = assistRecords.get(j);
                VoucherEntryInfo entry = new VoucherEntryInfo();
                entry.putAll((IObjectValue)entryInfo);
                String voucherassistrecordId = record.getId().toString();
                entry.put("entry_assistrecord_id", (Object)(entryId + voucherassistrecordId));
                entry.put("assistrecordid", (Object)voucherassistrecordId);
                entry.put("assistrecord_primaryitem", (Object)record.getPrimaryItem());
                entry.put("assistrecord_supplementaryitem", (Object)record.getSupplementaryItem());
                entry.setEntryDC(entryInfo.getEntryDC());
                if (entry.getAccount() == null) continue;
                if (isAc && allowCussent && !isInTimeVerify) {
                    vchAsstAboutAc.add(voucherassistrecordId);
                }
                AccountViewInfo account = new AccountViewInfo();
                account.putAll((IObjectValue)entry.getAccount());
                entry.setAccount(account);
                account.setCAA(entry.getCAA());
                AssistantHGInfo hgInfo = record.getAssGrp();
                if (hgInfo != null) {
                    String displayNameGroup = hgInfo.getDisplayNameGroup();
                    String[] displayNames = displayNameGroup.split(";");
                    StringBuffer displayName = new StringBuffer();
                    StringBuilder displayNumberAndName = new StringBuilder();
                    for (int n = 0; n < displayNames.length; ++n) {
                        String[] name = displayNames[n].split(":", 2);
                        if (name.length < 2 || StringUtils.isEmpty((String)name[1]) || "null".equals(name[1])) continue;
                        if (displayName.length() > 0) {
                            displayName.append("|");
                            displayNumberAndName.append("|");
                        }
                        if (name[1].indexOf("_!") != 0 && name[1].indexOf("_!") != -1) {
                            String[] array = name[1].split("_!");
                            displayName.append(array[1].trim());
                            displayNumberAndName.append(array[0]).append(" ").append(array[1]);
                            continue;
                        }
                        if (name[1].startsWith("_!")) {
                            if (name[1].equals("_!")) {
                                displayName.append("");
                                continue;
                            }
                            String nam = name[1].split("_!")[0].trim();
                            displayName.append(nam);
                            displayNumberAndName.append(nam);
                            continue;
                        }
                        displayName.append(name[1].trim());
                        displayNumberAndName.append(name[1].trim());
                    }
                    hgInfo.put("displayname", (Object)(isShowAsstNumber ? displayNumberAndName.toString() : displayName.toString()));
                    String nameGroup = hgInfo.getLongNameGroup();
                    String[] names = nameGroup.split(";");
                    StringBuffer name = new StringBuffer();
                    for (int n = 0; n < names.length; ++n) {
                        String[] nm = names[n].split(":", 2);
                        if (nm.length < 2 || StringUtils.isEmpty((String)nm[1]) || "null".equals(nm[1])) continue;
                        if (name.length() > 0) {
                            name.append("|");
                        }
                        name.append(nm[1].trim());
                    }
                    hgInfo.put("name", (Object)name.toString());
                    HashMap<String, String> asstActInfo = new HashMap<String, String>();
                    String asstName = isShowAsstNumber ? displayNumberAndName.toString() : name.toString();
                    asstName = VoucherUtil.decodeSplitFlag(asstName);
                    asstActInfo.put("name", asstName);
                    asstActInfo.put("asstAct", (String)hgInfo);
                    entry.put("assistGrp", asstActInfo);
                }
                if (account.isHasUserProperty()) {
                    String propName;
                    AssistCustomizedPropertyInfo propInfo;
                    ArrayList<AssistCustomizedPropertyInfo> propList;
                    AssistCustomizedPropertyCollection props = this.getAccountCustProp(ctx, account.getId().toString());
                    SelectorItemCollection selector = new SelectorItemCollection();
                    for (int k = 0; k < props.size(); ++k) {
                        AssistCustomizedPropertyInfo propInfo2 = props.get(k);
                        String propName2 = propInfo2.getCustomizedType().getMappingPropName();
                        if (propInfo2.getCustomizedType().getDataType() == AssistCustomizedDataTypeEnum.BUSINESSOBJECT) {
                            selector.add(new SelectorItemInfo(propName2 + ".id"));
                            selector.add(new SelectorItemInfo(propName2 + ".name"));
                            selector.add(new SelectorItemInfo(propName2 + ".number"));
                            continue;
                        }
                        selector.add(new SelectorItemInfo(propName2));
                    }
                    VoucherAssistRecordInfo custVchRecrd = null;
                    if (entry.get("isTemplate") == null && VoucherAssistRecordFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(voucherassistrecordId))) {
                        custVchRecrd = (VoucherAssistRecordInfo)VoucherAssistRecordFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(voucherassistrecordId), selector);
                        propList = new ArrayList();
                        for (int k = 0; k < props.size(); ++k) {
                            propInfo = props.get(k);
                            propName = propInfo.getCustomizedType().getMappingPropName();
                            propInfo.put("value", custVchRecrd.get(propName));
                            propList.add(propInfo);
                        }
                        account.put("accountcustprop", propList);
                    } else {
                        custVchRecrd = record;
                        propList = new ArrayList<AssistCustomizedPropertyInfo>();
                        for (int k = 0; k < props.size(); ++k) {
                            propInfo = props.get(k);
                            propName = propInfo.getCustomizedType().getMappingPropName();
                            propInfo.put("value", custVchRecrd.get(propName));
                            propList.add(propInfo);
                        }
                        account.put("accountcustprop", propList);
                    }
                }
                if (record.getBizDate() != null) {
                    account.put("asstbizdate", (Object)record.getBizDate());
                }
                if (account.isAC() && record.getEndDate() != null) {
                    account.put("asstenddate", (Object)record.getEndDate());
                }
                if (record.getVerifiedCussent() != null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("currency.id");
                    sic.add("currency.name");
                    sic.add("currency.precision");
                    sic.add("assGrp.id");
                    sic.add("assGrp.name");
                    sic.add("id");
                    AcctCussentInfo verifiedCussent = (AcctCussentInfo)AcctCussentFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(record.getVerifiedCussent().getId()), sic);
                    if (verifiedCussent.getAssGrp() != null) {
                        AssistantHGInfo assGrp = GlUtils.getHgInfo(ctx, verifiedCussent.getAssGrp().getId().toString(), account.getCAA().getId().toString(), true);
                        verifiedCussent.setAssGrp(assGrp);
                    }
                    account.put("verifiedcussent", (Object)verifiedCussent);
                }
                entry.setDescription(record.getDescription());
                entry.setOriginalAmount(record.getOriginalAmount());
                entry.setLocalAmount(record.getLocalAmount());
                entry.setReportingAmount(record.getReportingAmount());
                entry.setQuantity(record.getQuantity());
                entry.setPrice(record.getPrice());
                if (isAsstQty) {
                    entry.setMeasureUnit(record.getMeasureUnit());
                }
                this.setOrginal(entry);
                entry.put("assistRecords", (Object)new VoucherAssistRecordCollection());
                EntryDC entryDc = entry.getEntryDC();
                this.separateDebitCredit(entry);
                newEntryColl.add(entry);
                entry.setEntryDC(entryDc);
                entry.setSeq(newEntryColl.size());
            }
        } else {
            entryInfo.put("entry_assistrecord_id", (Object)entryId);
            this.setOrginal(entryInfo);
            EntryDC entryDc = entryInfo.getEntryDC();
            this.separateDebitCredit(entryInfo);
            newEntryColl.add(entryInfo);
            entryInfo.setEntryDC(entryDc);
            if (entryInfo.getAccount() != null) {
                AccountViewInfo account = new AccountViewInfo();
                account.putAll((IObjectValue)entryInfo.getAccount());
                account.setCAA(entryInfo.getCAA());
                entryInfo.setAccount(account);
            }
            entryInfo.setSeq(newEntryColl.size());
        }
    }

    private void toWebVoucherReverseEntryInfo(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo, VoucherEntryCollection newEntryColl, boolean isAsstQty) throws EASBizException, BOSException {
        this.setExchangeRate(ctx, voucherInfo, entryInfo);
        String entryId = entryInfo.getId().toString();
        entryInfo.setId(null);
        entryInfo.put("entryid", (Object)entryId);
        VoucherAssistRecordCollection assistRecords = entryInfo.getAssistRecords();
        if (assistRecords != null && !assistRecords.isEmpty()) {
            for (int j = 0; j < assistRecords.size(); ++j) {
                VoucherAssistRecordInfo record = assistRecords.get(j);
                VoucherEntryInfo entry = (VoucherEntryInfo)entryInfo.clone();
                Object voucherassistrecordId = null;
                entry.put("entry_assistrecord_id", (Object)(entryInfo.getSeq() + "$" + record.getSeq()));
                entry.put("assistrecordid", voucherassistrecordId);
                entry.setEntryDC(entryInfo.getEntryDC());
                AccountViewInfo account = entry.getAccount();
                if (account == null) continue;
                AssistantHGInfo hgInfo = record.getAssGrp();
                if (hgInfo != null) {
                    String displayNameGroup = hgInfo.getDisplayNameGroup();
                    String[] displayNames = displayNameGroup.split(";");
                    StringBuffer displayName = new StringBuffer();
                    for (int n = 0; n < displayNames.length; ++n) {
                        String[] name = displayNames[n].split(":", 2);
                        if (name.length < 2 || StringUtils.isEmpty((String)name[1]) || "null".equals(name[1])) continue;
                        if (displayName.length() > 0) {
                            displayName.append("|");
                        }
                        if (name[1].indexOf("_!") != 0 && name[1].indexOf("_!") != -1) {
                            displayName.append(name[1].split("_!")[1].trim());
                            continue;
                        }
                        if (name[1].startsWith("_!")) {
                            if (name[1].equals("_!")) {
                                displayName.append("");
                                continue;
                            }
                            displayName.append(name[1].split("_!")[0].trim());
                            continue;
                        }
                        displayName.append(name[1].trim());
                    }
                    hgInfo.put("displayname", (Object)displayName.toString());
                    String nameGroup = hgInfo.getLongNameGroup();
                    String[] names = nameGroup.split(";");
                    StringBuffer name = new StringBuffer();
                    for (int n = 0; n < names.length; ++n) {
                        String[] nm = names[n].split(":", 2);
                        if (nm.length < 2 || StringUtils.isEmpty((String)nm[1]) || "null".equals(nm[1])) continue;
                        if (name.length() > 0) {
                            name.append("|");
                        }
                        name.append(nm[1].trim());
                    }
                    hgInfo.put("name", (Object)name.toString());
                    HashMap<String, String> asstActInfo = new HashMap<String, String>();
                    asstActInfo.put("name", name.toString());
                    asstActInfo.put("asstAct", (String)hgInfo);
                    entry.put("assistGrp", asstActInfo);
                }
                if (account.isHasUserProperty()) {
                    AssistCustomizedPropertyCollection props = this.getAccountCustProp(ctx, account.getId().toString());
                    SelectorItemCollection selector = new SelectorItemCollection();
                    for (int k = 0; k < props.size(); ++k) {
                        AssistCustomizedPropertyInfo propInfo = props.get(k);
                        String propName = propInfo.getCustomizedType().getMappingPropName();
                        if (propInfo.getCustomizedType().getDataType() == AssistCustomizedDataTypeEnum.BUSINESSOBJECT) {
                            selector.add(new SelectorItemInfo(propName + ".id"));
                            selector.add(new SelectorItemInfo(propName + ".name"));
                            selector.add(new SelectorItemInfo(propName + ".number"));
                            continue;
                        }
                        selector.add(new SelectorItemInfo(propName));
                    }
                    VoucherAssistRecordInfo custVchRecrd = null;
                    custVchRecrd = record;
                    ArrayList<AssistCustomizedPropertyInfo> propList = new ArrayList<AssistCustomizedPropertyInfo>();
                    for (int k = 0; k < props.size(); ++k) {
                        AssistCustomizedPropertyInfo propInfo = props.get(k);
                        String propName = propInfo.getCustomizedType().getMappingPropName();
                        propInfo.put("value", custVchRecrd.get(propName));
                        propList.add(propInfo);
                    }
                    account.put("accountcustprop", propList);
                }
                if (record.getBizDate() != null) {
                    account.put("asstbizdate", (Object)record.getBizDate());
                }
                if (account.isAC() && record.getEndDate() != null) {
                    account.put("asstenddate", (Object)record.getEndDate());
                }
                entry.setDescription(record.getDescription());
                entry.setOriginalAmount(record.getOriginalAmount());
                entry.setLocalAmount(record.getLocalAmount());
                entry.setReportingAmount(record.getReportingAmount());
                entry.setQuantity(record.getQuantity());
                entry.setPrice(record.getPrice());
                if (isAsstQty) {
                    entry.setMeasureUnit(record.getMeasureUnit());
                }
                this.setOrginal(entry);
                entry.getAssistRecords().clear();
                EntryDC entryDc = entry.getEntryDC();
                this.separateDebitCredit(entry);
                newEntryColl.add(entry);
                entry.setEntryDC(entryDc);
                entry.setSeq(newEntryColl.size());
            }
        } else {
            entryInfo.put("entry_assistrecord_id", (Object)entryId);
            this.setOrginal(entryInfo);
            EntryDC entryDc = entryInfo.getEntryDC();
            this.separateDebitCredit(entryInfo);
            newEntryColl.add(entryInfo);
            entryInfo.setEntryDC(entryDc);
            entryInfo.setSeq(newEntryColl.size());
        }
    }

    private List getCurrencyComboList() throws EASBizException, BOSException {
        CurrencyCollection currencyColl = this.getCurrencyCollection();
        ArrayList currencyComboList = new ArrayList();
        for (int i = 0; i < currencyColl.size(); ++i) {
            CurrencyInfo currency = currencyColl.get(i);
            HashMap<String, Object> currencyMap = new HashMap<String, Object>();
            currencyMap.put("value", currency.getId().toString());
            currencyMap.put("alias", currency.getName());
            currencyMap.put("precision", currency.getPrecision());
            currencyMap.put("invalid", currency.getDeletedStatus() == DeletedStatusEnum.DELETED);
            currencyComboList.add(currencyMap);
        }
        return currencyComboList;
    }

    private CurrencyCollection getCurrencyCollection() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("precision"));
        view.getSelector().add(new SelectorItemInfo("deletedStatus"));
        return CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyCollection(view, true);
    }

    private List<Map> getVoucherTypeList(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        VoucherTypeCtrlCUInfo info = VoucherTypeCtrlCUFactory.getLocalInstance((Context)this.ctx).getVoucherTypeCtrlCU(company.getCU().getId().toString());
        ArrayList<Map> voucherTypeList = new ArrayList<Map>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select vt.fid, vt.fname_").append(this.ctx.getLocale().toString()).append(" fname, vt.fpretermit, case when vtc.flevel is null then vt.flevel else vtc.flevel end flevel ");
        sql.append(" from t_bd_vouchertypes vt left outer join t_bd_vouchertypectrllevel vtc on vtc.fvouchertypeid = vt.fid and vtc.fcompanyid = ? ");
        sql.append(" where vt.fid IN (SELECT FDataBaseDID FROM t_bd_databasedassign WHERE FBOSObjectType = '7487D35D' AND FAssignCUID = ? ");
        sql.append(" union all (select fid from T_BD_VoucherTypes where fcontrolunitid = ?)) order by vt.fnumber ASC");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new String[]{company.getId().toString(), company.getCU().getId().toString(), company.getCU().getId().toString()});
        try {
            HashSet<String> keys = new HashSet<String>();
            while (rs.next()) {
                HashMap<String, Object> vt = new HashMap<String, Object>();
                String typeId = rs.getString("fid");
                if (keys.contains(typeId)) continue;
                vt.put("value", typeId);
                vt.put("alias", rs.getString("fname"));
                if (info != null) {
                    vt.put("isDefualt", info.getDfVoucherType() != null && info.getDfVoucherType().getId().toString().equals(typeId));
                } else {
                    vt.put("isDefualt", rs.getInt("fpretermit") == 1);
                }
                vt.put("level", rs.getInt("flevel"));
                voucherTypeList.add(vt);
                keys.add(typeId);
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql error!", (Throwable)e);
        }
        return voucherTypeList;
    }

    private VoucherTypeInfo getDefaultVoucherTypeInfo(List<Map> voucherTypeList) throws BOSException, EASBizException {
        Iterator<Map> it = voucherTypeList.iterator();
        Map defaultVoucherType = null;
        Map topLevelDefVType = null;
        while (it.hasNext()) {
            Map vt = it.next();
            if (topLevelDefVType == null || vt.get("level") != null && (Integer)vt.get("level") < (Integer)topLevelDefVType.get("level")) {
                topLevelDefVType = vt;
            }
            if (!Boolean.TRUE.equals(vt.get("isDefualt"))) continue;
            defaultVoucherType = vt;
            break;
        }
        if (defaultVoucherType == null) {
            if (topLevelDefVType != null) {
                defaultVoucherType = topLevelDefVType;
            } else if (!voucherTypeList.isEmpty()) {
                defaultVoucherType = voucherTypeList.get(0);
            }
        }
        if (defaultVoucherType != null) {
            VoucherTypeInfo voucherTypeInfo = new VoucherTypeInfo();
            voucherTypeInfo.setId(BOSUuid.read((String)((String)defaultVoucherType.get("value"))));
            voucherTypeInfo.setName((String)defaultVoucherType.get("alias"));
            return voucherTypeInfo;
        }
        return null;
    }

    protected static List getPeriodListByDate(Context ctx, String periodTypeId, Date bookedDate) throws BOSException {
        ArrayList listSource = new ArrayList();
        PeriodTypeInfo periodType = new PeriodTypeInfo();
        periodType.setId(BOSUuid.read((String)periodTypeId));
        PeriodCollection periodColl = WebVoucherTransfer.getPeriodCollection(ctx, periodTypeId, bookedDate);
        if (periodColl != null) {
            for (int i = 0; i < periodColl.size(); ++i) {
                PeriodInfo period = periodColl.get(i);
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("alias", WebVoucherTransfer.formartPeriod(ctx, period));
                item.put("value", WebVoucherTransfer.toPeriodString(period));
                listSource.add(item);
            }
        }
        return listSource;
    }

    protected static String toPeriodString(PeriodInfo period) {
        StringBuffer periodStr = new StringBuffer();
        periodStr.append(period.getId());
        periodStr.append(";").append(period.getNumber());
        periodStr.append(";").append(period.isIsAdjustPeriod());
        return periodStr.toString();
    }

    protected static String formartPeriod(Context ctx, PeriodInfo period) {
        String resFullName = "com.kingdee.eas.basedata.assistant.PeriodResource";
        String s = EASResource.getString((String)resFullName, (String)"periodformat", (Locale)ctx.getOriginLocale());
        MessageFormat mf = new MessageFormat(s);
        String result = mf.format(new String[]{new Integer(period.getPeriodYear()).toString(), new Integer(period.getPeriodNumber()).toString()});
        if (period.isIsAdjustPeriod()) {
            String msg = EASResource.getString((String)resFullName, (String)"periodformat_PeriodAdjuxt", (Locale)ctx.getOriginLocale());
            MessageFormat msf = new MessageFormat(msg);
            result = msf.format(new String[]{new Integer(period.getPeriodYear()).toString(), new Integer(period.getPeriodNumber()).toString()});
        }
        return result;
    }

    private static PeriodCollection getPeriodCollection(Context ctx, String periodTypeId, Date date) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("periodYear"));
        evi.getSelector().add(new SelectorItemInfo("periodNumber"));
        evi.getSelector().add(new SelectorItemInfo("isAdjustPeriod"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodTypeId, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        return PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
    }

    private void separateDebitCredit(VoucherEntryInfo entryInfo) {
        if (entryInfo.getEntryDC() == EntryDC.CREDIT) {
            entryInfo.put("localDebitAmount", null);
            entryInfo.put("rptDebitAmount", null);
            entryInfo.put("localCreditAmount", (Object)entryInfo.getLocalAmount());
            entryInfo.put("rptCreditAmount", (Object)entryInfo.getReportingAmount());
        } else {
            entryInfo.put("localDebitAmount", (Object)entryInfo.getLocalAmount());
            entryInfo.put("rptDebitAmount", (Object)entryInfo.getReportingAmount());
            entryInfo.remove("localCreditAmount");
            entryInfo.remove("rptCreditAmount");
        }
        entryInfo.remove("entryDC");
        entryInfo.remove("localAmount");
        entryInfo.remove("reportingAmount");
    }

    private Map getSysParam(Context ctx) throws GLException, EASBizException, BOSException {
        String companyId = this.voucherInfo.getCompany().getId().toString();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String[] groupParamNumbers = new String[]{"G001", "G010", "GL_VCH_POST_CONTROL", "G003"};
        HashMap paramMap = iParamControl.getParamHashMap(groupParamNumbers, null);
        String[] paramNumbers = new String[]{"GL_002", "GL_003", "GL_047", "GL_0151", "GL_069", "GL_043", "GL_0155", "GL_014", "GL_015", "GL_014_1", "GL_0151", "GL_102", "GL_031", "GL_099", "GL_067", "GL_012", "GL_029", "GL_111", "GL_0302", "GL_008", "GL_052", "GL_028", "GL_100", "GL_100_1", "GL_115", "GL_013", "GL_044", "GL_044_0", "GL_034", "GL_035", "GL_036", "GL_037", "GL_039", "GL_040", "GL_041", "GL_042", "GL_033", "GL_109", "GL_044_99", "GL_044_1", "GL_064", "GL_01301", "GL_0301", "GL_004", "GL_073", "GL_116"};
        paramMap.putAll(iParamControl.getParamHashMap(paramNumbers, companyId));
        for (String key : paramMap.keySet()) {
            Object value = paramMap.get(key);
            if (value == null) continue;
            if ("true".equals(value) || "false".equals(value)) {
                paramMap.put(key, Boolean.valueOf((String)value));
                continue;
            }
            if ("GL_100_1".equals(key)) {
                value = value == null ? "0" : value;
                paramMap.put(key, new BigDecimal((String)value));
                continue;
            }
            if (!key.equals("GL_102")) continue;
            paramMap.put(key, value);
        }
        return paramMap;
    }

    private void setOrginal(VoucherEntryInfo entryInfo) {
        HashMap<String, Object> original = new HashMap<String, Object>();
        original.put("currencyid", entryInfo.getCurrency().getId().toString());
        original.put("originalamount", entryInfo.getOriginalAmount());
        original.put("quantity", entryInfo.getQuantity());
        original.put("measureunit", entryInfo.getMeasureUnit());
        original.put("price", entryInfo.getPrice());
        entryInfo.put("original", original);
    }

    private AssistCustomizedPropertyCollection getAccountCustProp(Context ctx, String accountId) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("isNecessary"));
        sic.add(new SelectorItemInfo("isCreditNecessary"));
        sic.add(new SelectorItemInfo("isDebitNecessary"));
        sic.add(new SelectorItemInfo("customizedType.id"));
        sic.add(new SelectorItemInfo("customizedType.name"));
        sic.add(new SelectorItemInfo("customizedType.mappingPropName"));
        sic.add(new SelectorItemInfo("customizedType.dataType"));
        sic.add(new SelectorItemInfo("customizedType.defaultQueryName"));
        sic.add(new SelectorItemInfo("customizedType.precision"));
        sic.add(new SelectorItemInfo("customizedType.isForCompany"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("seq"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("account.id", (Object)accountId));
        fic.add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        AssistCustomizedPropertyCollection coll = AssistCustomizedPropertyFactory.getLocalInstance(ctx).getAssistCustomizedPropertyCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            AssistCustomizedPropertyInfo prop = coll.get(i);
            AssistCustomizedTypeInfo type = prop.getCustomizedType();
            if (type.getDataType() != AssistCustomizedDataTypeEnum.ENUM) continue;
            try {
                List enumList = EnumUtils.getEnumList(Class.forName(type.getDefaultQueryName()));
                Iterator it = enumList.iterator();
                ArrayList eList = new ArrayList();
                while (it.hasNext()) {
                    Enum e = (Enum)it.next();
                    HashMap<String, Object> eMap = new HashMap<String, Object>();
                    eMap.put("alias", e.getAlias());
                    eMap.put("value", e instanceof IntEnum ? Integer.valueOf(((IntEnum)e).getValue()) : (e instanceof StringEnum ? ((StringEnum)e).getValue() : null));
                    eList.add(eMap);
                }
                type.put("enumsource", eList);
                continue;
            }
            catch (Exception e) {
                throw new BOSException("", (Throwable)e);
            }
        }
        return coll;
    }

    private void setExchangeRate(Context ctx, VoucherInfo voucherInfo, VoucherEntryInfo entryInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = voucherInfo.getCompany();
        boolean isAdjustment = voucherInfo.getSourceType() == SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT;
        ObjectUuidPK baseExchangeTableId = new ObjectUuidPK(isAdjustment && company.getAdjustExchangeTable() != null ? company.getAdjustExchangeTable().getId() : company.getBaseExchangeTable().getId());
        if (entryInfo.getCurrency() == null) {
            entryInfo.setCurrency(company.getBaseCurrency());
        }
        ObjectUuidPK currencyId = new ObjectUuidPK(entryInfo.getCurrency().getId());
        ObjectUuidPK baseCurrencyId = new ObjectUuidPK(company.getBaseCurrency().getId());
        this.cacheExchangeRate(ctx, baseExchangeTableId, currencyId, baseCurrencyId, voucherInfo.getBookedDate(), this.exchangeRateCache);
        if (company.getReportExchangeTable() != null && company.getReportCurrency() != null) {
            ObjectUuidPK rptExchangeTableId = new ObjectUuidPK(company.getReportExchangeTable().getId());
            ObjectUuidPK rptCurrencyId = new ObjectUuidPK(company.getReportCurrency().getId());
            ObjectUuidPK srcCurrencyId = company.getReportConvertMode() == ReportCurrencyConvertMode.Base ? baseCurrencyId : currencyId;
            this.cacheExchangeRate(ctx, rptExchangeTableId, srcCurrencyId, rptCurrencyId, voucherInfo.getBookedDate(), this.exchangeRateCache);
        }
    }

    private void cacheExchangeRate(Context ctx, ObjectUuidPK exchangeTableId, ObjectUuidPK srcCurrencyId, ObjectUuidPK targetCurrencyId, Date date, Map exchangeRateCache) throws EASBizException, BOSException {
        String key = exchangeTableId + "_" + srcCurrencyId + "_" + targetCurrencyId;
        if (exchangeRateCache.get(key) == null) {
            ExchangeRateInfo exRate = null;
            if (srcCurrencyId.equals((Object)targetCurrencyId)) {
                exRate = new ExchangeRateInfo();
                exRate.setConvertRate(new BigDecimal("1"));
                ExchangeAuxInfo aux = new ExchangeAuxInfo();
                aux.setExchangeRateType(ExchangeTypeEnum.FIXEXCHANGERATE);
                aux.setPrecision(2);
                exRate.setExchangeAux(aux);
            } else {
                exRate = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateConvertInfo((IObjectPK)exchangeTableId, (IObjectPK)srcCurrencyId, (IObjectPK)targetCurrencyId, date);
            }
            exchangeRateCache.put(key, exRate);
        }
    }
}

