/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.asstf7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AsstDataChangeEvent;
import com.kingdee.eas.fi.gl.AsstDataChangeResult;
import com.kingdee.eas.fi.gl.AsstF7Config;
import com.kingdee.eas.fi.gl.app.asstf7.AsstDataChangeConfig;
import com.kingdee.eas.fi.gl.app.asstf7.AsstF7ConfigInfo;
import com.kingdee.eas.fi.gl.app.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.app.asstf7.IAsstDataChangeListener;
import com.kingdee.eas.fi.gl.app.asstf7.IAsstF7Filter;
import com.kingdee.eas.fi.gl.app.asstf7.IAsstF7Processor;
import com.kingdee.eas.fi.gl.app.asstf7.ProfessionalF7Config;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AsstF7ConfigFactory {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.AsstF7Deploy");
    private static Map<String, String> queryNameConfig = new HashMap<String, String>();
    private static Map<String, ProfessionalF7Config> professionalF7Config;
    private static Map<String, String> autoCompleteItemConfig;
    private static Map<String, String> filterClassNameConfig;
    private static Map<String, List<AsstDataChangeConfig>> dataChangeConfig;
    private static Map<String, AsstF7ConfigInfo> asstF7Configs;

    private static void initDefaultDataChangeConfig() {
        ArrayList<AsstDataChangeConfig> configList = new ArrayList<AsstDataChangeConfig>();
        configList.add(new AsstDataChangeConfig("costOrg", "profitOrg", "com.kingdee.eas.fi.gl.app.asstf7.CostCenterOrgChangedListener", 1));
        dataChangeConfig.put("costOrg", configList);
        configList = new ArrayList();
        configList.add(new AsstDataChangeConfig("profitOrg", "costOrg", "com.kingdee.eas.fi.gl.app.asstf7.ProfitCenterOrgChangedListener", 1));
        dataChangeConfig.put("profitOrg", configList);
        configList = new ArrayList();
        configList.add(new AsstDataChangeConfig("bankAccount", "region", "com.kingdee.eas.fi.gl.app.asstf7.BankAccountChangedListener", 2));
        dataChangeConfig.put("bankAccount", configList);
        configList = new ArrayList();
        configList.add(new AsstDataChangeConfig("region", "bankAccount", "com.kingdee.eas.fi.gl.app.asstf7.BankChangedListener", 2));
        dataChangeConfig.put("region", configList);
        configList = new ArrayList();
        configList.add(new AsstDataChangeConfig("person", "adminOrg", "com.kingdee.eas.fi.gl.app.asstf7.PersonWithAdminOrgChangeListener", 0));
        configList.add(new AsstDataChangeConfig("person", "costOrg", "com.kingdee.eas.fi.gl.app.asstf7.PersonWithCostOrgChangeListener", 0));
        dataChangeConfig.put("person", configList);
    }

    public static Map<String, AsstDataChangeResult> dataChanged(Context ctx, String asstName, String[] relatedAsstNames, AsstDataChangeEvent event) throws BOSException, EASBizException {
        List<AsstDataChangeConfig> cfs = AsstF7ConfigFactory.getAsstDataChangeConfigList(ctx, asstName);
        HashMap<String, AsstDataChangeResult> results = new HashMap<String, AsstDataChangeResult>();
        block2: for (int i = 0; i < relatedAsstNames.length; ++i) {
            if (cfs == null || relatedAsstNames == null) continue;
            for (AsstDataChangeConfig cf : cfs) {
                if (!relatedAsstNames[i].equals(cf.getRelatedAsstName())) continue;
                IAsstDataChangeListener l = null;
                try {
                    if (cf.getDataChangelistener() != null) {
                        l = (IAsstDataChangeListener)Class.forName(cf.getDataChangelistener()).newInstance();
                    }
                }
                catch (Exception e) {
                    throw new BOSException("newInstance error!", (Throwable)e);
                }
                if (l == null) continue block2;
                results.put(relatedAsstNames[i], l.dataChanged(ctx, event));
                continue block2;
            }
        }
        return results;
    }

    public static AsstF7Config getAsstF7Config(Context ctx, String actTypeName, GLF7Parameter param) throws BOSException {
        if (asstF7Configs == null) {
            AsstF7ConfigFactory.initAsstF7Config(ctx);
        }
        if (actTypeName == null) {
            return null;
        }
        AsstF7ConfigInfo configInfo = asstF7Configs.get(ctx.getAIS() + "_" + actTypeName);
        AsstF7Config config = new AsstF7Config();
        if (configInfo == null) {
            AsstF7ConfigFactory.initAsstF7Config(ctx);
            configInfo = asstF7Configs.get(ctx.getAIS() + "_" + actTypeName);
        }
        if (configInfo != null) {
            HashMap<String, Object> option;
            if (configInfo.getFilterClassName() != null) {
                AsstF7ConfigFactory.resetConfigFilter(ctx, param, configInfo, config);
            }
            String cuId = "";
            if (param.getCompanyIdSet().size() > 0) {
                try {
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(param.getCompanyIdSet().toArray()[0].toString()));
                    cuId = company.getCU().getId().toString();
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
            config.setQueryName(configInfo.getActTypeInfo().getDefaultQueryName());
            config.setDispalyFields(configInfo.getDispalyFields());
            config.setAutoCompleteItem(configInfo.getAutoCompleteItem());
            config.setProfessionalF7Name(configInfo.getProfessionalF7Name());
            config.setProfessionalF7Module(configInfo.getProfessionalF7Module());
            config.setOption(configInfo.getOption());
            if (!StringUtils.isEmpty((String)cuId)) {
                if (config.getOption() != null) {
                    config.getOption().put("curCUId", cuId);
                } else {
                    option = new HashMap<String, Object>();
                    option.put("curCUId", cuId);
                    config.setOption(option);
                }
            }
            if (actTypeName.contains("Org") || actTypeName.contains("org")) {
                if (config.getOption() != null) {
                    config.getOption().put("isCUFilter", true);
                    config.getOption().put("isShowAllBox", true);
                } else {
                    option = new HashMap();
                    option.put("isCUFilter", true);
                    option.put("isShowAllBox ", true);
                    config.setOption(option);
                }
            }
            if (!param.isEditUI()) {
                if (config.getOption() != null) {
                    config.getOption().put("isShowSealUpBox", true);
                } else {
                    option = new HashMap();
                    option.put("isShowSealUpBox", true);
                    config.setOption(option);
                }
            }
            if (actTypeName.startsWith("generalAssActType")) {
                HashMap<String, String> genTypeOpts = new HashMap<String, String>();
                genTypeOpts.put("groupid", configInfo.getActTypeInfo().getGlAsstActTypeGrp().getId().toString());
                genTypeOpts.put("isGeneralAssActType", "true");
                config.setOption(genTypeOpts);
            }
        }
        return config;
    }

    public static Map<String, AsstF7Config> getAsstF7Configs(Context ctx, String[] asstHGAttributes, GLF7Parameter param) throws BOSException {
        if (asstF7Configs == null) {
            AsstF7ConfigFactory.initAsstF7Config(ctx);
        }
        HashMap<String, AsstF7Config> configs = new HashMap<String, AsstF7Config>();
        for (int i = 0; i < asstHGAttributes.length; ++i) {
            String hgAttr = asstHGAttributes[i];
            AsstF7ConfigInfo configInfo = asstF7Configs.get(ctx.getAIS() + "_" + hgAttr);
            if (configInfo == null) {
                AsstF7ConfigFactory.initAsstF7Config(ctx);
                configInfo = asstF7Configs.get(ctx.getAIS() + "_" + hgAttr);
            }
            AsstF7Config config = new AsstF7Config();
            if (configInfo != null) {
                if (configInfo.getFilterClassName() != null) {
                    AsstF7ConfigFactory.resetConfigFilter(ctx, param, configInfo, config);
                }
                config.setQueryName(configInfo.getActTypeInfo().getDefaultQueryName());
                config.setDispalyFields(configInfo.getDispalyFields());
                config.setAutoCompleteItem(configInfo.getAutoCompleteItem());
                config.setProfessionalF7Name(configInfo.getProfessionalF7Name());
                config.setProfessionalF7Module(configInfo.getProfessionalF7Module());
                config.setOption(configInfo.getOption());
                if (!param.isEditUI()) {
                    if (config.getOption() != null) {
                        config.getOption().put("isShowSealUpBox", true);
                    } else {
                        HashMap<String, Boolean> option = new HashMap<String, Boolean>();
                        option.put("isShowSealUpBox", true);
                        config.setOption(option);
                    }
                }
                if (hgAttr.startsWith("generalAssActType")) {
                    HashMap<String, String> genTypeOpts = new HashMap<String, String>();
                    genTypeOpts.put("groupid", configInfo.getActTypeInfo().getGlAsstActTypeGrp().getId().toString());
                    config.setOption(genTypeOpts);
                }
            }
            configs.put(hgAttr, config);
        }
        return configs;
    }

    private static void resetConfigFilter(Context ctx, GLF7Parameter param, AsstF7ConfigInfo configInfo, AsstF7Config config) {
        try {
            IAsstF7Filter fi = (IAsstF7Filter)Class.forName(configInfo.getFilterClassName()).newInstance();
            FilterInfo filter = fi.getFilter(ctx, configInfo.getActTypeInfo(), param);
            if (filter != null) {
                config.setFilterItem(filter.toString());
            }
            if (fi instanceof IAsstF7Processor) {
                ((IAsstF7Processor)((Object)fi)).doProcessor(ctx, configInfo, param);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Class forName newInstance error!", (Throwable)e);
        }
    }

    public static List<AsstDataChangeConfig> getAsstDataChangeConfigList(Context ctx, String asstName) throws BOSException {
        if (dataChangeConfig == null) {
            AsstF7ConfigFactory.initDataChangeConfig(ctx);
        }
        return dataChangeConfig.get(asstName);
    }

    private static void initDataChangeConfig(Context ctx) throws BOSException {
        dataChangeConfig = new HashMap<String, List<AsstDataChangeConfig>>();
        AsstF7ConfigFactory.initDefaultDataChangeConfig();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FSrcAsstName, FDestAsstName, FListenerClassName, FForceValue from T_GL_AsstF7DatachangeListener");
            while (rs.next()) {
                String srcAsstName = rs.getString("FSrcAsstName");
                String destAsstName = rs.getString("FDestAsstName");
                String listenerName = rs.getString("FListenerClassName");
                int forceValue = rs.getInt("FForceValue");
                if (srcAsstName == null || destAsstName == null || listenerName == null) continue;
                AsstDataChangeConfig cf = new AsstDataChangeConfig(srcAsstName, destAsstName, listenerName, forceValue);
                List<AsstDataChangeConfig> data = dataChangeConfig.get(srcAsstName);
                if (data == null) {
                    data = new ArrayList<AsstDataChangeConfig>();
                    dataChangeConfig.put(srcAsstName, data);
                }
                data.add(cf);
            }
        }
        catch (Exception e) {
            logger.error((Object)"SQLException", (Throwable)e);
        }
    }

    private static void initAsstF7Config(Context ctx) throws BOSException {
        if (asstF7Configs == null) {
            asstF7Configs = new HashMap<String, AsstF7ConfigInfo>();
        }
        AsstF7ConfigFactory.initDefaultFilterClass(ctx);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FAsstName,FFilterClassName,FDispalyFields from T_GL_Asstf7config");
            while (rs.next()) {
                String asstName = rs.getString("FAsstName");
                String filterClassName = rs.getString("FFilterClassName");
                String dispalyFields = rs.getString("FDispalyFields");
                if (asstName == null) continue;
                AsstF7ConfigInfo cf = asstF7Configs.get(ctx.getAIS() + "_" + asstName);
                cf.setFilterClassName(filterClassName);
                cf.setDispalyFields(dispalyFields);
            }
        }
        catch (Exception e) {
            logger.error((Object)"SQLException", (Throwable)e);
        }
    }

    private static void initDefaultFilterClass(Context ctx) throws BOSException {
        AsstActTypeCollection typeColl = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection();
        for (int i = 0; i < typeColl.size(); ++i) {
            AsstActTypeInfo actType = typeColl.get(i);
            String asstName = actType.getAsstHGAttribute();
            if (asstName.startsWith("generalAssActType")) {
                asstName = "generalAssActType";
            }
            if (queryNameConfig.get(asstName) != null) {
                actType.setDefaultQueryName(queryNameConfig.get(asstName));
            }
            Map option = null;
            String professionalF7Name = null;
            String professionalF7Module = null;
            ProfessionalF7Config pf7 = professionalF7Config.get(asstName);
            if (pf7 != null) {
                professionalF7Name = pf7.getName();
                professionalF7Module = pf7.getModule();
                option = pf7.getOption();
            }
            asstF7Configs.put(ctx.getAIS() + "_" + actType.getAsstHGAttribute(), new AsstF7ConfigInfo(actType, null, autoCompleteItemConfig.get(asstName), filterClassNameConfig.get(asstName), professionalF7Name, professionalF7Module, option));
        }
    }

    static {
        queryNameConfig.put("customer", "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery");
        queryNameConfig.put("supplier", "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery");
        queryNameConfig.put("provider", "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery");
        queryNameConfig.put("material", "com.kingdee.eas.basedata.master.material.app.F7MaterialFIQuery");
        professionalF7Config = new HashMap<String, ProfessionalF7Config>();
        professionalF7Config.put("generalAssActType", new ProfessionalF7Config("wafPromptSpecial_GeneralAsstActType", "promptSpecial_GeneralAsstActType"));
        professionalF7Config.put("customer", new ProfessionalF7Config("wafPromptSpecial_Customer", "promptSpecial_Customer"));
        professionalF7Config.put("supplier", new ProfessionalF7Config("wafPromptSpecial_Supplier", "promptSpecial_Supplier"));
        professionalF7Config.put("provider", new ProfessionalF7Config("wafPromptSpecial_Supplier", "promptSpecial_Supplier"));
        professionalF7Config.put("material", new ProfessionalF7Config("wafPromptSpecial_Material", "promptSpecial_Material"));
        HashMap<String, Boolean> personOpts = new HashMap<String, Boolean>();
        personOpts.put("defaultShowAll", false);
        personOpts.put("allAdmin", true);
        personOpts.put("showAllChildren", true);
        professionalF7Config.put("person", new ProfessionalF7Config("wafPromptSpecial_Person", "promptSpecial_Person", personOpts));
        HashMap<String, String> saleOrgOpts = new HashMap<String, String>();
        saleOrgOpts.put("orgType", OrgType.Sale.getName());
        professionalF7Config.put("saleOrg", new ProfessionalF7Config("wafPromptSpecial_Org", "promptSpecial_Org", saleOrgOpts));
        HashMap<String, String> purchaseOrgOpts = new HashMap<String, String>();
        purchaseOrgOpts.put("orgType", OrgType.Purchase.getName());
        professionalF7Config.put("purchaseOrg", new ProfessionalF7Config("wafPromptSpecial_Org", "promptSpecial_Org", purchaseOrgOpts));
        HashMap<String, String> storeageOrgOpts = new HashMap<String, String>();
        storeageOrgOpts.put("orgType", OrgType.Storage.getName());
        professionalF7Config.put("storeageOrg", new ProfessionalF7Config("wafPromptSpecial_Org", "promptSpecial_Org", storeageOrgOpts));
        HashMap<String, String> costOrgOpts = new HashMap<String, String>();
        costOrgOpts.put("orgType", OrgType.CostCenter.getName());
        professionalF7Config.put("costOrg", new ProfessionalF7Config("wafPromptSpecial_Org", "promptSpecial_Org", costOrgOpts));
        HashMap<String, String> profitOrgOpts = new HashMap<String, String>();
        profitOrgOpts.put("orgType", OrgType.ProfitCenter.getName());
        professionalF7Config.put("profitOrg", new ProfessionalF7Config("wafPromptSpecial_Org", "promptSpecial_Org", profitOrgOpts));
        HashMap<String, String> companyOrgOpts = new HashMap<String, String>();
        companyOrgOpts.put("orgType", OrgType.Company.getName());
        professionalF7Config.put("companyOrg", new ProfessionalF7Config("wafPromptSpecial_Org", "promptSpecial_Org", companyOrgOpts));
        HashMap<String, String> orgUnitOpts = new HashMap<String, String>();
        orgUnitOpts.put("orgType", OrgType.Company.getName());
        professionalF7Config.put("orgUnit", new ProfessionalF7Config("wafPromptSpecial_Org", "promptSpecial_Org", orgUnitOpts));
        HashMap<String, String> adminOrgOpts = new HashMap<String, String>();
        adminOrgOpts.put("orgType", OrgType.Admin.getName());
        adminOrgOpts.put("isShowVirtualBox", "true");
        professionalF7Config.put("adminOrg", new ProfessionalF7Config("wafPromptSpecial_Org", "promptSpecial_Org", adminOrgOpts));
        autoCompleteItemConfig = new HashMap<String, String>();
        autoCompleteItemConfig.put("generalAssActType", "number+name");
        filterClassNameConfig = new HashMap<String, String>();
        filterClassNameConfig.put("generalAssActType", "com.kingdee.eas.fi.gl.app.asstf7.GeneralAssActTypeFilter");
        filterClassNameConfig.put("customer", "com.kingdee.eas.fi.gl.app.asstf7.CustomerFilter");
        filterClassNameConfig.put("supplier", "com.kingdee.eas.fi.gl.app.asstf7.SupplierFilter");
        filterClassNameConfig.put("provider", "com.kingdee.eas.fi.gl.app.asstf7.SupplierFilter");
        filterClassNameConfig.put("material", "com.kingdee.eas.fi.gl.app.asstf7.MaterialFilter");
        filterClassNameConfig.put("innerAccount", "com.kingdee.eas.fi.gl.app.asstf7.InnerAccountFilter");
        filterClassNameConfig.put("bankAccount", "com.kingdee.eas.fi.gl.app.asstf7.BankAccountFilter");
        filterClassNameConfig.put("fpItem", "com.kingdee.eas.fi.gl.app.asstf7.FpItemFilter");
        filterClassNameConfig.put("city", "com.kingdee.eas.fi.gl.app.asstf7.CityFilter");
        filterClassNameConfig.put("province", "com.kingdee.eas.fi.gl.app.asstf7.ProvinceFilter");
        filterClassNameConfig.put("region", "com.kingdee.eas.fi.gl.app.asstf7.RegionFilter");
        filterClassNameConfig.put("ntType", "com.kingdee.eas.fi.gl.app.asstf7.NtTypeFilter");
        filterClassNameConfig.put("bank", "com.kingdee.eas.fi.gl.app.asstf7.BankFilter");
        filterClassNameConfig.put("project", "com.kingdee.eas.fi.gl.app.asstf7.ProjectFilter");
        filterClassNameConfig.put("cashFlowItem", "com.kingdee.eas.fi.gl.app.asstf7.CashFlowItemFilter");
        filterClassNameConfig.put("costObject", "com.kingdee.eas.fi.gl.app.asstf7.CostObjectFilter");
        filterClassNameConfig.put("costItem", "com.kingdee.eas.fi.gl.app.asstf7.CostItemFilter");
        filterClassNameConfig.put("person", "com.kingdee.eas.fi.gl.app.asstf7.PersonFilter");
        filterClassNameConfig.put("adminOrg", "com.kingdee.eas.fi.gl.app.asstf7.AdminOrgFilter");
        filterClassNameConfig.put("companyOrg", "com.kingdee.eas.fi.gl.app.asstf7.CompanyOrgFilter");
        filterClassNameConfig.put("orgUnit", "com.kingdee.eas.fi.gl.app.asstf7.CompanyOrgFilter");
        filterClassNameConfig.put("costOrg", "com.kingdee.eas.fi.gl.app.asstf7.CostCenterOrgFilter");
        filterClassNameConfig.put("saleOrg", "com.kingdee.eas.fi.gl.app.asstf7.SaleOrgFilter");
        filterClassNameConfig.put("profitOrg", "com.kingdee.eas.fi.gl.app.asstf7.ProfitCenterOrgFilter");
        filterClassNameConfig.put("purchaseOrg", "com.kingdee.eas.fi.gl.app.asstf7.PurchaseOrgFilter");
        filterClassNameConfig.put("storeageOrg", "com.kingdee.eas.fi.gl.app.asstf7.StorageOrgFilter");
    }
}

