/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.asstf7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.DataBaseDUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;

public class AsstF7Utils {
    protected static FilterInfo getDatabaseDFilter(Context ctx, Set<String> companyIdSet, BOSObjectType bosType) throws BOSException, EASBizException {
        String idFieldName = "id";
        String cuFieldName = "cu.id";
        IObjectPK[] CUPKs = AsstF7Utils.getCUPKs(ctx, companyIdSet);
        return DataBaseDUtil.getDatabaseDFilter((Context)ctx, (BOSObjectType)bosType, (IObjectPK[])CUPKs, (String)idFieldName, (String)cuFieldName);
    }

    protected static String getDelegateFilter(Set<String> companyIdSet, OrgType orgType) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select rel.ffromunitid from T_ORG_UnitRelation rel ");
        sql.append(" inner join t_org_typerelation typeRel on typeRel.fid = rel.ftyperelationid ");
        sql.append(" and rel.ftounitid in (").append(AsstF7Utils.toCompanyIds(companyIdSet)).append(")");
        sql.append(" and typeRel.ftotype = ").append(1);
        sql.append(" and typeRel.ffromtype = ").append(orgType.getValue());
        return sql.toString();
    }

    protected static String getDelegateFilterForPca(Set<String> companyIdSet, OrgType orgType) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select rel.ffromunitid from T_ORG_UnitRelation rel ");
        sql.append(" inner join t_org_typerelation typeRel on typeRel.fid = rel.ftyperelationid ");
        sql.append(" and rel.ftounitid in (").append(AsstF7Utils.toCompanyIds(companyIdSet)).append(")");
        sql.append(" and typeRel.ftotype = ").append(6);
        sql.append(" and typeRel.ffromtype = ").append(orgType.getValue());
        return sql.toString();
    }

    private static String toCompanyIds(Set<String> companyIdSet) {
        StringBuffer sql = new StringBuffer();
        Iterator<String> it = companyIdSet.iterator();
        while (it.hasNext()) {
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append("'").append(it.next()).append("'");
        }
        return sql.toString();
    }

    protected static IObjectPK[] getCUPKs(Context ctx, Set<String> companyIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("CU.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companyIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        IObjectPK[] CUPKs = new IObjectPK[companyColl.size()];
        for (int i = 0; i < companyColl.size(); ++i) {
            CUPKs[i] = new ObjectUuidPK(companyColl.get(i).getCU().getId());
        }
        return CUPKs;
    }

    protected static AdminOrgUnitInfo getPrimaryAdminOrgUnit(Context ctx, String personId) throws BOSException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select p.fadminorgunitid from t_org_PositionMember pm inner join t_org_Position p on p.fid = pm.fpositionid where pm.fisPrimary = 1 and pm.fpersonid = ?", (Object[])new String[]{personId});
        try {
            String adminOrgId;
            if (rs.next() && !StringUtils.isEmpty((String)(adminOrgId = rs.getString("fadminorgunitid")))) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("name"));
                selector.add(new SelectorItemInfo("number"));
                selector.add(new SelectorItemInfo("displayName"));
                return AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgId), selector);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

