/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.asstf7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.app.asstf7.IAsstF7Filter;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ProjectFilter
implements IAsstF7Filter {
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.asstf7.ProjectFilter");

    @Override
    public FilterInfo getFilter(Context ctx, AsstActTypeInfo asstActTypeInfo, GLF7Parameter param) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        if (param.isEditUI() || param.isOnlyLeaf()) {
            fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        }
        if (param.isEditUI()) {
            fic.add(new FilterItemInfo("status", (Object)new Integer(2), CompareType.NOTEQUALS));
        }
        String projectIsolate = this.getProjectIsolateParam(ctx);
        if (asstActTypeInfo.isIsForCompany() || "1".equals(projectIsolate)) {
            fic.add(new FilterItemInfo("company.id", param.getCompanyIdSet(), CompareType.INCLUDE));
        } else if ("2".equals(projectIsolate)) {
            StringBuffer itemStr = new StringBuffer();
            Iterator<String> iter = param.getCompanyIdSet().iterator();
            while (iter.hasNext()) {
                itemStr.append("'").append(iter.next()).append("'");
                if (!iter.hasNext()) continue;
                itemStr.append(",");
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select flongnumber from t_org_baseunit where fid in (").append(itemStr.toString()).append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashSet<String> numberSet = new HashSet<String>();
            try {
                while (rs != null && rs.next()) {
                    String longNumber = rs.getString("flongnumber");
                    String[] numberArr = longNumber.split("!");
                    numberSet.addAll(Arrays.asList(numberArr));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (numberSet != null && numberSet.size() > 0) {
                fic.add(new FilterItemInfo("company.number", numberSet, CompareType.INCLUDE));
            }
        }
        return filter;
    }

    private String getProjectIsolateParam(Context ctx) {
        String value = null;
        IParamControl iParam = null;
        try {
            iParam = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
            value = iParam.getParamValue(null, "ProjectIsolate");
            if (value == null) {
                value = "false";
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return value;
    }
}

