/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.check;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.eas.fi.gl.check.CheckResult;
import com.kingdee.eas.fi.gl.check.ResultStatusCode;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CheckAppUtil {
    private static String resClassName = "com.kingdee.eas.fi.gl.check.CheckSchemeRes";

    public static IQueryExecutor getQueryExecutor(Context ctx, String query, String oql) throws BOSException {
        IMetaDataPK queryPK = MetaDataPKFactory.getMetaDataPK((String)query);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(oql);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnoreRowCount = true;
        exec.option().isIgnorePermissionCheck = true;
        exec.option().pageCount = KDTDataRequestManager.defaultPageRow;
        return exec;
    }

    public static String getTempTableByIds(Context ctx, List<String> ids) throws Exception {
        String createTableSql = "create table check_temp_table (fid varchar(44))";
        String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
        String sql = "insert into " + tempTable + " values(?)";
        ArrayList<String[]> paramsList = new ArrayList<String[]>();
        for (String id : ids) {
            paramsList.add(new String[]{id});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        return tempTable;
    }

    public static CheckResult failResult(String message) {
        CheckResult result = new CheckResult(ResultStatusCode.FAILD, message);
        return result;
    }

    public static CheckResult successResult(String message) {
        CheckResult result = new CheckResult(ResultStatusCode.SUCCESS, message);
        return result;
    }

    public static String getResource(String resourceName, Locale locale) {
        return ResourceBase.getString((String)resClassName, (String)resourceName, (Locale)locale);
    }

    public static String getResource(String resourceName, Locale locale, Object[] params) {
        return ResourceBase.getString((String)resClassName, (String)resourceName, (Locale)locale, (Object[])params);
    }

    public static String getResource(Context ctx, String resourceName) {
        return ResourceBase.getString((String)resClassName, (String)resourceName, (Locale)ctx.getLocale());
    }

    public static String getResource(Context ctx, String resourceName, Object[] params) {
        return ResourceBase.getString((String)resClassName, (String)resourceName, (Locale)ctx.getLocale(), (Object[])params);
    }
}

