/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.check;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.check.CheckAppUtil;
import com.kingdee.eas.fi.gl.app.check.CheckTask;
import com.kingdee.eas.fi.gl.check.CheckResult;
import com.kingdee.eas.fi.gl.check.CheckSchemeInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeJobFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeJobInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeJobStatus;
import com.kingdee.eas.fi.gl.check.ResultStatusCode;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class CheckJobService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.check.CheckJobService");

    public static IObjectPK createRunningJobInfo(Context ctx, CheckTask checkTask) throws BOSException, EASBizException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        CheckSchemeJobInfo checkSchemeJobInfo = new CheckSchemeJobInfo();
        checkSchemeJobInfo.setJobName(checkTask.getTaskName());
        checkSchemeJobInfo.setOrg(checkTask.getFullOrgUnitInfo());
        checkSchemeJobInfo.setScheme(checkTask.getCheckSchemeInfo());
        checkSchemeJobInfo.setStartTime(new Timestamp(new Date().getTime()));
        checkSchemeJobInfo.setEndTime(null);
        checkSchemeJobInfo.setStatus(CheckSchemeJobStatus.running);
        checkSchemeJobInfo.setExecutor(currentUserInfo);
        IObjectPK jobPk = CheckSchemeJobFactory.getLocalInstance(ctx).addnew(checkSchemeJobInfo);
        return jobPk;
    }

    public static void updateJobInfo(Context ctx, IObjectPK jobPk, CheckResult check) throws BOSException, EASBizException {
        CheckSchemeJobInfo checkSchemeJobInfo = CheckSchemeJobFactory.getLocalInstance(ctx).getCheckSchemeJobInfo(jobPk);
        checkSchemeJobInfo.setEndTime(new Timestamp(new Date().getTime()));
        checkSchemeJobInfo.setStatus(check.getStatusCode() == ResultStatusCode.SUCCESS ? CheckSchemeJobStatus.success : CheckSchemeJobStatus.failed);
        checkSchemeJobInfo.setResult(check.getMessage());
        CheckSchemeJobFactory.getLocalInstance(ctx).submit(checkSchemeJobInfo);
    }

    public static void updateFailedJobInfo(Context ctx, IObjectPK jobPk) {
        try {
            CheckSchemeJobInfo checkSchemeJobInfo = CheckSchemeJobFactory.getLocalInstance(ctx).getCheckSchemeJobInfo(jobPk);
            checkSchemeJobInfo.setEndTime(new Timestamp(new Date().getTime()));
            checkSchemeJobInfo.setStatus(CheckSchemeJobStatus.failed);
            checkSchemeJobInfo.setResult(CheckAppUtil.getResource(ctx, "jobRunException"));
            CheckSchemeJobFactory.getLocalInstance(ctx).submit(checkSchemeJobInfo);
        }
        catch (BOSException | EASBizException e) {
            logger.error((Object)"update job status exception.", e);
        }
    }

    public static IObjectPK createFinishedJobInfo(Context ctx, FullOrgUnitInfo fullOrgUnitInfo, CheckSchemeInfo checkSchemeInfo, CheckSchemeJobStatus jobStatus, String message) {
        IObjectPK jobPk = null;
        try {
            UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            CheckSchemeJobInfo checkSchemeJobInfo = new CheckSchemeJobInfo();
            checkSchemeJobInfo.setOrg(fullOrgUnitInfo);
            checkSchemeJobInfo.setScheme(checkSchemeInfo);
            checkSchemeJobInfo.setStartTime(new Timestamp(new Date().getTime()));
            checkSchemeJobInfo.setEndTime(new Timestamp(new Date().getTime()));
            checkSchemeJobInfo.setStatus(jobStatus);
            checkSchemeJobInfo.setExecutor(currentUserInfo);
            checkSchemeJobInfo.setResult(message);
            jobPk = CheckSchemeJobFactory.getLocalInstance(ctx).addnew(checkSchemeJobInfo);
        }
        catch (BOSException | EASBizException e) {
            logger.error((Object)"create job exception.", e);
        }
        return jobPk;
    }
}

