/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.check;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.check.CheckSchemeInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeScheduleInfo;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CheckScheduleUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.check.CheckScheduleUtil");
    private static String checkSchemeFunction = "com.kingdee.eas.fi.gl.app.check.startCheckSchemeBackTask";
    private static String checkSchemeFunctionMethod = "startBackTask";
    private static String checkSchemeParam = "checkSchemeId";
    private static String backTaskName = "ClosePeriodCheckScheme";

    public static String enableSchedule(Context ctx, CheckSchemeInfo checkSchemeInfo) throws EASBizException, BOSException {
        CheckSchemeScheduleInfo schedule = checkSchemeInfo.getSchedule();
        String jobDefID = schedule.getJobDefID();
        String scheduleXml = schedule.getSchemeXML();
        if (!StringUtils.isEmpty((String)jobDefID)) {
            EnactmentServiceFactory.createEnactService((Context)ctx).removeJobProcessDef(jobDefID);
        }
        FunctionObjectInfo function = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)MetaDataPK.create((String)checkSchemeFunction));
        OperationCollection operCol = function.getOperation();
        OperationInfo operation = null;
        int length = operCol.size();
        for (int i = 0; i < length; ++i) {
            if (!checkSchemeFunctionMethod.equalsIgnoreCase(operCol.get(i).getName())) continue;
            operation = operCol.get(i);
            break;
        }
        if (operation == null) {
            throw new BOSException("can not found method: " + checkSchemeFunctionMethod);
        }
        HashMap<String, Object> jobContext = new HashMap<String, Object>();
        jobContext.put(checkSchemeParam, checkSchemeInfo.getId().toString());
        jobContext.put("isRetainTime", true);
        jobContext.put("nonMutexCtrl", "true");
        String jobNumber = backTaskName + "_" + checkSchemeInfo.getNumber();
        jobDefID = EnactmentServiceFactory.createEnactService((Context)ctx).createJobProcessDef(jobNumber, function, operation, jobContext, scheduleXml, ctx.getLocale());
        return jobDefID;
    }

    public static void disableSchedule(Context ctx, CheckSchemeScheduleInfo schedule) throws EASBizException, BOSException {
        if (schedule == null) {
            return;
        }
        String jobDefID = schedule.getJobDefID();
        String scheduleXml = schedule.getSchemeXML();
        if (!StringUtils.isEmpty((String)jobDefID)) {
            EnactmentServiceFactory.createEnactService((Context)ctx).updateProcessSchedule(jobDefID, scheduleXml);
            EnactmentServiceFactory.createEnactService((Context)ctx).setProcessDefEnable(jobDefID, false);
        }
    }
}

