/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.check;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.check.AbstractCheckSchemeAssignFacadeControllerBean;
import com.kingdee.eas.fi.gl.check.CheckSchemeCollection;
import com.kingdee.eas.fi.gl.check.CheckSchemeFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeOrgRelationCollection;
import com.kingdee.eas.fi.gl.check.CheckSchemeOrgRelationFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeOrgRelationInfo;
import com.kingdee.eas.fi.gl.check.util.CheckUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CheckSchemeAssignFacadeControllerBean
extends AbstractCheckSchemeAssignFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.check.CheckSchemeAssignFacadeControllerBean");

    @Override
    protected IObjectCollection _getCheckSchemes(Context ctx, List orgIds, Map params) throws BOSException, EASBizException {
        if (orgIds == null || orgIds.size() <= 0) {
            return null;
        }
        CheckSchemeOrgRelationCollection csOrgRelationCol = this.queryCheckSchemeOrgRelation(ctx, orgIds);
        HashSet<String> checkSchemeIds = new HashSet<String>(csOrgRelationCol.size());
        for (int i = 0; i < csOrgRelationCol.size(); ++i) {
            CheckSchemeOrgRelationInfo checkSchemeOrgRelationInfo = csOrgRelationCol.get(i);
            checkSchemeIds.add(checkSchemeOrgRelationInfo.getSchemeId());
        }
        CheckSchemeCollection checkSchemeCollection = this.queryCheckScheme(ctx, params, checkSchemeIds);
        return checkSchemeCollection;
    }

    private CheckSchemeCollection queryCheckScheme(Context ctx, Map params, Set<String> checkSchemeIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("ctrlConfigType"));
        view.getSelector().add(new SelectorItemInfo("subSystem"));
        view.getSelector().add(new SelectorItemInfo("config.bizName"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("createOrg", (Object)CheckUtil.getCurrentOrgId(ctx)));
        view.setFilter(filterInfo);
        view.getSorter().add(new SorterItemInfo("number"));
        CheckSchemeCollection checkSchemeCollection = null;
        String queryType = (String)params.get("queryType");
        if ("1".equals(queryType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", checkSchemeIds, CompareType.INCLUDE));
        } else if ("2".equals(queryType)) {
            if (checkSchemeIds != null && checkSchemeIds.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", checkSchemeIds, CompareType.NOTINCLUDE));
            }
        } else {
            return null;
        }
        String searchFilterStr = (String)params.get("searchFilterStr");
        if (!StringUtils.isEmpty((String)searchFilterStr)) {
            String filterType = (String)params.get("searcheFilterType");
            if ("1".equals(filterType)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)CheckUtil.getSqlFulltLike(searchFilterStr), CompareType.LIKE));
            } else if ("2".equals(filterType)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)CheckUtil.getSqlFulltLike(searchFilterStr), CompareType.LIKE));
            }
        }
        checkSchemeCollection = CheckSchemeFactory.getLocalInstance(ctx).getCheckSchemeCollection(view);
        return checkSchemeCollection;
    }

    private CheckSchemeOrgRelationCollection queryCheckSchemeOrgRelation(Context ctx, List orgIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("schemeId"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgId", new HashSet(orgIds), CompareType.INCLUDE));
        view.setFilter(filterInfo);
        CheckSchemeOrgRelationCollection csOrgRelationCol = CheckSchemeOrgRelationFactory.getLocalInstance(ctx).getCollection(view);
        return csOrgRelationCol;
    }

    @Override
    protected void _assign(Context ctx, List orgIds, List checkSchemeIds) throws BOSException, EASBizException {
        this.assign(ctx, orgIds, checkSchemeIds, true);
    }

    @Override
    protected void _unAssign(Context ctx, List orgIds, List checkSchemeIds) throws BOSException, EASBizException {
        this.assign(ctx, orgIds, checkSchemeIds, false);
    }

    private void assign(Context ctx, List orgIds, List checkSchemeIds, boolean isAssign) throws BOSException, EASBizException {
        if (orgIds == null || orgIds.size() <= 0 || checkSchemeIds == null || checkSchemeIds.size() <= 0) {
            return;
        }
        EntityViewInfo checkSchemeView = new EntityViewInfo();
        FilterInfo checkSchemeFilter = new FilterInfo();
        checkSchemeFilter.getFilterItems().add(new FilterItemInfo("id", new HashSet(checkSchemeIds), CompareType.INCLUDE));
        checkSchemeView.setFilter(checkSchemeFilter);
        CheckSchemeCollection checkSchemeCollection = CheckSchemeFactory.getLocalInstance(ctx).getCheckSchemeCollection(checkSchemeView);
        List orgIdList = orgIds;
        StringBuilder sql = new StringBuilder();
        if (isAssign) {
            sql.append("insert into T_check_companySchemeRelation(FId,FOrgId,FCheckSchemeID,Fresponsibles,FSchemeStatus) ");
            sql.append("select distinct ?,?,?,?,? from T_Check_Config ");
            sql.append("where not exists(");
            sql.append("select 1 from T_check_companySchemeRelation ");
            sql.append("where forgId = ? and FCheckSchemeID = ? ");
            sql.append(") ");
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), (List)this.getSqlParamList(orgIdList, checkSchemeCollection, isAssign));
        } else {
            sql.append("delete from T_check_companySchemeRelation where FOrgId = ? and  FCheckSchemeID = ?");
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), (List)this.getSqlParamList(orgIdList, checkSchemeCollection, isAssign));
        }
    }

    private List getSqlParamList(List<String> orgIdList, CheckSchemeCollection checkSchemeList, boolean isAssign) {
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        CheckSchemeOrgRelationInfo csOrgRelationInfo = new CheckSchemeOrgRelationInfo();
        for (String orgId : orgIdList) {
            for (int i = 0; i < checkSchemeList.size(); ++i) {
                CheckSchemeInfo checkSchemeInfo = checkSchemeList.get(i);
                String id = BOSUuid.create((BOSObjectType)csOrgRelationInfo.getBOSType()).toString();
                String checkSchemeId = checkSchemeInfo.getId().toString();
                Object[] params = null;
                params = isAssign ? new Object[]{id, orgId, checkSchemeId, checkSchemeInfo.getResponsibles() != null ? checkSchemeInfo.getResponsibles().getId().toString() : null, checkSchemeInfo.getStatus().getValue(), orgId, checkSchemeId} : new String[]{orgId, checkSchemeId};
                paramList.add((String[])params);
            }
        }
        return paramList;
    }

    @Override
    protected void _assign(Context ctx, String orgId, String schemeId) throws BOSException, EASBizException {
        this._assign(ctx, Arrays.asList((Object[])new Object[]{orgId}), Arrays.asList((Object[])new Object[]{schemeId}));
    }
}

