/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.check;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.check.AbstractCheckSchemeJobControllerBean;
import com.kingdee.eas.fi.gl.check.CheckSchemeException;
import com.kingdee.eas.fi.gl.check.CheckSchemeFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeJobInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeOrgRelationFactory;
import com.kingdee.eas.fi.gl.check.CheckSchemeOrgRelationInfo;
import com.kingdee.eas.fi.gl.check.SchemeStatus;
import org.apache.log4j.Logger;

public class CheckSchemeJobControllerBean
extends AbstractCheckSchemeJobControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.check.CheckSchemeJobControllerBean");

    @Override
    protected void _check(Context ctx, String jobId) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("scheme.id"));
        selectors.add(new SelectorItemInfo("scheme.number"));
        selectors.add(new SelectorItemInfo("org.id"));
        selectors.add(new SelectorItemInfo("org.name"));
        CheckSchemeJobInfo checkSchemeJobInfo = super.getCheckSchemeJobInfo(ctx, (IObjectPK)new ObjectUuidPK(jobId), selectors);
        CheckSchemeInfo scheme = checkSchemeJobInfo.getScheme();
        if (scheme == null) {
            throw new CheckSchemeException(CheckSchemeException.SCHEMENOTEXISTS);
        }
        FullOrgUnitInfo org = checkSchemeJobInfo.getOrg();
        if (org == null) {
            throw new CheckSchemeException(CheckSchemeException.SCHEMENOASSIGNORG, new String[]{scheme.getNumber()});
        }
        CheckSchemeOrgRelationInfo csor = CheckSchemeOrgRelationFactory.getLocalInstance(ctx).getCheckSchemOrgRelationInfo(scheme.getId().toString(), org.getId().toString());
        if (csor == null) {
            throw new CheckSchemeException(CheckSchemeException.SCHEMENOASSIGNORG2, new String[]{scheme.getNumber(), org.getName()});
        }
        if (csor.getSchemeStatus() != SchemeStatus.enable) {
            throw new CheckSchemeException(CheckSchemeException.SCHEMEISNOTENABLE, new String[]{scheme.getNumber()});
        }
        CheckSchemeFactory.getLocalInstance(ctx).checkByOrgAndScheme(org.getId().toString(), scheme.getId().toString());
    }
}

