/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.check;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.fi.gl.app.check.CheckAppUtil;
import com.kingdee.eas.fi.gl.app.check.CheckJobService;
import com.kingdee.eas.fi.gl.app.check.CheckTask;
import com.kingdee.eas.fi.gl.app.check.MessageInfo;
import com.kingdee.eas.fi.gl.app.check.SendMessageUtil;
import com.kingdee.eas.fi.gl.check.CheckResult;
import com.kingdee.eas.fi.gl.check.CheckSchemeInfo;
import com.kingdee.eas.fi.gl.check.CheckSchemeJobStatus;
import com.kingdee.eas.fi.gl.check.CheckSchemeOrgRelationInfo;
import com.kingdee.eas.fi.gl.check.ClosePeriodCheckParam;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RunCheckTask
implements Runnable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.check.RunCheckTask");
    private Context ctx;
    private CheckTask checkTask;

    public RunCheckTask(Context ctx, CheckTask checkTask) {
        this.ctx = ctx;
        this.checkTask = checkTask;
    }

    @Override
    public void run() {
        this.runRask();
    }

    public void runRask() {
        IObjectPK jobPk = null;
        try {
            jobPk = CheckJobService.createRunningJobInfo(this.ctx, this.checkTask);
            ClosePeriodCheckParam closeCheckParam = new ClosePeriodCheckParam(this.ctx, this.checkTask.getFullOrgUnitInfo(), this.checkTask.getCheckSchemeInfo());
            CheckResult result = this.checkTask.getClosePeriodCheckProcessor().check(closeCheckParam);
            CheckJobService.updateJobInfo(this.ctx, jobPk, result);
            this.sendMessage(this.ctx, this.checkTask, result);
        }
        catch (Exception e) {
            logger.error((Object)"run check task exception.", (Throwable)e);
            if (jobPk != null) {
                CheckJobService.updateFailedJobInfo(this.ctx, jobPk);
            }
            CheckJobService.createFinishedJobInfo(this.ctx, this.checkTask.getFullOrgUnitInfo(), this.checkTask.getCheckSchemeInfo(), CheckSchemeJobStatus.failed, CheckAppUtil.getResource(this.ctx, "jobRunException"));
        }
    }

    private void sendMessage(Context ctx, CheckTask checkTask, CheckResult result) {
        CheckSchemeInfo checkSchemeInfo = checkTask.getCheckSchemeInfo();
        CheckSchemeOrgRelationInfo checkSchemeOrgRelationInfo = checkTask.getCheckSchemeOrgRelationInfo();
        String responsiblesId = checkSchemeOrgRelationInfo.getResponsibles();
        if (StringUtils.isEmpty((String)responsiblesId)) {
            return;
        }
        String[] receivers = new String[]{responsiblesId};
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setAllNotice(true);
        messageInfo.setTitle(CheckAppUtil.getResource(ctx, "messageTitle"));
        messageInfo.setBody(CheckAppUtil.getResource(ctx, "messageBody", (Object[])new String[]{checkTask.getTaskName(), checkSchemeInfo.getNumber() + " " + checkSchemeInfo.getName(), checkTask.getFullOrgUnitInfo().getName(), result.getMessage()}));
        HashMap<Locale, String> senderMap = new HashMap<Locale, String>();
        Locale locale1 = new Locale("l1");
        Locale locale2 = new Locale("l2");
        Locale locale3 = new Locale("l3");
        senderMap.put(locale1, CheckAppUtil.getResource("messageSender", locale1));
        senderMap.put(locale2, CheckAppUtil.getResource("messageSender", locale2));
        senderMap.put(locale3, CheckAppUtil.getResource("messageSender", locale3));
        messageInfo.setSender(senderMap);
        messageInfo.setSendCommonMsg(checkSchemeInfo.isSendMsg());
        messageInfo.setSendMsgTxt(checkSchemeInfo.isSendTxtMsg());
        messageInfo.setSendEmail(checkSchemeInfo.isSendEmail());
        try {
            SendMessageUtil.sendMessage(ctx, receivers, messageInfo);
        }
        catch (Exception e) {
            logger.error((Object)(checkSchemeInfo.getName() + " send message exception."), (Throwable)e);
        }
    }
}

