/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.dataImport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.CashflowGrpAsstCollection;
import com.kingdee.eas.fi.gl.CashflowGrpAsstFactory;
import com.kingdee.eas.fi.gl.CashflowGrpAsstInfo;
import com.kingdee.eas.fi.gl.CashflowInitCollection;
import com.kingdee.eas.fi.gl.CashflowInitFactory;
import com.kingdee.eas.fi.gl.CashflowInitInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.app.dataImport.DataImportUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.log.ExcelTaskLog;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.task.SuccessInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class CashFlowInitDataImport
extends BlockDataTransmission {
    public static String RESOURCE = "com.kingdee.eas.fi.gl.CashflowInitResource";
    public static String PERMISSIONITEM = "gl_cashflowinit_save";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CashflowInitFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public void submitBlock(Context ctx, Object o) throws TaskExternalException {
    }

    public boolean isSkipMainProcess() {
        return true;
    }

    public boolean isAfterAllProcess() {
        return true;
    }

    public Object transform(Context ctx, RecordCollection coll) throws TaskExternalException {
        IRecord record;
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
        HashMap<String, Boolean> permissionMap = new HashMap<String, Boolean>();
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        HashMap<String, CashFlowItemInfo> cashFlowItemMap = new HashMap<String, CashFlowItemInfo>();
        RecordCollection errorColl = new RecordCollection();
        HashMap<String, CashflowInitInfo> cashFlowInitMap = new HashMap<String, CashflowInitInfo>();
        int succInt = 0;
        for (int i = 0; i < coll.size(); ++i) {
            record = coll.get(i);
            try {
                CashflowInitInfo initInfo = null;
                String companyNumber = DataImportUtils.getValue(record, "FOrgUnitID");
                String cashFlowItemNumber = DataImportUtils.getValue(record, "FCashID");
                String currencyNumber = DataImportUtils.getValue(record, "FCurrency");
                CashflowInitInfo existInitInfo = (CashflowInitInfo)cashFlowInitMap.get(companyNumber + currencyNumber + cashFlowItemNumber);
                if (existInitInfo != null) {
                    initInfo = existInitInfo;
                } else {
                    initInfo = new CashflowInitInfo();
                    CompanyOrgUnitInfo company = null;
                    company = this.getCompanyInfo(ctx, companyNumber, companyMap);
                    if (company == null) {
                        record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"companyNumberIsNull", (Locale)ctx.getLocale(), (Object[])new Object[]{companyNumber}));
                        errorColl.add(record);
                        if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                        continue;
                    }
                    initInfo.setCompany(company);
                    Boolean isHasPerm = (Boolean)permissionMap.get(companyNumber);
                    if (isHasPerm == null) {
                        isHasPerm = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(company.getId().toString()), PERMISSIONITEM);
                        permissionMap.put(companyNumber, isHasPerm);
                    }
                    if (!isHasPerm.booleanValue()) {
                        record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"permissionError", (Locale)ctx.getLocale(), (Object[])new Object[]{companyNumber}));
                        errorColl.add(record);
                        if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                        continue;
                    }
                    CurrencyInfo currency = this.getCurrencyInfo(ctx, currencyNumber, currencyMap);
                    if (currency == null) {
                        record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"currencyError", (Locale)ctx.getLocale(), (Object[])new Object[]{currencyNumber}));
                        errorColl.add(record);
                        if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                        continue;
                    }
                    initInfo.setCurrency(currency);
                    CashFlowItemInfo cashFlowItem = this.getCashFlowItem(ctx, cashFlowItemNumber, cashFlowItemMap);
                    if (cashFlowItem == null) {
                        record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"cashFlowItemError", (Locale)ctx.getLocale(), (Object[])new Object[]{cashFlowItemNumber}));
                        errorColl.add(record);
                        if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                        continue;
                    }
                    initInfo.setCashflowItem(cashFlowItem);
                    if (cashFlowItem.isIsFreeze()) {
                        record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"cashFlowItemDisable", (Locale)ctx.getLocale(), (Object[])new Object[]{cashFlowItemNumber}));
                        errorColl.add(record);
                        if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                        continue;
                    }
                    if (!cashFlowItem.isIsLeaf()) {
                        record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"cashFlowItemIsNotLeaf", (Locale)ctx.getLocale(), (Object[])new Object[]{cashFlowItemNumber}));
                        errorColl.add(record);
                        if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                        continue;
                    }
                }
                BigDecimal org = DataImportUtils.getBigDecimalValue(record.get("For"));
                if (org == null) {
                    record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"orgError", (Locale)ctx.getLocale()));
                    errorColl.add(record);
                    if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                    continue;
                }
                BigDecimal local = DataImportUtils.getBigDecimalValue(record.get("Local"));
                if (local == null) {
                    record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"localError", (Locale)ctx.getLocale()));
                    errorColl.add(record);
                    if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                    continue;
                }
                BigDecimal rpt = BigDecimal.ZERO;
                if (initInfo.getCompany().getReportCurrency() != null && (rpt = DataImportUtils.getBigDecimalValue(record.get("Rpt"))) == null) {
                    record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"rptError", (Locale)ctx.getLocale()));
                    errorColl.add(record);
                    if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                    continue;
                }
                if (initInfo.getCashflowItem().isIsEnable() && initInfo.getCashflowItem().getAsstAccount() != null) {
                    CashflowGrpAsstInfo asstInfo = new CashflowGrpAsstInfo();
                    String type = DataImportUtils.getValue(record, "FType");
                    if (type == null) {
                        record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"typeError", (Locale)ctx.getLocale()));
                        errorColl.add(record);
                        if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                        continue;
                    }
                    if (ResourceBase.getString((String)RESOURCE, (String)"outer", (Locale)ctx.getLocale()).equals(type)) {
                        asstInfo.setType(CashflowTypeEnum.OUT);
                    } else if (ResourceBase.getString((String)RESOURCE, (String)"inner", (Locale)ctx.getLocale()).equals(type)) {
                        asstInfo.setType(CashflowTypeEnum.IN);
                    } else {
                        record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"typeError", (Locale)ctx.getLocale()));
                        errorColl.add(record);
                        if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                        continue;
                    }
                    String asstAccount = DataImportUtils.getValue(record, "FCAA");
                    if (asstAccount == null) {
                        record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"asstAccountError", (Locale)ctx.getLocale(), (Object[])new Object[]{asstAccount}));
                        errorColl.add(record);
                        if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                        continue;
                    }
                    if (initInfo.getCashflowItem().getAsstAccount() != null && initInfo.getCashflowItem().getAsstAccount().getNumber() != null && !initInfo.getCashflowItem().getAsstAccount().getNumber().equals(asstAccount)) {
                        record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"assAccountIsNotMatch", (Locale)ctx.getLocale(), (Object[])new Object[]{cashFlowItemNumber, asstAccount}));
                        errorColl.add(record);
                        if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                        continue;
                    }
                    AsstActGroupDetailCollection asstTypeColl = DataImportUtils.getAsstAccountDetailCollection(ctx, asstAccount);
                    if (asstTypeColl == null || asstTypeColl.size() == 0) {
                        record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"asstAccountError", (Locale)ctx.getLocale(), (Object[])new Object[]{asstAccount}));
                        errorColl.add(record);
                        if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                        continue;
                    }
                    boolean isAsstCorrect = true;
                    AssistantHGInfo hgInfo = new AssistantHGInfo();
                    AsstActTypeCollection items = new AsstActTypeCollection();
                    String asstAccountId = null;
                    for (int j = 0; j < asstTypeColl.size(); ++j) {
                        asstAccountId = asstTypeColl.get(j).getAsstAccount().getId().toString();
                        AsstActTypeInfo asstType = asstTypeColl.get(j).getAsstActType();
                        items.add(asstType);
                        int excelIndex = j + 1;
                        String asstTypeName = DataImportUtils.getValue(record, "FItem_" + excelIndex);
                        if (asstTypeName == null) {
                            record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"asstTypeError", (Locale)ctx.getLocale(), (Object[])new Object[]{asstTypeName}));
                            errorColl.add(record);
                            isAsstCorrect = false;
                            break;
                        }
                        if (!asstTypeName.equals(asstType.getName())) {
                            record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"asstTypeIsNotMatch", (Locale)ctx.getLocale(), (Object[])new Object[]{asstAccount}));
                            errorColl.add(record);
                            isAsstCorrect = false;
                            break;
                        }
                        String asstNumber = DataImportUtils.getValue(record, "FNumber_" + excelIndex);
                        String asstName = DataImportUtils.getValue(record, "FName_" + excelIndex);
                        if (asstNumber == null) {
                            record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"asstError", (Locale)ctx.getLocale(), (Object[])new Object[]{asstNumber}));
                            errorColl.add(record);
                            isAsstCorrect = false;
                            break;
                        }
                        DataBaseInfo data = GlWebServiceUtil.findAsstActObject(ctx, asstType.getAsstHGAttribute(), asstNumber, asstName, initInfo.getCompany().getCU().getId().toString(), initInfo.getCompany());
                        if (data == null) {
                            record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"asstError", (Locale)ctx.getLocale(), (Object[])new Object[]{asstNumber}));
                            errorColl.add(record);
                            isAsstCorrect = false;
                            break;
                        }
                        if (data instanceof AccountBankInfo && data.getBoolean("isClosed")) {
                            record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"asstDisable", (Locale)ctx.getLocale(), (Object[])new Object[]{asstNumber}));
                            errorColl.add(record);
                            isAsstCorrect = false;
                            break;
                        }
                        hgInfo.put(asstType.getAsstHGAttribute(), (Object)data);
                    }
                    if (!isAsstCorrect) {
                        if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                        continue;
                    }
                    AssistantHGInfo assGrp = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(hgInfo, asstAccountId, items);
                    asstInfo.setAssistGrp(assGrp);
                    asstInfo.setOriginalAmount(org);
                    asstInfo.setLocalAmount(local);
                    asstInfo.setReportingAmount(rpt);
                    boolean isExist = this.isExistCashFlowInitAsst(ctx, initInfo, asstInfo, cashFlowInitMap);
                    if (!this.isSltImportUpdate() && isExist) {
                        record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"sumbitError", (Locale)ctx.getLocale()));
                        errorColl.add(record);
                        if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                        continue;
                    }
                    ++succInt;
                    cashFlowInitMap.put(companyNumber + currencyNumber + cashFlowItemNumber, initInfo);
                    continue;
                }
                boolean isExist = this.isExistCashFlowInit(ctx, initInfo, cashFlowInitMap);
                if (!this.isSltImportUpdate() && isExist) {
                    record.setMsg(ResourceBase.getString((String)RESOURCE, (String)"sumbitError", (Locale)ctx.getLocale()));
                    errorColl.add(record);
                    if (this.errHandleMode != null && this.errHandleMode.getValue() == 1) break;
                    continue;
                }
                initInfo.setOriginalAmount(org);
                initInfo.setLocalAmount(local);
                initInfo.setReportingAmount(rpt);
                ++succInt;
                cashFlowInitMap.put(companyNumber + currencyNumber + cashFlowItemNumber, initInfo);
            }
            catch (Exception e) {
                record.setMsg(e.getMessage());
                errorColl.add(record);
                if (this.errHandleMode == null) continue;
                if (this.errHandleMode.getValue() == 1) break;
            }
        }
        Iterator it = cashFlowInitMap.values().iterator();
        try {
            while (it.hasNext()) {
                CashflowInitInfo initInfo = (CashflowInitInfo)it.next();
                if (initInfo.getCashflowGrpAsst() != null && initInfo.getCashflowGrpAsst().size() > 0) {
                    this.dealCashFlowInitAmountWithAssist(initInfo);
                }
                CashflowInitFactory.getLocalInstance(ctx).submit((CoreBaseInfo)initInfo);
                if (initInfo.getCashflowGrpAsst() == null) continue;
                for (int i = 0; i < initInfo.getCashflowGrpAsst().size(); ++i) {
                    CashflowGrpAsstFactory.getLocalInstance(ctx).submit((CoreBaseInfo)initInfo.getCashflowGrpAsst().get(i));
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        if (this.getLog() instanceof TaskLog) {
            TaskLog log = (TaskLog)this.getLog();
            log.setFailRecordCount(coll.size() - succInt);
            for (int i = 0; i < errorColl.size(); ++i) {
                this.writeLog(errorColl.get(i).getRowNum(), (Exception)new TaskExternalException(errorColl.get(i).getMsg()));
            }
        } else if (this.getLog() instanceof ExcelTaskLog) {
            record = coll.get(0);
            SuccessInfo result = new SuccessInfo(record.getFileUuId(), record.getSheetId(), succInt);
            ArrayList<SuccessInfo> successList = new ArrayList<SuccessInfo>();
            successList.add(result);
            this.writeLog(errorColl, successList);
        }
        return null;
    }

    private void dealCashFlowInitAmountWithAssist(CashflowInitInfo initInfo) {
        BigDecimal org = BigDecimal.ZERO;
        BigDecimal local = BigDecimal.ZERO;
        BigDecimal rpt = BigDecimal.ZERO;
        for (int i = 0; i < initInfo.getCashflowGrpAsst().size(); ++i) {
            CashflowGrpAsstInfo asstInfo = initInfo.getCashflowGrpAsst().get(i);
            if (asstInfo.getOriginalAmount() != null) {
                org = org.add(asstInfo.getOriginalAmount());
            }
            if (asstInfo.getLocalAmount() != null) {
                local = local.add(asstInfo.getLocalAmount());
            }
            if (asstInfo.getReportingAmount() == null) continue;
            rpt = rpt.add(asstInfo.getReportingAmount());
        }
        initInfo.setOriginalAmount(org);
        initInfo.setLocalAmount(local);
        initInfo.setReportingAmount(rpt);
    }

    private void dealCashFlowInItWithAssist(Context ctx, CashflowInitInfo initInfo) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("cflowInit.id", (Object)initInfo.getId().toString());
        view.setFilter(filter);
        CashflowGrpAsstCollection existAsstColl = CashflowGrpAsstFactory.getLocalInstance(ctx).getCashflowGrpAsstCollection(view);
        if (existAsstColl.size() > 0) {
            int i;
            CashflowGrpAsstCollection removeColl = new CashflowGrpAsstCollection();
            for (i = 0; i < initInfo.getCashflowGrpAsst().size(); ++i) {
                CashflowGrpAsstInfo asstInfo = initInfo.getCashflowGrpAsst().get(i);
                if (asstInfo.getId() == null) continue;
                for (int j = 0; j < existAsstColl.size(); ++j) {
                    CashflowGrpAsstInfo existAsst = existAsstColl.get(j);
                    if (!asstInfo.getId().equals((Object)existAsst.getId())) continue;
                    removeColl.add(existAsst);
                }
                initInfo.getCashflowGrpAsst().addCollection(existAsstColl);
            }
            for (i = 0; i < removeColl.size(); ++i) {
                existAsstColl.remove(removeColl.get(i));
            }
        }
        this.dealCashFlowInitAmountWithAssist(initInfo);
    }

    private boolean isExistCashFlowInitAsst(Context ctx, CashflowInitInfo initInfo, CashflowGrpAsstInfo asstInfo, Map<String, CashflowInitInfo> cashFlowInitMap) throws BOSException {
        CashflowInitInfo existInitInfo = cashFlowInitMap.get(initInfo.getCompany().getNumber() + initInfo.getCurrency().getNumber() + initInfo.getCashflowItem().getNumber());
        boolean isExist = false;
        if (existInitInfo != null) {
            if (existInitInfo.getId() != null) {
                CashflowGrpAsstCollection asstColl = existInitInfo.getCashflowGrpAsst();
                for (int i = 0; i < asstColl.size(); ++i) {
                    CashflowGrpAsstInfo existAsstInfo = asstColl.get(i);
                    initInfo.setId(existAsstInfo.getCflowInit().getId());
                    if (!existAsstInfo.getAssistGrp().getId().equals((Object)asstInfo.getAssistGrp().getId())) continue;
                    asstInfo.setId(existAsstInfo.getId());
                    asstColl.remove(existAsstInfo);
                    asstInfo.setCflowInit(existInitInfo);
                    asstColl.add(asstInfo);
                    isExist = true;
                    break;
                }
                return isExist;
            }
            if (initInfo.getCashflowGrpAsst() == null) {
                initInfo.setCashflowGrpAsst(new CashflowGrpAsstCollection());
            }
            initInfo.getCashflowGrpAsst().add(asstInfo);
            asstInfo.setCflowInit(existInitInfo);
            return false;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("cflowInit.company.id", (Object)initInfo.getCompany().getId().toString());
        filter.appendFilterItem("cflowInit.currency.id", (Object)initInfo.getCurrency().getId().toString());
        filter.appendFilterItem("cflowInit.cashflowItem.id", (Object)initInfo.getCashflowItem().getId().toString());
        view.setFilter(filter);
        CashflowGrpAsstCollection asstColl = CashflowGrpAsstFactory.getLocalInstance(ctx).getCashflowGrpAsstCollection(view);
        if (asstColl != null && asstColl.size() > 0) {
            for (int i = 0; i < asstColl.size(); ++i) {
                CashflowGrpAsstInfo existAsstInfo = asstColl.get(i);
                initInfo.setId(existAsstInfo.getCflowInit().getId());
                if (existAsstInfo.getAssistGrp() == null || asstInfo.getAssistGrp() == null || !existAsstInfo.getAssistGrp().getId().equals((Object)asstInfo.getAssistGrp().getId())) continue;
                asstInfo.setId(existAsstInfo.getId());
                asstInfo.setCflowInit(initInfo);
                asstColl.remove(existAsstInfo);
                asstColl.add(asstInfo);
                isExist = true;
                break;
            }
        }
        if (!isExist) {
            this.isExistCashFlowInit(ctx, initInfo, cashFlowInitMap);
            asstInfo.setCflowInit(initInfo);
            asstColl.add(asstInfo);
        }
        initInfo.setCashflowGrpAsst(asstColl);
        return isExist;
    }

    private boolean isExistCashFlowInit(Context ctx, CashflowInitInfo initInfo, Map<String, CashflowInitInfo> cashFlowInitMap) throws BOSException {
        CashflowInitInfo existInitInfo = cashFlowInitMap.get(initInfo.getCompany().getNumber() + initInfo.getCurrency().getNumber() + initInfo.getCashflowItem().getNumber());
        if (existInitInfo != null) {
            initInfo.setId(existInitInfo.getId());
            return true;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("company.id", (Object)initInfo.getCompany().getId().toString());
        filter.appendFilterItem("currency.id", (Object)initInfo.getCurrency().getId().toString());
        filter.appendFilterItem("cashflowItem.id", (Object)initInfo.getCashflowItem().getId().toString());
        view.setFilter(filter);
        CashflowInitCollection initColl = CashflowInitFactory.getLocalInstance(ctx).getCashflowInitCollection(view);
        if (initColl.size() > 0) {
            existInitInfo = initColl.get(0);
            initInfo.setId(existInitInfo.getId());
            boolean isExist = existInitInfo.getOriginalAmount() != null && !existInitInfo.getOriginalAmount().equals(BigDecimal.ZERO) || existInitInfo.getLocalAmount() != null && !existInitInfo.getLocalAmount().equals(BigDecimal.ZERO) || existInitInfo.getReportingAmount() != null && !existInitInfo.getReportingAmount().equals(BigDecimal.ZERO);
            return isExist;
        }
        return false;
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, String companyNumber, Map<String, CompanyOrgUnitInfo> companyMap) throws BOSException {
        if (companyNumber == null) {
            return null;
        }
        CompanyOrgUnitInfo company = companyMap.get(companyNumber);
        if (company == null && (company = GlWebServiceUtil.getCompany(ctx, companyNumber)) != null) {
            companyMap.put(companyNumber, company);
        }
        return company;
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, String currencyNumber, Map<String, CurrencyInfo> currencyMap) throws BOSException {
        if (currencyNumber == null) {
            return null;
        }
        CurrencyInfo currency = currencyMap.get(currencyNumber);
        if (currency == null && (currency = GlWebServiceUtil.findCurrencyByNumber(ctx, currencyNumber)) != null) {
            currencyMap.put(currencyNumber, currency);
        }
        return currency;
    }

    private CashFlowItemInfo getCashFlowItem(Context ctx, String cashFlowItemNumber, Map<String, CashFlowItemInfo> cashFlowItemMap) throws BOSException {
        if (cashFlowItemNumber == null) {
            return null;
        }
        CashFlowItemInfo cashFlowItem = cashFlowItemMap.get(cashFlowItemNumber);
        if (cashFlowItem == null && (cashFlowItem = DataImportUtils.findCashflowItemByName(ctx, cashFlowItemNumber)) != null) {
            cashFlowItemMap.put(cashFlowItemNumber, cashFlowItem);
        }
        return cashFlowItem;
    }
}

