/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.dataImport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherImpExpParam;
import com.kingdee.eas.fi.gl.VoucherImpFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.fi.gl.app.dataImport.DataImportUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.RecordUtils;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.task.SuccessInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CashFlowRecordDataImport
extends BlockDataTransmission {
    private static final SimpleDateFormat dateTime_Formater = new SimpleDateFormat("yyyy-MM-dd");
    private int count = 0;
    private String FSerialNumber = "";
    protected static final String[] voucherField = new String[]{"FCompanyID", "FDate", "FTransDate", "FPeriod", "FGroup", "FNum", "FEntryID", "FExp", "FAcctID", "FCyID", "FExchRate", "FDC", "FFcyAmt", "FQty", "FPrice", "FDebit", "FCredit", "FPrepare", "FPoster", "FAuditor", "FAttchment", "FPostflag", "FSourcesys", "FDeleteflag", "FSerialNO", "FUnitName", "FReference", "FHasCashFlow", "FCashFlow", "FTransID", "FSettlCode", "FSettleNO", "FAsstAbstract", "FClsName1", "FObjID1", "FObjName1", "FClsName2", "FObjID2", "FObjName2", "FClsName3", "FObjID3", "FObjName3", "FClsName4", "FObjID4", "FObjName4", "FClsName5", "FObjID5", "FObjName5", "FClsName6", "FObjID6", "FObjName6", "FClsName7", "FObjID7", "FObjName7", "FClsName8", "FObjID8", "FObjName8", "FInvNum", "FTicketNum", "FCustomer", "FFeeType", "FHandler", "FMaterial", "FOrgUnit", "FSupplier", "FBizDate", "FEndDate", "FProfitCenterID", "FAssistUnit", "FAssistQty", "lineNum", "fileUuID"};
    protected static final String[] field = new String[]{"FCompanyID", "FDate", "FPeriod", "FGroup", "FNum", "FCyID", "FEntryID", "FOppEntryID", "FNumber", "FSubNumber", "FAmountFor", "FAmountLoc", "FAmountRpt", "FPriCoef", "FSuPCoef", "FType", "FClsName1", "FObjID1", "FObjName1", "FClsName2", "FObjID2", "FObjName2", "FClsName3", "FObjID3", "FObjName3", "FClsName4", "FObjID4", "FObjName4", "FClsName5", "FObjID5", "FObjName5", "FClsName6", "FObjID6", "FObjName6", "FClsName7", "FObjID7", "FObjName7", "FClsName8", "FObjID8", "FObjName8"};
    private RecordCollection excelColl = new RecordCollection();
    private static final String RES_GLVOUCHERIMPRESOURCE = "com.kingdee.eas.fi.gl.GLVoucherImpResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CashflowRecordFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public void submitBlock(Context ctx, Object o) throws TaskExternalException {
    }

    public boolean isSkipMainProcess() {
        return true;
    }

    public boolean isAfterAllProcess() {
        return false;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            Hashtable<String, Object> result = new Hashtable<String, Object>();
            String FGroupID = rs.getString("company.number");
            result.put("FCompanyID", FGroupID == null ? "" : FGroupID);
            Object FDate = rs.getObject("voucher.bookedDate");
            result.put("FDate", FDate == null ? "" : FDate.toString());
            String FPeriod = rs.getString("period.periodNumber");
            result.put("FPeriod", FPeriod == null ? "" : FPeriod);
            String FGroup = rs.getString("voucherType.name");
            result.put("FGroup", FGroup == null ? "" : FGroup);
            String FNum = rs.getString("voucher.number");
            result.put("FNum", FNum == null ? "" : FNum);
            String FEntryID = rs.getString("entry.seq");
            result.put("FEntryID", FEntryID == null ? "" : FEntryID);
            if (FEntryID.equals("1")) {
                String FSerialNO = String.valueOf(System.currentTimeMillis()) + "--" + this.count;
                result.put("FSerialNO", FSerialNO == null ? "" : FSerialNO);
                this.FSerialNumber = FSerialNO;
                ++this.count;
            } else {
                result.put("FSerialNO", this.FSerialNumber == null ? "" : this.FSerialNumber);
            }
            String FCyID = rs.getString("currency.number");
            result.put("FCyID", FCyID == null ? "" : FCyID);
            String FOppEntryID = rs.getString("opposingAccountEntry.seq");
            result.put("FOppEntryID", FOppEntryID == null ? "" : FOppEntryID);
            String FNumber = rs.getString("primaryItem.number");
            result.put("FNumber", FNumber == null ? "" : FNumber);
            String FSubNumber = rs.getString("supplementaryItem.number");
            result.put("FSubNumber", FSubNumber == null ? "" : FSubNumber);
            String FAmountFor = rs.getString("originalAmount");
            result.put("FAmountFor", FAmountFor == null ? Integer.valueOf(0) : FAmountFor);
            String FAmountLoc = rs.getString("localAmount");
            result.put("FAmountLoc", FAmountLoc == null ? Integer.valueOf(0) : FAmountLoc);
            String FAmountRpt = rs.getString("reportingAmount");
            result.put("FAmountRpt", FAmountRpt == null ? Integer.valueOf(0) : FAmountRpt);
            String FPriCoef = rs.getString("primaryCoefficient");
            result.put("FPriCoef", FPriCoef == null ? "" : FPriCoef);
            String FSuPCoef = rs.getString("supplementaryCoefficient");
            result.put("FSuPCoef", FSuPCoef == null ? "" : FSuPCoef);
            String FType = CashflowTypeEnum.getEnum((int)rs.getInt("type")).getAlias();
            result.put("FType", FType == null ? "" : FType);
            HashMap<String, Map> asstItemMap = new HashMap<String, Map>();
            Map asstResult = null;
            IGLGeneralFacade facade = GLGeneralFacadeFactory.getLocalInstance(ctx);
            String assGrpId = rs.getString("assGrp.id");
            if (asstItemMap.containsKey(assGrpId)) {
                asstResult = (Map)asstItemMap.get(assGrpId);
            } else {
                HashMap<String, String> key = new HashMap<String, String>();
                key.put("key", assGrpId);
                asstResult = facade.dealTask("getAsstItem", key);
                asstItemMap.put(assGrpId, asstResult);
            }
            if (asstResult != null) {
                AsstActTypeCollection col = (AsstActTypeCollection)asstResult.get("value");
                int count2 = 0;
                if (col != null) {
                    count2 = col.size();
                }
                for (int k = 0; k < count2; ++k) {
                    AsstActTypeInfo data = col.get(k);
                    int jj = k + 1;
                    result.put("FClsName" + jj, (String)data.get("asstTypes") == null ? "" : (String)data.get("asstTypes"));
                    result.put("FObjID" + jj, (String)data.get("asstItemNumbers") == null ? "" : (String)data.get("asstItemNumbers"));
                    result.put("FObjName" + jj, (String)data.get("asstItemNames") == null ? "" : (String)data.get("asstItemNames"));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        Map paramMap = this.getContextMap();
        String filterValue = paramMap.get("bizCommonQueryFilter").toString();
        filterValue = filterValue.replace("$", "'");
        HashSet selectedIds = new HashSet();
        if (paramMap.get("selectedVouchers") != null) {
            ArrayList selectedVouchers = (ArrayList)paramMap.get("selectedVouchers");
            selectedIds.addAll(selectedVouchers);
        }
        filterValue = filterValue.replace("and ((entries.seq is null ) or (entries.seq <> 0 ))", " ");
        try {
            filter = new FilterInfo(filterValue);
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo item = filter.getFilterItems().get(i);
                item.setPropertyName("voucher." + item.getPropertyName());
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        if (!selectedIds.isEmpty()) {
            FilterInfo voucherFilter = new FilterInfo();
            voucherFilter.getFilterItems().add(new FilterItemInfo("voucher.id", selectedIds, CompareType.INCLUDE));
            try {
                voucherFilter.mergeFilter(filter, "and");
                return voucherFilter;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.gl.app.CashFlowRecordExportQuery";
    }

    protected VoucherCollection getVoucherPkList(int i, int size, IObjectPK[] pkList) throws Exception {
        int j = 0;
        StringBuffer strFilter = new StringBuffer("");
        while (100 - j++ > 0 && i < size) {
            String id = pkList[i].toString();
            if (j > 1) {
                strFilter.append(",");
            }
            strFilter.append(id);
            ++i;
        }
        VoucherCollection voucherCollection = this.getVoucherCollection(strFilter.toString());
        CashflowRecordCollection cashflowCollection = this.getCashflowCollection(strFilter.toString());
        if (cashflowCollection.size() > 0) {
            this.mergeVoucherAndCashflow(voucherCollection, cashflowCollection);
        }
        return voucherCollection;
    }

    private void mergeVoucherAndCashflow(VoucherCollection voucherCollection, CashflowRecordCollection cashflowCollection) {
        for (CashflowRecordInfo cashflowRecord : cashflowCollection) {
            BOSUuid vchEntryId;
            BOSUuid vchId = cashflowRecord.getVoucher().getId();
            VoucherInfo voucher = (VoucherInfo)voucherCollection.getObject((Object)vchId);
            if (voucher == null) continue;
            cashflowRecord.setVoucher(voucher);
            VoucherEntryCollection entries = voucher.getEntries();
            VoucherEntryInfo entry = (VoucherEntryInfo)entries.getObject((Object)(vchEntryId = cashflowRecord.getEntry().getId()));
            if (entry == null) continue;
            cashflowRecord.setEntry(entry);
            entry.getCashflowRecords().add(cashflowRecord);
        }
    }

    private CashflowRecordCollection getCashflowCollection(String vchIdList) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)vchIdList, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("voucher.id"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("originalAmount"));
        sic.add(new SelectorItemInfo("localAmount"));
        sic.add(new SelectorItemInfo("reportingAmount"));
        sic.add(new SelectorItemInfo("primaryCoefficient"));
        sic.add(new SelectorItemInfo("supplementaryCoefficient"));
        sic.add(new SelectorItemInfo("voucher.number"));
        sic.add(new SelectorItemInfo("entry.seq"));
        sic.add(new SelectorItemInfo("opposingAccountEntry.seq"));
        sic.add(new SelectorItemInfo("primaryItem.number"));
        sic.add(new SelectorItemInfo("supplementaryItem.number"));
        sic.add(new SelectorItemInfo("assGrp.id"));
        sic.add(new SelectorItemInfo("type"));
        view.setSelector(sic);
        view.setFilter(filter);
        return CashflowRecordFactory.getRemoteInstance().getCashflowRecordCollection(view);
    }

    private VoucherCollection getVoucherCollection(String vchIdList) throws Exception {
        EntityViewInfo e = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)vchIdList, CompareType.INCLUDE));
        f.setMaskString(" #0 and #1 ");
        e.setFilter(f);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("bookedDate"));
        sic.add(new SelectorItemInfo("attachments"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("entryCount"));
        sic.add(new SelectorItemInfo("isReverseVoucher"));
        sic.add(new SelectorItemInfo("hasReversed"));
        sic.add(new SelectorItemInfo("cashflowFlag"));
        sic.add(new SelectorItemInfo("isAC"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("sourceSys"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("poster.name"));
        sic.add(new SelectorItemInfo("canceller.name"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("handler.number"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("cashier.number"));
        sic.add(new SelectorItemInfo("poster.number"));
        sic.add(new SelectorItemInfo("canceller.number"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.description"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.quantity"));
        sic.add(new SelectorItemInfo("entries.standardQuantity"));
        sic.add(new SelectorItemInfo("entries.originalAmount"));
        sic.add(new SelectorItemInfo("entries.entryDC"));
        sic.add(new SelectorItemInfo("entries.localExchangeRate"));
        sic.add(new SelectorItemInfo("entries.localAmount"));
        sic.add(new SelectorItemInfo("entries.reportingExchangeRate"));
        sic.add(new SelectorItemInfo("entries.reportingAmount"));
        sic.add(new SelectorItemInfo("entries.account.number"));
        sic.add(new SelectorItemInfo("entries.currency.number"));
        sic.add(new SelectorItemInfo("entries.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.number"));
        sic.add(new SelectorItemInfo("entries.account.AC"));
        sic.add(new SelectorItemInfo("entries.assistRecords.seq"));
        sic.add(new SelectorItemInfo("entries.assistRecords.quantity"));
        sic.add(new SelectorItemInfo("entries.assistRecords.standardQuantity"));
        sic.add(new SelectorItemInfo("entries.assistRecords.originalAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.localAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.reportingAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.bizNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.settlementType.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.settlementCode"));
        sic.add(new SelectorItemInfo("entries.assistRecords.invoiceNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.ticketNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.customer.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.feeType"));
        sic.add(new SelectorItemInfo("entries.assistRecords.handler.number"));
        sic.add(new SelectorItemInfo("entries.assistRecords.material.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.orgUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.supplier.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.bizDate"));
        sic.add(new SelectorItemInfo("entries.assistRecords.endDate"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assistQty"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assistUnit.number"));
        sic.add(new SelectorItemInfo("entries.account.isQty"));
        sic.add(new SelectorItemInfo("entries.assistRecords.description"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.number"));
        sic.add(new SelectorItemInfo("entries.assistRecords.price"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.id"));
        e.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        sort.add(new SorterItemInfo("entries.seq"));
        e.getSorter().addObjectCollection((IObjectCollection)sort);
        return VoucherFactory.getRemoteInstance().getVoucherCollection(e);
    }

    public void solutionOnFinished(Context ctx) throws TaskExternalException {
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_Voucher";
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        String hasCashFlow = (String)paramMap.get("hasCashFlow");
        if (tempTableName != null && hasCashFlow != null && "true".equals(hasCashFlow)) {
            try {
                WSVoucherCollection pcWSVchColl = CashFlowRecordDataImport.getVoucherList(ctx, tempTableName, new HashSet<String>());
                WSVoucherCollection cashs = (WSVoucherCollection)((Object)CashFlowRecordDataImport.getCashFlowMap(ctx, paramMap).get("coll"));
                pcWSVchColl.addCollection(cashs);
                VoucherImpExpParam filterParam = this.getVoucherImpExpParam(paramMap);
                boolean isSubmit = false;
                String isSubmittoStr = (String)paramMap.get("isSubmit");
                if (!StringUtils.isEmpty((String)isSubmittoStr)) {
                    isSubmit = Boolean.parseBoolean(isSubmittoStr);
                }
                String oprtState = (String)paramMap.get("oprtState");
                Map<String, IObjectCollection> result = new HashMap();
                if (!StringUtils.isEmpty((String)oprtState) && "checkVoucher".equals(oprtState)) {
                    IObjectCollection coll = VoucherImpFacadeFactory.getLocalInstance(ctx).checkVoucher((IObjectCollection)pcWSVchColl, false, isSubmit, true, false, "excel", filterParam);
                    result.put("cols", coll);
                    WSVoucherInfo pcWSVouherInfo = (WSVoucherInfo)coll.getObject(0);
                    String fileUuId = (String)pcWSVouherInfo.get("fileUuId");
                    int sheetId = (Integer)pcWSVouherInfo.get("sheetId");
                    result.put("fileUuId", (IObjectCollection)fileUuId);
                    result.put("sheetId", (IObjectCollection)Integer.valueOf(sheetId));
                } else {
                    result = VoucherImpFacadeFactory.getLocalInstance(ctx).importVoucher((IObjectCollection)pcWSVchColl, false, true, isSubmit, false, "excel", filterParam);
                }
                WSVoucherCollection cols = (WSVoucherCollection)((Object)result.get("cols"));
                HashSet<Object> sucSet = new HashSet<Object>();
                HashSet<Object> failedSet = new HashSet<Object>();
                HashSet<String> set = new HashSet<String>();
                Iterator itor = cols.iterator();
                while (itor.hasNext()) {
                    WSVoucherInfo pcWSVoucherInfo = (WSVoucherInfo)itor.next();
                    if ("0000".equals(pcWSVoucherInfo.getDescription())) {
                        sucSet.add(pcWSVoucherInfo.get("vouchernumber"));
                        continue;
                    }
                    failedSet.add(pcWSVoucherInfo.get("vouchernumber"));
                }
                for (String string : sucSet) {
                    if (!failedSet.contains(string)) continue;
                    set.add(string);
                    sucSet.remove(string);
                    failedSet.remove(string);
                }
                String string = (String)result.get("fileUuId");
                int sheetId = (Integer)result.get("sheetId");
                RecordCollection col = this.getFailedRecordCollection(ctx, failedSet, (IObjectCollection)cols, set);
                ArrayList<SuccessInfo> sucList = new ArrayList<SuccessInfo>();
                SuccessInfo sucInfo = this.getVoucherSuccessfulCount(ctx, sucSet, string, sheetId, set);
                sucList.add(sucInfo);
                this.writeLog(col, sucList);
                this.writeLogForVoucherNumberisNull(ctx);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (SQLException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
    }

    private void writeLogForVoucherNumberisNull(Context ctx) throws BOSException, SQLException {
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_Voucher";
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        StringBuffer sql = new StringBuffer();
        sql.append(DataImportUtils.getVoucherSelect());
        sql.append(" from ").append(tempTableName);
        sql.append(" where fnum is null ");
        sql.append(" order by lineNum");
        RecordCollection col = new RecordCollection();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs != null && rs.next()) {
            SimpleRecord rec = new SimpleRecord();
            rec.setRowNum(rs.getInt("lineNum"));
            rec.setFileUuId(rs.getString("fileUuID"));
            rec.setSheetId(RecordUtils.getSheetId((int)rec.getRowNum()));
            int size = voucherField.length;
            for (int i = 0; i < size; ++i) {
                DataToken value = new DataToken();
                value.name = voucherField[i];
                value.data = rs.getString(voucherField[i]);
                rec.put(voucherField[i], value);
            }
            StringBuffer msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)rs.getInt("lineNum")) + 4));
            msg.append(this.getRes(ctx, "number")).append("[").append(rs.getString("FNum") == null ? "" : rs.getString("FNum")).append("]");
            msg.append(this.getRes(ctx, "isnull")).append("!");
            rec.setMsg(msg.toString());
            col.add((IRecord)rec);
        }
        this.writeLog(col, null);
    }

    private String getRes(Context ctx, String resName) {
        return ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    private String getVchLineErrorMsg(Context ctx, int row) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"no", (Locale)ctx.getLocale()));
        msg.append(row);
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"line", (Locale)ctx.getLocale()));
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"voucher", (Locale)ctx.getLocale()));
        return msg.toString();
    }

    private RecordCollection getFailedRecordCollection(Context ctx, Set failedSet, IObjectCollection cols, Set set) throws BOSException, SQLException {
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_Voucher";
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        StringBuffer sql = new StringBuffer();
        RecordCollection result = new RecordCollection();
        if (failedSet.size() > 0) {
            sql.append(DataImportUtils.getVoucherSelect());
            sql.append(" from ").append(tempTableName);
            sql.append(" where fnum in (").append(DataImportUtils.convertSet2String(failedSet)).append(")");
            sql.append(" order by lineNum");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs != null && rs.next()) {
                SimpleRecord rec = new SimpleRecord();
                rec.setRowNum(rs.getInt("lineNum"));
                rec.setFileUuId(rs.getString("fileUuID"));
                rec.setSheetId(RecordUtils.getSheetId((int)rec.getRowNum()));
                int size = voucherField.length;
                for (int i = 0; i < size; ++i) {
                    DataToken value = new DataToken();
                    value.name = voucherField[i];
                    value.data = rs.getString(voucherField[i]);
                    rec.put(voucherField[i], value);
                }
                String voucherNum = rs.getString("FNum");
                int lineNum = rs.getInt("lineNum");
                int rowNum = RecordUtils.getRowNum((int)(lineNum + 4));
                for (WSVoucherInfo pcWSVoucherInfo : cols) {
                    if (StringUtils.isEmpty((String)voucherNum) || StringUtils.isEmpty((String)pcWSVoucherInfo.getVoucherNumber()) || !voucherNum.equals(pcWSVoucherInfo.getVoucherNumber())) continue;
                    rec.setMsg((String)pcWSVoucherInfo.get("voucherabstract"));
                }
                result.add((IRecord)rec);
            }
        }
        for (String voucherNumber : set) {
            sql = new StringBuffer();
            sql.append("select pv.fdescription, pd.fperiodnumber, vt.fname_l2, vt.fname_l1, vt.fname_l3, ");
            sql.append(" pc.fnumber profitcenternumber from t_gl_voucher pv ");
            sql.append(" inner join t_bd_period pd on pd.fid = pv.fperiodid ");
            sql.append(" inner join t_bd_vouchertypes vt on vt.fid = pv.fvouchertypeid ");
            sql.append(" inner join t_org_company pc on pc.fid = pv.fcompanyid ");
            sql.append(" where pv.fdescription in (");
            sql.append("select FSerialNO from ").append(tempTableName);
            sql.append(" where FNum = '").append(voucherNumber).append("')");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows == null || !rows.next()) continue;
            String description = rows.getString("fdescription");
            int periodNumbe = rows.getInt("fperiodnumber");
            String vouchertype = rows.getString("fname_" + ctx.getLocale());
            String profitcenternumber = rows.getString("profitcenternumber");
            StringBuffer sql1 = new StringBuffer();
            sql1.append(DataImportUtils.getVoucherSelect());
            sql1.append(" from ").append(tempTableName);
            sql1.append(" where fnum in ('").append(voucherNumber).append("')");
            sql1.append("   and (FSerialNO <> '").append(description).append("' ");
            sql1.append("   or  FPeriod <> ").append(periodNumbe);
            sql1.append("   or  FGroup <> '").append(vouchertype).append("' ");
            sql1.append("   or  FProfitCenterID <> '").append(profitcenternumber).append("') ");
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
            while (rs1 != null && rs1.next()) {
                SimpleRecord rec = new SimpleRecord();
                rec.setRowNum(rs1.getInt("lineNum"));
                rec.setFileUuId(rs1.getString("fileUuID"));
                rec.setSheetId(RecordUtils.getSheetId((int)rec.getRowNum()));
                int size = voucherField.length;
                for (int i = 0; i < size; ++i) {
                    DataToken value = new DataToken();
                    value.name = voucherField[i];
                    value.data = rs1.getString(voucherField[i]);
                    rec.put(voucherField[i], value);
                }
                String voucherNum = rs1.getString("FNum");
                int lineNum = rs1.getInt("lineNum");
                int rowNum = RecordUtils.getRowNum((int)(lineNum + 4));
                for (WSVoucherInfo pcWSVoucherInfo : cols) {
                    if (StringUtils.isEmpty((String)voucherNum) || StringUtils.isEmpty((String)pcWSVoucherInfo.getVoucherNumber()) || !voucherNum.equals(pcWSVoucherInfo.getVoucherNumber())) continue;
                    rec.setMsg((String)pcWSVoucherInfo.get("voucherabstract"));
                }
                result.add((IRecord)rec);
            }
        }
        return result;
    }

    private SuccessInfo getVoucherSuccessfulCount(Context ctx, Set sucSet, String fileUuId, int sheetId, Set set) throws BOSException, SQLException {
        int sucCount = 0;
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_Voucher";
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        StringBuffer sql = new StringBuffer();
        if (sucSet.size() > 0) {
            sql.append("select count(1) count from ").append(tempTableName).append(" where fnum in (").append(DataImportUtils.convertSet2String(sucSet)).append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null && rs.next()) {
                sucCount = rs.getInt("count");
            }
        }
        int count = 0;
        if (set.size() > 0) {
            sql = new StringBuffer();
            sql.append("select count(1) count from t_gl_voucher pv ");
            sql.append(" inner join t_gl_voucherentry pve on pve.fbillid = pv.fid ");
            sql.append(" where pv.fdescription in (");
            sql.append("  select FSerialNO from ").append(tempTableName).append(" where fnum in (").append(DataImportUtils.convertSet2String(set)).append("))");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows != null && rows.next()) {
                count = rows.getInt("count");
            }
        }
        SuccessInfo result = new SuccessInfo(fileUuId, sheetId, sucCount + count);
        return result;
    }

    protected static Map getCashFlowMap(Context ctx, Map paramMap) throws BOSException, SQLException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        WSVoucherCollection cashColl = new WSVoucherCollection();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_CashflowRecord";
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        StringBuffer sql = new StringBuffer();
        sql.append("select FCompanyID,FDate,FPeriod,FGroup,FNum,FSerialNO,FCyID,FEntryID,FOppEntryID,");
        sql.append("       FNumber,FSubNumber,FAmountFor,FAmountLoc,FAmountRpt,FPriCoef,FSuPCoef,");
        sql.append("       FType,FClsName1,FObjID1,FObjName1,FClsName2,FObjID2,FObjName2,FClsName3,");
        sql.append("       FObjID3,FObjName3,FClsName4,FObjID4,FObjName4,FClsName5,FObjID5,FObjName5,");
        sql.append("       FClsName6,FObjID6,FObjName6,FClsName7,FObjID7,FObjName7,FClsName8,FObjID8,");
        sql.append("       FObjName8,lineNum,fileUuID ");
        sql.append(" from ").append(tempTableName);
        sql.append(" order by FCompanyID,FPeriod,FGroup,FNum,FEntryID ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        WSVoucherInfo wsvoucher = null;
        HashMap<String, WSVoucherCollection> keyCashMap = new HashMap<String, WSVoucherCollection>();
        while (rs != null && rs.next()) {
            BigDecimal rptAmount;
            BigDecimal localAmount;
            wsvoucher = new WSVoucherInfo();
            wsvoucher.put("lineNum", rs.getInt("lineNum"));
            wsvoucher.setItemFlag(1);
            wsvoucher.setCompanyNumber(rs.getString("FCompanyID"));
            Date voucherDate = rs.getDate("FDate");
            wsvoucher.setBookedDate(voucherDate);
            int periodNum = 0;
            periodNum = rs.getInt("FPeriod");
            wsvoucher.setPeriodNumber(periodNum);
            wsvoucher.setVoucherType(rs.getString("FGroup"));
            wsvoucher.setVoucherNumber(rs.getString("FNum"));
            wsvoucher.setCurrencyNumber(rs.getString("FCyID"));
            wsvoucher.setEntrySeq(rs.getInt("FEntryID"));
            wsvoucher.put("cashOppEntrySeq", rs.getInt("FOppEntryID"));
            wsvoucher.setPrimaryItem(rs.getString("FNumber"));
            wsvoucher.setSupplyItem(rs.getString("FSubNumber"));
            BigDecimal originalAmount = rs.getBigDecimal("FAmountFor");
            if (originalAmount != null) {
                wsvoucher.setCashflowAmountOriginal(originalAmount.doubleValue());
            }
            if ((localAmount = rs.getBigDecimal("FAmountLoc")) != null) {
                wsvoucher.setCashflowAmountLocal(localAmount.doubleValue());
            }
            if ((rptAmount = rs.getBigDecimal("FAmountRpt")) != null) {
                wsvoucher.setCashflowAmountRpt(rptAmount.doubleValue());
            }
            BigDecimal primarycoef = rs.getBigDecimal("FPriCoef");
            wsvoucher.setPrimaryCoef(primarycoef.doubleValue());
            BigDecimal supplycoef = rs.getBigDecimal("FSuPCoef");
            wsvoucher.setSupplyCoef(supplycoef.doubleValue());
            wsvoucher.setType(rs.getString("FType"));
            int assistCount = 0;
            for (int k = 1; k < 9; ++k) {
                String strAsstActTypeName = rs.getString("FClsName" + k);
                String strAsstActID = rs.getString("FObjID" + k);
                String strAsstActName = rs.getString("FObjName" + k);
                if (!(strAsstActTypeName != null && !"".equals(strAsstActTypeName) || strAsstActID != null && !"".equals(strAsstActID) || strAsstActName != null && !"".equals(strAsstActName))) continue;
                wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
                wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
                wsvoucher.put("asstActName" + assistCount, strAsstActName);
                ++assistCount;
            }
            wsvoucher.put("assistCount", new Integer(assistCount));
            wsvoucher.put("fileUuId", rs.getString("fileUuID"));
            cashColl.add(wsvoucher);
            StringBuffer keys = new StringBuffer(wsvoucher.getCompanyNumber()).append("_");
            keys.append(wsvoucher.getPeriodYear()).append(wsvoucher.getPeriodNumber()).append("_").append(wsvoucher.getVoucherType()).append("_").append(wsvoucher.getVoucherNumber());
            WSVoucherCollection keyCashColl = (WSVoucherCollection)((Object)keyCashMap.get(keys.toString()));
            if (keyCashColl == null) {
                keyCashColl = new WSVoucherCollection();
                keyCashColl.add(wsvoucher);
                keyCashMap.put(keys.toString(), keyCashColl);
                continue;
            }
            keyCashColl.add(wsvoucher);
        }
        resultMap.put("coll", (Object)cashColl);
        resultMap.put("keyCashMap", keyCashMap);
        return resultMap;
    }

    protected static WSVoucherCollection getVoucherList(Context ctx, String tempTableName, Set<String> set) throws BOSException, SQLException {
        WSVoucherCollection pcWSVchColl = new WSVoucherCollection();
        StringBuffer sql = new StringBuffer();
        sql.append(DataImportUtils.getVoucherSelect());
        sql.append(" from ").append(tempTableName);
        if (set.size() > 0) {
            sql.append(" where FNum in (").append(DataImportUtils.convertSet2String(set)).append(") ");
        }
        sql.append(" order by FCompanyID, FPeriod, FGroup, FNum, FEntryID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        WSVoucherInfo wsvoucher = null;
        while (rs != null && rs.next()) {
            java.util.Date endDate;
            BigDecimal cAmount;
            BigDecimal dAmount;
            BigDecimal price;
            BigDecimal qty;
            BigDecimal quantity;
            wsvoucher = new WSVoucherInfo();
            wsvoucher.put("isWeb", "true");
            wsvoucher.put("lineNum", rs.getInt("lineNum"));
            String companyNumber = rs.getString("FCompanyID");
            wsvoucher.setCompanyNumber(companyNumber);
            Date voucherDate = rs.getDate("FDate");
            wsvoucher.setBookedDate(voucherDate);
            Date bizDate = rs.getDate("FTransDate");
            if (bizDate == null) {
                bizDate = voucherDate;
            }
            wsvoucher.setBizDate(bizDate);
            wsvoucher.setPeriodNumber(rs.getInt("FPeriod"));
            wsvoucher.setVoucherType(rs.getString("FGroup"));
            wsvoucher.setVoucherNumber(rs.getString("FNum"));
            wsvoucher.setEntrySeq(rs.getInt("FEntryID"));
            wsvoucher.setVoucherAbstract(rs.getString("FExp"));
            wsvoucher.setAccountNumber(rs.getString("FAcctID"));
            wsvoucher.setCurrencyNumber(rs.getString("FCyID"));
            BigDecimal exchangeRate = rs.getBigDecimal("FExchRate");
            if (exchangeRate != null) {
                exchangeRate = exchangeRate.setScale(10, 4);
                wsvoucher.setLocalRate(exchangeRate.doubleValue());
            }
            wsvoucher.setEntryDC(StringUtils.isEmpty((String)rs.getString("FDC")) ? -1 : rs.getInt("FDC"));
            BigDecimal originalAmount = rs.getBigDecimal("FFcyAmt");
            if (originalAmount != null) {
                wsvoucher.setOriginalAmount(originalAmount.doubleValue());
            }
            if ((quantity = rs.getBigDecimal("FQty")) != null) {
                wsvoucher.setQty(quantity.doubleValue());
            }
            if ((qty = rs.getBigDecimal("FAssistQty")) != null) {
                wsvoucher.put("assistQty", qty);
            }
            if ((price = rs.getBigDecimal("FPrice")) != null) {
                wsvoucher.setPrice(price.doubleValue());
            }
            if ((dAmount = rs.getBigDecimal("FDebit")) != null) {
                wsvoucher.setDebitAmount(dAmount.doubleValue());
            }
            if ((cAmount = rs.getBigDecimal("FCredit")) != null) {
                wsvoucher.setCreditAmount(cAmount.doubleValue());
            }
            wsvoucher.setCreator(rs.getString("FPrepare"));
            wsvoucher.setPoster(rs.getString("FPoster"));
            wsvoucher.setAuditor(rs.getString("FAuditor"));
            wsvoucher.setAttaches(rs.getInt("FAttchment"));
            String postflag = rs.getString("FPostflag");
            wsvoucher.put("module", postflag);
            String strModle = rs.getString("FSourcesys");
            wsvoucher.put("module", strModle);
            wsvoucher.put("deleted", rs.getString("FDeleteflag"));
            wsvoucher.put("pingzhengxuhao", rs.getString("FSerialNO"));
            wsvoucher.setMeasurement(rs.getString("FUnitName"));
            wsvoucher.put("assistUnit", rs.getString("FAssistUnit"));
            wsvoucher.setDescription(rs.getString("FReference"));
            wsvoucher.put("cashflowFlag", rs.getInt("FHasCashFlow"));
            wsvoucher.setItemFlag(0);
            wsvoucher.setBizNumber(rs.getString("FTransID"));
            wsvoucher.setSettlementType(rs.getString("FSettlCode"));
            wsvoucher.setSettlementNumber(rs.getString("FSettleNO"));
            String des = rs.getString("FAsstAbstract");
            wsvoucher.put("asstAbstract", des);
            int assistCount = 0;
            for (int k = 1; k <= 8; ++k) {
                String strAsstActTypeName = rs.getString("FClsName" + k);
                String strAsstActID = rs.getString("FObjID" + k);
                String strAsstActName = rs.getString("FObjName" + k);
                if (!(strAsstActTypeName != null && !"".equals(strAsstActTypeName) || strAsstActID != null && !"".equals(strAsstActID) || strAsstActName != null && !"".equals(strAsstActName))) continue;
                wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
                wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
                wsvoucher.put("asstActName" + assistCount, strAsstActName);
                ++assistCount;
            }
            wsvoucher.put("assistCount", new Integer(assistCount));
            wsvoucher.setInvoiceNumber(rs.getString("FInvNum"));
            wsvoucher.put("ticketNumber", rs.getString("FTicketNum"));
            wsvoucher.put("customer", rs.getString("FCustomer"));
            wsvoucher.put("feeType", rs.getString("FFeeType"));
            wsvoucher.put("handler", rs.getString("FHandler"));
            wsvoucher.put("material", rs.getString("FMaterial"));
            wsvoucher.put("orgUnit", rs.getString("FOrgUnit"));
            wsvoucher.put("supplier", rs.getString("FSupplier"));
            Date asstBizDate = rs.getDate("FBizDate");
            if (asstBizDate != null) {
                wsvoucher.setAssistBizDate(asstBizDate);
            }
            if ((endDate = rs.getDate("FEndDate")) == null) {
                endDate = wsvoucher.getBizDate();
            }
            wsvoucher.setAssistEndDate(endDate);
            wsvoucher.setProfitCenterNumber(rs.getString("FProfitCenterID"));
            wsvoucher.put("fileUuId", rs.getString("fileUuID"));
            pcWSVchColl.add(wsvoucher);
        }
        return pcWSVchColl;
    }

    public Object transform(Context ctx, RecordCollection coll) throws TaskExternalException {
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_CashflowRecord";
        if (ctx.get((Object)tempTableKey) == null) {
            try {
                this.createTempTable(ctx, tempTableKey);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        try {
            for (SimpleRecord record : coll) {
                this.insertDataIntoTempTable(ctx, record, tempTableName);
            }
        }
        catch (ParseException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return null;
    }

    private void createTempTable(Context ctx, String tempTableKey) throws Exception {
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table gl_cashflow (").append("FCompanyID nvarchar(80),").append("FDate DateTime,").append("FPeriod int,").append("FGroup nvarchar(80),").append("FNum nvarchar(80),").append("FSerialNO nvarchar(80),").append("FCyID varchar(80),").append("FEntryID int,").append("FOppEntryID int,").append("FNumber nvarchar(80),").append("FSubNumber nvarchar(80),").append("FAmountFor decimal(19,4),").append("FAmountLoc decimal(19,4),").append("FAmountRpt decimal(19,4),").append("FPriCoef decimal(19,4),").append("FSuPCoef decimal(19,4),").append("FType nvarchar(80),").append("FClsName1 nvarchar(80),").append("FObjID1 nvarchar(80),").append("FObjName1 nvarchar(80),").append("FClsName2 nvarchar(80),").append("FObjID2 nvarchar(80),").append("FObjName2 nvarchar(80),").append("FClsName3 nvarchar(80),").append("FObjID3 nvarchar(80),").append("FObjName3 nvarchar(80),").append("FClsName4 nvarchar(80),").append("FObjID4 nvarchar(80),").append("FObjName4 nvarchar(80),").append("FClsName5 nvarchar(80),").append("FObjID5 nvarchar(80),").append("FObjName5 nvarchar(80),").append("FClsName6 nvarchar(80),").append("FObjID6 nvarchar(80),").append("FObjName6 nvarchar(80),").append("FClsName7 nvarchar(80),").append("FObjID7 nvarchar(80),").append("FObjName7 nvarchar(80),").append("FClsName8 nvarchar(80),").append("FObjID8 nvarchar(80),").append("FObjName8 nvarchar(80),").append("lineNum int,").append("fileUuID nvarchar(80))");
        String tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createSql.toString());
        ctx.put((Object)tempTableKey, (Object)tempTableName);
    }

    private void insertDataIntoTempTable(Context ctx, SimpleRecord data, String tempTableName) throws ParseException, BOSException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(tempTableName);
        insertSql.append("(FCompanyID, FDate, FPeriod, FGroup, FNum, FSerialNO, FCyID, FEntryID, ").append("FOppEntryID, FNumber, FSubNumber, FAmountFor, FAmountLoc, FAmountRpt, ").append("FPriCoef, FSuPCoef, FType, FClsName1, FObjID1, FObjName1, FClsName2, ").append("FObjID2, FObjName2, FClsName3, FObjId3, FObjName3, FClsName4, FObjID4, ").append("FObjName4, FClsName5, FObjID5, FObjName5, FClsName6, FObjID6, FObjName6,").append("FClsName7, FObjID7, FObjName7, FClsName8, FObjID8, FObjName8, lineNum,").append("fileUuID)").append("values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ").append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Object[] insertValue = new Object[43];
        insertValue[0] = this.getValue(data, "FCompanyID");
        String fDate = this.getValue(data, "FDate");
        if (!StringUtils.isEmpty((String)fDate)) {
            java.util.Date utilDate = dateTime_Formater.parse(fDate);
            Date sqlDate = new Date(utilDate.getTime());
            insertValue[1] = sqlDate;
        } else {
            insertValue[1] = null;
        }
        String fPeriod = this.getValue(data, "FPeriod");
        insertValue[2] = !StringUtils.isEmpty((String)fPeriod) ? Integer.valueOf(Integer.parseInt(fPeriod)) : null;
        insertValue[3] = this.getValue(data, "FGroup");
        insertValue[4] = this.getValue(data, "FNum");
        insertValue[5] = this.getValue(data, "FSerialNO");
        insertValue[6] = this.getValue(data, "FCyID");
        String fEntryID = this.getValue(data, "FEntryID");
        insertValue[7] = !StringUtils.isEmpty((String)fEntryID) ? Integer.valueOf(Integer.parseInt(fEntryID)) : null;
        String fOppEntryID = this.getValue(data, "FOppEntryID");
        insertValue[8] = !StringUtils.isEmpty((String)fOppEntryID) ? Integer.valueOf(Integer.parseInt(fOppEntryID)) : null;
        insertValue[9] = this.getValue(data, "FNumber");
        insertValue[10] = this.getValue(data, "FSubNumber");
        String fAmountFor = this.getValue(data, "FAmountFor");
        insertValue[11] = !StringUtils.isEmpty((String)fAmountFor) ? new BigDecimal(fAmountFor) : null;
        String fAmountLoc = this.getValue(data, "FAmountLoc");
        insertValue[12] = !StringUtils.isEmpty((String)fAmountLoc) ? new BigDecimal(fAmountLoc) : null;
        String fAmountRpt = this.getValue(data, "FAmountRpt");
        insertValue[13] = !StringUtils.isEmpty((String)fAmountRpt) ? new BigDecimal(fAmountRpt) : null;
        String fPriCoef = this.getValue(data, "FPriCoef");
        insertValue[14] = !StringUtils.isEmpty((String)fPriCoef) ? new BigDecimal(fPriCoef) : null;
        String fSuPCoef = this.getValue(data, "FSuPCoef");
        insertValue[15] = !StringUtils.isEmpty((String)fSuPCoef) ? new BigDecimal(fSuPCoef) : null;
        insertValue[16] = this.getValue(data, "FType");
        insertValue[17] = this.getValue(data, "FClsName1");
        insertValue[18] = this.getValue(data, "FObjID1");
        insertValue[19] = this.getValue(data, "FObjName1");
        insertValue[20] = this.getValue(data, "FClsName2");
        insertValue[21] = this.getValue(data, "FObjID2");
        insertValue[22] = this.getValue(data, "FObjName2");
        insertValue[23] = this.getValue(data, "FClsName3");
        insertValue[24] = this.getValue(data, "FObjID3");
        insertValue[25] = this.getValue(data, "FObjName3");
        insertValue[26] = this.getValue(data, "FClsName4");
        insertValue[27] = this.getValue(data, "FObjID4");
        insertValue[28] = this.getValue(data, "FObjName4");
        insertValue[29] = this.getValue(data, "FClsName5");
        insertValue[30] = this.getValue(data, "FObjID5");
        insertValue[31] = this.getValue(data, "FObjName5");
        insertValue[32] = this.getValue(data, "FClsName6");
        insertValue[33] = this.getValue(data, "FObjID6");
        insertValue[34] = this.getValue(data, "FObjName6");
        insertValue[35] = this.getValue(data, "FClsName7");
        insertValue[36] = this.getValue(data, "FObjID7");
        insertValue[37] = this.getValue(data, "FObjName7");
        insertValue[38] = this.getValue(data, "FClsName8");
        insertValue[39] = this.getValue(data, "FObjID8");
        insertValue[40] = this.getValue(data, "FObjName8");
        insertValue[41] = data.getRowNum();
        insertValue[42] = data.getFileUuId();
        DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])insertValue);
    }

    protected String getValue(SimpleRecord data, String fieldName) {
        if (data.get(fieldName) == null) {
            return null;
        }
        Object obj = data.get((String)fieldName).data;
        return obj == null ? null : obj.toString().trim();
    }

    private VoucherImpExpParam getVoucherImpExpParam(Map paramMap) {
        VoucherImpExpParam filterParam = new VoucherImpExpParam();
        String errorDispose = (String)paramMap.get("errorDispose");
        if (!StringUtils.isEmpty((String)errorDispose)) {
            filterParam.setStopImpVoucher(Boolean.parseBoolean(errorDispose));
        }
        boolean halfInviableSaveVoucher = (Boolean)paramMap.get("halfInviableSaveVoucher");
        filterParam.setChkHalfInviableSaveVoucher(halfInviableSaveVoucher);
        boolean isSaveByOrgUser = (Boolean)paramMap.get("isSaveByOrgUser");
        filterParam.setSaveByOrgUser(isSaveByOrgUser);
        boolean isTempletVoucherCode = (Boolean)paramMap.get("isTempletVoucherCode");
        filterParam.setChkIsTempletVoucherCode(isTempletVoucherCode);
        filterParam.setAssistById(true);
        return filterParam;
    }

    public boolean isSameBlock(Map firstData, Map currentData) {
        return true;
    }
}

