/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.dataImport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherImpExpParam;
import com.kingdee.eas.fi.gl.VoucherImpFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.fi.gl.app.dataImport.CashFlowRecordDataImport;
import com.kingdee.eas.fi.gl.app.dataImport.DataImportUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.RecordUtils;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.task.SuccessInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class VoucherDataImport
extends BlockDataTransmission {
    private static final SimpleDateFormat dateTime_Formater = new SimpleDateFormat("yyyy-MM-dd");
    private static final String RES_GLVOUCHERIMPRESOURCE = "com.kingdee.eas.fi.gl.GLVoucherImpResource";
    private int count = 0;
    private String FSerialNumber = "";
    protected static final String[] voucherField = new String[]{"FCompanyID", "FDate", "FTransDate", "FPeriod", "FGroup", "FNum", "FEntryID", "FExp", "FAcctID", "FCyID", "FExchRate", "FDC", "FFcyAmt", "FQty", "FPrice", "FDebit", "FCredit", "FPrepare", "FPoster", "FAuditor", "FAttchment", "FPostflag", "FSourcesys", "FDeleteflag", "FSerialNO", "FUnitName", "FReference", "FHasCashFlow", "FCashFlow", "FTransID", "FSettlCode", "FSettleNO", "FAsstAbstract", "FClsName1", "FObjID1", "FObjName1", "FClsName2", "FObjID2", "FObjName2", "FClsName3", "FObjID3", "FObjName3", "FClsName4", "FObjID4", "FObjName4", "FClsName5", "FObjID5", "FObjName5", "FClsName6", "FObjID6", "FObjName6", "FClsName7", "FObjID7", "FObjName7", "FClsName8", "FObjID8", "FObjName8", "FInvNum", "FTicketNum", "FCustomer", "FFeeType", "FHandler", "FMaterial", "FOrgUnit", "FSupplier", "FBizDate", "FEndDate", "FProfitCenterID", "FAssistUnit", "FAssistQty", "lineNum", "fileUuID"};
    private RecordCollection excelColl = new RecordCollection();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return VoucherFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public void submitBlock(Context ctx, Object o) throws TaskExternalException {
    }

    public boolean isSkipMainProcess() {
        return true;
    }

    public boolean isAfterAllProcess() {
        return true;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            String FHandler;
            String FInvNum;
            Hashtable<String, Object> result = new Hashtable<String, Object>();
            String FCompanyID = rs.getString("company.number");
            result.put("FCompanyID", FCompanyID);
            Object FDate = rs.getObject("bookedDate");
            result.put("FDate", FDate == null ? "" : FDate.toString());
            Object FTransDate = rs.getObject("bizDate");
            result.put("FTransDate", FTransDate == null ? "" : FTransDate.toString());
            String FPeriod = rs.getString("period.number");
            FPeriod = Integer.valueOf(FPeriod.substring(4)).toString();
            result.put("FPeriod", FPeriod == null ? "" : FPeriod);
            String FGroup = rs.getString("voucherType.name");
            result.put("FGroup", FGroup == null ? "" : FGroup);
            String FNum = rs.getString("voucherNumber");
            result.put("FNum", FNum == null ? "" : FNum);
            String FEntryID = rs.getString("entries.seq");
            result.put("FEntryID", FEntryID == null ? "" : FEntryID);
            if (FEntryID.equals("1")) {
                String FSerialNO = String.valueOf(System.currentTimeMillis()) + "--" + this.count;
                result.put("FSerialNO", FSerialNO == null ? "" : FSerialNO);
                this.FSerialNumber = FSerialNO;
                ++this.count;
            } else {
                result.put("FSerialNO", this.FSerialNumber == null ? "" : this.FSerialNumber);
            }
            String FExp = rs.getString("entries.description");
            result.put("FExp", FExp == null ? "" : FExp);
            Object FProfitCenterID = rs.getObject("profitCenter.number");
            result.put("FProfitCenterID", FProfitCenterID == null ? "" : FProfitCenterID);
            String FAcctID = rs.getString("account.number");
            result.put("FAcctID", FAcctID == null ? "" : FAcctID);
            String FAcctName = rs.getString("account.longName");
            result.put("FAcctName", FAcctName == null ? "" : FAcctName);
            String FCompanyName = rs.getString("company.name");
            result.put("FCompanyName", FCompanyName == null ? "" : FCompanyName);
            String FCurrencyName = rs.getString("currency.name");
            result.put("FCyName", FCurrencyName == null ? "" : FCurrencyName);
            String FCyID = rs.getString("currency.number");
            result.put("FCyID", FCyID == null ? "" : FCyID);
            String FExchRate = rs.getString("entries.localExchangeRate");
            result.put("FExchRate", FExchRate == null ? Integer.valueOf(0) : FExchRate);
            String FDC = rs.getString("entries.entryDC");
            result.put("FDC", FDC == null ? "" : FDC);
            String FFcyAmt = rs.getString("entries.originalAmount");
            if (rs.getString("assistRecords.originalAmount") != null) {
                FFcyAmt = rs.getString("assistRecords.originalAmount");
            }
            result.put("FFcyAmt", FFcyAmt == null ? Integer.valueOf(0) : FFcyAmt);
            String FQty = rs.getString("entries.quantity");
            result.put("FQty", FQty == null ? Integer.valueOf(0) : FQty);
            String FAssistQty = rs.getString("assistRecords.quantity");
            result.put("FAssistQty", FAssistQty == null ? Integer.valueOf(0) : FAssistQty);
            Long FPrice = rs.getLong("entries.price");
            result.put("FPrice", FPrice == null ? (Number)0 : (Number)FPrice);
            String debitAmount = rs.getString("entries.localAmount");
            if (rs.getString("assistRecords.localAmount") != null) {
                debitAmount = rs.getString("assistRecords.localAmount");
            }
            String FDebit = "1".equals(FDC) ? debitAmount : "";
            result.put("FDebit", FDebit == null ? Integer.valueOf(0) : FDebit);
            String creditAmount = rs.getString("entries.localAmount");
            if (rs.getString("assistRecords.localAmount") != null) {
                creditAmount = rs.getString("assistRecords.localAmount");
            }
            String FCredit = "1".equals(FDC) ? "" : creditAmount;
            result.put("FCredit", FCredit == null ? Integer.valueOf(0) : FCredit);
            String FPrepare = rs.getString("creator.number");
            result.put("FPrepare", FPrepare == null ? "" : FPrepare);
            String FPoster = rs.getString("poster.number");
            result.put("FPoster", FPoster == null ? "" : FPoster);
            String FAuditor = rs.getString("auditor.number");
            result.put("FAuditor", FAuditor == null ? "" : FAuditor);
            String FAttchment = rs.getString("attachments");
            result.put("FAttchment", FAttchment == null ? Integer.valueOf(0) : FAttchment);
            String FPostflag = "5".equals(rs.getString("bizStatus")) ? "TRUE" : "FALSE";
            result.put("FPostflag", FPostflag == null ? Integer.valueOf(0) : FPostflag);
            String FSourcesys = "";
            result.put("FSourcesys", FSourcesys == null ? Integer.valueOf(0) : FSourcesys);
            String FDeleteflag = "FLASE";
            result.put("FDeleteflag", FDeleteflag == null ? Integer.valueOf(0) : FDeleteflag);
            String FUnitName = rs.getString("measureUnit.number");
            result.put("FUnitName", FUnitName == null ? "" : FUnitName);
            String FAssistUnit = rs.getString("assistUnit.number");
            result.put("FAssistUnit", FAssistUnit == null ? "" : FAssistUnit);
            String FReference = rs.getString("description");
            result.put("FReference", FReference == null ? "" : FReference);
            result.put("FHasCashFlow", "");
            String FCashFlow = rs.getString("cashflowFlag");
            result.put("FCashFlow", FCashFlow == null ? Integer.valueOf(0) : FCashFlow);
            String FTransID = rs.getString("assistRecords.bizNumber");
            result.put("FTransID", FTransID == null ? "" : FTransID);
            String FSettlCode = rs.getString("settlementType.name");
            result.put("FSettlCode", FSettlCode == null ? "" : FSettlCode);
            String FSettleNO = rs.getString("assistRecords.settlementCode");
            result.put("FSettleNO", FSettleNO == null ? "" : FSettleNO);
            String FAsstAbstract = rs.getString("assistRecords.description");
            result.put("FAsstAbstract", FAsstAbstract == null ? "" : FAsstAbstract);
            HashMap<String, Map> asstItemMap = new HashMap<String, Map>();
            Map asstResult = null;
            IGLGeneralFacade facade = GLGeneralFacadeFactory.getLocalInstance(ctx);
            String assGrpId = rs.getString("assGrp.id");
            if (asstItemMap.containsKey(assGrpId)) {
                asstResult = (Map)asstItemMap.get(assGrpId);
            } else {
                HashMap<String, String> key = new HashMap<String, String>();
                key.put("key", assGrpId);
                asstResult = facade.dealTask("getAsstItem", key);
                asstItemMap.put(assGrpId, asstResult);
            }
            if (asstResult != null) {
                AsstActTypeCollection col = (AsstActTypeCollection)asstResult.get("value");
                int count2 = 0;
                if (col != null) {
                    count2 = col.size();
                }
                for (int k = 0; k < count2; ++k) {
                    AsstActTypeInfo data = col.get(k);
                    int jj = k + 1;
                    result.put("FClsName" + jj, (String)data.get("asstTypes") == null ? "" : (String)data.get("asstTypes"));
                    result.put("FObjID" + jj, (String)data.get("asstItemNumbers") == null ? "" : (String)data.get("asstItemNumbers"));
                    result.put("FObjName" + jj, (String)data.get("asstItemNames") == null ? "" : (String)data.get("asstItemNames"));
                }
            }
            result.put("FInvNum", (FInvNum = rs.getString("assistRecords.invoiceNumber")) == null ? "" : FInvNum);
            String FTicketNum = rs.getString("assistRecords.ticketNumber");
            result.put("FTicketNum", FTicketNum == null ? "" : FTicketNum);
            String FCustomer = rs.getString("customer.name");
            result.put("FCustomer", FCustomer == null ? "" : FCustomer);
            boolean hasUserProperty = rs.getBoolean("account.hasUserProperty");
            if (hasUserProperty) {
                String FFeeType = rs.getString("assistRecords.feeType");
                result.put("FFeeType", FFeeType == null ? "" : FFeeType);
            }
            result.put("FHandler", (FHandler = rs.getString("handler.name")) == null ? "" : FHandler);
            String FMaterial = rs.getString("material.name");
            result.put("FMaterial", FMaterial == null ? "" : FMaterial);
            String FOrgUnit = rs.getString("orgUnit.name");
            result.put("FOrgUnit", FOrgUnit == null ? "" : FOrgUnit);
            String FSupplier = rs.getString("supplier.name");
            result.put("FSupplier", FSupplier == null ? "" : FSupplier);
            Object FBizDate = rs.getObject("assistRecords.bizDate");
            result.put("FBizDate", FBizDate == null ? "" : FBizDate);
            Object FEndDate = rs.getObject("assistRecords.endDate");
            result.put("FEndDate", FEndDate == null ? "" : FEndDate);
            return result;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        String filterValue;
        FilterInfo filter = new FilterInfo();
        Map paramMap = this.getContextMap();
        boolean isSelectedAll = (Boolean)paramMap.get("isSelectedAll");
        ArrayList selectedVouchers = (ArrayList)paramMap.get("selectedVouchers");
        HashSet<String> selectedIds = new HashSet<String>();
        if (selectedVouchers != null && !isSelectedAll) {
            selectedIds.addAll(selectedVouchers);
        } else {
            try {
                filterValue = paramMap.get("bizCommonQueryFilter").toString();
                filterValue = filterValue.replace("$", "'");
                EntityViewInfo mainQuery = new EntityViewInfo();
                mainQuery.setFilter(new FilterInfo(filterValue));
                MetaDataPK mainQueryPK = new MetaDataPK(this.getExportQueryInfo(ctx));
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
                exec.setObjectView(mainQuery);
                IRowSet rs = exec.executeQuery();
                while (rs.next()) {
                    selectedIds.add(rs.getString("id"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (selectedIds.size() != 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", selectedIds, CompareType.INCLUDE));
        } else {
            try {
                filterValue = paramMap.get("bizCommonQueryFilter").toString();
                filterValue = filterValue.replace("$", "'");
                filter = new FilterInfo(filterValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.gl.app.VoucherExportQuery";
    }

    protected VoucherCollection getVoucherPkList(IObjectPK[] pkList) throws Exception {
        StringBuffer strFilter = new StringBuffer("");
        strFilter.append(pkList[0]);
        VoucherCollection voucherCollection = this.getVoucherCollection(strFilter.toString());
        CashflowRecordCollection cashflowCollection = this.getCashflowCollection(strFilter.toString());
        if (cashflowCollection.size() > 0) {
            this.mergeVoucherAndCashflow(voucherCollection, cashflowCollection);
        }
        return voucherCollection;
    }

    private void mergeVoucherAndCashflow(VoucherCollection voucherCollection, CashflowRecordCollection cashflowCollection) {
        for (CashflowRecordInfo cashflowRecord : cashflowCollection) {
            BOSUuid vchEntryId;
            BOSUuid vchId = cashflowRecord.getVoucher().getId();
            VoucherInfo voucher = (VoucherInfo)voucherCollection.getObject((Object)vchId);
            if (voucher == null) continue;
            cashflowRecord.setVoucher(voucher);
            VoucherEntryCollection entries = voucher.getEntries();
            VoucherEntryInfo entry = (VoucherEntryInfo)entries.getObject((Object)(vchEntryId = cashflowRecord.getEntry().getId()));
            if (entry == null) continue;
            cashflowRecord.setEntry(entry);
            entry.getCashflowRecords().add(cashflowRecord);
        }
    }

    private CashflowRecordCollection getCashflowCollection(String vchIdList) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)vchIdList, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("voucher.id"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("originalAmount"));
        sic.add(new SelectorItemInfo("localAmount"));
        sic.add(new SelectorItemInfo("reportingAmount"));
        sic.add(new SelectorItemInfo("primaryCoefficient"));
        sic.add(new SelectorItemInfo("supplementaryCoefficient"));
        sic.add(new SelectorItemInfo("voucher.number"));
        sic.add(new SelectorItemInfo("entry.seq"));
        sic.add(new SelectorItemInfo("opposingAccountEntry.seq"));
        sic.add(new SelectorItemInfo("primaryItem.number"));
        sic.add(new SelectorItemInfo("supplementaryItem.number"));
        sic.add(new SelectorItemInfo("assGrp.id"));
        sic.add(new SelectorItemInfo("type"));
        view.setSelector(sic);
        view.setFilter(filter);
        return CashflowRecordFactory.getRemoteInstance().getCashflowRecordCollection(view);
    }

    private VoucherCollection getVoucherCollection(String vchIdList) throws Exception {
        EntityViewInfo e = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)vchIdList, CompareType.INCLUDE));
        f.setMaskString(" #0 and #1 ");
        e.setFilter(f);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("bookedDate"));
        sic.add(new SelectorItemInfo("attachments"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("entryCount"));
        sic.add(new SelectorItemInfo("isReverseVoucher"));
        sic.add(new SelectorItemInfo("hasReversed"));
        sic.add(new SelectorItemInfo("cashflowFlag"));
        sic.add(new SelectorItemInfo("isAC"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("sourceSys"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("poster.name"));
        sic.add(new SelectorItemInfo("canceller.name"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("handler.number"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("cashier.number"));
        sic.add(new SelectorItemInfo("poster.number"));
        sic.add(new SelectorItemInfo("canceller.number"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.description"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.quantity"));
        sic.add(new SelectorItemInfo("entries.standardQuantity"));
        sic.add(new SelectorItemInfo("entries.originalAmount"));
        sic.add(new SelectorItemInfo("entries.entryDC"));
        sic.add(new SelectorItemInfo("entries.localExchangeRate"));
        sic.add(new SelectorItemInfo("entries.localAmount"));
        sic.add(new SelectorItemInfo("entries.reportingExchangeRate"));
        sic.add(new SelectorItemInfo("entries.reportingAmount"));
        sic.add(new SelectorItemInfo("entries.account.number"));
        sic.add(new SelectorItemInfo("entries.currency.number"));
        sic.add(new SelectorItemInfo("entries.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.number"));
        sic.add(new SelectorItemInfo("entries.account.AC"));
        sic.add(new SelectorItemInfo("entries.assistRecords.seq"));
        sic.add(new SelectorItemInfo("entries.assistRecords.quantity"));
        sic.add(new SelectorItemInfo("entries.assistRecords.standardQuantity"));
        sic.add(new SelectorItemInfo("entries.assistRecords.originalAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.localAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.reportingAmount"));
        sic.add(new SelectorItemInfo("entries.assistRecords.bizNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.settlementType.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.settlementCode"));
        sic.add(new SelectorItemInfo("entries.assistRecords.invoiceNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.ticketNumber"));
        sic.add(new SelectorItemInfo("entries.assistRecords.customer.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.feeType"));
        sic.add(new SelectorItemInfo("entries.assistRecords.handler.number"));
        sic.add(new SelectorItemInfo("entries.assistRecords.material.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.orgUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.supplier.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.bizDate"));
        sic.add(new SelectorItemInfo("entries.assistRecords.endDate"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assistQty"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assistUnit.number"));
        sic.add(new SelectorItemInfo("entries.account.isQty"));
        sic.add(new SelectorItemInfo("entries.assistRecords.description"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.measureUnit.number"));
        sic.add(new SelectorItemInfo("entries.assistRecords.price"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.id"));
        e.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        sort.add(new SorterItemInfo("entries.seq"));
        e.getSorter().addObjectCollection((IObjectCollection)sort);
        return VoucherFactory.getRemoteInstance().getVoucherCollection(e);
    }

    public static void dealWitehCashFlow(Context ctx) {
    }

    public void solutionOnFinished(Context ctx) throws TaskExternalException {
    }

    private void writeLogForVoucherNumberisNull(Context ctx) throws BOSException, SQLException {
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_Voucher";
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        StringBuffer sql = new StringBuffer();
        sql.append(DataImportUtils.getVoucherSelect());
        sql.append(" from ").append(tempTableName);
        sql.append(" where fnum is null ");
        sql.append(" order by lineNum");
        RecordCollection col = new RecordCollection();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs != null && rs.next()) {
            SimpleRecord rec = new SimpleRecord();
            rec.setRowNum(rs.getInt("lineNum"));
            rec.setFileUuId(rs.getString("fileUuID"));
            rec.setSheetId(RecordUtils.getSheetId((int)rec.getRowNum()));
            int size = voucherField.length;
            for (int i = 0; i < size; ++i) {
                DataToken value = new DataToken();
                value.name = voucherField[i];
                value.data = rs.getString(voucherField[i]);
                rec.put(voucherField[i], value);
            }
            StringBuffer msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)rs.getInt("lineNum")) + 4));
            msg.append(this.getRes(ctx, "number")).append("[").append(rs.getString("FNum") == null ? "" : rs.getString("FNum")).append("]");
            msg.append(this.getRes(ctx, "isnull")).append("!");
            rec.setMsg(msg.toString());
            col.add((IRecord)rec);
        }
        this.writeLog(col, null);
    }

    private String getVchLineErrorMsg(Context ctx, int row) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"no", (Locale)ctx.getLocale()));
        msg.append(row);
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"line", (Locale)ctx.getLocale()));
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"voucher", (Locale)ctx.getLocale()));
        return msg.toString();
    }

    private String getRes(Context ctx, String resName) {
        return ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    private VoucherImpExpParam getVoucherImpExpParam(Map paramMap) {
        VoucherImpExpParam filterParam = new VoucherImpExpParam();
        String errorDispose = (String)paramMap.get("errorDispose");
        if (!StringUtils.isEmpty((String)errorDispose)) {
            filterParam.setStopImpVoucher(Boolean.parseBoolean(errorDispose));
        }
        boolean halfInviableSaveVoucher = (Boolean)paramMap.get("halfInviableSaveVoucher");
        filterParam.setChkHalfInviableSaveVoucher(halfInviableSaveVoucher);
        boolean isSaveByOrgUser = (Boolean)paramMap.get("isSaveByOrgUser");
        filterParam.setSaveByOrgUser(isSaveByOrgUser);
        boolean isTempletVoucherCode = (Boolean)paramMap.get("isTempletVoucherCode");
        filterParam.setChkIsTempletVoucherCode(isTempletVoucherCode);
        filterParam.setAssistById(true);
        return filterParam;
    }

    private List<Set<String>> getVoucherNumberGroup(Context ctx, String tempTableName) throws BOSException, SQLException {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        StringBuffer sql = new StringBuffer();
        sql.append("select min(linenum) minLineNum, FNum from ");
        sql.append(tempTableName);
        sql.append(" where FNum is not null group by FNum order by minLineNum");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int i = 0;
        HashSet<String> set = new HashSet<String>();
        while (rs != null && rs.next()) {
            set.add(rs.getString("FNum"));
            if (++i != 100) continue;
            result.add(set);
            i = 0;
            set = new HashSet();
        }
        if (i < 100 && set.size() > 0) {
            result.add(set);
        }
        return result;
    }

    private RecordCollection getFailedRecordCollection(Context ctx, Set failedSet, IObjectCollection cols, Set set) throws BOSException, SQLException {
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_Voucher";
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        StringBuffer sql = new StringBuffer();
        RecordCollection result = new RecordCollection();
        if (failedSet.size() > 0) {
            sql.append(DataImportUtils.getVoucherSelect());
            sql.append(" from ").append(tempTableName);
            sql.append(" where fnum in (").append(DataImportUtils.convertSet2String(failedSet)).append(")");
            sql.append(" order by lineNum");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs != null && rs.next()) {
                SimpleRecord rec = new SimpleRecord();
                rec.setRowNum(rs.getInt("lineNum"));
                rec.setFileUuId(rs.getString("fileUuID"));
                rec.setSheetId(RecordUtils.getSheetId((int)rec.getRowNum()));
                int size = voucherField.length;
                for (int i = 0; i < size; ++i) {
                    DataToken value = new DataToken();
                    value.name = voucherField[i];
                    value.data = rs.getString(voucherField[i]);
                    rec.put(voucherField[i], value);
                }
                String voucherNum = rs.getString("FNum");
                int lineNum = rs.getInt("lineNum");
                int rowNum = RecordUtils.getRowNum((int)(lineNum + 4));
                for (WSVoucherInfo pcWSVoucherInfo : cols) {
                    if (StringUtils.isEmpty((String)voucherNum) || StringUtils.isEmpty((String)pcWSVoucherInfo.getVoucherNumber()) || !voucherNum.equals(pcWSVoucherInfo.getVoucherNumber())) continue;
                    rec.setMsg((String)pcWSVoucherInfo.get("voucherabstract"));
                }
                result.add((IRecord)rec);
            }
        }
        for (String voucherNumber : set) {
            sql = new StringBuffer();
            sql.append("select pv.fdescription, pd.fperiodnumber, vt.fname_l2, vt.fname_l1, vt.fname_l3, ");
            sql.append(" pc.fnumber profitcenternumber from t_gl_voucher pv ");
            sql.append(" inner join t_bd_period pd on pd.fid = pv.fperiodid ");
            sql.append(" inner join t_bd_vouchertypes vt on vt.fid = pv.fvouchertypeid ");
            sql.append(" inner join t_org_company pc on pc.fid = pv.fcompanyid ");
            sql.append(" where pv.fdescription in (");
            sql.append("select FSerialNO from ").append(tempTableName);
            sql.append(" where FNum = '").append(voucherNumber).append("')");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows == null || !rows.next()) continue;
            String description = rows.getString("fdescription");
            int periodNumbe = rows.getInt("fperiodnumber");
            String vouchertype = rows.getString("fname_" + ctx.getLocale());
            String profitcenternumber = rows.getString("profitcenternumber");
            StringBuffer sql1 = new StringBuffer();
            sql1.append(DataImportUtils.getVoucherSelect());
            sql1.append(" from ").append(tempTableName);
            sql1.append(" where fnum in ('").append(voucherNumber).append("')");
            sql1.append("   and (FSerialNO <> '").append(description).append("' ");
            sql1.append("   or  FPeriod <> ").append(periodNumbe);
            sql1.append("   or  FGroup <> '").append(vouchertype).append("' ");
            sql1.append("   or  FProfitCenterID <> '").append(profitcenternumber).append("') ");
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
            while (rs1 != null && rs1.next()) {
                SimpleRecord rec = new SimpleRecord();
                rec.setRowNum(rs1.getInt("lineNum"));
                rec.setFileUuId(rs1.getString("fileUuID"));
                rec.setSheetId(RecordUtils.getSheetId((int)rec.getRowNum()));
                int size = voucherField.length;
                for (int i = 0; i < size; ++i) {
                    DataToken value = new DataToken();
                    value.name = voucherField[i];
                    value.data = rs1.getString(voucherField[i]);
                    rec.put(voucherField[i], value);
                }
                String voucherNum = rs1.getString("FNum");
                int lineNum = rs1.getInt("lineNum");
                int rowNum = RecordUtils.getRowNum((int)(lineNum + 4));
                for (WSVoucherInfo pcWSVoucherInfo : cols) {
                    if (StringUtils.isEmpty((String)voucherNum) || StringUtils.isEmpty((String)pcWSVoucherInfo.getVoucherNumber()) || !voucherNum.equals(pcWSVoucherInfo.getVoucherNumber())) continue;
                    rec.setMsg((String)pcWSVoucherInfo.get("voucherabstract"));
                }
                result.add((IRecord)rec);
            }
        }
        return result;
    }

    private SuccessInfo getVoucherSuccessfulCount(Context ctx, Set sucSet, String fileUuId, int sheetId, Set set) throws BOSException, SQLException {
        int sucCount = 0;
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        String tempTableKey = taskUiID + "_Voucher";
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        StringBuffer sql = new StringBuffer();
        if (sucSet.size() > 0) {
            sql.append("select count(1) count from ").append(tempTableName).append(" where fnum in (").append(DataImportUtils.convertSet2String(sucSet)).append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null && rs.next()) {
                sucCount = rs.getInt("count");
            }
        }
        int count = 0;
        if (set.size() > 0) {
            sql = new StringBuffer();
            sql.append("select count(1) count from t_gl_voucher pv ");
            sql.append(" inner join t_gl_voucherentry pve on pve.fbillid = pv.fid ");
            sql.append(" where pv.fdescription in (");
            sql.append("  select FSerialNO from ").append(tempTableName).append(" where fnum in (").append(DataImportUtils.convertSet2String(set)).append("))");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows != null && rows.next()) {
                count = rows.getInt("count");
            }
        }
        SuccessInfo result = new SuccessInfo(fileUuId, sheetId, sucCount + count);
        return result;
    }

    public Object transform(Context ctx, RecordCollection coll) throws TaskExternalException {
        Map paramMap = this.getContextMap();
        String taskUiID = (String)paramMap.get("taskUuId");
        Map resultMap = this.getWSVoucherCollection(ctx, coll);
        WSVoucherCollection pcWSVchColl = (WSVoucherCollection)((Object)resultMap.get("coll"));
        List voucherKeyList = (List)resultMap.get("keyList");
        Map keyVoucherMap = (Map)resultMap.get("keyVoucherMap");
        WSVoucherInfo wsv = pcWSVchColl.get(0);
        String fileUuId = (String)wsv.get("fileUuId");
        int sheetId = (Integer)wsv.get("sheetId");
        int cashSheetId = sheetId == 1 ? 2 : 1;
        String tempTableKey = taskUiID + "_CashflowRecord";
        WSVoucherCollection cashWSVchColl = null;
        Map keyCashMap = new HashMap();
        String tempTableName = (String)ctx.get((Object)tempTableKey);
        if (tempTableName != null) {
            try {
                Map cashResultMap = CashFlowRecordDataImport.getCashFlowMap(ctx, paramMap);
                cashWSVchColl = (WSVoucherCollection)((Object)cashResultMap.get("coll"));
                keyCashMap = (Map)cashResultMap.get("keyCashMap");
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (SQLException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        String oprtState = (String)paramMap.get("oprtState");
        HashMap result = new HashMap();
        WSVoucherCollection dealColl = new WSVoucherCollection();
        WSVoucherCollection dealCashColl = new WSVoucherCollection();
        VoucherImpExpParam filterParam = this.getVoucherImpExpParam(paramMap);
        for (int i = 0; i < voucherKeyList.size(); ++i) {
            String voucherKey = (String)voucherKeyList.get(i);
            dealColl.addCollection((WSVoucherCollection)((Object)keyVoucherMap.get(voucherKey)));
            dealColl.addCollection((WSVoucherCollection)((Object)keyCashMap.get(voucherKey)));
            dealCashColl.addCollection((WSVoucherCollection)((Object)keyCashMap.get(voucherKey)));
            if ((i + 1) % 40 != 0 && i + 1 != voucherKeyList.size()) continue;
            this.dealVoucher(ctx, coll, dealColl, fileUuId, sheetId, cashSheetId, dealCashColl, oprtState, result, filterParam);
            dealColl = new WSVoucherCollection();
            dealCashColl = new WSVoucherCollection();
        }
        return null;
    }

    private void dealVoucher(Context ctx, RecordCollection coll, WSVoucherCollection pcWSVchColl, String fileUuId, int sheetId, int cashSheetId, WSVoucherCollection cashWSVchColl, String oprtState, Map result, VoucherImpExpParam filterParam) throws TaskExternalException {
        Map paramMap = this.getContextMap();
        boolean isSubmit = false;
        String isSubmittoStr = (String)paramMap.get("isSubmit");
        if (!StringUtils.isEmpty((String)isSubmittoStr)) {
            isSubmit = Boolean.parseBoolean(isSubmittoStr);
        }
        IObjectCollection collection = null;
        if (!StringUtils.isEmpty((String)oprtState) && "checkVoucher".equals(oprtState)) {
            try {
                collection = VoucherImpFacadeFactory.getLocalInstance(ctx).checkVoucher((IObjectCollection)pcWSVchColl, false, isSubmit, true, false, "excel", filterParam);
                result.put("cols", collection);
                WSVoucherInfo pcWSVouherInfo = (WSVoucherInfo)collection.getObject(0);
                result.put("fileUuId", fileUuId);
                result.put("sheetId", sheetId);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        try {
            result = VoucherImpFacadeFactory.getLocalInstance(ctx).importVoucher((IObjectCollection)pcWSVchColl, false, true, isSubmit, false, "excel", filterParam);
            collection = (IObjectCollection)result.get("cols");
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        RecordCollection errorColl = new RecordCollection();
        ArrayList<SuccessInfo> successList = new ArrayList<SuccessInfo>();
        int cashFlowSuccessCount = 0;
        int voucherSuccessCount = 0;
        for (int i = 0; i < collection.size(); ++i) {
            StringBuffer keys;
            int k;
            WSVoucherInfo wsvoucher = (WSVoucherInfo)collection.getObject(i);
            for (k = 0; k < coll.size(); ++k) {
                IRecord rec = coll.get(k);
                keys = new StringBuffer(this.getValue(rec, "FCompanyID")).append("_");
                keys.append("0").append(this.getValue(rec, "FPeriod")).append("_").append(this.getValue(rec, "FGroup")).append("_").append(this.getValue(rec, "FNum"));
                if (wsvoucher.get("key") == null || !wsvoucher.get("key").equals(keys.toString())) continue;
                if ("0000".equals(wsvoucher.getDescription())) {
                    ++voucherSuccessCount;
                    continue;
                }
                rec.setMsg(wsvoucher.getVoucherAbstract());
                errorColl.add(rec);
            }
            if (cashWSVchColl == null) continue;
            for (k = 0; k < cashWSVchColl.size(); ++k) {
                WSVoucherInfo wsvi = cashWSVchColl.get(k);
                keys = new StringBuffer(wsvi.getCompanyNumber()).append("_");
                keys.append(wsvi.getPeriodYear()).append(wsvi.getPeriodNumber()).append("_").append(wsvi.getVoucherType()).append("_").append(wsvi.getVoucherNumber());
                if (wsvoucher.get("key") == null || !wsvoucher.get("key").equals(keys.toString())) continue;
                if ("0000".equals(wsvoucher.getDescription())) {
                    ++cashFlowSuccessCount;
                    continue;
                }
                SimpleRecord rec = new SimpleRecord();
                rec.setRowNum(wsvi.getInt("lineNum"));
                rec.setFileUuId(wsvi.getString("fileUuID"));
                rec.setSheetId(cashSheetId);
                this.setCashFlowRecordValue(wsvi, (IRecord)rec);
                rec.setMsg(wsvoucher.getVoucherAbstract());
                errorColl.add((IRecord)rec);
            }
        }
        SuccessInfo voucherSuc = new SuccessInfo(fileUuId, sheetId, voucherSuccessCount);
        successList.add(voucherSuc);
        SuccessInfo cashflowSuc = new SuccessInfo(fileUuId, cashSheetId, cashFlowSuccessCount);
        successList.add(cashflowSuc);
        this.writeLog(errorColl, successList);
    }

    private void setCashFlowRecordValue(WSVoucherInfo wsvi, IRecord rec) {
        DataToken value = new DataToken();
        value.name = "FCompanyID";
        value.data = wsvi.getCompanyNumber();
        rec.put("FCompanyID", value);
        value = new DataToken();
        value.name = "FDate";
        value.data = wsvi.getBookedDate();
        rec.put("FDate", value);
        value = new DataToken();
        value.name = "FPeriod";
        value.data = wsvi.getPeriodNumber();
        rec.put("FPeriod", value);
        value = new DataToken();
        value.name = "FGroup";
        value.data = wsvi.getVoucherType();
        rec.put("FGroup", value);
        value = new DataToken();
        value.name = "FNum";
        value.data = wsvi.getVoucherNumber();
        rec.put("FNum", value);
        value = new DataToken();
        value.name = "FCyID";
        value.data = wsvi.getCurrencyNumber();
        rec.put("FCyID", value);
        value = new DataToken();
        value.name = "FEntryID";
        value.data = wsvi.getEntrySeq();
        rec.put("FEntryID", value);
        value = new DataToken();
        value.name = "FOppEntryID";
        value.data = wsvi.getOppAccountSeq();
        rec.put("FOppEntryID", value);
        value = new DataToken();
        value.name = "FNumber";
        value.data = wsvi.getPrimaryItem();
        rec.put("FNumber", value);
        value = new DataToken();
        value.name = "FSubNumber";
        value.data = wsvi.getSupplyItem();
        rec.put("FSubNumber", value);
        value = new DataToken();
        value.name = "FAmountFor";
        value.data = wsvi.getCashflowAmountOriginal();
        rec.put("FAmountFor", value);
        value = new DataToken();
        value.name = "FAmountLoc";
        value.data = wsvi.getCashflowAmountLocal();
        rec.put("FAmountLoc", value);
        value = new DataToken();
        value.name = "FAmountRpt";
        value.data = wsvi.getCashflowAmountRpt();
        rec.put("FAmountRpt", value);
        value = new DataToken();
        value.name = "FPriCoef";
        value.data = wsvi.getPrimaryCoef();
        rec.put("FPriCoef", value);
        value = new DataToken();
        value.name = "FSuPCoef";
        value.data = wsvi.getSupplyCoef();
        rec.put("FSuPCoef", value);
        value = new DataToken();
        value.name = "FType";
        value.data = wsvi.getType();
        rec.put("FType", value);
        for (int m = 1; m < 9; ++m) {
            value = new DataToken();
            value.name = "FClsName" + m;
            value.data = wsvi.get("asstActType" + (m - 1));
            rec.put("FClsName" + m, value);
            value = new DataToken();
            value.name = "FObjID" + m;
            value.data = wsvi.get("asstActNumber" + (m - 1));
            rec.put("FObjID" + m, value);
            value = new DataToken();
            value.name = "FObjName" + m;
            value.data = wsvi.get("asstActName" + (m - 1));
            rec.put("FObjName" + m, value);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Map getWSVoucherCollection(Context ctx, RecordCollection coll) throws TaskExternalException {
        pcWSVchColl = new WSVoucherCollection();
        voucherKeyList = new ArrayList<String>();
        itor = coll.iterator();
        keyVoucherMap = new HashMap<String, WSVoucherCollection>();
        while (itor.hasNext()) {
            block32: {
                data = (SimpleRecord)itor.next();
                wsvoucher = new WSVoucherInfo();
                wsvoucher.put("isWeb", "true");
                wsvoucher.put("lineNum", data.getRowNum());
                wsvoucher.put("sheetId", data.getSheetId());
                companyNumber = this.getValue((IRecord)data, "FCompanyID");
                wsvoucher.setCompanyNumber(companyNumber);
                fDate = this.getValue((IRecord)data, "FDate");
                voucherDate = null;
                if (!StringUtils.isEmpty((String)fDate)) {
                    try {
                        utilDate = VoucherDataImport.dateTime_Formater.parse(fDate);
                        voucherDate = sqlDate = new Date(utilDate.getTime());
                    }
                    catch (Exception e) {
                        if (!(e instanceof ParseException)) ** GOTO lbl34
                        msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                        msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"bookeddate_format_error", (Locale)ctx.getLocale()));
                        data.setMsg(msg.toString());
                        this.excelColl.add((IRecord)data);
                        this.writeLog(this.excelColl, null);
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                } else {
                    voucherDate = null;
                }
lbl34:
                // 3 sources

                wsvoucher.setBookedDate(voucherDate);
                bizDate = null;
                transDate = this.getValue((IRecord)data, "FTransDate");
                if (!StringUtils.isEmpty((String)transDate)) {
                    try {
                        utilDate = VoucherDataImport.dateTime_Formater.parse(transDate);
                        bizDate = sqlDate = new Date(utilDate.getTime());
                    }
                    catch (Exception e) {
                        if (!(e instanceof ParseException)) ** GOTO lbl53
                        msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                        msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"bookeddate_format_error", (Locale)ctx.getLocale()));
                        data.setMsg(msg.toString());
                        this.excelColl.add((IRecord)data);
                        this.writeLog(this.excelColl, null);
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                } else {
                    bizDate = null;
                }
lbl53:
                // 3 sources

                if (bizDate == null) {
                    bizDate = voucherDate;
                }
                wsvoucher.setBizDate(bizDate);
                fperiod = this.getValue((IRecord)data, "FPeriod");
                wsvoucher.setPeriodNumber(StringUtils.isEmpty((String)fperiod) != false ? 0 : Integer.valueOf(fperiod));
                wsvoucher.setVoucherType(this.getValue((IRecord)data, "FGroup"));
                wsvoucher.setVoucherNumber(this.getValue((IRecord)data, "FNum"));
                seq = this.getValue((IRecord)data, "FEntryID");
                wsvoucher.setEntrySeq(StringUtils.isEmpty((String)seq) != false ? 0 : Integer.valueOf(seq));
                wsvoucher.setVoucherAbstract(this.getValue((IRecord)data, "FExp"));
                wsvoucher.setAccountNumber(this.getValue((IRecord)data, "FAcctID"));
                wsvoucher.setCurrencyNumber(this.getValue((IRecord)data, "FCyID"));
                v0 = exchangeRate = StringUtils.isEmpty((String)this.getValue((IRecord)data, "FExchRate")) != false ? null : new BigDecimal(this.getValue((IRecord)data, "FExchRate"));
                if (exchangeRate != null) {
                    exchangeRate = exchangeRate.setScale(10, 4);
                    wsvoucher.setLocalRate(exchangeRate.doubleValue());
                }
                try {
                    wsvoucher.setEntryDC(StringUtils.isEmpty((String)this.getValue((IRecord)data, "FDC")) != false ? -1 : Integer.valueOf(this.getValue((IRecord)data, "FDC")));
                }
                catch (NumberFormatException e) {
                    msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                    msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"dc_format_error", (Locale)ctx.getLocale()));
                    data.setMsg(msg.toString());
                    this.excelColl.add((IRecord)data);
                    this.writeLog(this.excelColl, null);
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                v1 = quantity = StringUtils.isEmpty((String)this.getValue((IRecord)data, "FQty")) != false ? null : new BigDecimal(this.getValue((IRecord)data, "FQty"));
                if (quantity != null) {
                    wsvoucher.setQty(quantity.doubleValue());
                }
                v2 = qty = StringUtils.isEmpty((String)this.getValue((IRecord)data, "FAssistQty")) != false ? null : new BigDecimal(this.getValue((IRecord)data, "FAssistQty"));
                if (qty != null) {
                    wsvoucher.put("assistQty", qty);
                }
                try {
                    originalAmountValue = this.getValue((IRecord)data, "FFcyAmt");
                    v3 = originalAmount = StringUtils.isEmpty((String)originalAmountValue) != false ? null : new BigDecimal(this.getValue((IRecord)data, "FFcyAmt"));
                    if (originalAmount != null) {
                        wsvoucher.setOriginalAmount(originalAmount.doubleValue());
                    }
                    v4 = price = StringUtils.isEmpty((String)this.getValue((IRecord)data, "FPrice")) != false ? null : new BigDecimal(this.getValue((IRecord)data, "FPrice"));
                    if (price != null) {
                        wsvoucher.setPrice(price.doubleValue());
                    }
                    v5 = dAmount = StringUtils.isEmpty((String)this.getValue((IRecord)data, "FDebit")) != false ? null : new BigDecimal(this.getValue((IRecord)data, "FDebit"));
                    if (dAmount != null) {
                        wsvoucher.setDebitAmount(dAmount.doubleValue());
                    }
                    v6 = cAmount = StringUtils.isEmpty((String)this.getValue((IRecord)data, "FCredit")) != false ? null : new BigDecimal(this.getValue((IRecord)data, "FCredit"));
                    if (cAmount != null) {
                        wsvoucher.setCreditAmount(cAmount.doubleValue());
                    }
                }
                catch (Exception e) {
                    msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                    msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"amount_format_error", (Locale)ctx.getLocale()));
                    data.setMsg(msg.toString());
                    this.excelColl.add((IRecord)data);
                    this.writeLog(this.excelColl, null);
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                wsvoucher.setCreator(this.getValue((IRecord)data, "FPrepare"));
                wsvoucher.setPoster(this.getValue((IRecord)data, "FPoster"));
                wsvoucher.setAuditor(this.getValue((IRecord)data, "FAuditor"));
                wsvoucher.setAttaches(StringUtils.isEmpty((String)this.getValue((IRecord)data, "FAttchment")) != false ? 0 : Integer.valueOf(this.getValue((IRecord)data, "FAttchment")));
                postflag = this.getValue((IRecord)data, "FPostflag");
                wsvoucher.put("module", postflag);
                strModle = this.getValue((IRecord)data, "FSourcesys");
                wsvoucher.put("module", strModle);
                wsvoucher.put("deleted", this.getValue((IRecord)data, "FDeleteflag"));
                wsvoucher.put("pingzhengxuhao", this.getValue((IRecord)data, "FSerialNO"));
                wsvoucher.setMeasurement(this.getValue((IRecord)data, "FUnitName"));
                wsvoucher.put("assistUnit", this.getValue((IRecord)data, "FAssistUnit"));
                wsvoucher.setDescription(this.getValue((IRecord)data, "FReference"));
                wsvoucher.put("cashflowFlag", this.getValue((IRecord)data, "FHasCashFlow"));
                wsvoucher.setItemFlag(0);
                wsvoucher.setBizNumber(this.getValue((IRecord)data, "FTransID"));
                wsvoucher.setSettlementType(this.getValue((IRecord)data, "FSettlCode"));
                wsvoucher.setSettlementNumber(this.getValue((IRecord)data, "FSettleNO"));
                des = this.getValue((IRecord)data, "FAsstAbstract");
                wsvoucher.put("asstAbstract", des);
                assistCount = 0;
                for (k = 1; k <= 8; ++k) {
                    strAsstActTypeName = this.getValue((IRecord)data, "FClsName" + k);
                    strAsstActID = this.getValue((IRecord)data, "FObjID" + k);
                    strAsstActName = this.getValue((IRecord)data, "FObjName" + k);
                    if (!(strAsstActTypeName != null && "".equals(strAsstActTypeName) == false || strAsstActID != null && "".equals(strAsstActID) == false || strAsstActName != null && "".equals(strAsstActName) == false)) continue;
                    wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
                    wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
                    wsvoucher.put("asstActName" + assistCount, strAsstActName);
                    ++assistCount;
                }
                wsvoucher.put("assistCount", new Integer(assistCount));
                wsvoucher.setInvoiceNumber(this.getValue((IRecord)data, "FInvNum"));
                wsvoucher.put("ticketNumber", this.getValue((IRecord)data, "FTicketNum"));
                wsvoucher.put("customer", this.getValue((IRecord)data, "FCustomer"));
                wsvoucher.put("feeType", this.getValue((IRecord)data, "FFeeType"));
                wsvoucher.put("handler", this.getValue((IRecord)data, "FHandler"));
                wsvoucher.put("material", this.getValue((IRecord)data, "FMaterial"));
                wsvoucher.put("orgUnit", this.getValue((IRecord)data, "FOrgUnit"));
                wsvoucher.put("supplier", this.getValue((IRecord)data, "FSupplier"));
                asstBizDataStr = this.getValue((IRecord)data, "FBizDate");
                if (!StringUtils.isEmpty((String)asstBizDataStr)) {
                    block31: {
                        asstBizDate = null;
                        try {
                            asstBizDate = VoucherDataImport.dateTime_Formater.parse(asstBizDataStr);
                        }
                        catch (ParseException e) {
                            if (!(e instanceof ParseException)) break block31;
                            msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                            msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"ac_bizdate_format_error", (Locale)ctx.getLocale()));
                            data.setMsg(msg.toString());
                            this.excelColl.add((IRecord)data);
                            this.writeLog(this.excelColl, null);
                            throw new TaskExternalException(e.getMessage(), e.getCause());
                        }
                    }
                    wsvoucher.setAssistBizDate(asstBizDate);
                } else {
                    wsvoucher.setAssistBizDate(null);
                }
                endDateStr = this.getValue((IRecord)data, "FEndDate");
                endDate = null;
                if (StringUtils.isEmpty((String)endDateStr)) {
                    endDate = wsvoucher.getBizDate();
                } else {
                    try {
                        endDate = VoucherDataImport.dateTime_Formater.parse(endDateStr);
                    }
                    catch (ParseException e) {
                        if (!(e instanceof ParseException)) break block32;
                        msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                        msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"ac_enddate_format_error", (Locale)ctx.getLocale()));
                        data.setMsg(msg.toString());
                        this.excelColl.add((IRecord)data);
                        this.writeLog(this.excelColl, null);
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                }
            }
            wsvoucher.setAssistEndDate(endDate);
            wsvoucher.put("profitCenterNumber", this.getValue((IRecord)data, "FProfitCenterID"));
            wsvoucher.put("fileUuId", data.getFileUuId());
            pcWSVchColl.add(wsvoucher);
            keys = new StringBuffer(wsvoucher.getCompanyNumber()).append("_");
            keys.append(wsvoucher.getPeriodYear()).append(wsvoucher.getPeriodNumber()).append("_").append(wsvoucher.getVoucherType()).append("_").append(wsvoucher.getVoucherNumber());
            if (!voucherKeyList.contains(keys.toString())) {
                voucherKeyList.add(keys.toString());
                voucherColl = new WSVoucherCollection();
                voucherColl.add(wsvoucher);
                keyVoucherMap.put(keys.toString(), voucherColl);
                continue;
            }
            voucherColl = (WSVoucherCollection)keyVoucherMap.get(keys.toString());
            voucherColl.add(wsvoucher);
        }
        resultMap = new HashMap<String, Object>();
        resultMap.put("coll", (Object)pcWSVchColl);
        resultMap.put("keyList", voucherKeyList);
        resultMap.put("keyVoucherMap", keyVoucherMap);
        return resultMap;
    }

    private void createTempTable(Context ctx, String tempTableKey) throws Exception {
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table gl_voucher (").append("FCompanyID nvarchar(80),").append("FDate DateTime,").append("FTransDate DateTime,").append("FPeriod int,").append("FGroup nvarchar(80),").append("FNum nvarchar(80),").append("FEntryID int,").append("FExp nvarchar(256),").append("FProfitCenterID nvarchar(80),").append("FAcctID varchar(80),").append("FCyID varchar(80),").append("FExchRate decimal(19,9),").append("FDC int,").append("FFcyAmt decimal(19,4),").append("FQty decimal(19,4),").append("FAssistQty decimal(19,4),").append("FPrice decimal(19,4),").append("FDebit decimal(19,4),").append("FCredit decimal(19,4),").append("FPrepare nvarchar(80),").append("FPoster nvarchar(80),").append("FAuditor nvarchar(80),").append("FAttchment int,").append("FPostflag nvarchar(80),").append("FSourcesys nvarchar(80),").append("FDeleteflag nvarchar(80),").append("FSerialNO nvarchar(80),").append("FUnitName nvarchar(80),").append("FAssistUnit nvarchar(80),").append("FReference nvarchar(80),").append("FHasCashFlow int,").append("FCashFlow nvarchar(80),").append("FTransID nvarchar(80),").append("FSettlCode nvarchar(80),").append("FSettleNO nvarchar(80),").append("FAsstAbstract nvarchar(80),").append("FClsName1 nvarchar(80),").append("FObjID1 nvarchar(80),").append("FObjName1 nvarchar(80),").append("FClsName2 nvarchar(80),").append("FObjID2 nvarchar(80),").append("FObjName2 nvarchar(80),").append("FClsName3 nvarchar(80),").append("FObjID3 nvarchar(80),").append("FObjName3 nvarchar(80),").append("FClsName4 nvarchar(80),").append("FObjID4 nvarchar(80),").append("FObjName4 nvarchar(80),").append("FClsName5 nvarchar(80),").append("FObjID5 nvarchar(80),").append("FObjName5 nvarchar(80),").append("FClsName6 nvarchar(80),").append("FObjID6 nvarchar(80),").append("FObjName6 nvarchar(80),").append("FClsName7 nvarchar(80),").append("FObjID7 nvarchar(80),").append("FObjName7 nvarchar(80),").append("FClsName8 nvarchar(80),").append("FObjID8 nvarchar(80),").append("FObjName8 nvarchar(80),").append("FInvNum nvarchar(80),").append("FTicketNum nvarchar(80),").append("FCustomer nvarchar(80),").append("FFeeType nvarchar(80),").append("FHandler nvarchar(80),").append("FMaterial nvarchar(80),").append("FOrgUnit nvarchar(80),").append("FSupplier nvarchar(80),").append("FBizDate DateTime,").append("FEndDate DateTime,").append("lineNum int,").append("fileUuID nvarchar(80))");
        String tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createSql.toString());
        ctx.put((Object)tempTableKey, (Object)tempTableName);
    }

    /*
     * Unable to fully structure code
     */
    private void insertDataIntoTempTable(Context ctx, SimpleRecord data, String tempTableName) throws ParseException, BOSException {
        insertSql = new StringBuffer();
        insertSql.append("insert into ").append(tempTableName);
        insertSql.append("(FCompanyID,FDate,FTransDate,FPeriod,FGroup,FNum,FEntryID,FExp,FAcctID,FCyID,FExchRate,FDC,FFcyAmt,FQty,FAssistQty,");
        insertSql.append("       FPrice,FDebit,FCredit,FPrepare,FPoster,FAuditor,FAttchment,FPostflag,FSourcesys,FDeleteflag,");
        insertSql.append("       FSerialNO,FUnitName,FAssistUnit,FReference,FHasCashFlow,FCashFlow,FTransID,FSettlCode,FSettleNO,FAsstAbstract,");
        insertSql.append("       FClsName1,FObjID1,FObjName1,FClsName2,FObjID2,FObjName2,FClsName3,FObjID3,FObjName3,");
        insertSql.append("       FClsName4,FObjID4,FObjName4,FClsName5,FObjID5,FObjName5,FClsName6,FObjID6,FObjName6,");
        insertSql.append("       FClsName7,FObjID7,FObjName7,FClsName8,FObjID8,FObjName8,");
        insertSql.append("       FInvNum,FTicketNum,FCustomer,FFeeType,FHandler,");
        insertSql.append("       FMaterial,FOrgUnit,FSupplier,FBizDate,FEndDate,FProfitCenterID,");
        insertSql.append("       lineNum,fileUuID ) ").append("values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ").append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ? , ? , ?,").append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ? , ? , ?)");
        insertValue = new Object[72];
        insertValue[0] = this.getValue((IRecord)data, "FCompanyID");
        fDate = this.getValue((IRecord)data, "FDate");
        if (!StringUtils.isEmpty((String)fDate)) {
            try {
                utilDate = VoucherDataImport.dateTime_Formater.parse(fDate);
                sqlDate = new Date(utilDate.getTime());
                insertValue[1] = sqlDate;
            }
            catch (Exception e) {
                if (!(e instanceof ParseException)) ** GOTO lbl41
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"bookeddate_format_error", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new ParseException(e.getMessage(), 1);
            }
        } else {
            insertValue[1] = null;
        }
lbl41:
        // 3 sources

        fTransDate = this.getValue((IRecord)data, "FTransDate");
        if (!StringUtils.isEmpty((String)fTransDate)) {
            try {
                utilDate = VoucherDataImport.dateTime_Formater.parse(fTransDate);
                sqlDate = new Date(utilDate.getTime());
                insertValue[2] = sqlDate;
            }
            catch (Exception e) {
                if (!(e instanceof ParseException)) ** GOTO lbl58
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"bizdate_format_error", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new ParseException(e.getMessage(), 1);
            }
        } else {
            insertValue[2] = null;
        }
lbl58:
        // 3 sources

        fPeriod = this.getValue((IRecord)data, "FPeriod");
        if (!StringUtils.isEmpty((String)fPeriod)) {
            try {
                insertValue[3] = Integer.parseInt(fPeriod);
            }
            catch (Exception e) {
                if (!(e instanceof NumberFormatException)) ** GOTO lbl73
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"period_format_error", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new NumberFormatException(e.getMessage());
            }
        } else {
            insertValue[3] = null;
        }
lbl73:
        // 3 sources

        insertValue[4] = this.getValue((IRecord)data, "FGroup");
        insertValue[5] = this.getValue((IRecord)data, "FNum");
        fEntryID = this.getValue((IRecord)data, "FEntryID");
        if (!StringUtils.isEmpty((String)fEntryID)) {
            try {
                insertValue[6] = Integer.parseInt(fEntryID);
            }
            catch (Exception e) {
                if (!(e instanceof NumberFormatException)) ** GOTO lbl90
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"entry_eq_format_error", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new NumberFormatException(e.getMessage());
            }
        } else {
            insertValue[6] = null;
        }
lbl90:
        // 3 sources

        insertValue[7] = this.getValue((IRecord)data, "FExp");
        insertValue[8] = this.getValue((IRecord)data, "FAcctID");
        insertValue[9] = this.getValue((IRecord)data, "FCyID");
        fExchRate = this.getValue((IRecord)data, "FExchRate");
        insertValue[10] = StringUtils.isEmpty((String)fExchRate) == false ? new BigDecimal(fExchRate) : null;
        fDC = this.getValue((IRecord)data, "FDC");
        if (!StringUtils.isEmpty((String)fDC)) {
            try {
                insertValue[11] = Integer.parseInt(fDC);
            }
            catch (Exception e) {
                if (!(e instanceof NumberFormatException)) ** GOTO lbl110
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"dc_format_error", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new NumberFormatException(e.getMessage());
            }
        } else {
            insertValue[11] = null;
        }
lbl110:
        // 3 sources

        fFcyAmt = this.getValue((IRecord)data, "FFcyAmt");
        insertValue[12] = StringUtils.isEmpty((String)fFcyAmt) == false ? new BigDecimal(fFcyAmt) : null;
        fQty = this.getValue((IRecord)data, "FQty");
        insertValue[13] = StringUtils.isEmpty((String)fQty) == false ? new BigDecimal(fQty) : null;
        fAssistQty = this.getValue((IRecord)data, "FAssistQty");
        insertValue[14] = StringUtils.isEmpty((String)fAssistQty) == false ? new BigDecimal(fAssistQty) : null;
        fPrice = this.getValue((IRecord)data, "FPrice");
        insertValue[15] = StringUtils.isEmpty((String)fPrice) == false ? new BigDecimal(fPrice) : null;
        fDebit = this.getValue((IRecord)data, "FDebit");
        insertValue[16] = StringUtils.isEmpty((String)fDebit) == false ? new BigDecimal(fDebit) : null;
        fCredit = this.getValue((IRecord)data, "FCredit");
        insertValue[17] = StringUtils.isEmpty((String)fCredit) == false ? new BigDecimal(fCredit) : null;
        insertValue[18] = this.getValue((IRecord)data, "FPrepare");
        insertValue[19] = this.getValue((IRecord)data, "FPoster");
        insertValue[20] = this.getValue((IRecord)data, "FAuditor");
        fAttchment = this.getValue((IRecord)data, "FAttchment");
        if (!StringUtils.isEmpty((String)fAttchment)) {
            try {
                insertValue[21] = Integer.parseInt(fAttchment);
            }
            catch (Exception e) {
                if (!(e instanceof NumberFormatException)) ** GOTO lbl140
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"attac_size_format_error", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new NumberFormatException(e.getMessage());
            }
        } else {
            insertValue[21] = null;
        }
lbl140:
        // 3 sources

        insertValue[22] = this.getValue((IRecord)data, "FPostflag");
        insertValue[23] = this.getValue((IRecord)data, "FSourcesys");
        insertValue[24] = this.getValue((IRecord)data, "FDeleteflag");
        insertValue[25] = this.getValue((IRecord)data, "FSerialNO");
        insertValue[26] = this.getValue((IRecord)data, "FUnitName");
        insertValue[27] = this.getValue((IRecord)data, "FAssistUnit");
        insertValue[28] = this.getValue((IRecord)data, "FReference");
        fHasCashFlow = this.getValue((IRecord)data, "FHasCashFlow");
        insertValue[29] = StringUtils.isEmpty((String)fHasCashFlow) == false ? Integer.valueOf(Integer.parseInt(fHasCashFlow)) : null;
        insertValue[30] = this.getValue((IRecord)data, "FCashFlow");
        insertValue[31] = this.getValue((IRecord)data, "FTransID");
        insertValue[32] = this.getValue((IRecord)data, "FSettlCode");
        insertValue[33] = this.getValue((IRecord)data, "FSettleNO");
        insertValue[34] = this.getValue((IRecord)data, "FAsstAbstract");
        insertValue[35] = this.getValue((IRecord)data, "FClsName1");
        insertValue[36] = this.getValue((IRecord)data, "FObjID1");
        insertValue[37] = this.getValue((IRecord)data, "FObjName1");
        insertValue[38] = this.getValue((IRecord)data, "FClsName2");
        insertValue[39] = this.getValue((IRecord)data, "FObjID2");
        insertValue[40] = this.getValue((IRecord)data, "FObjName2");
        insertValue[41] = this.getValue((IRecord)data, "FClsName3");
        insertValue[42] = this.getValue((IRecord)data, "FObjID3");
        insertValue[43] = this.getValue((IRecord)data, "FObjName3");
        insertValue[44] = this.getValue((IRecord)data, "FClsName4");
        insertValue[45] = this.getValue((IRecord)data, "FObjID4");
        insertValue[46] = this.getValue((IRecord)data, "FObjName4");
        insertValue[47] = this.getValue((IRecord)data, "FClsName5");
        insertValue[48] = this.getValue((IRecord)data, "FObjID5");
        insertValue[49] = this.getValue((IRecord)data, "FObjName5");
        insertValue[50] = this.getValue((IRecord)data, "FClsName6");
        insertValue[51] = this.getValue((IRecord)data, "FObjID6");
        insertValue[52] = this.getValue((IRecord)data, "FObjName6");
        insertValue[53] = this.getValue((IRecord)data, "FClsName7");
        insertValue[54] = this.getValue((IRecord)data, "FObjID7");
        insertValue[55] = this.getValue((IRecord)data, "FObjName7");
        insertValue[56] = this.getValue((IRecord)data, "FClsName8");
        insertValue[57] = this.getValue((IRecord)data, "FObjID8");
        insertValue[58] = this.getValue((IRecord)data, "FObjName8");
        insertValue[59] = this.getValue((IRecord)data, "FInvNum");
        insertValue[60] = this.getValue((IRecord)data, "FTicketNum");
        insertValue[61] = this.getValue((IRecord)data, "FCustomer");
        insertValue[62] = this.getValue((IRecord)data, "FFeeType");
        insertValue[63] = this.getValue((IRecord)data, "FHandler");
        insertValue[64] = this.getValue((IRecord)data, "FMaterial");
        insertValue[65] = this.getValue((IRecord)data, "FOrgUnit");
        insertValue[66] = this.getValue((IRecord)data, "FSupplier");
        fBizDate = this.getValue((IRecord)data, "FBizDate");
        if (!StringUtils.isEmpty((String)fBizDate)) {
            try {
                utilDate = VoucherDataImport.dateTime_Formater.parse(fBizDate);
                sqlDate = new Date(utilDate.getTime());
                insertValue[67] = sqlDate;
            }
            catch (Exception e) {
                if (!(e instanceof ParseException)) ** GOTO lbl203
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"ac_bizdate_format_error", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new ParseException(e.getMessage(), 1);
            }
        } else {
            insertValue[67] = null;
        }
lbl203:
        // 3 sources

        fEndDate = this.getValue((IRecord)data, "FEndDate");
        if (!StringUtils.isEmpty((String)fEndDate)) {
            try {
                utilDate = VoucherDataImport.dateTime_Formater.parse(fEndDate);
                sqlDate = new Date(utilDate.getTime());
                insertValue[68] = sqlDate;
            }
            catch (Exception e) {
                if (!(e instanceof ParseException)) ** GOTO lbl220
                msg = new StringBuffer(this.getVchLineErrorMsg(ctx, RecordUtils.getRowNum((int)data.getRowNum()) + 4));
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLVoucherImpResource", (String)"ac_enddate_format_error", (Locale)ctx.getLocale()));
                data.setMsg(msg.toString());
                this.excelColl.add((IRecord)data);
                throw new ParseException(e.getMessage(), 1);
            }
        } else {
            insertValue[68] = null;
        }
lbl220:
        // 3 sources

        insertValue[69] = this.getValue((IRecord)data, "FProfitCenterID");
        insertValue[70] = data.getRowNum();
        insertValue[71] = data.getFileUuId();
        DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])insertValue);
    }

    protected String getValue(IRecord data, String fieldName) {
        if (data.get(fieldName) == null) {
            return null;
        }
        Object obj = data.get((String)fieldName).data;
        return obj == null ? null : obj.toString().trim();
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return true;
    }
}

