/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.dataProcess.adapter;

import com.kingdee.bos.Context;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.expr.SqlAggregateExpr;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlInListExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.dom.stmt.SqlSelectStmt;
import com.kingdee.bos.sql.parser.SqlParser;
import com.kingdee.eas.fi.gl.app.dataProcess.CompareType;
import com.kingdee.eas.fi.gl.app.dataProcess.DataProcessEngine;
import com.kingdee.eas.fi.gl.app.dataProcess.FieldType;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.Field;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.FieldObjectFactory;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.FunctionField;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.SumFieldObjectFactory;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.WhereExpresion;
import com.kingdee.eas.fi.gl.app.dataProcess.function.CommonFunction;
import com.kingdee.eas.fi.gl.app.dataProcess.util.DataProcessUtil;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataProcessSqlAdapter {
    private static Logger logger = Logger.getLogger((String)DataProcessSqlAdapter.class.getClass().getName());
    private DataProcessEngine dataProcessEngine = null;

    public DataProcessSqlAdapter(List<Map<String, Object>> data) {
        this.dataProcessEngine = new DataProcessEngine(data);
    }

    public DataProcessSqlAdapter(Context ctx, String tempTable) {
        this.dataProcessEngine = new DataProcessEngine(ctx, tempTable);
    }

    public DataProcessSqlAdapter select(String sql) {
        return this.select(sql, null);
    }

    public DataProcessSqlAdapter select(String sql, String whereMaskStr) {
        if (StringUtils.isEmpty((String)sql)) {
            throw new RuntimeException("sql is null.");
        }
        if (!sql.trim().startsWith("select")) {
            throw new RuntimeException("only support select sql.");
        }
        ArrayList<String> selectFields = new ArrayList<String>();
        ArrayList<FunctionField> sumFields = new ArrayList<FunctionField>();
        ArrayList<WhereExpresion> whereExps = new ArrayList<WhereExpresion>();
        ArrayList<Field> groupByFields = new ArrayList<Field>();
        try {
            SqlParser sqlParser = new SqlParser(sql);
            ArrayList parseStmtList = (ArrayList)sqlParser.parseStmtList();
            SqlSelectStmt selectStmt = (SqlSelectStmt)parseStmtList.get(0);
            SqlSelect sqlSelect = (SqlSelect)selectStmt.select;
            List selectList = sqlSelect.selectList;
            this.parserSelect(selectList, selectFields, sumFields);
            this.parserWhere(sqlSelect.condition, whereExps);
            this.parserGroupBy(sqlSelect, groupByFields);
            boolean hasFunction = false;
            if (whereExps.size() > 0) {
                this.dataProcessEngine.where(whereExps, whereMaskStr);
            }
            if (groupByFields.size() > 0 && sumFields.size() > 0) {
                CommonFunction sumFunction = new CommonFunction(groupByFields, sumFields);
                this.dataProcessEngine.sum(sumFunction);
                hasFunction = true;
            }
            if (!hasFunction && selectFields.size() > 0) {
                this.dataProcessEngine.setTmpData(this.dataProcessEngine.select(selectFields));
            }
        }
        catch (ParserException e) {
            logger.error((Object)"sql parser error.", (Throwable)e);
            throw new RuntimeException("sql error...sql:" + sql, e);
        }
        return this;
    }

    private void parserGroupBy(SqlSelect sqlSelect, List<Field> groupByFields) {
        if (sqlSelect != null) {
            List groupBy = sqlSelect.groupBy;
            for (Object obj : groupBy) {
                SqlIdentifierExpr grouByExpr = (SqlIdentifierExpr)obj;
                String fieldName = grouByExpr.value;
                Field field = FieldObjectFactory.getInstance(fieldName, FieldType.String, fieldName);
                groupByFields.add(field);
            }
        }
    }

    private void parserSelect(List selectList, List<String> selectFields, List<FunctionField> sumFields) {
        if (selectList != null) {
            for (Object obj : selectList) {
                SqlSelectItem selectItem = (SqlSelectItem)obj;
                String fieldAlias = selectItem.alias;
                SqlExpr expr = selectItem.expr;
                if (expr instanceof SqlIdentifierExpr) {
                    String fieldName = ((SqlIdentifierExpr)expr).value;
                    selectFields.add(fieldName);
                    continue;
                }
                if (!(expr instanceof SqlAggregateExpr)) continue;
                String methodName = ((SqlAggregateExpr)expr).methodName;
                if ("sum".equals(methodName)) {
                    List paramList = ((SqlAggregateExpr)expr).paramList;
                    String fieldName = ((SqlIdentifierExpr)paramList.get((int)0)).value;
                    sumFields.add(SumFieldObjectFactory.getInstance(fieldName, FieldType.Integer, fieldAlias));
                    continue;
                }
                throw new RuntimeException("only support sum function.");
            }
        }
    }

    private void parserWhere(SqlExpr condition, List<WhereExpresion> whereExps) {
        if (condition != null) {
            if (condition instanceof SqlBinaryOpExpr) {
                String exprWord = condition.getExprWord();
                if (StringUtils.isEmpty((String)exprWord)) {
                    this.transferWhereExp(whereExps, condition);
                } else {
                    this.parserWhere(((SqlBinaryOpExpr)condition).left, whereExps);
                    this.parserWhere(((SqlBinaryOpExpr)condition).right, whereExps);
                }
            } else {
                throw new RuntimeException("not support this whereExpr.");
            }
        }
    }

    private void transferWhereExp(List<WhereExpresion> whereExps, SqlExpr condition) {
        if (condition instanceof SqlInListExpr) {
            String exprWord = ((SqlInListExpr)condition).getExprWord();
            if ("in".equalsIgnoreCase(exprWord)) {
                SqlExpr expr = ((SqlInListExpr)condition).expr;
                String fieldName = ((SqlIdentifierExpr)expr).value;
                List targetList = ((SqlInListExpr)condition).targetList;
                HashSet<String> valueSet = new HashSet<String>();
                for (Object obj : targetList) {
                    if (!(obj instanceof SqlCharExpr)) continue;
                    valueSet.add(((SqlCharExpr)obj).text);
                }
                WhereExpresion whereExp = new WhereExpresion(fieldName, CompareType.INCLUDE, valueSet);
                whereExps.add(whereExp);
            }
        } else if (condition instanceof SqlBinaryOpExpr) {
            SqlIdentifierExpr left = (SqlIdentifierExpr)((SqlBinaryOpExpr)condition).left;
            String fieldName = left.value;
            int operator = ((SqlBinaryOpExpr)condition).operator;
            CompareType compareType = this.getCompareType(operator);
            SqlExpr right = ((SqlBinaryOpExpr)condition).right;
            Object value = null;
            if (right instanceof SqlIntExpr) {
                value = ((SqlIntExpr)right).value;
            } else if (right instanceof SqlCharExpr) {
                value = ((SqlCharExpr)right).text;
            } else if (right instanceof SqlMethodInvokeExpr) {
                String methodeName = ((SqlMethodInvokeExpr)right).methodName;
                if ("to_date".equalsIgnoreCase(methodeName)) {
                    SqlCharExpr charExpr = (SqlCharExpr)((SqlMethodInvokeExpr)right).parameters.get(0);
                    try {
                        value = DataProcessUtil.getDate(charExpr.text);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException("date type value is illegal.", e);
                    }
                }
            } else {
                throw new RuntimeException("not support sql expr.");
            }
            WhereExpresion whereExp = new WhereExpresion(fieldName, compareType, value);
            whereExps.add(whereExp);
        }
    }

    private CompareType getCompareType(int operator) {
        CompareType compareType = CompareType.EQUALS;
        if (10 == operator) {
            compareType = CompareType.EQUALS;
        } else if (14 == operator) {
            compareType = CompareType.LESS;
        } else if (15 == operator) {
            compareType = CompareType.LESS_EQUALS;
        } else if (11 == operator) {
            compareType = CompareType.GREATER;
        } else if (12 == operator) {
            compareType = CompareType.GREATER_EQUALS;
        } else if (16 == operator) {
            compareType = CompareType.NOTEQUALS;
        }
        return compareType;
    }

    public List<Map<String, Object>> getTmpData() {
        return this.dataProcessEngine.getTmpData();
    }
}

