/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.dataProcess.test;

import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.fi.gl.app.dataProcess.CompareType;
import com.kingdee.eas.fi.gl.app.dataProcess.DataProcessEngine;
import com.kingdee.eas.fi.gl.app.dataProcess.FieldType;
import com.kingdee.eas.fi.gl.app.dataProcess.adapter.DataProcessSqlAdapter;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.Field;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.FieldObjectFactory;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.FunctionField;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.SumField;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.SumFieldObjectFactory;
import com.kingdee.eas.fi.gl.app.dataProcess.enties.WhereExpresion;
import com.kingdee.eas.fi.gl.app.dataProcess.function.CommonFunction;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDataProcess {
    DataProcessEngine dataP = null;
    DataProcessSqlAdapter dataProcess = null;
    int count = 2;
    BigDecimal value1 = new BigDecimal("1.11");
    BigDecimal value2 = new BigDecimal("2.11");
    BigDecimal value3 = new BigDecimal("3.11");
    public static Map<String, Object> defaultCol = new HashMap<String, Object>(3);

    @Before
    public void beforeDataProcess() {
        HashMap<String, Number> dataMap1;
        int i;
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (i = 0; i < this.count; ++i) {
            HashMap<String, Number> dataMap = new HashMap<String, Number>();
            dataMap.put("a", 1);
            dataMap.put("b", 2);
            dataMap.put("c", new BigDecimal("1.11"));
            dataMap.put("d", 1);
            data.add(dataMap);
        }
        for (i = 0; i < this.count; ++i) {
            dataMap1 = new HashMap<String, Number>();
            dataMap1.put("a", 1);
            dataMap1.put("b", 2);
            dataMap1.put("c", new BigDecimal("2.11"));
            dataMap1.put("d", 1);
            data.add(dataMap1);
        }
        for (i = 0; i < this.count; ++i) {
            dataMap1 = new HashMap();
            dataMap1.put("a", 1);
            dataMap1.put("b", 3);
            dataMap1.put("c", new BigDecimal("3.11"));
            dataMap1.put("d", 3);
            data.add(dataMap1);
        }
        this.dataP = new DataProcessEngine(data);
        this.dataProcess = new DataProcessSqlAdapter(data);
    }

    @Test
    public void testSumFunction1() throws ParserException, ParseException {
        ArrayList<FunctionField> sumFields = new ArrayList<FunctionField>();
        SumField fieldObj1 = SumFieldObjectFactory.getInstance("c", FieldType.BigDecimal, "c1");
        sumFields.add(fieldObj1);
        ArrayList<Field> groupByFields = new ArrayList<Field>();
        Field groupByField1 = FieldObjectFactory.getInstance("a", FieldType.String, "a");
        groupByFields.add(groupByField1);
        Field groupByField2 = FieldObjectFactory.getInstance("b", FieldType.String, "b");
        groupByFields.add(groupByField2);
        CommonFunction sum = new CommonFunction(groupByFields, sumFields);
        WhereExpresion whereExp = new WhereExpresion("d", CompareType.EQUALS, 1);
        ArrayList<WhereExpresion> whereExps = new ArrayList<WhereExpresion>();
        whereExps.add(whereExp);
        List<Map<String, Object>> tmpData = this.dataP.where(whereExps).sum(sum).getTmpData();
        Assert.assertEquals((Object)((BigDecimal)tmpData.get(0).get("c1")), (Object)this.value1.add(this.value2).multiply(new BigDecimal(this.count)));
        tmpData.forEach(e -> System.out.println(e));
    }

    @Test
    public void testSumFunction2() throws ParserException, ParseException {
        String sql = "select a,b,sum(c) c1 from t where d=1 group by a,b";
        List<Map<String, Object>> tmpData = this.dataProcess.select(sql).getTmpData();
        Assert.assertEquals((Object)((BigDecimal)tmpData.get(0).get("c1")), (Object)this.value1.add(this.value2).multiply(new BigDecimal(this.count)));
        tmpData.forEach(e -> System.out.println(e));
    }

    @Test
    public void testMaxFunction1() {
        ArrayList<Field> groupByFields = new ArrayList<Field>();
        Field groupByField1 = FieldObjectFactory.getInstance("a", FieldType.String, "a");
        groupByFields.add(groupByField1);
        Field groupByField2 = FieldObjectFactory.getInstance("b", FieldType.String, "b");
        groupByFields.add(groupByField2);
        ArrayList<FunctionField> funtionFields = new ArrayList<FunctionField>();
        FunctionField funtionField = new FunctionField("c", FieldType.BigDecimal, "c1");
        funtionFields.add(funtionField);
        WhereExpresion whereExp = new WhereExpresion("d", CompareType.EQUALS, 1);
        ArrayList<WhereExpresion> whereExps = new ArrayList<WhereExpresion>();
        whereExps.add(whereExp);
        CommonFunction commonFunction = new CommonFunction(groupByFields, funtionFields);
        List<Map<String, Object>> tmpData = this.dataP.where(whereExps).max(commonFunction).getTmpData();
        Assert.assertEquals((Object)((BigDecimal)tmpData.get(0).get("c1")), (Object)this.value2);
        tmpData.forEach(e -> System.out.println(e));
    }

    @Test
    public void testMinFunction1() {
        ArrayList<Field> groupByFields = new ArrayList<Field>();
        Field groupByField1 = FieldObjectFactory.getInstance("a", FieldType.String, "a");
        groupByFields.add(groupByField1);
        Field groupByField2 = FieldObjectFactory.getInstance("b", FieldType.String, "b");
        groupByFields.add(groupByField2);
        ArrayList<FunctionField> funtionFields = new ArrayList<FunctionField>();
        FunctionField funtionField = new FunctionField("c", FieldType.BigDecimal, "c1");
        funtionFields.add(funtionField);
        WhereExpresion whereExp = new WhereExpresion("d", CompareType.EQUALS, 1);
        ArrayList<WhereExpresion> whereExps = new ArrayList<WhereExpresion>();
        whereExps.add(whereExp);
        CommonFunction commonFunction = new CommonFunction(groupByFields, funtionFields);
        List<Map<String, Object>> tmpData = this.dataP.where(whereExps).min(commonFunction).getTmpData();
        Assert.assertEquals((Object)((BigDecimal)tmpData.get(0).get("c1")), (Object)this.value1);
        tmpData.forEach(e -> System.out.println(e));
    }

    @After
    public void afterDataProcess() {
        if (this.dataP != null) {
            this.dataP.release();
        }
    }

    static {
        defaultCol.put("leftamount", BigDecimal.ZERO);
        defaultCol.put("sumall", BigDecimal.ZERO);
        defaultCol.put("sumoverdue", BigDecimal.ZERO);
    }
}

