/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.dataProcess.util.logic;

import java.util.HashMap;
import java.util.Map;

public enum OperatorEnum {
    NOT("!", 0),
    LT("<", 1),
    ELT("<=", 1),
    GT(">", 1),
    EGT(">=", 1),
    EQ("==", 2),
    NEQ("!=", 2),
    BAND("&", 3),
    BOR("|", 4),
    AND("&&", 5),
    OR("||", 6),
    E("=", 7);

    private String name;
    private Integer priority;
    private static Map<String, OperatorEnum> enums;

    private OperatorEnum(String name, Integer priority) {
        this.name = name;
        this.priority = priority;
    }

    public static void enumToMap() {
        enums.put("!", NOT);
        enums.put("<", LT);
        enums.put("<=", ELT);
        enums.put(">", GT);
        enums.put(">=", EGT);
        enums.put("==", EQ);
        enums.put("!=", NEQ);
        enums.put("&", BAND);
        enums.put("|", BOR);
        enums.put("&&", AND);
        enums.put("||", OR);
        enums.put("=", E);
    }

    public static OperatorEnum getEnumByName(String name) {
        if (enums.size() < 1) {
            OperatorEnum.enumToMap();
        }
        return enums.get(name);
    }

    public static boolean isOperator(String name) {
        if (enums.size() < 1) {
            OperatorEnum.enumToMap();
        }
        return enums.containsKey(name);
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getName() {
        return this.name;
    }

    static {
        enums = new HashMap<String, OperatorEnum>();
    }
}

