/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.gpt.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLClosePeriodFacadeFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class GlClosePeriodCheckGptService {
    private static Logger logger = Logger.getLogger(GlClosePeriodCheckGptService.class);
    private Map<String, PeriodInfo> cachePeriodInfo = new HashMap<String, PeriodInfo>();

    public static Map execute(Map params) {
        return new GlClosePeriodCheckGptService().closePeriodCheck(params);
    }

    private Map closePeriodCheck(Map params) {
        String paramCheckResult = this.checkParams(params);
        HashMap<String, String> result = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)paramCheckResult)) {
            result.put("msg", paramCheckResult);
            return result;
        }
        Context ctx = (Context)params.get("bosCtx");
        String companyName = (String)params.get("companyName");
        String companyNumber = (String)params.get("companyNumber");
        LinkedHashSet<CompanyInfo> bizUnitCompanyList = new LinkedHashSet<CompanyInfo>();
        LinkedHashSet<CompanyInfo> unionCompanyList = new LinkedHashSet<CompanyInfo>();
        String resultMsg = "";
        try {
            this.getClosePeriodCheckCompanys(ctx, this.dealCompanyStr(companyName), this.dealCompanyStr(companyNumber), bizUnitCompanyList, unionCompanyList);
            if (bizUnitCompanyList.size() == 0) {
                result.put("msg", "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7ec4\u7ec7!");
                return result;
            }
            resultMsg = this.checkBizUnitCompany(ctx, bizUnitCompanyList);
        }
        catch (Exception e) {
            logger.error((Object)"query company info exception.", (Throwable)e);
            result.put("msg", "\u7ed3\u8d26\u68c0\u67e5\u5f02\u5e38.");
            return result;
        }
        result.put("msg", resultMsg);
        return result;
    }

    private String dealCompanyStr(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        return str.replaceAll("\\[|\\]|\"", "");
    }

    private String checkBizUnitCompany(Context ctx, Set<CompanyInfo> bizUnitCompanyList) throws BOSException, SQLException, EASBizException {
        String title = "\u672c\u6b21\u68c0\u67e5%d\u5bb6\u7ec4\u7ec7:\n\n%d\u5bb6\u7ec4\u7ec7\u4e0d\u5b58\u5728\u7ed3\u8d26\u98ce\u9669;\n\n%d\u5bb6\u7ec4\u7ec7\u4e0d\u6ee1\u8db3\u7ed3\u8d26\u6761\u4ef6;\n\n\u5177\u4f53\u4fe1\u606f\u5982\u4e0b:\n\n";
        String successTitleMsg = "%d\u5bb6\u6ee1\u8db3\u7ed3\u8d26\u6761\u4ef6\u7684\u7ec4\u7ec7:\n\n%s";
        String errorTitleMsg = "%d\u5bb6\u4e0d\u6ee1\u8db3\u7ed3\u8d26\u6761\u4ef6:\n\n%s";
        StringBuilder successOrgMsg = new StringBuilder();
        StringBuilder errorOrgMsg = new StringBuilder();
        int successCount = 0;
        int failCount = 0;
        StringBuilder resultMsg = new StringBuilder();
        HashMap closeCheckParam = new HashMap();
        for (CompanyInfo companyInfo : bizUnitCompanyList) {
            PeriodInfo periodInfo = this.getGLCurrentPeriod(ctx, companyInfo.getId());
            this.buildGlCloseCheckParams(ctx, periodInfo, closeCheckParam, companyInfo);
            String comName = companyInfo.getName();
            Map closeCheckResult = GLClosePeriodFacadeFactory.getLocalInstance(ctx).closeCheck(closeCheckParam);
            String status = (String)closeCheckResult.get("status");
            if ("success".equals(status)) {
                successOrgMsg.append(comName).append("\n\n");
                ++successCount;
            } else {
                errorOrgMsg.append(comName).append("--");
                List errors = (List)closeCheckResult.get("errors");
                for (Map error : errors) {
                    String errorMsg = (String)error.get("orgName");
                    errorMsg = errorMsg.endsWith(".") || errorMsg.endsWith("\u3002") ? errorMsg.replaceAll("\\.|\u3002", "") : errorMsg;
                    errorOrgMsg.append(errorMsg).append(";");
                }
                errorOrgMsg.append("\n\n");
                ++failCount;
            }
            closeCheckParam.clear();
        }
        resultMsg.append(String.format(title, successCount + failCount, successCount, failCount));
        if (successCount > 0) {
            resultMsg.append(String.format(successTitleMsg, successCount, successOrgMsg.toString()));
        }
        if (failCount > 0) {
            resultMsg.append(String.format(errorTitleMsg, failCount, errorOrgMsg));
        }
        return resultMsg.toString();
    }

    private void getClosePeriodCheckCompanys(Context ctx, String companyNameStr, String companyNumberStr, Set<CompanyInfo> bizUnitCompanyList, Set<CompanyInfo> unionCompanyList) throws BOSException, SQLException {
        LinkedHashSet<CompanyInfo> bizUnitCompanySetTemp = new LinkedHashSet<CompanyInfo>();
        LinkedHashSet<CompanyInfo> unionCompanySetTemp = new LinkedHashSet<CompanyInfo>();
        if (!StringUtils.isEmpty((String)companyNumberStr)) {
            this.queryCompanyByNumber(ctx, companyNumberStr, bizUnitCompanyList, unionCompanyList, bizUnitCompanySetTemp, unionCompanySetTemp);
        } else {
            this.queryCompanyByName(ctx, companyNameStr, bizUnitCompanyList, unionCompanyList, bizUnitCompanySetTemp, unionCompanySetTemp);
        }
        if (unionCompanyList.size() > 0) {
            for (CompanyInfo companyInfo : unionCompanyList) {
                this.queryBizUnitOrgByUnionOrg(ctx, companyInfo, bizUnitCompanyList);
            }
        }
    }

    private void queryCompanyByName(Context ctx, String companyNameStr, Set<CompanyInfo> bizUnitCompanyList, Set<CompanyInfo> unionCompanyList, Set<CompanyInfo> bizUnitCompanySetTemp, Set<CompanyInfo> unionCompanySetTemp) throws BOSException, SQLException {
        String[] companyNames;
        for (String companyName : companyNames = companyNameStr.split(",")) {
            this.queryCompanyByName(ctx, companyName, bizUnitCompanySetTemp, unionCompanySetTemp);
            if (bizUnitCompanySetTemp.size() == 0 && unionCompanySetTemp.size() == 0) {
                this.vagueQueryCompanyByName(ctx, companyName, bizUnitCompanySetTemp, unionCompanySetTemp);
            }
            bizUnitCompanyList.addAll(bizUnitCompanySetTemp);
            unionCompanyList.addAll(unionCompanySetTemp);
            bizUnitCompanySetTemp.clear();
            unionCompanySetTemp.clear();
        }
    }

    private void queryCompanyByNumber(Context ctx, String companyNumberStr, Set<CompanyInfo> bizUnitCompanyList, Set<CompanyInfo> unionCompanyList, Set<CompanyInfo> bizUnitCompanySetTemp, Set<CompanyInfo> unionCompanySetTemp) throws BOSException, SQLException {
        String[] companyNumbers;
        for (String companyNumber : companyNumbers = companyNumberStr.split(",")) {
            this.queryCompanyByNumber(ctx, companyNumber, bizUnitCompanySetTemp, unionCompanySetTemp);
            if (bizUnitCompanySetTemp.size() == 0 && unionCompanySetTemp.size() == 0) {
                this.vagueQueryCompanyByNumber(ctx, companyNumber, bizUnitCompanySetTemp, unionCompanySetTemp);
            }
            bizUnitCompanyList.addAll(bizUnitCompanySetTemp);
            unionCompanyList.addAll(unionCompanySetTemp);
            bizUnitCompanySetTemp.clear();
            unionCompanySetTemp.clear();
        }
    }

    private void buildGlCloseCheckParams(Context ctx, PeriodInfo periodInfo, Map closeCheckParam, CompanyInfo companyInfo) throws BOSException {
        closeCheckParam.put("id", UUID.randomUUID().toString());
        closeCheckParam.put("orgId", companyInfo.getId());
        closeCheckParam.put("periodId", periodInfo != null ? periodInfo.getId().toString() : null);
        closeCheckParam.put("cuId", companyInfo.getCuId());
        closeCheckParam.put("accountTableId", companyInfo.getAccountTableId());
    }

    private PeriodInfo getGLCurrentPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
        return currentPeriod;
    }

    private PeriodInfo getPeriodInfo(Context ctx, String periodTypeId, String number) throws BOSException {
        String cacheKey = periodTypeId + number;
        PeriodInfo periodInfo = this.cachePeriodInfo.get(cacheKey);
        if (periodInfo != null) {
            return periodInfo;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("description"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodTypeId));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        viewInfo.setFilter(filterInfo);
        PeriodCollection periodCollection = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(viewInfo);
        if (periodCollection != null && periodCollection.size() > 0) {
            PeriodInfo period = periodCollection.get(0);
            this.cachePeriodInfo.put(cacheKey, period);
            return period;
        }
        return null;
    }

    private void queryCompanyByNumber(Context ctx, String companyNumber, Set<CompanyInfo> bizUnitCompanyList, Set<CompanyInfo> unionCompanyList) throws BOSException, SQLException {
        String lg = ctx.getLocale().getLanguage();
        StringBuilder sql = new StringBuilder();
        sql.append(this.queryCompanySelect(lg)).append(" where fnumber = ?");
        this.getCompanyInfo(ctx, bizUnitCompanyList, unionCompanyList, sql, companyNumber);
    }

    private void vagueQueryCompanyByNumber(Context ctx, String companyNumber, Set<CompanyInfo> bizUnitCompanyList, Set<CompanyInfo> unionCompanyList) throws BOSException, SQLException {
        String lg = ctx.getLocale().getLanguage();
        StringBuilder sql = new StringBuilder();
        sql.append(this.queryCompanySelect(lg)).append(" where fnumber like ?");
        this.getCompanyInfo(ctx, bizUnitCompanyList, unionCompanyList, sql, companyNumber + "%");
    }

    private void queryCompanyByName(Context ctx, String companyName, Set<CompanyInfo> bizUnitCompanyList, Set<CompanyInfo> unionCompanyList) throws BOSException, SQLException {
        String lg = ctx.getLocale().getLanguage();
        StringBuilder sql = new StringBuilder();
        sql.append(this.queryCompanySelect(lg)).append(" where fname_").append(lg).append(" = ?");
        this.getCompanyInfo(ctx, bizUnitCompanyList, unionCompanyList, sql, companyName);
    }

    private void vagueQueryCompanyByName(Context ctx, String companyName, Set<CompanyInfo> bizUnitCompanyList, Set<CompanyInfo> unionCompanyList) throws BOSException, SQLException {
        String lg = ctx.getLocale().getLanguage();
        StringBuilder sql = new StringBuilder();
        sql.append(this.queryCompanySelect(lg)).append(" where fname_").append(lg).append(" like ?");
        this.getCompanyInfo(ctx, bizUnitCompanyList, unionCompanyList, sql, companyName + "%");
    }

    private void queryBizUnitOrgByUnionOrg(Context ctx, CompanyInfo unionCompanyInfo, Set<CompanyInfo> bizUnitCompanyList) throws BOSException, SQLException {
        String lg = ctx.getLocale().getLanguage();
        StringBuilder sql = new StringBuilder();
        sql.append(this.queryCompanySelect(lg)).append(" where fisBizUnit = 1 and flongNumber like ?");
        this.getCompanyInfo(ctx, bizUnitCompanyList, null, sql, unionCompanyInfo.getLongNumber() + "!%");
    }

    private String queryCompanySelect(String lg) {
        return "select fid,fisBizUnit,fnumber,flongNumber,fname_" + lg + " fname,fcontrolUnitid cuId,faccountPeriodId accountTableId,faccountPeriodId periodTypeId from t_org_company ";
    }

    private void getCompanyInfo(Context ctx, Set<CompanyInfo> bizUnitCompanyList, Set<CompanyInfo> unionCompanyList, StringBuilder sql, Object ... params) throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        while (rs.next()) {
            String companyId = rs.getString("fid");
            String number = rs.getString("fnumber");
            String longNumber = rs.getString("flongNumber");
            String name = rs.getString("fname");
            String cuId = rs.getString("cuId");
            String accountTableId = rs.getString("accountTableId");
            String periodTypeId = rs.getString("periodTypeId");
            boolean isBizUnit = rs.getBoolean("fisBizUnit");
            CompanyInfo companyInfo = new CompanyInfo(companyId, number, longNumber, name, isBizUnit);
            companyInfo.setCuId(cuId);
            companyInfo.setAccountTableId(accountTableId);
            companyInfo.setPeriodTypeId(periodTypeId);
            if (isBizUnit && bizUnitCompanyList != null) {
                bizUnitCompanyList.add(companyInfo);
                continue;
            }
            if (isBizUnit || unionCompanyList == null) continue;
            unionCompanyList.add(companyInfo);
        }
    }

    private String checkParams(Map params) {
        String companyName = (String)params.get("companyName");
        String companyNumber = (String)params.get("companyNumber");
        String period = (String)params.get("period");
        logger.error((Object)("GlGptClosePeriodCheck params,companyName:" + companyName + ",companyNumber:" + companyNumber + ",period:" + period));
        String paramCheckResult = "";
        if (StringUtils.isEmpty((String)companyName) && StringUtils.isEmpty((String)companyNumber)) {
            paramCheckResult = "\u8bf7\u8f93\u5165\u7ec4\u7ec7.";
        }
        return paramCheckResult;
    }

    private String parsePeriod(String period) {
        StringBuilder s = new StringBuilder();
        if (period.matches("^\\d{5,6}$")) {
            s.append(period);
        } else {
            int count = 0;
            String regex = "\\d{1}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(period);
            while (matcher.find() && count++ < 6) {
                s.append(matcher.group());
            }
        }
        if (s.length() == 5) {
            s.insert(4, "0");
        }
        return s.toString();
    }

    public class CompanyInfo {
        private String id;
        private String number;
        private String longNumber;
        private String name;
        private String cuId;
        private String accountTableId;
        private String periodTypeId;
        boolean isBizUnit;

        public CompanyInfo(String id, String number, String longNumber, String name, boolean isBizUnit) {
            this.id = id;
            this.number = number;
            this.longNumber = longNumber;
            this.name = name;
            this.isBizUnit = isBizUnit;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isBizUnit() {
            return this.isBizUnit;
        }

        public void setBizUnit(boolean isBizUnit) {
            this.isBizUnit = isBizUnit;
        }

        public String getCuId() {
            return this.cuId;
        }

        public void setCuId(String cuId) {
            this.cuId = cuId;
        }

        public String getAccountTableId() {
            return this.accountTableId;
        }

        public void setAccountTableId(String accountTableId) {
            this.accountTableId = accountTableId;
        }

        public String getPeriodTypeId() {
            return this.periodTypeId;
        }

        public void setPeriodTypeId(String periodTypeId) {
            this.periodTypeId = periodTypeId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompanyInfo other = (CompanyInfo)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        private GlClosePeriodCheckGptService getOuterType() {
            return GlClosePeriodCheckGptService.this;
        }
    }
}

