/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherHelpFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.voucher.AbstractOperateVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiCancelVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.ma.budget.BgCtrlException;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractAntiCancelBaseVoucherService
extends AbstractOperateVoucherService
implements IAntiCancelVoucherService {
    protected static final Logger logger = Logger.getLogger(AbstractAntiCancelBaseVoucherService.class);
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;
    protected GlParam sysParam = null;

    public AbstractAntiCancelBaseVoucherService(Context ctx) throws BOSException {
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
    }

    protected abstract IVoucherOprateSharer getOperateSharer(Context var1) throws BOSException;

    @Override
    public void antiCancelVoucher(Context ctx, BaseVoucherInfo voucherInfo, VoucherStatusEnum preStatus) throws EASBizException, BOSException {
        this.initGlParam(ctx, voucherInfo);
        ObjectUuidPK voucherPK = null;
        if (voucherInfo.getId() == null) {
            return;
        }
        voucherPK = new ObjectUuidPK(voucherInfo.getId());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"antiCancelVoucher", (BOSObjectType)voucherInfo.getBOSType(), (IObjectPK)voucherPK, (String)this.getLogDetail(ctx, voucherInfo), (String)this.getLogItemName());
        List beforeListeners = this.getBeforeActionListeners(ctx);
        if (beforeListeners != null) {
            for (Object beforeListener : beforeListeners) {
                ((GLActionListener)beforeListener).actionPerformed(ctx, voucherInfo);
            }
        }
        this.operateSharer.lockVoucher(ctx, voucherInfo.getId().toString());
        BaseVoucherInfo sVoucher = this.getStatusVoucher(ctx, new ObjectUuidPK(voucherInfo.getId()));
        if (sVoucher == null) {
            throw new VoucherException(VoucherException.VOUCHER_NOT_EXIST);
        }
        this.checkStatusAndOperate(sVoucher.getBizStatus(), VoucherOperateStatusEnum.ANTICANCLE);
        this.initVoucherValidator(ctx);
        voucherInfo.setBizStatus(sVoucher.getBizStatus());
        this.validatorVoucher(ctx, voucherInfo);
        this.antiCancel(ctx, voucherInfo, preStatus);
        this.afterAntiCancel(ctx, voucherInfo);
        List afterListeners = this.getAfterActionListeners(ctx);
        if (afterListeners != null) {
            for (Object afterListener : afterListeners) {
                ((GLActionListener)afterListener).actionPerformed(ctx, voucherInfo);
            }
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected void afterAntiCancel(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
    }

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.sysParam = this.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
    }

    protected abstract void initVoucherValidator(Context var1) throws EASBizException, BOSException;

    protected abstract void validatorVoucher(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException;

    private void antiCancel(Context ctx, BaseVoucherInfo voucherInfo, VoucherStatusEnum preStatus) throws EASBizException, BOSException {
        this.handleVoucherNumber(ctx, voucherInfo);
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        voucherInfo.setCanceller(null);
        this.operateSharer.updateVoucherStatus(ctx, voucherInfo, preStatus);
        this.requestBudgetSubstract(ctx, voucherInfo, this.sysParam, 2);
        this.intoVoucherLog(ctx, voucherInfo);
    }

    protected abstract void requestBudgetSubstract(Context var1, BaseVoucherInfo var2, GlParam var3, int var4) throws BgCtrlException, EASBizException, BOSException;

    private void handleVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (this.existCodingRule(ctx, voucherInfo)) {
            this.operateSharer.recycleVoucherId(ctx, voucherInfo, voucherInfo.getNumber());
        }
        this.handleVoucherSubmitNumber(ctx, voucherInfo);
    }

    protected void handleVoucherSubmitNumber(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, voucherInfo, VoucherStatusEnum.SUBMITTED));
        if (voucherInfo instanceof VoucherInfo) {
            VoucherCollection col = new VoucherCollection();
            col.add((VoucherInfo)voucherInfo);
            VoucherHelpFacadeControllerBean.botpRewriteStatic(ctx, col);
        }
    }

    protected abstract boolean existCodingRule(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException;

    protected abstract void intoVoucherLog(Context var1, BaseVoucherInfo var2) throws BOSException;

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "IAntiCancelVoucherService";
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = new String[]{"GLG01", "GLG01_2", "GL_028", "GL_029", "GL_032", "GL_052", "GL_060", "GL_075", "GL_101", "GL_008"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }
}

