/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.IVoucherEntry;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractCancelBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.AbstractOperateVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiCheckVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractAntiCheckBaseVoucherService
extends AbstractOperateVoucherService
implements IAntiCheckVoucherService {
    protected static final Logger logger = Logger.getLogger(AbstractCancelBaseVoucherService.class);
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;
    protected GlParam sysParam = null;

    public AbstractAntiCheckBaseVoucherService(Context ctx) throws BOSException {
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
    }

    protected abstract IVoucherOprateSharer getOperateSharer(Context var1) throws BOSException;

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.sysParam = this.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
    }

    protected abstract void initVoucherValidator(Context var1) throws EASBizException, BOSException;

    protected abstract void validatorVoucher(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException;

    @Override
    public void antiCheckVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.initVoucherValidator(ctx);
        this.operateSharer.lockVoucher(ctx, pk.toString());
        VoucherInfo voucherInfo = (VoucherInfo)this.iVoucher.getValue(pk, VoucherInfo.getDefaultProcessSelector());
        this.initGlParam(ctx, (BaseVoucherInfo)voucherInfo);
        this.validatorVoucher(ctx, (BaseVoucherInfo)voucherInfo);
        this.checkStatusAndOperate(voucherInfo.getBizStatus(), VoucherOperateStatusEnum.ANTICHECK);
        boolean useWorkflow = this.sysParam.getBoolean("GL_032");
        int isCheckAfterAudit = this.sysParam.getInt("GL_047");
        boolean isCheckBeforPost = this.sysParam.getBoolean("GL_046");
        int bizStatus = voucherInfo.getBizStatus().getValue();
        if (!useWorkflow && isCheckBeforPost && bizStatus == 5) {
            throw new VoucherException(VoucherException.VOUCHERCANCECHECKBFCANCEPOST);
        }
        if (!useWorkflow && isCheckAfterAudit == 1 && bizStatus >= 3) {
            throw new VoucherException(VoucherException.VOUCHERCHECKUNBFAUD);
        }
        boolean association = VoucherUtil.isAssociationCashManagement(ctx, voucherInfo.getCompany());
        if (association) {
            IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
            Set<String> ids = this.getEntryIds(voucherInfo);
            ids.add(pk.toString());
            bookNotifyFacade.batchAntiBook(ids);
        }
        this._antiCheckVoucher(ctx, (IObjectValue)voucherInfo);
    }

    private Set<String> getEntryIds(VoucherInfo vch) {
        Iterator it = vch.getEntries().iterator();
        VoucherEntryInfo entry = null;
        HashSet<String> ids = new HashSet<String>();
        while (it.hasNext()) {
            entry = (VoucherEntryInfo)it.next();
            ids.add(entry.getId().toString());
        }
        return ids;
    }

    protected void _antiCheckVoucherByEntry(Context ctx, IObjectPK entryPK) throws BOSException, EASBizException {
        this._checkVoucherValidForCheckingByEntry(ctx, entryPK.toString(), VoucherOperateStatusEnum.ANTICHECK);
        String sql = "update t_gl_voucherentry set fischeck =0 , fcashierid=null,fcheckDate=null where fid=? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{entryPK.toString()});
        IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        bookNotifyFacade.antiBook(entryPK.toString());
        sql = "select fischeck,fbillid from t_gl_voucherentry where fbillid in ( select fbillid from t_gl_voucherentry where fid =? )";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{entryPK.toString()});
        boolean hasCheck = false;
        String bill = null;
        try {
            while (!hasCheck && row != null && row.next()) {
                hasCheck = row.getBoolean("fischeck");
                bill = row.getString("fbillid");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (!hasCheck) {
            sql = "update t_gl_voucher set fischeck =0 , fcashierid=null where fid=? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{bill});
        }
    }

    protected void _checkVoucherValidForCheckingByEntry(Context ctx, String entryid, VoucherOperateStatusEnum status) throws BOSException, EASBizException {
        VoucherEntryInfo entryinfo = this.getEntryInfo(ctx, entryid);
        if (status == VoucherOperateStatusEnum.CHECK) {
            if (entryinfo.isIsCheck()) {
                Object[] params = new String[]{status.getAlias(), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"914_VoucherControllerBean", (Locale)ctx.getLocale())};
                throw new VoucherException(VoucherException.STATUS_AND_OPERATE, params);
            }
            this.checkStatusAndOperate(entryinfo.getBill().getBizStatus(), status);
            return;
        }
        if (status == VoucherOperateStatusEnum.ANTICHECK && !entryinfo.isIsCheck()) {
            Object[] params = new String[]{status.getAlias(), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"915_VoucherControllerBean", (Locale)ctx.getLocale())};
            throw new VoucherException(VoucherException.STATUS_AND_OPERATE, params);
        }
    }

    private VoucherEntryInfo getEntryInfo(Context ctx, String entryId) throws BOSException, EASBizException {
        IVoucherEntry entry = VoucherEntryFactory.getLocalInstance(ctx);
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("*");
        sel.add("bill.*");
        sel.add("bill.company.*");
        VoucherEntryInfo entryinfo = (VoucherEntryInfo)entry.getValue((IObjectPK)new ObjectUuidPK(entryId), sel);
        return entryinfo;
    }

    private boolean isBookByEntry(Context ctx, String vid) throws BOSException, EASBizException {
        String sql = "select fid from t_cas_journal where FBillID=? ";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vid});
        return rowset == null || rowset.size() == 0;
    }

    private void checkParamIsChanged(Context ctx, String id) throws BOSException, EASBizException {
        String sql;
        IRowSet rowset;
        if (id == null || id.trim().equals("")) {
            return;
        }
        if (BOSUuid.read((String)id).getType().equals((Object)new VoucherInfo().getBOSType()) ? ((rowset = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_cas_journal where FBillID=? ").toString(), (Object[])new Object[]{id})) == null || rowset.size() == 0) && (rowset = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_cas_journal where fbillID in (select FID FROM T_GL_VoucherEntry WHERE FBillID=?  )").toString(), (Object[])new Object[]{id})) != null && rowset.size() > 0 : BOSUuid.read((String)id).getType().equals((Object)new VoucherEntryInfo().getBOSType()) && ((rowset = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_cas_journal where FBillID=? ").toString(), (Object[])new Object[]{id})) == null || rowset.size() == 0) && (rowset = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_cas_journal where fbillID in (select FBillID FROM T_GL_VoucherEntry WHERE FID=?  )").toString(), (Object[])new Object[]{id})) != null && rowset.size() > 0) {
            throw new VoucherException(VoucherException.CHECKPARAMCHANGED);
        }
    }

    protected void _antiCheckVoucher(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)model;
        String sql = "select fid from  t_gl_voucher where  fischeck=0 and fid=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
        try {
            if (rs.next()) {
                throw new VoucherException(VoucherException.NOTCHECKED);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        boolean useWorkflow = GlUtils.isRunningWorkflow(ctx, voucherInfo.getId().toString());
        boolean checkMustCheck = this.sysParam.getBoolean("GL_0493");
        if (!useWorkflow && checkMustCheck && !SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType()) && !ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString().equals(voucherInfo.getCashier().getId().toString())) {
            throw new VoucherException(VoucherException.CHECKMUSTCHECK);
        }
        voucherInfo.setCashier(null);
        voucherInfo.setIsCheck(false);
        boolean association = VoucherUtil.isAssociationCashManagement(ctx, voucherInfo.getCompany());
        this.updateVoucherCheckStatus(ctx, voucherInfo.getId().toString(), null, 0, association);
    }

    private void updateVoucherCheckStatus(Context ctx, String id, String userid, int status, boolean association) throws BOSException {
        if (userid != null) {
            String sql = "update t_gl_voucher set fcashierid=?, fischeck=?, FLastUpdateTime=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userid, new Integer(status), GlUtils.getTime(), id});
            if (association) {
                sql = "update t_gl_voucherentry set fcashierid=?, fischeck=?, FCheckDate=? where fbillid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userid, new Integer(status), GlUtils.getTime(), id});
            }
        } else {
            String sql = "update t_gl_voucher set fcashierid=null, fischeck=?, FLastUpdateTime=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(status), GlUtils.getTime(), id});
            if (association) {
                sql = "update t_gl_voucherentry set fcashierid=null, fischeck=?, FCheckDate=null where fbillid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(status), id});
            }
        }
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "IAntiCancelVoucherService";
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = new String[]{"GLG01", "GLG01_2", "GL_028", "GL_029", "GL_032", "GL_052", "GL_060", "GL_075", "GL_101", "GL_008", "GL_048", "GL_047", "GL_046", "GL_0493"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }
}

