/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.VoucherBookNotifyByEntryBuilder;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.IVoucherEntry;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractOperateVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ICheckVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractCheckBaseVoucherService
extends AbstractOperateVoucherService
implements ICheckVoucherService {
    protected static final Logger logger = Logger.getLogger(AbstractCheckBaseVoucherService.class);
    protected IVoucherOprateSharer operateSharer;
    protected IVoucher iVoucher;

    public AbstractCheckBaseVoucherService(Context ctx) throws BOSException {
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = (IVoucher)this.getIBaseVoucher(ctx);
    }

    protected abstract IVoucherOprateSharer getOperateSharer(Context var1) throws BOSException;

    protected abstract void initVoucherValidator(Context var1) throws EASBizException, BOSException;

    protected abstract void validatorVoucher(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException;

    @Override
    public void checkVoucher(Context ctx, String id) throws BOSException, EASBizException {
        this.initVoucherValidator(ctx);
        this.operateSharer.lockVoucher(ctx, id);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("cashier.id"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.account.isCash"));
        sic.add(new SelectorItemInfo("entries.account.isBank"));
        VoucherInfo voucherInfo = (VoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(id), sic);
        if (!this._existsCashOrBankAccount(ctx, (IObjectPK)new ObjectUuidPK(id))) {
            throw new VoucherException(VoucherException.NO_NEED_CHECK);
        }
        boolean association = VoucherUtil.isAssociationCashManagement(ctx, voucherInfo.getCompany());
        if (association) {
            IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
            VoucherEntryCollection entries = voucherInfo.getEntries();
            HashSet<String> entryids = new HashSet<String>();
            Object entry = null;
            for (int i = 0; i < entries.size(); ++i) {
                if (!entries.get(i).getAccount().isIsBank() && !entries.get(i).getAccount().isIsCash()) continue;
                entryids.add(entries.get(i).getId().toString());
            }
            VoucherBookNotifyByEntryBuilder builder = new VoucherBookNotifyByEntryBuilder();
            JournalCollection coll = builder.getJournalColl(ctx, entryids);
            bookNotifyFacade.bookBatch(coll);
        }
        voucherInfo.setCashier(ContextUtil.getCurrentUserInfo((Context)ctx));
        voucherInfo.setIsCheck(true);
        this.updateVoucherCheckStatus(ctx, voucherInfo.getId().toString(), voucherInfo.getCashier().getId().toString(), 1, association);
    }

    @Override
    public void checkVoucherCollection(Context ctx, List pkList) throws BOSException, EASBizException {
        this.initVoucherValidator(ctx);
        ArrayList<ObjectUuidPK> canCheckList = new ArrayList<ObjectUuidPK>();
        this.operateSharer.lockVoucher(ctx, pkList);
        int n = pkList.size();
        for (int i = 0; i < n; ++i) {
            String vchid = pkList.get(i).toString();
            ObjectUuidPK voucherId = new ObjectUuidPK(vchid);
            if (!this._existsCashOrBankAccount(ctx, (IObjectPK)voucherId)) continue;
            String sql = "select 1 from  t_gl_voucher where  fid=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{vchid});
            try {
                if (!rs.next()) continue;
                this._checkVoucherValidForChecking(ctx, vchid, VoucherOperateStatusEnum.CHECK);
                canCheckList.add(voucherId);
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)"error:", (Throwable)e);
            }
        }
        if (canCheckList.size() <= 0) {
            throw new VoucherException(VoucherException.NONEEDCHECK);
        }
        this.checkVoucherBatch(ctx, canCheckList);
    }

    protected void _checkVoucherValidForChecking(Context ctx, String voucherId, VoucherOperateStatusEnum status) throws BOSException, EASBizException {
        block16: {
            String sql = "select fischeck,fbizstatus from  t_gl_voucher where  fid=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{voucherId});
            ObjectUuidPK pk = new ObjectUuidPK(voucherId);
            VoucherInfo voucherInfo = (VoucherInfo)this.iVoucher.getValue((IObjectPK)pk, VoucherInfo.getDefaultProcessSelector());
            String[] paramNumbers = new String[]{"GL_032", "GL_047", "GL_046"};
            HashMap param = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(paramNumbers, voucherInfo.getCompany().getId().toString());
            if (status.equals((Object)VoucherOperateStatusEnum.CHECK)) {
                try {
                    if (!rs.next()) break block16;
                    boolean ischeck = rs.getBoolean("fischeck");
                    if (ischeck) {
                        throw new VoucherException(VoucherException.VOUCHERCHECKED);
                    }
                    boolean useWorkflow = Boolean.valueOf(param.get("GL_032").toString());
                    int isCheckAfterAudit = Integer.valueOf(param.get("GL_047").toString());
                    boolean isCheckBeforPost = Boolean.valueOf(param.get("GL_046").toString());
                    int bizStatus = rs.getInt("fbizstatus");
                    if (!useWorkflow && isCheckBeforPost && bizStatus == 5) {
                        throw new VoucherException(VoucherException.VOUCHERCHECKBFPOST);
                    }
                    if (!useWorkflow && isCheckAfterAudit == 2 && bizStatus < 3) {
                        throw new VoucherException(VoucherException.VOUCHERCHECKAFAUD);
                    }
                    if (!useWorkflow && isCheckAfterAudit == 1 && bizStatus >= 3) {
                        throw new VoucherException(VoucherException.VOUCHERCHECKBFAUD);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"error:", (Throwable)e);
                }
            } else if (status.equals((Object)VoucherOperateStatusEnum.ANTICHECK)) {
                try {
                    if (rs.next()) {
                        boolean ischeck = rs.getBoolean("fischeck");
                        if (!ischeck) {
                            throw new VoucherException(VoucherException.NOTCHECKED);
                        }
                        boolean useWorkflow = Boolean.valueOf(param.get("GL_032").toString());
                        int isCheckAfterAudit = Integer.valueOf(param.get("GL_047").toString());
                        boolean isCheckBeforPost = Boolean.valueOf(param.get("GL_046").toString());
                        int bizStatus = rs.getInt("fbizstatus");
                        if (!useWorkflow && isCheckBeforPost && bizStatus == 5) {
                            throw new VoucherException(VoucherException.VOUCHERCANCECHECKBFCANCEPOST);
                        }
                        if (!useWorkflow && isCheckAfterAudit == 2 && bizStatus < 3) {
                            throw new VoucherException(VoucherException.VOUCHERCANCECHECKBFCANCEAUD);
                        }
                        if (!useWorkflow && isCheckAfterAudit == 1 && bizStatus >= 3) {
                            throw new VoucherException(VoucherException.VOUCHERCANCECHECKAFCANCEAUD);
                        }
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"error:", (Throwable)e);
                }
            }
        }
    }

    private String idList2Str(Collection voucherIDColl) {
        if (voucherIDColl == null || voucherIDColl.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = voucherIDColl.iterator();
        int index = 0;
        while (it.hasNext()) {
            if (index != 0) {
                sb.append("','");
            }
            sb.append(it.next().toString());
            ++index;
        }
        return sb.toString();
    }

    public void checkVoucherBatch(Context ctx, List pkList) throws BOSException, EASBizException {
        int i;
        if (pkList == null || pkList.size() <= 0) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)pkList);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        VoucherCollection coll = this.iVoucher.getVoucherCollection(evi);
        VoucherInfo vch = null;
        int size = coll.size();
        for (int i2 = 0; i2 < size; ++i2) {
            vch = coll.get(i2);
            this.checkStatusAndOperate(vch.getBizStatus(), VoucherOperateStatusEnum.CHECK);
        }
        this.setVoucherCollectioStatus(ctx, pkList);
        UserInfo cashier = ContextUtil.getCurrentUserInfo((Context)ctx);
        String cashierID = cashier != null ? cashier.getId().toString() : null;
        for (i = 0; i < coll.size(); ++i) {
            vch = coll.get(i);
            this.validatorVoucher(ctx, (BaseVoucherInfo)vch);
            boolean association = VoucherUtil.isAssociationCashManagement(ctx, vch.getCompany());
            if (association) {
                IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
                VoucherEntryCollection entries = vch.getEntries();
                HashSet<String> entryids = new HashSet<String>();
                Object entry = null;
                for (int k = 0; k < entries.size(); ++k) {
                    entryids.add(entries.get(k).getId().toString());
                }
                VoucherBookNotifyByEntryBuilder builder = new VoucherBookNotifyByEntryBuilder();
                JournalCollection ecoll = builder.getJournalColl(ctx, entryids);
                bookNotifyFacade.bookBatch(ecoll);
            }
            this.updateVoucherCheckStatus(ctx, vch.getId().toString(), cashierID, 1, association);
        }
        int n = pkList.size();
        for (i = 0; i < n; ++i) {
            ObjectUuidPK voucherId = (ObjectUuidPK)pkList.get(i);
            this.iVoucher.checkVoucher((IObjectPK)voucherId);
        }
    }

    private void updateVoucherCheckStatus(Context ctx, String id, String userid, int status, boolean association) throws BOSException {
        if (userid != null) {
            String sql = "update t_gl_voucher set fcashierid=?, fischeck=?, FLastUpdateTime=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userid, new Integer(status), GlUtils.getTime(), id});
            if (association) {
                sql = "update t_gl_voucherentry set fcashierid=?, fischeck=?, FCheckDate=? where fbillid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userid, new Integer(status), GlUtils.getTime(), id});
            }
        } else {
            String sql = "update t_gl_voucher set fcashierid=null, fischeck=?, FLastUpdateTime=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(status), GlUtils.getTime(), id});
            if (association) {
                sql = "update t_gl_voucherentry set fcashierid=null, fischeck=?, FCheckDate=null where fbillid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(status), id});
            }
        }
    }

    protected void _checkVoucherByEntry(Context ctx, String entryId) throws BOSException, EASBizException {
        VoucherEntryInfo entryinfo = this.getEntryInfo(ctx, entryId);
        this._checkVoucherValidForCheckingByEntry(ctx, entryId, VoucherOperateStatusEnum.CHECK);
        String sql = "update t_gl_voucherentry set fischeck =1 , fcashierid=?, FCheckDate=? where fid=? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), new Timestamp(System.currentTimeMillis()), entryId});
        boolean association = VoucherUtil.isAssociationCashManagement(ctx, entryinfo.getBill().getCompany());
        if (association) {
            IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
            bookNotifyFacade.book(VoucherBookNotifyByEntryBuilder.class.getName(), entryId);
        }
        sql = "update t_gl_voucher set fischeck =1 ,   fcashierid=? where\u3000fid in (select fbillid from t_gl_voucherentry where fid=? )  ";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), entryId});
    }

    private VoucherEntryInfo getEntryInfo(Context ctx, String entryId) throws BOSException, EASBizException {
        IVoucherEntry entry = VoucherEntryFactory.getLocalInstance(ctx);
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("*");
        sel.add("bill.*");
        sel.add("bill.company.*");
        VoucherEntryInfo entryinfo = (VoucherEntryInfo)entry.getValue((IObjectPK)new ObjectUuidPK(entryId), sel);
        return entryinfo;
    }

    protected void _checkVoucherValidForCheckingByEntry(Context ctx, String entryid, VoucherOperateStatusEnum status) throws BOSException, EASBizException {
        VoucherEntryInfo entryinfo = this.getEntryInfo(ctx, entryid);
        if (status == VoucherOperateStatusEnum.CHECK) {
            if (entryinfo.isIsCheck()) {
                Object[] params = new String[]{status.getAlias(), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"914_VoucherControllerBean", (Locale)ctx.getLocale())};
                throw new VoucherException(VoucherException.STATUS_AND_OPERATE, params);
            }
            this.checkStatusAndOperate(entryinfo.getBill().getBizStatus(), status);
            return;
        }
        if (status == VoucherOperateStatusEnum.ANTICHECK && !entryinfo.isIsCheck()) {
            Object[] params = new String[]{status.getAlias(), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"915_VoucherControllerBean", (Locale)ctx.getLocale())};
            throw new VoucherException(VoucherException.STATUS_AND_OPERATE, params);
        }
    }

    private void checkParamIsChanged(Context ctx, String id) throws BOSException, EASBizException {
        String sql;
        IRowSet rowset;
        if (id == null || id.trim().equals("")) {
            return;
        }
        if (BOSUuid.read((String)id).getType().equals((Object)new VoucherInfo().getBOSType()) ? ((rowset = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_cas_journal where FBillID=? ").toString(), (Object[])new Object[]{id})) == null || rowset.size() == 0) && (rowset = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_cas_journal where fbillID in (select FID FROM T_GL_VoucherEntry WHERE FBillID=?  )").toString(), (Object[])new Object[]{id})) != null && rowset.size() > 0 : BOSUuid.read((String)id).getType().equals((Object)new VoucherEntryInfo().getBOSType()) && ((rowset = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_cas_journal where FBillID=? ").toString(), (Object[])new Object[]{id})) == null || rowset.size() == 0) && (rowset = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_cas_journal where fbillID in (select FBillID FROM T_GL_VoucherEntry WHERE FID=?  )").toString(), (Object[])new Object[]{id})) != null && rowset.size() > 0) {
            throw new VoucherException(VoucherException.CHECKPARAMCHANGED);
        }
    }

    protected boolean _existsCashOrBankAccount(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.account.isCash"));
        sic.add(new SelectorItemInfo("entries.account.isBank"));
        VoucherInfo voucherInfo = (VoucherInfo)this.iVoucher.getValue(pk, sic);
        return voucherInfo.existsCashOrBankAccount();
    }

    private void setVoucherCollectioStatus(Context ctx, List pkList) throws BOSException {
        StringBuffer voucherids = new StringBuffer();
        int count = 0;
        int n = pkList.size();
        for (int i = 0; i < n; ++i) {
            String vchid = pkList.get(i).toString();
            if (count > 0) {
                voucherids.append(",");
            }
            voucherids.append("'").append(vchid).append("'");
            ++count;
        }
        String curUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" Update t_GL_Voucher \r\n");
        sql.append(" Set FisCheck = 1 ,FCashierID = ? \r\n");
        sql.append(" Where FisCheck =0 \r\n");
        sql.append(" and fid in(").append(voucherids.toString()).append(") ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curUserID});
    }
}

