/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractOperateVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ISubmitVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.List;
import java.util.Locale;

public abstract class AbstractSubmitBaseVoucherService
extends AbstractOperateVoucherService
implements ISubmitVoucherService {
    protected GlParam sysParam = null;
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;

    public AbstractSubmitBaseVoucherService(Context ctx) throws BOSException {
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
    }

    protected abstract IVoucherOprateSharer getOperateSharer(Context var1) throws BOSException;

    @Override
    public IObjectPK submitVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        List beforeListeners;
        if (voucherInfo == null) {
            return null;
        }
        this.initGlParam(ctx, voucherInfo);
        ObjectUuidPK voucherPK = null;
        if (voucherInfo.getId() != null) {
            voucherPK = new ObjectUuidPK(voucherInfo.getId());
        }
        String oldDetail = this.getLogDetail(ctx, voucherInfo);
        IObjectPK logPK = null;
        if (!"WebService".equals(voucherInfo.getString("entrance")) || this.sysParam.getBoolean("GL_VchImp_LogApp")) {
            logPK = LogUtil.beginLog((Context)ctx, (String)"submitVoucher", (BOSObjectType)voucherInfo.getBOSType(), (IObjectPK)voucherPK, (String)oldDetail, (String)this.getLogItemName());
        }
        if ((beforeListeners = this.getBeforeActionListeners(ctx)) != null) {
            for (Object beforeListener : beforeListeners) {
                ((GLActionListener)beforeListener).actionPerformed(ctx, voucherInfo);
            }
        }
        BaseVoucherInfo sVoucher = null;
        if (voucherInfo.getId() != null) {
            this.operateSharer.lockVoucher(ctx, voucherInfo.getId().toString());
            sVoucher = this.getStatusVoucher(ctx, new ObjectUuidPK(voucherInfo.getId()));
            if (sVoucher != null) {
                String msg;
                if (SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType())) {
                    throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"act_change_modify", (Locale)ctx.getLocale())));
                }
                if (!SourceType.GLVOUCHER.equals((Object)voucherInfo.getSourceType())) {
                    this.versionCheck(voucherInfo, sVoucher);
                }
                this.checkStatusAndOperate(sVoucher.getBizStatus(), VoucherOperateStatusEnum.SUBMIT);
                if (voucherInfo.getBizStatus().getValue() == 1 && !StringUtils.isEmpty((CharSequence)(msg = VoucherFacadeFactory.getLocalInstance((Context)ctx).checkCFRequisition(voucherInfo.getId().toString())))) {
                    throw new VoucherException(VoucherException.CHECKREQUISITION_SUBMIT, new Object[]{msg});
                }
            } else if (voucherInfo.getLastUpdateTime() != null) {
                throw new VoucherException(VoucherException.VOUCHER_NOT_EXIST);
            }
        }
        this.initVoucherValidator(ctx, voucherInfo);
        voucherInfo.put("voucherExists", (Object)(sVoucher != null ? 1 : 0));
        if (sVoucher != null) {
            this.transactExistVoucher(ctx, voucherInfo);
        } else if (voucherInfo.getId() == null) {
            voucherInfo.setId(BOSUuid.create((BOSObjectType)voucherInfo.getBOSType()));
        }
        this.loadVoucherInfoForSubmit(ctx, voucherInfo);
        this.validatorVoucher(ctx, voucherInfo);
        if (sVoucher != null) {
            this.insertVoucherLogBeforSubmit(ctx, sVoucher);
        }
        this.afterValidatorVoucher(ctx, voucherInfo);
        voucherPK = this.submit(ctx, voucherInfo);
        this.dealAfterSubmit(ctx, voucherInfo);
        this.insertVoucherLogAfterSubmit(ctx, (IObjectPK)voucherPK, sVoucher != null);
        this.recycleTempNumber(ctx, sVoucher, voucherInfo);
        List afterListeners = this.getAfterActionListeners(ctx);
        if (afterListeners != null) {
            for (Object afterListener : afterListeners) {
                ((GLActionListener)afterListener).actionPerformed(ctx, voucherInfo);
            }
        }
        String newDetail = this.getLogDetail(ctx, voucherInfo);
        if (!(StringUtils.isEmpty((CharSequence)oldDetail) || oldDetail.equals(newDetail) || oldDetail.contains("?"))) {
            this.afterLog(ctx, logPK, (IObjectPK)voucherPK, oldDetail + "->" + newDetail);
        } else {
            this.afterLog(ctx, logPK, (IObjectPK)voucherPK, newDetail);
        }
        return voucherPK;
    }

    protected abstract boolean exist(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;

    private void versionCheck(BaseVoucherInfo voucherInfo, BaseVoucherInfo vch) throws BOSException, EASBizException, VoucherException {
        if (!vch.getLastUpdateTime().equals(voucherInfo.getLastUpdateTime())) {
            throw new VoucherException(VoucherException.EDIT_CONFLICT);
        }
    }

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.sysParam = this.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
        ctx.put((Object)"GL_VOUCHERNUMBER_LOG", (Object)this.sysParam.getBoolean("GL_VOUCHERNUMBER_LOG"));
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "ISubmitVoucherService";
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        GlParam sysParam = GlParam.getGlParams((Context)ctx, (String[])GlParam.getCommonParamKeyList(), (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, sysParam);
        }
        return sysParam;
    }

    protected void initVoucherValidator(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
    }

    protected void transactExistVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
    }

    protected void dealAfterSubmit(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
    }

    protected abstract IObjectPK submit(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;

    protected void loadVoucherInfoForSubmit(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
    }

    protected void validatorVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
    }

    protected void afterValidatorVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
    }

    private void insertVoucherLogBeforSubmit(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getBizStatus().equals((Object)VoucherStatusEnum.SUBMITTED)) {
            this.operateSharer.insertVoucherLog(new String[]{voucherInfo.getId().toString()}, -2, true, false);
        }
    }

    private void insertVoucherLogAfterSubmit(Context ctx, IObjectPK voucherPK, boolean vchExists) throws BOSException, EASBizException {
        this.operateSharer.insertVoucherLog(new String[]{voucherPK.toString()}, vchExists ? 2 : 1, false, false);
    }

    private void recycleTempNumber(Context ctx, BaseVoucherInfo sVoucher, BaseVoucherInfo bVoucherInfo) throws BOSException, EASBizException {
        boolean isHandCode;
        if (null == sVoucher || null == sVoucher.getNumber() || !(bVoucherInfo instanceof VoucherInfo)) {
            return;
        }
        VoucherInfo voucherInfo = (VoucherInfo)bVoucherInfo;
        if (VoucherStatusEnum.TEMP == sVoucher.getBizStatus() && !(isHandCode = this.sysParam.getBoolean("GL_031"))) {
            VoucherStatusEnum vEnum = voucherInfo.getBizStatus();
            voucherInfo.setBizStatus(sVoucher.getBizStatus());
            if (VoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo, sVoucher.getBizStatus())) {
                this.operateSharer.recycleVoucherId(ctx, (BaseVoucherInfo)voucherInfo, sVoucher.getNumber());
            }
            voucherInfo.setBizStatus(vEnum);
        }
    }
}

