/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherBaseValidator;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.framework.CoreBaseInfo;
import org.apache.log4j.Logger;

public abstract class AbstractVoucherBaseValidator
implements IVoucherBaseValidator {
    protected static final Logger logger = Logger.getLogger(AbstractVoucherBaseValidator.class);
    protected static final String resource = "com.kingdee.eas.fi.gl.GLResource";

    @Override
    public abstract void validate(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;

    protected void checkStatusAndOperate(Context ctx, VoucherInfo voucherInfo, VoucherOperateStatusEnum operateStatus) throws BOSException, EASBizException {
        if (GlUtils.isExisted(ctx, voucherInfo)) {
            int i = operateStatus.getValue();
            int j = voucherInfo.getBizStatus().getValue();
            Object[] info = new String[]{operateStatus.toString(), voucherInfo.getBizStatus().toString()};
            if (!IVoucherOprateSharer.voucherStatus[i][j]) {
                throw new VoucherException(VoucherException.STATUS_AND_OPERATE, info);
            }
        }
    }

    protected void checkVoucherPeriod(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getPeriod() == null) {
            throw new VoucherException(VoucherException.PERIOD_CANNOT_NULL);
        }
        PeriodInfo currPeriod = GlUtils.getCurrentPeriod(ctx, voucherInfo.getCompany().getId().toString());
        if (voucherInfo.getPeriod().isIsAdjustPeriod() && voucherInfo.getPeriod().getPeriodYear() == currPeriod.getPeriodYear() - 1) {
            return;
        }
        if (voucherInfo.getPeriod().getPeriodYear() < currPeriod.getPeriodYear() || voucherInfo.getPeriod().getPeriodYear() == currPeriod.getPeriodYear() && voucherInfo.getPeriod().getPeriodNumber() < currPeriod.getPeriodNumber()) {
            throw new VoucherException(VoucherException.PERIOD_NOT_VAILD);
        }
    }

    protected void checkVoucherType(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getVoucherType() == null) {
            throw new VoucherException(VoucherException.TYPE_CANNOT_NULL);
        }
        String cuId = null;
        if (voucherInfo.getCompany() != null && voucherInfo.getCompany().getCU() != null) {
            cuId = voucherInfo.getCompany().getCU().getId().toString();
        }
        if (!VoucherUtil.isExistedVoucherType(ctx, cuId, voucherInfo.getVoucherType().getId().toString())) {
            throw new VoucherException(VoucherException.VOUCHERTYOENOTSEE);
        }
    }

    protected boolean existsCashOrBankAccount(Context ctx, String voucherId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.account.isCash"));
        sic.add(new SelectorItemInfo("entries.account.isBank"));
        CoreBaseInfo model = VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucherId), sic);
        return ((VoucherInfo)model).existsCashOrBankAccount();
    }
}

